// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.2
// Desc: Captain's wife
// Date: 15. august 1997.
// Auth: Anto Matkovic
// email: anto.matkovic@zg.tel.hr
// web page: http://www.geocities.com/SoHo/Studios/7415/

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare bjeloo = texture {pigment {colour rgb 0.8}
finish { ambient 0.19 diffuse 0.59 phong 0.9 phong_size 78}}

#declare zj = texture {pigment { bozo
  colour_map{  [0 colour rgb <0.3, 0.38, 0.24>]
               [1 colour rgb <0.33, 0.34, 0.28>]} scale 0.1}
finish { ambient 0.19 diffuse 0.59 phong 0.9 phong_size 123}}

#declare jakna = texture {pigment { bozo
  colour_map{  [0 colour rgb <0.2, 0.2, 0.28>]
               [1 colour rgb <0.2, 0.21, 0.23>]} scale 0.01}
finish { ambient 0.27 diffuse 0.55 }
normal {granite 0.2 scale 0.1}}

#declare suknja = texture {pigment { bozo          //skirt
  colour_map{  [0 colour rgb <0.22, 0.22, 0.39>]
               [0.3 colour rgb <0.25, 0.23, 0.41>]
               [0.6 colour rgb <0.29, 0.27, 0.43>]
               [1 colour rgb <0.32, 0.29, 0.45>]} scale 0.08}
finish { ambient 0.27 diffuse 0.59 specular 0.5 roughness 0.12 brilliance 7
reflection 0.09}}

#declare skin = texture {pigment { bozo
  colour_map{  [0 colour rgb <0.9, 0.79, 0.77>]
               [0.2 colour rgb <0.92, 0.82, 0.79>]
               [1 colour rgb <0.93, 0.84, 0.81>]} scale 0.06}
finish { ambient 0.2 diffuse 0.55 phong 0.09 phong_size 34}
normal { bozo 0.03 scale 0.06}}

#declare obrve = texture {pigment { bozo
  colour_map{  [0 colour rgb <0.58, 0.52, 0.5>]
               [0.2 colour rgb <0.72, 0.54, 0.48>]
               [1 colour rgb <0.73, 0.57, 0.42>]} scale 0.06}
finish { ambient 0.2 diffuse 0.55 phong 0.09 phong_size 34}
normal { bozo 0.03 scale 0.06}}

#declare lips = texture {pigment {colour rgb <0.8, 0.48, 0.5>}
finish { ambient 0.19 diffuse 0.59 phong 0.9 phong_size 123}
normal {bumps 0.08 scale 0.001}}

#declare cinovi = texture {pigment {colour rgb <0.98, 0.7, 0.35>}
finish { ambient 0.19 diffuse 0.59 specular 0.5 roughness 0.1
brilliance 7 reflection 0.09}
normal {granite 0.5 scale 0.01}}

#declare nokti = texture {pigment {colour rgb <0.9, 0.4, 0.4>}
finish { ambient 0.19 diffuse 0.59 phong 0.9 phong_size 45}}


union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5267, 12.3032, 11.5948> <-3.4876, 12.2131, 11.5546> <-3.3716, 12.1727, 11.5200> <-3.2744, 12.2152, 11.5195>
		<-3.5267, 12.3032, 11.5948> <-3.5041, 12.2497, 11.4565> <-3.3881, 12.2093, 11.4219> <-3.2909, 12.2518, 11.4213>
		<-3.5267, 12.3032, 11.5948> <-3.5041, 12.2497, 11.4565> <-3.4355, 12.3170, 11.3725> <-3.3383, 12.3595, 11.3720>
		<-3.5267, 12.3032, 11.5948> <-3.5432, 12.3397, 11.4966> <-3.4746, 12.4070, 11.4127> <-3.3774, 12.4495, 11.4121>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5267, 12.3032, 11.5948> <-3.5102, 12.2666, 11.6930> <-3.4134, 12.2716, 11.7760> <-3.3162, 12.3141, 11.7755>
		<-3.5267, 12.3032, 11.5948> <-3.4710, 12.1765, 11.6528> <-3.3743, 12.1816, 11.7359> <-3.2771, 12.2240, 11.7354>
		<-3.5267, 12.3032, 11.5948> <-3.4710, 12.1765, 11.6528> <-3.3550, 12.1361, 11.6182> <-3.2579, 12.1786, 11.6177>
		<-3.5267, 12.3032, 11.5948> <-3.4876, 12.2131, 11.5546> <-3.3716, 12.1727, 11.5200> <-3.2744, 12.2152, 11.5195>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5267, 12.3032, 11.5948> <-3.5658, 12.3932, 11.6350> <-3.5165, 12.5059, 11.6687> <-3.4193, 12.5484, 11.6681>
		<-3.5267, 12.3032, 11.5948> <-3.5493, 12.3566, 11.7331> <-3.4999, 12.4693, 11.7668> <-3.4027, 12.5118, 11.7663>
		<-3.5267, 12.3032, 11.5948> <-3.5493, 12.3566, 11.7331> <-3.4525, 12.3616, 11.8162> <-3.3554, 12.4041, 11.8157>
		<-3.5267, 12.3032, 11.5948> <-3.5102, 12.2666, 11.6930> <-3.4134, 12.2716, 11.7760> <-3.3162, 12.3141, 11.7755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5267, 12.3032, 11.5948> <-3.5432, 12.3397, 11.4966> <-3.4746, 12.4070, 11.4127> <-3.3774, 12.4495, 11.4121>
		<-3.5267, 12.3032, 11.5948> <-3.5824, 12.4298, 11.5368> <-3.5138, 12.4971, 11.4528> <-3.4166, 12.5396, 11.4523>
		<-3.5267, 12.3032, 11.5948> <-3.5824, 12.4298, 11.5368> <-3.5330, 12.5425, 11.5705> <-3.4358, 12.5850, 11.5700>
		<-3.5267, 12.3032, 11.5948> <-3.5658, 12.3932, 11.6350> <-3.5165, 12.5059, 11.6687> <-3.4193, 12.5484, 11.6681>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1670, 12.4604, 11.5928> <-3.1504, 12.4238, 11.6910> <-3.2191, 12.3566, 11.7750> <-3.3162, 12.3141, 11.7755>
		<-3.1670, 12.4604, 11.5928> <-3.1896, 12.5139, 11.7311> <-3.2582, 12.4466, 11.8151> <-3.3554, 12.4041, 11.8157>
		<-3.1670, 12.4604, 11.5928> <-3.1896, 12.5139, 11.7311> <-3.3056, 12.5543, 11.7658> <-3.4027, 12.5118, 11.7663>
		<-3.1670, 12.4604, 11.5928> <-3.2061, 12.5505, 11.6330> <-3.3221, 12.5909, 11.6676> <-3.4193, 12.5484, 11.6681>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1670, 12.4604, 11.5928> <-3.2061, 12.5505, 11.6330> <-3.3221, 12.5909, 11.6676> <-3.4193, 12.5484, 11.6681>
		<-3.1670, 12.4604, 11.5928> <-3.2227, 12.5871, 11.5348> <-3.3386, 12.6275, 11.5694> <-3.4358, 12.5850, 11.5700>
		<-3.1670, 12.4604, 11.5928> <-3.2227, 12.5871, 11.5348> <-3.3194, 12.5820, 11.4517> <-3.4166, 12.5396, 11.4523>
		<-3.1670, 12.4604, 11.5928> <-3.1835, 12.4970, 11.4947> <-3.2803, 12.4920, 11.4116> <-3.3774, 12.4495, 11.4121>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1670, 12.4604, 11.5928> <-3.1835, 12.4970, 11.4947> <-3.2803, 12.4920, 11.4116> <-3.3774, 12.4495, 11.4121>
		<-3.1670, 12.4604, 11.5928> <-3.1444, 12.4070, 11.4545> <-3.2411, 12.4020, 11.3714> <-3.3383, 12.3595, 11.3720>
		<-3.1670, 12.4604, 11.5928> <-3.1444, 12.4070, 11.4545> <-3.1937, 12.2943, 11.4208> <-3.2909, 12.2518, 11.4213>
		<-3.1670, 12.4604, 11.5928> <-3.1278, 12.3704, 11.5527> <-3.1772, 12.2577, 11.5190> <-3.2744, 12.2152, 11.5195>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1670, 12.4604, 11.5928> <-3.1278, 12.3704, 11.5527> <-3.1772, 12.2577, 11.5190> <-3.2744, 12.2152, 11.5195>
		<-3.1670, 12.4604, 11.5928> <-3.1113, 12.3338, 11.6508> <-3.1607, 12.2211, 11.6171> <-3.2579, 12.1786, 11.6177>
		<-3.1670, 12.4604, 11.5928> <-3.1113, 12.3338, 11.6508> <-3.1799, 12.2665, 11.7348> <-3.2771, 12.2240, 11.7354>
		<-3.1670, 12.4604, 11.5928> <-3.1504, 12.4238, 11.6910> <-3.2191, 12.3566, 11.7750> <-3.3162, 12.3141, 11.7755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0515, 12.0737, 11.5977> <-4.0123, 11.9837, 11.5575> <-3.8963, 11.9432, 11.5229> <-3.7991, 11.9857, 11.5224>
		<-4.0515, 12.0737, 11.5977> <-4.0289, 12.0203, 11.4593> <-3.9129, 11.9798, 11.4247> <-3.8157, 12.0223, 11.4242>
		<-4.0515, 12.0737, 11.5977> <-4.0289, 12.0203, 11.4593> <-3.9602, 12.0876, 11.3754> <-3.8631, 12.1301, 11.3748>
		<-4.0515, 12.0737, 11.5977> <-4.0680, 12.1103, 11.4995> <-3.9994, 12.1776, 11.4155> <-3.9022, 12.2201, 11.4150>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0515, 12.0737, 11.5977> <-4.0349, 12.0371, 11.6958> <-3.9382, 12.0421, 11.7789> <-3.8410, 12.0846, 11.7784>
		<-4.0515, 12.0737, 11.5977> <-3.9958, 11.9471, 11.6557> <-3.8990, 11.9521, 11.7388> <-3.8018, 11.9946, 11.7382>
		<-4.0515, 12.0737, 11.5977> <-3.9958, 11.9471, 11.6557> <-3.8798, 11.9066, 11.6211> <-3.7826, 11.9491, 11.6205>
		<-4.0515, 12.0737, 11.5977> <-4.0123, 11.9837, 11.5575> <-3.8963, 11.9432, 11.5229> <-3.7991, 11.9857, 11.5224>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0515, 12.0737, 11.5977> <-4.0906, 12.1637, 11.6378> <-4.0412, 12.2765, 11.6715> <-3.9440, 12.3190, 11.6710>
		<-4.0515, 12.0737, 11.5977> <-4.0741, 12.1271, 11.7360> <-4.0247, 12.2399, 11.7697> <-3.9275, 12.2824, 11.7692>
		<-4.0515, 12.0737, 11.5977> <-4.0741, 12.1271, 11.7360> <-3.9773, 12.1322, 11.8191> <-3.8801, 12.1746, 11.8185>
		<-4.0515, 12.0737, 11.5977> <-4.0349, 12.0371, 11.6958> <-3.9382, 12.0421, 11.7789> <-3.8410, 12.0846, 11.7784>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0515, 12.0737, 11.5977> <-4.0680, 12.1103, 11.4995> <-3.9994, 12.1776, 11.4155> <-3.9022, 12.2201, 11.4150>
		<-4.0515, 12.0737, 11.5977> <-4.1071, 12.2003, 11.5397> <-4.0385, 12.2676, 11.4557> <-3.9413, 12.3101, 11.4551>
		<-4.0515, 12.0737, 11.5977> <-4.1071, 12.2003, 11.5397> <-4.0578, 12.3131, 11.5734> <-3.9606, 12.3556, 11.5728>
		<-4.0515, 12.0737, 11.5977> <-4.0906, 12.1637, 11.6378> <-4.0412, 12.2765, 11.6715> <-3.9440, 12.3190, 11.6710>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6917, 12.2310, 11.5957> <-3.6752, 12.1944, 11.6939> <-3.7438, 12.1271, 11.7778> <-3.8410, 12.0846, 11.7784>
		<-3.6917, 12.2310, 11.5957> <-3.7143, 12.2844, 11.7340> <-3.7830, 12.2171, 11.8180> <-3.8801, 12.1746, 11.8185>
		<-3.6917, 12.2310, 11.5957> <-3.7143, 12.2844, 11.7340> <-3.8303, 12.3249, 11.7686> <-3.9275, 12.2824, 11.7692>
		<-3.6917, 12.2310, 11.5957> <-3.7309, 12.3210, 11.6359> <-3.8469, 12.3615, 11.6705> <-3.9440, 12.3190, 11.6710>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6917, 12.2310, 11.5957> <-3.7309, 12.3210, 11.6359> <-3.8469, 12.3615, 11.6705> <-3.9440, 12.3190, 11.6710>
		<-3.6917, 12.2310, 11.5957> <-3.7474, 12.3576, 11.5377> <-3.8634, 12.3981, 11.5723> <-3.9606, 12.3556, 11.5728>
		<-3.6917, 12.2310, 11.5957> <-3.7474, 12.3576, 11.5377> <-3.8442, 12.3526, 11.4546> <-3.9413, 12.3101, 11.4551>
		<-3.6917, 12.2310, 11.5957> <-3.7083, 12.2676, 11.4975> <-3.8050, 12.2626, 11.4145> <-3.9022, 12.2201, 11.4150>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6917, 12.2310, 11.5957> <-3.7083, 12.2676, 11.4975> <-3.8050, 12.2626, 11.4145> <-3.9022, 12.2201, 11.4150>
		<-3.6917, 12.2310, 11.5957> <-3.6691, 12.1776, 11.4574> <-3.7659, 12.1726, 11.3743> <-3.8631, 12.1301, 11.3748>
		<-3.6917, 12.2310, 11.5957> <-3.6691, 12.1776, 11.4574> <-3.7185, 12.0648, 11.4237> <-3.8157, 12.0223, 11.4242>
		<-3.6917, 12.2310, 11.5957> <-3.6526, 12.1410, 11.5555> <-3.7020, 12.0282, 11.5218> <-3.7991, 11.9857, 11.5224>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6917, 12.2310, 11.5957> <-3.6526, 12.1410, 11.5555> <-3.7020, 12.0282, 11.5218> <-3.7991, 11.9857, 11.5224>
		<-3.6917, 12.2310, 11.5957> <-3.6361, 12.1044, 11.6537> <-3.6854, 11.9916, 11.6200> <-3.7826, 11.9491, 11.6205>
		<-3.6917, 12.2310, 11.5957> <-3.6361, 12.1044, 11.6537> <-3.7047, 12.0371, 11.7377> <-3.8018, 11.9946, 11.7382>
		<-3.6917, 12.2310, 11.5957> <-3.6752, 12.1944, 11.6939> <-3.7438, 12.1271, 11.7778> <-3.8410, 12.0846, 11.7784>
	}
texture {bjeloo}
}


union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3952, 12.0376, 11.6527> <-3.4230, 12.0232, 11.6401> <-3.4574, 12.0056, 11.6085> <-3.4884, 11.9921, 11.6087>
		<-3.4021, 12.0354, 11.6109> <-3.4300, 12.0210, 11.5983> <-3.4579, 12.0064, 11.5889> <-3.4888, 11.9929, 11.5891>
		<-3.4452, 12.0363, 11.5654> <-3.4497, 12.0196, 11.5677> <-3.4739, 12.0018, 11.5630> <-3.4900, 11.9948, 11.5631>
		<-3.4532, 12.0355, 11.5237> <-3.4577, 12.0188, 11.5261> <-3.4739, 12.0017, 11.5434> <-3.4899, 11.9947, 11.5435>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3952, 12.0376, 11.6527> <-3.3654, 12.0469, 11.8322> <-3.3172, 12.0045, 12.0876> <-3.3318, 12.0734, 12.2557>
		<-3.4230, 12.0232, 11.6401> <-3.3933, 12.0325, 11.8196> <-3.3593, 11.9752, 12.0933> <-3.3739, 12.0441, 12.2614>
		<-3.4574, 12.0056, 11.6085> <-3.4549, 12.0041, 11.8052> <-3.4059, 11.9426, 12.0804> <-3.4329, 12.0076, 12.2641>
		<-3.4884, 11.9921, 11.6087> <-3.4859, 11.9905, 11.8054> <-3.4531, 11.9219, 12.0807> <-3.4802, 11.9870, 12.2644>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3952, 12.0376, 11.6527> <-3.3672, 12.0521, 11.6655> <-3.3308, 12.0717, 11.6850> <-3.3024, 12.0886, 11.6931>
		<-3.3654, 12.0469, 11.8322> <-3.3374, 12.0614, 11.8450> <-3.2840, 12.0712, 11.8423> <-3.2556, 12.0880, 11.8504>
		<-3.3172, 12.0045, 12.0876> <-3.2849, 12.0270, 12.0833> <-3.2532, 12.0630, 12.0929> <-3.2250, 12.0889, 12.0829>
		<-3.3318, 12.0734, 12.2557> <-3.2995, 12.0959, 12.2513> <-3.2622, 12.1327, 12.2411> <-3.2340, 12.1587, 12.2311>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3952, 12.0376, 11.6527> <-3.4021, 12.0354, 11.6109> <-3.4452, 12.0363, 11.5654> <-3.4532, 12.0355, 11.5237>
		<-3.3672, 12.0521, 11.6655> <-3.3742, 12.0500, 11.6236> <-3.4356, 12.0725, 11.5603> <-3.4436, 12.0717, 11.5186>
		<-3.3308, 12.0717, 11.6850> <-3.3510, 12.0720, 11.6172> <-3.4506, 12.1403, 11.5715> <-3.4737, 12.1412, 11.5046>
		<-3.3024, 12.0886, 11.6931> <-3.3226, 12.0888, 11.6253> <-3.4225, 12.1603, 11.5871> <-3.4457, 12.1612, 11.5201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3318, 12.0734, 12.2557> <-3.3451, 12.1363, 12.4091> <-3.4263, 12.3046, 12.5667> <-3.4810, 12.4430, 12.6412>
		<-3.3739, 12.0441, 12.2614> <-3.3872, 12.1070, 12.4148> <-3.4736, 12.2799, 12.5774> <-3.5282, 12.4182, 12.6518>
		<-3.4329, 12.0076, 12.2641> <-3.4565, 12.0645, 12.4246> <-3.5326, 12.2466, 12.5841> <-3.5936, 12.3871, 12.6622>
		<-3.4802, 11.9870, 12.2644> <-3.5038, 12.0438, 12.4248> <-3.5824, 12.2248, 12.5844> <-3.6434, 12.3653, 12.6624>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3318, 12.0734, 12.2557> <-3.2995, 12.0959, 12.2513> <-3.2622, 12.1327, 12.2411> <-3.2340, 12.1587, 12.2311>
		<-3.3451, 12.1363, 12.4091> <-3.3128, 12.1588, 12.4047> <-3.2709, 12.1999, 12.3837> <-3.2427, 12.2258, 12.3737>
		<-3.4263, 12.3046, 12.5667> <-3.3874, 12.3250, 12.5580> <-3.3442, 12.3600, 12.5494> <-3.3090, 12.3805, 12.5309>
		<-3.4810, 12.4430, 12.6412> <-3.4421, 12.4633, 12.6324> <-3.3927, 12.4943, 12.6166> <-3.3575, 12.5149, 12.5981>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4810, 12.4430, 12.6412> <-3.5372, 12.5853, 12.7178> <-3.6206, 12.8105, 12.7612> <-3.6851, 12.9672, 12.7367>
		<-3.5282, 12.4182, 12.6518> <-3.5845, 12.5606, 12.7284> <-3.6752, 12.7882, 12.7784> <-3.7397, 12.9449, 12.7539>
		<-3.5936, 12.3871, 12.6622> <-3.6556, 12.5300, 12.7416> <-3.7468, 12.7566, 12.7865> <-3.8165, 12.9158, 12.7664>
		<-3.6434, 12.3653, 12.6624> <-3.7055, 12.5083, 12.7419> <-3.8031, 12.7320, 12.7868> <-3.8728, 12.8912, 12.7667>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4810, 12.4430, 12.6412> <-3.4421, 12.4633, 12.6324> <-3.3927, 12.4943, 12.6166> <-3.3575, 12.5149, 12.5981>
		<-3.5372, 12.5853, 12.7178> <-3.4983, 12.6057, 12.7090> <-3.4433, 12.6341, 12.6865> <-3.4081, 12.6546, 12.6680>
		<-3.6206, 12.8105, 12.7612> <-3.5763, 12.8286, 12.7472> <-3.5228, 12.8600, 12.7178> <-3.4833, 12.8754, 12.6915>
		<-3.6851, 12.9672, 12.7367> <-3.6408, 12.9853, 12.7228> <-3.5864, 13.0090, 12.6905> <-3.5469, 13.0243, 12.6642>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4692, 12.1702, 11.0515> <-3.4597, 12.1808, 11.0513> <-3.4429, 12.1947, 11.0547> <-3.4355, 12.2004, 11.0654>
		<-3.4731, 12.1919, 11.0086> <-3.4636, 12.2025, 11.0084> <-3.4374, 12.2229, 11.0076> <-3.4300, 12.2286, 11.0184>
		<-3.4538, 12.2116, 10.9478> <-3.4391, 12.2312, 10.9471> <-3.4226, 12.2443, 10.9559> <-3.4089, 12.2645, 10.9571>
		<-3.4509, 12.2284, 10.9026> <-3.4362, 12.2480, 10.9019> <-3.4143, 12.2721, 10.9091> <-3.4006, 12.2924, 10.9103>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4692, 12.1702, 11.0515> <-3.4681, 12.1637, 11.0643> <-3.4407, 12.1535, 11.0638> <-3.4356, 12.1426, 11.0718>
		<-3.4597, 12.1808, 11.0513> <-3.4585, 12.1743, 11.0641> <-3.4356, 12.1668, 11.0662> <-3.4306, 12.1560, 11.0742>
		<-3.4429, 12.1947, 11.0547> <-3.4438, 12.1899, 11.0627> <-3.4300, 12.1803, 11.0728> <-3.4262, 12.1753, 11.0798>
		<-3.4355, 12.2004, 11.0654> <-3.4365, 12.1956, 11.0734> <-3.4254, 12.1904, 11.0821> <-3.4216, 12.1854, 11.0891>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4692, 12.1702, 11.0515> <-3.4816, 12.1565, 11.0517> <-3.4918, 12.1351, 11.0651> <-3.5055, 12.1228, 11.0666>
		<-3.4681, 12.1637, 11.0643> <-3.4804, 12.1500, 11.0645> <-3.4871, 12.1253, 11.0827> <-3.5008, 12.1130, 11.0842>
		<-3.4407, 12.1535, 11.0638> <-3.4493, 12.1306, 11.0596> <-3.4663, 12.1049, 11.0623> <-3.4769, 12.0825, 11.0605>
		<-3.4356, 12.1426, 11.0718> <-3.4442, 12.1197, 11.0676> <-3.4559, 12.0884, 11.0691> <-3.4665, 12.0660, 11.0673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4692, 12.1702, 11.0515> <-3.4731, 12.1919, 11.0086> <-3.4538, 12.2116, 10.9478> <-3.4509, 12.2284, 10.9026>
		<-3.4816, 12.1565, 11.0517> <-3.4855, 12.1782, 11.0088> <-3.4712, 12.1885, 10.9486> <-3.4683, 12.2053, 10.9034>
		<-3.4918, 12.1351, 11.0651> <-3.5022, 12.1571, 11.0258> <-3.4833, 12.1595, 10.9601> <-3.4853, 12.1703, 10.9153>
		<-3.5055, 12.1228, 11.0666> <-3.5159, 12.1448, 11.0273> <-3.5048, 12.1402, 10.9601> <-3.5068, 12.1509, 10.9153>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3024, 12.0886, 11.6931> <-3.2688, 12.1085, 11.7027> <-3.2188, 12.1313, 11.7107> <-3.1901, 12.1594, 11.7113>
		<-3.2556, 12.0880, 11.8504> <-3.2220, 12.1079, 11.8600> <-3.1894, 12.1499, 11.8527> <-3.1607, 12.1780, 11.8533>
		<-3.2250, 12.0889, 12.0829> <-3.1953, 12.1161, 12.0724> <-3.1501, 12.1503, 12.0788> <-3.1317, 12.1816, 12.0585>
		<-3.2340, 12.1587, 12.2311> <-3.2043, 12.1859, 12.2206> <-3.1576, 12.2188, 12.2077> <-3.1392, 12.2501, 12.1875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3024, 12.0886, 11.6931> <-3.3226, 12.0888, 11.6253> <-3.4225, 12.1603, 11.5871> <-3.4457, 12.1612, 11.5201>
		<-3.2688, 12.1085, 11.7027> <-3.2890, 12.1087, 11.6349> <-3.3726, 12.1957, 11.6147> <-3.3958, 12.1966, 11.5477>
		<-3.2188, 12.1313, 11.7107> <-3.2250, 12.1274, 11.6811> <-3.2970, 12.1389, 11.6529> <-3.3109, 12.1432, 11.6261>
		<-3.1901, 12.1594, 11.7113> <-3.1962, 12.1555, 11.6817> <-3.2397, 12.1731, 11.6609> <-3.2537, 12.1774, 11.6341>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2340, 12.1587, 12.2311> <-3.2043, 12.1859, 12.2206> <-3.1576, 12.2188, 12.2077> <-3.1392, 12.2501, 12.1875>
		<-3.2427, 12.2258, 12.3737> <-3.2130, 12.2531, 12.3632> <-3.1650, 12.2859, 12.3340> <-3.1465, 12.3172, 12.3137>
		<-3.3090, 12.3805, 12.5309> <-3.2704, 12.4030, 12.5106> <-3.2169, 12.4406, 12.4901> <-3.1912, 12.4628, 12.4546>
		<-3.3575, 12.5149, 12.5981> <-3.3189, 12.5374, 12.5778> <-3.2625, 12.5632, 12.5485> <-3.2369, 12.5853, 12.5130>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3575, 12.5149, 12.5981> <-3.3189, 12.5374, 12.5778> <-3.2625, 12.5632, 12.5485> <-3.2369, 12.5853, 12.5130>
		<-3.4081, 12.6546, 12.6680> <-3.3695, 12.6771, 12.6477> <-3.3125, 12.6973, 12.6124> <-3.2868, 12.7194, 12.5769>
		<-3.4833, 12.8754, 12.6915> <-3.4493, 12.8887, 12.6688> <-3.4044, 12.9139, 12.6366> <-3.3782, 12.9217, 12.6034>
		<-3.5469, 13.0243, 12.6642> <-3.5128, 13.0376, 12.6414> <-3.4678, 13.0543, 12.6075> <-3.4415, 13.0622, 12.5743>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5469, 13.0243, 12.6642> <-3.5128, 13.0376, 12.6414> <-3.4678, 13.0543, 12.6075> <-3.4415, 13.0622, 12.5743>
		<-3.6013, 13.1518, 12.6408> <-3.5672, 13.1651, 12.6181> <-3.5236, 13.1781, 12.5819> <-3.4974, 13.1859, 12.5487>
		<-3.6872, 13.3036, 12.5388> <-3.6494, 13.3147, 12.5138> <-3.6004, 13.3363, 12.4753> <-3.5693, 13.3355, 12.4405>
		<-3.7311, 13.3904, 12.4375> <-3.6933, 13.4015, 12.4124> <-3.6443, 13.4206, 12.3750> <-3.6132, 13.4198, 12.3402>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5469, 13.0243, 12.6642> <-3.6013, 13.1518, 12.6408> <-3.6872, 13.3036, 12.5388> <-3.7311, 13.3904, 12.4375>
		<-3.5864, 13.0090, 12.6905> <-3.6407, 13.1364, 12.6671> <-3.7220, 13.2934, 12.5620> <-3.7660, 13.3802, 12.4606>
		<-3.6408, 12.9853, 12.7228> <-3.6950, 13.1172, 12.7022> <-3.7751, 13.2726, 12.5906> <-3.8154, 13.3633, 12.4861>
		<-3.6851, 12.9672, 12.7367> <-3.7393, 13.0990, 12.7161> <-3.8135, 13.2585, 12.6041> <-3.8538, 13.3493, 12.4997>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8293, 13.5824, 12.0129> <-3.7934, 13.5857, 11.9979> <-3.7443, 13.5939, 11.9750> <-3.7130, 13.5831, 11.9542>
		<-3.8684, 13.6184, 11.8263> <-3.8324, 13.6217, 11.8113> <-3.7906, 13.6220, 11.7976> <-3.7593, 13.6112, 11.7767>
		<-3.9197, 13.5617, 11.5665> <-3.8949, 13.5559, 11.5599> <-3.8564, 13.5524, 11.5442> <-3.8327, 13.5454, 11.5353>
		<-3.9528, 13.5950, 11.3784> <-3.9280, 13.5892, 11.3717> <-3.8940, 13.5825, 11.3651> <-3.8702, 13.5756, 11.3561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8293, 13.5824, 12.0129> <-3.8006, 13.5559, 12.1503> <-3.7758, 13.4787, 12.3344> <-3.7311, 13.3904, 12.4375>
		<-3.7934, 13.5857, 11.9979> <-3.7646, 13.5592, 12.1353> <-3.7380, 13.4898, 12.3094> <-3.6933, 13.4015, 12.4124>
		<-3.7443, 13.5939, 11.9750> <-3.7120, 13.5743, 12.0986> <-3.6854, 13.4994, 12.2812> <-3.6443, 13.4206, 12.3750>
		<-3.7130, 13.5831, 11.9542> <-3.6807, 13.5636, 12.0778> <-3.6543, 13.4986, 12.2463> <-3.6132, 13.4198, 12.3402>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8293, 13.5824, 12.0129> <-3.8684, 13.6184, 11.8263> <-3.9197, 13.5617, 11.5665> <-3.9528, 13.5950, 11.3784>
		<-3.8646, 13.5792, 12.0276> <-3.9037, 13.6152, 11.8411> <-3.9576, 13.5588, 11.5709> <-3.9907, 13.5920, 11.3827>
		<-3.9130, 13.5712, 12.0438> <-3.9524, 13.6125, 11.8501> <-4.0080, 13.5553, 11.5859> <-4.0414, 13.5909, 11.3900>
		<-3.9490, 13.5614, 12.0527> <-3.9884, 13.6027, 11.8590> <-4.0458, 13.5496, 11.5887> <-4.0791, 13.5852, 11.3928>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8293, 13.5824, 12.0129> <-3.8646, 13.5792, 12.0276> <-3.9130, 13.5712, 12.0438> <-3.9490, 13.5614, 12.0527>
		<-3.8006, 13.5559, 12.1503> <-3.8359, 13.5526, 12.1650> <-3.8835, 13.5403, 12.1888> <-3.9195, 13.5305, 12.1977>
		<-3.7758, 13.4787, 12.3344> <-3.8107, 13.4685, 12.3576> <-3.8577, 13.4585, 12.3766> <-3.8961, 13.4444, 12.3901>
		<-3.7311, 13.3904, 12.4375> <-3.7660, 13.3802, 12.4606> <-3.8154, 13.3633, 12.4861> <-3.8538, 13.3493, 12.4997>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5480, 12.3826, 10.5556> <-3.5738, 12.3637, 10.5469> <-3.6088, 12.3371, 10.5342> <-3.6392, 12.3238, 10.5343>
		<-3.6083, 12.5089, 10.5343> <-3.6342, 12.4900, 10.5255> <-3.6684, 12.4684, 10.5149> <-3.6988, 12.4551, 10.5151>
		<-3.7117, 12.6774, 10.7084> <-3.7304, 12.6671, 10.7058> <-3.7598, 12.6444, 10.7000> <-3.7796, 12.6358, 10.7001>
		<-3.7703, 12.7893, 10.6446> <-3.7890, 12.7790, 10.6419> <-3.8138, 12.7645, 10.6380> <-3.8335, 12.7558, 10.6381>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5480, 12.3826, 10.5556> <-3.5212, 12.3266, 10.5651> <-3.5337, 12.3082, 10.6812> <-3.5233, 12.2727, 10.7320>
		<-3.5738, 12.3637, 10.5469> <-3.5470, 12.3077, 10.5563> <-3.5540, 12.2957, 10.6721> <-3.5436, 12.2602, 10.7228>
		<-3.6088, 12.3371, 10.5342> <-3.5831, 12.2804, 10.5425> <-3.5856, 12.2709, 10.6634> <-3.5708, 12.2388, 10.7154>
		<-3.6392, 12.3238, 10.5343> <-3.6135, 12.2671, 10.5427> <-3.6090, 12.2607, 10.6636> <-3.5942, 12.2285, 10.7156>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5480, 12.3826, 10.5556> <-3.5299, 12.3959, 10.5618> <-3.5079, 12.4153, 10.5730> <-3.4939, 12.4304, 10.5837>
		<-3.5212, 12.3266, 10.5651> <-3.5031, 12.3399, 10.5712> <-3.4770, 12.3562, 10.5870> <-3.4629, 12.3713, 10.5977>
		<-3.5337, 12.3082, 10.6812> <-3.5159, 12.3192, 10.6893> <-3.4938, 12.3356, 10.7009> <-3.4791, 12.3432, 10.7160>
		<-3.5233, 12.2727, 10.7320> <-3.5054, 12.2837, 10.7400> <-3.4839, 12.2979, 10.7568> <-3.4692, 12.3055, 10.7719>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5480, 12.3826, 10.5556> <-3.6083, 12.5089, 10.5343> <-3.7117, 12.6774, 10.7084> <-3.7703, 12.7893, 10.6446>
		<-3.5299, 12.3959, 10.5618> <-3.5903, 12.5221, 10.5404> <-3.7005, 12.6836, 10.7100> <-3.7591, 12.7955, 10.6461>
		<-3.5079, 12.4153, 10.5730> <-3.5700, 12.5336, 10.5450> <-3.6865, 12.6996, 10.7155> <-3.7446, 12.8041, 10.6496>
		<-3.4939, 12.4304, 10.5837> <-3.5559, 12.5487, 10.5556> <-3.6759, 12.7064, 10.7182> <-3.7340, 12.8109, 10.6522>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7130, 13.5831, 11.9542> <-3.6529, 13.5625, 11.9142> <-3.5731, 13.5177, 11.8658> <-3.5322, 13.4803, 11.8152>
		<-3.7593, 13.6112, 11.7767> <-3.6993, 13.5906, 11.7368> <-3.6238, 13.5450, 11.7082> <-3.5828, 13.5077, 11.6576>
		<-3.8327, 13.5454, 11.5353> <-3.7878, 13.5323, 11.5184> <-3.7218, 13.5141, 11.4753> <-3.6836, 13.4932, 11.4513>
		<-3.8702, 13.5756, 11.3561> <-3.8254, 13.5625, 11.3392> <-3.7629, 13.5493, 11.3165> <-3.7248, 13.5284, 11.2925>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7130, 13.5831, 11.9542> <-3.6807, 13.5636, 12.0778> <-3.6543, 13.4986, 12.2463> <-3.6132, 13.4198, 12.3402>
		<-3.6529, 13.5625, 11.9142> <-3.6206, 13.5429, 12.0378> <-3.6012, 13.4972, 12.1869> <-3.5601, 13.4183, 12.2807>
		<-3.5731, 13.5177, 11.8658> <-3.5426, 13.5011, 11.9609> <-3.5210, 13.4571, 12.1185> <-3.4911, 13.4022, 12.1981>
		<-3.5322, 13.4803, 11.8152> <-3.5016, 13.4638, 11.9103> <-3.4858, 13.4380, 12.0496> <-3.4558, 13.3830, 12.1292>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4415, 13.0622, 12.5743> <-3.3990, 13.0749, 12.5203> <-3.3498, 13.0878, 12.4406> <-3.3206, 13.0919, 12.3772>
		<-3.4974, 13.1859, 12.5487> <-3.4548, 13.1987, 12.4947> <-3.3976, 13.1959, 12.4119> <-3.3684, 13.2001, 12.3485>
		<-3.5693, 13.3355, 12.4405> <-3.5162, 13.3340, 12.3810> <-3.4551, 13.3361, 12.2937> <-3.4198, 13.3169, 12.2248>
		<-3.6132, 13.4198, 12.3402> <-3.5601, 13.4183, 12.2807> <-3.4911, 13.4022, 12.1981> <-3.4558, 13.3830, 12.1292>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4415, 13.0622, 12.5743> <-3.3782, 12.9217, 12.6034> <-3.2868, 12.7194, 12.5769> <-3.2369, 12.5853, 12.5130>
		<-3.3990, 13.0749, 12.5203> <-3.3356, 12.9345, 12.5494> <-3.2486, 12.7524, 12.5241> <-3.1987, 12.6182, 12.4602>
		<-3.3498, 13.0878, 12.4406> <-3.2982, 12.9709, 12.4716> <-3.2096, 12.7659, 12.4293> <-3.1664, 12.6552, 12.3730>
		<-3.3206, 13.0919, 12.3772> <-3.2690, 12.9750, 12.4082> <-3.1942, 12.8037, 12.3687> <-3.1510, 12.6930, 12.3124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2369, 12.5853, 12.5130> <-3.1912, 12.4628, 12.4546> <-3.1465, 12.3172, 12.3137> <-3.1392, 12.2501, 12.1875>
		<-3.1987, 12.6182, 12.4602> <-3.1531, 12.4957, 12.4018> <-3.1135, 12.3735, 12.2773> <-3.1061, 12.3064, 12.1510>
		<-3.1664, 12.6552, 12.3730> <-3.1295, 12.5608, 12.3249> <-3.0905, 12.4410, 12.1844> <-3.0783, 12.3824, 12.0895>
		<-3.1510, 12.6930, 12.3124> <-3.1141, 12.5985, 12.2644> <-3.0793, 12.5016, 12.1421> <-3.0671, 12.4429, 12.0472>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1392, 12.2501, 12.1875> <-3.1317, 12.1816, 12.0585> <-3.1607, 12.1780, 11.8533> <-3.1901, 12.1594, 11.7113>
		<-3.1061, 12.3064, 12.1510> <-3.0986, 12.2379, 12.0221> <-3.1190, 12.2188, 11.8542> <-3.1483, 12.2001, 11.7122>
		<-3.0783, 12.3824, 12.0895> <-3.0662, 12.3240, 11.9949> <-3.0777, 12.2785, 11.8116> <-3.0905, 12.2582, 11.7024>
		<-3.0671, 12.4429, 12.0472> <-3.0550, 12.3846, 11.9526> <-3.0594, 12.3337, 11.8070> <-3.0722, 12.3135, 11.6978>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1901, 12.1594, 11.7113> <-3.1962, 12.1555, 11.6817> <-3.2397, 12.1731, 11.6609> <-3.2537, 12.1774, 11.6341>
		<-3.1483, 12.2001, 11.7122> <-3.1545, 12.1962, 11.6826> <-3.1810, 12.2082, 11.6691> <-3.1949, 12.2125, 11.6424>
		<-3.0905, 12.2582, 11.7024> <-3.0955, 12.2502, 11.6591> <-3.1545, 12.2932, 11.6289> <-3.1624, 12.3008, 11.5860>
		<-3.0722, 12.3135, 11.6978> <-3.0772, 12.3055, 11.6546> <-3.1154, 12.3461, 11.6082> <-3.1233, 12.3537, 11.5654>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2537, 12.1774, 11.6341> <-3.2633, 12.1803, 11.6157> <-3.2536, 12.1677, 11.5732> <-3.2663, 12.1825, 11.5654>
		<-3.1949, 12.2125, 11.6424> <-3.2046, 12.2154, 11.6239> <-3.1891, 12.2037, 11.5823> <-3.2018, 12.2185, 11.5745>
		<-3.1624, 12.3008, 11.5860> <-3.1680, 12.2937, 11.5842> <-3.1726, 12.2918, 11.5632> <-3.1793, 12.2857, 11.5612>
		<-3.1233, 12.3537, 11.5654> <-3.1289, 12.3466, 11.5636> <-3.1354, 12.3360, 11.5614> <-3.1420, 12.3299, 11.5594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2537, 12.1774, 11.6341> <-3.3109, 12.1432, 11.6261> <-3.3958, 12.1966, 11.5477> <-3.4457, 12.1612, 11.5201>
		<-3.2633, 12.1803, 11.6157> <-3.3206, 12.1461, 11.6077> <-3.3984, 12.1947, 11.5538> <-3.4483, 12.1592, 11.5262>
		<-3.2536, 12.1677, 11.5732> <-3.3091, 12.1367, 11.5655> <-3.3817, 12.1696, 11.5322> <-3.4294, 12.1663, 11.5184>
		<-3.2663, 12.1825, 11.5654> <-3.3218, 12.1516, 11.5577> <-3.3776, 12.1750, 11.5335> <-3.4253, 12.1717, 11.5198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4227, 12.5326, 10.6690> <-3.4321, 12.5155, 10.6551> <-3.4478, 12.4945, 10.6368> <-3.4590, 12.4784, 10.6233>
		<-3.4732, 12.6394, 10.6278> <-3.4826, 12.6223, 10.6139> <-3.5076, 12.6023, 10.5972> <-3.5188, 12.5862, 10.5837>
		<-3.5887, 12.7972, 10.7659> <-3.6021, 12.7827, 10.7550> <-3.6194, 12.7580, 10.7401> <-3.6358, 12.7445, 10.7325>
		<-3.6391, 12.8883, 10.6963> <-3.6524, 12.8738, 10.6854> <-3.6722, 12.8549, 10.6724> <-3.6887, 12.8414, 10.6648>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4227, 12.5326, 10.6690> <-3.3847, 12.4522, 10.7000> <-3.3800, 12.3888, 10.8314> <-3.3779, 12.3360, 10.9093>
		<-3.4321, 12.5155, 10.6551> <-3.3941, 12.4352, 10.6861> <-3.3886, 12.3879, 10.8140> <-3.3865, 12.3351, 10.8919>
		<-3.4478, 12.4945, 10.6368> <-3.4096, 12.4257, 10.6621> <-3.4114, 12.3792, 10.7982> <-3.3961, 12.3366, 10.8673>
		<-3.4590, 12.4784, 10.6233> <-3.4209, 12.4096, 10.6486> <-3.4220, 12.3757, 10.7823> <-3.4067, 12.3331, 10.8514>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4227, 12.5326, 10.6690> <-3.4732, 12.6394, 10.6278> <-3.5887, 12.7972, 10.7659> <-3.6391, 12.8883, 10.6963>
		<-3.4109, 12.5540, 10.6864> <-3.4615, 12.6609, 10.6452> <-3.5748, 12.8124, 10.7773> <-3.6251, 12.9035, 10.7077>
		<-3.3982, 12.5846, 10.7091> <-3.4509, 12.6850, 10.6758> <-3.5608, 12.8418, 10.7947> <-3.6076, 12.9244, 10.7243>
		<-3.3886, 12.6065, 10.7273> <-3.4413, 12.7070, 10.6939> <-3.5513, 12.8576, 10.8094> <-3.5981, 12.9402, 10.7389>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4227, 12.5326, 10.6690> <-3.4109, 12.5540, 10.6864> <-3.3982, 12.5846, 10.7091> <-3.3886, 12.6065, 10.7273>
		<-3.3847, 12.4522, 10.7000> <-3.3729, 12.4737, 10.7174> <-3.3592, 12.5101, 10.7339> <-3.3496, 12.5321, 10.7520>
		<-3.3800, 12.3888, 10.8314> <-3.3613, 12.4080, 10.8342> <-3.3528, 12.4245, 10.8411> <-3.3370, 12.4453, 10.8480>
		<-3.3779, 12.3360, 10.9093> <-3.3592, 12.3553, 10.9121> <-3.3301, 12.3780, 10.9118> <-3.3143, 12.3988, 10.9187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5322, 13.4803, 11.8152> <-3.4829, 13.4354, 11.7543> <-3.4481, 13.3662, 11.6591> <-3.4188, 13.3150, 11.5908>
		<-3.5828, 13.5077, 11.6576> <-3.5335, 13.4628, 11.5968> <-3.5011, 13.3980, 11.5365> <-3.4718, 13.3468, 11.4682>
		<-3.6836, 13.4932, 11.4513> <-3.6387, 13.4686, 11.4229> <-3.5948, 13.4224, 11.3449> <-3.5615, 13.3878, 11.3113>
		<-3.7248, 13.5284, 11.2925> <-3.6798, 13.5037, 11.2642> <-3.6313, 13.4609, 11.2182> <-3.5980, 13.4263, 11.1847>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5322, 13.4803, 11.8152> <-3.5016, 13.4638, 11.9103> <-3.4858, 13.4380, 12.0496> <-3.4558, 13.3830, 12.1292>
		<-3.4829, 13.4354, 11.7543> <-3.4523, 13.4189, 11.8494> <-3.4361, 13.4111, 11.9527> <-3.4062, 13.3561, 12.0322>
		<-3.4481, 13.3662, 11.6591> <-3.4219, 13.3506, 11.7195> <-3.3871, 13.3380, 11.8332> <-3.3661, 13.3129, 11.8925>
		<-3.4188, 13.3150, 11.5908> <-3.3926, 13.2993, 11.6513> <-3.3551, 13.2933, 11.7354> <-3.3341, 13.2682, 11.7947>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1510, 12.6930, 12.3124> <-3.1357, 12.7305, 12.2522> <-3.1306, 12.7867, 12.1714> <-3.1359, 12.8328, 12.1156>
		<-3.1942, 12.8037, 12.3687> <-3.1789, 12.8412, 12.3085> <-3.1562, 12.8591, 12.2024> <-3.1615, 12.9052, 12.1467>
		<-3.2690, 12.9750, 12.4082> <-3.2347, 12.9799, 12.3336> <-3.2217, 13.0315, 12.2441> <-3.2029, 13.0292, 12.1640>
		<-3.3206, 13.0919, 12.3772> <-3.2863, 13.0968, 12.3026> <-3.2502, 13.0941, 12.1979> <-3.2314, 13.0919, 12.1178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1510, 12.6930, 12.3124> <-3.1141, 12.5985, 12.2644> <-3.0793, 12.5016, 12.1421> <-3.0671, 12.4429, 12.0472>
		<-3.1357, 12.7305, 12.2522> <-3.0988, 12.6360, 12.2042> <-3.0691, 12.5569, 12.1035> <-3.0569, 12.4983, 12.0086>
		<-3.1306, 12.7867, 12.1714> <-3.1039, 12.7113, 12.1391> <-3.0735, 12.6210, 12.0269> <-3.0615, 12.5739, 11.9556>
		<-3.1359, 12.8328, 12.1156> <-3.1092, 12.7574, 12.0833> <-3.0806, 12.6793, 11.9921> <-3.0686, 12.6322, 11.9208>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0671, 12.4429, 12.0472> <-3.0550, 12.3846, 11.9526> <-3.0594, 12.3337, 11.8070> <-3.0722, 12.3135, 11.6978>
		<-3.0569, 12.4983, 12.0086> <-3.0448, 12.4399, 11.9140> <-3.0376, 12.3997, 11.8016> <-3.0503, 12.3794, 11.6924>
		<-3.0615, 12.5739, 11.9556> <-3.0508, 12.5319, 11.8920> <-3.0545, 12.4958, 11.7540> <-3.0569, 12.4754, 11.6797>
		<-3.0686, 12.6322, 11.9208> <-3.0579, 12.5902, 11.8572> <-3.0601, 12.5653, 11.7537> <-3.0624, 12.5449, 11.6795>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0722, 12.3135, 11.6978> <-3.0772, 12.3055, 11.6546> <-3.1154, 12.3461, 11.6082> <-3.1233, 12.3537, 11.5654>
		<-3.0503, 12.3794, 11.6924> <-3.0554, 12.3714, 11.6491> <-3.0898, 12.3920, 11.6257> <-3.0977, 12.3996, 11.5829>
		<-3.0569, 12.4754, 11.6797> <-3.0580, 12.4658, 11.6448> <-3.0743, 12.4738, 11.5923> <-3.0796, 12.4779, 11.5567>
		<-3.0624, 12.5449, 11.6795> <-3.0635, 12.5353, 11.6446> <-3.0749, 12.5291, 11.5962> <-3.0801, 12.5332, 11.5606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1569, 12.3945, 11.2406> <-3.1314, 12.4476, 11.2738> <-3.1101, 12.5239, 11.3222> <-3.1100, 12.5826, 11.3557>
		<-3.1367, 12.3715, 11.3344> <-3.1112, 12.4246, 11.3677> <-3.0937, 12.5001, 11.3791> <-3.0936, 12.5588, 11.4127>
		<-3.1411, 12.3706, 11.4697> <-3.1155, 12.4166, 11.4872> <-3.0888, 12.4853, 11.4939> <-3.0894, 12.5405, 11.4979>
		<-3.1233, 12.3537, 11.5654> <-3.0977, 12.3996, 11.5829> <-3.0796, 12.4779, 11.5567> <-3.0801, 12.5332, 11.5606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1569, 12.3945, 11.2406> <-3.1760, 12.4162, 11.1517> <-3.2206, 12.4511, 11.0361> <-3.2528, 12.5009, 10.9638>
		<-3.1314, 12.4476, 11.2738> <-3.1505, 12.4694, 11.1849> <-3.1988, 12.5176, 11.0761> <-3.2310, 12.5674, 11.0038>
		<-3.1101, 12.5239, 11.3222> <-3.1329, 12.5571, 11.2428> <-3.1770, 12.6113, 11.1271> <-3.2126, 12.6588, 11.0607>
		<-3.1100, 12.5826, 11.3557> <-3.1328, 12.6158, 11.2764> <-3.1735, 12.6731, 11.1788> <-3.2090, 12.7206, 11.1124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1569, 12.3945, 11.2406> <-3.1722, 12.3626, 11.2207> <-3.2110, 12.3290, 11.1961> <-3.2424, 12.3069, 11.1833>
		<-3.1760, 12.4162, 11.1517> <-3.1913, 12.3844, 11.1318> <-3.2264, 12.3448, 11.1122> <-3.2579, 12.3226, 11.0994>
		<-3.2206, 12.4511, 11.0361> <-3.2309, 12.4195, 11.0171> <-3.2695, 12.3822, 10.9985> <-3.2919, 12.3528, 10.9887>
		<-3.2528, 12.5009, 10.9638> <-3.2631, 12.4694, 10.9448> <-3.2920, 12.4283, 10.9284> <-3.3143, 12.3988, 10.9187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1569, 12.3945, 11.2406> <-3.1367, 12.3715, 11.3344> <-3.1411, 12.3706, 11.4697> <-3.1233, 12.3537, 11.5654>
		<-3.1722, 12.3626, 11.2207> <-3.1520, 12.3397, 11.3145> <-3.1609, 12.3350, 11.4562> <-3.1432, 12.3181, 11.5518>
		<-3.2110, 12.3290, 11.1961> <-3.1956, 12.3133, 11.2798> <-3.1934, 12.3205, 11.4059> <-3.1811, 12.3148, 11.4913>
		<-3.2424, 12.3069, 11.1833> <-3.2270, 12.2911, 11.2669> <-3.2251, 12.3009, 11.3845> <-3.2128, 12.2952, 11.4699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2528, 12.5009, 10.9638> <-3.2631, 12.4694, 10.9448> <-3.2920, 12.4283, 10.9284> <-3.3143, 12.3988, 10.9187>
		<-3.2808, 12.5442, 10.9010> <-3.2911, 12.5126, 10.8820> <-3.3147, 12.4747, 10.8577> <-3.3370, 12.4453, 10.8480>
		<-3.3115, 12.6275, 10.8226> <-3.3186, 12.6008, 10.7981> <-3.3378, 12.5590, 10.7743> <-3.3496, 12.5321, 10.7520>
		<-3.3515, 12.6956, 10.8037> <-3.3586, 12.6689, 10.7792> <-3.3768, 12.6335, 10.7496> <-3.3886, 12.6065, 10.7273>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2528, 12.5009, 10.9638> <-3.2808, 12.5442, 10.9010> <-3.3115, 12.6275, 10.8226> <-3.3515, 12.6956, 10.8037>
		<-3.2310, 12.5674, 11.0038> <-3.2590, 12.6107, 10.9411> <-3.2980, 12.6782, 10.8690> <-3.3380, 12.7463, 10.8502>
		<-3.2126, 12.6588, 11.0607> <-3.2407, 12.6964, 11.0082> <-3.2814, 12.7593, 10.9337> <-3.3202, 12.8144, 10.9130>
		<-3.2090, 12.7206, 11.1124> <-3.2371, 12.7582, 11.0599> <-3.2813, 12.8086, 10.9836> <-3.3201, 12.8637, 10.9629>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2392, 13.0971, 11.8636> <-3.1998, 12.9969, 11.8133> <-3.1423, 12.8711, 11.7321> <-3.1078, 12.7633, 11.6961>
		<-3.2410, 13.1005, 11.8365> <-3.2015, 13.0004, 11.7862> <-3.1446, 12.8691, 11.7010> <-3.1101, 12.7613, 11.6651>
		<-3.2458, 13.1022, 11.8001> <-3.2092, 13.0054, 11.7469> <-3.1520, 12.8805, 11.6642> <-3.1210, 12.7754, 11.6253>
		<-3.2497, 13.1071, 11.7735> <-3.2131, 13.0103, 11.7203> <-3.1589, 12.8896, 11.6351> <-3.1278, 12.7845, 11.5962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2392, 13.0971, 11.8636> <-3.2378, 13.0942, 11.8861> <-3.2396, 13.0883, 11.9160> <-3.2392, 13.0860, 11.9387>
		<-3.1998, 12.9969, 11.8133> <-3.1984, 12.9941, 11.8359> <-3.2010, 13.0024, 11.8846> <-3.2006, 13.0002, 11.9073>
		<-3.1423, 12.8711, 11.7321> <-3.1392, 12.8739, 11.7747> <-3.1367, 12.8695, 11.8028> <-3.1454, 12.8928, 11.8377>
		<-3.1078, 12.7633, 11.6961> <-3.1047, 12.7661, 11.7388> <-3.1018, 12.7767, 11.7992> <-3.1105, 12.8000, 11.8340>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2497, 13.1071, 11.7735> <-3.2131, 13.0103, 11.7203> <-3.1589, 12.8896, 11.6351> <-3.1278, 12.7845, 11.5962>
		<-3.2534, 13.1117, 11.7489> <-3.2168, 13.0149, 11.6957> <-3.1667, 12.9001, 11.6016> <-3.1357, 12.7949, 11.5627>
		<-3.2587, 13.1224, 11.7172> <-3.2263, 13.0323, 11.6556> <-3.1721, 12.9054, 11.5763> <-3.1455, 12.8113, 11.5181>
		<-3.2645, 13.1287, 11.6933> <-3.2321, 13.0385, 11.6318> <-3.1832, 12.9223, 11.5465> <-3.1565, 12.8282, 11.4883>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2645, 13.1287, 11.6933> <-3.2321, 13.0385, 11.6318> <-3.1832, 12.9223, 11.5465> <-3.1565, 12.8282, 11.4883>
		<-3.2702, 13.1348, 11.6700> <-3.2378, 13.0446, 11.6084> <-3.2022, 12.9514, 11.4954> <-3.1756, 12.8572, 11.4372>
		<-3.2782, 13.1415, 11.6383> <-3.2583, 13.0795, 11.5511> <-3.2128, 12.9646, 11.4465> <-3.1999, 12.8947, 11.3642>
		<-3.2880, 13.1482, 11.6164> <-3.2681, 13.0862, 11.5292> <-3.2405, 13.0065, 11.4105> <-3.2276, 12.9366, 11.3281>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4188, 13.3150, 11.5908> <-3.4006, 13.2832, 11.5485> <-3.3837, 13.2305, 11.4959> <-3.3744, 13.2042, 11.4473>
		<-3.4718, 13.3468, 11.4682> <-3.4537, 13.3150, 11.4259> <-3.4361, 13.2702, 11.3951> <-3.4268, 13.2439, 11.3465>
		<-3.5615, 13.3878, 11.3113> <-3.5415, 13.3670, 11.2911> <-3.5264, 13.3316, 11.2452> <-3.5149, 13.3063, 11.2235>
		<-3.5980, 13.4263, 11.1847> <-3.5780, 13.4055, 11.1644> <-3.5604, 13.3708, 11.1366> <-3.5488, 13.3455, 11.1149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4188, 13.3150, 11.5908> <-3.3926, 13.2993, 11.6513> <-3.3551, 13.2933, 11.7354> <-3.3341, 13.2682, 11.7947>
		<-3.4006, 13.2832, 11.5485> <-3.3745, 13.2675, 11.6089> <-3.3363, 13.2669, 11.6780> <-3.3153, 13.2419, 11.7372>
		<-3.3837, 13.2305, 11.4959> <-3.3578, 13.2109, 11.5456> <-3.3234, 13.2018, 11.6170> <-3.3000, 13.1857, 11.6693>
		<-3.3744, 13.2042, 11.4473> <-3.3485, 13.1846, 11.4971> <-3.3113, 13.1642, 11.5642> <-3.2880, 13.1482, 11.6164>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0686, 12.6322, 11.9208> <-3.0579, 12.5902, 11.8572> <-3.0601, 12.5653, 11.7537> <-3.0624, 12.5449, 11.6795>
		<-3.0746, 12.6818, 11.8912> <-3.0639, 12.6398, 11.8276> <-3.0654, 12.6322, 11.7534> <-3.0677, 12.6118, 11.6792>
		<-3.0901, 12.7457, 11.8319> <-3.0814, 12.7224, 11.7970> <-3.0852, 12.7051, 11.7184> <-3.0883, 12.7024, 11.6758>
		<-3.1105, 12.8000, 11.8340> <-3.1018, 12.7767, 11.7992> <-3.1047, 12.7661, 11.7388> <-3.1078, 12.7633, 11.6961>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0686, 12.6322, 11.9208> <-3.0746, 12.6818, 11.8912> <-3.0901, 12.7457, 11.8319> <-3.1105, 12.8000, 11.8340>
		<-3.0806, 12.6793, 11.9921> <-3.0867, 12.7289, 11.9625> <-3.1044, 12.7838, 11.8890> <-3.1248, 12.8381, 11.8912>
		<-3.1092, 12.7574, 12.0833> <-3.1132, 12.7924, 12.0409> <-3.1432, 12.8664, 11.9915> <-3.1569, 12.9043, 11.9538>
		<-3.1359, 12.8328, 12.1156> <-3.1399, 12.8678, 12.0732> <-3.1678, 12.9213, 12.0277> <-3.1815, 12.9592, 11.9900>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0624, 12.5449, 11.6795> <-3.0635, 12.5353, 11.6446> <-3.0749, 12.5291, 11.5962> <-3.0801, 12.5332, 11.5606>
		<-3.0677, 12.6118, 11.6792> <-3.0688, 12.6022, 11.6443> <-3.0757, 12.6063, 11.6018> <-3.0809, 12.6105, 11.5662>
		<-3.0883, 12.7024, 11.6758> <-3.0906, 12.7003, 11.6447> <-3.1003, 12.7054, 11.5993> <-3.1071, 12.7145, 11.5702>
		<-3.1078, 12.7633, 11.6961> <-3.1101, 12.7613, 11.6651> <-3.1210, 12.7754, 11.6253> <-3.1278, 12.7845, 11.5962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1100, 12.5826, 11.3557> <-3.1328, 12.6158, 11.2764> <-3.1735, 12.6731, 11.1788> <-3.2090, 12.7206, 11.1124>
		<-3.1099, 12.6563, 11.3978> <-3.1328, 12.6895, 11.3184> <-3.1694, 12.7435, 11.2376> <-3.2049, 12.7910, 11.1712>
		<-3.1367, 12.7580, 11.4449> <-3.1557, 12.7871, 11.3938> <-3.1890, 12.8357, 11.2947> <-3.2167, 12.8777, 11.2587>
		<-3.1565, 12.8282, 11.4883> <-3.1756, 12.8572, 11.4372> <-3.1999, 12.8947, 11.3642> <-3.2276, 12.9366, 11.3281>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1100, 12.5826, 11.3557> <-3.1099, 12.6563, 11.3978> <-3.1367, 12.7580, 11.4449> <-3.1565, 12.8282, 11.4883>
		<-3.0936, 12.5588, 11.4127> <-3.0936, 12.6325, 11.4548> <-3.1256, 12.7411, 11.4747> <-3.1455, 12.8113, 11.5181>
		<-3.0894, 12.5405, 11.4979> <-3.0902, 12.6178, 11.5034> <-3.1150, 12.7250, 11.5367> <-3.1357, 12.7949, 11.5627>
		<-3.0801, 12.5332, 11.5606> <-3.0809, 12.6105, 11.5662> <-3.1071, 12.7145, 11.5702> <-3.1278, 12.7845, 11.5962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2090, 12.7206, 11.1124> <-3.2371, 12.7582, 11.0599> <-3.2813, 12.8086, 10.9836> <-3.3201, 12.8637, 10.9629>
		<-3.2049, 12.7910, 11.1712> <-3.2330, 12.8285, 11.1186> <-3.2812, 12.8882, 11.0641> <-3.3200, 12.9432, 11.0434>
		<-3.2167, 12.8777, 11.2587> <-3.2491, 12.9268, 11.2165> <-3.2996, 13.0136, 11.1839> <-3.3402, 13.0577, 11.1434>
		<-3.2276, 12.9366, 11.3281> <-3.2600, 12.9858, 11.2860> <-3.3099, 13.0784, 11.2762> <-3.3506, 13.1226, 11.2356>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3201, 12.8637, 10.9629> <-3.3202, 12.8144, 10.9130> <-3.3380, 12.7463, 10.8502> <-3.3515, 12.6956, 10.8037>
		<-3.3787, 12.9468, 10.9316> <-3.3789, 12.8976, 10.8817> <-3.3951, 12.8435, 10.8232> <-3.4086, 12.7928, 10.7768>
		<-3.4767, 13.0962, 11.0241> <-3.4839, 13.0545, 10.9850> <-3.4982, 12.9832, 10.9301> <-3.5131, 12.9430, 10.8916>
		<-3.5174, 13.1583, 10.9477> <-3.5245, 13.1166, 10.9086> <-3.5439, 13.0617, 10.8580> <-3.5587, 13.0215, 10.8195>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3201, 12.8637, 10.9629> <-3.3787, 12.9468, 10.9316> <-3.4767, 13.0962, 11.0241> <-3.5174, 13.1583, 10.9477>
		<-3.3200, 12.9432, 11.0434> <-3.3786, 13.0264, 11.0121> <-3.4719, 13.1246, 11.0507> <-3.5125, 13.1867, 10.9743>
		<-3.3402, 13.0577, 11.1434> <-3.3893, 13.1111, 11.0944> <-3.4864, 13.1929, 11.0877> <-3.5143, 13.2247, 11.0111>
		<-3.3506, 13.1226, 11.2356> <-3.3996, 13.1759, 11.1866> <-3.4913, 13.2219, 11.1136> <-3.5192, 13.2537, 11.0370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6851, 12.9672, 12.7367> <-3.7393, 13.0990, 12.7161> <-3.8135, 13.2585, 12.6041> <-3.8538, 13.3493, 12.4997>
		<-3.7397, 12.9449, 12.7539> <-3.7939, 13.0767, 12.7333> <-3.8691, 13.2382, 12.6238> <-3.9094, 13.3290, 12.5193>
		<-3.8165, 12.9158, 12.7664> <-3.8733, 13.0454, 12.7501> <-3.9450, 13.2105, 12.6490> <-3.9854, 13.3016, 12.5472>
		<-3.8728, 12.8912, 12.7667> <-3.9295, 13.0208, 12.7504> <-4.0021, 13.1855, 12.6493> <-4.0425, 13.2766, 12.5475>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9490, 13.5614, 12.0527> <-4.0071, 13.5455, 12.0670> <-4.0848, 13.5220, 12.0894> <-4.1415, 13.4972, 12.0898>
		<-3.9195, 13.5305, 12.1977> <-3.9776, 13.5146, 12.2120> <-4.0678, 13.4850, 12.2393> <-4.1244, 13.4602, 12.2396>
		<-3.8961, 13.4444, 12.3901> <-3.9517, 13.4241, 12.4098> <-4.0294, 13.4009, 12.4362> <-4.0865, 13.3760, 12.4365>
		<-3.8538, 13.3493, 12.4997> <-3.9094, 13.3290, 12.5193> <-3.9854, 13.3016, 12.5472> <-4.0425, 13.2766, 12.5475>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9490, 13.5614, 12.0527> <-3.9884, 13.6027, 11.8590> <-4.0458, 13.5496, 11.5887> <-4.0791, 13.5852, 11.3928>
		<-4.0071, 13.5455, 12.0670> <-4.0465, 13.5868, 11.8733> <-4.0745, 13.5452, 11.5908> <-4.1079, 13.5808, 11.3949>
		<-4.0848, 13.5220, 12.0894> <-4.1077, 13.5720, 11.8871> <-4.1271, 13.5312, 11.5990> <-4.1466, 13.5731, 11.3945>
		<-4.1415, 13.4972, 12.0898> <-4.1644, 13.5472, 11.8874> <-4.1538, 13.5195, 11.5991> <-4.1733, 13.5614, 11.3946>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3153, 12.2351, 11.4359> <-3.3444, 12.2186, 11.4368> <-3.3813, 12.2001, 11.4601> <-3.4066, 12.1858, 11.4764>
		<-3.3430, 12.2385, 11.3458> <-3.3721, 12.2221, 11.3468> <-3.3938, 12.1968, 11.3795> <-3.4191, 12.1825, 11.3959>
		<-3.3993, 12.1982, 11.2288> <-3.3981, 12.1916, 11.2545> <-3.4188, 12.1893, 11.2690> <-3.4250, 12.1713, 11.2874>
		<-3.4103, 12.2158, 11.1368> <-3.4091, 12.2092, 11.1625> <-3.4227, 12.1823, 11.1878> <-3.4289, 12.1643, 11.2063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3153, 12.2351, 11.4359> <-3.3098, 12.2344, 11.4538> <-3.3026, 12.2032, 11.4689> <-3.3024, 12.2025, 11.4876>
		<-3.3444, 12.2186, 11.4368> <-3.3389, 12.2180, 11.4548> <-3.3254, 12.1900, 11.4696> <-3.3252, 12.1892, 11.4884>
		<-3.3813, 12.2001, 11.4601> <-3.3790, 12.2008, 11.4750> <-3.3533, 12.1806, 11.4967> <-3.3487, 12.1851, 11.5104>
		<-3.4066, 12.1858, 11.4764> <-3.4043, 12.1864, 11.4914> <-3.3852, 12.1727, 11.5050> <-3.3806, 12.1771, 11.5188>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3153, 12.2351, 11.4359> <-3.3430, 12.2385, 11.3458> <-3.3993, 12.1982, 11.2288> <-3.4103, 12.2158, 11.1368>
		<-3.2831, 12.2533, 11.4348> <-3.3108, 12.2567, 11.3447> <-3.3523, 12.2292, 11.2463> <-3.3632, 12.2468, 11.1543>
		<-3.2402, 12.2783, 11.4515> <-3.2525, 12.2840, 11.3660> <-3.2727, 12.2589, 11.2482> <-3.2881, 12.2747, 11.1646>
		<-3.2128, 12.2952, 11.4699> <-3.2251, 12.3009, 11.3845> <-3.2270, 12.2911, 11.2669> <-3.2424, 12.3069, 11.1833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3153, 12.2351, 11.4359> <-3.2831, 12.2533, 11.4348> <-3.2402, 12.2783, 11.4515> <-3.2128, 12.2952, 11.4699>
		<-3.3098, 12.2344, 11.4538> <-3.2775, 12.2526, 11.4527> <-3.2382, 12.2773, 11.4656> <-3.2108, 12.2942, 11.4840>
		<-3.3026, 12.2032, 11.4689> <-3.2669, 12.2240, 11.4678> <-3.2275, 12.2576, 11.4854> <-3.1970, 12.2818, 11.4990>
		<-3.3024, 12.2025, 11.4876> <-3.2667, 12.2232, 11.4865> <-3.2256, 12.2607, 11.4992> <-3.1951, 12.2849, 11.5128>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4457, 12.1612, 11.5201> <-3.4737, 12.1412, 11.5046> <-3.4436, 12.0717, 11.5186> <-3.4532, 12.0355, 11.5237>
		<-3.4720, 12.1622, 11.4441> <-3.5000, 12.1422, 11.4286> <-3.4570, 12.0704, 11.4488> <-3.4667, 12.0342, 11.4538>
		<-3.4517, 12.1132, 11.3388> <-3.4565, 12.0957, 11.3494> <-3.4571, 12.0517, 11.3515> <-3.4636, 12.0328, 11.3580>
		<-3.4520, 12.0944, 11.2606> <-3.4568, 12.0769, 11.2712> <-3.4589, 12.0497, 11.2804> <-3.4654, 12.0308, 11.2869>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4457, 12.1612, 11.5201> <-3.4384, 12.1666, 11.5033> <-3.4211, 12.1776, 11.4858> <-3.4066, 12.1858, 11.4764>
		<-3.4483, 12.1592, 11.5262> <-3.4411, 12.1646, 11.5094> <-3.4188, 12.1782, 11.5007> <-3.4043, 12.1864, 11.4914>
		<-3.4294, 12.1663, 11.5184> <-3.4160, 12.1679, 11.5181> <-3.4016, 12.1686, 11.5093> <-3.3852, 12.1727, 11.5050>
		<-3.4253, 12.1717, 11.5198> <-3.4119, 12.1733, 11.5195> <-3.3969, 12.1730, 11.5230> <-3.3806, 12.1771, 11.5188>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4457, 12.1612, 11.5201> <-3.4720, 12.1622, 11.4441> <-3.4517, 12.1132, 11.3388> <-3.4520, 12.0944, 11.2606>
		<-3.4384, 12.1666, 11.5033> <-3.4647, 12.1676, 11.4274> <-3.4454, 12.1361, 11.3250> <-3.4458, 12.1173, 11.2468>
		<-3.4211, 12.1776, 11.4858> <-3.4336, 12.1743, 11.4052> <-3.4314, 12.1526, 11.3065> <-3.4354, 12.1456, 11.2253>
		<-3.4066, 12.1858, 11.4764> <-3.4191, 12.1825, 11.3959> <-3.4250, 12.1713, 11.2874> <-3.4289, 12.1643, 11.2063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3806, 12.1771, 11.5188> <-3.3776, 12.1800, 11.5277> <-3.3849, 12.1965, 11.5304> <-3.3868, 12.2048, 11.5354>
		<-3.3969, 12.1730, 11.5230> <-3.3939, 12.1759, 11.5320> <-3.3966, 12.1926, 11.5325> <-3.3984, 12.2009, 11.5375>
		<-3.4119, 12.1733, 11.5195> <-3.4067, 12.1802, 11.5211> <-3.4107, 12.1923, 11.5282> <-3.4084, 12.2002, 11.5310>
		<-3.4253, 12.1717, 11.5198> <-3.4201, 12.1786, 11.5214> <-3.4199, 12.1903, 11.5263> <-3.4176, 12.1983, 11.5291>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3806, 12.1771, 11.5188> <-3.3487, 12.1851, 11.5104> <-3.3252, 12.1892, 11.4884> <-3.3024, 12.2025, 11.4876>
		<-3.3776, 12.1800, 11.5277> <-3.3457, 12.1879, 11.5194> <-3.3250, 12.1888, 11.5003> <-3.3022, 12.2020, 11.4995>
		<-3.3849, 12.1965, 11.5304> <-3.3556, 12.2061, 11.5253> <-3.3319, 12.2111, 11.5040> <-3.3108, 12.2233, 11.5040>
		<-3.3868, 12.2048, 11.5354> <-3.3574, 12.2144, 11.5303> <-3.3355, 12.2200, 11.5110> <-3.3144, 12.2322, 11.5110>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3024, 12.2025, 11.4876> <-3.2667, 12.2232, 11.4865> <-3.2256, 12.2607, 11.4992> <-3.1951, 12.2849, 11.5128>
		<-3.3022, 12.2020, 11.4995> <-3.2665, 12.2228, 11.4984> <-3.2242, 12.2630, 11.5093> <-3.1937, 12.2872, 11.5229>
		<-3.3108, 12.2233, 11.5040> <-3.2750, 12.2438, 11.5040> <-3.2359, 12.2825, 11.5189> <-3.2012, 12.3025, 11.5286>
		<-3.3144, 12.2322, 11.5110> <-3.2787, 12.2527, 11.5110> <-3.2385, 12.2900, 11.5257> <-3.2038, 12.3100, 11.5354>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1420, 12.3299, 11.5594> <-3.1579, 12.3164, 11.5454> <-3.1766, 12.2997, 11.5211> <-3.1951, 12.2849, 11.5128>
		<-3.1354, 12.3360, 11.5614> <-3.1513, 12.3225, 11.5474> <-3.1785, 12.2966, 11.5073> <-3.1970, 12.2818, 11.4990>
		<-3.1289, 12.3466, 11.5636> <-3.1488, 12.3109, 11.5500> <-3.1791, 12.3138, 11.5054> <-3.2108, 12.2942, 11.4840>
		<-3.1233, 12.3537, 11.5654> <-3.1432, 12.3181, 11.5518> <-3.1811, 12.3148, 11.4913> <-3.2128, 12.2952, 11.4699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1420, 12.3299, 11.5594> <-3.1458, 12.3264, 11.5582> <-3.1528, 12.3247, 11.5564> <-3.1574, 12.3225, 11.5552>
		<-3.1579, 12.3164, 11.5454> <-3.1618, 12.3129, 11.5443> <-3.1667, 12.3210, 11.5505> <-3.1713, 12.3187, 11.5492>
		<-3.1766, 12.2997, 11.5211> <-3.1752, 12.3020, 11.5312> <-3.1881, 12.3100, 11.5323> <-3.1907, 12.3176, 11.5391>
		<-3.1951, 12.2849, 11.5128> <-3.1937, 12.2872, 11.5229> <-3.2012, 12.3025, 11.5286> <-3.2038, 12.3100, 11.5354>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1420, 12.3299, 11.5594> <-3.1793, 12.2857, 11.5612> <-3.2018, 12.2185, 11.5745> <-3.2663, 12.1825, 11.5654>
		<-3.1458, 12.3264, 11.5582> <-3.1831, 12.2822, 11.5601> <-3.2138, 12.2326, 11.5671> <-3.2784, 12.1965, 11.5581>
		<-3.1528, 12.3247, 11.5564> <-3.1936, 12.2951, 11.5728> <-3.2240, 12.2407, 11.6026> <-3.2853, 12.2114, 11.5964>
		<-3.1574, 12.3225, 11.5552> <-3.1982, 12.2929, 11.5715> <-3.2322, 12.2531, 11.6158> <-3.2935, 12.2238, 11.6097>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2663, 12.1825, 11.5654> <-3.3218, 12.1516, 11.5577> <-3.3776, 12.1750, 11.5335> <-3.4253, 12.1717, 11.5198>
		<-3.2784, 12.1965, 11.5581> <-3.3338, 12.1656, 11.5503> <-3.3724, 12.1818, 11.5351> <-3.4201, 12.1786, 11.5214>
		<-3.2853, 12.2114, 11.5964> <-3.3374, 12.1865, 11.5912> <-3.3827, 12.1980, 11.5505> <-3.4199, 12.1903, 11.5263>
		<-3.2935, 12.2238, 11.6097> <-3.3456, 12.1989, 11.6045> <-3.3804, 12.2059, 11.5533> <-3.4176, 12.1983, 11.5291>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3506, 13.1226, 11.2356> <-3.3996, 13.1759, 11.1866> <-3.4913, 13.2219, 11.1136> <-3.5192, 13.2537, 11.0370>
		<-3.3568, 13.1618, 11.2914> <-3.4059, 13.2151, 11.2424> <-3.4959, 13.2494, 11.1382> <-3.5238, 13.2812, 11.0616>
		<-3.3630, 13.1721, 11.3880> <-3.4154, 13.2117, 11.2872> <-3.5027, 13.2796, 11.2007> <-3.5366, 13.3188, 11.0921>
		<-3.3744, 13.2042, 11.4473> <-3.4268, 13.2439, 11.3465> <-3.5149, 13.3063, 11.2235> <-3.5488, 13.3455, 11.1149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3506, 13.1226, 11.2356> <-3.3568, 13.1618, 11.2914> <-3.3630, 13.1721, 11.3880> <-3.3744, 13.2042, 11.4473>
		<-3.3099, 13.0784, 11.2762> <-3.3162, 13.1176, 11.3319> <-3.3371, 13.1525, 11.4377> <-3.3485, 13.1846, 11.4971>
		<-3.2600, 12.9858, 11.2860> <-3.2729, 13.0557, 11.3683> <-3.2914, 13.1023, 11.4770> <-3.3113, 13.1642, 11.5642>
		<-3.2276, 12.9366, 11.3281> <-3.2405, 13.0065, 11.4105> <-3.2681, 13.0862, 11.5292> <-3.2880, 13.1482, 11.6164>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1359, 12.8328, 12.1156> <-3.1399, 12.8678, 12.0732> <-3.1678, 12.9213, 12.0277> <-3.1815, 12.9592, 11.9900>
		<-3.1615, 12.9052, 12.1467> <-3.1655, 12.9402, 12.1042> <-3.1823, 12.9535, 12.0490> <-3.1959, 12.9915, 12.0113>
		<-3.2029, 13.0292, 12.1640> <-3.1961, 13.0284, 12.1351> <-3.2188, 13.0459, 12.0404> <-3.2201, 13.0449, 12.0108>
		<-3.2314, 13.0919, 12.1178> <-3.2246, 13.0910, 12.0890> <-3.2354, 13.0827, 12.0493> <-3.2367, 13.0817, 12.0197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4439, 12.0251, 11.1067> <-3.4360, 12.0432, 11.1076> <-3.4365, 12.0706, 11.1100> <-3.4318, 12.0898, 11.1110>
		<-3.4428, 12.0166, 11.1399> <-3.4348, 12.0347, 11.1408> <-3.4387, 12.0594, 11.1342> <-3.4339, 12.0786, 11.1352>
		<-3.4572, 12.0261, 11.1856> <-3.4505, 12.0428, 11.1806> <-3.4484, 12.0664, 11.1790> <-3.4434, 12.0830, 11.1721>
		<-3.4613, 12.0272, 11.2197> <-3.4546, 12.0438, 11.2146> <-3.4520, 12.0673, 11.2055> <-3.4470, 12.0838, 11.1986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4439, 12.0251, 11.1067> <-3.4445, 12.0296, 11.0889> <-3.4573, 12.0513, 11.0733> <-3.4665, 12.0660, 11.0673>
		<-3.4360, 12.0432, 11.1076> <-3.4366, 12.0477, 11.0898> <-3.4467, 12.0737, 11.0751> <-3.4559, 12.0884, 11.0691>
		<-3.4365, 12.0706, 11.1100> <-3.4349, 12.0789, 11.0921> <-3.4373, 12.1049, 11.0786> <-3.4442, 12.1197, 11.0676>
		<-3.4318, 12.0898, 11.1110> <-3.4302, 12.0981, 11.0931> <-3.4287, 12.1278, 11.0828> <-3.4356, 12.1426, 11.0718>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4439, 12.0251, 11.1067> <-3.4515, 12.0078, 11.1059> <-3.4647, 11.9826, 11.1054> <-3.4820, 11.9751, 11.1055>
		<-3.4445, 12.0296, 11.0889> <-3.4521, 12.0123, 11.0881> <-3.4659, 11.9853, 11.0879> <-3.4832, 11.9778, 11.0880>
		<-3.4573, 12.0513, 11.0733> <-3.4654, 12.0341, 11.0720> <-3.4736, 12.0033, 11.0669> <-3.4911, 11.9956, 11.0670>
		<-3.4665, 12.0660, 11.0673> <-3.4747, 12.0488, 11.0660> <-3.4805, 12.0186, 11.0615> <-3.4979, 12.0110, 11.0616>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4439, 12.0251, 11.1067> <-3.4428, 12.0166, 11.1399> <-3.4572, 12.0261, 11.1856> <-3.4613, 12.0272, 11.2197>
		<-3.4515, 12.0078, 11.1059> <-3.4503, 11.9994, 11.1391> <-3.4626, 12.0127, 11.1897> <-3.4667, 12.0138, 11.2237>
		<-3.4647, 11.9826, 11.1054> <-3.4623, 11.9770, 11.1419> <-3.4720, 11.9880, 11.1915> <-3.4730, 11.9912, 11.2284>
		<-3.4820, 11.9751, 11.1055> <-3.4795, 11.9694, 11.1420> <-3.4857, 11.9820, 11.1916> <-3.4867, 11.9852, 11.2285>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3515, 12.6956, 10.8037> <-3.3586, 12.6689, 10.7792> <-3.3768, 12.6335, 10.7496> <-3.3886, 12.6065, 10.7273>
		<-3.4086, 12.7928, 10.7768> <-3.4158, 12.7661, 10.7523> <-3.4295, 12.7340, 10.7162> <-3.4413, 12.7070, 10.6939>
		<-3.5131, 12.9430, 10.8916> <-3.5225, 12.9177, 10.8674> <-3.5366, 12.8820, 10.8319> <-3.5513, 12.8576, 10.8094>
		<-3.5587, 13.0215, 10.8195> <-3.5681, 12.9961, 10.7952> <-3.5834, 12.9646, 10.7615> <-3.5981, 12.9402, 10.7389>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4558, 13.3830, 12.1292> <-3.4198, 13.3169, 12.2248> <-3.3684, 13.2001, 12.3485> <-3.3206, 13.0919, 12.3772>
		<-3.4062, 13.3561, 12.0322> <-3.3702, 13.2900, 12.1279> <-3.3341, 13.2049, 12.2739> <-3.2863, 13.0968, 12.3026>
		<-3.3661, 13.3129, 11.8925> <-3.3304, 13.2705, 11.9928> <-3.2896, 13.1808, 12.1340> <-3.2502, 13.0941, 12.1979>
		<-3.3341, 13.2682, 11.7947> <-3.2984, 13.2257, 11.8950> <-3.2708, 13.1785, 12.0540> <-3.2314, 13.0919, 12.1178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4654, 12.0308, 11.2869> <-3.4697, 12.0183, 11.2912> <-3.4747, 11.9968, 11.2962> <-3.4875, 11.9912, 11.2962>
		<-3.4660, 12.0303, 11.2667> <-3.4703, 12.0178, 11.2710> <-3.4745, 11.9961, 11.2758> <-3.4873, 11.9906, 11.2758>
		<-3.4637, 12.0278, 11.2398> <-3.4691, 12.0145, 11.2438> <-3.4736, 11.9929, 11.2487> <-3.4873, 11.9869, 11.2488>
		<-3.4613, 12.0272, 11.2197> <-3.4667, 12.0138, 11.2237> <-3.4730, 11.9912, 11.2284> <-3.4867, 11.9852, 11.2285>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4654, 12.0308, 11.2869> <-3.4636, 12.0328, 11.3580> <-3.4667, 12.0342, 11.4538> <-3.4532, 12.0355, 11.5237>
		<-3.4697, 12.0183, 11.2912> <-3.4678, 12.0203, 11.3623> <-3.4711, 12.0175, 11.4562> <-3.4577, 12.0188, 11.5261>
		<-3.4747, 11.9968, 11.2962> <-3.4755, 11.9990, 11.3703> <-3.4737, 12.0015, 11.4692> <-3.4739, 12.0017, 11.5434>
		<-3.4875, 11.9912, 11.2962> <-3.4882, 11.9934, 11.3704> <-3.4897, 11.9945, 11.4693> <-3.4899, 11.9947, 11.5435>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4654, 12.0308, 11.2869> <-3.4660, 12.0303, 11.2667> <-3.4637, 12.0278, 11.2398> <-3.4613, 12.0272, 11.2197>
		<-3.4589, 12.0497, 11.2804> <-3.4595, 12.0492, 11.2602> <-3.4570, 12.0445, 11.2347> <-3.4546, 12.0438, 11.2146>
		<-3.4568, 12.0769, 11.2712> <-3.4569, 12.0725, 11.2528> <-3.4545, 12.0678, 11.2242> <-3.4520, 12.0673, 11.2055>
		<-3.4520, 12.0944, 11.2606> <-3.4521, 12.0900, 11.2422> <-3.4496, 12.0844, 11.2174> <-3.4470, 12.0838, 11.1986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4520, 12.0944, 11.2606> <-3.4521, 12.0900, 11.2422> <-3.4496, 12.0844, 11.2174> <-3.4470, 12.0838, 11.1986>
		<-3.4458, 12.1173, 11.2468> <-3.4458, 12.1129, 11.2284> <-3.4427, 12.1074, 11.2078> <-3.4401, 12.1068, 11.1891>
		<-3.4354, 12.1456, 11.2253> <-3.4360, 12.1445, 11.2127> <-3.4311, 12.1383, 11.1916> <-3.4284, 12.1384, 11.1793>
		<-3.4289, 12.1643, 11.2063> <-3.4296, 12.1632, 11.1937> <-3.4245, 12.1588, 11.1774> <-3.4219, 12.1589, 11.1650>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4289, 12.1643, 11.2063> <-3.4296, 12.1632, 11.1937> <-3.4245, 12.1588, 11.1774> <-3.4219, 12.1589, 11.1650>
		<-3.4227, 12.1823, 11.1878> <-3.4234, 12.1813, 11.1752> <-3.4201, 12.1727, 11.1677> <-3.4174, 12.1729, 11.1553>
		<-3.4091, 12.2092, 11.1625> <-3.4152, 12.2052, 11.1602> <-3.4113, 12.1971, 11.1405> <-3.4111, 12.1900, 11.1373>
		<-3.4103, 12.2158, 11.1368> <-3.4164, 12.2118, 11.1346> <-3.4113, 12.2029, 11.1238> <-3.4111, 12.1958, 11.1206>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4884, 11.9921, 11.6087> <-3.5199, 11.9783, 11.6088> <-3.5567, 11.9648, 11.6411> <-3.5868, 11.9539, 11.6538>
		<-3.4888, 11.9929, 11.5891> <-3.5204, 11.9791, 11.5893> <-3.5504, 11.9684, 11.5990> <-3.5805, 11.9575, 11.6117>
		<-3.4900, 11.9948, 11.5631> <-3.5060, 11.9877, 11.5632> <-3.5349, 11.9824, 11.5685> <-3.5504, 11.9903, 11.5662>
		<-3.4899, 11.9947, 11.5435> <-3.5060, 11.9877, 11.5436> <-3.5296, 11.9875, 11.5264> <-3.5451, 11.9954, 11.5242>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4884, 11.9921, 11.6087> <-3.4859, 11.9905, 11.8054> <-3.4531, 11.9219, 12.0807> <-3.4802, 11.9870, 12.2644>
		<-3.5199, 11.9783, 11.6088> <-3.5175, 11.9767, 11.8055> <-3.5032, 11.9000, 12.0809> <-3.5302, 11.9651, 12.2646>
		<-3.5567, 11.9648, 11.6411> <-3.5833, 11.9494, 11.8208> <-3.5611, 11.8869, 12.0943> <-3.6008, 11.9448, 12.2626>
		<-3.5868, 11.9539, 11.6538> <-3.6134, 11.9385, 11.8335> <-3.6141, 11.8747, 12.0892> <-3.6538, 11.9326, 12.2574>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6434, 12.3653, 12.6624> <-3.6960, 12.3423, 12.6627> <-3.7671, 12.3137, 12.6534> <-3.8203, 12.2946, 12.6430>
		<-3.5824, 12.2248, 12.5844> <-3.6350, 12.2018, 12.5847> <-3.7043, 12.1789, 12.5789> <-3.7575, 12.1598, 12.5685>
		<-3.5038, 12.0438, 12.4248> <-3.5538, 12.0219, 12.4251> <-3.6370, 11.9977, 12.4161> <-3.6900, 11.9855, 12.4109>
		<-3.4802, 11.9870, 12.2644> <-3.5302, 11.9651, 12.2646> <-3.6008, 11.9448, 12.2626> <-3.6538, 11.9326, 12.2574>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6434, 12.3653, 12.6624> <-3.7055, 12.5083, 12.7419> <-3.8031, 12.7320, 12.7868> <-3.8728, 12.8912, 12.7667>
		<-3.6960, 12.3423, 12.6627> <-3.7581, 12.4852, 12.7421> <-3.8602, 12.7070, 12.7871> <-3.9300, 12.8662, 12.7670>
		<-3.7671, 12.3137, 12.6534> <-3.8317, 12.4524, 12.7300> <-3.9334, 12.6754, 12.7797> <-4.0048, 12.8289, 12.7553>
		<-3.8203, 12.2946, 12.6430> <-3.8849, 12.4333, 12.7197> <-3.9879, 12.6500, 12.7632> <-4.0594, 12.8035, 12.7388>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5868, 11.9539, 11.6538> <-3.6182, 11.9424, 11.6671> <-3.6599, 11.9276, 11.6864> <-3.6933, 11.9177, 11.6952>
		<-3.5805, 11.9575, 11.6117> <-3.6120, 11.9460, 11.6250> <-3.6460, 11.9428, 11.6178> <-3.6794, 11.9329, 11.6267>
		<-3.5504, 11.9903, 11.5662> <-3.5842, 12.0075, 11.5614> <-3.6266, 12.0632, 11.5730> <-3.6607, 12.0560, 11.5889>
		<-3.5451, 11.9954, 11.5242> <-3.5789, 12.0126, 11.5194> <-3.6115, 12.0810, 11.5053> <-3.6455, 12.0738, 11.5212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5868, 11.9539, 11.6538> <-3.6134, 11.9385, 11.8335> <-3.6141, 11.8747, 12.0892> <-3.6538, 11.9326, 12.2574>
		<-3.6182, 11.9424, 11.6671> <-3.6449, 11.9271, 11.8468> <-3.6548, 11.8653, 12.0852> <-3.6945, 11.9232, 12.2535>
		<-3.6599, 11.9276, 11.6864> <-3.6920, 11.8926, 11.8436> <-3.7069, 11.8629, 12.0962> <-3.7502, 11.9179, 12.2449>
		<-3.6933, 11.9177, 11.6952> <-3.7254, 11.8827, 11.8525> <-3.7474, 11.8603, 12.0855> <-3.7907, 11.9153, 12.2341>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6538, 11.9326, 12.2574> <-3.6900, 11.9855, 12.4109> <-3.7575, 12.1598, 12.5685> <-3.8203, 12.2946, 12.6430>
		<-3.6945, 11.9232, 12.2535> <-3.7308, 11.9761, 12.4070> <-3.7990, 12.1449, 12.5605> <-3.8617, 12.2797, 12.6350>
		<-3.7502, 11.9179, 12.2449> <-3.7918, 11.9706, 12.3876> <-3.8548, 12.1368, 12.5522> <-3.9181, 12.2646, 12.6194>
		<-3.7907, 11.9153, 12.2341> <-3.8323, 11.9680, 12.3768> <-3.8939, 12.1248, 12.5341> <-3.9573, 12.2526, 12.6014>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8203, 12.2946, 12.6430> <-3.8849, 12.4333, 12.7197> <-3.9879, 12.6500, 12.7632> <-4.0594, 12.8035, 12.7388>
		<-3.8617, 12.2797, 12.6350> <-3.9263, 12.4184, 12.7116> <-4.0324, 12.6293, 12.7497> <-4.1038, 12.7828, 12.7253>
		<-3.9181, 12.2646, 12.6194> <-3.9841, 12.3977, 12.6895> <-4.0938, 12.6104, 12.7218> <-4.1603, 12.7581, 12.6944>
		<-3.9573, 12.2526, 12.6014> <-4.0233, 12.3857, 12.6714> <-4.1327, 12.5915, 12.6951> <-4.1992, 12.7391, 12.6677>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6420, 12.0946, 11.0524> <-3.6229, 12.0943, 11.0525> <-3.5991, 12.0881, 11.0657> <-3.5801, 12.0902, 11.0670>
		<-3.6574, 12.1113, 11.0097> <-3.6382, 12.1110, 11.0098> <-3.6073, 12.1108, 11.0266> <-3.5883, 12.1130, 11.0279>
		<-3.6861, 12.1099, 10.9494> <-3.6547, 12.1057, 10.9527> <-3.6220, 12.0992, 10.9609> <-3.5904, 12.1027, 10.9607>
		<-3.6992, 12.1199, 10.9040> <-3.6678, 12.1157, 10.9073> <-3.6257, 12.1091, 10.9162> <-3.5941, 12.1127, 10.9159>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6420, 12.0946, 11.0524> <-3.6377, 12.0899, 11.0645> <-3.6440, 12.0639, 11.0653> <-3.6385, 12.0539, 11.0729>
		<-3.6229, 12.0943, 11.0525> <-3.6186, 12.0896, 11.0646> <-3.6213, 12.0552, 11.0611> <-3.6158, 12.0452, 11.0687>
		<-3.5991, 12.0881, 11.0657> <-3.5954, 12.0779, 11.0832> <-3.5904, 12.0502, 11.0630> <-3.5856, 12.0314, 11.0697>
		<-3.5801, 12.0902, 11.0670> <-3.5764, 12.0801, 11.0844> <-3.5669, 12.0430, 11.0611> <-3.5621, 12.0242, 11.0678>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6420, 12.0946, 11.0524> <-3.6574, 12.1113, 11.0097> <-3.6861, 12.1099, 10.9494> <-3.6992, 12.1199, 10.9040>
		<-3.6554, 12.0948, 11.0524> <-3.6707, 12.1115, 11.0097> <-3.7085, 12.1129, 10.9470> <-3.7216, 12.1229, 10.9016>
		<-3.6756, 12.0931, 11.0565> <-3.6992, 12.1105, 11.0053> <-3.7245, 12.1177, 10.9466> <-3.7504, 12.1325, 10.8957>
		<-3.6840, 12.0918, 11.0668> <-3.7076, 12.1091, 11.0155> <-3.7468, 12.1217, 10.9479> <-3.7727, 12.1366, 10.8970>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6420, 12.0946, 11.0524> <-3.6554, 12.0948, 11.0524> <-3.6756, 12.0931, 11.0565> <-3.6840, 12.0918, 11.0668>
		<-3.6377, 12.0899, 11.0645> <-3.6510, 12.0901, 11.0645> <-3.6718, 12.0903, 11.0648> <-3.6802, 12.0890, 11.0750>
		<-3.6440, 12.0639, 11.0653> <-3.6581, 12.0694, 11.0679> <-3.6729, 12.0739, 11.0738> <-3.6844, 12.0772, 11.0835>
		<-3.6385, 12.0539, 11.0729> <-3.6526, 12.0594, 11.0756> <-3.6720, 12.0676, 11.0809> <-3.6834, 12.0709, 11.0905>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6933, 11.9177, 11.6952> <-3.7254, 11.8827, 11.8525> <-3.7474, 11.8603, 12.0855> <-3.7907, 11.9153, 12.2341>
		<-3.7290, 11.9070, 11.7047> <-3.7611, 11.8721, 11.8620> <-3.7819, 11.8581, 12.0763> <-3.8252, 11.9130, 12.2250>
		<-3.7775, 11.8875, 11.7138> <-3.8072, 11.8804, 11.8562> <-3.8275, 11.8573, 12.0804> <-3.8717, 11.9095, 12.2090>
		<-3.8159, 11.8857, 11.7147> <-3.8456, 11.8785, 11.8572> <-3.8581, 11.8643, 12.0630> <-3.9022, 11.9165, 12.1916>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6933, 11.9177, 11.6952> <-3.7290, 11.9070, 11.7047> <-3.7775, 11.8875, 11.7138> <-3.8159, 11.8857, 11.7147>
		<-3.6794, 11.9329, 11.6267> <-3.7151, 11.9223, 11.6362> <-3.7713, 11.8890, 11.6840> <-3.8097, 11.8872, 11.6849>
		<-3.6607, 12.0560, 11.5889> <-3.7204, 12.0434, 11.6168> <-3.7289, 11.9502, 11.6553> <-3.7927, 11.9313, 11.6639>
		<-3.6455, 12.0738, 11.5212> <-3.7052, 12.0612, 11.5491> <-3.7227, 11.9632, 11.6284> <-3.7866, 11.9444, 11.6370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7907, 11.9153, 12.2341> <-3.8323, 11.9680, 12.3768> <-3.8939, 12.1248, 12.5341> <-3.9573, 12.2526, 12.6014>
		<-3.8252, 11.9130, 12.2250> <-3.8668, 11.9658, 12.3677> <-3.9368, 12.1117, 12.5143> <-4.0002, 12.2395, 12.5815>
		<-3.8717, 11.9095, 12.2090> <-3.9153, 11.9610, 12.3358> <-3.9986, 12.0984, 12.4942> <-4.0577, 12.2155, 12.5528>
		<-3.9022, 11.9165, 12.1916> <-3.9458, 11.9680, 12.3185> <-4.0326, 12.0944, 12.4590> <-4.0917, 12.2115, 12.5177>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9573, 12.2526, 12.6014> <-4.0233, 12.3857, 12.6714> <-4.1327, 12.5915, 12.6951> <-4.1992, 12.7391, 12.6677>
		<-4.0002, 12.2395, 12.5815> <-4.0662, 12.3726, 12.6516> <-4.1644, 12.5761, 12.6734> <-4.2308, 12.7238, 12.6460>
		<-4.0577, 12.2155, 12.5528> <-4.1222, 12.3433, 12.6168> <-4.2090, 12.5620, 12.6395> <-4.2694, 12.7037, 12.6104>
		<-4.0917, 12.2115, 12.5177> <-4.1562, 12.3393, 12.5816> <-4.2321, 12.5484, 12.6080> <-4.2925, 12.6901, 12.5789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4238, 13.3225, 12.0161> <-4.3978, 13.3458, 12.0303> <-4.3602, 13.3759, 12.0466> <-4.3289, 13.3953, 12.0548>
		<-4.4225, 13.2838, 12.1537> <-4.3965, 13.3072, 12.1678> <-4.3563, 13.3338, 12.1917> <-4.3250, 13.3532, 12.1999>
		<-4.3832, 13.2126, 12.3375> <-4.3518, 13.2314, 12.3603> <-4.3136, 13.2591, 12.3794> <-4.2769, 13.2779, 12.3922>
		<-4.3477, 13.1203, 12.4406> <-4.3162, 13.1390, 12.4634> <-4.2704, 13.1644, 12.4890> <-4.2338, 13.1831, 12.5018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4238, 13.3225, 12.0161> <-4.4255, 13.3749, 11.8295> <-4.3533, 13.3721, 11.5688> <-4.3572, 13.4181, 11.3806>
		<-4.3978, 13.3458, 12.0303> <-4.3995, 13.3983, 11.8436> <-4.3253, 13.3980, 11.5728> <-4.3293, 13.4440, 11.3845>
		<-4.3602, 13.3759, 12.0466> <-4.3655, 13.4321, 11.8527> <-4.2890, 13.4330, 11.5876> <-4.2942, 13.4808, 11.3915>
		<-4.3289, 13.3953, 12.0548> <-4.3343, 13.4515, 11.8609> <-4.2588, 13.4564, 11.5899> <-4.2641, 13.5043, 11.3938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4238, 13.3225, 12.0161> <-4.4512, 13.2979, 12.0012> <-4.4922, 13.2672, 11.9793> <-4.5061, 13.2364, 11.9585>
		<-4.4255, 13.3749, 11.8295> <-4.4529, 13.3504, 11.8146> <-4.4829, 13.3196, 11.8016> <-4.4969, 13.2888, 11.7808>
		<-4.3533, 13.3721, 11.5688> <-4.3659, 13.3500, 11.5624> <-4.3898, 13.3191, 11.5471> <-4.4010, 13.2970, 11.5384>
		<-4.3572, 13.4181, 11.3806> <-4.3698, 13.3960, 11.3741> <-4.3881, 13.3664, 11.3678> <-4.3992, 13.3443, 11.3590>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4238, 13.3225, 12.0161> <-4.4225, 13.2838, 12.1537> <-4.3832, 13.2126, 12.3375> <-4.3477, 13.1203, 12.4406>
		<-4.4512, 13.2979, 12.0012> <-4.4499, 13.2593, 12.1388> <-4.4172, 13.1923, 12.3129> <-4.3816, 13.1000, 12.4160>
		<-4.4922, 13.2672, 11.9793> <-4.4986, 13.2307, 12.1032> <-4.4618, 13.1599, 12.2853> <-4.4295, 13.0772, 12.3792>
		<-4.5061, 13.2364, 11.9585> <-4.5125, 13.1999, 12.0823> <-4.4827, 13.1364, 12.2508> <-4.4503, 13.0537, 12.3447>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7496, 12.2944, 10.5567> <-3.7716, 12.2900, 10.5629> <-3.8006, 12.2875, 10.5747> <-3.8212, 12.2873, 10.5854>
		<-3.8006, 12.4248, 10.5353> <-3.8226, 12.4204, 10.5415> <-3.8453, 12.4131, 10.5467> <-3.8659, 12.4128, 10.5573>
		<-3.8537, 12.6153, 10.7092> <-3.8682, 12.6105, 10.7112> <-3.8914, 12.6099, 10.7161> <-3.9060, 12.6060, 10.7193>
		<-3.8965, 12.7342, 10.6452> <-3.9110, 12.7293, 10.6472> <-3.9303, 12.7226, 10.6502> <-3.9449, 12.7187, 10.6534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7496, 12.2944, 10.5567> <-3.7271, 12.2367, 10.5662> <-3.7079, 12.2319, 10.6824> <-3.6877, 12.2008, 10.7330>
		<-3.7716, 12.2900, 10.5629> <-3.7490, 12.2323, 10.5724> <-3.7295, 12.2255, 10.6903> <-3.7094, 12.1943, 10.7408>
		<-3.8006, 12.2875, 10.5747> <-3.7783, 12.2250, 10.5887> <-3.7574, 12.2202, 10.7012> <-3.7373, 12.1870, 10.7569>
		<-3.8212, 12.2873, 10.5854> <-3.7990, 12.2247, 10.5994> <-3.7737, 12.2143, 10.7177> <-3.7536, 12.1812, 10.7734>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7496, 12.2944, 10.5567> <-3.8006, 12.4248, 10.5353> <-3.8537, 12.6153, 10.7092> <-3.8965, 12.7342, 10.6452>
		<-3.7166, 12.3011, 10.5475> <-3.7676, 12.4314, 10.5260> <-3.8348, 12.6216, 10.7066> <-3.8776, 12.7405, 10.6426>
		<-3.6712, 12.3099, 10.5345> <-3.7308, 12.4411, 10.5152> <-3.7980, 12.6278, 10.7002> <-3.8519, 12.7478, 10.6382>
		<-3.6392, 12.3238, 10.5343> <-3.6988, 12.4551, 10.5151> <-3.7796, 12.6358, 10.7001> <-3.8335, 12.7558, 10.6381>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7496, 12.2944, 10.5567> <-3.7166, 12.3011, 10.5475> <-3.6712, 12.3099, 10.5345> <-3.6392, 12.3238, 10.5343>
		<-3.7271, 12.2367, 10.5662> <-3.6940, 12.2434, 10.5570> <-3.6455, 12.2531, 10.5429> <-3.6135, 12.2671, 10.5427>
		<-3.7079, 12.2319, 10.6824> <-3.6809, 12.2399, 10.6727> <-3.6362, 12.2487, 10.6637> <-3.6090, 12.2607, 10.6636>
		<-3.6877, 12.2008, 10.7330> <-3.6608, 12.2088, 10.7232> <-3.6214, 12.2166, 10.7158> <-3.5942, 12.2285, 10.7156>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5061, 13.2364, 11.9585> <-4.5125, 13.1999, 12.0823> <-4.4827, 13.1364, 12.2508> <-4.4503, 13.0537, 12.3447>
		<-4.5324, 13.1782, 11.9192> <-4.5388, 13.1417, 12.0430> <-4.5183, 13.0963, 12.1918> <-4.4859, 13.0136, 12.2858>
		<-4.5535, 13.0890, 11.8711> <-4.5612, 13.0557, 11.9664> <-4.5424, 13.0106, 12.1241> <-4.5217, 12.9515, 12.2037>
		<-4.5543, 13.0334, 11.8208> <-4.5621, 13.0001, 11.9161> <-4.5529, 12.9714, 12.0555> <-4.5322, 12.9124, 12.1351>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5061, 13.2364, 11.9585> <-4.5324, 13.1782, 11.9192> <-4.5535, 13.0890, 11.8711> <-4.5543, 13.0334, 11.8208>
		<-4.4969, 13.2888, 11.7808> <-4.5231, 13.2306, 11.7414> <-4.5406, 13.1441, 11.7132> <-4.5415, 13.0885, 11.6629>
		<-4.4010, 13.2970, 11.5384> <-4.4219, 13.2551, 11.5219> <-4.4538, 13.1941, 11.4793> <-4.4645, 13.1518, 11.4555>
		<-4.3992, 13.3443, 11.3590> <-4.4202, 13.3024, 11.3425> <-4.4532, 13.2475, 11.3203> <-4.4639, 13.2052, 11.2965>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0917, 12.2115, 12.5177> <-4.1423, 12.2056, 12.4654> <-4.1922, 12.2067, 12.3786> <-4.2309, 12.2208, 12.3183>
		<-4.0326, 12.0944, 12.4590> <-4.0832, 12.0886, 12.4067> <-4.1487, 12.1152, 12.3305> <-4.1874, 12.1293, 12.2703>
		<-3.9458, 11.9680, 12.3185> <-4.0120, 11.9830, 12.2808> <-4.0868, 12.0041, 12.1908> <-4.1427, 12.0368, 12.1479>
		<-3.9022, 11.9165, 12.1916> <-3.9684, 11.9316, 12.1539> <-4.0530, 11.9550, 12.0959> <-4.1088, 11.9877, 12.0530>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0917, 12.2115, 12.5177> <-4.1562, 12.3393, 12.5816> <-4.2321, 12.5484, 12.6080> <-4.2925, 12.6901, 12.5789>
		<-4.1423, 12.2056, 12.4654> <-4.2067, 12.3334, 12.5293> <-4.2722, 12.5249, 12.5534> <-4.3325, 12.6666, 12.5243>
		<-4.1922, 12.2067, 12.3786> <-4.2432, 12.3140, 12.4349> <-4.3317, 12.5191, 12.4783> <-4.3828, 12.6363, 12.4473>
		<-4.2309, 12.2208, 12.3183> <-4.2819, 12.3281, 12.3746> <-4.3569, 12.4993, 12.4142> <-4.4080, 12.6165, 12.3831>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9022, 11.9165, 12.1916> <-3.9684, 11.9316, 12.1539> <-4.0530, 11.9550, 12.0959> <-4.1088, 11.9877, 12.0530>
		<-3.8581, 11.8643, 12.0630> <-3.9242, 11.8794, 12.0253> <-4.0193, 11.9060, 12.0011> <-4.0751, 11.9386, 11.9582>
		<-3.8456, 11.8785, 11.8572> <-3.9046, 11.8757, 11.8586> <-3.9808, 11.8834, 11.8166> <-4.0347, 11.9072, 11.8124>
		<-3.8159, 11.8857, 11.7147> <-3.8749, 11.8829, 11.7162> <-3.9578, 11.8787, 11.7072> <-4.0118, 11.9025, 11.7030>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8159, 11.8857, 11.7147> <-3.8749, 11.8829, 11.7162> <-3.9578, 11.8787, 11.7072> <-4.0118, 11.9025, 11.7030>
		<-3.8097, 11.8872, 11.6849> <-3.8687, 11.8844, 11.6863> <-3.9488, 11.8769, 11.6639> <-4.0027, 11.9006, 11.6597>
		<-3.7927, 11.9313, 11.6639> <-3.8590, 11.9118, 11.6729> <-3.9417, 11.9490, 11.6331> <-4.0080, 11.9558, 11.6131>
		<-3.7866, 11.9444, 11.6370> <-3.8528, 11.9249, 11.6460> <-3.9414, 11.9602, 11.5903> <-4.0077, 11.9670, 11.5702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7866, 11.9444, 11.6370> <-3.7824, 11.9534, 11.6185> <-3.7802, 11.9375, 11.5761> <-3.7825, 11.9568, 11.5683>
		<-3.7227, 11.9632, 11.6284> <-3.7185, 11.9722, 11.6099> <-3.7199, 11.9571, 11.5676> <-3.7222, 11.9764, 11.5598>
		<-3.7052, 12.0612, 11.5491> <-3.7019, 12.0618, 11.5552> <-3.6950, 12.0326, 11.5339> <-3.7017, 12.0333, 11.5352>
		<-3.6455, 12.0738, 11.5212> <-3.6422, 12.0744, 11.5272> <-3.6604, 12.0653, 11.5197> <-3.6671, 12.0660, 11.5211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7866, 11.9444, 11.6370> <-3.8528, 11.9249, 11.6460> <-3.9414, 11.9602, 11.5903> <-4.0077, 11.9670, 11.5702>
		<-3.7824, 11.9534, 11.6185> <-3.8486, 11.9338, 11.6275> <-3.9307, 11.9602, 11.5884> <-3.9970, 11.9670, 11.5684>
		<-3.7802, 11.9375, 11.5761> <-3.8492, 11.9150, 11.5859> <-3.9258, 11.9626, 11.5675> <-3.9826, 11.9656, 11.5663>
		<-3.7825, 11.9568, 11.5683> <-3.8516, 11.9344, 11.5780> <-3.9152, 11.9639, 11.5653> <-3.9721, 11.9669, 11.5641>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5543, 13.0334, 11.8208> <-4.5621, 13.0001, 11.9161> <-4.5529, 12.9714, 12.0555> <-4.5322, 12.9124, 12.1351>
		<-4.5554, 12.9665, 11.7602> <-4.5632, 12.9332, 11.8555> <-4.5677, 12.9163, 11.9588> <-4.5470, 12.8573, 12.0385>
		<-4.5294, 12.8935, 11.6650> <-4.5351, 12.8639, 11.7256> <-4.5485, 12.8303, 11.8396> <-4.5438, 12.7980, 11.8989>
		<-4.5123, 12.8369, 11.5968> <-4.5180, 12.8073, 11.6574> <-4.5382, 12.7760, 11.7419> <-4.5336, 12.7437, 11.8012>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5543, 13.0334, 11.8208> <-4.5554, 12.9665, 11.7602> <-4.5294, 12.8935, 11.6650> <-4.5123, 12.8369, 11.5968>
		<-4.5415, 13.0885, 11.6629> <-4.5425, 13.0216, 11.6023> <-4.5178, 12.9535, 11.5421> <-4.5008, 12.8969, 11.4738>
		<-4.4645, 13.1518, 11.4555> <-4.4772, 13.1019, 11.4275> <-4.4739, 13.0380, 11.3497> <-4.4714, 12.9900, 11.3163>
		<-4.4639, 13.2052, 11.2965> <-4.4766, 13.1554, 11.2685> <-4.4785, 13.0904, 11.2229> <-4.4760, 13.0424, 11.1895>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2309, 12.2208, 12.3183> <-4.2694, 12.2348, 12.2584> <-4.3148, 12.2689, 12.1779> <-4.3456, 12.3038, 12.1222>
		<-4.1874, 12.1293, 12.2703> <-4.2258, 12.1433, 12.2104> <-4.2779, 12.1980, 12.1455> <-4.3087, 12.2329, 12.0898>
		<-4.1427, 12.0368, 12.1479> <-4.1916, 12.0654, 12.1103> <-4.2327, 12.1145, 12.0332> <-4.2710, 12.1589, 11.9987>
		<-4.1088, 11.9877, 12.0530> <-4.1578, 12.0163, 12.0153> <-4.2075, 12.0732, 11.9618> <-4.2458, 12.1175, 11.9273>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2309, 12.2208, 12.3183> <-4.2819, 12.3281, 12.3746> <-4.3569, 12.4993, 12.4142> <-4.4080, 12.6165, 12.3831>
		<-4.2694, 12.2348, 12.2584> <-4.3204, 12.3421, 12.3147> <-4.3859, 12.4766, 12.3406> <-4.4369, 12.5938, 12.3095>
		<-4.3148, 12.2689, 12.1779> <-4.3503, 12.3370, 12.2090> <-4.4325, 12.5021, 12.2508> <-4.4596, 12.5654, 12.2046>
		<-4.3456, 12.3038, 12.1222> <-4.3810, 12.3719, 12.1533> <-4.4439, 12.4866, 12.1708> <-4.4709, 12.5499, 12.1246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1088, 11.9877, 12.0530> <-4.1578, 12.0163, 12.0153> <-4.2075, 12.0732, 11.9618> <-4.2458, 12.1175, 11.9273>
		<-4.0751, 11.9386, 11.9582> <-4.1240, 11.9673, 11.9206> <-4.1850, 12.0363, 11.8981> <-4.2234, 12.0807, 11.8636>
		<-4.0347, 11.9072, 11.8124> <-4.0988, 11.9354, 11.8075> <-4.1584, 12.0126, 11.7601> <-4.2059, 12.0643, 11.7600>
		<-4.0118, 11.9025, 11.7030> <-4.0759, 11.9307, 11.6980> <-4.1440, 11.9995, 11.6857> <-4.1916, 12.0512, 11.6856>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0118, 11.9025, 11.7030> <-4.0759, 11.9307, 11.6980> <-4.1440, 11.9995, 11.6857> <-4.1916, 12.0512, 11.6856>
		<-4.0027, 11.9006, 11.6597> <-4.0668, 11.9288, 11.6547> <-4.1373, 11.9934, 11.6508> <-4.1849, 12.0450, 11.6508>
		<-4.0080, 11.9558, 11.6131> <-4.0607, 11.9675, 11.6311> <-4.1355, 12.0083, 11.5977> <-4.1767, 12.0473, 11.6020>
		<-4.0077, 11.9670, 11.5702> <-4.0604, 11.9787, 11.5882> <-4.1350, 12.0149, 11.5624> <-4.1762, 12.0540, 11.5666>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0088, 12.0218, 11.2458> <-3.9781, 12.0119, 11.2272> <-3.9341, 12.0123, 11.1993> <-3.8998, 12.0194, 11.1869>
		<-4.0125, 12.0502, 11.1570> <-3.9819, 12.0404, 11.1384> <-3.9358, 12.0341, 11.1152> <-3.9015, 12.0412, 11.1027>
		<-4.0163, 12.1032, 11.0404> <-3.9857, 12.0892, 11.0210> <-3.9327, 12.0918, 11.0024> <-3.8953, 12.0887, 10.9923>
		<-4.0331, 12.1597, 10.9681> <-4.0026, 12.1457, 10.9486> <-3.9518, 12.1394, 10.9322> <-3.9145, 12.1363, 10.9222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0088, 12.0218, 11.2458> <-4.0048, 11.9917, 11.3397> <-4.0071, 11.9919, 11.4747> <-4.0077, 11.9670, 11.5702>
		<-3.9781, 12.0119, 11.2272> <-3.9742, 11.9819, 11.3211> <-3.9669, 11.9830, 11.4610> <-3.9675, 11.9580, 11.5566>
		<-3.9341, 12.0123, 11.1993> <-3.9324, 11.9906, 11.2829> <-3.9379, 11.9950, 11.4099> <-3.9394, 11.9832, 11.4955>
		<-3.8998, 12.0194, 11.1869> <-3.8981, 11.9977, 11.2705> <-3.9017, 12.0050, 11.3881> <-3.9033, 11.9933, 11.4737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0088, 12.0218, 11.2458> <-4.0125, 12.0502, 11.1570> <-4.0163, 12.1032, 11.0404> <-4.0331, 12.1597, 10.9681>
		<-4.0658, 12.0401, 11.2805> <-4.0696, 12.0685, 11.1917> <-4.0798, 12.1323, 11.0807> <-4.0966, 12.1888, 11.0084>
		<-4.1423, 12.0715, 11.3273> <-4.1506, 12.1110, 11.2480> <-4.1642, 12.1797, 11.1325> <-4.1755, 12.2378, 11.0660>
		<-4.1871, 12.1117, 11.3616> <-4.1954, 12.1512, 11.2823> <-4.2116, 12.2192, 11.1845> <-4.2228, 12.2773, 11.1179>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0088, 12.0218, 11.2458> <-4.0048, 11.9917, 11.3397> <-4.0071, 11.9919, 11.4747> <-4.0077, 11.9670, 11.5702>
		<-4.0658, 12.0401, 11.2805> <-4.0619, 12.0100, 11.3744> <-4.0598, 12.0036, 11.4927> <-4.0604, 11.9787, 11.5882>
		<-4.1423, 12.0715, 11.3273> <-4.1364, 12.0431, 11.3843> <-4.1342, 12.0267, 11.4995> <-4.1350, 12.0149, 11.5624>
		<-4.1871, 12.1117, 11.3616> <-4.1812, 12.0833, 11.4187> <-4.1754, 12.0657, 11.5037> <-4.1762, 12.0540, 11.5666>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0331, 12.1597, 10.9681> <-4.0478, 12.2089, 10.9051> <-4.0864, 12.2886, 10.8269> <-4.1105, 12.3637, 10.8079>
		<-4.0966, 12.1888, 11.0084> <-4.1113, 12.2379, 10.9454> <-4.1319, 12.3137, 10.8738> <-4.1560, 12.3888, 10.8549>
		<-4.1755, 12.2378, 11.0660> <-4.1844, 12.2838, 11.0133> <-4.2037, 12.3561, 10.9388> <-4.2180, 12.4219, 10.9179>
		<-4.2228, 12.2773, 11.1179> <-4.2317, 12.3233, 11.0653> <-4.2395, 12.3897, 10.9888> <-4.2537, 12.4554, 10.9680>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0331, 12.1597, 10.9681> <-4.0026, 12.1457, 10.9486> <-3.9518, 12.1394, 10.9322> <-3.9145, 12.1363, 10.9222>
		<-4.0478, 12.2089, 10.9051> <-4.0172, 12.1949, 10.8857> <-3.9711, 12.1875, 10.8614> <-3.9338, 12.1844, 10.8513>
		<-4.0864, 12.2886, 10.8269> <-4.0628, 12.2755, 10.8025> <-4.0209, 12.2597, 10.7779> <-3.9938, 12.2502, 10.7558>
		<-4.1105, 12.3637, 10.8079> <-4.0870, 12.3507, 10.7835> <-4.0512, 12.3383, 10.7530> <-4.0241, 12.3287, 10.7309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4718, 12.5582, 11.8703> <-4.4255, 12.4610, 11.8200> <-4.3722, 12.3334, 11.7388> <-4.3175, 12.2344, 11.7028>
		<-4.4729, 12.5619, 11.8432> <-4.4266, 12.4648, 11.7929> <-4.3691, 12.3338, 11.7077> <-4.3143, 12.2347, 11.6717>
		<-4.4716, 12.5662, 11.8068> <-4.4259, 12.4734, 11.7536> <-4.3725, 12.3471, 11.6710> <-4.3181, 12.2520, 11.6318>
		<-4.4728, 12.5723, 11.7802> <-4.4271, 12.4795, 11.7269> <-4.3748, 12.3581, 11.6418> <-4.3204, 12.2630, 11.6027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4718, 12.5582, 11.8703> <-4.4708, 12.5551, 11.8928> <-4.4678, 12.5512, 11.9228> <-4.4659, 12.5497, 11.9454>
		<-4.4255, 12.4610, 11.8200> <-4.4245, 12.4580, 11.8425> <-4.4314, 12.4645, 11.8914> <-4.4295, 12.4629, 11.9140>
		<-4.3722, 12.3334, 11.7388> <-4.3765, 12.3329, 11.7815> <-4.3787, 12.3264, 11.8095> <-4.3895, 12.3488, 11.8445>
		<-4.3175, 12.2344, 11.7028> <-4.3218, 12.2339, 11.7454> <-4.3337, 12.2380, 11.8058> <-4.3445, 12.2604, 11.8408>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4728, 12.5723, 11.7802> <-4.4271, 12.4795, 11.7269> <-4.3748, 12.3581, 11.6418> <-4.3204, 12.2630, 11.6027>
		<-4.4739, 12.5780, 11.7555> <-4.4282, 12.4852, 11.7023> <-4.3775, 12.3709, 11.6083> <-4.3230, 12.2758, 11.5691>
		<-4.4785, 12.5891, 11.7238> <-4.4349, 12.5038, 11.6622> <-4.3792, 12.3777, 11.5829> <-4.3288, 12.2939, 11.5245>
		<-4.4794, 12.5974, 11.7000> <-4.4358, 12.5122, 11.6384> <-4.3844, 12.3971, 11.5531> <-4.3340, 12.3134, 11.4947>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4794, 12.5974, 11.7000> <-4.4358, 12.5122, 11.6384> <-4.3844, 12.3971, 11.5531> <-4.3340, 12.3134, 11.4947>
		<-4.4802, 12.6057, 11.6766> <-4.4366, 12.5205, 11.6150> <-4.3932, 12.4306, 11.5019> <-4.3428, 12.3469, 11.4435>
		<-4.4800, 12.6161, 11.6448> <-4.4465, 12.5593, 11.5582> <-4.3962, 12.4471, 11.4530> <-4.3544, 12.3899, 11.3705>
		<-4.4785, 12.6277, 11.6229> <-4.4450, 12.5709, 11.5364> <-4.4086, 12.4958, 11.4169> <-4.3668, 12.4385, 11.3344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5123, 12.8369, 11.5968> <-4.5180, 12.8073, 11.6574> <-4.5382, 12.7760, 11.7419> <-4.5336, 12.7437, 11.8012>
		<-4.5017, 12.8018, 11.5545> <-4.5074, 12.7722, 11.6151> <-4.5322, 12.7441, 11.6845> <-4.5276, 12.7118, 11.7439>
		<-4.4750, 12.7533, 11.5018> <-4.4777, 12.7213, 11.5517> <-4.4914, 12.6903, 11.6241> <-4.4950, 12.6625, 11.6764>
		<-4.4625, 12.7284, 11.4532> <-4.4652, 12.6964, 11.5032> <-4.4749, 12.6555, 11.5706> <-4.4785, 12.6277, 11.6229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5123, 12.8369, 11.5968> <-4.5017, 12.8018, 11.5545> <-4.4750, 12.7533, 11.5018> <-4.4625, 12.7284, 11.4532>
		<-4.5008, 12.8969, 11.4738> <-4.4902, 12.8618, 11.4315> <-4.4694, 12.8183, 11.4007> <-4.4569, 12.7934, 11.3521>
		<-4.4714, 12.9900, 11.3163> <-4.4699, 12.9611, 11.2962> <-4.4546, 12.9258, 11.2502> <-4.4441, 12.9000, 11.2286>
		<-4.4760, 13.0424, 11.1895> <-4.4746, 13.0135, 11.1693> <-4.4613, 12.9769, 11.1415> <-4.4508, 12.9511, 11.1199>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2458, 12.1175, 11.9273> <-4.2234, 12.0807, 11.8636> <-4.2059, 12.0643, 11.7600> <-4.1916, 12.0512, 11.6856>
		<-4.2786, 12.1555, 11.8977> <-4.2562, 12.1186, 11.8341> <-4.2513, 12.1135, 11.7600> <-4.2369, 12.1004, 11.6856>
		<-4.3181, 12.2086, 11.8386> <-4.3073, 12.1862, 11.8036> <-4.2910, 12.1781, 11.7251> <-4.2867, 12.1786, 11.6824>
		<-4.3445, 12.2604, 11.8408> <-4.3337, 12.2380, 11.8058> <-4.3218, 12.2339, 11.7454> <-4.3175, 12.2344, 11.7028>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2458, 12.1175, 11.9273> <-4.2710, 12.1589, 11.9987> <-4.3087, 12.2329, 12.0898> <-4.3456, 12.3038, 12.1222>
		<-4.2786, 12.1555, 11.8977> <-4.3038, 12.1968, 11.9691> <-4.3320, 12.2595, 12.0475> <-4.3690, 12.3304, 12.0799>
		<-4.3181, 12.2086, 11.8386> <-4.3358, 12.2452, 11.8958> <-4.3675, 12.3311, 11.9982> <-4.3897, 12.3870, 12.0344>
		<-4.3445, 12.2604, 11.8408> <-4.3622, 12.2971, 11.8980> <-4.3864, 12.3667, 11.9606> <-4.4086, 12.4227, 11.9967>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1916, 12.0512, 11.6856> <-4.1849, 12.0450, 11.6508> <-4.1767, 12.0473, 11.6020> <-4.1762, 12.0540, 11.5666>
		<-4.2369, 12.1004, 11.6856> <-4.2302, 12.0942, 11.6508> <-4.2324, 12.1001, 11.6078> <-4.2320, 12.1067, 11.5724>
		<-4.2867, 12.1786, 11.6824> <-4.2835, 12.1789, 11.6514> <-4.2821, 12.1891, 11.6059> <-4.2844, 12.2002, 11.5768>
		<-4.3175, 12.2344, 11.7028> <-4.3143, 12.2347, 11.6717> <-4.3181, 12.2520, 11.6318> <-4.3204, 12.2630, 11.6027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1871, 12.1117, 11.3616> <-4.1954, 12.1512, 11.2823> <-4.2116, 12.2192, 11.1845> <-4.2228, 12.2773, 11.1179>
		<-4.2420, 12.1609, 11.4036> <-4.2503, 12.2004, 11.3243> <-4.2654, 12.2642, 11.2436> <-4.2767, 12.3223, 11.1771>
		<-4.2964, 12.2510, 11.4513> <-4.3053, 12.2845, 11.4001> <-4.3192, 12.3416, 11.3008> <-4.3316, 12.3902, 11.2648>
		<-4.3340, 12.3134, 11.4947> <-4.3428, 12.3469, 11.4435> <-4.3544, 12.3899, 11.3705> <-4.3668, 12.4385, 11.3344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1871, 12.1117, 11.3616> <-4.1812, 12.0833, 11.4187> <-4.1754, 12.0657, 11.5037> <-4.1762, 12.0540, 11.5666>
		<-4.2420, 12.1609, 11.4036> <-4.2361, 12.1325, 11.4607> <-4.2311, 12.1185, 11.5095> <-4.2320, 12.1067, 11.5724>
		<-4.2964, 12.2510, 11.4513> <-4.2913, 12.2315, 11.4810> <-4.2871, 12.2129, 11.5432> <-4.2844, 12.2002, 11.5768>
		<-4.3340, 12.3134, 11.4947> <-4.3288, 12.2939, 11.5245> <-4.3230, 12.2758, 11.5691> <-4.3204, 12.2630, 11.6027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2228, 12.2773, 11.1179> <-4.2317, 12.3233, 11.0653> <-4.2395, 12.3897, 10.9888> <-4.2537, 12.4554, 10.9680>
		<-4.2767, 12.3223, 11.1771> <-4.2856, 12.3683, 11.1244> <-4.2973, 12.4439, 11.0696> <-4.3115, 12.5097, 11.0488>
		<-4.3316, 12.3902, 11.2648> <-4.3460, 12.4472, 11.2225> <-4.3757, 12.5431, 11.1898> <-4.3809, 12.6027, 11.1491>
		<-4.3668, 12.4385, 11.3344> <-4.3813, 12.4955, 11.2921> <-4.4154, 12.5951, 11.2822> <-4.4206, 12.6547, 11.2415>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2537, 12.4554, 10.9680> <-4.2753, 12.5548, 10.9365> <-4.3175, 12.7286, 11.0287> <-4.3362, 12.8003, 10.9522>
		<-4.3115, 12.5097, 11.0488> <-4.3331, 12.6091, 11.0173> <-4.3406, 12.7450, 11.0557> <-4.3594, 12.8167, 10.9793>
		<-4.3809, 12.6027, 11.1491> <-4.3872, 12.6748, 11.0999> <-4.3814, 12.8016, 11.0926> <-4.3865, 12.8433, 11.0159>
		<-4.4206, 12.6547, 11.2415> <-4.4270, 12.7267, 11.1922> <-4.3991, 12.8250, 11.1186> <-4.4043, 12.8667, 11.0419>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2537, 12.4554, 10.9680> <-4.2180, 12.4219, 10.9179> <-4.1560, 12.3888, 10.8549> <-4.1105, 12.3637, 10.8079>
		<-4.2753, 12.5548, 10.9365> <-4.2395, 12.5213, 10.8864> <-4.1904, 12.4958, 10.8278> <-4.1449, 12.4707, 10.7808>
		<-4.3175, 12.7286, 11.0287> <-4.2843, 12.7049, 10.9898> <-4.2254, 12.6653, 10.9338> <-4.1883, 12.6480, 10.8951>
		<-4.3362, 12.8003, 10.9522> <-4.3030, 12.7766, 10.9133> <-4.2545, 12.7509, 10.8617> <-4.2173, 12.7335, 10.8231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0594, 12.8035, 12.7388> <-4.0048, 12.8289, 12.7553> <-3.9300, 12.8662, 12.7670> <-3.8728, 12.8912, 12.7667>
		<-4.1196, 12.9328, 12.7182> <-4.0650, 12.9582, 12.7348> <-3.9867, 12.9958, 12.7507> <-3.9295, 13.0208, 12.7504>
		<-4.1926, 13.0928, 12.6062> <-4.1371, 13.1212, 12.6256> <-4.0620, 13.1594, 12.6496> <-4.0021, 13.1855, 12.6493>
		<-4.2338, 13.1831, 12.5018> <-4.1783, 13.2116, 12.5212> <-4.1023, 13.2505, 12.5478> <-4.0425, 13.2766, 12.5475>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0594, 12.8035, 12.7388> <-4.1038, 12.7828, 12.7253> <-4.1603, 12.7581, 12.6944> <-4.1992, 12.7391, 12.6677>
		<-4.1196, 12.9328, 12.7182> <-4.1640, 12.9121, 12.7047> <-4.2170, 12.8843, 12.6710> <-4.2560, 12.8653, 12.6444>
		<-4.1926, 13.0928, 12.6062> <-4.2292, 13.0740, 12.5934> <-4.2813, 13.0484, 12.5647> <-4.3127, 13.0296, 12.5419>
		<-4.2338, 13.1831, 12.5018> <-4.2704, 13.1644, 12.4890> <-4.3162, 13.1390, 12.4634> <-4.3477, 13.1203, 12.4406>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3289, 13.3953, 12.0548> <-4.3250, 13.3532, 12.1999> <-4.2769, 13.2779, 12.3922> <-4.2338, 13.1831, 12.5018>
		<-4.2751, 13.4286, 12.0688> <-4.2711, 13.3865, 12.2140> <-4.2214, 13.3064, 12.4117> <-4.1783, 13.2116, 12.5212>
		<-4.2009, 13.4712, 12.0901> <-4.1839, 13.4342, 12.2399> <-4.1464, 13.3498, 12.4369> <-4.1023, 13.2505, 12.5478>
		<-4.1415, 13.4972, 12.0898> <-4.1244, 13.4602, 12.2396> <-4.0865, 13.3760, 12.4365> <-4.0425, 13.2766, 12.5475>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3289, 13.3953, 12.0548> <-4.3343, 13.4515, 11.8609> <-4.2588, 13.4564, 11.5899> <-4.2641, 13.5043, 11.3938>
		<-4.2751, 13.4286, 12.0688> <-4.2804, 13.4848, 11.8750> <-4.2335, 13.4762, 11.5918> <-4.2388, 13.5240, 11.3957>
		<-4.2009, 13.4712, 12.0901> <-4.2239, 13.5212, 11.8878> <-4.1833, 13.5066, 11.5993> <-4.2028, 13.5485, 11.3948>
		<-4.1415, 13.4972, 12.0898> <-4.1644, 13.5472, 11.8874> <-4.1538, 13.5195, 11.5991> <-4.1733, 13.5614, 11.3946>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7890, 12.0280, 11.4385> <-3.7572, 12.0382, 11.4391> <-3.7184, 12.0527, 11.4619> <-3.6905, 12.0617, 11.4780>
		<-3.7735, 12.0503, 11.3482> <-3.7418, 12.0605, 11.3488> <-3.7086, 12.0591, 11.3813> <-3.6808, 12.0680, 11.3974>
		<-3.7076, 12.0634, 11.2305> <-3.7038, 12.0579, 11.2561> <-3.6879, 12.0715, 11.2707> <-3.6704, 12.0638, 11.2890>
		<-3.7133, 12.0834, 11.1385> <-3.7096, 12.0779, 11.1641> <-3.6810, 12.0693, 11.1896> <-3.6636, 12.0615, 11.2078>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7890, 12.0280, 11.4385> <-3.7920, 12.0235, 11.4564> <-3.7740, 11.9971, 11.4715> <-3.7734, 11.9965, 11.4902>
		<-3.7572, 12.0382, 11.4391> <-3.7603, 12.0337, 11.4571> <-3.7488, 12.0048, 11.4719> <-3.7482, 12.0043, 11.4907>
		<-3.7184, 12.0527, 11.4619> <-3.7202, 12.0516, 11.4769> <-3.7225, 12.0193, 11.4988> <-3.7290, 12.0188, 11.5125>
		<-3.6905, 12.0617, 11.4780> <-3.6923, 12.0605, 11.4930> <-3.6949, 12.0373, 11.5068> <-3.7014, 12.0368, 11.5205>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7890, 12.0280, 11.4385> <-3.7735, 12.0503, 11.3482> <-3.7076, 12.0634, 11.2305> <-3.7133, 12.0834, 11.1385>
		<-3.8245, 12.0165, 11.4377> <-3.8091, 12.0388, 11.3474> <-3.7640, 12.0491, 11.2485> <-3.7697, 12.0691, 11.1565>
		<-3.8722, 12.0020, 11.4549> <-3.8706, 12.0137, 11.3693> <-3.8419, 12.0094, 11.2501> <-3.8436, 12.0311, 11.1665>
		<-3.9033, 11.9933, 11.4737> <-3.9017, 12.0050, 11.3881> <-3.8981, 11.9977, 11.2705> <-3.8998, 12.0194, 11.1869>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7890, 12.0280, 11.4385> <-3.8245, 12.0165, 11.4377> <-3.8722, 12.0020, 11.4549> <-3.9033, 11.9933, 11.4737>
		<-3.7920, 12.0235, 11.4564> <-3.8276, 12.0121, 11.4557> <-3.8724, 12.0001, 11.4690> <-3.9035, 11.9914, 11.4877>
		<-3.7740, 11.9971, 11.4715> <-3.8133, 11.9850, 11.4708> <-3.8649, 11.9787, 11.4887> <-3.9031, 11.9731, 11.5029>
		<-3.7734, 11.9965, 11.4902> <-3.8126, 11.9845, 11.4895> <-3.8677, 11.9798, 11.5026> <-3.9058, 11.9741, 11.5168>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6905, 12.0617, 11.4780> <-3.6923, 12.0605, 11.4930> <-3.6949, 12.0373, 11.5068> <-3.7014, 12.0368, 11.5205>
		<-3.6746, 12.0667, 11.4872> <-3.6764, 12.0656, 11.5021> <-3.6808, 12.0466, 11.5110> <-3.6873, 12.0461, 11.5246>
		<-3.6546, 12.0721, 11.5045> <-3.6513, 12.0727, 11.5105> <-3.6707, 12.0566, 11.5195> <-3.6774, 12.0573, 11.5209>
		<-3.6455, 12.0738, 11.5212> <-3.6422, 12.0744, 11.5272> <-3.6604, 12.0653, 11.5197> <-3.6671, 12.0660, 11.5211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6905, 12.0617, 11.4780> <-3.6746, 12.0667, 11.4872> <-3.6546, 12.0721, 11.5045> <-3.6455, 12.0738, 11.5212>
		<-3.6808, 12.0680, 11.3974> <-3.6648, 12.0731, 11.4066> <-3.6375, 12.0920, 11.4286> <-3.6284, 12.0937, 11.4453>
		<-3.6704, 12.0638, 11.2890> <-3.6523, 12.0558, 11.3079> <-3.6300, 12.0553, 11.3261> <-3.6088, 12.0445, 11.3397>
		<-3.6636, 12.0615, 11.2078> <-3.6455, 12.0535, 11.2268> <-3.6171, 12.0423, 11.2478> <-3.5960, 12.0315, 11.2614>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7014, 12.0368, 11.5205> <-3.7057, 12.0365, 11.5295> <-3.7136, 12.0526, 11.5326> <-3.7189, 12.0593, 11.5377>
		<-3.6873, 12.0461, 11.5246> <-3.6915, 12.0457, 11.5336> <-3.7023, 12.0589, 11.5346> <-3.7075, 12.0656, 11.5398>
		<-3.6774, 12.0573, 11.5209> <-3.6859, 12.0581, 11.5226> <-3.6925, 12.0690, 11.5299> <-3.6998, 12.0727, 11.5328>
		<-3.6671, 12.0660, 11.5211> <-3.6756, 12.0669, 11.5228> <-3.6843, 12.0747, 11.5278> <-3.6917, 12.0785, 11.5306>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7014, 12.0368, 11.5205> <-3.7290, 12.0188, 11.5125> <-3.7482, 12.0043, 11.4907> <-3.7734, 11.9965, 11.4902>
		<-3.7057, 12.0365, 11.5295> <-3.7333, 12.0184, 11.5215> <-3.7478, 12.0039, 11.5026> <-3.7730, 11.9962, 11.5021>
		<-3.7136, 12.0526, 11.5326> <-3.7400, 12.0379, 11.5278> <-3.7598, 12.0240, 11.5064> <-3.7825, 12.0170, 11.5066>
		<-3.7189, 12.0593, 11.5377> <-3.7452, 12.0447, 11.5330> <-3.7637, 12.0328, 11.5134> <-3.7863, 12.0258, 11.5136>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7734, 11.9965, 11.4902> <-3.8126, 11.9845, 11.4895> <-3.8677, 11.9798, 11.5026> <-3.9058, 11.9741, 11.5168>
		<-3.7730, 11.9962, 11.5021> <-3.8122, 11.9842, 11.5014> <-3.8697, 11.9806, 11.5128> <-3.9079, 11.9749, 11.5270>
		<-3.7825, 12.0170, 11.5066> <-3.8212, 12.0051, 11.5069> <-3.8756, 12.0028, 11.5224> <-3.9132, 11.9912, 11.5326>
		<-3.7863, 12.0258, 11.5136> <-3.8251, 12.0139, 11.5139> <-3.8788, 12.0101, 11.5292> <-3.9163, 11.9985, 11.5393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9721, 11.9669, 11.5641> <-3.9826, 11.9656, 11.5663> <-3.9970, 11.9670, 11.5684> <-4.0077, 11.9670, 11.5702>
		<-3.9522, 11.9691, 11.5499> <-3.9628, 11.9678, 11.5521> <-3.9568, 11.9580, 11.5547> <-3.9675, 11.9580, 11.5566>
		<-3.9286, 11.9708, 11.5252> <-3.9258, 11.9697, 11.5114> <-3.9397, 11.9813, 11.5095> <-3.9394, 11.9832, 11.4955>
		<-3.9058, 11.9741, 11.5168> <-3.9031, 11.9731, 11.5029> <-3.9035, 11.9914, 11.4877> <-3.9033, 11.9933, 11.4737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9721, 11.9669, 11.5641> <-3.9669, 11.9676, 11.5630> <-3.9608, 11.9714, 11.5609> <-3.9560, 11.9733, 11.5595>
		<-3.9522, 11.9691, 11.5499> <-3.9470, 11.9697, 11.5488> <-3.9489, 11.9789, 11.5548> <-3.9441, 11.9809, 11.5535>
		<-3.9286, 11.9708, 11.5252> <-3.9306, 11.9716, 11.5354> <-3.9274, 11.9868, 11.5364> <-3.9305, 11.9941, 11.5432>
		<-3.9058, 11.9741, 11.5168> <-3.9079, 11.9749, 11.5270> <-3.9132, 11.9912, 11.5326> <-3.9163, 11.9985, 11.5393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9721, 11.9669, 11.5641> <-3.9669, 11.9676, 11.5630> <-3.9608, 11.9714, 11.5609> <-3.9560, 11.9733, 11.5595>
		<-3.9152, 11.9639, 11.5653> <-3.9100, 11.9645, 11.5642> <-3.9122, 11.9809, 11.5768> <-3.9074, 11.9828, 11.5754>
		<-3.8516, 11.9344, 11.5780> <-3.8538, 11.9527, 11.5706> <-3.8524, 11.9659, 11.6059> <-3.8558, 11.9804, 11.6192>
		<-3.7825, 11.9568, 11.5683> <-3.7847, 11.9752, 11.5608> <-3.7905, 11.9905, 11.5992> <-3.7940, 12.0050, 11.6124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7825, 11.9568, 11.5683> <-3.7847, 11.9752, 11.5608> <-3.7905, 11.9905, 11.5992> <-3.7940, 12.0050, 11.6124>
		<-3.7222, 11.9764, 11.5598> <-3.7244, 11.9947, 11.5523> <-3.7369, 12.0118, 11.5933> <-3.7404, 12.0263, 11.6066>
		<-3.7017, 12.0333, 11.5352> <-3.7102, 12.0341, 11.5370> <-3.7150, 12.0527, 11.5523> <-3.7224, 12.0564, 11.5552>
		<-3.6671, 12.0660, 11.5211> <-3.6756, 12.0669, 11.5228> <-3.6843, 12.0747, 11.5278> <-3.6917, 12.0785, 11.5306>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4206, 12.6547, 11.2415> <-4.4447, 12.6861, 11.2973> <-4.4472, 12.6980, 11.3939> <-4.4625, 12.7284, 11.4532>
		<-4.4154, 12.5951, 11.2822> <-4.4395, 12.6265, 11.3380> <-4.4499, 12.6659, 11.4438> <-4.4652, 12.6964, 11.5032>
		<-4.3813, 12.4955, 11.2921> <-4.4230, 12.5528, 11.3746> <-4.4414, 12.5987, 11.4840> <-4.4749, 12.6555, 11.5706>
		<-4.3668, 12.4385, 11.3344> <-4.4086, 12.4958, 11.4169> <-4.4450, 12.5709, 11.5364> <-4.4785, 12.6277, 11.6229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4206, 12.6547, 11.2415> <-4.4270, 12.7267, 11.1922> <-4.3991, 12.8250, 11.1186> <-4.4043, 12.8667, 11.0419>
		<-4.4447, 12.6861, 11.2973> <-4.4510, 12.7582, 11.2481> <-4.4160, 12.8471, 11.1432> <-4.4211, 12.8889, 11.0665>
		<-4.4472, 12.6980, 11.3939> <-4.4416, 12.7630, 11.2928> <-4.4329, 12.8729, 11.2058> <-4.4397, 12.9239, 11.0970>
		<-4.4625, 12.7284, 11.4532> <-4.4569, 12.7934, 11.3521> <-4.4441, 12.9000, 11.2286> <-4.4508, 12.9511, 11.1199>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3456, 12.3038, 12.1222> <-4.3810, 12.3719, 12.1533> <-4.4439, 12.4866, 12.1708> <-4.4709, 12.5499, 12.1246>
		<-4.3690, 12.3304, 12.0799> <-4.4044, 12.3985, 12.1110> <-4.4480, 12.4810, 12.1419> <-4.4750, 12.5443, 12.0957>
		<-4.3897, 12.3870, 12.0344> <-4.4027, 12.4199, 12.0556> <-4.4444, 12.5100, 12.0472> <-4.4594, 12.5475, 12.0560>
		<-4.4086, 12.4227, 11.9967> <-4.4216, 12.4556, 12.0180> <-4.4436, 12.5100, 12.0174> <-4.4586, 12.5474, 12.0263>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4820, 11.9751, 11.1055> <-3.5011, 11.9667, 11.1056> <-3.5318, 11.9711, 11.1062> <-3.5514, 11.9781, 11.1073>
		<-3.4832, 11.9778, 11.0880> <-3.5023, 11.9694, 11.0881> <-3.5344, 11.9748, 11.0883> <-3.5540, 11.9818, 11.0893>
		<-3.4911, 11.9956, 11.0670> <-3.5092, 11.9877, 11.0671> <-3.5390, 12.0015, 11.0724> <-3.5578, 12.0073, 11.0739>
		<-3.4979, 12.0110, 11.0616> <-3.5160, 12.0031, 11.0617> <-3.5433, 12.0184, 11.0663> <-3.5621, 12.0242, 11.0678>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4820, 11.9751, 11.1055> <-3.4795, 11.9694, 11.1420> <-3.4857, 11.9820, 11.1916> <-3.4867, 11.9852, 11.2285>
		<-3.5011, 11.9667, 11.1056> <-3.4986, 11.9611, 11.1421> <-3.5007, 11.9755, 11.1917> <-3.5017, 11.9786, 11.2286>
		<-3.5318, 11.9711, 11.1062> <-3.5270, 11.9642, 11.1394> <-3.5273, 11.9839, 11.1902> <-3.5251, 11.9877, 11.2242>
		<-3.5514, 11.9781, 11.1073> <-3.5466, 11.9712, 11.1405> <-3.5423, 11.9889, 11.1861> <-3.5402, 11.9927, 11.2201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5514, 11.9781, 11.1073> <-3.5540, 11.9818, 11.0893> <-3.5578, 12.0073, 11.0739> <-3.5621, 12.0242, 11.0678>
		<-3.5688, 11.9842, 11.1082> <-3.5713, 11.9879, 11.0903> <-3.5813, 12.0145, 11.0758> <-3.5856, 12.0314, 11.0697>
		<-3.5830, 12.0077, 11.1108> <-3.5896, 12.0126, 11.0926> <-3.6078, 12.0306, 11.0798> <-3.6158, 12.0452, 11.0687>
		<-3.5991, 12.0167, 11.1119> <-3.6057, 12.0215, 11.0936> <-3.6304, 12.0393, 11.0841> <-3.6385, 12.0539, 11.0729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5514, 11.9781, 11.1073> <-3.5466, 11.9712, 11.1405> <-3.5423, 11.9889, 11.1861> <-3.5402, 11.9927, 11.2201>
		<-3.5688, 11.9842, 11.1082> <-3.5640, 11.9774, 11.1415> <-3.5596, 11.9946, 11.1813> <-3.5574, 11.9984, 11.2154>
		<-3.5830, 12.0077, 11.1108> <-3.5743, 12.0013, 11.1349> <-3.5774, 12.0099, 11.1800> <-3.5768, 12.0125, 11.2062>
		<-3.5991, 12.0167, 11.1119> <-3.5904, 12.0103, 11.1359> <-3.5931, 12.0176, 11.1732> <-3.5926, 12.0202, 11.1994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5991, 12.0167, 11.1119> <-3.6057, 12.0215, 11.0936> <-3.6304, 12.0393, 11.0841> <-3.6385, 12.0539, 11.0729>
		<-3.6211, 12.0290, 11.1134> <-3.6278, 12.0338, 11.0951> <-3.6445, 12.0448, 11.0867> <-3.6526, 12.0594, 11.0756>
		<-3.6552, 12.0360, 11.1133> <-3.6576, 12.0383, 11.1035> <-3.6709, 12.0608, 11.0885> <-3.6720, 12.0676, 11.0809>
		<-3.6772, 12.0482, 11.1156> <-3.6797, 12.0505, 11.1058> <-3.6824, 12.0641, 11.0982> <-3.6834, 12.0709, 11.0905>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5991, 12.0167, 11.1119> <-3.5904, 12.0103, 11.1359> <-3.5931, 12.0176, 11.1732> <-3.5926, 12.0202, 11.1994>
		<-3.6211, 12.0290, 11.1134> <-3.6124, 12.0226, 11.1374> <-3.6146, 12.0280, 11.1639> <-3.6140, 12.0306, 11.1901>
		<-3.6552, 12.0360, 11.1133> <-3.6514, 12.0325, 11.1282> <-3.6472, 12.0415, 11.1651> <-3.6449, 12.0437, 11.1805>
		<-3.6772, 12.0482, 11.1156> <-3.6734, 12.0446, 11.1305> <-3.6664, 12.0508, 11.1509> <-3.6641, 12.0530, 11.1664>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1105, 12.3637, 10.8079> <-4.0870, 12.3507, 10.7835> <-4.0512, 12.3383, 10.7530> <-4.0241, 12.3287, 10.7309>
		<-4.1449, 12.4707, 10.7808> <-4.1213, 12.4577, 10.7565> <-4.0919, 12.4438, 10.7196> <-4.0648, 12.4342, 10.6975>
		<-4.1883, 12.6480, 10.8951> <-4.1646, 12.6369, 10.8705> <-4.1317, 12.6220, 10.8349> <-4.1045, 12.6160, 10.8122>
		<-4.2173, 12.7335, 10.8231> <-4.1937, 12.7225, 10.7985> <-4.1613, 12.7118, 10.7645> <-4.1342, 12.7058, 10.7418>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5322, 12.9124, 12.1351> <-4.5073, 12.8415, 12.2308> <-4.4552, 12.7249, 12.3544> <-4.4080, 12.6165, 12.3831>
		<-4.5217, 12.9515, 12.2037> <-4.4968, 12.8806, 12.2994> <-4.4300, 12.7447, 12.4186> <-4.3828, 12.6363, 12.4473>
		<-4.4859, 13.0136, 12.2858> <-4.4514, 12.9252, 12.3861> <-4.3857, 12.7915, 12.4987> <-4.3325, 12.6666, 12.5243>
		<-4.4503, 13.0537, 12.3447> <-4.4158, 12.9654, 12.4451> <-4.3456, 12.8150, 12.5533> <-4.2925, 12.6901, 12.5789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5322, 12.9124, 12.1351> <-4.5073, 12.8415, 12.2308> <-4.4552, 12.7249, 12.3544> <-4.4080, 12.6165, 12.3831>
		<-4.5470, 12.8573, 12.0385> <-4.5221, 12.7863, 12.1342> <-4.4841, 12.7022, 12.2808> <-4.4369, 12.5938, 12.3095>
		<-4.5438, 12.7980, 11.8989> <-4.5359, 12.7434, 11.9994> <-4.4970, 12.6529, 12.1407> <-4.4596, 12.5654, 12.2046>
		<-4.5336, 12.7437, 11.8012> <-4.5257, 12.6891, 11.9017> <-4.5083, 12.6374, 12.0607> <-4.4709, 12.5499, 12.1246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5399, 11.9982, 11.2873> <-3.5588, 12.0053, 11.2812> <-3.5797, 12.0232, 11.2719> <-3.5960, 12.0315, 11.2614>
		<-3.5396, 11.9981, 11.2671> <-3.5585, 12.0051, 11.2610> <-3.5767, 12.0201, 11.2534> <-3.5929, 12.0284, 11.2430>
		<-3.5389, 11.9950, 11.2402> <-3.5562, 12.0007, 11.2354> <-3.5764, 12.0144, 11.2251> <-3.5922, 12.0221, 11.2182>
		<-3.5402, 11.9927, 11.2201> <-3.5574, 11.9984, 11.2154> <-3.5768, 12.0125, 11.2062> <-3.5926, 12.0202, 11.1994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5399, 11.9982, 11.2873> <-3.5411, 11.9989, 11.3584> <-3.5361, 12.0039, 11.4542> <-3.5451, 11.9954, 11.5242>
		<-3.5588, 12.0053, 11.2812> <-3.5600, 12.0059, 11.3523> <-3.5699, 12.0211, 11.4493> <-3.5789, 12.0126, 11.5194>
		<-3.5797, 12.0232, 11.2719> <-3.5926, 12.0362, 11.3501> <-3.5944, 12.1009, 11.4294> <-3.6115, 12.0810, 11.5053>
		<-3.5960, 12.0315, 11.2614> <-3.6088, 12.0445, 11.3397> <-3.6284, 12.0937, 11.4453> <-3.6455, 12.0738, 11.5212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5399, 11.9982, 11.2873> <-3.5396, 11.9981, 11.2671> <-3.5389, 11.9950, 11.2402> <-3.5402, 11.9927, 11.2201>
		<-3.5255, 11.9929, 11.2919> <-3.5251, 11.9927, 11.2717> <-3.5238, 11.9900, 11.2443> <-3.5251, 11.9877, 11.2242>
		<-3.5022, 11.9847, 11.2963> <-3.5020, 11.9841, 11.2759> <-3.5023, 11.9803, 11.2489> <-3.5017, 11.9786, 11.2286>
		<-3.4875, 11.9912, 11.2962> <-3.4873, 11.9906, 11.2758> <-3.4873, 11.9869, 11.2488> <-3.4867, 11.9852, 11.2285>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5399, 11.9982, 11.2873> <-3.5255, 11.9929, 11.2919> <-3.5022, 11.9847, 11.2963> <-3.4875, 11.9912, 11.2962>
		<-3.5411, 11.9989, 11.3584> <-3.5266, 11.9935, 11.3630> <-3.5030, 11.9870, 11.3705> <-3.4882, 11.9934, 11.3704>
		<-3.5361, 12.0039, 11.4542> <-3.5206, 11.9960, 11.4564> <-3.5058, 11.9875, 11.4694> <-3.4897, 11.9945, 11.4693>
		<-3.5451, 11.9954, 11.5242> <-3.5296, 11.9875, 11.5264> <-3.5060, 11.9877, 11.5436> <-3.4899, 11.9947, 11.5435>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5960, 12.0315, 11.2614> <-3.5929, 12.0284, 11.2430> <-3.5922, 12.0221, 11.2182> <-3.5926, 12.0202, 11.1994>
		<-3.6171, 12.0423, 11.2478> <-3.6141, 12.0392, 11.2294> <-3.6136, 12.0325, 11.2089> <-3.6140, 12.0306, 11.1901>
		<-3.6455, 12.0535, 11.2268> <-3.6444, 12.0532, 11.2141> <-3.6431, 12.0455, 11.1930> <-3.6449, 12.0437, 11.1805>
		<-3.6636, 12.0615, 11.2078> <-3.6625, 12.0612, 11.1952> <-3.6623, 12.0548, 11.1788> <-3.6641, 12.0530, 11.1664>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6636, 12.0615, 11.2078> <-3.6625, 12.0612, 11.1952> <-3.6623, 12.0548, 11.1788> <-3.6641, 12.0530, 11.1664>
		<-3.6810, 12.0693, 11.1896> <-3.6799, 12.0689, 11.1769> <-3.6753, 12.0611, 11.1692> <-3.6771, 12.0593, 11.1567>
		<-3.7096, 12.0779, 11.1641> <-3.7023, 12.0797, 11.1618> <-3.6980, 12.0719, 11.1419> <-3.6929, 12.0669, 11.1386>
		<-3.7133, 12.0834, 11.1385> <-3.7060, 12.0852, 11.1362> <-3.7022, 12.0758, 11.1255> <-3.6971, 12.0708, 11.1222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1992, 12.7391, 12.6677> <-4.2308, 12.7238, 12.6460> <-4.2694, 12.7037, 12.6104> <-4.2925, 12.6901, 12.5789>
		<-4.2560, 12.8653, 12.6444> <-4.2876, 12.8500, 12.6227> <-4.3225, 12.8286, 12.5848> <-4.3456, 12.8150, 12.5533>
		<-4.3127, 13.0296, 12.5419> <-4.3467, 13.0093, 12.5173> <-4.3949, 12.9888, 12.4796> <-4.4158, 12.9654, 12.4451>
		<-4.3477, 13.1203, 12.4406> <-4.3816, 13.1000, 12.4160> <-4.4295, 13.0772, 12.3792> <-4.4503, 13.0537, 12.3447>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4318, 12.0898, 11.1110> <-3.4302, 12.0981, 11.0931> <-3.4287, 12.1278, 11.0828> <-3.4356, 12.1426, 11.0718>
		<-3.4261, 12.1128, 11.1122> <-3.4244, 12.1211, 11.0943> <-3.4237, 12.1411, 11.0853> <-3.4306, 12.1560, 11.0742>
		<-3.4135, 12.1423, 11.1120> <-3.4135, 12.1457, 11.1023> <-3.4220, 12.1698, 11.0875> <-3.4262, 12.1753, 11.0798>
		<-3.4090, 12.1654, 11.1141> <-3.4089, 12.1688, 11.1044> <-3.4174, 12.1799, 11.0968> <-3.4216, 12.1854, 11.0891>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4318, 12.0898, 11.1110> <-3.4261, 12.1128, 11.1122> <-3.4135, 12.1423, 11.1120> <-3.4090, 12.1654, 11.1141>
		<-3.4339, 12.0786, 11.1352> <-3.4282, 12.1016, 11.1364> <-3.4136, 12.1370, 11.1270> <-3.4090, 12.1602, 11.1291>
		<-3.4434, 12.0830, 11.1721> <-3.4366, 12.1060, 11.1626> <-3.4251, 12.1386, 11.1638> <-3.4185, 12.1591, 11.1495>
		<-3.4470, 12.0838, 11.1986> <-3.4401, 12.1068, 11.1891> <-3.4284, 12.1384, 11.1793> <-3.4219, 12.1589, 11.1650>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5801, 12.0902, 11.0670> <-3.5672, 12.0917, 11.0678> <-3.5525, 12.1010, 11.0592> <-3.5405, 12.1062, 11.0591>
		<-3.5883, 12.1130, 11.0279> <-3.5754, 12.1145, 11.0287> <-3.5651, 12.1296, 11.0228> <-3.5532, 12.1348, 11.0228>
		<-3.5904, 12.1027, 10.9607> <-3.5758, 12.1044, 10.9605> <-3.5631, 12.1214, 10.9497> <-3.5497, 12.1273, 10.9496>
		<-3.5941, 12.1127, 10.9159> <-3.5796, 12.1143, 10.9157> <-3.5668, 12.1303, 10.9027> <-3.5534, 12.1362, 10.9027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5801, 12.0902, 11.0670> <-3.5764, 12.0801, 11.0844> <-3.5669, 12.0430, 11.0611> <-3.5621, 12.0242, 11.0678>
		<-3.5672, 12.0917, 11.0678> <-3.5635, 12.0815, 11.0853> <-3.5481, 12.0372, 11.0596> <-3.5433, 12.0184, 11.0663>
		<-3.5525, 12.1010, 11.0592> <-3.5442, 12.0823, 11.0829> <-3.5282, 12.0303, 11.0520> <-3.5160, 12.0031, 11.0617>
		<-3.5405, 12.1062, 11.0591> <-3.5322, 12.0875, 11.0828> <-3.5101, 12.0382, 11.0519> <-3.4979, 12.0110, 11.0616>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8998, 12.0194, 11.1869> <-3.8436, 12.0311, 11.1665> <-3.7697, 12.0691, 11.1565> <-3.7133, 12.0834, 11.1385>
		<-3.9015, 12.0412, 11.1027> <-3.8453, 12.0529, 11.0823> <-3.7744, 12.0855, 11.0808> <-3.7180, 12.0998, 11.0628>
		<-3.8953, 12.0887, 10.9923> <-3.8683, 12.0865, 10.9851> <-3.8174, 12.1097, 10.9814> <-3.7902, 12.1118, 10.9752>
		<-3.9145, 12.1363, 10.9222> <-3.8875, 12.1341, 10.9149> <-3.8490, 12.1401, 10.9174> <-3.8218, 12.1422, 10.9111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9145, 12.1363, 10.9222> <-3.8875, 12.1341, 10.9149> <-3.8490, 12.1401, 10.9174> <-3.8218, 12.1422, 10.9111>
		<-3.9338, 12.1844, 10.8513> <-3.9068, 12.1821, 10.8440> <-3.8874, 12.1769, 10.8397> <-3.8602, 12.1791, 10.8334>
		<-3.9938, 12.2502, 10.7558> <-3.9708, 12.2420, 10.7370> <-3.9320, 12.2296, 10.7208> <-3.9078, 12.2234, 10.7028>
		<-4.0241, 12.3287, 10.7309> <-4.0011, 12.3206, 10.7121> <-3.9679, 12.3109, 10.6899> <-3.9437, 12.3048, 10.6718>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2424, 12.3069, 11.1833> <-3.2881, 12.2747, 11.1646> <-3.3632, 12.2468, 11.1543> <-3.4103, 12.2158, 11.1368>
		<-3.2579, 12.3226, 11.0994> <-3.3036, 12.2904, 11.0807> <-3.3723, 12.2614, 11.0784> <-3.4193, 12.2304, 11.0609>
		<-3.2919, 12.3528, 10.9887> <-3.3076, 12.3320, 10.9819> <-3.3575, 12.3116, 10.9765> <-3.3762, 12.2924, 10.9737>
		<-3.3143, 12.3988, 10.9187> <-3.3301, 12.3780, 10.9118> <-3.3592, 12.3553, 10.9121> <-3.3779, 12.3360, 10.9093>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1105, 12.8000, 11.8340> <-3.1454, 12.8928, 11.8377> <-3.2006, 13.0002, 11.9073> <-3.2392, 13.0860, 11.9387>
		<-3.1248, 12.8381, 11.8912> <-3.1597, 12.9309, 11.8948> <-3.2002, 12.9978, 11.9315> <-3.2388, 13.0836, 11.9629>
		<-3.1569, 12.9043, 11.9538> <-3.1714, 12.9366, 11.9751> <-3.2212, 13.0441, 11.9865> <-3.2377, 13.0809, 11.9953>
		<-3.1815, 12.9592, 11.9900> <-3.1959, 12.9915, 12.0113> <-3.2201, 13.0449, 12.0108> <-3.2367, 13.0817, 12.0197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3445, 12.2604, 11.8408> <-4.3622, 12.2971, 11.8980> <-4.3864, 12.3667, 11.9606> <-4.4086, 12.4227, 11.9967>
		<-4.3895, 12.3488, 11.8445> <-4.4072, 12.3854, 11.9017> <-4.3994, 12.3996, 11.9818> <-4.4216, 12.4556, 12.0180>
		<-4.4295, 12.4629, 11.9140> <-4.4275, 12.4612, 11.9382> <-4.4429, 12.5100, 11.9931> <-4.4436, 12.5100, 12.0174>
		<-4.4659, 12.5497, 11.9454> <-4.4639, 12.5480, 11.9696> <-4.4579, 12.5474, 12.0019> <-4.4586, 12.5474, 12.0263>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0241, 12.3287, 10.7309> <-4.0011, 12.3206, 10.7121> <-3.9679, 12.3109, 10.6899> <-3.9437, 12.3048, 10.6718>
		<-4.0648, 12.4342, 10.6975> <-4.0418, 12.4261, 10.6787> <-4.0155, 12.4187, 10.6488> <-3.9913, 12.4126, 10.6308>
		<-4.1045, 12.6160, 10.8122> <-4.0866, 12.6120, 10.7972> <-4.0550, 12.6025, 10.7793> <-4.0341, 12.6028, 10.7681>
		<-4.1342, 12.7058, 10.7418> <-4.1162, 12.7019, 10.7269> <-4.0892, 12.7003, 10.7098> <-4.0683, 12.7006, 10.6986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4355, 12.2004, 11.0654> <-3.4365, 12.1956, 11.0734> <-3.4254, 12.1904, 11.0821> <-3.4216, 12.1854, 11.0891>
		<-3.4234, 12.2098, 11.0829> <-3.4244, 12.2050, 11.0909> <-3.4220, 12.1977, 11.0888> <-3.4182, 12.1927, 11.0958>
		<-3.4113, 12.2216, 11.1144> <-3.4175, 12.2175, 11.1121> <-3.4112, 12.2063, 11.1140> <-3.4110, 12.1993, 11.1108>
		<-3.4103, 12.2158, 11.1368> <-3.4164, 12.2118, 11.1346> <-3.4113, 12.2029, 11.1238> <-3.4111, 12.1958, 11.1206>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4355, 12.2004, 11.0654> <-3.4300, 12.2286, 11.0184> <-3.4089, 12.2645, 10.9571> <-3.4006, 12.2924, 10.9103>
		<-3.4234, 12.2098, 11.0829> <-3.4179, 12.2379, 11.0358> <-3.4006, 12.2767, 10.9579> <-3.3923, 12.3046, 10.9111>
		<-3.4113, 12.2216, 11.1144> <-3.4203, 12.2362, 11.0385> <-3.3830, 12.2793, 10.9740> <-3.3847, 12.3229, 10.9096>
		<-3.4103, 12.2158, 11.1368> <-3.4193, 12.2304, 11.0609> <-3.3762, 12.2924, 10.9737> <-3.3779, 12.3360, 10.9093>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4090, 12.1654, 11.1141> <-3.4072, 12.1746, 11.1150> <-3.4109, 12.1873, 11.1168> <-3.4111, 12.1958, 11.1206>
		<-3.4090, 12.1654, 11.1141> <-3.4073, 12.1693, 11.1299> <-3.4109, 12.1815, 11.1334> <-3.4111, 12.1900, 11.1373>
		<-3.4090, 12.1654, 11.1141> <-3.4073, 12.1693, 11.1299> <-3.4140, 12.1731, 11.1398> <-3.4174, 12.1729, 11.1553>
		<-3.4090, 12.1654, 11.1141> <-3.4090, 12.1602, 11.1291> <-3.4185, 12.1591, 11.1495> <-3.4219, 12.1589, 11.1650>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4090, 12.1654, 11.1141> <-3.4089, 12.1688, 11.1044> <-3.4174, 12.1799, 11.0968> <-3.4216, 12.1854, 11.0891>
		<-3.4090, 12.1654, 11.1141> <-3.4072, 12.1780, 11.1052> <-3.4140, 12.1872, 11.1035> <-3.4182, 12.1927, 11.0958>
		<-3.4090, 12.1654, 11.1141> <-3.4072, 12.1780, 11.1052> <-3.4108, 12.1908, 11.1069> <-3.4110, 12.1993, 11.1108>
		<-3.4090, 12.1654, 11.1141> <-3.4072, 12.1746, 11.1150> <-3.4109, 12.1873, 11.1168> <-3.4111, 12.1958, 11.1206>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6840, 12.0918, 11.0668> <-3.6989, 12.0894, 11.0847> <-3.7166, 12.0882, 11.1159> <-3.7133, 12.0834, 11.1385>
		<-3.6802, 12.0890, 11.0750> <-3.6951, 12.0866, 11.0929> <-3.7093, 12.0900, 11.1135> <-3.7060, 12.0852, 11.1362>
		<-3.6844, 12.0772, 11.0835> <-3.6922, 12.0794, 11.0900> <-3.7047, 12.0781, 11.1157> <-3.7022, 12.0758, 11.1255>
		<-3.6834, 12.0709, 11.0905> <-3.6912, 12.0731, 11.0970> <-3.6996, 12.0731, 11.1124> <-3.6971, 12.0708, 11.1222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6840, 12.0918, 11.0668> <-3.7076, 12.1091, 11.0155> <-3.7468, 12.1217, 10.9479> <-3.7727, 12.1366, 10.8970>
		<-3.6989, 12.0894, 11.0847> <-3.7225, 12.1068, 11.0335> <-3.7620, 12.1245, 10.9488> <-3.7878, 12.1394, 10.8978>
		<-3.7166, 12.0882, 11.1159> <-3.7213, 12.1046, 11.0401> <-3.7754, 12.1101, 10.9709> <-3.8071, 12.1405, 10.9069>
		<-3.7133, 12.0834, 11.1385> <-3.7180, 12.0998, 11.0628> <-3.7902, 12.1118, 10.9752> <-3.8218, 12.1422, 10.9111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8834, 12.2927, 10.6258> <-3.9230, 12.4094, 10.5861> <-3.9583, 12.6036, 10.7343> <-3.9937, 12.7081, 10.6665>
		<-3.9021, 12.2954, 10.6390> <-3.9417, 12.4121, 10.5993> <-3.9811, 12.6003, 10.7427> <-4.0165, 12.7048, 10.6748>
		<-3.9256, 12.3001, 10.6583> <-3.9732, 12.4079, 10.6173> <-4.0125, 12.6032, 10.7565> <-4.0467, 12.7010, 10.6871>
		<-3.9437, 12.3048, 10.6718> <-3.9913, 12.4126, 10.6308> <-4.0341, 12.6028, 10.7681> <-4.0683, 12.7006, 10.6986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8834, 12.2927, 10.6258> <-3.9021, 12.2954, 10.6390> <-3.9256, 12.3001, 10.6583> <-3.9437, 12.3048, 10.6718>
		<-3.8582, 12.2182, 10.6511> <-3.8769, 12.2209, 10.6643> <-3.8897, 12.2188, 10.6893> <-3.9078, 12.2234, 10.7028>
		<-3.8313, 12.1973, 10.7851> <-3.8392, 12.1928, 10.8011> <-3.8557, 12.1838, 10.8162> <-3.8602, 12.1791, 10.8334>
		<-3.8071, 12.1580, 10.8536> <-3.8150, 12.1535, 10.8696> <-3.8174, 12.1469, 10.8939> <-3.8218, 12.1422, 10.9111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8834, 12.2927, 10.6258> <-3.9230, 12.4094, 10.5861> <-3.9583, 12.6036, 10.7343> <-3.9937, 12.7081, 10.6665>
		<-3.8653, 12.2901, 10.6130> <-3.9049, 12.4068, 10.5733> <-3.9439, 12.6057, 10.7290> <-3.9793, 12.7102, 10.6612>
		<-3.8411, 12.2870, 10.5956> <-3.8857, 12.4125, 10.5676> <-3.9207, 12.6021, 10.7225> <-3.9595, 12.7147, 10.6566>
		<-3.8212, 12.2873, 10.5854> <-3.8659, 12.4128, 10.5573> <-3.9060, 12.6060, 10.7193> <-3.9449, 12.7187, 10.6534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8834, 12.2927, 10.6258> <-3.8582, 12.2182, 10.6511> <-3.8313, 12.1973, 10.7851> <-3.8071, 12.1580, 10.8536>
		<-3.8653, 12.2901, 10.6130> <-3.8401, 12.2156, 10.6384> <-3.8185, 12.2046, 10.7593> <-3.7943, 12.1653, 10.8278>
		<-3.8411, 12.2870, 10.5956> <-3.8188, 12.2244, 10.6096> <-3.7940, 12.2070, 10.7382> <-3.7739, 12.1739, 10.7939>
		<-3.8212, 12.2873, 10.5854> <-3.7990, 12.2247, 10.5994> <-3.7737, 12.2143, 10.7177> <-3.7536, 12.1812, 10.7734>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4590, 12.4784, 10.6233> <-3.4209, 12.4096, 10.6486> <-3.4220, 12.3757, 10.7823> <-3.4067, 12.3331, 10.8514>
		<-3.4691, 12.4639, 10.6112> <-3.4310, 12.3951, 10.6365> <-3.4391, 12.3700, 10.7565> <-3.4238, 12.3274, 10.8257>
		<-3.4810, 12.4443, 10.5935> <-3.4500, 12.3852, 10.6075> <-3.4584, 12.3539, 10.7371> <-3.4485, 12.3162, 10.7931>
		<-3.4939, 12.4304, 10.5837> <-3.4629, 12.3713, 10.5977> <-3.4791, 12.3432, 10.7160> <-3.4692, 12.3055, 10.7719>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4590, 12.4784, 10.6233> <-3.4691, 12.4639, 10.6112> <-3.4810, 12.4443, 10.5935> <-3.4939, 12.4304, 10.5837>
		<-3.5188, 12.5862, 10.5837> <-3.5289, 12.5717, 10.5716> <-3.5430, 12.5627, 10.5655> <-3.5559, 12.5487, 10.5556>
		<-3.6358, 12.7445, 10.7325> <-3.6481, 12.7345, 10.7268> <-3.6620, 12.7153, 10.7216> <-3.6759, 12.7064, 10.7182>
		<-3.6887, 12.8414, 10.6648> <-3.7009, 12.8314, 10.6591> <-3.7201, 12.8197, 10.6557> <-3.7340, 12.8109, 10.6522>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5068, 12.1509, 10.9153> <-3.5180, 12.1408, 10.9153> <-3.5395, 12.1423, 10.9026> <-3.5534, 12.1362, 10.9027>
		<-3.5048, 12.1402, 10.9601> <-3.5161, 12.1300, 10.9601> <-3.5358, 12.1334, 10.9495> <-3.5497, 12.1273, 10.9496>
		<-3.5159, 12.1448, 11.0273> <-3.5247, 12.1369, 11.0282> <-3.5424, 12.1396, 11.0227> <-3.5532, 12.1348, 11.0228>
		<-3.5055, 12.1228, 11.0666> <-3.5143, 12.1150, 11.0675> <-3.5297, 12.1110, 11.0590> <-3.5405, 12.1062, 11.0591>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8071, 12.1580, 10.8536> <-3.8150, 12.1535, 10.8696> <-3.8174, 12.1469, 10.8939> <-3.8218, 12.1422, 10.9111>
		<-3.8041, 12.1532, 10.8620> <-3.8121, 12.1487, 10.8780> <-3.8127, 12.1473, 10.8928> <-3.8171, 12.1426, 10.9100>
		<-3.7984, 12.1479, 10.8734> <-3.8044, 12.1483, 10.8782> <-3.8101, 12.1439, 10.8964> <-3.8158, 12.1434, 10.9015>
		<-3.7930, 12.1460, 10.8816> <-3.7990, 12.1464, 10.8864> <-3.8064, 12.1448, 10.8935> <-3.8121, 12.1443, 10.8986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8071, 12.1580, 10.8536> <-3.8041, 12.1532, 10.8620> <-3.7984, 12.1479, 10.8734> <-3.7930, 12.1460, 10.8816>
		<-3.7943, 12.1653, 10.8278> <-3.7913, 12.1605, 10.8361> <-3.7802, 12.1468, 10.8589> <-3.7747, 12.1448, 10.8671>
		<-3.7739, 12.1739, 10.7939> <-3.7671, 12.1626, 10.8130> <-3.7613, 12.1485, 10.8265> <-3.7519, 12.1396, 10.8458>
		<-3.7536, 12.1812, 10.7734> <-3.7468, 12.1698, 10.7925> <-3.7409, 12.1481, 10.8152> <-3.7315, 12.1392, 10.8344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6877, 12.2008, 10.7330> <-3.6783, 12.1863, 10.7566> <-3.6633, 12.1569, 10.7797> <-3.6516, 12.1430, 10.8027>
		<-3.7094, 12.1943, 10.7408> <-3.7000, 12.1798, 10.7644> <-3.6879, 12.1528, 10.7865> <-3.6762, 12.1389, 10.8095>
		<-3.7373, 12.1870, 10.7569> <-3.7305, 12.1757, 10.7760> <-3.7184, 12.1476, 10.8026> <-3.7090, 12.1387, 10.8218>
		<-3.7536, 12.1812, 10.7734> <-3.7468, 12.1698, 10.7925> <-3.7409, 12.1481, 10.8152> <-3.7315, 12.1392, 10.8344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6877, 12.2008, 10.7330> <-3.6608, 12.2088, 10.7232> <-3.6214, 12.2166, 10.7158> <-3.5942, 12.2285, 10.7156>
		<-3.6783, 12.1863, 10.7566> <-3.6514, 12.1943, 10.7468> <-3.6144, 12.2014, 10.7405> <-3.5871, 12.2133, 10.7403>
		<-3.6633, 12.1569, 10.7797> <-3.6378, 12.1612, 10.7727> <-3.5983, 12.1716, 10.7644> <-3.5738, 12.1823, 10.7643>
		<-3.6516, 12.1430, 10.8027> <-3.6262, 12.1472, 10.7956> <-3.5913, 12.1560, 10.7889> <-3.5667, 12.1667, 10.7888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5942, 12.2285, 10.7156> <-3.5708, 12.2388, 10.7154> <-3.5436, 12.2602, 10.7228> <-3.5233, 12.2727, 10.7320>
		<-3.5871, 12.2133, 10.7403> <-3.5637, 12.2235, 10.7402> <-3.5387, 12.2438, 10.7464> <-3.5184, 12.2563, 10.7555>
		<-3.5738, 12.1823, 10.7643> <-3.5510, 12.1923, 10.7641> <-3.5203, 12.2125, 10.7717> <-3.5018, 12.2276, 10.7787>
		<-3.5667, 12.1667, 10.7888> <-3.5439, 12.1767, 10.7886> <-3.5158, 12.1953, 10.7948> <-3.4973, 12.2105, 10.8018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5233, 12.2727, 10.7320> <-3.5054, 12.2837, 10.7400> <-3.4839, 12.2979, 10.7568> <-3.4692, 12.3055, 10.7719>
		<-3.5184, 12.2563, 10.7555> <-3.5006, 12.2673, 10.7635> <-3.4806, 12.2851, 10.7758> <-3.4658, 12.2927, 10.7909>
		<-3.5018, 12.2276, 10.7787> <-3.4847, 12.2416, 10.7852> <-3.4651, 12.2608, 10.8008> <-3.4516, 12.2747, 10.8133>
		<-3.4973, 12.2105, 10.8018> <-3.4802, 12.2245, 10.8083> <-3.4634, 12.2485, 10.8203> <-3.4499, 12.2624, 10.8328>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4067, 12.3331, 10.8514> <-3.4041, 12.3257, 10.8633> <-3.3992, 12.3184, 10.8805> <-3.3993, 12.3120, 10.8931>
		<-3.4238, 12.3274, 10.8257> <-3.4212, 12.3200, 10.8375> <-3.4145, 12.3034, 10.8626> <-3.4146, 12.2970, 10.8753>
		<-3.4485, 12.3162, 10.7931> <-3.4452, 12.3034, 10.8120> <-3.4353, 12.2916, 10.8285> <-3.4336, 12.2793, 10.8480>
		<-3.4692, 12.3055, 10.7719> <-3.4658, 12.2927, 10.7909> <-3.4516, 12.2747, 10.8133> <-3.4499, 12.2624, 10.8328>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4067, 12.3331, 10.8514> <-3.3961, 12.3366, 10.8673> <-3.3865, 12.3351, 10.8919> <-3.3779, 12.3360, 10.9093>
		<-3.4041, 12.3257, 10.8633> <-3.3935, 12.3293, 10.8792> <-3.3892, 12.3324, 10.8915> <-3.3806, 12.3333, 10.9089>
		<-3.3992, 12.3184, 10.8805> <-3.3951, 12.3224, 10.8852> <-3.3868, 12.3241, 10.9043> <-3.3826, 12.3282, 10.9088>
		<-3.3993, 12.3120, 10.8931> <-3.3953, 12.3160, 10.8979> <-3.3896, 12.3216, 10.9036> <-3.3854, 12.3257, 10.9080>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5055, 12.1228, 11.0666> <-3.5008, 12.1130, 11.0842> <-3.4769, 12.0825, 11.0605> <-3.4665, 12.0660, 11.0673>
		<-3.5143, 12.1150, 11.0675> <-3.5096, 12.1051, 11.0851> <-3.4851, 12.0653, 11.0592> <-3.4747, 12.0488, 11.0660>
		<-3.5297, 12.1110, 11.0590> <-3.5214, 12.0923, 11.0828> <-3.4926, 12.0458, 11.0518> <-3.4805, 12.0186, 11.0615>
		<-3.5405, 12.1062, 11.0591> <-3.5322, 12.0875, 11.0828> <-3.5101, 12.0382, 11.0519> <-3.4979, 12.0110, 11.0616>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6772, 12.0482, 11.1156> <-3.6797, 12.0505, 11.1058> <-3.6824, 12.0641, 11.0982> <-3.6834, 12.0709, 11.0905>
		<-3.6772, 12.0482, 11.1156> <-3.6877, 12.0549, 11.1067> <-3.6901, 12.0663, 11.1047> <-3.6912, 12.0731, 11.0970>
		<-3.6772, 12.0482, 11.1156> <-3.6877, 12.0549, 11.1067> <-3.6935, 12.0672, 11.1086> <-3.6996, 12.0731, 11.1124>
		<-3.6772, 12.0482, 11.1156> <-3.6853, 12.0526, 11.1164> <-3.6910, 12.0649, 11.1184> <-3.6971, 12.0708, 11.1222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6772, 12.0482, 11.1156> <-3.6734, 12.0446, 11.1305> <-3.6664, 12.0508, 11.1509> <-3.6641, 12.0530, 11.1664>
		<-3.6772, 12.0482, 11.1156> <-3.6815, 12.0491, 11.1313> <-3.6794, 12.0571, 11.1413> <-3.6771, 12.0593, 11.1567>
		<-3.6772, 12.0482, 11.1156> <-3.6815, 12.0491, 11.1313> <-3.6869, 12.0610, 11.1348> <-3.6929, 12.0669, 11.1386>
		<-3.6772, 12.0482, 11.1156> <-3.6853, 12.0526, 11.1164> <-3.6910, 12.0649, 11.1184> <-3.6971, 12.0708, 11.1222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1733, 13.5614, 11.3946> <-4.1466, 13.5731, 11.3945> <-4.1079, 13.5808, 11.3949> <-4.0791, 13.5852, 11.3928>
		<-4.1969, 13.6121, 11.1475> <-4.1702, 13.6238, 11.1473> <-4.1500, 13.6256, 11.1476> <-4.1212, 13.6300, 11.1455>
		<-4.2454, 13.7175, 10.8283> <-4.2209, 13.7282, 10.8281> <-4.1968, 13.7305, 10.8261> <-4.1706, 13.7348, 10.8233>
		<-4.2843, 13.8039, 10.5933> <-4.2598, 13.8146, 10.5931> <-4.2247, 13.8229, 10.5903> <-4.1985, 13.8272, 10.5875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1733, 13.5614, 11.3946> <-4.1969, 13.6121, 11.1475> <-4.2454, 13.7175, 10.8283> <-4.2843, 13.8039, 10.5933>
		<-4.2028, 13.5485, 11.3948> <-4.2264, 13.5992, 11.1476> <-4.2725, 13.7057, 10.8284> <-4.3113, 13.7921, 10.5934>
		<-4.2388, 13.5240, 11.3957> <-4.2454, 13.5844, 11.1483> <-4.2937, 13.6898, 10.8272> <-4.3449, 13.7707, 10.5911>
		<-4.2641, 13.5043, 11.3938> <-4.2708, 13.5646, 11.1463> <-4.3172, 13.6720, 10.8245> <-4.3683, 13.7529, 10.5884>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2641, 13.5043, 11.3938> <-4.2708, 13.5646, 11.1463> <-4.3172, 13.6720, 10.8245> <-4.3683, 13.7529, 10.5884>
		<-4.2942, 13.4808, 11.3915> <-4.3009, 13.5411, 11.1440> <-4.3450, 13.6509, 10.8213> <-4.3962, 13.7317, 10.5852>
		<-4.3293, 13.4440, 11.3845> <-4.3345, 13.5046, 11.1362> <-4.3641, 13.6235, 10.8140> <-4.4285, 13.6982, 10.5781>
		<-4.3572, 13.4181, 11.3806> <-4.3625, 13.4788, 11.1323> <-4.3899, 13.6001, 10.8096> <-4.4543, 13.6747, 10.5737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3572, 13.4181, 11.3806> <-4.3625, 13.4788, 11.1323> <-4.3899, 13.6001, 10.8096> <-4.4543, 13.6747, 10.5737>
		<-4.3698, 13.3960, 11.3741> <-4.3751, 13.4566, 11.1258> <-4.4014, 13.5797, 10.8040> <-4.4658, 13.6543, 10.5681>
		<-4.3881, 13.3664, 11.3678> <-4.3858, 13.4316, 11.1209> <-4.4115, 13.5566, 10.7956> <-4.4828, 13.6277, 10.5610>
		<-4.3992, 13.3443, 11.3590> <-4.3969, 13.4094, 11.1122> <-4.4214, 13.5355, 10.7894> <-4.4927, 13.6066, 10.5548>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3992, 13.3443, 11.3590> <-4.3969, 13.4094, 11.1122> <-4.4214, 13.5355, 10.7894> <-4.4927, 13.6066, 10.5548>
		<-4.4202, 13.3024, 11.3425> <-4.4179, 13.3675, 11.0956> <-4.4400, 13.4959, 10.7778> <-4.5113, 13.5670, 10.5432>
		<-4.4532, 13.2475, 11.3203> <-4.4522, 13.3270, 11.0840> <-4.4595, 13.4509, 10.7556> <-4.5406, 13.5147, 10.5286>
		<-4.4639, 13.2052, 11.2965> <-4.4630, 13.2847, 11.0602> <-4.4682, 13.4088, 10.7413> <-4.5492, 13.4726, 10.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4639, 13.2052, 11.2965> <-4.4630, 13.2847, 11.0602> <-4.4682, 13.4088, 10.7413> <-4.5492, 13.4726, 10.5144>
		<-4.4766, 13.1554, 11.2685> <-4.4757, 13.2348, 11.0322> <-4.4782, 13.3601, 10.7249> <-4.5593, 13.4239, 10.4979>
		<-4.4785, 13.0904, 11.2229> <-4.4865, 13.1804, 11.0051> <-4.4739, 13.3004, 10.6857> <-4.5583, 13.3576, 10.4730>
		<-4.4760, 13.0424, 11.1895> <-4.4840, 13.1324, 10.9717> <-4.4696, 13.2518, 10.6668> <-4.5540, 13.3089, 10.4542>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4760, 13.0424, 11.1895> <-4.4840, 13.1324, 10.9717> <-4.4696, 13.2518, 10.6668> <-4.5540, 13.3089, 10.4542>
		<-4.4746, 13.0135, 11.1693> <-4.4825, 13.1034, 10.9515> <-4.4670, 13.2226, 10.6555> <-4.5514, 13.2798, 10.4429>
		<-4.4613, 12.9769, 11.1415> <-4.4740, 13.0732, 10.9363> <-4.4548, 13.1879, 10.6309> <-4.5377, 13.2427, 10.4268>
		<-4.4508, 12.9511, 11.1199> <-4.4634, 13.0474, 10.9146> <-4.4437, 13.1610, 10.6190> <-4.5266, 13.2159, 10.4149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4508, 12.9511, 11.1199> <-4.4634, 13.0474, 10.9146> <-4.4437, 13.1610, 10.6190> <-4.5266, 13.2159, 10.4149>
		<-4.4397, 12.9239, 11.0970> <-4.4523, 13.0203, 10.8918> <-4.4321, 13.1331, 10.6066> <-4.5150, 13.1879, 10.4025>
		<-4.4211, 12.8889, 11.0665> <-4.4338, 12.9921, 10.8769> <-4.4173, 13.0986, 10.5801> <-4.4963, 13.1518, 10.3859>
		<-4.4043, 12.8667, 11.0419> <-4.4170, 12.9700, 10.8522> <-4.3998, 13.0739, 10.5679> <-4.4788, 13.1271, 10.3737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4043, 12.8667, 11.0419> <-4.4170, 12.9700, 10.8522> <-4.3998, 13.0739, 10.5679> <-4.4788, 13.1271, 10.3737>
		<-4.3865, 12.8433, 11.0159> <-4.3992, 12.9466, 10.8263> <-4.3819, 13.0487, 10.5555> <-4.4609, 13.1019, 10.3613>
		<-4.3594, 12.8167, 10.9793> <-4.3948, 12.9524, 10.8346> <-4.3601, 13.0202, 10.5262> <-4.4319, 13.0717, 10.3452>
		<-4.3362, 12.8003, 10.9522> <-4.3717, 12.9359, 10.8076> <-4.3374, 12.9989, 10.5144> <-4.4092, 13.0504, 10.3334>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3362, 12.8003, 10.9522> <-4.3717, 12.9359, 10.8076> <-4.3374, 12.9989, 10.5144> <-4.4092, 13.0504, 10.3334>
		<-4.3030, 12.7766, 10.9133> <-4.3385, 12.9122, 10.7687> <-4.3121, 12.9751, 10.5013> <-4.3840, 13.0266, 10.3203>
		<-4.2545, 12.7509, 10.8617> <-4.2994, 12.8827, 10.7506> <-4.2819, 12.9455, 10.4602> <-4.3489, 12.9959, 10.3029>
		<-4.2173, 12.7335, 10.8231> <-4.2622, 12.8654, 10.7119> <-4.2523, 12.9267, 10.4482> <-4.3192, 12.9771, 10.2909>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2173, 12.7335, 10.8231> <-4.2622, 12.8654, 10.7119> <-4.2523, 12.9267, 10.4482> <-4.3192, 12.9771, 10.2909>
		<-4.1937, 12.7225, 10.7985> <-4.2386, 12.8543, 10.6873> <-4.2258, 12.9098, 10.4375> <-4.2927, 12.9602, 10.2802>
		<-4.1613, 12.7118, 10.7645> <-4.2022, 12.8356, 10.6675> <-4.1986, 12.8946, 10.4123> <-4.2530, 12.9439, 10.2674>
		<-4.1342, 12.7058, 10.7418> <-4.1750, 12.8296, 10.6449> <-4.1689, 12.8830, 10.4030> <-4.2233, 12.9323, 10.2580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1342, 12.7058, 10.7418> <-4.1750, 12.8296, 10.6449> <-4.1689, 12.8830, 10.4030> <-4.2233, 12.9323, 10.2580>
		<-4.1162, 12.7019, 10.7269> <-4.1571, 12.8256, 10.6299> <-4.1496, 12.8754, 10.3969> <-4.2040, 12.9247, 10.2520>
		<-4.0892, 12.7003, 10.7098> <-4.1314, 12.8211, 10.6241> <-4.1298, 12.8685, 10.3829> <-4.1771, 12.9171, 10.2446>
		<-4.0683, 12.7006, 10.6986> <-4.1105, 12.8214, 10.6129> <-4.1092, 12.8646, 10.3780> <-4.1564, 12.9132, 10.2397>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0683, 12.7006, 10.6986> <-4.1105, 12.8214, 10.6129> <-4.1092, 12.8646, 10.3780> <-4.1564, 12.9132, 10.2397>
		<-4.0467, 12.7010, 10.6871> <-4.0889, 12.8218, 10.6013> <-4.0902, 12.8611, 10.3735> <-4.1374, 12.9096, 10.2351>
		<-4.0165, 12.7048, 10.6748> <-4.0569, 12.8240, 10.5974> <-4.0692, 12.8592, 10.3632> <-4.1113, 12.9076, 10.2300>
		<-3.9937, 12.7081, 10.6665> <-4.0341, 12.8273, 10.5890> <-4.0496, 12.8591, 10.3599> <-4.0917, 12.9075, 10.2267>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9937, 12.7081, 10.6665> <-4.0341, 12.8273, 10.5890> <-4.0496, 12.8591, 10.3599> <-4.0917, 12.9075, 10.2267>
		<-3.9793, 12.7102, 10.6612> <-4.0197, 12.8294, 10.5838> <-4.0333, 12.8591, 10.3571> <-4.0753, 12.9075, 10.2239>
		<-3.9595, 12.7147, 10.6566> <-4.0010, 12.8349, 10.5863> <-4.0181, 12.8599, 10.3529> <-4.0534, 12.9098, 10.2210>
		<-3.9449, 12.7187, 10.6534> <-3.9864, 12.8388, 10.5831> <-4.0019, 12.8629, 10.3512> <-4.0371, 12.9128, 10.2194>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9449, 12.7187, 10.6534> <-3.9864, 12.8388, 10.5831> <-4.0019, 12.8629, 10.3512> <-4.0371, 12.9128, 10.2194>
		<-3.9303, 12.7226, 10.6502> <-3.9718, 12.8428, 10.5799> <-3.9838, 12.8663, 10.3494> <-4.0191, 12.9162, 10.2176>
		<-3.9110, 12.7293, 10.6472> <-3.9544, 12.8499, 10.5823> <-3.9687, 12.8705, 10.3472> <-3.9955, 12.9235, 10.2164>
		<-3.8965, 12.7342, 10.6452> <-3.9398, 12.8547, 10.5803> <-3.9510, 12.8757, 10.3462> <-3.9778, 12.9286, 10.2153>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8965, 12.7342, 10.6452> <-3.9398, 12.8547, 10.5803> <-3.9510, 12.8757, 10.3462> <-3.9778, 12.9286, 10.2153>
		<-3.8776, 12.7405, 10.6426> <-3.9209, 12.8611, 10.5777> <-3.9334, 12.8809, 10.3451> <-3.9602, 12.9338, 10.2143>
		<-3.8519, 12.7478, 10.6382> <-3.9047, 12.8653, 10.5775> <-3.9153, 12.8845, 10.3420> <-3.9363, 12.9398, 10.2125>
		<-3.8335, 12.7558, 10.6381> <-3.8863, 12.8733, 10.5774> <-3.8984, 12.8919, 10.3419> <-3.9194, 12.9472, 10.2124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8335, 12.7558, 10.6381> <-3.8863, 12.8733, 10.5774> <-3.8984, 12.8919, 10.3419> <-3.9194, 12.9472, 10.2124>
		<-3.8138, 12.7645, 10.6380> <-3.8666, 12.8820, 10.5773> <-3.8799, 12.9000, 10.3418> <-3.9009, 12.9553, 10.2123>
		<-3.7890, 12.7790, 10.6419> <-3.8485, 12.8925, 10.5771> <-3.8633, 12.9107, 10.3440> <-3.8779, 12.9695, 10.2137>
		<-3.7703, 12.7893, 10.6446> <-3.8297, 12.9029, 10.5797> <-3.8460, 12.9211, 10.3449> <-3.8607, 12.9799, 10.2147>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7703, 12.7893, 10.6446> <-3.8297, 12.9029, 10.5797> <-3.8460, 12.9211, 10.3449> <-3.8607, 12.9799, 10.2147>
		<-3.7591, 12.7955, 10.6461> <-3.8186, 12.9091, 10.5813> <-3.8323, 12.9294, 10.3457> <-3.8469, 12.9882, 10.2155>
		<-3.7446, 12.8041, 10.6496> <-3.8065, 12.9153, 10.5794> <-3.8214, 12.9367, 10.3475> <-3.8289, 12.9998, 10.2168>
		<-3.7340, 12.8109, 10.6522> <-3.7959, 12.9220, 10.5821> <-3.8087, 12.9464, 10.3489> <-3.8161, 13.0094, 10.2182>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7340, 12.8109, 10.6522> <-3.7959, 12.9220, 10.5821> <-3.8087, 12.9464, 10.3489> <-3.8161, 13.0094, 10.2182>
		<-3.7201, 12.8197, 10.6557> <-3.7820, 12.9309, 10.5855> <-3.7942, 12.9574, 10.3506> <-3.8016, 13.0204, 10.2199>
		<-3.7009, 12.8314, 10.6591> <-3.7613, 12.9421, 10.5818> <-3.7812, 12.9675, 10.3535> <-3.7822, 13.0352, 10.2221>
		<-3.6887, 12.8414, 10.6648> <-3.7490, 12.9521, 10.5875> <-3.7690, 12.9807, 10.3564> <-3.7700, 13.0485, 10.2250>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6887, 12.8414, 10.6648> <-3.7490, 12.9521, 10.5875> <-3.7690, 12.9807, 10.3564> <-3.7700, 13.0485, 10.2250>
		<-3.6722, 12.8549, 10.6724> <-3.7326, 12.9655, 10.5951> <-3.7566, 12.9941, 10.3593> <-3.7577, 13.0619, 10.2279>
		<-3.6524, 12.8738, 10.6854> <-3.7143, 12.9858, 10.5998> <-3.7463, 13.0101, 10.3693> <-3.7443, 13.0821, 10.2332>
		<-3.6391, 12.8883, 10.6963> <-3.7010, 13.0004, 10.6107> <-3.7370, 13.0254, 10.3735> <-3.7349, 13.0975, 10.2374>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6391, 12.8883, 10.6963> <-3.7010, 13.0004, 10.6107> <-3.7370, 13.0254, 10.3735> <-3.7349, 13.0975, 10.2374>
		<-3.6251, 12.9035, 10.7077> <-3.6870, 13.0156, 10.6221> <-3.7259, 13.0436, 10.3784> <-3.7239, 13.1157, 10.2423>
		<-3.6076, 12.9244, 10.7243> <-3.6720, 13.0379, 10.6275> <-3.7161, 13.0618, 10.3911> <-3.7094, 13.1403, 10.2490>
		<-3.5981, 12.9402, 10.7389> <-3.6624, 13.0537, 10.6421> <-3.7090, 13.0815, 10.3972> <-3.7024, 13.1600, 10.2552>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5981, 12.9402, 10.7389> <-3.6624, 13.0537, 10.6421> <-3.7090, 13.0815, 10.3972> <-3.7024, 13.1600, 10.2552>
		<-3.5834, 12.9646, 10.7615> <-3.6477, 13.0781, 10.6647> <-3.6988, 13.1101, 10.4062> <-3.6922, 13.1886, 10.2641>
		<-3.5681, 12.9961, 10.7952> <-3.6382, 13.1168, 10.6843> <-3.6951, 13.1398, 10.4319> <-3.6840, 13.2279, 10.2774>
		<-3.5587, 13.0215, 10.8195> <-3.6288, 13.1421, 10.7086> <-3.6890, 13.1692, 10.4419> <-3.6779, 13.2573, 10.2873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5587, 13.0215, 10.8195> <-3.6288, 13.1421, 10.7086> <-3.6890, 13.1692, 10.4419> <-3.6779, 13.2573, 10.2873>
		<-3.5439, 13.0617, 10.8580> <-3.6140, 13.1823, 10.7471> <-3.6815, 13.2056, 10.4542> <-3.6704, 13.2937, 10.2997>
		<-3.5245, 13.1166, 10.9086> <-3.6014, 13.2341, 10.7642> <-3.6749, 13.2486, 10.4935> <-3.6593, 13.3424, 10.3159>
		<-3.5174, 13.1583, 10.9477> <-3.5942, 13.2758, 10.8033> <-3.6729, 13.2853, 10.5069> <-3.6573, 13.3791, 10.3293>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5174, 13.1583, 10.9477> <-3.5942, 13.2758, 10.8033> <-3.6729, 13.2853, 10.5069> <-3.6573, 13.3791, 10.3293>
		<-3.5125, 13.1867, 10.9743> <-3.5894, 13.3042, 10.8299> <-3.6713, 13.3166, 10.5182> <-3.6557, 13.4104, 10.3407>
		<-3.5143, 13.2247, 11.0111> <-3.5832, 13.3033, 10.8218> <-3.6784, 13.3517, 10.5476> <-3.6598, 13.4521, 10.3569>
		<-3.5192, 13.2537, 11.0370> <-3.5881, 13.3324, 10.8477> <-3.6846, 13.3820, 10.5599> <-3.6661, 13.4824, 10.3693>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5192, 13.2537, 11.0370> <-3.5881, 13.3324, 10.8477> <-3.6846, 13.3820, 10.5599> <-3.6661, 13.4824, 10.3693>
		<-3.5238, 13.2812, 11.0616> <-3.5927, 13.3599, 10.8723> <-3.6908, 13.4117, 10.5720> <-3.6722, 13.5122, 10.3814>
		<-3.5366, 13.3188, 11.0921> <-3.6007, 13.3927, 10.8872> <-3.7050, 13.4461, 10.5987> <-3.6858, 13.5505, 10.3980>
		<-3.5488, 13.3455, 11.1149> <-3.6129, 13.4193, 10.9100> <-3.7175, 13.4736, 10.6111> <-3.6984, 13.5780, 10.4104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5488, 13.3455, 11.1149> <-3.6129, 13.4193, 10.9100> <-3.7175, 13.4736, 10.6111> <-3.6984, 13.5780, 10.4104>
		<-3.5604, 13.3708, 11.1366> <-3.6244, 13.4447, 10.9316> <-3.7296, 13.5000, 10.6230> <-3.7105, 13.6044, 10.4222>
		<-3.5780, 13.4055, 11.1644> <-3.6407, 13.4715, 10.9469> <-3.7455, 13.5331, 10.6480> <-3.7282, 13.6397, 10.4384>
		<-3.5980, 13.4263, 11.1847> <-3.6607, 13.4923, 10.9672> <-3.7651, 13.5548, 10.6594> <-3.7477, 13.6614, 10.4498>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5980, 13.4263, 11.1847> <-3.6607, 13.4923, 10.9672> <-3.7651, 13.5548, 10.6594> <-3.7477, 13.6614, 10.4498>
		<-3.6313, 13.4609, 11.2182> <-3.6940, 13.5269, 11.0007> <-3.7977, 13.5911, 10.6784> <-3.7804, 13.6977, 10.4688>
		<-3.6798, 13.5037, 11.2642> <-3.7411, 13.5560, 11.0282> <-3.8362, 13.6362, 10.7188> <-3.8282, 13.7436, 10.4939>
		<-3.7248, 13.5284, 11.2925> <-3.7860, 13.5807, 11.0566> <-3.8786, 13.6620, 10.7355> <-3.8706, 13.7694, 10.5107>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7248, 13.5284, 11.2925> <-3.7860, 13.5807, 11.0566> <-3.8786, 13.6620, 10.7355> <-3.8706, 13.7694, 10.5107>
		<-3.7629, 13.5493, 11.3165> <-3.8241, 13.6016, 11.0806> <-3.9152, 13.6843, 10.7500> <-3.9072, 13.7917, 10.5252>
		<-3.8254, 13.5625, 11.3392> <-3.8771, 13.6040, 11.0927> <-3.9595, 13.7025, 10.7736> <-3.9653, 13.8057, 10.5402>
		<-3.8702, 13.5756, 11.3561> <-3.9219, 13.6171, 11.1096> <-4.0011, 13.7158, 10.7856> <-4.0070, 13.8190, 10.5522>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8702, 13.5756, 11.3561> <-3.9219, 13.6171, 11.1096> <-4.0011, 13.7158, 10.7856> <-4.0070, 13.8190, 10.5522>
		<-3.8940, 13.5825, 11.3651> <-3.9457, 13.6240, 11.1185> <-4.0233, 13.7228, 10.7920> <-4.0291, 13.8261, 10.5585>
		<-3.9280, 13.5892, 11.3717> <-3.9717, 13.6330, 11.1236> <-4.0463, 13.7322, 10.8010> <-4.0601, 13.8317, 10.5659>
		<-3.9528, 13.5950, 11.3784> <-3.9964, 13.6388, 11.1303> <-4.0690, 13.7377, 10.8068> <-4.0829, 13.8371, 10.5717>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9528, 13.5950, 11.3784> <-3.9964, 13.6388, 11.1303> <-4.0690, 13.7377, 10.8068> <-4.0829, 13.8371, 10.5717>
		<-3.9907, 13.5920, 11.3827> <-4.0343, 13.6359, 11.1346> <-4.1037, 13.7347, 10.8116> <-4.1176, 13.8341, 10.5764>
		<-4.0414, 13.5909, 11.3900> <-4.0835, 13.6358, 11.1427> <-4.1361, 13.7405, 10.8196> <-4.1640, 13.8329, 10.5838>
		<-4.0791, 13.5852, 11.3928> <-4.1212, 13.6300, 11.1455> <-4.1706, 13.7348, 10.8233> <-4.1985, 13.8272, 10.5875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2843, 13.8039, 10.5933> <-4.2598, 13.8146, 10.5931> <-4.2247, 13.8229, 10.5903> <-4.1985, 13.8272, 10.5875>
		<-4.2943, 13.8260, 10.5331> <-4.2698, 13.8367, 10.5329> <-4.2319, 13.8468, 10.5292> <-4.2057, 13.8511, 10.5264>
		<-4.3096, 13.8871, 10.4678> <-4.2689, 13.9047, 10.4698> <-4.2302, 13.9169, 10.4722> <-4.1873, 13.9282, 10.4706>
		<-4.3349, 13.9203, 10.4181> <-4.2942, 13.9380, 10.4202> <-4.2374, 13.9557, 10.4193> <-4.1945, 13.9671, 10.4176>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2843, 13.8039, 10.5933> <-4.2943, 13.8260, 10.5331> <-4.3096, 13.8871, 10.4678> <-4.3349, 13.9203, 10.4181>
		<-4.3113, 13.7921, 10.5934> <-4.3213, 13.8142, 10.5332> <-4.3546, 13.8675, 10.4656> <-4.3799, 13.9007, 10.4159>
		<-4.3449, 13.7707, 10.5911> <-4.3590, 13.7930, 10.5261> <-4.3949, 13.8410, 10.4578> <-4.4374, 13.8692, 10.4096>
		<-4.3683, 13.7529, 10.5884> <-4.3824, 13.7752, 10.5235> <-4.4364, 13.8153, 10.4517> <-4.4788, 13.8435, 10.4035>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3683, 13.7529, 10.5884> <-4.3824, 13.7752, 10.5235> <-4.4364, 13.8153, 10.4517> <-4.4788, 13.8435, 10.4035>
		<-4.3962, 13.7317, 10.5852> <-4.4103, 13.7540, 10.5203> <-4.4842, 13.7857, 10.4447> <-4.5266, 13.8139, 10.3965>
		<-4.4285, 13.6982, 10.5781> <-4.4492, 13.7222, 10.5024> <-4.5244, 13.7448, 10.4322> <-4.5859, 13.7686, 10.3833>
		<-4.4543, 13.6747, 10.5737> <-4.4750, 13.6987, 10.4980> <-4.5702, 13.7127, 10.4236> <-4.6318, 13.7365, 10.3747>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4543, 13.6747, 10.5737> <-4.4750, 13.6987, 10.4980> <-4.5702, 13.7127, 10.4236> <-4.6318, 13.7365, 10.3747>
		<-4.4658, 13.6543, 10.5681> <-4.4865, 13.6783, 10.4923> <-4.5930, 13.6874, 10.4144> <-4.6545, 13.7112, 10.3654>
		<-4.4828, 13.6277, 10.5610> <-4.5083, 13.6532, 10.4771> <-4.6138, 13.6571, 10.4049> <-4.6866, 13.6786, 10.3541>
		<-4.4927, 13.6066, 10.5548> <-4.5182, 13.6321, 10.4709> <-4.6349, 13.6307, 10.3948> <-4.7076, 13.6521, 10.3440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4927, 13.6066, 10.5548> <-4.5182, 13.6321, 10.4709> <-4.6349, 13.6307, 10.3948> <-4.7076, 13.6521, 10.3440>
		<-4.5113, 13.5670, 10.5432> <-4.5368, 13.5925, 10.4592> <-4.6724, 13.5834, 10.3767> <-4.7452, 13.6049, 10.3259>
		<-4.5406, 13.5147, 10.5286> <-4.5760, 13.5426, 10.4294> <-4.7091, 13.5267, 10.3590> <-4.8016, 13.5439, 10.3039>
		<-4.5492, 13.4726, 10.5144> <-4.5847, 13.5005, 10.4152> <-4.7344, 13.4738, 10.3358> <-4.8268, 13.4910, 10.2807>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5492, 13.4726, 10.5144> <-4.5847, 13.5005, 10.4152> <-4.7344, 13.4738, 10.3358> <-4.8268, 13.4910, 10.2807>
		<-4.5593, 13.4239, 10.4979> <-4.5947, 13.4519, 10.3987> <-4.7591, 13.4220, 10.3130> <-4.8516, 13.4393, 10.2580>
		<-4.5583, 13.3576, 10.4730> <-4.6023, 13.3874, 10.3620> <-4.7607, 13.3515, 10.2828> <-4.8667, 13.3648, 10.2216>
		<-4.5540, 13.3089, 10.4542> <-4.5980, 13.3388, 10.3431> <-4.7650, 13.2966, 10.2548> <-4.8711, 13.3100, 10.1937>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5540, 13.3089, 10.4542> <-4.5980, 13.3388, 10.3431> <-4.7650, 13.2966, 10.2548> <-4.8711, 13.3100, 10.1937>
		<-4.5514, 13.2798, 10.4429> <-4.5954, 13.3096, 10.3318> <-4.7674, 13.2668, 10.2396> <-4.8734, 13.2802, 10.1785>
		<-4.5377, 13.2427, 10.4268> <-4.5841, 13.2735, 10.3125> <-4.7520, 13.2297, 10.2211> <-4.8604, 13.2416, 10.1559>
		<-4.5266, 13.2159, 10.4149> <-4.5730, 13.2466, 10.3006> <-4.7404, 13.2027, 10.2049> <-4.8488, 13.2146, 10.1397>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5266, 13.2159, 10.4149> <-4.5730, 13.2466, 10.3006> <-4.7404, 13.2027, 10.2049> <-4.8488, 13.2146, 10.1397>
		<-4.5150, 13.1879, 10.4025> <-4.5614, 13.2187, 10.2882> <-4.7284, 13.1747, 10.1881> <-4.8369, 13.1866, 10.1229>
		<-4.4963, 13.1518, 10.3859> <-4.5431, 13.1833, 10.2708> <-4.7083, 13.1401, 10.1704> <-4.8150, 13.1512, 10.1004>
		<-4.4788, 13.1271, 10.3737> <-4.5256, 13.1586, 10.2586> <-4.6867, 13.1178, 10.1548> <-4.7934, 13.1289, 10.0848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4788, 13.1271, 10.3737> <-4.5256, 13.1586, 10.2586> <-4.6867, 13.1178, 10.1548> <-4.7934, 13.1289, 10.0848>
		<-4.4609, 13.1019, 10.3613> <-4.5077, 13.1334, 10.2462> <-4.6633, 13.0936, 10.1380> <-4.7701, 13.1047, 10.0680>
		<-4.4319, 13.0717, 10.3452> <-4.4768, 13.1039, 10.2323> <-4.6314, 13.0678, 10.1232> <-4.7312, 13.0791, 10.0476>
		<-4.4092, 13.0504, 10.3334> <-4.4541, 13.0825, 10.2205> <-4.6014, 13.0505, 10.1088> <-4.7011, 13.0618, 10.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4092, 13.0504, 10.3334> <-4.4541, 13.0825, 10.2205> <-4.6014, 13.0505, 10.1088> <-4.7011, 13.0618, 10.0332>
		<-4.3840, 13.0266, 10.3203> <-4.4288, 13.0588, 10.2074> <-4.5659, 13.0300, 10.0917> <-4.6656, 13.0414, 10.0161>
		<-4.3489, 12.9959, 10.3029> <-4.3943, 13.0302, 10.1960> <-4.5286, 13.0036, 10.0770> <-4.6160, 13.0162, 9.9941>
		<-4.3192, 12.9771, 10.2909> <-4.3647, 13.0114, 10.1840> <-4.4884, 12.9910, 10.0632> <-4.5758, 13.0035, 9.9803>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3192, 12.9771, 10.2909> <-4.3647, 13.0114, 10.1840> <-4.4884, 12.9910, 10.0632> <-4.5758, 13.0035, 9.9803>
		<-4.2927, 12.9602, 10.2802> <-4.3381, 12.9945, 10.1732> <-4.4480, 12.9783, 10.0493> <-4.5354, 12.9908, 9.9664>
		<-4.2530, 12.9439, 10.2674> <-4.2915, 12.9788, 10.1649> <-4.4083, 12.9680, 10.0426> <-4.4776, 12.9833, 9.9522>
		<-4.2233, 12.9323, 10.2580> <-4.2618, 12.9671, 10.1555> <-4.3653, 12.9627, 10.0321> <-4.4347, 12.9780, 9.9418>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2233, 12.9323, 10.2580> <-4.2618, 12.9671, 10.1555> <-4.3653, 12.9627, 10.0321> <-4.4347, 12.9780, 9.9418>
		<-4.2040, 12.9247, 10.2520> <-4.2425, 12.9596, 10.1494> <-4.3354, 12.9590, 10.0249> <-4.4048, 12.9743, 9.9345>
		<-4.1771, 12.9171, 10.2446> <-4.2110, 12.9520, 10.1451> <-4.3104, 12.9550, 10.0217> <-4.3641, 12.9728, 9.9265>
		<-4.1564, 12.9132, 10.2397> <-4.1904, 12.9482, 10.1402> <-4.2799, 12.9558, 10.0167> <-4.3336, 12.9736, 9.9214>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1564, 12.9132, 10.2397> <-4.1904, 12.9482, 10.1402> <-4.2799, 12.9558, 10.0167> <-4.3336, 12.9736, 9.9214>
		<-4.1374, 12.9096, 10.2351> <-4.1713, 12.9446, 10.1357> <-4.2497, 12.9566, 10.0117> <-4.3034, 12.9744, 9.9165>
		<-4.1113, 12.9076, 10.2300> <-4.1417, 12.9426, 10.1337> <-4.2274, 12.9580, 10.0101> <-4.2630, 12.9787, 9.9115>
		<-4.0917, 12.9075, 10.2267> <-4.1221, 12.9425, 10.1304> <-4.1973, 12.9626, 10.0072> <-4.2329, 12.9833, 9.9086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0917, 12.9075, 10.2267> <-4.1221, 12.9425, 10.1304> <-4.1973, 12.9626, 10.0072> <-4.2329, 12.9833, 9.9086>
		<-4.0753, 12.9075, 10.2239> <-4.1057, 12.9424, 10.1276> <-4.1709, 12.9667, 10.0046> <-4.2065, 12.9874, 9.9060>
		<-4.0534, 12.9098, 10.2210> <-4.0786, 12.9455, 10.1268> <-4.1533, 12.9720, 10.0035> <-4.1716, 12.9954, 9.9040>
		<-4.0371, 12.9128, 10.2194> <-4.0624, 12.9485, 10.1252> <-4.1275, 12.9792, 10.0027> <-4.1457, 13.0026, 9.9032>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0371, 12.9128, 10.2194> <-4.0624, 12.9485, 10.1252> <-4.1275, 12.9792, 10.0027> <-4.1457, 13.0026, 9.9032>
		<-4.0191, 12.9162, 10.2176> <-4.0443, 12.9518, 10.1234> <-4.0980, 12.9875, 10.0018> <-4.1162, 13.0108, 9.9022>
		<-3.9955, 12.9235, 10.2164> <-4.0144, 12.9608, 10.1241> <-4.0794, 12.9985, 10.0005> <-4.0777, 13.0246, 9.9026>
		<-3.9778, 12.9286, 10.2153> <-3.9967, 12.9660, 10.1231> <-4.0504, 13.0086, 10.0005> <-4.0487, 13.0346, 9.9027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9778, 12.9286, 10.2153> <-3.9967, 12.9660, 10.1231> <-4.0504, 13.0086, 10.0005> <-4.0487, 13.0346, 9.9027>
		<-3.9602, 12.9338, 10.2143> <-3.9791, 12.9711, 10.1220> <-4.0214, 13.0186, 10.0006> <-4.0197, 13.0447, 9.9028>
		<-3.9363, 12.9398, 10.2125> <-3.9510, 12.9787, 10.1215> <-4.0012, 13.0291, 9.9962> <-3.9806, 13.0572, 9.9024>
		<-3.9194, 12.9472, 10.2124> <-3.9342, 12.9861, 10.1214> <-3.9731, 13.0413, 9.9976> <-3.9525, 13.0695, 9.9038>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9194, 12.9472, 10.2124> <-3.9342, 12.9861, 10.1214> <-3.9731, 13.0413, 9.9976> <-3.9525, 13.0695, 9.9038>
		<-3.9009, 12.9553, 10.2123> <-3.9157, 12.9942, 10.1213> <-3.9422, 13.0547, 9.9991> <-3.9216, 13.0829, 9.9053>
		<-3.8779, 12.9695, 10.2137> <-3.8881, 13.0104, 10.1231> <-3.9204, 13.0743, 9.9969> <-3.8822, 13.1041, 9.9094>
		<-3.8607, 12.9799, 10.2147> <-3.8708, 13.0208, 10.1241> <-3.8907, 13.0900, 9.9999> <-3.8526, 13.1198, 9.9124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8607, 12.9799, 10.2147> <-3.8708, 13.0208, 10.1241> <-3.8907, 13.0900, 9.9999> <-3.8526, 13.1198, 9.9124>
		<-3.8469, 12.9882, 10.2155> <-3.8571, 13.0291, 10.1248> <-3.8673, 13.1025, 10.0022> <-3.8292, 13.1323, 9.9148>
		<-3.8289, 12.9998, 10.2168> <-3.8341, 13.0436, 10.1259> <-3.8482, 13.1186, 10.0004> <-3.7982, 13.1494, 9.9182>
		<-3.8161, 13.0094, 10.2182> <-3.8213, 13.0533, 10.1274> <-3.8257, 13.1325, 10.0037> <-3.7758, 13.1633, 9.9215>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8161, 13.0094, 10.2182> <-3.8213, 13.0533, 10.1274> <-3.8257, 13.1325, 10.0037> <-3.7758, 13.1633, 9.9215>
		<-3.8016, 13.0204, 10.2199> <-3.8068, 13.0642, 10.1290> <-3.8007, 13.1479, 10.0073> <-3.7507, 13.1788, 9.9252>
		<-3.7822, 13.0352, 10.2221> <-3.7829, 13.0825, 10.1305> <-3.7783, 13.1676, 10.0067> <-3.7172, 13.1995, 9.9301>
		<-3.7700, 13.0485, 10.2250> <-3.7707, 13.0958, 10.1334> <-3.7554, 13.1857, 10.0122> <-3.6943, 13.2176, 9.9355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7700, 13.0485, 10.2250> <-3.7707, 13.0958, 10.1334> <-3.7554, 13.1857, 10.0122> <-3.6943, 13.2176, 9.9355>
		<-3.7577, 13.0619, 10.2279> <-3.7584, 13.1092, 10.1363> <-3.7338, 13.2028, 10.0173> <-3.6727, 13.2347, 9.9406>
		<-3.7443, 13.0821, 10.2332> <-3.7429, 13.1315, 10.1400> <-3.7161, 13.2272, 10.0216> <-3.6467, 13.2604, 9.9494>
		<-3.7349, 13.0975, 10.2374> <-3.7335, 13.1469, 10.1441> <-3.6975, 13.2469, 10.0286> <-3.6280, 13.2801, 9.9564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7349, 13.0975, 10.2374> <-3.7335, 13.1469, 10.1441> <-3.6975, 13.2469, 10.0286> <-3.6280, 13.2801, 9.9564>
		<-3.7239, 13.1157, 10.2423> <-3.7225, 13.1650, 10.1491> <-3.6766, 13.2690, 10.0365> <-3.6071, 13.3022, 9.9643>
		<-3.7094, 13.1403, 10.2490> <-3.7049, 13.1928, 10.1540> <-3.6564, 13.2972, 10.0429> <-3.5791, 13.3320, 9.9749>
		<-3.7024, 13.1600, 10.2552> <-3.6979, 13.2125, 10.1601> <-3.6400, 13.3221, 10.0530> <-3.5627, 13.3568, 9.9850>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7024, 13.1600, 10.2552> <-3.6979, 13.2125, 10.1601> <-3.6400, 13.3221, 10.0530> <-3.5627, 13.3568, 9.9850>
		<-3.6922, 13.1886, 10.2641> <-3.6877, 13.2411, 10.1691> <-3.6185, 13.3545, 10.0662> <-3.5412, 13.3892, 9.9982>
		<-3.6840, 13.2279, 10.2774> <-3.6770, 13.2835, 10.1799> <-3.6035, 13.3980, 10.0821> <-3.5187, 13.4353, 10.0183>
		<-3.6779, 13.2573, 10.2873> <-3.6709, 13.3129, 10.1899> <-3.5870, 13.4325, 10.0973> <-3.5023, 13.4697, 10.0335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6779, 13.2573, 10.2873> <-3.6709, 13.3129, 10.1899> <-3.5870, 13.4325, 10.0973> <-3.5023, 13.4697, 10.0335>
		<-3.6704, 13.2937, 10.2997> <-3.6634, 13.3493, 10.2022> <-3.5674, 13.4737, 10.1153> <-3.4826, 13.5109, 10.0515>
		<-3.6593, 13.3424, 10.3159> <-3.6502, 13.3971, 10.2123> <-3.5470, 13.5252, 10.1352> <-3.4544, 13.5656, 10.0752>
		<-3.6573, 13.3791, 10.3293> <-3.6482, 13.4339, 10.2257> <-3.5351, 13.5682, 10.1556> <-3.4425, 13.6086, 10.0956>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6573, 13.3791, 10.3293> <-3.6482, 13.4339, 10.2257> <-3.5351, 13.5682, 10.1556> <-3.4425, 13.6086, 10.0956>
		<-3.6557, 13.4104, 10.3407> <-3.6466, 13.4652, 10.2371> <-3.5260, 13.6011, 10.1712> <-3.4333, 13.6416, 10.1113>
		<-3.6598, 13.4521, 10.3569> <-3.6496, 13.5075, 10.2519> <-3.5247, 13.6439, 10.1923> <-3.4298, 13.6870, 10.1345>
		<-3.6661, 13.4824, 10.3693> <-3.6558, 13.5378, 10.2642> <-3.5279, 13.6769, 10.2101> <-3.4330, 13.7199, 10.1523>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6661, 13.4824, 10.3693> <-3.6558, 13.5378, 10.2642> <-3.5279, 13.6769, 10.2101> <-3.4330, 13.7199, 10.1523>
		<-3.6722, 13.5122, 10.3814> <-3.6620, 13.5675, 10.2764> <-3.5308, 13.7073, 10.2266> <-3.4359, 13.7504, 10.1688>
		<-3.6858, 13.5505, 10.3980> <-3.6759, 13.6045, 10.2941> <-3.5414, 13.7444, 10.2482> <-3.4488, 13.7897, 10.1917>
		<-3.6984, 13.5780, 10.4104> <-3.6885, 13.6321, 10.3064> <-3.5551, 13.7717, 10.2649> <-3.4625, 13.8169, 10.2084>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6984, 13.5780, 10.4104> <-3.6885, 13.6321, 10.3064> <-3.5551, 13.7717, 10.2649> <-3.4625, 13.8169, 10.2084>
		<-3.7105, 13.6044, 10.4222> <-3.7006, 13.6585, 10.3183> <-3.5683, 13.7980, 10.2811> <-3.4757, 13.8432, 10.2246>
		<-3.7282, 13.6397, 10.4384> <-3.7199, 13.6908, 10.3378> <-3.5833, 13.8313, 10.3025> <-3.4969, 13.8783, 10.2467>
		<-3.7477, 13.6614, 10.4498> <-3.7394, 13.7126, 10.3492> <-3.6080, 13.8494, 10.3164> <-3.5215, 13.8963, 10.2606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7477, 13.6614, 10.4498> <-3.7394, 13.7126, 10.3492> <-3.6080, 13.8494, 10.3164> <-3.5215, 13.8963, 10.2606>
		<-3.7804, 13.6977, 10.4688> <-3.7720, 13.7488, 10.3682> <-3.6532, 13.8826, 10.3419> <-3.5668, 13.9296, 10.2861>
		<-3.8282, 13.7436, 10.4939> <-3.8250, 13.7862, 10.4047> <-3.7002, 13.9198, 10.3742> <-3.6344, 13.9681, 10.3183>
		<-3.8706, 13.7694, 10.5107> <-3.8674, 13.8120, 10.4214> <-3.7566, 13.9362, 10.3929> <-3.6908, 13.9846, 10.3370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8706, 13.7694, 10.5107> <-3.8674, 13.8120, 10.4214> <-3.7566, 13.9362, 10.3929> <-3.6908, 13.9846, 10.3370>
		<-3.9072, 13.7917, 10.5252> <-3.9041, 13.8343, 10.4359> <-3.8143, 13.9531, 10.4120> <-3.7484, 14.0014, 10.3562>
		<-3.9653, 13.8057, 10.5402> <-3.9672, 13.8391, 10.4648> <-3.8704, 13.9541, 10.4276> <-3.8330, 14.0012, 10.3711>
		<-4.0070, 13.8190, 10.5522> <-4.0088, 13.8524, 10.4768> <-3.9319, 13.9584, 10.4408> <-3.8945, 14.0054, 10.3843>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0070, 13.8190, 10.5522> <-4.0088, 13.8524, 10.4768> <-3.9319, 13.9584, 10.4408> <-3.8945, 14.0054, 10.3843>
		<-4.0291, 13.8261, 10.5585> <-4.0310, 13.8594, 10.4831> <-3.9663, 13.9608, 10.4481> <-3.9289, 14.0078, 10.3917>
		<-4.0601, 13.8317, 10.5659> <-4.0641, 13.8607, 10.4974> <-3.9955, 13.9612, 10.4550> <-3.9754, 14.0062, 10.3991>
		<-4.0829, 13.8371, 10.5717> <-4.0869, 13.8661, 10.5032> <-4.0302, 13.9616, 10.4613> <-4.0101, 14.0066, 10.4055>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0829, 13.8371, 10.5717> <-4.0869, 13.8661, 10.5032> <-4.0302, 13.9616, 10.4613> <-4.0101, 14.0066, 10.4055>
		<-4.1176, 13.8341, 10.5764> <-4.1216, 13.8631, 10.5080> <-4.0855, 13.9497, 10.4650> <-4.0654, 13.9947, 10.4091>
		<-4.1640, 13.8329, 10.5838> <-4.1712, 13.8568, 10.5227> <-4.1325, 13.9428, 10.4684> <-4.1397, 13.9816, 10.4155>
		<-4.1985, 13.8272, 10.5875> <-4.2057, 13.8511, 10.5264> <-4.1873, 13.9282, 10.4706> <-4.1945, 13.9671, 10.4176>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5722, 14.1824, 10.0275> <-4.5010, 14.1037, 10.1447> <-4.3965, 14.0012, 10.2972> <-4.3349, 13.9203, 10.4181>
		<-4.4839, 14.2038, 10.0300> <-4.4127, 14.1252, 10.1472> <-4.3558, 14.0189, 10.2992> <-4.2942, 13.9380, 10.4202>
		<-4.3643, 14.2244, 10.0295> <-4.3403, 14.1432, 10.1464> <-4.2530, 14.0406, 10.3037> <-4.2374, 13.9557, 10.4193>
		<-4.2744, 14.2377, 10.0281> <-4.2504, 14.1565, 10.1450> <-4.2101, 14.0520, 10.3020> <-4.1945, 13.9671, 10.4176>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5722, 14.1824, 10.0275> <-4.6651, 14.1598, 10.0249> <-4.7872, 14.1225, 10.0180> <-4.8774, 14.0912, 10.0111>
		<-4.5010, 14.1037, 10.1447> <-4.5940, 14.0811, 10.1421> <-4.6677, 14.0482, 10.1357> <-4.7578, 14.0169, 10.1288>
		<-4.3965, 14.0012, 10.2972> <-4.4415, 13.9817, 10.2949> <-4.5485, 13.9430, 10.2836> <-4.5899, 13.9174, 10.2775>
		<-4.3349, 13.9203, 10.4181> <-4.3799, 13.9007, 10.4159> <-4.4374, 13.8692, 10.4096> <-4.4788, 13.8435, 10.4035>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8774, 14.0912, 10.0111> <-4.9763, 14.0568, 10.0036> <-5.1044, 14.0020, 9.9891> <-5.2017, 13.9637, 9.9796>
		<-4.7578, 14.0169, 10.1288> <-4.8567, 13.9825, 10.1213> <-4.9334, 13.9338, 10.1076> <-5.0307, 13.8955, 10.0981>
		<-4.5899, 13.9174, 10.2775> <-4.6377, 13.8878, 10.2705> <-4.7499, 13.8320, 10.2529> <-4.7958, 13.7999, 10.2443>
		<-4.4788, 13.8435, 10.4035> <-4.5266, 13.8139, 10.3965> <-4.5859, 13.7686, 10.3833> <-4.6318, 13.7365, 10.3747>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2017, 13.9637, 9.9796> <-5.2500, 13.9336, 9.9698> <-5.3163, 13.8959, 9.9580> <-5.3626, 13.8632, 9.9469>
		<-5.0307, 13.8955, 10.0981> <-5.0790, 13.8654, 10.0883> <-5.1198, 13.8326, 10.0772> <-5.1661, 13.7999, 10.0660>
		<-4.7958, 13.7999, 10.2443> <-4.8186, 13.7746, 10.2351> <-4.8765, 13.7346, 10.2214> <-4.8975, 13.7082, 10.2112>
		<-4.6318, 13.7365, 10.3747> <-4.6545, 13.7112, 10.3654> <-4.6866, 13.6786, 10.3541> <-4.7076, 13.6521, 10.3440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3626, 13.8632, 9.9469> <-5.4406, 13.8080, 9.9280> <-5.5549, 13.7422, 9.9073> <-5.6153, 13.6710, 9.8797>
		<-5.1661, 13.7999, 10.0660> <-5.2441, 13.7447, 10.0472> <-5.3184, 13.6882, 10.0276> <-5.3788, 13.6170, 10.0000>
		<-4.8975, 13.7082, 10.2112> <-4.9351, 13.6609, 10.1931> <-5.0314, 13.5866, 10.1671> <-5.0566, 13.5337, 10.1439>
		<-4.7076, 13.6521, 10.3440> <-4.7452, 13.6049, 10.3259> <-4.8016, 13.5439, 10.3039> <-4.8268, 13.4910, 10.2807>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6153, 13.6710, 9.8797> <-5.6624, 13.6155, 9.8581> <-5.6994, 13.5234, 9.8189> <-5.7091, 13.4547, 9.7882>
		<-5.3788, 13.6170, 10.0000> <-5.4258, 13.5615, 9.9784> <-5.4480, 13.4800, 9.9405> <-5.4577, 13.4113, 9.9098>
		<-5.0566, 13.5337, 10.1439> <-5.0813, 13.4820, 10.1212> <-5.1101, 13.3955, 10.0813> <-5.1145, 13.3407, 10.0533>
		<-4.8268, 13.4910, 10.2807> <-4.8516, 13.4393, 10.2580> <-4.8667, 13.3648, 10.2216> <-4.8711, 13.3100, 10.1937>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7091, 13.4547, 9.7882> <-5.7143, 13.4178, 9.7717> <-5.6847, 13.3705, 9.7474> <-5.6620, 13.3405, 9.7318>
		<-5.4577, 13.4113, 9.9098> <-5.4629, 13.3744, 9.8933> <-5.4408, 13.3327, 9.8698> <-5.4181, 13.3027, 9.8541>
		<-5.1145, 13.3407, 10.0533> <-5.1169, 13.3109, 10.0381> <-5.0955, 13.2674, 10.0145> <-5.0839, 13.2404, 9.9983>
		<-4.8711, 13.3100, 10.1937> <-4.8734, 13.2802, 10.1785> <-4.8604, 13.2416, 10.1559> <-4.8488, 13.2146, 10.1397>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6620, 13.3405, 9.7318> <-5.6342, 13.3038, 9.7126> <-5.5857, 13.2618, 9.6893> <-5.5445, 13.2377, 9.6748>
		<-5.4181, 13.3027, 9.8541> <-5.3902, 13.2661, 9.8350> <-5.3604, 13.2292, 9.8123> <-5.3192, 13.2051, 9.7978>
		<-5.0839, 13.2404, 9.9983> <-5.0719, 13.2124, 9.9815> <-5.0306, 13.1736, 9.9590> <-5.0090, 13.1513, 9.9434>
		<-4.8488, 13.2146, 10.1397> <-4.8369, 13.1866, 10.1229> <-4.8150, 13.1512, 10.1004> <-4.7934, 13.1289, 10.0848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5445, 13.2377, 9.6748> <-5.4904, 13.2060, 9.6557> <-5.4095, 13.1770, 9.6356> <-5.3487, 13.1571, 9.6214>
		<-5.3192, 13.2051, 9.7978> <-5.2651, 13.1734, 9.7787> <-5.2152, 13.1484, 9.7592> <-5.1545, 13.1285, 9.7450>
		<-5.0090, 13.1513, 9.9434> <-4.9857, 13.1271, 9.9266> <-4.9153, 13.1000, 9.9081> <-4.8853, 13.0827, 9.8937>
		<-4.7934, 13.1289, 10.0848> <-4.7701, 13.1047, 10.0680> <-4.7312, 13.0791, 10.0476> <-4.7011, 13.0618, 10.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3487, 13.1571, 9.6214> <-5.2707, 13.1316, 9.6032> <-5.1646, 13.1015, 9.5806> <-5.0830, 13.0869, 9.5670>
		<-5.1545, 13.1285, 9.7450> <-5.0764, 13.1030, 9.7268> <-5.0125, 13.0765, 9.7045> <-4.9308, 13.0619, 9.6910>
		<-4.8853, 13.0827, 9.8937> <-4.8497, 13.0623, 9.8766> <-4.7589, 13.0367, 9.8587> <-4.7186, 13.0241, 9.8449>
		<-4.7011, 13.0618, 10.0332> <-4.6656, 13.0414, 10.0161> <-4.6160, 13.0162, 9.9941> <-4.5758, 13.0035, 9.9803>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0830, 13.0869, 9.5670> <-4.9946, 13.0710, 9.5524> <-4.8739, 13.0622, 9.5383> <-4.7837, 13.0557, 9.5278>
		<-4.9308, 13.0619, 9.6910> <-4.8424, 13.0460, 9.6763> <-4.7692, 13.0389, 9.6624> <-4.6790, 13.0324, 9.6520>
		<-4.7186, 13.0241, 9.8449> <-4.6782, 13.0114, 9.8311> <-4.5767, 13.0051, 9.8232> <-4.5337, 12.9998, 9.8127>
		<-4.5758, 13.0035, 9.9803> <-4.5354, 12.9908, 9.9664> <-4.4776, 12.9833, 9.9522> <-4.4347, 12.9780, 9.9418>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7837, 13.0557, 9.5278> <-4.7197, 13.0512, 9.5203> <-4.6338, 13.0492, 9.5123> <-4.5694, 13.0501, 9.5073>
		<-4.6790, 13.0324, 9.6520> <-4.6150, 13.0278, 9.6445> <-4.5631, 13.0263, 9.6365> <-4.4986, 13.0271, 9.6315>
		<-4.5337, 12.9998, 9.8127> <-4.5038, 12.9961, 9.8055> <-4.4343, 12.9960, 9.8020> <-4.4038, 12.9969, 9.7969>
		<-4.4347, 12.9780, 9.9418> <-4.4048, 12.9743, 9.9345> <-4.3641, 12.9728, 9.9265> <-4.3336, 12.9736, 9.9214>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5694, 13.0501, 9.5073> <-4.5053, 13.0509, 9.5023> <-4.4198, 13.0558, 9.4975> <-4.3558, 13.0613, 9.4946>
		<-4.4986, 13.0271, 9.6315> <-4.4346, 13.0280, 9.6266> <-4.3829, 13.0324, 9.6216> <-4.3189, 13.0379, 9.6188>
		<-4.4038, 12.9969, 9.7969> <-4.3736, 12.9977, 9.7920> <-4.3068, 13.0042, 9.7900> <-4.2767, 13.0088, 9.7871>
		<-4.3336, 12.9736, 9.9214> <-4.3034, 12.9744, 9.9165> <-4.2630, 12.9787, 9.9115> <-4.2329, 12.9833, 9.9086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3558, 13.0613, 9.4946> <-4.3002, 13.0660, 9.4922> <-4.2263, 13.0754, 9.4903> <-4.1711, 13.0840, 9.4896>
		<-4.3189, 13.0379, 9.6188> <-4.2633, 13.0426, 9.6163> <-4.2187, 13.0510, 9.6144> <-4.1635, 13.0596, 9.6137>
		<-4.2767, 13.0088, 9.7871> <-4.2503, 13.0129, 9.7845> <-4.1938, 13.0239, 9.7826> <-4.1680, 13.0311, 9.7818>
		<-4.2329, 12.9833, 9.9086> <-4.2065, 12.9874, 9.9060> <-4.1716, 12.9954, 9.9040> <-4.1457, 13.0026, 9.9032>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1711, 13.0840, 9.4896> <-4.1091, 13.0936, 9.4889> <-4.0269, 13.1100, 9.4896> <-3.9653, 13.1219, 9.4899>
		<-4.1635, 13.0596, 9.6137> <-4.1014, 13.0692, 9.6129> <-4.0519, 13.0838, 9.6134> <-3.9903, 13.0957, 9.6137>
		<-4.1680, 13.0311, 9.7818> <-4.1385, 13.0393, 9.7808> <-4.0755, 13.0578, 9.7779> <-4.0465, 13.0679, 9.7780>
		<-4.1457, 13.0026, 9.9032> <-4.1162, 13.0108, 9.9022> <-4.0777, 13.0246, 9.9026> <-4.0487, 13.0346, 9.9027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9653, 13.1219, 9.4899> <-3.9040, 13.1338, 9.4902> <-3.8220, 13.1484, 9.4901> <-3.7613, 13.1631, 9.4918>
		<-3.9903, 13.0957, 9.6137> <-3.9290, 13.1076, 9.6140> <-3.8793, 13.1203, 9.6137> <-3.8187, 13.1350, 9.6154>
		<-4.0465, 13.0679, 9.7780> <-4.0175, 13.0779, 9.7781> <-3.9520, 13.0963, 9.7720> <-3.9239, 13.1085, 9.7734>
		<-4.0487, 13.0346, 9.9027> <-4.0197, 13.0447, 9.9028> <-3.9806, 13.0572, 9.9024> <-3.9525, 13.0695, 9.9038>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7613, 13.1631, 9.4918> <-3.6971, 13.1788, 9.4936> <-3.6127, 13.2042, 9.4983> <-3.5494, 13.2230, 9.5016>
		<-3.8187, 13.1350, 9.6154> <-3.7544, 13.1506, 9.6172> <-3.7037, 13.1732, 9.6215> <-3.6404, 13.1921, 9.6249>
		<-3.9239, 13.1085, 9.7734> <-3.8930, 13.1219, 9.7749> <-3.8225, 13.1507, 9.7727> <-3.7929, 13.1665, 9.7757>
		<-3.9525, 13.0695, 9.9038> <-3.9216, 13.0829, 9.9053> <-3.8822, 13.1041, 9.9094> <-3.8526, 13.1198, 9.9124>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5494, 13.2230, 9.5016> <-3.5003, 13.2376, 9.5043> <-3.4349, 13.2579, 9.5081> <-3.3865, 13.2747, 9.5118>
		<-3.6404, 13.1921, 9.6249> <-3.5912, 13.2067, 9.6275> <-3.5517, 13.2245, 9.6310> <-3.5033, 13.2413, 9.6347>
		<-3.7929, 13.1665, 9.7757> <-3.7695, 13.1789, 9.7781> <-3.7127, 13.2022, 9.7777> <-3.6903, 13.2161, 9.7809>
		<-3.8526, 13.1198, 9.9124> <-3.8292, 13.1323, 9.9148> <-3.7982, 13.1494, 9.9182> <-3.7758, 13.1633, 9.9215>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3865, 13.2747, 9.5118> <-3.3342, 13.2928, 9.5157> <-3.2643, 13.3169, 9.5210> <-3.2139, 13.3393, 9.5270>
		<-3.5033, 13.2413, 9.6347> <-3.4510, 13.2594, 9.6387> <-3.4084, 13.2804, 9.6435> <-3.3580, 13.3028, 9.6496>
		<-3.6903, 13.2161, 9.7809> <-3.6652, 13.2316, 9.7846> <-3.6030, 13.2592, 9.7868> <-3.5802, 13.2773, 9.7922>
		<-3.7758, 13.1633, 9.9215> <-3.7507, 13.1788, 9.9252> <-3.7172, 13.1995, 9.9301> <-3.6943, 13.2176, 9.9355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2139, 13.3393, 9.5270> <-3.1701, 13.3587, 9.5323> <-3.1142, 13.3894, 9.5418> <-3.0733, 13.4137, 9.5495>
		<-3.3580, 13.3028, 9.6496> <-3.3142, 13.3222, 9.6548> <-3.2806, 13.3493, 9.6638> <-3.2397, 13.3737, 9.6716>
		<-3.5802, 13.2773, 9.7922> <-3.5585, 13.2944, 9.7973> <-3.5084, 13.3265, 9.8056> <-3.4897, 13.3462, 9.8126>
		<-3.6943, 13.2176, 9.9355> <-3.6727, 13.2347, 9.9406> <-3.6467, 13.2604, 9.9494> <-3.6280, 13.2801, 9.9564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0733, 13.4137, 9.5495> <-3.0303, 13.4393, 9.5577> <-2.9723, 13.4733, 9.5685> <-2.9347, 13.5052, 9.5800>
		<-3.2397, 13.3737, 9.6716> <-3.1968, 13.3992, 9.6797> <-3.1607, 13.4288, 9.6900> <-3.1231, 13.4607, 9.7015>
		<-3.4897, 13.3462, 9.8126> <-3.4688, 13.3683, 9.8205> <-3.4165, 13.4051, 9.8319> <-3.4001, 13.4299, 9.8420>
		<-3.6280, 13.2801, 9.9564> <-3.6071, 13.3022, 9.9643> <-3.5791, 13.3320, 9.9749> <-3.5627, 13.3568, 9.9850>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9347, 13.5052, 9.5800> <-2.8917, 13.5417, 9.5931> <-2.8425, 13.5977, 9.6148> <-2.8066, 13.6400, 9.6312>
		<-3.1231, 13.4607, 9.7015> <-3.0801, 13.4971, 9.7146> <-3.0512, 13.5466, 9.7354> <-3.0153, 13.5889, 9.7519>
		<-3.4001, 13.4299, 9.8420> <-3.3786, 13.4624, 9.8552> <-3.3330, 13.5169, 9.8784> <-3.3165, 13.5513, 9.8936>
		<-3.5627, 13.3568, 9.9850> <-3.5412, 13.3892, 9.9982> <-3.5187, 13.4353, 10.0183> <-3.5023, 13.4697, 10.0335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8066, 13.6400, 9.6312> <-2.7659, 13.6880, 9.6499> <-2.7069, 13.7507, 9.6737> <-2.6798, 13.8059, 9.6968>
		<-3.0153, 13.5889, 9.7519> <-2.9746, 13.6369, 9.7705> <-2.9357, 13.6915, 9.7934> <-2.9086, 13.7467, 9.8165>
		<-3.3165, 13.5513, 9.8936> <-3.2969, 13.5925, 9.9116> <-3.2456, 13.6568, 9.9401> <-3.2337, 13.6998, 9.9605>
		<-3.5023, 13.4697, 10.0335> <-3.4826, 13.5109, 10.0515> <-3.4544, 13.5656, 10.0752> <-3.4425, 13.6086, 10.0956>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6798, 13.8059, 9.6968> <-2.6616, 13.8430, 9.7123> <-2.6530, 13.8995, 9.7376> <-2.6597, 13.9389, 9.7562>
		<-2.9086, 13.7467, 9.8165> <-2.8904, 13.7838, 9.8320> <-2.8850, 13.8338, 9.8564> <-2.8917, 13.8732, 9.8751>
		<-3.2337, 13.6998, 9.9605> <-3.2245, 13.7327, 9.9762> <-3.2158, 13.7841, 10.0041> <-3.2189, 13.8170, 10.0219>
		<-3.4425, 13.6086, 10.0956> <-3.4333, 13.6416, 10.1113> <-3.4298, 13.6870, 10.1345> <-3.4330, 13.7199, 10.1523>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6597, 13.9389, 9.7562> <-2.6663, 13.9776, 9.7745> <-2.6956, 14.0250, 9.7988> <-2.7223, 14.0551, 9.8148>
		<-2.8917, 13.8732, 9.8751> <-2.8983, 13.9119, 9.8934> <-2.9176, 13.9536, 9.9168> <-2.9443, 13.9836, 9.9329>
		<-3.2189, 13.8170, 10.0219> <-3.2219, 13.8475, 10.0384> <-3.2428, 13.8904, 10.0660> <-3.2565, 13.9176, 10.0828>
		<-3.4330, 13.7199, 10.1523> <-3.4359, 13.7504, 10.1688> <-3.4488, 13.7897, 10.1917> <-3.4625, 13.8169, 10.2084>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7223, 14.0551, 9.8148> <-2.7530, 14.0897, 9.8333> <-2.8027, 14.1317, 9.8567> <-2.8474, 14.1503, 9.8690>
		<-2.9443, 13.9836, 9.9329> <-2.9751, 14.0183, 9.9514> <-3.0050, 14.0555, 9.9742> <-3.0496, 14.0741, 9.9865>
		<-3.2565, 13.9176, 10.0828> <-3.2697, 13.9439, 10.0989> <-3.3088, 13.9804, 10.1254> <-3.3334, 13.9985, 10.1393>
		<-3.4625, 13.8169, 10.2084> <-3.4757, 13.8432, 10.2246> <-3.4969, 13.8783, 10.2467> <-3.5215, 13.8963, 10.2606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8474, 14.1503, 9.8690> <-2.9501, 14.1931, 9.8972> <-3.0945, 14.2379, 9.9298> <-3.2063, 14.2565, 9.9477>
		<-3.0496, 14.0741, 9.9865> <-3.1523, 14.1169, 10.0147> <-3.2399, 14.1563, 10.0466> <-3.3517, 14.1749, 10.0645>
		<-3.3334, 13.9985, 10.1393> <-3.3787, 14.0317, 10.1648> <-3.4989, 14.0674, 10.2035> <-3.5553, 14.0839, 10.2222>
		<-3.5215, 13.8963, 10.2606> <-3.5668, 13.9296, 10.2861> <-3.6344, 13.9681, 10.3183> <-3.6908, 13.9846, 10.3370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2063, 14.2565, 9.9477> <-3.3336, 14.2778, 9.9681> <-3.5085, 14.2770, 9.9823> <-3.6384, 14.2823, 9.9956>
		<-3.3517, 14.1749, 10.0645> <-3.4789, 14.1962, 10.0849> <-3.5854, 14.1939, 10.0989> <-3.7152, 14.1992, 10.1122>
		<-3.5553, 14.0839, 10.2222> <-3.6130, 14.1008, 10.2413> <-3.7593, 14.0938, 10.2598> <-3.8208, 14.0981, 10.2730>
		<-3.6908, 13.9846, 10.3370> <-3.7484, 14.0014, 10.3562> <-3.8330, 14.0012, 10.3711> <-3.8945, 14.0054, 10.3843>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6384, 14.2823, 9.9956> <-3.7117, 14.2853, 10.0031> <-3.8099, 14.2836, 10.0105> <-3.8834, 14.2842, 10.0168>
		<-3.7152, 14.1992, 10.1122> <-3.7886, 14.2022, 10.1197> <-3.8479, 14.2003, 10.1271> <-3.9214, 14.2009, 10.1334>
		<-3.8208, 14.0981, 10.2730> <-3.8552, 14.1004, 10.2804> <-3.9355, 14.0958, 10.2880> <-3.9701, 14.0961, 10.2943>
		<-3.8945, 14.0054, 10.3843> <-3.9289, 14.0078, 10.3917> <-3.9754, 14.0062, 10.3991> <-4.0101, 14.0066, 10.4055>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8834, 14.2842, 10.0168> <-4.0007, 14.2702, 10.0202> <-4.1575, 14.2550, 10.0263> <-4.2744, 14.2377, 10.0281>
		<-3.9214, 14.2009, 10.1334> <-4.0387, 14.1870, 10.1368> <-4.1335, 14.1738, 10.1432> <-4.2504, 14.1565, 10.1450>
		<-3.9701, 14.0961, 10.2943> <-4.0254, 14.0843, 10.2980> <-4.1554, 14.0665, 10.2999> <-4.2101, 14.0520, 10.3020>
		<-4.0101, 14.0066, 10.4055> <-4.0654, 13.9947, 10.4091> <-4.1397, 13.9816, 10.4155> <-4.1945, 13.9671, 10.4176>
	}
	texture {skin}
}








union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1514, 12.6525, 10.2938> <-4.1514, 12.6386, 10.2998> <-4.1543, 12.6329, 10.3054> <-4.1514, 12.6165, 10.3094>
		<-4.1686, 12.6475, 10.2820> <-4.1686, 12.6336, 10.2880> <-4.1732, 12.6270, 10.2925> <-4.1702, 12.6107, 10.2965>
		<-4.1931, 12.6412, 10.2681> <-4.1952, 12.6262, 10.2727> <-4.1998, 12.6202, 10.2768> <-4.1967, 12.6031, 10.2810>
		<-4.2087, 12.6358, 10.2545> <-4.2108, 12.6208, 10.2591> <-4.2172, 12.6141, 10.2623> <-4.2141, 12.5969, 10.2665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1514, 12.6165, 10.3094> <-4.1484, 12.6001, 10.3134> <-4.1433, 12.5938, 10.3107> <-4.1382, 12.5796, 10.3115>
		<-4.1702, 12.6107, 10.2965> <-4.1673, 12.5942, 10.3005> <-4.1604, 12.5882, 10.2991> <-4.1553, 12.5739, 10.2999>
		<-4.1967, 12.6031, 10.2810> <-4.1936, 12.5858, 10.2852> <-4.1869, 12.5805, 10.2838> <-4.1796, 12.5665, 10.2863>
		<-4.2141, 12.5969, 10.2665> <-4.2110, 12.5797, 10.2707> <-4.2025, 12.5747, 10.2703> <-4.1952, 12.5607, 10.2727>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2358, 12.6234, 10.2200> <-4.2277, 12.6271, 10.2304> <-4.2187, 12.6323, 10.2458> <-4.2087, 12.6358, 10.2545>
		<-4.2500, 12.6043, 10.2155> <-4.2419, 12.6080, 10.2258> <-4.2208, 12.6174, 10.2504> <-4.2108, 12.6208, 10.2591>
		<-4.2774, 12.6000, 10.2017> <-4.2599, 12.6069, 10.2191> <-4.2363, 12.6074, 10.2464> <-4.2172, 12.6141, 10.2623>
		<-4.2726, 12.5739, 10.2082> <-4.2550, 12.5808, 10.2257> <-4.2332, 12.5902, 10.2506> <-4.2141, 12.5969, 10.2665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2726, 12.5739, 10.2082> <-4.2550, 12.5808, 10.2257> <-4.2332, 12.5902, 10.2506> <-4.2141, 12.5969, 10.2665>
		<-4.2676, 12.5471, 10.2150> <-4.2500, 12.5540, 10.2325> <-4.2301, 12.5730, 10.2548> <-4.2110, 12.5797, 10.2707>
		<-4.2414, 12.5583, 10.2270> <-4.2334, 12.5620, 10.2372> <-4.2122, 12.5711, 10.2618> <-4.2025, 12.5747, 10.2703>
		<-4.2218, 12.5485, 10.2388> <-4.2138, 12.5522, 10.2490> <-4.2049, 12.5571, 10.2642> <-4.1952, 12.5607, 10.2727>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1999, 12.5184, 10.3802> <-4.2004, 12.5037, 10.3849> <-4.2039, 12.4973, 10.3897> <-4.2012, 12.4803, 10.3923>
		<-4.2118, 12.5149, 10.3673> <-4.2122, 12.5002, 10.3720> <-4.2171, 12.4931, 10.3758> <-4.2144, 12.4761, 10.3783>
		<-4.2287, 12.5104, 10.3512> <-4.2309, 12.4947, 10.3544> <-4.2354, 12.4882, 10.3577> <-4.2326, 12.4704, 10.3604>
		<-4.2393, 12.5068, 10.3374> <-4.2415, 12.4911, 10.3406> <-4.2479, 12.4840, 10.3431> <-4.2450, 12.4662, 10.3458>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2012, 12.4803, 10.3923> <-4.1985, 12.4632, 10.3949> <-4.1930, 12.4571, 10.3919> <-4.1879, 12.4425, 10.3917>
		<-4.2144, 12.4761, 10.3783> <-4.2116, 12.4590, 10.3809> <-4.2047, 12.4530, 10.3792> <-4.1996, 12.4384, 10.3789>
		<-4.2326, 12.4704, 10.3604> <-4.2298, 12.4526, 10.3631> <-4.2234, 12.4472, 10.3616> <-4.2164, 12.4327, 10.3629>
		<-4.2450, 12.4662, 10.3458> <-4.2422, 12.4484, 10.3485> <-4.2339, 12.4432, 10.3479> <-4.2269, 12.4287, 10.3492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2590, 12.4985, 10.3032> <-4.2531, 12.5010, 10.3135> <-4.2465, 12.5043, 10.3280> <-4.2393, 12.5068, 10.3374>
		<-4.2710, 12.4799, 10.2972> <-4.2651, 12.4824, 10.3075> <-4.2487, 12.4887, 10.3312> <-4.2415, 12.4911, 10.3406>
		<-4.2942, 12.4755, 10.2837> <-4.2807, 12.4803, 10.3011> <-4.2621, 12.4792, 10.3263> <-4.2479, 12.4840, 10.3431>
		<-4.2901, 12.4503, 10.2877> <-4.2766, 12.4550, 10.3051> <-4.2593, 12.4614, 10.3290> <-4.2450, 12.4662, 10.3458>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2901, 12.4503, 10.2877> <-4.2766, 12.4550, 10.3051> <-4.2593, 12.4614, 10.3290> <-4.2450, 12.4662, 10.3458>
		<-4.2860, 12.4248, 10.2918> <-4.2724, 12.4296, 10.3092> <-4.2565, 12.4436, 10.3317> <-4.2422, 12.4484, 10.3485>
		<-4.2632, 12.4320, 10.3048> <-4.2574, 12.4345, 10.3149> <-4.2410, 12.4405, 10.3387> <-4.2339, 12.4432, 10.3479>
		<-4.2463, 12.4205, 10.3156> <-4.2405, 12.4230, 10.3256> <-4.2340, 12.4261, 10.3400> <-4.2269, 12.4287, 10.3492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0569, 12.3887, 10.4219> <-4.0582, 12.3739, 10.4249> <-4.0626, 12.3672, 10.4278> <-4.0602, 12.3503, 10.4298>
		<-4.0635, 12.3865, 10.4065> <-4.0648, 12.3716, 10.4096> <-4.0700, 12.3643, 10.4111> <-4.0676, 12.3474, 10.4130>
		<-4.0737, 12.3834, 10.3866> <-4.0761, 12.3678, 10.3878> <-4.0809, 12.3611, 10.3890> <-4.0784, 12.3435, 10.3910>
		<-4.0789, 12.3812, 10.3708> <-4.0812, 12.3655, 10.3719> <-4.0875, 12.3583, 10.3718> <-4.0850, 12.3407, 10.3738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0602, 12.3503, 10.4298> <-4.0578, 12.3334, 10.4317> <-4.0516, 12.3277, 10.4301> <-4.0462, 12.3135, 10.4304>
		<-4.0676, 12.3474, 10.4130> <-4.0652, 12.3305, 10.4149> <-4.0581, 12.3247, 10.4149> <-4.0527, 12.3105, 10.4151>
		<-4.0784, 12.3435, 10.3910> <-4.0759, 12.3258, 10.3930> <-4.0693, 12.3206, 10.3931> <-4.0627, 12.3064, 10.3953>
		<-4.0850, 12.3407, 10.3738> <-4.0825, 12.3230, 10.3758> <-4.0745, 12.3180, 10.3773> <-4.0679, 12.3037, 10.3795>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0857, 12.3761, 10.3336> <-4.0837, 12.3776, 10.3447> <-4.0824, 12.3796, 10.3600> <-4.0789, 12.3812, 10.3708>
		<-4.0940, 12.3584, 10.3233> <-4.0919, 12.3599, 10.3345> <-4.0848, 12.3640, 10.3612> <-4.0812, 12.3655, 10.3719>
		<-4.1107, 12.3547, 10.3040> <-4.1040, 12.3578, 10.3241> <-4.0950, 12.3550, 10.3521> <-4.0875, 12.3583, 10.3718>
		<-4.1072, 12.3302, 10.3070> <-4.1005, 12.3333, 10.3270> <-4.0925, 12.3374, 10.3541> <-4.0850, 12.3407, 10.3738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1072, 12.3302, 10.3070> <-4.1005, 12.3333, 10.3270> <-4.0925, 12.3374, 10.3541> <-4.0850, 12.3407, 10.3738>
		<-4.1036, 12.3054, 10.3100> <-4.0969, 12.3085, 10.3300> <-4.0900, 12.3198, 10.3561> <-4.0825, 12.3230, 10.3758>
		<-4.0872, 12.3109, 10.3290> <-4.0851, 12.3123, 10.3400> <-4.0779, 12.3162, 10.3667> <-4.0745, 12.3180, 10.3773>
		<-4.0746, 12.2987, 10.3429> <-4.0726, 12.3002, 10.3539> <-4.0713, 12.3019, 10.3689> <-4.0679, 12.3037, 10.3795>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8748, 12.2591, 10.4331> <-3.8750, 12.2467, 10.4346> <-3.8785, 12.2407, 10.4354> <-3.8753, 12.2270, 10.4370>
		<-3.8750, 12.2579, 10.4208> <-3.8753, 12.2455, 10.4223> <-3.8789, 12.2390, 10.4219> <-3.8757, 12.2254, 10.4234>
		<-3.8767, 12.2561, 10.4044> <-3.8771, 12.2432, 10.4043> <-3.8803, 12.2372, 10.4038> <-3.8770, 12.2231, 10.4054>
		<-3.8757, 12.2551, 10.3921> <-3.8761, 12.2422, 10.3920> <-3.8800, 12.2358, 10.3903> <-3.8767, 12.2216, 10.3919>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8753, 12.2270, 10.4370> <-3.8721, 12.2134, 10.4385> <-3.8663, 12.2095, 10.4389> <-3.8607, 12.1985, 10.4401>
		<-3.8757, 12.2254, 10.4234> <-3.8725, 12.2118, 10.4250> <-3.8665, 12.2078, 10.4267> <-3.8608, 12.1968, 10.4279>
		<-3.8770, 12.2231, 10.4054> <-3.8738, 12.2089, 10.4071> <-3.8682, 12.2052, 10.4087> <-3.8622, 12.1941, 10.4116>
		<-3.8767, 12.2216, 10.3919> <-3.8734, 12.2074, 10.3935> <-3.8672, 12.2039, 10.3965> <-3.8612, 12.1928, 10.3993>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8695, 12.2535, 10.3646> <-3.8714, 12.2540, 10.3728> <-3.8751, 12.2544, 10.3837> <-3.8757, 12.2551, 10.3921>
		<-3.8708, 12.2392, 10.3551> <-3.8727, 12.2397, 10.3633> <-3.8755, 12.2415, 10.3836> <-3.8761, 12.2422, 10.3920>
		<-3.8772, 12.2353, 10.3376> <-3.8784, 12.2369, 10.3532> <-3.8796, 12.2341, 10.3746> <-3.8800, 12.2358, 10.3903>
		<-3.8729, 12.2166, 10.3399> <-3.8740, 12.2181, 10.3555> <-3.8763, 12.2199, 10.3763> <-3.8767, 12.2216, 10.3919>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8729, 12.2166, 10.3399> <-3.8740, 12.2181, 10.3555> <-3.8763, 12.2199, 10.3763> <-3.8767, 12.2216, 10.3919>
		<-3.8685, 12.1977, 10.3422> <-3.8697, 12.1992, 10.3578> <-3.8730, 12.2057, 10.3779> <-3.8734, 12.2074, 10.3935>
		<-3.8619, 12.2009, 10.3597> <-3.8638, 12.2014, 10.3679> <-3.8665, 12.2030, 10.3882> <-3.8672, 12.2039, 10.3965>
		<-3.8551, 12.1911, 10.3722> <-3.8569, 12.1916, 10.3803> <-3.8605, 12.1919, 10.3911> <-3.8612, 12.1928, 10.3993>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7713, 12.9295, 10.4308> <-3.7599, 12.9193, 10.4384> <-3.7536, 12.9172, 10.4450> <-3.7418, 12.9029, 10.4506>
		<-3.7827, 12.9260, 10.4428> <-3.7714, 12.9157, 10.4505> <-3.7661, 12.9129, 10.4584> <-3.7543, 12.8986, 10.4640>
		<-3.7970, 12.9227, 10.4604> <-3.7870, 12.9115, 10.4699> <-3.7821, 12.9089, 10.4776> <-3.7699, 12.8941, 10.4834>
		<-3.8093, 12.9176, 10.4709> <-3.7993, 12.9065, 10.4804> <-3.7955, 12.9035, 10.4897> <-3.7833, 12.8887, 10.4955>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7418, 12.9029, 10.4506> <-3.7298, 12.8884, 10.4562> <-3.7272, 12.8796, 10.4539> <-3.7181, 12.8650, 10.4561>
		<-3.7543, 12.8986, 10.4640> <-3.7423, 12.8841, 10.4697> <-3.7382, 12.8755, 10.4662> <-3.7290, 12.8608, 10.4683>
		<-3.7699, 12.8941, 10.4834> <-3.7573, 12.8789, 10.4894> <-3.7536, 12.8710, 10.4857> <-3.7425, 12.8565, 10.4863>
		<-3.7833, 12.8887, 10.4955> <-3.7707, 12.8735, 10.5014> <-3.7656, 12.8657, 10.4963> <-3.7545, 12.8512, 10.4969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8408, 12.9011, 10.4898> <-3.8314, 12.9061, 10.4841> <-3.8181, 12.9140, 10.4784> <-3.8093, 12.9176, 10.4709>
		<-3.8405, 12.8865, 10.5088> <-3.8311, 12.8915, 10.5031> <-3.8081, 12.9029, 10.4878> <-3.7993, 12.9065, 10.4804>
		<-3.8566, 12.8832, 10.5313> <-3.8396, 12.8908, 10.5182> <-3.8117, 12.8970, 10.5043> <-3.7955, 12.9035, 10.4897>
		<-3.8400, 12.8634, 10.5390> <-3.8230, 12.8710, 10.5259> <-3.7995, 12.8822, 10.5101> <-3.7833, 12.8887, 10.4955>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8400, 12.8634, 10.5390> <-3.8230, 12.8710, 10.5259> <-3.7995, 12.8822, 10.5101> <-3.7833, 12.8887, 10.4955>
		<-3.8224, 12.8423, 10.5472> <-3.8054, 12.8499, 10.5341> <-3.7869, 12.8670, 10.5160> <-3.7707, 12.8735, 10.5014>
		<-3.8066, 12.8459, 10.5246> <-3.7973, 12.8508, 10.5190> <-3.7741, 12.8619, 10.5038> <-3.7656, 12.8657, 10.4963>
		<-3.7855, 12.8349, 10.5155> <-3.7762, 12.8398, 10.5099> <-3.7630, 12.8474, 10.5043> <-3.7545, 12.8512, 10.4969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9893, 9.0073, 7.7516> <-3.0001, 8.9979, 7.7592> <-3.0033, 8.9938, 7.7667> <-3.0173, 8.9830, 7.7713>
		<-2.9748, 8.9896, 7.7501> <-2.9856, 8.9802, 7.7577> <-2.9876, 8.9741, 7.7652> <-3.0016, 8.9633, 7.7697>
		<-2.9546, 8.9663, 7.7505> <-2.9639, 8.9543, 7.7581> <-2.9654, 8.9486, 7.7651> <-2.9801, 8.9372, 7.7699>
		<-2.9409, 8.9483, 7.7466> <-2.9502, 8.9363, 7.7541> <-2.9504, 8.9287, 7.7613> <-2.9651, 8.9173, 7.7661>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0173, 8.9830, 7.7713> <-3.0313, 8.9721, 7.7759> <-3.0384, 8.9682, 7.7717> <-3.0517, 8.9589, 7.7719>
		<-3.0016, 8.9633, 7.7697> <-3.0156, 8.9524, 7.7743> <-3.0245, 8.9501, 7.7703> <-3.0378, 8.9408, 7.7706>
		<-2.9801, 8.9372, 7.7699> <-2.9948, 8.9258, 7.7747> <-3.0030, 8.9240, 7.7708> <-3.0185, 8.9167, 7.7713>
		<-2.9651, 8.9173, 7.7661> <-2.9799, 8.9059, 7.7709> <-2.9897, 8.9058, 7.7669> <-3.0051, 8.8985, 7.7675>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9155, 8.9101, 7.7301> <-2.9231, 8.9216, 7.7350> <-2.9322, 8.9368, 7.7440> <-2.9409, 8.9483, 7.7466>
		<-2.9147, 8.8848, 7.7358> <-2.9223, 8.8963, 7.7408> <-2.9415, 8.9249, 7.7516> <-2.9502, 8.9363, 7.7541>
		<-2.8908, 8.8618, 7.7376> <-2.9063, 8.8836, 7.7439> <-2.9341, 8.9069, 7.7572> <-2.9504, 8.9287, 7.7613>
		<-2.9134, 8.8446, 7.7449> <-2.9289, 8.8664, 7.7513> <-2.9488, 8.8956, 7.7619> <-2.9651, 8.9173, 7.7661>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9134, 8.8446, 7.7449> <-2.9289, 8.8664, 7.7513> <-2.9488, 8.8956, 7.7619> <-2.9651, 8.9173, 7.7661>
		<-2.9365, 8.8270, 7.7525> <-2.9520, 8.8488, 7.7589> <-2.9635, 8.8841, 7.7667> <-2.9799, 8.9059, 7.7709>
		<-2.9543, 8.8546, 7.7488> <-2.9619, 8.8659, 7.7537> <-2.9813, 8.8943, 7.7645> <-2.9897, 8.9058, 7.7669>
		<-2.9801, 8.8609, 7.7512> <-2.9876, 8.8722, 7.7561> <-2.9967, 8.8870, 7.7651> <-3.0051, 8.8985, 7.7675>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2936, 8.9430, 7.4111> <-3.3036, 8.9311, 7.4168> <-3.3050, 8.9233, 7.4217> <-3.3195, 8.9122, 7.4258>
		<-3.2894, 8.9325, 7.3958> <-3.2994, 8.9206, 7.4015> <-3.3005, 8.9113, 7.4051> <-3.3150, 8.9002, 7.4092>
		<-3.2827, 8.9175, 7.3762> <-3.2923, 8.9037, 7.3802> <-3.2933, 8.8952, 7.3832> <-3.3084, 8.8836, 7.3875>
		<-3.2796, 8.9079, 7.3601> <-3.2893, 8.8941, 7.3640> <-3.2895, 8.8838, 7.3660> <-3.3046, 8.8722, 7.3703>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3195, 8.9122, 7.4258> <-3.3339, 8.9011, 7.4300> <-3.3431, 8.9008, 7.4280> <-3.3579, 8.8936, 7.4294>
		<-3.3150, 8.9002, 7.4092> <-3.3294, 8.8891, 7.4133> <-3.3394, 8.8898, 7.4129> <-3.3543, 8.8826, 7.4143>
		<-3.3084, 8.8836, 7.3875> <-3.3235, 8.8720, 7.3918> <-3.3326, 8.8728, 7.3916> <-3.3485, 8.8669, 7.3950>
		<-3.3046, 8.8722, 7.3703> <-3.3197, 8.8606, 7.3746> <-3.3299, 8.8629, 7.3756> <-3.3458, 8.8570, 7.3789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2765, 8.8894, 7.3213> <-3.2775, 8.8949, 7.3329> <-3.2775, 8.9013, 7.3491> <-3.2796, 8.9079, 7.3601>
		<-3.2825, 8.8667, 7.3140> <-3.2834, 8.8722, 7.3257> <-3.2872, 8.8875, 7.3531> <-3.2893, 8.8941, 7.3640>
		<-3.2706, 8.8470, 7.2962> <-3.2743, 8.8595, 7.3165> <-3.2851, 8.8707, 7.3462> <-3.2895, 8.8838, 7.3660>
		<-3.2920, 8.8306, 7.3025> <-3.2958, 8.8431, 7.3229> <-3.3002, 8.8591, 7.3505> <-3.3046, 8.8722, 7.3703>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2920, 8.8306, 7.3025> <-3.2958, 8.8431, 7.3229> <-3.3002, 8.8591, 7.3505> <-3.3046, 8.8722, 7.3703>
		<-3.3137, 8.8141, 7.3089> <-3.3174, 8.8266, 7.3292> <-3.3153, 8.8475, 7.3548> <-3.3197, 8.8606, 7.3746>
		<-3.3232, 8.8357, 7.3260> <-3.3241, 8.8411, 7.3375> <-3.3281, 8.8563, 7.3649> <-3.3299, 8.8629, 7.3756>
		<-3.3427, 8.8388, 7.3407> <-3.3437, 8.8443, 7.3522> <-3.3440, 8.8504, 7.3682> <-3.3458, 8.8570, 7.3789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4913, 8.9489, 7.4858> <-3.5011, 8.9364, 7.4896> <-3.5023, 8.9278, 7.4923> <-3.5166, 8.9166, 7.4957>
		<-3.4905, 8.9434, 7.4686> <-3.5002, 8.9309, 7.4724> <-3.5016, 8.9213, 7.4735> <-3.5158, 8.9101, 7.4769>
		<-3.4882, 8.9349, 7.4461> <-3.4981, 8.9212, 7.4478> <-3.4993, 8.9123, 7.4486> <-3.5141, 8.9007, 7.4521>
		<-3.4885, 8.9305, 7.4286> <-3.4984, 8.9168, 7.4303> <-3.4992, 8.9066, 7.4296> <-3.5140, 8.8949, 7.4331>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5166, 8.9166, 7.4957> <-3.5308, 8.9054, 7.4990> <-3.5399, 8.9059, 7.4987> <-3.5546, 8.8992, 7.5007>
		<-3.5158, 8.9101, 7.4769> <-3.5300, 8.8989, 7.4802> <-3.5397, 8.8999, 7.4817> <-3.5544, 8.8932, 7.4837>
		<-3.5141, 8.9007, 7.4521> <-3.5290, 8.8890, 7.4556> <-3.5378, 8.8900, 7.4572> <-3.5531, 8.8840, 7.4614>
		<-3.5140, 8.8949, 7.4331> <-3.5289, 8.8833, 7.4366> <-3.5384, 8.8853, 7.4398> <-3.5537, 8.8793, 7.4440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4930, 8.9243, 7.3884> <-3.4917, 8.9262, 7.4005> <-3.4888, 8.9275, 7.4167> <-3.4885, 8.9305, 7.4286>
		<-3.5018, 8.9054, 7.3773> <-3.5005, 8.9073, 7.3893> <-3.4986, 8.9138, 7.4184> <-3.4984, 8.9168, 7.4303>
		<-3.4951, 8.8916, 7.3544> <-3.4946, 8.8975, 7.3765> <-3.4991, 8.9000, 7.4077> <-3.4992, 8.9066, 7.4296>
		<-3.5157, 8.8754, 7.3594> <-3.5152, 8.8813, 7.3815> <-3.5139, 8.8883, 7.4112> <-3.5140, 8.8949, 7.4331>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5157, 8.8754, 7.3594> <-3.5152, 8.8813, 7.3815> <-3.5139, 8.8883, 7.4112> <-3.5140, 8.8949, 7.4331>
		<-3.5366, 8.8591, 7.3645> <-3.5361, 8.8649, 7.3866> <-3.5287, 8.8767, 7.4147> <-3.5289, 8.8833, 7.4366>
		<-3.5418, 8.8741, 7.3871> <-3.5404, 8.8759, 7.3989> <-3.5388, 8.8822, 7.4281> <-3.5384, 8.8853, 7.4398>
		<-3.5581, 8.8733, 7.4044> <-3.5568, 8.8751, 7.4163> <-3.5541, 8.8762, 7.4323> <-3.5537, 8.8793, 7.4440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7229, 8.9864, 7.5346> <-3.7318, 8.9768, 7.5368> <-3.7336, 8.9695, 7.5374> <-3.7460, 8.9614, 7.5404>
		<-3.7254, 8.9862, 7.5216> <-3.7344, 8.9766, 7.5239> <-3.7366, 8.9690, 7.5232> <-3.7490, 8.9609, 7.5261>
		<-3.7281, 8.9849, 7.5041> <-3.7376, 8.9748, 7.5047> <-3.7397, 8.9679, 7.5039> <-3.7526, 8.9594, 7.5070>
		<-3.7315, 8.9858, 7.4914> <-3.7409, 8.9757, 7.4919> <-3.7431, 8.9680, 7.4898> <-3.7560, 8.9596, 7.4928>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7460, 8.9614, 7.5404> <-3.7583, 8.9533, 7.5433> <-3.7656, 8.9547, 7.5449> <-3.7779, 8.9505, 7.5477>
		<-3.7490, 8.9609, 7.5261> <-3.7613, 8.9528, 7.5291> <-3.7686, 8.9542, 7.5320> <-3.7809, 8.9500, 7.5348>
		<-3.7526, 8.9594, 7.5070> <-3.7654, 8.9510, 7.5101> <-3.7721, 8.9523, 7.5129> <-3.7844, 8.9481, 7.5175>
		<-3.7560, 8.9596, 7.4928> <-3.7689, 8.9512, 7.4959> <-3.7757, 8.9530, 7.5002> <-3.7881, 8.9488, 7.5048>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7416, 8.9913, 7.4634> <-3.7386, 8.9897, 7.4718> <-3.7338, 8.9864, 7.4826> <-3.7315, 8.9858, 7.4914>
		<-3.7528, 8.9803, 7.4539> <-3.7498, 8.9786, 7.4623> <-3.7432, 8.9763, 7.4832> <-3.7409, 8.9757, 7.4919>
		<-3.7537, 8.9738, 7.4346> <-3.7493, 8.9729, 7.4508> <-3.7471, 8.9682, 7.4734> <-3.7431, 8.9680, 7.4898>
		<-3.7707, 8.9626, 7.4388> <-3.7663, 8.9617, 7.4550> <-3.7600, 8.9598, 7.4765> <-3.7560, 8.9596, 7.4928>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7707, 8.9626, 7.4388> <-3.7663, 8.9617, 7.4550> <-3.7600, 8.9598, 7.4765> <-3.7560, 8.9596, 7.4928>
		<-3.7878, 8.9514, 7.4430> <-3.7834, 8.9505, 7.4592> <-3.7728, 8.9514, 7.4796> <-3.7689, 8.9512, 7.4959>
		<-3.7875, 8.9575, 7.4624> <-3.7845, 8.9559, 7.4707> <-3.7782, 8.9535, 7.4916> <-3.7757, 8.9530, 7.5002>
		<-3.7981, 8.9543, 7.4773> <-3.7951, 8.9526, 7.4855> <-3.7906, 8.9493, 7.4963> <-3.7881, 8.9488, 7.5048>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3359, 9.6364, 7.5742> <-3.3418, 9.6284, 7.5896> <-3.3405, 9.6242, 7.5986> <-3.3512, 9.6156, 7.6141>
		<-3.3307, 9.6203, 7.5677> <-3.3366, 9.6123, 7.5831> <-3.3349, 9.6061, 7.5916> <-3.3455, 9.5975, 7.6071>
		<-3.3216, 9.5988, 7.5603> <-3.3270, 9.5882, 7.5751> <-3.3253, 9.5822, 7.5831> <-3.3363, 9.5733, 7.5992>
		<-3.3185, 9.5828, 7.5524> <-3.3239, 9.5722, 7.5673> <-3.3214, 9.5643, 7.5748> <-3.3325, 9.5554, 7.5909>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3512, 9.6156, 7.6141> <-3.3620, 9.6068, 7.6299> <-3.3714, 9.6045, 7.6326> <-3.3842, 9.5975, 7.6443>
		<-3.3455, 9.5975, 7.6071> <-3.3564, 9.5887, 7.6229> <-3.3666, 9.5880, 7.6267> <-3.3793, 9.5810, 7.6384>
		<-3.3363, 9.5733, 7.5992> <-3.3477, 9.5641, 7.6157> <-3.3572, 9.5638, 7.6190> <-3.3710, 9.5589, 7.6320>
		<-3.3325, 9.5554, 7.5909> <-3.3439, 9.5462, 7.6074> <-3.3544, 9.5476, 7.6116> <-3.3681, 9.5427, 7.6246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3183, 9.5460, 7.5299> <-3.3184, 9.5570, 7.5367> <-3.3162, 9.5713, 7.5468> <-3.3185, 9.5828, 7.5524>
		<-3.3200, 9.5221, 7.5390> <-3.3201, 9.5331, 7.5457> <-3.3216, 9.5608, 7.5617> <-3.3239, 9.5722, 7.5673>
		<-3.3078, 9.4960, 7.5315> <-3.3108, 9.5173, 7.5428> <-3.3167, 9.5426, 7.5648> <-3.3214, 9.5643, 7.5748>
		<-3.3228, 9.4841, 7.5533> <-3.3257, 9.5055, 7.5646> <-3.3278, 9.5337, 7.5809> <-3.3325, 9.5554, 7.5909>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3228, 9.4841, 7.5533> <-3.3257, 9.5055, 7.5646> <-3.3278, 9.5337, 7.5809> <-3.3325, 9.5554, 7.5909>
		<-3.3386, 9.4715, 7.5764> <-3.3415, 9.4929, 7.5877> <-3.3392, 9.5245, 7.5974> <-3.3439, 9.5462, 7.6074>
		<-3.3505, 9.4979, 7.5834> <-3.3506, 9.5087, 7.5901> <-3.3523, 9.5362, 7.6063> <-3.3544, 9.5476, 7.6116>
		<-3.3680, 9.5065, 7.6024> <-3.3680, 9.5174, 7.6090> <-3.3661, 9.5313, 7.6193> <-3.3681, 9.5427, 7.6246>
	}
	texture {nokti}
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7344, 12.7939, 10.4207> <-3.7368, 12.7883, 10.3890> <-3.7358, 12.7586, 10.3386> <-3.7275, 12.7080, 10.3463>
		<-3.7002, 12.7976, 10.4123> <-3.7026, 12.7921, 10.3806> <-3.7236, 12.7610, 10.3370> <-3.7153, 12.7104, 10.3446>
		<-3.6551, 12.8023, 10.3982> <-3.6797, 12.7960, 10.3780> <-3.7117, 12.7664, 10.3367> <-3.6994, 12.7172, 10.3491>
		<-3.6231, 12.8071, 10.3838> <-3.6477, 12.8008, 10.3637> <-3.6999, 12.7694, 10.3339> <-3.6876, 12.7203, 10.3462>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7344, 12.7939, 10.4207> <-3.7578, 12.7913, 10.4265> <-3.7925, 12.7888, 10.4201> <-3.8140, 12.7861, 10.4308>
		<-3.7368, 12.7883, 10.3890> <-3.7601, 12.7858, 10.3948> <-3.7945, 12.7838, 10.3887> <-3.8160, 12.7811, 10.3994>
		<-3.7358, 12.7586, 10.3386> <-3.7589, 12.7542, 10.3417> <-3.7994, 12.7484, 10.3352> <-3.8126, 12.7481, 10.3549>
		<-3.7275, 12.7080, 10.3463> <-3.7507, 12.7036, 10.3493> <-3.7914, 12.6983, 10.3420> <-3.8046, 12.6980, 10.3618>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7344, 12.7939, 10.4207> <-3.7323, 12.7988, 10.4487> <-3.7205, 12.7629, 10.4959> <-3.7160, 12.7351, 10.5001>
		<-3.7578, 12.7913, 10.4265> <-3.7557, 12.7963, 10.4544> <-3.7442, 12.7595, 10.4995> <-3.7396, 12.7317, 10.5038>
		<-3.7925, 12.7888, 10.4201> <-3.7906, 12.7933, 10.4483> <-3.7763, 12.7517, 10.4956> <-3.7719, 12.7237, 10.4994>
		<-3.8140, 12.7861, 10.4308> <-3.8121, 12.7906, 10.4590> <-3.7996, 12.7488, 10.5015> <-3.7951, 12.7208, 10.5053>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7344, 12.7939, 10.4207> <-3.7002, 12.7976, 10.4123> <-3.6551, 12.8023, 10.3982> <-3.6231, 12.8071, 10.3838>
		<-3.7323, 12.7988, 10.4487> <-3.6981, 12.8026, 10.4403> <-3.6279, 12.8092, 10.4204> <-3.5959, 12.8140, 10.4061>
		<-3.7205, 12.7629, 10.4959> <-3.6678, 12.7705, 10.4878> <-3.5985, 12.7876, 10.4796> <-3.5494, 12.7913, 10.4576>
		<-3.7160, 12.7351, 10.5001> <-3.6632, 12.7428, 10.4920> <-3.5901, 12.7539, 10.4880> <-3.5410, 12.7576, 10.4661>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7160, 12.7351, 10.5001> <-3.6632, 12.7428, 10.4920> <-3.5901, 12.7539, 10.4880> <-3.5410, 12.7576, 10.4661>
		<-3.7113, 12.7065, 10.5044> <-3.6586, 12.7141, 10.4963> <-3.5819, 12.7212, 10.4962> <-3.5329, 12.7249, 10.4743>
		<-3.7087, 12.6543, 10.4714> <-3.6707, 12.6572, 10.4662> <-3.5859, 12.6515, 10.4215> <-3.5859, 12.6515, 10.4216>
		<-3.7108, 12.6492, 10.4426> <-3.6729, 12.6521, 10.4374> <-3.5844, 12.6519, 10.4228> <-3.5844, 12.6519, 10.4228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7160, 12.7351, 10.5001> <-3.7113, 12.7065, 10.5044> <-3.7087, 12.6543, 10.4714> <-3.7108, 12.6492, 10.4426>
		<-3.7396, 12.7317, 10.5038> <-3.7350, 12.7031, 10.5081> <-3.7326, 12.6524, 10.4747> <-3.7347, 12.6473, 10.4459>
		<-3.7719, 12.7237, 10.4994> <-3.7674, 12.6958, 10.5033> <-3.7671, 12.6419, 10.4674> <-3.7690, 12.6374, 10.4392>
		<-3.7951, 12.7208, 10.5053> <-3.7907, 12.6929, 10.5091> <-3.7881, 12.6404, 10.4794> <-3.7899, 12.6359, 10.4513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7108, 12.6492, 10.4426> <-3.6729, 12.6521, 10.4374> <-3.5844, 12.6519, 10.4228> <-3.5844, 12.6519, 10.4228>
		<-3.7132, 12.6436, 10.4108> <-3.6753, 12.6465, 10.4056> <-3.5826, 12.6523, 10.4242> <-3.5826, 12.6523, 10.4243>
		<-3.7192, 12.6573, 10.3539> <-3.7070, 12.6596, 10.3523> <-3.6838, 12.6547, 10.3648> <-3.6720, 12.6578, 10.3619>
		<-3.7275, 12.7080, 10.3463> <-3.7153, 12.7104, 10.3446> <-3.6994, 12.7172, 10.3491> <-3.6876, 12.7203, 10.3462>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7108, 12.6492, 10.4426> <-3.7132, 12.6436, 10.4108> <-3.7192, 12.6573, 10.3539> <-3.7275, 12.7080, 10.3463>
		<-3.7347, 12.6473, 10.4459> <-3.7371, 12.6417, 10.4142> <-3.7424, 12.6529, 10.3570> <-3.7507, 12.7036, 10.3493>
		<-3.7690, 12.6374, 10.4392> <-3.7710, 12.6325, 10.4085> <-3.7835, 12.6493, 10.3487> <-3.7914, 12.6983, 10.3420>
		<-3.7899, 12.6359, 10.4513> <-3.7920, 12.6310, 10.4206> <-3.7968, 12.6490, 10.3685> <-3.8046, 12.6980, 10.3618>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8140, 12.7861, 10.4308> <-3.8278, 12.7844, 10.4377> <-3.8281, 12.7857, 10.4791> <-3.8419, 12.7805, 10.4742>
		<-3.8160, 12.7811, 10.3994> <-3.8299, 12.7794, 10.4063> <-3.8117, 12.7835, 10.4580> <-3.8255, 12.7783, 10.4531>
		<-3.8126, 12.7481, 10.3549> <-3.8263, 12.7477, 10.3755> <-3.7979, 12.7141, 10.4396> <-3.7935, 12.7155, 10.4406>
		<-3.8046, 12.6980, 10.3618> <-3.8183, 12.6977, 10.3823> <-3.7963, 12.7051, 10.4415> <-3.7920, 12.7066, 10.4426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8140, 12.7861, 10.4308> <-3.8121, 12.7906, 10.4590> <-3.7996, 12.7488, 10.5015> <-3.7951, 12.7208, 10.5053>
		<-3.8278, 12.7844, 10.4377> <-3.8260, 12.7889, 10.4659> <-3.8222, 12.7460, 10.5072> <-3.8177, 12.7180, 10.5110>
		<-3.8281, 12.7857, 10.4791> <-3.8443, 12.7879, 10.5000> <-3.8484, 12.7468, 10.5388> <-3.8440, 12.7213, 10.5445>
		<-3.8419, 12.7805, 10.4742> <-3.8581, 12.7827, 10.4951> <-3.8704, 12.7420, 10.5324> <-3.8661, 12.7164, 10.5380>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7951, 12.7208, 10.5053> <-3.7907, 12.6929, 10.5091> <-3.7881, 12.6404, 10.4794> <-3.7899, 12.6359, 10.4513>
		<-3.8177, 12.7180, 10.5110> <-3.8132, 12.6901, 10.5148> <-3.8038, 12.6393, 10.4885> <-3.8057, 12.6348, 10.4604>
		<-3.8440, 12.7213, 10.5445> <-3.8396, 12.6954, 10.5501> <-3.8174, 12.6467, 10.5307> <-3.8010, 12.6445, 10.5095>
		<-3.8661, 12.7164, 10.5380> <-3.8617, 12.6905, 10.5437> <-3.8347, 12.6439, 10.5258> <-3.8183, 12.6417, 10.5046>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7899, 12.6359, 10.4513> <-3.7920, 12.6310, 10.4206> <-3.7968, 12.6490, 10.3685> <-3.8046, 12.6980, 10.3618>
		<-3.8057, 12.6348, 10.4604> <-3.8077, 12.6300, 10.4297> <-3.8105, 12.6487, 10.3890> <-3.8183, 12.6977, 10.3823>
		<-3.8010, 12.6445, 10.5095> <-3.7848, 12.6424, 10.4887> <-3.7948, 12.6963, 10.4435> <-3.7963, 12.7051, 10.4415>
		<-3.8183, 12.6417, 10.5046> <-3.8021, 12.6396, 10.4838> <-3.7905, 12.6977, 10.4446> <-3.7920, 12.7066, 10.4426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8419, 12.7805, 10.4742> <-3.8826, 12.7652, 10.4597> <-3.9189, 12.7468, 10.4079> <-3.9535, 12.7335, 10.3811>
		<-3.8255, 12.7783, 10.4531> <-3.8662, 12.7630, 10.4386> <-3.9022, 12.7446, 10.3865> <-3.9369, 12.7313, 10.3596>
		<-3.7935, 12.7155, 10.4406> <-3.7854, 12.7182, 10.4426> <-3.8680, 12.7216, 10.3550> <-3.9039, 12.7096, 10.3287>
		<-3.7920, 12.7066, 10.4426> <-3.7839, 12.7092, 10.4446> <-3.8621, 12.6794, 10.3650> <-3.8981, 12.6674, 10.3387>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8419, 12.7805, 10.4742> <-3.8581, 12.7827, 10.4951> <-3.8704, 12.7420, 10.5324> <-3.8661, 12.7164, 10.5380>
		<-3.8826, 12.7652, 10.4597> <-3.8988, 12.7673, 10.4806> <-3.9133, 12.7325, 10.5199> <-3.9090, 12.7069, 10.5256>
		<-3.9189, 12.7468, 10.4079> <-3.9350, 12.7490, 10.4288> <-3.9533, 12.7163, 10.4712> <-3.9498, 12.6908, 10.4773>
		<-3.9535, 12.7335, 10.3811> <-3.9697, 12.7357, 10.4019> <-3.9881, 12.7044, 10.4441> <-3.9846, 12.6789, 10.4502>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8661, 12.7164, 10.5380> <-3.8617, 12.6905, 10.5437> <-3.8347, 12.6439, 10.5258> <-3.8183, 12.6417, 10.5046>
		<-3.9090, 12.7069, 10.5256> <-3.9045, 12.6810, 10.5312> <-3.8788, 12.6367, 10.5133> <-3.8624, 12.6345, 10.4922>
		<-3.9498, 12.6908, 10.4773> <-3.9463, 12.6658, 10.4832> <-3.9172, 12.6255, 10.4580> <-3.9013, 12.6234, 10.4375>
		<-3.9846, 12.6789, 10.4502> <-3.9811, 12.6538, 10.4561> <-3.9526, 12.6141, 10.4302> <-3.9367, 12.6120, 10.4098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8183, 12.6417, 10.5046> <-3.8021, 12.6396, 10.4838> <-3.7905, 12.6977, 10.4446> <-3.7920, 12.7066, 10.4426>
		<-3.8624, 12.6345, 10.4922> <-3.8462, 12.6324, 10.4713> <-3.7824, 12.7004, 10.4466> <-3.7839, 12.7092, 10.4446>
		<-3.9013, 12.6234, 10.4375> <-3.8843, 12.6212, 10.4157> <-3.8562, 12.6363, 10.3752> <-3.8621, 12.6794, 10.3650>
		<-3.9367, 12.6120, 10.4098> <-3.9197, 12.6098, 10.3879> <-3.8921, 12.6244, 10.3489> <-3.8981, 12.6674, 10.3387>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9535, 12.7335, 10.3811> <-3.9771, 12.7245, 10.3628> <-3.9937, 12.7209, 10.3523> <-4.0359, 12.7063, 10.3237>
		<-3.9369, 12.7313, 10.3596> <-3.9605, 12.7223, 10.3413> <-3.9684, 12.7175, 10.3196> <-4.0105, 12.7028, 10.2911>
		<-3.9039, 12.7096, 10.3287> <-3.9284, 12.7015, 10.3108> <-3.9990, 12.6434, 10.2915> <-3.9916, 12.6458, 10.2963>
		<-3.8981, 12.6674, 10.3387> <-3.9226, 12.6592, 10.3208> <-3.9980, 12.6379, 10.2928> <-3.9906, 12.6403, 10.2975>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9535, 12.7335, 10.3811> <-3.9697, 12.7357, 10.4019> <-3.9881, 12.7044, 10.4441> <-3.9846, 12.6789, 10.4502>
		<-3.9771, 12.7245, 10.3628> <-3.9933, 12.7267, 10.3836> <-4.0116, 12.6964, 10.4259> <-4.0080, 12.6708, 10.4319>
		<-3.9937, 12.7209, 10.3523> <-4.0203, 12.7246, 10.3865> <-4.0413, 12.6823, 10.4002> <-4.0370, 12.6582, 10.4055>
		<-4.0359, 12.7063, 10.3237> <-4.0625, 12.7099, 10.3579> <-4.0644, 12.6739, 10.3817> <-4.0601, 12.6498, 10.3870>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9846, 12.6789, 10.4502> <-3.9811, 12.6538, 10.4561> <-3.9526, 12.6141, 10.4302> <-3.9367, 12.6120, 10.4098>
		<-4.0080, 12.6708, 10.4319> <-4.0046, 12.6458, 10.4378> <-3.9757, 12.6066, 10.4121> <-3.9599, 12.6045, 10.3916>
		<-4.0370, 12.6582, 10.4055> <-4.0324, 12.6331, 10.4111> <-3.9995, 12.5960, 10.4158> <-3.9718, 12.5922, 10.3801>
		<-4.0601, 12.6498, 10.3870> <-4.0556, 12.6247, 10.3926> <-4.0407, 12.5827, 10.3877> <-4.0129, 12.5789, 10.3520>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9367, 12.6120, 10.4098> <-3.9197, 12.6098, 10.3879> <-3.8921, 12.6244, 10.3489> <-3.8981, 12.6674, 10.3387>
		<-3.9599, 12.6045, 10.3916> <-3.9429, 12.6023, 10.3698> <-3.9166, 12.6162, 10.3310> <-3.9226, 12.6592, 10.3208>
		<-3.9718, 12.5922, 10.3801> <-3.9461, 12.5887, 10.3471> <-3.9970, 12.6323, 10.2940> <-3.9980, 12.6379, 10.2928>
		<-4.0129, 12.5789, 10.3520> <-3.9873, 12.5754, 10.3190> <-3.9896, 12.6348, 10.2988> <-3.9906, 12.6403, 10.2975>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0359, 12.7063, 10.3237> <-4.0820, 12.6902, 10.2925> <-4.0999, 12.6845, 10.2816> <-4.1267, 12.6733, 10.2637>
		<-4.0105, 12.7028, 10.2911> <-4.0566, 12.6868, 10.2598> <-4.0870, 12.6814, 10.2591> <-4.1138, 12.6701, 10.2413>
		<-3.9916, 12.6458, 10.2963> <-3.9822, 12.6489, 10.3024> <-4.0638, 12.6553, 10.2273> <-4.0955, 12.6448, 10.2053>
		<-3.9906, 12.6403, 10.2975> <-3.9812, 12.6434, 10.3036> <-4.0574, 12.6152, 10.2373> <-4.0891, 12.6046, 10.2154>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0359, 12.7063, 10.3237> <-4.0625, 12.7099, 10.3579> <-4.0644, 12.6739, 10.3817> <-4.0601, 12.6498, 10.3870>
		<-4.0820, 12.6902, 10.2925> <-4.1086, 12.6939, 10.3267> <-4.0905, 12.6644, 10.3608> <-4.0862, 12.6404, 10.3662>
		<-4.0999, 12.6845, 10.2816> <-4.1111, 12.6873, 10.3012> <-4.1071, 12.6826, 10.3527> <-4.1000, 12.6381, 10.3639>
		<-4.1267, 12.6733, 10.2637> <-4.1379, 12.6761, 10.2833> <-4.1558, 12.6638, 10.3080> <-4.1487, 12.6193, 10.3191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0601, 12.6498, 10.3870> <-4.0556, 12.6247, 10.3926> <-4.0407, 12.5827, 10.3877> <-4.0129, 12.5789, 10.3520>
		<-4.0862, 12.6404, 10.3662> <-4.0817, 12.6153, 10.3717> <-4.0871, 12.5676, 10.3560> <-4.0594, 12.5638, 10.3203>
		<-4.1000, 12.6381, 10.3639> <-4.0930, 12.5942, 10.3748> <-4.0910, 12.5653, 10.3308> <-4.0799, 12.5626, 10.3115>
		<-4.1487, 12.6193, 10.3191> <-4.1417, 12.5754, 10.3301> <-4.1192, 12.5592, 10.3123> <-4.1081, 12.5564, 10.2929>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0129, 12.5789, 10.3520> <-3.9873, 12.5754, 10.3190> <-3.9896, 12.6348, 10.2988> <-3.9906, 12.6403, 10.2975>
		<-4.0594, 12.5638, 10.3203> <-4.0337, 12.5603, 10.2873> <-3.9802, 12.6379, 10.3049> <-3.9812, 12.6434, 10.3036>
		<-4.0799, 12.5626, 10.3115> <-4.0668, 12.5594, 10.2887> <-4.0509, 12.5744, 10.2475> <-4.0574, 12.6152, 10.2373>
		<-4.1081, 12.5564, 10.2929> <-4.0950, 12.5532, 10.2702> <-4.0826, 12.5639, 10.2255> <-4.0891, 12.6046, 10.2154>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1267, 12.6733, 10.2637> <-4.1477, 12.6645, 10.2497> <-4.1746, 12.6511, 10.2302> <-4.1952, 12.6397, 10.2176>
		<-4.1138, 12.6701, 10.2413> <-4.1348, 12.6614, 10.2273> <-4.1615, 12.6493, 10.2133> <-4.1821, 12.6379, 10.2008>
		<-4.0955, 12.6448, 10.2053> <-4.1133, 12.6389, 10.1930> <-4.1377, 12.6239, 10.1812> <-4.1590, 12.6190, 10.1759>
		<-4.0891, 12.6046, 10.2154> <-4.1069, 12.5987, 10.2030> <-4.1331, 12.5908, 10.1892> <-4.1543, 12.5858, 10.1838>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1267, 12.6733, 10.2637> <-4.1379, 12.6761, 10.2833> <-4.1558, 12.6638, 10.3080> <-4.1487, 12.6193, 10.3191>
		<-4.1477, 12.6645, 10.2497> <-4.1590, 12.6673, 10.2693> <-4.1948, 12.6487, 10.2720> <-4.1878, 12.6042, 10.2831>
		<-4.1746, 12.6511, 10.2302> <-4.1848, 12.6525, 10.2434> <-4.1571, 12.6706, 10.3010> <-4.1497, 12.6178, 10.3136>
		<-4.1952, 12.6397, 10.2176> <-4.2054, 12.6411, 10.2308> <-4.2146, 12.6459, 10.2391> <-4.2071, 12.5931, 10.2517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1487, 12.6193, 10.3191> <-4.1417, 12.5754, 10.3301> <-4.1192, 12.5592, 10.3123> <-4.1081, 12.5564, 10.2929>
		<-4.1878, 12.6042, 10.2831> <-4.1808, 12.5603, 10.2941> <-4.1416, 12.5543, 10.2975> <-4.1305, 12.5515, 10.2781>
		<-4.1497, 12.6178, 10.3136> <-4.1424, 12.5658, 10.3260> <-4.1691, 12.5461, 10.2692> <-4.1591, 12.5447, 10.2563>
		<-4.2071, 12.5931, 10.2517> <-4.1998, 12.5411, 10.2641> <-4.1916, 12.5435, 10.2538> <-4.1815, 12.5421, 10.2409>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1081, 12.5564, 10.2929> <-4.0950, 12.5532, 10.2702> <-4.0826, 12.5639, 10.2255> <-4.0891, 12.6046, 10.2154>
		<-4.1305, 12.5515, 10.2781> <-4.1175, 12.5483, 10.2554> <-4.1004, 12.5580, 10.2132> <-4.1069, 12.5987, 10.2030>
		<-4.1591, 12.5447, 10.2563> <-4.1457, 12.5429, 10.2392> <-4.1284, 12.5570, 10.1972> <-4.1331, 12.5908, 10.1892>
		<-4.1815, 12.5421, 10.2409> <-4.1682, 12.5403, 10.2238> <-4.1496, 12.5521, 10.1919> <-4.1543, 12.5858, 10.1838>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1952, 12.6397, 10.2176> <-4.2052, 12.6341, 10.2115> <-4.2216, 12.6276, 10.2047> <-4.2283, 12.6170, 10.2018>
		<-4.1821, 12.6379, 10.2008> <-4.1921, 12.6323, 10.1947> <-4.2140, 12.6262, 10.1935> <-4.2208, 12.6156, 10.1905>
		<-4.1590, 12.6190, 10.1759> <-4.1742, 12.6155, 10.1720> <-4.1951, 12.6001, 10.1776> <-4.2108, 12.5981, 10.1806>
		<-4.1543, 12.5858, 10.1838> <-4.1696, 12.5823, 10.1800> <-4.1916, 12.5791, 10.1825> <-4.2072, 12.5771, 10.1855>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1952, 12.6397, 10.2176> <-4.2054, 12.6411, 10.2308> <-4.2146, 12.6459, 10.2391> <-4.2071, 12.5931, 10.2517>
		<-4.2052, 12.6341, 10.2115> <-4.2154, 12.6355, 10.2247> <-4.2386, 12.6355, 10.2132> <-4.2312, 12.5827, 10.2258>
		<-4.2216, 12.6276, 10.2047> <-4.2283, 12.6289, 10.2148> <-4.2272, 12.6157, 10.2415> <-4.2228, 12.5894, 10.2477>
		<-4.2283, 12.6170, 10.2018> <-4.2351, 12.6183, 10.2118> <-4.2391, 12.6085, 10.2202> <-4.2346, 12.5822, 10.2264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2071, 12.5931, 10.2517> <-4.1998, 12.5411, 10.2641> <-4.1916, 12.5435, 10.2538> <-4.1815, 12.5421, 10.2409>
		<-4.2312, 12.5827, 10.2258> <-4.2239, 12.5307, 10.2382> <-4.2016, 12.5423, 10.2469> <-4.1916, 12.5409, 10.2340>
		<-4.2228, 12.5894, 10.2477> <-4.2183, 12.5630, 10.2539> <-4.2139, 12.5399, 10.2357> <-4.2071, 12.5387, 10.2256>
		<-4.2346, 12.5822, 10.2264> <-4.2301, 12.5559, 10.2326> <-4.2227, 12.5453, 10.2290> <-4.2159, 12.5441, 10.2189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1815, 12.5421, 10.2409> <-4.1682, 12.5403, 10.2238> <-4.1496, 12.5521, 10.1919> <-4.1543, 12.5858, 10.1838>
		<-4.1916, 12.5409, 10.2340> <-4.1783, 12.5391, 10.2168> <-4.1648, 12.5486, 10.1880> <-4.1696, 12.5823, 10.1800>
		<-4.2071, 12.5387, 10.2256> <-4.1996, 12.5373, 10.2144> <-4.1880, 12.5582, 10.1874> <-4.1916, 12.5791, 10.1825>
		<-4.2159, 12.5441, 10.2189> <-4.2084, 12.5427, 10.2077> <-4.2037, 12.5562, 10.1904> <-4.2072, 12.5771, 10.1855>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2362, 12.5755, 10.1996> <-4.2349, 12.5676, 10.2014> <-4.2250, 12.5496, 10.2121> <-4.2159, 12.5441, 10.2189>
		<-4.2362, 12.5755, 10.1996> <-4.2314, 12.5669, 10.1962> <-4.2175, 12.5482, 10.2009> <-4.2084, 12.5427, 10.2077>
		<-4.2362, 12.5755, 10.1996> <-4.2314, 12.5669, 10.1962> <-4.2131, 12.5550, 10.1923> <-4.2037, 12.5562, 10.1904>
		<-4.2362, 12.5755, 10.1996> <-4.2327, 12.5749, 10.1944> <-4.2167, 12.5760, 10.1873> <-4.2072, 12.5771, 10.1855>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2362, 12.5755, 10.1996> <-4.2327, 12.5749, 10.1944> <-4.2167, 12.5760, 10.1873> <-4.2072, 12.5771, 10.1855>
		<-4.2362, 12.5755, 10.1996> <-4.2341, 12.5828, 10.1925> <-4.2202, 12.5969, 10.1824> <-4.2108, 12.5981, 10.1806>
		<-4.2362, 12.5755, 10.1996> <-4.2341, 12.5828, 10.1925> <-4.2275, 12.6052, 10.1876> <-4.2208, 12.6156, 10.1905>
		<-4.2362, 12.5755, 10.1996> <-4.2376, 12.5835, 10.1977> <-4.2350, 12.6066, 10.1988> <-4.2283, 12.6170, 10.2018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2362, 12.5755, 10.1996> <-4.2376, 12.5835, 10.1977> <-4.2350, 12.6066, 10.1988> <-4.2283, 12.6170, 10.2018>
		<-4.2362, 12.5755, 10.1996> <-4.2406, 12.5840, 10.2022> <-4.2418, 12.6079, 10.2089> <-4.2351, 12.6183, 10.2118>
		<-4.2362, 12.5755, 10.1996> <-4.2406, 12.5840, 10.2022> <-4.2476, 12.6035, 10.2051> <-4.2391, 12.6085, 10.2202>
		<-4.2362, 12.5755, 10.1996> <-4.2392, 12.5761, 10.2041> <-4.2431, 12.5771, 10.2113> <-4.2346, 12.5822, 10.2264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2362, 12.5755, 10.1996> <-4.2392, 12.5761, 10.2041> <-4.2431, 12.5771, 10.2113> <-4.2346, 12.5822, 10.2264>
		<-4.2362, 12.5755, 10.1996> <-4.2379, 12.5682, 10.2059> <-4.2386, 12.5508, 10.2175> <-4.2301, 12.5559, 10.2326>
		<-4.2362, 12.5755, 10.1996> <-4.2379, 12.5682, 10.2059> <-4.2318, 12.5509, 10.2222> <-4.2227, 12.5453, 10.2290>
		<-4.2362, 12.5755, 10.1996> <-4.2349, 12.5676, 10.2014> <-4.2250, 12.5496, 10.2121> <-4.2159, 12.5441, 10.2189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7198, 12.6347, 10.4697> <-3.7293, 12.6303, 10.4391> <-3.7351, 12.6028, 10.3872> <-3.7290, 12.5515, 10.3923>
		<-3.7451, 12.6321, 10.4779> <-3.7546, 12.6277, 10.4473> <-3.7605, 12.5989, 10.3947> <-3.7544, 12.5476, 10.3997>
		<-3.7807, 12.6309, 10.4837> <-3.7882, 12.6270, 10.4530> <-3.8002, 12.5956, 10.3973> <-3.7943, 12.5450, 10.4017>
		<-3.8051, 12.6291, 10.4945> <-3.8125, 12.6252, 10.4638> <-3.8192, 12.5957, 10.4161> <-3.8133, 12.5451, 10.4205>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7198, 12.6347, 10.4697> <-3.6788, 12.6390, 10.4563> <-3.5844, 12.6518, 10.4228> <-3.5844, 12.6519, 10.4228>
		<-3.7293, 12.6303, 10.4391> <-3.6883, 12.6345, 10.4258> <-3.5832, 12.6520, 10.4242> <-3.5832, 12.6520, 10.4242>
		<-3.7351, 12.6028, 10.3872> <-3.7098, 12.6068, 10.3798> <-3.6701, 12.6205, 10.3769> <-3.6448, 12.6229, 10.3687>
		<-3.7290, 12.5515, 10.3923> <-3.7037, 12.5555, 10.3849> <-3.6702, 12.5691, 10.3793> <-3.6449, 12.5714, 10.3712>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7198, 12.6347, 10.4697> <-3.7115, 12.6387, 10.4965> <-3.6866, 12.6010, 10.5368> <-3.6833, 12.5730, 10.5395>
		<-3.6788, 12.6390, 10.4563> <-3.6705, 12.6429, 10.4832> <-3.6396, 12.6052, 10.5259> <-3.6362, 12.5772, 10.5286>
		<-3.5844, 12.6518, 10.4228> <-3.5857, 12.6517, 10.4214> <-3.5676, 12.6192, 10.5289> <-3.5677, 12.5848, 10.5306>
		<-3.5844, 12.6519, 10.4228> <-3.5857, 12.6517, 10.4213> <-3.5256, 12.6202, 10.5049> <-3.5256, 12.5857, 10.5065>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7198, 12.6347, 10.4697> <-3.7451, 12.6321, 10.4779> <-3.7807, 12.6309, 10.4837> <-3.8051, 12.6291, 10.4945>
		<-3.7115, 12.6387, 10.4965> <-3.7367, 12.6361, 10.5047> <-3.7741, 12.6343, 10.5111> <-3.7984, 12.6325, 10.5219>
		<-3.6866, 12.6010, 10.5368> <-3.7154, 12.5985, 10.5434> <-3.7532, 12.5932, 10.5540> <-3.7815, 12.5914, 10.5627>
		<-3.6833, 12.5730, 10.5395> <-3.7120, 12.5704, 10.5462> <-3.7499, 12.5651, 10.5564> <-3.7782, 12.5633, 10.5651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6833, 12.5730, 10.5395> <-3.6797, 12.5433, 10.5425> <-3.6931, 12.4883, 10.5130> <-3.7019, 12.4841, 10.4845>
		<-3.6362, 12.5772, 10.5286> <-3.6327, 12.5474, 10.5316> <-3.6569, 12.4886, 10.4993> <-3.6657, 12.4845, 10.4709>
		<-3.5677, 12.5848, 10.5306> <-3.5678, 12.5445, 10.5325> <-3.5861, 12.4801, 10.4283> <-3.5837, 12.4804, 10.4309>
		<-3.5256, 12.5857, 10.5065> <-3.5257, 12.5455, 10.5085> <-3.5870, 12.4806, 10.4283> <-3.5847, 12.4809, 10.4309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6833, 12.5730, 10.5395> <-3.7120, 12.5704, 10.5462> <-3.7499, 12.5651, 10.5564> <-3.7782, 12.5633, 10.5651>
		<-3.6797, 12.5433, 10.5425> <-3.7085, 12.5407, 10.5491> <-3.7466, 12.5364, 10.5589> <-3.7749, 12.5346, 10.5676>
		<-3.6931, 12.4883, 10.5130> <-3.7181, 12.4881, 10.5224> <-3.7570, 12.4820, 10.5238> <-3.7809, 12.4827, 10.5356>
		<-3.7019, 12.4841, 10.4845> <-3.7269, 12.4839, 10.4940> <-3.7638, 12.4785, 10.4958> <-3.7877, 12.4792, 10.5076>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7019, 12.4841, 10.4845> <-3.7269, 12.4839, 10.4940> <-3.7638, 12.4785, 10.4958> <-3.7877, 12.4792, 10.5076>
		<-3.7117, 12.4796, 10.4531> <-3.7367, 12.4794, 10.4625> <-3.7712, 12.4747, 10.4651> <-3.7952, 12.4753, 10.4769>
		<-3.7227, 12.4987, 10.3975> <-3.7481, 12.4948, 10.4050> <-3.7884, 12.4944, 10.4061> <-3.8075, 12.4946, 10.4249>
		<-3.7290, 12.5515, 10.3923> <-3.7544, 12.5476, 10.3997> <-3.7943, 12.5450, 10.4017> <-3.8133, 12.5451, 10.4205>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7019, 12.4841, 10.4845> <-3.7117, 12.4796, 10.4531> <-3.7227, 12.4987, 10.3975> <-3.7290, 12.5515, 10.3923>
		<-3.6657, 12.4845, 10.4709> <-3.6755, 12.4799, 10.4394> <-3.6974, 12.5027, 10.3901> <-3.7037, 12.5555, 10.3849>
		<-3.5837, 12.4804, 10.4309> <-3.5817, 12.4806, 10.4332> <-3.6703, 12.5126, 10.3820> <-3.6702, 12.5691, 10.3793>
		<-3.5847, 12.4809, 10.4309> <-3.5826, 12.4811, 10.4333> <-3.6450, 12.5150, 10.3739> <-3.6449, 12.5714, 10.3712>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8051, 12.6291, 10.4945> <-3.8125, 12.6252, 10.4638> <-3.8192, 12.5957, 10.4161> <-3.8133, 12.5451, 10.4205>
		<-3.8271, 12.6275, 10.5042> <-3.8345, 12.6236, 10.4735> <-3.8351, 12.5958, 10.4318> <-3.8293, 12.5452, 10.4362>
		<-3.8496, 12.6288, 10.5409> <-3.8372, 12.6271, 10.5174> <-3.8365, 12.5605, 10.4914> <-3.8349, 12.5515, 10.4927>
		<-3.8728, 12.6235, 10.5371> <-3.8604, 12.6218, 10.5136> <-3.8323, 12.5612, 10.4914> <-3.8307, 12.5522, 10.4927>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8051, 12.6291, 10.4945> <-3.8271, 12.6275, 10.5042> <-3.8496, 12.6288, 10.5409> <-3.8728, 12.6235, 10.5371>
		<-3.7984, 12.6325, 10.5219> <-3.8204, 12.6309, 10.5315> <-3.8619, 12.6304, 10.5641> <-3.8850, 12.6252, 10.5603>
		<-3.7815, 12.5914, 10.5627> <-3.8149, 12.5893, 10.5730> <-3.8588, 12.5904, 10.6031> <-3.8933, 12.5857, 10.5990>
		<-3.7782, 12.5633, 10.5651> <-3.8117, 12.5612, 10.5754> <-3.8544, 12.5647, 10.6068> <-3.8889, 12.5601, 10.6028>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7782, 12.5633, 10.5651> <-3.8117, 12.5612, 10.5754> <-3.8544, 12.5647, 10.6068> <-3.8889, 12.5601, 10.6028>
		<-3.7749, 12.5346, 10.5676> <-3.8084, 12.5325, 10.5779> <-3.8499, 12.5387, 10.6106> <-3.8844, 12.5340, 10.6065>
		<-3.7809, 12.4827, 10.5356> <-3.8023, 12.4832, 10.5460> <-3.8382, 12.4914, 10.5832> <-3.8618, 12.4898, 10.5803>
		<-3.7877, 12.4792, 10.5076> <-3.8091, 12.4797, 10.5181> <-3.8258, 12.4898, 10.5596> <-3.8494, 12.4881, 10.5568>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7877, 12.4792, 10.5076> <-3.8091, 12.4797, 10.5181> <-3.8258, 12.4898, 10.5596> <-3.8494, 12.4881, 10.5568>
		<-3.7952, 12.4753, 10.4769> <-3.8166, 12.4759, 10.4874> <-3.8136, 12.4881, 10.5365> <-3.8372, 12.4864, 10.5337>
		<-3.8075, 12.4946, 10.4249> <-3.8234, 12.4947, 10.4406> <-3.8334, 12.5426, 10.4940> <-3.8292, 12.5433, 10.4940>
		<-3.8133, 12.5451, 10.4205> <-3.8293, 12.5452, 10.4362> <-3.8349, 12.5515, 10.4927> <-3.8307, 12.5522, 10.4927>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8728, 12.6235, 10.5371> <-3.8604, 12.6218, 10.5136> <-3.8323, 12.5612, 10.4914> <-3.8307, 12.5522, 10.4927>
		<-3.9116, 12.6147, 10.5308> <-3.8992, 12.6130, 10.5073> <-3.8249, 12.5624, 10.4913> <-3.8233, 12.5534, 10.4926>
		<-3.9472, 12.5980, 10.4854> <-3.9351, 12.5965, 10.4633> <-3.9097, 12.5728, 10.4326> <-3.9040, 12.5331, 10.4393>
		<-3.9813, 12.5892, 10.4658> <-3.9692, 12.5878, 10.4437> <-3.9439, 12.5648, 10.4144> <-3.9383, 12.5251, 10.4211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8728, 12.6235, 10.5371> <-3.9116, 12.6147, 10.5308> <-3.9472, 12.5980, 10.4854> <-3.9813, 12.5892, 10.4658>
		<-3.8850, 12.6252, 10.5603> <-3.9239, 12.6164, 10.5540> <-3.9601, 12.5995, 10.5089> <-3.9942, 12.5908, 10.4893>
		<-3.8933, 12.5857, 10.5990> <-3.9327, 12.5803, 10.5944> <-3.9725, 12.5673, 10.5539> <-4.0065, 12.5591, 10.5344>
		<-3.8889, 12.5601, 10.6028> <-3.9283, 12.5547, 10.5981> <-3.9688, 12.5411, 10.5582> <-4.0028, 12.5329, 10.5388>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8889, 12.5601, 10.6028> <-3.9283, 12.5547, 10.5981> <-3.9688, 12.5411, 10.5582> <-4.0028, 12.5329, 10.5388>
		<-3.8844, 12.5340, 10.6065> <-3.9238, 12.5287, 10.6019> <-3.9651, 12.5153, 10.5626> <-3.9991, 12.5072, 10.5431>
		<-3.8618, 12.4898, 10.5803> <-3.9023, 12.4869, 10.5754> <-3.9418, 12.4765, 10.5293> <-3.9765, 12.4683, 10.5094>
		<-3.8494, 12.4881, 10.5568> <-3.8898, 12.4852, 10.5519> <-3.9292, 12.4750, 10.5063> <-3.9638, 12.4667, 10.4864>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8494, 12.4881, 10.5568> <-3.8898, 12.4852, 10.5519> <-3.9292, 12.4750, 10.5063> <-3.9638, 12.4667, 10.4864>
		<-3.8372, 12.4864, 10.5337> <-3.8776, 12.4836, 10.5288> <-3.9168, 12.4735, 10.4836> <-3.9514, 12.4652, 10.4637>
		<-3.8292, 12.5433, 10.4940> <-3.8218, 12.5445, 10.4939> <-3.8982, 12.4925, 10.4461> <-3.9325, 12.4846, 10.4279>
		<-3.8307, 12.5522, 10.4927> <-3.8233, 12.5534, 10.4926> <-3.9040, 12.5331, 10.4393> <-3.9383, 12.5251, 10.4211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9813, 12.5892, 10.4658> <-3.9692, 12.5878, 10.4437> <-3.9439, 12.5648, 10.4144> <-3.9383, 12.5251, 10.4211>
		<-4.0089, 12.5822, 10.4500> <-3.9967, 12.5807, 10.4278> <-3.9728, 12.5581, 10.3991> <-3.9671, 12.5184, 10.4058>
		<-4.0304, 12.5824, 10.4456> <-4.0106, 12.5797, 10.4082> <-4.0490, 12.5071, 10.3760> <-4.0481, 12.5014, 10.3768>
		<-4.0777, 12.5709, 10.4194> <-4.0579, 12.5682, 10.3820> <-4.0408, 12.5091, 10.3809> <-4.0399, 12.5034, 10.3817>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9813, 12.5892, 10.4658> <-4.0089, 12.5822, 10.4500> <-4.0304, 12.5824, 10.4456> <-4.0777, 12.5709, 10.4194>
		<-3.9942, 12.5908, 10.4893> <-4.0217, 12.5837, 10.4735> <-4.0512, 12.5852, 10.4850> <-4.0985, 12.5737, 10.4588>
		<-4.0065, 12.5591, 10.5344> <-4.0342, 12.5525, 10.5185> <-4.0721, 12.5428, 10.4994> <-4.0985, 12.5359, 10.4815>
		<-4.0028, 12.5329, 10.5388> <-4.0305, 12.5263, 10.5229> <-4.0681, 12.5177, 10.5028> <-4.0945, 12.5108, 10.4849>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0028, 12.5329, 10.5388> <-4.0305, 12.5263, 10.5229> <-4.0681, 12.5177, 10.5028> <-4.0945, 12.5108, 10.4849>
		<-3.9991, 12.5072, 10.5431> <-4.0268, 12.5006, 10.5272> <-4.0640, 12.4915, 10.5064> <-4.0904, 12.4846, 10.4885>
		<-3.9765, 12.4683, 10.5094> <-4.0042, 12.4617, 10.4935> <-4.0311, 12.4528, 10.5049> <-4.0785, 12.4415, 10.4785>
		<-3.9638, 12.4667, 10.4864> <-3.9915, 12.4601, 10.4704> <-4.0094, 12.4499, 10.4639> <-4.0568, 12.4386, 10.4375>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9638, 12.4667, 10.4864> <-3.9915, 12.4601, 10.4704> <-4.0094, 12.4499, 10.4639> <-4.0568, 12.4386, 10.4375>
		<-3.9514, 12.4652, 10.4637> <-3.9791, 12.4586, 10.4478> <-3.9894, 12.4472, 10.4260> <-4.0367, 12.4359, 10.3996>
		<-3.9325, 12.4846, 10.4279> <-3.9614, 12.4778, 10.4126> <-4.0472, 12.4956, 10.3776> <-4.0390, 12.4976, 10.3825>
		<-3.9383, 12.5251, 10.4211> <-3.9671, 12.5184, 10.4058> <-4.0481, 12.5014, 10.3768> <-4.0399, 12.5034, 10.3817>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0777, 12.5709, 10.4194> <-4.0579, 12.5682, 10.3820> <-4.0408, 12.5091, 10.3809> <-4.0399, 12.5034, 10.3817>
		<-4.1228, 12.5599, 10.3945> <-4.1030, 12.5572, 10.3570> <-4.0330, 12.5111, 10.3856> <-4.0321, 12.5053, 10.3864>
		<-4.1383, 12.5540, 10.3834> <-4.1230, 12.5531, 10.3614> <-4.1000, 12.5292, 10.3249> <-4.0938, 12.4873, 10.3318>
		<-4.1622, 12.5452, 10.3657> <-4.1469, 12.5443, 10.3438> <-4.1249, 12.5223, 10.3058> <-4.1188, 12.4804, 10.3127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0777, 12.5709, 10.4194> <-4.1228, 12.5599, 10.3945> <-4.1383, 12.5540, 10.3834> <-4.1622, 12.5452, 10.3657>
		<-4.0985, 12.5737, 10.4588> <-4.1436, 12.5627, 10.4338> <-4.1514, 12.5548, 10.4023> <-4.1754, 12.5459, 10.3846>
		<-4.0985, 12.5359, 10.4815> <-4.1279, 12.5282, 10.4616> <-4.1453, 12.5459, 10.4549> <-4.1952, 12.5303, 10.4054>
		<-4.0945, 12.5108, 10.4849> <-4.1240, 12.5031, 10.4650> <-4.1386, 12.5000, 10.4625> <-4.1885, 12.4844, 10.4130>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0945, 12.5108, 10.4849> <-4.1240, 12.5031, 10.4650> <-4.1386, 12.5000, 10.4625> <-4.1885, 12.4844, 10.4130>
		<-4.0904, 12.4846, 10.4885> <-4.1198, 12.4770, 10.4686> <-4.1320, 12.4550, 10.4699> <-4.1819, 12.4394, 10.4204>
		<-4.0785, 12.4415, 10.4785> <-4.1233, 12.4309, 10.4535> <-4.1325, 12.4284, 10.4221> <-4.1573, 12.4245, 10.4042>
		<-4.0568, 12.4386, 10.4375> <-4.1016, 12.4279, 10.4125> <-4.1195, 12.4277, 10.4036> <-4.1444, 12.4238, 10.3857>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0568, 12.4386, 10.4375> <-4.1016, 12.4279, 10.4125> <-4.1195, 12.4277, 10.4036> <-4.1444, 12.4238, 10.3857>
		<-4.0367, 12.4359, 10.3996> <-4.0816, 12.4252, 10.3746> <-4.1040, 12.4268, 10.3813> <-4.1289, 12.4229, 10.3634>
		<-4.0390, 12.4976, 10.3825> <-4.0312, 12.4995, 10.3872> <-4.0876, 12.4446, 10.3388> <-4.1125, 12.4378, 10.3197>
		<-4.0399, 12.5034, 10.3817> <-4.0321, 12.5053, 10.3864> <-4.0938, 12.4873, 10.3318> <-4.1188, 12.4804, 10.3127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1622, 12.5452, 10.3657> <-4.1469, 12.5443, 10.3438> <-4.1249, 12.5223, 10.3058> <-4.1188, 12.4804, 10.3127>
		<-4.1840, 12.5371, 10.3496> <-4.1688, 12.5362, 10.3276> <-4.1433, 12.5173, 10.2917> <-4.1372, 12.4753, 10.2986>
		<-4.2093, 12.5254, 10.3236> <-4.1944, 12.5253, 10.3075> <-4.1668, 12.5030, 10.2742> <-4.1624, 12.4684, 10.2794>
		<-4.2297, 12.5147, 10.3072> <-4.2148, 12.5147, 10.2911> <-4.1886, 12.4982, 10.2659> <-4.1841, 12.4637, 10.2711>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1622, 12.5452, 10.3657> <-4.1840, 12.5371, 10.3496> <-4.2093, 12.5254, 10.3236> <-4.2297, 12.5147, 10.3072>
		<-4.1754, 12.5459, 10.3846> <-4.1972, 12.5379, 10.3685> <-4.2209, 12.5254, 10.3362> <-4.2414, 12.5148, 10.3197>
		<-4.1952, 12.5303, 10.4054> <-4.2353, 12.5178, 10.3657> <-4.1967, 12.5385, 10.3990> <-4.2516, 12.5190, 10.3279>
		<-4.1885, 12.4844, 10.4130> <-4.2285, 12.4719, 10.3733> <-4.1896, 12.4834, 10.4074> <-4.2446, 12.4639, 10.3363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1885, 12.4844, 10.4130> <-4.2285, 12.4719, 10.3733> <-4.1896, 12.4834, 10.4074> <-4.2446, 12.4639, 10.3363>
		<-4.1819, 12.4394, 10.4204> <-4.2219, 12.4269, 10.3807> <-4.1827, 12.4294, 10.4156> <-4.2376, 12.4099, 10.3445>
		<-4.1573, 12.4245, 10.4042> <-4.1806, 12.4208, 10.3875> <-4.2060, 12.4149, 10.3535> <-4.2281, 12.4135, 10.3349>
		<-4.1444, 12.4238, 10.3857> <-4.1677, 12.4201, 10.3689> <-4.1946, 12.4148, 10.3412> <-4.2167, 12.4135, 10.3225>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1444, 12.4238, 10.3857> <-4.1677, 12.4201, 10.3689> <-4.1946, 12.4148, 10.3412> <-4.2167, 12.4135, 10.3225>
		<-4.1289, 12.4229, 10.3634> <-4.1522, 12.4192, 10.3466> <-4.1793, 12.4148, 10.3248> <-4.2015, 12.4134, 10.3062>
		<-4.1125, 12.4378, 10.3197> <-4.1310, 12.4327, 10.3056> <-4.1578, 12.4332, 10.2848> <-4.1796, 12.4284, 10.2765>
		<-4.1188, 12.4804, 10.3127> <-4.1372, 12.4753, 10.2986> <-4.1624, 12.4684, 10.2794> <-4.1841, 12.4637, 10.2711>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2297, 12.5147, 10.3072> <-4.2148, 12.5147, 10.2911> <-4.1886, 12.4982, 10.2659> <-4.1841, 12.4637, 10.2711>
		<-4.2396, 12.5096, 10.2993> <-4.2247, 12.5095, 10.2832> <-4.2049, 12.4947, 10.2596> <-4.2004, 12.4601, 10.2649>
		<-4.2553, 12.5036, 10.2889> <-4.2474, 12.5031, 10.2777> <-4.2283, 12.4776, 10.2597> <-4.2249, 12.4560, 10.2630>
		<-4.2628, 12.4929, 10.2849> <-4.2549, 12.4924, 10.2736> <-4.2458, 12.4750, 10.2620> <-4.2423, 12.4534, 10.2653>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2297, 12.5147, 10.3072> <-4.2396, 12.5096, 10.2993> <-4.2553, 12.5036, 10.2889> <-4.2628, 12.4929, 10.2849>
		<-4.2414, 12.5148, 10.3197> <-4.2512, 12.5096, 10.3118> <-4.2625, 12.5040, 10.2991> <-4.2701, 12.4933, 10.2951>
		<-4.2516, 12.5190, 10.3279> <-4.2749, 12.5107, 10.2977> <-4.2625, 12.4882, 10.3247> <-4.2755, 12.4825, 10.3019>
		<-4.2446, 12.4639, 10.3363> <-4.2679, 12.4557, 10.3061> <-4.2581, 12.4609, 10.3288> <-4.2711, 12.4551, 10.3060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2446, 12.4639, 10.3363> <-4.2679, 12.4557, 10.3061> <-4.2581, 12.4609, 10.3288> <-4.2711, 12.4551, 10.3060>
		<-4.2376, 12.4099, 10.3445> <-4.2609, 12.4017, 10.3143> <-4.2538, 12.4335, 10.3330> <-4.2668, 12.4277, 10.3102>
		<-4.2281, 12.4135, 10.3349> <-4.2380, 12.4129, 10.3265> <-4.2486, 12.4116, 10.3130> <-4.2580, 12.4176, 10.3065>
		<-4.2167, 12.4135, 10.3225> <-4.2266, 12.4129, 10.3142> <-4.2413, 12.4112, 10.3028> <-4.2508, 12.4172, 10.2963>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2167, 12.4135, 10.3225> <-4.2266, 12.4129, 10.3142> <-4.2413, 12.4112, 10.3028> <-4.2508, 12.4172, 10.2963>
		<-4.2015, 12.4134, 10.3062> <-4.2114, 12.4128, 10.2978> <-4.2334, 12.4107, 10.2916> <-4.2429, 12.4168, 10.2851>
		<-4.1796, 12.4284, 10.2765> <-4.1959, 12.4249, 10.2702> <-4.2214, 12.4344, 10.2663> <-4.2389, 12.4319, 10.2686>
		<-4.1841, 12.4637, 10.2711> <-4.2004, 12.4601, 10.2649> <-4.2249, 12.4560, 10.2630> <-4.2423, 12.4534, 10.2653>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2749, 12.4506, 10.2831> <-4.2736, 12.4423, 10.2843> <-4.2603, 12.4233, 10.2899> <-4.2508, 12.4172, 10.2963>
		<-4.2749, 12.4506, 10.2831> <-4.2763, 12.4425, 10.2881> <-4.2675, 12.4237, 10.3001> <-4.2580, 12.4176, 10.3065>
		<-4.2749, 12.4506, 10.2831> <-4.2763, 12.4425, 10.2881> <-4.2743, 12.4244, 10.2970> <-4.2668, 12.4277, 10.3102>
		<-4.2749, 12.4506, 10.2831> <-4.2776, 12.4507, 10.2869> <-4.2786, 12.4518, 10.2929> <-4.2711, 12.4551, 10.3060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2749, 12.4506, 10.2831> <-4.2707, 12.4503, 10.2771> <-4.2533, 12.4519, 10.2668> <-4.2423, 12.4534, 10.2653>
		<-4.2749, 12.4506, 10.2831> <-4.2694, 12.4421, 10.2784> <-4.2499, 12.4303, 10.2700> <-4.2389, 12.4319, 10.2686>
		<-4.2749, 12.4506, 10.2831> <-4.2694, 12.4421, 10.2784> <-4.2524, 12.4228, 10.2787> <-4.2429, 12.4168, 10.2851>
		<-4.2749, 12.4506, 10.2831> <-4.2736, 12.4423, 10.2843> <-4.2603, 12.4233, 10.2899> <-4.2508, 12.4172, 10.2963>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2749, 12.4506, 10.2831> <-4.2762, 12.4590, 10.2818> <-4.2701, 12.4826, 10.2810> <-4.2628, 12.4929, 10.2849>
		<-4.2749, 12.4506, 10.2831> <-4.2720, 12.4587, 10.2759> <-4.2622, 12.4821, 10.2698> <-4.2549, 12.4924, 10.2736>
		<-4.2749, 12.4506, 10.2831> <-4.2720, 12.4587, 10.2759> <-4.2567, 12.4735, 10.2635> <-4.2458, 12.4750, 10.2620>
		<-4.2749, 12.4506, 10.2831> <-4.2707, 12.4503, 10.2771> <-4.2533, 12.4519, 10.2668> <-4.2423, 12.4534, 10.2653>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2749, 12.4506, 10.2831> <-4.2776, 12.4507, 10.2869> <-4.2786, 12.4518, 10.2929> <-4.2711, 12.4551, 10.3060>
		<-4.2749, 12.4506, 10.2831> <-4.2789, 12.4591, 10.2856> <-4.2830, 12.4792, 10.2887> <-4.2755, 12.4825, 10.3019>
		<-4.2749, 12.4506, 10.2831> <-4.2789, 12.4591, 10.2856> <-4.2773, 12.4830, 10.2912> <-4.2701, 12.4933, 10.2951>
		<-4.2749, 12.4506, 10.2831> <-4.2762, 12.4590, 10.2818> <-4.2701, 12.4826, 10.2810> <-4.2628, 12.4929, 10.2849>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6789, 12.4725, 10.4840> <-3.6917, 12.4686, 10.4560> <-3.6846, 12.4433, 10.4025> <-3.6723, 12.3952, 10.4067>
		<-3.6951, 12.4711, 10.4923> <-3.7079, 12.4672, 10.4643> <-3.7079, 12.4414, 10.4095> <-3.6955, 12.3933, 10.4137>
		<-3.7175, 12.4689, 10.5019> <-3.7258, 12.4658, 10.4733> <-3.7307, 12.4406, 10.4217> <-3.7258, 12.3929, 10.4257>
		<-3.7348, 12.4677, 10.5077> <-3.7431, 12.4645, 10.4792> <-3.7527, 12.4392, 10.4319> <-3.7479, 12.3915, 10.4358>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6789, 12.4725, 10.4840> <-3.6500, 12.4750, 10.4693> <-3.5855, 12.4813, 10.4310> <-3.5847, 12.4809, 10.4309>
		<-3.6917, 12.4686, 10.4560> <-3.6628, 12.4712, 10.4413> <-3.5831, 12.4816, 10.4322> <-3.5823, 12.4812, 10.4322>
		<-3.6846, 12.4433, 10.4025> <-3.6780, 12.4438, 10.4005> <-3.6611, 12.4471, 10.4171> <-3.6554, 12.4473, 10.4132>
		<-3.6723, 12.3952, 10.4067> <-3.6657, 12.3957, 10.4047> <-3.6554, 12.3992, 10.4100> <-3.6497, 12.3994, 10.4061>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6789, 12.4725, 10.4840> <-3.6667, 12.4762, 10.5108> <-3.6195, 12.4419, 10.5360> <-3.6121, 12.4133, 10.5384>
		<-3.6500, 12.4750, 10.4693> <-3.6378, 12.4787, 10.4960> <-3.5803, 12.4441, 10.5225> <-3.5730, 12.4155, 10.5250>
		<-3.5855, 12.4813, 10.4310> <-3.5885, 12.4809, 10.4293> <-3.5178, 12.4581, 10.5280> <-3.5132, 12.4197, 10.5224>
		<-3.5847, 12.4809, 10.4309> <-3.5877, 12.4805, 10.4293> <-3.4851, 12.4578, 10.5026> <-3.4805, 12.4194, 10.4970>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6789, 12.4725, 10.4840> <-3.6951, 12.4711, 10.4923> <-3.7175, 12.4689, 10.5019> <-3.7348, 12.4677, 10.5077>
		<-3.6667, 12.4762, 10.5108> <-3.6829, 12.4747, 10.5191> <-3.7101, 12.4717, 10.5275> <-3.7273, 12.4705, 10.5334>
		<-3.6195, 12.4419, 10.5360> <-3.6484, 12.4403, 10.5459> <-3.6809, 12.4356, 10.5638> <-3.7101, 12.4335, 10.5729>
		<-3.6121, 12.4133, 10.5384> <-3.6411, 12.4117, 10.5484> <-3.6782, 12.4090, 10.5660> <-3.7074, 12.4068, 10.5751>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6121, 12.4133, 10.5384> <-3.6054, 12.3870, 10.5407> <-3.6317, 12.3359, 10.5208> <-3.6430, 12.3326, 10.4962>
		<-3.5730, 12.4155, 10.5250> <-3.5663, 12.3892, 10.5273> <-3.6026, 12.3332, 10.4998> <-3.6138, 12.3298, 10.4752>
		<-3.5132, 12.4197, 10.5224> <-3.5078, 12.3747, 10.5158> <-3.5657, 12.3168, 10.4081> <-3.5666, 12.3167, 10.4076>
		<-3.4805, 12.4194, 10.4970> <-3.4751, 12.3744, 10.4904> <-3.5638, 12.3151, 10.4071> <-3.5647, 12.3150, 10.4066>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6121, 12.4133, 10.5384> <-3.6411, 12.4117, 10.5484> <-3.6782, 12.4090, 10.5660> <-3.7074, 12.4068, 10.5751>
		<-3.6054, 12.3870, 10.5407> <-3.6344, 12.3854, 10.5507> <-3.6755, 12.3819, 10.5683> <-3.7047, 12.3797, 10.5773>
		<-3.6317, 12.3359, 10.5208> <-3.6515, 12.3378, 10.5350> <-3.6899, 12.3340, 10.5383> <-3.7133, 12.3325, 10.5451>
		<-3.6430, 12.3326, 10.4962> <-3.6627, 12.3344, 10.5104> <-3.6975, 12.3311, 10.5123> <-3.7209, 12.3297, 10.5191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6430, 12.3326, 10.4962> <-3.6627, 12.3344, 10.5104> <-3.6975, 12.3311, 10.5123> <-3.7209, 12.3297, 10.5191>
		<-3.6562, 12.3286, 10.4673> <-3.6759, 12.3304, 10.4815> <-3.7060, 12.3279, 10.4833> <-3.7293, 12.3265, 10.4901>
		<-3.6595, 12.3455, 10.4110> <-3.6828, 12.3436, 10.4180> <-3.7210, 12.3446, 10.4296> <-3.7430, 12.3431, 10.4398>
		<-3.6723, 12.3952, 10.4067> <-3.6955, 12.3933, 10.4137> <-3.7258, 12.3929, 10.4257> <-3.7479, 12.3915, 10.4358>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6430, 12.3326, 10.4962> <-3.6562, 12.3286, 10.4673> <-3.6595, 12.3455, 10.4110> <-3.6723, 12.3952, 10.4067>
		<-3.6138, 12.3298, 10.4752> <-3.6270, 12.3258, 10.4462> <-3.6530, 12.3460, 10.4090> <-3.6657, 12.3957, 10.4047>
		<-3.5666, 12.3167, 10.4076> <-3.5673, 12.3166, 10.4073> <-3.6489, 12.3456, 10.4022> <-3.6554, 12.3992, 10.4100>
		<-3.5647, 12.3150, 10.4066> <-3.5654, 12.3149, 10.4063> <-3.6432, 12.3458, 10.3983> <-3.6497, 12.3994, 10.4061>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7348, 12.4677, 10.5077> <-3.7431, 12.4645, 10.4792> <-3.7527, 12.4392, 10.4319> <-3.7479, 12.3915, 10.4358>
		<-3.7620, 12.4657, 10.5169> <-3.7703, 12.4626, 10.4883> <-3.7793, 12.4375, 10.4441> <-3.7745, 12.3898, 10.4481>
		<-3.7997, 12.4641, 10.5247> <-3.8070, 12.4608, 10.4994> <-3.8389, 12.3939, 10.4847> <-3.8378, 12.3848, 10.4854>
		<-3.8268, 12.4617, 10.5340> <-3.8341, 12.4585, 10.5087> <-3.8351, 12.3938, 10.4806> <-3.8341, 12.3847, 10.4813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7348, 12.4677, 10.5077> <-3.7620, 12.4657, 10.5169> <-3.7997, 12.4641, 10.5247> <-3.8268, 12.4617, 10.5340>
		<-3.7273, 12.4705, 10.5334> <-3.7545, 12.4685, 10.5426> <-3.7925, 12.4672, 10.5497> <-3.8196, 12.4649, 10.5590>
		<-3.7101, 12.4335, 10.5729> <-3.7375, 12.4314, 10.5815> <-3.7754, 12.4272, 10.5894> <-3.8036, 12.4254, 10.5951>
		<-3.7074, 12.4068, 10.5751> <-3.7349, 12.4048, 10.5837> <-3.7724, 12.4013, 10.5914> <-3.8006, 12.3994, 10.5971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7074, 12.4068, 10.5751> <-3.7349, 12.4048, 10.5837> <-3.7724, 12.4013, 10.5914> <-3.8006, 12.3994, 10.5971>
		<-3.7047, 12.3797, 10.5773> <-3.7321, 12.3777, 10.5859> <-3.7694, 12.3750, 10.5935> <-3.7976, 12.3731, 10.5992>
		<-3.7133, 12.3325, 10.5451> <-3.7403, 12.3308, 10.5530> <-3.7773, 12.3252, 10.5597> <-3.8033, 12.3253, 10.5703>
		<-3.7209, 12.3297, 10.5191> <-3.7478, 12.3280, 10.5269> <-3.7846, 12.3220, 10.5344> <-3.8107, 12.3221, 10.5450>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7209, 12.3297, 10.5191> <-3.7478, 12.3280, 10.5269> <-3.7846, 12.3220, 10.5344> <-3.8107, 12.3221, 10.5450>
		<-3.7293, 12.3265, 10.4901> <-3.7563, 12.3248, 10.4979> <-3.7918, 12.3188, 10.5095> <-3.8179, 12.3189, 10.5200>
		<-3.7430, 12.3431, 10.4398> <-3.7696, 12.3414, 10.4521> <-3.8368, 12.3758, 10.4861> <-3.8331, 12.3757, 10.4820>
		<-3.7479, 12.3915, 10.4358> <-3.7745, 12.3898, 10.4481> <-3.8378, 12.3848, 10.4854> <-3.8341, 12.3847, 10.4813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8268, 12.4617, 10.5340> <-3.8341, 12.4585, 10.5087> <-3.8351, 12.3938, 10.4806> <-3.8341, 12.3847, 10.4813>
		<-3.8446, 12.4602, 10.5401> <-3.8519, 12.4570, 10.5148> <-3.8336, 12.3938, 10.4789> <-3.8326, 12.3846, 10.4796>
		<-3.8664, 12.4583, 10.5649> <-3.8470, 12.4584, 10.5455> <-3.8159, 12.4383, 10.5143> <-3.8099, 12.3952, 10.5210>
		<-3.8840, 12.4550, 10.5590> <-3.8646, 12.4551, 10.5396> <-3.8273, 12.4367, 10.5113> <-3.8213, 12.3935, 10.5180>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8268, 12.4617, 10.5340> <-3.8446, 12.4602, 10.5401> <-3.8664, 12.4583, 10.5649> <-3.8840, 12.4550, 10.5590>
		<-3.8196, 12.4649, 10.5590> <-3.8373, 12.4634, 10.5651> <-3.8852, 12.4581, 10.5837> <-3.9028, 12.4548, 10.5778>
		<-3.8036, 12.4254, 10.5951> <-3.8397, 12.4230, 10.6024> <-3.8901, 12.4236, 10.6245> <-3.9252, 12.4187, 10.6144>
		<-3.8006, 12.3994, 10.5971> <-3.8367, 12.3970, 10.6044> <-3.8864, 12.3975, 10.6285> <-3.9216, 12.3927, 10.6184>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8006, 12.3994, 10.5971> <-3.8367, 12.3970, 10.6044> <-3.8864, 12.3975, 10.6285> <-3.9216, 12.3927, 10.6184>
		<-3.7976, 12.3731, 10.5992> <-3.8337, 12.3707, 10.6065> <-3.8829, 12.3719, 10.6325> <-3.9180, 12.3671, 10.6223>
		<-3.8033, 12.3253, 10.5703> <-3.8216, 12.3254, 10.5777> <-3.8665, 12.3324, 10.6027> <-3.8852, 12.3301, 10.5968>
		<-3.8107, 12.3221, 10.5450> <-3.8289, 12.3222, 10.5524> <-3.8480, 12.3325, 10.5842> <-3.8667, 12.3302, 10.5783>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8107, 12.3221, 10.5450> <-3.8289, 12.3222, 10.5524> <-3.8480, 12.3325, 10.5842> <-3.8667, 12.3302, 10.5783>
		<-3.8179, 12.3189, 10.5200> <-3.8361, 12.3190, 10.5274> <-3.8283, 12.3327, 10.5644> <-3.8470, 12.3304, 10.5585>
		<-3.8331, 12.3757, 10.4820> <-3.8315, 12.3756, 10.4803> <-3.8037, 12.3513, 10.5277> <-3.8152, 12.3496, 10.5248>
		<-3.8341, 12.3847, 10.4813> <-3.8326, 12.3846, 10.4796> <-3.8099, 12.3952, 10.5210> <-3.8213, 12.3935, 10.5180>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8840, 12.4550, 10.5590> <-3.8646, 12.4551, 10.5396> <-3.8273, 12.4367, 10.5113> <-3.8213, 12.3935, 10.5180>
		<-3.9122, 12.4497, 10.5496> <-3.8928, 12.4498, 10.5302> <-3.8575, 12.4324, 10.5035> <-3.8515, 12.3893, 10.5102>
		<-3.9207, 12.4476, 10.5268> <-3.8913, 12.4478, 10.4974> <-3.9153, 12.3782, 10.4553> <-3.9146, 12.3726, 10.4559>
		<-3.9559, 12.4375, 10.4910> <-3.9265, 12.4378, 10.4616> <-3.9089, 12.3799, 10.4616> <-3.9081, 12.3742, 10.4622>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8840, 12.4550, 10.5590> <-3.9122, 12.4497, 10.5496> <-3.9207, 12.4476, 10.5268> <-3.9559, 12.4375, 10.4910>
		<-3.9028, 12.4548, 10.5778> <-3.9310, 12.4495, 10.5684> <-3.9515, 12.4473, 10.5577> <-3.9867, 12.4373, 10.5219>
		<-3.9252, 12.4187, 10.6144> <-3.9546, 12.4147, 10.6059> <-3.9728, 12.4040, 10.5636> <-3.9920, 12.3983, 10.5402>
		<-3.9216, 12.3927, 10.6184> <-3.9510, 12.3887, 10.6099> <-3.9694, 12.3792, 10.5662> <-3.9886, 12.3735, 10.5428>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9216, 12.3927, 10.6184> <-3.9510, 12.3887, 10.6099> <-3.9694, 12.3792, 10.5662> <-3.9886, 12.3735, 10.5428>
		<-3.9180, 12.3671, 10.6223> <-3.9474, 12.3630, 10.6139> <-3.9659, 12.3535, 10.5690> <-3.9851, 12.3477, 10.5455>
		<-3.8852, 12.3301, 10.5968> <-3.9150, 12.3264, 10.5874> <-3.9335, 12.3153, 10.5750> <-3.9701, 12.3061, 10.5370>
		<-3.8667, 12.3302, 10.5783> <-3.8965, 12.3265, 10.5688> <-3.9013, 12.3155, 10.5428> <-3.9379, 12.3063, 10.5048>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8667, 12.3302, 10.5783> <-3.8965, 12.3265, 10.5688> <-3.9013, 12.3155, 10.5428> <-3.9379, 12.3063, 10.5048>
		<-3.8470, 12.3304, 10.5585> <-3.8768, 12.3267, 10.5491> <-3.8715, 12.3158, 10.5129> <-3.9082, 12.3066, 10.4750>
		<-3.8152, 12.3496, 10.5248> <-3.8454, 12.3454, 10.5170> <-3.9138, 12.3668, 10.4565> <-3.9073, 12.3685, 10.4628>
		<-3.8213, 12.3935, 10.5180> <-3.8515, 12.3893, 10.5102> <-3.9146, 12.3726, 10.4559> <-3.9081, 12.3742, 10.4622>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9559, 12.4375, 10.4910> <-3.9265, 12.4378, 10.4616> <-3.9089, 12.3799, 10.4616> <-3.9081, 12.3742, 10.4622>
		<-3.9895, 12.4279, 10.4568> <-3.9601, 12.4282, 10.4274> <-3.9030, 12.3814, 10.4674> <-3.9022, 12.3757, 10.4680>
		<-4.0025, 12.4236, 10.4443> <-3.9816, 12.4249, 10.4288> <-3.9484, 12.4044, 10.4003> <-3.9432, 12.3631, 10.4053>
		<-4.0190, 12.4165, 10.4218> <-3.9980, 12.4177, 10.4062> <-3.9649, 12.3995, 10.3770> <-3.9597, 12.3582, 10.3820>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9559, 12.4375, 10.4910> <-3.9895, 12.4279, 10.4568> <-4.0025, 12.4236, 10.4443> <-4.0190, 12.4165, 10.4218>
		<-3.9867, 12.4373, 10.5219> <-4.0204, 12.4277, 10.4877> <-4.0209, 12.4226, 10.4580> <-4.0373, 12.4154, 10.4354>
		<-3.9920, 12.3983, 10.5402> <-4.0133, 12.3920, 10.5143> <-4.0315, 12.4099, 10.5074> <-4.0623, 12.3985, 10.4484>
		<-3.9886, 12.3735, 10.5428> <-4.0099, 12.3672, 10.5169> <-4.0257, 12.3640, 10.5130> <-4.0565, 12.3526, 10.4540>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9886, 12.3735, 10.5428> <-4.0099, 12.3672, 10.5169> <-4.0257, 12.3640, 10.5130> <-4.0565, 12.3526, 10.4540>
		<-3.9851, 12.3477, 10.5455> <-4.0064, 12.3414, 10.5196> <-4.0199, 12.3188, 10.5185> <-4.0508, 12.3074, 10.4594>
		<-3.9701, 12.3061, 10.5370> <-4.0034, 12.2977, 10.5025> <-4.0045, 12.2971, 10.4726> <-4.0217, 12.2948, 10.4498>
		<-3.9379, 12.3063, 10.5048> <-3.9712, 12.2980, 10.4703> <-3.9865, 12.2982, 10.4592> <-4.0037, 12.2958, 10.4364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9379, 12.3063, 10.5048> <-3.9712, 12.2980, 10.4703> <-3.9865, 12.2982, 10.4592> <-4.0037, 12.2958, 10.4364>
		<-3.9082, 12.3066, 10.4750> <-3.9414, 12.2982, 10.4405> <-3.9652, 12.2994, 10.4433> <-3.9824, 12.2971, 10.4205>
		<-3.9073, 12.3685, 10.4628> <-3.9014, 12.3700, 10.4686> <-3.9379, 12.3210, 10.4104> <-3.9544, 12.3162, 10.3871>
		<-3.9081, 12.3742, 10.4622> <-3.9022, 12.3757, 10.4680> <-3.9432, 12.3631, 10.4053> <-3.9597, 12.3582, 10.3820>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0190, 12.4165, 10.4218> <-3.9980, 12.4177, 10.4062> <-3.9649, 12.3995, 10.3770> <-3.9597, 12.3582, 10.3820>
		<-4.0343, 12.4098, 10.4008> <-4.0133, 12.4110, 10.3852> <-3.9777, 12.3958, 10.3588> <-3.9725, 12.3544, 10.3638>
		<-4.0479, 12.4007, 10.3685> <-4.0291, 12.4023, 10.3583> <-3.9923, 12.3834, 10.3344> <-3.9884, 12.3494, 10.3380>
		<-4.0609, 12.3918, 10.3469> <-4.0421, 12.3933, 10.3367> <-4.0095, 12.3794, 10.3204> <-4.0056, 12.3454, 10.3240>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0190, 12.4165, 10.4218> <-4.0343, 12.4098, 10.4008> <-4.0479, 12.4007, 10.3685> <-4.0609, 12.3918, 10.3469>
		<-4.0373, 12.4154, 10.4354> <-4.0526, 12.4087, 10.4145> <-4.0626, 12.3996, 10.3765> <-4.0756, 12.3906, 10.3549>
		<-4.0623, 12.3985, 10.4484> <-4.0876, 12.3892, 10.4001> <-4.0614, 12.4066, 10.4427> <-4.0877, 12.3937, 10.3595>
		<-4.0565, 12.3526, 10.4540> <-4.0818, 12.3433, 10.4056> <-4.0552, 12.3521, 10.4484> <-4.0814, 12.3393, 10.3652>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0565, 12.3526, 10.4540> <-4.0818, 12.3433, 10.4056> <-4.0552, 12.3521, 10.4484> <-4.0814, 12.3393, 10.3652>
		<-4.0508, 12.3074, 10.4594> <-4.0760, 12.2981, 10.4111> <-4.0491, 12.2986, 10.4539> <-4.0753, 12.2858, 10.3708>
		<-4.0217, 12.2948, 10.4498> <-4.0382, 12.2926, 10.4280> <-4.0496, 12.2898, 10.3886> <-4.0639, 12.2901, 10.3652>
		<-4.0037, 12.2958, 10.4364> <-4.0202, 12.2936, 10.4146> <-4.0351, 12.2910, 10.3807> <-4.0494, 12.2913, 10.3574>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0037, 12.2958, 10.4364> <-4.0202, 12.2936, 10.4146> <-4.0351, 12.2910, 10.3807> <-4.0494, 12.2913, 10.3574>
		<-3.9824, 12.2971, 10.4205> <-3.9989, 12.2948, 10.3987> <-4.0159, 12.2925, 10.3703> <-4.0303, 12.2928, 10.3469>
		<-3.9544, 12.3162, 10.3871> <-3.9672, 12.3124, 10.3689> <-3.9844, 12.3146, 10.3416> <-4.0016, 12.3106, 10.3276>
		<-3.9597, 12.3582, 10.3820> <-3.9725, 12.3544, 10.3638> <-3.9884, 12.3494, 10.3380> <-4.0056, 12.3454, 10.3240>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0609, 12.3918, 10.3469> <-4.0421, 12.3933, 10.3367> <-4.0095, 12.3794, 10.3204> <-4.0056, 12.3454, 10.3240>
		<-4.0672, 12.3874, 10.3364> <-4.0484, 12.3889, 10.3262> <-4.0235, 12.3762, 10.3091> <-4.0196, 12.3421, 10.3126>
		<-4.0783, 12.3824, 10.3220> <-4.0682, 12.3828, 10.3135> <-4.0460, 12.3589, 10.3013> <-4.0430, 12.3381, 10.3036>
		<-4.0832, 12.3723, 10.3155> <-4.0731, 12.3727, 10.3070> <-4.0636, 12.3556, 10.2977> <-4.0607, 12.3348, 10.3000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0609, 12.3918, 10.3469> <-4.0672, 12.3874, 10.3364> <-4.0783, 12.3824, 10.3220> <-4.0832, 12.3723, 10.3155>
		<-4.0756, 12.3906, 10.3549> <-4.0820, 12.3863, 10.3444> <-4.0877, 12.3820, 10.3298> <-4.0926, 12.3719, 10.3233>
		<-4.0877, 12.3937, 10.3595> <-4.0986, 12.3883, 10.3247> <-4.0954, 12.3646, 10.3511> <-4.0997, 12.3604, 10.3264>
		<-4.0814, 12.3393, 10.3652> <-4.0924, 12.3339, 10.3304> <-4.0915, 12.3375, 10.3542> <-4.0958, 12.3333, 10.3294>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0814, 12.3393, 10.3652> <-4.0924, 12.3339, 10.3304> <-4.0915, 12.3375, 10.3542> <-4.0958, 12.3333, 10.3294>
		<-4.0753, 12.2858, 10.3708> <-4.0863, 12.2804, 10.3359> <-4.0877, 12.3104, 10.3572> <-4.0919, 12.3062, 10.3325>
		<-4.0639, 12.2901, 10.3652> <-4.0703, 12.2902, 10.3547> <-4.0751, 12.2907, 10.3400> <-4.0819, 12.2968, 10.3318>
		<-4.0494, 12.2913, 10.3574> <-4.0559, 12.2914, 10.3468> <-4.0657, 12.2911, 10.3322> <-4.0725, 12.2972, 10.3239>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0494, 12.2913, 10.3574> <-4.0559, 12.2914, 10.3468> <-4.0657, 12.2911, 10.3322> <-4.0725, 12.2972, 10.3239>
		<-4.0303, 12.2928, 10.3469> <-4.0367, 12.2929, 10.3364> <-4.0557, 12.2915, 10.3238> <-4.0625, 12.2976, 10.3155>
		<-4.0016, 12.3106, 10.3276> <-4.0156, 12.3074, 10.3163> <-4.0401, 12.3174, 10.3060> <-4.0577, 12.3141, 10.3023>
		<-4.0056, 12.3454, 10.3240> <-4.0196, 12.3421, 10.3126> <-4.0430, 12.3381, 10.3036> <-4.0607, 12.3348, 10.3000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0915, 12.3292, 10.3064> <-4.0904, 12.3213, 10.3073> <-4.0793, 12.3034, 10.3157> <-4.0725, 12.2972, 10.3239>
		<-4.0915, 12.3292, 10.3064> <-4.0940, 12.3212, 10.3103> <-4.0888, 12.3030, 10.3235> <-4.0819, 12.2968, 10.3318>
		<-4.0915, 12.3292, 10.3064> <-4.0940, 12.3212, 10.3103> <-4.0945, 12.3036, 10.3174> <-4.0919, 12.3062, 10.3325>
		<-4.0915, 12.3292, 10.3064> <-4.0951, 12.3291, 10.3094> <-4.0984, 12.3307, 10.3143> <-4.0958, 12.3333, 10.3294>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0915, 12.3292, 10.3064> <-4.0867, 12.3294, 10.3024> <-4.0699, 12.3330, 10.2981> <-4.0607, 12.3348, 10.3000>
		<-4.0915, 12.3292, 10.3064> <-4.0856, 12.3215, 10.3033> <-4.0670, 12.3124, 10.3004> <-4.0577, 12.3141, 10.3023>
		<-4.0915, 12.3292, 10.3064> <-4.0856, 12.3215, 10.3033> <-4.0693, 12.3038, 10.3073> <-4.0625, 12.2976, 10.3155>
		<-4.0915, 12.3292, 10.3064> <-4.0904, 12.3213, 10.3073> <-4.0793, 12.3034, 10.3157> <-4.0725, 12.2972, 10.3239>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0915, 12.3292, 10.3064> <-4.0928, 12.3379, 10.3054> <-4.0883, 12.3619, 10.3087> <-4.0832, 12.3723, 10.3155>
		<-4.0915, 12.3292, 10.3064> <-4.0880, 12.3381, 10.3014> <-4.0782, 12.3623, 10.3003> <-4.0731, 12.3727, 10.3070>
		<-4.0915, 12.3292, 10.3064> <-4.0880, 12.3381, 10.3014> <-4.0729, 12.3538, 10.2958> <-4.0636, 12.3556, 10.2977>
		<-4.0915, 12.3292, 10.3064> <-4.0867, 12.3294, 10.3024> <-4.0699, 12.3330, 10.2981> <-4.0607, 12.3348, 10.3000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0915, 12.3292, 10.3064> <-4.0951, 12.3291, 10.3094> <-4.0984, 12.3307, 10.3143> <-4.0958, 12.3333, 10.3294>
		<-4.0915, 12.3292, 10.3064> <-4.0963, 12.3377, 10.3084> <-4.1023, 12.3578, 10.3113> <-4.0997, 12.3604, 10.3264>
		<-4.0915, 12.3292, 10.3064> <-4.0963, 12.3377, 10.3084> <-4.0977, 12.3615, 10.3166> <-4.0926, 12.3719, 10.3233>
		<-4.0915, 12.3292, 10.3064> <-4.0928, 12.3379, 10.3054> <-4.0883, 12.3619, 10.3087> <-4.0832, 12.3723, 10.3155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6215, 12.3128, 10.4849> <-3.6386, 12.3090, 10.4617> <-3.6698, 12.2859, 10.4235> <-3.6676, 12.2395, 10.4295>
		<-3.6462, 12.3114, 10.5006> <-3.6634, 12.3076, 10.4773> <-3.6854, 12.2877, 10.4313> <-3.6832, 12.2413, 10.4373>
		<-3.6892, 12.3080, 10.4947> <-3.6960, 12.3072, 10.4739> <-3.7103, 12.2817, 10.4407> <-3.7049, 12.2470, 10.4446>
		<-3.7172, 12.3064, 10.5030> <-3.7241, 12.3055, 10.4822> <-3.7262, 12.2832, 10.4477> <-3.7208, 12.2485, 10.4516>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6215, 12.3128, 10.4849> <-3.5970, 12.3142, 10.4695> <-3.5632, 12.3136, 10.4058> <-3.5647, 12.3150, 10.4066>
		<-3.6386, 12.3090, 10.4617> <-3.6141, 12.3104, 10.4462> <-3.5638, 12.3136, 10.4056> <-3.5653, 12.3150, 10.4064>
		<-3.6698, 12.2859, 10.4235> <-3.6581, 12.2845, 10.4176> <-3.6445, 12.2810, 10.3962> <-3.6350, 12.2796, 10.3871>
		<-3.6676, 12.2395, 10.4295> <-3.6558, 12.2381, 10.4235> <-3.6398, 12.2393, 10.4151> <-3.6302, 12.2379, 10.4060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6215, 12.3128, 10.4849> <-3.6085, 12.3156, 10.5026> <-3.5944, 12.2777, 10.5272> <-3.5934, 12.2558, 10.5300>
		<-3.5970, 12.3142, 10.4695> <-3.5840, 12.3170, 10.4871> <-3.5609, 12.2764, 10.5100> <-3.5598, 12.2546, 10.5128>
		<-3.5632, 12.3136, 10.4058> <-3.5625, 12.3136, 10.4061> <-3.5176, 12.2822, 10.4757> <-3.5141, 12.2516, 10.4896>
		<-3.5647, 12.3150, 10.4066> <-3.5640, 12.3150, 10.4069> <-3.4899, 12.2767, 10.4507> <-3.4864, 12.2460, 10.4645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6215, 12.3128, 10.4849> <-3.6462, 12.3114, 10.5006> <-3.6892, 12.3080, 10.4947> <-3.7172, 12.3064, 10.5030>
		<-3.6085, 12.3156, 10.5026> <-3.6332, 12.3142, 10.5182> <-3.6814, 12.3090, 10.5187> <-3.7094, 12.3074, 10.5270>
		<-3.5944, 12.2777, 10.5272> <-3.6203, 12.2786, 10.5405> <-3.6592, 12.2792, 10.5556> <-3.6873, 12.2781, 10.5632>
		<-3.5934, 12.2558, 10.5300> <-3.6192, 12.2568, 10.5433> <-3.6554, 12.2545, 10.5584> <-3.6835, 12.2533, 10.5659>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5934, 12.2558, 10.5300> <-3.5923, 12.2341, 10.5328> <-3.6026, 12.1905, 10.5184> <-3.6155, 12.1876, 10.5010>
		<-3.5598, 12.2546, 10.5128> <-3.5588, 12.2329, 10.5155> <-3.5814, 12.1884, 10.5117> <-3.5943, 12.1856, 10.4942>
		<-3.5141, 12.2516, 10.4896> <-3.5115, 12.2284, 10.5001> <-3.5386, 12.1849, 10.4949> <-3.5623, 12.1836, 10.4853>
		<-3.4864, 12.2460, 10.4645> <-3.4838, 12.2228, 10.4750> <-3.5258, 12.1827, 10.4768> <-3.5494, 12.1813, 10.4672>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5934, 12.2558, 10.5300> <-3.6192, 12.2568, 10.5433> <-3.6554, 12.2545, 10.5584> <-3.6835, 12.2533, 10.5659>
		<-3.5923, 12.2341, 10.5328> <-3.6182, 12.2350, 10.5461> <-3.6520, 12.2327, 10.5609> <-3.6801, 12.2316, 10.5684>
		<-3.6026, 12.1905, 10.5184> <-3.6271, 12.1929, 10.5263> <-3.6678, 12.1961, 10.5316> <-3.6932, 12.1969, 10.5364>
		<-3.6155, 12.1876, 10.5010> <-3.6400, 12.1900, 10.5088> <-3.6747, 12.1952, 10.5105> <-3.7000, 12.1961, 10.5154>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6155, 12.1876, 10.5010> <-3.6400, 12.1900, 10.5088> <-3.6747, 12.1952, 10.5105> <-3.7000, 12.1961, 10.5154>
		<-3.6326, 12.1839, 10.4778> <-3.6572, 12.1863, 10.4856> <-3.6822, 12.1942, 10.4876> <-3.7075, 12.1951, 10.4925>
		<-3.6654, 12.1932, 10.4354> <-3.6810, 12.1951, 10.4432> <-3.6989, 12.2089, 10.4488> <-3.7149, 12.2104, 10.4559>
		<-3.6676, 12.2395, 10.4295> <-3.6832, 12.2413, 10.4373> <-3.7049, 12.2470, 10.4446> <-3.7208, 12.2485, 10.4516>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6155, 12.1876, 10.5010> <-3.6326, 12.1839, 10.4778> <-3.6654, 12.1932, 10.4354> <-3.6676, 12.2395, 10.4295>
		<-3.5943, 12.1856, 10.4942> <-3.6115, 12.1818, 10.4710> <-3.6536, 12.1919, 10.4295> <-3.6558, 12.2381, 10.4235>
		<-3.5623, 12.1836, 10.4853> <-3.5927, 12.1819, 10.4729> <-3.6343, 12.1914, 10.4368> <-3.6398, 12.2393, 10.4151>
		<-3.5494, 12.1813, 10.4672> <-3.5799, 12.1796, 10.4548> <-3.6247, 12.1901, 10.4277> <-3.6302, 12.2379, 10.4060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7172, 12.3064, 10.5030> <-3.7241, 12.3055, 10.4822> <-3.7262, 12.2832, 10.4477> <-3.7208, 12.2485, 10.4516>
		<-3.7366, 12.3053, 10.5087> <-3.7434, 12.3044, 10.4879> <-3.7366, 12.2842, 10.4523> <-3.7312, 12.2495, 10.4562>
		<-3.7609, 12.3029, 10.5212> <-3.7554, 12.3029, 10.4970> <-3.7565, 12.2568, 10.4704> <-3.7555, 12.2483, 10.4703>
		<-3.7784, 12.3036, 10.5313> <-3.7729, 12.3036, 10.5071> <-3.7562, 12.2564, 10.4683> <-3.7552, 12.2478, 10.4681>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7172, 12.3064, 10.5030> <-3.7366, 12.3053, 10.5087> <-3.7609, 12.3029, 10.5212> <-3.7784, 12.3036, 10.5313>
		<-3.7094, 12.3074, 10.5270> <-3.7288, 12.3063, 10.5327> <-3.7655, 12.3029, 10.5417> <-3.7830, 12.3036, 10.5518>
		<-3.6873, 12.2781, 10.5632> <-3.7158, 12.2769, 10.5708> <-3.7537, 12.2694, 10.5755> <-3.7828, 12.2687, 10.5803>
		<-3.6835, 12.2533, 10.5659> <-3.7119, 12.2521, 10.5735> <-3.7514, 12.2486, 10.5752> <-3.7804, 12.2479, 10.5800>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6835, 12.2533, 10.5659> <-3.7119, 12.2521, 10.5735> <-3.7514, 12.2486, 10.5752> <-3.7804, 12.2479, 10.5800>
		<-3.6801, 12.2316, 10.5684> <-3.7085, 12.2304, 10.5760> <-3.7490, 12.2272, 10.5749> <-3.7780, 12.2265, 10.5797>
		<-3.6932, 12.1969, 10.5364> <-3.7131, 12.1976, 10.5402> <-3.7529, 12.1914, 10.5411> <-3.7706, 12.1928, 10.5508>
		<-3.7000, 12.1961, 10.5154> <-3.7199, 12.1967, 10.5192> <-3.7482, 12.1914, 10.5201> <-3.7659, 12.1928, 10.5298>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7000, 12.1961, 10.5154> <-3.7199, 12.1967, 10.5192> <-3.7482, 12.1914, 10.5201> <-3.7659, 12.1928, 10.5298>
		<-3.7075, 12.1951, 10.4925> <-3.7274, 12.1958, 10.4963> <-3.7430, 12.1914, 10.4971> <-3.7607, 12.1927, 10.5067>
		<-3.7149, 12.2104, 10.4559> <-3.7253, 12.2114, 10.4605> <-3.7546, 12.2401, 10.4701> <-3.7543, 12.2397, 10.4680>
		<-3.7208, 12.2485, 10.4516> <-3.7312, 12.2495, 10.4562> <-3.7555, 12.2483, 10.4703> <-3.7552, 12.2478, 10.4681>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7784, 12.3036, 10.5313> <-3.7729, 12.3036, 10.5071> <-3.7562, 12.2564, 10.4683> <-3.7552, 12.2478, 10.4681>
		<-3.7856, 12.3039, 10.5355> <-3.7802, 12.3039, 10.5113> <-3.7556, 12.2554, 10.4640> <-3.7547, 12.2469, 10.4639>
		<-3.7912, 12.3106, 10.5542> <-3.7714, 12.3141, 10.5440> <-3.7217, 12.2992, 10.5209> <-3.7153, 12.2638, 10.5236>
		<-3.7983, 12.3098, 10.5498> <-3.7785, 12.3133, 10.5397> <-3.7384, 12.3029, 10.5366> <-3.7320, 12.2674, 10.5394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7784, 12.3036, 10.5313> <-3.7856, 12.3039, 10.5355> <-3.7912, 12.3106, 10.5542> <-3.7983, 12.3098, 10.5498>
		<-3.7830, 12.3036, 10.5518> <-3.7902, 12.3039, 10.5559> <-3.8109, 12.3071, 10.5643> <-3.8180, 12.3063, 10.5600>
		<-3.7828, 12.2687, 10.5803> <-3.7980, 12.2684, 10.5828> <-3.8226, 12.2737, 10.5977> <-3.8348, 12.2719, 10.5885>
		<-3.7804, 12.2479, 10.5800> <-3.7957, 12.2476, 10.5825> <-3.8186, 12.2516, 10.5994> <-3.8309, 12.2499, 10.5902>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7804, 12.2479, 10.5800> <-3.7957, 12.2476, 10.5825> <-3.8186, 12.2516, 10.5994> <-3.8309, 12.2499, 10.5902>
		<-3.7780, 12.2265, 10.5797> <-3.7933, 12.2262, 10.5822> <-3.8147, 12.2300, 10.6011> <-3.8270, 12.2283, 10.5919>
		<-3.7706, 12.1928, 10.5508> <-3.7792, 12.1934, 10.5554> <-3.7894, 12.1988, 10.5725> <-3.7982, 12.1985, 10.5681>
		<-3.7659, 12.1928, 10.5298> <-3.7745, 12.1934, 10.5344> <-3.7701, 12.2023, 10.5625> <-3.7788, 12.2019, 10.5582>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7659, 12.1928, 10.5298> <-3.7745, 12.1934, 10.5344> <-3.7701, 12.2023, 10.5625> <-3.7788, 12.2019, 10.5582>
		<-3.7607, 12.1927, 10.5067> <-3.7693, 12.1934, 10.5114> <-3.7495, 12.2059, 10.5520> <-3.7582, 12.2056, 10.5476>
		<-3.7543, 12.2397, 10.4680> <-3.7538, 12.2388, 10.4637> <-3.7087, 12.2268, 10.5265> <-3.7253, 12.2305, 10.5422>
		<-3.7552, 12.2478, 10.4681> <-3.7547, 12.2469, 10.4639> <-3.7153, 12.2638, 10.5236> <-3.7320, 12.2674, 10.5394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7983, 12.3098, 10.5498> <-3.7785, 12.3133, 10.5397> <-3.7384, 12.3029, 10.5366> <-3.7320, 12.2674, 10.5394>
		<-3.8163, 12.3075, 10.5389> <-3.7966, 12.3110, 10.5287> <-3.7533, 12.3061, 10.5508> <-3.7469, 12.2707, 10.5535>
		<-3.8245, 12.3035, 10.5260> <-3.7915, 12.3107, 10.5214> <-3.7883, 12.2578, 10.4900> <-3.7872, 12.2532, 10.4905>
		<-3.8396, 12.2961, 10.4941> <-3.8066, 12.3033, 10.4895> <-3.7857, 12.2588, 10.4954> <-3.7845, 12.2542, 10.4959>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7983, 12.3098, 10.5498> <-3.8163, 12.3075, 10.5389> <-3.8245, 12.3035, 10.5260> <-3.8396, 12.2961, 10.4941>
		<-3.8180, 12.3063, 10.5600> <-3.8360, 12.3041, 10.5490> <-3.8593, 12.2959, 10.5308> <-3.8744, 12.2885, 10.4989>
		<-3.8348, 12.2719, 10.5885> <-3.8573, 12.2687, 10.5716> <-3.8710, 12.2587, 10.5326> <-3.8805, 12.2543, 10.5062>
		<-3.8309, 12.2499, 10.5902> <-3.8534, 12.2467, 10.5733> <-3.8660, 12.2388, 10.5348> <-3.8755, 12.2344, 10.5085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8309, 12.2499, 10.5902> <-3.8534, 12.2467, 10.5733> <-3.8660, 12.2388, 10.5348> <-3.8755, 12.2344, 10.5085>
		<-3.8270, 12.2283, 10.5919> <-3.8495, 12.2251, 10.5750> <-3.8609, 12.2180, 10.5372> <-3.8704, 12.2136, 10.5109>
		<-3.7982, 12.1985, 10.5681> <-3.8152, 12.1979, 10.5596> <-3.8358, 12.1872, 10.5401> <-3.8496, 12.1831, 10.5111>
		<-3.7788, 12.2019, 10.5582> <-3.7959, 12.2013, 10.5497> <-3.7996, 12.1951, 10.5351> <-3.8134, 12.1910, 10.5061>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7788, 12.2019, 10.5582> <-3.7959, 12.2013, 10.5497> <-3.7996, 12.1951, 10.5351> <-3.8134, 12.1910, 10.5061>
		<-3.7582, 12.2056, 10.5476> <-3.7753, 12.2050, 10.5391> <-3.7661, 12.2024, 10.5304> <-3.7799, 12.1984, 10.5014>
		<-3.7253, 12.2305, 10.5422> <-3.7403, 12.2337, 10.5564> <-3.7860, 12.2486, 10.4910> <-3.7834, 12.2496, 10.4964>
		<-3.7320, 12.2674, 10.5394> <-3.7469, 12.2707, 10.5535> <-3.7872, 12.2532, 10.4905> <-3.7845, 12.2542, 10.4959>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8396, 12.2961, 10.4941> <-3.8066, 12.3033, 10.4895> <-3.7857, 12.2588, 10.4954> <-3.7845, 12.2542, 10.4959>
		<-3.8510, 12.2905, 10.4702> <-3.8180, 12.2978, 10.4656> <-3.7831, 12.2598, 10.5006> <-3.7820, 12.2552, 10.5011>
		<-3.8467, 12.2888, 10.4583> <-3.8265, 12.2929, 10.4528> <-3.7899, 12.2827, 10.4449> <-3.7827, 12.2493, 10.4488>
		<-3.8490, 12.2849, 10.4430> <-3.8287, 12.2890, 10.4375> <-3.7928, 12.2797, 10.4251> <-3.7857, 12.2464, 10.4290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8396, 12.2961, 10.4941> <-3.8510, 12.2905, 10.4702> <-3.8467, 12.2888, 10.4583> <-3.8490, 12.2849, 10.4430>
		<-3.8744, 12.2885, 10.4989> <-3.8858, 12.2829, 10.4750> <-3.8646, 12.2852, 10.4632> <-3.8668, 12.2813, 10.4479>
		<-3.8805, 12.2543, 10.5062> <-3.8860, 12.2517, 10.4911> <-3.8889, 12.2679, 10.4825> <-3.8878, 12.2645, 10.4503>
		<-3.8755, 12.2344, 10.5085> <-3.8810, 12.2318, 10.4933> <-3.8809, 12.2306, 10.4868> <-3.8798, 12.2272, 10.4547>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8755, 12.2344, 10.5085> <-3.8810, 12.2318, 10.4933> <-3.8809, 12.2306, 10.4868> <-3.8798, 12.2272, 10.4547>
		<-3.8704, 12.2136, 10.5109> <-3.8758, 12.2111, 10.4957> <-3.8731, 12.1941, 10.4911> <-3.8720, 12.1907, 10.4590>
		<-3.8496, 12.1831, 10.5111> <-3.8613, 12.1797, 10.4865> <-3.8421, 12.1846, 10.4750> <-3.8456, 12.1840, 10.4593>
		<-3.8134, 12.1910, 10.5061> <-3.8251, 12.1876, 10.4815> <-3.8247, 12.1882, 10.4702> <-3.8281, 12.1875, 10.4545>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8134, 12.1910, 10.5061> <-3.8251, 12.1876, 10.4815> <-3.8247, 12.1882, 10.4702> <-3.8281, 12.1875, 10.4545>
		<-3.7799, 12.1984, 10.5014> <-3.7916, 12.1949, 10.4769> <-3.8040, 12.1924, 10.4646> <-3.8075, 12.1917, 10.4489>
		<-3.7834, 12.2496, 10.4964> <-3.7809, 12.2506, 10.5017> <-3.7755, 12.2153, 10.4528> <-3.7784, 12.2124, 10.4330>
		<-3.7845, 12.2542, 10.4959> <-3.7820, 12.2552, 10.5011> <-3.7827, 12.2493, 10.4488> <-3.7857, 12.2464, 10.4290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8490, 12.2849, 10.4430> <-3.8287, 12.2890, 10.4375> <-3.7928, 12.2797, 10.4251> <-3.7857, 12.2464, 10.4290>
		<-3.8517, 12.2801, 10.4241> <-3.8315, 12.2843, 10.4186> <-3.7953, 12.2773, 10.4089> <-3.7881, 12.2440, 10.4128>
		<-3.8536, 12.2739, 10.3986> <-3.8366, 12.2777, 10.3962> <-3.7999, 12.2676, 10.3885> <-3.7942, 12.2400, 10.3913>
		<-3.8563, 12.2673, 10.3803> <-3.8392, 12.2710, 10.3779> <-3.8080, 12.2642, 10.3745> <-3.8023, 12.2366, 10.3772>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8490, 12.2849, 10.4430> <-3.8517, 12.2801, 10.4241> <-3.8536, 12.2739, 10.3986> <-3.8563, 12.2673, 10.3803>
		<-3.8668, 12.2813, 10.4479> <-3.8696, 12.2765, 10.4290> <-3.8670, 12.2710, 10.4004> <-3.8696, 12.2644, 10.3821>
		<-3.8878, 12.2645, 10.4503> <-3.8864, 12.2602, 10.4098> <-3.8863, 12.2715, 10.4469> <-3.8805, 12.2656, 10.3824>
		<-3.8798, 12.2272, 10.4547> <-3.8784, 12.2230, 10.4142> <-3.8771, 12.2275, 10.4512> <-3.8713, 12.2215, 10.3868>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8798, 12.2272, 10.4547> <-3.8784, 12.2230, 10.4142> <-3.8771, 12.2275, 10.4512> <-3.8713, 12.2215, 10.3868>
		<-3.8720, 12.1907, 10.4590> <-3.8706, 12.1864, 10.4185> <-3.8681, 12.1843, 10.4555> <-3.8623, 12.1783, 10.3911>
		<-3.8456, 12.1840, 10.4593> <-3.8499, 12.1832, 10.4396> <-3.8483, 12.1825, 10.4098> <-3.8524, 12.1833, 10.3901>
		<-3.8281, 12.1875, 10.4545> <-3.8324, 12.1867, 10.4348> <-3.8352, 12.1853, 10.4080> <-3.8393, 12.1862, 10.3883>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8281, 12.1875, 10.4545> <-3.8324, 12.1867, 10.4348> <-3.8352, 12.1853, 10.4080> <-3.8393, 12.1862, 10.3883>
		<-3.8075, 12.1917, 10.4489> <-3.8118, 12.1909, 10.4292> <-3.8178, 12.1891, 10.4056> <-3.8219, 12.1900, 10.3859>
		<-3.7784, 12.2124, 10.4330> <-3.7808, 12.2100, 10.4168> <-3.7883, 12.2119, 10.3941> <-3.7964, 12.2084, 10.3800>
		<-3.7857, 12.2464, 10.4290> <-3.7881, 12.2440, 10.4128> <-3.7942, 12.2400, 10.3913> <-3.8023, 12.2366, 10.3772>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8563, 12.2673, 10.3803> <-3.8392, 12.2710, 10.3779> <-3.8080, 12.2642, 10.3745> <-3.8023, 12.2366, 10.3772>
		<-3.8575, 12.2640, 10.3713> <-3.8405, 12.2678, 10.3689> <-3.8147, 12.2614, 10.3629> <-3.8089, 12.2338, 10.3657>
		<-3.8609, 12.2599, 10.3582> <-3.8506, 12.2620, 10.3548> <-3.8259, 12.2468, 10.3503> <-3.8218, 12.2295, 10.3523>
		<-3.8619, 12.2521, 10.3526> <-3.8515, 12.2542, 10.3492> <-3.8374, 12.2433, 10.3441> <-3.8334, 12.2261, 10.3461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8563, 12.2673, 10.3803> <-3.8575, 12.2640, 10.3713> <-3.8609, 12.2599, 10.3582> <-3.8619, 12.2521, 10.3526>
		<-3.8696, 12.2644, 10.3821> <-3.8709, 12.2611, 10.3731> <-3.8703, 12.2580, 10.3612> <-3.8712, 12.2502, 10.3556>
		<-3.8805, 12.2656, 10.3824> <-3.8781, 12.2631, 10.3555> <-3.8804, 12.2414, 10.3740> <-3.8763, 12.2402, 10.3558>
		<-3.8713, 12.2215, 10.3868> <-3.8689, 12.2190, 10.3599> <-3.8753, 12.2195, 10.3765> <-3.8712, 12.2183, 10.3583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8713, 12.2215, 10.3868> <-3.8689, 12.2190, 10.3599> <-3.8753, 12.2195, 10.3765> <-3.8712, 12.2183, 10.3583>
		<-3.8623, 12.1783, 10.3911> <-3.8599, 12.1758, 10.3642> <-3.8702, 12.1977, 10.3790> <-3.8661, 12.1965, 10.3609>
		<-3.8524, 12.1833, 10.3901> <-3.8543, 12.1837, 10.3812> <-3.8536, 12.1846, 10.3693> <-3.8572, 12.1897, 10.3626>
		<-3.8393, 12.1862, 10.3883> <-3.8412, 12.1866, 10.3794> <-3.8443, 12.1866, 10.3663> <-3.8478, 12.1917, 10.3596>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8393, 12.1862, 10.3883> <-3.8412, 12.1866, 10.3794> <-3.8443, 12.1866, 10.3663> <-3.8478, 12.1917, 10.3596>
		<-3.8219, 12.1900, 10.3859> <-3.8237, 12.1904, 10.3770> <-3.8338, 12.1887, 10.3629> <-3.8373, 12.1938, 10.3562>
		<-3.7964, 12.2084, 10.3800> <-3.8030, 12.2056, 10.3685> <-3.8178, 12.2121, 10.3543> <-3.8294, 12.2086, 10.3481>
		<-3.8023, 12.2366, 10.3772> <-3.8089, 12.2338, 10.3657> <-3.8218, 12.2295, 10.3523> <-3.8334, 12.2261, 10.3461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8619, 12.2187, 10.3454> <-3.8604, 12.2124, 10.3461> <-3.8517, 12.1973, 10.3521> <-3.8478, 12.1917, 10.3596>
		<-3.8619, 12.2187, 10.3454> <-3.8633, 12.2118, 10.3471> <-3.8611, 12.1954, 10.3552> <-3.8572, 12.1897, 10.3626>
		<-3.8619, 12.2187, 10.3454> <-3.8633, 12.2118, 10.3471> <-3.8638, 12.1958, 10.3507> <-3.8661, 12.1965, 10.3609>
		<-3.8619, 12.2187, 10.3454> <-3.8648, 12.2181, 10.3463> <-3.8689, 12.2176, 10.3482> <-3.8712, 12.2183, 10.3583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8619, 12.2187, 10.3454> <-3.8565, 12.2198, 10.3436> <-3.8410, 12.2238, 10.3421> <-3.8334, 12.2261, 10.3461>
		<-3.8619, 12.2187, 10.3454> <-3.8550, 12.2135, 10.3444> <-3.8369, 12.2063, 10.3441> <-3.8294, 12.2086, 10.3481>
		<-3.8619, 12.2187, 10.3454> <-3.8550, 12.2135, 10.3444> <-3.8412, 12.1994, 10.3487> <-3.8373, 12.1938, 10.3562>
		<-3.8619, 12.2187, 10.3454> <-3.8604, 12.2124, 10.3461> <-3.8517, 12.1973, 10.3521> <-3.8478, 12.1917, 10.3596>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8619, 12.2187, 10.3454> <-3.8634, 12.2252, 10.3446> <-3.8628, 12.2438, 10.3466> <-3.8619, 12.2521, 10.3526>
		<-3.8619, 12.2187, 10.3454> <-3.8580, 12.2263, 10.3429> <-3.8525, 12.2460, 10.3433> <-3.8515, 12.2542, 10.3492>
		<-3.8619, 12.2187, 10.3454> <-3.8580, 12.2263, 10.3429> <-3.8450, 12.2410, 10.3401> <-3.8374, 12.2433, 10.3441>
		<-3.8619, 12.2187, 10.3454> <-3.8565, 12.2198, 10.3436> <-3.8410, 12.2238, 10.3421> <-3.8334, 12.2261, 10.3461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8619, 12.2187, 10.3454> <-3.8648, 12.2181, 10.3463> <-3.8689, 12.2176, 10.3482> <-3.8712, 12.2183, 10.3583>
		<-3.8619, 12.2187, 10.3454> <-3.8663, 12.2246, 10.3456> <-3.8739, 12.2395, 10.3457> <-3.8763, 12.2402, 10.3558>
		<-3.8619, 12.2187, 10.3454> <-3.8663, 12.2246, 10.3456> <-3.8722, 12.2419, 10.3497> <-3.8712, 12.2502, 10.3556>
		<-3.8619, 12.2187, 10.3454> <-3.8634, 12.2252, 10.3446> <-3.8628, 12.2438, 10.3466> <-3.8619, 12.2521, 10.3526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5256, 12.5857, 10.5065> <-3.4962, 12.5864, 10.4897> <-3.4770, 12.5805, 10.4437> <-3.4622, 12.5781, 10.4133>
		<-3.5256, 12.6202, 10.5049> <-3.4961, 12.6209, 10.4881> <-3.4832, 12.6081, 10.4440> <-3.4683, 12.6056, 10.4136>
		<-3.5857, 12.6517, 10.4213> <-3.5912, 12.6508, 10.4202> <-3.5182, 12.6336, 10.4191> <-3.5009, 12.6329, 10.4008>
		<-3.5844, 12.6519, 10.4228> <-3.5899, 12.6509, 10.4217> <-3.5219, 12.6615, 10.4165> <-3.5046, 12.6607, 10.3983>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5256, 12.5857, 10.5065> <-3.5257, 12.5455, 10.5085> <-3.5870, 12.4806, 10.4283> <-3.5847, 12.4809, 10.4309>
		<-3.4962, 12.5864, 10.4897> <-3.4962, 12.5462, 10.4916> <-3.5873, 12.4806, 10.4282> <-3.5850, 12.4809, 10.4309>
		<-3.4770, 12.5805, 10.4437> <-3.4711, 12.5541, 10.4433> <-3.4971, 12.5171, 10.4249> <-3.4924, 12.4905, 10.4227>
		<-3.4622, 12.5781, 10.4133> <-3.4563, 12.5516, 10.4129> <-3.4711, 12.5159, 10.3985> <-3.4664, 12.4893, 10.3962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4805, 12.4194, 10.4970> <-3.4545, 12.4191, 10.4769> <-3.4444, 12.4137, 10.4295> <-3.4324, 12.4116, 10.3990>
		<-3.4851, 12.4578, 10.5026> <-3.4592, 12.4575, 10.4825> <-3.4451, 12.4389, 10.4325> <-3.4331, 12.4369, 10.4020>
		<-3.5877, 12.4805, 10.4293> <-3.5880, 12.4805, 10.4293> <-3.4879, 12.4656, 10.4205> <-3.4619, 12.4644, 10.3941>
		<-3.5847, 12.4809, 10.4309> <-3.5850, 12.4809, 10.4309> <-3.4924, 12.4905, 10.4227> <-3.4664, 12.4893, 10.3962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4805, 12.4194, 10.4970> <-3.4751, 12.3744, 10.4904> <-3.5638, 12.3151, 10.4071> <-3.5647, 12.3150, 10.4066>
		<-3.4545, 12.4191, 10.4769> <-3.4491, 12.3741, 10.4703> <-3.5650, 12.3151, 10.4069> <-3.5658, 12.3150, 10.4064>
		<-3.4444, 12.4137, 10.4295> <-3.4434, 12.3811, 10.4255> <-3.4847, 12.3437, 10.4013> <-3.4837, 12.3110, 10.3979>
		<-3.4324, 12.4116, 10.3990> <-3.4314, 12.3790, 10.3950> <-3.4622, 12.3415, 10.3779> <-3.4611, 12.3088, 10.3744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4864, 12.2460, 10.4645> <-3.4628, 12.2413, 10.4432> <-3.4390, 12.2294, 10.4076> <-3.4262, 12.2223, 10.3790>
		<-3.4899, 12.2767, 10.4507> <-3.4663, 12.2719, 10.4293> <-3.4292, 12.2555, 10.4108> <-3.4163, 12.2483, 10.3822>
		<-3.5640, 12.3150, 10.4069> <-3.5652, 12.3150, 10.4067> <-3.4827, 12.2832, 10.3949> <-3.4602, 12.2810, 10.3715>
		<-3.5647, 12.3150, 10.4066> <-3.5658, 12.3150, 10.4064> <-3.4837, 12.3110, 10.3979> <-3.4611, 12.3088, 10.3744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4864, 12.2460, 10.4645> <-3.4838, 12.2228, 10.4750> <-3.5258, 12.1827, 10.4768> <-3.5494, 12.1813, 10.4672>
		<-3.4628, 12.2413, 10.4432> <-3.4601, 12.2181, 10.4537> <-3.5057, 12.1792, 10.4485> <-3.5294, 12.1778, 10.4389>
		<-3.4390, 12.2294, 10.4076> <-3.4501, 12.2004, 10.4040> <-3.4952, 12.1724, 10.3967> <-3.5257, 12.1733, 10.3898>
		<-3.4262, 12.2223, 10.3790> <-3.4372, 12.1932, 10.3754> <-3.4833, 12.1690, 10.3642> <-3.5138, 12.1699, 10.3573>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5494, 12.1813, 10.4672> <-3.5799, 12.1796, 10.4548> <-3.6247, 12.1901, 10.4277> <-3.6302, 12.2379, 10.4060>
		<-3.5294, 12.1778, 10.4389> <-3.5598, 12.1761, 10.4265> <-3.6073, 12.1876, 10.4111> <-3.6127, 12.2354, 10.3894>
		<-3.5257, 12.1733, 10.3898> <-3.5512, 12.1740, 10.3841> <-3.5786, 12.2081, 10.3668> <-3.5896, 12.2318, 10.3658>
		<-3.5138, 12.1699, 10.3573> <-3.5393, 12.1706, 10.3516> <-3.5676, 12.2031, 10.3458> <-3.5786, 12.2267, 10.3448>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6302, 12.2379, 10.4060> <-3.6350, 12.2796, 10.3871> <-3.5653, 12.3150, 10.4064> <-3.5647, 12.3150, 10.4066>
		<-3.6127, 12.2354, 10.3894> <-3.6175, 12.2771, 10.3705> <-3.5647, 12.3150, 10.4065> <-3.5641, 12.3150, 10.4067>
		<-3.5896, 12.2318, 10.3658> <-3.5997, 12.2534, 10.3649> <-3.5756, 12.2844, 10.3666> <-3.5790, 12.3080, 10.3686>
		<-3.5786, 12.2267, 10.3448> <-3.5887, 12.2484, 10.3439> <-3.5741, 12.2826, 10.3497> <-3.5774, 12.3062, 10.3517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5647, 12.3150, 10.4066> <-3.5654, 12.3149, 10.4063> <-3.6432, 12.3458, 10.3983> <-3.6497, 12.3994, 10.4061>
		<-3.5641, 12.3150, 10.4067> <-3.5648, 12.3149, 10.4064> <-3.6269, 12.3465, 10.3871> <-3.6333, 12.4001, 10.3950>
		<-3.5790, 12.3080, 10.3686> <-3.5830, 12.3363, 10.3710> <-3.6078, 12.3703, 10.3739> <-3.6122, 12.3985, 10.3769>
		<-3.5774, 12.3062, 10.3517> <-3.5815, 12.3345, 10.3541> <-3.5987, 12.3698, 10.3563> <-3.6030, 12.3980, 10.3593>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6497, 12.3994, 10.4061> <-3.6554, 12.4473, 10.4132> <-3.5823, 12.4812, 10.4322> <-3.5847, 12.4809, 10.4309>
		<-3.6333, 12.4001, 10.3950> <-3.6391, 12.4480, 10.4020> <-3.5822, 12.4812, 10.4322> <-3.5845, 12.4809, 10.4310>
		<-3.6122, 12.3985, 10.3769> <-3.6159, 12.4226, 10.3795> <-3.6040, 12.4563, 10.3893> <-3.6071, 12.4807, 10.3892>
		<-3.6030, 12.3980, 10.3593> <-3.6067, 12.4222, 10.3620> <-3.6009, 12.4548, 10.3705> <-3.6040, 12.4791, 10.3704>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5847, 12.4809, 10.4309> <-3.5826, 12.4811, 10.4333> <-3.6450, 12.5150, 10.3739> <-3.6449, 12.5714, 10.3712>
		<-3.5845, 12.4809, 10.4310> <-3.5825, 12.4811, 10.4333> <-3.6375, 12.5157, 10.3714> <-3.6374, 12.5721, 10.3687>
		<-3.6071, 12.4807, 10.3892> <-3.6103, 12.5061, 10.3890> <-3.6241, 12.5375, 10.3648> <-3.6276, 12.5629, 10.3653>
		<-3.6040, 12.4791, 10.3704> <-3.6072, 12.5045, 10.3703> <-3.6204, 12.5359, 10.3579> <-3.6239, 12.5613, 10.3584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6449, 12.5714, 10.3712> <-3.6448, 12.6229, 10.3687> <-3.5832, 12.6520, 10.4242> <-3.5844, 12.6519, 10.4228>
		<-3.6374, 12.5721, 10.3687> <-3.6373, 12.6236, 10.3663> <-3.5788, 12.6527, 10.4250> <-3.5801, 12.6526, 10.4237>
		<-3.6276, 12.5629, 10.3653> <-3.6309, 12.5867, 10.3658> <-3.6244, 12.6201, 10.3974> <-3.6279, 12.6435, 10.3930>
		<-3.6239, 12.5613, 10.3584> <-3.6272, 12.5851, 10.3589> <-3.6227, 12.6166, 10.3782> <-3.6262, 12.6400, 10.3738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5844, 12.6519, 10.4228> <-3.5899, 12.6509, 10.4217> <-3.5219, 12.6615, 10.4165> <-3.5046, 12.6607, 10.3983>
		<-3.5859, 12.6515, 10.4216> <-3.5914, 12.6505, 10.4205> <-3.5256, 12.6892, 10.4139> <-3.5083, 12.6885, 10.3957>
		<-3.5329, 12.7249, 10.4743> <-3.5086, 12.7268, 10.4635> <-3.4879, 12.7301, 10.4285> <-3.4752, 12.7276, 10.4052>
		<-3.5410, 12.7576, 10.4661> <-3.5167, 12.7594, 10.4553> <-3.4981, 12.7550, 10.4204> <-3.4854, 12.7525, 10.3971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5844, 12.6519, 10.4228> <-3.5801, 12.6526, 10.4237> <-3.6279, 12.6435, 10.3930> <-3.6262, 12.6400, 10.3738>
		<-3.5826, 12.6523, 10.4243> <-3.5783, 12.6530, 10.4251> <-3.6324, 12.6734, 10.3875> <-3.6307, 12.6699, 10.3682>
		<-3.6720, 12.6578, 10.3619> <-3.6596, 12.6609, 10.3589> <-3.6653, 12.6999, 10.3426> <-3.6582, 12.6992, 10.3316>
		<-3.6876, 12.7203, 10.3462> <-3.6752, 12.7234, 10.3432> <-3.6561, 12.7288, 10.3382> <-3.6490, 12.7281, 10.3272>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6876, 12.7203, 10.3462> <-3.6752, 12.7234, 10.3432> <-3.6561, 12.7288, 10.3382> <-3.6490, 12.7281, 10.3272>
		<-3.6999, 12.7694, 10.3339> <-3.6875, 12.7726, 10.3309> <-3.6451, 12.7633, 10.3329> <-3.6380, 12.7627, 10.3219>
		<-3.6477, 12.8008, 10.3637> <-3.6297, 12.8035, 10.3556> <-3.6100, 12.8150, 10.3508> <-3.6026, 12.8136, 10.3323>
		<-3.6231, 12.8071, 10.3838> <-3.6050, 12.8098, 10.3757> <-3.5766, 12.8199, 10.3650> <-3.5692, 12.8186, 10.3465>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6231, 12.8071, 10.3838> <-3.6050, 12.8098, 10.3757> <-3.5766, 12.8199, 10.3650> <-3.5692, 12.8186, 10.3465>
		<-3.5959, 12.8140, 10.4061> <-3.5779, 12.8167, 10.3980> <-3.5443, 12.8247, 10.3788> <-3.5369, 12.8234, 10.3603>
		<-3.5494, 12.7913, 10.4576> <-3.5252, 12.7932, 10.4468> <-3.5109, 12.7863, 10.4101> <-3.4983, 12.7838, 10.3868>
		<-3.5410, 12.7576, 10.4661> <-3.5167, 12.7594, 10.4553> <-3.4981, 12.7550, 10.4204> <-3.4854, 12.7525, 10.3971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6192, 12.9745, 10.2082> <-3.6488, 12.9612, 10.1962> <-3.6867, 12.9188, 10.1778> <-3.6694, 12.8662, 10.1828>
		<-3.5948, 12.9759, 10.1747> <-3.6244, 12.9626, 10.1627> <-3.6799, 12.9229, 10.1581> <-3.6626, 12.8703, 10.1632>
		<-3.5689, 12.9786, 10.1248> <-3.6072, 12.9670, 10.1123> <-3.6566, 12.9022, 10.1115> <-3.6573, 12.8673, 10.1348>
		<-3.5491, 12.9708, 10.0892> <-3.5874, 12.9592, 10.0767> <-3.6502, 12.9014, 10.0913> <-3.6509, 12.8666, 10.1146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6192, 12.9745, 10.2082> <-3.6421, 12.9732, 10.2396> <-3.6592, 12.9734, 10.2583> <-3.7056, 12.9620, 10.3039>
		<-3.6488, 12.9612, 10.1962> <-3.6717, 12.9600, 10.2276> <-3.6844, 12.9330, 10.2138> <-3.7308, 12.9216, 10.2593>
		<-3.6867, 12.9188, 10.1778> <-3.6961, 12.9131, 10.2052> <-3.7086, 12.8752, 10.2382> <-3.7248, 12.8674, 10.2617>
		<-3.6694, 12.8662, 10.1828> <-3.6788, 12.8605, 10.2102> <-3.6880, 12.8422, 10.2458> <-3.7042, 12.8344, 10.2693>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6192, 12.9745, 10.2082> <-3.5916, 12.9869, 10.2194> <-3.5291, 12.9641, 10.2409> <-3.5191, 12.9336, 10.2439>
		<-3.6421, 12.9732, 10.2396> <-3.6144, 12.9856, 10.2508> <-3.5650, 12.9665, 10.2824> <-3.5550, 12.9360, 10.2854>
		<-3.6592, 12.9734, 10.2583> <-3.6396, 13.0049, 10.2930> <-3.6174, 12.9635, 10.3362> <-3.6022, 12.9392, 10.3419>
		<-3.7056, 12.9620, 10.3039> <-3.6860, 12.9935, 10.3386> <-3.6567, 12.9591, 10.3743> <-3.6416, 12.9348, 10.3799>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6192, 12.9745, 10.2082> <-3.5948, 12.9759, 10.1747> <-3.5689, 12.9786, 10.1248> <-3.5491, 12.9708, 10.0892>
		<-3.5916, 12.9869, 10.2194> <-3.5672, 12.9883, 10.1860> <-3.5353, 12.9888, 10.1358> <-3.5155, 12.9810, 10.1002>
		<-3.5291, 12.9641, 10.2409> <-3.5118, 12.9630, 10.2210> <-3.4791, 12.9598, 10.1759> <-3.4640, 12.9537, 10.1551>
		<-3.5191, 12.9336, 10.2439> <-3.5018, 12.9325, 10.2239> <-3.4797, 12.9292, 10.1963> <-3.4646, 12.9231, 10.1756>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5191, 12.9336, 10.2439> <-3.5018, 12.9325, 10.2239> <-3.4797, 12.9292, 10.1963> <-3.4646, 12.9231, 10.1756>
		<-3.5066, 12.8958, 10.2475> <-3.4893, 12.8947, 10.2276> <-3.4804, 12.8917, 10.2214> <-3.4653, 12.8855, 10.2006>
		<-3.5278, 12.8160, 10.2389> <-3.5249, 12.8148, 10.2333> <-3.5086, 12.8065, 10.2151> <-3.5090, 12.8074, 10.2214>
		<-3.5619, 12.8007, 10.2250> <-3.5591, 12.7995, 10.2194> <-3.5522, 12.7932, 10.2008> <-3.5526, 12.7941, 10.2071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5191, 12.9336, 10.2439> <-3.5066, 12.8958, 10.2475> <-3.5278, 12.8160, 10.2389> <-3.5619, 12.8007, 10.2250>
		<-3.5550, 12.9360, 10.2854> <-3.5425, 12.8982, 10.2890> <-3.5445, 12.8229, 10.2721> <-3.5787, 12.8076, 10.2582>
		<-3.6022, 12.9392, 10.3419> <-3.5840, 12.9099, 10.3486> <-3.5585, 12.8513, 10.3250> <-3.5822, 12.8134, 10.2833>
		<-3.6416, 12.9348, 10.3799> <-3.6233, 12.9055, 10.3867> <-3.5941, 12.8590, 10.3781> <-3.6177, 12.8211, 10.3363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7056, 12.9620, 10.3039> <-3.7486, 12.9514, 10.3460> <-3.7701, 12.9417, 10.3541> <-3.7936, 12.9315, 10.3795>
		<-3.7308, 12.9216, 10.2593> <-3.7738, 12.9110, 10.3015> <-3.7871, 12.9168, 10.3349> <-3.8105, 12.9066, 10.3602>
		<-3.7248, 12.8674, 10.2617> <-3.7458, 12.8572, 10.2920> <-3.8052, 12.8511, 10.3110> <-3.8288, 12.8465, 10.3408>
		<-3.7042, 12.8344, 10.2693> <-3.7252, 12.8242, 10.2996> <-3.7675, 12.8117, 10.3290> <-3.7912, 12.8072, 10.3588>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7056, 12.9620, 10.3039> <-3.6860, 12.9935, 10.3386> <-3.6567, 12.9591, 10.3743> <-3.6416, 12.9348, 10.3799>
		<-3.7486, 12.9514, 10.3460> <-3.7289, 12.9829, 10.3807> <-3.6786, 12.9567, 10.3954> <-3.6634, 12.9323, 10.4010>
		<-3.7701, 12.9417, 10.3541> <-3.7572, 12.9607, 10.3688> <-3.7107, 12.9664, 10.3871> <-3.6742, 12.9282, 10.4046>
		<-3.7936, 12.9315, 10.3795> <-3.7807, 12.9505, 10.3941> <-3.7571, 12.9491, 10.4215> <-3.7206, 12.9110, 10.4390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6416, 12.9348, 10.3799> <-3.6233, 12.9055, 10.3867> <-3.5941, 12.8590, 10.3781> <-3.6177, 12.8211, 10.3363>
		<-3.6634, 12.9323, 10.4010> <-3.6451, 12.9031, 10.4078> <-3.6278, 12.8663, 10.4284> <-3.6514, 12.8284, 10.3866>
		<-3.6742, 12.9282, 10.4046> <-3.6418, 12.8943, 10.4201> <-3.6598, 12.8475, 10.4134> <-3.6713, 12.8306, 10.4003>
		<-3.7206, 12.9110, 10.4390> <-3.6882, 12.8771, 10.4545> <-3.6850, 12.8468, 10.4389> <-3.6965, 12.8300, 10.4259>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6177, 12.8211, 10.3363> <-3.5822, 12.8134, 10.2833> <-3.5787, 12.8076, 10.2582> <-3.5619, 12.8007, 10.2250>
		<-3.6387, 12.7874, 10.2992> <-3.6032, 12.7797, 10.2462> <-3.6109, 12.7932, 10.2451> <-3.5941, 12.7862, 10.2119>
		<-3.6870, 12.8068, 10.2756> <-3.6708, 12.8147, 10.2522> <-3.6600, 12.8033, 10.2157> <-3.6506, 12.8090, 10.1883>
		<-3.7042, 12.8344, 10.2693> <-3.6880, 12.8422, 10.2458> <-3.6788, 12.8605, 10.2102> <-3.6694, 12.8662, 10.1828>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6177, 12.8211, 10.3363> <-3.6387, 12.7874, 10.2992> <-3.6870, 12.8068, 10.2756> <-3.7042, 12.8344, 10.2693>
		<-3.6514, 12.8284, 10.3866> <-3.6724, 12.7948, 10.3495> <-3.7080, 12.7966, 10.3060> <-3.7252, 12.8242, 10.2996>
		<-3.6713, 12.8306, 10.4003> <-3.6872, 12.8072, 10.3823> <-3.7322, 12.7748, 10.3459> <-3.7675, 12.8117, 10.3290>
		<-3.6965, 12.8300, 10.4259> <-3.7124, 12.8066, 10.4078> <-3.7558, 12.7702, 10.3757> <-3.7912, 12.8072, 10.3588>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7936, 12.9315, 10.3795> <-3.8119, 12.9235, 10.3992> <-3.8304, 12.9115, 10.4301> <-3.8437, 12.9021, 10.4529>
		<-3.8105, 12.9066, 10.3602> <-3.8288, 12.8986, 10.3800> <-3.8404, 12.8930, 10.4129> <-3.8537, 12.8835, 10.4358>
		<-3.8288, 12.8465, 10.3408> <-3.8440, 12.8436, 10.3600> <-3.8493, 12.8364, 10.3939> <-3.8588, 12.8409, 10.4162>
		<-3.7912, 12.8072, 10.3588> <-3.8063, 12.8042, 10.3780> <-3.8221, 12.8051, 10.4079> <-3.8317, 12.8096, 10.4302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7936, 12.9315, 10.3795> <-3.7807, 12.9505, 10.3941> <-3.7571, 12.9491, 10.4215> <-3.7206, 12.9110, 10.4390>
		<-3.8119, 12.9235, 10.3992> <-3.7990, 12.9426, 10.4139> <-3.8018, 12.9325, 10.4546> <-3.7653, 12.8944, 10.4721>
		<-3.8304, 12.9115, 10.4301> <-3.8233, 12.9246, 10.4423> <-3.7646, 12.9534, 10.4200> <-3.7254, 12.9081, 10.4402>
		<-3.8437, 12.9021, 10.4529> <-3.8366, 12.9152, 10.4651> <-3.8340, 12.9231, 10.4733> <-3.7948, 12.8779, 10.4935>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7206, 12.9110, 10.4390> <-3.6882, 12.8771, 10.4545> <-3.6850, 12.8468, 10.4389> <-3.6965, 12.8300, 10.4259>
		<-3.7653, 12.8944, 10.4721> <-3.7330, 12.8605, 10.4876> <-3.7059, 12.8463, 10.4601> <-3.7174, 12.8294, 10.4470>
		<-3.7254, 12.9081, 10.4402> <-3.6876, 12.8645, 10.4597> <-3.7406, 12.8318, 10.4836> <-3.7475, 12.8192, 10.4718>
		<-3.7948, 12.8779, 10.4935> <-3.7570, 12.8342, 10.5129> <-3.7634, 12.8298, 10.5026> <-3.7702, 12.8172, 10.4908>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6965, 12.8300, 10.4259> <-3.7124, 12.8066, 10.4078> <-3.7558, 12.7702, 10.3757> <-3.7912, 12.8072, 10.3588>
		<-3.7174, 12.8294, 10.4470> <-3.7332, 12.8061, 10.4290> <-3.7710, 12.7673, 10.3949> <-3.8063, 12.8042, 10.3780>
		<-3.7475, 12.8192, 10.4718> <-3.7565, 12.8024, 10.4563> <-3.7977, 12.7768, 10.4205> <-3.8221, 12.8051, 10.4079>
		<-3.7702, 12.8172, 10.4908> <-3.7793, 12.8004, 10.4753> <-3.8072, 12.7813, 10.4428> <-3.8317, 12.8096, 10.4302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8437, 12.9021, 10.4529> <-3.8503, 12.8974, 10.4642> <-3.8590, 12.8936, 10.4820> <-3.8596, 12.8847, 10.4926>
		<-3.8537, 12.8835, 10.4358> <-3.8603, 12.8789, 10.4470> <-3.8656, 12.8839, 10.4725> <-3.8661, 12.8751, 10.4831>
		<-3.8588, 12.8409, 10.4162> <-3.8663, 12.8444, 10.4336> <-3.8584, 12.8438, 10.4635> <-3.8615, 12.8513, 10.4810>
		<-3.8317, 12.8096, 10.4302> <-3.8392, 12.8131, 10.4476> <-3.8437, 12.8259, 10.4704> <-3.8468, 12.8334, 10.4880>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8437, 12.9021, 10.4529> <-3.8366, 12.9152, 10.4651> <-3.8340, 12.9231, 10.4733> <-3.7948, 12.8779, 10.4935>
		<-3.8503, 12.8974, 10.4642> <-3.8432, 12.9105, 10.4764> <-3.8636, 12.9102, 10.4960> <-3.8244, 12.8650, 10.5162>
		<-3.8590, 12.8936, 10.4820> <-3.8531, 12.9023, 10.4904> <-3.8219, 12.9004, 10.5001> <-3.8034, 12.8781, 10.5088>
		<-3.8596, 12.8847, 10.4926> <-3.8537, 12.8934, 10.5010> <-3.8436, 12.8877, 10.5104> <-3.8252, 12.8654, 10.5191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7948, 12.8779, 10.4935> <-3.7570, 12.8342, 10.5129> <-3.7634, 12.8298, 10.5026> <-3.7702, 12.8172, 10.4908>
		<-3.8244, 12.8650, 10.5162> <-3.7866, 12.8213, 10.5356> <-3.7737, 12.8289, 10.5113> <-3.7806, 12.8163, 10.4995>
		<-3.8034, 12.8781, 10.5088> <-3.7845, 12.8551, 10.5178> <-3.7884, 12.8246, 10.5222> <-3.7944, 12.8156, 10.5135>
		<-3.8252, 12.8654, 10.5191> <-3.8062, 12.8425, 10.5281> <-3.8004, 12.8293, 10.5265> <-3.8064, 12.8203, 10.5178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7702, 12.8172, 10.4908> <-3.7793, 12.8004, 10.4753> <-3.8072, 12.7813, 10.4428> <-3.8317, 12.8096, 10.4302>
		<-3.7806, 12.8163, 10.4995> <-3.7897, 12.7995, 10.4840> <-3.8147, 12.7848, 10.4602> <-3.8392, 12.8131, 10.4476>
		<-3.7944, 12.8156, 10.5135> <-3.8008, 12.8062, 10.5042> <-3.8293, 12.8085, 10.4773> <-3.8437, 12.8259, 10.4704>
		<-3.8064, 12.8203, 10.5178> <-3.8128, 12.8109, 10.5085> <-3.8324, 12.8160, 10.4948> <-3.8468, 12.8334, 10.4880>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8471, 12.8473, 10.5184> <-3.8413, 12.8403, 10.5211> <-3.8194, 12.8254, 10.5224> <-3.8064, 12.8203, 10.5178>
		<-3.8471, 12.8473, 10.5184> <-3.8442, 12.8360, 10.5170> <-3.8258, 12.8159, 10.5132> <-3.8128, 12.8109, 10.5085>
		<-3.8471, 12.8473, 10.5184> <-3.8442, 12.8360, 10.5170> <-3.8340, 12.8199, 10.5039> <-3.8324, 12.8160, 10.4948>
		<-3.8471, 12.8473, 10.5184> <-3.8500, 12.8431, 10.5142> <-3.8484, 12.8373, 10.4971> <-3.8468, 12.8334, 10.4880>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8471, 12.8473, 10.5184> <-3.8500, 12.8431, 10.5142> <-3.8484, 12.8373, 10.4971> <-3.8468, 12.8334, 10.4880>
		<-3.8471, 12.8473, 10.5184> <-3.8556, 12.8499, 10.5116> <-3.8631, 12.8552, 10.4901> <-3.8615, 12.8513, 10.4810>
		<-3.8471, 12.8473, 10.5184> <-3.8556, 12.8499, 10.5116> <-3.8667, 12.8660, 10.4939> <-3.8661, 12.8751, 10.4831>
		<-3.8471, 12.8473, 10.5184> <-3.8528, 12.8541, 10.5157> <-3.8601, 12.8757, 10.5034> <-3.8596, 12.8847, 10.4926>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8471, 12.8473, 10.5184> <-3.8528, 12.8541, 10.5157> <-3.8601, 12.8757, 10.5034> <-3.8596, 12.8847, 10.4926>
		<-3.8471, 12.8473, 10.5184> <-3.8503, 12.8577, 10.5192> <-3.8543, 12.8844, 10.5119> <-3.8537, 12.8934, 10.5010>
		<-3.8471, 12.8473, 10.5184> <-3.8503, 12.8577, 10.5192> <-3.8585, 12.8791, 10.5175> <-3.8436, 12.8877, 10.5104>
		<-3.8471, 12.8473, 10.5184> <-3.8447, 12.8509, 10.5219> <-3.8400, 12.8567, 10.5262> <-3.8252, 12.8654, 10.5191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8471, 12.8473, 10.5184> <-3.8447, 12.8509, 10.5219> <-3.8400, 12.8567, 10.5262> <-3.8252, 12.8654, 10.5191>
		<-3.8471, 12.8473, 10.5184> <-3.8389, 12.8438, 10.5246> <-3.8211, 12.8338, 10.5352> <-3.8062, 12.8425, 10.5281>
		<-3.8471, 12.8473, 10.5184> <-3.8389, 12.8438, 10.5246> <-3.8133, 12.8343, 10.5311> <-3.8004, 12.8293, 10.5265>
		<-3.8471, 12.8473, 10.5184> <-3.8413, 12.8403, 10.5211> <-3.8194, 12.8254, 10.5224> <-3.8064, 12.8203, 10.5178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4126, 12.6445, 10.2420> <-3.4170, 12.6714, 10.2436> <-3.4052, 12.7147, 10.2548> <-3.4236, 12.7344, 10.2502>
		<-3.4397, 12.6503, 10.2891> <-3.4441, 12.6772, 10.2906> <-3.4247, 12.7217, 10.2982> <-3.4430, 12.7413, 10.2937>
		<-3.4670, 12.6591, 10.3587> <-3.4707, 12.6869, 10.3561> <-3.4523, 12.7230, 10.3632> <-3.4625, 12.7479, 10.3550>
		<-3.5046, 12.6607, 10.3983> <-3.5083, 12.6885, 10.3957> <-3.4752, 12.7276, 10.4052> <-3.4854, 12.7525, 10.3971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4126, 12.6445, 10.2420> <-3.3995, 12.6417, 10.2192> <-3.3834, 12.6358, 10.1884> <-3.3708, 12.6319, 10.1655>
		<-3.4170, 12.6714, 10.2436> <-3.4039, 12.6686, 10.2208> <-3.3905, 12.6682, 10.1919> <-3.3779, 12.6643, 10.1690>
		<-3.4052, 12.7147, 10.2548> <-3.3946, 12.7109, 10.2311> <-3.3866, 12.6989, 10.1990> <-3.3749, 12.6930, 10.1762>
		<-3.4236, 12.7344, 10.2502> <-3.4130, 12.7306, 10.2265> <-3.3970, 12.7224, 10.1963> <-3.3853, 12.7166, 10.1736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4126, 12.6445, 10.2420> <-3.4087, 12.6202, 10.2406> <-3.3986, 12.5886, 10.2413> <-3.3957, 12.5641, 10.2405>
		<-3.3995, 12.6417, 10.2192> <-3.3956, 12.6174, 10.2178> <-3.3869, 12.5861, 10.2148> <-3.3841, 12.5616, 10.2139>
		<-3.3834, 12.6358, 10.1884> <-3.3766, 12.6052, 10.1852> <-3.3667, 12.5806, 10.1844> <-3.3628, 12.5566, 10.1816>
		<-3.3708, 12.6319, 10.1655> <-3.3640, 12.6014, 10.1623> <-3.3531, 12.5778, 10.1589> <-3.3492, 12.5538, 10.1561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4126, 12.6445, 10.2420> <-3.4397, 12.6503, 10.2891> <-3.4670, 12.6591, 10.3587> <-3.5046, 12.6607, 10.3983>
		<-3.4087, 12.6202, 10.2406> <-3.4357, 12.6261, 10.2877> <-3.4633, 12.6313, 10.3613> <-3.5009, 12.6329, 10.4008>
		<-3.3986, 12.5886, 10.2413> <-3.4209, 12.5934, 10.2921> <-3.4440, 12.6016, 10.3637> <-3.4683, 12.6056, 10.4136>
		<-3.3957, 12.5641, 10.2405> <-3.4180, 12.5689, 10.2913> <-3.4378, 12.5740, 10.3633> <-3.4622, 12.5781, 10.4133>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4236, 12.7344, 10.2502> <-3.4130, 12.7306, 10.2265> <-3.3970, 12.7224, 10.1963> <-3.3853, 12.7166, 10.1736>
		<-3.4536, 12.7665, 10.2427> <-3.4430, 12.7626, 10.2190> <-3.4075, 12.7461, 10.1937> <-3.3958, 12.7402, 10.1709>
		<-3.5099, 12.7997, 10.2186> <-3.4835, 12.7969, 10.2053> <-3.4595, 12.7657, 10.1882> <-3.4337, 12.7584, 10.1599>
		<-3.5526, 12.7941, 10.2071> <-3.5262, 12.7913, 10.1938> <-3.4627, 12.7890, 10.1772> <-3.4368, 12.7817, 10.1489>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4236, 12.7344, 10.2502> <-3.4430, 12.7413, 10.2937> <-3.4625, 12.7479, 10.3550> <-3.4854, 12.7525, 10.3971>
		<-3.4536, 12.7665, 10.2427> <-3.4731, 12.7734, 10.2862> <-3.4754, 12.7793, 10.3447> <-3.4983, 12.7838, 10.3868>
		<-3.5099, 12.7997, 10.2186> <-3.5124, 12.8059, 10.2608> <-3.5211, 12.8205, 10.3207> <-3.5369, 12.8234, 10.3603>
		<-3.5526, 12.7941, 10.2071> <-3.5551, 12.8004, 10.2493> <-3.5534, 12.8157, 10.3069> <-3.5692, 12.8186, 10.3465>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5960, 12.7119, 10.2037> <-3.5983, 12.6812, 10.2059> <-3.5721, 12.6450, 10.2174> <-3.5663, 12.6148, 10.2195>
		<-3.5852, 12.7082, 10.1769> <-3.5875, 12.6775, 10.1790> <-3.5600, 12.6399, 10.1845> <-3.5543, 12.6097, 10.1867>
		<-3.5705, 12.7035, 10.1410> <-3.5578, 12.6649, 10.1421> <-3.5504, 12.6334, 10.1448> <-3.5408, 12.6035, 10.1419>
		<-3.5629, 12.6987, 10.1133> <-3.5502, 12.6602, 10.1143> <-3.5387, 12.6291, 10.1117> <-3.5291, 12.5992, 10.1088>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5960, 12.7119, 10.2037> <-3.6110, 12.7170, 10.2411> <-3.6271, 12.7261, 10.2931> <-3.6490, 12.7281, 10.3272>
		<-3.5983, 12.6812, 10.2059> <-3.6133, 12.6864, 10.2432> <-3.6363, 12.6972, 10.2975> <-3.6582, 12.6992, 10.3316>
		<-3.5721, 12.6450, 10.2174> <-3.5892, 12.6522, 10.2640> <-3.6263, 12.6609, 10.3190> <-3.6307, 12.6699, 10.3682>
		<-3.5663, 12.6148, 10.2195> <-3.5834, 12.6220, 10.2662> <-3.6218, 12.6310, 10.3246> <-3.6262, 12.6400, 10.3738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5960, 12.7119, 10.2037> <-3.5852, 12.7082, 10.1769> <-3.5705, 12.7035, 10.1410> <-3.5629, 12.6987, 10.1133>
		<-3.5938, 12.7397, 10.2018> <-3.5831, 12.7360, 10.1750> <-3.5785, 12.7277, 10.1404> <-3.5709, 12.7230, 10.1126>
		<-3.5793, 12.7907, 10.1999> <-3.5862, 12.7831, 10.1764> <-3.5776, 12.7538, 10.1461> <-3.5769, 12.7447, 10.1138>
		<-3.5526, 12.7941, 10.2071> <-3.5595, 12.7866, 10.1837> <-3.5833, 12.7704, 10.1367> <-3.5826, 12.7612, 10.1044>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5960, 12.7119, 10.2037> <-3.5938, 12.7397, 10.2018> <-3.5793, 12.7907, 10.1999> <-3.5526, 12.7941, 10.2071>
		<-3.6110, 12.7170, 10.2411> <-3.6089, 12.7448, 10.2392> <-3.5819, 12.7969, 10.2421> <-3.5551, 12.8004, 10.2493>
		<-3.6271, 12.7261, 10.2931> <-3.6160, 12.7607, 10.2878> <-3.5868, 12.8107, 10.2926> <-3.5534, 12.8157, 10.3069>
		<-3.6490, 12.7281, 10.3272> <-3.6380, 12.7627, 10.3219> <-3.6026, 12.8136, 10.3323> <-3.5692, 12.8186, 10.3465>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5663, 12.6148, 10.2195> <-3.5834, 12.6220, 10.2662> <-3.6218, 12.6310, 10.3246> <-3.6262, 12.6400, 10.3738>
		<-3.5619, 12.5915, 10.2212> <-3.5790, 12.5987, 10.2679> <-3.6183, 12.6076, 10.3290> <-3.6227, 12.6166, 10.3782>
		<-3.5649, 12.5594, 10.2164> <-3.5842, 12.5670, 10.2586> <-3.6055, 12.5757, 10.3183> <-3.6272, 12.5851, 10.3589>
		<-3.5623, 12.5357, 10.2165> <-3.5817, 12.5434, 10.2587> <-3.6022, 12.5519, 10.3178> <-3.6239, 12.5613, 10.3584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5663, 12.6148, 10.2195> <-3.5619, 12.5915, 10.2212> <-3.5649, 12.5594, 10.2164> <-3.5623, 12.5357, 10.2165>
		<-3.5543, 12.6097, 10.1867> <-3.5498, 12.5864, 10.1884> <-3.5480, 12.5527, 10.1797> <-3.5455, 12.5291, 10.1798>
		<-3.5408, 12.6035, 10.1419> <-3.5325, 12.5778, 10.1394> <-3.5254, 12.5460, 10.1369> <-3.5191, 12.5200, 10.1327>
		<-3.5291, 12.5992, 10.1088> <-3.5208, 12.5735, 10.1063> <-3.5096, 12.5397, 10.0997> <-3.5032, 12.5137, 10.0954>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5623, 12.5357, 10.2165> <-3.5817, 12.5434, 10.2587> <-3.6022, 12.5519, 10.3178> <-3.6239, 12.5613, 10.3584>
		<-3.5599, 12.5138, 10.2166> <-3.5793, 12.5214, 10.2588> <-3.5987, 12.5265, 10.3172> <-3.6204, 12.5359, 10.3579>
		<-3.5519, 12.4853, 10.2207> <-3.5693, 12.4902, 10.2653> <-3.5994, 12.5006, 10.3229> <-3.6072, 12.5045, 10.3703>
		<-3.5499, 12.4633, 10.2202> <-3.5673, 12.4683, 10.2648> <-3.5962, 12.4752, 10.3231> <-3.6040, 12.4791, 10.3704>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5623, 12.5357, 10.2165> <-3.5599, 12.5138, 10.2166> <-3.5519, 12.4853, 10.2207> <-3.5499, 12.4633, 10.2202>
		<-3.5455, 12.5291, 10.1798> <-3.5431, 12.5072, 10.1799> <-3.5357, 12.4807, 10.1793> <-3.5337, 12.4587, 10.1788>
		<-3.5191, 12.5200, 10.1327> <-3.5143, 12.5003, 10.1294> <-3.5099, 12.4726, 10.1302> <-3.5086, 12.4529, 10.1250>
		<-3.5032, 12.5137, 10.0954> <-3.4984, 12.4941, 10.0922> <-3.4934, 12.4671, 10.0891> <-3.4920, 12.4473, 10.0839>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5499, 12.4633, 10.2202> <-3.5673, 12.4683, 10.2648> <-3.5962, 12.4752, 10.3231> <-3.6040, 12.4791, 10.3704>
		<-3.5480, 12.4425, 10.2198> <-3.5654, 12.4475, 10.2643> <-3.5930, 12.4508, 10.3232> <-3.6009, 12.4548, 10.3705>
		<-3.5499, 12.4148, 10.2151> <-3.5658, 12.4176, 10.2589> <-3.5852, 12.4210, 10.3205> <-3.6067, 12.4222, 10.3620>
		<-3.5494, 12.3940, 10.2133> <-3.5653, 12.3968, 10.2571> <-3.5815, 12.3969, 10.3179> <-3.6030, 12.3980, 10.3593>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5499, 12.4633, 10.2202> <-3.5480, 12.4425, 10.2198> <-3.5499, 12.4148, 10.2151> <-3.5494, 12.3940, 10.2133>
		<-3.5337, 12.4587, 10.1788> <-3.5318, 12.4379, 10.1783> <-3.5331, 12.4120, 10.1691> <-3.5326, 12.3912, 10.1672>
		<-3.5086, 12.4529, 10.1250> <-3.5071, 12.4320, 10.1195> <-3.5140, 12.4053, 10.1106> <-3.5129, 12.3845, 10.1050>
		<-3.4920, 12.4473, 10.0839> <-3.4906, 12.4265, 10.0784> <-3.4951, 12.4002, 10.0655> <-3.4940, 12.3793, 10.0599>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5494, 12.3940, 10.2133> <-3.5653, 12.3968, 10.2571> <-3.5815, 12.3969, 10.3179> <-3.6030, 12.3980, 10.3593>
		<-3.5487, 12.3637, 10.2106> <-3.5646, 12.3664, 10.2544> <-3.5772, 12.3687, 10.3149> <-3.5987, 12.3698, 10.3563>
		<-3.5501, 12.3229, 10.2076> <-3.5631, 12.3255, 10.2509> <-3.5773, 12.3296, 10.3093> <-3.5815, 12.3345, 10.3541>
		<-3.5458, 12.2928, 10.2049> <-3.5588, 12.2954, 10.2482> <-3.5732, 12.3012, 10.3069> <-3.5774, 12.3062, 10.3517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5494, 12.3940, 10.2133> <-3.5487, 12.3637, 10.2106> <-3.5501, 12.3229, 10.2076> <-3.5458, 12.2928, 10.2049>
		<-3.5326, 12.3912, 10.1672> <-3.5319, 12.3608, 10.1645> <-3.5350, 12.3198, 10.1573> <-3.5306, 12.2898, 10.1546>
		<-3.5129, 12.3845, 10.1050> <-3.5115, 12.3571, 10.0976> <-3.5106, 12.3168, 10.0885> <-3.5048, 12.2891, 10.0891>
		<-3.4940, 12.3793, 10.0599> <-3.4926, 12.3520, 10.0526> <-3.4896, 12.3151, 10.0403> <-3.4838, 12.2874, 10.0408>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5458, 12.2928, 10.2049> <-3.5588, 12.2954, 10.2482> <-3.5732, 12.3012, 10.3069> <-3.5774, 12.3062, 10.3517>
		<-3.5411, 12.2604, 10.2020> <-3.5541, 12.2631, 10.2452> <-3.5699, 12.2776, 10.3049> <-3.5741, 12.2826, 10.3497>
		<-3.5378, 12.2143, 10.1957> <-3.5578, 12.2201, 10.2410> <-3.5661, 12.2380, 10.3007> <-3.5887, 12.2484, 10.3439>
		<-3.5195, 12.1871, 10.1947> <-3.5394, 12.1929, 10.2400> <-3.5560, 12.2163, 10.3016> <-3.5786, 12.2267, 10.3448>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5458, 12.2928, 10.2049> <-3.5411, 12.2604, 10.2020> <-3.5378, 12.2143, 10.1957> <-3.5195, 12.1871, 10.1947>
		<-3.5306, 12.2898, 10.1546> <-3.5259, 12.2574, 10.1517> <-3.5202, 12.2092, 10.1558> <-3.5019, 12.1820, 10.1548>
		<-3.5048, 12.2891, 10.0891> <-3.4985, 12.2587, 10.0897> <-3.4933, 12.2141, 10.1011> <-3.4745, 12.1895, 10.1026>
		<-3.4838, 12.2874, 10.0408> <-3.4775, 12.2570, 10.0414> <-3.4733, 12.2155, 10.0620> <-3.4545, 12.1909, 10.0636>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5195, 12.1871, 10.1947> <-3.5067, 12.1682, 10.1940> <-3.4741, 12.1537, 10.1962> <-3.4515, 12.1532, 10.1996>
		<-3.5019, 12.1820, 10.1548> <-3.4891, 12.1631, 10.1541> <-3.4538, 12.1505, 10.1504> <-3.4312, 12.1500, 10.1538>
		<-3.4745, 12.1895, 10.1026> <-3.4583, 12.1683, 10.1040> <-3.4241, 12.1472, 10.0841> <-3.3996, 12.1458, 10.0946>
		<-3.4545, 12.1909, 10.0636> <-3.4383, 12.1697, 10.0649> <-3.4021, 12.1498, 10.0391> <-3.3776, 12.1484, 10.0496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5195, 12.1871, 10.1947> <-3.5394, 12.1929, 10.2400> <-3.5560, 12.2163, 10.3016> <-3.5786, 12.2267, 10.3448>
		<-3.5067, 12.1682, 10.1940> <-3.5267, 12.1740, 10.2392> <-3.5449, 12.1927, 10.3026> <-3.5676, 12.2031, 10.3458>
		<-3.4741, 12.1537, 10.1962> <-3.4947, 12.1570, 10.2429> <-3.5218, 12.1656, 10.3038> <-3.5393, 12.1706, 10.3516>
		<-3.4515, 12.1532, 10.1996> <-3.4721, 12.1565, 10.2462> <-3.4963, 12.1649, 10.3095> <-3.5138, 12.1699, 10.3573>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4515, 12.1532, 10.1996> <-3.4265, 12.1527, 10.2032> <-3.3847, 12.1610, 10.2121> <-3.3749, 12.1839, 10.2160>
		<-3.4312, 12.1500, 10.1538> <-3.4062, 12.1495, 10.1575> <-3.3741, 12.1566, 10.1815> <-3.3642, 12.1795, 10.1855>
		<-3.3996, 12.1458, 10.0946> <-3.3758, 12.1445, 10.1048> <-3.3523, 12.1599, 10.1361> <-3.3461, 12.1832, 10.1455>
		<-3.3776, 12.1484, 10.0496> <-3.3538, 12.1471, 10.0598> <-3.3405, 12.1609, 10.1057> <-3.3343, 12.1842, 10.1152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4515, 12.1532, 10.1996> <-3.4721, 12.1565, 10.2462> <-3.4963, 12.1649, 10.3095> <-3.5138, 12.1699, 10.3573>
		<-3.4265, 12.1527, 10.2032> <-3.4472, 12.1559, 10.2499> <-3.4658, 12.1640, 10.3164> <-3.4833, 12.1690, 10.3642>
		<-3.3847, 12.1610, 10.2121> <-3.4018, 12.1681, 10.2612> <-3.4163, 12.1815, 10.3287> <-3.4372, 12.1932, 10.3754>
		<-3.3749, 12.1839, 10.2160> <-3.3920, 12.1910, 10.2652> <-3.4052, 12.2106, 10.3322> <-3.4262, 12.2223, 10.3790>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3749, 12.1839, 10.2160> <-3.3614, 12.2153, 10.2214> <-3.3889, 12.2635, 10.2212> <-3.3894, 12.2980, 10.2245>
		<-3.3642, 12.1795, 10.1855> <-3.3508, 12.2109, 10.1909> <-3.3728, 12.2627, 10.1875> <-3.3734, 12.2972, 10.1908>
		<-3.3461, 12.1832, 10.1455> <-3.3375, 12.2151, 10.1585> <-3.3539, 12.2673, 10.1413> <-3.3546, 12.3027, 10.1447>
		<-3.3343, 12.1842, 10.1152> <-3.3257, 12.2162, 10.1281> <-3.3355, 12.2673, 10.1088> <-3.3363, 12.3027, 10.1122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3749, 12.1839, 10.2160> <-3.3920, 12.1910, 10.2652> <-3.4052, 12.2106, 10.3322> <-3.4262, 12.2223, 10.3790>
		<-3.3614, 12.2153, 10.2214> <-3.3785, 12.2224, 10.2706> <-3.3953, 12.2366, 10.3355> <-3.4163, 12.2483, 10.3822>
		<-3.3889, 12.2635, 10.2212> <-3.4103, 12.2646, 10.2663> <-3.4256, 12.2776, 10.3356> <-3.4602, 12.2810, 10.3715>
		<-3.3894, 12.2980, 10.2245> <-3.4109, 12.2990, 10.2696> <-3.4265, 12.3055, 10.3385> <-3.4611, 12.3088, 10.3744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3894, 12.2980, 10.2245> <-3.3899, 12.3294, 10.2275> <-3.3779, 12.3704, 10.2348> <-3.3784, 12.4019, 10.2368>
		<-3.3734, 12.2972, 10.1908> <-3.3739, 12.3286, 10.1938> <-3.3669, 12.3678, 10.2038> <-3.3674, 12.3993, 10.2059>
		<-3.3546, 12.3027, 10.1447> <-3.3552, 12.3295, 10.1473> <-3.3525, 12.3646, 10.1589> <-3.3537, 12.3909, 10.1644>
		<-3.3363, 12.3027, 10.1122> <-3.3369, 12.3295, 10.1148> <-3.3374, 12.3631, 10.1296> <-3.3386, 12.3894, 10.1351>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3894, 12.2980, 10.2245> <-3.4109, 12.2990, 10.2696> <-3.4265, 12.3055, 10.3385> <-3.4611, 12.3088, 10.3744>
		<-3.3899, 12.3294, 10.2275> <-3.4114, 12.3304, 10.2726> <-3.4276, 12.3381, 10.3420> <-3.4622, 12.3415, 10.3779>
		<-3.3779, 12.3704, 10.2348> <-3.3950, 12.3744, 10.2830> <-3.4127, 12.3758, 10.3473> <-3.4314, 12.3790, 10.3950>
		<-3.3784, 12.4019, 10.2368> <-3.3956, 12.4059, 10.2851> <-3.4137, 12.4084, 10.3513> <-3.4324, 12.4116, 10.3990>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3784, 12.4019, 10.2368> <-3.3788, 12.4233, 10.2382> <-3.3903, 12.4507, 10.2354> <-3.3926, 12.4720, 10.2359>
		<-3.3674, 12.3993, 10.2059> <-3.3678, 12.4207, 10.2073> <-3.3767, 12.4476, 10.2077> <-3.3790, 12.4689, 10.2082>
		<-3.3537, 12.3909, 10.1644> <-3.3547, 12.4122, 10.1689> <-3.3572, 12.4419, 10.1698> <-3.3586, 12.4635, 10.1726>
		<-3.3386, 12.3894, 10.1351> <-3.3396, 12.4108, 10.1396> <-3.3421, 12.4396, 10.1428> <-3.3435, 12.4612, 10.1456>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3784, 12.4019, 10.2368> <-3.3956, 12.4059, 10.2851> <-3.4137, 12.4084, 10.3513> <-3.4324, 12.4116, 10.3990>
		<-3.3788, 12.4233, 10.2382> <-3.3960, 12.4273, 10.2865> <-3.4144, 12.4337, 10.3543> <-3.4331, 12.4369, 10.4020>
		<-3.3903, 12.4507, 10.2354> <-3.4136, 12.4560, 10.2829> <-3.4246, 12.4626, 10.3562> <-3.4619, 12.4644, 10.3941>
		<-3.3926, 12.4720, 10.2359> <-3.4159, 12.4774, 10.2834> <-3.4290, 12.4876, 10.3583> <-3.4664, 12.4893, 10.3962>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3926, 12.4720, 10.2359> <-3.3790, 12.4689, 10.2082> <-3.3586, 12.4635, 10.1726> <-3.3435, 12.4612, 10.1456>
		<-3.3955, 12.4995, 10.2365> <-3.3819, 12.4964, 10.2088> <-3.3604, 12.4913, 10.1761> <-3.3453, 12.4889, 10.1491>
		<-3.3925, 12.5367, 10.2395> <-3.3809, 12.5341, 10.2130> <-3.3584, 12.5291, 10.1784> <-3.3449, 12.5263, 10.1529>
		<-3.3957, 12.5641, 10.2405> <-3.3841, 12.5616, 10.2139> <-3.3628, 12.5566, 10.1816> <-3.3492, 12.5538, 10.1561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3926, 12.4720, 10.2359> <-3.4159, 12.4774, 10.2834> <-3.4290, 12.4876, 10.3583> <-3.4664, 12.4893, 10.3962>
		<-3.3955, 12.4995, 10.2365> <-3.4188, 12.5049, 10.2840> <-3.4338, 12.5142, 10.3606> <-3.4711, 12.5159, 10.3985>
		<-3.3925, 12.5367, 10.2395> <-3.4149, 12.5414, 10.2903> <-3.4319, 12.5475, 10.3630> <-3.4563, 12.5516, 10.4129>
		<-3.3957, 12.5641, 10.2405> <-3.4180, 12.5689, 10.2913> <-3.4378, 12.5740, 10.3633> <-3.4622, 12.5781, 10.4133>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3708, 12.6319, 10.1655> <-3.3640, 12.6014, 10.1623> <-3.3531, 12.5778, 10.1589> <-3.3492, 12.5538, 10.1561>
		<-3.3261, 12.6181, 10.0843> <-3.3193, 12.5876, 10.0810> <-3.3116, 12.5693, 10.0810> <-3.3078, 12.5453, 10.0782>
		<-3.2667, 12.6013, 9.9755> <-3.2612, 12.5789, 9.9756> <-3.2550, 12.5583, 9.9725> <-3.2529, 12.5405, 9.9731>
		<-3.2216, 12.5856, 9.8949> <-3.2161, 12.5631, 9.8950> <-3.2143, 12.5443, 9.8949> <-3.2122, 12.5264, 9.8956>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3708, 12.6319, 10.1655> <-3.3261, 12.6181, 10.0843> <-3.2667, 12.6013, 9.9755> <-3.2216, 12.5856, 9.8949>
		<-3.3779, 12.6643, 10.1690> <-3.3332, 12.6505, 10.0878> <-3.2724, 12.6242, 9.9754> <-3.2273, 12.6084, 9.8947>
		<-3.3749, 12.6930, 10.1762> <-3.3319, 12.6716, 10.0924> <-3.2811, 12.6470, 9.9781> <-3.2354, 12.6260, 9.8956>
		<-3.3853, 12.7166, 10.1736> <-3.3423, 12.6951, 10.0898> <-3.2870, 12.6643, 9.9775> <-3.2413, 12.6434, 9.8950>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3853, 12.7166, 10.1736> <-3.3423, 12.6951, 10.0898> <-3.2870, 12.6643, 9.9775> <-3.2413, 12.6434, 9.8950>
		<-3.3958, 12.7402, 10.1709> <-3.3528, 12.7188, 10.0871> <-3.2939, 12.6851, 9.9768> <-3.2482, 12.6641, 9.8943>
		<-3.4337, 12.7584, 10.1599> <-3.3705, 12.7405, 10.0906> <-3.3080, 12.7137, 9.9709> <-3.2571, 12.6919, 9.8931>
		<-3.4368, 12.7817, 10.1489> <-3.3737, 12.7638, 10.0796> <-3.3151, 12.7342, 9.9684> <-3.2642, 12.7124, 9.8906>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4368, 12.7817, 10.1489> <-3.4627, 12.7890, 10.1772> <-3.5262, 12.7913, 10.1938> <-3.5526, 12.7941, 10.2071>
		<-3.4414, 12.8152, 10.1331> <-3.4672, 12.8225, 10.1614> <-3.4825, 12.8045, 10.2081> <-3.5090, 12.8074, 10.2214>
		<-3.3993, 12.8651, 10.1195> <-3.4140, 12.8759, 10.1455> <-3.4471, 12.8781, 10.1756> <-3.4653, 12.8855, 10.2006>
		<-3.4087, 12.8888, 10.0923> <-3.4235, 12.8996, 10.1183> <-3.4464, 12.9157, 10.1506> <-3.4646, 12.9231, 10.1756>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4368, 12.7817, 10.1489> <-3.3737, 12.7638, 10.0796> <-3.3151, 12.7342, 9.9684> <-3.2642, 12.7124, 9.8906>
		<-3.4414, 12.8152, 10.1331> <-3.3782, 12.7973, 10.0638> <-3.3241, 12.7603, 9.9653> <-3.2732, 12.7385, 9.8875>
		<-3.3993, 12.8651, 10.1195> <-3.3631, 12.8385, 10.0556> <-3.3130, 12.8053, 9.9424> <-3.2762, 12.7782, 9.8791>
		<-3.4087, 12.8888, 10.0923> <-3.3725, 12.8622, 10.0284> <-3.3317, 12.8256, 9.9396> <-3.2950, 12.7985, 9.8762>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4087, 12.8888, 10.0923> <-3.4235, 12.8996, 10.1183> <-3.4464, 12.9157, 10.1506> <-3.4646, 12.9231, 10.1756>
		<-3.4196, 12.9160, 10.0610> <-3.4344, 12.9269, 10.0870> <-3.4458, 12.9463, 10.1301> <-3.4640, 12.9537, 10.1551>
		<-3.4424, 12.9325, 10.0011> <-3.4615, 12.9464, 10.0311> <-3.4973, 12.9739, 10.0674> <-3.5155, 12.9810, 10.1002>
		<-3.4943, 12.9254, 9.9838> <-3.5134, 12.9393, 10.0138> <-3.5309, 12.9637, 10.0564> <-3.5491, 12.9708, 10.0892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4087, 12.8888, 10.0923> <-3.3725, 12.8622, 10.0284> <-3.3317, 12.8256, 9.9396> <-3.2950, 12.7985, 9.8762>
		<-3.4196, 12.9160, 10.0610> <-3.3834, 12.8894, 9.9971> <-3.3589, 12.8550, 9.9354> <-3.3221, 12.8278, 9.8720>
		<-3.4424, 12.9325, 10.0011> <-3.4192, 12.9157, 9.9647> <-3.3819, 12.8824, 9.9010> <-3.3572, 12.8644, 9.8662>
		<-3.4943, 12.9254, 9.9838> <-3.4711, 12.9086, 9.9473> <-3.4333, 12.8869, 9.9032> <-3.4086, 12.8688, 9.8684>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4943, 12.9254, 9.9838> <-3.4711, 12.9086, 9.9473> <-3.4333, 12.8869, 9.9032> <-3.4086, 12.8688, 9.8684>
		<-3.5472, 12.9182, 9.9661> <-3.5240, 12.9014, 9.9297> <-3.4914, 12.8919, 9.9057> <-3.4667, 12.8738, 9.8710>
		<-3.5963, 12.9016, 9.9916> <-3.5777, 12.8931, 9.9495> <-3.5400, 12.8758, 9.9092> <-3.5131, 12.8628, 9.8731>
		<-3.6186, 12.8601, 10.0222> <-3.6000, 12.8515, 9.9800> <-3.5774, 12.8334, 9.9234> <-3.5505, 12.8205, 9.8873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4943, 12.9254, 9.9838> <-3.5134, 12.9393, 10.0138> <-3.5309, 12.9637, 10.0564> <-3.5491, 12.9708, 10.0892>
		<-3.5472, 12.9182, 9.9661> <-3.5662, 12.9321, 9.9961> <-3.5692, 12.9521, 10.0439> <-3.5874, 12.9592, 10.0767>
		<-3.5963, 12.9016, 9.9916> <-3.6080, 12.9070, 10.0181> <-3.6414, 12.9004, 10.0633> <-3.6502, 12.9014, 10.0913>
		<-3.6186, 12.8601, 10.0222> <-3.6303, 12.8654, 10.0487> <-3.6421, 12.8655, 10.0866> <-3.6509, 12.8666, 10.1146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6186, 12.8601, 10.0222> <-3.6000, 12.8515, 9.9800> <-3.5774, 12.8334, 9.9234> <-3.5505, 12.8205, 9.8873>
		<-3.6391, 12.8220, 10.0502> <-3.6205, 12.8134, 10.0080> <-3.6053, 12.8019, 9.9340> <-3.5784, 12.7890, 9.8979>
		<-3.5942, 12.7946, 10.0856> <-3.5929, 12.7789, 10.0298> <-3.5765, 12.7551, 9.9647> <-3.5526, 12.7454, 9.9128>
		<-3.5826, 12.7612, 10.1044> <-3.5814, 12.7455, 10.0486> <-3.5702, 12.7229, 9.9727> <-3.5463, 12.7132, 9.9207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6186, 12.8601, 10.0222> <-3.6303, 12.8654, 10.0487> <-3.6421, 12.8655, 10.0866> <-3.6509, 12.8666, 10.1146>
		<-3.6391, 12.8220, 10.0502> <-3.6508, 12.8273, 10.0767> <-3.6428, 12.8294, 10.1107> <-3.6516, 12.8305, 10.1387>
		<-3.5942, 12.7946, 10.0856> <-3.5949, 12.8038, 10.1179> <-3.6014, 12.7739, 10.1699> <-3.5946, 12.7814, 10.1934>
		<-3.5826, 12.7612, 10.1044> <-3.5833, 12.7704, 10.1367> <-3.5595, 12.7866, 10.1837> <-3.5526, 12.7941, 10.2071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5826, 12.7612, 10.1044> <-3.5814, 12.7455, 10.0486> <-3.5702, 12.7229, 9.9727> <-3.5463, 12.7132, 9.9207>
		<-3.5769, 12.7447, 10.1138> <-3.5757, 12.7289, 10.0580> <-3.5671, 12.7069, 9.9766> <-3.5432, 12.6973, 9.9247>
		<-3.5709, 12.7230, 10.1126> <-3.5557, 12.7134, 10.0569> <-3.5521, 12.6929, 9.9816> <-3.5318, 12.6822, 9.9277>
		<-3.5629, 12.6987, 10.1133> <-3.5477, 12.6892, 10.0575> <-3.5405, 12.6749, 9.9798> <-3.5201, 12.6642, 9.9259>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5629, 12.6987, 10.1133> <-3.5477, 12.6892, 10.0575> <-3.5405, 12.6749, 9.9798> <-3.5201, 12.6642, 9.9259>
		<-3.5502, 12.6602, 10.1143> <-3.5350, 12.6506, 10.0586> <-3.5170, 12.6386, 9.9761> <-3.4966, 12.6278, 9.9222>
		<-3.5387, 12.6291, 10.1117> <-3.5173, 12.6211, 10.0509> <-3.4910, 12.6116, 9.9752> <-3.4718, 12.6026, 9.9138>
		<-3.5291, 12.5992, 10.1088> <-3.5077, 12.5912, 10.0480> <-3.4752, 12.5826, 9.9680> <-3.4560, 12.5736, 9.9066>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5291, 12.5992, 10.1088> <-3.5077, 12.5912, 10.0480> <-3.4752, 12.5826, 9.9680> <-3.4560, 12.5736, 9.9066>
		<-3.5208, 12.5735, 10.1063> <-3.4994, 12.5655, 10.0455> <-3.4605, 12.5556, 9.9612> <-3.4412, 12.5466, 9.8998>
		<-3.5096, 12.5397, 10.0997> <-3.4824, 12.5290, 10.0358> <-3.4467, 12.5136, 9.9544> <-3.4279, 12.5085, 9.8868>
		<-3.5032, 12.5137, 10.0954> <-3.4761, 12.5030, 10.0315> <-3.4378, 12.4843, 9.9471> <-3.4191, 12.4791, 9.8796>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5032, 12.5137, 10.0954> <-3.4761, 12.5030, 10.0315> <-3.4378, 12.4843, 9.9471> <-3.4191, 12.4791, 9.8796>
		<-3.4984, 12.4941, 10.0922> <-3.4713, 12.4833, 10.0283> <-3.4323, 12.4661, 9.9426> <-3.4135, 12.4609, 9.8751>
		<-3.4934, 12.4671, 10.0891> <-3.4674, 12.4584, 10.0245> <-3.4303, 12.4431, 9.9376> <-3.4109, 12.4351, 9.8706>
		<-3.4920, 12.4473, 10.0839> <-3.4661, 12.4386, 10.0193> <-3.4276, 12.4239, 9.9348> <-3.4082, 12.4159, 9.8678>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4920, 12.4473, 10.0839> <-3.4661, 12.4386, 10.0193> <-3.4276, 12.4239, 9.9348> <-3.4082, 12.4159, 9.8678>
		<-3.4906, 12.4265, 10.0784> <-3.4646, 12.4178, 10.0138> <-3.4250, 12.4055, 9.9320> <-3.4056, 12.3975, 9.8651>
		<-3.4951, 12.4002, 10.0655> <-3.4696, 12.3933, 10.0048> <-3.4245, 12.3788, 9.9234> <-3.4028, 12.3728, 9.8611>
		<-3.4940, 12.3793, 10.0599> <-3.4685, 12.3724, 9.9992> <-3.4232, 12.3600, 9.9234> <-3.4015, 12.3540, 9.8611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4940, 12.3793, 10.0599> <-3.4685, 12.3724, 9.9992> <-3.4232, 12.3600, 9.9234> <-3.4015, 12.3540, 9.8611>
		<-3.4926, 12.3520, 10.0526> <-3.4671, 12.3451, 9.9918> <-3.4217, 12.3382, 9.9234> <-3.4000, 12.3321, 9.8611>
		<-3.4896, 12.3151, 10.0403> <-3.4666, 12.3133, 9.9873> <-3.4235, 12.3052, 9.9139> <-3.4021, 12.3017, 9.8603>
		<-3.4838, 12.2874, 10.0408> <-3.4608, 12.2856, 9.9878> <-3.4204, 12.2848, 9.9214> <-3.3991, 12.2813, 9.8677>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4838, 12.2874, 10.0408> <-3.4608, 12.2856, 9.9878> <-3.4204, 12.2848, 9.9214> <-3.3991, 12.2813, 9.8677>
		<-3.4775, 12.2570, 10.0414> <-3.4544, 12.2552, 9.9884> <-3.4162, 12.2567, 9.9317> <-3.3949, 12.2532, 9.8781>
		<-3.4733, 12.2155, 10.0620> <-3.4509, 12.2170, 10.0183> <-3.4131, 12.2172, 9.9542> <-3.3952, 12.2195, 9.9085>
		<-3.4545, 12.1909, 10.0636> <-3.4321, 12.1924, 10.0199> <-3.3959, 12.1945, 9.9646> <-3.3780, 12.1968, 9.9189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4545, 12.1909, 10.0636> <-3.4321, 12.1924, 10.0199> <-3.3959, 12.1945, 9.9646> <-3.3780, 12.1968, 9.9189>
		<-3.4383, 12.1697, 10.0649> <-3.4159, 12.1713, 10.0212> <-3.3841, 12.1789, 9.9717> <-3.3662, 12.1812, 9.9260>
		<-3.4021, 12.1498, 10.0391> <-3.3828, 12.1520, 9.9996> <-3.3498, 12.1648, 9.9574> <-3.3350, 12.1699, 9.9162>
		<-3.3776, 12.1484, 10.0496> <-3.3583, 12.1507, 10.0101> <-3.3291, 12.1643, 9.9599> <-3.3143, 12.1693, 9.9187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3776, 12.1484, 10.0496> <-3.3583, 12.1507, 10.0101> <-3.3291, 12.1643, 9.9599> <-3.3143, 12.1693, 9.9187>
		<-3.3538, 12.1471, 10.0598> <-3.3345, 12.1494, 10.0203> <-3.3121, 12.1638, 9.9620> <-3.2973, 12.1689, 9.9208>
		<-3.3405, 12.1609, 10.1057> <-3.3193, 12.1629, 10.0511> <-3.2920, 12.1778, 9.9903> <-3.2754, 12.1808, 9.9341>
		<-3.3343, 12.1842, 10.1152> <-3.3130, 12.1862, 10.0605> <-3.2812, 12.1910, 9.9889> <-3.2646, 12.1940, 9.9327>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3343, 12.1842, 10.1152> <-3.3130, 12.1862, 10.0605> <-3.2812, 12.1910, 9.9889> <-3.2646, 12.1940, 9.9327>
		<-3.3257, 12.2162, 10.1281> <-3.3044, 12.2182, 10.0735> <-3.2583, 12.2192, 9.9860> <-3.2417, 12.2221, 9.9298>
		<-3.3355, 12.2673, 10.1088> <-3.2997, 12.2674, 10.0454> <-3.2509, 12.2677, 9.9772> <-3.2199, 12.2641, 9.9114>
		<-3.3363, 12.3027, 10.1122> <-3.3005, 12.3028, 10.0488> <-3.2402, 12.3019, 9.9712> <-3.2092, 12.2984, 9.9054>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3363, 12.3027, 10.1122> <-3.3005, 12.3028, 10.0488> <-3.2402, 12.3019, 9.9712> <-3.2092, 12.2984, 9.9054>
		<-3.3369, 12.3295, 10.1148> <-3.3010, 12.3296, 10.0514> <-3.2325, 12.3265, 9.9669> <-3.2015, 12.3229, 9.9011>
		<-3.3374, 12.3631, 10.1296> <-3.3003, 12.3595, 10.0573> <-3.2421, 12.3663, 9.9725> <-3.2056, 12.3589, 9.9002>
		<-3.3386, 12.3894, 10.1351> <-3.3015, 12.3858, 10.0628> <-3.2413, 12.3923, 9.9716> <-3.2049, 12.3850, 9.8992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3386, 12.3894, 10.1351> <-3.3015, 12.3858, 10.0628> <-3.2413, 12.3923, 9.9716> <-3.2049, 12.3850, 9.8992>
		<-3.3396, 12.4108, 10.1396> <-3.3024, 12.4071, 10.0673> <-3.2409, 12.4098, 9.9709> <-3.2044, 12.4024, 9.8986>
		<-3.3421, 12.4396, 10.1428> <-3.3009, 12.4333, 10.0690> <-3.2433, 12.4363, 9.9749> <-3.2042, 12.4257, 9.9005>
		<-3.3435, 12.4612, 10.1456> <-3.3023, 12.4549, 10.0718> <-3.2442, 12.4537, 9.9745> <-3.2051, 12.4432, 9.9000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3435, 12.4612, 10.1456> <-3.3023, 12.4549, 10.0718> <-3.2442, 12.4537, 9.9745> <-3.2051, 12.4432, 9.9000>
		<-3.3453, 12.4889, 10.1491> <-3.3041, 12.4826, 10.0753> <-3.2455, 12.4788, 9.9738> <-3.2064, 12.4682, 9.8994>
		<-3.3449, 12.5263, 10.1529> <-3.3034, 12.5178, 10.0749> <-3.2500, 12.5156, 9.9740> <-3.2094, 12.5015, 9.8965>
		<-3.3492, 12.5538, 10.1561> <-3.3078, 12.5453, 10.0782> <-3.2529, 12.5405, 9.9731> <-3.2122, 12.5264, 9.8956>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2216, 12.5856, 9.8949> <-3.2161, 12.5631, 9.8950> <-3.2143, 12.5443, 9.8949> <-3.2122, 12.5264, 9.8956>
		<-3.1933, 12.5757, 9.8442> <-3.1877, 12.5533, 9.8443> <-3.1883, 12.5352, 9.8453> <-3.1862, 12.5174, 9.8459>
		<-3.1491, 12.5503, 9.7820> <-3.1478, 12.5235, 9.7850> <-3.1484, 12.5024, 9.7842> <-3.1491, 12.4815, 9.7859>
		<-3.1261, 12.5466, 9.7279> <-3.1248, 12.5198, 9.7309> <-3.1269, 12.4979, 9.7318> <-3.1276, 12.4770, 9.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2216, 12.5856, 9.8949> <-3.1933, 12.5757, 9.8442> <-3.1491, 12.5503, 9.7820> <-3.1261, 12.5466, 9.7279>
		<-3.2273, 12.6084, 9.8947> <-3.1990, 12.5986, 9.8441> <-3.1502, 12.5716, 9.7796> <-3.1272, 12.5680, 9.7256>
		<-3.2354, 12.6260, 9.8956> <-3.2057, 12.6124, 9.8419> <-3.1559, 12.5892, 9.7801> <-3.1306, 12.5851, 9.7226>
		<-3.2413, 12.6434, 9.8950> <-3.2115, 12.6297, 9.8413> <-3.1592, 12.6054, 9.7773> <-3.1339, 12.6013, 9.7198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2413, 12.6434, 9.8950> <-3.2115, 12.6297, 9.8413> <-3.1592, 12.6054, 9.7773> <-3.1339, 12.6013, 9.7198>
		<-3.2482, 12.6641, 9.8943> <-3.2184, 12.6505, 9.8406> <-3.1627, 12.6228, 9.7743> <-3.1374, 12.6187, 9.7168>
		<-3.2571, 12.6919, 9.8931> <-3.2216, 12.6767, 9.8388> <-3.1699, 12.6475, 9.7732> <-3.1427, 12.6419, 9.7125>
		<-3.2642, 12.7124, 9.8906> <-3.2287, 12.6972, 9.8363> <-3.1759, 12.6640, 9.7692> <-3.1488, 12.6585, 9.7085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2642, 12.7124, 9.8906> <-3.2287, 12.6972, 9.8363> <-3.1759, 12.6640, 9.7692> <-3.1488, 12.6585, 9.7085>
		<-3.2732, 12.7385, 9.8875> <-3.2377, 12.7233, 9.8332> <-3.1827, 12.6824, 9.7647> <-3.1555, 12.6769, 9.7041>
		<-3.2762, 12.7782, 9.8791> <-3.2432, 12.7538, 9.8222> <-3.1907, 12.7136, 9.7623> <-3.1620, 12.7050, 9.6989>
		<-3.2950, 12.7985, 9.8762> <-3.2619, 12.7741, 9.8193> <-3.2049, 12.7259, 9.7553> <-3.1763, 12.7173, 9.6919>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2950, 12.7985, 9.8762> <-3.2619, 12.7741, 9.8193> <-3.2049, 12.7259, 9.7553> <-3.1763, 12.7173, 9.6919>
		<-3.3221, 12.8278, 9.8720> <-3.2891, 12.8035, 9.8152> <-3.2260, 12.7441, 9.7449> <-3.1974, 12.7355, 9.6815>
		<-3.3572, 12.8644, 9.8662> <-3.3116, 12.8311, 9.8020> <-3.2610, 12.7678, 9.7447> <-3.2247, 12.7539, 9.6685>
		<-3.4086, 12.8688, 9.8684> <-3.3630, 12.8355, 9.8042> <-3.2964, 12.7682, 9.7300> <-3.2600, 12.7543, 9.6538>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4086, 12.8688, 9.8684> <-3.3630, 12.8355, 9.8042> <-3.2964, 12.7682, 9.7300> <-3.2600, 12.7543, 9.6538>
		<-3.4667, 12.8738, 9.8710> <-3.4211, 12.8405, 9.8067> <-3.3244, 12.7685, 9.7183> <-3.2880, 12.7546, 9.6422>
		<-3.5131, 12.8628, 9.8731> <-3.4516, 12.8332, 9.7907> <-3.3553, 12.7519, 9.7298> <-3.3034, 12.7379, 9.6372>
		<-3.5505, 12.8205, 9.8873> <-3.4891, 12.7909, 9.8049> <-3.3778, 12.7331, 9.7221> <-3.3259, 12.7190, 9.6296>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5505, 12.8205, 9.8873> <-3.4891, 12.7909, 9.8049> <-3.3778, 12.7331, 9.7221> <-3.3259, 12.7190, 9.6296>
		<-3.5784, 12.7890, 9.8979> <-3.5170, 12.7594, 9.8155> <-3.3947, 12.7189, 9.7164> <-3.3428, 12.7049, 9.6238>
		<-3.5526, 12.7454, 9.9128> <-3.5084, 12.7276, 9.8170> <-3.3980, 12.6931, 9.7180> <-3.3522, 12.6874, 9.6215>
		<-3.5463, 12.7132, 9.9207> <-3.5021, 12.6954, 9.8250> <-3.4049, 12.6768, 9.7166> <-3.3591, 12.6711, 9.6201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5463, 12.7132, 9.9207> <-3.5021, 12.6954, 9.8250> <-3.4049, 12.6768, 9.7166> <-3.3591, 12.6711, 9.6201>
		<-3.5432, 12.6973, 9.9247> <-3.4990, 12.6794, 9.8289> <-3.4134, 12.6568, 9.7149> <-3.3676, 12.6511, 9.6184>
		<-3.5318, 12.6822, 9.9277> <-3.4958, 12.6633, 9.8326> <-3.4116, 12.6367, 9.7135> <-3.3725, 12.6282, 9.6181>
		<-3.5201, 12.6642, 9.9259> <-3.4842, 12.6453, 9.8308> <-3.4152, 12.6089, 9.7147> <-3.3761, 12.6005, 9.6193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5201, 12.6642, 9.9259> <-3.4842, 12.6453, 9.8308> <-3.4152, 12.6089, 9.7147> <-3.3761, 12.6005, 9.6193>
		<-3.4966, 12.6278, 9.9222> <-3.4606, 12.6089, 9.8271> <-3.4189, 12.5813, 9.7159> <-3.3798, 12.5729, 9.6206>
		<-3.4718, 12.6026, 9.9138> <-3.4456, 12.5904, 9.8304> <-3.4059, 12.5556, 9.7080> <-3.3783, 12.5502, 9.6243>
		<-3.4560, 12.5736, 9.9066> <-3.4298, 12.5614, 9.8231> <-3.4056, 12.5341, 9.7100> <-3.3779, 12.5286, 9.6263>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4560, 12.5736, 9.9066> <-3.4298, 12.5614, 9.8231> <-3.4056, 12.5341, 9.7100> <-3.3779, 12.5286, 9.6263>
		<-3.4412, 12.5466, 9.8998> <-3.4151, 12.5344, 9.8164> <-3.4053, 12.5189, 9.7115> <-3.3777, 12.5134, 9.6278>
		<-3.4279, 12.5085, 9.8868> <-3.4077, 12.5029, 9.8140> <-3.3972, 12.4933, 9.7018> <-3.3757, 12.4932, 9.6291>
		<-3.4191, 12.4791, 9.8796> <-3.3988, 12.4736, 9.8068> <-3.3957, 12.4783, 9.7037> <-3.3742, 12.4781, 9.6311>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4191, 12.4791, 9.8796> <-3.3988, 12.4736, 9.8068> <-3.3957, 12.4783, 9.7037> <-3.3742, 12.4781, 9.6311>
		<-3.4135, 12.4609, 9.8751> <-3.3933, 12.4553, 9.8023> <-3.3933, 12.4532, 9.7070> <-3.3717, 12.4531, 9.6344>
		<-3.4109, 12.4351, 9.8706> <-3.3920, 12.4273, 9.8050> <-3.3889, 12.4220, 9.7054> <-3.3688, 12.4198, 9.6397>
		<-3.4082, 12.4159, 9.8678> <-3.3893, 12.4082, 9.8022> <-3.3850, 12.3973, 9.7095> <-3.3649, 12.3951, 9.6439>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4082, 12.4159, 9.8678> <-3.3893, 12.4082, 9.8022> <-3.3850, 12.3973, 9.7095> <-3.3649, 12.3951, 9.6439>
		<-3.4056, 12.3975, 9.8651> <-3.3867, 12.3897, 9.7995> <-3.3823, 12.3805, 9.7123> <-3.3623, 12.3784, 9.6466>
		<-3.4028, 12.3728, 9.8611> <-3.3818, 12.3670, 9.8010> <-3.3757, 12.3580, 9.7119> <-3.3560, 12.3567, 9.6511>
		<-3.4015, 12.3540, 9.8611> <-3.3805, 12.3482, 9.8010> <-3.3720, 12.3415, 9.7150> <-3.3523, 12.3402, 9.6541>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4015, 12.3540, 9.8611> <-3.3805, 12.3482, 9.8010> <-3.3720, 12.3415, 9.7150> <-3.3523, 12.3402, 9.6541>
		<-3.4000, 12.3321, 9.8611> <-3.3790, 12.3263, 9.8010> <-3.3669, 12.3185, 9.7192> <-3.3472, 12.3171, 9.6584>
		<-3.4021, 12.3017, 9.8603> <-3.3789, 12.2979, 9.8018> <-3.3643, 12.2870, 9.7225> <-3.3434, 12.2852, 9.6630>
		<-3.3991, 12.2813, 9.8677> <-3.3758, 12.2775, 9.8093> <-3.3564, 12.2649, 9.7277> <-3.3355, 12.2632, 9.6683>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3991, 12.2813, 9.8677> <-3.3758, 12.2775, 9.8093> <-3.3564, 12.2649, 9.7277> <-3.3355, 12.2632, 9.6683>
		<-3.3949, 12.2532, 9.8781> <-3.3716, 12.2494, 9.8196> <-3.3502, 12.2476, 9.7319> <-3.3294, 12.2459, 9.6724>
		<-3.3952, 12.2195, 9.9085> <-3.3684, 12.2231, 9.8402> <-3.3431, 12.2208, 9.7481> <-3.3191, 12.2223, 9.6787>
		<-3.3780, 12.1968, 9.9189> <-3.3512, 12.2004, 9.8505> <-3.3300, 12.2090, 9.7546> <-3.3060, 12.2105, 9.6852>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3780, 12.1968, 9.9189> <-3.3512, 12.2004, 9.8505> <-3.3300, 12.2090, 9.7546> <-3.3060, 12.2105, 9.6852>
		<-3.3662, 12.1812, 9.9260> <-3.3394, 12.1848, 9.8576> <-3.3176, 12.1978, 9.7608> <-3.2936, 12.1993, 9.6913>
		<-3.3350, 12.1699, 9.9162> <-3.3129, 12.1775, 9.8545> <-3.2925, 12.1895, 9.7637> <-3.2714, 12.1916, 9.7013>
		<-3.3143, 12.1693, 9.9187> <-3.2922, 12.1770, 9.8571> <-3.2761, 12.1885, 9.7706> <-3.2551, 12.1907, 9.7082>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3143, 12.1693, 9.9187> <-3.2922, 12.1770, 9.8571> <-3.2761, 12.1885, 9.7706> <-3.2551, 12.1907, 9.7082>
		<-3.2973, 12.1689, 9.9208> <-3.2752, 12.1766, 9.8592> <-3.2645, 12.1878, 9.7755> <-3.2434, 12.1899, 9.7131>
		<-3.2754, 12.1808, 9.9341> <-3.2571, 12.1841, 9.8721> <-3.2465, 12.1955, 9.7810> <-3.2269, 12.1966, 9.7193>
		<-3.2646, 12.1940, 9.9327> <-3.2463, 12.1973, 9.8707> <-3.2377, 12.2041, 9.7839> <-3.2181, 12.2052, 9.7222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2646, 12.1940, 9.9327> <-3.2463, 12.1973, 9.8707> <-3.2377, 12.2041, 9.7839> <-3.2181, 12.2052, 9.7222>
		<-3.2417, 12.2221, 9.9298> <-3.2234, 12.2255, 9.8678> <-3.2172, 12.2240, 9.7907> <-3.1976, 12.2251, 9.7289>
		<-3.2199, 12.2641, 9.9114> <-3.1977, 12.2616, 9.8642> <-3.1915, 12.2582, 9.7851> <-3.1745, 12.2569, 9.7358>
		<-3.2092, 12.2984, 9.9054> <-3.1870, 12.2958, 9.8582> <-3.1777, 12.2839, 9.7884> <-3.1607, 12.2825, 9.7391>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2092, 12.2984, 9.9054> <-3.1870, 12.2958, 9.8582> <-3.1777, 12.2839, 9.7884> <-3.1607, 12.2825, 9.7391>
		<-3.2015, 12.3229, 9.9011> <-3.1794, 12.3204, 9.8539> <-3.1678, 12.3022, 9.7909> <-3.1508, 12.3008, 9.7416>
		<-3.2056, 12.3589, 9.9002> <-3.1822, 12.3542, 9.8536> <-3.1637, 12.3320, 9.7899> <-3.1452, 12.3289, 9.7411>
		<-3.2049, 12.3850, 9.8992> <-3.1814, 12.3802, 9.8527> <-3.1587, 12.3523, 9.7901> <-3.1402, 12.3493, 9.7412>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2049, 12.3850, 9.8992> <-3.1814, 12.3802, 9.8527> <-3.1587, 12.3523, 9.7901> <-3.1402, 12.3493, 9.7412>
		<-3.2044, 12.4024, 9.8986> <-3.1810, 12.3977, 9.8520> <-3.1547, 12.3685, 9.7902> <-3.1362, 12.3654, 9.7413>
		<-3.2042, 12.4257, 9.9005> <-3.1792, 12.4190, 9.8528> <-3.1522, 12.3908, 9.7914> <-3.1324, 12.3873, 9.7410>
		<-3.2051, 12.4432, 9.9000> <-3.1801, 12.4364, 9.8524> <-3.1506, 12.4073, 9.7904> <-3.1308, 12.4038, 9.7400>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2051, 12.4432, 9.9000> <-3.1801, 12.4364, 9.8524> <-3.1506, 12.4073, 9.7904> <-3.1308, 12.4038, 9.7400>
		<-3.2064, 12.4682, 9.8994> <-3.1814, 12.4615, 9.8517> <-3.1484, 12.4292, 9.7891> <-3.1286, 12.4257, 9.7387>
		<-3.2094, 12.5015, 9.8965> <-3.1833, 12.4925, 9.8468> <-3.1498, 12.4595, 9.7878> <-3.1283, 12.4550, 9.7354>
		<-3.2122, 12.5264, 9.8956> <-3.1862, 12.5174, 9.8459> <-3.1491, 12.4815, 9.7859> <-3.1276, 12.4770, 9.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6694, 12.8662, 10.1828> <-3.6506, 12.8090, 10.1883> <-3.5941, 12.7862, 10.2119> <-3.5619, 12.8007, 10.2250>
		<-3.6626, 12.8703, 10.1632> <-3.6438, 12.8131, 10.1687> <-3.5913, 12.7851, 10.2063> <-3.5591, 12.7995, 10.2194>
		<-3.6573, 12.8673, 10.1348> <-3.6580, 12.8312, 10.1589> <-3.5942, 12.7805, 10.1871> <-3.5522, 12.7932, 10.2008>
		<-3.6509, 12.8666, 10.1146> <-3.6516, 12.8305, 10.1387> <-3.5946, 12.7814, 10.1934> <-3.5526, 12.7941, 10.2071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9755, 12.5466, 9.3161> <-3.0207, 12.5466, 9.4397> <-3.0747, 12.5385, 9.6071> <-3.1261, 12.5466, 9.7279>
		<-2.9741, 12.5198, 9.3191> <-3.0193, 12.5198, 9.4426> <-3.0734, 12.5117, 9.6101> <-3.1248, 12.5198, 9.7309>
		<-2.9763, 12.4979, 9.3200> <-3.0215, 12.4979, 9.4435> <-3.0772, 12.4874, 9.6104> <-3.1269, 12.4979, 9.7318>
		<-2.9769, 12.4770, 9.3217> <-3.0221, 12.4770, 9.4453> <-3.0779, 12.4665, 9.6122> <-3.1276, 12.4770, 9.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9755, 12.5466, 9.3161> <-2.9765, 12.5680, 9.3138> <-2.9800, 12.5851, 9.3108> <-2.9832, 12.6013, 9.3080>
		<-3.0207, 12.5466, 9.4397> <-3.0217, 12.5680, 9.4373> <-3.0252, 12.5851, 9.4343> <-3.0284, 12.6013, 9.4315>
		<-3.0747, 12.5385, 9.6071> <-3.0758, 12.5599, 9.6047> <-3.0778, 12.5765, 9.6025> <-3.0811, 12.5927, 9.5996>
		<-3.1261, 12.5466, 9.7279> <-3.1272, 12.5680, 9.7256> <-3.1306, 12.5851, 9.7226> <-3.1339, 12.6013, 9.7198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9832, 12.6013, 9.3080> <-2.9868, 12.6187, 9.3050> <-2.9921, 12.6419, 9.3007> <-2.9981, 12.6585, 9.2967>
		<-3.0284, 12.6013, 9.4315> <-3.0320, 12.6187, 9.4285> <-3.0373, 12.6419, 9.4243> <-3.0433, 12.6585, 9.4203>
		<-3.0811, 12.5927, 9.5996> <-3.0846, 12.6101, 9.5966> <-3.0891, 12.6311, 9.5929> <-3.0952, 12.6476, 9.5889>
		<-3.1339, 12.6013, 9.7198> <-3.1374, 12.6187, 9.7168> <-3.1427, 12.6419, 9.7125> <-3.1488, 12.6585, 9.7085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9981, 12.6585, 9.2967> <-3.0048, 12.6769, 9.2923> <-3.0113, 12.7050, 9.2871> <-3.0256, 12.7173, 9.2800>
		<-3.0433, 12.6585, 9.4203> <-3.0500, 12.6769, 9.4158> <-3.0565, 12.7050, 9.4106> <-3.0708, 12.7173, 9.4036>
		<-3.0952, 12.6476, 9.5889> <-3.1019, 12.6660, 9.5845> <-3.1082, 12.6888, 9.5799> <-3.1225, 12.7011, 9.5729>
		<-3.1488, 12.6585, 9.7085> <-3.1555, 12.6769, 9.7041> <-3.1620, 12.7050, 9.6989> <-3.1763, 12.7173, 9.6919>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0256, 12.7173, 9.2800> <-3.0467, 12.7355, 9.2697> <-3.0740, 12.7539, 9.2567> <-3.1093, 12.7543, 9.2420>
		<-3.0708, 12.7173, 9.4036> <-3.0919, 12.7355, 9.3932> <-3.1192, 12.7539, 9.3802> <-3.1545, 12.7543, 9.3655>
		<-3.1225, 12.7011, 9.5729> <-3.1436, 12.7193, 9.5625> <-3.1687, 12.7325, 9.5514> <-3.2040, 12.7329, 9.5367>
		<-3.1763, 12.7173, 9.6919> <-3.1974, 12.7355, 9.6815> <-3.2247, 12.7539, 9.6685> <-3.2600, 12.7543, 9.6538>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1093, 12.7543, 9.2420> <-3.1373, 12.7546, 9.2303> <-3.1527, 12.7379, 9.2254> <-3.1752, 12.7190, 9.2178>
		<-3.1545, 12.7543, 9.3655> <-3.1825, 12.7546, 9.3539> <-3.1979, 12.7379, 9.3490> <-3.2204, 12.7190, 9.3413>
		<-3.2040, 12.7329, 9.5367> <-3.2320, 12.7332, 9.5251> <-3.2396, 12.7207, 9.5235> <-3.2621, 12.7018, 9.5158>
		<-3.2600, 12.7543, 9.6538> <-3.2880, 12.7546, 9.6422> <-3.3034, 12.7379, 9.6372> <-3.3259, 12.7190, 9.6296>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1752, 12.7190, 9.2178> <-3.1921, 12.7049, 9.2120> <-3.2016, 12.6874, 9.2097> <-3.2085, 12.6711, 9.2083>
		<-3.2204, 12.7190, 9.3413> <-3.2373, 12.7049, 9.3356> <-3.2468, 12.6874, 9.3332> <-3.2537, 12.6711, 9.3318>
		<-3.2621, 12.7018, 9.5158> <-3.2790, 12.6876, 9.5101> <-3.2960, 12.6804, 9.5028> <-3.3029, 12.6641, 9.5014>
		<-3.3259, 12.7190, 9.6296> <-3.3428, 12.7049, 9.6238> <-3.3522, 12.6874, 9.6215> <-3.3591, 12.6711, 9.6201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2085, 12.6711, 9.2083> <-3.2169, 12.6511, 9.2065> <-3.2218, 12.6282, 9.2063> <-3.2255, 12.6005, 9.2075>
		<-3.2537, 12.6711, 9.3318> <-3.2621, 12.6511, 9.3301> <-3.2670, 12.6282, 9.3298> <-3.2707, 12.6005, 9.3311>
		<-3.3029, 12.6641, 9.5014> <-3.3113, 12.6441, 9.4997> <-3.3227, 12.6175, 9.4968> <-3.3264, 12.5897, 9.4980>
		<-3.3591, 12.6711, 9.6201> <-3.3676, 12.6511, 9.6184> <-3.3725, 12.6282, 9.6181> <-3.3761, 12.6005, 9.6193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2255, 12.6005, 9.2075> <-3.2291, 12.5729, 9.2087> <-3.2276, 12.5502, 9.2124> <-3.2273, 12.5286, 9.2145>
		<-3.2707, 12.6005, 9.3311> <-3.2743, 12.5729, 9.3323> <-3.2728, 12.5502, 9.3360> <-3.2725, 12.5286, 9.3381>
		<-3.3264, 12.5897, 9.4980> <-3.3300, 12.5621, 9.4992> <-3.3371, 12.5421, 9.4996> <-3.3367, 12.5205, 9.5017>
		<-3.3761, 12.6005, 9.6193> <-3.3798, 12.5729, 9.6206> <-3.3783, 12.5502, 9.6243> <-3.3779, 12.5286, 9.6263>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2273, 12.5286, 9.2145> <-3.2270, 12.5134, 9.2160> <-3.2250, 12.4932, 9.2173> <-3.2235, 12.4781, 9.2193>
		<-3.2725, 12.5286, 9.3381> <-3.2722, 12.5134, 9.3395> <-3.2702, 12.4932, 9.3408> <-3.2687, 12.4781, 9.3428>
		<-3.3367, 12.5205, 9.5017> <-3.3365, 12.5053, 9.5031> <-3.3383, 12.4930, 9.5030> <-3.3368, 12.4780, 9.5049>
		<-3.3779, 12.5286, 9.6263> <-3.3777, 12.5134, 9.6278> <-3.3757, 12.4932, 9.6291> <-3.3742, 12.4781, 9.6311>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2235, 12.4781, 9.2193> <-3.2211, 12.4531, 9.2225> <-3.2182, 12.4198, 9.2279> <-3.2142, 12.3951, 9.2320>
		<-3.2687, 12.4781, 9.3428> <-3.2663, 12.4531, 9.3461> <-3.2634, 12.4198, 9.3515> <-3.2594, 12.3951, 9.3556>
		<-3.3368, 12.4780, 9.5049> <-3.3344, 12.4529, 9.5082> <-3.3304, 12.4157, 9.5140> <-3.3265, 12.3910, 9.5181>
		<-3.3742, 12.4781, 9.6311> <-3.3717, 12.4531, 9.6344> <-3.3688, 12.4198, 9.6397> <-3.3649, 12.3951, 9.6439>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2142, 12.3951, 9.2320> <-3.2116, 12.3784, 9.2348> <-3.2053, 12.3567, 9.2392> <-3.2017, 12.3402, 9.2423>
		<-3.2594, 12.3951, 9.3556> <-3.2568, 12.3784, 9.3584> <-3.2505, 12.3567, 9.3628> <-3.2469, 12.3402, 9.3658>
		<-3.3265, 12.3910, 9.5181> <-3.3239, 12.3742, 9.5209> <-3.3156, 12.3539, 9.5259> <-3.3119, 12.3374, 9.5289>
		<-3.3649, 12.3951, 9.6439> <-3.3623, 12.3784, 9.6466> <-3.3560, 12.3567, 9.6511> <-3.3523, 12.3402, 9.6541>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2017, 12.3402, 9.2423> <-3.1965, 12.3171, 9.2465> <-3.1927, 12.2852, 9.2512> <-3.1849, 12.2632, 9.2564>
		<-3.2469, 12.3402, 9.3658> <-3.2417, 12.3171, 9.3701> <-3.2380, 12.2852, 9.3747> <-3.2301, 12.2632, 9.3800>
		<-3.3119, 12.3374, 9.5289> <-3.3068, 12.3143, 9.5332> <-3.2999, 12.2815, 9.5389> <-3.2920, 12.2595, 9.5442>
		<-3.3523, 12.3402, 9.6541> <-3.3472, 12.3171, 9.6584> <-3.3434, 12.2852, 9.6630> <-3.3355, 12.2632, 9.6683>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1849, 12.2632, 9.2564> <-3.1787, 12.2459, 9.2606> <-3.1685, 12.2223, 9.2668> <-3.1554, 12.2105, 9.2733>
		<-3.2301, 12.2632, 9.3800> <-3.2239, 12.2459, 9.3841> <-3.2137, 12.2223, 9.3904> <-3.2006, 12.2105, 9.3969>
		<-3.2920, 12.2595, 9.5442> <-3.2859, 12.2422, 9.5483> <-3.2762, 12.2249, 9.5543> <-3.2631, 12.2131, 9.5608>
		<-3.3355, 12.2632, 9.6683> <-3.3294, 12.2459, 9.6724> <-3.3191, 12.2223, 9.6787> <-3.3060, 12.2105, 9.6852>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1554, 12.2105, 9.2733> <-3.1429, 12.1993, 9.2795> <-3.1208, 12.1916, 9.2894> <-3.1044, 12.1907, 9.2963>
		<-3.2006, 12.2105, 9.3969> <-3.1881, 12.1993, 9.4030> <-3.1660, 12.1916, 9.4130> <-3.1496, 12.1907, 9.4199>
		<-3.2631, 12.2131, 9.5608> <-3.2507, 12.2019, 9.5670> <-3.2294, 12.1959, 9.5767> <-3.2130, 12.1949, 9.5836>
		<-3.3060, 12.2105, 9.6852> <-3.2936, 12.1993, 9.6913> <-3.2714, 12.1916, 9.7013> <-3.2551, 12.1907, 9.7082>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1044, 12.1907, 9.2963> <-3.0928, 12.1899, 9.3012> <-3.0762, 12.1966, 9.3075> <-3.0674, 12.2052, 9.3104>
		<-3.1496, 12.1907, 9.4199> <-3.1380, 12.1899, 9.4248> <-3.1214, 12.1966, 9.4310> <-3.1126, 12.2052, 9.4339>
		<-3.2130, 12.1949, 9.5836> <-3.2014, 12.1942, 9.5885> <-3.1872, 12.1989, 9.5939> <-3.1784, 12.2074, 9.5968>
		<-3.2551, 12.1907, 9.7082> <-3.2434, 12.1899, 9.7131> <-3.2269, 12.1966, 9.7193> <-3.2181, 12.2052, 9.7222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0674, 12.2052, 9.3104> <-3.0470, 12.2251, 9.3171> <-3.0239, 12.2569, 9.3239> <-3.0100, 12.2825, 9.3273>
		<-3.1126, 12.2052, 9.4339> <-3.0922, 12.2251, 9.4406> <-3.0691, 12.2569, 9.4475> <-3.0552, 12.2825, 9.4509>
		<-3.1784, 12.2074, 9.5968> <-3.1579, 12.2274, 9.6035> <-3.1317, 12.2535, 9.6114> <-3.1178, 12.2791, 9.6148>
		<-3.2181, 12.2052, 9.7222> <-3.1976, 12.2251, 9.7289> <-3.1745, 12.2569, 9.7358> <-3.1607, 12.2825, 9.7391>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0100, 12.2825, 9.3273> <-3.0001, 12.3008, 9.3297> <-2.9945, 12.3289, 9.3292> <-2.9895, 12.3493, 9.3294>
		<-3.0552, 12.2825, 9.4509> <-3.0453, 12.3008, 9.4533> <-3.0397, 12.3289, 9.4528> <-3.0347, 12.3493, 9.4529>
		<-3.1178, 12.2791, 9.6148> <-3.1079, 12.2974, 9.6172> <-3.0988, 12.3212, 9.6182> <-3.0938, 12.3416, 9.6183>
		<-3.1607, 12.2825, 9.7391> <-3.1508, 12.3008, 9.7416> <-3.1452, 12.3289, 9.7411> <-3.1402, 12.3493, 9.7412>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9895, 12.3493, 9.3294> <-2.9855, 12.3654, 9.3295> <-2.9817, 12.3873, 9.3292> <-2.9801, 12.4038, 9.3282>
		<-3.0347, 12.3493, 9.4529> <-3.0307, 12.3654, 9.4530> <-3.0269, 12.3873, 9.4527> <-3.0253, 12.4038, 9.4517>
		<-3.0938, 12.3416, 9.6183> <-3.0898, 12.3577, 9.6185> <-3.0843, 12.3789, 9.6188> <-3.0827, 12.3954, 9.6179>
		<-3.1402, 12.3493, 9.7412> <-3.1362, 12.3654, 9.7413> <-3.1324, 12.3873, 9.7410> <-3.1308, 12.4038, 9.7400>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9801, 12.4038, 9.3282> <-2.9779, 12.4257, 9.3269> <-2.9777, 12.4550, 9.3236> <-2.9769, 12.4770, 9.3217>
		<-3.0253, 12.4038, 9.4517> <-3.0231, 12.4257, 9.4504> <-3.0229, 12.4550, 9.4471> <-3.0221, 12.4770, 9.4453>
		<-3.0827, 12.3954, 9.6179> <-3.0805, 12.4173, 9.6165> <-3.0786, 12.4446, 9.6141> <-3.0779, 12.4665, 9.6122>
		<-3.1308, 12.4038, 9.7400> <-3.1286, 12.4257, 9.7387> <-3.1283, 12.4550, 9.7354> <-3.1276, 12.4770, 9.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3319, 9.4934, 7.7595> <-3.3409, 9.4904, 7.7268> <-3.3748, 9.4732, 7.6788> <-3.4155, 9.4392, 7.6924>
		<-3.3606, 9.5275, 7.7614> <-3.3696, 9.5245, 7.7288> <-3.3972, 9.5015, 7.6808> <-3.4378, 9.4675, 7.6943>
		<-3.3982, 9.5735, 7.7639> <-3.3960, 9.5596, 7.7345> <-3.4162, 9.5230, 7.6921> <-3.4654, 9.5067, 7.6994>
		<-3.4259, 9.6085, 7.7637> <-3.4237, 9.5946, 7.7343> <-3.4391, 9.5508, 7.6942> <-3.4883, 9.5345, 7.7015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3319, 9.4934, 7.7595> <-3.3153, 9.4736, 7.7584> <-3.2908, 9.4493, 7.7557> <-3.2749, 9.4290, 7.7536>
		<-3.3409, 9.4904, 7.7268> <-3.3243, 9.4707, 7.7257> <-3.2994, 9.4467, 7.7229> <-3.2836, 9.4264, 7.7207>
		<-3.3748, 9.4732, 7.6788> <-3.3588, 9.4529, 7.6774> <-3.3363, 9.4265, 7.6766> <-3.3195, 9.4068, 7.6775>
		<-3.4155, 9.4392, 7.6924> <-3.3994, 9.4189, 7.6910> <-3.3771, 9.3924, 7.6894> <-3.3603, 9.3727, 7.6903>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3319, 9.4934, 7.7595> <-3.3239, 9.4960, 7.7888> <-3.3490, 9.4724, 7.8435> <-3.3717, 9.4534, 7.8511>
		<-3.3153, 9.4736, 7.7584> <-3.3072, 9.4762, 7.7877> <-3.3330, 9.4522, 7.8415> <-3.3557, 9.4332, 7.8491>
		<-3.2908, 9.4493, 7.7557> <-3.2830, 9.4516, 7.7852> <-3.3134, 9.4242, 7.8372> <-3.3362, 9.4051, 7.8443>
		<-3.2749, 9.4290, 7.7536> <-3.2672, 9.4313, 7.7831> <-3.2979, 9.4037, 7.8335> <-3.3207, 9.3846, 7.8407>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3319, 9.4934, 7.7595> <-3.3606, 9.5275, 7.7614> <-3.3982, 9.5735, 7.7639> <-3.4259, 9.6085, 7.7637>
		<-3.3239, 9.4960, 7.7888> <-3.3526, 9.5301, 7.7907> <-3.4006, 9.5885, 7.7958> <-3.4283, 9.6235, 7.7955>
		<-3.3490, 9.4724, 7.8435> <-3.3869, 9.5201, 7.8483> <-3.4289, 9.5746, 7.8537> <-3.4673, 9.6219, 7.8584>
		<-3.3717, 9.4534, 7.8511> <-3.4096, 9.5012, 7.8559> <-3.4620, 9.5636, 7.8586> <-3.5004, 9.6109, 7.8634>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3717, 9.4534, 7.8511> <-3.4096, 9.5012, 7.8559> <-3.4620, 9.5636, 7.8586> <-3.5004, 9.6109, 7.8634>
		<-3.3950, 9.4339, 7.8589> <-3.4329, 9.4817, 7.8637> <-3.5003, 9.5509, 7.8643> <-3.5387, 9.5982, 7.8690>
		<-3.4416, 9.3975, 7.8291> <-3.4870, 9.4454, 7.8288> <-3.6074, 9.5472, 7.7886> <-3.6075, 9.5472, 7.7885>
		<-3.4499, 9.3948, 7.7989> <-3.4953, 9.4427, 7.7986> <-3.6076, 9.5482, 7.7907> <-3.6076, 9.5482, 7.7907>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3717, 9.4534, 7.8511> <-3.3950, 9.4339, 7.8589> <-3.4416, 9.3975, 7.8291> <-3.4499, 9.3948, 7.7989>
		<-3.3557, 9.4332, 7.8491> <-3.3790, 9.4137, 7.8569> <-3.4237, 9.3787, 7.8292> <-3.4320, 9.3760, 7.7990>
		<-3.3362, 9.4051, 7.8443> <-3.3590, 9.3860, 7.8515> <-3.4060, 9.3489, 7.8241> <-3.4137, 9.3465, 7.7946>
		<-3.3207, 9.3846, 7.8407> <-3.3435, 9.3656, 7.8478> <-3.3897, 9.3289, 7.8215> <-3.3974, 9.3265, 7.7920>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4499, 9.3948, 7.7989> <-3.4953, 9.4427, 7.7986> <-3.6076, 9.5482, 7.7907> <-3.6076, 9.5482, 7.7907>
		<-3.4589, 9.3919, 7.7661> <-3.5044, 9.4398, 7.7658> <-3.6077, 9.5492, 7.7929> <-3.6078, 9.5492, 7.7928>
		<-3.4562, 9.4052, 7.7060> <-3.4786, 9.4334, 7.7079> <-3.5294, 9.4855, 7.7089> <-3.5523, 9.5132, 7.7110>
		<-3.4155, 9.4392, 7.6924> <-3.4378, 9.4675, 7.6943> <-3.4654, 9.5067, 7.6994> <-3.4883, 9.5345, 7.7015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4499, 9.3948, 7.7989> <-3.4589, 9.3919, 7.7661> <-3.4562, 9.4052, 7.7060> <-3.4155, 9.4392, 7.6924>
		<-3.4320, 9.3760, 7.7990> <-3.4411, 9.3731, 7.7662> <-3.4401, 9.3849, 7.7046> <-3.3994, 9.4189, 7.6910>
		<-3.4137, 9.3465, 7.7946> <-3.4222, 9.3439, 7.7625> <-3.4171, 9.3590, 7.7019> <-3.3771, 9.3924, 7.6894>
		<-3.3974, 9.3265, 7.7920> <-3.4059, 9.3240, 7.7599> <-3.4002, 9.3393, 7.7029> <-3.3603, 9.3727, 7.6903>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2749, 9.4290, 7.7536> <-3.2560, 9.4048, 7.7510> <-3.2336, 9.3705, 7.7475> <-3.2163, 9.3453, 7.7437>
		<-3.2836, 9.4264, 7.7207> <-3.2647, 9.4022, 7.7181> <-3.2409, 9.3683, 7.7199> <-3.2236, 9.3431, 7.7160>
		<-3.3195, 9.4068, 7.6775> <-3.2992, 9.3830, 7.6787> <-3.2808, 9.2958, 7.6966> <-3.2844, 9.3005, 7.6972>
		<-3.3603, 9.3727, 7.6903> <-3.3400, 9.3489, 7.6915> <-3.2883, 9.2897, 7.6989> <-3.2920, 9.2944, 7.6996>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2749, 9.4290, 7.7536> <-3.2672, 9.4313, 7.7831> <-3.2979, 9.4037, 7.8335> <-3.3207, 9.3846, 7.8407>
		<-3.2560, 9.4048, 7.7510> <-3.2483, 9.4071, 7.7805> <-3.2796, 9.3794, 7.8292> <-3.3024, 9.3603, 7.8364>
		<-3.2336, 9.3705, 7.7475> <-3.2264, 9.3727, 7.7749> <-3.2564, 9.3458, 7.8217> <-3.2778, 9.3284, 7.8284>
		<-3.2163, 9.3453, 7.7437> <-3.2091, 9.3475, 7.7711> <-3.2376, 9.3217, 7.8180> <-3.2590, 9.3043, 7.8246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3207, 9.3846, 7.8407> <-3.3435, 9.3656, 7.8478> <-3.3897, 9.3289, 7.8215> <-3.3974, 9.3265, 7.7920>
		<-3.3024, 9.3603, 7.8364> <-3.3252, 9.3413, 7.8435> <-3.3708, 9.3057, 7.8184> <-3.3786, 9.3034, 7.7890>
		<-3.2778, 9.3284, 7.8284> <-3.2996, 9.3108, 7.8351> <-3.3450, 9.2757, 7.8117> <-3.3523, 9.2735, 7.7840>
		<-3.2590, 9.3043, 7.8246> <-3.2808, 9.2868, 7.8314> <-3.3256, 9.2532, 7.8077> <-3.3329, 9.2510, 7.7800>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3974, 9.3265, 7.7920> <-3.4059, 9.3240, 7.7599> <-3.4002, 9.3393, 7.7029> <-3.3603, 9.3727, 7.6903>
		<-3.3786, 9.3034, 7.7890> <-3.3871, 9.3008, 7.7568> <-3.3800, 9.3155, 7.7041> <-3.3400, 9.3489, 7.6915>
		<-3.3523, 9.2735, 7.7840> <-3.3595, 9.2713, 7.7567> <-3.2957, 9.2837, 7.7013> <-3.2883, 9.2897, 7.6989>
		<-3.3329, 9.2510, 7.7800> <-3.3400, 9.2489, 7.7526> <-3.2994, 9.2884, 7.7019> <-3.2920, 9.2944, 7.6996>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2163, 9.3453, 7.7437> <-3.1888, 9.3052, 7.7376> <-3.1538, 9.2510, 7.7260> <-3.1255, 9.2113, 7.7206>
		<-3.2236, 9.3431, 7.7160> <-3.1961, 9.3030, 7.7099> <-3.1612, 9.2487, 7.6979> <-3.1329, 9.2091, 7.6924>
		<-3.2844, 9.3005, 7.6972> <-3.2902, 9.3078, 7.6982> <-3.1923, 9.2335, 7.6545> <-3.1624, 9.1946, 7.6501>
		<-3.2920, 9.2944, 7.6996> <-3.2977, 9.3017, 7.7005> <-3.2269, 9.2044, 7.6669> <-3.1970, 9.1655, 7.6624>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2163, 9.3453, 7.7437> <-3.2091, 9.3475, 7.7711> <-3.2376, 9.3217, 7.8180> <-3.2590, 9.3043, 7.8246>
		<-3.1888, 9.3052, 7.7376> <-3.1816, 9.3073, 7.7650> <-3.2077, 9.2835, 7.8120> <-3.2292, 9.2661, 7.8187>
		<-3.1538, 9.2510, 7.7260> <-3.1466, 9.2531, 7.7534> <-3.1670, 9.2334, 7.8068> <-3.1879, 9.2158, 7.8143>
		<-3.1255, 9.2113, 7.7206> <-3.1183, 9.2135, 7.7479> <-3.1376, 9.1947, 7.8010> <-3.1586, 9.1771, 7.8085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2590, 9.3043, 7.8246> <-3.2808, 9.2868, 7.8314> <-3.3256, 9.2532, 7.8077> <-3.3329, 9.2510, 7.7800>
		<-3.2292, 9.2661, 7.8187> <-3.2509, 9.2486, 7.8255> <-3.2933, 9.2161, 7.8010> <-3.3006, 9.2139, 7.7733>
		<-3.1879, 9.2158, 7.8143> <-3.2084, 9.1986, 7.8217> <-3.2485, 9.1686, 7.7892> <-3.2555, 9.1665, 7.7624>
		<-3.1586, 9.1771, 7.8085> <-3.1791, 9.1599, 7.8159> <-3.2181, 9.1298, 7.7830> <-3.2251, 9.1277, 7.7562>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3329, 9.2510, 7.7800> <-3.3400, 9.2489, 7.7526> <-3.2994, 9.2884, 7.7019> <-3.2920, 9.2944, 7.6996>
		<-3.3006, 9.2139, 7.7733> <-3.3078, 9.2117, 7.7459> <-3.3052, 9.2957, 7.7029> <-3.2977, 9.3017, 7.7005>
		<-3.2555, 9.1665, 7.7624> <-3.2630, 9.1642, 7.7337> <-3.2622, 9.1748, 7.6795> <-3.2269, 9.2044, 7.6669>
		<-3.2251, 9.1277, 7.7562> <-3.2327, 9.1254, 7.7275> <-3.2323, 9.1359, 7.6751> <-3.1970, 9.1655, 7.6624>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1255, 9.2113, 7.7206> <-3.1062, 9.1843, 7.7168> <-3.0917, 9.1687, 7.7160> <-3.0576, 9.1234, 7.7130>
		<-3.1329, 9.2091, 7.6924> <-3.1136, 9.1821, 7.6887> <-3.1030, 9.1652, 7.6732> <-3.0690, 9.1199, 7.6702>
		<-3.1624, 9.1946, 7.6501> <-3.1419, 9.1680, 7.6470> <-3.1157, 9.0752, 7.6733> <-3.1217, 9.0829, 7.6737>
		<-3.1970, 9.1655, 7.6624> <-3.1765, 9.1390, 7.6594> <-3.1204, 9.0715, 7.6747> <-3.1264, 9.0792, 7.6751>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1255, 9.2113, 7.7206> <-3.1183, 9.2135, 7.7479> <-3.1376, 9.1947, 7.8010> <-3.1586, 9.1771, 7.8085>
		<-3.1062, 9.1843, 7.7168> <-3.0990, 9.1865, 7.7441> <-3.1178, 9.1686, 7.7971> <-3.1387, 9.1511, 7.8046>
		<-3.0917, 9.1687, 7.7160> <-3.0798, 9.1723, 7.7609> <-3.0943, 9.1313, 7.7904> <-3.1147, 9.1151, 7.7966>
		<-3.0576, 9.1234, 7.7130> <-3.0457, 9.1270, 7.7578> <-3.0749, 9.1049, 7.7861> <-3.0953, 9.0888, 7.7923>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1586, 9.1771, 7.8085> <-3.1791, 9.1599, 7.8159> <-3.2181, 9.1298, 7.7830> <-3.2251, 9.1277, 7.7562>
		<-3.1387, 9.1511, 7.8046> <-3.1593, 9.1339, 7.8120> <-3.1982, 9.1044, 7.7789> <-3.2052, 9.1023, 7.7522>
		<-3.1147, 9.1151, 7.7966> <-3.1360, 9.0982, 7.8031> <-3.1872, 9.0849, 7.7960> <-3.1996, 9.0811, 7.7492>
		<-3.0953, 9.0888, 7.7923> <-3.1166, 9.0719, 7.7988> <-3.1532, 9.0415, 7.7928> <-3.1657, 9.0376, 7.7459>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2251, 9.1277, 7.7562> <-3.2327, 9.1254, 7.7275> <-3.2323, 9.1359, 7.6751> <-3.1970, 9.1655, 7.6624>
		<-3.2052, 9.1023, 7.7522> <-3.2128, 9.1000, 7.7235> <-3.2118, 9.1093, 7.6721> <-3.1765, 9.1390, 7.6594>
		<-3.1996, 9.0811, 7.7492> <-3.2111, 9.0776, 7.7059> <-3.1251, 9.0677, 7.6762> <-3.1204, 9.0715, 7.6747>
		<-3.1657, 9.0376, 7.7459> <-3.1772, 9.0341, 7.7027> <-3.1311, 9.0755, 7.6765> <-3.1264, 9.0792, 7.6751>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0576, 9.1234, 7.7130> <-3.0204, 9.0739, 7.7097> <-3.0061, 9.0556, 7.7094> <-2.9858, 9.0253, 7.7081>
		<-3.0690, 9.1199, 7.6702> <-3.0318, 9.0704, 7.6669> <-3.0108, 9.0502, 7.6824> <-2.9904, 9.0200, 7.6811>
		<-3.1217, 9.0829, 7.6737> <-3.1293, 9.0928, 7.6741> <-3.0348, 9.0267, 7.6448> <-3.0088, 8.9929, 7.6419>
		<-3.1264, 9.0792, 7.6751> <-3.1340, 9.0891, 7.6755> <-3.0686, 8.9997, 7.6566> <-3.0426, 8.9659, 7.6538>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0576, 9.1234, 7.7130> <-3.0457, 9.1270, 7.7578> <-3.0749, 9.1049, 7.7861> <-3.0953, 9.0888, 7.7923>
		<-3.0204, 9.0739, 7.7097> <-3.0085, 9.0775, 7.7545> <-3.0530, 9.0753, 7.7814> <-3.0734, 9.0591, 7.7876>
		<-3.0061, 9.0556, 7.7094> <-3.0020, 9.0603, 7.7330> <-3.0256, 9.0792, 7.7796> <-3.0630, 9.0493, 7.7928>
		<-2.9858, 9.0253, 7.7081> <-2.9817, 9.0300, 7.7317> <-2.9835, 9.0206, 7.7654> <-3.0210, 8.9906, 7.7786>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0953, 9.0888, 7.7923> <-3.1166, 9.0719, 7.7988> <-3.1532, 9.0415, 7.7928> <-3.1657, 9.0376, 7.7459>
		<-3.0734, 9.0591, 7.7876> <-3.0947, 9.0422, 7.7941> <-3.1150, 8.9924, 7.7891> <-3.1275, 8.9886, 7.7422>
		<-3.0630, 9.0493, 7.7928> <-3.1000, 9.0198, 7.8057> <-3.1049, 8.9783, 7.7679> <-3.1089, 8.9737, 7.7446>
		<-3.0210, 8.9906, 7.7786> <-3.0579, 8.9612, 7.7915> <-3.0800, 8.9514, 7.7658> <-3.0841, 8.9468, 7.7426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1657, 9.0376, 7.7459> <-3.1772, 9.0341, 7.7027> <-3.1311, 9.0755, 7.6765> <-3.1264, 9.0792, 7.6751>
		<-3.1275, 8.9886, 7.7422> <-3.1389, 8.9851, 7.6990> <-3.1387, 9.0853, 7.6769> <-3.1340, 9.0891, 7.6755>
		<-3.1089, 8.9737, 7.7446> <-3.1136, 8.9682, 7.7173> <-3.1029, 8.9724, 7.6687> <-3.0686, 8.9997, 7.6566>
		<-3.0841, 8.9468, 7.7426> <-3.0888, 8.9413, 7.7152> <-3.0769, 8.9385, 7.6658> <-3.0426, 8.9659, 7.6538>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9858, 9.0253, 7.7081> <-2.9698, 9.0015, 7.7070> <-2.9502, 8.9687, 7.7044> <-2.9367, 8.9434, 7.7049>
		<-2.9904, 9.0200, 7.6811> <-2.9745, 8.9962, 7.6800> <-2.9561, 8.9669, 7.6823> <-2.9426, 8.9416, 7.6828>
		<-3.0088, 8.9929, 7.6419> <-2.9942, 8.9739, 7.6403> <-2.9801, 8.9441, 7.6440> <-2.9645, 8.9270, 7.6506>
		<-3.0426, 8.9659, 7.6538> <-3.0280, 8.9469, 7.6522> <-3.0074, 8.9213, 7.6538> <-2.9918, 8.9043, 7.6603>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9858, 9.0253, 7.7081> <-2.9817, 9.0300, 7.7317> <-2.9835, 9.0206, 7.7654> <-3.0210, 8.9906, 7.7786>
		<-2.9698, 9.0015, 7.7070> <-2.9657, 9.0062, 7.7306> <-2.9497, 8.9734, 7.7540> <-2.9872, 8.9435, 7.7671>
		<-2.9502, 8.9687, 7.7044> <-2.9457, 8.9701, 7.7217> <-2.9758, 9.0229, 7.7587> <-3.0192, 8.9866, 7.7742>
		<-2.9367, 8.9434, 7.7049> <-2.9322, 8.9448, 7.7221> <-2.9247, 8.9478, 7.7338> <-2.9681, 8.9115, 7.7494>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0210, 8.9906, 7.7786> <-3.0579, 8.9612, 7.7915> <-3.0800, 8.9514, 7.7658> <-3.0841, 8.9468, 7.7426>
		<-2.9872, 8.9435, 7.7671> <-3.0241, 8.9140, 7.7801> <-3.0602, 8.9299, 7.7642> <-3.0642, 8.9253, 7.7409>
		<-3.0192, 8.9866, 7.7742> <-3.0620, 8.9509, 7.7895> <-3.0339, 8.8976, 7.7531> <-3.0384, 8.8962, 7.7361>
		<-2.9681, 8.9115, 7.7494> <-3.0109, 8.8758, 7.7647> <-3.0124, 8.8779, 7.7505> <-3.0169, 8.8765, 7.7336>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0841, 8.9468, 7.7426> <-3.0888, 8.9413, 7.7152> <-3.0769, 8.9385, 7.6658> <-3.0426, 8.9659, 7.6538>
		<-3.0642, 8.9253, 7.7409> <-3.0690, 8.9199, 7.7136> <-3.0622, 8.9195, 7.6642> <-3.0280, 8.9469, 7.6522>
		<-3.0384, 8.8962, 7.7361> <-3.0444, 8.8944, 7.7137> <-3.0351, 8.8982, 7.6637> <-3.0074, 8.9213, 7.6538>
		<-3.0169, 8.8765, 7.7336> <-3.0229, 8.8747, 7.7111> <-3.0195, 8.8811, 7.6703> <-2.9918, 8.9043, 7.6603>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9367, 8.9434, 7.7049> <-2.9302, 8.9312, 7.7051> <-2.9190, 8.9147, 7.7080> <-2.9192, 8.9010, 7.7102>
		<-2.9426, 8.9416, 7.6828> <-2.9361, 8.9294, 7.6830> <-2.9221, 8.9127, 7.6939> <-2.9223, 8.8990, 7.6961>
		<-2.9645, 8.9270, 7.6506> <-2.9533, 8.9148, 7.6552> <-2.9482, 8.8934, 7.6732> <-2.9380, 8.8851, 7.6843>
		<-2.9918, 8.9043, 7.6603> <-2.9806, 8.8920, 7.6650> <-2.9659, 8.8793, 7.6790> <-2.9557, 8.8710, 7.6901>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9367, 8.9434, 7.7049> <-2.9322, 8.9448, 7.7221> <-2.9247, 8.9478, 7.7338> <-2.9681, 8.9115, 7.7494>
		<-2.9302, 8.9312, 7.7051> <-2.9256, 8.9326, 7.7223> <-2.9033, 8.9163, 7.7234> <-2.9467, 8.8801, 7.7390>
		<-2.9190, 8.9147, 7.7080> <-2.9162, 8.9165, 7.7207> <-2.9344, 8.9166, 7.7468> <-2.9566, 8.8989, 7.7541>
		<-2.9192, 8.9010, 7.7102> <-2.9165, 8.9028, 7.7229> <-2.9222, 8.8959, 7.7341> <-2.9445, 8.8782, 7.7413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9681, 8.9115, 7.7494> <-3.0109, 8.8758, 7.7647> <-3.0124, 8.8779, 7.7505> <-3.0169, 8.8765, 7.7336>
		<-2.9467, 8.8801, 7.7390> <-2.9895, 8.8444, 7.7543> <-3.0028, 8.8690, 7.7494> <-3.0073, 8.8676, 7.7324>
		<-2.9566, 8.8989, 7.7541> <-2.9789, 8.8812, 7.7614> <-2.9907, 8.8563, 7.7455> <-2.9935, 8.8545, 7.7328>
		<-2.9445, 8.8782, 7.7413> <-2.9667, 8.8605, 7.7486> <-2.9781, 8.8537, 7.7430> <-2.9809, 8.8520, 7.7304>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0169, 8.8765, 7.7336> <-3.0229, 8.8747, 7.7111> <-3.0195, 8.8811, 7.6703> <-2.9918, 8.9043, 7.6603>
		<-3.0073, 8.8676, 7.7324> <-3.0133, 8.8658, 7.7100> <-3.0083, 8.8689, 7.6749> <-2.9806, 8.8920, 7.6650>
		<-2.9935, 8.8545, 7.7328> <-2.9966, 8.8525, 7.7188> <-2.9836, 8.8653, 7.6848> <-2.9659, 8.8793, 7.6790>
		<-2.9809, 8.8520, 7.7304> <-2.9839, 8.8500, 7.7163> <-2.9733, 8.8569, 7.6959> <-2.9557, 8.8710, 7.6901>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9384, 8.8608, 7.7182> <-2.9450, 8.8554, 7.7203> <-2.9678, 8.8493, 7.7278> <-2.9809, 8.8520, 7.7304>
		<-2.9384, 8.8608, 7.7182> <-2.9465, 8.8545, 7.7138> <-2.9709, 8.8474, 7.7138> <-2.9839, 8.8500, 7.7163>
		<-2.9384, 8.8608, 7.7182> <-2.9465, 8.8545, 7.7138> <-2.9672, 8.8519, 7.7025> <-2.9733, 8.8569, 7.6959>
		<-2.9384, 8.8608, 7.7182> <-2.9398, 8.8598, 7.7116> <-2.9495, 8.8660, 7.6967> <-2.9557, 8.8710, 7.6901>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9384, 8.8608, 7.7182> <-2.9398, 8.8598, 7.7116> <-2.9495, 8.8660, 7.6967> <-2.9557, 8.8710, 7.6901>
		<-2.9384, 8.8608, 7.7182> <-2.9331, 8.8652, 7.7094> <-2.9318, 8.8801, 7.6910> <-2.9380, 8.8851, 7.6843>
		<-2.9384, 8.8608, 7.7182> <-2.9331, 8.8652, 7.7094> <-2.9226, 8.8856, 7.6983> <-2.9223, 8.8990, 7.6961>
		<-2.9384, 8.8608, 7.7182> <-2.9316, 8.8661, 7.7160> <-2.9195, 8.8876, 7.7124> <-2.9192, 8.9010, 7.7102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9384, 8.8608, 7.7182> <-2.9316, 8.8661, 7.7160> <-2.9195, 8.8876, 7.7124> <-2.9192, 8.9010, 7.7102>
		<-2.9384, 8.8608, 7.7182> <-2.9304, 8.8669, 7.7216> <-2.9167, 8.8894, 7.7250> <-2.9165, 8.9028, 7.7229>
		<-2.9384, 8.8608, 7.7182> <-2.9304, 8.8669, 7.7216> <-2.9136, 8.8811, 7.7250> <-2.9222, 8.8959, 7.7341>
		<-2.9384, 8.8608, 7.7182> <-2.9371, 8.8616, 7.7238> <-2.9358, 8.8635, 7.7323> <-2.9445, 8.8782, 7.7413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9384, 8.8608, 7.7182> <-2.9371, 8.8616, 7.7238> <-2.9358, 8.8635, 7.7323> <-2.9445, 8.8782, 7.7413>
		<-2.9384, 8.8608, 7.7182> <-2.9438, 8.8562, 7.7260> <-2.9581, 8.8457, 7.7396> <-2.9667, 8.8605, 7.7486>
		<-2.9384, 8.8608, 7.7182> <-2.9438, 8.8562, 7.7260> <-2.9651, 8.8511, 7.7405> <-2.9781, 8.8537, 7.7430>
		<-2.9384, 8.8608, 7.7182> <-2.9450, 8.8554, 7.7203> <-2.9678, 8.8493, 7.7278> <-2.9809, 8.8520, 7.7304>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5151, 9.4076, 7.7372> <-3.5316, 9.4177, 7.7086> <-3.5805, 9.4277, 7.6698> <-3.6231, 9.3943, 7.6821>
		<-3.5009, 9.3855, 7.7261> <-3.5174, 9.3956, 7.6975> <-3.5683, 9.4068, 7.6546> <-3.6109, 9.3734, 7.6669>
		<-3.4847, 9.3601, 7.7016> <-3.5016, 9.3719, 7.6745> <-3.5518, 9.3781, 7.6353> <-3.5941, 9.3455, 7.6469>
		<-3.4734, 9.3391, 7.6859> <-3.4903, 9.3508, 7.6588> <-3.5383, 9.3564, 7.6223> <-3.5806, 9.3238, 7.6339>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5151, 9.4076, 7.7372> <-3.5415, 9.4487, 7.7578> <-3.6077, 9.5482, 7.7906> <-3.6076, 9.5482, 7.7907>
		<-3.5316, 9.4177, 7.7086> <-3.5580, 9.4588, 7.7291> <-3.6074, 9.5486, 7.7929> <-3.6073, 9.5486, 7.7929>
		<-3.5805, 9.4277, 7.6698> <-3.5873, 9.4396, 7.6784> <-3.5834, 9.4589, 7.6992> <-3.5918, 9.4714, 7.7050>
		<-3.6231, 9.3943, 7.6821> <-3.6300, 9.4062, 7.6907> <-3.6356, 9.4205, 7.7073> <-3.6440, 9.4330, 7.7132>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5151, 9.4076, 7.7372> <-3.5005, 9.3988, 7.7624> <-3.5200, 9.3640, 7.8133> <-3.5434, 9.3457, 7.8200>
		<-3.5415, 9.4487, 7.7578> <-3.5269, 9.4398, 7.7829> <-3.5420, 9.3990, 7.8360> <-3.5654, 9.3807, 7.8427>
		<-3.6077, 9.5482, 7.7906> <-3.6079, 9.5478, 7.7885> <-3.5684, 9.4484, 7.8667> <-3.5979, 9.4267, 7.8713>
		<-3.6076, 9.5482, 7.7907> <-3.6079, 9.5478, 7.7886> <-3.5938, 9.4845, 7.8833> <-3.6233, 9.4628, 7.8879>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5151, 9.4076, 7.7372> <-3.5009, 9.3855, 7.7261> <-3.4847, 9.3601, 7.7016> <-3.4734, 9.3391, 7.6859>
		<-3.5005, 9.3988, 7.7624> <-3.4863, 9.3766, 7.7512> <-3.4696, 9.3496, 7.7258> <-3.4583, 9.3286, 7.7101>
		<-3.5200, 9.3640, 7.8133> <-3.5052, 9.3405, 7.7981> <-3.4897, 9.3093, 7.7737> <-3.4774, 9.2866, 7.7553>
		<-3.5434, 9.3457, 7.8200> <-3.5285, 9.3222, 7.8048> <-3.5132, 9.2911, 7.7802> <-3.5009, 9.2684, 7.7617>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5434, 9.3457, 7.8200> <-3.5681, 9.3264, 7.8272> <-3.6250, 9.3002, 7.7999> <-3.6404, 9.3096, 7.7732>
		<-3.5654, 9.3807, 7.8427> <-3.5901, 9.3614, 7.8499> <-3.6558, 9.3397, 7.8184> <-3.6712, 9.3490, 7.7918>
		<-3.5979, 9.4267, 7.8713> <-3.6324, 9.4014, 7.8766> <-3.7556, 9.4402, 7.8108> <-3.7551, 9.4409, 7.8145>
		<-3.6233, 9.4628, 7.8879> <-3.6578, 9.4374, 7.8933> <-3.7545, 9.4399, 7.8098> <-3.7541, 9.4405, 7.8135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5434, 9.3457, 7.8200> <-3.5285, 9.3222, 7.8048> <-3.5132, 9.2911, 7.7802> <-3.5009, 9.2684, 7.7617>
		<-3.5681, 9.3264, 7.8272> <-3.5533, 9.3029, 7.8119> <-3.5372, 9.2726, 7.7867> <-3.5249, 9.2499, 7.7683>
		<-3.6250, 9.3002, 7.7999> <-3.6084, 9.2791, 7.7900> <-3.5961, 9.2512, 7.7613> <-3.5835, 9.2315, 7.7449>
		<-3.6404, 9.3096, 7.7732> <-3.6239, 9.2885, 7.7633> <-3.6116, 9.2619, 7.7366> <-3.5989, 9.2422, 7.7202>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6404, 9.3096, 7.7732> <-3.6239, 9.2885, 7.7633> <-3.6116, 9.2619, 7.7366> <-3.5989, 9.2422, 7.7202>
		<-3.6574, 9.3200, 7.7438> <-3.6409, 9.2989, 7.7338> <-3.6285, 9.2736, 7.7095> <-3.6158, 9.2540, 7.6931>
		<-3.6670, 9.3600, 7.6947> <-3.6549, 9.3390, 7.6795> <-3.6364, 9.3128, 7.6584> <-3.6229, 9.2911, 7.6455>
		<-3.6231, 9.3943, 7.6821> <-3.6109, 9.3734, 7.6669> <-3.5941, 9.3455, 7.6469> <-3.5806, 9.3238, 7.6339>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6404, 9.3096, 7.7732> <-3.6574, 9.3200, 7.7438> <-3.6670, 9.3600, 7.6947> <-3.6231, 9.3943, 7.6821>
		<-3.6712, 9.3490, 7.7918> <-3.6883, 9.3594, 7.7623> <-3.6739, 9.3718, 7.7033> <-3.6300, 9.4062, 7.6907>
		<-3.7551, 9.4409, 7.8145> <-3.7547, 9.4415, 7.8182> <-3.6899, 9.3806, 7.7158> <-3.6356, 9.4205, 7.7073>
		<-3.7541, 9.4405, 7.8135> <-3.7537, 9.4412, 7.8172> <-3.6983, 9.3931, 7.7216> <-3.6440, 9.4330, 7.7132>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4734, 9.3391, 7.6859> <-3.4903, 9.3508, 7.6588> <-3.5383, 9.3564, 7.6223> <-3.5806, 9.3238, 7.6339>
		<-3.4603, 9.3147, 7.6677> <-3.4772, 9.3265, 7.6406> <-3.5225, 9.3310, 7.6071> <-3.5648, 9.2983, 7.6187>
		<-3.4447, 9.2806, 7.6444> <-3.4589, 9.2904, 7.6217> <-3.5154, 9.2385, 7.5827> <-3.5231, 9.2327, 7.5849>
		<-3.4339, 9.2565, 7.6245> <-3.4480, 9.2664, 7.6018> <-3.5180, 9.2431, 7.5862> <-3.5258, 9.2374, 7.5884>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4734, 9.3391, 7.6859> <-3.4603, 9.3147, 7.6677> <-3.4447, 9.2806, 7.6444> <-3.4339, 9.2565, 7.6245>
		<-3.4583, 9.3286, 7.7101> <-3.4452, 9.3043, 7.6919> <-3.4308, 9.2709, 7.6668> <-3.4199, 9.2468, 7.6469>
		<-3.4774, 9.2866, 7.7553> <-3.4645, 9.2629, 7.7361> <-3.4500, 9.2310, 7.7085> <-3.4374, 9.2077, 7.6886>
		<-3.5009, 9.2684, 7.7617> <-3.4880, 9.2447, 7.7425> <-3.4720, 9.2146, 7.7145> <-3.4595, 9.1913, 7.6947>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5009, 9.2684, 7.7617> <-3.4880, 9.2447, 7.7425> <-3.4720, 9.2146, 7.7145> <-3.4595, 9.1913, 7.6947>
		<-3.5249, 9.2499, 7.7683> <-3.5121, 9.2262, 7.7491> <-3.4943, 9.1979, 7.7207> <-3.4818, 9.1746, 7.7009>
		<-3.5835, 9.2315, 7.7449> <-3.5691, 9.2092, 7.7264> <-3.5497, 9.1816, 7.6992> <-3.5360, 9.1600, 7.6794>
		<-3.5989, 9.2422, 7.7202> <-3.5845, 9.2200, 7.7016> <-3.5639, 9.1915, 7.6765> <-3.5502, 9.1698, 7.6566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5989, 9.2422, 7.7202> <-3.5845, 9.2200, 7.7016> <-3.5639, 9.1915, 7.6765> <-3.5502, 9.1698, 7.6566>
		<-3.6158, 9.2540, 7.6931> <-3.6014, 9.2317, 7.6745> <-3.5778, 9.2011, 7.6541> <-3.5641, 9.1795, 7.6343>
		<-3.6229, 9.2911, 7.6455> <-3.6071, 9.2656, 7.6303> <-3.5308, 9.2270, 7.5870> <-3.5334, 9.2317, 7.5905>
		<-3.5806, 9.3238, 7.6339> <-3.5648, 9.2983, 7.6187> <-3.5231, 9.2327, 7.5849> <-3.5258, 9.2374, 7.5884>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4339, 9.2565, 7.6245> <-3.4480, 9.2664, 7.6018> <-3.5180, 9.2431, 7.5862> <-3.5258, 9.2374, 7.5884>
		<-3.4197, 9.2251, 7.5985> <-3.4338, 9.2350, 7.5758> <-3.5214, 9.2490, 7.5906> <-3.5291, 9.2432, 7.5928>
		<-3.4057, 9.1852, 7.5591> <-3.4192, 9.1949, 7.5378> <-3.4608, 9.1983, 7.5109> <-3.4938, 9.1719, 7.5210>
		<-3.3899, 9.1544, 7.5333> <-3.4035, 9.1641, 7.5120> <-3.4441, 9.1679, 7.4865> <-3.4771, 9.1415, 7.4967>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4339, 9.2565, 7.6245> <-3.4197, 9.2251, 7.5985> <-3.4057, 9.1852, 7.5591> <-3.3899, 9.1544, 7.5333>
		<-3.4199, 9.2468, 7.6469> <-3.4057, 9.2154, 7.6209> <-3.3913, 9.1749, 7.5817> <-3.3755, 9.1442, 7.5559>
		<-3.4374, 9.2077, 7.6886> <-3.4212, 9.1775, 7.6629> <-3.3993, 9.1377, 7.6290> <-3.3832, 9.1074, 7.6033>
		<-3.4595, 9.1913, 7.6947> <-3.4432, 9.1611, 7.6690> <-3.4211, 9.1203, 7.6357> <-3.4050, 9.0900, 7.6100>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4595, 9.1913, 7.6947> <-3.4432, 9.1611, 7.6690> <-3.4211, 9.1203, 7.6357> <-3.4050, 9.0900, 7.6100>
		<-3.4818, 9.1746, 7.7009> <-3.4656, 9.1444, 7.6752> <-3.4426, 9.1032, 7.6423> <-3.4264, 9.0729, 7.6166>
		<-3.5360, 9.1600, 7.6794> <-3.5176, 9.1308, 7.6525> <-3.4943, 9.0937, 7.6132> <-3.4778, 9.0630, 7.5869>
		<-3.5502, 9.1698, 7.6566> <-3.5317, 9.1407, 7.6298> <-3.5084, 9.1038, 7.5910> <-3.4919, 9.0730, 7.5647>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5502, 9.1698, 7.6566> <-3.5317, 9.1407, 7.6298> <-3.5084, 9.1038, 7.5910> <-3.4919, 9.0730, 7.5647>
		<-3.5641, 9.1795, 7.6343> <-3.5457, 9.1504, 7.6075> <-3.5223, 9.1137, 7.5692> <-3.5058, 9.0829, 7.5429>
		<-3.5334, 9.2317, 7.5905> <-3.5367, 9.2375, 7.5949> <-3.5276, 9.1450, 7.5314> <-3.5109, 9.1146, 7.5071>
		<-3.5258, 9.2374, 7.5884> <-3.5291, 9.2432, 7.5928> <-3.4938, 9.1719, 7.5210> <-3.4771, 9.1415, 7.4967>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3899, 9.1544, 7.5333> <-3.4035, 9.1641, 7.5120> <-3.4441, 9.1679, 7.4865> <-3.4771, 9.1415, 7.4967>
		<-3.3771, 9.1296, 7.5125> <-3.3907, 9.1393, 7.4912> <-3.4300, 9.1423, 7.4660> <-3.4631, 9.1159, 7.4762>
		<-3.3616, 9.1140, 7.5044> <-3.3842, 9.1296, 7.4682> <-3.4152, 9.0481, 7.4320> <-3.4201, 9.0444, 7.4332>
		<-3.3391, 9.0716, 7.4696> <-3.3616, 9.0873, 7.4334> <-3.4190, 9.0554, 7.4383> <-3.4239, 9.0517, 7.4396>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3899, 9.1544, 7.5333> <-3.3771, 9.1296, 7.5125> <-3.3616, 9.1140, 7.5044> <-3.3391, 9.0716, 7.4696>
		<-3.3755, 9.1442, 7.5559> <-3.3627, 9.1193, 7.5351> <-3.3379, 9.0975, 7.5424> <-3.3154, 9.0552, 7.5076>
		<-3.3832, 9.1074, 7.6033> <-3.3700, 9.0828, 7.5824> <-3.3520, 9.0484, 7.5565> <-3.3403, 9.0248, 7.5337>
		<-3.4050, 9.0900, 7.6100> <-3.3918, 9.0654, 7.5891> <-3.3733, 9.0321, 7.5622> <-3.3616, 9.0084, 7.5394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4050, 9.0900, 7.6100> <-3.3918, 9.0654, 7.5891> <-3.3733, 9.0321, 7.5622> <-3.3616, 9.0084, 7.5394>
		<-3.4264, 9.0729, 7.6166> <-3.4132, 9.0483, 7.5957> <-3.3955, 9.0151, 7.5681> <-3.3838, 8.9914, 7.5453>
		<-3.4778, 9.0630, 7.5869> <-3.4646, 9.0384, 7.5660> <-3.4494, 9.0106, 7.5741> <-3.4267, 8.9684, 7.5391>
		<-3.4919, 9.0730, 7.5647> <-3.4787, 9.0484, 7.5437> <-3.4741, 9.0277, 7.5345> <-3.4514, 8.9856, 7.4995>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4919, 9.0730, 7.5647> <-3.4787, 9.0484, 7.5437> <-3.4741, 9.0277, 7.5345> <-3.4514, 8.9856, 7.4995>
		<-3.5058, 9.0829, 7.5429> <-3.4926, 9.0583, 7.5219> <-3.4970, 9.0436, 7.4979> <-3.4743, 9.0015, 7.4629>
		<-3.5109, 9.1146, 7.5071> <-3.4969, 9.0889, 7.4866> <-3.4250, 9.0406, 7.4346> <-3.4288, 9.0479, 7.4410>
		<-3.4771, 9.1415, 7.4967> <-3.4631, 9.1159, 7.4762> <-3.4201, 9.0444, 7.4332> <-3.4239, 9.0517, 7.4396>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3391, 9.0716, 7.4696> <-3.3616, 9.0873, 7.4334> <-3.4190, 9.0554, 7.4383> <-3.4239, 9.0517, 7.4396>
		<-3.3176, 9.0314, 7.4365> <-3.3402, 9.0470, 7.4003> <-3.4227, 9.0624, 7.4445> <-3.4275, 9.0587, 7.4458>
		<-3.3122, 9.0161, 7.4225> <-3.3276, 9.0285, 7.4019> <-3.3685, 9.0305, 7.3685> <-3.4036, 9.0028, 7.3791>
		<-3.3038, 8.9928, 7.4005> <-3.3192, 9.0052, 7.3799> <-3.3580, 9.0080, 7.3446> <-3.3931, 8.9803, 7.3552>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3391, 9.0716, 7.4696> <-3.3176, 9.0314, 7.4365> <-3.3122, 9.0161, 7.4225> <-3.3038, 8.9928, 7.4005>
		<-3.3154, 9.0552, 7.5076> <-3.2939, 9.0149, 7.4745> <-3.2989, 9.0053, 7.4403> <-3.2905, 8.9820, 7.4183>
		<-3.3403, 9.0248, 7.5337> <-3.3273, 8.9983, 7.5083> <-3.3021, 8.9992, 7.4975> <-3.2843, 8.9536, 7.4379>
		<-3.3616, 9.0084, 7.5394> <-3.3486, 8.9820, 7.5140> <-3.3404, 8.9689, 7.5091> <-3.3226, 8.9233, 7.4495>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3616, 9.0084, 7.5394> <-3.3486, 8.9820, 7.5140> <-3.3404, 8.9689, 7.5091> <-3.3226, 8.9233, 7.4495>
		<-3.3838, 8.9914, 7.5453> <-3.3708, 8.9650, 7.5199> <-3.3780, 8.9391, 7.5205> <-3.3602, 8.8936, 7.4609>
		<-3.4267, 8.9684, 7.5391> <-3.4052, 8.9286, 7.5060> <-3.4051, 8.9222, 7.4714> <-3.3923, 8.9019, 7.4487>
		<-3.4514, 8.9856, 7.4995> <-3.4299, 8.9457, 7.4664> <-3.4182, 8.9327, 7.4540> <-3.4054, 8.9125, 7.4313>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4514, 8.9856, 7.4995> <-3.4299, 8.9457, 7.4664> <-3.4182, 8.9327, 7.4540> <-3.4054, 8.9125, 7.4313>
		<-3.4743, 9.0015, 7.4629> <-3.4528, 8.9616, 7.4297> <-3.4338, 8.9454, 7.4330> <-3.4210, 8.9251, 7.4103>
		<-3.4288, 9.0479, 7.4410> <-3.4324, 9.0549, 7.4471> <-3.4392, 8.9746, 7.3899> <-3.4288, 8.9521, 7.3660>
		<-3.4239, 9.0517, 7.4396> <-3.4275, 9.0587, 7.4458> <-3.4036, 9.0028, 7.3791> <-3.3931, 8.9803, 7.3552>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3038, 8.9928, 7.4005> <-3.3192, 9.0052, 7.3799> <-3.3580, 9.0080, 7.3446> <-3.3931, 8.9803, 7.3552>
		<-3.2961, 8.9715, 7.3803> <-3.3115, 8.9839, 7.3597> <-3.3503, 8.9914, 7.3269> <-3.3854, 8.9637, 7.3375>
		<-3.2902, 8.9456, 7.3494> <-3.3038, 8.9579, 7.3349> <-3.3463, 8.9642, 7.3054> <-3.3748, 8.9410, 7.3136>
		<-3.2855, 8.9234, 7.3293> <-3.2991, 8.9358, 7.3148> <-3.3349, 8.9449, 7.2933> <-3.3635, 8.9216, 7.3015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3038, 8.9928, 7.4005> <-3.2961, 8.9715, 7.3803> <-3.2902, 8.9456, 7.3494> <-3.2855, 8.9234, 7.3293>
		<-3.2905, 8.9820, 7.4183> <-3.2828, 8.9607, 7.3981> <-3.2795, 8.9359, 7.3608> <-3.2748, 8.9137, 7.3407>
		<-3.2843, 8.9536, 7.4379> <-3.2700, 8.9171, 7.3901> <-3.2780, 8.9592, 7.4304> <-3.2627, 8.9086, 7.3474>
		<-3.3226, 8.9233, 7.4495> <-3.3083, 8.8868, 7.4018> <-3.3234, 8.9222, 7.4435> <-3.3082, 8.8715, 7.3605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3226, 8.9233, 7.4495> <-3.3083, 8.8868, 7.4018> <-3.3234, 8.9222, 7.4435> <-3.3082, 8.8715, 7.3605>
		<-3.3602, 8.8936, 7.4609> <-3.3460, 8.8570, 7.4132> <-3.3680, 8.8858, 7.4563> <-3.3527, 8.8351, 7.3733>
		<-3.3923, 8.9019, 7.4487> <-3.3803, 8.8829, 7.4274> <-3.3712, 8.8619, 7.3877> <-3.3586, 8.8457, 7.3645>
		<-3.4054, 8.9125, 7.4313> <-3.3933, 8.8934, 7.4100> <-3.3816, 8.8714, 7.3765> <-3.3690, 8.8552, 7.3533>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4054, 8.9125, 7.4313> <-3.3933, 8.8934, 7.4100> <-3.3816, 8.8714, 7.3765> <-3.3690, 8.8552, 7.3533>
		<-3.4210, 8.9251, 7.4103> <-3.4090, 8.9061, 7.3890> <-3.3955, 8.8840, 7.3617> <-3.3829, 8.8678, 7.3385>
		<-3.4288, 8.9521, 7.3660> <-3.4211, 8.9355, 7.3483> <-3.4039, 8.9172, 7.3220> <-3.3925, 8.8979, 7.3099>
		<-3.3931, 8.9803, 7.3552> <-3.3854, 8.9637, 7.3375> <-3.3748, 8.9410, 7.3136> <-3.3635, 8.9216, 7.3015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2855, 8.9234, 7.3293> <-3.2991, 8.9358, 7.3148> <-3.3349, 8.9449, 7.2933> <-3.3635, 8.9216, 7.3015>
		<-3.2832, 8.9127, 7.3196> <-3.2969, 8.9251, 7.3051> <-3.3264, 8.9305, 7.2843> <-3.3550, 8.9072, 7.2925>
		<-3.2776, 8.8971, 7.3065> <-3.2856, 8.9035, 7.2959> <-3.3219, 8.8999, 7.2815> <-3.3402, 8.8858, 7.2867>
		<-3.2807, 8.8836, 7.3016> <-3.2887, 8.8901, 7.2910> <-3.3104, 8.8847, 7.2812> <-3.3287, 8.8706, 7.2865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2855, 8.9234, 7.3293> <-3.2832, 8.9127, 7.3196> <-3.2776, 8.8971, 7.3065> <-3.2807, 8.8836, 7.3016>
		<-3.2748, 8.9137, 7.3407> <-3.2726, 8.9030, 7.3310> <-3.2704, 8.8912, 7.3160> <-3.2734, 8.8778, 7.3112>
		<-3.2627, 8.9086, 7.3474> <-3.2563, 8.8871, 7.3122> <-3.2783, 8.8774, 7.3440> <-3.2765, 8.8650, 7.3181>
		<-3.3082, 8.8715, 7.3605> <-3.3017, 8.8500, 7.3253> <-3.3015, 8.8596, 7.3506> <-3.2997, 8.8472, 7.3247>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3082, 8.8715, 7.3605> <-3.3017, 8.8500, 7.3253> <-3.3015, 8.8596, 7.3506> <-3.2997, 8.8472, 7.3247>
		<-3.3527, 8.8351, 7.3733> <-3.3463, 8.8136, 7.3381> <-3.3247, 8.8417, 7.3572> <-3.3229, 8.8293, 7.3313>
		<-3.3586, 8.8457, 7.3645> <-3.3529, 8.8384, 7.3541> <-3.3482, 8.8306, 7.3381> <-3.3376, 8.8285, 7.3294>
		<-3.3690, 8.8552, 7.3533> <-3.3634, 8.8479, 7.3430> <-3.3555, 8.8364, 7.3286> <-3.3448, 8.8344, 7.3199>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3690, 8.8552, 7.3533> <-3.3634, 8.8479, 7.3430> <-3.3555, 8.8364, 7.3286> <-3.3448, 8.8344, 7.3199>
		<-3.3829, 8.8678, 7.3385> <-3.3773, 8.8605, 7.3281> <-3.3634, 8.8429, 7.3180> <-3.3528, 8.8408, 7.3094>
		<-3.3925, 8.8979, 7.3099> <-3.3840, 8.8834, 7.3008> <-3.3584, 8.8718, 7.2920> <-3.3470, 8.8566, 7.2917>
		<-3.3635, 8.9216, 7.3015> <-3.3550, 8.9072, 7.2925> <-3.3402, 8.8858, 7.2867> <-3.3287, 8.8706, 7.2865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3039, 8.8426, 7.3001> <-3.3109, 8.8372, 7.3021> <-3.3342, 8.8323, 7.3112> <-3.3448, 8.8344, 7.3199>
		<-3.3039, 8.8426, 7.3001> <-3.3082, 8.8351, 7.3056> <-3.3270, 8.8265, 7.3208> <-3.3376, 8.8285, 7.3294>
		<-3.3039, 8.8426, 7.3001> <-3.3082, 8.8351, 7.3056> <-3.3218, 8.8222, 7.3164> <-3.3229, 8.8293, 7.3313>
		<-3.3039, 8.8426, 7.3001> <-3.3012, 8.8404, 7.3036> <-3.2986, 8.8400, 7.3098> <-3.2997, 8.8472, 7.3247>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3039, 8.8426, 7.3001> <-3.3081, 8.8460, 7.2945> <-3.3215, 8.8611, 7.2863> <-3.3287, 8.8706, 7.2865>
		<-3.3039, 8.8426, 7.3001> <-3.3151, 8.8407, 7.2965> <-3.3398, 8.8470, 7.2915> <-3.3470, 8.8566, 7.2917>
		<-3.3039, 8.8426, 7.3001> <-3.3151, 8.8407, 7.2965> <-3.3422, 8.8388, 7.3007> <-3.3528, 8.8408, 7.3094>
		<-3.3039, 8.8426, 7.3001> <-3.3109, 8.8372, 7.3021> <-3.3342, 8.8323, 7.3112> <-3.3448, 8.8344, 7.3199>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3039, 8.8426, 7.3001> <-3.2967, 8.8481, 7.2980> <-3.2837, 8.8706, 7.2969> <-3.2807, 8.8836, 7.3016>
		<-3.3039, 8.8426, 7.3001> <-3.3010, 8.8515, 7.2925> <-3.2917, 8.8771, 7.2863> <-3.2887, 8.8901, 7.2910>
		<-3.3039, 8.8426, 7.3001> <-3.3010, 8.8515, 7.2925> <-3.3032, 8.8751, 7.2811> <-3.3104, 8.8847, 7.2812>
		<-3.3039, 8.8426, 7.3001> <-3.3081, 8.8460, 7.2945> <-3.3215, 8.8611, 7.2863> <-3.3287, 8.8706, 7.2865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3039, 8.8426, 7.3001> <-3.3012, 8.8404, 7.3036> <-3.2986, 8.8400, 7.3098> <-3.2997, 8.8472, 7.3247>
		<-3.3039, 8.8426, 7.3001> <-3.2940, 8.8459, 7.3016> <-3.2754, 8.8579, 7.3032> <-3.2765, 8.8650, 7.3181>
		<-3.3039, 8.8426, 7.3001> <-3.2940, 8.8459, 7.3016> <-3.2764, 8.8648, 7.3064> <-3.2734, 8.8778, 7.3112>
		<-3.3039, 8.8426, 7.3001> <-3.2967, 8.8481, 7.2980> <-3.2837, 8.8706, 7.2969> <-3.2807, 8.8836, 7.3016>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6594, 9.3157, 7.7924> <-3.6728, 9.3227, 7.7629> <-3.7256, 9.3426, 7.7332> <-3.7685, 9.3154, 7.7496>
		<-3.6483, 9.3001, 7.7881> <-3.6617, 9.3072, 7.7585> <-3.7110, 9.3236, 7.7229> <-3.7540, 9.2964, 7.7394>
		<-3.6377, 9.2799, 7.7738> <-3.6526, 9.2904, 7.7474> <-3.6997, 9.3022, 7.7095> <-3.7394, 9.2712, 7.7197>
		<-3.6289, 9.2655, 7.7640> <-3.6438, 9.2759, 7.7376> <-3.6868, 9.2822, 7.6988> <-3.7266, 9.2512, 7.7090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6594, 9.3157, 7.7924> <-3.6862, 9.3533, 7.8031> <-3.7532, 9.4402, 7.8126> <-3.7541, 9.4405, 7.8135>
		<-3.6728, 9.3227, 7.7629> <-3.6997, 9.3603, 7.7735> <-3.7529, 9.4409, 7.8154> <-3.7538, 9.4412, 7.8163>
		<-3.7256, 9.3426, 7.7332> <-3.7333, 9.3526, 7.7386> <-3.7439, 9.3569, 7.7493> <-3.7519, 9.3679, 7.7516>
		<-3.7685, 9.3154, 7.7496> <-3.7762, 9.3255, 7.7551> <-3.7920, 9.3361, 7.7582> <-3.8000, 9.3470, 7.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6594, 9.3157, 7.7924> <-3.6466, 9.3090, 7.8206> <-3.6800, 9.2986, 7.8790> <-3.7055, 9.2825, 7.8887>
		<-3.6862, 9.3533, 7.8031> <-3.6735, 9.3466, 7.8313> <-3.7017, 9.3308, 7.8980> <-3.7271, 9.3147, 7.9077>
		<-3.7532, 9.4402, 7.8126> <-3.7536, 9.4394, 7.8090> <-3.7190, 9.3720, 7.9298> <-3.7568, 9.3556, 7.9368>
		<-3.7541, 9.4405, 7.8135> <-3.7545, 9.4397, 7.8099> <-3.7435, 9.4054, 7.9420> <-3.7813, 9.3890, 7.9491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6594, 9.3157, 7.7924> <-3.6483, 9.3001, 7.7881> <-3.6377, 9.2799, 7.7738> <-3.6289, 9.2655, 7.7640>
		<-3.6466, 9.3090, 7.8206> <-3.6355, 9.2935, 7.8163> <-3.6244, 9.2705, 7.7975> <-3.6156, 9.2561, 7.7877>
		<-3.6800, 9.2986, 7.8790> <-3.6635, 9.2741, 7.8645> <-3.6464, 9.2417, 7.8491> <-3.6320, 9.2177, 7.8319>
		<-3.7055, 9.2825, 7.8887> <-3.6890, 9.2580, 7.8743> <-3.6687, 9.2243, 7.8548> <-3.6542, 9.2003, 7.8376>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7055, 9.2825, 7.8887> <-3.7289, 9.2676, 7.8977> <-3.7723, 9.2307, 7.8663> <-3.7841, 9.2368, 7.8403>
		<-3.7271, 9.3147, 7.9077> <-3.7506, 9.2998, 7.9168> <-3.8093, 9.2720, 7.8771> <-3.8211, 9.2782, 7.8511>
		<-3.7568, 9.3556, 7.9368> <-3.8012, 9.3364, 7.9451> <-3.9135, 9.3692, 7.8437> <-3.9136, 9.3690, 7.8426>
		<-3.7813, 9.3890, 7.9491> <-3.8257, 9.3698, 7.9574> <-3.9175, 9.3700, 7.8451> <-3.9176, 9.3698, 7.8441>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7055, 9.2825, 7.8887> <-3.6890, 9.2580, 7.8743> <-3.6687, 9.2243, 7.8548> <-3.6542, 9.2003, 7.8376>
		<-3.7289, 9.2676, 7.8977> <-3.7125, 9.2432, 7.8833> <-3.6912, 9.2067, 7.8606> <-3.6768, 9.1827, 7.8434>
		<-3.7723, 9.2307, 7.8663> <-3.7553, 9.2116, 7.8614> <-3.7420, 9.1847, 7.8316> <-3.7305, 9.1660, 7.8175>
		<-3.7841, 9.2368, 7.8403> <-3.7670, 9.2177, 7.8354> <-3.7555, 9.1943, 7.8075> <-3.7440, 9.1755, 7.7935>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7841, 9.2368, 7.8403> <-3.7670, 9.2177, 7.8354> <-3.7555, 9.1943, 7.8075> <-3.7440, 9.1755, 7.7935>
		<-3.7980, 9.2440, 7.8098> <-3.7809, 9.2250, 7.8048> <-3.7706, 9.2049, 7.7807> <-3.7591, 9.1861, 7.7667>
		<-3.8129, 9.2874, 7.7667> <-3.7983, 9.2684, 7.7564> <-3.7798, 9.2397, 7.7300> <-3.7669, 9.2197, 7.7193>
		<-3.7685, 9.3154, 7.7496> <-3.7540, 9.2964, 7.7394> <-3.7394, 9.2712, 7.7197> <-3.7266, 9.2512, 7.7090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7841, 9.2368, 7.8403> <-3.7980, 9.2440, 7.8098> <-3.8129, 9.2874, 7.7667> <-3.7685, 9.3154, 7.7496>
		<-3.8211, 9.2782, 7.8511> <-3.8349, 9.2854, 7.8206> <-3.8206, 9.2975, 7.7721> <-3.7762, 9.3255, 7.7551>
		<-3.9136, 9.3690, 7.8426> <-3.9137, 9.3688, 7.8418> <-3.8521, 9.3100, 7.7695> <-3.7920, 9.3361, 7.7582>
		<-3.9176, 9.3698, 7.8441> <-3.9177, 9.3696, 7.8432> <-3.8601, 9.3210, 7.7718> <-3.8000, 9.3470, 7.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6289, 9.2655, 7.7640> <-3.6438, 9.2759, 7.7376> <-3.6868, 9.2822, 7.6988> <-3.7266, 9.2512, 7.7090>
		<-3.6151, 9.2427, 7.7485> <-3.6299, 9.2531, 7.7222> <-3.6714, 9.2582, 7.6860> <-3.7111, 9.2271, 7.6961>
		<-3.5964, 9.2145, 7.7251> <-3.6099, 9.2235, 7.7018> <-3.6640, 9.1702, 7.6665> <-3.6717, 9.1643, 7.6685>
		<-3.5840, 9.1919, 7.7083> <-3.5976, 9.2008, 7.6850> <-3.6667, 9.1746, 7.6694> <-3.6744, 9.1688, 7.6714>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6289, 9.2655, 7.7640> <-3.6151, 9.2427, 7.7485> <-3.5964, 9.2145, 7.7251> <-3.5840, 9.1919, 7.7083>
		<-3.6156, 9.2561, 7.7877> <-3.6018, 9.2333, 7.7722> <-3.5830, 9.2057, 7.7481> <-3.5707, 9.1830, 7.7313>
		<-3.6320, 9.2177, 7.8319> <-3.6185, 9.1951, 7.8158> <-3.6038, 9.1665, 7.7891> <-3.5906, 9.1443, 7.7723>
		<-3.6542, 9.2003, 7.8376> <-3.6407, 9.1777, 7.8215> <-3.6256, 9.1499, 7.7949> <-3.6125, 9.1277, 7.7781>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6542, 9.2003, 7.8376> <-3.6407, 9.1777, 7.8215> <-3.6256, 9.1499, 7.7949> <-3.6125, 9.1277, 7.7781>
		<-3.6768, 9.1827, 7.8434> <-3.6633, 9.1601, 7.8273> <-3.6478, 9.1331, 7.8008> <-3.6346, 9.1108, 7.7839>
		<-3.7305, 9.1660, 7.8175> <-3.7172, 9.1444, 7.8013> <-3.7018, 9.1146, 7.7791> <-3.6880, 9.0934, 7.7627>
		<-3.7440, 9.1755, 7.7935> <-3.7307, 9.1539, 7.7772> <-3.7154, 9.1236, 7.7557> <-3.7016, 9.1024, 7.7394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7440, 9.1755, 7.7935> <-3.7307, 9.1539, 7.7772> <-3.7154, 9.1236, 7.7557> <-3.7016, 9.1024, 7.7394>
		<-3.7591, 9.1861, 7.7667> <-3.7458, 9.1645, 7.7504> <-3.7287, 9.1325, 7.7328> <-3.7149, 9.1113, 7.7164>
		<-3.7669, 9.2197, 7.7193> <-3.7515, 9.1956, 7.7065> <-3.6792, 9.1586, 7.6705> <-3.6819, 9.1630, 7.6734>
		<-3.7266, 9.2512, 7.7090> <-3.7111, 9.2271, 7.6961> <-3.6717, 9.1643, 7.6685> <-3.6744, 9.1688, 7.6714>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5840, 9.1919, 7.7083> <-3.5976, 9.2008, 7.6850> <-3.6667, 9.1746, 7.6694> <-3.6744, 9.1688, 7.6714>
		<-3.5724, 9.1704, 7.6924> <-3.5859, 9.1794, 7.6691> <-3.6685, 9.1776, 7.6713> <-3.6762, 9.1718, 7.6733>
		<-3.5583, 9.1380, 7.6747> <-3.5757, 9.1542, 7.6573> <-3.6201, 9.1650, 7.6287> <-3.6561, 9.1363, 7.6391>
		<-3.5490, 9.1185, 7.6552> <-3.5663, 9.1347, 7.6378> <-3.6123, 9.1509, 7.6151> <-3.6483, 9.1221, 7.6255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5840, 9.1919, 7.7083> <-3.5724, 9.1704, 7.6924> <-3.5583, 9.1380, 7.6747> <-3.5490, 9.1185, 7.6552>
		<-3.5707, 9.1830, 7.7313> <-3.5590, 9.1615, 7.7154> <-3.5415, 9.1223, 7.6915> <-3.5322, 9.1029, 7.6720>
		<-3.5906, 9.1443, 7.7723> <-3.5751, 9.1180, 7.7524> <-3.5495, 9.0798, 7.7335> <-3.5370, 9.0559, 7.7089>
		<-3.6125, 9.1277, 7.7781> <-3.5969, 9.1014, 7.7582> <-3.5712, 9.0624, 7.7398> <-3.5587, 9.0386, 7.7152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6125, 9.1277, 7.7781> <-3.5969, 9.1014, 7.7582> <-3.5712, 9.0624, 7.7398> <-3.5587, 9.0386, 7.7152>
		<-3.6346, 9.1108, 7.7839> <-3.6191, 9.0845, 7.7640> <-3.5925, 9.0454, 7.7460> <-3.5800, 9.0215, 7.7214>
		<-3.6880, 9.0934, 7.7627> <-3.6744, 9.0725, 7.7466> <-3.6467, 9.0390, 7.7221> <-3.6363, 9.0200, 7.7018>
		<-3.7016, 9.1024, 7.7394> <-3.6880, 9.0815, 7.7232> <-3.6632, 9.0544, 7.7056> <-3.6528, 9.0354, 7.6853>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7016, 9.1024, 7.7394> <-3.6880, 9.0815, 7.7232> <-3.6632, 9.0544, 7.7056> <-3.6528, 9.0354, 7.6853>
		<-3.7149, 9.1113, 7.7164> <-3.7013, 9.0904, 7.7003> <-3.6808, 9.0709, 7.6879> <-3.6704, 9.0519, 7.6676>
		<-3.6819, 9.1630, 7.6734> <-3.6838, 9.1660, 7.6753> <-3.6926, 9.1070, 7.6498> <-3.6848, 9.0929, 7.6361>
		<-3.6744, 9.1688, 7.6714> <-3.6762, 9.1718, 7.6733> <-3.6561, 9.1363, 7.6391> <-3.6483, 9.1221, 7.6255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5490, 9.1185, 7.6552> <-3.5663, 9.1347, 7.6378> <-3.6123, 9.1509, 7.6151> <-3.6483, 9.1221, 7.6255>
		<-3.5386, 9.0970, 7.6335> <-3.5560, 9.1131, 7.6162> <-3.5999, 9.1283, 7.5933> <-3.6358, 9.0996, 7.6038>
		<-3.5322, 9.0878, 7.6156> <-3.5585, 9.1123, 7.5893> <-3.5995, 9.0447, 7.5447> <-3.6042, 9.0409, 7.5458>
		<-3.5191, 9.0565, 7.5726> <-3.5454, 9.0810, 7.5463> <-3.6021, 9.0503, 7.5524> <-3.6068, 9.0465, 7.5535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5490, 9.1185, 7.6552> <-3.5386, 9.0970, 7.6335> <-3.5322, 9.0878, 7.6156> <-3.5191, 9.0565, 7.5726>
		<-3.5322, 9.1029, 7.6720> <-3.5218, 9.0813, 7.6503> <-3.5046, 9.0621, 7.6432> <-3.4915, 9.0308, 7.6002>
		<-3.5370, 9.0559, 7.7089> <-3.5257, 9.0343, 7.6867> <-3.5205, 9.0128, 7.6484> <-3.5141, 8.9958, 7.6208>
		<-3.5587, 9.0386, 7.7152> <-3.5474, 9.0169, 7.6930> <-3.5412, 8.9964, 7.6531> <-3.5349, 8.9794, 7.6255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5587, 9.0386, 7.7152> <-3.5474, 9.0169, 7.6930> <-3.5412, 8.9964, 7.6531> <-3.5349, 8.9794, 7.6255>
		<-3.5800, 9.0215, 7.7214> <-3.5687, 8.9999, 7.6992> <-3.5629, 8.9793, 7.6580> <-3.5565, 8.9623, 7.6304>
		<-3.6363, 9.0200, 7.7018> <-3.6245, 8.9984, 7.6788> <-3.6148, 8.9742, 7.6717> <-3.6003, 8.9426, 7.6262>
		<-3.6528, 9.0354, 7.6853> <-3.6410, 9.0138, 7.6622> <-3.6436, 9.0010, 7.6429> <-3.6291, 8.9694, 7.5974>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6528, 9.0354, 7.6853> <-3.6410, 9.0138, 7.6622> <-3.6436, 9.0010, 7.6429> <-3.6291, 8.9694, 7.5974>
		<-3.6704, 9.0519, 7.6676> <-3.6587, 9.0302, 7.6446> <-3.6702, 9.0258, 7.6163> <-3.6557, 8.9942, 7.5707>
		<-3.6848, 9.0929, 7.6361> <-3.6724, 9.0703, 7.6144> <-3.6090, 9.0371, 7.5469> <-3.6116, 9.0427, 7.5545>
		<-3.6483, 9.1221, 7.6255> <-3.6358, 9.0996, 7.6038> <-3.6042, 9.0409, 7.5458> <-3.6068, 9.0465, 7.5535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5191, 9.0565, 7.5726> <-3.5454, 9.0810, 7.5463> <-3.6021, 9.0503, 7.5524> <-3.6068, 9.0465, 7.5535>
		<-3.5066, 9.0266, 7.5315> <-3.5328, 9.0511, 7.5052> <-3.6045, 9.0554, 7.5594> <-3.6092, 9.0517, 7.5605>
		<-3.5020, 9.0145, 7.5164> <-3.5191, 9.0323, 7.5033> <-3.5636, 9.0439, 7.4798> <-3.5979, 9.0160, 7.4883>
		<-3.4987, 8.9984, 7.4903> <-3.5158, 9.0162, 7.4772> <-3.5587, 9.0296, 7.4527> <-3.5929, 9.0017, 7.4612>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5191, 9.0565, 7.5726> <-3.5066, 9.0266, 7.5315> <-3.5020, 9.0145, 7.5164> <-3.4987, 8.9984, 7.4903>
		<-3.4915, 9.0308, 7.6002> <-3.4790, 9.0008, 7.5591> <-3.4871, 8.9988, 7.5279> <-3.4837, 8.9828, 7.5018>
		<-3.5141, 8.9958, 7.6208> <-3.5070, 8.9770, 7.5903> <-3.4810, 8.9775, 7.5791> <-3.4758, 8.9502, 7.5124>
		<-3.5349, 8.9794, 7.6255> <-3.5278, 8.9606, 7.5950> <-3.5191, 8.9466, 7.5885> <-3.5138, 8.9193, 7.5217>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5349, 8.9794, 7.6255> <-3.5278, 8.9606, 7.5950> <-3.5191, 8.9466, 7.5885> <-3.5138, 8.9193, 7.5217>
		<-3.5565, 8.9623, 7.6304> <-3.5494, 8.9435, 7.5999> <-3.5566, 8.9162, 7.5977> <-3.5513, 8.8889, 7.5310>
		<-3.6003, 8.9426, 7.6262> <-3.5872, 8.9138, 7.5848> <-3.5914, 8.9148, 7.5530> <-3.5839, 8.9018, 7.5262>
		<-3.6291, 8.9694, 7.5974> <-3.6159, 8.9407, 7.5560> <-3.6062, 8.9302, 7.5417> <-3.5986, 8.9172, 7.5149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6291, 8.9694, 7.5974> <-3.6159, 8.9407, 7.5560> <-3.6062, 8.9302, 7.5417> <-3.5986, 8.9172, 7.5149>
		<-3.6557, 8.9942, 7.5707> <-3.6425, 8.9655, 7.5293> <-3.6236, 8.9483, 7.5284> <-3.6160, 8.9354, 7.5016>
		<-3.6116, 9.0427, 7.5545> <-3.6140, 9.0479, 7.5616> <-3.6327, 8.9877, 7.4969> <-3.6277, 8.9734, 7.4698>
		<-3.6068, 9.0465, 7.5535> <-3.6092, 9.0517, 7.5605> <-3.5979, 9.0160, 7.4883> <-3.5929, 9.0017, 7.4612>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4987, 8.9984, 7.4903> <-3.5158, 9.0162, 7.4772> <-3.5587, 9.0296, 7.4527> <-3.5929, 9.0017, 7.4612>
		<-3.4956, 8.9835, 7.4660> <-3.5127, 9.0013, 7.4529> <-3.5548, 9.0185, 7.4317> <-3.5890, 8.9906, 7.4401>
		<-3.4973, 8.9688, 7.4302> <-3.5117, 8.9849, 7.4224> <-3.5570, 9.0000, 7.4042> <-3.5850, 8.9768, 7.4105>
		<-3.4976, 8.9538, 7.4057> <-3.5121, 8.9699, 7.3979> <-3.5493, 8.9851, 7.3869> <-3.5773, 8.9619, 7.3932>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4987, 8.9984, 7.4903> <-3.4956, 8.9835, 7.4660> <-3.4973, 8.9688, 7.4302> <-3.4976, 8.9538, 7.4057>
		<-3.4837, 8.9828, 7.5018> <-3.4806, 8.9678, 7.4775> <-3.4859, 8.9563, 7.4363> <-3.4863, 8.9413, 7.4118>
		<-3.4758, 8.9502, 7.5124> <-3.4715, 8.9278, 7.4577> <-3.4713, 8.9574, 7.5060> <-3.4743, 8.9343, 7.4146>
		<-3.5138, 8.9193, 7.5217> <-3.5095, 8.8969, 7.4671> <-3.5160, 8.9204, 7.5161> <-3.5190, 8.8972, 7.4246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5138, 8.9193, 7.5217> <-3.5095, 8.8969, 7.4671> <-3.5160, 8.9204, 7.5161> <-3.5190, 8.8972, 7.4246>
		<-3.5513, 8.8889, 7.5310> <-3.5470, 8.8665, 7.4763> <-3.5600, 8.8839, 7.5259> <-3.5630, 8.8608, 7.4345>
		<-3.5839, 8.9018, 7.5262> <-3.5767, 8.8894, 7.5006> <-3.5764, 8.8818, 7.4573> <-3.5691, 8.8731, 7.4302>
		<-3.5986, 8.9172, 7.5149> <-3.5914, 8.9048, 7.4893> <-3.5875, 8.8942, 7.4513> <-3.5802, 8.8854, 7.4242>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5986, 8.9172, 7.5149> <-3.5914, 8.9048, 7.4893> <-3.5875, 8.8942, 7.4513> <-3.5802, 8.8854, 7.4242>
		<-3.6160, 8.9354, 7.5016> <-3.6088, 8.9229, 7.4760> <-3.6022, 8.9105, 7.4434> <-3.5950, 8.9018, 7.4163>
		<-3.6277, 8.9734, 7.4698> <-3.6239, 8.9623, 7.4487> <-3.6135, 8.9532, 7.4169> <-3.6059, 8.9383, 7.3996>
		<-3.5929, 9.0017, 7.4612> <-3.5890, 8.9906, 7.4401> <-3.5850, 8.9768, 7.4105> <-3.5773, 8.9619, 7.3932>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4976, 8.9538, 7.4057> <-3.5121, 8.9699, 7.3979> <-3.5493, 8.9851, 7.3869> <-3.5773, 8.9619, 7.3932>
		<-3.4978, 8.9466, 7.3939> <-3.5123, 8.9627, 7.3861> <-3.5431, 8.9730, 7.3728> <-3.5711, 8.9498, 7.3791>
		<-3.4956, 8.9356, 7.3771> <-3.5041, 8.9441, 7.3698> <-3.5406, 8.9436, 7.3618> <-3.5581, 8.9298, 7.3659>
		<-3.5006, 8.9247, 7.3699> <-3.5091, 8.9333, 7.3627> <-3.5305, 8.9281, 7.3553> <-3.5480, 8.9143, 7.3594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4976, 8.9538, 7.4057> <-3.4978, 8.9466, 7.3939> <-3.4956, 8.9356, 7.3771> <-3.5006, 8.9247, 7.3699>
		<-3.4863, 8.9413, 7.4118> <-3.4865, 8.9340, 7.4000> <-3.4877, 8.9276, 7.3839> <-3.4926, 8.9168, 7.3767>
		<-3.4743, 8.9343, 7.4146> <-3.4756, 8.9246, 7.3763> <-3.4917, 8.9070, 7.4061> <-3.4956, 8.9025, 7.3795>
		<-3.5190, 8.8972, 7.4246> <-3.5203, 8.8875, 7.3863> <-3.5145, 8.8891, 7.4114> <-3.5184, 8.8846, 7.3848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5190, 8.8972, 7.4246> <-3.5203, 8.8875, 7.3863> <-3.5145, 8.8891, 7.4114> <-3.5184, 8.8846, 7.3848>
		<-3.5630, 8.8608, 7.4345> <-3.5643, 8.8511, 7.3962> <-3.5373, 8.8712, 7.4168> <-3.5412, 8.8667, 7.3902>
		<-3.5691, 8.8731, 7.4302> <-3.5659, 8.8691, 7.4181> <-3.5642, 8.8670, 7.4018> <-3.5558, 8.8672, 7.3916>
		<-3.5802, 8.8854, 7.4242> <-3.5770, 8.8815, 7.4121> <-3.5721, 8.8749, 7.3950> <-3.5637, 8.8751, 7.3848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5802, 8.8854, 7.4242> <-3.5770, 8.8815, 7.4121> <-3.5721, 8.8749, 7.3950> <-3.5637, 8.8751, 7.3848>
		<-3.5950, 8.9018, 7.4163> <-3.5917, 8.8978, 7.4041> <-3.5806, 8.8834, 7.3877> <-3.5722, 8.8836, 7.3776>
		<-3.6059, 8.9383, 7.3996> <-3.5997, 8.9262, 7.3855> <-3.5754, 8.9162, 7.3700> <-3.5653, 8.9007, 7.3635>
		<-3.5773, 8.9619, 7.3932> <-3.5711, 8.9498, 7.3791> <-3.5581, 8.9298, 7.3659> <-3.5480, 8.9143, 7.3594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5282, 8.8865, 7.3614> <-3.5348, 8.8812, 7.3630> <-3.5553, 8.8753, 7.3746> <-3.5637, 8.8751, 7.3848>
		<-3.5282, 8.8865, 7.3614> <-3.5318, 8.8782, 7.3656> <-3.5474, 8.8673, 7.3814> <-3.5558, 8.8672, 7.3916>
		<-3.5282, 8.8865, 7.3614> <-3.5318, 8.8782, 7.3656> <-3.5435, 8.8640, 7.3740> <-3.5412, 8.8667, 7.3902>
		<-3.5282, 8.8865, 7.3614> <-3.5252, 8.8835, 7.3640> <-3.5207, 8.8819, 7.3686> <-3.5184, 8.8846, 7.3848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5282, 8.8865, 7.3614> <-3.5322, 8.8905, 7.3579> <-3.5427, 8.9062, 7.3560> <-3.5480, 8.9143, 7.3594>
		<-3.5282, 8.8865, 7.3614> <-3.5389, 8.8853, 7.3595> <-3.5601, 8.8926, 7.3601> <-3.5653, 8.9007, 7.3635>
		<-3.5282, 8.8865, 7.3614> <-3.5389, 8.8853, 7.3595> <-3.5637, 8.8838, 7.3674> <-3.5722, 8.8836, 7.3776>
		<-3.5282, 8.8865, 7.3614> <-3.5348, 8.8812, 7.3630> <-3.5553, 8.8753, 7.3746> <-3.5637, 8.8751, 7.3848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5282, 8.8865, 7.3614> <-3.5209, 8.8922, 7.3597> <-3.5056, 8.9135, 7.3626> <-3.5006, 8.9247, 7.3699>
		<-3.5282, 8.8865, 7.3614> <-3.5250, 8.8962, 7.3562> <-3.5142, 8.9220, 7.3553> <-3.5091, 8.9333, 7.3627>
		<-3.5282, 8.8865, 7.3614> <-3.5250, 8.8962, 7.3562> <-3.5252, 8.9200, 7.3519> <-3.5305, 8.9281, 7.3553>
		<-3.5282, 8.8865, 7.3614> <-3.5322, 8.8905, 7.3579> <-3.5427, 8.9062, 7.3560> <-3.5480, 8.9143, 7.3594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5282, 8.8865, 7.3614> <-3.5252, 8.8835, 7.3640> <-3.5207, 8.8819, 7.3686> <-3.5184, 8.8846, 7.3848>
		<-3.5282, 8.8865, 7.3614> <-3.5179, 8.8892, 7.3623> <-3.4979, 8.8998, 7.3632> <-3.4956, 8.9025, 7.3795>
		<-3.5282, 8.8865, 7.3614> <-3.5179, 8.8892, 7.3623> <-3.4977, 8.9055, 7.3694> <-3.4926, 8.9168, 7.3767>
		<-3.5282, 8.8865, 7.3614> <-3.5209, 8.8922, 7.3597> <-3.5056, 8.9135, 7.3626> <-3.5006, 8.9247, 7.3699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8151, 9.2431, 7.8514> <-3.8256, 9.2502, 7.8226> <-3.8553, 9.2551, 7.7714> <-3.8950, 9.2246, 7.7770>
		<-3.7971, 9.2184, 7.8443> <-3.8076, 9.2255, 7.8155> <-3.8411, 9.2365, 7.7647> <-3.8809, 9.2060, 7.7703>
		<-3.7876, 9.1945, 7.8037> <-3.7969, 9.2027, 7.7838> <-3.8331, 9.2035, 7.7510> <-3.8622, 9.1814, 7.7607>
		<-3.7736, 9.1721, 7.7869> <-3.7830, 9.1802, 7.7670> <-3.8195, 9.1851, 7.7429> <-3.8486, 9.1630, 7.7526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8151, 9.2431, 7.8514> <-3.8432, 9.2816, 7.8625> <-3.9210, 9.3705, 7.8453> <-3.9176, 9.3698, 7.8441>
		<-3.8256, 9.2502, 7.8226> <-3.8536, 9.2887, 7.8338> <-3.9209, 9.3703, 7.8446> <-3.9175, 9.3696, 7.8434>
		<-3.8553, 9.2551, 7.7714> <-3.8670, 9.2704, 7.7770> <-3.8959, 9.3006, 7.7722> <-3.9097, 9.3146, 7.7763>
		<-3.8950, 9.2246, 7.7770> <-3.9067, 9.2399, 7.7826> <-3.9208, 9.2620, 7.7895> <-3.9346, 9.2760, 7.7936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8151, 9.2431, 7.8514> <-3.8079, 9.2383, 7.8713> <-3.8334, 9.2079, 7.8968> <-3.8505, 9.1947, 7.8992>
		<-3.8432, 9.2816, 7.8625> <-3.8359, 9.2768, 7.8824> <-3.8625, 9.2437, 7.9135> <-3.8796, 9.2306, 7.9159>
		<-3.9210, 9.3705, 7.8453> <-3.9211, 9.3706, 7.8461> <-3.9020, 9.3050, 7.9269> <-3.9203, 9.2765, 7.9397>
		<-3.9176, 9.3698, 7.8441> <-3.9177, 9.3699, 7.8448> <-3.9349, 9.3394, 7.9389> <-3.9533, 9.3109, 7.9517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8151, 9.2431, 7.8514> <-3.7971, 9.2184, 7.8443> <-3.7876, 9.1945, 7.8037> <-3.7736, 9.1721, 7.7869>
		<-3.8079, 9.2383, 7.8713> <-3.7899, 9.2136, 7.8642> <-3.7768, 9.1852, 7.8267> <-3.7629, 9.1627, 7.8099>
		<-3.8334, 9.2079, 7.8968> <-3.8156, 9.1859, 7.8865> <-3.7904, 9.1558, 7.8708> <-3.7765, 9.1343, 7.8551>
		<-3.8505, 9.1947, 7.8992> <-3.8327, 9.1728, 7.8890> <-3.8112, 9.1400, 7.8777> <-3.7973, 9.1185, 7.8620>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8505, 9.1947, 7.8992> <-3.8680, 9.1813, 7.9016> <-3.9078, 9.1614, 7.8858> <-3.9152, 9.1664, 7.8655>
		<-3.8796, 9.2306, 7.9159> <-3.8971, 9.2172, 7.9184> <-3.9293, 9.1872, 7.8991> <-3.9367, 9.1922, 7.8788>
		<-3.9203, 9.2765, 7.9397> <-3.9331, 9.2567, 7.9486> <-3.9709, 9.2327, 7.9164> <-3.9680, 9.2273, 7.8919>
		<-3.9533, 9.3109, 7.9517> <-3.9661, 9.2911, 7.9606> <-3.9955, 9.2589, 7.9206> <-3.9926, 9.2535, 7.8961>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8505, 9.1947, 7.8992> <-3.8327, 9.1728, 7.8890> <-3.8112, 9.1400, 7.8777> <-3.7973, 9.1185, 7.8620>
		<-3.8680, 9.1813, 7.9016> <-3.8502, 9.1593, 7.8914> <-3.8295, 9.1261, 7.8838> <-3.8155, 9.1046, 7.8681>
		<-3.9078, 9.1614, 7.8858> <-3.8910, 9.1412, 7.8754> <-3.8703, 9.1129, 7.8533> <-3.8567, 9.0935, 7.8378>
		<-3.9152, 9.1664, 7.8655> <-3.8983, 9.1462, 7.8551> <-3.8797, 9.1211, 7.8331> <-3.8662, 9.1017, 7.8177>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9152, 9.1664, 7.8655> <-3.8983, 9.1462, 7.8551> <-3.8797, 9.1211, 7.8331> <-3.8662, 9.1017, 7.8177>
		<-3.9253, 9.1732, 7.8375> <-3.9085, 9.1530, 7.8271> <-3.8900, 9.1300, 7.8112> <-3.8764, 9.1107, 7.7957>
		<-3.9337, 9.1949, 7.7825> <-3.9196, 9.1763, 7.7757> <-3.8941, 9.1571, 7.7713> <-3.8805, 9.1387, 7.7632>
		<-3.8950, 9.2246, 7.7770> <-3.8809, 9.2060, 7.7703> <-3.8622, 9.1814, 7.7607> <-3.8486, 9.1630, 7.7526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9152, 9.1664, 7.8655> <-3.9253, 9.1732, 7.8375> <-3.9337, 9.1949, 7.7825> <-3.8950, 9.2246, 7.7770>
		<-3.9367, 9.1922, 7.8788> <-3.9469, 9.1990, 7.8509> <-3.9454, 9.2102, 7.7880> <-3.9067, 9.2399, 7.7826>
		<-3.9680, 9.2273, 7.8919> <-3.9641, 9.2200, 7.8590> <-3.9485, 9.2190, 7.8087> <-3.9208, 9.2620, 7.7895>
		<-3.9926, 9.2535, 7.8961> <-3.9887, 9.2462, 7.8632> <-3.9623, 9.2330, 7.8128> <-3.9346, 9.2760, 7.7936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7736, 9.1721, 7.7869> <-3.7830, 9.1802, 7.7670> <-3.8195, 9.1851, 7.7429> <-3.8486, 9.1630, 7.7526>
		<-3.7640, 9.1565, 7.7753> <-3.7733, 9.1647, 7.7554> <-3.8126, 9.1758, 7.7388> <-3.8417, 9.1537, 7.7484>
		<-3.7436, 9.1305, 7.7732> <-3.7588, 9.1483, 7.7608> <-3.8184, 9.1360, 7.7333> <-3.8260, 9.1310, 7.7346>
		<-3.7370, 9.1174, 7.7574> <-3.7522, 9.1352, 7.7449> <-3.8193, 9.1374, 7.7349> <-3.8269, 9.1324, 7.7362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7736, 9.1721, 7.7869> <-3.7640, 9.1565, 7.7753> <-3.7436, 9.1305, 7.7732> <-3.7370, 9.1174, 7.7574>
		<-3.7629, 9.1627, 7.8099> <-3.7532, 9.1472, 7.7983> <-3.7308, 9.1154, 7.7838> <-3.7241, 9.1022, 7.7679>
		<-3.7765, 9.1343, 7.8551> <-3.7619, 9.1117, 7.8387> <-3.7473, 9.0804, 7.8144> <-3.7381, 9.0620, 7.7905>
		<-3.7973, 9.1185, 7.8620> <-3.7827, 9.0959, 7.8456> <-3.7658, 9.0681, 7.8177> <-3.7566, 9.0498, 7.7938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7973, 9.1185, 7.8620> <-3.7827, 9.0959, 7.8456> <-3.7658, 9.0681, 7.8177> <-3.7566, 9.0498, 7.7938>
		<-3.8155, 9.1046, 7.8681> <-3.8009, 9.0820, 7.8517> <-3.7849, 9.0556, 7.8210> <-3.7757, 9.0372, 7.7971>
		<-3.8567, 9.0935, 7.8378> <-3.8464, 9.0787, 7.8260> <-3.8286, 9.0491, 7.8022> <-3.8225, 9.0369, 7.7854>
		<-3.8662, 9.1017, 7.8177> <-3.8558, 9.0868, 7.8058> <-3.8418, 9.0646, 7.7914> <-3.8357, 9.0524, 7.7746>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8662, 9.1017, 7.8177> <-3.8558, 9.0868, 7.8058> <-3.8418, 9.0646, 7.7914> <-3.8357, 9.0524, 7.7746>
		<-3.8764, 9.1107, 7.7957> <-3.8661, 9.0958, 7.7839> <-3.8563, 9.0816, 7.7796> <-3.8501, 9.0694, 7.7628>
		<-3.8805, 9.1387, 7.7632> <-3.8736, 9.1294, 7.7591> <-3.8333, 9.1262, 7.7359> <-3.8341, 9.1276, 7.7375>
		<-3.8486, 9.1630, 7.7526> <-3.8417, 9.1537, 7.7484> <-3.8260, 9.1310, 7.7346> <-3.8269, 9.1324, 7.7362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7370, 9.1174, 7.7574> <-3.7522, 9.1352, 7.7449> <-3.8193, 9.1374, 7.7349> <-3.8269, 9.1324, 7.7362>
		<-3.7277, 9.0990, 7.7352> <-3.7429, 9.1169, 7.7227> <-3.8209, 9.1402, 7.7382> <-3.8285, 9.1352, 7.7395>
		<-3.7279, 9.0873, 7.6941> <-3.7416, 9.1056, 7.6864> <-3.7822, 9.1277, 7.6826> <-3.8132, 9.1054, 7.6885>
		<-3.7236, 9.0734, 7.6676> <-3.7372, 9.0917, 7.6599> <-3.7754, 9.1142, 7.6638> <-3.8065, 9.0919, 7.6697>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7370, 9.1174, 7.7574> <-3.7277, 9.0990, 7.7352> <-3.7279, 9.0873, 7.6941> <-3.7236, 9.0734, 7.6676>
		<-3.7241, 9.1022, 7.7679> <-3.7148, 9.0839, 7.7457> <-3.7143, 9.0691, 7.7018> <-3.7099, 9.0552, 7.6752>
		<-3.7381, 9.0620, 7.7905> <-3.7293, 9.0445, 7.7677> <-3.7230, 9.0276, 7.7313> <-3.7188, 9.0143, 7.7046>
		<-3.7566, 9.0498, 7.7938> <-3.7478, 9.0322, 7.7709> <-3.7422, 9.0137, 7.7350> <-3.7381, 9.0004, 7.7082>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7566, 9.0498, 7.7938> <-3.7478, 9.0322, 7.7709> <-3.7422, 9.0137, 7.7350> <-3.7381, 9.0004, 7.7082>
		<-3.7757, 9.0372, 7.7971> <-3.7669, 9.0197, 7.7742> <-3.7611, 9.0001, 7.7386> <-3.7570, 8.9869, 7.7119>
		<-3.8225, 9.0369, 7.7854> <-3.8138, 9.0196, 7.7617> <-3.8095, 9.0016, 7.7200> <-3.8046, 8.9877, 7.6931>
		<-3.8357, 9.0524, 7.7746> <-3.8270, 9.0351, 7.7509> <-3.8229, 9.0195, 7.7124> <-3.8180, 9.0056, 7.6856>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8357, 9.0524, 7.7746> <-3.8270, 9.0351, 7.7509> <-3.8229, 9.0195, 7.7124> <-3.8180, 9.0056, 7.6856>
		<-3.8501, 9.0694, 7.7628> <-3.8415, 9.0521, 7.7390> <-3.8371, 9.0385, 7.7044> <-3.8322, 9.0246, 7.6776>
		<-3.8341, 9.1276, 7.7375> <-3.8358, 9.1304, 7.7408> <-3.8455, 9.0822, 7.6947> <-3.8388, 9.0686, 7.6759>
		<-3.8269, 9.1324, 7.7362> <-3.8285, 9.1352, 7.7395> <-3.8132, 9.1054, 7.6885> <-3.8065, 9.0919, 7.6697>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7236, 9.0734, 7.6676> <-3.7372, 9.0917, 7.6599> <-3.7754, 9.1142, 7.6638> <-3.8065, 9.0919, 7.6697>
		<-3.7203, 9.0630, 7.6477> <-3.7340, 9.0812, 7.6400> <-3.7692, 9.1016, 7.6464> <-3.8003, 9.0793, 7.6523>
		<-3.7124, 9.0508, 7.6384> <-3.7323, 9.0814, 7.6386> <-3.7794, 9.0460, 7.6089> <-3.7836, 9.0434, 7.6099>
		<-3.7117, 9.0362, 7.6027> <-3.7316, 9.0669, 7.6028> <-3.7798, 9.0483, 7.6150> <-3.7840, 9.0457, 7.6159>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7236, 9.0734, 7.6676> <-3.7203, 9.0630, 7.6477> <-3.7124, 9.0508, 7.6384> <-3.7117, 9.0362, 7.6027>
		<-3.7099, 9.0552, 7.6752> <-3.7067, 9.0447, 7.6553> <-3.6915, 9.0185, 7.6382> <-3.6908, 9.0040, 7.6025>
		<-3.7188, 9.0143, 7.7046> <-3.7147, 9.0010, 7.6777> <-3.7106, 8.9814, 7.6403> <-3.7109, 8.9729, 7.6112>
		<-3.7381, 9.0004, 7.7082> <-3.7340, 8.9871, 7.6813> <-3.7289, 8.9698, 7.6446> <-3.7292, 8.9613, 7.6155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7381, 9.0004, 7.7082> <-3.7340, 8.9871, 7.6813> <-3.7289, 8.9698, 7.6446> <-3.7292, 8.9613, 7.6155>
		<-3.7570, 8.9869, 7.7119> <-3.7529, 8.9735, 7.6850> <-3.7480, 8.9578, 7.6491> <-3.7483, 8.9493, 7.6200>
		<-3.8046, 8.9877, 7.6931> <-3.8013, 8.9785, 7.6752> <-3.7894, 8.9530, 7.6580> <-3.7867, 8.9417, 7.6253>
		<-3.8180, 9.0056, 7.6856> <-3.8147, 8.9964, 7.6677> <-3.8112, 8.9865, 7.6581> <-3.8085, 8.9753, 7.6255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8180, 9.0056, 7.6856> <-3.8147, 8.9964, 7.6677> <-3.8112, 8.9865, 7.6581> <-3.8085, 8.9753, 7.6255>
		<-3.8322, 9.0246, 7.6776> <-3.8289, 9.0154, 7.6597> <-3.8314, 9.0176, 7.6583> <-3.8286, 9.0064, 7.6256>
		<-3.8388, 9.0686, 7.6759> <-3.8326, 9.0561, 7.6585> <-3.7879, 9.0407, 7.6109> <-3.7882, 9.0430, 7.6169>
		<-3.8065, 9.0919, 7.6697> <-3.8003, 9.0793, 7.6523> <-3.7836, 9.0434, 7.6099> <-3.7840, 9.0457, 7.6159>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7117, 9.0362, 7.6027> <-3.7316, 9.0669, 7.6028> <-3.7798, 9.0483, 7.6150> <-3.7840, 9.0457, 7.6159>
		<-3.7111, 9.0253, 7.5759> <-3.7310, 9.0559, 7.5760> <-3.7801, 9.0506, 7.6208> <-3.7843, 9.0480, 7.6218>
		<-3.7174, 9.0281, 7.5641> <-3.7303, 9.0468, 7.5614> <-3.7665, 9.0672, 7.5596> <-3.7963, 9.0469, 7.5667>
		<-3.7211, 9.0246, 7.5478> <-3.7339, 9.0434, 7.5451> <-3.7696, 9.0642, 7.5383> <-3.7994, 9.0440, 7.5455>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7117, 9.0362, 7.6027> <-3.7111, 9.0253, 7.5759> <-3.7174, 9.0281, 7.5641> <-3.7211, 9.0246, 7.5478>
		<-3.6908, 9.0040, 7.6025> <-3.6902, 8.9931, 7.5757> <-3.7061, 9.0116, 7.5666> <-3.7098, 9.0081, 7.5503>
		<-3.7109, 8.9729, 7.6112> <-3.7110, 8.9680, 7.5944> <-3.6980, 8.9787, 7.5839> <-3.7064, 8.9794, 7.5503>
		<-3.7292, 8.9613, 7.6155> <-3.7294, 8.9564, 7.5987> <-3.7314, 8.9561, 7.5919> <-3.7397, 8.9568, 7.5584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7292, 8.9613, 7.6155> <-3.7294, 8.9564, 7.5987> <-3.7314, 8.9561, 7.5919> <-3.7397, 8.9568, 7.5584>
		<-3.7483, 8.9493, 7.6200> <-3.7485, 8.9444, 7.6032> <-3.7640, 8.9339, 7.5998> <-3.7724, 8.9346, 7.5662>
		<-3.7867, 8.9417, 7.6253> <-3.7844, 8.9323, 7.5977> <-3.7967, 8.9512, 7.5883> <-3.7971, 8.9493, 7.5712>
		<-3.8085, 8.9753, 7.6255> <-3.8061, 8.9658, 7.5978> <-3.8078, 8.9674, 7.5859> <-3.8081, 8.9655, 7.5688>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8085, 8.9753, 7.6255> <-3.8061, 8.9658, 7.5978> <-3.8078, 8.9674, 7.5859> <-3.8081, 8.9655, 7.5688>
		<-3.8286, 9.0064, 7.6256> <-3.8263, 8.9969, 7.5980> <-3.8209, 8.9865, 7.5831> <-3.8212, 8.9846, 7.5660>
		<-3.7882, 9.0430, 7.6169> <-3.7885, 9.0453, 7.6228> <-3.8267, 9.0263, 7.5740> <-3.8298, 9.0233, 7.5528>
		<-3.7840, 9.0457, 7.6159> <-3.7843, 9.0480, 7.6218> <-3.7963, 9.0469, 7.5667> <-3.7994, 9.0440, 7.5455>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7211, 9.0246, 7.5478> <-3.7339, 9.0434, 7.5451> <-3.7696, 9.0642, 7.5383> <-3.7994, 9.0440, 7.5455>
		<-3.7255, 9.0204, 7.5277> <-3.7384, 9.0391, 7.5249> <-3.7721, 9.0618, 7.5209> <-3.8019, 9.0416, 7.5281>
		<-3.7327, 9.0162, 7.5008> <-3.7430, 9.0320, 7.5008> <-3.7791, 9.0525, 7.4992> <-3.8037, 9.0357, 7.5046>
		<-3.7386, 9.0105, 7.4813> <-3.7489, 9.0264, 7.4814> <-3.7778, 9.0449, 7.4833> <-3.8024, 9.0280, 7.4886>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7211, 9.0246, 7.5478> <-3.7255, 9.0204, 7.5277> <-3.7327, 9.0162, 7.5008> <-3.7386, 9.0105, 7.4813>
		<-3.7098, 9.0081, 7.5503> <-3.7142, 9.0039, 7.5301> <-3.7247, 9.0038, 7.5007> <-3.7306, 8.9982, 7.4813>
		<-3.7064, 8.9794, 7.5503> <-3.7169, 8.9803, 7.5080> <-3.7027, 8.9861, 7.5465> <-3.7215, 8.9908, 7.4797>
		<-3.7397, 8.9568, 7.5584> <-3.7503, 8.9577, 7.5160> <-3.7421, 8.9593, 7.5551> <-3.7609, 8.9640, 7.4883>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7397, 8.9568, 7.5584> <-3.7503, 8.9577, 7.5160> <-3.7421, 8.9593, 7.5551> <-3.7609, 8.9640, 7.4883>
		<-3.7724, 8.9346, 7.5662> <-3.7829, 8.9355, 7.5239> <-3.7807, 8.9329, 7.5635> <-3.7994, 8.9376, 7.4967>
		<-3.7971, 8.9493, 7.5712> <-3.7975, 8.9470, 7.5498> <-3.8038, 8.9499, 7.5186> <-3.8032, 8.9490, 7.4971>
		<-3.8081, 8.9655, 7.5688> <-3.8086, 8.9632, 7.5474> <-3.8117, 8.9620, 7.5187> <-3.8111, 8.9611, 7.4971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8081, 8.9655, 7.5688> <-3.8086, 8.9632, 7.5474> <-3.8117, 8.9620, 7.5187> <-3.8111, 8.9611, 7.4971>
		<-3.8212, 8.9846, 7.5660> <-3.8217, 8.9823, 7.5446> <-3.8222, 8.9782, 7.5188> <-3.8216, 8.9773, 7.4972>
		<-3.8298, 9.0233, 7.5528> <-3.8323, 9.0209, 7.5354> <-3.8289, 9.0185, 7.5101> <-3.8276, 9.0109, 7.4941>
		<-3.7994, 9.0440, 7.5455> <-3.8019, 9.0416, 7.5281> <-3.8037, 9.0357, 7.5046> <-3.8024, 9.0280, 7.4886>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7386, 9.0105, 7.4813> <-3.7489, 9.0264, 7.4814> <-3.7778, 9.0449, 7.4833> <-3.8024, 9.0280, 7.4886>
		<-3.7415, 9.0078, 7.4718> <-3.7518, 9.0236, 7.4719> <-3.7768, 9.0386, 7.4702> <-3.8014, 9.0218, 7.4756>
		<-3.7441, 9.0031, 7.4576> <-3.7508, 9.0127, 7.4557> <-3.7814, 9.0201, 7.4558> <-3.7970, 9.0099, 7.4595>
		<-3.7502, 8.9969, 7.4520> <-3.7568, 9.0066, 7.4500> <-3.7763, 9.0092, 7.4475> <-3.7920, 8.9990, 7.4513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7386, 9.0105, 7.4813> <-3.7415, 9.0078, 7.4718> <-3.7441, 9.0031, 7.4576> <-3.7502, 8.9969, 7.4520>
		<-3.7306, 8.9982, 7.4813> <-3.7335, 8.9954, 7.4718> <-3.7381, 8.9943, 7.4594> <-3.7442, 8.9882, 7.4538>
		<-3.7215, 8.9908, 7.4797> <-3.7293, 8.9928, 7.4519> <-3.7411, 8.9733, 7.4722> <-3.7479, 8.9768, 7.4538>
		<-3.7609, 8.9640, 7.4883> <-3.7687, 8.9659, 7.4605> <-3.7610, 8.9603, 7.4769> <-3.7678, 8.9639, 7.4585>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7609, 8.9640, 7.4883> <-3.7687, 8.9659, 7.4605> <-3.7610, 8.9603, 7.4769> <-3.7678, 8.9639, 7.4585>
		<-3.7994, 8.9376, 7.4967> <-3.8073, 8.9396, 7.4689> <-3.7808, 8.9473, 7.4816> <-3.7876, 8.9509, 7.4632>
		<-3.8032, 8.9490, 7.4971> <-3.8029, 8.9486, 7.4873> <-3.8045, 8.9506, 7.4748> <-3.7991, 8.9523, 7.4669>
		<-3.8111, 8.9611, 7.4971> <-3.8108, 8.9607, 7.4874> <-3.8105, 8.9594, 7.4730> <-3.8051, 8.9611, 7.4651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8111, 8.9611, 7.4971> <-3.8108, 8.9607, 7.4874> <-3.8105, 8.9594, 7.4730> <-3.8051, 8.9611, 7.4651>
		<-3.8216, 8.9773, 7.4972> <-3.8213, 8.9769, 7.4875> <-3.8172, 8.9691, 7.4710> <-3.8118, 8.9709, 7.4631>
		<-3.8276, 9.0109, 7.4941> <-3.8266, 9.0046, 7.4810> <-3.8129, 8.9995, 7.4633> <-3.8078, 8.9886, 7.4550>
		<-3.8024, 9.0280, 7.4886> <-3.8014, 9.0218, 7.4756> <-3.7970, 9.0099, 7.4595> <-3.7920, 8.9990, 7.4513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7764, 8.9721, 7.4463> <-3.7822, 8.9683, 7.4476> <-3.7991, 8.9630, 7.4563> <-3.8051, 8.9611, 7.4651>
		<-3.7764, 8.9721, 7.4463> <-3.7803, 8.9656, 7.4482> <-3.7931, 8.9542, 7.4581> <-3.7991, 8.9523, 7.4669>
		<-3.7764, 8.9721, 7.4463> <-3.7803, 8.9656, 7.4482> <-3.7914, 8.9529, 7.4529> <-3.7876, 8.9509, 7.4632>
		<-3.7764, 8.9721, 7.4463> <-3.7745, 8.9694, 7.4468> <-3.7716, 8.9658, 7.4482> <-3.7678, 8.9639, 7.4585>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7764, 8.9721, 7.4463> <-3.7798, 8.9771, 7.4452> <-3.7887, 8.9920, 7.4459> <-3.7920, 8.9990, 7.4513>
		<-3.7764, 8.9721, 7.4463> <-3.7856, 8.9733, 7.4466> <-3.8045, 8.9816, 7.4497> <-3.8078, 8.9886, 7.4550>
		<-3.7764, 8.9721, 7.4463> <-3.7856, 8.9733, 7.4466> <-3.8058, 8.9728, 7.4543> <-3.8118, 8.9709, 7.4631>
		<-3.7764, 8.9721, 7.4463> <-3.7822, 8.9683, 7.4476> <-3.7991, 8.9630, 7.4563> <-3.8051, 8.9611, 7.4651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7764, 8.9721, 7.4463> <-3.7705, 8.9760, 7.4449> <-3.7566, 8.9904, 7.4460> <-3.7502, 8.9969, 7.4520>
		<-3.7764, 8.9721, 7.4463> <-3.7740, 8.9810, 7.4438> <-3.7632, 9.0000, 7.4441> <-3.7568, 9.0066, 7.4500>
		<-3.7764, 8.9721, 7.4463> <-3.7740, 8.9810, 7.4438> <-3.7730, 9.0022, 7.4422> <-3.7763, 9.0092, 7.4475>
		<-3.7764, 8.9721, 7.4463> <-3.7798, 8.9771, 7.4452> <-3.7887, 8.9920, 7.4459> <-3.7920, 8.9990, 7.4513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7764, 8.9721, 7.4463> <-3.7745, 8.9694, 7.4468> <-3.7716, 8.9658, 7.4482> <-3.7678, 8.9639, 7.4585>
		<-3.7764, 8.9721, 7.4463> <-3.7687, 8.9732, 7.4454> <-3.7517, 8.9788, 7.4435> <-3.7479, 8.9768, 7.4538>
		<-3.7764, 8.9721, 7.4463> <-3.7687, 8.9732, 7.4454> <-3.7506, 8.9816, 7.4478> <-3.7442, 8.9882, 7.4538>
		<-3.7764, 8.9721, 7.4463> <-3.7705, 8.9760, 7.4449> <-3.7566, 8.9904, 7.4460> <-3.7502, 8.9969, 7.4520>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6233, 9.4628, 7.8879> <-3.6429, 9.4905, 7.9007> <-3.6706, 9.5288, 7.9139> <-3.6924, 9.5575, 7.9178>
		<-3.5938, 9.4845, 7.8833> <-3.6133, 9.5123, 7.8961> <-3.6453, 9.5425, 7.9046> <-3.6671, 9.5713, 7.9085>
		<-3.6079, 9.5478, 7.7886> <-3.6087, 9.5461, 7.7828> <-3.6335, 9.5646, 7.8568> <-3.6469, 9.5854, 7.8674>
		<-3.6076, 9.5482, 7.7907> <-3.6085, 9.5465, 7.7848> <-3.6099, 9.5820, 7.8495> <-3.6233, 9.6028, 7.8602>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6233, 9.4628, 7.8879> <-3.6578, 9.4374, 7.8933> <-3.7545, 9.4399, 7.8098> <-3.7541, 9.4405, 7.8135>
		<-3.6429, 9.4905, 7.9007> <-3.6773, 9.4652, 7.9061> <-3.7546, 9.4398, 7.8095> <-3.7541, 9.4405, 7.8132>
		<-3.6706, 9.5288, 7.9139> <-3.6949, 9.5156, 7.9228> <-3.7355, 9.4992, 7.8944> <-3.7609, 9.4871, 7.9015>
		<-3.6924, 9.5575, 7.9178> <-3.7167, 9.5443, 7.9267> <-3.7551, 9.5295, 7.9108> <-3.7805, 9.5174, 7.9178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7813, 9.3890, 7.9491> <-3.8012, 9.4162, 7.9591> <-3.8304, 9.4539, 7.9610> <-3.8516, 9.4819, 7.9619>
		<-3.7435, 9.4054, 7.9420> <-3.7634, 9.4326, 7.9520> <-3.8061, 9.4661, 7.9584> <-3.8273, 9.4941, 7.9593>
		<-3.7545, 9.4397, 7.8099> <-3.7545, 9.4397, 7.8096> <-3.7848, 9.4757, 7.9081> <-3.8044, 9.5061, 7.9245>
		<-3.7541, 9.4405, 7.8135> <-3.7541, 9.4405, 7.8132> <-3.7609, 9.4871, 7.9015> <-3.7805, 9.5174, 7.9178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7813, 9.3890, 7.9491> <-3.8257, 9.3698, 7.9574> <-3.9175, 9.3700, 7.8451> <-3.9176, 9.3698, 7.8441>
		<-3.8012, 9.4162, 7.9591> <-3.8456, 9.3970, 7.9674> <-3.9175, 9.3697, 7.8439> <-3.9176, 9.3695, 7.8429>
		<-3.8304, 9.4539, 7.9610> <-3.8617, 9.4382, 7.9643> <-3.9048, 9.4217, 7.9218> <-3.9355, 9.4045, 7.9222>
		<-3.8516, 9.4819, 7.9619> <-3.8829, 9.4662, 7.9653> <-3.9232, 9.4478, 7.9360> <-3.9538, 9.4306, 7.9364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9533, 9.3109, 7.9517> <-3.9744, 9.3330, 7.9594> <-4.0066, 9.3602, 7.9634> <-4.0296, 9.3818, 7.9644>
		<-3.9349, 9.3394, 7.9389> <-3.9560, 9.3615, 7.9466> <-3.9842, 9.3757, 7.9710> <-4.0071, 9.3973, 7.9719>
		<-3.9177, 9.3699, 7.8448> <-3.9177, 9.3697, 7.8436> <-3.9601, 9.3906, 7.9226> <-3.9785, 9.4167, 7.9367>
		<-3.9176, 9.3698, 7.8441> <-3.9176, 9.3695, 7.8429> <-3.9355, 9.4045, 7.9222> <-3.9538, 9.4306, 7.9364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9533, 9.3109, 7.9517> <-3.9661, 9.2911, 7.9606> <-3.9955, 9.2589, 7.9206> <-3.9926, 9.2535, 7.8961>
		<-3.9744, 9.3330, 7.9594> <-3.9872, 9.3131, 7.9682> <-4.0212, 9.2862, 7.9250> <-4.0183, 9.2808, 7.9005>
		<-4.0066, 9.3602, 7.9634> <-4.0294, 9.3446, 7.9558> <-4.0551, 9.3190, 7.9217> <-4.0553, 9.3153, 7.8933>
		<-4.0296, 9.3818, 7.9644> <-4.0523, 9.3661, 7.9567> <-4.0807, 9.3467, 7.9222> <-4.0809, 9.3430, 7.8938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9926, 9.2535, 7.8961> <-3.9887, 9.2462, 7.8632> <-3.9623, 9.2330, 7.8128> <-3.9346, 9.2760, 7.7936>
		<-4.0183, 9.2808, 7.9005> <-4.0144, 9.2735, 7.8676> <-3.9894, 9.2606, 7.8210> <-3.9617, 9.3036, 7.8018>
		<-4.0553, 9.3153, 7.8933> <-4.0555, 9.3117, 7.8655> <-4.0233, 9.3256, 7.8278> <-4.0017, 9.3363, 7.8137>
		<-4.0809, 9.3430, 7.8938> <-4.0811, 9.3394, 7.8661> <-4.0523, 9.3521, 7.8320> <-4.0307, 9.3628, 7.8179>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9346, 9.2760, 7.7936> <-3.9097, 9.3146, 7.7763> <-3.9175, 9.3696, 7.8434> <-3.9176, 9.3698, 7.8441>
		<-3.9617, 9.3036, 7.8018> <-3.9368, 9.3422, 7.7845> <-3.9175, 9.3698, 7.8440> <-3.9176, 9.3699, 7.8447>
		<-4.0017, 9.3363, 7.8137> <-3.9819, 9.3461, 7.8007> <-3.9669, 9.3801, 7.8221> <-3.9446, 9.3913, 7.8166>
		<-4.0307, 9.3628, 7.8179> <-4.0109, 9.3726, 7.8049> <-3.9788, 9.3933, 7.8177> <-3.9564, 9.4045, 7.8122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9176, 9.3698, 7.8441> <-3.9177, 9.3696, 7.8432> <-3.8601, 9.3210, 7.7718> <-3.8000, 9.3470, 7.7605>
		<-3.9176, 9.3699, 7.8447> <-3.9177, 9.3697, 7.8438> <-3.8809, 9.3495, 7.7778> <-3.8208, 9.3756, 7.7665>
		<-3.9446, 9.3913, 7.8166> <-3.9164, 9.4054, 7.8098> <-3.8720, 9.4040, 7.7816> <-3.8434, 9.4172, 7.7748>
		<-3.9564, 9.4045, 7.8122> <-3.9283, 9.4186, 7.8053> <-3.8926, 9.4332, 7.7839> <-3.8640, 9.4464, 7.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8000, 9.3470, 7.7605> <-3.7519, 9.3679, 7.7516> <-3.7538, 9.4412, 7.8163> <-3.7541, 9.4405, 7.8135>
		<-3.8208, 9.3756, 7.7665> <-3.7727, 9.3964, 7.7575> <-3.7538, 9.4412, 7.8165> <-3.7541, 9.4406, 7.8137>
		<-3.8434, 9.4172, 7.7748> <-3.8214, 9.4274, 7.7695> <-3.7980, 9.4547, 7.7805> <-3.7764, 9.4661, 7.7758>
		<-3.8640, 9.4464, 7.7771> <-3.8420, 9.4566, 7.7718> <-3.8108, 9.4701, 7.7769> <-3.7892, 9.4816, 7.7722>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7541, 9.4405, 7.8135> <-3.7537, 9.4412, 7.8172> <-3.6983, 9.3931, 7.7216> <-3.6440, 9.4330, 7.7132>
		<-3.7541, 9.4406, 7.8137> <-3.7537, 9.4412, 7.8173> <-3.7170, 9.4210, 7.7346> <-3.6627, 9.4609, 7.7262>
		<-3.7764, 9.4661, 7.7758> <-3.7520, 9.4791, 7.7705> <-3.7126, 9.4864, 7.7458> <-3.6888, 9.5000, 7.7393>
		<-3.7892, 9.4816, 7.7722> <-3.7648, 9.4946, 7.7668> <-3.7359, 9.5135, 7.7503> <-3.7121, 9.5272, 7.7439>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6440, 9.4330, 7.7132> <-3.5918, 9.4714, 7.7050> <-3.6073, 9.5486, 7.7929> <-3.6076, 9.5482, 7.7907>
		<-3.6627, 9.4609, 7.7262> <-3.6105, 9.4993, 7.7180> <-3.6067, 9.5499, 7.7975> <-3.6069, 9.5495, 7.7952>
		<-3.6888, 9.5000, 7.7393> <-3.6684, 9.5117, 7.7338> <-3.6477, 9.5390, 7.7424> <-3.6276, 9.5513, 7.7372>
		<-3.7121, 9.5272, 7.7439> <-3.6917, 9.5388, 7.7383> <-3.6624, 9.5532, 7.7374> <-3.6423, 9.5656, 7.7322>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6076, 9.5482, 7.7907> <-3.6085, 9.5465, 7.7848> <-3.6099, 9.5820, 7.8495> <-3.6233, 9.6028, 7.8602>
		<-3.6075, 9.5472, 7.7885> <-3.6083, 9.5455, 7.7827> <-3.5860, 9.5996, 7.8422> <-3.5994, 9.6204, 7.8528>
		<-3.5387, 9.5982, 7.8690> <-3.5522, 9.6148, 7.8707> <-3.5496, 9.6322, 7.8874> <-3.5633, 9.6486, 7.8887>
		<-3.5004, 9.6109, 7.8634> <-3.5139, 9.6275, 7.8650> <-3.5309, 9.6500, 7.8710> <-3.5446, 9.6665, 7.8723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6076, 9.5482, 7.7907> <-3.6069, 9.5495, 7.7952> <-3.6276, 9.5513, 7.7372> <-3.6423, 9.5656, 7.7322>
		<-3.6078, 9.5492, 7.7928> <-3.6071, 9.5505, 7.7974> <-3.6030, 9.5665, 7.7309> <-3.6177, 9.5807, 7.7259>
		<-3.5523, 9.5132, 7.7110> <-3.5739, 9.5393, 7.7129> <-3.5611, 9.5714, 7.7031> <-3.5833, 9.5970, 7.7019>
		<-3.4883, 9.5345, 7.7015> <-3.5099, 9.5606, 7.7034> <-3.5413, 9.5931, 7.7068> <-3.5635, 9.6187, 7.7057>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4883, 9.5345, 7.7015> <-3.5099, 9.5606, 7.7034> <-3.5413, 9.5931, 7.7068> <-3.5635, 9.6187, 7.7057>
		<-3.4391, 9.5508, 7.6942> <-3.4606, 9.5769, 7.6961> <-3.5167, 9.6201, 7.7115> <-3.5389, 9.6457, 7.7104>
		<-3.4237, 9.5946, 7.7343> <-3.4486, 9.6259, 7.7341> <-3.4846, 9.6744, 7.7281> <-3.5109, 9.7041, 7.7228>
		<-3.4259, 9.6085, 7.7637> <-3.4508, 9.6398, 7.7635> <-3.4806, 9.6845, 7.7633> <-3.5069, 9.7142, 7.7580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4259, 9.6085, 7.7637> <-3.4508, 9.6398, 7.7635> <-3.4806, 9.6845, 7.7633> <-3.5069, 9.7142, 7.7580>
		<-3.4283, 9.6235, 7.7955> <-3.4531, 9.6548, 7.7953> <-3.4764, 9.6952, 7.8004> <-3.5026, 9.7248, 7.7951>
		<-3.4673, 9.6219, 7.8584> <-3.4808, 9.6385, 7.8601> <-3.5072, 9.6727, 7.8502> <-3.5209, 9.6891, 7.8515>
		<-3.5004, 9.6109, 7.8634> <-3.5139, 9.6275, 7.8650> <-3.5309, 9.6500, 7.8710> <-3.5446, 9.6665, 7.8723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4449, 9.9002, 7.6388> <-3.4604, 9.8912, 7.6064> <-3.5046, 9.8671, 7.5668> <-3.5501, 9.8383, 7.5922>
		<-3.4662, 9.9372, 7.6507> <-3.4817, 9.9282, 7.6183> <-3.5134, 9.8880, 7.5658> <-3.5589, 9.8592, 7.5912>
		<-3.4963, 9.9890, 7.6578> <-3.5096, 9.9782, 7.6164> <-3.5618, 9.9222, 7.5744> <-3.5789, 9.8825, 7.5864>
		<-3.5265, 10.0206, 7.6654> <-3.5398, 10.0098, 7.6240> <-3.5752, 9.9405, 7.5734> <-3.5922, 9.9008, 7.5854>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4449, 9.9002, 7.6388> <-3.4249, 9.8654, 7.6277> <-3.4117, 9.8440, 7.6174> <-3.3897, 9.7831, 7.5892>
		<-3.4604, 9.8912, 7.6064> <-3.4404, 9.8564, 7.5953> <-3.4709, 9.8470, 7.5806> <-3.4489, 9.7861, 7.5525>
		<-3.5046, 9.8671, 7.5668> <-3.4924, 9.8379, 7.5681> <-3.5049, 9.7841, 7.5723> <-3.4962, 9.7545, 7.5657>
		<-3.5501, 9.8383, 7.5922> <-3.5379, 9.8092, 7.5935> <-3.5320, 9.7661, 7.5996> <-3.5233, 9.7364, 7.5930>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4449, 9.9002, 7.6388> <-3.4305, 9.9085, 7.6691> <-3.4450, 9.9007, 7.7420> <-3.4714, 9.8840, 7.7567>
		<-3.4249, 9.8654, 7.6277> <-3.4105, 9.8738, 7.6579> <-3.4143, 9.8551, 7.7211> <-3.4407, 9.8384, 7.7359>
		<-3.4117, 9.8440, 7.6174> <-3.3655, 9.8416, 7.6461> <-3.3792, 9.7903, 7.6890> <-3.3991, 9.7769, 7.7091>
		<-3.3897, 9.7831, 7.5892> <-3.3435, 9.7807, 7.6179> <-3.3561, 9.7422, 7.6643> <-3.3761, 9.7289, 7.6844>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4449, 9.9002, 7.6388> <-3.4662, 9.9372, 7.6507> <-3.4963, 9.9890, 7.6578> <-3.5265, 10.0206, 7.6654>
		<-3.4305, 9.9085, 7.6691> <-3.4518, 9.9456, 7.6810> <-3.4846, 9.9985, 7.6942> <-3.5148, 10.0301, 7.7018>
		<-3.4450, 9.9007, 7.7420> <-3.4597, 9.9226, 7.7520> <-3.4929, 9.9695, 7.7685> <-3.5123, 9.9884, 7.7767>
		<-3.4714, 9.8840, 7.7567> <-3.4862, 9.9059, 7.7668> <-3.5079, 9.9346, 7.7790> <-3.5273, 9.9535, 7.7872>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4714, 9.8840, 7.7567> <-3.4862, 9.9059, 7.7668> <-3.5079, 9.9346, 7.7790> <-3.5273, 9.9535, 7.7872>
		<-3.5041, 9.8634, 7.7749> <-3.5189, 9.8853, 7.7850> <-3.5262, 9.8918, 7.7919> <-3.5456, 9.9107, 7.8001>
		<-3.5775, 9.8155, 7.7601> <-3.5821, 9.8204, 7.7610> <-3.6021, 9.8363, 7.7716> <-3.5976, 9.8316, 7.7734>
		<-3.5954, 9.8051, 7.7227> <-3.6000, 9.8100, 7.7236> <-3.6173, 9.8239, 7.7244> <-3.6128, 9.8192, 7.7262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4714, 9.8840, 7.7567> <-3.5041, 9.8634, 7.7749> <-3.5775, 9.8155, 7.7601> <-3.5954, 9.8051, 7.7227>
		<-3.4407, 9.8384, 7.7359> <-3.4734, 9.8178, 7.7541> <-3.5498, 9.7864, 7.7548> <-3.5677, 9.7760, 7.7174>
		<-3.3991, 9.7769, 7.7091> <-3.4231, 9.7609, 7.7333> <-3.4918, 9.7549, 7.7569> <-3.5474, 9.7577, 7.7224>
		<-3.3761, 9.7289, 7.6844> <-3.4001, 9.7128, 7.7086> <-3.4496, 9.7032, 7.7401> <-3.5051, 9.7060, 7.7056>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3897, 9.7831, 7.5892> <-3.3693, 9.7267, 7.5631> <-3.3706, 9.7064, 7.5458> <-3.3620, 9.6711, 7.5329>
		<-3.4489, 9.7861, 7.5525> <-3.4285, 9.7297, 7.5264> <-3.4021, 9.7010, 7.5247> <-3.3935, 9.6658, 7.5118>
		<-3.4962, 9.7545, 7.5657> <-3.4849, 9.7160, 7.5571> <-3.4723, 9.6751, 7.5056> <-3.4561, 9.6394, 7.4935>
		<-3.5233, 9.7364, 7.5930> <-3.5119, 9.6979, 7.5844> <-3.5008, 9.6511, 7.5544> <-3.4845, 9.6154, 7.5424>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3897, 9.7831, 7.5892> <-3.3435, 9.7807, 7.6179> <-3.3561, 9.7422, 7.6643> <-3.3761, 9.7289, 7.6844>
		<-3.3693, 9.7267, 7.5631> <-3.3231, 9.7243, 7.5918> <-3.3433, 9.7155, 7.6506> <-3.3633, 9.7022, 7.6707>
		<-3.3706, 9.7064, 7.5458> <-3.3466, 9.7104, 7.5618> <-3.3360, 9.7161, 7.6143> <-3.3636, 9.6929, 7.6616>
		<-3.3620, 9.6711, 7.5329> <-3.3379, 9.6752, 7.5489> <-3.3257, 9.6608, 7.5827> <-3.3533, 9.6376, 7.6300>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3761, 9.7289, 7.6844> <-3.4001, 9.7128, 7.7086> <-3.4496, 9.7032, 7.7401> <-3.5051, 9.7060, 7.7056>
		<-3.3633, 9.7022, 7.6707> <-3.3873, 9.6862, 7.6949> <-3.4096, 9.6542, 7.7241> <-3.4651, 9.6570, 7.6896>
		<-3.3636, 9.6929, 7.6616> <-3.3881, 9.6723, 7.7037> <-3.4315, 9.6434, 7.6888> <-3.4528, 9.6398, 7.6745>
		<-3.3533, 9.6376, 7.6300> <-3.3778, 9.6170, 7.6721> <-3.4141, 9.6129, 7.6731> <-3.4355, 9.6093, 7.6588>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5051, 9.7060, 7.7056> <-3.5474, 9.7577, 7.7224> <-3.5677, 9.7760, 7.7174> <-3.5954, 9.8051, 7.7227>
		<-3.5545, 9.7086, 7.6749> <-3.5967, 9.7603, 7.6918> <-3.5845, 9.7662, 7.6821> <-3.6122, 9.7953, 7.6874>
		<-3.5458, 9.7213, 7.6157> <-3.5545, 9.7510, 7.6224> <-3.5874, 9.7779, 7.6211> <-3.5996, 9.8071, 7.6197>
		<-3.5233, 9.7364, 7.5930> <-3.5320, 9.7661, 7.5996> <-3.5379, 9.8092, 7.5935> <-3.5501, 9.8383, 7.5922>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5051, 9.7060, 7.7056> <-3.5545, 9.7086, 7.6749> <-3.5458, 9.7213, 7.6157> <-3.5233, 9.7364, 7.5930>
		<-3.4651, 9.6570, 7.6896> <-3.5145, 9.6596, 7.6589> <-3.5345, 9.6829, 7.6071> <-3.5119, 9.6979, 7.5844>
		<-3.4528, 9.6398, 7.6745> <-3.4824, 9.6348, 7.6548> <-3.5275, 9.6286, 7.6003> <-3.5008, 9.6511, 7.5544>
		<-3.4355, 9.6093, 7.6588> <-3.4650, 9.6043, 7.6391> <-3.5113, 9.5929, 7.5882> <-3.4845, 9.6154, 7.5424>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3620, 9.6711, 7.5329> <-3.3553, 9.6436, 7.5228> <-3.3456, 9.6046, 7.5172> <-3.3389, 9.5755, 7.5134>
		<-3.3935, 9.6658, 7.5118> <-3.3868, 9.6383, 7.5018> <-3.3710, 9.6039, 7.5030> <-3.3644, 9.5748, 7.4992>
		<-3.4561, 9.6394, 7.4935> <-3.4456, 9.6165, 7.4857> <-3.4313, 9.5826, 7.4939> <-3.4131, 9.5637, 7.4920>
		<-3.4845, 9.6154, 7.5424> <-3.4741, 9.5925, 7.5346> <-3.4539, 9.5628, 7.5298> <-3.4356, 9.5439, 7.5279>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3620, 9.6711, 7.5329> <-3.3379, 9.6752, 7.5489> <-3.3257, 9.6608, 7.5827> <-3.3533, 9.6376, 7.6300>
		<-3.3553, 9.6436, 7.5228> <-3.3312, 9.6476, 7.5389> <-3.3157, 9.6076, 7.5522> <-3.3433, 9.5843, 7.5995>
		<-3.3456, 9.6046, 7.5172> <-3.3276, 9.6051, 7.5272> <-3.3219, 9.6618, 7.5742> <-3.3545, 9.6331, 7.6261>
		<-3.3389, 9.5755, 7.5134> <-3.3209, 9.5760, 7.5234> <-3.3094, 9.5750, 7.5281> <-3.3419, 9.5463, 7.5800>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3533, 9.6376, 7.6300> <-3.3778, 9.6170, 7.6721> <-3.4141, 9.6129, 7.6731> <-3.4355, 9.6093, 7.6588>
		<-3.3433, 9.5843, 7.5995> <-3.3678, 9.5637, 7.6416> <-3.3997, 9.5877, 7.6601> <-3.4211, 9.5841, 7.6459>
		<-3.3545, 9.6331, 7.6261> <-3.3859, 9.6055, 7.6761> <-3.3947, 9.5472, 7.6358> <-3.4121, 9.5468, 7.6262>
		<-3.3419, 9.5463, 7.5800> <-3.3733, 9.5187, 7.6300> <-3.3827, 9.5222, 7.6204> <-3.4000, 9.5217, 7.6107>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4355, 9.6093, 7.6588> <-3.4650, 9.6043, 7.6391> <-3.5113, 9.5929, 7.5882> <-3.4845, 9.6154, 7.5424>
		<-3.4211, 9.5841, 7.6459> <-3.4506, 9.5791, 7.6261> <-3.5008, 9.5700, 7.5804> <-3.4741, 9.5925, 7.5346>
		<-3.4121, 9.5468, 7.6262> <-3.4351, 9.5462, 7.6134> <-3.4742, 9.5449, 7.5622> <-3.4539, 9.5628, 7.5298>
		<-3.4000, 9.5217, 7.6107> <-3.4230, 9.5211, 7.5979> <-3.4560, 9.5260, 7.5603> <-3.4356, 9.5439, 7.5279>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3389, 9.5755, 7.5134> <-3.3357, 9.5612, 7.5115> <-3.3275, 9.5412, 7.5098> <-3.3291, 9.5272, 7.5142>
		<-3.3644, 9.5748, 7.4992> <-3.3611, 9.5605, 7.4974> <-3.3410, 9.5408, 7.5009> <-3.3425, 9.5267, 7.5053>
		<-3.4131, 9.5637, 7.4920> <-3.3988, 9.5488, 7.4905> <-3.3826, 9.5271, 7.5094> <-3.3653, 9.5161, 7.5119>
		<-3.4356, 9.5439, 7.5279> <-3.4213, 9.5290, 7.5264> <-3.3960, 9.5163, 7.5288> <-3.3787, 9.5054, 7.5313>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3389, 9.5755, 7.5134> <-3.3209, 9.5760, 7.5234> <-3.3094, 9.5750, 7.5281> <-3.3419, 9.5463, 7.5800>
		<-3.3357, 9.5612, 7.5115> <-3.3177, 9.5617, 7.5215> <-3.3040, 9.5380, 7.5084> <-3.3366, 9.5094, 7.5603>
		<-3.3275, 9.5412, 7.5098> <-3.3155, 9.5417, 7.5177> <-3.3150, 9.5443, 7.5527> <-3.3317, 9.5308, 7.5770>
		<-3.3291, 9.5272, 7.5142> <-3.3170, 9.5276, 7.5221> <-3.3177, 9.5204, 7.5363> <-3.3344, 9.5069, 7.5606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3419, 9.5463, 7.5800> <-3.3733, 9.5187, 7.6300> <-3.3827, 9.5222, 7.6204> <-3.4000, 9.5217, 7.6107>
		<-3.3366, 9.5094, 7.5603> <-3.3680, 9.4817, 7.6104> <-3.3771, 9.5108, 7.6133> <-3.3945, 9.5103, 7.6036>
		<-3.3317, 9.5308, 7.5770> <-3.3489, 9.5170, 7.6019> <-3.3729, 9.4939, 7.6032> <-3.3852, 9.4935, 7.5950>
		<-3.3344, 9.5069, 7.5606> <-3.3515, 9.4930, 7.5855> <-3.3648, 9.4888, 7.5922> <-3.3772, 9.4883, 7.5841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4000, 9.5217, 7.6107> <-3.4230, 9.5211, 7.5979> <-3.4560, 9.5260, 7.5603> <-3.4356, 9.5439, 7.5279>
		<-3.3945, 9.5103, 7.6036> <-3.4175, 9.5097, 7.5908> <-3.4417, 9.5111, 7.5588> <-3.4213, 9.5290, 7.5264>
		<-3.3852, 9.4935, 7.5950> <-3.3984, 9.4930, 7.5864> <-3.4090, 9.5058, 7.5477> <-3.3960, 9.5163, 7.5288>
		<-3.3772, 9.4883, 7.5841> <-3.3903, 9.4879, 7.5754> <-3.3917, 9.4949, 7.5502> <-3.3787, 9.5054, 7.5313>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3483, 9.4887, 7.5405> <-3.3536, 9.4845, 7.5481> <-3.3685, 9.4828, 7.5723> <-3.3772, 9.4883, 7.5841>
		<-3.3483, 9.4887, 7.5405> <-3.3595, 9.4843, 7.5443> <-3.3816, 9.4823, 7.5636> <-3.3903, 9.4879, 7.5754>
		<-3.3483, 9.4887, 7.5405> <-3.3595, 9.4843, 7.5443> <-3.3827, 9.4892, 7.5515> <-3.3917, 9.4949, 7.5502>
		<-3.3483, 9.4887, 7.5405> <-3.3542, 9.4885, 7.5366> <-3.3696, 9.4997, 7.5326> <-3.3787, 9.5054, 7.5313>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3483, 9.4887, 7.5405> <-3.3542, 9.4885, 7.5366> <-3.3696, 9.4997, 7.5326> <-3.3787, 9.5054, 7.5313>
		<-3.3483, 9.4887, 7.5405> <-3.3491, 9.4926, 7.5292> <-3.3563, 9.5105, 7.5132> <-3.3653, 9.5161, 7.5119>
		<-3.3483, 9.4887, 7.5405> <-3.3491, 9.4926, 7.5292> <-3.3440, 9.5124, 7.5098> <-3.3425, 9.5267, 7.5053>
		<-3.3483, 9.4887, 7.5405> <-3.3433, 9.4928, 7.5331> <-3.3306, 9.5128, 7.5187> <-3.3291, 9.5272, 7.5142>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3483, 9.4887, 7.5405> <-3.3433, 9.4928, 7.5331> <-3.3306, 9.5128, 7.5187> <-3.3291, 9.5272, 7.5142>
		<-3.3483, 9.4887, 7.5405> <-3.3383, 9.4930, 7.5364> <-3.3186, 9.5132, 7.5266> <-3.3170, 9.5276, 7.5221>
		<-3.3483, 9.4887, 7.5405> <-3.3383, 9.4930, 7.5364> <-3.3195, 9.5040, 7.5251> <-3.3177, 9.5204, 7.5363>
		<-3.3483, 9.4887, 7.5405> <-3.3434, 9.4889, 7.5438> <-3.3362, 9.4905, 7.5494> <-3.3344, 9.5069, 7.5606>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3483, 9.4887, 7.5405> <-3.3434, 9.4889, 7.5438> <-3.3362, 9.4905, 7.5494> <-3.3344, 9.5069, 7.5606>
		<-3.3483, 9.4887, 7.5405> <-3.3487, 9.4846, 7.5514> <-3.3533, 9.4767, 7.5743> <-3.3515, 9.4930, 7.5855>
		<-3.3483, 9.4887, 7.5405> <-3.3487, 9.4846, 7.5514> <-3.3562, 9.4832, 7.5804> <-3.3648, 9.4888, 7.5922>
		<-3.3483, 9.4887, 7.5405> <-3.3536, 9.4845, 7.5481> <-3.3685, 9.4828, 7.5723> <-3.3772, 9.4883, 7.5841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7404, 9.7543, 7.8964> <-3.7153, 9.7672, 7.8894> <-3.6716, 9.7880, 7.9002> <-3.6548, 9.7966, 7.8779>
		<-3.7044, 9.7094, 7.8860> <-3.6792, 9.7224, 7.8790> <-3.6375, 9.7500, 7.8968> <-3.6207, 9.7585, 7.8745>
		<-3.6524, 9.6479, 7.8833> <-3.6285, 9.6656, 7.8760> <-3.5959, 9.6879, 7.8918> <-3.5772, 9.7058, 7.8754>
		<-3.6233, 9.6028, 7.8602> <-3.5994, 9.6204, 7.8528> <-3.5633, 9.6486, 7.8887> <-3.5446, 9.6665, 7.8723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7404, 9.7543, 7.8964> <-3.7579, 9.7759, 7.9014> <-3.7831, 9.8035, 7.9069> <-3.8015, 9.8245, 7.9115>
		<-3.7153, 9.7672, 7.8894> <-3.7327, 9.7889, 7.8944> <-3.7516, 9.8171, 7.8972> <-3.7700, 9.8381, 7.9018>
		<-3.6716, 9.7880, 7.9002> <-3.6903, 9.8089, 7.9021> <-3.7207, 9.8309, 7.9001> <-3.7407, 9.8503, 7.9041>
		<-3.6548, 9.7966, 7.8779> <-3.6735, 9.8174, 7.8798> <-3.7003, 9.8431, 7.8860> <-3.7202, 9.8625, 7.8899>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7404, 9.7543, 7.8964> <-3.7632, 9.7425, 7.9027> <-3.7919, 9.7270, 7.9168> <-3.8144, 9.7143, 7.9222>
		<-3.7579, 9.7759, 7.9014> <-3.7807, 9.7642, 7.9077> <-3.8111, 9.7514, 7.9189> <-3.8336, 9.7387, 7.9243>
		<-3.7831, 9.8035, 7.9069> <-3.8129, 9.7906, 7.9161> <-3.8363, 9.7803, 7.9286> <-3.8596, 9.7699, 7.9342>
		<-3.8015, 9.8245, 7.9115> <-3.8313, 9.8116, 7.9207> <-3.8554, 9.8045, 7.9331> <-3.8787, 9.7940, 7.9387>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7404, 9.7543, 7.8964> <-3.7044, 9.7094, 7.8860> <-3.6524, 9.6479, 7.8833> <-3.6233, 9.6028, 7.8602>
		<-3.7632, 9.7425, 7.9027> <-3.7272, 9.6977, 7.8923> <-3.6760, 9.6305, 7.8906> <-3.6469, 9.5854, 7.8674>
		<-3.7919, 9.7270, 7.9168> <-3.7551, 9.6803, 7.9126> <-3.7030, 9.6185, 7.9150> <-3.6671, 9.5713, 7.9085>
		<-3.8144, 9.7143, 7.9222> <-3.7776, 9.6676, 7.9180> <-3.7283, 9.6047, 7.9242> <-3.6924, 9.5575, 7.9178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6548, 9.7966, 7.8779> <-3.6735, 9.8174, 7.8798> <-3.7003, 9.8431, 7.8860> <-3.7202, 9.8625, 7.8899>
		<-3.6274, 9.8105, 7.8414> <-3.6461, 9.8314, 7.8433> <-3.6797, 9.8554, 7.8718> <-3.6996, 9.8748, 7.8758>
		<-3.6059, 9.8289, 7.7724> <-3.6193, 9.8478, 7.7942> <-3.6597, 9.8522, 7.8155> <-3.6858, 9.8804, 7.8317>
		<-3.6128, 9.8192, 7.7262> <-3.6261, 9.8381, 7.7480> <-3.6452, 9.8737, 7.8055> <-3.6714, 9.9020, 7.8217>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6548, 9.7966, 7.8779> <-3.6207, 9.7585, 7.8745> <-3.5772, 9.7058, 7.8754> <-3.5446, 9.6665, 7.8723>
		<-3.6274, 9.8105, 7.8414> <-3.5934, 9.7725, 7.8380> <-3.5535, 9.7284, 7.8546> <-3.5209, 9.6891, 7.8515>
		<-3.6059, 9.8289, 7.7724> <-3.5751, 9.7973, 7.7847> <-3.5327, 9.7587, 7.7891> <-3.5026, 9.7248, 7.7951>
		<-3.6128, 9.8192, 7.7262> <-3.5820, 9.7876, 7.7385> <-3.5369, 9.7481, 7.7520> <-3.5069, 9.7142, 7.7580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6826, 9.7574, 7.6913> <-3.7083, 9.7367, 7.6934> <-3.7365, 9.7157, 7.7281> <-3.7626, 9.6982, 7.7382>
		<-3.7031, 9.7809, 7.6899> <-3.7287, 9.7602, 7.6920> <-3.7618, 9.7438, 7.7286> <-3.7879, 9.7263, 7.7388>
		<-3.7300, 9.8128, 7.6947> <-3.7650, 9.7939, 7.7123> <-3.7922, 9.7762, 7.7244> <-3.8214, 9.7641, 7.7365>
		<-3.7515, 9.8354, 7.6926> <-3.7865, 9.8165, 7.7102> <-3.8169, 9.8048, 7.7244> <-3.8461, 9.7927, 7.7365>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6826, 9.7574, 7.6913> <-3.6466, 9.7159, 7.6939> <-3.5997, 9.6601, 7.7038> <-3.5635, 9.6187, 7.7057>
		<-3.7083, 9.7367, 7.6934> <-3.6722, 9.6952, 7.6959> <-3.6194, 9.6384, 7.7000> <-3.5833, 9.5970, 7.7019>
		<-3.7365, 9.7157, 7.7281> <-3.7006, 9.6757, 7.7274> <-3.6552, 9.6170, 7.7132> <-3.6177, 9.5807, 7.7259>
		<-3.7626, 9.6982, 7.7382> <-3.7268, 9.6582, 7.7375> <-3.6799, 9.6019, 7.7195> <-3.6423, 9.5656, 7.7322>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6826, 9.7574, 7.6913> <-3.7031, 9.7809, 7.6899> <-3.7300, 9.8128, 7.6947> <-3.7515, 9.8354, 7.6926>
		<-3.6594, 9.7761, 7.6895> <-3.6799, 9.7997, 7.6881> <-3.7081, 9.8247, 7.6836> <-3.7295, 9.8472, 7.6815>
		<-3.6171, 9.8131, 7.6972> <-3.6368, 9.8252, 7.6827> <-3.6817, 9.8358, 7.6835> <-3.7089, 9.8569, 7.6734>
		<-3.6128, 9.8192, 7.7262> <-3.6325, 9.8313, 7.7116> <-3.6719, 9.8510, 7.6724> <-3.6992, 9.8722, 7.6623>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6826, 9.7574, 7.6913> <-3.6594, 9.7761, 7.6895> <-3.6171, 9.8131, 7.6972> <-3.6128, 9.8192, 7.7262>
		<-3.6466, 9.7159, 7.6939> <-3.6234, 9.7346, 7.6920> <-3.5863, 9.7816, 7.7095> <-3.5820, 9.7876, 7.7385>
		<-3.5997, 9.6601, 7.7038> <-3.5750, 9.6871, 7.7085> <-3.5409, 9.7380, 7.7168> <-3.5369, 9.7481, 7.7520>
		<-3.5635, 9.6187, 7.7057> <-3.5389, 9.6457, 7.7104> <-3.5109, 9.7041, 7.7228> <-3.5069, 9.7142, 7.7580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7626, 9.6982, 7.7382> <-3.7268, 9.6582, 7.7375> <-3.6799, 9.6019, 7.7195> <-3.6423, 9.5656, 7.7322>
		<-3.7827, 9.6847, 7.7461> <-3.7469, 9.6447, 7.7453> <-3.6999, 9.5895, 7.7247> <-3.6624, 9.5532, 7.7374>
		<-3.8137, 9.6686, 7.7450> <-3.7766, 9.6305, 7.7408> <-3.7261, 9.5790, 7.7450> <-3.6917, 9.5388, 7.7383>
		<-3.8348, 9.6555, 7.7504> <-3.7977, 9.6174, 7.7462> <-3.7465, 9.5673, 7.7506> <-3.7121, 9.5272, 7.7439>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7626, 9.6982, 7.7382> <-3.7827, 9.6847, 7.7461> <-3.8137, 9.6686, 7.7450> <-3.8348, 9.6555, 7.7504>
		<-3.7879, 9.7263, 7.7388> <-3.8080, 9.7129, 7.7466> <-3.8443, 9.7000, 7.7485> <-3.8654, 9.6869, 7.7539>
		<-3.8214, 9.7641, 7.7365> <-3.8480, 9.7530, 7.7475> <-3.8800, 9.7360, 7.7582> <-3.9079, 9.7259, 7.7665>
		<-3.8461, 9.7927, 7.7365> <-3.8728, 9.7817, 7.7475> <-3.9094, 9.7686, 7.7611> <-3.9374, 9.7584, 7.7694>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8348, 9.6555, 7.7504> <-3.7977, 9.6174, 7.7462> <-3.7465, 9.5673, 7.7506> <-3.7121, 9.5272, 7.7439>
		<-3.8545, 9.6433, 7.7554> <-3.8174, 9.6053, 7.7512> <-3.7703, 9.5537, 7.7571> <-3.7359, 9.5135, 7.7503>
		<-3.8782, 9.6261, 7.7683> <-3.8455, 9.5864, 7.7668> <-3.7971, 9.5336, 7.7577> <-3.7648, 9.4946, 7.7668>
		<-3.8982, 9.6143, 7.7727> <-3.8654, 9.5745, 7.7712> <-3.8216, 9.5206, 7.7630> <-3.7892, 9.4816, 7.7722>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8348, 9.6555, 7.7504> <-3.8545, 9.6433, 7.7554> <-3.8782, 9.6261, 7.7683> <-3.8982, 9.6143, 7.7727>
		<-3.8654, 9.6869, 7.7539> <-3.8850, 9.6747, 7.7589> <-3.9086, 9.6631, 7.7698> <-3.9285, 9.6512, 7.7742>
		<-3.9079, 9.7259, 7.7665> <-3.9261, 9.7193, 7.7720> <-3.9493, 9.7068, 7.7788> <-3.9684, 9.7008, 7.7802>
		<-3.9374, 9.7584, 7.7694> <-3.9555, 9.7518, 7.7748> <-3.9804, 9.7431, 7.7808> <-3.9995, 9.7371, 7.7822>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8982, 9.6143, 7.7727> <-3.8654, 9.5745, 7.7712> <-3.8216, 9.5206, 7.7630> <-3.7892, 9.4816, 7.7722>
		<-3.9171, 9.6031, 7.7769> <-3.8843, 9.5634, 7.7754> <-3.8431, 9.5092, 7.7677> <-3.8108, 9.4701, 7.7769>
		<-3.9441, 9.5898, 7.7766> <-3.9135, 9.5505, 7.7762> <-3.8706, 9.4972, 7.7750> <-3.8420, 9.4566, 7.7718>
		<-3.9636, 9.5792, 7.7789> <-3.9330, 9.5399, 7.7785> <-3.8926, 9.4870, 7.7803> <-3.8640, 9.4464, 7.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8982, 9.6143, 7.7727> <-3.9171, 9.6031, 7.7769> <-3.9441, 9.5898, 7.7766> <-3.9636, 9.5792, 7.7789>
		<-3.9285, 9.6512, 7.7742> <-3.9474, 9.6400, 7.7784> <-3.9764, 9.6313, 7.7769> <-3.9959, 9.6207, 7.7792>
		<-3.9684, 9.7008, 7.7802> <-3.9904, 9.6939, 7.7818> <-4.0178, 9.6830, 7.7748> <-4.0397, 9.6756, 7.7763>
		<-3.9995, 9.7371, 7.7822> <-4.0215, 9.7302, 7.7838> <-4.0517, 9.7231, 7.7780> <-4.0736, 9.7157, 7.7794>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9636, 9.5792, 7.7789> <-3.9330, 9.5399, 7.7785> <-3.8926, 9.4870, 7.7803> <-3.8640, 9.4464, 7.7771>
		<-3.9922, 9.5638, 7.7822> <-3.9616, 9.5245, 7.7818> <-3.9212, 9.4739, 7.7871> <-3.8926, 9.4332, 7.7839>
		<-4.0299, 9.5416, 7.7844> <-4.0006, 9.5032, 7.7871> <-3.9596, 9.4537, 7.7936> <-3.9283, 9.4186, 7.8053>
		<-4.0586, 9.5276, 7.7913> <-4.0293, 9.4892, 7.7940> <-3.9877, 9.4396, 7.8005> <-3.9564, 9.4045, 7.8122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9636, 9.5792, 7.7789> <-3.9922, 9.5638, 7.7822> <-4.0299, 9.5416, 7.7844> <-4.0586, 9.5276, 7.7913>
		<-3.9959, 9.6207, 7.7792> <-4.0245, 9.6053, 7.7825> <-4.0641, 9.5863, 7.7814> <-4.0928, 9.5723, 7.7883>
		<-4.0397, 9.6756, 7.7763> <-4.0684, 9.6660, 7.7782> <-4.1101, 9.6494, 7.7807> <-4.1350, 9.6347, 7.7900>
		<-4.0736, 9.7157, 7.7794> <-4.1023, 9.7061, 7.7814> <-4.1425, 9.6954, 7.7841> <-4.1674, 9.6808, 7.7934>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0586, 9.5276, 7.7913> <-4.0293, 9.4892, 7.7940> <-3.9877, 9.4396, 7.8005> <-3.9564, 9.4045, 7.8122>
		<-4.0895, 9.5126, 7.7988> <-4.0601, 9.4742, 7.8014> <-4.0101, 9.4283, 7.8060> <-3.9788, 9.3933, 7.8177>
		<-4.1341, 9.4922, 7.8057> <-4.1000, 9.4514, 7.8017> <-4.0500, 9.4084, 7.8105> <-4.0109, 9.3726, 7.8049>
		<-4.1612, 9.4833, 7.8263> <-4.1270, 9.4425, 7.8223> <-4.0698, 9.3986, 7.8235> <-4.0307, 9.3628, 7.8179>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0586, 9.5276, 7.7913> <-4.0895, 9.5126, 7.7988> <-4.1341, 9.4922, 7.8057> <-4.1612, 9.4833, 7.8263>
		<-4.0928, 9.5723, 7.7883> <-4.1236, 9.5573, 7.7957> <-4.1642, 9.5281, 7.8092> <-4.1912, 9.5193, 7.8298>
		<-4.1350, 9.6347, 7.7900> <-4.1623, 9.6187, 7.8002> <-4.1955, 9.5850, 7.8147> <-4.2185, 9.5762, 7.8370>
		<-4.1674, 9.6808, 7.7934> <-4.1946, 9.6647, 7.8036> <-4.2197, 9.6250, 7.8202> <-4.2427, 9.6161, 7.8425>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1612, 9.4833, 7.8263> <-4.1808, 9.4769, 7.8413> <-4.2013, 9.4753, 7.8758> <-4.2021, 9.4804, 7.9008>
		<-4.1912, 9.5193, 7.8298> <-4.2109, 9.5128, 7.8448> <-4.2334, 9.5181, 7.8796> <-4.2343, 9.5232, 7.9045>
		<-4.2185, 9.5762, 7.8370> <-4.2383, 9.5685, 7.8561> <-4.2745, 9.5860, 7.8858> <-4.2715, 9.5840, 7.9141>
		<-4.2427, 9.6161, 7.8425> <-4.2625, 9.6085, 7.8616> <-4.3003, 9.6328, 7.8907> <-4.2972, 9.6308, 7.9190>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1612, 9.4833, 7.8263> <-4.1270, 9.4425, 7.8223> <-4.0698, 9.3986, 7.8235> <-4.0307, 9.3628, 7.8179>
		<-4.1808, 9.4769, 7.8413> <-4.1466, 9.4361, 7.8373> <-4.0914, 9.3880, 7.8377> <-4.0523, 9.3521, 7.8320>
		<-4.2013, 9.4753, 7.8758> <-4.1683, 9.4314, 7.8720> <-4.1184, 9.3798, 7.8669> <-4.0811, 9.3394, 7.8661>
		<-4.2021, 9.4804, 7.9008> <-4.1692, 9.4365, 7.8969> <-4.1182, 9.3834, 7.8947> <-4.0809, 9.3430, 7.8938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2021, 9.4804, 7.9008> <-4.2029, 9.4849, 7.9231> <-4.1839, 9.4987, 7.9533> <-4.1657, 9.5106, 7.9601>
		<-4.2343, 9.5232, 7.9045> <-4.2350, 9.5277, 7.9268> <-4.2070, 9.5249, 7.9532> <-4.1888, 9.5367, 7.9600>
		<-4.2715, 9.5840, 7.9141> <-4.2687, 9.5823, 7.9392> <-4.2347, 9.5704, 7.9547> <-4.2114, 9.5780, 7.9610>
		<-4.2972, 9.6308, 7.9190> <-4.2945, 9.6291, 7.9441> <-4.2528, 9.6001, 7.9571> <-4.2296, 9.6078, 7.9635>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2021, 9.4804, 7.9008> <-4.1692, 9.4365, 7.8969> <-4.1182, 9.3834, 7.8947> <-4.0809, 9.3430, 7.8938>
		<-4.2029, 9.4849, 7.9231> <-4.1699, 9.4411, 7.9192> <-4.1180, 9.3871, 7.9231> <-4.0807, 9.3467, 7.9222>
		<-4.1839, 9.4987, 7.9533> <-4.1466, 9.4566, 7.9534> <-4.0933, 9.4046, 7.9584> <-4.0523, 9.3661, 7.9567>
		<-4.1657, 9.5106, 7.9601> <-4.1284, 9.4685, 7.9603> <-4.0705, 9.4203, 7.9660> <-4.0296, 9.3818, 7.9644>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1657, 9.5106, 7.9601> <-4.1363, 9.5296, 7.9711> <-4.0920, 9.5542, 7.9544> <-4.0602, 9.5725, 7.9540>
		<-4.1888, 9.5367, 7.9600> <-4.1594, 9.5558, 7.9710> <-4.1144, 9.5870, 7.9581> <-4.0826, 9.6054, 7.9577>
		<-4.2114, 9.5780, 7.9610> <-4.1761, 9.5896, 7.9707> <-4.1404, 9.6339, 7.9592> <-4.1071, 9.6531, 7.9588>
		<-4.2296, 9.6078, 7.9635> <-4.1942, 9.6194, 7.9731> <-4.1617, 9.6671, 7.9656> <-4.1283, 9.6863, 7.9651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1657, 9.5106, 7.9601> <-4.1284, 9.4685, 7.9603> <-4.0705, 9.4203, 7.9660> <-4.0296, 9.3818, 7.9644>
		<-4.1363, 9.5296, 7.9711> <-4.0990, 9.4875, 7.9713> <-4.0480, 9.4358, 7.9735> <-4.0071, 9.3973, 7.9719>
		<-4.0920, 9.5542, 7.9544> <-4.0620, 9.5102, 7.9495> <-4.0066, 9.4567, 7.9584> <-3.9785, 9.4167, 7.9367>
		<-4.0602, 9.5725, 7.9540> <-4.0301, 9.5286, 7.9491> <-3.9819, 9.4706, 7.9581> <-3.9538, 9.4306, 7.9364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0602, 9.5725, 7.9540> <-4.0309, 9.5894, 7.9536> <-3.9913, 9.6112, 7.9608> <-3.9622, 9.6279, 7.9572>
		<-4.0826, 9.6054, 7.9577> <-4.0533, 9.6222, 7.9573> <-4.0132, 9.6389, 7.9607> <-3.9840, 9.6556, 7.9571>
		<-4.1071, 9.6531, 7.9588> <-4.0821, 9.6674, 7.9585> <-4.0442, 9.6789, 7.9589> <-4.0175, 9.6894, 7.9566>
		<-4.1283, 9.6863, 7.9651> <-4.1034, 9.7006, 7.9648> <-4.0645, 9.7074, 7.9633> <-4.0378, 9.7180, 7.9610>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0602, 9.5725, 7.9540> <-4.0301, 9.5286, 7.9491> <-3.9819, 9.4706, 7.9581> <-3.9538, 9.4306, 7.9364>
		<-4.0309, 9.5894, 7.9536> <-4.0009, 9.5454, 7.9486> <-3.9513, 9.4878, 7.9576> <-3.9232, 9.4478, 7.9360>
		<-3.9913, 9.6112, 7.9608> <-3.9573, 9.5680, 7.9609> <-3.9160, 9.5100, 7.9668> <-3.8829, 9.4662, 7.9653>
		<-3.9622, 9.6279, 7.9572> <-3.9281, 9.5848, 7.9574> <-3.8847, 9.5257, 7.9634> <-3.8516, 9.4819, 7.9619>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9622, 9.6279, 7.9572> <-3.9423, 9.6393, 7.9548> <-3.9185, 9.6535, 7.9391> <-3.8990, 9.6649, 7.9345>
		<-3.9840, 9.6556, 7.9571> <-3.9642, 9.6670, 7.9547> <-3.9391, 9.6792, 7.9428> <-3.9197, 9.6906, 7.9382>
		<-4.0175, 9.6894, 7.9566> <-3.9958, 9.6980, 7.9548> <-3.9687, 9.7139, 7.9491> <-3.9478, 9.7239, 7.9461>
		<-4.0378, 9.7180, 7.9610> <-4.0162, 9.7265, 7.9592> <-3.9884, 9.7400, 7.9544> <-3.9675, 9.7500, 7.9515>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9622, 9.6279, 7.9572> <-3.9281, 9.5848, 7.9574> <-3.8847, 9.5257, 7.9634> <-3.8516, 9.4819, 7.9619>
		<-3.9423, 9.6393, 7.9548> <-3.9083, 9.5961, 7.9550> <-3.8605, 9.5379, 7.9608> <-3.8273, 9.4941, 7.9593>
		<-3.9185, 9.6535, 7.9391> <-3.8830, 9.6094, 7.9327> <-3.8326, 9.5497, 7.9480> <-3.8044, 9.5061, 7.9245>
		<-3.8990, 9.6649, 7.9345> <-3.8636, 9.6208, 7.9281> <-3.8087, 9.5610, 7.9413> <-3.7805, 9.5174, 7.9178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8990, 9.6649, 7.9345> <-3.9197, 9.6906, 7.9382> <-3.9478, 9.7239, 7.9461> <-3.9675, 9.7500, 7.9515>
		<-3.8740, 9.6795, 7.9285> <-3.8946, 9.7052, 7.9323> <-3.9210, 9.7367, 7.9424> <-3.9407, 9.7629, 7.9478>
		<-3.8397, 9.7001, 7.9282> <-3.8589, 9.7245, 7.9304> <-3.8863, 9.7579, 7.9407> <-3.9054, 9.7820, 7.9452>
		<-3.8144, 9.7143, 7.9222> <-3.8336, 9.7387, 7.9243> <-3.8596, 9.7699, 7.9342> <-3.8787, 9.7940, 7.9387>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8990, 9.6649, 7.9345> <-3.8636, 9.6208, 7.9281> <-3.8087, 9.5610, 7.9413> <-3.7805, 9.5174, 7.9178>
		<-3.8740, 9.6795, 7.9285> <-3.8385, 9.6354, 7.9221> <-3.7833, 9.5731, 7.9343> <-3.7551, 9.5295, 7.9108>
		<-3.8397, 9.7001, 7.9282> <-3.8029, 9.6534, 7.9241> <-3.7526, 9.5915, 7.9331> <-3.7167, 9.5443, 7.9267>
		<-3.8144, 9.7143, 7.9222> <-3.7776, 9.6676, 7.9180> <-3.7283, 9.6047, 7.9242> <-3.6924, 9.5575, 7.9178>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8015, 9.8245, 7.9115> <-3.8313, 9.8116, 7.9207> <-3.8554, 9.8045, 7.9331> <-3.8787, 9.7940, 7.9387>
		<-3.8668, 9.8989, 7.9279> <-3.8966, 9.8860, 7.9370> <-3.9137, 9.8781, 7.9468> <-3.9370, 9.8676, 7.9524>
		<-3.9528, 9.9993, 7.9490> <-3.9732, 9.9880, 7.9573> <-3.9939, 9.9808, 7.9647> <-4.0095, 9.9705, 7.9691>
		<-4.0195, 10.0723, 7.9662> <-4.0399, 10.0610, 7.9744> <-4.0568, 10.0505, 7.9784> <-4.0724, 10.0402, 7.9828>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8015, 9.8245, 7.9115> <-3.8668, 9.8989, 7.9279> <-3.9528, 9.9993, 7.9490> <-4.0195, 10.0723, 7.9662>
		<-3.7700, 9.8381, 7.9018> <-3.8353, 9.9125, 7.9182> <-3.9319, 10.0108, 7.9406> <-3.9987, 10.0837, 7.9578>
		<-3.7407, 9.8503, 7.9041> <-3.8141, 9.9217, 7.9187> <-3.9092, 10.0189, 7.9302> <-3.9817, 10.0904, 7.9479>
		<-3.7202, 9.8625, 7.8899> <-3.7936, 9.9339, 7.9046> <-3.8935, 10.0274, 7.9221> <-3.9660, 10.0990, 7.9398>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7202, 9.8625, 7.8899> <-3.7936, 9.9339, 7.9046> <-3.8935, 10.0274, 7.9221> <-3.9660, 10.0990, 7.9398>
		<-3.6996, 9.8748, 7.8758> <-3.7731, 9.9461, 7.8904> <-3.8748, 10.0376, 7.9125> <-3.9473, 10.1092, 7.9302>
		<-3.6858, 9.8804, 7.8317> <-3.7498, 9.9496, 7.8714> <-3.8513, 10.0541, 7.8929> <-3.9223, 10.1233, 7.9176>
		<-3.6714, 9.9020, 7.8217> <-3.7353, 9.9711, 7.8614> <-3.8338, 10.0656, 7.8824> <-3.9048, 10.1348, 7.9072>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6714, 9.9020, 7.8217> <-3.6452, 9.8737, 7.8055> <-3.6261, 9.8381, 7.7480> <-3.6128, 9.8192, 7.7262>
		<-3.6505, 9.9329, 7.8074> <-3.6244, 9.9046, 7.7912> <-3.6110, 9.8505, 7.7952> <-3.5976, 9.8316, 7.7734>
		<-3.6191, 9.9889, 7.8386> <-3.5925, 9.9687, 7.8322> <-3.5690, 9.9334, 7.8099> <-3.5456, 9.9107, 7.8001>
		<-3.6131, 10.0215, 7.8163> <-3.5865, 10.0014, 7.8099> <-3.5507, 9.9761, 7.7970> <-3.5273, 9.9535, 7.7872>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6714, 9.9020, 7.8217> <-3.7353, 9.9711, 7.8614> <-3.8338, 10.0656, 7.8824> <-3.9048, 10.1348, 7.9072>
		<-3.6505, 9.9329, 7.8074> <-3.7145, 10.0020, 7.8471> <-3.8116, 10.0802, 7.8692> <-3.8826, 10.1494, 7.8939>
		<-3.6191, 9.9889, 7.8386> <-3.6845, 10.0386, 7.8544> <-3.7865, 10.1295, 7.8666> <-3.8521, 10.1786, 7.8831>
		<-3.6131, 10.0215, 7.8163> <-3.6786, 10.0712, 7.8321> <-3.7681, 10.1369, 7.8444> <-3.8337, 10.1860, 7.8610>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6131, 10.0215, 7.8163> <-3.5865, 10.0014, 7.8099> <-3.5507, 9.9761, 7.7970> <-3.5273, 9.9535, 7.7872>
		<-3.6063, 10.0590, 7.7907> <-3.5797, 10.0389, 7.7843> <-3.5357, 10.0111, 7.7865> <-3.5123, 9.9884, 7.7767>
		<-3.6245, 10.1091, 7.7440> <-3.5924, 10.0858, 7.7344> <-3.5425, 10.0593, 7.7088> <-3.5148, 10.0301, 7.7018>
		<-3.6352, 10.0998, 7.6867> <-3.6030, 10.0765, 7.6770> <-3.5542, 10.0498, 7.6724> <-3.5265, 10.0206, 7.6654>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6131, 10.0215, 7.8163> <-3.6786, 10.0712, 7.8321> <-3.7681, 10.1369, 7.8444> <-3.8337, 10.1860, 7.8610>
		<-3.6063, 10.0590, 7.7907> <-3.6717, 10.1087, 7.8065> <-3.7415, 10.1476, 7.8124> <-3.8071, 10.1967, 7.8290>
		<-3.6245, 10.1091, 7.7440> <-3.6636, 10.1373, 7.7557> <-3.7349, 10.1833, 7.7734> <-3.7742, 10.2100, 7.7874>
		<-3.6352, 10.0998, 7.6867> <-3.6742, 10.1280, 7.6984> <-3.7238, 10.1651, 7.7224> <-3.7632, 10.1918, 7.7364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6352, 10.0998, 7.6867> <-3.6742, 10.1280, 7.6984> <-3.7238, 10.1651, 7.7224> <-3.7632, 10.1918, 7.7364>
		<-3.6460, 10.0904, 7.6283> <-3.6851, 10.1186, 7.6400> <-3.7113, 10.1445, 7.6648> <-3.7507, 10.1713, 7.6788>
		<-3.6401, 10.0417, 7.5906> <-3.6746, 10.0777, 7.5947> <-3.7180, 10.1142, 7.6195> <-3.7539, 10.1459, 7.6346>
		<-3.6563, 9.9841, 7.5844> <-3.6908, 10.0201, 7.5885> <-3.7428, 10.0638, 7.5923> <-3.7787, 10.0954, 7.6074>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6352, 10.0998, 7.6867> <-3.6030, 10.0765, 7.6770> <-3.5542, 10.0498, 7.6724> <-3.5265, 10.0206, 7.6654>
		<-3.6460, 10.0904, 7.6283> <-3.6139, 10.0671, 7.6186> <-3.5676, 10.0389, 7.6309> <-3.5398, 10.0098, 7.6240>
		<-3.6401, 10.0417, 7.5906> <-3.6183, 10.0190, 7.5880> <-3.5937, 9.9660, 7.5721> <-3.5752, 9.9405, 7.5734>
		<-3.6563, 9.9841, 7.5844> <-3.6345, 9.9614, 7.5819> <-3.6107, 9.9262, 7.5841> <-3.5922, 9.9008, 7.5854>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6563, 9.9841, 7.5844> <-3.6908, 10.0201, 7.5885> <-3.7428, 10.0638, 7.5923> <-3.7787, 10.0954, 7.6074>
		<-3.6711, 9.9312, 7.5788> <-3.7057, 9.9673, 7.5829> <-3.7613, 10.0263, 7.5721> <-3.7972, 10.0579, 7.5872>
		<-3.6795, 9.9029, 7.6399> <-3.7265, 9.9394, 7.6224> <-3.7879, 9.9843, 7.6177> <-3.8299, 10.0297, 7.6236>
		<-3.6992, 9.8722, 7.6623> <-3.7463, 9.9087, 7.6448> <-3.8124, 9.9612, 7.6307> <-3.8544, 10.0066, 7.6366>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6563, 9.9841, 7.5844> <-3.6345, 9.9614, 7.5819> <-3.6107, 9.9262, 7.5841> <-3.5922, 9.9008, 7.5854>
		<-3.6711, 9.9312, 7.5788> <-3.6494, 9.9086, 7.5762> <-3.6284, 9.8851, 7.5965> <-3.6098, 9.8596, 7.5979>
		<-3.6795, 9.9029, 7.6399> <-3.6522, 9.8818, 7.6500> <-3.6471, 9.8195, 7.6661> <-3.6274, 9.8074, 7.6807>
		<-3.6992, 9.8722, 7.6623> <-3.6719, 9.8510, 7.6724> <-3.6325, 9.8313, 7.7116> <-3.6128, 9.8192, 7.7262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6992, 9.8722, 7.6623> <-3.7463, 9.9087, 7.6448> <-3.8124, 9.9612, 7.6307> <-3.8544, 10.0066, 7.6366>
		<-3.7089, 9.8569, 7.6734> <-3.7560, 9.8934, 7.6559> <-3.8246, 9.9497, 7.6371> <-3.8665, 9.9951, 7.6430>
		<-3.7295, 9.8472, 7.6815> <-3.7727, 9.8925, 7.6773> <-3.8357, 9.9430, 7.6555> <-3.8793, 9.9880, 7.6573>
		<-3.7515, 9.8354, 7.6926> <-3.7947, 9.8807, 7.6884> <-3.8540, 9.9382, 7.6686> <-3.8977, 9.9832, 7.6704>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7515, 9.8354, 7.6926> <-3.7947, 9.8807, 7.6884> <-3.8540, 9.9382, 7.6686> <-3.8977, 9.9832, 7.6704>
		<-3.7865, 9.8165, 7.7102> <-3.8296, 9.8618, 7.7060> <-3.8911, 9.9284, 7.6951> <-3.9347, 9.9734, 7.6968>
		<-3.8169, 9.8048, 7.7244> <-3.8624, 9.8574, 7.7244> <-3.9184, 9.9227, 7.7238> <-3.9648, 9.9744, 7.7215>
		<-3.8461, 9.7927, 7.7365> <-3.8916, 9.8454, 7.7364> <-3.9501, 9.9173, 7.7404> <-3.9965, 9.9691, 7.7380>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8461, 9.7927, 7.7365> <-3.8916, 9.8454, 7.7364> <-3.9501, 9.9173, 7.7404> <-3.9965, 9.9691, 7.7380>
		<-3.8728, 9.7817, 7.7475> <-3.9182, 9.8343, 7.7474> <-3.9797, 9.9123, 7.7558> <-4.0261, 9.9641, 7.7534>
		<-3.9094, 9.7686, 7.7611> <-3.9598, 9.8242, 7.7659> <-4.0232, 9.8977, 7.7722> <-4.0691, 9.9570, 7.7664>
		<-3.9374, 9.7584, 7.7694> <-3.9877, 9.8141, 7.7743> <-4.0544, 9.8895, 7.7819> <-4.1003, 9.9489, 7.7761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9374, 9.7584, 7.7694> <-3.9877, 9.8141, 7.7743> <-4.0544, 9.8895, 7.7819> <-4.1003, 9.9489, 7.7761>
		<-3.9555, 9.7518, 7.7748> <-4.0059, 9.8075, 7.7797> <-4.0738, 9.8845, 7.7879> <-4.1197, 9.9438, 7.7821>
		<-3.9804, 9.7431, 7.7808> <-4.0292, 9.8001, 7.7840> <-4.0968, 9.8766, 7.7904> <-4.1456, 9.9335, 7.7860>
		<-3.9995, 9.7371, 7.7822> <-4.0483, 9.7941, 7.7854> <-4.1156, 9.8683, 7.7944> <-4.1645, 9.9252, 7.7900>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9995, 9.7371, 7.7822> <-4.0483, 9.7941, 7.7854> <-4.1156, 9.8683, 7.7944> <-4.1645, 9.9252, 7.7900>
		<-4.0215, 9.7302, 7.7838> <-4.0703, 9.7872, 7.7870> <-4.1353, 9.8597, 7.7986> <-4.1841, 9.9166, 7.7942>
		<-4.0517, 9.7231, 7.7780> <-4.0973, 9.7771, 7.7822> <-4.1654, 9.8491, 7.8001> <-4.2100, 9.9042, 7.7996>
		<-4.0736, 9.7157, 7.7794> <-4.1192, 9.7698, 7.7837> <-4.1836, 9.8376, 7.8039> <-4.2282, 9.8927, 7.8033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0736, 9.7157, 7.7794> <-4.1192, 9.7698, 7.7837> <-4.1836, 9.8376, 7.8039> <-4.2282, 9.8927, 7.8033>
		<-4.1023, 9.7061, 7.7814> <-4.1479, 9.7601, 7.7856> <-4.2017, 9.8262, 7.8076> <-4.2462, 9.8813, 7.8071>
		<-4.1425, 9.6954, 7.7841> <-4.1780, 9.7460, 7.7878> <-4.2346, 9.8155, 7.8054> <-4.2719, 9.8649, 7.8074>
		<-4.1674, 9.6808, 7.7934> <-4.2029, 9.7313, 7.7971> <-4.2475, 9.7997, 7.8130> <-4.2847, 9.8492, 7.8150>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1674, 9.6808, 7.7934> <-4.2029, 9.7313, 7.7971> <-4.2475, 9.7997, 7.8130> <-4.2847, 9.8492, 7.8150>
		<-4.1946, 9.6647, 7.8036> <-4.2302, 9.7153, 7.8073> <-4.2666, 9.7762, 7.8244> <-4.3038, 9.8256, 7.8264>
		<-4.2197, 9.6250, 7.8202> <-4.2467, 9.6697, 7.8263> <-4.2888, 9.7358, 7.8404> <-4.3157, 9.7810, 7.8412>
		<-4.2427, 9.6161, 7.8425> <-4.2697, 9.6608, 7.8486> <-4.3047, 9.7204, 7.8640> <-4.3316, 9.7655, 7.8648>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2427, 9.6161, 7.8425> <-4.2697, 9.6608, 7.8486> <-4.3047, 9.7204, 7.8640> <-4.3316, 9.7655, 7.8648>
		<-4.2625, 9.6085, 7.8616> <-4.2895, 9.6532, 7.8677> <-4.3156, 9.7098, 7.8802> <-4.3426, 9.7549, 7.8810>
		<-4.3003, 9.6328, 7.8907> <-4.3230, 9.6739, 7.8951> <-4.3404, 9.7257, 7.9110> <-4.3620, 9.7677, 7.9100>
		<-4.2972, 9.6308, 7.9190> <-4.3199, 9.6720, 7.9234> <-4.3417, 9.7310, 7.9326> <-4.3633, 9.7730, 7.9316>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2972, 9.6308, 7.9190> <-4.3199, 9.6720, 7.9234> <-4.3417, 9.7310, 7.9326> <-4.3633, 9.7730, 7.9316>
		<-4.2945, 9.6291, 7.9441> <-4.3172, 9.6702, 7.9484> <-4.3428, 9.7354, 7.9504> <-4.3643, 9.7773, 7.9494>
		<-4.2528, 9.6001, 7.9571> <-4.2866, 9.6557, 7.9617> <-4.3150, 9.7257, 7.9765> <-4.3485, 9.7816, 7.9747>
		<-4.2296, 9.6078, 7.9635> <-4.2634, 9.6633, 7.9680> <-4.3052, 9.7387, 7.9852> <-4.3388, 9.7945, 7.9834>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2296, 9.6078, 7.9635> <-4.2634, 9.6633, 7.9680> <-4.3052, 9.7387, 7.9852> <-4.3388, 9.7945, 7.9834>
		<-4.1942, 9.6194, 7.9731> <-4.2281, 9.6749, 7.9777> <-4.2847, 9.7661, 8.0037> <-4.3182, 9.8219, 8.0019>
		<-4.1617, 9.6671, 7.9656> <-4.2031, 9.7320, 7.9780> <-4.2488, 9.8069, 8.0048> <-4.2944, 9.8698, 8.0119>
		<-4.1283, 9.6863, 7.9651> <-4.1698, 9.7511, 7.9775> <-4.2233, 9.8360, 8.0092> <-4.2688, 9.8988, 8.0163>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1283, 9.6863, 7.9651> <-4.1698, 9.7511, 7.9775> <-4.2233, 9.8360, 8.0092> <-4.2688, 9.8988, 8.0163>
		<-4.1034, 9.7006, 7.9648> <-4.1448, 9.7655, 7.9772> <-4.2050, 9.8568, 8.0124> <-4.2505, 9.9196, 8.0195>
		<-4.0645, 9.7074, 7.9633> <-4.1146, 9.7777, 7.9742> <-4.1653, 9.8721, 8.0003> <-4.2187, 9.9401, 8.0109>
		<-4.0378, 9.7180, 7.9610> <-4.0879, 9.7883, 7.9719> <-4.1429, 9.8886, 7.9976> <-4.1963, 9.9565, 8.0082>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0378, 9.7180, 7.9610> <-4.0879, 9.7883, 7.9719> <-4.1429, 9.8886, 7.9976> <-4.1963, 9.9565, 8.0082>
		<-4.0162, 9.7265, 7.9592> <-4.0663, 9.7969, 7.9701> <-4.1279, 9.8996, 7.9958> <-4.1813, 9.9675, 8.0064>
		<-3.9884, 9.7400, 7.9544> <-4.0423, 9.8115, 7.9691> <-4.1018, 9.9111, 7.9917> <-4.1596, 9.9798, 8.0045>
		<-3.9675, 9.7500, 7.9515> <-4.0214, 9.8215, 7.9662> <-4.0866, 9.9214, 7.9886> <-4.1443, 9.9901, 8.0014>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9675, 9.7500, 7.9515> <-4.0214, 9.8215, 7.9662> <-4.0866, 9.9214, 7.9886> <-4.1443, 9.9901, 8.0014>
		<-3.9407, 9.7629, 7.9478> <-3.9946, 9.8343, 7.9624> <-4.0646, 9.9362, 7.9841> <-4.1224, 10.0049, 7.9969>
		<-3.9054, 9.7820, 7.9452> <-3.9637, 9.8557, 7.9589> <-4.0314, 9.9561, 7.9753> <-4.0943, 10.0259, 7.9890>
		<-3.8787, 9.7940, 7.9387> <-3.9370, 9.8676, 7.9524> <-4.0095, 9.9705, 7.9691> <-4.0724, 10.0402, 7.9828>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0195, 10.0723, 7.9662> <-4.0399, 10.0610, 7.9744> <-4.0568, 10.0505, 7.9784> <-4.0724, 10.0402, 7.9828>
		<-4.0614, 10.1181, 7.9770> <-4.0818, 10.1068, 7.9852> <-4.0971, 10.0952, 7.9872> <-4.1128, 10.0849, 7.9916>
		<-4.1199, 10.1751, 7.9982> <-4.1420, 10.1574, 8.0038> <-4.1613, 10.1453, 8.0060> <-4.1787, 10.1313, 8.0084>
		<-4.1634, 10.2203, 8.0047> <-4.1855, 10.2026, 8.0103> <-4.2042, 10.1881, 8.0110> <-4.2216, 10.1740, 8.0135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0195, 10.0723, 7.9662> <-4.0614, 10.1181, 7.9770> <-4.1199, 10.1751, 7.9982> <-4.1634, 10.2203, 8.0047>
		<-3.9987, 10.0837, 7.9578> <-4.0405, 10.1296, 7.9686> <-4.1023, 10.1893, 7.9937> <-4.1458, 10.2344, 8.0002>
		<-3.9817, 10.0904, 7.9479> <-4.0289, 10.1371, 7.9595> <-4.0853, 10.1978, 7.9856> <-4.1320, 10.2456, 7.9937>
		<-3.9660, 10.0990, 7.9398> <-4.0132, 10.1456, 7.9514> <-4.0722, 10.2084, 7.9794> <-4.1189, 10.2562, 7.9875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9660, 10.0990, 7.9398> <-4.0132, 10.1456, 7.9514> <-4.0722, 10.2084, 7.9794> <-4.1189, 10.2562, 7.9875>
		<-3.9473, 10.1092, 7.9302> <-3.9945, 10.1558, 7.9417> <-4.0582, 10.2199, 7.9727> <-4.1049, 10.2677, 7.9808>
		<-3.9223, 10.1233, 7.9176> <-3.9719, 10.1716, 7.9349> <-4.0356, 10.2336, 7.9618> <-4.0863, 10.2829, 7.9712>
		<-3.9048, 10.1348, 7.9072> <-3.9544, 10.1832, 7.9244> <-4.0226, 10.2443, 7.9524> <-4.0733, 10.2937, 7.9617>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9048, 10.1348, 7.9072> <-3.9544, 10.1832, 7.9244> <-4.0226, 10.2443, 7.9524> <-4.0733, 10.2937, 7.9617>
		<-3.8826, 10.1494, 7.8939> <-3.9322, 10.1978, 7.9112> <-4.0082, 10.2563, 7.9418> <-4.0589, 10.3057, 7.9512>
		<-3.8521, 10.1786, 7.8831> <-3.9110, 10.2226, 7.8980> <-3.9802, 10.2754, 7.9291> <-4.0363, 10.3241, 7.9395>
		<-3.8337, 10.1860, 7.8610> <-3.8927, 10.2300, 7.8759> <-3.9718, 10.2831, 7.9108> <-4.0280, 10.3318, 7.9212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8337, 10.1860, 7.8610> <-3.8927, 10.2300, 7.8759> <-3.9718, 10.2831, 7.9108> <-4.0280, 10.3318, 7.9212>
		<-3.8071, 10.1967, 7.8290> <-3.8661, 10.2407, 7.8438> <-3.9595, 10.2945, 7.8838> <-4.0156, 10.3431, 7.8942>
		<-3.7742, 10.2100, 7.7874> <-3.8469, 10.2594, 7.8132> <-3.9327, 10.2987, 7.8459> <-4.0039, 10.3545, 7.8600>
		<-3.7632, 10.1918, 7.7364> <-3.8358, 10.2412, 7.7622> <-3.9371, 10.2978, 7.8052> <-4.0083, 10.3536, 7.8193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7632, 10.1918, 7.7364> <-3.8358, 10.2412, 7.7622> <-3.9371, 10.2978, 7.8052> <-4.0083, 10.3536, 7.8193>
		<-3.7507, 10.1713, 7.6788> <-3.8233, 10.2207, 7.7046> <-3.9405, 10.2971, 7.7729> <-4.0117, 10.3529, 7.7870>
		<-3.7539, 10.1459, 7.6346> <-3.8358, 10.2181, 7.6691> <-3.9439, 10.2672, 7.7471> <-4.0276, 10.3413, 7.7718>
		<-3.7787, 10.0954, 7.6074> <-3.8606, 10.1677, 7.6419> <-3.9626, 10.2540, 7.7240> <-4.0463, 10.3281, 7.7487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7787, 10.0954, 7.6074> <-3.8606, 10.1677, 7.6419> <-3.9626, 10.2540, 7.7240> <-4.0463, 10.3281, 7.7487>
		<-3.7972, 10.0579, 7.5872> <-3.8791, 10.1302, 7.6217> <-3.9766, 10.2441, 7.7067> <-4.0603, 10.3182, 7.7314>
		<-3.8299, 10.0297, 7.6236> <-3.9073, 10.1134, 7.6346> <-3.9986, 10.2230, 7.7100> <-4.0761, 10.3063, 7.7232>
		<-3.8544, 10.0066, 7.6366> <-3.9318, 10.0903, 7.6476> <-4.0131, 10.2120, 7.7045> <-4.0906, 10.2953, 7.7177>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8544, 10.0066, 7.6366> <-3.9318, 10.0903, 7.6476> <-4.0131, 10.2120, 7.7045> <-4.0906, 10.2953, 7.7177>
		<-3.8665, 9.9951, 7.6430> <-3.9439, 10.0788, 7.6540> <-4.0308, 10.1985, 7.6978> <-4.1083, 10.2818, 7.7110>
		<-3.8793, 9.9880, 7.6573> <-3.9563, 10.0674, 7.6604> <-4.0496, 10.1889, 7.7039> <-4.1282, 10.2667, 7.7087>
		<-3.8977, 9.9832, 7.6704> <-3.9747, 10.0626, 7.6735> <-4.0730, 10.1702, 7.7040> <-4.1516, 10.2479, 7.7088>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8977, 9.9832, 7.6704> <-3.9747, 10.0626, 7.6735> <-4.0730, 10.1702, 7.7040> <-4.1516, 10.2479, 7.7088>
		<-3.9347, 9.9734, 7.6968> <-4.0117, 10.0528, 7.7000> <-4.0963, 10.1516, 7.7041> <-4.1749, 10.2293, 7.7089>
		<-3.9648, 9.9744, 7.7215> <-4.0279, 10.0447, 7.7183> <-4.1293, 10.1439, 7.7209> <-4.1930, 10.2134, 7.7144>
		<-3.9965, 9.9691, 7.7380> <-4.0596, 10.0394, 7.7348> <-4.1472, 10.1296, 7.7246> <-4.2109, 10.1992, 7.7181>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9965, 9.9691, 7.7380> <-4.0596, 10.0394, 7.7348> <-4.1472, 10.1296, 7.7246> <-4.2109, 10.1992, 7.7181>
		<-4.0261, 9.9641, 7.7534> <-4.0892, 10.0344, 7.7503> <-4.1598, 10.1195, 7.7271> <-4.2235, 10.1891, 7.7206>
		<-4.0691, 9.9570, 7.7664> <-4.1185, 10.0210, 7.7602> <-4.1884, 10.1157, 7.7349> <-4.2409, 10.1768, 7.7255>
		<-4.1003, 9.9489, 7.7761> <-4.1498, 10.0128, 7.7698> <-4.2008, 10.1057, 7.7388> <-4.2532, 10.1669, 7.7295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1003, 9.9489, 7.7761> <-4.1498, 10.0128, 7.7698> <-4.2008, 10.1057, 7.7388> <-4.2532, 10.1669, 7.7295>
		<-4.1197, 9.9438, 7.7821> <-4.1692, 10.0078, 7.7759> <-4.2212, 10.0892, 7.7454> <-4.2737, 10.1504, 7.7361>
		<-4.1456, 9.9335, 7.7860> <-4.1934, 9.9892, 7.7817> <-4.2533, 10.0715, 7.7537> <-4.3003, 10.1274, 7.7449>
		<-4.1645, 9.9252, 7.7900> <-4.2123, 9.9809, 7.7857> <-4.2732, 10.0550, 7.7620> <-4.3202, 10.1109, 7.7533>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1645, 9.9252, 7.7900> <-4.2123, 9.9809, 7.7857> <-4.2732, 10.0550, 7.7620> <-4.3202, 10.1109, 7.7533>
		<-4.1841, 9.9166, 7.7942> <-4.2319, 9.9723, 7.7899> <-4.2867, 10.0439, 7.7677> <-4.3336, 10.0998, 7.7589>
		<-4.2100, 9.9042, 7.7996> <-4.2532, 9.9576, 7.7991> <-4.3090, 10.0318, 7.7767> <-4.3509, 10.0857, 7.7693>
		<-4.2282, 9.8927, 7.8033> <-4.2714, 9.9461, 7.8028> <-4.3222, 10.0210, 7.7834> <-4.3642, 10.0748, 7.7761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2282, 9.8927, 7.8033> <-4.2714, 9.9461, 7.8028> <-4.3222, 10.0210, 7.7834> <-4.3642, 10.0748, 7.7761>
		<-4.2462, 9.8813, 7.8071> <-4.2894, 9.9347, 7.8066> <-4.3407, 10.0058, 7.7928> <-4.3826, 10.0596, 7.7855>
		<-4.2719, 9.8649, 7.8074> <-4.3124, 9.9188, 7.8095> <-4.3673, 9.9853, 7.7997> <-4.4086, 10.0385, 7.7947>
		<-4.2847, 9.8492, 7.8150> <-4.3252, 9.9030, 7.8171> <-4.3846, 9.9709, 7.8122> <-4.4259, 10.0241, 7.8071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2847, 9.8492, 7.8150> <-4.3252, 9.9030, 7.8171> <-4.3846, 9.9709, 7.8122> <-4.4259, 10.0241, 7.8071>
		<-4.3038, 9.8256, 7.8264> <-4.3444, 9.8795, 7.8285> <-4.3982, 9.9596, 7.8219> <-4.4394, 10.0128, 7.8169>
		<-4.3157, 9.7810, 7.8412> <-4.3560, 9.8485, 7.8424> <-4.4144, 9.9323, 7.8385> <-4.4577, 9.9976, 7.8322>
		<-4.3316, 9.7655, 7.8648> <-4.3719, 9.8331, 7.8660> <-4.4225, 9.9249, 7.8554> <-4.4658, 9.9902, 7.8490>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3316, 9.7655, 7.8648> <-4.3719, 9.8331, 7.8660> <-4.4225, 9.9249, 7.8554> <-4.4658, 9.9902, 7.8490>
		<-4.3426, 9.7549, 7.8810> <-4.3829, 9.8224, 7.8822> <-4.4302, 9.9178, 7.8714> <-4.4735, 9.9832, 7.8650>
		<-4.3620, 9.7677, 7.9100> <-4.3942, 9.8305, 7.9084> <-4.4392, 9.9194, 7.8977> <-4.4769, 9.9787, 7.8917>
		<-4.3633, 9.7730, 7.9316> <-4.3955, 9.8358, 7.9300> <-4.4378, 9.9193, 7.9167> <-4.4756, 9.9786, 7.9107>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3633, 9.7730, 7.9316> <-4.3955, 9.8358, 7.9300> <-4.4378, 9.9193, 7.9167> <-4.4756, 9.9786, 7.9107>
		<-4.3643, 9.7773, 7.9494> <-4.3965, 9.8401, 7.9479> <-4.4369, 9.9192, 7.9302> <-4.4746, 9.9785, 7.9242>
		<-4.3485, 9.7816, 7.9747> <-4.3841, 9.8410, 7.9728> <-4.4285, 9.9261, 7.9489> <-4.4669, 9.9835, 7.9422>
		<-4.3388, 9.7945, 7.9834> <-4.3744, 9.8539, 7.9815> <-4.4202, 9.9321, 7.9578> <-4.4586, 9.9894, 7.9511>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3388, 9.7945, 7.9834> <-4.3744, 9.8539, 7.9815> <-4.4202, 9.9321, 7.9578> <-4.4586, 9.9894, 7.9511>
		<-4.3182, 9.8219, 8.0019> <-4.3539, 9.8814, 8.0000> <-4.4010, 9.9459, 7.9783> <-4.4393, 10.0033, 7.9716>
		<-4.2944, 9.8698, 8.0119> <-4.3270, 9.9148, 8.0170> <-4.3760, 9.9806, 7.9956> <-4.4098, 10.0250, 7.9934>
		<-4.2688, 9.8988, 8.0163> <-4.3015, 9.9438, 8.0214> <-4.3529, 9.9981, 8.0077> <-4.3867, 10.0425, 8.0055>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2688, 9.8988, 8.0163> <-4.3015, 9.9438, 8.0214> <-4.3529, 9.9981, 8.0077> <-4.3867, 10.0425, 8.0055>
		<-4.2505, 9.9196, 8.0195> <-4.2832, 9.9646, 8.0246> <-4.3364, 10.0106, 8.0163> <-4.3701, 10.0550, 8.0141>
		<-4.2187, 9.9401, 8.0109> <-4.2531, 9.9838, 8.0177> <-4.3099, 10.0314, 8.0153> <-4.3462, 10.0741, 8.0162>
		<-4.1963, 9.9565, 8.0082> <-4.2307, 10.0002, 8.0150> <-4.2924, 10.0451, 8.0180> <-4.3287, 10.0878, 8.0188>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1963, 9.9565, 8.0082> <-4.2307, 10.0002, 8.0150> <-4.2924, 10.0451, 8.0180> <-4.3287, 10.0878, 8.0188>
		<-4.1813, 9.9675, 8.0064> <-4.2157, 10.0112, 8.0132> <-4.2785, 10.0560, 8.0201> <-4.3148, 10.0987, 8.0209>
		<-4.1596, 9.9798, 8.0045> <-4.1966, 10.0238, 8.0127> <-4.2576, 10.0699, 8.0194> <-4.2960, 10.1133, 8.0220>
		<-4.1443, 9.9901, 8.0014> <-4.1813, 10.0341, 8.0096> <-4.2437, 10.0810, 8.0187> <-4.2822, 10.1244, 8.0213>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1443, 9.9901, 8.0014> <-4.1813, 10.0341, 8.0096> <-4.2437, 10.0810, 8.0187> <-4.2822, 10.1244, 8.0213>
		<-4.1224, 10.0049, 7.9969> <-4.1594, 10.0489, 8.0051> <-4.2254, 10.0958, 8.0178> <-4.2638, 10.1392, 8.0204>
		<-4.0943, 10.0259, 7.9890> <-4.1346, 10.0705, 7.9978> <-4.1969, 10.1165, 8.0110> <-4.2399, 10.1593, 8.0160>
		<-4.0724, 10.0402, 7.9828> <-4.1128, 10.0849, 7.9916> <-4.1787, 10.1313, 8.0084> <-4.2216, 10.1740, 8.0135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5501, 9.8383, 7.5922> <-3.5996, 9.8071, 7.6197> <-3.6122, 9.7953, 7.6874> <-3.5954, 9.8051, 7.7227>
		<-3.5589, 9.8592, 7.5912> <-3.6084, 9.8280, 7.6188> <-3.6169, 9.8002, 7.6883> <-3.6000, 9.8100, 7.7236>
		<-3.5789, 9.8825, 7.5864> <-3.5965, 9.8413, 7.5988> <-3.6320, 9.8121, 7.6789> <-3.6173, 9.8239, 7.7244>
		<-3.5922, 9.9008, 7.5854> <-3.6098, 9.8596, 7.5979> <-3.6274, 9.8074, 7.6807> <-3.6128, 9.8192, 7.7262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1634, 10.2203, 8.0047> <-4.1855, 10.2026, 8.0103> <-4.2042, 10.1881, 8.0110> <-4.2216, 10.1740, 8.0135>
		<-4.2292, 10.2884, 8.0145> <-4.2513, 10.2707, 8.0201> <-4.2710, 10.2546, 8.0189> <-4.2883, 10.2406, 8.0214>
		<-4.3176, 10.3797, 8.0207> <-4.3385, 10.3626, 8.0253> <-4.3563, 10.3484, 8.0260> <-4.3726, 10.3348, 8.0267>
		<-4.3828, 10.4491, 8.0203> <-4.4037, 10.4320, 8.0250> <-4.4208, 10.4176, 8.0252> <-4.4371, 10.4040, 8.0260>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1634, 10.2203, 8.0047> <-4.2292, 10.2884, 8.0145> <-4.3176, 10.3797, 8.0207> <-4.3828, 10.4491, 8.0203>
		<-4.1458, 10.2344, 8.0002> <-4.2115, 10.3026, 8.0100> <-4.3011, 10.3932, 8.0170> <-4.3663, 10.4626, 8.0167>
		<-4.1320, 10.2456, 7.9937> <-4.1980, 10.3133, 8.0051> <-4.2877, 10.4037, 8.0107> <-4.3531, 10.4729, 8.0105>
		<-4.1189, 10.2562, 7.9875> <-4.1850, 10.3239, 7.9989> <-4.2753, 10.4135, 8.0048> <-4.3407, 10.4827, 8.0046>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1189, 10.2562, 7.9875> <-4.1850, 10.3239, 7.9989> <-4.2753, 10.4135, 8.0048> <-4.3407, 10.4827, 8.0046>
		<-4.1049, 10.2677, 7.9808> <-4.1709, 10.3353, 7.9922> <-4.2619, 10.4240, 7.9984> <-4.3273, 10.4932, 7.9983>
		<-4.0863, 10.2829, 7.9712> <-4.1537, 10.3485, 7.9836> <-4.2440, 10.4385, 7.9892> <-4.3094, 10.5072, 7.9890>
		<-4.0733, 10.2937, 7.9617> <-4.1407, 10.3593, 7.9742> <-4.2315, 10.4479, 7.9799> <-4.2970, 10.5165, 7.9797>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0733, 10.2937, 7.9617> <-4.1407, 10.3593, 7.9742> <-4.2315, 10.4479, 7.9799> <-4.2970, 10.5165, 7.9797>
		<-4.0589, 10.3057, 7.9512> <-4.1263, 10.3713, 7.9637> <-4.2174, 10.4585, 7.9693> <-4.2829, 10.5272, 7.9691>
		<-4.0363, 10.3241, 7.9395> <-4.1066, 10.3850, 7.9525> <-4.1958, 10.4766, 7.9572> <-4.2609, 10.5442, 7.9568>
		<-4.0280, 10.3318, 7.9212> <-4.0983, 10.3927, 7.9342> <-4.1875, 10.4814, 7.9390> <-4.2526, 10.5490, 7.9385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0280, 10.3318, 7.9212> <-4.0983, 10.3927, 7.9342> <-4.1875, 10.4814, 7.9390> <-4.2526, 10.5490, 7.9385>
		<-4.0156, 10.3431, 7.8942> <-4.0859, 10.4040, 7.9072> <-4.1739, 10.4892, 7.9090> <-4.2390, 10.5569, 7.9086>
		<-4.0039, 10.3545, 7.8600> <-4.0737, 10.4092, 7.8738> <-4.1638, 10.4987, 7.8738> <-4.2268, 10.5627, 7.8717>
		<-4.0083, 10.3536, 7.8193> <-4.0781, 10.4083, 7.8331> <-4.1653, 10.4923, 7.8308> <-4.2282, 10.5563, 7.8287>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0083, 10.3536, 7.8193> <-4.0781, 10.4083, 7.8331> <-4.1653, 10.4923, 7.8308> <-4.2282, 10.5563, 7.8287>
		<-4.0117, 10.3529, 7.7870> <-4.0815, 10.4076, 7.8009> <-4.1665, 10.4870, 7.7955> <-4.2294, 10.5510, 7.7934>
		<-4.0276, 10.3413, 7.7718> <-4.0906, 10.3971, 7.7903> <-4.1823, 10.4765, 7.7797> <-4.2429, 10.5375, 7.7760>
		<-4.0463, 10.3281, 7.7487> <-4.1093, 10.3838, 7.7673> <-4.1985, 10.4596, 7.7527> <-4.2591, 10.5206, 7.7491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0463, 10.3281, 7.7487> <-4.1093, 10.3838, 7.7673> <-4.1985, 10.4596, 7.7527> <-4.2591, 10.5206, 7.7491>
		<-4.0603, 10.3182, 7.7314> <-4.1233, 10.3739, 7.7500> <-4.2100, 10.4476, 7.7336> <-4.2706, 10.5087, 7.7300>
		<-4.0761, 10.3063, 7.7232> <-4.1330, 10.3674, 7.7329> <-4.2255, 10.4360, 7.7239> <-4.2847, 10.4955, 7.7194>
		<-4.0906, 10.2953, 7.7177> <-4.1475, 10.3564, 7.7274> <-4.2390, 10.4238, 7.7167> <-4.2982, 10.4832, 7.7122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0906, 10.2953, 7.7177> <-4.1475, 10.3564, 7.7274> <-4.2390, 10.4238, 7.7167> <-4.2982, 10.4832, 7.7122>
		<-4.1083, 10.2818, 7.7110> <-4.1652, 10.3428, 7.7207> <-4.2546, 10.4096, 7.7084> <-4.3138, 10.4691, 7.7038>
		<-4.1282, 10.2667, 7.7087> <-4.1869, 10.3247, 7.7123> <-4.2741, 10.3948, 7.7069> <-4.3322, 10.4533, 7.7017>
		<-4.1516, 10.2479, 7.7088> <-4.2103, 10.3060, 7.7124> <-4.2960, 10.3759, 7.7035> <-4.3541, 10.4344, 7.6983>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1516, 10.2479, 7.7088> <-4.2103, 10.3060, 7.7124> <-4.2960, 10.3759, 7.7035> <-4.3541, 10.4344, 7.6983>
		<-4.1749, 10.2293, 7.7089> <-4.2336, 10.2873, 7.7124> <-4.3106, 10.3633, 7.7012> <-4.3687, 10.4218, 7.6960>
		<-4.1930, 10.2134, 7.7144> <-4.2481, 10.2737, 7.7088> <-4.3250, 10.3520, 7.7018> <-4.3809, 10.4114, 7.6956>
		<-4.2109, 10.1992, 7.7181> <-4.2660, 10.2594, 7.7124> <-4.3366, 10.3424, 7.7037> <-4.3925, 10.4019, 7.6975>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2109, 10.1992, 7.7181> <-4.2660, 10.2594, 7.7124> <-4.3366, 10.3424, 7.7037> <-4.3925, 10.4019, 7.6975>
		<-4.2235, 10.1891, 7.7206> <-4.2786, 10.2494, 7.7150> <-4.3537, 10.3283, 7.7065> <-4.4097, 10.3878, 7.7003>
		<-4.2409, 10.1768, 7.7255> <-4.2938, 10.2386, 7.7161> <-4.3750, 10.3115, 7.7146> <-4.4322, 10.3698, 7.7088>
		<-4.2532, 10.1669, 7.7295> <-4.3061, 10.2287, 7.7201> <-4.3920, 10.2978, 7.7197> <-4.4492, 10.3561, 7.7139>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2532, 10.1669, 7.7295> <-4.3061, 10.2287, 7.7201> <-4.3920, 10.2978, 7.7197> <-4.4492, 10.3561, 7.7139>
		<-4.2737, 10.1504, 7.7361> <-4.3266, 10.2121, 7.7267> <-4.4059, 10.2866, 7.7238> <-4.4630, 10.3450, 7.7181>
		<-4.3003, 10.1274, 7.7449> <-4.3526, 10.1897, 7.7352> <-4.4262, 10.2699, 7.7293> <-4.4816, 10.3298, 7.7227>
		<-4.3202, 10.1109, 7.7533> <-4.3725, 10.1732, 7.7435> <-4.4398, 10.2590, 7.7349> <-4.4953, 10.3190, 7.7283>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3202, 10.1109, 7.7533> <-4.3725, 10.1732, 7.7435> <-4.4398, 10.2590, 7.7349> <-4.4953, 10.3190, 7.7283>
		<-4.3336, 10.0998, 7.7589> <-4.3860, 10.1620, 7.7492> <-4.4523, 10.2492, 7.7400> <-4.5077, 10.3091, 7.7334>
		<-4.3509, 10.0857, 7.7693> <-4.4013, 10.1503, 7.7605> <-4.4683, 10.2363, 7.7500> <-4.5236, 10.2969, 7.7432>
		<-4.3642, 10.0748, 7.7761> <-4.4145, 10.1394, 7.7673> <-4.4805, 10.2268, 7.7563> <-4.5358, 10.2873, 7.7495>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3642, 10.0748, 7.7761> <-4.4145, 10.1394, 7.7673> <-4.4805, 10.2268, 7.7563> <-4.5358, 10.2873, 7.7495>
		<-4.3826, 10.0596, 7.7855> <-4.4330, 10.1242, 7.7767> <-4.4970, 10.2138, 7.7648> <-4.5524, 10.2744, 7.7581>
		<-4.4086, 10.0385, 7.7947> <-4.4593, 10.1039, 7.7886> <-4.5204, 10.1942, 7.7730> <-4.5756, 10.2558, 7.7661>
		<-4.4259, 10.0241, 7.8071> <-4.4766, 10.0895, 7.8010> <-4.5359, 10.1825, 7.7847> <-4.5911, 10.2442, 7.7777>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4259, 10.0241, 7.8071> <-4.4766, 10.0895, 7.8010> <-4.5359, 10.1825, 7.7847> <-4.5911, 10.2442, 7.7777>
		<-4.4394, 10.0128, 7.8169> <-4.4902, 10.0782, 7.8107> <-4.5492, 10.1725, 7.7947> <-4.6044, 10.2342, 7.7877>
		<-4.4577, 9.9976, 7.8322> <-4.5042, 10.0676, 7.8253> <-4.5668, 10.1580, 7.8104> <-4.6225, 10.2209, 7.8037>
		<-4.4658, 9.9902, 7.8490> <-4.5123, 10.0602, 7.8422> <-4.5749, 10.1532, 7.8274> <-4.6306, 10.2161, 7.8207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4658, 9.9902, 7.8490> <-4.5123, 10.0602, 7.8422> <-4.5749, 10.1532, 7.8274> <-4.6306, 10.2161, 7.8207>
		<-4.4735, 9.9832, 7.8650> <-4.5200, 10.0532, 7.8581> <-4.5833, 10.1482, 7.8452> <-4.6391, 10.2111, 7.8385>
		<-4.4769, 9.9787, 7.8917> <-4.5234, 10.0518, 7.8844> <-4.5863, 10.1457, 7.8730> <-4.6434, 10.2109, 7.8671>
		<-4.4756, 9.9786, 7.9107> <-4.5220, 10.0516, 7.9034> <-4.5862, 10.1482, 7.8932> <-4.6433, 10.2134, 7.8874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4756, 9.9786, 7.9107> <-4.5220, 10.0516, 7.9034> <-4.5862, 10.1482, 7.8932> <-4.6433, 10.2134, 7.8874>
		<-4.4746, 9.9785, 7.9242> <-4.5210, 10.0515, 7.9169> <-4.5862, 10.1500, 7.9081> <-4.6432, 10.2152, 7.9022>
		<-4.4669, 9.9835, 7.9422> <-4.5160, 10.0569, 7.9336> <-4.5792, 10.1556, 7.9270> <-4.6375, 10.2225, 7.9219>
		<-4.4586, 9.9894, 7.9511> <-4.5077, 10.0629, 7.9425> <-4.5718, 10.1631, 7.9376> <-4.6300, 10.2300, 7.9325>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4586, 9.9894, 7.9511> <-4.5077, 10.0629, 7.9425> <-4.5718, 10.1631, 7.9376> <-4.6300, 10.2300, 7.9325>
		<-4.4393, 10.0033, 7.9716> <-4.4885, 10.0767, 7.9630> <-4.5557, 10.1796, 7.9608> <-4.6139, 10.2464, 7.9557>
		<-4.4098, 10.0250, 7.9934> <-4.4655, 10.0983, 7.9898> <-4.5270, 10.2023, 7.9853> <-4.5878, 10.2714, 7.9813>
		<-4.3867, 10.0425, 8.0055> <-4.4423, 10.1158, 8.0019> <-4.5061, 10.2219, 8.0008> <-4.5668, 10.2910, 7.9969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3867, 10.0425, 8.0055> <-4.4423, 10.1158, 8.0019> <-4.5061, 10.2219, 8.0008> <-4.5668, 10.2910, 7.9969>
		<-4.3701, 10.0550, 8.0141> <-4.4258, 10.1283, 8.0105> <-4.4929, 10.2342, 8.0105> <-4.5537, 10.3033, 8.0066>
		<-4.3462, 10.0741, 8.0162> <-4.4067, 10.1452, 8.0175> <-4.4713, 10.2516, 8.0135> <-4.5329, 10.3217, 8.0108>
		<-4.3287, 10.0878, 8.0188> <-4.3891, 10.1589, 8.0202> <-4.4563, 10.2648, 8.0182> <-4.5180, 10.3348, 8.0155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3287, 10.0878, 8.0188> <-4.3891, 10.1589, 8.0202> <-4.4563, 10.2648, 8.0182> <-4.5180, 10.3348, 8.0155>
		<-4.3148, 10.0987, 8.0209> <-4.3753, 10.1698, 8.0223> <-4.4449, 10.2748, 8.0218> <-4.5066, 10.3449, 8.0191>
		<-4.2960, 10.1133, 8.0220> <-4.3583, 10.1836, 8.0263> <-4.4283, 10.2881, 8.0251> <-4.4910, 10.3582, 8.0230>
		<-4.2822, 10.1244, 8.0213> <-4.3444, 10.1948, 8.0256> <-4.4165, 10.2982, 8.0266> <-4.4792, 10.3683, 8.0245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2822, 10.1244, 8.0213> <-4.3444, 10.1948, 8.0256> <-4.4165, 10.2982, 8.0266> <-4.4792, 10.3683, 8.0245>
		<-4.2638, 10.1392, 8.0204> <-4.3261, 10.2096, 8.0247> <-4.4040, 10.3089, 8.0282> <-4.4667, 10.3790, 8.0262>
		<-4.2399, 10.1593, 8.0160> <-4.3066, 10.2259, 8.0239> <-4.3852, 10.3242, 8.0273> <-4.4498, 10.3933, 8.0265>
		<-4.2216, 10.1740, 8.0135> <-4.2883, 10.2406, 8.0214> <-4.3726, 10.3348, 8.0267> <-4.4371, 10.4040, 8.0260>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8567, 10.9583, 8.0011> <-4.7145, 10.8055, 8.0069> <-4.5258, 10.6012, 8.0196> <-4.3828, 10.4491, 8.0203>
		<-4.8777, 10.9412, 8.0054> <-4.7355, 10.7884, 8.0112> <-4.5466, 10.5842, 8.0242> <-4.4037, 10.4320, 8.0250>
		<-4.8950, 10.9266, 8.0054> <-4.7527, 10.7739, 8.0117> <-4.5633, 10.5702, 8.0235> <-4.4208, 10.4176, 8.0252>
		<-4.9113, 10.9129, 8.0051> <-4.7691, 10.7602, 8.0114> <-4.5796, 10.5566, 8.0242> <-4.4371, 10.4040, 8.0260>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8567, 10.9583, 8.0011> <-4.8401, 10.9719, 7.9977> <-4.8269, 10.9822, 7.9915> <-4.8145, 10.9920, 7.9855>
		<-4.7145, 10.8055, 8.0069> <-4.6979, 10.8191, 8.0035> <-4.6848, 10.8295, 7.9972> <-4.6724, 10.8392, 7.9912>
		<-4.5258, 10.6012, 8.0196> <-4.5092, 10.6147, 8.0159> <-4.4965, 10.6246, 8.0101> <-4.4841, 10.6344, 8.0042>
		<-4.3828, 10.4491, 8.0203> <-4.3663, 10.4626, 8.0167> <-4.3531, 10.4729, 8.0105> <-4.3407, 10.4827, 8.0046>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8145, 10.9920, 7.9855> <-4.8011, 11.0025, 7.9790> <-4.7833, 11.0164, 7.9695> <-4.7710, 11.0257, 7.9597>
		<-4.6724, 10.8392, 7.9912> <-4.6590, 10.8497, 7.9847> <-4.6411, 10.8637, 7.9755> <-4.6288, 10.8729, 7.9657>
		<-4.4841, 10.6344, 8.0042> <-4.4707, 10.6449, 7.9978> <-4.4535, 10.6583, 7.9886> <-4.4410, 10.6677, 7.9793>
		<-4.3407, 10.4827, 8.0046> <-4.3273, 10.4932, 7.9983> <-4.3094, 10.5072, 7.9890> <-4.2970, 10.5165, 7.9797>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7710, 11.0257, 7.9597> <-4.7569, 11.0362, 7.9486> <-4.7348, 11.0533, 7.9351> <-4.7272, 11.0576, 7.9162>
		<-4.6288, 10.8729, 7.9657> <-4.6147, 10.8835, 7.9546> <-4.5924, 10.9007, 7.9418> <-4.5848, 10.9050, 7.9229>
		<-4.4410, 10.6677, 7.9793> <-4.4269, 10.6783, 7.9687> <-4.4058, 10.6945, 7.9557> <-4.3975, 10.6993, 7.9375>
		<-4.2970, 10.5165, 7.9797> <-4.2829, 10.5272, 7.9691> <-4.2609, 10.5442, 7.9568> <-4.2526, 10.5490, 7.9385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7272, 11.0576, 7.9162> <-4.7138, 11.0651, 7.8830> <-4.7026, 11.0700, 7.8427> <-4.7050, 11.0627, 7.7962>
		<-4.5848, 10.9050, 7.9229> <-4.5714, 10.9125, 7.8897> <-4.5596, 10.9180, 7.8525> <-4.5620, 10.9108, 7.8060>
		<-4.3975, 10.6993, 7.9375> <-4.3838, 10.7072, 7.9076> <-4.3731, 10.7117, 7.8668> <-4.3746, 10.7052, 7.8238>
		<-4.2526, 10.5490, 7.9385> <-4.2390, 10.5569, 7.9086> <-4.2268, 10.5627, 7.8717> <-4.2282, 10.5563, 7.8287>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7050, 11.0627, 7.7962> <-4.7071, 11.0567, 7.7574> <-4.7209, 11.0429, 7.7380> <-4.7380, 11.0251, 7.7073>
		<-4.5620, 10.9108, 7.8060> <-4.5640, 10.9047, 7.7671> <-4.5772, 10.8915, 7.7505> <-4.5944, 10.8737, 7.7199>
		<-4.3746, 10.7052, 7.8238> <-4.3758, 10.7000, 7.7885> <-4.3901, 10.6858, 7.7672> <-4.4063, 10.6689, 7.7403>
		<-4.2282, 10.5563, 7.8287> <-4.2294, 10.5510, 7.7934> <-4.2429, 10.5375, 7.7760> <-4.2591, 10.5206, 7.7491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7380, 11.0251, 7.7073> <-4.7497, 11.0129, 7.6863> <-4.7641, 10.9994, 7.6739> <-4.7783, 10.9865, 7.6652>
		<-4.5944, 10.8737, 7.7199> <-4.6061, 10.8615, 7.6989> <-4.6201, 10.8484, 7.6880> <-4.6342, 10.8356, 7.6793>
		<-4.4063, 10.6689, 7.7403> <-4.4177, 10.6569, 7.7212> <-4.4320, 10.6436, 7.7082> <-4.4455, 10.6313, 7.7009>
		<-4.2591, 10.5206, 7.7491> <-4.2706, 10.5087, 7.7300> <-4.2847, 10.4955, 7.7194> <-4.2982, 10.4832, 7.7122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7783, 10.9865, 7.6652> <-4.7939, 10.9723, 7.6555> <-4.8126, 10.9562, 7.6523> <-4.8349, 10.9370, 7.6476>
		<-4.6342, 10.8356, 7.6793> <-4.6499, 10.8214, 7.6697> <-4.6684, 10.8055, 7.6675> <-4.6907, 10.7862, 7.6628>
		<-4.4455, 10.6313, 7.7009> <-4.4611, 10.6171, 7.6926> <-4.4792, 10.6016, 7.6885> <-4.5011, 10.5827, 7.6851>
		<-4.2982, 10.4832, 7.7122> <-4.3138, 10.4691, 7.7038> <-4.3322, 10.4533, 7.7017> <-4.3541, 10.4344, 7.6983>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8349, 10.9370, 7.6476> <-4.8496, 10.9243, 7.6446> <-4.8620, 10.9138, 7.6436> <-4.8738, 10.9041, 7.6453>
		<-4.6907, 10.7862, 7.6628> <-4.7054, 10.7735, 7.6598> <-4.7177, 10.7631, 7.6593> <-4.7294, 10.7534, 7.6609>
		<-4.5011, 10.5827, 7.6851> <-4.5157, 10.5701, 7.6828> <-4.5239, 10.5635, 7.6799> <-4.5355, 10.5539, 7.6818>
		<-4.3541, 10.4344, 7.6983> <-4.3687, 10.4218, 7.6960> <-4.3809, 10.4114, 7.6956> <-4.3925, 10.4019, 7.6975>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8738, 10.9041, 7.6453> <-4.8910, 10.8899, 7.6477> <-4.9135, 10.8719, 7.6561> <-4.9305, 10.8582, 7.6611>
		<-4.7294, 10.7534, 7.6609> <-4.7466, 10.7393, 7.6633> <-4.7691, 10.7213, 7.6720> <-4.7861, 10.7076, 7.6769>
		<-4.5355, 10.5539, 7.6818> <-4.5526, 10.5398, 7.6846> <-4.5783, 10.5189, 7.6941> <-4.5953, 10.5052, 7.6992>
		<-4.3925, 10.4019, 7.6975> <-4.4097, 10.3878, 7.7003> <-4.4322, 10.3698, 7.7088> <-4.4492, 10.3561, 7.7139>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9305, 10.8582, 7.6611> <-4.9444, 10.8470, 7.6651> <-4.9631, 10.8318, 7.6694> <-4.9767, 10.8210, 7.6750>
		<-4.7861, 10.7076, 7.6769> <-4.8000, 10.6964, 7.6809> <-4.8187, 10.6812, 7.6854> <-4.8323, 10.6704, 7.6910>
		<-4.5953, 10.5052, 7.6992> <-4.6091, 10.4941, 7.7033> <-4.6232, 10.4830, 7.7058> <-4.6369, 10.4722, 7.7114>
		<-4.4492, 10.3561, 7.7139> <-4.4630, 10.3450, 7.7181> <-4.4816, 10.3298, 7.7227> <-4.4953, 10.3190, 7.7283>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9767, 10.8210, 7.6750> <-4.9892, 10.8111, 7.6801> <-5.0050, 10.7989, 7.6904> <-5.0172, 10.7894, 7.6968>
		<-4.8323, 10.6704, 7.6910> <-4.8447, 10.6605, 7.6961> <-4.8606, 10.6483, 7.7062> <-4.8728, 10.6388, 7.7126>
		<-4.6369, 10.4722, 7.7114> <-4.6493, 10.4623, 7.7165> <-4.6643, 10.4508, 7.7262> <-4.6765, 10.4413, 7.7325>
		<-4.4953, 10.3190, 7.7283> <-4.5077, 10.3091, 7.7334> <-4.5236, 10.2969, 7.7432> <-4.5358, 10.2873, 7.7495>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0172, 10.7894, 7.6968> <-5.0337, 10.7765, 7.7056> <-5.0570, 10.7579, 7.7135> <-5.0723, 10.7464, 7.7257>
		<-4.8728, 10.6388, 7.7126> <-4.8893, 10.6259, 7.7214> <-4.9126, 10.6072, 7.7291> <-4.9279, 10.5957, 7.7413>
		<-4.6765, 10.4413, 7.7325> <-4.6931, 10.4284, 7.7410> <-4.7146, 10.4112, 7.7485> <-4.7302, 10.3995, 7.7602>
		<-4.5358, 10.2873, 7.7495> <-4.5524, 10.2744, 7.7581> <-4.5756, 10.2558, 7.7661> <-4.5911, 10.2442, 7.7777>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0723, 10.7464, 7.7257> <-5.0857, 10.7364, 7.7363> <-5.1036, 10.7233, 7.7536> <-5.1112, 10.7190, 7.7714>
		<-4.9279, 10.5957, 7.7413> <-4.9413, 10.5857, 7.7519> <-4.9595, 10.5724, 7.7684> <-4.9670, 10.5681, 7.7862>
		<-4.7302, 10.3995, 7.7602> <-4.7435, 10.3895, 7.7702> <-4.7607, 10.3770, 7.7871> <-4.7688, 10.3723, 7.8041>
		<-4.5911, 10.2442, 7.7777> <-4.6044, 10.2342, 7.7877> <-4.6225, 10.2209, 7.8037> <-4.6306, 10.2161, 7.8207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1112, 10.7190, 7.7714> <-5.1196, 10.7141, 7.7913> <-5.1230, 10.7146, 7.8224> <-5.1225, 10.7175, 7.8443>
		<-4.9670, 10.5681, 7.7862> <-4.9754, 10.5633, 7.8061> <-4.9793, 10.5634, 7.8353> <-4.9787, 10.5663, 7.8572>
		<-4.7688, 10.3723, 7.8041> <-4.7773, 10.3672, 7.8219> <-4.7808, 10.3678, 7.8530> <-4.7807, 10.3703, 7.8733>
		<-4.6306, 10.2161, 7.8207> <-4.6391, 10.2111, 7.8385> <-4.6434, 10.2109, 7.8671> <-4.6433, 10.2134, 7.8874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1225, 10.7175, 7.8443> <-5.1221, 10.7197, 7.8607> <-5.1159, 10.7273, 7.8823> <-5.1081, 10.7352, 7.8946>
		<-4.9787, 10.5663, 7.8572> <-4.9783, 10.5684, 7.8736> <-4.9725, 10.5757, 7.8937> <-4.9647, 10.5837, 7.9060>
		<-4.7807, 10.3703, 7.8733> <-4.7806, 10.3721, 7.8881> <-4.7745, 10.3798, 7.9100> <-4.7671, 10.3873, 7.9206>
		<-4.6433, 10.2134, 7.8874> <-4.6432, 10.2152, 7.9022> <-4.6375, 10.2225, 7.9219> <-4.6300, 10.2300, 7.9325>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1081, 10.7352, 7.8946> <-5.0928, 10.7508, 7.9187> <-5.0678, 10.7749, 7.9459> <-5.0474, 10.7940, 7.9628>
		<-4.9647, 10.5837, 7.9060> <-4.9494, 10.5993, 7.9301> <-4.9236, 10.6241, 7.9562> <-4.9033, 10.6431, 7.9730>
		<-4.7671, 10.3873, 7.9206> <-4.7509, 10.4038, 7.9438> <-4.7257, 10.4282, 7.9724> <-4.7047, 10.4478, 7.9880>
		<-4.6300, 10.2300, 7.9325> <-4.6139, 10.2464, 7.9557> <-4.5878, 10.2714, 7.9813> <-4.5668, 10.2910, 7.9969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0474, 10.7940, 7.9628> <-5.0329, 10.8076, 7.9748> <-5.0101, 10.8279, 7.9830> <-4.9934, 10.8427, 7.9896>
		<-4.9033, 10.6431, 7.9730> <-4.8887, 10.6567, 7.9850> <-4.8675, 10.6755, 7.9908> <-4.8508, 10.6903, 7.9974>
		<-4.7047, 10.4478, 7.9880> <-4.6916, 10.4601, 7.9977> <-4.6709, 10.4783, 8.0048> <-4.6559, 10.4915, 8.0095>
		<-4.5668, 10.2910, 7.9969> <-4.5537, 10.3033, 8.0066> <-4.5329, 10.3217, 8.0108> <-4.5180, 10.3348, 8.0155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9934, 10.8427, 7.9896> <-4.9821, 10.8527, 7.9941> <-4.9662, 10.8662, 7.9972> <-4.9543, 10.8763, 7.9995>
		<-4.8508, 10.6903, 7.9974> <-4.8394, 10.7003, 8.0019> <-4.8236, 10.7138, 8.0048> <-4.8118, 10.7239, 8.0070>
		<-4.6559, 10.4915, 8.0095> <-4.6446, 10.5015, 8.0131> <-4.6301, 10.5139, 8.0185> <-4.6183, 10.5239, 8.0200>
		<-4.5180, 10.3348, 8.0155> <-4.5066, 10.3449, 8.0191> <-4.4910, 10.3582, 8.0230> <-4.4792, 10.3683, 8.0245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9543, 10.8763, 7.9995> <-4.9416, 10.8873, 8.0019> <-4.9244, 10.9019, 8.0049> <-4.9113, 10.9129, 8.0051>
		<-4.8118, 10.7239, 8.0070> <-4.7990, 10.7349, 8.0094> <-4.7821, 10.7493, 8.0112> <-4.7691, 10.7602, 8.0114>
		<-4.6183, 10.5239, 8.0200> <-4.6058, 10.5346, 8.0216> <-4.5923, 10.5459, 8.0248> <-4.5796, 10.5566, 8.0242>
		<-4.4792, 10.3683, 8.0245> <-4.4667, 10.3790, 8.0262> <-4.4498, 10.3933, 8.0265> <-4.4371, 10.4040, 8.0260>
	}
	texture {skin}
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2355, 13.1470, 5.6512> <-2.1178, 13.2289, 5.6565> <-2.0450, 13.3588, 5.4610> <-2.0046, 13.4329, 5.3449>
		<-2.3757, 13.3966, 5.7465> <-2.2580, 13.4785, 5.7517> <-2.1644, 13.6139, 5.5487> <-2.1241, 13.6880, 5.4326>
		<-2.5067, 13.7551, 5.8809> <-2.3763, 13.8497, 5.8764> <-2.3354, 13.9567, 5.6319> <-2.2842, 14.0424, 5.5054>
		<-2.6372, 14.0105, 5.9744> <-2.5068, 14.1052, 5.9700> <-2.4374, 14.2169, 5.7264> <-2.3862, 14.3026, 5.5998>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2355, 13.1470, 5.6512> <-2.0954, 12.8975, 5.5560> <-1.8610, 12.5792, 5.4624> <-1.7053, 12.3512, 5.3411>
		<-2.1178, 13.2289, 5.6565> <-1.9776, 12.9794, 5.5612> <-1.7522, 12.6480, 5.4781> <-1.5965, 12.4200, 5.3567>
		<-2.0450, 13.3588, 5.4610> <-1.9285, 13.1102, 5.3756> <-1.7659, 12.7719, 5.2265> <-1.6242, 12.5445, 5.1222>
		<-2.0046, 13.4329, 5.3449> <-1.8882, 13.1843, 5.2595> <-1.7424, 12.8528, 5.1279> <-1.6007, 12.6254, 5.0236>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2355, 13.1470, 5.6512> <-2.3757, 13.3966, 5.7465> <-2.5067, 13.7551, 5.8809> <-2.6372, 14.0105, 5.9744>
		<-2.3577, 13.0621, 5.6458> <-2.4979, 13.3117, 5.7410> <-2.6597, 13.6440, 5.8861> <-2.7902, 13.8995, 5.9797>
		<-2.4951, 13.0452, 5.4366> <-2.6572, 13.2622, 5.5374> <-2.8412, 13.5790, 5.6786> <-2.9849, 13.8149, 5.7638>
		<-2.5851, 13.0292, 5.3190> <-2.7472, 13.2462, 5.4198> <-2.9639, 13.5430, 5.5393> <-3.1076, 13.7789, 5.6245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2355, 13.1470, 5.6512> <-2.3577, 13.0621, 5.6458> <-2.4951, 13.0452, 5.4366> <-2.5851, 13.0292, 5.3190>
		<-2.0954, 12.8975, 5.5560> <-2.2176, 12.8125, 5.5505> <-2.3363, 12.8326, 5.3379> <-2.4263, 12.8165, 5.2204>
		<-1.8610, 12.5792, 5.4624> <-1.9884, 12.4986, 5.4441> <-2.0778, 12.5612, 5.1867> <-2.1766, 12.5691, 5.0716>
		<-1.7053, 12.3512, 5.3411> <-1.8327, 12.2706, 5.3227> <-1.9403, 12.3401, 5.0755> <-2.0391, 12.3481, 4.9605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5851, 13.0292, 5.3190> <-2.7472, 13.2462, 5.4198> <-2.9639, 13.5430, 5.5393> <-3.1076, 13.7789, 5.6245>
		<-2.6939, 13.0098, 5.1768> <-2.8561, 13.2269, 5.2776> <-3.1114, 13.4997, 5.3718> <-3.2551, 13.7355, 5.4570>
		<-2.7785, 13.0394, 4.9436> <-2.9513, 13.2588, 5.0274> <-3.2124, 13.5440, 5.1115> <-3.3768, 13.7788, 5.1654>
		<-2.8870, 13.0311, 4.8000> <-3.0598, 13.2506, 4.8839> <-3.3460, 13.5193, 4.9293> <-3.5104, 13.7541, 4.9831>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5851, 13.0292, 5.3190> <-2.6939, 13.0098, 5.1768> <-2.7785, 13.0394, 4.9436> <-2.8870, 13.0311, 4.8000>
		<-2.4263, 12.8165, 5.2204> <-2.5352, 12.7972, 5.0782> <-2.6318, 12.8531, 4.8724> <-2.7404, 12.8449, 4.7289>
		<-2.1766, 12.5691, 5.0716> <-2.3025, 12.5793, 4.9250> <-2.3998, 12.5942, 4.7028> <-2.5507, 12.6094, 4.5826>
		<-2.0391, 12.3481, 4.9605> <-2.1650, 12.3582, 4.8139> <-2.3024, 12.3963, 4.5904> <-2.4533, 12.4116, 4.4702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0046, 13.4329, 5.3449> <-1.9577, 13.5189, 5.2102> <-1.9616, 13.5767, 4.9843> <-1.9543, 13.6634, 4.8422>
		<-2.1241, 13.6880, 5.4326> <-2.0772, 13.7740, 5.2978> <-2.0814, 13.8553, 5.0537> <-2.0741, 13.9419, 4.9116>
		<-2.2842, 14.0424, 5.5054> <-2.2237, 14.1437, 5.3556> <-2.1895, 14.2351, 5.1518> <-2.1620, 14.3421, 4.9964>
		<-2.3862, 14.3026, 5.5998> <-2.3257, 14.4039, 5.4501> <-2.2971, 14.5188, 5.2205> <-2.2697, 14.6258, 5.0650>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0046, 13.4329, 5.3449> <-1.8882, 13.1843, 5.2595> <-1.7424, 12.8528, 5.1279> <-1.6007, 12.6254, 5.0236>
		<-1.9577, 13.5189, 5.2102> <-1.8413, 13.2703, 5.1247> <-1.7157, 12.9445, 5.0161> <-1.5740, 12.7171, 4.9119>
		<-1.9616, 13.5767, 4.9843> <-1.8610, 13.3428, 4.9260> <-1.6653, 13.0400, 4.8516> <-1.5398, 12.8322, 4.7550>
		<-1.9543, 13.6634, 4.8422> <-1.8536, 13.4294, 4.7839> <-1.6637, 13.1331, 4.7379> <-1.5382, 12.9253, 4.6413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7053, 12.3512, 5.3411> <-1.6226, 12.2301, 5.2766> <-1.4850, 12.0486, 5.1841> <-1.4484, 11.9945, 5.0378>
		<-1.5965, 12.4200, 5.3567> <-1.5138, 12.2989, 5.2923> <-1.3732, 12.1087, 5.1911> <-1.3366, 12.0546, 5.0448>
		<-1.6242, 12.5445, 5.1222> <-1.5631, 12.4463, 5.0772> <-1.3758, 12.2896, 5.0483> <-1.3410, 12.2601, 4.9329>
		<-1.6007, 12.6254, 5.0236> <-1.5395, 12.5272, 4.9786> <-1.3699, 12.3878, 4.9678> <-1.3352, 12.3584, 4.8524>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7053, 12.3512, 5.3411> <-1.8327, 12.2706, 5.3227> <-1.9403, 12.3401, 5.0755> <-2.0391, 12.3481, 4.9605>
		<-1.6226, 12.2301, 5.2766> <-1.7500, 12.1495, 5.2583> <-1.8870, 12.2545, 5.0325> <-1.9858, 12.2624, 4.9175>
		<-1.4850, 12.0486, 5.1841> <-1.6324, 11.9694, 5.1749> <-1.8369, 12.0604, 5.0268> <-1.9626, 12.0616, 4.9160>
		<-1.4484, 11.9945, 5.0378> <-1.5958, 11.9153, 5.0286> <-1.8334, 12.0220, 4.9242> <-1.9591, 12.0232, 4.8134>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0391, 12.3481, 4.9605> <-2.1650, 12.3582, 4.8139> <-2.3024, 12.3963, 4.5904> <-2.4533, 12.4116, 4.4702>
		<-1.9858, 12.2624, 4.9175> <-2.1117, 12.2726, 4.7709> <-2.2450, 12.2797, 4.5241> <-2.3958, 12.2949, 4.4039>
		<-1.9626, 12.0616, 4.9160> <-2.1273, 12.0631, 4.7709> <-2.2240, 12.0517, 4.5157> <-2.3713, 12.0527, 4.3530>
		<-1.9591, 12.0232, 4.8134> <-2.1237, 12.0247, 4.6683> <-2.2336, 12.0022, 4.3788> <-2.3809, 12.0032, 4.2161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6007, 12.6254, 5.0236> <-1.5395, 12.5272, 4.9786> <-1.3699, 12.3878, 4.9678> <-1.3352, 12.3584, 4.8524>
		<-1.5740, 12.7171, 4.9119> <-1.5128, 12.6189, 4.8669> <-1.3618, 12.5245, 4.8559> <-1.3270, 12.4950, 4.7404>
		<-1.5398, 12.8322, 4.7550> <-1.4946, 12.7574, 4.7203> <-1.3994, 12.6404, 4.6447> <-1.3858, 12.6366, 4.5517>
		<-1.5382, 12.9253, 4.6413> <-1.4930, 12.8505, 4.6065> <-1.4170, 12.7549, 4.5111> <-1.4034, 12.7511, 4.4181>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6372, 14.0105, 5.9744> <-2.5068, 14.1052, 5.9700> <-2.4374, 14.2169, 5.7264> <-2.3862, 14.3026, 5.5998>
		<-2.7228, 14.1780, 6.0358> <-2.5924, 14.2727, 6.0313> <-2.4940, 14.3615, 5.7789> <-2.4429, 14.4472, 5.6523>
		<-2.8586, 14.3884, 6.1223> <-2.6906, 14.4372, 6.1191> <-2.5398, 14.5665, 5.9109> <-2.4706, 14.6378, 5.7668>
		<-2.9550, 14.5554, 6.1669> <-2.7869, 14.6042, 6.1637> <-2.6000, 14.7041, 5.9764> <-2.5307, 14.7755, 5.8324>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6372, 14.0105, 5.9744> <-2.7228, 14.1780, 6.0358> <-2.8586, 14.3884, 6.1223> <-2.9550, 14.5554, 6.1669>
		<-2.7902, 13.8995, 5.9797> <-2.8758, 14.0670, 6.0410> <-3.0362, 14.3369, 6.1257> <-3.1326, 14.5039, 6.1703>
		<-2.9849, 13.8149, 5.7638> <-3.1106, 14.0212, 5.8384> <-3.2198, 14.2803, 5.9135> <-3.3469, 14.4894, 5.9773>
		<-3.1076, 13.7789, 5.6245> <-3.2333, 13.9852, 5.6991> <-3.3540, 14.2907, 5.7867> <-3.4811, 14.4997, 5.8505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1076, 13.7789, 5.6245> <-3.2333, 13.9852, 5.6991> <-3.3540, 14.2907, 5.7867> <-3.4811, 14.4997, 5.8505>
		<-3.2551, 13.7355, 5.4570> <-3.3808, 13.9418, 5.5316> <-3.5444, 14.3053, 5.6066> <-3.6715, 14.5144, 5.6704>
		<-3.3768, 13.7788, 5.1654> <-3.5513, 14.0279, 5.2225> <-3.7206, 14.4311, 5.2295> <-3.8553, 14.6676, 5.3769>
		<-3.5104, 13.7541, 4.9831> <-3.6849, 14.0032, 5.0402> <-3.8767, 14.4003, 5.0207> <-4.0115, 14.6367, 5.1681>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3862, 14.3026, 5.5998> <-2.3257, 14.4039, 5.4501> <-2.2971, 14.5188, 5.2205> <-2.2697, 14.6258, 5.0650>
		<-2.4429, 14.4472, 5.6523> <-2.3823, 14.5485, 5.5026> <-2.3472, 14.6507, 5.2524> <-2.3197, 14.7577, 5.0970>
		<-2.4706, 14.6378, 5.7668> <-2.3861, 14.7247, 5.5912> <-2.4489, 14.8113, 5.3189> <-2.4298, 14.9164, 5.1342>
		<-2.5307, 14.7755, 5.8324> <-2.4463, 14.8624, 5.6568> <-2.4981, 14.9406, 5.3613> <-2.4789, 15.0457, 5.1766>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9550, 14.5554, 6.1669> <-2.7869, 14.6042, 6.1637> <-2.6000, 14.7041, 5.9764> <-2.5307, 14.7755, 5.8324>
		<-3.0523, 14.7241, 6.2120> <-2.8843, 14.7729, 6.2088> <-2.6766, 14.8794, 6.0599> <-2.6073, 14.9507, 5.9159>
		<-3.1899, 14.9529, 6.2351> <-3.0490, 15.0186, 6.2541> <-2.8259, 15.0877, 6.1420> <-2.7476, 15.1650, 6.0305>
		<-3.2813, 15.1267, 6.2724> <-3.1405, 15.1924, 6.2915> <-2.9182, 15.2636, 6.2058> <-2.8399, 15.3409, 6.0944>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9550, 14.5554, 6.1669> <-3.0523, 14.7241, 6.2120> <-3.1899, 14.9529, 6.2351> <-3.2813, 15.1267, 6.2724>
		<-3.1326, 14.5039, 6.1703> <-3.2299, 14.6726, 6.2153> <-3.3612, 14.8731, 6.2119> <-3.4526, 15.0469, 6.2493>
		<-3.3469, 14.4894, 5.9773> <-3.4248, 14.6176, 6.0164> <-3.5548, 14.8441, 6.0181> <-3.6447, 14.9558, 6.0773>
		<-3.4811, 14.4997, 5.8505> <-3.5590, 14.6279, 5.8896> <-3.6986, 14.7871, 5.9070> <-3.7884, 14.8987, 5.9662>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4811, 14.4997, 5.8505> <-3.5590, 14.6279, 5.8896> <-3.6986, 14.7871, 5.9070> <-3.7884, 14.8987, 5.9662>
		<-3.6715, 14.5144, 5.6704> <-3.7495, 14.6426, 5.7095> <-3.8050, 14.7449, 5.8248> <-3.8948, 14.8565, 5.8840>
		<-3.8553, 14.6676, 5.3769> <-3.9211, 14.7829, 5.4488> <-3.9623, 14.7664, 5.5979> <-4.0036, 14.8457, 5.7196>
		<-4.0115, 14.6367, 5.1681> <-4.0772, 14.7520, 5.2400> <-4.0650, 14.7201, 5.5132> <-4.1063, 14.7994, 5.6349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5307, 14.7755, 5.8324> <-2.4463, 14.8624, 5.6568> <-2.4981, 14.9406, 5.3613> <-2.4789, 15.0457, 5.1766>
		<-2.6073, 14.9507, 5.9159> <-2.5229, 15.0377, 5.7403> <-2.5738, 15.1400, 5.4266> <-2.5546, 15.2451, 5.2419>
		<-2.7476, 15.1650, 6.0305> <-2.6298, 15.2813, 5.8629> <-2.6350, 15.4087, 5.5422> <-2.5956, 15.5280, 5.3429>
		<-2.8399, 15.3409, 6.0944> <-2.7221, 15.4573, 5.9267> <-2.7234, 15.5974, 5.6217> <-2.6840, 15.7167, 5.4224>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2813, 15.1267, 6.2724> <-3.1405, 15.1924, 6.2915> <-2.9182, 15.2636, 6.2058> <-2.8399, 15.3409, 6.0944>
		<-3.3224, 15.2048, 6.2892> <-3.1815, 15.2704, 6.3082> <-3.0610, 15.5357, 6.3046> <-2.9827, 15.6131, 6.1932>
		<-3.3351, 15.3270, 6.3419> <-3.2214, 15.5601, 6.3871> <-3.1390, 15.7706, 6.4213> <-3.1122, 16.0169, 6.3320>
		<-3.3958, 15.3929, 6.3467> <-3.2820, 15.6260, 6.3919> <-3.3397, 16.0200, 6.4627> <-3.3129, 16.2662, 6.3734>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2813, 15.1267, 6.2724> <-3.3224, 15.2048, 6.2892> <-3.3351, 15.3270, 6.3419> <-3.3958, 15.3929, 6.3467>
		<-3.4526, 15.0469, 6.2493> <-3.4937, 15.1249, 6.2660> <-3.4211, 15.1509, 6.3078> <-3.4817, 15.2169, 6.3126>
		<-3.6447, 14.9558, 6.0773> <-3.6883, 15.0101, 6.1061> <-3.7110, 15.0377, 6.2232> <-3.7529, 15.0993, 6.2349>
		<-3.7884, 14.8987, 5.9662> <-3.8321, 14.9530, 5.9950> <-3.8712, 14.9750, 6.1236> <-3.9131, 15.0366, 6.1352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7884, 14.8987, 5.9662> <-3.8321, 14.9530, 5.9950> <-3.8712, 14.9750, 6.1236> <-3.9131, 15.0366, 6.1352>
		<-3.8948, 14.8565, 5.8840> <-3.9385, 14.9108, 5.9128> <-3.9794, 14.9327, 6.0563> <-4.0213, 14.9943, 6.0679>
		<-4.0036, 14.8457, 5.7196> <-4.0324, 14.9009, 5.8044> <-4.0813, 14.9906, 5.8606> <-4.1207, 15.0821, 5.8943>
		<-4.1063, 14.7994, 5.6349> <-4.1351, 14.8547, 5.7196> <-4.1950, 14.9732, 5.7913> <-4.2344, 15.0647, 5.8250>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8399, 15.3409, 6.0944> <-2.7221, 15.4573, 5.9267> <-2.7234, 15.5974, 5.6217> <-2.6840, 15.7167, 5.4224>
		<-2.9827, 15.6131, 6.1932> <-2.8649, 15.7294, 6.0255> <-2.8687, 15.9075, 5.7524> <-2.8293, 16.0268, 5.5530>
		<-3.1122, 16.0169, 6.3320> <-3.0918, 16.2032, 6.2645> <-3.0461, 16.3286, 5.9741> <-3.0195, 16.4261, 5.8024>
		<-3.3129, 16.2662, 6.3734> <-3.2926, 16.4526, 6.3059> <-3.2801, 16.6018, 6.0450> <-3.2535, 16.6992, 5.8732>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3352, 12.3584, 4.8524> <-1.2593, 12.2940, 4.6002> <-1.2778, 12.3542, 4.2217> <-1.2778, 12.3516, 3.9507>
		<-1.3270, 12.4950, 4.7404> <-1.2512, 12.4307, 4.4883> <-1.2679, 12.5314, 4.0815> <-1.2679, 12.5288, 3.8105>
		<-1.3858, 12.6366, 4.5517> <-1.3419, 12.6243, 4.2514> <-1.3343, 12.7052, 3.8766> <-1.3343, 12.7159, 3.5731>
		<-1.4034, 12.7511, 4.4181> <-1.3595, 12.7388, 4.1178> <-1.3589, 12.8644, 3.7179> <-1.3589, 12.8751, 3.4144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3352, 12.3584, 4.8524> <-1.3410, 12.2601, 4.9329> <-1.3366, 12.0546, 5.0448> <-1.4484, 11.9945, 5.0378>
		<-1.2593, 12.2940, 4.6002> <-1.2651, 12.1958, 4.6807> <-1.2769, 11.9664, 4.8064> <-1.3887, 11.9063, 4.7994>
		<-1.2778, 12.3542, 4.2217> <-1.2844, 12.2357, 4.3155> <-1.2802, 11.9939, 4.4410> <-1.4125, 11.9211, 4.4325>
		<-1.2778, 12.3516, 3.9507> <-1.2844, 12.2331, 4.0445> <-1.2802, 11.9916, 4.1798> <-1.4125, 11.9188, 4.1713>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4484, 11.9945, 5.0378> <-1.5958, 11.9153, 5.0286> <-1.8334, 12.0220, 4.9242> <-1.9591, 12.0232, 4.8134>
		<-1.3887, 11.9063, 4.7994> <-1.5361, 11.8271, 4.7902> <-1.8245, 11.9261, 4.6678> <-1.9502, 11.9273, 4.5570>
		<-1.4125, 11.9211, 4.4325> <-1.5827, 11.8275, 4.4216> <-1.8369, 11.9341, 4.2779> <-2.0026, 11.9555, 4.1781>
		<-1.4125, 11.9188, 4.1713> <-1.5827, 11.8251, 4.1604> <-1.8369, 11.9314, 4.0041> <-2.0026, 11.9529, 3.9043>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9591, 12.0232, 4.8134> <-2.1237, 12.0247, 4.6683> <-2.2336, 12.0022, 4.3788> <-2.3809, 12.0032, 4.2161>
		<-1.9502, 11.9273, 4.5570> <-2.1149, 11.9288, 4.4119> <-2.2480, 11.9281, 4.1736> <-2.3953, 11.9291, 4.0109>
		<-2.0026, 11.9555, 4.1781> <-2.1723, 11.9775, 4.0759> <-2.3468, 12.0576, 3.8555> <-2.4932, 12.0557, 3.7201>
		<-2.0026, 11.9529, 3.9043> <-2.1723, 11.9748, 3.8021> <-2.3748, 12.0642, 3.6388> <-2.5211, 12.0624, 3.5034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2778, 12.3516, 3.9507> <-1.2778, 12.3461, 3.3739> <-1.3230, 12.3356, 2.6055> <-1.3352, 12.3312, 2.0288>
		<-1.2679, 12.5288, 3.8105> <-1.2679, 12.5232, 3.2337> <-1.3151, 12.4890, 2.5965> <-1.3272, 12.4846, 2.0197>
		<-1.3343, 12.7159, 3.5731> <-1.3343, 12.7310, 3.1419> <-1.3757, 12.6890, 2.4284> <-1.3844, 12.6855, 1.9970>
		<-1.3589, 12.8751, 3.4144> <-1.3589, 12.8903, 2.9832> <-1.3946, 12.8404, 2.4088> <-1.4034, 12.8370, 1.9774>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2778, 12.3516, 3.9507> <-1.2844, 12.2331, 4.0445> <-1.2802, 11.9916, 4.1798> <-1.4125, 11.9188, 4.1713>
		<-1.2778, 12.3461, 3.3739> <-1.2844, 12.2276, 3.4676> <-1.2802, 11.9858, 3.5368> <-1.4125, 11.9130, 3.5284>
		<-1.3230, 12.3356, 2.6055> <-1.3289, 12.2216, 2.6122> <-1.3399, 12.0108, 2.6717> <-1.4406, 11.9567, 2.6717>
		<-1.3352, 12.3312, 2.0288> <-1.3411, 12.2173, 2.0355> <-1.3477, 12.0215, 2.0288> <-1.4484, 11.9674, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4125, 11.9188, 4.1713> <-1.5827, 11.8251, 4.1604> <-1.8369, 11.9314, 4.0041> <-2.0026, 11.9529, 3.9043>
		<-1.4125, 11.9130, 3.5284> <-1.5827, 11.8193, 3.5175> <-1.8369, 11.9259, 3.4412> <-2.0026, 11.9474, 3.3414>
		<-1.4406, 11.9567, 2.6717> <-1.5757, 11.8841, 2.6717> <-1.8153, 11.9740, 2.5916> <-1.9682, 11.9870, 2.5916>
		<-1.4484, 11.9674, 2.0288> <-1.5836, 11.8947, 2.0288> <-1.8062, 11.9831, 2.0288> <-1.9591, 11.9960, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0026, 11.9529, 3.9043> <-2.1723, 11.9748, 3.8021> <-2.3748, 12.0642, 3.6388> <-2.5211, 12.0624, 3.5034>
		<-2.0026, 11.9474, 3.3414> <-2.1723, 11.9694, 3.2391> <-2.4316, 12.0777, 3.1982> <-2.5779, 12.0758, 3.0628>
		<-1.9682, 11.9870, 2.5916> <-2.1798, 12.0049, 2.5916> <-2.4240, 12.0539, 2.4871> <-2.6354, 12.0687, 2.4724>
		<-1.9591, 11.9960, 2.0288> <-2.1707, 12.0140, 2.0288> <-2.4517, 12.0554, 2.0435> <-2.6630, 12.0702, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3352, 12.3312, 1.2292> <-1.3271, 12.4902, 1.2292> <-1.3820, 12.6997, 1.2292> <-1.4034, 12.8575, 1.2292>
		<-1.3352, 12.3312, 1.4691> <-1.3271, 12.4902, 1.4691> <-1.3820, 12.6936, 1.4537> <-1.4034, 12.8513, 1.4537>
		<-1.3402, 12.3294, 1.7890> <-1.3323, 12.4828, 1.7799> <-1.3890, 12.6837, 1.7725> <-1.4080, 12.8351, 1.7530>
		<-1.3352, 12.3312, 2.0288> <-1.3272, 12.4846, 2.0197> <-1.3844, 12.6855, 1.9970> <-1.4034, 12.8370, 1.9774>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3352, 12.3312, 1.2292> <-1.3352, 12.3312, 1.4691> <-1.3402, 12.3294, 1.7890> <-1.3352, 12.3312, 2.0288>
		<-1.3409, 12.2171, 1.2292> <-1.3409, 12.2171, 1.4691> <-1.3461, 12.2155, 1.7957> <-1.3411, 12.2173, 2.0355>
		<-1.3477, 12.0215, 1.2292> <-1.3477, 12.0215, 1.4691> <-1.3506, 12.0254, 1.7890> <-1.3477, 12.0215, 2.0288>
		<-1.4484, 11.9674, 1.2292> <-1.4484, 11.9674, 1.4691> <-1.4513, 11.9713, 1.7890> <-1.4484, 11.9674, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4484, 11.9674, 1.2292> <-1.4484, 11.9674, 1.4691> <-1.4513, 11.9713, 1.7890> <-1.4484, 11.9674, 2.0288>
		<-1.5836, 11.8947, 1.2292> <-1.5836, 11.8947, 1.4691> <-1.5865, 11.8987, 1.7890> <-1.5836, 11.8947, 2.0288>
		<-1.8062, 11.9831, 1.2292> <-1.8062, 11.9831, 1.4691> <-1.8023, 11.9870, 1.7890> <-1.8062, 11.9831, 2.0288>
		<-1.9591, 11.9960, 1.2292> <-1.9591, 11.9960, 1.4691> <-1.9552, 11.9999, 1.7890> <-1.9591, 11.9960, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9591, 11.9960, 1.2292> <-1.9591, 11.9960, 1.4691> <-1.9552, 11.9999, 1.7890> <-1.9591, 11.9960, 2.0288>
		<-2.1707, 12.0140, 1.2292> <-2.1707, 12.0140, 1.4691> <-2.1668, 12.0178, 1.7890> <-2.1707, 12.0140, 2.0288>
		<-2.4511, 12.0575, 1.2292> <-2.4511, 12.0575, 1.4691> <-2.4666, 12.0563, 1.8041> <-2.4517, 12.0554, 2.0435>
		<-2.6630, 12.0702, 1.2292> <-2.6630, 12.0702, 1.4691> <-2.6780, 12.0710, 1.7894> <-2.6630, 12.0702, 2.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4014, 12.4350, 4.6640> <-4.2850, 12.4650, 4.6741> <-4.1594, 12.6283, 4.6744> <-4.0909, 12.6794, 4.5892>
		<-4.4442, 12.5890, 4.8549> <-4.3278, 12.6190, 4.8650> <-4.1897, 12.7934, 4.8136> <-4.1213, 12.8444, 4.7284>
		<-4.5067, 12.7150, 5.1664> <-4.3470, 12.7869, 5.1321> <-4.2444, 12.9791, 5.0240> <-4.1737, 13.0785, 4.8938>
		<-4.5356, 12.8755, 5.3545> <-4.3760, 12.9474, 5.3202> <-4.2718, 13.1464, 5.1611> <-4.2011, 13.2458, 5.0309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4014, 12.4350, 4.6640> <-4.3829, 12.3685, 4.5815> <-4.3550, 12.2184, 4.5370> <-4.3341, 12.1507, 4.4560>
		<-4.2850, 12.4650, 4.6741> <-4.2665, 12.3984, 4.5916> <-4.2453, 12.2715, 4.5452> <-4.2244, 12.2038, 4.4642>
		<-4.1594, 12.6283, 4.6744> <-4.1433, 12.5409, 4.6007> <-4.1470, 12.4286, 4.4981> <-4.1301, 12.3666, 4.4021>
		<-4.0909, 12.6794, 4.5892> <-4.0748, 12.5920, 4.5155> <-4.0634, 12.4676, 4.4182> <-4.0465, 12.4057, 4.3222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4014, 12.4350, 4.6640> <-4.4442, 12.5890, 4.8549> <-4.5067, 12.7150, 5.1664> <-4.5356, 12.8755, 5.3545>
		<-4.5298, 12.4020, 4.6529> <-4.5726, 12.5559, 4.8438> <-4.6309, 12.6590, 5.1930> <-4.6598, 12.8195, 5.3811>
		<-4.7178, 12.4554, 4.6044> <-4.7686, 12.6099, 4.7801> <-4.8095, 12.7193, 5.0855> <-4.8577, 12.8641, 5.2700>
		<-4.8189, 12.4920, 4.5261> <-4.8698, 12.6465, 4.7019> <-4.9215, 12.7544, 5.0114> <-4.9697, 12.8993, 5.1959>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4014, 12.4350, 4.6640> <-4.5298, 12.4020, 4.6529> <-4.7178, 12.4554, 4.6044> <-4.8189, 12.4920, 4.5261>
		<-4.3829, 12.3685, 4.5815> <-4.5113, 12.3354, 4.5704> <-4.6865, 12.3604, 4.4963> <-4.7877, 12.3970, 4.4181>
		<-4.3550, 12.2184, 4.5370> <-4.4672, 12.1641, 4.5286> <-4.6584, 12.1198, 4.4249> <-4.7449, 12.1909, 4.3695>
		<-4.3341, 12.1507, 4.4560> <-4.4463, 12.0964, 4.4476> <-4.6163, 12.0170, 4.3284> <-4.7027, 12.0881, 4.2729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0909, 12.6794, 4.5892> <-3.9384, 12.7931, 4.3994> <-3.9754, 12.8682, 3.7724> <-3.7210, 12.9425, 3.8170>
		<-4.1213, 12.8444, 4.7284> <-3.9688, 12.9581, 4.5386> <-4.0642, 13.0952, 3.9071> <-3.8098, 13.1696, 3.9516>
		<-4.1737, 13.0785, 4.8938> <-4.0832, 13.2058, 4.7272> <-4.1253, 13.2629, 4.2394> <-3.9416, 13.3980, 4.2267>
		<-4.2011, 13.2458, 5.0309> <-4.1106, 13.3731, 4.8643> <-4.1957, 13.4766, 4.4035> <-4.0120, 13.6117, 4.3908>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0909, 12.6794, 4.5892> <-4.0748, 12.5920, 4.5155> <-4.0634, 12.4676, 4.4182> <-4.0465, 12.4057, 4.3222>
		<-3.9384, 12.7931, 4.3994> <-3.9223, 12.7057, 4.3257> <-3.9076, 12.5403, 4.2692> <-3.8907, 12.4784, 4.1732>
		<-3.9754, 12.8682, 3.7724> <-3.9305, 12.7535, 3.7044> <-3.8623, 12.6178, 3.7694> <-3.8051, 12.5026, 3.7125>
		<-3.7210, 12.9425, 3.8170> <-3.6761, 12.8278, 3.7489> <-3.6358, 12.6187, 3.7905> <-3.5785, 12.5034, 3.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7210, 12.9425, 3.8170> <-3.3541, 13.0497, 3.8812> <-3.1206, 13.0133, 4.4912> <-2.8870, 13.0311, 4.8000>
		<-3.8098, 13.1696, 3.9516> <-3.4429, 13.2768, 4.0159> <-3.2934, 13.2327, 4.5750> <-3.0598, 13.2506, 4.8839>
		<-3.9416, 13.3980, 4.2267> <-3.7513, 13.5381, 4.2136> <-3.4851, 13.4936, 4.7395> <-3.3460, 13.5193, 4.9293>
		<-4.0120, 13.6117, 4.3908> <-3.8217, 13.7518, 4.3777> <-3.6495, 13.7284, 4.7933> <-3.5104, 13.7541, 4.9831>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7210, 12.9425, 3.8170> <-3.6761, 12.8278, 3.7489> <-3.6358, 12.6187, 3.7905> <-3.5785, 12.5034, 3.7335>
		<-3.3541, 13.0497, 3.8812> <-3.3092, 12.9350, 3.8132> <-3.2331, 12.6202, 3.8279> <-3.1758, 12.5049, 3.7709>
		<-3.1206, 13.0133, 4.4912> <-2.9739, 12.8270, 4.4200> <-2.8660, 12.6412, 4.3313> <-2.7685, 12.4434, 4.2189>
		<-2.8870, 13.0311, 4.8000> <-2.7404, 12.8449, 4.7289> <-2.5507, 12.6094, 4.5826> <-2.4533, 12.4116, 4.4702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1291, 12.9550, 3.8065> <-5.1297, 12.8782, 3.8945> <-5.1707, 12.7583, 4.0074> <-5.1309, 12.6989, 4.0997>
		<-5.2362, 13.1040, 3.9698> <-5.2367, 13.0272, 4.0577> <-5.2838, 12.8789, 4.2049> <-5.2440, 12.8195, 4.2973>
		<-5.3032, 13.3383, 4.1959> <-5.3163, 13.2327, 4.3189> <-5.4093, 13.0796, 4.4594> <-5.3486, 12.9914, 4.5818>
		<-5.3884, 13.5088, 4.3508> <-5.4015, 13.4032, 4.4738> <-5.4927, 13.2451, 4.6383> <-5.4321, 13.1568, 4.7607>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1291, 12.9550, 3.8065> <-5.1092, 12.9273, 3.7762> <-5.0072, 12.9873, 3.7712> <-4.9903, 12.9548, 3.7439>
		<-5.1297, 12.8782, 3.8945> <-5.1097, 12.8505, 3.8641> <-5.0130, 12.9128, 3.8548> <-4.9961, 12.8803, 3.8275>
		<-5.1707, 12.7583, 4.0074> <-5.1517, 12.7381, 3.9743> <-5.0549, 12.8271, 3.9952> <-5.0402, 12.7984, 3.9665>
		<-5.1309, 12.6989, 4.0997> <-5.1119, 12.6787, 4.0666> <-5.0243, 12.7350, 4.0514> <-5.0096, 12.7063, 4.0227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1309, 12.6989, 4.0997> <-5.0729, 12.6123, 4.2343> <-4.9484, 12.5388, 4.4260> <-4.8189, 12.4920, 4.5261>
		<-5.2440, 12.8195, 4.2973> <-5.1860, 12.7329, 4.4318> <-4.9992, 12.6933, 4.6018> <-4.8698, 12.6465, 4.7019>
		<-5.3486, 12.9914, 4.5818> <-5.2720, 12.8798, 4.7365> <-5.0873, 12.8064, 4.9016> <-4.9215, 12.7544, 5.0114>
		<-5.4321, 13.1568, 4.7607> <-5.3554, 13.0452, 4.9154> <-5.1355, 12.9513, 5.0861> <-4.9697, 12.8993, 5.1959>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1309, 12.6989, 4.0997> <-5.1119, 12.6787, 4.0666> <-5.0243, 12.7350, 4.0514> <-5.0096, 12.7063, 4.0227>
		<-5.0729, 12.6123, 4.2343> <-5.0539, 12.5921, 4.2012> <-4.9643, 12.5541, 4.1618> <-4.9496, 12.5254, 4.1331>
		<-4.9484, 12.5388, 4.4260> <-4.9171, 12.4438, 4.3179> <-4.8973, 12.3162, 4.2717> <-4.8551, 12.2135, 4.1752>
		<-4.8189, 12.4920, 4.5261> <-4.7877, 12.3970, 4.4181> <-4.7449, 12.1909, 4.3695> <-4.7027, 12.0881, 4.2729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1767, 11.7070, 3.7931> <-4.0709, 11.7973, 3.7760> <-4.0337, 11.9840, 3.6349> <-3.9130, 12.0272, 3.5782>
		<-4.1703, 11.7639, 4.0302> <-4.0645, 11.8542, 4.0131> <-4.0761, 12.0713, 3.8692> <-3.9554, 12.1145, 3.8125>
		<-4.2867, 11.9973, 4.2724> <-4.1771, 12.0503, 4.2806> <-4.0930, 12.2306, 4.1913> <-4.0094, 12.2697, 4.1114>
		<-4.3341, 12.1507, 4.4560> <-4.2244, 12.2038, 4.4642> <-4.1301, 12.3666, 4.4021> <-4.0465, 12.4057, 4.3222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1767, 11.7070, 3.7931> <-4.1861, 11.6227, 3.4415> <-4.3433, 11.6879, 2.9644> <-4.3837, 11.7069, 2.6055>
		<-4.0709, 11.7973, 3.7760> <-4.0803, 11.7130, 3.4244> <-4.1421, 11.6913, 2.9871> <-4.1825, 11.7103, 2.6282>
		<-4.0337, 11.9840, 3.6349> <-3.9968, 11.9080, 3.4310> <-3.9841, 11.8483, 3.0582> <-3.9803, 11.8275, 2.8385>
		<-3.9130, 12.0272, 3.5782> <-3.8761, 11.9512, 3.3743> <-3.7880, 11.8861, 3.0919> <-3.7842, 11.8652, 2.8722>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1767, 11.7070, 3.7931> <-4.1703, 11.7639, 4.0302> <-4.2867, 11.9973, 4.2724> <-4.3341, 12.1507, 4.4560>
		<-4.2499, 11.6444, 3.8050> <-4.2436, 11.7013, 4.0421> <-4.3989, 11.9430, 4.2640> <-4.4463, 12.0964, 4.4476>
		<-4.3660, 11.5326, 3.7063> <-4.3412, 11.5717, 3.9533> <-4.5443, 11.8416, 4.1634> <-4.6163, 12.0170, 4.3284>
		<-4.4425, 11.5749, 3.6640> <-4.4177, 11.6140, 3.9110> <-4.6307, 11.9127, 4.1080> <-4.7027, 12.0881, 4.2729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1767, 11.7070, 3.7931> <-4.2499, 11.6444, 3.8050> <-4.3660, 11.5326, 3.7063> <-4.4425, 11.5749, 3.6640>
		<-4.1861, 11.6227, 3.4415> <-4.2594, 11.5601, 3.4534> <-4.3967, 11.4841, 3.4002> <-4.4733, 11.5264, 3.3579>
		<-4.3433, 11.6879, 2.9644> <-4.4963, 11.6853, 2.9471> <-4.6978, 11.6830, 3.0097> <-4.7928, 11.7965, 3.0522>
		<-4.3837, 11.7069, 2.6055> <-4.5367, 11.7043, 2.5882> <-4.7605, 11.7335, 2.7089> <-4.8555, 11.8470, 2.7513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9130, 12.0272, 3.5782> <-3.7378, 12.0898, 3.4960> <-3.4564, 12.0346, 3.2886> <-3.2686, 12.0317, 3.3668>
		<-3.9554, 12.1145, 3.8125> <-3.7801, 12.1771, 3.7302> <-3.5257, 12.1338, 3.4503> <-3.3378, 12.1309, 3.5285>
		<-4.0094, 12.2697, 4.1114> <-3.8536, 12.3424, 3.9624> <-3.7229, 12.3372, 3.6307> <-3.4964, 12.3381, 3.6518>
		<-4.0465, 12.4057, 4.3222> <-3.8907, 12.4784, 4.1732> <-3.8051, 12.5026, 3.7125> <-3.5785, 12.5034, 3.7335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9130, 12.0272, 3.5782> <-3.8761, 11.9512, 3.3743> <-3.7880, 11.8861, 3.0919> <-3.7842, 11.8652, 2.8722>
		<-3.7378, 12.0898, 3.4960> <-3.7009, 12.0138, 3.2920> <-3.6114, 11.9201, 3.1222> <-3.6076, 11.8992, 2.9025>
		<-3.4564, 12.0346, 3.2886> <-3.3978, 11.9507, 3.1518> <-3.3409, 11.9057, 2.9015> <-3.3451, 11.9127, 2.7308>
		<-3.2686, 12.0317, 3.3668> <-3.2100, 11.9478, 3.2300> <-3.1793, 11.9309, 2.9822> <-3.1835, 11.9379, 2.8116>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8136, 12.3451, 3.2942> <-4.8088, 12.2566, 3.3409> <-4.8377, 12.1330, 3.4100> <-4.7978, 12.0502, 3.4498>
		<-4.8773, 12.4238, 3.5045> <-4.8726, 12.3354, 3.5511> <-4.8617, 12.2158, 3.6648> <-4.8219, 12.1330, 3.7045>
		<-4.9044, 12.7887, 3.6043> <-4.9102, 12.7141, 3.6880> <-4.9485, 12.6199, 3.7875> <-4.9179, 12.5277, 3.8438>
		<-4.9903, 12.9548, 3.7439> <-4.9961, 12.8803, 3.8275> <-5.0402, 12.7984, 3.9665> <-5.0096, 12.7063, 4.0227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8136, 12.3451, 3.2942> <-4.7678, 12.2885, 3.1433> <-4.7268, 12.5875, 2.9773> <-4.7078, 12.6058, 2.8119>
		<-4.8088, 12.2566, 3.3409> <-4.7631, 12.2001, 3.1900> <-4.7837, 12.5019, 2.9842> <-4.7648, 12.5202, 2.8188>
		<-4.8377, 12.1330, 3.4100> <-4.8195, 12.0703, 3.2171> <-4.8761, 12.3922, 3.0445> <-4.8779, 12.4212, 2.8429>
		<-4.7978, 12.0502, 3.4498> <-4.7796, 11.9875, 3.2568> <-4.8958, 12.2914, 3.0364> <-4.8975, 12.3204, 2.8348>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7978, 12.0502, 3.4498> <-4.7224, 11.8937, 3.5249> <-4.5917, 11.6573, 3.5816> <-4.4425, 11.5749, 3.6640>
		<-4.8219, 12.1330, 3.7045> <-4.7465, 11.9765, 3.7797> <-4.5669, 11.6964, 3.8286> <-4.4177, 11.6140, 3.9110>
		<-4.9179, 12.5277, 3.8438> <-4.8579, 12.3469, 3.9542> <-4.7831, 12.0380, 4.0102> <-4.6307, 11.9127, 4.1080>
		<-5.0096, 12.7063, 4.0227> <-4.9496, 12.5254, 4.1331> <-4.8551, 12.2135, 4.1752> <-4.7027, 12.0881, 4.2729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7978, 12.0502, 3.4498> <-4.7796, 11.9875, 3.2568> <-4.8958, 12.2914, 3.0364> <-4.8975, 12.3204, 2.8348>
		<-4.7224, 11.8937, 3.5249> <-4.7042, 11.8310, 3.3320> <-4.9233, 12.1497, 3.0251> <-4.9251, 12.1787, 2.8235>
		<-4.5917, 11.6573, 3.5816> <-4.6224, 11.6088, 3.2755> <-4.8822, 11.9032, 3.0920> <-4.9449, 11.9537, 2.7912>
		<-4.4425, 11.5749, 3.6640> <-4.4733, 11.5264, 3.3579> <-4.7928, 11.7965, 3.0522> <-4.8555, 11.8470, 2.7513>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5356, 12.8755, 5.3545> <-4.3760, 12.9474, 5.3202> <-4.2718, 13.1464, 5.1611> <-4.2011, 13.2458, 5.0309>
		<-4.5597, 13.0089, 5.5109> <-4.4000, 13.0809, 5.4766> <-4.2977, 13.3044, 5.2906> <-4.2270, 13.4039, 5.1604>
		<-4.5426, 13.2443, 5.6687> <-4.3890, 13.3136, 5.6357> <-4.2976, 13.4780, 5.4675> <-4.2488, 13.5984, 5.3552>
		<-4.5759, 13.4025, 5.7979> <-4.4223, 13.4718, 5.7650> <-4.3172, 13.6428, 5.5895> <-4.2684, 13.7632, 5.4773>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5356, 12.8755, 5.3545> <-4.5597, 13.0089, 5.5109> <-4.5426, 13.2443, 5.6687> <-4.5759, 13.4025, 5.7979>
		<-4.6598, 12.8195, 5.3811> <-4.6839, 12.9529, 5.5375> <-4.6921, 13.1769, 5.7007> <-4.7255, 13.3351, 5.8300>
		<-4.8577, 12.8641, 5.2700> <-4.8990, 12.9883, 5.4282> <-4.9461, 13.2010, 5.6020> <-4.9760, 13.3456, 5.7445>
		<-4.9697, 12.8993, 5.1959> <-5.0110, 13.0235, 5.3540> <-5.0851, 13.2369, 5.5164> <-5.1150, 13.3816, 5.6589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2011, 13.2458, 5.0309> <-4.1106, 13.3731, 4.8643> <-4.1957, 13.4766, 4.4035> <-4.0120, 13.6117, 4.3908>
		<-4.2270, 13.4039, 5.1604> <-4.1365, 13.5312, 4.9938> <-4.2658, 13.6895, 4.5670> <-4.0822, 13.8247, 4.5543>
		<-4.2488, 13.5984, 5.3552> <-4.1780, 13.7731, 5.1923> <-4.2060, 13.9493, 4.7837> <-4.1395, 14.1756, 4.7036>
		<-4.2684, 13.7632, 5.4773> <-4.1976, 13.9379, 5.3143> <-4.2545, 14.1336, 4.9853> <-4.1879, 14.3599, 4.9052>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3884, 13.5088, 4.3508> <-5.4015, 13.4032, 4.4738> <-5.4927, 13.2451, 4.6383> <-5.4321, 13.1568, 4.7607>
		<-5.4748, 13.6816, 4.5078> <-5.4879, 13.5760, 4.6307> <-5.5585, 13.3754, 4.7793> <-5.4978, 13.2871, 4.9016>
		<-5.6295, 13.9159, 4.6905> <-5.6061, 13.7884, 4.7832> <-5.6612, 13.6295, 4.9027> <-5.5855, 13.5369, 5.0079>
		<-5.7004, 14.0980, 4.8446> <-5.6770, 13.9706, 4.9373> <-5.6981, 13.7659, 5.0483> <-5.6224, 13.6733, 5.1536>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4321, 13.1568, 4.7607> <-5.3554, 13.0452, 4.9154> <-5.1355, 12.9513, 5.0861> <-4.9697, 12.8993, 5.1959>
		<-5.4978, 13.2871, 4.9016> <-5.4212, 13.1755, 5.0563> <-5.1768, 13.0755, 5.2442> <-5.0110, 13.0235, 5.3540>
		<-5.5855, 13.5369, 5.0079> <-5.4753, 13.4021, 5.1612> <-5.2780, 13.2869, 5.3976> <-5.0851, 13.2369, 5.5164>
		<-5.6224, 13.6733, 5.1536> <-5.5122, 13.5384, 5.3068> <-5.3079, 13.4315, 5.5401> <-5.1150, 13.3816, 5.6589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5759, 13.4025, 5.7979> <-4.4223, 13.4718, 5.7650> <-4.3172, 13.6428, 5.5895> <-4.2684, 13.7632, 5.4773>
		<-4.6048, 13.5395, 5.9099> <-4.4512, 13.6087, 5.8769> <-4.3284, 13.7369, 5.6591> <-4.2796, 13.8573, 5.5469>
		<-4.6979, 13.7062, 6.0606> <-4.5178, 13.7700, 5.9721> <-4.3586, 13.8597, 5.7107> <-4.2733, 14.0147, 5.5967>
		<-4.7416, 13.8532, 6.1535> <-4.5616, 13.9169, 6.0649> <-4.3885, 13.9494, 5.7805> <-4.3032, 14.1045, 5.6665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5759, 13.4025, 5.7979> <-4.6048, 13.5395, 5.9099> <-4.6979, 13.7062, 6.0606> <-4.7416, 13.8532, 6.1535>
		<-4.7255, 13.3351, 5.8300> <-4.7543, 13.4721, 5.9420> <-4.8065, 13.6678, 6.1140> <-4.8502, 13.8148, 6.2069>
		<-4.9760, 13.3456, 5.7445> <-5.0023, 13.4727, 5.8697> <-5.0151, 13.5937, 5.9976> <-5.0444, 13.7434, 6.0938>
		<-5.1150, 13.3816, 5.6589> <-5.1413, 13.5087, 5.7842> <-5.1272, 13.6529, 5.9899> <-5.1565, 13.8026, 6.0861>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2684, 13.7632, 5.4773> <-4.1976, 13.9379, 5.3143> <-4.2545, 14.1336, 4.9853> <-4.1879, 14.3599, 4.9052>
		<-4.2796, 13.8573, 5.5469> <-4.2088, 14.0320, 5.3840> <-4.2925, 14.2780, 5.1433> <-4.2259, 14.5043, 5.0632>
		<-4.2733, 14.0147, 5.5967> <-4.2029, 14.1428, 5.5025> <-4.2942, 14.3892, 5.3801> <-4.2469, 14.5563, 5.3725>
		<-4.3032, 14.1045, 5.6665> <-4.2327, 14.2325, 5.5723> <-4.3384, 14.5051, 5.5587> <-4.2910, 14.6723, 5.5511>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1879, 14.3599, 4.9052> <-4.1542, 14.4745, 4.8646> <-4.0865, 14.6218, 5.0678> <-4.0115, 14.6367, 5.1681>
		<-4.2259, 14.5043, 5.0632> <-4.1922, 14.6190, 5.0227> <-4.1522, 14.7372, 5.1397> <-4.0772, 14.7520, 5.2400>
		<-4.2469, 14.5563, 5.3725> <-4.2273, 14.6254, 5.3694> <-4.1173, 14.6966, 5.4700> <-4.0650, 14.7201, 5.5132>
		<-4.2910, 14.6723, 5.5511> <-4.2715, 14.7413, 5.5480> <-4.1586, 14.7759, 5.5917> <-4.1063, 14.7994, 5.6349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1879, 14.3599, 4.9052> <-4.1395, 14.1756, 4.7036> <-4.0822, 13.8247, 4.5543> <-4.0120, 13.6117, 4.3908>
		<-4.1542, 14.4745, 4.8646> <-4.1057, 14.2902, 4.6630> <-3.8918, 13.9647, 4.5411> <-3.8217, 13.7518, 4.3777>
		<-4.0865, 14.6218, 5.0678> <-3.9517, 14.3854, 4.9204> <-3.8240, 13.9775, 4.8504> <-3.6495, 13.7284, 4.7933>
		<-4.0115, 14.6367, 5.1681> <-3.8767, 14.4003, 5.0207> <-3.6849, 14.0032, 5.0402> <-3.5104, 13.7541, 4.9831>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7004, 14.0980, 4.8446> <-5.6770, 13.9706, 4.9373> <-5.6981, 13.7659, 5.0483> <-5.6224, 13.6733, 5.1536>
		<-5.7786, 14.2990, 5.0146> <-5.7552, 14.1716, 5.1073> <-5.7627, 14.0047, 5.3035> <-5.6870, 13.9121, 5.4088>
		<-5.8433, 14.5266, 5.3299> <-5.8084, 14.4107, 5.5267> <-5.8289, 14.2718, 5.7695> <-5.7076, 14.1087, 5.8795>
		<-5.8833, 14.7805, 5.4265> <-5.8484, 14.6646, 5.6234> <-5.8882, 14.5573, 5.9728> <-5.7670, 14.3942, 6.0828>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6224, 13.6733, 5.1536> <-5.5122, 13.5384, 5.3068> <-5.3079, 13.4315, 5.5401> <-5.1150, 13.3816, 5.6589>
		<-5.6870, 13.9121, 5.4088> <-5.5769, 13.7773, 5.5620> <-5.3342, 13.5586, 5.6654> <-5.1413, 13.5087, 5.7842>
		<-5.7076, 14.1087, 5.8795> <-5.5738, 13.9286, 6.0009> <-5.3524, 13.7717, 5.9743> <-5.1272, 13.6529, 5.9899>
		<-5.7670, 14.3942, 6.0828> <-5.6332, 14.2142, 6.2042> <-5.3816, 13.9214, 6.0706> <-5.1565, 13.8026, 6.0861>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7416, 13.8532, 6.1535> <-4.5616, 13.9169, 6.0649> <-4.3885, 13.9494, 5.7805> <-4.3032, 14.1045, 5.6665>
		<-4.8514, 14.2221, 6.3865> <-4.6713, 14.2858, 6.2979> <-4.4677, 14.1873, 5.9656> <-4.3824, 14.3424, 5.8516>
		<-5.0759, 14.6949, 6.7291> <-4.8981, 14.6019, 6.6112> <-4.6897, 14.5944, 6.3913> <-4.5657, 14.5651, 6.1966>
		<-5.0866, 15.1180, 6.8816> <-4.9088, 15.0250, 6.7638> <-4.7523, 14.8743, 6.5133> <-4.6284, 14.8450, 6.3187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7416, 13.8532, 6.1535> <-4.8514, 14.2221, 6.3865> <-5.0759, 14.6949, 6.7291> <-5.0866, 15.1180, 6.8816>
		<-4.8502, 13.8148, 6.2069> <-4.9600, 14.1836, 6.4399> <-5.1765, 14.7476, 6.7958> <-5.1873, 15.1707, 6.9483>
		<-5.0444, 13.7434, 6.0938> <-5.1283, 14.1734, 6.3702> <-5.4262, 14.7580, 6.7632> <-5.3770, 15.2437, 6.9367>
		<-5.1565, 13.8026, 6.0861> <-5.2404, 14.2326, 6.3625> <-5.5377, 14.8093, 6.7153> <-5.4885, 15.2950, 6.8888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3032, 14.1045, 5.6665> <-4.2327, 14.2325, 5.5723> <-4.3384, 14.5051, 5.5587> <-4.2910, 14.6723, 5.5511>
		<-4.3824, 14.3424, 5.8516> <-4.3119, 14.4705, 5.7574> <-4.3639, 14.5721, 5.6619> <-4.3165, 14.7392, 5.6543>
		<-4.5657, 14.5651, 6.1966> <-4.4785, 14.5444, 6.0596> <-4.4737, 14.7977, 5.8987> <-4.3773, 14.8515, 5.7778>
		<-4.6284, 14.8450, 6.3187> <-4.5411, 14.8243, 6.1816> <-4.5127, 14.9057, 5.9497> <-4.4162, 14.9595, 5.8288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2910, 14.6723, 5.5511> <-4.2715, 14.7413, 5.5480> <-4.1586, 14.7759, 5.5917> <-4.1063, 14.7994, 5.6349>
		<-4.3165, 14.7392, 5.6543> <-4.2970, 14.8083, 5.6511> <-4.1874, 14.8311, 5.6764> <-4.1351, 14.8547, 5.7196>
		<-4.3773, 14.8515, 5.7778> <-4.3401, 14.8722, 5.7313> <-4.2484, 14.9650, 5.7588> <-4.1950, 14.9732, 5.7913>
		<-4.4162, 14.9595, 5.8288> <-4.3791, 14.9802, 5.7823> <-4.2878, 15.0565, 5.7925> <-4.2344, 15.0647, 5.8250>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.8833, 14.7805, 5.4265> <-5.8484, 14.6646, 5.6234> <-5.8882, 14.5573, 5.9728> <-5.7670, 14.3942, 6.0828>
		<-5.9212, 15.0210, 5.5181> <-5.8863, 14.9051, 5.7150> <-5.9504, 14.8566, 6.1858> <-5.8291, 14.6934, 6.2958>
		<-6.0596, 15.4121, 5.4327> <-6.0796, 15.3815, 5.7480> <-6.2234, 15.2694, 6.1167> <-6.1309, 15.1983, 6.4119>
		<-5.9443, 15.6453, 5.4337> <-5.9643, 15.6147, 5.7490> <-6.1035, 15.6145, 6.1896> <-6.0110, 15.5434, 6.4848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7670, 14.3942, 6.0828> <-5.6332, 14.2142, 6.2042> <-5.3816, 13.9214, 6.0706> <-5.1565, 13.8026, 6.0861>
		<-5.8291, 14.6934, 6.2958> <-5.6953, 14.5134, 6.4172> <-5.4656, 14.3514, 6.3470> <-5.2404, 14.2326, 6.3625>
		<-6.1309, 15.1983, 6.4119> <-6.0692, 15.1509, 6.6088> <-5.7169, 14.8918, 6.6384> <-5.5377, 14.8093, 6.7153>
		<-6.0110, 15.5434, 6.4848> <-5.9493, 15.4960, 6.6817> <-5.6677, 15.3774, 6.8119> <-5.4885, 15.2950, 6.8888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7078, 12.6058, 2.8119> <-4.6783, 12.6342, 2.5541> <-4.6683, 12.5108, 2.2108> <-4.6597, 12.4933, 1.9505>
		<-4.7648, 12.5202, 2.8188> <-4.7352, 12.5486, 2.5610> <-4.7136, 12.4426, 2.2108> <-4.7051, 12.4251, 1.9505>
		<-4.8779, 12.4212, 2.8429> <-4.8802, 12.4592, 2.5785> <-4.8082, 12.3539, 2.2170> <-4.7932, 12.3458, 1.9505>
		<-4.8975, 12.3204, 2.8348> <-4.8998, 12.3584, 2.5705> <-4.8259, 12.2739, 2.2170> <-4.8109, 12.2658, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8975, 12.3204, 2.8348> <-4.8998, 12.3584, 2.5705> <-4.8259, 12.2739, 2.2170> <-4.8109, 12.2658, 1.9505>
		<-4.9251, 12.1787, 2.8235> <-4.9274, 12.2167, 2.5592> <-4.8521, 12.1557, 2.2170> <-4.8371, 12.1476, 1.9505>
		<-4.9449, 11.9537, 2.7912> <-4.9934, 11.9927, 2.5585> <-4.8914, 11.9479, 2.1911> <-4.8820, 11.9512, 1.9505>
		<-4.8555, 11.8470, 2.7513> <-4.9040, 11.8861, 2.5186> <-4.8092, 11.8590, 2.1911> <-4.7997, 11.8623, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8555, 11.8470, 2.7513> <-4.9040, 11.8861, 2.5186> <-4.8092, 11.8590, 2.1911> <-4.7997, 11.8623, 1.9505>
		<-4.7605, 11.7335, 2.7089> <-4.8090, 11.7725, 2.4762> <-4.7236, 11.7665, 2.1911> <-4.7142, 11.7699, 1.9505>
		<-4.5367, 11.7043, 2.5882> <-4.5589, 11.7147, 2.3911> <-4.5104, 11.7881, 2.1486> <-4.5100, 11.8030, 1.9505>
		<-4.3837, 11.7069, 2.6055> <-4.4059, 11.7173, 2.4083> <-4.3845, 11.7895, 2.1486> <-4.3841, 11.8044, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3837, 11.7069, 2.6055> <-4.4059, 11.7173, 2.4083> <-4.3845, 11.7895, 2.1486> <-4.3841, 11.8044, 1.9505>
		<-4.1825, 11.7103, 2.6282> <-4.2047, 11.7207, 2.4310> <-4.2334, 11.7912, 2.1486> <-4.2329, 11.8061, 1.9505>
		<-3.9803, 11.8275, 2.8385> <-3.9755, 11.8012, 2.5616> <-4.0139, 11.8314, 2.2302> <-4.0309, 11.8339, 1.9525>
		<-3.7842, 11.8652, 2.8722> <-3.7794, 11.8389, 2.5953> <-3.8677, 11.8701, 2.2281> <-3.8847, 11.8725, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7842, 11.8652, 2.8722> <-3.7794, 11.8389, 2.5953> <-3.8677, 11.8701, 2.2281> <-3.8847, 11.8725, 1.9505>
		<-3.6076, 11.8992, 2.9025> <-3.6028, 11.8729, 2.6256> <-3.6880, 11.9177, 2.2256> <-3.7049, 11.9201, 1.9479>
		<-3.3451, 11.9127, 2.7308> <-3.3519, 11.9236, 2.4618> <-3.4660, 12.0369, 2.1909> <-3.4876, 12.0605, 1.9235>
		<-3.1835, 11.9379, 2.8116> <-3.1903, 11.9489, 2.5426> <-3.2828, 12.0666, 2.2026> <-3.3044, 12.0901, 1.9352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2686, 12.0317, 3.3668> <-2.9283, 12.0264, 3.5085> <-2.6283, 12.0048, 3.9428> <-2.3809, 12.0032, 4.2161>
		<-3.3378, 12.1309, 3.5285> <-2.9975, 12.1256, 3.6702> <-2.6187, 12.0543, 4.0797> <-2.3713, 12.0527, 4.3530>
		<-3.4964, 12.3381, 3.6518> <-3.0937, 12.3395, 3.6892> <-2.7111, 12.3268, 4.1526> <-2.3958, 12.2949, 4.4039>
		<-3.5785, 12.5034, 3.7335> <-3.1758, 12.5049, 3.7709> <-2.7685, 12.4434, 4.2189> <-2.4533, 12.4116, 4.4702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2686, 12.0317, 3.3668> <-3.2100, 11.9478, 3.2300> <-3.1793, 11.9309, 2.9822> <-3.1835, 11.9379, 2.8116>
		<-2.9283, 12.0264, 3.5085> <-2.8697, 11.9425, 3.3717> <-2.9225, 11.9710, 3.1105> <-2.9268, 11.9780, 2.9399>
		<-2.6283, 12.0048, 3.9428> <-2.6427, 11.9307, 3.7376> <-2.7058, 12.0530, 3.5233> <-2.7338, 12.0597, 3.3066>
		<-2.3809, 12.0032, 4.2161> <-2.3953, 11.9291, 4.0109> <-2.4932, 12.0557, 3.7201> <-2.5211, 12.0624, 3.5034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5211, 12.0624, 3.5034> <-2.7338, 12.0597, 3.3066> <-2.9268, 11.9780, 2.9399> <-3.1835, 11.9379, 2.8116>
		<-2.5779, 12.0758, 3.0628> <-2.7906, 12.0732, 2.8660> <-2.9335, 11.9889, 2.6709> <-3.1903, 11.9489, 2.5426>
		<-2.6354, 12.0687, 2.4724> <-2.8289, 12.0822, 2.4589> <-3.0912, 12.0976, 2.2149> <-3.2828, 12.0666, 2.2026>
		<-2.6630, 12.0702, 2.0288> <-2.8566, 12.0838, 2.0153> <-3.1127, 12.1211, 1.9475> <-3.3044, 12.0901, 1.9352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6560, 12.4992, 1.2292> <-4.7014, 12.4309, 1.2292> <-4.7895, 12.3517, 1.2292> <-4.8072, 12.2717, 1.2292>
		<-4.6571, 12.4974, 1.4456> <-4.7025, 12.4292, 1.4456> <-4.7906, 12.3499, 1.4456> <-4.8083, 12.2699, 1.4456>
		<-4.6527, 12.4788, 1.7347> <-4.6980, 12.4105, 1.7347> <-4.7810, 12.3393, 1.7345> <-4.7988, 12.2593, 1.7345>
		<-4.6597, 12.4933, 1.9505> <-4.7051, 12.4251, 1.9505> <-4.7932, 12.3458, 1.9505> <-4.8109, 12.2658, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8072, 12.2717, 1.2292> <-4.8334, 12.1535, 1.2292> <-4.8783, 11.9571, 1.2292> <-4.7960, 11.8682, 1.2292>
		<-4.8083, 12.2699, 1.4456> <-4.8345, 12.1517, 1.4456> <-4.8794, 11.9553, 1.4456> <-4.7971, 11.8664, 1.4456>
		<-4.7988, 12.2593, 1.7345> <-4.8250, 12.1411, 1.7345> <-4.8735, 11.9542, 1.7343> <-4.7913, 11.8653, 1.7343>
		<-4.8109, 12.2658, 1.9505> <-4.8371, 12.1476, 1.9505> <-4.8820, 11.9512, 1.9505> <-4.7997, 11.8623, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7960, 11.8682, 1.2292> <-4.7105, 11.7758, 1.2292> <-4.5062, 11.8087, 1.2292> <-4.3803, 11.8103, 1.2292>
		<-4.7971, 11.8664, 1.4456> <-4.7116, 11.7740, 1.4456> <-4.5074, 11.8070, 1.4456> <-4.3815, 11.8085, 1.4456>
		<-4.7913, 11.8653, 1.7343> <-4.7058, 11.7729, 1.7343> <-4.5094, 11.8192, 1.7347> <-4.3835, 11.8206, 1.7347>
		<-4.7997, 11.8623, 1.9505> <-4.7142, 11.7699, 1.9505> <-4.5100, 11.8030, 1.9505> <-4.3841, 11.8044, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3803, 11.8103, 1.2292> <-4.2302, 11.8122, 1.2292> <-4.0304, 11.8431, 1.2292> <-3.8847, 11.8795, 1.2292>
		<-4.3815, 11.8085, 1.4456> <-4.2313, 11.8104, 1.4456> <-4.0304, 11.8410, 1.4456> <-3.8847, 11.8774, 1.4456>
		<-4.3835, 11.8206, 1.7347> <-4.2324, 11.8223, 1.7347> <-4.0441, 11.8357, 1.7366> <-3.8979, 11.8744, 1.7345>
		<-4.3841, 11.8044, 1.9505> <-4.2329, 11.8061, 1.9505> <-4.0309, 11.8339, 1.9525> <-3.8847, 11.8725, 1.9505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8847, 11.8795, 1.2292> <-3.7082, 11.9236, 1.2292> <-3.4911, 12.0491, 1.2292> <-3.3113, 12.0772, 1.2292>
		<-3.8847, 11.8774, 1.4456> <-3.7082, 11.9215, 1.4456> <-3.4890, 12.0530, 1.4410> <-3.3092, 12.0811, 1.4410>
		<-3.8979, 11.8744, 1.7345> <-3.7182, 11.9220, 1.7320> <-3.5046, 12.0790, 1.7131> <-3.3214, 12.1086, 1.7249>
		<-3.8847, 11.8725, 1.9505> <-3.7049, 11.9201, 1.9479> <-3.4876, 12.0605, 1.9235> <-3.3044, 12.0901, 1.9352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3044, 12.0901, 1.9352> <-3.3214, 12.1086, 1.7249> <-3.3092, 12.0811, 1.4410> <-3.3113, 12.0772, 1.2292>
		<-3.1127, 12.1211, 1.9475> <-3.1297, 12.1397, 1.7372> <-3.1170, 12.1111, 1.4410> <-3.1191, 12.1072, 1.2292>
		<-2.8566, 12.0838, 2.0153> <-2.8716, 12.0846, 1.7759> <-2.8572, 12.0819, 1.4691> <-2.8572, 12.0819, 1.2292>
		<-2.6630, 12.0702, 2.0288> <-2.6780, 12.0710, 1.7894> <-2.6630, 12.0702, 1.4691> <-2.6630, 12.0702, 1.2292>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4034, 12.8575, 1.2292> <-1.4217, 12.9924, 1.2292> <-1.4118, 13.1824, 1.2292> <-1.4675, 13.3067, 1.2292>
		<-1.4034, 12.8513, 1.4537> <-1.4217, 12.9862, 1.4537> <-1.4118, 13.2071, 1.4281> <-1.4675, 13.3313, 1.4281>
		<-1.4080, 12.8351, 1.7530> <-1.4287, 13.0011, 1.7315> <-1.3981, 13.2359, 1.7059> <-1.4720, 13.3868, 1.6917>
		<-1.4034, 12.8370, 1.9774> <-1.4242, 13.0029, 1.9560> <-1.3936, 13.2379, 1.9062> <-1.4675, 13.3888, 1.8920>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4034, 12.8370, 1.9774> <-1.4242, 13.0029, 1.9560> <-1.3936, 13.2379, 1.9062> <-1.4675, 13.3888, 1.8920>
		<-1.3946, 12.8404, 2.4088> <-1.4154, 13.0064, 2.3873> <-1.3863, 13.2412, 2.2338> <-1.4601, 13.3921, 2.2196>
		<-1.3589, 12.8903, 2.9832> <-1.3794, 13.0229, 2.8511> <-1.3562, 13.2145, 2.7614> <-1.4280, 13.3524, 2.6552>
		<-1.3589, 12.8751, 3.4144> <-1.3794, 13.0077, 3.2823> <-1.3562, 13.1865, 3.0879> <-1.4280, 13.3243, 2.9816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3589, 12.8751, 3.4144> <-1.3794, 13.0077, 3.2823> <-1.3562, 13.1865, 3.0879> <-1.4280, 13.3243, 2.9816>
		<-1.3589, 12.8644, 3.7179> <-1.3794, 12.9970, 3.5858> <-1.3562, 13.1641, 3.3485> <-1.4280, 13.3019, 3.2423>
		<-1.3595, 12.7388, 4.1178> <-1.3817, 12.8831, 3.9495> <-1.3612, 13.0516, 3.7412> <-1.4294, 13.1989, 3.5886>
		<-1.4034, 12.7511, 4.4181> <-1.4255, 12.8954, 4.2498> <-1.3994, 13.0735, 3.9991> <-1.4675, 13.2208, 3.8465>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4034, 12.7511, 4.4181> <-1.4255, 12.8954, 4.2498> <-1.3994, 13.0735, 3.9991> <-1.4675, 13.2208, 3.8465>
		<-1.4170, 12.7549, 4.5111> <-1.4391, 12.8992, 4.3428> <-1.4130, 13.0813, 4.0911> <-1.4811, 13.2286, 3.9384>
		<-1.4930, 12.8505, 4.6065> <-1.4906, 12.9955, 4.4291> <-1.4683, 13.1960, 4.1613> <-1.5450, 13.3483, 4.0082>
		<-1.5382, 12.9253, 4.6413> <-1.5357, 13.0704, 4.4638> <-1.5105, 13.2631, 4.2104> <-1.5872, 13.4155, 4.0573>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5382, 12.9253, 4.6413> <-1.5357, 13.0704, 4.4638> <-1.5105, 13.2631, 4.2104> <-1.5872, 13.4155, 4.0573>
		<-1.6637, 13.1331, 4.7379> <-1.6612, 13.2781, 4.5604> <-1.6161, 13.4313, 4.3332> <-1.6928, 13.5837, 4.1801>
		<-1.8536, 13.4294, 4.7839> <-1.8465, 13.5142, 4.6448> <-1.8280, 13.7177, 4.4545> <-1.8700, 13.8036, 4.3225>
		<-1.9543, 13.6634, 4.8422> <-1.9471, 13.7481, 4.7031> <-1.9146, 13.9137, 4.5473> <-1.9566, 13.9996, 4.4153>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9543, 13.6634, 4.8422> <-1.9471, 13.7481, 4.7031> <-1.9146, 13.9137, 4.5473> <-1.9566, 13.9996, 4.4153>
		<-2.0741, 13.9419, 4.9116> <-2.0669, 14.0267, 4.7726> <-2.0245, 14.1627, 4.6652> <-2.0666, 14.2485, 4.5332>
		<-2.1620, 14.3421, 4.9964> <-2.1444, 14.4106, 4.8969> <-2.1132, 14.5374, 4.7696> <-2.1441, 14.6135, 4.6793>
		<-2.2697, 14.6258, 5.0650> <-2.2521, 14.6943, 4.9655> <-2.2056, 14.8093, 4.8437> <-2.2366, 14.8855, 4.7534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2697, 14.6258, 5.0650> <-2.2521, 14.6943, 4.9655> <-2.2056, 14.8093, 4.8437> <-2.2366, 14.8855, 4.7534>
		<-2.3197, 14.7577, 5.0970> <-2.3021, 14.8262, 4.9975> <-2.2542, 14.9521, 4.8826> <-2.2851, 15.0283, 4.7924>
		<-2.4298, 14.9164, 5.1342> <-2.4161, 14.9915, 5.0022> <-2.3262, 15.1344, 4.8842> <-2.3758, 15.2217, 4.7695>
		<-2.4789, 15.0457, 5.1766> <-2.4652, 15.1208, 5.0446> <-2.3726, 15.2818, 4.9034> <-2.4223, 15.3691, 4.7887>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4789, 15.0457, 5.1766> <-2.4652, 15.1208, 5.0446> <-2.3726, 15.2818, 4.9034> <-2.4223, 15.3691, 4.7887>
		<-2.5546, 15.2451, 5.2419> <-2.5409, 15.3201, 5.1099> <-2.4368, 15.4854, 4.9298> <-2.4865, 15.5727, 4.8151>
		<-2.5956, 15.5280, 5.3429> <-2.5643, 15.6225, 5.1850> <-2.4810, 15.7818, 5.0380> <-2.5222, 15.8568, 4.8721>
		<-2.6840, 15.7167, 5.4224> <-2.6527, 15.8112, 5.2645> <-2.5632, 15.9779, 5.0707> <-2.6044, 16.0529, 4.9048>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6840, 15.7167, 5.4224> <-2.6527, 15.8112, 5.2645> <-2.5632, 15.9779, 5.0707> <-2.6044, 16.0529, 4.9048>
		<-2.8293, 16.0268, 5.5530> <-2.7980, 16.1213, 5.3951> <-2.6885, 16.2770, 5.1207> <-2.7298, 16.3520, 4.9548>
		<-3.0195, 16.4261, 5.8024> <-2.9843, 16.5552, 5.5749> <-2.8797, 16.7205, 5.3000> <-2.8927, 16.7651, 5.0401>
		<-3.2535, 16.6992, 5.8732> <-3.2183, 16.8283, 5.6457> <-3.0970, 16.9653, 5.3225> <-3.1100, 17.0099, 5.0627>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4675, 13.3067, 1.2292> <-1.5623, 13.5183, 1.2292> <-1.7477, 13.7713, 1.2292> <-1.8936, 13.9516, 1.2292>
		<-1.4675, 13.3313, 1.4281> <-1.5623, 13.5429, 1.4281> <-1.7477, 13.7374, 1.4255> <-1.8936, 13.9177, 1.4255>
		<-1.4720, 13.3868, 1.6917> <-1.5534, 13.5532, 1.6761> <-1.7652, 13.7249, 1.6895> <-1.8983, 13.8546, 1.6849>
		<-1.4675, 13.3888, 1.8920> <-1.5489, 13.5552, 1.8764> <-1.7605, 13.7089, 1.8879> <-1.8936, 13.8386, 1.8833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4675, 13.3888, 1.8920> <-1.5489, 13.5552, 1.8764> <-1.7605, 13.7089, 1.8879> <-1.8936, 13.8386, 1.8833>
		<-1.4601, 13.3921, 2.2196> <-1.5415, 13.5585, 2.2040> <-1.7549, 13.6899, 2.1246> <-1.8880, 13.8195, 2.1200>
		<-1.4280, 13.3524, 2.6552> <-1.5123, 13.5140, 2.5306> <-1.7073, 13.6927, 2.4996> <-1.8595, 13.8398, 2.4368>
		<-1.4280, 13.3243, 2.9816> <-1.5123, 13.4859, 2.8570> <-1.7073, 13.6881, 2.7371> <-1.8595, 13.8352, 2.6743>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4280, 13.3243, 2.9816> <-1.5123, 13.4859, 2.8570> <-1.7073, 13.6881, 2.7371> <-1.8595, 13.8352, 2.6743>
		<-1.4280, 13.3019, 3.2423> <-1.5123, 13.4635, 3.1177> <-1.7073, 13.6843, 2.9313> <-1.8595, 13.8314, 2.8684>
		<-1.4294, 13.1989, 3.5886> <-1.5118, 13.3771, 3.4041> <-1.6767, 13.5859, 3.2906> <-1.8330, 13.7508, 3.1458>
		<-1.4675, 13.2208, 3.8465> <-1.5499, 13.3989, 3.6620> <-1.7374, 13.6458, 3.4651> <-1.8936, 13.8107, 3.3203>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4675, 13.2208, 3.8465> <-1.5499, 13.3989, 3.6620> <-1.7374, 13.6458, 3.4651> <-1.8936, 13.8107, 3.3203>
		<-1.4811, 13.2286, 3.9384> <-1.5635, 13.4067, 3.7539> <-1.7750, 13.6830, 3.5734> <-1.9313, 13.8479, 3.4286>
		<-1.5450, 13.3483, 4.0082> <-1.6518, 13.5604, 3.7952> <-1.8817, 13.8232, 3.5703> <-2.0697, 14.0173, 3.4008>
		<-1.5872, 13.4155, 4.0573> <-1.6940, 13.6276, 3.8443> <-1.9436, 13.9099, 3.6266> <-2.1316, 14.1041, 3.4571>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5872, 13.4155, 4.0573> <-1.6940, 13.6276, 3.8443> <-1.9436, 13.9099, 3.6266> <-2.1316, 14.1041, 3.4571>
		<-1.6928, 13.5837, 4.1801> <-1.7996, 13.7958, 3.9671> <-2.0098, 14.0027, 3.6867> <-2.1978, 14.1969, 3.5172>
		<-1.8700, 13.8036, 4.3225> <-1.9390, 13.9447, 4.1054> <-2.1393, 14.1530, 3.8151> <-2.2799, 14.2980, 3.6390>
		<-1.9566, 13.9996, 4.4153> <-2.0256, 14.1406, 4.1982> <-2.1757, 14.2580, 3.8804> <-2.3162, 14.4030, 3.7043>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9566, 13.9996, 4.4153> <-2.0256, 14.1406, 4.1982> <-2.1757, 14.2580, 3.8804> <-2.3162, 14.4030, 3.7043>
		<-2.0666, 14.2485, 4.5332> <-2.1356, 14.3896, 4.3161> <-2.2683, 14.5256, 4.0468> <-2.4089, 14.6706, 3.8707>
		<-2.1441, 14.6135, 4.6793> <-2.2024, 14.7570, 4.5092> <-2.3367, 14.9782, 4.1636> <-2.4678, 15.0972, 4.0168>
		<-2.2366, 14.8855, 4.7534> <-2.2949, 15.0289, 4.5834> <-2.4271, 15.2172, 4.3699> <-2.5582, 15.3362, 4.2231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2366, 14.8855, 4.7534> <-2.2949, 15.0289, 4.5834> <-2.4271, 15.2172, 4.3699> <-2.5582, 15.3362, 4.2231>
		<-2.2851, 15.0283, 4.7924> <-2.3434, 15.1718, 4.6223> <-2.4643, 15.3155, 4.4548> <-2.5954, 15.4345, 4.3079>
		<-2.3758, 15.2217, 4.7695> <-2.4104, 15.2824, 4.6898> <-2.5731, 15.3474, 4.5980> <-2.6712, 15.3580, 4.5591>
		<-2.4223, 15.3691, 4.7887> <-2.4569, 15.4298, 4.7089> <-2.6207, 15.4565, 4.6618> <-2.7187, 15.4672, 4.6228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4223, 15.3691, 4.7887> <-2.4569, 15.4298, 4.7089> <-2.6207, 15.4565, 4.6618> <-2.7187, 15.4672, 4.6228>
		<-2.4865, 15.5727, 4.8151> <-2.5210, 15.6335, 4.7353> <-2.6861, 15.6067, 4.7496> <-2.7842, 15.6174, 4.7106>
		<-2.5222, 15.8568, 4.8721> <-2.5469, 15.9017, 4.7726> <-2.7071, 15.8985, 4.6963> <-2.8051, 15.8943, 4.6424>
		<-2.6044, 16.0529, 4.9048> <-2.6291, 16.0978, 4.8054> <-2.7781, 16.0702, 4.7035> <-2.8761, 16.0659, 4.6496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6044, 16.0529, 4.9048> <-2.6291, 16.0978, 4.8054> <-2.7781, 16.0702, 4.7035> <-2.8761, 16.0659, 4.6496>
		<-2.7298, 16.3520, 4.9548> <-2.7545, 16.3969, 4.8553> <-2.8865, 16.3320, 4.7145> <-2.9844, 16.3277, 4.6605>
		<-2.8927, 16.7651, 5.0401> <-2.8992, 16.7876, 4.9091> <-3.0333, 16.7148, 4.7620> <-3.1323, 16.6849, 4.6783>
		<-3.1100, 17.0099, 5.0627> <-3.1166, 17.0324, 4.9317> <-3.2140, 16.9334, 4.7666> <-3.3130, 16.9035, 4.6829>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3187, 14.3582, 1.2292> <-2.3187, 14.3162, 1.4191> <-2.3232, 14.2463, 1.6698> <-2.3187, 14.2181, 1.8622>
		<-2.1912, 14.2362, 1.2292> <-2.1912, 14.1942, 1.4191> <-2.1957, 14.1325, 1.6762> <-2.1912, 14.1043, 1.8685>
		<-2.0046, 14.0887, 1.2292> <-2.0046, 14.0549, 1.4255> <-2.0208, 13.9739, 1.6806> <-2.0161, 13.9579, 1.8790>
		<-1.8936, 13.9516, 1.2292> <-1.8936, 13.9177, 1.4255> <-1.8983, 13.8546, 1.6849> <-1.8936, 13.8386, 1.8833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3187, 14.2181, 1.8622> <-2.3133, 14.1847, 2.0903> <-2.2857, 14.1722, 2.3976> <-2.2857, 14.1532, 2.6275>
		<-2.1912, 14.1043, 1.8685> <-2.1858, 14.0708, 2.0966> <-2.1578, 14.0768, 2.4117> <-2.1578, 14.0578, 2.6415>
		<-2.0161, 13.9579, 1.8790> <-2.0105, 13.9389, 2.1157> <-1.9699, 13.9465, 2.3912> <-1.9699, 13.9419, 2.6287>
		<-1.8936, 13.8386, 1.8833> <-1.8880, 13.8195, 2.1200> <-1.8595, 13.8398, 2.4368> <-1.8595, 13.8352, 2.6743>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2857, 14.1532, 2.6275> <-2.2857, 14.1425, 2.7568> <-2.2670, 14.0690, 2.9495> <-2.3187, 14.1192, 3.0574>
		<-2.1578, 14.0578, 2.6415> <-2.1578, 14.0471, 2.7708> <-2.1395, 13.9764, 3.0284> <-2.1912, 14.0267, 3.1363>
		<-1.9699, 13.9419, 2.6287> <-1.9699, 13.9381, 2.8229> <-1.9351, 13.8586, 3.0511> <-1.9958, 13.9185, 3.2256>
		<-1.8595, 13.8352, 2.6743> <-1.8595, 13.8314, 2.8684> <-1.8330, 13.7508, 3.1458> <-1.8936, 13.8107, 3.3203>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3187, 14.1192, 3.0574> <-2.3662, 14.1654, 3.1566> <-2.4980, 14.3219, 3.1331> <-2.5533, 14.4134, 3.1861>
		<-2.1912, 14.0267, 3.1363> <-2.2387, 14.0729, 3.2355> <-2.3715, 14.2292, 3.2143> <-2.4268, 14.3206, 3.2674>
		<-1.9958, 13.9185, 3.2256> <-2.0334, 13.9558, 3.3339> <-2.1738, 14.1249, 3.3069> <-2.2357, 14.2116, 3.3632>
		<-1.8936, 13.8107, 3.3203> <-1.9313, 13.8479, 3.4286> <-2.0697, 14.0173, 3.4008> <-2.1316, 14.1041, 3.4571>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5533, 14.4134, 3.1861> <-2.6222, 14.5272, 3.2522> <-2.6848, 14.6766, 3.3705> <-2.7276, 14.7950, 3.4495>
		<-2.4268, 14.3206, 3.2674> <-2.4957, 14.4345, 3.3335> <-2.5614, 14.5590, 3.4469> <-2.6042, 14.6774, 3.5260>
		<-2.2357, 14.2116, 3.3632> <-2.3019, 14.3044, 3.4233> <-2.3779, 14.3991, 3.5163> <-2.4143, 14.5041, 3.5816>
		<-2.1316, 14.1041, 3.4571> <-2.1978, 14.1969, 3.5172> <-2.2799, 14.2980, 3.6390> <-2.3162, 14.4030, 3.7043>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7276, 14.7950, 3.4495> <-2.8075, 15.0162, 3.5973> <-2.8788, 15.4056, 3.7149> <-2.9617, 15.5438, 3.9412>
		<-2.6042, 14.6774, 3.5260> <-2.6841, 14.8986, 3.6737> <-2.7578, 15.3433, 3.7995> <-2.8407, 15.4815, 4.0257>
		<-2.4143, 14.5041, 3.5816> <-2.5069, 14.7717, 3.7479> <-2.5592, 15.1801, 3.9145> <-2.6496, 15.4191, 4.1208>
		<-2.3162, 14.4030, 3.7043> <-2.4089, 14.6706, 3.8707> <-2.4678, 15.0972, 4.0168> <-2.5582, 15.3362, 4.2231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9617, 15.5438, 3.9412> <-3.0154, 15.6335, 4.0879> <-3.0499, 15.3398, 4.3824> <-3.1170, 15.4446, 4.5128>
		<-2.8407, 15.4815, 4.0257> <-2.8944, 15.5712, 4.1725> <-2.9304, 15.3466, 4.4154> <-2.9975, 15.4513, 4.5458>
		<-2.6496, 15.4191, 4.1208> <-2.6867, 15.5174, 4.2056> <-2.7860, 15.3705, 4.5135> <-2.8335, 15.4796, 4.5773>
		<-2.5582, 15.3362, 4.2231> <-2.5954, 15.4345, 4.3079> <-2.6712, 15.3580, 4.5591> <-2.7187, 15.4672, 4.6228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1170, 15.4446, 4.5128> <-3.1840, 15.5491, 4.6429> <-3.2005, 15.8578, 4.5317> <-3.2692, 16.0239, 4.5386>
		<-2.9975, 15.4513, 4.5458> <-3.0645, 15.5559, 4.6759> <-3.0826, 15.8704, 4.5650> <-3.1513, 16.0365, 4.5719>
		<-2.8335, 15.4796, 4.5773> <-2.8990, 15.6298, 4.6650> <-2.9129, 15.8896, 4.5830> <-2.9839, 16.0612, 4.5902>
		<-2.7187, 15.4672, 4.6228> <-2.7842, 15.6174, 4.7106> <-2.8051, 15.8943, 4.6424> <-2.8761, 16.0659, 4.6496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2692, 16.0239, 4.5386> <-3.3741, 16.2772, 4.5492> <-3.5390, 16.6065, 4.5662> <-3.6920, 16.8342, 4.5709>
		<-3.1513, 16.0365, 4.5719> <-3.2561, 16.2898, 4.5825> <-3.4253, 16.6273, 4.5998> <-3.5783, 16.8550, 4.6045>
		<-2.9839, 16.0612, 4.5902> <-3.0923, 16.3230, 4.6011> <-3.2219, 16.6579, 4.6026> <-3.4026, 16.8764, 4.6072>
		<-2.8761, 16.0659, 4.6496> <-2.9844, 16.3277, 4.6605> <-3.1323, 16.6849, 4.6783> <-3.3130, 16.9035, 4.6829>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3211, 17.5894, 4.5709> <-4.2826, 17.6101, 4.6045> <-4.2123, 17.6413, 4.6343> <-4.1929, 17.6586, 4.6829>
		<-4.1323, 17.3628, 4.5709> <-4.0939, 17.3836, 4.6045> <-3.9484, 17.4147, 4.6343> <-3.9289, 17.4321, 4.6829>
		<-3.8564, 17.0789, 4.5759> <-3.7427, 17.0997, 4.6095> <-3.6242, 17.1445, 4.6128> <-3.5346, 17.1715, 4.6885>
		<-3.6920, 16.8342, 4.5709> <-3.5783, 16.8550, 4.6045> <-3.4026, 16.8764, 4.6072> <-3.3130, 16.9035, 4.6829>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1929, 17.6586, 4.6829> <-4.1505, 17.6964, 4.7888> <-4.1262, 17.7854, 4.9443> <-4.1242, 17.7651, 5.0627>
		<-3.9289, 17.4321, 4.6829> <-3.8866, 17.4699, 4.7888> <-3.8220, 17.5588, 4.9443> <-3.8200, 17.5385, 5.0627>
		<-3.5346, 17.1715, 4.6885> <-3.4356, 17.2014, 4.7722> <-3.3678, 17.3154, 4.9578> <-3.3612, 17.2929, 5.0888>
		<-3.3130, 16.9035, 4.6829> <-3.2140, 16.9334, 4.7666> <-3.1166, 17.0324, 4.9317> <-3.1100, 17.0099, 5.0627>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1242, 17.7651, 5.0627> <-4.1199, 17.7210, 5.3197> <-4.1609, 17.5830, 5.6466> <-4.1728, 17.4544, 5.8732>
		<-3.8200, 17.5385, 5.0627> <-3.8156, 17.4944, 5.3197> <-3.8851, 17.3564, 5.6466> <-3.8970, 17.2278, 5.8732>
		<-3.3612, 17.2929, 5.0888> <-3.3482, 17.2484, 5.3486> <-3.4461, 17.0942, 5.7147> <-3.4813, 16.9651, 5.9422>
		<-3.1100, 17.0099, 5.0627> <-3.0970, 16.9653, 5.3225> <-3.2183, 16.8283, 5.6457> <-3.2535, 16.6992, 5.8732>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1728, 17.4544, 5.8732> <-4.1818, 17.3565, 6.0457> <-4.1860, 17.2079, 6.3058> <-4.1929, 17.0214, 6.3734>
		<-3.8970, 17.2278, 5.8732> <-3.9060, 17.1299, 6.0457> <-3.9220, 16.9814, 6.3058> <-3.9289, 16.7948, 6.3734>
		<-3.4813, 16.9651, 5.9422> <-3.5079, 16.8677, 6.1140> <-3.5090, 16.7213, 6.3505> <-3.5293, 16.5349, 6.4180>
		<-3.2535, 16.6992, 5.8732> <-3.2801, 16.6018, 6.0450> <-3.2926, 16.4526, 6.3059> <-3.3129, 16.2662, 6.3734>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1929, 17.0214, 6.3734> <-4.2019, 16.7750, 6.4627> <-4.1789, 16.4022, 6.3960> <-4.2209, 16.1481, 6.3467>
		<-3.9289, 16.7948, 6.3734> <-3.9380, 16.5484, 6.4627> <-3.9314, 16.1757, 6.3960> <-3.9734, 15.9215, 6.3467>
		<-3.5293, 16.5349, 6.4180> <-3.5561, 16.2887, 6.5073> <-3.5089, 15.8726, 6.4098> <-3.6227, 15.6395, 6.3647>
		<-3.3129, 16.2662, 6.3734> <-3.3397, 16.0200, 6.4627> <-3.2820, 15.6260, 6.3919> <-3.3958, 15.3929, 6.3467>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2209, 16.1481, 6.3467> <-4.2425, 16.0173, 6.3214> <-4.3212, 15.8712, 6.2147> <-4.3959, 15.7918, 6.1352>
		<-3.9734, 15.9215, 6.3467> <-3.9950, 15.7908, 6.3214> <-4.1763, 15.6447, 6.2147> <-4.2510, 15.5652, 6.1352>
		<-3.6227, 15.6395, 6.3647> <-3.7086, 15.4635, 6.3306> <-3.9023, 15.3190, 6.2765> <-4.0625, 15.2563, 6.1768>
		<-3.3958, 15.3929, 6.3467> <-3.4817, 15.2169, 6.3126> <-3.7529, 15.0993, 6.2349> <-3.9131, 15.0366, 6.1352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3959, 15.7918, 6.1352> <-4.4282, 15.7574, 6.1009> <-4.4902, 15.8286, 6.0269> <-4.5408, 15.8078, 6.0064>
		<-4.2510, 15.5652, 6.1352> <-4.2834, 15.5308, 6.1009> <-4.3983, 15.6056, 5.9725> <-4.4489, 15.5849, 5.9520>
		<-4.0625, 15.2563, 6.1768> <-4.1707, 15.2139, 6.1095> <-4.2134, 15.2972, 5.9735> <-4.3271, 15.2797, 5.9043>
		<-3.9131, 15.0366, 6.1352> <-4.0213, 14.9943, 6.0679> <-4.1207, 15.0821, 5.8943> <-4.2344, 15.0647, 5.8250>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5408, 15.8078, 6.0064> <-4.5851, 15.7896, 5.9883> <-4.6438, 15.7120, 5.9879> <-4.6566, 15.6846, 6.0292>
		<-4.4489, 15.5849, 5.9520> <-4.4932, 15.5667, 5.9339> <-4.5717, 15.4945, 5.9278> <-4.5845, 15.4671, 5.9691>
		<-4.3271, 15.2797, 5.9043> <-4.3805, 15.2716, 5.8717> <-4.4527, 15.1839, 5.8784> <-4.4898, 15.1631, 5.9250>
		<-4.2344, 15.0647, 5.8250> <-4.2878, 15.0565, 5.7925> <-4.3791, 14.9802, 5.7823> <-4.4162, 14.9595, 5.8288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6566, 15.6846, 6.0292> <-4.6793, 15.6360, 6.1023> <-4.6238, 15.5808, 6.2312> <-4.6378, 15.6001, 6.3187>
		<-4.5845, 15.4671, 5.9691> <-4.6072, 15.4185, 6.0421> <-4.6210, 15.3542, 6.2312> <-4.6350, 15.3736, 6.3187>
		<-4.4898, 15.1631, 5.9250> <-4.5863, 15.1093, 6.0459> <-4.5866, 15.0278, 6.2703> <-4.6739, 15.0484, 6.4074>
		<-4.4162, 14.9595, 5.8288> <-4.5127, 14.9057, 5.9497> <-4.5411, 14.8243, 6.1816> <-4.6284, 14.8450, 6.3187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6378, 15.6001, 6.3187> <-4.6676, 15.6414, 6.5052> <-4.7209, 15.7619, 6.7407> <-4.7928, 15.8732, 6.8816>
		<-4.6350, 15.3736, 6.3187> <-4.6648, 15.4148, 6.5052> <-4.8090, 15.5354, 6.7407> <-4.8809, 15.6466, 6.8816>
		<-4.6739, 15.0484, 6.4074> <-4.7978, 15.0777, 6.6021> <-4.9146, 15.2536, 6.8462> <-5.0924, 15.3466, 6.9640>
		<-4.6284, 14.8450, 6.3187> <-4.7523, 14.8743, 6.5133> <-4.9088, 15.0250, 6.7638> <-5.0866, 15.1180, 6.8816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7928, 15.8732, 6.8816> <-4.8177, 15.9117, 6.9304> <-4.8970, 16.0070, 6.9291> <-4.9287, 16.0501, 6.8888>
		<-4.8809, 15.6466, 6.8816> <-4.9058, 15.6851, 6.9304> <-5.0650, 15.7805, 6.9291> <-5.0967, 15.8236, 6.8888>
		<-5.0924, 15.3466, 6.9640> <-5.1930, 15.3993, 7.0307> <-5.3502, 15.5080, 7.0311> <-5.4617, 15.5594, 6.9832>
		<-5.0866, 15.1180, 6.8816> <-5.1873, 15.1707, 6.9483> <-5.3770, 15.2437, 6.9367> <-5.4885, 15.2950, 6.8888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9287, 16.0501, 6.8888> <-5.0006, 16.1480, 6.7976> <-5.0899, 16.2632, 6.6316> <-5.1055, 16.2986, 6.4848>
		<-5.0967, 15.8236, 6.8888> <-5.1686, 15.9214, 6.7976> <-5.3616, 16.0367, 6.6316> <-5.3771, 16.0720, 6.4848>
		<-5.4617, 15.5594, 6.9832> <-5.6409, 15.6418, 6.9063> <-5.8355, 15.8237, 6.7508> <-5.8972, 15.8711, 6.5540>
		<-5.4885, 15.2950, 6.8888> <-5.6677, 15.3774, 6.8119> <-5.9493, 15.4960, 6.6817> <-6.0110, 15.5434, 6.4848>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1055, 16.2986, 6.4848> <-5.1379, 16.3724, 6.1783> <-5.0897, 16.3699, 5.7490> <-5.0829, 16.4004, 5.4337>
		<-5.3771, 16.0720, 6.4848> <-5.4096, 16.1458, 6.1783> <-5.3481, 16.1433, 5.7490> <-5.3413, 16.1739, 5.4337>
		<-5.8972, 15.8711, 6.5540> <-5.9897, 15.9422, 6.2587> <-5.8121, 15.9228, 5.7504> <-5.7921, 15.9534, 5.4351>
		<-6.0110, 15.5434, 6.4848> <-6.1035, 15.6145, 6.1896> <-5.9643, 15.6147, 5.7490> <-5.9443, 15.6453, 5.4337>
	}
texture {suknja}
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4006, 12.2924, 10.9103> <-3.3923, 12.3046, 10.9111> <-3.3847, 12.3229, 10.9096> <-3.3779, 12.3360, 10.9093>
		<-3.4000, 12.2944, 10.9071> <-3.3917, 12.3065, 10.9078> <-3.3874, 12.3202, 10.9092> <-3.3806, 12.3333, 10.9089>
		<-3.4043, 12.2965, 10.9033> <-3.3979, 12.3046, 10.9057> <-3.3889, 12.3201, 10.9066> <-3.3826, 12.3282, 10.9088>
		<-3.4064, 12.2985, 10.9008> <-3.4000, 12.3066, 10.9032> <-3.3917, 12.3175, 10.9058> <-3.3854, 12.3257, 10.9080>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4006, 12.2924, 10.9103> <-3.4000, 12.2944, 10.9071> <-3.4043, 12.2965, 10.9033> <-3.4064, 12.2985, 10.9008>
		<-3.4143, 12.2721, 10.9091> <-3.4138, 12.2741, 10.9058> <-3.4198, 12.2769, 10.8974> <-3.4218, 12.2789, 10.8949>
		<-3.4362, 12.2480, 10.9019> <-3.4358, 12.2505, 10.8952> <-3.4392, 12.2515, 10.8905> <-3.4420, 12.2532, 10.8842>
		<-3.4509, 12.2284, 10.9026> <-3.4505, 12.2309, 10.8959> <-3.4553, 12.2319, 10.8869> <-3.4582, 12.2337, 10.8805>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5068, 12.1509, 10.9153> <-3.4853, 12.1703, 10.9153> <-3.4683, 12.2053, 10.9034> <-3.4509, 12.2284, 10.9026>
		<-3.5073, 12.1539, 10.9028> <-3.4858, 12.1732, 10.9028> <-3.4678, 12.2078, 10.8967> <-3.4505, 12.2309, 10.8959>
		<-3.5103, 12.1633, 10.8880> <-3.4918, 12.1812, 10.8881> <-3.4716, 12.2122, 10.8832> <-3.4553, 12.2319, 10.8869>
		<-3.5139, 12.1683, 10.8767> <-3.4954, 12.1862, 10.8768> <-3.4745, 12.2140, 10.8769> <-3.4582, 12.2337, 10.8805>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5068, 12.1509, 10.9153> <-3.5073, 12.1539, 10.9028> <-3.5103, 12.1633, 10.8880> <-3.5139, 12.1683, 10.8767>
		<-3.5180, 12.1408, 10.9153> <-3.5186, 12.1438, 10.9028> <-3.5211, 12.1529, 10.8879> <-3.5246, 12.1579, 10.8766>
		<-3.5395, 12.1423, 10.9026> <-3.5401, 12.1435, 10.8957> <-3.5401, 12.1436, 10.8860> <-3.5412, 12.1461, 10.8796>
		<-3.5534, 12.1362, 10.9027> <-3.5540, 12.1375, 10.8958> <-3.5538, 12.1376, 10.8862> <-3.5549, 12.1401, 10.8797>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5941, 12.1127, 10.9159> <-3.5796, 12.1143, 10.9157> <-3.5668, 12.1303, 10.9027> <-3.5534, 12.1362, 10.9027>
		<-3.5952, 12.1155, 10.9033> <-3.5806, 12.1171, 10.9031> <-3.5674, 12.1316, 10.8959> <-3.5540, 12.1375, 10.8958>
		<-3.5956, 12.1259, 10.8887> <-3.5831, 12.1266, 10.8885> <-3.5653, 12.1325, 10.8863> <-3.5538, 12.1376, 10.8862>
		<-3.5958, 12.1323, 10.8774> <-3.5833, 12.1331, 10.8772> <-3.5663, 12.1351, 10.8798> <-3.5549, 12.1401, 10.8797>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5941, 12.1127, 10.9159> <-3.5952, 12.1155, 10.9033> <-3.5956, 12.1259, 10.8887> <-3.5958, 12.1323, 10.8774>
		<-3.6257, 12.1091, 10.9162> <-3.6268, 12.1119, 10.9035> <-3.6242, 12.1242, 10.8891> <-3.6244, 12.1306, 10.8779>
		<-3.6678, 12.1157, 10.9073> <-3.6700, 12.1173, 10.8998> <-3.6636, 12.1263, 10.8872> <-3.6626, 12.1300, 10.8803>
		<-3.6992, 12.1199, 10.9040> <-3.7013, 12.1215, 10.8965> <-3.6921, 12.1282, 10.8888> <-3.6912, 12.1319, 10.8818>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.6992, 12.1199, 10.9040> <-3.7013, 12.1215, 10.8965> <-3.6921, 12.1282, 10.8888> <-3.6912, 12.1319, 10.8818>
		<-3.7216, 12.1229, 10.9016> <-3.7237, 12.1245, 10.8941> <-3.7175, 12.1299, 10.8902> <-3.7166, 12.1336, 10.8833>
		<-3.7504, 12.1325, 10.8957> <-3.7520, 12.1335, 10.8924> <-3.7495, 12.1389, 10.8864> <-3.7500, 12.1416, 10.8839>
		<-3.7727, 12.1366, 10.8970> <-3.7743, 12.1375, 10.8937> <-3.7746, 12.1415, 10.8899> <-3.7751, 12.1441, 10.8873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7727, 12.1366, 10.8970> <-3.7743, 12.1375, 10.8937> <-3.7746, 12.1415, 10.8899> <-3.7751, 12.1441, 10.8873>
		<-3.7878, 12.1394, 10.8978> <-3.7895, 12.1403, 10.8946> <-3.7860, 12.1426, 10.8915> <-3.7866, 12.1453, 10.8889>
		<-3.8071, 12.1405, 10.9069> <-3.8024, 12.1409, 10.9058> <-3.8047, 12.1434, 10.8981> <-3.8010, 12.1443, 10.8952>
		<-3.8218, 12.1422, 10.9111> <-3.8171, 12.1426, 10.9100> <-3.8158, 12.1434, 10.9015> <-3.8121, 12.1443, 10.8986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5239, 12.1752, 10.8608> <-3.5225, 12.1709, 10.8648> <-3.5155, 12.1706, 10.8714> <-3.5139, 12.1683, 10.8767>
		<-3.5045, 12.1920, 10.8635> <-3.5030, 12.1878, 10.8674> <-3.4970, 12.1886, 10.8716> <-3.4954, 12.1862, 10.8768>
		<-3.4816, 12.2180, 10.8667> <-3.4800, 12.2158, 10.8685> <-3.4758, 12.2148, 10.8740> <-3.4745, 12.2140, 10.8769>
		<-3.4647, 12.2367, 10.8723> <-3.4631, 12.2346, 10.8742> <-3.4595, 12.2345, 10.8777> <-3.4582, 12.2337, 10.8805>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5239, 12.1752, 10.8608> <-3.5045, 12.1920, 10.8635> <-3.4816, 12.2180, 10.8667> <-3.4647, 12.2367, 10.8723>
		<-3.5252, 12.1793, 10.8570> <-3.5058, 12.1961, 10.8597> <-3.4835, 12.2208, 10.8643> <-3.4667, 12.2395, 10.8700>
		<-3.5226, 12.1876, 10.8559> <-3.5048, 12.2026, 10.8591> <-3.4837, 12.2292, 10.8626> <-3.4678, 12.2453, 10.8690>
		<-3.5221, 12.1929, 10.8538> <-3.5043, 12.2079, 10.8570> <-3.4851, 12.2329, 10.8612> <-3.4691, 12.2490, 10.8676>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5239, 12.1752, 10.8608> <-3.5252, 12.1793, 10.8570> <-3.5226, 12.1876, 10.8559> <-3.5221, 12.1929, 10.8538>
		<-3.5335, 12.1668, 10.8595> <-3.5349, 12.1709, 10.8557> <-3.5342, 12.1778, 10.8538> <-3.5337, 12.1832, 10.8518>
		<-3.5489, 12.1586, 10.8591> <-3.5503, 12.1620, 10.8554> <-3.5505, 12.1694, 10.8529> <-3.5521, 12.1736, 10.8503>
		<-3.5606, 12.1535, 10.8591> <-3.5620, 12.1569, 10.8555> <-3.5645, 12.1633, 10.8530> <-3.5661, 12.1674, 10.8503>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5239, 12.1752, 10.8608> <-3.5335, 12.1668, 10.8595> <-3.5489, 12.1586, 10.8591> <-3.5606, 12.1535, 10.8591>
		<-3.5225, 12.1709, 10.8648> <-3.5321, 12.1626, 10.8634> <-3.5468, 12.1537, 10.8644> <-3.5586, 12.1485, 10.8645>
		<-3.5155, 12.1706, 10.8714> <-3.5263, 12.1602, 10.8713> <-3.5423, 12.1489, 10.8727> <-3.5560, 12.1429, 10.8728>
		<-3.5139, 12.1683, 10.8767> <-3.5246, 12.1579, 10.8766> <-3.5412, 12.1461, 10.8796> <-3.5549, 12.1401, 10.8797>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5606, 12.1535, 10.8591> <-3.5620, 12.1569, 10.8555> <-3.5645, 12.1633, 10.8530> <-3.5661, 12.1674, 10.8503>
		<-3.5705, 12.1492, 10.8592> <-3.5719, 12.1526, 10.8555> <-3.5793, 12.1568, 10.8531> <-3.5810, 12.1609, 10.8504>
		<-3.5845, 12.1454, 10.8600> <-3.5888, 12.1492, 10.8554> <-3.5949, 12.1514, 10.8542> <-3.6017, 12.1536, 10.8522>
		<-3.5951, 12.1440, 10.8612> <-3.5994, 12.1478, 10.8566> <-3.6108, 12.1490, 10.8564> <-3.6176, 12.1512, 10.8543>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5606, 12.1535, 10.8591> <-3.5705, 12.1492, 10.8592> <-3.5845, 12.1454, 10.8600> <-3.5951, 12.1440, 10.8612>
		<-3.5586, 12.1485, 10.8645> <-3.5684, 12.1442, 10.8645> <-3.5810, 12.1423, 10.8638> <-3.5915, 12.1410, 10.8649>
		<-3.5560, 12.1429, 10.8728> <-3.5675, 12.1378, 10.8729> <-3.5834, 12.1361, 10.8720> <-3.5959, 12.1353, 10.8722>
		<-3.5549, 12.1401, 10.8797> <-3.5663, 12.1351, 10.8798> <-3.5833, 12.1331, 10.8772> <-3.5958, 12.1323, 10.8774>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5951, 12.1440, 10.8612> <-3.5994, 12.1478, 10.8566> <-3.6108, 12.1490, 10.8564> <-3.6176, 12.1512, 10.8543>
		<-3.6250, 12.1402, 10.8644> <-3.6293, 12.1439, 10.8598> <-3.6361, 12.1452, 10.8598> <-3.6429, 12.1474, 10.8578>
		<-3.6650, 12.1352, 10.8696> <-3.6671, 12.1380, 10.8672> <-3.6748, 12.1435, 10.8655> <-3.6770, 12.1468, 10.8641>
		<-3.6951, 12.1360, 10.8736> <-3.6971, 12.1388, 10.8712> <-3.7002, 12.1437, 10.8703> <-3.7024, 12.1470, 10.8689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5951, 12.1440, 10.8612> <-3.6250, 12.1402, 10.8644> <-3.6650, 12.1352, 10.8696> <-3.6951, 12.1360, 10.8736>
		<-3.5915, 12.1410, 10.8649> <-3.6214, 12.1371, 10.8682> <-3.6635, 12.1332, 10.8713> <-3.6936, 12.1340, 10.8753>
		<-3.5959, 12.1353, 10.8722> <-3.6245, 12.1336, 10.8727> <-3.6623, 12.1314, 10.8776> <-3.6908, 12.1333, 10.8792>
		<-3.5958, 12.1323, 10.8774> <-3.6244, 12.1306, 10.8779> <-3.6626, 12.1300, 10.8803> <-3.6912, 12.1319, 10.8818>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7751, 12.1489, 10.8853> <-3.7511, 12.1461, 10.8807> <-3.7194, 12.1367, 10.8768> <-3.6951, 12.1360, 10.8736>
		<-3.7753, 12.1499, 10.8849> <-3.7513, 12.1471, 10.8803> <-3.7215, 12.1394, 10.8745> <-3.6971, 12.1388, 10.8712>
		<-3.7760, 12.1512, 10.8847> <-3.7539, 12.1510, 10.8791> <-3.7225, 12.1439, 10.8745> <-3.7002, 12.1437, 10.8703>
		<-3.7763, 12.1523, 10.8844> <-3.7543, 12.1520, 10.8788> <-3.7247, 12.1471, 10.8731> <-3.7024, 12.1470, 10.8689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7751, 12.1489, 10.8853> <-3.7749, 12.1474, 10.8858> <-3.7754, 12.1453, 10.8863> <-3.7751, 12.1441, 10.8873>
		<-3.7511, 12.1461, 10.8807> <-3.7509, 12.1447, 10.8812> <-3.7502, 12.1427, 10.8828> <-3.7500, 12.1416, 10.8839>
		<-3.7194, 12.1367, 10.8768> <-3.7179, 12.1347, 10.8785> <-3.7162, 12.1350, 10.8806> <-3.7166, 12.1336, 10.8833>
		<-3.6951, 12.1360, 10.8736> <-3.6936, 12.1340, 10.8753> <-3.6908, 12.1333, 10.8792> <-3.6912, 12.1319, 10.8818>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7751, 12.1489, 10.8853> <-3.7823, 12.1497, 10.8866> <-3.7913, 12.1482, 10.8908> <-3.7983, 12.1479, 10.8931>
		<-3.7749, 12.1474, 10.8858> <-3.7821, 12.1483, 10.8871> <-3.7955, 12.1473, 10.8924> <-3.8025, 12.1470, 10.8948>
		<-3.7754, 12.1453, 10.8863> <-3.7868, 12.1464, 10.8879> <-3.7974, 12.1451, 10.8925> <-3.8085, 12.1452, 10.8959>
		<-3.7751, 12.1441, 10.8873> <-3.7866, 12.1453, 10.8889> <-3.8010, 12.1443, 10.8952> <-3.8121, 12.1443, 10.8986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7751, 12.1489, 10.8853> <-3.7753, 12.1499, 10.8849> <-3.7760, 12.1512, 10.8847> <-3.7763, 12.1523, 10.8844>
		<-3.7751, 12.1489, 10.8853> <-3.7824, 12.1507, 10.8862> <-3.7829, 12.1513, 10.8864> <-3.7833, 12.1523, 10.8862>
		<-3.7751, 12.1489, 10.8853> <-3.7824, 12.1507, 10.8862> <-3.7848, 12.1497, 10.8882> <-3.7917, 12.1494, 10.8905>
		<-3.7751, 12.1489, 10.8853> <-3.7823, 12.1497, 10.8866> <-3.7913, 12.1482, 10.8908> <-3.7983, 12.1479, 10.8931>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7126, 12.1422, 10.8579> <-3.7347, 12.1435, 10.8663> <-3.7639, 12.1488, 10.8771> <-3.7857, 12.1503, 10.8860>
		<-3.7184, 12.1407, 10.8511> <-3.7405, 12.1419, 10.8595> <-3.7665, 12.1478, 10.8766> <-3.7883, 12.1493, 10.8856>
		<-3.7279, 12.1357, 10.8420> <-3.7482, 12.1361, 10.8534> <-3.7732, 12.1443, 10.8695> <-3.7914, 12.1454, 10.8840>
		<-3.7315, 12.1392, 10.8344> <-3.7519, 12.1396, 10.8458> <-3.7747, 12.1448, 10.8671> <-3.7930, 12.1460, 10.8816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7126, 12.1422, 10.8579> <-3.7096, 12.1430, 10.8615> <-3.7054, 12.1456, 10.8656> <-3.7024, 12.1470, 10.8689>
		<-3.7347, 12.1435, 10.8663> <-3.7317, 12.1443, 10.8699> <-3.7278, 12.1457, 10.8698> <-3.7247, 12.1471, 10.8731>
		<-3.7639, 12.1488, 10.8771> <-3.7612, 12.1498, 10.8775> <-3.7571, 12.1515, 10.8793> <-3.7543, 12.1520, 10.8788>
		<-3.7857, 12.1503, 10.8860> <-3.7830, 12.1513, 10.8865> <-3.7791, 12.1517, 10.8849> <-3.7763, 12.1523, 10.8844>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7126, 12.1422, 10.8579> <-3.7184, 12.1407, 10.8511> <-3.7279, 12.1357, 10.8420> <-3.7315, 12.1392, 10.8344>
		<-3.6904, 12.1409, 10.8495> <-3.6962, 12.1394, 10.8426> <-3.7053, 12.1352, 10.8294> <-3.7090, 12.1387, 10.8218>
		<-3.6612, 12.1387, 10.8359> <-3.6662, 12.1375, 10.8284> <-3.6726, 12.1345, 10.8166> <-3.6762, 12.1389, 10.8095>
		<-3.6383, 12.1418, 10.8300> <-3.6433, 12.1406, 10.8225> <-3.6480, 12.1386, 10.8098> <-3.6516, 12.1430, 10.8027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7126, 12.1422, 10.8579> <-3.7096, 12.1430, 10.8615> <-3.7054, 12.1456, 10.8656> <-3.7024, 12.1470, 10.8689>
		<-3.6904, 12.1409, 10.8495> <-3.6874, 12.1417, 10.8530> <-3.6801, 12.1454, 10.8608> <-3.6770, 12.1468, 10.8641>
		<-3.6612, 12.1387, 10.8359> <-3.6557, 12.1400, 10.8442> <-3.6491, 12.1446, 10.8505> <-3.6429, 12.1474, 10.8578>
		<-3.6383, 12.1418, 10.8300> <-3.6329, 12.1431, 10.8383> <-3.6238, 12.1484, 10.8470> <-3.6176, 12.1512, 10.8543>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4618, 12.2519, 10.8566> <-3.4748, 12.2373, 10.8473> <-3.4886, 12.2142, 10.8350> <-3.5043, 12.2004, 10.8293>
		<-3.4637, 12.2506, 10.8599> <-3.4767, 12.2360, 10.8507> <-3.4925, 12.2114, 10.8430> <-3.5082, 12.1977, 10.8374>
		<-3.4669, 12.2498, 10.8643> <-3.4829, 12.2338, 10.8579> <-3.4989, 12.2101, 10.8496> <-3.5168, 12.1952, 10.8465>
		<-3.4691, 12.2490, 10.8676> <-3.4851, 12.2329, 10.8612> <-3.5043, 12.2079, 10.8570> <-3.5221, 12.1929, 10.8538>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4618, 12.2519, 10.8566> <-3.4579, 12.2546, 10.8495> <-3.4493, 12.2578, 10.8400> <-3.4499, 12.2624, 10.8328>
		<-3.4748, 12.2373, 10.8473> <-3.4709, 12.2400, 10.8402> <-3.4627, 12.2439, 10.8275> <-3.4634, 12.2485, 10.8203>
		<-3.4886, 12.2142, 10.8350> <-3.4849, 12.2168, 10.8272> <-3.4788, 12.2192, 10.8154> <-3.4802, 12.2245, 10.8083>
		<-3.5043, 12.2004, 10.8293> <-3.5006, 12.2030, 10.8215> <-3.4959, 12.2051, 10.8090> <-3.4973, 12.2105, 10.8018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4618, 12.2519, 10.8566> <-3.4457, 12.2700, 10.8680> <-3.4239, 12.2923, 10.8859> <-3.4073, 12.3093, 10.8983>
		<-3.4579, 12.2546, 10.8495> <-3.4417, 12.2727, 10.8609> <-3.4215, 12.2937, 10.8849> <-3.4049, 12.3108, 10.8973>
		<-3.4493, 12.2578, 10.8400> <-3.4330, 12.2747, 10.8552> <-3.4147, 12.2956, 10.8779> <-3.3994, 12.3107, 10.8958>
		<-3.4499, 12.2624, 10.8328> <-3.4336, 12.2793, 10.8480> <-3.4146, 12.2970, 10.8753> <-3.3993, 12.3120, 10.8931>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4618, 12.2519, 10.8566> <-3.4637, 12.2506, 10.8599> <-3.4669, 12.2498, 10.8643> <-3.4691, 12.2490, 10.8676>
		<-3.4457, 12.2700, 10.8680> <-3.4475, 12.2687, 10.8714> <-3.4495, 12.2675, 10.8713> <-3.4517, 12.2666, 10.8746>
		<-3.4239, 12.2923, 10.8859> <-3.4254, 12.2914, 10.8865> <-3.4275, 12.2894, 10.8893> <-3.4287, 12.2881, 10.8892>
		<-3.4073, 12.3093, 10.8983> <-3.4088, 12.3085, 10.8989> <-3.4101, 12.3062, 10.8982> <-3.4113, 12.3048, 10.8982>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.8121, 12.1443, 10.8986> <-3.8085, 12.1452, 10.8959> <-3.8025, 12.1470, 10.8948> <-3.7983, 12.1479, 10.8931>
		<-3.8064, 12.1448, 10.8935> <-3.8028, 12.1457, 10.8908> <-3.7987, 12.1477, 10.8926> <-3.7945, 12.1486, 10.8910>
		<-3.7990, 12.1464, 10.8864> <-3.7974, 12.1458, 10.8888> <-3.7924, 12.1496, 10.8872> <-3.7897, 12.1506, 10.8877>
		<-3.7930, 12.1460, 10.8816> <-3.7914, 12.1454, 10.8840> <-3.7883, 12.1493, 10.8856> <-3.7857, 12.1503, 10.8860>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.3854, 12.3257, 10.9080> <-3.3896, 12.3216, 10.9036> <-3.3953, 12.3160, 10.8979> <-3.3993, 12.3120, 10.8931>
		<-3.3889, 12.3224, 10.9071> <-3.3930, 12.3183, 10.9026> <-3.3953, 12.3146, 10.9005> <-3.3994, 12.3107, 10.8958>
		<-3.3947, 12.3199, 10.9052> <-3.3974, 12.3176, 10.9036> <-3.4025, 12.3133, 10.8991> <-3.4049, 12.3108, 10.8973>
		<-3.3983, 12.3170, 10.9039> <-3.4010, 12.3147, 10.9022> <-3.4049, 12.3118, 10.9001> <-3.4073, 12.3093, 10.8983>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.3854, 12.3257, 10.9080> <-3.3889, 12.3224, 10.9071> <-3.3947, 12.3199, 10.9052> <-3.3983, 12.3170, 10.9039>
		<-3.3917, 12.3175, 10.9058> <-3.3951, 12.3143, 10.9049> <-3.3982, 12.3153, 10.9038> <-3.4018, 12.3124, 10.9024>
		<-3.4000, 12.3066, 10.9032> <-3.4008, 12.3074, 10.9021> <-3.4055, 12.3048, 10.9011> <-3.4063, 12.3060, 10.9006>
		<-3.4064, 12.2985, 10.9008> <-3.4072, 12.2993, 10.8997> <-3.4091, 12.3004, 10.8994> <-3.4100, 12.3015, 10.8989>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4582, 12.2337, 10.8805> <-3.4420, 12.2532, 10.8842> <-3.4218, 12.2789, 10.8949> <-3.4064, 12.2985, 10.9008>
		<-3.4595, 12.2345, 10.8777> <-3.4434, 12.2540, 10.8813> <-3.4227, 12.2797, 10.8939> <-3.4072, 12.2993, 10.8997>
		<-3.4631, 12.2346, 10.8742> <-3.4457, 12.2539, 10.8800> <-3.4254, 12.2807, 10.8916> <-3.4091, 12.3004, 10.8994>
		<-3.4647, 12.2367, 10.8723> <-3.4473, 12.2561, 10.8781> <-3.4263, 12.2819, 10.8912> <-3.4100, 12.3015, 10.8989>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.6516, 12.1430, 10.8027> <-3.6262, 12.1472, 10.7956> <-3.5913, 12.1560, 10.7889> <-3.5667, 12.1667, 10.7888>
		<-3.6480, 12.1386, 10.8098> <-3.6225, 12.1429, 10.8028> <-3.5890, 12.1511, 10.7966> <-3.5645, 12.1618, 10.7965>
		<-3.6433, 12.1406, 10.8225> <-3.6209, 12.1436, 10.8167> <-3.5855, 12.1527, 10.8104> <-3.5642, 12.1621, 10.8103>
		<-3.6383, 12.1418, 10.8300> <-3.6160, 12.1448, 10.8243> <-3.5854, 12.1528, 10.8198> <-3.5641, 12.1622, 10.8197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4973, 12.2105, 10.8018> <-3.4959, 12.2051, 10.8090> <-3.5006, 12.2030, 10.8215> <-3.5043, 12.2004, 10.8293>
		<-3.5158, 12.1953, 10.7948> <-3.5144, 12.1900, 10.8020> <-3.5162, 12.1894, 10.8159> <-3.5199, 12.1867, 10.8237>
		<-3.5439, 12.1767, 10.7886> <-3.5417, 12.1718, 10.7963> <-3.5445, 12.1707, 10.8102> <-3.5444, 12.1708, 10.8196>
		<-3.5667, 12.1667, 10.7888> <-3.5645, 12.1618, 10.7965> <-3.5642, 12.1621, 10.8103> <-3.5641, 12.1622, 10.8197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.7983, 12.1479, 10.8931> <-3.7945, 12.1486, 10.8910> <-3.7897, 12.1506, 10.8877> <-3.7857, 12.1503, 10.8860>
		<-3.7983, 12.1479, 10.8931> <-3.7879, 12.1501, 10.8884> <-3.7871, 12.1516, 10.8881> <-3.7830, 12.1513, 10.8865>
		<-3.7983, 12.1479, 10.8931> <-3.7879, 12.1501, 10.8884> <-3.7861, 12.1517, 10.8866> <-3.7791, 12.1517, 10.8849>
		<-3.7983, 12.1479, 10.8931> <-3.7917, 12.1494, 10.8905> <-3.7833, 12.1523, 10.8862> <-3.7763, 12.1523, 10.8844>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.3983, 12.3170, 10.9039> <-3.4010, 12.3147, 10.9022> <-3.4049, 12.3118, 10.9001> <-3.4073, 12.3093, 10.8983>
		<-3.3983, 12.3170, 10.9039> <-3.4052, 12.3114, 10.9006> <-3.4063, 12.3110, 10.9007> <-3.4088, 12.3085, 10.8989>
		<-3.3983, 12.3170, 10.9039> <-3.4052, 12.3114, 10.9006> <-3.4063, 12.3098, 10.9001> <-3.4101, 12.3062, 10.8982>
		<-3.3983, 12.3170, 10.9039> <-3.4025, 12.3137, 10.9023> <-3.4075, 12.3085, 10.9001> <-3.4113, 12.3048, 10.8982>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.3983, 12.3170, 10.9039> <-3.4025, 12.3137, 10.9023> <-3.4075, 12.3085, 10.9001> <-3.4113, 12.3048, 10.8982>
		<-3.3983, 12.3170, 10.9039> <-3.4060, 12.3090, 10.9008> <-3.4071, 12.3075, 10.9003> <-3.4109, 12.3038, 10.8984>
		<-3.3983, 12.3170, 10.9039> <-3.4060, 12.3090, 10.9008> <-3.4070, 12.3068, 10.9003> <-3.4106, 12.3023, 10.8986>
		<-3.3983, 12.3170, 10.9039> <-3.4018, 12.3124, 10.9024> <-3.4063, 12.3060, 10.9006> <-3.4100, 12.3015, 10.8989>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.6383, 12.1418, 10.8300> <-3.6329, 12.1431, 10.8383> <-3.6238, 12.1484, 10.8470> <-3.6176, 12.1512, 10.8543>
		<-3.6160, 12.1448, 10.8243> <-3.6105, 12.1461, 10.8325> <-3.6079, 12.1508, 10.8449> <-3.6017, 12.1536, 10.8522>
		<-3.5854, 12.1528, 10.8198> <-3.5853, 12.1530, 10.8291> <-3.5804, 12.1594, 10.8412> <-3.5810, 12.1609, 10.8504>
		<-3.5641, 12.1622, 10.8197> <-3.5640, 12.1623, 10.8290> <-3.5655, 12.1659, 10.8411> <-3.5661, 12.1674, 10.8503>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.5043, 12.2004, 10.8293> <-3.5082, 12.1977, 10.8374> <-3.5168, 12.1952, 10.8465> <-3.5221, 12.1929, 10.8538>
		<-3.5199, 12.1867, 10.8237> <-3.5238, 12.1840, 10.8318> <-3.5284, 12.1854, 10.8444> <-3.5337, 12.1832, 10.8518>
		<-3.5444, 12.1708, 10.8196> <-3.5443, 12.1709, 10.8289> <-3.5515, 12.1720, 10.8411> <-3.5521, 12.1736, 10.8503>
		<-3.5641, 12.1622, 10.8197> <-3.5640, 12.1623, 10.8290> <-3.5655, 12.1659, 10.8411> <-3.5661, 12.1674, 10.8503>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 2
		v_steps 2
		<-3.4647, 12.2367, 10.8723> <-3.4473, 12.2561, 10.8781> <-3.4263, 12.2819, 10.8912> <-3.4100, 12.3015, 10.8989>
		<-3.4667, 12.2395, 10.8700> <-3.4492, 12.2588, 10.8758> <-3.4269, 12.2827, 10.8908> <-3.4106, 12.3023, 10.8986>
		<-3.4678, 12.2453, 10.8690> <-3.4503, 12.2630, 10.8760> <-3.4283, 12.2871, 10.8894> <-3.4109, 12.3038, 10.8984>
		<-3.4691, 12.2490, 10.8676> <-3.4517, 12.2666, 10.8746> <-3.4287, 12.2881, 10.8892> <-3.4113, 12.3048, 10.8982>
	}
texture {lips}
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3595, 12.2196, 11.5355> <-3.3470, 12.1909, 11.5227> <-3.3041, 12.1988, 11.5184> <-3.2731, 12.2123, 11.5182>
		<-3.3595, 12.2196, 11.5355> <-3.3534, 12.2052, 11.4846> <-3.3093, 12.2104, 11.4871> <-3.2784, 12.2239, 11.4870>
		<-3.3595, 12.2196, 11.5355> <-3.3534, 12.2052, 11.4846> <-3.3268, 12.2313, 11.4519> <-3.2890, 12.2478, 11.4517>
		<-3.3595, 12.2196, 11.5355> <-3.3659, 12.2338, 11.4973> <-3.3392, 12.2599, 11.4647> <-3.3015, 12.2765, 11.4645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3595, 12.2196, 11.5355> <-3.3530, 12.2054, 11.5736> <-3.3155, 12.2073, 11.6059> <-3.2777, 12.2238, 11.6057>
		<-3.3595, 12.2196, 11.5355> <-3.3406, 12.1767, 11.5608> <-3.3030, 12.1787, 11.5931> <-3.2652, 12.1952, 11.5929>
		<-3.3595, 12.2196, 11.5355> <-3.3406, 12.1767, 11.5608> <-3.2988, 12.1871, 11.5496> <-3.2679, 12.2006, 11.5494>
		<-3.3595, 12.2196, 11.5355> <-3.3470, 12.1909, 11.5227> <-3.3041, 12.1988, 11.5184> <-3.2731, 12.2123, 11.5182>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3595, 12.2196, 11.5355> <-3.3719, 12.2482, 11.5483> <-3.3370, 12.2745, 11.5521> <-3.3061, 12.2880, 11.5520>
		<-3.3595, 12.2196, 11.5355> <-3.3655, 12.2340, 11.5864> <-3.3317, 12.2628, 11.5834> <-3.3008, 12.2764, 11.5832>
		<-3.3595, 12.2196, 11.5355> <-3.3655, 12.2340, 11.5864> <-3.3279, 12.2360, 11.6187> <-3.2902, 12.2525, 11.6185>
		<-3.3595, 12.2196, 11.5355> <-3.3530, 12.2054, 11.5736> <-3.3155, 12.2073, 11.6059> <-3.2777, 12.2238, 11.6057>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3595, 12.2196, 11.5355> <-3.3659, 12.2338, 11.4973> <-3.3392, 12.2599, 11.4647> <-3.3015, 12.2765, 11.4645>
		<-3.3595, 12.2196, 11.5355> <-3.3783, 12.2625, 11.5101> <-3.3517, 12.2886, 11.4775> <-3.3139, 12.3051, 11.4773>
		<-3.3595, 12.2196, 11.5355> <-3.3783, 12.2625, 11.5101> <-3.3422, 12.2861, 11.5209> <-3.3113, 12.2996, 11.5207>
		<-3.3595, 12.2196, 11.5355> <-3.3719, 12.2482, 11.5483> <-3.3370, 12.2745, 11.5521> <-3.3061, 12.2880, 11.5520>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2197, 12.2807, 11.5347> <-3.2133, 12.2665, 11.5728> <-3.2400, 12.2403, 11.6055> <-3.2777, 12.2238, 11.6057>
		<-3.2197, 12.2807, 11.5347> <-3.2258, 12.2951, 11.5856> <-3.2524, 12.2690, 11.6182> <-3.2902, 12.2525, 11.6185>
		<-3.2197, 12.2807, 11.5347> <-3.2258, 12.2951, 11.5856> <-3.2699, 12.2899, 11.5830> <-3.3008, 12.2764, 11.5832>
		<-3.2197, 12.2807, 11.5347> <-3.2322, 12.3093, 11.5475> <-3.2751, 12.3015, 11.5518> <-3.3061, 12.2880, 11.5520>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2197, 12.2807, 11.5347> <-3.2322, 12.3093, 11.5475> <-3.2751, 12.3015, 11.5518> <-3.3061, 12.2880, 11.5520>
		<-3.2197, 12.2807, 11.5347> <-3.2386, 12.3236, 11.5094> <-3.2804, 12.3132, 11.5206> <-3.3113, 12.2996, 11.5207>
		<-3.2197, 12.2807, 11.5347> <-3.2386, 12.3236, 11.5094> <-3.2762, 12.3216, 11.4771> <-3.3139, 12.3051, 11.4773>
		<-3.2197, 12.2807, 11.5347> <-3.2261, 12.2949, 11.4966> <-3.2637, 12.2930, 11.4643> <-3.3015, 12.2765, 11.4645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2197, 12.2807, 11.5347> <-3.2261, 12.2949, 11.4966> <-3.2637, 12.2930, 11.4643> <-3.3015, 12.2765, 11.4645>
		<-3.2197, 12.2807, 11.5347> <-3.2137, 12.2663, 11.4838> <-3.2513, 12.2643, 11.4515> <-3.2890, 12.2478, 11.4517>
		<-3.2197, 12.2807, 11.5347> <-3.2137, 12.2663, 11.4838> <-3.2475, 12.2374, 11.4868> <-3.2784, 12.2239, 11.4870>
		<-3.2197, 12.2807, 11.5347> <-3.2073, 12.2520, 11.5219> <-3.2422, 12.2258, 11.5180> <-3.2731, 12.2123, 11.5182>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2197, 12.2807, 11.5347> <-3.2073, 12.2520, 11.5219> <-3.2422, 12.2258, 11.5180> <-3.2731, 12.2123, 11.5182>
		<-3.2197, 12.2807, 11.5347> <-3.2008, 12.2378, 11.5601> <-3.2369, 12.2142, 11.5493> <-3.2679, 12.2006, 11.5494>
		<-3.2197, 12.2807, 11.5347> <-3.2008, 12.2378, 11.5601> <-3.2275, 12.2117, 11.5927> <-3.2652, 12.1952, 11.5929>
		<-3.2197, 12.2807, 11.5347> <-3.2133, 12.2665, 11.5728> <-3.2400, 12.2403, 11.6055> <-3.2777, 12.2238, 11.6057>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8842, 11.9901, 11.5383> <-3.8718, 11.9615, 11.5256> <-3.8288, 11.9693, 11.5212> <-3.7979, 11.9828, 11.5211>
		<-3.8842, 11.9901, 11.5383> <-3.8782, 11.9757, 11.4874> <-3.8341, 11.9810, 11.4900> <-3.8032, 11.9945, 11.4898>
		<-3.8842, 11.9901, 11.5383> <-3.8782, 11.9757, 11.4874> <-3.8515, 12.0019, 11.4548> <-3.8138, 12.0184, 11.4546>
		<-3.8842, 11.9901, 11.5383> <-3.8906, 12.0044, 11.5002> <-3.8640, 12.0305, 11.4676> <-3.8262, 12.0470, 11.4674>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8842, 11.9901, 11.5383> <-3.8778, 11.9759, 11.5765> <-3.8402, 11.9779, 11.6087> <-3.8025, 11.9944, 11.6085>
		<-3.8842, 11.9901, 11.5383> <-3.8653, 11.9473, 11.5637> <-3.8278, 11.9492, 11.5960> <-3.7900, 11.9657, 11.5958>
		<-3.8842, 11.9901, 11.5383> <-3.8653, 11.9473, 11.5637> <-3.8235, 11.9577, 11.5525> <-3.7926, 11.9712, 11.5523>
		<-3.8842, 11.9901, 11.5383> <-3.8718, 11.9615, 11.5256> <-3.8288, 11.9693, 11.5212> <-3.7979, 11.9828, 11.5211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8842, 11.9901, 11.5383> <-3.8967, 12.0188, 11.5511> <-3.8617, 12.0450, 11.5550> <-3.8308, 12.0586, 11.5548>
		<-3.8842, 11.9901, 11.5383> <-3.8903, 12.0046, 11.5893> <-3.8565, 12.0334, 11.5863> <-3.8256, 12.0469, 11.5861>
		<-3.8842, 11.9901, 11.5383> <-3.8903, 12.0046, 11.5893> <-3.8527, 12.0065, 11.6215> <-3.8149, 12.0230, 11.6213>
		<-3.8842, 11.9901, 11.5383> <-3.8778, 11.9759, 11.5765> <-3.8402, 11.9779, 11.6087> <-3.8025, 11.9944, 11.6085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8842, 11.9901, 11.5383> <-3.8906, 12.0044, 11.5002> <-3.8640, 12.0305, 11.4676> <-3.8262, 12.0470, 11.4674>
		<-3.8842, 11.9901, 11.5383> <-3.9031, 12.0330, 11.5130> <-3.8764, 12.0592, 11.4804> <-3.8387, 12.0757, 11.4802>
		<-3.8842, 11.9901, 11.5383> <-3.9031, 12.0330, 11.5130> <-3.8670, 12.0567, 11.5238> <-3.8361, 12.0702, 11.5236>
		<-3.8842, 11.9901, 11.5383> <-3.8967, 12.0188, 11.5511> <-3.8617, 12.0450, 11.5550> <-3.8308, 12.0586, 11.5548>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7445, 12.0512, 11.5376> <-3.7381, 12.0370, 11.5757> <-3.7647, 12.0109, 11.6083> <-3.8025, 11.9944, 11.6085>
		<-3.7445, 12.0512, 11.5376> <-3.7505, 12.0657, 11.5885> <-3.7772, 12.0395, 11.6211> <-3.8149, 12.0230, 11.6213>
		<-3.7445, 12.0512, 11.5376> <-3.7505, 12.0657, 11.5885> <-3.7946, 12.0604, 11.5859> <-3.8256, 12.0469, 11.5861>
		<-3.7445, 12.0512, 11.5376> <-3.7569, 12.0799, 11.5504> <-3.7999, 12.0721, 11.5547> <-3.8308, 12.0586, 11.5548>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7445, 12.0512, 11.5376> <-3.7569, 12.0799, 11.5504> <-3.7999, 12.0721, 11.5547> <-3.8308, 12.0586, 11.5548>
		<-3.7445, 12.0512, 11.5376> <-3.7634, 12.0941, 11.5122> <-3.8052, 12.0837, 11.5234> <-3.8361, 12.0702, 11.5236>
		<-3.7445, 12.0512, 11.5376> <-3.7634, 12.0941, 11.5122> <-3.8009, 12.0922, 11.4800> <-3.8387, 12.0757, 11.4802>
		<-3.7445, 12.0512, 11.5376> <-3.7509, 12.0655, 11.4994> <-3.7885, 12.0635, 11.4672> <-3.8262, 12.0470, 11.4674>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7445, 12.0512, 11.5376> <-3.7509, 12.0655, 11.4994> <-3.7885, 12.0635, 11.4672> <-3.8262, 12.0470, 11.4674>
		<-3.7445, 12.0512, 11.5376> <-3.7385, 12.0368, 11.4867> <-3.7760, 12.0349, 11.4544> <-3.8138, 12.0184, 11.4546>
		<-3.7445, 12.0512, 11.5376> <-3.7385, 12.0368, 11.4867> <-3.7722, 12.0080, 11.4897> <-3.8032, 11.9945, 11.4898>
		<-3.7445, 12.0512, 11.5376> <-3.7320, 12.0226, 11.5248> <-3.7670, 11.9964, 11.5209> <-3.7979, 11.9828, 11.5211>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7445, 12.0512, 11.5376> <-3.7320, 12.0226, 11.5248> <-3.7670, 11.9964, 11.5209> <-3.7979, 11.9828, 11.5211>
		<-3.7445, 12.0512, 11.5376> <-3.7256, 12.0084, 11.5629> <-3.7617, 11.9847, 11.5521> <-3.7926, 11.9712, 11.5523>
		<-3.7445, 12.0512, 11.5376> <-3.7256, 12.0084, 11.5629> <-3.7523, 11.9822, 11.5956> <-3.7900, 11.9657, 11.5958>
		<-3.7445, 12.0512, 11.5376> <-3.7381, 12.0370, 11.5757> <-3.7647, 12.0109, 11.6083> <-3.8025, 11.9944, 11.6085>
	}
	texture {zj}
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0732, 12.1376, 11.7050> <-4.0490, 12.0813, 11.7118> <-4.0408, 11.9876, 11.7214> <-3.9924, 11.9499, 11.7277>
		<-4.0732, 12.1229, 11.6977> <-4.0490, 12.0666, 11.7045> <-4.0408, 11.9698, 11.7124> <-3.9924, 11.9320, 11.7188>
		<-4.0732, 12.0927, 11.6964> <-4.0490, 12.0333, 11.7017> <-4.0420, 11.9363, 11.7118> <-3.9924, 11.8955, 11.7173>
		<-4.0732, 12.0885, 11.6805> <-4.0490, 12.0291, 11.6858> <-4.0420, 11.9312, 11.6926> <-3.9924, 11.8904, 11.6980>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9924, 11.9499, 11.7277> <-3.9483, 11.9155, 11.7335> <-3.8627, 11.9273, 11.7414> <-3.8064, 11.9293, 11.7401>
		<-3.9924, 11.9320, 11.7188> <-3.9483, 11.8976, 11.7246> <-3.8627, 11.9090, 11.7323> <-3.8064, 11.9111, 11.7310>
		<-3.9924, 11.8955, 11.7173> <-3.9492, 11.8598, 11.7220> <-3.8627, 11.8719, 11.7308> <-3.8064, 11.8738, 11.7294>
		<-3.9924, 11.8904, 11.6980> <-3.9492, 11.8547, 11.7027> <-3.8627, 11.8667, 11.7111> <-3.8064, 11.8686, 11.7097>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8064, 11.9293, 11.7401> <-3.7680, 11.9308, 11.7392> <-3.7196, 11.9507, 11.7301> <-3.6838, 11.9613, 11.7206>
		<-3.8064, 11.9111, 11.7310> <-3.7680, 11.9125, 11.7301> <-3.7196, 11.9324, 11.7210> <-3.6838, 11.9431, 11.7115>
		<-3.8064, 11.8738, 11.7294> <-3.7680, 11.8750, 11.7284> <-3.7196, 11.8951, 11.7194> <-3.6838, 11.9057, 11.7099>
		<-3.8064, 11.8686, 11.7097> <-3.7680, 11.8698, 11.7087> <-3.7196, 11.8899, 11.6997> <-3.6838, 11.9005, 11.6902>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6838, 11.9613, 11.7206> <-3.6504, 11.9712, 11.7117> <-3.6033, 11.9761, 11.6917> <-3.5773, 11.9975, 11.6791>
		<-3.6838, 11.9431, 11.7115> <-3.6504, 11.9530, 11.7026> <-3.6033, 11.9578, 11.6826> <-3.5773, 11.9793, 11.6700>
		<-3.6838, 11.9057, 11.7099> <-3.6504, 11.9156, 11.7010> <-3.6033, 11.9205, 11.6811> <-3.5773, 11.9419, 11.6685>
		<-3.6838, 11.9005, 11.6902> <-3.6504, 11.9105, 11.6813> <-3.6033, 11.9153, 11.6613> <-3.5773, 11.9367, 11.6487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5773, 11.9975, 11.6791> <-3.5469, 12.0225, 11.6644> <-3.5435, 12.0917, 11.6342> <-3.5050, 12.1085, 11.6340>
		<-3.5773, 11.9793, 11.6700> <-3.5469, 12.0042, 11.6553> <-3.5435, 12.0734, 11.6251> <-3.5050, 12.0903, 11.6249>
		<-3.5773, 11.9419, 11.6685> <-3.5469, 11.9669, 11.6538> <-3.5435, 12.0361, 11.6235> <-3.5050, 12.0529, 11.6233>
		<-3.5773, 11.9367, 11.6487> <-3.5469, 11.9617, 11.6340> <-3.5435, 12.0309, 11.6038> <-3.5050, 12.0477, 11.6036>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5050, 12.1085, 11.6340> <-3.4693, 12.1241, 11.6338> <-3.4218, 12.0772, 11.6637> <-3.3857, 12.0812, 11.6781>
		<-3.5050, 12.0903, 11.6249> <-3.4693, 12.1059, 11.6247> <-3.4218, 12.0590, 11.6546> <-3.3857, 12.0630, 11.6690>
		<-3.5050, 12.0529, 11.6233> <-3.4693, 12.0685, 11.6231> <-3.4218, 12.0216, 11.6530> <-3.3857, 12.0257, 11.6674>
		<-3.5050, 12.0477, 11.6036> <-3.4693, 12.0634, 11.6034> <-3.4218, 12.0164, 11.6333> <-3.3857, 12.0205, 11.6477>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3857, 12.0812, 11.6781> <-3.3543, 12.0848, 11.6906> <-3.3213, 12.1153, 11.7104> <-3.2929, 12.1322, 11.7185>
		<-3.3857, 12.0630, 11.6690> <-3.3543, 12.0665, 11.6815> <-3.3213, 12.0971, 11.7013> <-3.2929, 12.1140, 11.7094>
		<-3.3857, 12.0257, 11.6674> <-3.3543, 12.0292, 11.6799> <-3.3213, 12.0598, 11.6997> <-3.2929, 12.0766, 11.7078>
		<-3.3857, 12.0205, 11.6477> <-3.3543, 12.0240, 11.6602> <-3.3213, 12.0546, 11.6800> <-3.2929, 12.0714, 11.6881>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2929, 12.1322, 11.7185> <-3.2593, 12.1521, 11.7281> <-3.2090, 12.1746, 11.7361> <-3.1806, 12.2030, 11.7367>
		<-3.2929, 12.1140, 11.7094> <-3.2593, 12.1339, 11.7190> <-3.2090, 12.1564, 11.7270> <-3.1806, 12.1848, 11.7275>
		<-3.2929, 12.0766, 11.7078> <-3.2593, 12.0965, 11.7174> <-3.2090, 12.1189, 11.7254> <-3.1806, 12.1474, 11.7260>
		<-3.2929, 12.0714, 11.6881> <-3.2593, 12.0914, 11.6977> <-3.2090, 12.1137, 11.7057> <-3.1806, 12.1422, 11.7063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1806, 12.2030, 11.7367> <-3.1414, 12.2422, 11.7374> <-3.0756, 12.2972, 11.7287> <-3.0725, 12.3523, 11.7226>
		<-3.1806, 12.1848, 11.7275> <-3.1414, 12.2239, 11.7283> <-3.0756, 12.2794, 11.7198> <-3.0725, 12.3344, 11.7137>
		<-3.1806, 12.1474, 11.7260> <-3.1413, 12.1869, 11.7268> <-3.0756, 12.2424, 11.7171> <-3.0725, 12.2979, 11.7122>
		<-3.1806, 12.1422, 11.7063> <-3.1413, 12.1817, 11.7071> <-3.0756, 12.2373, 11.6978> <-3.0725, 12.2928, 11.6929>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0725, 12.3523, 11.7226> <-3.0691, 12.4135, 11.7159> <-3.1350, 12.4810, 11.7068> <-3.1618, 12.5361, 11.7001>
		<-3.0725, 12.3344, 11.7137> <-3.0691, 12.3956, 11.7070> <-3.1350, 12.4662, 11.6995> <-3.1618, 12.5214, 11.6927>
		<-3.0725, 12.2979, 11.7122> <-3.0690, 12.3619, 11.7065> <-3.1350, 12.4330, 11.6967> <-3.1618, 12.4912, 11.6915>
		<-3.0725, 12.2928, 11.6929> <-3.0690, 12.3568, 11.6872> <-3.1350, 12.4288, 11.6807> <-3.1618, 12.4870, 11.6755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0732, 12.1264, 11.6627> <-4.0732, 12.1151, 11.6680> <-4.0732, 12.0853, 11.6684> <-4.0732, 12.0885, 11.6805>
		<-4.0490, 12.0694, 11.6668> <-4.0490, 12.0580, 11.6721> <-4.0490, 12.0259, 11.6736> <-4.0490, 12.0291, 11.6858>
		<-4.0410, 11.9748, 11.6718> <-4.0410, 11.9610, 11.6783> <-4.0420, 11.9273, 11.6778> <-4.0420, 11.9312, 11.6926>
		<-3.9924, 11.9364, 11.6763> <-3.9924, 11.9226, 11.6828> <-3.9924, 11.8865, 11.6832> <-3.9924, 11.8904, 11.6980>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9924, 11.9364, 11.6763> <-3.9924, 11.9226, 11.6828> <-3.9924, 11.8865, 11.6832> <-3.9924, 11.8904, 11.6980>
		<-3.9484, 11.9016, 11.6804> <-3.9484, 11.8878, 11.6869> <-3.9492, 11.8508, 11.6880> <-3.9492, 11.8547, 11.7027>
		<-3.8626, 11.9135, 11.6891> <-3.8626, 11.8994, 11.6957> <-3.8627, 11.8628, 11.6961> <-3.8627, 11.8667, 11.7111>
		<-3.8064, 11.9155, 11.6876> <-3.8064, 11.9014, 11.6942> <-3.8064, 11.8646, 11.6946> <-3.8064, 11.8686, 11.7097>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8064, 11.9155, 11.6876> <-3.8064, 11.9014, 11.6942> <-3.8064, 11.8646, 11.6946> <-3.8064, 11.8686, 11.7097>
		<-3.7680, 11.9169, 11.6866> <-3.7680, 11.9028, 11.6932> <-3.7680, 11.8659, 11.6937> <-3.7680, 11.8698, 11.7087>
		<-3.7196, 11.9369, 11.6776> <-3.7196, 11.9228, 11.6842> <-3.7196, 11.8859, 11.6846> <-3.7196, 11.8899, 11.6997>
		<-3.6838, 11.9475, 11.6681> <-3.6838, 11.9334, 11.6747> <-3.6838, 11.8966, 11.6751> <-3.6838, 11.9005, 11.6902>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6838, 11.9475, 11.6681> <-3.6838, 11.9334, 11.6747> <-3.6838, 11.8966, 11.6751> <-3.6838, 11.9005, 11.6902>
		<-3.6504, 11.9574, 11.6592> <-3.6504, 11.9433, 11.6658> <-3.6504, 11.9065, 11.6663> <-3.6504, 11.9105, 11.6813>
		<-3.6033, 11.9623, 11.6392> <-3.6033, 11.9482, 11.6459> <-3.6033, 11.9113, 11.6463> <-3.6033, 11.9153, 11.6613>
		<-3.5773, 11.9837, 11.6266> <-3.5773, 11.9696, 11.6333> <-3.5773, 11.9328, 11.6337> <-3.5773, 11.9367, 11.6487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5773, 11.9837, 11.6266> <-3.5773, 11.9696, 11.6333> <-3.5773, 11.9328, 11.6337> <-3.5773, 11.9367, 11.6487>
		<-3.5469, 12.0087, 11.6119> <-3.5469, 11.9946, 11.6186> <-3.5469, 11.9577, 11.6190> <-3.5469, 11.9617, 11.6340>
		<-3.5435, 12.0779, 11.5817> <-3.5435, 12.0638, 11.5884> <-3.5435, 12.0269, 11.5888> <-3.5435, 12.0309, 11.6038>
		<-3.5050, 12.0947, 11.5815> <-3.5050, 12.0806, 11.5881> <-3.5050, 12.0438, 11.5886> <-3.5050, 12.0477, 11.6036>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5050, 12.0947, 11.5815> <-3.5050, 12.0806, 11.5881> <-3.5050, 12.0438, 11.5886> <-3.5050, 12.0477, 11.6036>
		<-3.4693, 12.1103, 11.5813> <-3.4693, 12.0962, 11.5880> <-3.4693, 12.0594, 11.5884> <-3.4693, 12.0634, 11.6034>
		<-3.4218, 12.0634, 11.6112> <-3.4218, 12.0493, 11.6179> <-3.4218, 12.0125, 11.6183> <-3.4218, 12.0164, 11.6333>
		<-3.3857, 12.0674, 11.6256> <-3.3857, 12.0533, 11.6322> <-3.3857, 12.0165, 11.6326> <-3.3857, 12.0205, 11.6477>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3857, 12.0674, 11.6256> <-3.3857, 12.0533, 11.6322> <-3.3857, 12.0165, 11.6326> <-3.3857, 12.0205, 11.6477>
		<-3.3543, 12.0709, 11.6381> <-3.3543, 12.0569, 11.6447> <-3.3543, 12.0200, 11.6452> <-3.3543, 12.0240, 11.6602>
		<-3.3213, 12.1015, 11.6579> <-3.3213, 12.0875, 11.6645> <-3.3213, 12.0506, 11.6649> <-3.3213, 12.0546, 11.6800>
		<-3.2929, 12.1184, 11.6660> <-3.2929, 12.1043, 11.6726> <-3.2929, 12.0675, 11.6731> <-3.2929, 12.0714, 11.6881>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2929, 12.1184, 11.6660> <-3.2929, 12.1043, 11.6726> <-3.2929, 12.0675, 11.6731> <-3.2929, 12.0714, 11.6881>
		<-3.2593, 12.1383, 11.6756> <-3.2593, 12.1242, 11.6822> <-3.2593, 12.0874, 11.6826> <-3.2593, 12.0914, 11.6977>
		<-3.2090, 12.1608, 11.6835> <-3.2090, 12.1467, 11.6901> <-3.2090, 12.1098, 11.6906> <-3.2090, 12.1137, 11.7057>
		<-3.1806, 12.1892, 11.6842> <-3.1806, 12.1751, 11.6908> <-3.1806, 12.1383, 11.6912> <-3.1806, 12.1422, 11.7063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1806, 12.1892, 11.6842> <-3.1806, 12.1751, 11.6908> <-3.1806, 12.1383, 11.6912> <-3.1806, 12.1422, 11.7063>
		<-3.1414, 12.2284, 11.6851> <-3.1414, 12.2143, 11.6917> <-3.1413, 12.1778, 11.6921> <-3.1413, 12.1817, 11.7071>
		<-3.0756, 12.2835, 11.6756> <-3.0756, 12.2697, 11.6821> <-3.0756, 12.2335, 11.6831> <-3.0756, 12.2373, 11.6978>
		<-3.0725, 12.3387, 11.6713> <-3.0725, 12.3250, 11.6777> <-3.0725, 12.2889, 11.6781> <-3.0725, 12.2928, 11.6929>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0725, 12.3387, 11.6713> <-3.0725, 12.3250, 11.6777> <-3.0725, 12.2889, 11.6781> <-3.0725, 12.2928, 11.6929>
		<-3.0691, 12.4005, 11.6664> <-3.0691, 12.3867, 11.6729> <-3.0690, 12.3529, 11.6724> <-3.0690, 12.3568, 11.6872>
		<-3.1350, 12.4691, 11.6618> <-3.1350, 12.4577, 11.6671> <-3.1350, 12.4256, 11.6686> <-3.1350, 12.4288, 11.6807>
		<-3.1618, 12.5250, 11.6577> <-3.1618, 12.5136, 11.6631> <-3.1618, 12.4839, 11.6634> <-3.1618, 12.4870, 11.6755>
	}
	texture {obrve}
}
///pazi
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8703, 12.6568, 8.6429> <-2.7865, 12.6590, 8.6668> <-2.6606, 12.6517, 8.7055> <-2.6024, 12.5951, 8.7376>
		<-2.8797, 12.6745, 8.6593> <-2.7958, 12.6766, 8.6832> <-2.6628, 12.6677, 8.7245> <-2.6046, 12.6112, 8.7566>
		<-2.8895, 12.7132, 8.6748> <-2.7982, 12.7155, 8.7009> <-2.6594, 12.7072, 8.7452> <-2.5961, 12.6456, 8.7802>
		<-2.9015, 12.7157, 8.6976> <-2.8101, 12.7180, 8.7237> <-2.6731, 12.7101, 8.7658> <-2.6097, 12.6485, 8.8008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8703, 12.6568, 8.6429> <-2.8797, 12.6745, 8.6593> <-2.8895, 12.7132, 8.6748> <-2.9015, 12.7157, 8.6976>
		<-2.9375, 12.6551, 8.6237> <-2.9469, 12.6728, 8.6401> <-2.9627, 12.7113, 8.6539> <-2.9746, 12.7138, 8.6767>
		<-3.0275, 12.6188, 8.6072> <-3.0426, 12.6345, 8.6224> <-3.0622, 12.6709, 8.6344> <-3.0725, 12.6743, 8.6587>
		<-3.0869, 12.5829, 8.5994> <-3.1020, 12.5985, 8.6147> <-3.1269, 12.6318, 8.6260> <-3.1372, 12.6351, 8.6503>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0869, 12.5829, 8.5994> <-3.1020, 12.5985, 8.6147> <-3.1269, 12.6318, 8.6260> <-3.1372, 12.6351, 8.6503>
		<-3.1584, 12.5395, 8.5901> <-3.1735, 12.5552, 8.6053> <-3.2048, 12.5847, 8.6158> <-3.2151, 12.5880, 8.6401>
		<-3.2509, 12.4679, 8.5822> <-3.2716, 12.4787, 8.5972> <-3.3071, 12.5046, 8.6058> <-3.3157, 12.5100, 8.6316>
		<-3.2977, 12.3982, 8.5872> <-3.3184, 12.4090, 8.6021> <-3.3581, 12.4286, 8.6112> <-3.3667, 12.4341, 8.6370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2977, 12.3982, 8.5872> <-3.3184, 12.4090, 8.6021> <-3.3581, 12.4286, 8.6112> <-3.3667, 12.4341, 8.6370>
		<-3.3446, 12.3284, 8.5922> <-3.3653, 12.3391, 8.6071> <-3.4091, 12.3526, 8.6166> <-3.4178, 12.3580, 8.6424>
		<-3.3938, 12.2163, 8.6077> <-3.4169, 12.2200, 8.6238> <-3.4635, 12.2275, 8.6334> <-3.4714, 12.2360, 8.6593>
		<-3.3872, 12.1356, 8.6312> <-3.4103, 12.1394, 8.6473> <-3.4562, 12.1397, 8.6590> <-3.4641, 12.1482, 8.6849>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3872, 12.1356, 8.6312> <-3.4103, 12.1394, 8.6473> <-3.4562, 12.1397, 8.6590> <-3.4641, 12.1482, 8.6849>
		<-3.3774, 12.0171, 8.6657> <-3.4005, 12.0209, 8.6818> <-3.4456, 12.0107, 8.6965> <-3.4535, 12.0192, 8.7225>
		<-3.3302, 11.8519, 8.7237> <-3.3495, 11.8460, 8.7435> <-3.3929, 11.8272, 8.7617> <-3.4021, 11.8393, 8.7856>
		<-3.2462, 11.7732, 8.7692> <-3.2655, 11.7674, 8.7890> <-3.3014, 11.7416, 8.8113> <-3.3106, 11.7536, 8.8352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2462, 11.7732, 8.7692> <-3.2655, 11.7674, 8.7890> <-3.3014, 11.7416, 8.8113> <-3.3106, 11.7536, 8.8352>
		<-3.1715, 11.7033, 8.8097> <-3.1909, 11.6974, 8.8295> <-3.2202, 11.6655, 8.8554> <-3.2294, 11.6775, 8.8793>
		<-3.0150, 11.6969, 8.8572> <-3.0254, 11.6888, 8.8802> <-3.0473, 11.6587, 8.9103> <-3.0590, 11.6706, 8.9309>
		<-2.9103, 11.6890, 8.8899> <-2.9207, 11.6809, 8.9129> <-2.9333, 11.6501, 8.9459> <-2.9449, 11.6620, 8.9665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9103, 11.6890, 8.8899> <-2.9207, 11.6809, 8.9129> <-2.9333, 11.6501, 8.9459> <-2.9449, 11.6620, 8.9665>
		<-2.8394, 11.6837, 8.9120> <-2.8498, 11.6756, 8.9350> <-2.8561, 11.6443, 8.9700> <-2.8678, 11.6561, 8.9906>
		<-2.7398, 11.6998, 8.9368> <-2.7439, 11.6928, 8.9613> <-2.7459, 11.6627, 8.9984> <-2.7593, 11.6737, 9.0176>
		<-2.6727, 11.7300, 8.9483> <-2.6768, 11.7229, 8.9729> <-2.6730, 11.6956, 9.0109> <-2.6863, 11.7065, 9.0302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6727, 11.7300, 8.9483> <-2.6768, 11.7229, 8.9729> <-2.6730, 11.6956, 9.0109> <-2.6863, 11.7065, 9.0302>
		<-2.5953, 11.7648, 8.9616> <-2.5994, 11.7578, 8.9862> <-2.5886, 11.7335, 9.0254> <-2.6020, 11.7445, 9.0446>
		<-2.4715, 11.8195, 8.9832> <-2.4694, 11.8169, 9.0083> <-2.4522, 11.7949, 9.0498> <-2.4672, 11.8040, 9.0681>
		<-2.4426, 11.8994, 8.9703> <-2.4406, 11.8969, 8.9954> <-2.4208, 11.8820, 9.0357> <-2.4358, 11.8910, 9.0540>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4426, 11.8994, 8.9703> <-2.4406, 11.8969, 8.9954> <-2.4208, 11.8820, 9.0357> <-2.4358, 11.8910, 9.0540>
		<-2.4032, 12.0088, 8.9526> <-2.4011, 12.0062, 8.9777> <-2.3779, 12.0010, 9.0164> <-2.3928, 12.0101, 9.0348>
		<-2.4515, 12.1651, 8.8967> <-2.4503, 12.1725, 8.9189> <-2.4316, 12.1749, 8.9557> <-2.4454, 12.1803, 8.9739>
		<-2.4765, 12.2740, 8.8602> <-2.4753, 12.2815, 8.8825> <-2.4589, 12.2935, 8.9161> <-2.4726, 12.2989, 8.9343>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4765, 12.2740, 8.8602> <-2.4753, 12.2815, 8.8825> <-2.4589, 12.2935, 8.9161> <-2.4726, 12.2989, 8.9343>
		<-2.4999, 12.3758, 8.8262> <-2.4987, 12.3833, 8.8484> <-2.4843, 12.4043, 8.8790> <-2.4981, 12.4097, 8.8972>
		<-2.5292, 12.5240, 8.7781> <-2.5314, 12.5400, 8.7970> <-2.5164, 12.5681, 8.8242> <-2.5300, 12.5710, 8.8448>
		<-2.6024, 12.5951, 8.7376> <-2.6046, 12.6112, 8.7566> <-2.5961, 12.6456, 8.7802> <-2.6097, 12.6485, 8.8008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9565, 12.6747, 8.8077> <-2.9400, 12.6870, 8.7747> <-2.9194, 12.7194, 8.7319> <-2.9015, 12.7157, 8.6976>
		<-2.8785, 12.6767, 8.8300> <-2.8619, 12.6890, 8.7969> <-2.8281, 12.7217, 8.7580> <-2.8101, 12.7180, 8.7237>
		<-2.7613, 12.6699, 8.8660> <-2.7321, 12.6793, 8.8375> <-2.6960, 12.7149, 8.8005> <-2.6731, 12.7101, 8.7658>
		<-2.7071, 12.6173, 8.8959> <-2.6779, 12.6267, 8.8674> <-2.6327, 12.6534, 8.8355> <-2.6097, 12.6485, 8.8008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9565, 12.6747, 8.8077> <-3.0191, 12.6731, 8.7898> <-3.1028, 12.6393, 8.7744> <-3.1581, 12.6058, 8.7672>
		<-2.9400, 12.6870, 8.7747> <-3.0026, 12.6854, 8.7568> <-3.0965, 12.6481, 8.7393> <-3.1519, 12.6146, 8.7321>
		<-2.9194, 12.7194, 8.7319> <-2.9926, 12.7175, 8.7111> <-3.0868, 12.6789, 8.6922> <-3.1515, 12.6397, 8.6838>
		<-2.9015, 12.7157, 8.6976> <-2.9746, 12.7138, 8.6767> <-3.0725, 12.6743, 8.6587> <-3.1372, 12.6351, 8.6503>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1581, 12.6058, 8.7672> <-3.2247, 12.5655, 8.7585> <-3.3108, 12.4989, 8.7512> <-3.3543, 12.4339, 8.7558>
		<-3.1519, 12.6146, 8.7321> <-3.2185, 12.5743, 8.7234> <-3.3145, 12.4989, 8.7155> <-3.3581, 12.4340, 8.7202>
		<-3.1515, 12.6397, 8.6838> <-3.2294, 12.5926, 8.6736> <-3.3269, 12.5171, 8.6649> <-3.3779, 12.4411, 8.6703>
		<-3.1372, 12.6351, 8.6503> <-3.2151, 12.5880, 8.6401> <-3.3157, 12.5100, 8.6316> <-3.3667, 12.4341, 8.6370>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3543, 12.4339, 8.7558> <-3.3980, 12.3689, 8.7604> <-3.4438, 12.2646, 8.7749> <-3.4376, 12.1895, 8.7968>
		<-3.3581, 12.4340, 8.7202> <-3.4017, 12.3690, 8.7248> <-3.4518, 12.2522, 8.7414> <-3.4456, 12.1771, 8.7632>
		<-3.3779, 12.4411, 8.6703> <-3.4290, 12.3651, 8.6757> <-3.4816, 12.2469, 8.6928> <-3.4743, 12.1591, 8.7184>
		<-3.3667, 12.4341, 8.6370> <-3.4178, 12.3580, 8.6424> <-3.4714, 12.2360, 8.6593> <-3.4641, 12.1482, 8.6849>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4376, 12.1895, 8.7968> <-3.4286, 12.0792, 8.8289> <-3.3846, 11.9254, 8.8829> <-3.3064, 11.8522, 8.9253>
		<-3.4456, 12.1771, 8.7632> <-3.4365, 12.0668, 8.7954> <-3.3859, 11.8958, 8.8559> <-3.3077, 11.8226, 8.8983>
		<-3.4743, 12.1591, 8.7184> <-3.4637, 12.0301, 8.7560> <-3.4152, 11.8564, 8.8194> <-3.3237, 11.7707, 8.8690>
		<-3.4641, 12.1482, 8.6849> <-3.4535, 12.0192, 8.7225> <-3.4021, 11.8393, 8.7856> <-3.3106, 11.7536, 8.8352>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3064, 11.8522, 8.9253> <-3.2369, 11.7871, 8.9630> <-3.0912, 11.7811, 9.0072> <-2.9937, 11.7738, 9.0376>
		<-3.3077, 11.8226, 8.8983> <-3.2382, 11.7575, 8.9360> <-3.0766, 11.7476, 8.9858> <-2.9791, 11.7402, 9.0163>
		<-3.3237, 11.7707, 8.8690> <-3.2424, 11.6946, 8.9131> <-3.0776, 11.6895, 8.9639> <-2.9636, 11.6809, 8.9995>
		<-3.3106, 11.7536, 8.8352> <-3.2294, 11.6775, 8.8793> <-3.0590, 11.6706, 8.9309> <-2.9449, 11.6620, 8.9665>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9937, 11.7738, 9.0376> <-2.9278, 11.7688, 9.0582> <-2.8350, 11.7838, 9.0813> <-2.7726, 11.8119, 9.0920>
		<-2.9791, 11.7402, 9.0163> <-2.9131, 11.7352, 9.0369> <-2.8091, 11.7522, 9.0627> <-2.7467, 11.7803, 9.0735>
		<-2.9636, 11.6809, 8.9995> <-2.8864, 11.6751, 9.0236> <-2.7825, 11.6927, 9.0510> <-2.7095, 11.7256, 9.0635>
		<-2.9449, 11.6620, 8.9665> <-2.8678, 11.6561, 8.9906> <-2.7593, 11.6737, 9.0176> <-2.6863, 11.7065, 9.0302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7726, 11.8119, 9.0920> <-2.7005, 11.8443, 9.1044> <-2.5852, 11.8952, 9.1245> <-2.5584, 11.9696, 9.1124>
		<-2.7467, 11.7803, 9.0735> <-2.6746, 11.8127, 9.0858> <-2.5484, 11.8716, 9.1070> <-2.5216, 11.9460, 9.0949>
		<-2.7095, 11.7256, 9.0635> <-2.6252, 11.7635, 9.0780> <-2.4949, 11.8208, 9.1022> <-2.4635, 11.9079, 9.0881>
		<-2.6863, 11.7065, 9.0302> <-2.6020, 11.7445, 9.0446> <-2.4672, 11.8040, 9.0681> <-2.4358, 11.8910, 9.0540>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5584, 11.9696, 9.1124> <-2.5217, 12.0714, 9.0960> <-2.5666, 12.2169, 9.0439> <-2.5899, 12.3184, 9.0100>
		<-2.5216, 11.9460, 9.0949> <-2.4849, 12.0478, 9.0784> <-2.5314, 12.2111, 9.0212> <-2.5547, 12.3125, 8.9873>
		<-2.4635, 11.9079, 9.0881> <-2.4206, 12.0269, 9.0689> <-2.4702, 12.1900, 9.0067> <-2.4975, 12.3086, 8.9671>
		<-2.4358, 11.8910, 9.0540> <-2.3928, 12.0101, 9.0348> <-2.4454, 12.1803, 8.9739> <-2.4726, 12.2989, 8.9343>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5899, 12.3184, 9.0100> <-2.6116, 12.4131, 8.9783> <-2.6389, 12.5510, 8.9335> <-2.7071, 12.6173, 8.8959>
		<-2.5547, 12.3125, 8.9873> <-2.5765, 12.4073, 8.9556> <-2.6097, 12.5604, 8.9050> <-2.6779, 12.6267, 8.8674>
		<-2.4975, 12.3086, 8.9671> <-2.5229, 12.4194, 8.9300> <-2.5530, 12.5759, 8.8795> <-2.6327, 12.6534, 8.8355>
		<-2.4726, 12.2989, 8.9343> <-2.4981, 12.4097, 8.8972> <-2.5300, 12.5710, 8.8448> <-2.6097, 12.6485, 8.8008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9912, 10.9875, 8.2146> <-5.0585, 10.9241, 8.2200> <-5.1718, 10.8171, 8.2289> <-5.1932, 10.7608, 8.1585>
		<-4.9850, 10.9700, 8.2318> <-5.0523, 10.9066, 8.2371> <-5.1695, 10.7953, 8.2449> <-5.1909, 10.7390, 8.1746>
		<-4.9871, 10.9482, 8.2692> <-5.0587, 10.8807, 8.2750> <-5.1823, 10.7667, 8.2838> <-5.2051, 10.7068, 8.2089>
		<-4.9707, 10.9292, 8.2717> <-5.0423, 10.8617, 8.2775> <-5.1628, 10.7479, 8.2869> <-5.1857, 10.6880, 8.2120>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9912, 10.9875, 8.2146> <-4.9850, 10.9700, 8.2318> <-4.9871, 10.9482, 8.2692> <-4.9707, 10.9292, 8.2717>
		<-4.9393, 11.0364, 8.2105> <-4.9331, 11.0189, 8.2276> <-4.9318, 11.0003, 8.2648> <-4.9154, 10.9812, 8.2673>
		<-4.8645, 11.0871, 8.1653> <-4.8550, 11.0722, 8.1807> <-4.8500, 11.0539, 8.2163> <-4.8359, 11.0352, 8.2192>
		<-4.8128, 11.1195, 8.1281> <-4.8032, 11.1045, 8.1435> <-4.7949, 11.0883, 8.1767> <-4.7808, 11.0696, 8.1796>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8128, 11.1195, 8.1281> <-4.8032, 11.1045, 8.1435> <-4.7949, 11.0883, 8.1767> <-4.7808, 11.0696, 8.1796>
		<-4.7309, 11.1707, 8.0692> <-4.7213, 11.1557, 8.0847> <-4.7078, 11.1428, 8.1141> <-4.6937, 11.1241, 8.1170>
		<-4.6200, 11.2378, 7.9839> <-4.6053, 11.2256, 7.9950> <-4.5870, 11.2139, 8.0220> <-4.5756, 11.1955, 8.0262>
		<-4.5508, 11.2628, 7.8981> <-4.5361, 11.2506, 7.9091> <-4.5134, 11.2405, 7.9306> <-4.5020, 11.2222, 7.9349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5508, 11.2628, 7.8981> <-4.5361, 11.2506, 7.9091> <-4.5134, 11.2405, 7.9306> <-4.5020, 11.2222, 7.9349>
		<-4.4795, 11.2886, 7.8097> <-4.4649, 11.2764, 7.8208> <-4.4376, 11.2679, 7.8366> <-4.4262, 11.2496, 7.8409>
		<-4.3998, 11.2963, 7.6703> <-4.3814, 11.2845, 7.6749> <-4.3516, 11.2765, 7.6860> <-4.3413, 11.2578, 7.6925>
		<-4.3571, 11.2843, 7.5628> <-4.3387, 11.2725, 7.5673> <-4.3061, 11.2637, 7.5716> <-4.2959, 11.2450, 7.5780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3571, 11.2843, 7.5628> <-4.3387, 11.2725, 7.5673> <-4.3061, 11.2637, 7.5716> <-4.2959, 11.2450, 7.5780>
		<-4.3250, 11.2752, 7.4820> <-4.3066, 11.2634, 7.4865> <-4.2720, 11.2541, 7.4856> <-4.2617, 11.2354, 7.4920>
		<-4.2976, 11.2423, 7.3621> <-4.2783, 11.2288, 7.3614> <-4.2431, 11.2195, 7.3557> <-4.2325, 11.2003, 7.3645>
		<-4.3091, 11.1947, 7.2897> <-4.2898, 11.1812, 7.2890> <-4.2554, 11.1688, 7.2787> <-4.2448, 11.1496, 7.2874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3091, 11.1947, 7.2897> <-4.2898, 11.1812, 7.2890> <-4.2554, 11.1688, 7.2787> <-4.2448, 11.1496, 7.2874>
		<-4.3211, 11.1454, 7.2148> <-4.3018, 11.1319, 7.2142> <-4.2681, 11.1164, 7.1990> <-4.2576, 11.0973, 7.2078>
		<-4.3775, 11.0527, 7.1405> <-4.3606, 11.0352, 7.1364> <-4.3297, 11.0174, 7.1181> <-4.3177, 10.9986, 7.1287>
		<-4.4295, 10.9858, 7.1090> <-4.4126, 10.9683, 7.1048> <-4.3850, 10.9462, 7.0845> <-4.3730, 10.9274, 7.0951>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4295, 10.9858, 7.1090> <-4.4126, 10.9683, 7.1048> <-4.3850, 10.9462, 7.0845> <-4.3730, 10.9274, 7.0951>
		<-4.4668, 10.9378, 7.0863> <-4.4499, 10.9203, 7.0822> <-4.4248, 10.8951, 7.0604> <-4.4127, 10.8763, 7.0710>
		<-4.5379, 10.8751, 7.1006> <-4.5239, 10.8548, 7.0967> <-4.5018, 10.8277, 7.0754> <-4.4883, 10.8096, 7.0862>
		<-4.5866, 10.8376, 7.1212> <-4.5727, 10.8172, 7.1173> <-4.5536, 10.7877, 7.0974> <-4.5401, 10.7696, 7.1081>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5866, 10.8376, 7.1212> <-4.5727, 10.8172, 7.1173> <-4.5536, 10.7877, 7.0974> <-4.5401, 10.7696, 7.1081>
		<-4.6952, 10.7538, 7.1671> <-4.6813, 10.7334, 7.1632> <-4.6692, 10.6986, 7.1462> <-4.6557, 10.6805, 7.1569>
		<-4.8496, 10.6319, 7.2266> <-4.8426, 10.6067, 7.2267> <-4.8372, 10.5679, 7.2106> <-4.8200, 10.5508, 7.2203>
		<-4.9446, 10.5886, 7.3267> <-4.9376, 10.5634, 7.3267> <-4.9383, 10.5218, 7.3171> <-4.9212, 10.5047, 7.3268>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9446, 10.5886, 7.3267> <-4.9376, 10.5634, 7.3267> <-4.9383, 10.5218, 7.3171> <-4.9212, 10.5047, 7.3268>
		<-5.0298, 10.5498, 7.4163> <-5.0228, 10.5246, 7.4164> <-5.0289, 10.4805, 7.4124> <-5.0118, 10.4634, 7.4222>
		<-5.1088, 10.5578, 7.5874> <-5.1056, 10.5325, 7.5948> <-5.1148, 10.4892, 7.5975> <-5.0959, 10.4719, 7.6043>
		<-5.1452, 10.5830, 7.7092> <-5.1420, 10.5577, 7.7166> <-5.1535, 10.5160, 7.7271> <-5.1346, 10.4987, 7.7339>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.1452, 10.5830, 7.7092> <-5.1420, 10.5577, 7.7166> <-5.1535, 10.5160, 7.7271> <-5.1346, 10.4987, 7.7339>
		<-5.1861, 10.6114, 7.8461> <-5.1829, 10.5861, 7.8535> <-5.1971, 10.5462, 7.8728> <-5.1781, 10.5289, 7.8796>
		<-5.2269, 10.6723, 8.0479> <-5.2247, 10.6504, 8.0639> <-5.2410, 10.6126, 8.0911> <-5.2216, 10.5938, 8.0943>
		<-5.1932, 10.7608, 8.1585> <-5.1909, 10.7390, 8.1746> <-5.2051, 10.7068, 8.2089> <-5.1857, 10.6880, 8.2120>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8832, 10.8621, 8.2310> <-4.9094, 10.8822, 8.2432> <-4.9478, 10.9026, 8.2752> <-4.9707, 10.9292, 8.2717>
		<-4.9472, 10.8018, 8.2361> <-4.9734, 10.8219, 8.2483> <-5.0194, 10.8351, 8.2809> <-5.0423, 10.8617, 8.2775>
		<-5.0549, 10.7001, 8.2445> <-5.0880, 10.7125, 8.2548> <-5.1366, 10.7224, 8.2912> <-5.1628, 10.7479, 8.2869>
		<-5.0753, 10.6466, 8.1776> <-5.1084, 10.6590, 8.1880> <-5.1594, 10.6625, 8.2163> <-5.1857, 10.6880, 8.2120>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8832, 10.8621, 8.2310> <-4.8338, 10.9086, 8.2270> <-4.7628, 10.9568, 8.1840> <-4.7136, 10.9876, 8.1487>
		<-4.9094, 10.8822, 8.2432> <-4.8601, 10.9287, 8.2392> <-4.7830, 10.9814, 8.1933> <-4.7338, 11.0122, 8.1580>
		<-4.9478, 10.9026, 8.2752> <-4.8925, 10.9547, 8.2708> <-4.8161, 11.0089, 8.2233> <-4.7611, 11.0433, 8.1837>
		<-4.9707, 10.9292, 8.2717> <-4.9154, 10.9812, 8.2673> <-4.8359, 11.0352, 8.2192> <-4.7808, 11.0696, 8.1796>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7136, 10.9876, 8.1487> <-4.6357, 11.0362, 8.0927> <-4.5302, 11.1001, 8.0116> <-4.4644, 11.1239, 7.9300>
		<-4.7338, 11.0122, 8.1580> <-4.6559, 11.0609, 8.1020> <-4.5415, 11.1296, 8.0131> <-4.4757, 11.1534, 7.9314>
		<-4.7611, 11.0433, 8.1837> <-4.6739, 11.0978, 8.1211> <-4.5593, 11.1692, 8.0323> <-4.4856, 11.1958, 7.9409>
		<-4.7808, 11.0696, 8.1796> <-4.6937, 11.1241, 8.1170> <-4.5756, 11.1955, 8.0262> <-4.5020, 11.2222, 7.9349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4644, 11.1239, 7.9300> <-4.3967, 11.1484, 7.8460> <-4.3209, 11.1557, 7.7134> <-4.2803, 11.1443, 7.6112>
		<-4.4757, 11.1534, 7.9314> <-4.4080, 11.1779, 7.8475> <-4.3256, 11.1859, 7.7035> <-4.2849, 11.1745, 7.6012>
		<-4.4856, 11.1958, 7.9409> <-4.4098, 11.2232, 7.8469> <-4.3265, 11.2309, 7.7018> <-4.2811, 11.2180, 7.5873>
		<-4.5020, 11.2222, 7.9349> <-4.4262, 11.2496, 7.8409> <-4.3413, 11.2578, 7.6925> <-4.2959, 11.2450, 7.5780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2803, 11.1443, 7.6112> <-4.2497, 11.1357, 7.5343> <-4.2237, 11.1043, 7.4203> <-4.2347, 11.0591, 7.3515>
		<-4.2849, 11.1745, 7.6012> <-4.2544, 11.1659, 7.5244> <-4.2267, 11.1315, 7.4011> <-4.2377, 11.0862, 7.3323>
		<-4.2811, 11.2180, 7.5873> <-4.2469, 11.2084, 7.5014> <-4.2176, 11.1731, 7.3769> <-4.2299, 11.1224, 7.2998>
		<-4.2959, 11.2450, 7.5780> <-4.2617, 11.2354, 7.4920> <-4.2325, 11.2003, 7.3645> <-4.2448, 11.1496, 7.2874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2347, 11.0591, 7.3515> <-4.2460, 11.0123, 7.2803> <-4.2997, 10.9241, 7.2097> <-4.3491, 10.8605, 7.1797>
		<-4.2377, 11.0862, 7.3323> <-4.2491, 11.0394, 7.2611> <-4.3069, 10.9442, 7.1843> <-4.3563, 10.8806, 7.1543>
		<-4.2299, 11.1224, 7.2998> <-4.2426, 11.0701, 7.2202> <-4.3015, 10.9734, 7.1429> <-4.3568, 10.9022, 7.1093>
		<-4.2448, 11.1496, 7.2874> <-4.2576, 11.0973, 7.2078> <-4.3177, 10.9986, 7.1287> <-4.3730, 10.9274, 7.0951>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3491, 10.8605, 7.1797> <-4.3846, 10.8148, 7.1581> <-4.4522, 10.7553, 7.1717> <-4.4985, 10.7195, 7.1913>
		<-4.3563, 10.8806, 7.1543> <-4.3918, 10.8349, 7.1328> <-4.4646, 10.7703, 7.1467> <-4.5110, 10.7346, 7.1663>
		<-4.3568, 10.9022, 7.1093> <-4.3965, 10.8511, 7.0852> <-4.4711, 10.7867, 7.0998> <-4.5230, 10.7467, 7.1217>
		<-4.3730, 10.9274, 7.0951> <-4.4127, 10.8763, 7.0710> <-4.4883, 10.8096, 7.0862> <-4.5401, 10.7696, 7.1081>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4985, 10.7195, 7.1913> <-4.6018, 10.6399, 7.2349> <-4.7486, 10.5240, 7.2916> <-4.8389, 10.4828, 7.3867>
		<-4.5110, 10.7346, 7.1663> <-4.6143, 10.6549, 7.2100> <-4.7732, 10.5305, 7.2736> <-4.8636, 10.4893, 7.3687>
		<-4.5230, 10.7467, 7.1217> <-4.6386, 10.6576, 7.1706> <-4.7995, 10.5303, 7.2319> <-4.9007, 10.4842, 7.3384>
		<-4.5401, 10.7696, 7.1081> <-4.6557, 10.6805, 7.1569> <-4.8200, 10.5508, 7.2203> <-4.9212, 10.5047, 7.3268>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8389, 10.4828, 7.3867> <-4.9199, 10.4459, 7.4719> <-4.9951, 10.4535, 7.6346> <-5.0297, 10.4775, 7.7504>
		<-4.8636, 10.4893, 7.3687> <-4.9446, 10.4525, 7.4539> <-5.0265, 10.4599, 7.6296> <-5.0611, 10.4839, 7.7454>
		<-4.9007, 10.4842, 7.3384> <-4.9913, 10.4429, 7.4338> <-5.0727, 10.4507, 7.6125> <-5.1114, 10.4775, 7.7421>
		<-4.9212, 10.5047, 7.3268> <-5.0118, 10.4634, 7.4222> <-5.0959, 10.4719, 7.6043> <-5.1346, 10.4987, 7.7339>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0297, 10.4775, 7.7504> <-5.0686, 10.5044, 7.8806> <-5.1073, 10.5624, 8.0724> <-5.0753, 10.6466, 8.1776>
		<-5.0611, 10.4839, 7.7454> <-5.1000, 10.5108, 7.8756> <-5.1405, 10.5748, 8.0827> <-5.1084, 10.6590, 8.1880>
		<-5.1114, 10.4775, 7.7421> <-5.1549, 10.5077, 7.8878> <-5.1953, 10.5683, 8.0985> <-5.1594, 10.6625, 8.2163>
		<-5.1346, 10.4987, 7.7339> <-5.1781, 10.5289, 7.8796> <-5.2216, 10.5938, 8.0943> <-5.1857, 10.6880, 8.2120>
	}
	texture {cinovi}
}


union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7535, 11.1416, 0.2209> <-0.7587, 11.1469, 0.1906> <-0.7475, 11.1781, 0.1467> <-0.7163, 11.2174, 0.1499>
		<-0.7666, 11.1611, 0.2350> <-0.7718, 11.1665, 0.2046> <-0.7692, 11.2073, 0.1590> <-0.7381, 11.2466, 0.1621>
		<-0.7759, 11.1797, 0.2689> <-0.7837, 11.1888, 0.2295> <-0.7880, 11.2256, 0.1731> <-0.7648, 11.2873, 0.1785>
		<-0.7895, 11.2002, 0.2810> <-0.7972, 11.2093, 0.2416> <-0.8079, 11.2546, 0.1885> <-0.7847, 11.3164, 0.1939>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7535, 11.1416, 0.2209> <-0.7478, 11.1331, 0.2148> <-0.7413, 11.1255, 0.2222> <-0.7293, 11.1102, 0.2160>
		<-0.7587, 11.1469, 0.1906> <-0.7530, 11.1384, 0.1844> <-0.7546, 11.1416, 0.1672> <-0.7427, 11.1263, 0.1610>
		<-0.7475, 11.1781, 0.1467> <-0.7436, 11.1729, 0.1445> <-0.7035, 11.1944, 0.1449> <-0.7046, 11.1958, 0.1458>
		<-0.7163, 11.2174, 0.1499> <-0.7124, 11.2122, 0.1477> <-0.6985, 11.2009, 0.1451> <-0.6996, 11.2023, 0.1460>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7535, 11.1416, 0.2209> <-0.7476, 11.1355, 0.2556> <-0.7098, 11.1601, 0.3156> <-0.6877, 11.1880, 0.3178>
		<-0.7478, 11.1331, 0.2148> <-0.7419, 11.1270, 0.2495> <-0.7027, 11.1504, 0.3095> <-0.6805, 11.1783, 0.3117>
		<-0.7413, 11.1255, 0.2222> <-0.7288, 11.1104, 0.2737> <-0.6901, 11.1430, 0.2991> <-0.6708, 11.1681, 0.3001>
		<-0.7293, 11.1102, 0.2160> <-0.7169, 11.0951, 0.2675> <-0.6834, 11.1342, 0.2914> <-0.6642, 11.1593, 0.2924>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7535, 11.1416, 0.2209> <-0.7666, 11.1611, 0.2350> <-0.7759, 11.1797, 0.2689> <-0.7895, 11.2002, 0.2810>
		<-0.7476, 11.1355, 0.2556> <-0.7607, 11.1551, 0.2697> <-0.7695, 11.1721, 0.3016> <-0.7831, 11.1926, 0.3136>
		<-0.7098, 11.1601, 0.3156> <-0.7288, 11.1857, 0.3316> <-0.7444, 11.2180, 0.3483> <-0.7630, 11.2446, 0.3630>
		<-0.6877, 11.1880, 0.3178> <-0.7066, 11.2136, 0.3338> <-0.7324, 11.2498, 0.3511> <-0.7510, 11.2764, 0.3658>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6877, 11.1880, 0.3178> <-0.7066, 11.2136, 0.3338> <-0.7324, 11.2498, 0.3511> <-0.7510, 11.2764, 0.3658>
		<-0.6661, 11.2152, 0.3200> <-0.6851, 11.2408, 0.3360> <-0.7208, 11.2807, 0.3538> <-0.7394, 11.3073, 0.3685>
		<-0.6477, 11.2619, 0.2649> <-0.6696, 11.2927, 0.2824> <-0.6994, 11.3286, 0.3084> <-0.7207, 11.3590, 0.3272>
		<-0.6534, 11.2678, 0.2311> <-0.6754, 11.2986, 0.2486> <-0.7056, 11.3360, 0.2767> <-0.7270, 11.3664, 0.2955>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6877, 11.1880, 0.3178> <-0.6661, 11.2152, 0.3200> <-0.6477, 11.2619, 0.2649> <-0.6534, 11.2678, 0.2311>
		<-0.6805, 11.1783, 0.3117> <-0.6589, 11.2055, 0.3139> <-0.6414, 11.2531, 0.2599> <-0.6472, 11.2590, 0.2261>
		<-0.6708, 11.1681, 0.3001> <-0.6521, 11.1925, 0.3010> <-0.6319, 11.2366, 0.2769> <-0.6440, 11.2513, 0.2268>
		<-0.6642, 11.1593, 0.2924> <-0.6454, 11.1837, 0.2933> <-0.6213, 11.2204, 0.2709> <-0.6335, 11.2351, 0.2209>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6534, 11.2678, 0.2311> <-0.6754, 11.2986, 0.2486> <-0.7056, 11.3360, 0.2767> <-0.7270, 11.3664, 0.2955>
		<-0.6588, 11.2733, 0.1996> <-0.6807, 11.3041, 0.2171> <-0.7124, 11.3440, 0.2423> <-0.7337, 11.3744, 0.2611>
		<-0.6840, 11.2581, 0.1531> <-0.7057, 11.2873, 0.1654> <-0.7444, 11.3413, 0.1832> <-0.7644, 11.3704, 0.1986>
		<-0.7163, 11.2174, 0.1499> <-0.7381, 11.2466, 0.1621> <-0.7648, 11.2873, 0.1785> <-0.7847, 11.3164, 0.1939>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6534, 11.2678, 0.2311> <-0.6588, 11.2733, 0.1996> <-0.6840, 11.2581, 0.1531> <-0.7163, 11.2174, 0.1499>
		<-0.6472, 11.2590, 0.2261> <-0.6525, 11.2645, 0.1946> <-0.6801, 11.2529, 0.1509> <-0.7124, 11.2122, 0.1477>
		<-0.6440, 11.2513, 0.2268> <-0.6558, 11.2655, 0.1784> <-0.6942, 11.2065, 0.1453> <-0.6985, 11.2009, 0.1451>
		<-0.6335, 11.2351, 0.2209> <-0.6452, 11.2494, 0.1724> <-0.6953, 11.2079, 0.1462> <-0.6996, 11.2023, 0.1460>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7293, 11.1102, 0.2160> <-0.7087, 11.0838, 0.2054> <-0.7035, 11.0726, 0.1989> <-0.6903, 11.0607, 0.1882>
		<-0.7427, 11.1263, 0.1610> <-0.7221, 11.1000, 0.1504> <-0.7112, 11.0816, 0.1656> <-0.6981, 11.0697, 0.1550>
		<-0.7046, 11.1958, 0.1458> <-0.7086, 11.2010, 0.1492> <-0.7076, 11.1187, 0.1071> <-0.6939, 11.0998, 0.0976>
		<-0.6996, 11.2023, 0.1460> <-0.7037, 11.2074, 0.1494> <-0.6724, 11.1629, 0.1109> <-0.6586, 11.1440, 0.1014>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7293, 11.1102, 0.2160> <-0.7169, 11.0951, 0.2675> <-0.6834, 11.1342, 0.2914> <-0.6642, 11.1593, 0.2924>
		<-0.7087, 11.0838, 0.2054> <-0.6963, 11.0687, 0.2569> <-0.6713, 11.1181, 0.2774> <-0.6520, 11.1432, 0.2784>
		<-0.7035, 11.0726, 0.1989> <-0.6974, 11.0655, 0.2249> <-0.6801, 11.0885, 0.2764> <-0.6450, 11.1324, 0.2802>
		<-0.6903, 11.0607, 0.1882> <-0.6843, 11.0536, 0.2143> <-0.6600, 11.0611, 0.2418> <-0.6250, 11.1050, 0.2456>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6642, 11.1593, 0.2924> <-0.6454, 11.1837, 0.2933> <-0.6213, 11.2204, 0.2709> <-0.6335, 11.2351, 0.2209>
		<-0.6520, 11.1432, 0.2784> <-0.6333, 11.1676, 0.2794> <-0.6024, 11.1915, 0.2603> <-0.6145, 11.2062, 0.2102>
		<-0.6450, 11.1324, 0.2802> <-0.6116, 11.1742, 0.2838> <-0.5992, 11.1890, 0.2331> <-0.6050, 11.1957, 0.2083>
		<-0.6250, 11.1050, 0.2456> <-0.5916, 11.1468, 0.2492> <-0.5898, 11.1727, 0.2232> <-0.5955, 11.1794, 0.1985>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6335, 11.2351, 0.2209> <-0.6452, 11.2494, 0.1724> <-0.6953, 11.2079, 0.1462> <-0.6996, 11.2023, 0.1460>
		<-0.6145, 11.2062, 0.2102> <-0.6263, 11.2204, 0.1618> <-0.6993, 11.2131, 0.1496> <-0.7037, 11.2074, 0.1494>
		<-0.6050, 11.1957, 0.2083> <-0.6126, 11.2044, 0.1761> <-0.6380, 11.2058, 0.1146> <-0.6724, 11.1629, 0.1109>
		<-0.5955, 11.1794, 0.1985> <-0.6031, 11.1881, 0.1662> <-0.6243, 11.1870, 0.1051> <-0.6586, 11.1440, 0.1014>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6903, 11.0607, 0.1882> <-0.6781, 11.0496, 0.1784> <-0.6608, 11.0421, 0.1600> <-0.6466, 11.0352, 0.1491>
		<-0.6981, 11.0697, 0.1550> <-0.6859, 11.0586, 0.1452> <-0.6674, 11.0496, 0.1372> <-0.6531, 11.0427, 0.1264>
		<-0.6939, 11.0998, 0.0976> <-0.6849, 11.0875, 0.0914> <-0.6604, 11.0825, 0.0912> <-0.6503, 11.0695, 0.0924>
		<-0.6586, 11.1440, 0.1014> <-0.6496, 11.1317, 0.0952> <-0.6357, 11.1137, 0.0938> <-0.6256, 11.1008, 0.0950>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6903, 11.0607, 0.1882> <-0.6843, 11.0536, 0.2143> <-0.6600, 11.0611, 0.2418> <-0.6250, 11.1050, 0.2456>
		<-0.6781, 11.0496, 0.1784> <-0.6721, 11.0426, 0.2044> <-0.6415, 11.0357, 0.2097> <-0.6064, 11.0796, 0.2135>
		<-0.6608, 11.0421, 0.1600> <-0.6557, 11.0363, 0.1775> <-0.6640, 11.0557, 0.2366> <-0.6250, 11.1050, 0.2407>
		<-0.6466, 11.0352, 0.1491> <-0.6415, 11.0294, 0.1667> <-0.6393, 11.0228, 0.1780> <-0.6004, 11.0721, 0.1821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6250, 11.1050, 0.2456> <-0.5916, 11.1468, 0.2492> <-0.5898, 11.1727, 0.2232> <-0.5955, 11.1794, 0.1985>
		<-0.6064, 11.0796, 0.2135> <-0.5730, 11.1214, 0.2171> <-0.5805, 11.1568, 0.2136> <-0.5863, 11.1635, 0.1889>
		<-0.6250, 11.1050, 0.2407> <-0.5855, 11.1550, 0.2448> <-0.5727, 11.1397, 0.1863> <-0.5778, 11.1456, 0.1685>
		<-0.6004, 11.0721, 0.1821> <-0.5609, 11.1221, 0.1862> <-0.5670, 11.1235, 0.1747> <-0.5721, 11.1294, 0.1569>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5955, 11.1794, 0.1985> <-0.6031, 11.1881, 0.1662> <-0.6243, 11.1870, 0.1051> <-0.6586, 11.1440, 0.1014>
		<-0.5863, 11.1635, 0.1889> <-0.5939, 11.1722, 0.1566> <-0.6153, 11.1747, 0.0989> <-0.6496, 11.1317, 0.0952>
		<-0.5778, 11.1456, 0.1685> <-0.5844, 11.1530, 0.1460> <-0.6113, 11.1446, 0.0964> <-0.6357, 11.1137, 0.0938>
		<-0.5721, 11.1294, 0.1569> <-0.5786, 11.1368, 0.1344> <-0.6012, 11.1317, 0.0975> <-0.6256, 11.1008, 0.0950>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6466, 11.0352, 0.1491> <-0.6402, 11.0321, 0.1443> <-0.6299, 11.0247, 0.1389> <-0.6221, 11.0275, 0.1363>
		<-0.6531, 11.0427, 0.1264> <-0.6468, 11.0396, 0.1215> <-0.6337, 11.0290, 0.1240> <-0.6260, 11.0317, 0.1214>
		<-0.6503, 11.0695, 0.0924> <-0.6430, 11.0601, 0.0932> <-0.6240, 11.0591, 0.1003> <-0.6174, 11.0512, 0.1064>
		<-0.6256, 11.1008, 0.0950> <-0.6183, 11.0914, 0.0958> <-0.6085, 11.0794, 0.1018> <-0.6020, 11.0715, 0.1079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6466, 11.0352, 0.1491> <-0.6415, 11.0294, 0.1667> <-0.6393, 11.0228, 0.1780> <-0.6004, 11.0721, 0.1821>
		<-0.6402, 11.0321, 0.1443> <-0.6351, 11.0263, 0.1618> <-0.6296, 11.0098, 0.1549> <-0.5907, 11.0591, 0.1590>
		<-0.6299, 11.0247, 0.1389> <-0.6265, 11.0209, 0.1521> <-0.6121, 11.0371, 0.1758> <-0.5928, 11.0623, 0.1776>
		<-0.6221, 11.0275, 0.1363> <-0.6188, 11.0236, 0.1495> <-0.6080, 11.0314, 0.1576> <-0.5887, 11.0566, 0.1594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6004, 11.0721, 0.1821> <-0.5609, 11.1221, 0.1862> <-0.5670, 11.1235, 0.1747> <-0.5721, 11.1294, 0.1569>
		<-0.5907, 11.0591, 0.1590> <-0.5512, 11.1091, 0.1631> <-0.5641, 11.1155, 0.1690> <-0.5693, 11.1214, 0.1512>
		<-0.5928, 11.0623, 0.1776> <-0.5731, 11.0882, 0.1794> <-0.5616, 11.1049, 0.1583> <-0.5651, 11.1088, 0.1448>
		<-0.5887, 11.0566, 0.1594> <-0.5690, 11.0824, 0.1612> <-0.5638, 11.0954, 0.1548> <-0.5672, 11.0993, 0.1413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5721, 11.1294, 0.1569> <-0.5786, 11.1368, 0.1344> <-0.6012, 11.1317, 0.0975> <-0.6256, 11.1008, 0.0950>
		<-0.5693, 11.1214, 0.1512> <-0.5758, 11.1288, 0.1287> <-0.5939, 11.1223, 0.0983> <-0.6183, 11.0914, 0.0958>
		<-0.5651, 11.1088, 0.1448> <-0.5689, 11.1130, 0.1301> <-0.5931, 11.0995, 0.1032> <-0.6085, 11.0794, 0.1018>
		<-0.5672, 11.0993, 0.1413> <-0.5710, 11.1036, 0.1266> <-0.5866, 11.0916, 0.1093> <-0.6020, 11.0715, 0.1079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5886, 11.0555, 0.1296> <-0.5872, 11.0540, 0.1351> <-0.5847, 11.0509, 0.1413> <-0.5887, 11.0566, 0.1594>
		<-0.5886, 11.0555, 0.1296> <-0.5813, 11.0617, 0.1356> <-0.5649, 11.0767, 0.1431> <-0.5690, 11.0824, 0.1612>
		<-0.5886, 11.0555, 0.1296> <-0.5813, 11.0617, 0.1356> <-0.5668, 11.0816, 0.1497> <-0.5638, 11.0954, 0.1548>
		<-0.5886, 11.0555, 0.1296> <-0.5827, 11.0633, 0.1302> <-0.5703, 11.0855, 0.1362> <-0.5672, 11.0993, 0.1413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5886, 11.0555, 0.1296> <-0.5827, 11.0633, 0.1302> <-0.5703, 11.0855, 0.1362> <-0.5672, 11.0993, 0.1413>
		<-0.5886, 11.0555, 0.1296> <-0.5841, 11.0649, 0.1247> <-0.5741, 11.0898, 0.1215> <-0.5710, 11.1036, 0.1266>
		<-0.5886, 11.0555, 0.1296> <-0.5841, 11.0649, 0.1247> <-0.5817, 11.0856, 0.1139> <-0.5866, 11.0916, 0.1093>
		<-0.5886, 11.0555, 0.1296> <-0.5900, 11.0571, 0.1242> <-0.5970, 11.0655, 0.1125> <-0.6020, 11.0715, 0.1079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5886, 11.0555, 0.1296> <-0.5900, 11.0571, 0.1242> <-0.5970, 11.0655, 0.1125> <-0.6020, 11.0715, 0.1079>
		<-0.5886, 11.0555, 0.1296> <-0.5953, 11.0502, 0.1237> <-0.6125, 11.0452, 0.1110> <-0.6174, 11.0512, 0.1064>
		<-0.5886, 11.0555, 0.1296> <-0.5953, 11.0502, 0.1237> <-0.6140, 11.0359, 0.1174> <-0.6260, 11.0317, 0.1214>
		<-0.5886, 11.0555, 0.1296> <-0.5939, 11.0487, 0.1292> <-0.6102, 11.0316, 0.1323> <-0.6221, 11.0275, 0.1363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5886, 11.0555, 0.1296> <-0.5939, 11.0487, 0.1292> <-0.6102, 11.0316, 0.1323> <-0.6221, 11.0275, 0.1363>
		<-0.5886, 11.0555, 0.1296> <-0.5925, 11.0471, 0.1346> <-0.6068, 11.0278, 0.1455> <-0.6188, 11.0236, 0.1495>
		<-0.5886, 11.0555, 0.1296> <-0.5925, 11.0471, 0.1346> <-0.6039, 11.0256, 0.1395> <-0.6080, 11.0314, 0.1576>
		<-0.5886, 11.0555, 0.1296> <-0.5872, 11.0540, 0.1351> <-0.5847, 11.0509, 0.1413> <-0.5887, 11.0566, 0.1594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7895, 11.2002, 0.2810> <-0.7972, 11.2093, 0.2416> <-0.8079, 11.2546, 0.1885> <-0.7847, 11.3164, 0.1939>
		<-0.8005, 11.2168, 0.2908> <-0.8083, 11.2259, 0.2514> <-0.8135, 11.2628, 0.1928> <-0.7903, 11.3245, 0.1982>
		<-0.8291, 11.2574, 0.2916> <-0.8296, 11.2579, 0.2874> <-0.8202, 11.2870, 0.2042> <-0.7949, 11.3321, 0.2121>
		<-0.8320, 11.2600, 0.2908> <-0.8325, 11.2605, 0.2866> <-0.8261, 11.2955, 0.2072> <-0.8008, 11.3406, 0.2152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7895, 11.2002, 0.2810> <-0.8005, 11.2168, 0.2908> <-0.8291, 11.2574, 0.2916> <-0.8320, 11.2600, 0.2908>
		<-0.7831, 11.1926, 0.3136> <-0.7941, 11.2092, 0.3235> <-0.8286, 11.2569, 0.2963> <-0.8315, 11.2595, 0.2955>
		<-0.7630, 11.2446, 0.3630> <-0.7722, 11.2578, 0.3703> <-0.7887, 11.2764, 0.3780> <-0.7979, 11.2893, 0.3858>
		<-0.7510, 11.2764, 0.3658> <-0.7602, 11.2896, 0.3731> <-0.7711, 11.3077, 0.3835> <-0.7803, 11.3206, 0.3913>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7510, 11.2764, 0.3658> <-0.7602, 11.2896, 0.3731> <-0.7711, 11.3077, 0.3835> <-0.7803, 11.3206, 0.3913>
		<-0.7394, 11.3073, 0.3685> <-0.7486, 11.3204, 0.3758> <-0.7551, 11.3364, 0.3886> <-0.7643, 11.3493, 0.3963>
		<-0.7207, 11.3590, 0.3272> <-0.7285, 11.3701, 0.3340> <-0.7519, 11.4065, 0.3192> <-0.7500, 11.4055, 0.3202>
		<-0.7270, 11.3664, 0.2955> <-0.7347, 11.3774, 0.3024> <-0.7524, 11.4070, 0.3155> <-0.7504, 11.4059, 0.3165>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7270, 11.3664, 0.2955> <-0.7347, 11.3774, 0.3024> <-0.7524, 11.4070, 0.3155> <-0.7504, 11.4059, 0.3165>
		<-0.7337, 11.3744, 0.2611> <-0.7415, 11.3854, 0.2679> <-0.7528, 11.4074, 0.3114> <-0.7509, 11.4063, 0.3124>
		<-0.7644, 11.3704, 0.1986> <-0.7700, 11.3785, 0.2030> <-0.7662, 11.3834, 0.2211> <-0.7721, 11.3919, 0.2242>
		<-0.7847, 11.3164, 0.1939> <-0.7903, 11.3245, 0.1982> <-0.7949, 11.3321, 0.2121> <-0.8008, 11.3406, 0.2152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6767, 11.3142, 0.2442> <-0.6827, 11.3208, 0.2160> <-0.6765, 11.3522, 0.1728> <-0.6470, 11.3891, 0.1779>
		<-0.6895, 11.3298, 0.2585> <-0.6954, 11.3364, 0.2302> <-0.6951, 11.3767, 0.1833> <-0.6656, 11.4136, 0.1884>
		<-0.7014, 11.3431, 0.2888> <-0.7092, 11.3524, 0.2498> <-0.7130, 11.3878, 0.1960> <-0.6884, 11.4483, 0.2010>
		<-0.7146, 11.3595, 0.3017> <-0.7224, 11.3689, 0.2628> <-0.7300, 11.4124, 0.2086> <-0.7053, 11.4730, 0.2135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6767, 11.3142, 0.2442> <-0.6713, 11.3075, 0.2381> <-0.6659, 11.2998, 0.2437> <-0.6557, 11.2873, 0.2360>
		<-0.6827, 11.3208, 0.2160> <-0.6772, 11.3141, 0.2099> <-0.6799, 11.3173, 0.1931> <-0.6698, 11.3048, 0.1854>
		<-0.6765, 11.3522, 0.1728> <-0.6731, 11.3477, 0.1709> <-0.6361, 11.3698, 0.1697> <-0.6370, 11.3709, 0.1707>
		<-0.6470, 11.3891, 0.1779> <-0.6436, 11.3846, 0.1759> <-0.6314, 11.3755, 0.1712> <-0.6323, 11.3766, 0.1723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6767, 11.3142, 0.2442> <-0.6698, 11.3064, 0.2774> <-0.6342, 11.3237, 0.3384> <-0.6126, 11.3507, 0.3421>
		<-0.6713, 11.3075, 0.2381> <-0.6644, 11.2997, 0.2713> <-0.6277, 11.3151, 0.3323> <-0.6061, 11.3421, 0.3360>
		<-0.6659, 11.2998, 0.2437> <-0.6525, 11.2831, 0.2922> <-0.6175, 11.3118, 0.3161> <-0.5986, 11.3349, 0.3222>
		<-0.6557, 11.2873, 0.2360> <-0.6423, 11.2706, 0.2845> <-0.6120, 11.3048, 0.3075> <-0.5931, 11.3279, 0.3136>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6767, 11.3142, 0.2442> <-0.6895, 11.3298, 0.2585> <-0.7014, 11.3431, 0.2888> <-0.7146, 11.3595, 0.3017>
		<-0.6698, 11.3064, 0.2774> <-0.6826, 11.3221, 0.2916> <-0.6949, 11.3353, 0.3212> <-0.7081, 11.3518, 0.3342>
		<-0.6342, 11.3237, 0.3384> <-0.6512, 11.3465, 0.3546> <-0.6659, 11.3764, 0.3701> <-0.6834, 11.3999, 0.3847>
		<-0.6126, 11.3507, 0.3421> <-0.6297, 11.3735, 0.3583> <-0.6531, 11.4078, 0.3727> <-0.6706, 11.4313, 0.3873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6126, 11.3507, 0.3421> <-0.6297, 11.3735, 0.3583> <-0.6531, 11.4078, 0.3727> <-0.6706, 11.4313, 0.3873>
		<-0.5913, 11.3774, 0.3458> <-0.6083, 11.4001, 0.3620> <-0.6406, 11.4386, 0.3752> <-0.6580, 11.4621, 0.3898>
		<-0.5737, 11.4268, 0.2935> <-0.5954, 11.4544, 0.3049> <-0.6219, 11.4863, 0.3331> <-0.6422, 11.5140, 0.3469>
		<-0.5805, 11.4345, 0.2607> <-0.6023, 11.4621, 0.2721> <-0.6283, 11.4940, 0.3013> <-0.6486, 11.5216, 0.3150>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6126, 11.3507, 0.3421> <-0.5913, 11.3774, 0.3458> <-0.5737, 11.4268, 0.2935> <-0.5805, 11.4345, 0.2607>
		<-0.6061, 11.3421, 0.3360> <-0.5848, 11.3687, 0.3396> <-0.5672, 11.4186, 0.2901> <-0.5741, 11.4263, 0.2573>
		<-0.5986, 11.3349, 0.3222> <-0.5814, 11.3559, 0.3278> <-0.5559, 11.4049, 0.3195> <-0.5681, 11.4201, 0.2755>
		<-0.5931, 11.3279, 0.3136> <-0.5759, 11.3488, 0.3192> <-0.5457, 11.3914, 0.3116> <-0.5579, 11.4066, 0.2676>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5805, 11.4345, 0.2607> <-0.6023, 11.4621, 0.2721> <-0.6283, 11.4940, 0.3013> <-0.6486, 11.5216, 0.3150>
		<-0.5871, 11.4418, 0.2295> <-0.6088, 11.4694, 0.2409> <-0.6351, 11.5021, 0.2672> <-0.6554, 11.5298, 0.2809>
		<-0.6144, 11.4300, 0.1835> <-0.6329, 11.4544, 0.1940> <-0.6668, 11.5013, 0.2053> <-0.6837, 11.5259, 0.2179>
		<-0.6470, 11.3891, 0.1779> <-0.6656, 11.4136, 0.1884> <-0.6884, 11.4483, 0.2010> <-0.7053, 11.4730, 0.2135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5805, 11.4345, 0.2607> <-0.5871, 11.4418, 0.2295> <-0.6144, 11.4300, 0.1835> <-0.6470, 11.3891, 0.1779>
		<-0.5741, 11.4263, 0.2573> <-0.5806, 11.4336, 0.2261> <-0.6109, 11.4254, 0.1815> <-0.6436, 11.3846, 0.1759>
		<-0.5681, 11.4201, 0.2755> <-0.5837, 11.4395, 0.2193> <-0.6261, 11.3820, 0.1729> <-0.6314, 11.3755, 0.1712>
		<-0.5579, 11.4066, 0.2676> <-0.5735, 11.4260, 0.2115> <-0.6270, 11.3831, 0.1740> <-0.6323, 11.3766, 0.1723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6557, 11.2873, 0.2360> <-0.6377, 11.2652, 0.2223> <-0.6327, 11.2566, 0.2148> <-0.6221, 11.2470, 0.2029>
		<-0.6698, 11.3048, 0.1854> <-0.6518, 11.2826, 0.1718> <-0.6410, 11.2666, 0.1840> <-0.6304, 11.2570, 0.1720>
		<-0.6370, 11.3709, 0.1707> <-0.6404, 11.3751, 0.1747> <-0.6444, 11.3041, 0.1276> <-0.6326, 11.2881, 0.1159>
		<-0.6323, 11.3766, 0.1723> <-0.6357, 11.3809, 0.1762> <-0.6104, 11.3454, 0.1333> <-0.5986, 11.3293, 0.1216>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6557, 11.2873, 0.2360> <-0.6423, 11.2706, 0.2845> <-0.6120, 11.3048, 0.3075> <-0.5931, 11.3279, 0.3136>
		<-0.6377, 11.2652, 0.2223> <-0.6243, 11.2484, 0.2709> <-0.6021, 11.2919, 0.2918> <-0.5831, 11.3150, 0.2979>
		<-0.6327, 11.2566, 0.2148> <-0.6262, 11.2488, 0.2389> <-0.6102, 11.2640, 0.2921> <-0.5765, 11.3049, 0.2977>
		<-0.6221, 11.2470, 0.2029> <-0.6156, 11.2392, 0.2270> <-0.5948, 11.2434, 0.2554> <-0.5611, 11.2842, 0.2611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5931, 11.3279, 0.3136> <-0.5759, 11.3488, 0.3192> <-0.5457, 11.3914, 0.3116> <-0.5579, 11.4066, 0.2676>
		<-0.5831, 11.3150, 0.2979> <-0.5659, 11.3360, 0.3035> <-0.5256, 11.3646, 0.2960> <-0.5378, 11.3798, 0.2520>
		<-0.5765, 11.3049, 0.2977> <-0.5416, 11.3472, 0.3036> <-0.5266, 11.3689, 0.2590> <-0.5333, 11.3770, 0.2340>
		<-0.5611, 11.2842, 0.2611> <-0.5262, 11.3265, 0.2670> <-0.5199, 11.3547, 0.2439> <-0.5267, 11.3628, 0.2189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5579, 11.4066, 0.2676> <-0.5735, 11.4260, 0.2115> <-0.6270, 11.3831, 0.1740> <-0.6323, 11.3766, 0.1723>
		<-0.5378, 11.3798, 0.2520> <-0.5534, 11.3991, 0.1958> <-0.6304, 11.3873, 0.1779> <-0.6357, 11.3809, 0.1762>
		<-0.5333, 11.3770, 0.2340> <-0.5421, 11.3876, 0.2012> <-0.5743, 11.3892, 0.1394> <-0.6104, 11.3454, 0.1333>
		<-0.5267, 11.3628, 0.2189> <-0.5355, 11.3734, 0.1861> <-0.5624, 11.3732, 0.1277> <-0.5986, 11.3293, 0.1216>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6221, 11.2470, 0.2029> <-0.6122, 11.2380, 0.1917> <-0.6002, 11.2317, 0.1720> <-0.5887, 11.2264, 0.1601>
		<-0.6304, 11.2570, 0.1720> <-0.6205, 11.2480, 0.1608> <-0.6071, 11.2398, 0.1506> <-0.5956, 11.2345, 0.1386>
		<-0.6326, 11.2881, 0.1159> <-0.6252, 11.2781, 0.1085> <-0.6028, 11.2737, 0.1066> <-0.5938, 11.2624, 0.1063>
		<-0.5986, 11.3293, 0.1216> <-0.5911, 11.3193, 0.1142> <-0.5788, 11.3036, 0.1107> <-0.5698, 11.2922, 0.1105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6221, 11.2470, 0.2029> <-0.6156, 11.2392, 0.2270> <-0.5948, 11.2434, 0.2554> <-0.5611, 11.2842, 0.2611>
		<-0.6122, 11.2380, 0.1917> <-0.6058, 11.2302, 0.2158> <-0.5798, 11.2233, 0.2199> <-0.5461, 11.2642, 0.2255>
		<-0.6002, 11.2317, 0.1720> <-0.5948, 11.2253, 0.1889> <-0.6001, 11.2367, 0.2498> <-0.5615, 11.2847, 0.2565>
		<-0.5887, 11.2264, 0.1601> <-0.5832, 11.2200, 0.1770> <-0.5814, 11.2126, 0.1876> <-0.5428, 11.2606, 0.1942>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5611, 11.2842, 0.2611> <-0.5262, 11.3265, 0.2670> <-0.5199, 11.3547, 0.2439> <-0.5267, 11.3628, 0.2189>
		<-0.5461, 11.2642, 0.2255> <-0.5112, 11.3065, 0.2314> <-0.5139, 11.3417, 0.2302> <-0.5206, 11.3498, 0.2052>
		<-0.5615, 11.2847, 0.2565> <-0.5232, 11.3323, 0.2631> <-0.5132, 11.3252, 0.2025> <-0.5186, 11.3316, 0.1857>
		<-0.5428, 11.2606, 0.1942> <-0.5045, 11.3082, 0.2008> <-0.5104, 11.3106, 0.1894> <-0.5159, 11.3170, 0.1726>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5267, 11.3628, 0.2189> <-0.5355, 11.3734, 0.1861> <-0.5624, 11.3732, 0.1277> <-0.5986, 11.3293, 0.1216>
		<-0.5206, 11.3498, 0.2052> <-0.5294, 11.3604, 0.1724> <-0.5550, 11.3632, 0.1203> <-0.5911, 11.3193, 0.1142>
		<-0.5186, 11.3316, 0.1857> <-0.5256, 11.3398, 0.1639> <-0.5544, 11.3339, 0.1149> <-0.5788, 11.3036, 0.1107>
		<-0.5159, 11.3170, 0.1726> <-0.5229, 11.3252, 0.1508> <-0.5454, 11.3225, 0.1147> <-0.5698, 11.2922, 0.1105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5887, 11.2264, 0.1601> <-0.5834, 11.2240, 0.1546> <-0.5738, 11.2188, 0.1483> <-0.5669, 11.2219, 0.1457>
		<-0.5956, 11.2345, 0.1386> <-0.5903, 11.2321, 0.1332> <-0.5779, 11.2236, 0.1343> <-0.5710, 11.2266, 0.1317>
		<-0.5938, 11.2624, 0.1063> <-0.5872, 11.2541, 0.1061> <-0.5692, 11.2536, 0.1126> <-0.5632, 11.2464, 0.1177>
		<-0.5698, 11.2922, 0.1105> <-0.5632, 11.2839, 0.1103> <-0.5541, 11.2730, 0.1150> <-0.5482, 11.2658, 0.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5887, 11.2264, 0.1601> <-0.5832, 11.2200, 0.1770> <-0.5814, 11.2126, 0.1876> <-0.5428, 11.2606, 0.1942>
		<-0.5834, 11.2240, 0.1546> <-0.5780, 11.2176, 0.1715> <-0.5741, 11.2032, 0.1634> <-0.5355, 11.2512, 0.1700>
		<-0.5738, 11.2188, 0.1483> <-0.5701, 11.2145, 0.1610> <-0.5553, 11.2278, 0.1849> <-0.5362, 11.2523, 0.1880>
		<-0.5669, 11.2219, 0.1457> <-0.5632, 11.2175, 0.1585> <-0.5528, 11.2243, 0.1668> <-0.5337, 11.2489, 0.1699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5428, 11.2606, 0.1942> <-0.5045, 11.3082, 0.2008> <-0.5104, 11.3106, 0.1894> <-0.5159, 11.3170, 0.1726>
		<-0.5355, 11.2512, 0.1700> <-0.4972, 11.2988, 0.1766> <-0.5091, 11.3036, 0.1831> <-0.5145, 11.3099, 0.1663>
		<-0.5362, 11.2523, 0.1880> <-0.5171, 11.2769, 0.1911> <-0.5071, 11.2949, 0.1712> <-0.5108, 11.2992, 0.1585>
		<-0.5337, 11.2489, 0.1699> <-0.5145, 11.2735, 0.1730> <-0.5095, 11.2866, 0.1672> <-0.5132, 11.2909, 0.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5159, 11.3170, 0.1726> <-0.5229, 11.3252, 0.1508> <-0.5454, 11.3225, 0.1147> <-0.5698, 11.2922, 0.1105>
		<-0.5145, 11.3099, 0.1663> <-0.5216, 11.3182, 0.1445> <-0.5388, 11.3142, 0.1145> <-0.5632, 11.2839, 0.1103>
		<-0.5108, 11.2992, 0.1585> <-0.5149, 11.3041, 0.1442> <-0.5388, 11.2927, 0.1175> <-0.5541, 11.2730, 0.1150>
		<-0.5132, 11.2909, 0.1544> <-0.5173, 11.2958, 0.1402> <-0.5328, 11.2855, 0.1226> <-0.5482, 11.2658, 0.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5352, 11.2503, 0.1401> <-0.5337, 11.2485, 0.1454> <-0.5310, 11.2453, 0.1509> <-0.5337, 11.2489, 0.1699>
		<-0.5352, 11.2503, 0.1401> <-0.5279, 11.2559, 0.1464> <-0.5119, 11.2699, 0.1540> <-0.5145, 11.2735, 0.1730>
		<-0.5352, 11.2503, 0.1401> <-0.5279, 11.2559, 0.1464> <-0.5131, 11.2740, 0.1610> <-0.5095, 11.2866, 0.1672>
		<-0.5352, 11.2503, 0.1401> <-0.5294, 11.2577, 0.1410> <-0.5169, 11.2783, 0.1483> <-0.5132, 11.2909, 0.1544>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5352, 11.2503, 0.1401> <-0.5294, 11.2577, 0.1410> <-0.5169, 11.2783, 0.1483> <-0.5132, 11.2909, 0.1544>
		<-0.5352, 11.2503, 0.1401> <-0.5309, 11.2594, 0.1360> <-0.5210, 11.2831, 0.1340> <-0.5173, 11.2958, 0.1402>
		<-0.5352, 11.2503, 0.1401> <-0.5309, 11.2594, 0.1360> <-0.5281, 11.2797, 0.1267> <-0.5328, 11.2855, 0.1226>
		<-0.5352, 11.2503, 0.1401> <-0.5367, 11.2520, 0.1350> <-0.5434, 11.2600, 0.1242> <-0.5482, 11.2658, 0.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5352, 11.2503, 0.1401> <-0.5367, 11.2520, 0.1350> <-0.5434, 11.2600, 0.1242> <-0.5482, 11.2658, 0.1201>
		<-0.5352, 11.2503, 0.1401> <-0.5418, 11.2454, 0.1342> <-0.5585, 11.2406, 0.1218> <-0.5632, 11.2464, 0.1177>
		<-0.5352, 11.2503, 0.1401> <-0.5418, 11.2454, 0.1342> <-0.5599, 11.2316, 0.1275> <-0.5710, 11.2266, 0.1317>
		<-0.5352, 11.2503, 0.1401> <-0.5403, 11.2437, 0.1393> <-0.5558, 11.2268, 0.1416> <-0.5669, 11.2219, 0.1457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5352, 11.2503, 0.1401> <-0.5403, 11.2437, 0.1393> <-0.5558, 11.2268, 0.1416> <-0.5669, 11.2219, 0.1457>
		<-0.5352, 11.2503, 0.1401> <-0.5388, 11.2419, 0.1446> <-0.5521, 11.2225, 0.1543> <-0.5632, 11.2175, 0.1585>
		<-0.5352, 11.2503, 0.1401> <-0.5388, 11.2419, 0.1446> <-0.5502, 11.2207, 0.1478> <-0.5528, 11.2243, 0.1668>
		<-0.5352, 11.2503, 0.1401> <-0.5337, 11.2485, 0.1454> <-0.5310, 11.2453, 0.1509> <-0.5337, 11.2489, 0.1699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7146, 11.3595, 0.3017> <-0.7224, 11.3689, 0.2628> <-0.7300, 11.4124, 0.2086> <-0.7053, 11.4730, 0.2135>
		<-0.7243, 11.3716, 0.3112> <-0.7321, 11.3809, 0.2723> <-0.7370, 11.4227, 0.2138> <-0.7124, 11.4832, 0.2188>
		<-0.7481, 11.4046, 0.3177> <-0.7485, 11.4051, 0.3136> <-0.7383, 11.4395, 0.2287> <-0.7185, 11.4947, 0.2340>
		<-0.7504, 11.4059, 0.3165> <-0.7508, 11.4064, 0.3125> <-0.7465, 11.4498, 0.2316> <-0.7267, 11.5050, 0.2369>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7146, 11.3595, 0.3017> <-0.7243, 11.3716, 0.3112> <-0.7481, 11.4046, 0.3177> <-0.7504, 11.4059, 0.3165>
		<-0.7081, 11.3518, 0.3342> <-0.7178, 11.3638, 0.3437> <-0.7477, 11.4040, 0.3220> <-0.7500, 11.4053, 0.3208>
		<-0.6834, 11.3999, 0.3847> <-0.6950, 11.4155, 0.3945> <-0.7098, 11.4294, 0.4107> <-0.7224, 11.4446, 0.4199>
		<-0.6706, 11.4313, 0.3873> <-0.6822, 11.4470, 0.3971> <-0.6967, 11.4658, 0.4142> <-0.7094, 11.4810, 0.4234>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6706, 11.4313, 0.3873> <-0.6822, 11.4470, 0.3971> <-0.6967, 11.4658, 0.4142> <-0.7094, 11.4810, 0.4234>
		<-0.6580, 11.4621, 0.3898> <-0.6697, 11.4778, 0.3996> <-0.6838, 11.5019, 0.4177> <-0.6964, 11.5171, 0.4269>
		<-0.6422, 11.5140, 0.3469> <-0.6542, 11.5303, 0.3550> <-0.6848, 11.5729, 0.3424> <-0.6864, 11.5786, 0.3467>
		<-0.6486, 11.5216, 0.3150> <-0.6606, 11.5379, 0.3232> <-0.6861, 11.5746, 0.3289> <-0.6877, 11.5803, 0.3332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6486, 11.5216, 0.3150> <-0.6606, 11.5379, 0.3232> <-0.6861, 11.5746, 0.3289> <-0.6877, 11.5803, 0.3332>
		<-0.6554, 11.5298, 0.2809> <-0.6674, 11.5461, 0.2891> <-0.6872, 11.5763, 0.3163> <-0.6888, 11.5819, 0.3206>
		<-0.6837, 11.5259, 0.2179> <-0.6908, 11.5362, 0.2231> <-0.6988, 11.5494, 0.2393> <-0.7070, 11.5598, 0.2422>
		<-0.7053, 11.4730, 0.2135> <-0.7124, 11.4832, 0.2188> <-0.7185, 11.4947, 0.2340> <-0.7267, 11.5050, 0.2369>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6168, 11.4859, 0.2865> <-0.6207, 11.4912, 0.2577> <-0.6150, 11.5179, 0.2119> <-0.5858, 11.5553, 0.2149>
		<-0.6286, 11.5013, 0.2986> <-0.6325, 11.5067, 0.2698> <-0.6331, 11.5436, 0.2199> <-0.6038, 11.5810, 0.2228>
		<-0.6406, 11.5215, 0.3194> <-0.6465, 11.5263, 0.2806> <-0.6508, 11.5600, 0.2276> <-0.6249, 11.6179, 0.2317>
		<-0.6534, 11.5385, 0.3278> <-0.6593, 11.5433, 0.2891> <-0.6679, 11.5868, 0.2339> <-0.6420, 11.6447, 0.2380>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6168, 11.4859, 0.2865> <-0.6118, 11.4794, 0.2814> <-0.6068, 11.4756, 0.2798> <-0.5977, 11.4654, 0.2707>
		<-0.6207, 11.4912, 0.2577> <-0.6158, 11.4847, 0.2526> <-0.6211, 11.4935, 0.2315> <-0.6120, 11.4834, 0.2225>
		<-0.6150, 11.5179, 0.2119> <-0.6133, 11.5154, 0.2112> <-0.5813, 11.5461, 0.2081> <-0.5817, 11.5466, 0.2088>
		<-0.5858, 11.5553, 0.2149> <-0.5840, 11.5528, 0.2141> <-0.5768, 11.5519, 0.2088> <-0.5773, 11.5524, 0.2094>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6168, 11.4859, 0.2865> <-0.6126, 11.4802, 0.3170> <-0.5831, 11.5010, 0.3729> <-0.5638, 11.5255, 0.3748>
		<-0.6118, 11.4794, 0.2814> <-0.6076, 11.4737, 0.3119> <-0.5762, 11.4904, 0.3673> <-0.5570, 11.5150, 0.3692>
		<-0.6068, 11.4756, 0.2798> <-0.5929, 11.4582, 0.3265> <-0.5608, 11.4849, 0.3548> <-0.5427, 11.5084, 0.3575>
		<-0.5977, 11.4654, 0.2707> <-0.5838, 11.4480, 0.3175> <-0.5542, 11.4774, 0.3454> <-0.5361, 11.5009, 0.3480>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6168, 11.4859, 0.2865> <-0.6286, 11.5013, 0.2986> <-0.6406, 11.5215, 0.3194> <-0.6534, 11.5385, 0.3278>
		<-0.6126, 11.4802, 0.3170> <-0.6244, 11.4957, 0.3291> <-0.6352, 11.5171, 0.3544> <-0.6480, 11.5341, 0.3628>
		<-0.5831, 11.5010, 0.3729> <-0.6004, 11.5277, 0.3872> <-0.6128, 11.5617, 0.4001> <-0.6297, 11.5904, 0.4108>
		<-0.5638, 11.5255, 0.3748> <-0.5812, 11.5523, 0.3891> <-0.5982, 11.5942, 0.4024> <-0.6151, 11.6228, 0.4131>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5638, 11.5255, 0.3748> <-0.5812, 11.5523, 0.3891> <-0.5982, 11.5942, 0.4024> <-0.6151, 11.6228, 0.4131>
		<-0.5438, 11.5511, 0.3768> <-0.5612, 11.5779, 0.3911> <-0.5854, 11.6227, 0.4045> <-0.6024, 11.6513, 0.4151>
		<-0.5231, 11.5942, 0.3271> <-0.5399, 11.6231, 0.3404> <-0.5598, 11.6649, 0.3573> <-0.5772, 11.6938, 0.3698>
		<-0.5274, 11.6000, 0.2954> <-0.5443, 11.6290, 0.3087> <-0.5646, 11.6687, 0.3266> <-0.5819, 11.6976, 0.3392>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5638, 11.5255, 0.3748> <-0.5438, 11.5511, 0.3768> <-0.5231, 11.5942, 0.3271> <-0.5274, 11.6000, 0.2954>
		<-0.5570, 11.5150, 0.3692> <-0.5370, 11.5406, 0.3712> <-0.5188, 11.5868, 0.3237> <-0.5231, 11.5927, 0.2920>
		<-0.5427, 11.5084, 0.3575> <-0.5250, 11.5312, 0.3601> <-0.5052, 11.5716, 0.3364> <-0.5187, 11.5885, 0.2907>
		<-0.5361, 11.5009, 0.3480> <-0.5183, 11.5238, 0.3507> <-0.4980, 11.5598, 0.3292> <-0.5115, 11.5767, 0.2835>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5274, 11.6000, 0.2954> <-0.5443, 11.6290, 0.3087> <-0.5646, 11.6687, 0.3266> <-0.5819, 11.6976, 0.3392>
		<-0.5316, 11.6056, 0.2653> <-0.5484, 11.6346, 0.2786> <-0.5700, 11.6732, 0.2908> <-0.5874, 11.7021, 0.3033>
		<-0.5552, 11.5943, 0.2179> <-0.5733, 11.6200, 0.2259> <-0.6008, 11.6713, 0.2355> <-0.6180, 11.6981, 0.2418>
		<-0.5858, 11.5553, 0.2149> <-0.6038, 11.5810, 0.2228> <-0.6249, 11.6179, 0.2317> <-0.6420, 11.6447, 0.2380>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5274, 11.6000, 0.2954> <-0.5316, 11.6056, 0.2653> <-0.5552, 11.5943, 0.2179> <-0.5858, 11.5553, 0.2149>
		<-0.5231, 11.5927, 0.2920> <-0.5273, 11.5983, 0.2619> <-0.5535, 11.5918, 0.2171> <-0.5840, 11.5528, 0.2141>
		<-0.5187, 11.5885, 0.2907> <-0.5322, 11.6054, 0.2453> <-0.5726, 11.5574, 0.2094> <-0.5768, 11.5519, 0.2088>
		<-0.5115, 11.5767, 0.2835> <-0.5250, 11.5936, 0.2381> <-0.5730, 11.5579, 0.2101> <-0.5773, 11.5524, 0.2094>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5977, 11.4654, 0.2707> <-0.5804, 11.4462, 0.2536> <-0.5753, 11.4367, 0.2477> <-0.5650, 11.4282, 0.2352>
		<-0.6120, 11.4834, 0.2225> <-0.5947, 11.4641, 0.2054> <-0.5837, 11.4472, 0.2180> <-0.5734, 11.4387, 0.2056>
		<-0.5817, 11.5466, 0.2088> <-0.5849, 11.5502, 0.2133> <-0.5885, 11.4835, 0.1618> <-0.5771, 11.4684, 0.1491>
		<-0.5773, 11.5524, 0.2094> <-0.5804, 11.5560, 0.2140> <-0.5563, 11.5241, 0.1688> <-0.5450, 11.5091, 0.1561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5977, 11.4654, 0.2707> <-0.5838, 11.4480, 0.3175> <-0.5542, 11.4774, 0.3454> <-0.5361, 11.5009, 0.3480>
		<-0.5804, 11.4462, 0.2536> <-0.5665, 11.4288, 0.3003> <-0.5434, 11.4653, 0.3300> <-0.5253, 11.4887, 0.3327>
		<-0.5753, 11.4367, 0.2477> <-0.5689, 11.4286, 0.2706> <-0.5516, 11.4394, 0.3238> <-0.5201, 11.4792, 0.3306>
		<-0.5650, 11.4282, 0.2352> <-0.5585, 11.4201, 0.2581> <-0.5376, 11.4208, 0.2862> <-0.5061, 11.4606, 0.2931>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5361, 11.5009, 0.3480> <-0.5183, 11.5238, 0.3507> <-0.4980, 11.5598, 0.3292> <-0.5115, 11.5767, 0.2835>
		<-0.5253, 11.4887, 0.3327> <-0.5075, 11.5116, 0.3354> <-0.4833, 11.5358, 0.3145> <-0.4969, 11.5528, 0.2689>
		<-0.5201, 11.4792, 0.3306> <-0.4906, 11.5165, 0.3370> <-0.4851, 11.5351, 0.2860> <-0.4911, 11.5427, 0.2646>
		<-0.5061, 11.4606, 0.2931> <-0.4766, 11.4979, 0.2994> <-0.4785, 11.5224, 0.2741> <-0.4846, 11.5300, 0.2526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5115, 11.5767, 0.2835> <-0.5250, 11.5936, 0.2381> <-0.5730, 11.5579, 0.2101> <-0.5773, 11.5524, 0.2094>
		<-0.4969, 11.5528, 0.2689> <-0.5104, 11.5696, 0.2235> <-0.5762, 11.5615, 0.2146> <-0.5804, 11.5560, 0.2140>
		<-0.4911, 11.5427, 0.2646> <-0.4996, 11.5533, 0.2347> <-0.5239, 11.5651, 0.1758> <-0.5563, 11.5241, 0.1688>
		<-0.4846, 11.5300, 0.2526> <-0.4930, 11.5405, 0.2227> <-0.5125, 11.5500, 0.1631> <-0.5450, 11.5091, 0.1561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5650, 11.4282, 0.2352> <-0.5552, 11.4201, 0.2233> <-0.5428, 11.4156, 0.2033> <-0.5315, 11.4110, 0.1907>
		<-0.5734, 11.4387, 0.2056> <-0.5636, 11.4306, 0.1936> <-0.5495, 11.4238, 0.1833> <-0.5383, 11.4192, 0.1707>
		<-0.5771, 11.4684, 0.1491> <-0.5701, 11.4591, 0.1413> <-0.5485, 11.4561, 0.1390> <-0.5399, 11.4451, 0.1381>
		<-0.5450, 11.5091, 0.1561> <-0.5379, 11.4998, 0.1482> <-0.5263, 11.4845, 0.1437> <-0.5177, 11.4735, 0.1428>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5650, 11.4282, 0.2352> <-0.5585, 11.4201, 0.2581> <-0.5376, 11.4208, 0.2862> <-0.5061, 11.4606, 0.2931>
		<-0.5552, 11.4201, 0.2233> <-0.5487, 11.4120, 0.2462> <-0.5238, 11.4025, 0.2493> <-0.4924, 11.4424, 0.2561>
		<-0.5428, 11.4156, 0.2033> <-0.5376, 11.4094, 0.2185> <-0.5413, 11.4170, 0.2811> <-0.5066, 11.4612, 0.2885>
		<-0.5315, 11.4110, 0.1907> <-0.5264, 11.4048, 0.2059> <-0.5247, 11.3957, 0.2173> <-0.4901, 11.4399, 0.2247>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5061, 11.4606, 0.2931> <-0.4766, 11.4979, 0.2994> <-0.4785, 11.5224, 0.2741> <-0.4846, 11.5300, 0.2526>
		<-0.4924, 11.4424, 0.2561> <-0.4629, 11.4796, 0.2625> <-0.4718, 11.5094, 0.2619> <-0.4779, 11.5169, 0.2404>
		<-0.5066, 11.4612, 0.2885> <-0.4723, 11.5051, 0.2958> <-0.4668, 11.4986, 0.2332> <-0.4719, 11.5048, 0.2181>
		<-0.4901, 11.4399, 0.2247> <-0.4558, 11.4837, 0.2321> <-0.4628, 11.4860, 0.2194> <-0.4679, 11.4922, 0.2043>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4846, 11.5300, 0.2526> <-0.4930, 11.5405, 0.2227> <-0.5125, 11.5500, 0.1631> <-0.5450, 11.5091, 0.1561>
		<-0.4779, 11.5169, 0.2404> <-0.4863, 11.5275, 0.2105> <-0.5055, 11.5407, 0.1553> <-0.5379, 11.4998, 0.1482>
		<-0.4719, 11.5048, 0.2181> <-0.4788, 11.5131, 0.1977> <-0.5037, 11.5134, 0.1486> <-0.5263, 11.4845, 0.1437>
		<-0.4679, 11.4922, 0.2043> <-0.4748, 11.5006, 0.1839> <-0.4950, 11.5023, 0.1477> <-0.5177, 11.4735, 0.1428>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5315, 11.4110, 0.1907> <-0.5267, 11.4090, 0.1852> <-0.5183, 11.4035, 0.1784> <-0.5119, 11.4063, 0.1755>
		<-0.5383, 11.4192, 0.1707> <-0.5334, 11.4172, 0.1652> <-0.5222, 11.4083, 0.1655> <-0.5158, 11.4111, 0.1627>
		<-0.5399, 11.4451, 0.1381> <-0.5336, 11.4370, 0.1374> <-0.5163, 11.4365, 0.1435> <-0.5105, 11.4293, 0.1481>
		<-0.5177, 11.4735, 0.1428> <-0.5114, 11.4654, 0.1421> <-0.5026, 11.4546, 0.1463> <-0.4968, 11.4475, 0.1509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5315, 11.4110, 0.1907> <-0.5264, 11.4048, 0.2059> <-0.5247, 11.3957, 0.2173> <-0.4901, 11.4399, 0.2247>
		<-0.5267, 11.4090, 0.1852> <-0.5215, 11.4028, 0.2005> <-0.5183, 11.3874, 0.1926> <-0.4837, 11.4316, 0.2000>
		<-0.5183, 11.4035, 0.1784> <-0.5148, 11.3993, 0.1898> <-0.5010, 11.4095, 0.2144> <-0.4839, 11.4321, 0.2179>
		<-0.5119, 11.4063, 0.1755> <-0.5084, 11.4021, 0.1870> <-0.4990, 11.4068, 0.1962> <-0.4819, 11.4294, 0.1997>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4901, 11.4399, 0.2247> <-0.4558, 11.4837, 0.2321> <-0.4628, 11.4860, 0.2194> <-0.4679, 11.4922, 0.2043>
		<-0.4837, 11.4316, 0.2000> <-0.4493, 11.4755, 0.2074> <-0.4609, 11.4800, 0.2128> <-0.4660, 11.4861, 0.1976>
		<-0.4839, 11.4321, 0.2179> <-0.4668, 11.4547, 0.2214> <-0.4594, 11.4719, 0.2010> <-0.4629, 11.4762, 0.1896>
		<-0.4819, 11.4294, 0.1997> <-0.4648, 11.4520, 0.2032> <-0.4615, 11.4641, 0.1966> <-0.4650, 11.4684, 0.1851>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4679, 11.4922, 0.2043> <-0.4748, 11.5006, 0.1839> <-0.4950, 11.5023, 0.1477> <-0.5177, 11.4735, 0.1428>
		<-0.4660, 11.4861, 0.1976> <-0.4728, 11.4945, 0.1773> <-0.4887, 11.4943, 0.1470> <-0.5114, 11.4654, 0.1421>
		<-0.4629, 11.4762, 0.1896> <-0.4669, 11.4810, 0.1765> <-0.4886, 11.4731, 0.1491> <-0.5026, 11.4546, 0.1463>
		<-0.4650, 11.4684, 0.1851> <-0.4690, 11.4732, 0.1721> <-0.4828, 11.4659, 0.1538> <-0.4968, 11.4475, 0.1509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4840, 11.4317, 0.1700> <-0.4824, 11.4298, 0.1753> <-0.4798, 11.4265, 0.1805> <-0.4819, 11.4294, 0.1997>
		<-0.4840, 11.4317, 0.1700> <-0.4772, 11.4366, 0.1763> <-0.4627, 11.4492, 0.1840> <-0.4648, 11.4520, 0.2032>
		<-0.4840, 11.4317, 0.1700> <-0.4772, 11.4366, 0.1763> <-0.4644, 11.4529, 0.1903> <-0.4615, 11.4641, 0.1966>
		<-0.4840, 11.4317, 0.1700> <-0.4788, 11.4385, 0.1711> <-0.4679, 11.4572, 0.1788> <-0.4650, 11.4684, 0.1851>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4840, 11.4317, 0.1700> <-0.4788, 11.4385, 0.1711> <-0.4679, 11.4572, 0.1788> <-0.4650, 11.4684, 0.1851>
		<-0.4840, 11.4317, 0.1700> <-0.4803, 11.4404, 0.1661> <-0.4719, 11.4620, 0.1657> <-0.4690, 11.4732, 0.1721>
		<-0.4840, 11.4317, 0.1700> <-0.4803, 11.4404, 0.1661> <-0.4782, 11.4601, 0.1576> <-0.4828, 11.4659, 0.1538>
		<-0.4840, 11.4317, 0.1700> <-0.4855, 11.4335, 0.1651> <-0.4921, 11.4417, 0.1547> <-0.4968, 11.4475, 0.1509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4840, 11.4317, 0.1700> <-0.4855, 11.4335, 0.1651> <-0.4921, 11.4417, 0.1547> <-0.4968, 11.4475, 0.1509>
		<-0.4840, 11.4317, 0.1700> <-0.4900, 11.4276, 0.1642> <-0.5058, 11.4235, 0.1519> <-0.5105, 11.4293, 0.1481>
		<-0.4840, 11.4317, 0.1700> <-0.4900, 11.4276, 0.1642> <-0.5061, 11.4153, 0.1585> <-0.5158, 11.4111, 0.1627>
		<-0.4840, 11.4317, 0.1700> <-0.4885, 11.4258, 0.1691> <-0.5021, 11.4106, 0.1713> <-0.5119, 11.4063, 0.1755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4840, 11.4317, 0.1700> <-0.4885, 11.4258, 0.1691> <-0.5021, 11.4106, 0.1713> <-0.5119, 11.4063, 0.1755>
		<-0.4840, 11.4317, 0.1700> <-0.4869, 11.4239, 0.1744> <-0.4986, 11.4063, 0.1828> <-0.5084, 11.4021, 0.1870>
		<-0.4840, 11.4317, 0.1700> <-0.4869, 11.4239, 0.1744> <-0.4969, 11.4039, 0.1770> <-0.4990, 11.4068, 0.1962>
		<-0.4840, 11.4317, 0.1700> <-0.4824, 11.4298, 0.1753> <-0.4798, 11.4265, 0.1805> <-0.4819, 11.4294, 0.1997>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6534, 11.5385, 0.3278> <-0.6593, 11.5433, 0.2891> <-0.6679, 11.5868, 0.2339> <-0.6420, 11.6447, 0.2380>
		<-0.6625, 11.5506, 0.3338> <-0.6684, 11.5554, 0.2951> <-0.6744, 11.5969, 0.2364> <-0.6484, 11.6548, 0.2405>
		<-0.6888, 11.5845, 0.3364> <-0.6905, 11.5861, 0.3232> <-0.6874, 11.6134, 0.2345> <-0.6594, 11.6674, 0.2416>
		<-0.6877, 11.5803, 0.3332> <-0.6893, 11.5819, 0.3200> <-0.6923, 11.6243, 0.2371> <-0.6643, 11.6783, 0.2442>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6534, 11.5385, 0.3278> <-0.6625, 11.5506, 0.3338> <-0.6888, 11.5845, 0.3364> <-0.6877, 11.5803, 0.3332>
		<-0.6480, 11.5341, 0.3628> <-0.6571, 11.5462, 0.3688> <-0.6873, 11.5830, 0.3490> <-0.6861, 11.5788, 0.3458>
		<-0.6297, 11.5904, 0.4108> <-0.6362, 11.6013, 0.4149> <-0.6505, 11.6150, 0.4157> <-0.6582, 11.6253, 0.4196>
		<-0.6151, 11.6228, 0.4131> <-0.6216, 11.6338, 0.4172> <-0.6340, 11.6468, 0.4199> <-0.6417, 11.6571, 0.4238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6151, 11.6228, 0.4131> <-0.6216, 11.6338, 0.4172> <-0.6340, 11.6468, 0.4199> <-0.6417, 11.6571, 0.4238>
		<-0.6024, 11.6513, 0.4151> <-0.6089, 11.6623, 0.4192> <-0.6198, 11.6742, 0.4235> <-0.6275, 11.6845, 0.4274>
		<-0.5772, 11.6938, 0.3698> <-0.5840, 11.7052, 0.3747> <-0.5957, 11.7195, 0.3811> <-0.6039, 11.7306, 0.3841>
		<-0.5819, 11.6976, 0.3392> <-0.5887, 11.7090, 0.3441> <-0.5996, 11.7231, 0.3505> <-0.6078, 11.7342, 0.3535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5819, 11.6976, 0.3392> <-0.5887, 11.7090, 0.3441> <-0.5996, 11.7231, 0.3505> <-0.6078, 11.7342, 0.3535>
		<-0.5874, 11.7021, 0.3033> <-0.5942, 11.7135, 0.3082> <-0.6044, 11.7276, 0.3127> <-0.6126, 11.7387, 0.3157>
		<-0.6180, 11.6981, 0.2418> <-0.6244, 11.7082, 0.2443> <-0.6312, 11.7216, 0.2487> <-0.6362, 11.7326, 0.2513>
		<-0.6420, 11.6447, 0.2380> <-0.6484, 11.6548, 0.2405> <-0.6594, 11.6674, 0.2416> <-0.6643, 11.6783, 0.2442>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8270, 10.9831, 0.1925> <-0.8320, 10.9882, 0.1631> <-0.8237, 11.0173, 0.1182> <-0.7943, 11.0559, 0.1215>
		<-0.8479, 11.0128, 0.2121> <-0.8529, 11.0180, 0.1826> <-0.8469, 11.0486, 0.1331> <-0.8175, 11.0872, 0.1363>
		<-0.8699, 11.0481, 0.2496> <-0.8759, 11.0548, 0.2140> <-0.8769, 11.0800, 0.1557> <-0.8457, 11.1301, 0.1579>
		<-0.8910, 11.0768, 0.2704> <-0.8970, 11.0836, 0.2348> <-0.8984, 11.1114, 0.1728> <-0.8672, 11.1616, 0.1750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8270, 10.9831, 0.1925> <-0.8204, 10.9737, 0.1864> <-0.8144, 10.9652, 0.1933> <-0.8010, 10.9490, 0.1867>
		<-0.8320, 10.9882, 0.1631> <-0.8254, 10.9789, 0.1570> <-0.8277, 10.9814, 0.1398> <-0.8143, 10.9652, 0.1332>
		<-0.8237, 11.0173, 0.1182> <-0.8196, 11.0117, 0.1156> <-0.7802, 11.0315, 0.1159> <-0.7814, 11.0329, 0.1168>
		<-0.7943, 11.0559, 0.1215> <-0.7901, 11.0503, 0.1188> <-0.7754, 11.0377, 0.1161> <-0.7766, 11.0392, 0.1171>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8270, 10.9831, 0.1925> <-0.8212, 10.9772, 0.2263> <-0.7867, 10.9989, 0.2871> <-0.7657, 11.0265, 0.2894>
		<-0.8204, 10.9737, 0.1864> <-0.8147, 10.9678, 0.2202> <-0.7791, 10.9885, 0.2806> <-0.7581, 11.0160, 0.2829>
		<-0.8144, 10.9652, 0.1933> <-0.8021, 10.9502, 0.2428> <-0.7664, 10.9802, 0.2700> <-0.7479, 11.0045, 0.2710>
		<-0.8010, 10.9490, 0.1867> <-0.7887, 10.9341, 0.2362> <-0.7588, 10.9708, 0.2620> <-0.7404, 10.9951, 0.2630>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8270, 10.9831, 0.1925> <-0.8479, 11.0128, 0.2121> <-0.8699, 11.0481, 0.2496> <-0.8910, 11.0768, 0.2704>
		<-0.8212, 10.9772, 0.2263> <-0.8422, 11.0069, 0.2458> <-0.8650, 11.0425, 0.2789> <-0.8861, 11.0713, 0.2997>
		<-0.7867, 10.9989, 0.2871> <-0.8086, 11.0288, 0.3058> <-0.8329, 11.0726, 0.3283> <-0.8543, 11.1035, 0.3458>
		<-0.7657, 11.0265, 0.2894> <-0.7875, 11.0563, 0.3081> <-0.8169, 11.0982, 0.3295> <-0.8384, 11.1291, 0.3470>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7657, 11.0265, 0.2894> <-0.7875, 11.0563, 0.3081> <-0.8169, 11.0982, 0.3295> <-0.8384, 11.1291, 0.3470>
		<-0.7450, 11.0536, 0.2917> <-0.7668, 11.0834, 0.3104> <-0.7997, 11.1259, 0.3307> <-0.8211, 11.1568, 0.3482>
		<-0.7288, 11.0984, 0.2359> <-0.7520, 11.1316, 0.2559> <-0.7786, 11.1738, 0.2888> <-0.8002, 11.2082, 0.3083>
		<-0.7344, 11.1042, 0.2027> <-0.7576, 11.1374, 0.2227> <-0.7839, 11.1798, 0.2571> <-0.8055, 11.2142, 0.2767>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7657, 11.0265, 0.2894> <-0.7450, 11.0536, 0.2917> <-0.7288, 11.0984, 0.2359> <-0.7344, 11.1042, 0.2027>
		<-0.7581, 11.0160, 0.2829> <-0.7374, 11.0431, 0.2851> <-0.7221, 11.0889, 0.2302> <-0.7278, 11.0947, 0.1970>
		<-0.7479, 11.0045, 0.2710> <-0.7289, 11.0295, 0.2720> <-0.7069, 11.0743, 0.2490> <-0.7196, 11.0897, 0.1980>
		<-0.7404, 10.9951, 0.2630> <-0.7213, 11.0201, 0.2640> <-0.6941, 11.0577, 0.2425> <-0.7068, 11.0731, 0.1916>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7344, 11.1042, 0.2027> <-0.7576, 11.1374, 0.2227> <-0.7839, 11.1798, 0.2571> <-0.8055, 11.2142, 0.2767>
		<-0.7397, 11.1096, 0.1719> <-0.7628, 11.1428, 0.1919> <-0.7899, 11.1865, 0.2214> <-0.8115, 11.2210, 0.2409>
		<-0.7634, 11.0962, 0.1248> <-0.7866, 11.1276, 0.1397> <-0.8144, 11.1804, 0.1602> <-0.8359, 11.2118, 0.1773>
		<-0.7943, 11.0559, 0.1215> <-0.8175, 11.0872, 0.1363> <-0.8457, 11.1301, 0.1579> <-0.8672, 11.1616, 0.1750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7344, 11.1042, 0.2027> <-0.7397, 11.1096, 0.1719> <-0.7634, 11.0962, 0.1248> <-0.7943, 11.0559, 0.1215>
		<-0.7278, 11.0947, 0.1970> <-0.7330, 11.1001, 0.1662> <-0.7593, 11.0907, 0.1222> <-0.7901, 11.0503, 0.1188>
		<-0.7196, 11.0897, 0.1980> <-0.7319, 11.1047, 0.1486> <-0.7710, 11.0436, 0.1163> <-0.7754, 11.0377, 0.1161>
		<-0.7068, 11.0731, 0.1916> <-0.7191, 11.0881, 0.1422> <-0.7722, 11.0450, 0.1173> <-0.7766, 11.0392, 0.1171>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8010, 10.9490, 0.1867> <-0.7779, 10.9211, 0.1752> <-0.7697, 10.9110, 0.1685> <-0.7559, 10.8974, 0.1572>
		<-0.8143, 10.9652, 0.1332> <-0.7912, 10.9373, 0.1217> <-0.7774, 10.9199, 0.1362> <-0.7636, 10.9063, 0.1250>
		<-0.7814, 11.0329, 0.1168> <-0.7859, 11.0384, 0.1204> <-0.7786, 10.9545, 0.0768> <-0.7633, 10.9345, 0.0668>
		<-0.7766, 11.0392, 0.1171> <-0.7811, 11.0447, 0.1206> <-0.7446, 10.9979, 0.0806> <-0.7294, 10.9779, 0.0706>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8010, 10.9490, 0.1867> <-0.7887, 10.9341, 0.2362> <-0.7588, 10.9708, 0.2620> <-0.7404, 10.9951, 0.2630>
		<-0.7779, 10.9211, 0.1752> <-0.7656, 10.9061, 0.2247> <-0.7451, 10.9536, 0.2475> <-0.7267, 10.9780, 0.2485>
		<-0.7697, 10.9110, 0.1685> <-0.7638, 10.9041, 0.1932> <-0.7509, 10.9256, 0.2467> <-0.7179, 10.9677, 0.2504>
		<-0.7559, 10.8974, 0.1572> <-0.7500, 10.8905, 0.1820> <-0.7279, 10.8959, 0.2107> <-0.6950, 10.9380, 0.2144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7404, 10.9951, 0.2630> <-0.7213, 11.0201, 0.2640> <-0.6941, 11.0577, 0.2425> <-0.7068, 11.0731, 0.1916>
		<-0.7267, 10.9780, 0.2485> <-0.7077, 11.0030, 0.2495> <-0.6714, 11.0282, 0.2310> <-0.6841, 11.0436, 0.1801>
		<-0.7179, 10.9677, 0.2504> <-0.6846, 11.0104, 0.2542> <-0.6694, 11.0245, 0.2030> <-0.6753, 11.0314, 0.1779>
		<-0.6950, 10.9380, 0.2144> <-0.6616, 10.9807, 0.2182> <-0.6588, 11.0069, 0.1926> <-0.6648, 11.0139, 0.1675>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7068, 11.0731, 0.1916> <-0.7191, 11.0881, 0.1422> <-0.7722, 11.0450, 0.1173> <-0.7766, 11.0392, 0.1171>
		<-0.6841, 11.0436, 0.1801> <-0.6963, 11.0586, 0.1307> <-0.7767, 11.0505, 0.1208> <-0.7811, 11.0447, 0.1206>
		<-0.6753, 11.0314, 0.1779> <-0.6831, 11.0404, 0.1455> <-0.7105, 11.0415, 0.0845> <-0.7446, 10.9979, 0.0806>
		<-0.6648, 11.0139, 0.1675> <-0.6726, 11.0229, 0.1351> <-0.6952, 11.0215, 0.0744> <-0.7294, 10.9779, 0.0706>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7559, 10.8974, 0.1572> <-0.7437, 10.8853, 0.1473> <-0.7293, 10.8732, 0.1280> <-0.7155, 10.8644, 0.1168>
		<-0.7636, 10.9063, 0.1250> <-0.7515, 10.8943, 0.1150> <-0.7361, 10.8810, 0.1051> <-0.7223, 10.8722, 0.0939>
		<-0.7633, 10.9345, 0.0668> <-0.7533, 10.9215, 0.0602> <-0.7300, 10.9138, 0.0595> <-0.7192, 10.8999, 0.0603>
		<-0.7294, 10.9779, 0.0706> <-0.7194, 10.9648, 0.0640> <-0.7049, 10.9453, 0.0621> <-0.6941, 10.9313, 0.0629>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7559, 10.8974, 0.1572> <-0.7500, 10.8905, 0.1820> <-0.7279, 10.8959, 0.2107> <-0.6950, 10.9380, 0.2144>
		<-0.7437, 10.8853, 0.1473> <-0.7378, 10.8785, 0.1720> <-0.7072, 10.8691, 0.1782> <-0.6742, 10.9113, 0.1819>
		<-0.7293, 10.8732, 0.1280> <-0.7240, 10.8671, 0.1457> <-0.7347, 10.8880, 0.2052> <-0.6949, 10.9378, 0.2093>
		<-0.7155, 10.8644, 0.1168> <-0.7102, 10.8583, 0.1345> <-0.7079, 10.8519, 0.1456> <-0.6681, 10.9016, 0.1496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6950, 10.9380, 0.2144> <-0.6616, 10.9807, 0.2182> <-0.6588, 11.0069, 0.1926> <-0.6648, 11.0139, 0.1675>
		<-0.6742, 10.9113, 0.1819> <-0.6409, 10.9539, 0.1857> <-0.6487, 10.9901, 0.1826> <-0.6547, 10.9970, 0.1576>
		<-0.6949, 10.9378, 0.2093> <-0.6545, 10.9884, 0.2134> <-0.6401, 10.9712, 0.1546> <-0.6455, 10.9774, 0.1366>
		<-0.6681, 10.9016, 0.1496> <-0.6276, 10.9523, 0.1538> <-0.6337, 10.9539, 0.1426> <-0.6391, 10.9600, 0.1246>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6648, 11.0139, 0.1675> <-0.6726, 11.0229, 0.1351> <-0.6952, 11.0215, 0.0744> <-0.7294, 10.9779, 0.0706>
		<-0.6547, 10.9970, 0.1576> <-0.6625, 11.0060, 0.1251> <-0.6853, 11.0085, 0.0679> <-0.7194, 10.9648, 0.0640>
		<-0.6455, 10.9774, 0.1366> <-0.6522, 10.9851, 0.1140> <-0.6801, 10.9763, 0.0646> <-0.7049, 10.9453, 0.0621>
		<-0.6391, 10.9600, 0.1246> <-0.6458, 10.9678, 0.1020> <-0.6692, 10.9624, 0.0654> <-0.6941, 10.9313, 0.0629>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7155, 10.8644, 0.1168> <-0.7091, 10.8603, 0.1116> <-0.6980, 10.8526, 0.1061> <-0.6897, 10.8552, 0.1033>
		<-0.7223, 10.8722, 0.0939> <-0.7160, 10.8681, 0.0887> <-0.7020, 10.8570, 0.0911> <-0.6936, 10.8596, 0.0883>
		<-0.7192, 10.8999, 0.0603> <-0.7115, 10.8899, 0.0609> <-0.6917, 10.8881, 0.0676> <-0.6847, 10.8794, 0.0735>
		<-0.6941, 10.9313, 0.0629> <-0.6864, 10.9213, 0.0634> <-0.6759, 10.9085, 0.0690> <-0.6689, 10.8999, 0.0750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7155, 10.8644, 0.1168> <-0.7102, 10.8583, 0.1345> <-0.7079, 10.8519, 0.1456> <-0.6681, 10.9016, 0.1496>
		<-0.7091, 10.8603, 0.1116> <-0.7038, 10.8543, 0.1293> <-0.6972, 10.8374, 0.1218> <-0.6574, 10.8872, 0.1259>
		<-0.6980, 10.8526, 0.1061> <-0.6945, 10.8486, 0.1195> <-0.6797, 10.8657, 0.1435> <-0.6600, 10.8913, 0.1453>
		<-0.6897, 10.8552, 0.1033> <-0.6861, 10.8512, 0.1167> <-0.6751, 10.8591, 0.1246> <-0.6553, 10.8847, 0.1264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6681, 10.9016, 0.1496> <-0.6276, 10.9523, 0.1538> <-0.6337, 10.9539, 0.1426> <-0.6391, 10.9600, 0.1246>
		<-0.6574, 10.8872, 0.1259> <-0.6169, 10.9378, 0.1300> <-0.6305, 10.9453, 0.1367> <-0.6359, 10.9515, 0.1187>
		<-0.6600, 10.8913, 0.1453> <-0.6398, 10.9174, 0.1471> <-0.6276, 10.9341, 0.1257> <-0.6312, 10.9382, 0.1120>
		<-0.6553, 10.8847, 0.1264> <-0.6352, 10.9108, 0.1282> <-0.6297, 10.9241, 0.1221> <-0.6333, 10.9282, 0.1084>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6391, 10.9600, 0.1246> <-0.6458, 10.9678, 0.1020> <-0.6692, 10.9624, 0.0654> <-0.6941, 10.9313, 0.0629>
		<-0.6359, 10.9515, 0.1187> <-0.6427, 10.9592, 0.0961> <-0.6615, 10.9524, 0.0660> <-0.6864, 10.9213, 0.0634>
		<-0.6312, 10.9382, 0.1120> <-0.6352, 10.9426, 0.0972> <-0.6602, 10.9288, 0.0704> <-0.6759, 10.9085, 0.0690>
		<-0.6333, 10.9282, 0.1084> <-0.6372, 10.9326, 0.0935> <-0.6532, 10.9202, 0.0764> <-0.6689, 10.8999, 0.0750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6549, 10.8831, 0.0964> <-0.6535, 10.8814, 0.1019> <-0.6509, 10.8784, 0.1084> <-0.6553, 10.8847, 0.1264>
		<-0.6549, 10.8831, 0.0964> <-0.6473, 10.8894, 0.1024> <-0.6307, 10.9045, 0.1102> <-0.6352, 10.9108, 0.1282>
		<-0.6549, 10.8831, 0.0964> <-0.6473, 10.8894, 0.1024> <-0.6326, 10.9099, 0.1169> <-0.6297, 10.9241, 0.1221>
		<-0.6549, 10.8831, 0.0964> <-0.6488, 10.8910, 0.0970> <-0.6362, 10.9140, 0.1032> <-0.6333, 10.9282, 0.1084>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6549, 10.8831, 0.0964> <-0.6488, 10.8910, 0.0970> <-0.6362, 10.9140, 0.1032> <-0.6333, 10.9282, 0.1084>
		<-0.6549, 10.8831, 0.0964> <-0.6503, 10.8927, 0.0914> <-0.6402, 10.9184, 0.0883> <-0.6372, 10.9326, 0.0935>
		<-0.6549, 10.8831, 0.0964> <-0.6503, 10.8927, 0.0914> <-0.6481, 10.9140, 0.0808> <-0.6532, 10.9202, 0.0764>
		<-0.6549, 10.8831, 0.0964> <-0.6564, 10.8847, 0.0908> <-0.6638, 10.8936, 0.0793> <-0.6689, 10.8999, 0.0750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6549, 10.8831, 0.0964> <-0.6564, 10.8847, 0.0908> <-0.6638, 10.8936, 0.0793> <-0.6689, 10.8999, 0.0750>
		<-0.6549, 10.8831, 0.0964> <-0.6618, 10.8777, 0.0904> <-0.6796, 10.8732, 0.0779> <-0.6847, 10.8794, 0.0735>
		<-0.6549, 10.8831, 0.0964> <-0.6618, 10.8777, 0.0904> <-0.6813, 10.8634, 0.0842> <-0.6936, 10.8596, 0.0883>
		<-0.6549, 10.8831, 0.0964> <-0.6603, 10.8761, 0.0959> <-0.6774, 10.8590, 0.0992> <-0.6897, 10.8552, 0.1033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6549, 10.8831, 0.0964> <-0.6603, 10.8761, 0.0959> <-0.6774, 10.8590, 0.0992> <-0.6897, 10.8552, 0.1033>
		<-0.6549, 10.8831, 0.0964> <-0.6589, 10.8745, 0.1014> <-0.6738, 10.8550, 0.1125> <-0.6861, 10.8512, 0.1167>
		<-0.6549, 10.8831, 0.0964> <-0.6589, 10.8745, 0.1014> <-0.6706, 10.8528, 0.1066> <-0.6751, 10.8591, 0.1246>
		<-0.6549, 10.8831, 0.0964> <-0.6535, 10.8814, 0.1019> <-0.6509, 10.8784, 0.1084> <-0.6553, 10.8847, 0.1264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8910, 11.0768, 0.2704> <-0.8970, 11.0836, 0.2348> <-0.8984, 11.1114, 0.1728> <-0.8672, 11.1616, 0.1750>
		<-0.8958, 11.0833, 0.2751> <-0.9018, 11.0901, 0.2395> <-0.9068, 11.1236, 0.1794> <-0.8755, 11.1738, 0.1817>
		<-0.9123, 11.0993, 0.2775> <-0.9127, 11.0997, 0.2741> <-0.9108, 11.1362, 0.1909> <-0.8848, 11.1885, 0.1957>
		<-0.9121, 11.0989, 0.2762> <-0.9125, 11.0993, 0.2729> <-0.9195, 11.1489, 0.1957> <-0.8936, 11.2012, 0.2005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8910, 11.0768, 0.2704> <-0.8958, 11.0833, 0.2751> <-0.9123, 11.0993, 0.2775> <-0.9121, 11.0989, 0.2762>
		<-0.8861, 11.0713, 0.2997> <-0.8909, 11.0778, 0.3044> <-0.9118, 11.0989, 0.2810> <-0.9116, 11.0985, 0.2797>
		<-0.8543, 11.1035, 0.3458> <-0.8649, 11.1187, 0.3544> <-0.8790, 11.1316, 0.3632> <-0.8893, 11.1461, 0.3732>
		<-0.8384, 11.1291, 0.3470> <-0.8489, 11.1443, 0.3556> <-0.8620, 11.1658, 0.3663> <-0.8724, 11.1802, 0.3763>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8384, 11.1291, 0.3470> <-0.8489, 11.1443, 0.3556> <-0.8620, 11.1658, 0.3663> <-0.8724, 11.1802, 0.3763>
		<-0.8211, 11.1568, 0.3482> <-0.8317, 11.1720, 0.3568> <-0.8465, 11.1971, 0.3691> <-0.8569, 11.2115, 0.3792>
		<-0.8002, 11.2082, 0.3083> <-0.8081, 11.2208, 0.3154> <-0.8337, 11.2614, 0.2948> <-0.8315, 11.2595, 0.2954>
		<-0.8055, 11.2142, 0.2767> <-0.8134, 11.2268, 0.2838> <-0.8342, 11.2619, 0.2902> <-0.8320, 11.2600, 0.2908>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8055, 11.2142, 0.2767> <-0.8134, 11.2268, 0.2838> <-0.8342, 11.2619, 0.2902> <-0.8320, 11.2600, 0.2908>
		<-0.8115, 11.2210, 0.2409> <-0.8193, 11.2335, 0.2480> <-0.8347, 11.2625, 0.2857> <-0.8326, 11.2606, 0.2863>
		<-0.8359, 11.2118, 0.1773> <-0.8443, 11.2240, 0.1839> <-0.8597, 11.2389, 0.2003> <-0.8685, 11.2517, 0.2050>
		<-0.8672, 11.1616, 0.1750> <-0.8755, 11.1738, 0.1817> <-0.8848, 11.1885, 0.1957> <-0.8936, 11.2012, 0.2005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0199, 10.9052, 0.1979> <-1.0263, 10.9109, 0.1601> <-0.9944, 10.9379, 0.1065> <-0.9514, 10.9827, 0.1089>
		<-1.0493, 10.9390, 0.2142> <-1.0557, 10.9446, 0.1765> <-1.0075, 10.9547, 0.1194> <-0.9646, 10.9996, 0.1217>
		<-1.0852, 10.9805, 0.2475> <-1.0930, 10.9864, 0.2018> <-0.9866, 11.0119, 0.1522> <-0.9717, 11.0181, 0.1531>
		<-1.1132, 11.0150, 0.2647> <-1.1210, 11.0209, 0.2190> <-1.0011, 11.0301, 0.1610> <-0.9861, 11.0364, 0.1619>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0199, 10.9052, 0.1979> <-1.0010, 10.8834, 0.1873> <-0.9867, 10.8682, 0.1898> <-0.9529, 10.8309, 0.1756>
		<-1.0263, 10.9109, 0.1601> <-1.0073, 10.8891, 0.1496> <-1.0062, 10.8910, 0.1228> <-0.9725, 10.8537, 0.1087>
		<-0.9944, 10.9379, 0.1065> <-0.9880, 10.9298, 0.1004> <-0.9267, 10.9450, 0.0984> <-0.9287, 10.9475, 0.0999>
		<-0.9514, 10.9827, 0.1089> <-0.9451, 10.9747, 0.1027> <-0.9211, 10.9534, 0.0990> <-0.9231, 10.9559, 0.1005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0199, 10.9052, 0.1979> <-1.0123, 10.8984, 0.2432> <-0.9485, 10.9180, 0.3147> <-0.9164, 10.9516, 0.3164>
		<-1.0010, 10.8834, 0.1873> <-0.9933, 10.8766, 0.2327> <-0.9369, 10.9013, 0.3000> <-0.9048, 10.9349, 0.3018>
		<-0.9867, 10.8682, 0.1898> <-0.9685, 10.8470, 0.2518> <-0.9092, 10.8832, 0.2780> <-0.8876, 10.9157, 0.2802>
		<-0.9529, 10.8309, 0.1756> <-0.9348, 10.8098, 0.2376> <-0.8963, 10.8669, 0.2640> <-0.8746, 10.8994, 0.2662>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0199, 10.9052, 0.1979> <-1.0493, 10.9390, 0.2142> <-1.0852, 10.9805, 0.2475> <-1.1132, 11.0150, 0.2647>
		<-1.0123, 10.8984, 0.2432> <-1.0417, 10.9322, 0.2596> <-1.0763, 10.9738, 0.2999> <-1.1043, 11.0082, 0.3172>
		<-0.9485, 10.9180, 0.3147> <-0.9601, 10.9346, 0.3293> <-0.9875, 10.9729, 0.3484> <-1.0013, 10.9897, 0.3607>
		<-0.9164, 10.9516, 0.3164> <-0.9280, 10.9682, 0.3310> <-0.9381, 10.9935, 0.3513> <-0.9518, 11.0103, 0.3636>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9164, 10.9516, 0.3164> <-0.9280, 10.9682, 0.3310> <-0.9381, 10.9935, 0.3513> <-0.9518, 11.0103, 0.3636>
		<-0.8863, 10.9831, 0.3181> <-0.8978, 10.9997, 0.3327> <-0.9040, 11.0077, 0.3532> <-0.9177, 11.0245, 0.3655>
		<-0.8725, 11.0453, 0.2481> <-0.8850, 11.0636, 0.2641> <-0.9109, 11.0971, 0.2760> <-0.9115, 11.0984, 0.2796>
		<-0.8797, 11.0517, 0.2055> <-0.8921, 11.0700, 0.2215> <-0.9114, 11.0975, 0.2727> <-0.9121, 11.0989, 0.2762>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9164, 10.9516, 0.3164> <-0.8863, 10.9831, 0.3181> <-0.8725, 11.0453, 0.2481> <-0.8797, 11.0517, 0.2055>
		<-0.9048, 10.9349, 0.3018> <-0.8747, 10.9663, 0.3034> <-0.8631, 11.0315, 0.2359> <-0.8703, 11.0379, 0.1934>
		<-0.8876, 10.9157, 0.2802> <-0.8672, 10.9462, 0.2823> <-0.8466, 11.0026, 0.2564> <-0.8636, 11.0225, 0.1981>
		<-0.8746, 10.8994, 0.2662> <-0.8543, 10.9299, 0.2683> <-0.8255, 10.9768, 0.2451> <-0.8425, 10.9967, 0.1868>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8797, 11.0517, 0.2055> <-0.8921, 11.0700, 0.2215> <-0.9114, 11.0975, 0.2727> <-0.9121, 11.0989, 0.2762>
		<-0.8862, 11.0575, 0.1672> <-0.8986, 11.0758, 0.1832> <-0.9121, 11.0980, 0.2688> <-0.9127, 11.0994, 0.2724>
		<-0.9078, 11.0283, 0.1113> <-0.9209, 11.0452, 0.1241> <-0.9581, 11.0238, 0.1539> <-0.9725, 11.0420, 0.1627>
		<-0.9514, 10.9827, 0.1089> <-0.9646, 10.9996, 0.1217> <-0.9717, 11.0181, 0.1531> <-0.9861, 11.0364, 0.1619>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8797, 11.0517, 0.2055> <-0.8862, 11.0575, 0.1672> <-0.9078, 11.0283, 0.1113> <-0.9514, 10.9827, 0.1089>
		<-0.8703, 11.0379, 0.1934> <-0.8767, 11.0436, 0.1551> <-0.9015, 11.0203, 0.1051> <-0.9451, 10.9747, 0.1027>
		<-0.8636, 11.0225, 0.1981> <-0.8801, 11.0417, 0.1419> <-0.9164, 10.9605, 0.0995> <-0.9211, 10.9534, 0.0990>
		<-0.8425, 10.9967, 0.1868> <-0.8590, 11.0159, 0.1306> <-0.9184, 10.9629, 0.1009> <-0.9231, 10.9559, 0.1005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9529, 10.8309, 0.1756> <-0.9223, 10.7971, 0.1628> <-0.9120, 10.7845, 0.1556> <-0.8939, 10.7661, 0.1450>
		<-0.9725, 10.8537, 0.1087> <-0.9419, 10.8200, 0.0959> <-0.9207, 10.7939, 0.1148> <-0.9027, 10.7755, 0.1043>
		<-0.9287, 10.9475, 0.0999> <-0.9352, 10.9552, 0.1045> <-0.9168, 10.8403, 0.0490> <-0.8949, 10.8113, 0.0377>
		<-0.9231, 10.9559, 0.1005> <-0.9296, 10.9636, 0.1051> <-0.8773, 10.8965, 0.0514> <-0.8555, 10.8675, 0.0402>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9529, 10.8309, 0.1756> <-0.9348, 10.8098, 0.2376> <-0.8963, 10.8669, 0.2640> <-0.8746, 10.8994, 0.2662>
		<-0.9223, 10.7971, 0.1628> <-0.9042, 10.7760, 0.2248> <-0.8799, 10.8461, 0.2462> <-0.8583, 10.8786, 0.2484>
		<-0.9120, 10.7845, 0.1556> <-0.9052, 10.7771, 0.1873> <-0.8886, 10.8137, 0.2449> <-0.8496, 10.8692, 0.2473>
		<-0.8939, 10.7661, 0.1450> <-0.8871, 10.7587, 0.1768> <-0.8578, 10.7727, 0.2082> <-0.8189, 10.8281, 0.2106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8746, 10.8994, 0.2662> <-0.8543, 10.9299, 0.2683> <-0.8255, 10.9768, 0.2451> <-0.8425, 10.9967, 0.1868>
		<-0.8583, 10.8786, 0.2484> <-0.8379, 10.9092, 0.2505> <-0.7953, 10.9399, 0.2291> <-0.8124, 10.9598, 0.1708>
		<-0.8496, 10.8692, 0.2473> <-0.8088, 10.9273, 0.2499> <-0.7880, 10.9439, 0.1966> <-0.7952, 10.9516, 0.1633>
		<-0.8189, 10.8281, 0.2106> <-0.7781, 10.8863, 0.2132> <-0.7723, 10.9214, 0.1855> <-0.7795, 10.9291, 0.1522>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8425, 10.9967, 0.1868> <-0.8590, 11.0159, 0.1306> <-0.9184, 10.9629, 0.1009> <-0.9231, 10.9559, 0.1005>
		<-0.8124, 10.9598, 0.1708> <-0.8288, 10.9789, 0.1146> <-0.9249, 10.9707, 0.1055> <-0.9296, 10.9636, 0.1051>
		<-0.7952, 10.9516, 0.1633> <-0.8038, 10.9609, 0.1232> <-0.8384, 10.9519, 0.0539> <-0.8773, 10.8965, 0.0514>
		<-0.7795, 10.9291, 0.1522> <-0.7881, 10.9384, 0.1120> <-0.8166, 10.9229, 0.0426> <-0.8555, 10.8675, 0.0402>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8939, 10.7661, 0.1450> <-0.8744, 10.7461, 0.1336> <-0.8497, 10.7205, 0.1142> <-0.8278, 10.7033, 0.1026>
		<-0.9027, 10.7755, 0.1043> <-0.8831, 10.7555, 0.0928> <-0.8583, 10.7299, 0.0847> <-0.8364, 10.7128, 0.0730>
		<-0.8949, 10.8113, 0.0377> <-0.8785, 10.7895, 0.0292> <-0.8463, 10.7718, 0.0322> <-0.8291, 10.7490, 0.0346>
		<-0.8555, 10.8675, 0.0402> <-0.8390, 10.8457, 0.0317> <-0.8160, 10.8137, 0.0338> <-0.7989, 10.7910, 0.0363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8939, 10.7661, 0.1450> <-0.8871, 10.7587, 0.1768> <-0.8578, 10.7727, 0.2082> <-0.8189, 10.8281, 0.2106>
		<-0.8744, 10.7461, 0.1336> <-0.8676, 10.7388, 0.1654> <-0.8254, 10.7295, 0.1696> <-0.7865, 10.7850, 0.1721>
		<-0.8497, 10.7205, 0.1142> <-0.8429, 10.7132, 0.1373> <-0.8658, 10.7593, 0.2014> <-0.8176, 10.8261, 0.2040>
		<-0.8278, 10.7033, 0.1026> <-0.8210, 10.6960, 0.1256> <-0.8169, 10.6912, 0.1372> <-0.7687, 10.7580, 0.1398>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8189, 10.8281, 0.2106> <-0.7781, 10.8863, 0.2132> <-0.7723, 10.9214, 0.1855> <-0.7795, 10.9291, 0.1522>
		<-0.7865, 10.7850, 0.1721> <-0.7457, 10.8431, 0.1746> <-0.7544, 10.8956, 0.1727> <-0.7615, 10.9033, 0.1394>
		<-0.8176, 10.8261, 0.2040> <-0.7671, 10.8961, 0.2068> <-0.7369, 10.8582, 0.1442> <-0.7439, 10.8659, 0.1200>
		<-0.7687, 10.7580, 0.1398> <-0.7181, 10.8280, 0.1425> <-0.7243, 10.8291, 0.1319> <-0.7314, 10.8368, 0.1078>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7795, 10.9291, 0.1522> <-0.7881, 10.9384, 0.1120> <-0.8166, 10.9229, 0.0426> <-0.8555, 10.8675, 0.0402>
		<-0.7615, 10.9033, 0.1394> <-0.7702, 10.9126, 0.0992> <-0.8002, 10.9011, 0.0341> <-0.8390, 10.8457, 0.0317>
		<-0.7439, 10.8659, 0.1200> <-0.7522, 10.8749, 0.0918> <-0.7871, 10.8537, 0.0354> <-0.8160, 10.8137, 0.0338>
		<-0.7314, 10.8368, 0.1078> <-0.7396, 10.8458, 0.0796> <-0.7700, 10.8310, 0.0378> <-0.7989, 10.7910, 0.0363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8278, 10.7033, 0.1026> <-0.8177, 10.6954, 0.0972> <-0.8016, 10.6809, 0.0922> <-0.7884, 10.6832, 0.0888>
		<-0.8364, 10.7128, 0.0730> <-0.8263, 10.7048, 0.0676> <-0.8065, 10.6860, 0.0725> <-0.7932, 10.6883, 0.0691>
		<-0.8291, 10.7490, 0.0346> <-0.8176, 10.7337, 0.0363> <-0.7908, 10.7282, 0.0446> <-0.7800, 10.7146, 0.0529>
		<-0.7989, 10.7910, 0.0363> <-0.7873, 10.7756, 0.0379> <-0.7716, 10.7559, 0.0454> <-0.7608, 10.7423, 0.0537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8278, 10.7033, 0.1026> <-0.8210, 10.6960, 0.1256> <-0.8169, 10.6912, 0.1372> <-0.7687, 10.7580, 0.1398>
		<-0.8177, 10.6954, 0.0972> <-0.8110, 10.6881, 0.1203> <-0.7966, 10.6629, 0.1105> <-0.7484, 10.7298, 0.1132>
		<-0.8016, 10.6809, 0.0922> <-0.7973, 10.6763, 0.1099> <-0.7805, 10.7076, 0.1373> <-0.7566, 10.7420, 0.1383>
		<-0.7884, 10.6832, 0.0888> <-0.7840, 10.6787, 0.1064> <-0.7697, 10.6920, 0.1138> <-0.7458, 10.7265, 0.1147>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7687, 10.7580, 0.1398> <-0.7181, 10.8280, 0.1425> <-0.7243, 10.8291, 0.1319> <-0.7314, 10.8368, 0.1078>
		<-0.7484, 10.7298, 0.1132> <-0.6978, 10.7997, 0.1159> <-0.7182, 10.8148, 0.1259> <-0.7252, 10.8225, 0.1018>
		<-0.7566, 10.7420, 0.1383> <-0.7315, 10.7782, 0.1393> <-0.7116, 10.7968, 0.1139> <-0.7161, 10.8016, 0.0955>
		<-0.7458, 10.7265, 0.1147> <-0.7207, 10.7627, 0.1158> <-0.7130, 10.7806, 0.1102> <-0.7175, 10.7853, 0.0917>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7314, 10.8368, 0.1078> <-0.7396, 10.8458, 0.0796> <-0.7700, 10.8310, 0.0378> <-0.7989, 10.7910, 0.0363>
		<-0.7252, 10.8225, 0.1018> <-0.7335, 10.8315, 0.0735> <-0.7584, 10.8157, 0.0395> <-0.7873, 10.7756, 0.0379>
		<-0.7161, 10.8016, 0.0955> <-0.7209, 10.8065, 0.0763> <-0.7530, 10.7828, 0.0462> <-0.7716, 10.7559, 0.0454>
		<-0.7175, 10.7853, 0.0917> <-0.7222, 10.7903, 0.0725> <-0.7422, 10.7692, 0.0544> <-0.7608, 10.7423, 0.0537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7415, 10.7187, 0.0803> <-0.7399, 10.7170, 0.0869> <-0.7375, 10.7145, 0.0967> <-0.7458, 10.7265, 0.1147>
		<-0.7415, 10.7187, 0.0803> <-0.7319, 10.7285, 0.0872> <-0.7124, 10.7507, 0.0977> <-0.7207, 10.7627, 0.1158>
		<-0.7415, 10.7187, 0.0803> <-0.7319, 10.7285, 0.0872> <-0.7148, 10.7597, 0.1053> <-0.7130, 10.7806, 0.1102>
		<-0.7415, 10.7187, 0.0803> <-0.7335, 10.7302, 0.0806> <-0.7193, 10.7644, 0.0868> <-0.7175, 10.7853, 0.0917>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7415, 10.7187, 0.0803> <-0.7335, 10.7302, 0.0806> <-0.7193, 10.7644, 0.0868> <-0.7175, 10.7853, 0.0917>
		<-0.7415, 10.7187, 0.0803> <-0.7353, 10.7322, 0.0732> <-0.7240, 10.7694, 0.0676> <-0.7222, 10.7903, 0.0725>
		<-0.7415, 10.7187, 0.0803> <-0.7353, 10.7322, 0.0732> <-0.7353, 10.7606, 0.0597> <-0.7422, 10.7692, 0.0544>
		<-0.7415, 10.7187, 0.0803> <-0.7433, 10.7206, 0.0729> <-0.7540, 10.7337, 0.0589> <-0.7608, 10.7423, 0.0537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7415, 10.7187, 0.0803> <-0.7433, 10.7206, 0.0729> <-0.7540, 10.7337, 0.0589> <-0.7608, 10.7423, 0.0537>
		<-0.7415, 10.7187, 0.0803> <-0.7499, 10.7111, 0.0726> <-0.7732, 10.7060, 0.0581> <-0.7800, 10.7146, 0.0529>
		<-0.7415, 10.7187, 0.0803> <-0.7499, 10.7111, 0.0726> <-0.7762, 10.6914, 0.0647> <-0.7932, 10.6883, 0.0691>
		<-0.7415, 10.7187, 0.0803> <-0.7481, 10.7091, 0.0801> <-0.7714, 10.6863, 0.0844> <-0.7884, 10.6832, 0.0888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7415, 10.7187, 0.0803> <-0.7481, 10.7091, 0.0801> <-0.7714, 10.6863, 0.0844> <-0.7884, 10.6832, 0.0888>
		<-0.7415, 10.7187, 0.0803> <-0.7465, 10.7075, 0.0866> <-0.7670, 10.6817, 0.1021> <-0.7840, 10.6787, 0.1064>
		<-0.7415, 10.7187, 0.0803> <-0.7465, 10.7075, 0.0866> <-0.7614, 10.6800, 0.0957> <-0.7697, 10.6920, 0.1138>
		<-0.7415, 10.7187, 0.0803> <-0.7399, 10.7170, 0.0869> <-0.7375, 10.7145, 0.0967> <-0.7458, 10.7265, 0.1147>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1132, 11.0150, 0.2647> <-1.1210, 11.0209, 0.2190> <-1.0011, 11.0301, 0.1610> <-0.9861, 11.0364, 0.1619>
		<-1.1477, 11.0574, 0.2859> <-1.1554, 11.0633, 0.2402> <-1.0350, 11.0730, 0.1816> <-1.0201, 11.0792, 0.1825>
		<-1.1986, 11.1154, 0.3030> <-1.1963, 11.1116, 0.2519> <-1.1197, 11.1212, 0.2047> <-1.0764, 11.1379, 0.1829>
		<-1.2277, 11.1609, 0.3256> <-1.2255, 11.1571, 0.2745> <-1.1522, 11.1647, 0.2263> <-1.1088, 11.1815, 0.2045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1132, 11.0150, 0.2647> <-1.1477, 11.0574, 0.2859> <-1.1986, 11.1154, 0.3030> <-1.2277, 11.1609, 0.3256>
		<-1.1043, 11.0082, 0.3172> <-1.1388, 11.0506, 0.3383> <-1.2014, 11.1201, 0.3654> <-1.2306, 11.1656, 0.3881>
		<-1.0013, 10.9897, 0.3607> <-1.0495, 11.0487, 0.4039> <-1.1226, 11.1279, 0.4373> <-1.1758, 11.1880, 0.4724>
		<-0.9518, 11.0103, 0.3636> <-1.0000, 11.0693, 0.4067> <-1.0690, 11.1436, 0.4656> <-1.1221, 11.2037, 0.5007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9518, 11.0103, 0.3636> <-1.0000, 11.0693, 0.4067> <-1.0690, 11.1436, 0.4656> <-1.1221, 11.2037, 0.5007>
		<-0.9177, 11.0245, 0.3655> <-0.9659, 11.0836, 0.4087> <-1.0358, 11.1533, 0.4832> <-1.0889, 11.2134, 0.5183>
		<-0.9115, 11.0984, 0.2796> <-0.9112, 11.0977, 0.2894> <-1.0072, 11.1656, 0.4059> <-1.0425, 11.2062, 0.4487>
		<-0.9121, 11.0989, 0.2762> <-0.9117, 11.0981, 0.2860> <-0.9739, 11.1842, 0.3983> <-1.0092, 11.2248, 0.4410>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8724, 11.1802, 0.3763> <-0.8893, 11.1461, 0.3732> <-0.9116, 11.0985, 0.2797> <-0.9121, 11.0989, 0.2762>
		<-0.8980, 11.2158, 0.4011> <-0.9149, 11.1816, 0.3980> <-0.9113, 11.0977, 0.2895> <-0.9117, 11.0981, 0.2860>
		<-0.9305, 11.2632, 0.4362> <-0.9459, 11.2410, 0.4365> <-0.9508, 11.1972, 0.3930> <-0.9739, 11.1842, 0.3983>
		<-0.9581, 11.2956, 0.4631> <-0.9735, 11.2734, 0.4634> <-0.9861, 11.2378, 0.4357> <-1.0092, 11.2248, 0.4410>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8724, 11.1802, 0.3763> <-0.8980, 11.2158, 0.4011> <-0.9305, 11.2632, 0.4362> <-0.9581, 11.2956, 0.4631>
		<-0.8569, 11.2115, 0.3792> <-0.8824, 11.2471, 0.4040> <-0.9167, 11.2829, 0.4358> <-0.9443, 11.3153, 0.4627>
		<-0.8315, 11.2595, 0.2954> <-0.8312, 11.2586, 0.3059> <-0.9020, 11.3031, 0.4017> <-0.9295, 11.3395, 0.4393>
		<-0.8320, 11.2600, 0.2908> <-0.8317, 11.2591, 0.3014> <-0.8883, 11.3229, 0.4013> <-0.9158, 11.3593, 0.4389>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7803, 11.3206, 0.3913> <-0.7979, 11.2893, 0.3858> <-0.8315, 11.2595, 0.2955> <-0.8320, 11.2600, 0.2908>
		<-0.8047, 11.3546, 0.4118> <-0.8222, 11.3233, 0.4063> <-0.8312, 11.2586, 0.3061> <-0.8317, 11.2591, 0.3014>
		<-0.8395, 11.3995, 0.4371> <-0.8555, 11.3767, 0.4358> <-0.8724, 11.3458, 0.4008> <-0.8883, 11.3229, 0.4013>
		<-0.8629, 11.4327, 0.4601> <-0.8789, 11.4099, 0.4588> <-0.8999, 11.3822, 0.4384> <-0.9158, 11.3593, 0.4389>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7803, 11.3206, 0.3913> <-0.8047, 11.3546, 0.4118> <-0.8395, 11.3995, 0.4371> <-0.8629, 11.4327, 0.4601>
		<-0.7643, 11.3493, 0.3963> <-0.7887, 11.3833, 0.4168> <-0.8266, 11.4181, 0.4381> <-0.8499, 11.4512, 0.4611>
		<-0.7500, 11.4055, 0.3202> <-0.7496, 11.4050, 0.3285> <-0.8110, 11.4413, 0.4148> <-0.8342, 11.4756, 0.4456>
		<-0.7504, 11.4059, 0.3165> <-0.7500, 11.4054, 0.3248> <-0.7981, 11.4599, 0.4154> <-0.8213, 11.4942, 0.4462>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7094, 11.4810, 0.4234> <-0.7224, 11.4446, 0.4199> <-0.7500, 11.4053, 0.3208> <-0.7504, 11.4059, 0.3165>
		<-0.7283, 11.5038, 0.4372> <-0.7414, 11.4674, 0.4337> <-0.7496, 11.4049, 0.3291> <-0.7500, 11.4054, 0.3248>
		<-0.7581, 11.5333, 0.4506> <-0.7751, 11.5162, 0.4498> <-0.7843, 11.4796, 0.4159> <-0.7981, 11.4599, 0.4154>
		<-0.7756, 11.5576, 0.4638> <-0.7925, 11.5406, 0.4630> <-0.8075, 11.5139, 0.4468> <-0.8213, 11.4942, 0.4462>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7094, 11.4810, 0.4234> <-0.7283, 11.5038, 0.4372> <-0.7581, 11.5333, 0.4506> <-0.7756, 11.5576, 0.4638>
		<-0.6964, 11.5171, 0.4269> <-0.7153, 11.5399, 0.4407> <-0.7412, 11.5503, 0.4514> <-0.7586, 11.5746, 0.4645>
		<-0.6864, 11.5786, 0.3467> <-0.6860, 11.5776, 0.3589> <-0.7084, 11.5602, 0.4324> <-0.7254, 11.5847, 0.4539>
		<-0.6877, 11.5803, 0.3332> <-0.6872, 11.5794, 0.3455> <-0.6947, 11.5798, 0.4296> <-0.7118, 11.6043, 0.4511>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6417, 11.6571, 0.4238> <-0.6582, 11.6253, 0.4196> <-0.6861, 11.5788, 0.3458> <-0.6877, 11.5803, 0.3332>
		<-0.6519, 11.6707, 0.4289> <-0.6684, 11.6389, 0.4247> <-0.6856, 11.5779, 0.3580> <-0.6872, 11.5794, 0.3455>
		<-0.6646, 11.6884, 0.4390> <-0.6768, 11.6632, 0.4535> <-0.6769, 11.6055, 0.4259> <-0.6947, 11.5798, 0.4296>
		<-0.6749, 11.7023, 0.4431> <-0.6871, 11.6771, 0.4575> <-0.6939, 11.6300, 0.4474> <-0.7118, 11.6043, 0.4511>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6417, 11.6571, 0.4238> <-0.6519, 11.6707, 0.4289> <-0.6646, 11.6884, 0.4390> <-0.6749, 11.7023, 0.4431>
		<-0.6275, 11.6845, 0.4274> <-0.6377, 11.6981, 0.4325> <-0.6512, 11.7159, 0.4232> <-0.6615, 11.7298, 0.4273>
		<-0.6039, 11.7306, 0.3841> <-0.6111, 11.7403, 0.3868> <-0.6249, 11.7529, 0.3916> <-0.6324, 11.7627, 0.3921>
		<-0.6078, 11.7342, 0.3535> <-0.6150, 11.7439, 0.3561> <-0.6254, 11.7569, 0.3574> <-0.6330, 11.7666, 0.3579>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6078, 11.7342, 0.3535> <-0.6150, 11.7439, 0.3561> <-0.6254, 11.7569, 0.3574> <-0.6330, 11.7666, 0.3579>
		<-0.6126, 11.7387, 0.3157> <-0.6198, 11.7484, 0.3184> <-0.6260, 11.7609, 0.3221> <-0.6336, 11.7707, 0.3226>
		<-0.6362, 11.7326, 0.2513> <-0.6422, 11.7457, 0.2544> <-0.6549, 11.7371, 0.2766> <-0.6630, 11.7494, 0.2764>
		<-0.6643, 11.6783, 0.2442> <-0.6703, 11.6914, 0.2473> <-0.6699, 11.7115, 0.2570> <-0.6780, 11.7238, 0.2568>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6643, 11.6783, 0.2442> <-0.6703, 11.6914, 0.2473> <-0.6699, 11.7115, 0.2570> <-0.6780, 11.7238, 0.2568>
		<-0.6923, 11.6243, 0.2371> <-0.6983, 11.6374, 0.2402> <-0.6841, 11.6872, 0.2385> <-0.6922, 11.6995, 0.2383>
		<-0.6893, 11.5819, 0.3200> <-0.6897, 11.5826, 0.3099> <-0.6831, 11.6241, 0.2589> <-0.6996, 11.6472, 0.2484>
		<-0.6877, 11.5803, 0.3332> <-0.6880, 11.5811, 0.3232> <-0.7024, 11.5966, 0.2561> <-0.7189, 11.6198, 0.2456>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6877, 11.5803, 0.3332> <-0.6880, 11.5811, 0.3232> <-0.7024, 11.5966, 0.2561> <-0.7189, 11.6198, 0.2456>
		<-0.6888, 11.5819, 0.3206> <-0.6892, 11.5827, 0.3105> <-0.7163, 11.5770, 0.2541> <-0.7328, 11.6001, 0.2436>
		<-0.7070, 11.5598, 0.2422> <-0.7232, 11.5803, 0.2479> <-0.7515, 11.5687, 0.2406> <-0.7673, 11.5902, 0.2424>
		<-0.7267, 11.5050, 0.2369> <-0.7429, 11.5256, 0.2427> <-0.7684, 11.5515, 0.2397> <-0.7843, 11.5731, 0.2414>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7267, 11.5050, 0.2369> <-0.7429, 11.5256, 0.2427> <-0.7684, 11.5515, 0.2397> <-0.7843, 11.5731, 0.2414>
		<-0.7465, 11.4498, 0.2316> <-0.7627, 11.4704, 0.2374> <-0.7858, 11.5338, 0.2387> <-0.8017, 11.5553, 0.2404>
		<-0.7508, 11.4064, 0.3125> <-0.7512, 11.4068, 0.3052> <-0.7906, 11.4898, 0.2436> <-0.8175, 11.5255, 0.2394>
		<-0.7504, 11.4059, 0.3165> <-0.7508, 11.4063, 0.3093> <-0.8048, 11.4694, 0.2434> <-0.8317, 11.5051, 0.2392>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7504, 11.4059, 0.3165> <-0.7508, 11.4063, 0.3093> <-0.8048, 11.4694, 0.2434> <-0.8317, 11.5051, 0.2392>
		<-0.7509, 11.4063, 0.3124> <-0.7513, 11.4067, 0.3052> <-0.8174, 11.4512, 0.2432> <-0.8444, 11.4869, 0.2391>
		<-0.7721, 11.3919, 0.2242> <-0.7934, 11.4225, 0.2353> <-0.8387, 11.4319, 0.2334> <-0.8612, 11.4626, 0.2413>
		<-0.8008, 11.3406, 0.2152> <-0.8221, 11.3712, 0.2262> <-0.8514, 11.4138, 0.2324> <-0.8739, 11.4444, 0.2403>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8008, 11.3406, 0.2152> <-0.8221, 11.3712, 0.2262> <-0.8514, 11.4138, 0.2324> <-0.8739, 11.4444, 0.2403>
		<-0.8261, 11.2955, 0.2072> <-0.8474, 11.3260, 0.2183> <-0.8656, 11.3935, 0.2313> <-0.8881, 11.4242, 0.2392>
		<-0.8325, 11.2605, 0.2866> <-0.8327, 11.2612, 0.2781> <-0.8791, 11.3591, 0.2322> <-0.9071, 11.3975, 0.2336>
		<-0.8320, 11.2600, 0.2908> <-0.8323, 11.2607, 0.2823> <-0.8933, 11.3389, 0.2308> <-0.9214, 11.3773, 0.2322>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8320, 11.2600, 0.2908> <-0.8323, 11.2607, 0.2823> <-0.8933, 11.3389, 0.2308> <-0.9214, 11.3773, 0.2322>
		<-0.8326, 11.2606, 0.2863> <-0.8328, 11.2613, 0.2778> <-0.9076, 11.3185, 0.2293> <-0.9356, 11.3570, 0.2307>
		<-0.8685, 11.2517, 0.2050> <-0.8905, 11.2836, 0.2170> <-0.9315, 11.2978, 0.2225> <-0.9545, 11.3296, 0.2325>
		<-0.8936, 11.2012, 0.2005> <-0.9155, 11.2331, 0.2125> <-0.9458, 11.2775, 0.2206> <-0.9688, 11.3093, 0.2306>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8936, 11.2012, 0.2005> <-0.9155, 11.2331, 0.2125> <-0.9458, 11.2775, 0.2206> <-0.9688, 11.3093, 0.2306>
		<-0.9195, 11.1489, 0.1957> <-0.9415, 11.1808, 0.2077> <-0.9600, 11.2573, 0.2186> <-0.9831, 11.2891, 0.2286>
		<-0.9125, 11.0993, 0.2729> <-0.9127, 11.0999, 0.2650> <-0.9643, 11.2148, 0.2180> <-0.9981, 11.2592, 0.2226>
		<-0.9121, 11.0989, 0.2762> <-0.9123, 11.0995, 0.2683> <-0.9825, 11.1982, 0.2147> <-1.0163, 11.2426, 0.2192>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9121, 11.0989, 0.2762> <-0.9123, 11.0995, 0.2683> <-0.9825, 11.1982, 0.2147> <-1.0163, 11.2426, 0.2192>
		<-0.9127, 11.0994, 0.2724> <-0.9130, 11.1000, 0.2644> <-1.0070, 11.1758, 0.2101> <-1.0408, 11.2202, 0.2146>
		<-0.9725, 11.0420, 0.1627> <-1.0065, 11.0849, 0.1833> <-1.0481, 11.1489, 0.1686> <-1.0805, 11.1924, 0.1902>
		<-0.9861, 11.0364, 0.1619> <-1.0201, 11.0792, 0.1825> <-1.0764, 11.1379, 0.1829> <-1.1088, 11.1815, 0.2045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2277, 11.1609, 0.3256> <-1.2255, 11.1571, 0.2745> <-1.1522, 11.1647, 0.2263> <-1.1088, 11.1815, 0.2045>
		<-1.2660, 11.2207, 0.3553> <-1.2637, 11.2168, 0.3042> <-1.2060, 11.2370, 0.2621> <-1.1627, 11.2537, 0.2403>
		<-1.3037, 11.3004, 0.4099> <-1.3002, 11.3036, 0.3738> <-1.2445, 11.3237, 0.3378> <-1.2218, 11.3432, 0.3170>
		<-1.3367, 11.3639, 0.4382> <-1.3332, 11.3671, 0.4020> <-1.2941, 11.3995, 0.3726> <-1.2714, 11.4189, 0.3518>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2277, 11.1609, 0.3256> <-1.2660, 11.2207, 0.3553> <-1.3037, 11.3004, 0.4099> <-1.3367, 11.3639, 0.4382>
		<-1.2306, 11.1656, 0.3881> <-1.2688, 11.2253, 0.4178> <-1.3084, 11.2962, 0.4578> <-1.3414, 11.3597, 0.4861>
		<-1.1758, 11.1880, 0.4724> <-1.2258, 11.2445, 0.5054> <-1.2672, 11.3175, 0.5191> <-1.3128, 11.3791, 0.5493>
		<-1.1221, 11.2037, 0.5007> <-1.1722, 11.2602, 0.5338> <-1.2490, 11.3363, 0.5598> <-1.2946, 11.3979, 0.5900>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1221, 11.2037, 0.5007> <-1.1722, 11.2602, 0.5338> <-1.2490, 11.3363, 0.5598> <-1.2946, 11.3979, 0.5900>
		<-1.0889, 11.2134, 0.5183> <-1.1389, 11.2699, 0.5513> <-1.2354, 11.3505, 0.5903> <-1.2810, 11.4121, 0.6205>
		<-1.0425, 11.2062, 0.4487> <-1.1045, 11.2775, 0.5237> <-1.1930, 11.3644, 0.5875> <-1.2562, 11.4447, 0.6517>
		<-1.0092, 11.2248, 0.4410> <-1.0713, 11.2961, 0.5161> <-1.1715, 11.3896, 0.6024> <-1.2347, 11.4698, 0.6667>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0092, 11.2248, 0.4410> <-1.0713, 11.2961, 0.5161> <-1.1715, 11.3896, 0.6024> <-1.2347, 11.4698, 0.6667>
		<-0.9861, 11.2378, 0.4357> <-1.0481, 11.3091, 0.5108> <-1.1557, 11.4081, 0.6134> <-1.2189, 11.4883, 0.6776>
		<-0.9735, 11.2734, 0.4634> <-1.0370, 11.3480, 0.5254> <-1.1337, 11.4406, 0.6144> <-1.1952, 11.5181, 0.6748>
		<-0.9581, 11.2956, 0.4631> <-1.0216, 11.3702, 0.5250> <-1.1146, 11.4590, 0.6118> <-1.1761, 11.5365, 0.6723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9581, 11.2956, 0.4631> <-1.0216, 11.3702, 0.5250> <-1.1146, 11.4590, 0.6118> <-1.1761, 11.5365, 0.6723>
		<-0.9443, 11.3153, 0.4627> <-1.0079, 11.3899, 0.5247> <-1.0907, 11.4820, 0.6086> <-1.1522, 11.5595, 0.6690>
		<-0.9295, 11.3395, 0.4393> <-0.9810, 11.4077, 0.5096> <-1.0638, 11.5087, 0.5942> <-1.1179, 11.5844, 0.6540>
		<-0.9158, 11.3593, 0.4389> <-0.9673, 11.4274, 0.5091> <-1.0393, 11.5302, 0.5877> <-1.0933, 11.6059, 0.6476>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9158, 11.3593, 0.4389> <-0.9673, 11.4274, 0.5091> <-1.0393, 11.5302, 0.5877> <-1.0933, 11.6059, 0.6476>
		<-0.8999, 11.3822, 0.4384> <-0.9514, 11.4503, 0.5086> <-1.0185, 11.5483, 0.5822> <-1.0726, 11.6240, 0.6421>
		<-0.8789, 11.4099, 0.4588> <-0.9291, 11.4812, 0.5083> <-0.9942, 11.5784, 0.5920> <-1.0454, 11.6502, 0.6398>
		<-0.8629, 11.4327, 0.4601> <-0.9131, 11.5040, 0.5095> <-0.9741, 11.5966, 0.5847> <-1.0252, 11.6684, 0.6325>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8629, 11.4327, 0.4601> <-0.9131, 11.5040, 0.5095> <-0.9741, 11.5966, 0.5847> <-1.0252, 11.6684, 0.6325>
		<-0.8499, 11.4512, 0.4611> <-0.9001, 11.5225, 0.5105> <-0.9553, 11.6136, 0.5779> <-1.0065, 11.6854, 0.6257>
		<-0.8342, 11.4756, 0.4456> <-0.8761, 11.5376, 0.5013> <-0.9352, 11.6376, 0.5672> <-0.9825, 11.7058, 0.6098>
		<-0.8213, 11.4942, 0.4462> <-0.8631, 11.5562, 0.5019> <-0.9171, 11.6544, 0.5584> <-0.9644, 11.7226, 0.6010>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8213, 11.4942, 0.4462> <-0.8631, 11.5562, 0.5019> <-0.9171, 11.6544, 0.5584> <-0.9644, 11.7226, 0.6010>
		<-0.8075, 11.5139, 0.4468> <-0.8494, 11.5759, 0.5025> <-0.9024, 11.6680, 0.5513> <-0.9497, 11.7361, 0.5939>
		<-0.7925, 11.5406, 0.4630> <-0.8372, 11.6030, 0.4967> <-0.8843, 11.6945, 0.5526> <-0.9305, 11.7557, 0.5865>
		<-0.7756, 11.5576, 0.4638> <-0.8203, 11.6200, 0.4975> <-0.8699, 11.7085, 0.5455> <-0.9162, 11.7696, 0.5794>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7756, 11.5576, 0.4638> <-0.8203, 11.6200, 0.4975> <-0.8699, 11.7085, 0.5455> <-0.9162, 11.7696, 0.5794>
		<-0.7586, 11.5746, 0.4645> <-0.8034, 11.6370, 0.4982> <-0.8524, 11.7255, 0.5369> <-0.8986, 11.7866, 0.5708>
		<-0.7254, 11.5847, 0.4539> <-0.7646, 11.6412, 0.5035> <-0.8273, 11.7466, 0.5313> <-0.8743, 11.8102, 0.5619>
		<-0.7118, 11.6043, 0.4511> <-0.7510, 11.6607, 0.5007> <-0.8111, 11.7620, 0.5181> <-0.8581, 11.8256, 0.5487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7118, 11.6043, 0.4511> <-0.7510, 11.6607, 0.5007> <-0.8111, 11.7620, 0.5181> <-0.8581, 11.8256, 0.5487>
		<-0.6939, 11.6300, 0.4474> <-0.7331, 11.6864, 0.4971> <-0.7931, 11.7791, 0.5035> <-0.8401, 11.8427, 0.5341>
		<-0.6871, 11.6771, 0.4575> <-0.7255, 11.7291, 0.4728> <-0.7771, 11.8151, 0.4925> <-0.8169, 11.8648, 0.5109>
		<-0.6749, 11.7023, 0.4431> <-0.7133, 11.7543, 0.4583> <-0.7639, 11.8266, 0.4696> <-0.8037, 11.8764, 0.4880>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6749, 11.7023, 0.4431> <-0.7133, 11.7543, 0.4583> <-0.7639, 11.8266, 0.4696> <-0.8037, 11.8764, 0.4880>
		<-0.6615, 11.7298, 0.4273> <-0.6999, 11.7818, 0.4425> <-0.7444, 11.8437, 0.4359> <-0.7843, 11.8935, 0.4543>
		<-0.6324, 11.7627, 0.3921> <-0.6679, 11.8085, 0.3946> <-0.7150, 11.8766, 0.3970> <-0.7529, 11.9195, 0.4060>
		<-0.6330, 11.7666, 0.3579> <-0.6685, 11.8124, 0.3604> <-0.7133, 11.8765, 0.3545> <-0.7513, 11.9194, 0.3635>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6330, 11.7666, 0.3579> <-0.6685, 11.8124, 0.3604> <-0.7133, 11.8765, 0.3545> <-0.7513, 11.9194, 0.3635>
		<-0.6336, 11.7707, 0.3226> <-0.6691, 11.8165, 0.3251> <-0.7118, 11.8764, 0.3135> <-0.7497, 11.9193, 0.3225>
		<-0.6630, 11.7494, 0.2764> <-0.6946, 11.7975, 0.2757> <-0.7366, 11.8523, 0.2662> <-0.7730, 11.8968, 0.2693>
		<-0.6780, 11.7238, 0.2568> <-0.7096, 11.7719, 0.2561> <-0.7578, 11.8312, 0.2382> <-0.7942, 11.8757, 0.2413>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6780, 11.7238, 0.2568> <-0.7096, 11.7719, 0.2561> <-0.7578, 11.8312, 0.2382> <-0.7942, 11.8757, 0.2413>
		<-0.6922, 11.6995, 0.2383> <-0.7238, 11.7476, 0.2376> <-0.7713, 11.8179, 0.2205> <-0.8077, 11.8624, 0.2236>
		<-0.6996, 11.6472, 0.2484> <-0.7387, 11.7023, 0.2236> <-0.7932, 11.7770, 0.2214> <-0.8367, 11.8343, 0.2239>
		<-0.7189, 11.6198, 0.2456> <-0.7580, 11.6749, 0.2207> <-0.8117, 11.7590, 0.2240> <-0.8552, 11.8163, 0.2265>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7189, 11.6198, 0.2456> <-0.7580, 11.6749, 0.2207> <-0.8117, 11.7590, 0.2240> <-0.8552, 11.8163, 0.2265>
		<-0.7328, 11.6001, 0.2436> <-0.7719, 11.6552, 0.2187> <-0.8305, 11.7408, 0.2266> <-0.8740, 11.7981, 0.2292>
		<-0.7673, 11.5902, 0.2424> <-0.8078, 11.6451, 0.2470> <-0.8554, 11.7223, 0.2413> <-0.8961, 11.7766, 0.2497>
		<-0.7843, 11.5731, 0.2414> <-0.8247, 11.6280, 0.2460> <-0.8736, 11.7051, 0.2497> <-0.9142, 11.7595, 0.2580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7843, 11.5731, 0.2414> <-0.8247, 11.6280, 0.2460> <-0.8736, 11.7051, 0.2497> <-0.9142, 11.7595, 0.2580>
		<-0.8017, 11.5553, 0.2404> <-0.8422, 11.6102, 0.2450> <-0.8914, 11.6883, 0.2579> <-0.9320, 11.7427, 0.2662>
		<-0.8175, 11.5255, 0.2394> <-0.8622, 11.5847, 0.2325> <-0.9129, 11.6615, 0.2626> <-0.9566, 11.7204, 0.2757>
		<-0.8317, 11.5051, 0.2392> <-0.8764, 11.5643, 0.2323> <-0.9313, 11.6445, 0.2684> <-0.9750, 11.7033, 0.2816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8317, 11.5051, 0.2392> <-0.8764, 11.5643, 0.2323> <-0.9313, 11.6445, 0.2684> <-0.9750, 11.7033, 0.2816>
		<-0.8444, 11.4869, 0.2391> <-0.8891, 11.5461, 0.2321> <-0.9476, 11.6294, 0.2737> <-0.9913, 11.6882, 0.2868>
		<-0.8612, 11.4626, 0.2413> <-0.9074, 11.5255, 0.2574> <-0.9671, 11.6052, 0.2757> <-1.0136, 11.6679, 0.2916>
		<-0.8739, 11.4444, 0.2403> <-0.9201, 11.5073, 0.2564> <-0.9834, 11.5897, 0.2790> <-1.0300, 11.6524, 0.2949>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8739, 11.4444, 0.2403> <-0.9201, 11.5073, 0.2564> <-0.9834, 11.5897, 0.2790> <-1.0300, 11.6524, 0.2949>
		<-0.8881, 11.4242, 0.2392> <-0.9344, 11.4871, 0.2552> <-0.9991, 11.5748, 0.2822> <-1.0456, 11.6375, 0.2981>
		<-0.9071, 11.3975, 0.2336> <-0.9575, 11.4665, 0.2361> <-1.0180, 11.5494, 0.2821> <-1.0663, 11.6172, 0.3014>
		<-0.9214, 11.3773, 0.2322> <-0.9717, 11.4463, 0.2347> <-1.0333, 11.5340, 0.2839> <-1.0816, 11.6018, 0.3032>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9214, 11.3773, 0.2322> <-0.9717, 11.4463, 0.2347> <-1.0333, 11.5340, 0.2839> <-1.0816, 11.6018, 0.3032>
		<-0.9356, 11.3570, 0.2307> <-0.9860, 11.4260, 0.2332> <-1.0510, 11.5162, 0.2860> <-1.0993, 11.5840, 0.3053>
		<-0.9545, 11.3296, 0.2325> <-1.0054, 11.3999, 0.2547> <-1.0718, 11.4885, 0.2853> <-1.1222, 11.5596, 0.3062>
		<-0.9688, 11.3093, 0.2306> <-1.0197, 11.3797, 0.2528> <-1.0894, 11.4706, 0.2870> <-1.1398, 11.5417, 0.3079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9688, 11.3093, 0.2306> <-1.0197, 11.3797, 0.2528> <-1.0894, 11.4706, 0.2870> <-1.1398, 11.5417, 0.3079>
		<-0.9831, 11.2891, 0.2286> <-1.0339, 11.3595, 0.2508> <-1.1079, 11.4518, 0.2889> <-1.1584, 11.5228, 0.3097>
		<-0.9981, 11.2592, 0.2226> <-1.0554, 11.3342, 0.2303> <-1.1296, 11.4226, 0.2842> <-1.1831, 11.4968, 0.3089>
		<-1.0163, 11.2426, 0.2192> <-1.0735, 11.3177, 0.2269> <-1.1485, 11.4051, 0.2905> <-1.2019, 11.4792, 0.3152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0163, 11.2426, 0.2192> <-1.0735, 11.3177, 0.2269> <-1.1485, 11.4051, 0.2905> <-1.2019, 11.4792, 0.3152>
		<-1.0408, 11.2202, 0.2146> <-1.0981, 11.2952, 0.2223> <-1.1696, 11.3854, 0.2975> <-1.2230, 11.4596, 0.3222>
		<-1.0805, 11.1924, 0.1902> <-1.1344, 11.2647, 0.2261> <-1.2032, 11.3590, 0.3001> <-1.2528, 11.4348, 0.3349>
		<-1.1088, 11.1815, 0.2045> <-1.1627, 11.2537, 0.2403> <-1.2218, 11.3432, 0.3170> <-1.2714, 11.4189, 0.3518>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3367, 11.3639, 0.4382> <-1.3332, 11.3671, 0.4020> <-1.2941, 11.3995, 0.3726> <-1.2714, 11.4189, 0.3518>
		<-1.3723, 11.4324, 0.4687> <-1.3687, 11.4356, 0.4325> <-1.3355, 11.4627, 0.4016> <-1.3127, 11.4822, 0.3809>
		<-1.4204, 11.5280, 0.4983> <-1.4177, 11.5305, 0.4619> <-1.3894, 11.5549, 0.4292> <-1.3702, 11.5721, 0.4032>
		<-1.4555, 11.5997, 0.5209> <-1.4528, 11.6022, 0.4845> <-1.4291, 11.6243, 0.4418> <-1.4099, 11.6415, 0.4158>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3367, 11.3639, 0.4382> <-1.3723, 11.4324, 0.4687> <-1.4204, 11.5280, 0.4983> <-1.4555, 11.5997, 0.5209>
		<-1.3414, 11.3597, 0.4861> <-1.3770, 11.4282, 0.5166> <-1.4246, 11.5241, 0.5543> <-1.4597, 11.5958, 0.5769>
		<-1.3128, 11.3791, 0.5493> <-1.3604, 11.4434, 0.5808> <-1.4084, 11.5385, 0.6146> <-1.4457, 11.6054, 0.6536>
		<-1.2946, 11.3979, 0.5900> <-1.3422, 11.4622, 0.6215> <-1.3943, 11.5546, 0.6666> <-1.4316, 11.6216, 0.7057>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2946, 11.3979, 0.5900> <-1.3422, 11.4622, 0.6215> <-1.3943, 11.5546, 0.6666> <-1.4316, 11.6216, 0.7057>
		<-1.2810, 11.4121, 0.6205> <-1.3286, 11.4764, 0.6520> <-1.3839, 11.5666, 0.7054> <-1.4211, 11.6336, 0.7444>
		<-1.2562, 11.4447, 0.6517> <-1.3035, 11.5046, 0.6997> <-1.3597, 11.5993, 0.7406> <-1.3984, 11.6635, 0.7906>
		<-1.2347, 11.4698, 0.6667> <-1.2820, 11.5298, 0.7147> <-1.3375, 11.6261, 0.7639> <-1.3762, 11.6904, 0.8139>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2347, 11.4698, 0.6667> <-1.2820, 11.5298, 0.7147> <-1.3375, 11.6261, 0.7639> <-1.3762, 11.6904, 0.8139>
		<-1.2189, 11.4883, 0.6776> <-1.2661, 11.5483, 0.7257> <-1.3242, 11.6423, 0.7779> <-1.3629, 11.7066, 0.8279>
		<-1.1952, 11.5181, 0.6748> <-1.2431, 11.5785, 0.7219> <-1.2992, 11.6738, 0.7716> <-1.3399, 11.7366, 0.8221>
		<-1.1761, 11.5365, 0.6723> <-1.2240, 11.5969, 0.7193> <-1.2812, 11.6914, 0.7701> <-1.3220, 11.7542, 0.8207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1761, 11.5365, 0.6723> <-1.2240, 11.5969, 0.7193> <-1.2812, 11.6914, 0.7701> <-1.3220, 11.7542, 0.8207>
		<-1.1522, 11.5595, 0.6690> <-1.2002, 11.6199, 0.7161> <-1.2593, 11.7130, 0.7683> <-1.3000, 11.7759, 0.8188>
		<-1.1179, 11.5844, 0.6540> <-1.1625, 11.6470, 0.7035> <-1.2231, 11.7392, 0.7607> <-1.2666, 11.8005, 0.8129>
		<-1.0933, 11.6059, 0.6476> <-1.1380, 11.6684, 0.6970> <-1.2012, 11.7587, 0.7509> <-1.2447, 11.8199, 0.8030>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0933, 11.6059, 0.6476> <-1.1380, 11.6684, 0.6970> <-1.2012, 11.7587, 0.7509> <-1.2447, 11.8199, 0.8030>
		<-1.0726, 11.6240, 0.6421> <-1.1173, 11.6866, 0.6916> <-1.1804, 11.7772, 0.7415> <-1.2238, 11.8385, 0.7937>
		<-1.0454, 11.6502, 0.6398> <-1.0898, 11.7126, 0.6813> <-1.1554, 11.8026, 0.7252> <-1.2005, 11.8616, 0.7709>
		<-1.0252, 11.6684, 0.6325> <-1.0697, 11.7308, 0.6740> <-1.1362, 11.8204, 0.7118> <-1.1812, 11.8794, 0.7574>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0252, 11.6684, 0.6325> <-1.0697, 11.7308, 0.6740> <-1.1362, 11.8204, 0.7118> <-1.1812, 11.8794, 0.7574>
		<-1.0065, 11.6854, 0.6257> <-1.0510, 11.7478, 0.6673> <-1.1194, 11.8358, 0.7000> <-1.1645, 11.8949, 0.7457>
		<-0.9825, 11.7058, 0.6098> <-1.0263, 11.7689, 0.6493> <-1.0934, 11.8563, 0.6883> <-1.1410, 11.9148, 0.7305>
		<-0.9644, 11.7226, 0.6010> <-1.0082, 11.7857, 0.6405> <-1.0769, 11.8723, 0.6769> <-1.1245, 11.9308, 0.7191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9644, 11.7226, 0.6010> <-1.0082, 11.7857, 0.6405> <-1.0769, 11.8723, 0.6769> <-1.1245, 11.9308, 0.7191>
		<-0.9497, 11.7361, 0.5939> <-0.9936, 11.7993, 0.6334> <-1.0653, 11.8835, 0.6689> <-1.1129, 11.9420, 0.7111>
		<-0.9305, 11.7557, 0.5865> <-0.9781, 11.8185, 0.6214> <-1.0493, 11.8982, 0.6648> <-1.0994, 11.9587, 0.7003>
		<-0.9162, 11.7696, 0.5794> <-0.9637, 11.8324, 0.6143> <-1.0377, 11.9097, 0.6573> <-1.0878, 11.9702, 0.6928>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9162, 11.7696, 0.5794> <-0.9637, 11.8324, 0.6143> <-1.0377, 11.9097, 0.6573> <-1.0878, 11.9702, 0.6928>
		<-0.8986, 11.7866, 0.5708> <-0.9462, 11.8494, 0.6057> <-1.0196, 11.9277, 0.6457> <-1.0697, 11.9881, 0.6812>
		<-0.8743, 11.8102, 0.5619> <-0.9215, 11.8742, 0.5927> <-0.9883, 11.9541, 0.6423> <-1.0421, 12.0132, 0.6718>
		<-0.8581, 11.8256, 0.5487> <-0.9054, 11.8895, 0.5795> <-0.9717, 11.9697, 0.6260> <-1.0256, 12.0289, 0.6555>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8581, 11.8256, 0.5487> <-0.9054, 11.8895, 0.5795> <-0.9717, 11.9697, 0.6260> <-1.0256, 12.0289, 0.6555>
		<-0.8401, 11.8427, 0.5341> <-0.8874, 11.9066, 0.5649> <-0.9537, 11.9868, 0.6083> <-1.0076, 12.0460, 0.6377>
		<-0.8169, 11.8648, 0.5109> <-0.8673, 11.9279, 0.5341> <-0.9298, 12.0096, 0.5839> <-0.9855, 12.0675, 0.6085>
		<-0.8037, 11.8764, 0.4880> <-0.8542, 11.9394, 0.5113> <-0.9193, 12.0194, 0.5569> <-0.9750, 12.0772, 0.5816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8037, 11.8764, 0.4880> <-0.8542, 11.9394, 0.5113> <-0.9193, 12.0194, 0.5569> <-0.9750, 12.0772, 0.5816>
		<-0.7843, 11.8935, 0.4543> <-0.8347, 11.9565, 0.4775> <-0.9027, 12.0347, 0.5147> <-0.9584, 12.0925, 0.5393>
		<-0.7529, 11.9195, 0.4060> <-0.8069, 11.9805, 0.4188> <-0.8796, 12.0548, 0.4640> <-0.9386, 12.1106, 0.4779>
		<-0.7513, 11.9194, 0.3635> <-0.8053, 11.9804, 0.3763> <-0.8781, 12.0547, 0.4162> <-0.9372, 12.1105, 0.4301>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7513, 11.9194, 0.3635> <-0.8053, 11.9804, 0.3763> <-0.8781, 12.0547, 0.4162> <-0.9372, 12.1105, 0.4301>
		<-0.7497, 11.9193, 0.3225> <-0.8037, 11.9803, 0.3353> <-0.8767, 12.0545, 0.3696> <-0.9358, 12.1103, 0.3835>
		<-0.7730, 11.8968, 0.2693> <-0.8236, 11.9588, 0.2736> <-0.8927, 12.0401, 0.3012> <-0.9467, 12.0966, 0.3186>
		<-0.7942, 11.8757, 0.2413> <-0.8448, 11.9377, 0.2456> <-0.9119, 12.0198, 0.2639> <-0.9659, 12.0763, 0.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7942, 11.8757, 0.2413> <-0.8448, 11.9377, 0.2456> <-0.9119, 12.0198, 0.2639> <-0.9659, 12.0763, 0.2813>
		<-0.8077, 11.8624, 0.2236> <-0.8583, 11.9244, 0.2278> <-0.9220, 12.0090, 0.2441> <-0.9760, 12.0656, 0.2616>
		<-0.8367, 11.8343, 0.2239> <-0.8849, 11.8978, 0.2267> <-0.9509, 11.9798, 0.2481> <-1.0053, 12.0369, 0.2602>
		<-0.8552, 11.8163, 0.2265> <-0.9035, 11.8798, 0.2293> <-0.9683, 11.9626, 0.2513> <-1.0226, 12.0197, 0.2633>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8552, 11.8163, 0.2265> <-0.9035, 11.8798, 0.2293> <-0.9683, 11.9626, 0.2513> <-1.0226, 12.0197, 0.2633>
		<-0.8740, 11.7981, 0.2292> <-0.9223, 11.8616, 0.2320> <-0.9865, 11.9445, 0.2546> <-1.0408, 12.0017, 0.2667>
		<-0.8961, 11.7766, 0.2497> <-0.9436, 11.8402, 0.2594> <-1.0066, 11.9235, 0.2834> <-1.0604, 11.9821, 0.2914>
		<-0.9142, 11.7595, 0.2580> <-0.9617, 11.8231, 0.2678> <-1.0237, 11.9070, 0.2937> <-1.0775, 11.9656, 0.3017>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9142, 11.7595, 0.2580> <-0.9617, 11.8231, 0.2678> <-1.0237, 11.9070, 0.2937> <-1.0775, 11.9656, 0.3017>
		<-0.9320, 11.7427, 0.2662> <-0.9795, 11.8063, 0.2760> <-1.0401, 11.8911, 0.3036> <-1.0939, 11.9497, 0.3116>
		<-0.9566, 11.7204, 0.2757> <-1.0036, 11.7837, 0.2899> <-1.0668, 11.8661, 0.3189> <-1.1168, 11.9285, 0.3232>
		<-0.9750, 11.7033, 0.2816> <-1.0220, 11.7666, 0.2958> <-1.0841, 11.8497, 0.3261> <-1.1341, 11.9122, 0.3304>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9750, 11.7033, 0.2816> <-1.0220, 11.7666, 0.2958> <-1.0841, 11.8497, 0.3261> <-1.1341, 11.9122, 0.3304>
		<-0.9913, 11.6882, 0.2868> <-1.0384, 11.7515, 0.3010> <-1.0992, 11.8355, 0.3324> <-1.1492, 11.8979, 0.3367>
		<-1.0136, 11.6679, 0.2916> <-1.0605, 11.7311, 0.3076> <-1.1218, 11.8148, 0.3367> <-1.1701, 11.8786, 0.3426>
		<-1.0300, 11.6524, 0.2949> <-1.0769, 11.7155, 0.3110> <-1.1371, 11.8000, 0.3407> <-1.1854, 11.8638, 0.3466>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0300, 11.6524, 0.2949> <-1.0769, 11.7155, 0.3110> <-1.1371, 11.8000, 0.3407> <-1.1854, 11.8638, 0.3466>
		<-1.0456, 11.6375, 0.2981> <-1.0925, 11.7006, 0.3141> <-1.1516, 11.7858, 0.3445> <-1.1999, 11.8497, 0.3505>
		<-1.0663, 11.6172, 0.3014> <-1.1116, 11.6810, 0.3195> <-1.1726, 11.7653, 0.3476> <-1.2191, 11.8304, 0.3544>
		<-1.0816, 11.6018, 0.3032> <-1.1270, 11.6655, 0.3213> <-1.1869, 11.7505, 0.3498> <-1.2333, 11.8156, 0.3566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0816, 11.6018, 0.3032> <-1.1270, 11.6655, 0.3213> <-1.1869, 11.7505, 0.3498> <-1.2333, 11.8156, 0.3566>
		<-1.0993, 11.5840, 0.3053> <-1.1446, 11.6478, 0.3234> <-1.2033, 11.7336, 0.3523> <-1.2497, 11.7987, 0.3592>
		<-1.1222, 11.5596, 0.3062> <-1.1674, 11.6233, 0.3248> <-1.2267, 11.7088, 0.3528> <-1.2711, 11.7754, 0.3603>
		<-1.1398, 11.5417, 0.3079> <-1.1850, 11.6054, 0.3266> <-1.2430, 11.6918, 0.3549> <-1.2874, 11.7583, 0.3624>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1398, 11.5417, 0.3079> <-1.1850, 11.6054, 0.3266> <-1.2430, 11.6918, 0.3549> <-1.2874, 11.7583, 0.3624>
		<-1.1584, 11.5228, 0.3097> <-1.2035, 11.5865, 0.3284> <-1.2603, 11.6738, 0.3572> <-1.3046, 11.7403, 0.3646>
		<-1.1831, 11.4968, 0.3089> <-1.2285, 11.5598, 0.3299> <-1.2857, 11.6472, 0.3554> <-1.3279, 11.7152, 0.3637>
		<-1.2019, 11.4792, 0.3152> <-1.2473, 11.5422, 0.3362> <-1.3030, 11.6308, 0.3629> <-1.3451, 11.6987, 0.3712>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2019, 11.4792, 0.3152> <-1.2473, 11.5422, 0.3362> <-1.3030, 11.6308, 0.3629> <-1.3451, 11.6987, 0.3712>
		<-1.2230, 11.4596, 0.3222> <-1.2684, 11.5225, 0.3432> <-1.3231, 11.6116, 0.3717> <-1.3653, 11.6795, 0.3800>
		<-1.2528, 11.4348, 0.3349> <-1.2942, 11.4980, 0.3640> <-1.3549, 11.5858, 0.3825> <-1.3946, 11.6552, 0.3951>
		<-1.2714, 11.4189, 0.3518> <-1.3127, 11.4822, 0.3809> <-1.3702, 11.5721, 0.4032> <-1.4099, 11.6415, 0.4158>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4555, 11.5997, 0.5209> <-1.4528, 11.6022, 0.4845> <-1.4291, 11.6243, 0.4418> <-1.4099, 11.6415, 0.4158>
		<-1.4864, 11.6627, 0.5408> <-1.4836, 11.6652, 0.5044> <-1.4637, 11.6848, 0.4528> <-1.4445, 11.7020, 0.4268>
		<-1.5256, 11.7492, 0.5621> <-1.5235, 11.7513, 0.5145> <-1.5025, 11.7714, 0.4637> <-1.4846, 11.7883, 0.4228>
		<-1.5565, 11.8129, 0.5799> <-1.5544, 11.8149, 0.5323> <-1.5359, 11.8332, 0.4711> <-1.5180, 11.8500, 0.4302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4555, 11.5997, 0.5209> <-1.4864, 11.6627, 0.5408> <-1.5256, 11.7492, 0.5621> <-1.5565, 11.8129, 0.5799>
		<-1.4597, 11.5958, 0.5769> <-1.4906, 11.6588, 0.5968> <-1.5291, 11.7458, 0.6413> <-1.5600, 11.8095, 0.6592>
		<-1.4457, 11.6054, 0.6536> <-1.4811, 11.6691, 0.6907> <-1.5195, 11.7545, 0.7224> <-1.5484, 11.8172, 0.7661>
		<-1.4316, 11.6216, 0.7057> <-1.4670, 11.6852, 0.7427> <-1.5073, 11.7696, 0.7994> <-1.5363, 11.8323, 0.8431>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4316, 11.6216, 0.7057> <-1.4670, 11.6852, 0.7427> <-1.5073, 11.7696, 0.7994> <-1.5363, 11.8323, 0.8431>
		<-1.4211, 11.6336, 0.7444> <-1.4565, 11.6972, 0.7815> <-1.4994, 11.7794, 0.8495> <-1.5284, 11.8421, 0.8932>
		<-1.3984, 11.6635, 0.7906> <-1.4367, 11.7271, 0.8400> <-1.4805, 11.8105, 0.8973> <-1.5117, 11.8667, 0.9591>
		<-1.3762, 11.6904, 0.8139> <-1.4145, 11.7540, 0.8633> <-1.4595, 11.8384, 0.9354> <-1.4907, 11.8947, 0.9972>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3762, 11.6904, 0.8139> <-1.4145, 11.7540, 0.8633> <-1.4595, 11.8384, 0.9354> <-1.4907, 11.8947, 0.9972>
		<-1.3629, 11.7066, 0.8279> <-1.4012, 11.7702, 0.8773> <-1.4505, 11.8503, 0.9517> <-1.4817, 11.9066, 1.0135>
		<-1.3399, 11.7366, 0.8221> <-1.3803, 11.7989, 0.8723> <-1.4295, 11.8830, 0.9429> <-1.4610, 11.9363, 1.0076>
		<-1.3220, 11.7542, 0.8207> <-1.3624, 11.8165, 0.8708> <-1.4143, 11.8989, 0.9421> <-1.4457, 11.9523, 1.0069>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3220, 11.7542, 0.8207> <-1.3624, 11.8165, 0.8708> <-1.4143, 11.8989, 0.9421> <-1.4457, 11.9523, 1.0069>
		<-1.3000, 11.7759, 0.8188> <-1.3404, 11.8382, 0.8690> <-1.3958, 11.9182, 0.9412> <-1.4273, 11.9715, 1.0060>
		<-1.2666, 11.8005, 0.8129> <-1.3094, 11.8608, 0.8643> <-1.3619, 11.9398, 0.9396> <-1.3981, 11.9935, 1.0022>
		<-1.2447, 11.8199, 0.8030> <-1.2875, 11.8803, 0.8544> <-1.3440, 11.9565, 0.9291> <-1.3801, 12.0102, 0.9917>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2447, 11.8199, 0.8030> <-1.2875, 11.8803, 0.8544> <-1.3440, 11.9565, 0.9291> <-1.3801, 12.0102, 0.9917>
		<-1.2238, 11.8385, 0.7937> <-1.2666, 11.8988, 0.8450> <-1.3252, 11.9739, 0.9182> <-1.3614, 12.0276, 0.9808>
		<-1.2005, 11.8616, 0.7709> <-1.2464, 11.9216, 0.8173> <-1.3004, 11.9964, 0.8961> <-1.3422, 12.0479, 0.9548>
		<-1.1812, 11.8794, 0.7574> <-1.2271, 11.9394, 0.8038> <-1.2848, 12.0115, 0.8788> <-1.3266, 12.0631, 0.9375>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1812, 11.8794, 0.7574> <-1.2271, 11.9394, 0.8038> <-1.2848, 12.0115, 0.8788> <-1.3266, 12.0631, 0.9375>
		<-1.1645, 11.8949, 0.7457> <-1.2103, 11.9549, 0.7921> <-1.2699, 12.0259, 0.8624> <-1.3118, 12.0775, 0.9211>
		<-1.1410, 11.9148, 0.7305> <-1.1881, 11.9726, 0.7722> <-1.2459, 12.0441, 0.8461> <-1.2912, 12.0946, 0.8980>
		<-1.1245, 11.9308, 0.7191> <-1.1716, 11.9886, 0.7608> <-1.2334, 12.0581, 0.8276> <-1.2786, 12.1086, 0.8795>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1245, 11.9308, 0.7191> <-1.1716, 11.9886, 0.7608> <-1.2334, 12.0581, 0.8276> <-1.2786, 12.1086, 0.8795>
		<-1.1129, 11.9420, 0.7111> <-1.1600, 11.9999, 0.7528> <-1.2198, 12.0733, 0.8074> <-1.2650, 12.1238, 0.8594>
		<-1.0994, 11.9587, 0.7003> <-1.1464, 12.0154, 0.7337> <-1.2034, 12.0913, 0.7985> <-1.2522, 12.1469, 0.8312>
		<-1.0878, 11.9702, 0.6928> <-1.1347, 12.0269, 0.7262> <-1.1909, 12.1045, 0.7764> <-1.2396, 12.1601, 0.8091>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0878, 11.9702, 0.6928> <-1.1347, 12.0269, 0.7262> <-1.1909, 12.1045, 0.7764> <-1.2396, 12.1601, 0.8091>
		<-1.0697, 11.9881, 0.6812> <-1.1167, 12.0449, 0.7146> <-1.1784, 12.1176, 0.7544> <-1.2272, 12.1732, 0.7871>
		<-1.0421, 12.0132, 0.6718> <-1.0897, 12.0655, 0.6978> <-1.1572, 12.1350, 0.7321> <-1.2077, 12.1852, 0.7565>
		<-1.0256, 12.0289, 0.6555> <-1.0732, 12.0811, 0.6815> <-1.1451, 12.1460, 0.7088> <-1.1956, 12.1962, 0.7332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0256, 12.0289, 0.6555> <-1.0732, 12.0811, 0.6815> <-1.1451, 12.1460, 0.7088> <-1.1956, 12.1962, 0.7332>
		<-1.0076, 12.0460, 0.6377> <-1.0552, 12.0982, 0.6637> <-1.1312, 12.1587, 0.6820> <-1.1817, 12.2089, 0.7064>
		<-0.9855, 12.0675, 0.6085> <-1.0349, 12.1188, 0.6303> <-1.1089, 12.1818, 0.6539> <-1.1610, 12.2314, 0.6731>
		<-0.9750, 12.0772, 0.5816> <-1.0243, 12.1285, 0.6034> <-1.1007, 12.1897, 0.6232> <-1.1529, 12.2392, 0.6423>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9750, 12.0772, 0.5816> <-1.0243, 12.1285, 0.6034> <-1.1007, 12.1897, 0.6232> <-1.1529, 12.2392, 0.6423>
		<-0.9584, 12.0925, 0.5393> <-1.0078, 12.1438, 0.5611> <-1.0861, 12.2038, 0.5678> <-1.1383, 12.2534, 0.5869>
		<-0.9386, 12.1106, 0.4779> <-0.9909, 12.1600, 0.4903> <-1.0710, 12.2183, 0.5004> <-1.1232, 12.2685, 0.5095>
		<-0.9372, 12.1105, 0.4301> <-0.9894, 12.1599, 0.4424> <-1.0687, 12.2184, 0.4415> <-1.1209, 12.2686, 0.4505>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9372, 12.1105, 0.4301> <-0.9894, 12.1599, 0.4424> <-1.0687, 12.2184, 0.4415> <-1.1209, 12.2686, 0.4505>
		<-0.9358, 12.1103, 0.3835> <-0.9880, 12.1597, 0.3958> <-1.0675, 12.2185, 0.4105> <-1.1197, 12.2687, 0.4195>
		<-0.9467, 12.0966, 0.3186> <-0.9974, 12.1497, 0.3350> <-1.0797, 12.1982, 0.3648> <-1.1285, 12.2540, 0.3775>
		<-0.9659, 12.0763, 0.2813> <-1.0166, 12.1294, 0.2976> <-1.0930, 12.1838, 0.3407> <-1.1418, 12.2397, 0.3534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9659, 12.0763, 0.2813> <-1.0166, 12.1294, 0.2976> <-1.0930, 12.1838, 0.3407> <-1.1418, 12.2397, 0.3534>
		<-0.9760, 12.0656, 0.2616> <-1.0267, 12.1187, 0.2779> <-1.1055, 12.1703, 0.3179> <-1.1543, 12.2261, 0.3306>
		<-1.0053, 12.0369, 0.2602> <-1.0552, 12.0895, 0.2713> <-1.1349, 12.1450, 0.3034> <-1.1817, 12.2008, 0.3115>
		<-1.0226, 12.0197, 0.2633> <-1.0725, 12.0723, 0.2744> <-1.1549, 12.1251, 0.2954> <-1.2018, 12.1809, 0.3035>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0226, 12.0197, 0.2633> <-1.0725, 12.0723, 0.2744> <-1.1549, 12.1251, 0.2954> <-1.2018, 12.1809, 0.3035>
		<-1.0408, 12.0017, 0.2667> <-1.0907, 12.0542, 0.2778> <-1.1700, 12.1102, 0.2894> <-1.2168, 12.1660, 0.2974>
		<-1.0604, 11.9821, 0.2914> <-1.1089, 12.0349, 0.2987> <-1.1924, 12.0896, 0.3034> <-1.2384, 12.1449, 0.3077>
		<-1.0775, 11.9656, 0.3017> <-1.1260, 12.0184, 0.3089> <-1.2075, 12.0736, 0.3044> <-1.2535, 12.1289, 0.3086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0775, 11.9656, 0.3017> <-1.1260, 12.0184, 0.3089> <-1.2075, 12.0736, 0.3044> <-1.2535, 12.1289, 0.3086>
		<-1.0939, 11.9497, 0.3116> <-1.1424, 12.0026, 0.3188> <-1.2178, 12.0627, 0.3050> <-1.2637, 12.1181, 0.3092>
		<-1.1168, 11.9285, 0.3232> <-1.1610, 11.9837, 0.3270> <-1.2325, 12.0463, 0.3038> <-1.2761, 12.1021, 0.3055>
		<-1.1341, 11.9122, 0.3304> <-1.1784, 11.9673, 0.3342> <-1.2425, 12.0357, 0.3069> <-1.2861, 12.0914, 0.3086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1341, 11.9122, 0.3304> <-1.1784, 11.9673, 0.3342> <-1.2425, 12.0357, 0.3069> <-1.2861, 12.0914, 0.3086>
		<-1.1492, 11.8979, 0.3367> <-1.1935, 11.9531, 0.3405> <-1.2556, 12.0218, 0.3108> <-1.2993, 12.0775, 0.3125>
		<-1.1701, 11.8786, 0.3426> <-1.2124, 11.9346, 0.3478> <-1.2745, 12.0052, 0.3240> <-1.3163, 12.0618, 0.3258>
		<-1.1854, 11.8638, 0.3466> <-1.2277, 11.9198, 0.3518> <-1.2875, 11.9918, 0.3298> <-1.3293, 12.0484, 0.3317>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1854, 11.8638, 0.3466> <-1.2277, 11.9198, 0.3518> <-1.2875, 11.9918, 0.3298> <-1.3293, 12.0484, 0.3317>
		<-1.1999, 11.8497, 0.3505> <-1.2422, 11.9056, 0.3556> <-1.2996, 11.9793, 0.3352> <-1.3414, 12.0359, 0.3371>
		<-1.2191, 11.8304, 0.3544> <-1.2597, 11.8873, 0.3605> <-1.3176, 11.9611, 0.3402> <-1.3576, 12.0187, 0.3428>
		<-1.2333, 11.8156, 0.3566> <-1.2739, 11.8725, 0.3627> <-1.3296, 11.9478, 0.3433> <-1.3696, 12.0054, 0.3459>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2333, 11.8156, 0.3566> <-1.2739, 11.8725, 0.3627> <-1.3296, 11.9478, 0.3433> <-1.3696, 12.0054, 0.3459>
		<-1.2497, 11.7987, 0.3592> <-1.2903, 11.8556, 0.3652> <-1.3433, 11.9327, 0.3469> <-1.3833, 11.9903, 0.3495>
		<-1.2711, 11.7754, 0.3603> <-1.3098, 11.8334, 0.3668> <-1.3632, 11.9104, 0.3480> <-1.4011, 11.9692, 0.3511>
		<-1.2874, 11.7583, 0.3624> <-1.3261, 11.8163, 0.3689> <-1.3768, 11.8951, 0.3511> <-1.4148, 11.9539, 0.3541>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2874, 11.7583, 0.3624> <-1.3261, 11.8163, 0.3689> <-1.3768, 11.8951, 0.3511> <-1.4148, 11.9539, 0.3541>
		<-1.3046, 11.7403, 0.3646> <-1.3433, 11.7983, 0.3711> <-1.3912, 11.8789, 0.3543> <-1.4292, 11.9378, 0.3573>
		<-1.3279, 11.7152, 0.3637> <-1.3646, 11.7745, 0.3710> <-1.4135, 11.8542, 0.3529> <-1.4494, 11.9144, 0.3566>
		<-1.3451, 11.6987, 0.3712> <-1.3819, 11.7581, 0.3785> <-1.4273, 11.8404, 0.3630> <-1.4631, 11.9006, 0.3667>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3451, 11.6987, 0.3712> <-1.3819, 11.7581, 0.3785> <-1.4273, 11.8404, 0.3630> <-1.4631, 11.9006, 0.3667>
		<-1.3653, 11.6795, 0.3800> <-1.4020, 11.7389, 0.3873> <-1.4456, 11.8219, 0.3766> <-1.4815, 11.8821, 0.3803>
		<-1.3946, 11.6552, 0.3951> <-1.4292, 11.7158, 0.4061> <-1.4736, 11.7986, 0.3976> <-1.5069, 11.8604, 0.4050>
		<-1.4099, 11.6415, 0.4158> <-1.4445, 11.7020, 0.4268> <-1.4846, 11.7883, 0.4228> <-1.5180, 11.8500, 0.4302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5565, 11.8129, 0.5799> <-1.5544, 11.8149, 0.5323> <-1.5359, 11.8332, 0.4711> <-1.5180, 11.8500, 0.4302>
		<-1.6035, 11.9097, 0.6071> <-1.6013, 11.9118, 0.5595> <-1.5979, 11.9480, 0.4849> <-1.5800, 11.9648, 0.4440>
		<-1.6625, 12.0430, 0.6365> <-1.6743, 12.0647, 0.5793> <-1.6622, 12.0858, 0.5225> <-1.6596, 12.1187, 0.4696>
		<-1.7150, 12.1346, 0.6708> <-1.7268, 12.1564, 0.6136> <-1.7302, 12.1967, 0.5393> <-1.7276, 12.2297, 0.4865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5565, 11.8129, 0.5799> <-1.6035, 11.9097, 0.6071> <-1.6625, 12.0430, 0.6365> <-1.7150, 12.1346, 0.6708>
		<-1.5600, 11.8095, 0.6592> <-1.6070, 11.9063, 0.6863> <-1.6427, 12.0062, 0.7331> <-1.6952, 12.0978, 0.7674>
		<-1.5484, 11.8172, 0.7661> <-1.5770, 11.8790, 0.8092> <-1.6290, 12.0099, 0.8397> <-1.6545, 12.0603, 0.8972>
		<-1.5363, 11.8323, 0.8431> <-1.5648, 11.8941, 0.8862> <-1.5975, 11.9859, 0.9373> <-1.6231, 12.0363, 0.9947>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5363, 11.8323, 0.8431> <-1.5648, 11.8941, 0.8862> <-1.5975, 11.9859, 0.9373> <-1.6231, 12.0363, 0.9947>
		<-1.5284, 11.8421, 0.8932> <-1.5569, 11.9040, 0.9363> <-1.5808, 11.9731, 0.9893> <-1.6063, 12.0235, 1.0468>
		<-1.5117, 11.8667, 0.9591> <-1.5345, 11.9078, 1.0041> <-1.5660, 11.9767, 1.0639> <-1.5831, 12.0061, 1.1194>
		<-1.4907, 11.8947, 0.9972> <-1.5134, 11.9357, 1.0422> <-1.5377, 11.9832, 1.1120> <-1.5549, 12.0126, 1.1675>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4907, 11.8947, 0.9972> <-1.5134, 11.9357, 1.0422> <-1.5377, 11.9832, 1.1120> <-1.5549, 12.0126, 1.1675>
		<-1.4817, 11.9066, 1.0135> <-1.5044, 11.9476, 1.0585> <-1.5260, 11.9859, 1.1319> <-1.5432, 12.0153, 1.1874>
		<-1.4610, 11.9363, 1.0076> <-1.4850, 11.9770, 1.0570> <-1.5055, 12.0221, 1.1335> <-1.5191, 12.0456, 1.1961>
		<-1.4457, 11.9523, 1.0069> <-1.4697, 11.9929, 1.0562> <-1.4910, 12.0401, 1.1338> <-1.5045, 12.0637, 1.1964>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4457, 11.9523, 1.0069> <-1.4697, 11.9929, 1.0562> <-1.4910, 12.0401, 1.1338> <-1.5045, 12.0637, 1.1964>
		<-1.4273, 11.9715, 1.0060> <-1.4513, 12.0122, 1.0553> <-1.4741, 12.0611, 1.1341> <-1.4876, 12.0847, 1.1968>
		<-1.3981, 11.9935, 1.0022> <-1.4258, 12.0347, 1.0501> <-1.4497, 12.0883, 1.1211> <-1.4675, 12.1139, 1.1827>
		<-1.3801, 12.0102, 0.9917> <-1.4078, 12.0514, 1.0397> <-1.4387, 12.1090, 1.1080> <-1.4565, 12.1346, 1.1696>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3801, 12.0102, 0.9917> <-1.4078, 12.0514, 1.0397> <-1.4387, 12.1090, 1.1080> <-1.4565, 12.1346, 1.1696>
		<-1.3614, 12.0276, 0.9808> <-1.3891, 12.0688, 1.0288> <-1.4285, 12.1281, 1.0959> <-1.4463, 12.1537, 1.1575>
		<-1.3422, 12.0479, 0.9548> <-1.3769, 12.0906, 1.0035> <-1.4195, 12.1443, 1.0690> <-1.4418, 12.1758, 1.1316>
		<-1.3266, 12.0631, 0.9375> <-1.3613, 12.1058, 0.9862> <-1.4133, 12.1613, 1.0520> <-1.4356, 12.1928, 1.1146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3266, 12.0631, 0.9375> <-1.3613, 12.1058, 0.9862> <-1.4133, 12.1613, 1.0520> <-1.4356, 12.1928, 1.1146>
		<-1.3118, 12.0775, 0.9211> <-1.3465, 12.1202, 0.9698> <-1.4065, 12.1800, 1.0333> <-1.4288, 12.2114, 1.0959>
		<-1.2912, 12.0946, 0.8980> <-1.3327, 12.1411, 0.9457> <-1.3848, 12.2009, 1.0106> <-1.4157, 12.2375, 1.0727>
		<-1.2786, 12.1086, 0.8795> <-1.3202, 12.1551, 0.9272> <-1.3822, 12.2168, 0.9886> <-1.4132, 12.2535, 1.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2786, 12.1086, 0.8795> <-1.3202, 12.1551, 0.9272> <-1.3822, 12.2168, 0.9886> <-1.4132, 12.2535, 1.0507>
		<-1.2650, 12.1238, 0.8594> <-1.3065, 12.1703, 0.9071> <-1.3777, 12.2457, 0.9487> <-1.4086, 12.2823, 1.0108>
		<-1.2522, 12.1469, 0.8312> <-1.3009, 12.2025, 0.8639> <-1.3799, 12.2720, 0.8925> <-1.4159, 12.3134, 0.9519>
		<-1.2396, 12.1601, 0.8091> <-1.2884, 12.2157, 0.8418> <-1.3763, 12.2990, 0.8512> <-1.4123, 12.3404, 0.9106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2396, 12.1601, 0.8091> <-1.2884, 12.2157, 0.8418> <-1.3763, 12.2990, 0.8512> <-1.4123, 12.3404, 0.9106>
		<-1.2272, 12.1732, 0.7871> <-1.2759, 12.2288, 0.8198> <-1.3742, 12.3148, 0.8271> <-1.4102, 12.3562, 0.8865>
		<-1.2077, 12.1852, 0.7565> <-1.2678, 12.2450, 0.7855> <-1.3483, 12.3265, 0.8041> <-1.3980, 12.3791, 0.8570>
		<-1.1956, 12.1962, 0.7332> <-1.2557, 12.2560, 0.7622> <-1.3446, 12.3429, 0.7806> <-1.3943, 12.3955, 0.8335>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1956, 12.1962, 0.7332> <-1.2557, 12.2560, 0.7622> <-1.3446, 12.3429, 0.7806> <-1.3943, 12.3955, 0.8335>
		<-1.1817, 12.2089, 0.7064> <-1.2418, 12.2687, 0.7354> <-1.3398, 12.3641, 0.7502> <-1.3895, 12.4167, 0.8032>
		<-1.1610, 12.2314, 0.6731> <-1.2315, 12.2984, 0.6989> <-1.3201, 12.3888, 0.7130> <-1.3825, 12.4486, 0.7645>
		<-1.1529, 12.2392, 0.6423> <-1.2234, 12.3062, 0.6681> <-1.3213, 12.4059, 0.6798> <-1.3838, 12.4657, 0.7313>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1529, 12.2392, 0.6423> <-1.2234, 12.3062, 0.6681> <-1.3213, 12.4059, 0.6798> <-1.3838, 12.4657, 0.7313>
		<-1.1383, 12.2534, 0.5869> <-1.2088, 12.3204, 0.6128> <-1.3238, 12.4392, 0.6156> <-1.3863, 12.4990, 0.6671>
		<-1.1232, 12.2685, 0.5095> <-1.2120, 12.3540, 0.5249> <-1.3157, 12.4547, 0.5072> <-1.3915, 12.5278, 0.5732>
		<-1.1209, 12.2686, 0.4505> <-1.2097, 12.3541, 0.4659> <-1.3308, 12.4892, 0.4454> <-1.4066, 12.5623, 0.5115>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1209, 12.2686, 0.4505> <-1.2097, 12.3541, 0.4659> <-1.3308, 12.4892, 0.4454> <-1.4066, 12.5623, 0.5115>
		<-1.1197, 12.2687, 0.4195> <-1.2085, 12.3542, 0.4349> <-1.3397, 12.5095, 0.4091> <-1.4155, 12.5825, 0.4752>
		<-1.1285, 12.2540, 0.3775> <-1.2296, 12.3698, 0.4038> <-1.3473, 12.5188, 0.3964> <-1.4393, 12.6351, 0.4449>
		<-1.1418, 12.2397, 0.3534> <-1.2429, 12.3554, 0.3797> <-1.3705, 12.5286, 0.3621> <-1.4624, 12.6448, 0.4106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1418, 12.2397, 0.3534> <-1.2429, 12.3554, 0.3797> <-1.3705, 12.5286, 0.3621> <-1.4624, 12.6448, 0.4106>
		<-1.1543, 12.2261, 0.3306> <-1.2554, 12.3419, 0.3570> <-1.3852, 12.5348, 0.3403> <-1.4771, 12.6510, 0.3888>
		<-1.1817, 12.2008, 0.3115> <-1.2839, 12.3226, 0.3291> <-1.4107, 12.4978, 0.3365> <-1.5010, 12.6277, 0.3598>
		<-1.2018, 12.1809, 0.3035> <-1.3039, 12.3027, 0.3211> <-1.4262, 12.4789, 0.3251> <-1.5166, 12.6087, 0.3484>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2018, 12.1809, 0.3035> <-1.3039, 12.3027, 0.3211> <-1.4262, 12.4789, 0.3251> <-1.5166, 12.6087, 0.3484>
		<-1.2168, 12.1660, 0.2974> <-1.3190, 12.2878, 0.3150> <-1.4401, 12.4619, 0.3150> <-1.5305, 12.5918, 0.3383>
		<-1.2384, 12.1449, 0.3077> <-1.3352, 12.2615, 0.3167> <-1.4547, 12.4341, 0.3305> <-1.5411, 12.5581, 0.3458>
		<-1.2535, 12.1289, 0.3086> <-1.3503, 12.2455, 0.3176> <-1.4651, 12.4124, 0.3304> <-1.5515, 12.5363, 0.3457>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2535, 12.1289, 0.3086> <-1.3503, 12.2455, 0.3176> <-1.4651, 12.4124, 0.3304> <-1.5515, 12.5363, 0.3457>
		<-1.2637, 12.1181, 0.3092> <-1.3606, 12.2347, 0.3182> <-1.4733, 12.3953, 0.3303> <-1.5597, 12.5192, 0.3456>
		<-1.2761, 12.1021, 0.3055> <-1.3663, 12.2171, 0.3090> <-1.4859, 12.3768, 0.3304> <-1.5698, 12.4957, 0.3446>
		<-1.2861, 12.0914, 0.3086> <-1.3763, 12.2065, 0.3121> <-1.4948, 12.3603, 0.3335> <-1.5786, 12.4792, 0.3478>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2861, 12.0914, 0.3086> <-1.3763, 12.2065, 0.3121> <-1.4948, 12.3603, 0.3335> <-1.5786, 12.4792, 0.3478>
		<-1.2993, 12.0775, 0.3125> <-1.3894, 12.1925, 0.3161> <-1.5026, 12.3458, 0.3363> <-1.5864, 12.4647, 0.3505>
		<-1.3163, 12.0618, 0.3258> <-1.4011, 12.1767, 0.3296> <-1.5171, 12.3304, 0.3463> <-1.5978, 12.4475, 0.3597>
		<-1.3293, 12.0484, 0.3317> <-1.4141, 12.1633, 0.3354> <-1.5257, 12.3171, 0.3517> <-1.6063, 12.4342, 0.3651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3293, 12.0484, 0.3317> <-1.4141, 12.1633, 0.3354> <-1.5257, 12.3171, 0.3517> <-1.6063, 12.4342, 0.3651>
		<-1.3414, 12.0359, 0.3371> <-1.4262, 12.1508, 0.3408> <-1.5338, 12.3044, 0.3568> <-1.6144, 12.4216, 0.3702>
		<-1.3576, 12.0187, 0.3428> <-1.4380, 12.1346, 0.3480> <-1.5468, 12.2888, 0.3650> <-1.6253, 12.4054, 0.3787>
		<-1.3696, 12.0054, 0.3459> <-1.4501, 12.1213, 0.3512> <-1.5557, 12.2763, 0.3690> <-1.6341, 12.3929, 0.3827>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3696, 12.0054, 0.3459> <-1.4501, 12.1213, 0.3512> <-1.5557, 12.2763, 0.3690> <-1.6341, 12.3929, 0.3827>
		<-1.3833, 11.9903, 0.3495> <-1.4637, 12.1062, 0.3548> <-1.5653, 12.2627, 0.3734> <-1.6437, 12.3793, 0.3870>
		<-1.4011, 11.9692, 0.3511> <-1.4774, 12.0874, 0.3572> <-1.5809, 12.2438, 0.3751> <-1.6577, 12.3610, 0.3890>
		<-1.4148, 11.9539, 0.3541> <-1.4910, 12.0721, 0.3602> <-1.5908, 12.2302, 0.3788> <-1.6675, 12.3473, 0.3927>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4148, 11.9539, 0.3541> <-1.4910, 12.0721, 0.3602> <-1.5908, 12.2302, 0.3788> <-1.6675, 12.3473, 0.3927>
		<-1.4292, 11.9378, 0.3573> <-1.5054, 12.0559, 0.3634> <-1.6014, 12.2155, 0.3828> <-1.6781, 12.3326, 0.3967>
		<-1.4494, 11.9144, 0.3566> <-1.5208, 12.0344, 0.3640> <-1.6207, 12.1946, 0.3829> <-1.6953, 12.3119, 0.3975>
		<-1.4631, 11.9006, 0.3667> <-1.5345, 12.0206, 0.3741> <-1.6276, 12.1811, 0.3937> <-1.7022, 12.2984, 0.4083>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4631, 11.9006, 0.3667> <-1.5345, 12.0206, 0.3741> <-1.6276, 12.1811, 0.3937> <-1.7022, 12.2984, 0.4083>
		<-1.4815, 11.8821, 0.3803> <-1.5529, 12.0021, 0.3877> <-1.6395, 12.1577, 0.4123> <-1.7141, 12.2750, 0.4269>
		<-1.5069, 11.8604, 0.4050> <-1.5689, 11.9752, 0.4188> <-1.6583, 12.1357, 0.4424> <-1.7262, 12.2467, 0.4592>
		<-1.5180, 11.8500, 0.4302> <-1.5800, 11.9648, 0.4440> <-1.6596, 12.1187, 0.4696> <-1.7276, 12.2297, 0.4865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7150, 12.1346, 0.6708> <-1.7268, 12.1564, 0.6136> <-1.7302, 12.1967, 0.5393> <-1.7276, 12.2297, 0.4865>
		<-1.7662, 12.2239, 0.7041> <-1.7780, 12.2457, 0.6469> <-1.8116, 12.3298, 0.5595> <-1.8090, 12.3627, 0.5067>
		<-1.8776, 12.3789, 0.7044> <-1.9182, 12.4445, 0.6241> <-1.9478, 12.5200, 0.4887> <-1.9739, 12.5999, 0.4156>
		<-1.9007, 12.4136, 0.8043> <-1.9413, 12.4793, 0.7239> <-1.9895, 12.5826, 0.6268> <-2.0156, 12.6626, 0.5537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7150, 12.1346, 0.6708> <-1.7662, 12.2239, 0.7041> <-1.8776, 12.3789, 0.7044> <-1.9007, 12.4136, 0.8043>
		<-1.6952, 12.0978, 0.7674> <-1.7464, 12.1872, 0.8007> <-1.8207, 12.2871, 0.8168> <-1.8438, 12.3218, 0.9167>
		<-1.6545, 12.0603, 0.8972> <-1.6768, 12.1043, 0.9473> <-1.7402, 12.1863, 0.9996> <-1.7532, 12.2055, 1.0661>
		<-1.6231, 12.0363, 0.9947> <-1.6453, 12.0803, 1.0449> <-1.6790, 12.1207, 1.1271> <-1.6920, 12.1399, 1.1935>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6231, 12.0363, 0.9947> <-1.6453, 12.0803, 1.0449> <-1.6790, 12.1207, 1.1271> <-1.6920, 12.1399, 1.1935>
		<-1.6063, 12.0235, 1.0468> <-1.6286, 12.0676, 1.0969> <-1.6529, 12.0927, 1.1815> <-1.6658, 12.1119, 1.2479>
		<-1.5831, 12.0061, 1.1194> <-1.6035, 12.0409, 1.1852> <-1.6329, 12.0925, 1.2676> <-1.6475, 12.1112, 1.3410>
		<-1.5549, 12.0126, 1.1675> <-1.5752, 12.0474, 1.2333> <-1.6004, 12.0887, 1.3255> <-1.6150, 12.1074, 1.3990>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5549, 12.0126, 1.1675> <-1.5752, 12.0474, 1.2333> <-1.6004, 12.0887, 1.3255> <-1.6150, 12.1074, 1.3990>
		<-1.5432, 12.0153, 1.1874> <-1.5636, 12.0501, 1.2532> <-1.5866, 12.0871, 1.3501> <-1.6012, 12.1058, 1.4236>
		<-1.5191, 12.0456, 1.1961> <-1.5353, 12.0737, 1.2707> <-1.5608, 12.0947, 1.3773> <-1.5673, 12.1072, 1.4575>
		<-1.5045, 12.0637, 1.1964> <-1.5207, 12.0918, 1.2710> <-1.5370, 12.1098, 1.3782> <-1.5435, 12.1223, 1.4583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5045, 12.0637, 1.1964> <-1.5207, 12.0918, 1.2710> <-1.5370, 12.1098, 1.3782> <-1.5435, 12.1223, 1.4583>
		<-1.4876, 12.0847, 1.1968> <-1.5038, 12.1128, 1.2714> <-1.5136, 12.1247, 1.3790> <-1.5202, 12.1371, 1.4591>
		<-1.4675, 12.1139, 1.1827> <-1.4863, 12.1408, 1.2474> <-1.5024, 12.1519, 1.3515> <-1.5100, 12.1648, 1.4224>
		<-1.4565, 12.1346, 1.1696> <-1.4752, 12.1615, 1.2343> <-1.4914, 12.1681, 1.3320> <-1.4991, 12.1811, 1.4029>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4565, 12.1346, 1.1696> <-1.4752, 12.1615, 1.2343> <-1.4914, 12.1681, 1.3320> <-1.4991, 12.1811, 1.4029>
		<-1.4463, 12.1537, 1.1575> <-1.4650, 12.1806, 1.2222> <-1.4766, 12.1901, 1.3057> <-1.4842, 12.2030, 1.3766>
		<-1.4418, 12.1758, 1.1316> <-1.4602, 12.2016, 1.1830> <-1.4612, 12.2104, 1.2761> <-1.4652, 12.2248, 1.3347>
		<-1.4356, 12.1928, 1.1146> <-1.4540, 12.2186, 1.1660> <-1.4542, 12.2342, 1.2483> <-1.4582, 12.2486, 1.3068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4356, 12.1928, 1.1146> <-1.4540, 12.2186, 1.1660> <-1.4542, 12.2342, 1.2483> <-1.4582, 12.2486, 1.3068>
		<-1.4288, 12.2114, 1.0959> <-1.4472, 12.2373, 1.1473> <-1.4486, 12.2531, 1.2261> <-1.4527, 12.2675, 1.2847>
		<-1.4157, 12.2375, 1.0727> <-1.4400, 12.2663, 1.1214> <-1.4509, 12.2813, 1.1975> <-1.4570, 12.2969, 1.2568>
		<-1.4132, 12.2535, 1.0507> <-1.4375, 12.2822, 1.0994> <-1.4519, 12.3052, 1.1801> <-1.4580, 12.3208, 1.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4132, 12.2535, 1.0507> <-1.4375, 12.2822, 1.0994> <-1.4519, 12.3052, 1.1801> <-1.4580, 12.3208, 1.2393>
		<-1.4086, 12.2823, 1.0108> <-1.4329, 12.3111, 1.0595> <-1.4530, 12.3331, 1.1598> <-1.4591, 12.3486, 1.2190>
		<-1.4159, 12.3134, 0.9519> <-1.4542, 12.3576, 1.0153> <-1.4537, 12.3760, 1.1212> <-1.4601, 12.3951, 1.2051>
		<-1.4123, 12.3404, 0.9106> <-1.4506, 12.3846, 0.9740> <-1.4588, 12.4009, 1.0979> <-1.4652, 12.4200, 1.1818>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4123, 12.3404, 0.9106> <-1.4506, 12.3846, 0.9740> <-1.4588, 12.4009, 1.0979> <-1.4652, 12.4200, 1.1818>
		<-1.4102, 12.3562, 0.8865> <-1.4485, 12.4004, 0.9499> <-1.4660, 12.4360, 1.0650> <-1.4724, 12.4551, 1.1489>
		<-1.3980, 12.3791, 0.8570> <-1.4435, 12.4272, 0.9055> <-1.4860, 12.4557, 1.0184> <-1.4885, 12.4880, 1.0939>
		<-1.3943, 12.3955, 0.8335> <-1.4398, 12.4437, 0.8820> <-1.4959, 12.4845, 0.9803> <-1.4983, 12.5167, 1.0558>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3943, 12.3955, 0.8335> <-1.4398, 12.4437, 0.8820> <-1.4959, 12.4845, 0.9803> <-1.4983, 12.5167, 1.0558>
		<-1.3895, 12.4167, 0.8032> <-1.4350, 12.4649, 0.8517> <-1.5040, 12.5084, 0.9486> <-1.5065, 12.5406, 1.0241>
		<-1.3825, 12.4486, 0.7645> <-1.4366, 12.5003, 0.8090> <-1.5047, 12.5323, 0.9037> <-1.5168, 12.5712, 0.9807>
		<-1.3838, 12.4657, 0.7313> <-1.4379, 12.5175, 0.7759> <-1.5131, 12.5566, 0.8723> <-1.5251, 12.5955, 0.9492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3838, 12.4657, 0.7313> <-1.4379, 12.5175, 0.7759> <-1.5131, 12.5566, 0.8723> <-1.5251, 12.5955, 0.9492>
		<-1.3863, 12.4990, 0.6671> <-1.4403, 12.5507, 0.7117> <-1.5226, 12.5843, 0.8364> <-1.5347, 12.6232, 0.9134>
		<-1.3915, 12.5278, 0.5732> <-1.4603, 12.5941, 0.6333> <-1.5260, 12.6321, 0.7625> <-1.5484, 12.6638, 0.8686>
		<-1.4066, 12.5623, 0.5115> <-1.4755, 12.6286, 0.5715> <-1.5357, 12.6582, 0.7255> <-1.5581, 12.6899, 0.8316>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4066, 12.5623, 0.5115> <-1.4755, 12.6286, 0.5715> <-1.5357, 12.6582, 0.7255> <-1.5581, 12.6899, 0.8316>
		<-1.4155, 12.5825, 0.4752> <-1.4844, 12.6489, 0.5352> <-1.5532, 12.7054, 0.6587> <-1.5756, 12.7371, 0.7648>
		<-1.4393, 12.6351, 0.4449> <-1.4948, 12.7053, 0.4743> <-1.5674, 12.7690, 0.5783> <-1.5852, 12.7949, 0.6672>
		<-1.4624, 12.6448, 0.4106> <-1.5179, 12.7151, 0.4399> <-1.5981, 12.8137, 0.5147> <-1.6159, 12.8395, 0.6036>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4624, 12.6448, 0.4106> <-1.5179, 12.7151, 0.4399> <-1.5981, 12.8137, 0.5147> <-1.6159, 12.8395, 0.6036>
		<-1.4771, 12.6510, 0.3888> <-1.5326, 12.7213, 0.4181> <-1.6246, 12.8522, 0.4599> <-1.6423, 12.8780, 0.5488>
		<-1.5010, 12.6277, 0.3598> <-1.5742, 12.7329, 0.3786> <-1.6691, 12.8865, 0.3670> <-1.6953, 12.9323, 0.4854>
		<-1.5166, 12.6087, 0.3484> <-1.5898, 12.7139, 0.3673> <-1.7193, 12.9166, 0.3252> <-1.7454, 12.9624, 0.4435>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5166, 12.6087, 0.3484> <-1.5898, 12.7139, 0.3673> <-1.7193, 12.9166, 0.3252> <-1.7454, 12.9624, 0.4435>
		<-1.5305, 12.5918, 0.3383> <-1.6037, 12.6970, 0.3571> <-1.7411, 12.9297, 0.3069> <-1.7673, 12.9755, 0.4252>
		<-1.5411, 12.5581, 0.3458> <-1.6320, 12.6886, 0.3618> <-1.7754, 12.9091, 0.2798> <-1.8137, 12.9774, 0.4192>
		<-1.5515, 12.5363, 0.3457> <-1.6425, 12.6668, 0.3617> <-1.8061, 12.9081, 0.2735> <-1.8444, 12.9765, 0.4128>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5515, 12.5363, 0.3457> <-1.6425, 12.6668, 0.3617> <-1.8061, 12.9081, 0.2735> <-1.8444, 12.9765, 0.4128>
		<-1.5597, 12.5192, 0.3456> <-1.6507, 12.6497, 0.3616> <-1.8225, 12.9076, 0.2701> <-1.8608, 12.9760, 0.4095>
		<-1.5698, 12.4957, 0.3446> <-1.6693, 12.6368, 0.3615> <-1.8365, 12.8874, 0.2612> <-1.8825, 12.9656, 0.4091>
		<-1.5786, 12.4792, 0.3478> <-1.6781, 12.6203, 0.3646> <-1.8510, 12.8795, 0.2643> <-1.8970, 12.9577, 0.4122>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5786, 12.4792, 0.3478> <-1.6781, 12.6203, 0.3646> <-1.8510, 12.8795, 0.2643> <-1.8970, 12.9577, 0.4122>
		<-1.5864, 12.4647, 0.3505> <-1.6859, 12.6058, 0.3674> <-1.8645, 12.8721, 0.2672> <-1.9105, 12.9503, 0.4151>
		<-1.5978, 12.4475, 0.3597> <-1.6987, 12.5941, 0.3765> <-1.8729, 12.8579, 0.2744> <-1.9236, 12.9371, 0.4265>
		<-1.6063, 12.4342, 0.3651> <-1.7072, 12.5808, 0.3819> <-1.8836, 12.8480, 0.2802> <-1.9343, 12.9272, 0.4323>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6063, 12.4342, 0.3651> <-1.7072, 12.5808, 0.3819> <-1.8836, 12.8480, 0.2802> <-1.9343, 12.9272, 0.4323>
		<-1.6144, 12.4216, 0.3702> <-1.7153, 12.5682, 0.3870> <-1.8939, 12.8385, 0.2858> <-1.9447, 12.9177, 0.4378>
		<-1.6253, 12.4054, 0.3787> <-1.7261, 12.5552, 0.3962> <-1.9020, 12.8250, 0.2933> <-1.9584, 12.9050, 0.4460>
		<-1.6341, 12.3929, 0.3827> <-1.7349, 12.5427, 0.4002> <-1.9107, 12.8132, 0.2971> <-1.9670, 12.8932, 0.4499>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6341, 12.3929, 0.3827> <-1.7349, 12.5427, 0.4002> <-1.9107, 12.8132, 0.2971> <-1.9670, 12.8932, 0.4499>
		<-1.6437, 12.3793, 0.3870> <-1.7445, 12.5291, 0.4046> <-1.9210, 12.7992, 0.3017> <-1.9773, 12.8792, 0.4544>
		<-1.6577, 12.3610, 0.3890> <-1.7556, 12.5104, 0.4068> <-1.9318, 12.7831, 0.3043> <-1.9899, 12.8584, 0.4565>
		<-1.6675, 12.3473, 0.3927> <-1.7654, 12.4967, 0.4105> <-1.9387, 12.7668, 0.3078> <-1.9968, 12.8422, 0.4599>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6675, 12.3473, 0.3927> <-1.7654, 12.4967, 0.4105> <-1.9387, 12.7668, 0.3078> <-1.9968, 12.8422, 0.4599>
		<-1.6781, 12.3326, 0.3967> <-1.7760, 12.4820, 0.4145> <-1.9472, 12.7468, 0.3120> <-2.0053, 12.8222, 0.4642>
		<-1.6953, 12.3119, 0.3975> <-1.7873, 12.4564, 0.4155> <-1.9643, 12.7237, 0.3161> <-2.0161, 12.7927, 0.4652>
		<-1.7022, 12.2984, 0.4083> <-1.7941, 12.4429, 0.4263> <-1.9663, 12.7041, 0.3263> <-2.0181, 12.7732, 0.4754>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7022, 12.2984, 0.4083> <-1.7941, 12.4429, 0.4263> <-1.9663, 12.7041, 0.3263> <-2.0181, 12.7732, 0.4754>
		<-1.7141, 12.2750, 0.4269> <-1.8061, 12.4196, 0.4449> <-1.9701, 12.6683, 0.3451> <-2.0219, 12.7373, 0.4942>
		<-1.7262, 12.2467, 0.4592> <-1.8077, 12.3797, 0.4794> <-1.9834, 12.6291, 0.3889> <-2.0251, 12.6917, 0.5270>
		<-1.7276, 12.2297, 0.4865> <-1.8090, 12.3627, 0.5067> <-1.9739, 12.5999, 0.4156> <-2.0156, 12.6626, 0.5537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9007, 12.4136, 0.8043> <-1.9413, 12.4793, 0.7239> <-1.9895, 12.5826, 0.6268> <-2.0156, 12.6626, 0.5537>
		<-1.9346, 12.4646, 0.9508> <-1.9753, 12.5303, 0.8704> <-2.0411, 12.6602, 0.7976> <-2.0672, 12.7401, 0.7245>
		<-1.8718, 12.3742, 1.1718> <-1.8975, 12.4179, 1.1194> <-1.9356, 12.5235, 1.0338> <-1.9556, 12.5831, 0.9967>
		<-1.8678, 12.3641, 1.3303> <-1.8935, 12.4079, 1.2778> <-1.9192, 12.4881, 1.2244> <-1.9392, 12.5477, 1.1873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9007, 12.4136, 0.8043> <-1.9346, 12.4646, 0.9508> <-1.8718, 12.3742, 1.1718> <-1.8678, 12.3641, 1.3303>
		<-1.8438, 12.3218, 0.9167> <-1.8778, 12.3728, 1.0632> <-1.8367, 12.3147, 1.2433> <-1.8327, 12.3046, 1.4017>
		<-1.7532, 12.2055, 1.0661> <-1.7758, 12.2390, 1.1819> <-1.7607, 12.2352, 1.4012> <-1.7854, 12.2570, 1.5193>
		<-1.6920, 12.1399, 1.1935> <-1.7145, 12.1733, 1.3093> <-1.7151, 12.1874, 1.4754> <-1.7399, 12.2093, 1.5935>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6920, 12.1399, 1.1935> <-1.7145, 12.1733, 1.3093> <-1.7151, 12.1874, 1.4754> <-1.7399, 12.2093, 1.5935>
		<-1.6658, 12.1119, 1.2479> <-1.6884, 12.1453, 1.3637> <-1.6965, 12.1679, 1.5058> <-1.7213, 12.1898, 1.6239>
		<-1.6475, 12.1112, 1.3410> <-1.6635, 12.1317, 1.4215> <-1.6738, 12.1470, 1.5819> <-1.6924, 12.1557, 1.6640>
		<-1.6150, 12.1074, 1.3990> <-1.6310, 12.1279, 1.4794> <-1.6374, 12.1334, 1.5937> <-1.6559, 12.1421, 1.6757>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6150, 12.1074, 1.3990> <-1.6310, 12.1279, 1.4794> <-1.6374, 12.1334, 1.5937> <-1.6559, 12.1421, 1.6757>
		<-1.6012, 12.1058, 1.4236> <-1.6172, 12.1263, 1.5040> <-1.6063, 12.1218, 1.6037> <-1.6249, 12.1305, 1.6857>
		<-1.5673, 12.1072, 1.4575> <-1.5721, 12.1163, 1.5164> <-1.5713, 12.1212, 1.6139> <-1.5701, 12.1230, 1.6737>
		<-1.5435, 12.1223, 1.4583> <-1.5483, 12.1315, 1.5172> <-1.5434, 12.1336, 1.5975> <-1.5422, 12.1354, 1.6573>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5435, 12.1223, 1.4583> <-1.5483, 12.1315, 1.5172> <-1.5434, 12.1336, 1.5975> <-1.5422, 12.1354, 1.6573>
		<-1.5202, 12.1371, 1.4591> <-1.5250, 12.1463, 1.5180> <-1.5163, 12.1455, 1.5815> <-1.5151, 12.1474, 1.6413>
		<-1.5100, 12.1648, 1.4224> <-1.5159, 12.1747, 1.4764> <-1.5176, 12.1817, 1.5497> <-1.5133, 12.1861, 1.6045>
		<-1.4991, 12.1811, 1.4029> <-1.5049, 12.1910, 1.4569> <-1.5057, 12.2060, 1.5297> <-1.5014, 12.2105, 1.5846>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4991, 12.1811, 1.4029> <-1.5049, 12.1910, 1.4569> <-1.5057, 12.2060, 1.5297> <-1.5014, 12.2105, 1.5846>
		<-1.4842, 12.2030, 1.3766> <-1.4901, 12.2129, 1.4306> <-1.4942, 12.2296, 1.5105> <-1.4898, 12.2340, 1.5653>
		<-1.4652, 12.2248, 1.3347> <-1.4698, 12.2410, 1.4001> <-1.4740, 12.2664, 1.4807> <-1.4716, 12.2708, 1.5480>
		<-1.4582, 12.2486, 1.3068> <-1.4628, 12.2648, 1.3722> <-1.4665, 12.2902, 1.4597> <-1.4642, 12.2946, 1.5271>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4582, 12.2486, 1.3068> <-1.4628, 12.2648, 1.3722> <-1.4665, 12.2902, 1.4597> <-1.4642, 12.2946, 1.5271>
		<-1.4527, 12.2675, 1.2847> <-1.4572, 12.2837, 1.3501> <-1.4598, 12.3118, 1.4407> <-1.4574, 12.3162, 1.5080>
		<-1.4570, 12.2969, 1.2568> <-1.4635, 12.3134, 1.3196> <-1.4602, 12.3332, 1.4104> <-1.4571, 12.3396, 1.4752>
		<-1.4580, 12.3208, 1.2393> <-1.4645, 12.3373, 1.3021> <-1.4579, 12.3529, 1.3885> <-1.4548, 12.3593, 1.4533>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4580, 12.3208, 1.2393> <-1.4645, 12.3373, 1.3021> <-1.4579, 12.3529, 1.3885> <-1.4548, 12.3593, 1.4533>
		<-1.4591, 12.3486, 1.2190> <-1.4656, 12.3651, 1.2818> <-1.4550, 12.3778, 1.3609> <-1.4519, 12.3842, 1.4258>
		<-1.4601, 12.3951, 1.2051> <-1.4642, 12.4073, 1.2585> <-1.4573, 12.4143, 1.3343> <-1.4527, 12.4179, 1.3889>
		<-1.4652, 12.4200, 1.1818> <-1.4693, 12.4321, 1.2352> <-1.4515, 12.4397, 1.3077> <-1.4469, 12.4433, 1.3623>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4652, 12.4200, 1.1818> <-1.4693, 12.4321, 1.2352> <-1.4515, 12.4397, 1.3077> <-1.4469, 12.4433, 1.3623>
		<-1.4724, 12.4551, 1.1489> <-1.4765, 12.4673, 1.2022> <-1.4430, 12.4769, 1.2688> <-1.4384, 12.4805, 1.3234>
		<-1.4885, 12.4880, 1.0939> <-1.4903, 12.5125, 1.1512> <-1.4169, 12.5249, 1.2099> <-1.4067, 12.5261, 1.2714>
		<-1.4983, 12.5167, 1.0558> <-1.5001, 12.5412, 1.1131> <-1.4175, 12.5660, 1.1742> <-1.4073, 12.5672, 1.2356>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4983, 12.5167, 1.0558> <-1.5001, 12.5412, 1.1131> <-1.4175, 12.5660, 1.1742> <-1.4073, 12.5672, 1.2356>
		<-1.5065, 12.5406, 1.0241> <-1.5083, 12.5651, 1.0814> <-1.4180, 12.5988, 1.1456> <-1.4078, 12.6001, 1.2071>
		<-1.5168, 12.5712, 0.9807> <-1.5266, 12.6028, 1.0432> <-1.4390, 12.6484, 1.1113> <-1.4297, 12.6517, 1.1813>
		<-1.5251, 12.5955, 0.9492> <-1.5349, 12.6271, 1.0118> <-1.4597, 12.6771, 1.0861> <-1.4505, 12.6805, 1.1561>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5251, 12.5955, 0.9492> <-1.5349, 12.6271, 1.0118> <-1.4597, 12.6771, 1.0861> <-1.4505, 12.6805, 1.1561>
		<-1.5347, 12.6232, 0.9134> <-1.5445, 12.6548, 0.9759> <-1.4765, 12.7002, 1.0658> <-1.4672, 12.7036, 1.1359>
		<-1.5484, 12.6638, 0.8686> <-1.5640, 12.6859, 0.9426> <-1.5131, 12.7097, 1.0279> <-1.5080, 12.7129, 1.1065>
		<-1.5581, 12.6899, 0.8316> <-1.5737, 12.7121, 0.9056> <-1.5337, 12.7317, 1.0101> <-1.5286, 12.7349, 1.0887>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5581, 12.6899, 0.8316> <-1.5737, 12.7121, 0.9056> <-1.5337, 12.7317, 1.0101> <-1.5286, 12.7349, 1.0887>
		<-1.5756, 12.7371, 0.7648> <-1.5913, 12.7592, 0.8388> <-1.5550, 12.7544, 0.9917> <-1.5499, 12.7577, 1.0702>
		<-1.5852, 12.7949, 0.6672> <-1.6098, 12.8306, 0.7903> <-1.5675, 12.8079, 0.9182> <-1.5632, 12.8026, 1.0485>
		<-1.6159, 12.8395, 0.6036> <-1.6405, 12.8753, 0.7266> <-1.5920, 12.8321, 0.9071> <-1.5877, 12.8268, 1.0374>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6159, 12.8395, 0.6036> <-1.6405, 12.8753, 0.7266> <-1.5920, 12.8321, 0.9071> <-1.5877, 12.8268, 1.0374>
		<-1.6423, 12.8780, 0.5488> <-1.6669, 12.9137, 0.6719> <-1.6105, 12.8504, 0.8988> <-1.6062, 12.8451, 1.0291>
		<-1.6953, 12.9323, 0.4854> <-1.7313, 12.9955, 0.6485> <-1.6553, 12.8799, 0.8440> <-1.6417, 12.8611, 1.0211>
		<-1.7454, 12.9624, 0.4435> <-1.7815, 13.0255, 0.6066> <-1.6801, 12.8900, 0.8494> <-1.6665, 12.8712, 1.0266>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7454, 12.9624, 0.4435> <-1.7815, 13.0255, 0.6066> <-1.6801, 12.8900, 0.8494> <-1.6665, 12.8712, 1.0266>
		<-1.7673, 12.9755, 0.4252> <-1.8033, 13.0386, 0.5884> <-1.7071, 12.9009, 0.8554> <-1.6935, 12.8821, 1.0325>
		<-1.8137, 12.9774, 0.4192> <-1.8619, 13.0636, 0.5950> <-1.7447, 12.9103, 0.8581> <-1.7258, 12.8904, 1.0578>
		<-1.8444, 12.9765, 0.4128> <-1.8926, 13.0627, 0.5886> <-1.7699, 12.9130, 0.8735> <-1.7511, 12.8931, 1.0733>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8444, 12.9765, 0.4128> <-1.8926, 13.0627, 0.5886> <-1.7699, 12.9130, 0.8735> <-1.7511, 12.8931, 1.0733>
		<-1.8608, 12.9760, 0.4095> <-1.9090, 13.0622, 0.5853> <-1.7909, 12.9152, 0.8862> <-1.7720, 12.8953, 1.0860>
		<-1.8825, 12.9656, 0.4091> <-1.9394, 13.0623, 0.5919> <-1.8180, 12.9118, 0.8915> <-1.7999, 12.8930, 1.1044>
		<-1.8970, 12.9577, 0.4122> <-1.9538, 13.0544, 0.5950> <-1.8367, 12.9061, 0.9065> <-1.8186, 12.8873, 1.1194>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8970, 12.9577, 0.4122> <-1.9538, 13.0544, 0.5950> <-1.8367, 12.9061, 0.9065> <-1.8186, 12.8873, 1.1194>
		<-1.9105, 12.9503, 0.4151> <-1.9674, 13.0470, 0.5979> <-1.8561, 12.9002, 0.9219> <-1.8380, 12.8814, 1.1348>
		<-1.9236, 12.9371, 0.4265> <-1.9872, 13.0363, 0.6169> <-1.8732, 12.8912, 0.9436> <-1.8575, 12.8710, 1.1660>
		<-1.9343, 12.9272, 0.4323> <-1.9979, 13.0264, 0.6227> <-1.8916, 12.8750, 0.9504> <-1.8760, 12.8549, 1.1729>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9343, 12.9272, 0.4323> <-1.9979, 13.0264, 0.6227> <-1.8916, 12.8750, 0.9504> <-1.8760, 12.8549, 1.1729>
		<-1.9447, 12.9177, 0.4378> <-2.0082, 13.0169, 0.6283> <-1.9075, 12.8611, 0.9563> <-1.8919, 12.8409, 1.1788>
		<-1.9584, 12.9050, 0.4460> <-2.0250, 12.9996, 0.6267> <-1.9195, 12.8427, 0.9475> <-1.9085, 12.8171, 1.1602>
		<-1.9670, 12.8932, 0.4499> <-2.0337, 12.9878, 0.6305> <-1.9308, 12.8242, 0.9444> <-1.9198, 12.7985, 1.1571>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9670, 12.8932, 0.4499> <-2.0337, 12.9878, 0.6305> <-1.9308, 12.8242, 0.9444> <-1.9198, 12.7985, 1.1571>
		<-1.9773, 12.8792, 0.4544> <-2.0440, 12.9738, 0.6350> <-1.9439, 12.8027, 0.9407> <-1.9329, 12.7771, 1.1534>
		<-1.9899, 12.8584, 0.4565> <-2.0580, 12.9469, 0.6350> <-1.9616, 12.7764, 0.9424> <-1.9501, 12.7472, 1.1506>
		<-1.9968, 12.8422, 0.4599> <-2.0649, 12.9307, 0.6384> <-1.9683, 12.7519, 0.9422> <-1.9568, 12.7227, 1.1504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9968, 12.8422, 0.4599> <-2.0649, 12.9307, 0.6384> <-1.9683, 12.7519, 0.9422> <-1.9568, 12.7227, 1.1504>
		<-2.0053, 12.8222, 0.4642> <-2.0734, 12.9106, 0.6427> <-1.9745, 12.7292, 0.9420> <-1.9630, 12.7000, 1.1502>
		<-2.0161, 12.7927, 0.4652> <-2.0787, 12.8763, 0.6457> <-1.9777, 12.6995, 0.9455> <-1.9640, 12.6675, 1.1511>
		<-2.0181, 12.7732, 0.4754> <-2.0807, 12.8567, 0.6559> <-1.9753, 12.6765, 0.9504> <-1.9617, 12.6445, 1.1559>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0181, 12.7732, 0.4754> <-2.0807, 12.8567, 0.6559> <-1.9753, 12.6765, 0.9504> <-1.9617, 12.6445, 1.1559>
		<-2.0219, 12.7373, 0.4942> <-2.0845, 12.8208, 0.6746> <-1.9723, 12.6461, 0.9568> <-1.9587, 12.6141, 1.1623>
		<-2.0251, 12.6917, 0.5270> <-2.0767, 12.7693, 0.6978> <-1.9642, 12.6087, 0.9809> <-1.9477, 12.5733, 1.1715>
		<-2.0156, 12.6626, 0.5537> <-2.0672, 12.7401, 0.7245> <-1.9556, 12.5831, 0.9967> <-1.9392, 12.5477, 1.1873>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8678, 12.3641, 1.3303> <-1.8935, 12.4079, 1.2778> <-1.9192, 12.4881, 1.2244> <-1.9392, 12.5477, 1.1873>
		<-1.8652, 12.3578, 1.4301> <-1.8910, 12.4016, 1.3777> <-1.9084, 12.4649, 1.3493> <-1.9284, 12.5246, 1.3122>
		<-1.8755, 12.3611, 1.5637> <-1.8919, 12.3923, 1.5457> <-1.9159, 12.4470, 1.4950> <-1.9254, 12.4812, 1.4776>
		<-1.8789, 12.3592, 1.6637> <-1.8953, 12.3904, 1.6457> <-1.9155, 12.4332, 1.6217> <-1.9249, 12.4675, 1.6044>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8678, 12.3641, 1.3303> <-1.8652, 12.3578, 1.4301> <-1.8755, 12.3611, 1.5637> <-1.8789, 12.3592, 1.6637>
		<-1.8327, 12.3046, 1.4017> <-1.8302, 12.2983, 1.5016> <-1.8559, 12.3239, 1.5851> <-1.8594, 12.3220, 1.6851>
		<-1.7854, 12.2570, 1.5193> <-1.7951, 12.2655, 1.5653> <-1.8242, 12.2702, 1.6669> <-1.8322, 12.2725, 1.7140>
		<-1.7399, 12.2093, 1.5935> <-1.7495, 12.2178, 1.6396> <-1.7974, 12.2378, 1.6884> <-1.8054, 12.2401, 1.7354>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7399, 12.2093, 1.5935> <-1.7495, 12.2178, 1.6396> <-1.7974, 12.2378, 1.6884> <-1.8054, 12.2401, 1.7354>
		<-1.7213, 12.1898, 1.6239> <-1.7309, 12.1983, 1.6699> <-1.7720, 12.2070, 1.7087> <-1.7800, 12.2093, 1.7558>
		<-1.6924, 12.1557, 1.6640> <-1.7013, 12.1599, 1.7036> <-1.7387, 12.1651, 1.7442> <-1.7449, 12.1652, 1.7846>
		<-1.6559, 12.1421, 1.6757> <-1.6649, 12.1463, 1.7153> <-1.7003, 12.1501, 1.7616> <-1.7064, 12.1502, 1.8020>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6559, 12.1421, 1.6757> <-1.6649, 12.1463, 1.7153> <-1.7003, 12.1501, 1.7616> <-1.7064, 12.1502, 1.8020>
		<-1.6249, 12.1305, 1.6857> <-1.6339, 12.1347, 1.7254> <-1.6538, 12.1319, 1.7825> <-1.6600, 12.1320, 1.8229>
		<-1.5701, 12.1230, 1.6737> <-1.5689, 12.1249, 1.7337> <-1.5879, 12.1210, 1.7954> <-1.5878, 12.1206, 1.8555>
		<-1.5422, 12.1354, 1.6573> <-1.5410, 12.1372, 1.7173> <-1.5356, 12.1350, 1.7972> <-1.5355, 12.1345, 1.8572>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5422, 12.1354, 1.6573> <-1.5410, 12.1372, 1.7173> <-1.5356, 12.1350, 1.7972> <-1.5355, 12.1345, 1.8572>
		<-1.5151, 12.1474, 1.6413> <-1.5139, 12.1492, 1.7013> <-1.5023, 12.1439, 1.7984> <-1.5022, 12.1434, 1.8584>
		<-1.5133, 12.1861, 1.6045> <-1.5079, 12.1916, 1.6726> <-1.4909, 12.1849, 1.7575> <-1.4837, 12.1881, 1.8255>
		<-1.5014, 12.2105, 1.5846> <-1.4960, 12.2160, 1.6526> <-1.4741, 12.2109, 1.7422> <-1.4668, 12.2141, 1.8102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5014, 12.2105, 1.5846> <-1.4960, 12.2160, 1.6526> <-1.4741, 12.2109, 1.7422> <-1.4668, 12.2141, 1.8102>
		<-1.4898, 12.2340, 1.5653> <-1.4844, 12.2395, 1.6334> <-1.4625, 12.2287, 1.7316> <-1.4552, 12.2320, 1.7996>
		<-1.4716, 12.2708, 1.5480> <-1.4690, 12.2756, 1.6218> <-1.4522, 12.2601, 1.7142> <-1.4454, 12.2614, 1.7878>
		<-1.4642, 12.2946, 1.5271> <-1.4616, 12.2994, 1.6008> <-1.4487, 12.2776, 1.6984> <-1.4419, 12.2789, 1.7721>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4642, 12.2946, 1.5271> <-1.4616, 12.2994, 1.6008> <-1.4487, 12.2776, 1.6984> <-1.4419, 12.2789, 1.7721>
		<-1.4574, 12.3162, 1.5080> <-1.4548, 12.3210, 1.5818> <-1.4431, 12.3060, 1.6729> <-1.4363, 12.3073, 1.7465>
		<-1.4571, 12.3396, 1.4752> <-1.4539, 12.3461, 1.5417> <-1.4452, 12.3331, 1.6363> <-1.4392, 12.3366, 1.7028>
		<-1.4548, 12.3593, 1.4533> <-1.4516, 12.3659, 1.5198> <-1.4432, 12.3603, 1.6090> <-1.4372, 12.3638, 1.6755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4548, 12.3593, 1.4533> <-1.4516, 12.3659, 1.5198> <-1.4432, 12.3603, 1.6090> <-1.4372, 12.3638, 1.6755>
		<-1.4519, 12.3842, 1.4258> <-1.4487, 12.3907, 1.4922> <-1.4415, 12.3839, 1.5853> <-1.4355, 12.3874, 1.6518>
		<-1.4527, 12.4179, 1.3889> <-1.4466, 12.4227, 1.4607> <-1.4375, 12.4213, 1.5529> <-1.4322, 12.4231, 1.6248>
		<-1.4469, 12.4433, 1.3623> <-1.4408, 12.4481, 1.4341> <-1.4349, 12.4459, 1.5303> <-1.4296, 12.4477, 1.6022>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4469, 12.4433, 1.3623> <-1.4408, 12.4481, 1.4341> <-1.4349, 12.4459, 1.5303> <-1.4296, 12.4477, 1.6022>
		<-1.4384, 12.4805, 1.3234> <-1.4323, 12.4852, 1.3951> <-1.4324, 12.4700, 1.5081> <-1.4270, 12.4718, 1.5800>
		<-1.4067, 12.5261, 1.2714> <-1.3922, 12.5279, 1.3583> <-1.4165, 12.5020, 1.4539> <-1.4165, 12.4975, 1.5420>
		<-1.4073, 12.5672, 1.2356> <-1.3928, 12.5690, 1.3225> <-1.4201, 12.5306, 1.4382> <-1.4200, 12.5261, 1.5262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4073, 12.5672, 1.2356> <-1.3928, 12.5690, 1.3225> <-1.4201, 12.5306, 1.4382> <-1.4200, 12.5261, 1.5262>
		<-1.4078, 12.6001, 1.2071> <-1.3933, 12.6018, 1.2940> <-1.4234, 12.5576, 1.4234> <-1.4234, 12.5531, 1.5114>
		<-1.4297, 12.6517, 1.1813> <-1.4157, 12.6568, 1.2867> <-1.4395, 12.6016, 1.4015> <-1.4378, 12.5946, 1.5077>
		<-1.4505, 12.6805, 1.1561> <-1.4365, 12.6856, 1.2615> <-1.4530, 12.6294, 1.4000> <-1.4514, 12.6224, 1.5062>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4505, 12.6805, 1.1561> <-1.4365, 12.6856, 1.2615> <-1.4530, 12.6294, 1.4000> <-1.4514, 12.6224, 1.5062>
		<-1.4672, 12.7036, 1.1359> <-1.4532, 12.7087, 1.2413> <-1.4681, 12.6603, 1.3982> <-1.4664, 12.6533, 1.5044>
		<-1.5080, 12.7129, 1.1065> <-1.4996, 12.7182, 1.2343> <-1.4971, 12.6928, 1.3792> <-1.4936, 12.6914, 1.5073>
		<-1.5286, 12.7349, 1.0887> <-1.5203, 12.7402, 1.2164> <-1.5171, 12.7197, 1.3872> <-1.5136, 12.7183, 1.5152>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5286, 12.7349, 1.0887> <-1.5203, 12.7402, 1.2164> <-1.5171, 12.7197, 1.3872> <-1.5136, 12.7183, 1.5152>
		<-1.5499, 12.7577, 1.0702> <-1.5416, 12.7629, 1.1980> <-1.5375, 12.7470, 1.3953> <-1.5340, 12.7456, 1.5233>
		<-1.5632, 12.8026, 1.0485> <-1.5580, 12.7962, 1.2049> <-1.5600, 12.7809, 1.4022> <-1.5577, 12.7775, 1.5588>
		<-1.5877, 12.8268, 1.0374> <-1.5825, 12.8204, 1.1939> <-1.5864, 12.8039, 1.4023> <-1.5842, 12.8006, 1.5589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5877, 12.8268, 1.0374> <-1.5825, 12.8204, 1.1939> <-1.5864, 12.8039, 1.4023> <-1.5842, 12.8006, 1.5589>
		<-1.6062, 12.8451, 1.0291> <-1.6010, 12.8387, 1.1855> <-1.6093, 12.8240, 1.4025> <-1.6071, 12.8207, 1.5591>
		<-1.6417, 12.8611, 1.0211> <-1.6304, 12.8457, 1.1669> <-1.6390, 12.8403, 1.3811> <-1.6371, 12.8375, 1.5281>
		<-1.6665, 12.8712, 1.0266> <-1.6552, 12.8557, 1.1723> <-1.6647, 12.8515, 1.3691> <-1.6628, 12.8487, 1.5161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6665, 12.8712, 1.0266> <-1.6552, 12.8557, 1.1723> <-1.6647, 12.8515, 1.3691> <-1.6628, 12.8487, 1.5161>
		<-1.6935, 12.8821, 1.0325> <-1.6822, 12.8667, 1.1782> <-1.6872, 12.8612, 1.3585> <-1.6853, 12.8584, 1.5055>
		<-1.7258, 12.8904, 1.0578> <-1.7142, 12.8782, 1.1802> <-1.7199, 12.8698, 1.3691> <-1.7180, 12.8669, 1.4926>
		<-1.7511, 12.8931, 1.0733> <-1.7395, 12.8809, 1.1956> <-1.7451, 12.8726, 1.3608> <-1.7432, 12.8697, 1.4842>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7511, 12.8931, 1.0733> <-1.7395, 12.8809, 1.1956> <-1.7451, 12.8726, 1.3608> <-1.7432, 12.8697, 1.4842>
		<-1.7720, 12.8953, 1.0860> <-1.7604, 12.8831, 1.2084> <-1.7639, 12.8746, 1.3546> <-1.7620, 12.8717, 1.4780>
		<-1.7999, 12.8930, 1.1044> <-1.7911, 12.8838, 1.2086> <-1.7904, 12.8728, 1.3663> <-1.7885, 12.8700, 1.4712>
		<-1.8186, 12.8873, 1.1194> <-1.8098, 12.8781, 1.2236> <-1.8092, 12.8670, 1.3634> <-1.8073, 12.8643, 1.4683>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8186, 12.8873, 1.1194> <-1.8098, 12.8781, 1.2236> <-1.8092, 12.8670, 1.3634> <-1.8073, 12.8643, 1.4683>
		<-1.8380, 12.8814, 1.1348> <-1.8292, 12.8721, 1.2390> <-1.8269, 12.8616, 1.3607> <-1.8251, 12.8589, 1.4656>
		<-1.8575, 12.8710, 1.1660> <-1.8514, 12.8631, 1.2537> <-1.8495, 12.8485, 1.3764> <-1.8478, 12.8460, 1.4646>
		<-1.8760, 12.8549, 1.1729> <-1.8698, 12.8469, 1.2606> <-1.8634, 12.8361, 1.3778> <-1.8617, 12.8335, 1.4660>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8760, 12.8549, 1.1729> <-1.8698, 12.8469, 1.2606> <-1.8634, 12.8361, 1.3778> <-1.8617, 12.8335, 1.4660>
		<-1.8919, 12.8409, 1.1788> <-1.8857, 12.8330, 1.2665> <-1.8821, 12.8194, 1.3796> <-1.8804, 12.8169, 1.4678>
		<-1.9085, 12.8171, 1.1602> <-1.9035, 12.8055, 1.2563> <-1.9021, 12.7945, 1.3761> <-1.9018, 12.7906, 1.4729>
		<-1.9198, 12.7985, 1.1571> <-1.9149, 12.7870, 1.2531> <-1.9141, 12.7732, 1.3818> <-1.9138, 12.7693, 1.4786>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9198, 12.7985, 1.1571> <-1.9149, 12.7870, 1.2531> <-1.9141, 12.7732, 1.3818> <-1.9138, 12.7693, 1.4786>
		<-1.9329, 12.7771, 1.1534> <-1.9280, 12.7655, 1.2495> <-1.9258, 12.7526, 1.3873> <-1.9254, 12.7486, 1.4842>
		<-1.9501, 12.7472, 1.1506> <-1.9443, 12.7325, 1.2555> <-1.9359, 12.7226, 1.3884> <-1.9344, 12.7185, 1.4945>
		<-1.9568, 12.7227, 1.1504> <-1.9510, 12.7080, 1.2553> <-1.9406, 12.7002, 1.3967> <-1.9391, 12.6961, 1.5027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9568, 12.7227, 1.1504> <-1.9510, 12.7080, 1.2553> <-1.9406, 12.7002, 1.3967> <-1.9391, 12.6961, 1.5027>
		<-1.9630, 12.7000, 1.1502> <-1.9572, 12.6853, 1.2552> <-1.9462, 12.6738, 1.4064> <-1.9446, 12.6697, 1.5124>
		<-1.9640, 12.6675, 1.1511> <-1.9565, 12.6498, 1.2647> <-1.9500, 12.6400, 1.4113> <-1.9493, 12.6339, 1.5264>
		<-1.9617, 12.6445, 1.1559> <-1.9542, 12.6268, 1.2695> <-1.9484, 12.6138, 1.4229> <-1.9476, 12.6077, 1.5380>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9617, 12.6445, 1.1559> <-1.9542, 12.6268, 1.2695> <-1.9484, 12.6138, 1.4229> <-1.9476, 12.6077, 1.5380>
		<-1.9587, 12.6141, 1.1623> <-1.9511, 12.5964, 1.2760> <-1.9457, 12.5709, 1.4420> <-1.9450, 12.5648, 1.5571>
		<-1.9477, 12.5733, 1.1715> <-1.9370, 12.5501, 1.2963> <-1.9366, 12.5220, 1.4570> <-1.9362, 12.5082, 1.5838>
		<-1.9392, 12.5477, 1.1873> <-1.9284, 12.5246, 1.3122> <-1.9254, 12.4812, 1.4776> <-1.9249, 12.4675, 1.6044>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8789, 12.3592, 1.6637> <-1.8953, 12.3904, 1.6457> <-1.9155, 12.4332, 1.6217> <-1.9249, 12.4675, 1.6044>
		<-1.8826, 12.3571, 1.7724> <-1.8990, 12.3883, 1.7545> <-1.9151, 12.4204, 1.7400> <-1.9245, 12.4546, 1.7227>
		<-1.8903, 12.3520, 1.9173> <-1.9065, 12.3833, 1.9096> <-1.9260, 12.4258, 1.8891> <-1.9348, 12.4601, 1.8817>
		<-1.8916, 12.3509, 2.0261> <-1.9078, 12.3822, 2.0184> <-1.9276, 12.4253, 2.0081> <-1.9365, 12.4596, 2.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8789, 12.3592, 1.6637> <-1.8826, 12.3571, 1.7724> <-1.8903, 12.3520, 1.9173> <-1.8916, 12.3509, 2.0261>
		<-1.8594, 12.3220, 1.6851> <-1.8631, 12.3199, 1.7939> <-1.8710, 12.3148, 1.9265> <-1.8723, 12.3137, 2.0353>
		<-1.8322, 12.2725, 1.7140> <-1.8483, 12.2771, 1.8091> <-1.8446, 12.2658, 1.9512> <-1.8453, 12.2640, 2.0477>
		<-1.8054, 12.2401, 1.7354> <-1.8215, 12.2447, 1.8305> <-1.8177, 12.2336, 1.9604> <-1.8185, 12.2319, 2.0569>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8054, 12.2401, 1.7354> <-1.8215, 12.2447, 1.8305> <-1.8177, 12.2336, 1.9604> <-1.8185, 12.2319, 2.0569>
		<-1.7800, 12.2093, 1.7558> <-1.7961, 12.2139, 1.8509> <-1.7920, 12.2028, 1.9692> <-1.7928, 12.2011, 2.0657>
		<-1.7449, 12.1652, 1.7846> <-1.7576, 12.1655, 1.8688> <-1.7560, 12.1590, 1.9932> <-1.7562, 12.1569, 2.0783>
		<-1.7064, 12.1502, 1.8020> <-1.7192, 12.1504, 1.8862> <-1.7179, 12.1452, 2.0003> <-1.7181, 12.1432, 2.0854>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7064, 12.1502, 1.8020> <-1.7192, 12.1504, 1.8862> <-1.7179, 12.1452, 2.0003> <-1.7181, 12.1432, 2.0854>
		<-1.6600, 12.1320, 1.8229> <-1.6727, 12.1322, 1.9071> <-1.6683, 12.1273, 2.0097> <-1.6685, 12.1253, 2.0948>
		<-1.5878, 12.1206, 1.8555> <-1.5876, 12.1200, 1.9310> <-1.5927, 12.1166, 2.0305> <-1.5921, 12.1147, 2.1061>
		<-1.5355, 12.1345, 1.8572> <-1.5354, 12.1339, 1.9328> <-1.5420, 12.1337, 2.0336> <-1.5414, 12.1318, 2.1091>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5355, 12.1345, 1.8572> <-1.5354, 12.1339, 1.9328> <-1.5420, 12.1337, 2.0336> <-1.5414, 12.1318, 2.1091>
		<-1.5022, 12.1434, 1.8584> <-1.5020, 12.1428, 1.9340> <-1.5021, 12.1472, 2.0360> <-1.5015, 12.1452, 2.1115>
		<-1.4837, 12.1881, 1.8255> <-1.4744, 12.1922, 1.9129> <-1.4747, 12.2010, 2.0170> <-1.4715, 12.2012, 2.1049>
		<-1.4668, 12.2141, 1.8102> <-1.4575, 12.2182, 1.8975> <-1.4495, 12.2346, 2.0139> <-1.4464, 12.2349, 2.1018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4668, 12.2141, 1.8102> <-1.4575, 12.2182, 1.8975> <-1.4495, 12.2346, 2.0139> <-1.4464, 12.2349, 2.1018>
		<-1.4552, 12.2320, 1.7996> <-1.4459, 12.2361, 1.8870> <-1.4354, 12.2534, 2.0122> <-1.4323, 12.2537, 2.1001>
		<-1.4454, 12.2614, 1.7878> <-1.4364, 12.2632, 1.8844> <-1.4228, 12.2816, 1.9995> <-1.4186, 12.2826, 2.0964>
		<-1.4419, 12.2789, 1.7721> <-1.4329, 12.2807, 1.8687> <-1.4160, 12.3039, 1.9962> <-1.4118, 12.3049, 2.0932>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4419, 12.2789, 1.7721> <-1.4329, 12.2807, 1.8687> <-1.4160, 12.3039, 1.9962> <-1.4118, 12.3049, 2.0932>
		<-1.4363, 12.3073, 1.7465> <-1.4273, 12.3091, 1.8432> <-1.4082, 12.3294, 1.9925> <-1.4040, 12.3304, 2.0894>
		<-1.4392, 12.3366, 1.7028> <-1.4282, 12.3431, 1.8240> <-1.4070, 12.3642, 1.9615> <-1.4013, 12.3661, 2.0832>
		<-1.4372, 12.3638, 1.6755> <-1.4262, 12.3702, 1.7967> <-1.4041, 12.3906, 1.9571> <-1.3984, 12.3924, 2.0788>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4372, 12.3638, 1.6755> <-1.4262, 12.3702, 1.7967> <-1.4041, 12.3906, 1.9571> <-1.3984, 12.3924, 2.0788>
		<-1.4355, 12.3874, 1.6518> <-1.4245, 12.3938, 1.7729> <-1.4018, 12.4111, 1.9536> <-1.3961, 12.4130, 2.0753>
		<-1.4322, 12.4231, 1.6248> <-1.4219, 12.4266, 1.7642> <-1.3988, 12.4402, 1.9309> <-1.3933, 12.4405, 2.0705>
		<-1.4296, 12.4477, 1.6022> <-1.4193, 12.4512, 1.7416> <-1.4000, 12.4607, 1.9269> <-1.3946, 12.4611, 2.0666>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4296, 12.4477, 1.6022> <-1.4193, 12.4512, 1.7416> <-1.4000, 12.4607, 1.9269> <-1.3946, 12.4611, 2.0666>
		<-1.4270, 12.4718, 1.5800> <-1.4167, 12.4753, 1.7194> <-1.4013, 12.4804, 1.9232> <-1.3958, 12.4808, 2.0628>
		<-1.4165, 12.4975, 1.5420> <-1.4164, 12.4894, 1.6999> <-1.4043, 12.5077, 1.8992> <-1.4018, 12.5065, 2.0574>
		<-1.4200, 12.5261, 1.5262> <-1.4199, 12.5181, 1.6842> <-1.4093, 12.5267, 1.8951> <-1.4068, 12.5255, 2.0533>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4200, 12.5261, 1.5262> <-1.4199, 12.5181, 1.6842> <-1.4093, 12.5267, 1.8951> <-1.4068, 12.5255, 2.0533>
		<-1.4234, 12.5531, 1.5114> <-1.4233, 12.5450, 1.6693> <-1.4170, 12.5561, 1.8888> <-1.4144, 12.5550, 2.0469>
		<-1.4378, 12.5946, 1.5077> <-1.4354, 12.5841, 1.6651> <-1.4258, 12.5955, 1.8807> <-1.4235, 12.5951, 2.0385>
		<-1.4514, 12.6224, 1.5062> <-1.4489, 12.6119, 1.6636> <-1.4390, 12.6228, 1.8741> <-1.4367, 12.6224, 2.0318>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4514, 12.6224, 1.5062> <-1.4489, 12.6119, 1.6636> <-1.4390, 12.6228, 1.8741> <-1.4367, 12.6224, 2.0318>
		<-1.4664, 12.6533, 1.5044> <-1.4639, 12.6428, 1.6618> <-1.4550, 12.6558, 1.8661> <-1.4527, 12.6554, 2.0238>
		<-1.4936, 12.6914, 1.5073> <-1.4895, 12.6898, 1.6542> <-1.4825, 12.6943, 1.8660> <-1.4813, 12.6956, 2.0130>
		<-1.5136, 12.7183, 1.5152> <-1.5095, 12.7167, 1.6621> <-1.5044, 12.7237, 1.8580> <-1.5033, 12.7249, 2.0049>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5136, 12.7183, 1.5152> <-1.5095, 12.7167, 1.6621> <-1.5044, 12.7237, 1.8580> <-1.5033, 12.7249, 2.0049>
		<-1.5340, 12.7456, 1.5233> <-1.5299, 12.7440, 1.6702> <-1.5238, 12.7497, 1.8508> <-1.5227, 12.7510, 1.9977>
		<-1.5577, 12.7775, 1.5588> <-1.5559, 12.7748, 1.6855> <-1.5501, 12.7839, 1.8614> <-1.5495, 12.7856, 1.9881>
		<-1.5842, 12.8006, 1.5589> <-1.5824, 12.7979, 1.6856> <-1.5749, 12.8050, 1.8545> <-1.5743, 12.8067, 1.9812>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5842, 12.8006, 1.5589> <-1.5824, 12.7979, 1.6856> <-1.5749, 12.8050, 1.8545> <-1.5743, 12.8067, 1.9812>
		<-1.6071, 12.8207, 1.5591> <-1.6053, 12.8180, 1.6857> <-1.5961, 12.8229, 1.8486> <-1.5955, 12.8247, 1.9753>
		<-1.6371, 12.8375, 1.5281> <-1.6354, 12.8350, 1.6621> <-1.6287, 12.8408, 1.8339> <-1.6287, 12.8429, 1.9679>
		<-1.6628, 12.8487, 1.5161> <-1.6611, 12.8461, 1.6501> <-1.6547, 12.8513, 1.8288> <-1.6546, 12.8534, 1.9628>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6628, 12.8487, 1.5161> <-1.6611, 12.8461, 1.6501> <-1.6547, 12.8513, 1.8288> <-1.6546, 12.8534, 1.9628>
		<-1.6853, 12.8584, 1.5055> <-1.6836, 12.8559, 1.6395> <-1.6782, 12.8608, 1.8242> <-1.6782, 12.8629, 1.9582>
		<-1.7180, 12.8669, 1.4926> <-1.7158, 12.8637, 1.6320> <-1.7114, 12.8683, 1.8132> <-1.7119, 12.8706, 1.9527>
		<-1.7432, 12.8697, 1.4842> <-1.7410, 12.8664, 1.6237> <-1.7369, 12.8703, 1.8097> <-1.7375, 12.8726, 1.9492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7432, 12.8697, 1.4842> <-1.7410, 12.8664, 1.6237> <-1.7369, 12.8703, 1.8097> <-1.7375, 12.8726, 1.9492>
		<-1.7620, 12.8717, 1.4780> <-1.7598, 12.8684, 1.6175> <-1.7569, 12.8719, 1.8070> <-1.7574, 12.8742, 1.9464>
		<-1.7885, 12.8700, 1.4712> <-1.7860, 12.8662, 1.6134> <-1.7839, 12.8693, 1.8014> <-1.7849, 12.8716, 1.9436>
		<-1.8073, 12.8643, 1.4683> <-1.8048, 12.8605, 1.6105> <-1.8031, 12.8632, 1.8002> <-1.8041, 12.8655, 1.9424>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8073, 12.8643, 1.4683> <-1.8048, 12.8605, 1.6105> <-1.8031, 12.8632, 1.8002> <-1.8041, 12.8655, 1.9424>
		<-1.8251, 12.8589, 1.4656> <-1.8226, 12.8551, 1.6077> <-1.8219, 12.8571, 1.7990> <-1.8229, 12.8594, 1.9412>
		<-1.8478, 12.8460, 1.4646> <-1.8451, 12.8419, 1.6072> <-1.8451, 12.8438, 1.7982> <-1.8465, 12.8459, 1.9408>
		<-1.8617, 12.8335, 1.4660> <-1.8590, 12.8295, 1.6085> <-1.8599, 12.8308, 1.7988> <-1.8613, 12.8328, 1.9414>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8617, 12.8335, 1.4660> <-1.8590, 12.8295, 1.6085> <-1.8599, 12.8308, 1.7988> <-1.8613, 12.8328, 1.9414>
		<-1.8804, 12.8169, 1.4678> <-1.8777, 12.8128, 1.6103> <-1.8795, 12.8135, 1.7995> <-1.8809, 12.8156, 1.9421>
		<-1.9018, 12.7906, 1.4729> <-1.9013, 12.7848, 1.6133> <-1.9020, 12.7870, 1.8039> <-1.9038, 12.7886, 1.9443>
		<-1.9138, 12.7693, 1.4786> <-1.9133, 12.7635, 1.6190> <-1.9153, 12.7646, 1.8064> <-1.9170, 12.7662, 1.9468>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9138, 12.7693, 1.4786> <-1.9133, 12.7635, 1.6190> <-1.9153, 12.7646, 1.8064> <-1.9170, 12.7662, 1.9468>
		<-1.9254, 12.7486, 1.4842> <-1.9249, 12.7429, 1.6245> <-1.9275, 12.7439, 1.8087> <-1.9293, 12.7455, 1.9491>
		<-1.9344, 12.7185, 1.4945> <-1.9325, 12.7132, 1.6307> <-1.9377, 12.7135, 1.8172> <-1.9396, 12.7146, 1.9535>
		<-1.9391, 12.6961, 1.5027> <-1.9372, 12.6908, 1.6389> <-1.9433, 12.6902, 1.8208> <-1.9452, 12.6913, 1.9571>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9391, 12.6961, 1.5027> <-1.9372, 12.6908, 1.6389> <-1.9433, 12.6902, 1.8208> <-1.9452, 12.6913, 1.9571>
		<-1.9446, 12.6697, 1.5124> <-1.9427, 12.6644, 1.6486> <-1.9496, 12.6637, 1.8249> <-1.9515, 12.6648, 1.9612>
		<-1.9493, 12.6339, 1.5264> <-1.9484, 12.6270, 1.6565> <-1.9555, 12.6280, 1.8368> <-1.9574, 12.6285, 1.9671>
		<-1.9476, 12.6077, 1.5380> <-1.9468, 12.6009, 1.6681> <-1.9544, 12.6009, 1.8419> <-1.9564, 12.6014, 1.9722>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9476, 12.6077, 1.5380> <-1.9468, 12.6009, 1.6681> <-1.9544, 12.6009, 1.8419> <-1.9564, 12.6014, 1.9722>
		<-1.9450, 12.5648, 1.5571> <-1.9441, 12.5580, 1.6872> <-1.9528, 12.5579, 1.8500> <-1.9547, 12.5584, 1.9803>
		<-1.9362, 12.5082, 1.5838> <-1.9358, 12.4954, 1.7020> <-1.9456, 12.5016, 1.8728> <-1.9472, 12.5011, 1.9918>
		<-1.9249, 12.4675, 1.6044> <-1.9245, 12.4546, 1.7227> <-1.9348, 12.4601, 1.8817> <-1.9365, 12.4596, 2.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8904, 12.3491, 2.6369> <-1.8908, 12.3497, 2.4536> <-1.8938, 12.3490, 2.2093> <-1.8916, 12.3509, 2.0261>
		<-1.9077, 12.3821, 2.6291> <-1.9081, 12.3826, 2.4459> <-1.9100, 12.3803, 2.2016> <-1.9078, 12.3822, 2.0184>
		<-1.9290, 12.4274, 2.6188> <-1.9283, 12.4263, 2.4356> <-1.9302, 12.4246, 2.1913> <-1.9276, 12.4253, 2.0081>
		<-1.9390, 12.4633, 2.6114> <-1.9382, 12.4622, 2.4282> <-1.9390, 12.4588, 2.1839> <-1.9365, 12.4596, 2.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8904, 12.3491, 2.6369> <-1.8698, 12.3099, 2.6461> <-1.8411, 12.2577, 2.6585> <-1.8129, 12.2235, 2.6676>
		<-1.8908, 12.3497, 2.4536> <-1.8702, 12.3105, 2.4628> <-1.8428, 12.2602, 2.4752> <-1.8146, 12.2260, 2.4844>
		<-1.8938, 12.3490, 2.2093> <-1.8745, 12.3118, 2.2185> <-1.8468, 12.2608, 2.2309> <-1.8200, 12.2286, 2.2401>
		<-1.8916, 12.3509, 2.0261> <-1.8723, 12.3137, 2.0353> <-1.8453, 12.2640, 2.0477> <-1.8185, 12.2319, 2.0569>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8129, 12.2235, 2.6676> <-1.7860, 12.1909, 2.6764> <-1.7481, 12.1442, 2.6889> <-1.7085, 12.1287, 2.6962>
		<-1.8146, 12.2260, 2.4844> <-1.7877, 12.1934, 2.4932> <-1.7510, 12.1486, 2.5057> <-1.7114, 12.1331, 2.5130>
		<-1.8200, 12.2286, 2.2401> <-1.7942, 12.1978, 2.2489> <-1.7566, 12.1526, 2.2615> <-1.7186, 12.1388, 2.2687>
		<-1.8185, 12.2319, 2.0569> <-1.7928, 12.2011, 2.0657> <-1.7562, 12.1569, 2.0783> <-1.7181, 12.1432, 2.0854>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7085, 12.1287, 2.6962> <-1.6582, 12.1091, 2.7054> <-1.5804, 12.0954, 2.7168> <-1.5283, 12.1122, 2.7199>
		<-1.7114, 12.1331, 2.5130> <-1.6611, 12.1134, 2.5222> <-1.5843, 12.1013, 2.5335> <-1.5322, 12.1180, 2.5367>
		<-1.7186, 12.1388, 2.2687> <-1.6689, 12.1209, 2.2780> <-1.5906, 12.1099, 2.2894> <-1.5398, 12.1270, 2.2924>
		<-1.7181, 12.1432, 2.0854> <-1.6685, 12.1253, 2.0948> <-1.5921, 12.1147, 2.1061> <-1.5414, 12.1318, 2.1091>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5283, 12.1122, 2.7199> <-1.4882, 12.1251, 2.7223> <-1.4590, 12.1827, 2.7156> <-1.4344, 12.2168, 2.7125>
		<-1.5322, 12.1180, 2.5367> <-1.4921, 12.1310, 2.5390> <-1.4626, 12.1881, 2.5324> <-1.4380, 12.2223, 2.5293>
		<-1.5398, 12.1270, 2.2924> <-1.5000, 12.1405, 2.2948> <-1.4649, 12.2018, 2.2881> <-1.4398, 12.2354, 2.2850>
		<-1.5414, 12.1318, 2.1091> <-1.5015, 12.1452, 2.1115> <-1.4715, 12.2012, 2.1049> <-1.4464, 12.2349, 2.1018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4344, 12.2168, 2.7125> <-1.4204, 12.2362, 2.7108> <-1.4073, 12.2659, 2.7072> <-1.4010, 12.2888, 2.7039>
		<-1.4380, 12.2223, 2.5293> <-1.4240, 12.2416, 2.5276> <-1.4105, 12.2708, 2.5239> <-1.4042, 12.2936, 2.5207>
		<-1.4398, 12.2354, 2.2850> <-1.4257, 12.2543, 2.2833> <-1.4105, 12.2845, 2.2796> <-1.4037, 12.3069, 2.2763>
		<-1.4464, 12.2349, 2.1018> <-1.4323, 12.2537, 2.1001> <-1.4186, 12.2826, 2.0964> <-1.4118, 12.3049, 2.0932>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4010, 12.2888, 2.7039> <-1.3937, 12.3153, 2.7001> <-1.3919, 12.3521, 2.6940> <-1.3897, 12.3794, 2.6895>
		<-1.4042, 12.2936, 2.5207> <-1.3969, 12.3201, 2.5169> <-1.3945, 12.3560, 2.5107> <-1.3923, 12.3833, 2.5063>
		<-1.4037, 12.3069, 2.2763> <-1.3960, 12.3324, 2.2726> <-1.3927, 12.3689, 2.2663> <-1.3898, 12.3952, 2.2618>
		<-1.4118, 12.3049, 2.0932> <-1.4040, 12.3304, 2.0894> <-1.4013, 12.3661, 2.0832> <-1.3984, 12.3924, 2.0788>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3897, 12.3794, 2.6895> <-1.3879, 12.4007, 2.6860> <-1.3858, 12.4294, 2.6812> <-1.3877, 12.4506, 2.6773>
		<-1.3923, 12.3833, 2.5063> <-1.3905, 12.4046, 2.5028> <-1.3879, 12.4325, 2.4980> <-1.3897, 12.4538, 2.4941>
		<-1.3898, 12.3952, 2.2618> <-1.3875, 12.4158, 2.2583> <-1.3862, 12.4411, 2.2537> <-1.3875, 12.4616, 2.2497>
		<-1.3984, 12.3924, 2.0788> <-1.3961, 12.4130, 2.0753> <-1.3933, 12.4405, 2.0705> <-1.3946, 12.4611, 2.0666>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3877, 12.4506, 2.6773> <-1.3894, 12.4712, 2.6736> <-1.3962, 12.4981, 2.6681> <-1.4017, 12.5180, 2.6640>
		<-1.3897, 12.4538, 2.4941> <-1.3915, 12.4744, 2.4903> <-1.3977, 12.5004, 2.4849> <-1.4032, 12.5202, 2.4808>
		<-1.3875, 12.4616, 2.2497> <-1.3887, 12.4813, 2.2460> <-1.3988, 12.5052, 2.2406> <-1.4038, 12.5242, 2.2365>
		<-1.3946, 12.4611, 2.0666> <-1.3958, 12.4808, 2.0628> <-1.4018, 12.5065, 2.0574> <-1.4068, 12.5255, 2.0533>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4017, 12.5180, 2.6640> <-1.4103, 12.5488, 2.6577> <-1.4206, 12.5908, 2.6492> <-1.4348, 12.6194, 2.6426>
		<-1.4032, 12.5202, 2.4808> <-1.4118, 12.5511, 2.4745> <-1.4212, 12.5916, 2.4660> <-1.4353, 12.6203, 2.4594>
		<-1.4038, 12.5242, 2.2365> <-1.4115, 12.5537, 2.2302> <-1.4208, 12.5946, 2.2217> <-1.4341, 12.6219, 2.2151>
		<-1.4068, 12.5255, 2.0533> <-1.4144, 12.5550, 2.0469> <-1.4235, 12.5951, 2.0385> <-1.4367, 12.6224, 2.0318>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4348, 12.6194, 2.6426> <-1.4519, 12.6542, 2.6346> <-1.4821, 12.6967, 2.6237> <-1.5052, 12.7278, 2.6156>
		<-1.4353, 12.6203, 2.4594> <-1.4525, 12.6551, 2.4513> <-1.4815, 12.6958, 2.4405> <-1.5046, 12.7269, 2.4324>
		<-1.4341, 12.6219, 2.2151> <-1.4500, 12.6550, 2.2070> <-1.4799, 12.6971, 2.1962> <-1.5019, 12.7265, 2.1881>
		<-1.4367, 12.6224, 2.0318> <-1.4527, 12.6554, 2.0238> <-1.4813, 12.6956, 2.0130> <-1.5033, 12.7249, 2.0049>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5052, 12.7278, 2.6156> <-1.5256, 12.7553, 2.6085> <-1.5537, 12.7920, 2.5989> <-1.5796, 12.8146, 2.5919>
		<-1.5046, 12.7269, 2.4324> <-1.5250, 12.7545, 2.4253> <-1.5522, 12.7896, 2.4156> <-1.5780, 12.8122, 2.4087>
		<-1.5019, 12.7265, 2.1881> <-1.5213, 12.7526, 2.1810> <-1.5487, 12.7881, 2.1713> <-1.5735, 12.8092, 2.1644>
		<-1.5033, 12.7249, 2.0049> <-1.5227, 12.7510, 1.9977> <-1.5495, 12.7856, 1.9881> <-1.5743, 12.8067, 1.9812>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5796, 12.8146, 2.5919> <-1.6015, 12.8338, 2.5861> <-1.6357, 12.8537, 2.5787> <-1.6625, 12.8653, 2.5736>
		<-1.5780, 12.8122, 2.4087> <-1.5999, 12.8314, 2.4029> <-1.6334, 12.8501, 2.3955> <-1.6602, 12.8617, 2.3903>
		<-1.5735, 12.8092, 2.1644> <-1.5947, 12.8272, 2.1585> <-1.6287, 12.8458, 2.1512> <-1.6546, 12.8563, 2.1461>
		<-1.5743, 12.8067, 1.9812> <-1.5955, 12.8247, 1.9753> <-1.6287, 12.8429, 1.9679> <-1.6546, 12.8534, 1.9628>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6625, 12.8653, 2.5736> <-1.6866, 12.8757, 2.5690> <-1.7211, 12.8846, 2.5634> <-1.7473, 12.8875, 2.5599>
		<-1.6602, 12.8617, 2.3903> <-1.6842, 12.8722, 2.3857> <-1.7181, 12.8802, 2.3802> <-1.7444, 12.8830, 2.3767>
		<-1.6546, 12.8563, 2.1461> <-1.6781, 12.8658, 2.1414> <-1.7126, 12.8736, 2.1359> <-1.7382, 12.8757, 2.1325>
		<-1.6546, 12.8534, 1.9628> <-1.6782, 12.8629, 1.9582> <-1.7119, 12.8706, 1.9527> <-1.7375, 12.8726, 1.9492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7473, 12.8875, 2.5599> <-1.7675, 12.8896, 2.5572> <-1.7954, 12.8877, 2.5543> <-1.8150, 12.8818, 2.5531>
		<-1.7444, 12.8830, 2.3767> <-1.7645, 12.8852, 2.3740> <-1.7922, 12.8828, 2.3711> <-1.8117, 12.8769, 2.3699>
		<-1.7382, 12.8757, 2.1325> <-1.7581, 12.8773, 2.1297> <-1.7862, 12.8746, 2.1269> <-1.8054, 12.8684, 2.1256>
		<-1.7375, 12.8726, 1.9492> <-1.7574, 12.8742, 1.9464> <-1.7849, 12.8716, 1.9436> <-1.8041, 12.8655, 1.9424>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8150, 12.8818, 2.5531> <-1.8338, 12.8760, 2.5519> <-1.8576, 12.8625, 2.5515> <-1.8723, 12.8494, 2.5521>
		<-1.8117, 12.8769, 2.3699> <-1.8306, 12.8711, 2.3687> <-1.8543, 12.8576, 2.3683> <-1.8690, 12.8444, 2.3689>
		<-1.8054, 12.8684, 2.1256> <-1.8242, 12.8624, 2.1245> <-1.8483, 12.8485, 2.1241> <-1.8631, 12.8355, 2.1246>
		<-1.8041, 12.8655, 1.9424> <-1.8229, 12.8594, 1.9412> <-1.8465, 12.8459, 1.9408> <-1.8613, 12.8328, 1.9414>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8723, 12.8494, 2.5521> <-1.8919, 12.8319, 2.5529> <-1.9144, 12.8043, 2.5550> <-1.9272, 12.7816, 2.5575>
		<-1.8690, 12.8444, 2.3689> <-1.8886, 12.8270, 2.3696> <-1.9113, 12.7997, 2.3718> <-1.9241, 12.7770, 2.3743>
		<-1.8631, 12.8355, 2.1246> <-1.8827, 12.8183, 2.1254> <-1.9060, 12.7907, 2.1276> <-1.9193, 12.7683, 2.1301>
		<-1.8613, 12.8328, 1.9414> <-1.8809, 12.8156, 1.9421> <-1.9038, 12.7886, 1.9443> <-1.9170, 12.7662, 1.9468>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9272, 12.7816, 2.5575> <-1.9393, 12.7602, 2.5598> <-1.9489, 12.7283, 2.5643> <-1.9539, 12.7044, 2.5678>
		<-1.9241, 12.7770, 2.3743> <-1.9362, 12.7556, 2.3766> <-1.9463, 12.7244, 2.3810> <-1.9513, 12.7005, 2.3846>
		<-1.9193, 12.7683, 2.1301> <-1.9316, 12.7476, 2.1324> <-1.9422, 12.7160, 2.1368> <-1.9477, 12.6927, 2.1404>
		<-1.9170, 12.7662, 1.9468> <-1.9293, 12.7455, 1.9491> <-1.9396, 12.7146, 1.9535> <-1.9452, 12.6913, 1.9571>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9539, 12.7044, 2.5678> <-1.9597, 12.6769, 2.5719> <-1.9646, 12.6392, 2.5779> <-1.9629, 12.6112, 2.5830>
		<-1.9513, 12.7005, 2.3846> <-1.9571, 12.6729, 2.3887> <-1.9627, 12.6362, 2.3947> <-1.9609, 12.6083, 2.3998>
		<-1.9477, 12.6927, 2.1404> <-1.9541, 12.6662, 2.1444> <-1.9600, 12.6291, 2.1504> <-1.9590, 12.6020, 2.1555>
		<-1.9452, 12.6913, 1.9571> <-1.9515, 12.6648, 1.9612> <-1.9574, 12.6285, 1.9671> <-1.9564, 12.6014, 1.9722>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9629, 12.6112, 2.5830> <-1.9601, 12.5663, 2.5911> <-1.9509, 12.5066, 2.6025> <-1.9390, 12.4633, 2.6114>
		<-1.9609, 12.6083, 2.3998> <-1.9582, 12.5633, 2.4079> <-1.9502, 12.5054, 2.4193> <-1.9382, 12.4622, 2.4282>
		<-1.9590, 12.6020, 2.1555> <-1.9574, 12.5590, 2.1636> <-1.9498, 12.5003, 2.1750> <-1.9390, 12.4588, 2.1839>
		<-1.9564, 12.6014, 1.9722> <-1.9547, 12.5584, 1.9803> <-1.9472, 12.5011, 1.9918> <-1.9365, 12.4596, 2.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6621, 11.0859, 0.2236> <-0.6503, 11.0985, 0.2281> <-0.6437, 11.1025, 0.2340> <-0.6316, 11.1186, 0.2352>
		<-0.6553, 11.0757, 0.2140> <-0.6435, 11.0883, 0.2185> <-0.6360, 11.0916, 0.2235> <-0.6238, 11.1077, 0.2248>
		<-0.6461, 11.0613, 0.2020> <-0.6331, 11.0731, 0.2053> <-0.6255, 11.0766, 0.2101> <-0.6134, 11.0926, 0.2114>
		<-0.6394, 11.0517, 0.1917> <-0.6264, 11.0635, 0.1950> <-0.6178, 11.0662, 0.1991> <-0.6057, 11.0822, 0.2003>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6316, 11.1186, 0.2352> <-0.6192, 11.1349, 0.2365> <-0.6167, 11.1431, 0.2315> <-0.6073, 11.1585, 0.2291>
		<-0.6238, 11.1077, 0.2248> <-0.6115, 11.1240, 0.2260> <-0.6094, 11.1334, 0.2220> <-0.6000, 11.1488, 0.2196>
		<-0.6134, 11.0926, 0.2114> <-0.6003, 11.1099, 0.2127> <-0.5980, 11.1188, 0.2089> <-0.5892, 11.1358, 0.2078>
		<-0.6057, 11.0822, 0.2003> <-0.5927, 11.0995, 0.2016> <-0.5918, 11.1093, 0.1985> <-0.5830, 11.1263, 0.1974>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6194, 11.0251, 0.1588> <-0.6254, 11.0331, 0.1687> <-0.6333, 11.0431, 0.1825> <-0.6394, 11.0517, 0.1917>
		<-0.6016, 11.0307, 0.1559> <-0.6076, 11.0387, 0.1658> <-0.6203, 11.0548, 0.1858> <-0.6264, 11.0635, 0.1950>
		<-0.5852, 11.0219, 0.1499> <-0.5949, 11.0347, 0.1646> <-0.6080, 11.0528, 0.1849> <-0.6178, 11.0662, 0.1991>
		<-0.5733, 11.0395, 0.1514> <-0.5830, 11.0523, 0.1660> <-0.5959, 11.0689, 0.1862> <-0.6057, 11.0822, 0.2003>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5733, 11.0395, 0.1514> <-0.5830, 11.0523, 0.1660> <-0.5959, 11.0689, 0.1862> <-0.6057, 11.0822, 0.2003>
		<-0.5581, 11.0619, 0.1532> <-0.5678, 11.0747, 0.1679> <-0.5828, 11.0862, 0.1875> <-0.5927, 11.0995, 0.2016>
		<-0.5704, 11.0767, 0.1597> <-0.5747, 11.0846, 0.1695> <-0.5864, 11.1012, 0.1896> <-0.5918, 11.1093, 0.1985>
		<-0.5686, 11.1000, 0.1650> <-0.5729, 11.1079, 0.1747> <-0.5776, 11.1182, 0.1885> <-0.5830, 11.1263, 0.1974>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5985, 11.2678, 0.2375> <-0.5869, 11.2798, 0.2426> <-0.5804, 11.2833, 0.2486> <-0.5684, 11.2988, 0.2506>
		<-0.5930, 11.2596, 0.2269> <-0.5814, 11.2716, 0.2320> <-0.5741, 11.2746, 0.2369> <-0.5621, 11.2901, 0.2390>
		<-0.5858, 11.2469, 0.2138> <-0.5732, 11.2582, 0.2176> <-0.5660, 11.2623, 0.2218> <-0.5541, 11.2778, 0.2239>
		<-0.5802, 11.2404, 0.2021> <-0.5676, 11.2517, 0.2059> <-0.5594, 11.2543, 0.2098> <-0.5475, 11.2698, 0.2119>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5684, 11.2988, 0.2506> <-0.5564, 11.3144, 0.2527> <-0.5539, 11.3225, 0.2482> <-0.5448, 11.3374, 0.2468>
		<-0.5621, 11.2901, 0.2390> <-0.5501, 11.3057, 0.2411> <-0.5480, 11.3149, 0.2377> <-0.5388, 11.3298, 0.2362>
		<-0.5541, 11.2778, 0.2239> <-0.5414, 11.2942, 0.2261> <-0.5392, 11.3030, 0.2228> <-0.5305, 11.3192, 0.2227>
		<-0.5475, 11.2698, 0.2119> <-0.5348, 11.2862, 0.2141> <-0.5337, 11.2957, 0.2118> <-0.5250, 11.3120, 0.2117>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5651, 11.2293, 0.1676> <-0.5697, 11.2326, 0.1780> <-0.5757, 11.2351, 0.1926> <-0.5802, 11.2404, 0.2021>
		<-0.5471, 11.2328, 0.1646> <-0.5516, 11.2361, 0.1750> <-0.5630, 11.2465, 0.1964> <-0.5676, 11.2517, 0.2059>
		<-0.5322, 11.2228, 0.1573> <-0.5409, 11.2322, 0.1729> <-0.5510, 11.2442, 0.1945> <-0.5594, 11.2543, 0.2098>
		<-0.5184, 11.2385, 0.1598> <-0.5271, 11.2479, 0.1755> <-0.5390, 11.2596, 0.1966> <-0.5475, 11.2698, 0.2119>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5184, 11.2385, 0.1598> <-0.5271, 11.2479, 0.1755> <-0.5390, 11.2596, 0.1966> <-0.5475, 11.2698, 0.2119>
		<-0.5021, 11.2570, 0.1628> <-0.5108, 11.2664, 0.1784> <-0.5264, 11.2761, 0.1988> <-0.5348, 11.2862, 0.2141>
		<-0.5132, 11.2713, 0.1708> <-0.5177, 11.2773, 0.1810> <-0.5288, 11.2893, 0.2020> <-0.5337, 11.2957, 0.2118>
		<-0.5100, 11.2920, 0.1777> <-0.5145, 11.2980, 0.1879> <-0.5201, 11.3056, 0.2019> <-0.5250, 11.3120, 0.2117>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5403, 11.4483, 0.2692> <-0.5301, 11.4588, 0.2743> <-0.5242, 11.4616, 0.2803> <-0.5137, 11.4756, 0.2825>
		<-0.5353, 11.4407, 0.2581> <-0.5250, 11.4512, 0.2633> <-0.5184, 11.4536, 0.2681> <-0.5079, 11.4676, 0.2704>
		<-0.5286, 11.4296, 0.2440> <-0.5173, 11.4395, 0.2478> <-0.5120, 11.4448, 0.2497> <-0.5016, 11.4587, 0.2519>
		<-0.5235, 11.4230, 0.2323> <-0.5123, 11.4330, 0.2361> <-0.5048, 11.4349, 0.2399> <-0.4944, 11.4488, 0.2422>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5137, 11.4756, 0.2825> <-0.5031, 11.4897, 0.2848> <-0.5013, 11.4972, 0.2806> <-0.4935, 11.5108, 0.2793>
		<-0.5079, 11.4676, 0.2704> <-0.4973, 11.4817, 0.2727> <-0.4959, 11.4902, 0.2696> <-0.4881, 11.5038, 0.2684>
		<-0.5016, 11.4587, 0.2519> <-0.4904, 11.4736, 0.2543> <-0.4878, 11.4792, 0.2539> <-0.4805, 11.4940, 0.2541>
		<-0.4944, 11.4488, 0.2422> <-0.4833, 11.4637, 0.2446> <-0.4827, 11.4725, 0.2425> <-0.4754, 11.4873, 0.2428>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5095, 11.4080, 0.1971> <-0.5137, 11.4125, 0.2077> <-0.5193, 11.4174, 0.2223> <-0.5235, 11.4230, 0.2323>
		<-0.4945, 11.4110, 0.2073> <-0.4987, 11.4155, 0.2179> <-0.5080, 11.4274, 0.2261> <-0.5123, 11.4330, 0.2361>
		<-0.4833, 11.3997, 0.2207> <-0.4905, 11.4096, 0.2262> <-0.4987, 11.4264, 0.2315> <-0.5048, 11.4349, 0.2399>
		<-0.4705, 11.4159, 0.2236> <-0.4777, 11.4258, 0.2292> <-0.4883, 11.4403, 0.2338> <-0.4944, 11.4488, 0.2422>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4705, 11.4159, 0.2236> <-0.4777, 11.4258, 0.2292> <-0.4883, 11.4403, 0.2338> <-0.4944, 11.4488, 0.2422>
		<-0.4556, 11.4348, 0.2270> <-0.4627, 11.4447, 0.2326> <-0.4772, 11.4552, 0.2362> <-0.4833, 11.4637, 0.2446>
		<-0.4649, 11.4484, 0.2141> <-0.4691, 11.4540, 0.2245> <-0.4782, 11.4666, 0.2325> <-0.4827, 11.4725, 0.2425>
		<-0.4614, 11.4688, 0.2081> <-0.4656, 11.4744, 0.2185> <-0.4708, 11.4814, 0.2327> <-0.4754, 11.4873, 0.2428>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7327, 10.9182, 0.1923> <-0.7207, 10.9310, 0.1968> <-0.7138, 10.9351, 0.2027> <-0.7014, 10.9513, 0.2040>
		<-0.7253, 10.9071, 0.1824> <-0.7133, 10.9199, 0.1869> <-0.7054, 10.9232, 0.1919> <-0.6930, 10.9395, 0.1931>
		<-0.7155, 10.8901, 0.1712> <-0.7022, 10.9019, 0.1744> <-0.6941, 10.9068, 0.1781> <-0.6817, 10.9231, 0.1793>
		<-0.7081, 10.8811, 0.1594> <-0.6947, 10.8929, 0.1626> <-0.6858, 10.8955, 0.1666> <-0.6734, 10.9118, 0.1678>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7014, 10.9513, 0.2040> <-0.6888, 10.9680, 0.2052> <-0.6861, 10.9763, 0.2002> <-0.6765, 10.9920, 0.1979>
		<-0.6930, 10.9395, 0.1931> <-0.6803, 10.9561, 0.1944> <-0.6782, 10.9658, 0.1904> <-0.6686, 10.9814, 0.1881>
		<-0.6817, 10.9231, 0.1793> <-0.6683, 10.9407, 0.1806> <-0.6662, 10.9499, 0.1767> <-0.6572, 10.9674, 0.1757>
		<-0.6734, 10.9118, 0.1678> <-0.6600, 10.9294, 0.1692> <-0.6592, 10.9395, 0.1662> <-0.6502, 10.9569, 0.1651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6906, 10.8673, 0.1258> <-0.6958, 10.8715, 0.1359> <-0.7026, 10.8745, 0.1508> <-0.7081, 10.8811, 0.1594>
		<-0.6707, 10.8668, 0.1227> <-0.6759, 10.8710, 0.1328> <-0.6892, 10.8864, 0.1541> <-0.6947, 10.8929, 0.1626>
		<-0.6547, 10.8497, 0.1160> <-0.6650, 10.8634, 0.1311> <-0.6753, 10.8812, 0.1522> <-0.6858, 10.8955, 0.1666>
		<-0.6389, 10.8661, 0.1177> <-0.6493, 10.8798, 0.1328> <-0.6629, 10.8975, 0.1534> <-0.6734, 10.9118, 0.1678>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6389, 10.8661, 0.1177> <-0.6493, 10.8798, 0.1328> <-0.6629, 10.8975, 0.1534> <-0.6734, 10.9118, 0.1678>
		<-0.6199, 10.8858, 0.1198> <-0.6302, 10.8995, 0.1348> <-0.6495, 10.9151, 0.1548> <-0.6600, 10.9294, 0.1692>
		<-0.6352, 10.9036, 0.1266> <-0.6404, 10.9125, 0.1365> <-0.6530, 10.9304, 0.1569> <-0.6592, 10.9395, 0.1662>
		<-0.6329, 10.9272, 0.1321> <-0.6381, 10.9361, 0.1420> <-0.6441, 10.9479, 0.1559> <-0.6502, 10.9569, 0.1651>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8626, 10.7914, 0.1864> <-0.8475, 10.8096, 0.1912> <-0.8388, 10.8160, 0.1980> <-0.8234, 10.8385, 0.1988>
		<-0.8496, 10.7718, 0.1762> <-0.8345, 10.7900, 0.1810> <-0.8241, 10.7950, 0.1868> <-0.8087, 10.8175, 0.1875>
		<-0.8315, 10.7444, 0.1654> <-0.8143, 10.7607, 0.1689> <-0.8038, 10.7660, 0.1744> <-0.7885, 10.7884, 0.1751>
		<-0.8192, 10.7261, 0.1523> <-0.8020, 10.7424, 0.1558> <-0.7898, 10.7461, 0.1605> <-0.7745, 10.7685, 0.1613>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8234, 10.8385, 0.1988> <-0.8074, 10.8618, 0.1996> <-0.8042, 10.8729, 0.1933> <-0.7921, 10.8946, 0.1898>
		<-0.8087, 10.8175, 0.1875> <-0.7928, 10.8408, 0.1883> <-0.7905, 10.8543, 0.1831> <-0.7785, 10.8759, 0.1796>
		<-0.7885, 10.7884, 0.1751> <-0.7713, 10.8135, 0.1760> <-0.7700, 10.8253, 0.1709> <-0.7593, 10.8500, 0.1688>
		<-0.7745, 10.7685, 0.1613> <-0.7574, 10.7936, 0.1621> <-0.7574, 10.8077, 0.1579> <-0.7467, 10.8323, 0.1558>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7961, 10.6923, 0.1154> <-0.8030, 10.7024, 0.1265> <-0.8113, 10.7143, 0.1438> <-0.8192, 10.7261, 0.1523>
		<-0.7710, 10.6978, 0.1121> <-0.7780, 10.7079, 0.1232> <-0.7940, 10.7306, 0.1473> <-0.8020, 10.7424, 0.1558>
		<-0.7475, 10.6823, 0.1060> <-0.7605, 10.7009, 0.1223> <-0.7759, 10.7262, 0.1467> <-0.7898, 10.7461, 0.1605>
		<-0.7312, 10.7065, 0.1070> <-0.7442, 10.7251, 0.1233> <-0.7606, 10.7486, 0.1474> <-0.7745, 10.7685, 0.1613>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7312, 10.7065, 0.1070> <-0.7442, 10.7251, 0.1233> <-0.7606, 10.7486, 0.1474> <-0.7745, 10.7685, 0.1613>
		<-0.7083, 10.7403, 0.1083> <-0.7213, 10.7589, 0.1245> <-0.7435, 10.7737, 0.1483> <-0.7574, 10.7936, 0.1621>
		<-0.7267, 10.7633, 0.1146> <-0.7335, 10.7733, 0.1255> <-0.7493, 10.7963, 0.1495> <-0.7574, 10.8077, 0.1579>
		<-0.7239, 10.7990, 0.1195> <-0.7307, 10.8090, 0.1303> <-0.7386, 10.8209, 0.1474> <-0.7467, 10.8323, 0.1558>
	}
texture {skin}
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6964, 11.1296, 0.2280> <-0.6846, 11.1422, 0.2325> <-0.6780, 11.1462, 0.2384> <-0.6659, 11.1622, 0.2397>
		<-0.6793, 11.1062, 0.2184> <-0.6675, 11.1188, 0.2229> <-0.6599, 11.1222, 0.2280> <-0.6478, 11.1382, 0.2292>
		<-0.6555, 11.0737, 0.2098> <-0.6426, 11.0854, 0.2131> <-0.6347, 11.0884, 0.2187> <-0.6225, 11.1045, 0.2200>
		<-0.6394, 11.0517, 0.1961> <-0.6264, 11.0635, 0.1995> <-0.6178, 11.0662, 0.2035> <-0.6057, 11.0822, 0.2047>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6659, 11.1622, 0.2397> <-0.6535, 11.1786, 0.2409> <-0.6509, 11.1867, 0.2359> <-0.6416, 11.2021, 0.2335>
		<-0.6478, 11.1382, 0.2292> <-0.6355, 11.1546, 0.2304> <-0.6334, 11.1640, 0.2264> <-0.6240, 11.1794, 0.2240>
		<-0.6225, 11.1045, 0.2200> <-0.6095, 11.1218, 0.2213> <-0.6074, 11.1312, 0.2167> <-0.5986, 11.1483, 0.2156>
		<-0.6057, 11.0822, 0.2047> <-0.5927, 11.0995, 0.2061> <-0.5918, 11.1093, 0.2030> <-0.5830, 11.1263, 0.2018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6194, 11.0251, 0.1632> <-0.6254, 11.0331, 0.1731> <-0.6319, 11.0416, 0.1899> <-0.6394, 11.0517, 0.1961>
		<-0.6016, 11.0307, 0.1603> <-0.6076, 11.0387, 0.1702> <-0.6189, 11.0534, 0.1932> <-0.6264, 11.0635, 0.1995>
		<-0.5852, 11.0219, 0.1543> <-0.5949, 11.0347, 0.1690> <-0.6063, 11.0509, 0.1931> <-0.6178, 11.0662, 0.2035>
		<-0.5733, 11.0395, 0.1558> <-0.5830, 11.0523, 0.1705> <-0.5942, 11.0670, 0.1943> <-0.6057, 11.0822, 0.2047>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5733, 11.0395, 0.1558> <-0.5830, 11.0523, 0.1705> <-0.5942, 11.0670, 0.1943> <-0.6057, 11.0822, 0.2047>
		<-0.5581, 11.0619, 0.1576> <-0.5678, 11.0747, 0.1723> <-0.5811, 11.0842, 0.1956> <-0.5927, 11.0995, 0.2061>
		<-0.5704, 11.0767, 0.1641> <-0.5747, 11.0846, 0.1739> <-0.5849, 11.0997, 0.1969> <-0.5918, 11.1093, 0.2030>
		<-0.5686, 11.1000, 0.1694> <-0.5729, 11.1079, 0.1791> <-0.5761, 11.1167, 0.1958> <-0.5830, 11.1263, 0.2018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6327, 11.3115, 0.2419> <-0.6211, 11.3234, 0.2470> <-0.6146, 11.3269, 0.2530> <-0.6027, 11.3424, 0.2550>
		<-0.6170, 11.2901, 0.2313> <-0.6054, 11.3021, 0.2364> <-0.5981, 11.3052, 0.2414> <-0.5861, 11.3206, 0.2434>
		<-0.5954, 11.2588, 0.2222> <-0.5827, 11.2702, 0.2260> <-0.5747, 11.2738, 0.2307> <-0.5628, 11.2892, 0.2328>
		<-0.5802, 11.2404, 0.2066> <-0.5676, 11.2517, 0.2103> <-0.5594, 11.2543, 0.2143> <-0.5475, 11.2698, 0.2163>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6027, 11.3424, 0.2550> <-0.5906, 11.3580, 0.2571> <-0.5882, 11.3661, 0.2527> <-0.5790, 11.3811, 0.2512>
		<-0.5861, 11.3206, 0.2434> <-0.5741, 11.3363, 0.2455> <-0.5719, 11.3454, 0.2421> <-0.5628, 11.3603, 0.2407>
		<-0.5628, 11.2892, 0.2328> <-0.5501, 11.3057, 0.2350> <-0.5485, 11.3148, 0.2310> <-0.5398, 11.3311, 0.2309>
		<-0.5475, 11.2698, 0.2163> <-0.5348, 11.2862, 0.2185> <-0.5337, 11.2957, 0.2162> <-0.5250, 11.3120, 0.2161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5651, 11.2293, 0.1720> <-0.5697, 11.2326, 0.1824> <-0.5740, 11.2328, 0.2001> <-0.5802, 11.2404, 0.2066>
		<-0.5471, 11.2317, 0.1690> <-0.5516, 11.2350, 0.1794> <-0.5613, 11.2441, 0.2039> <-0.5676, 11.2517, 0.2103>
		<-0.5320, 11.2199, 0.1618> <-0.5408, 11.2302, 0.1774> <-0.5488, 11.2408, 0.2028> <-0.5594, 11.2543, 0.2143>
		<-0.5184, 11.2355, 0.1643> <-0.5271, 11.2458, 0.1799> <-0.5368, 11.2563, 0.2049> <-0.5475, 11.2698, 0.2163>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5184, 11.2355, 0.1643> <-0.5271, 11.2458, 0.1799> <-0.5368, 11.2563, 0.2049> <-0.5475, 11.2698, 0.2163>
		<-0.5013, 11.2549, 0.1674> <-0.5100, 11.2652, 0.1830> <-0.5242, 11.2727, 0.2071> <-0.5348, 11.2862, 0.2185>
		<-0.5132, 11.2702, 0.1752> <-0.5177, 11.2762, 0.1854> <-0.5271, 11.2872, 0.2096> <-0.5337, 11.2957, 0.2162>
		<-0.5100, 11.2920, 0.1821> <-0.5145, 11.2980, 0.1923> <-0.5184, 11.3035, 0.2095> <-0.5250, 11.3120, 0.2161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5833, 11.4963, 0.2736> <-0.5697, 11.5051, 0.2787> <-0.5597, 11.5041, 0.2845> <-0.5479, 11.5192, 0.2869>
		<-0.5654, 11.4743, 0.2625> <-0.5517, 11.4831, 0.2677> <-0.5428, 11.4822, 0.2759> <-0.5310, 11.4973, 0.2784>
		<-0.5401, 11.4428, 0.2529> <-0.5277, 11.4517, 0.2612> <-0.5198, 11.4490, 0.2706> <-0.5081, 11.4646, 0.2732>
		<-0.5235, 11.4230, 0.2367> <-0.5111, 11.4319, 0.2451> <-0.5031, 11.4305, 0.2558> <-0.4914, 11.4461, 0.2584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5479, 11.5192, 0.2869> <-0.5367, 11.5335, 0.2893> <-0.5396, 11.5435, 0.2850> <-0.5343, 11.5588, 0.2837>
		<-0.5310, 11.4973, 0.2784> <-0.5198, 11.5116, 0.2807> <-0.5219, 11.5221, 0.2740> <-0.5166, 11.5374, 0.2728>
		<-0.5081, 11.4646, 0.2732> <-0.4963, 11.4805, 0.2757> <-0.4976, 11.4912, 0.2671> <-0.4914, 11.5071, 0.2628>
		<-0.4914, 11.4461, 0.2584> <-0.4796, 11.4619, 0.2609> <-0.4816, 11.4714, 0.2515> <-0.4754, 11.4873, 0.2472>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5095, 11.4080, 0.2015> <-0.5137, 11.4125, 0.2121> <-0.5169, 11.4151, 0.2302> <-0.5235, 11.4230, 0.2367>
		<-0.4910, 11.4138, 0.2049> <-0.4952, 11.4183, 0.2155> <-0.5045, 11.4240, 0.2386> <-0.5111, 11.4319, 0.2451>
		<-0.4752, 11.4059, 0.2072> <-0.4842, 11.4128, 0.2216> <-0.4926, 11.4188, 0.2465> <-0.5031, 11.4305, 0.2558>
		<-0.4616, 11.4232, 0.2103> <-0.4705, 11.4301, 0.2247> <-0.4809, 11.4344, 0.2490> <-0.4914, 11.4461, 0.2584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4616, 11.4232, 0.2103> <-0.4705, 11.4301, 0.2247> <-0.4809, 11.4344, 0.2490> <-0.4914, 11.4461, 0.2584>
		<-0.4493, 11.4387, 0.2131> <-0.4583, 11.4455, 0.2275> <-0.4691, 11.4502, 0.2516> <-0.4796, 11.4619, 0.2609>
		<-0.4615, 11.4512, 0.2117> <-0.4657, 11.4568, 0.2221> <-0.4749, 11.4632, 0.2449> <-0.4816, 11.4714, 0.2515>
		<-0.4614, 11.4688, 0.2125> <-0.4656, 11.4744, 0.2229> <-0.4687, 11.4791, 0.2406> <-0.4754, 11.4873, 0.2472>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7670, 10.9618, 0.1967> <-0.7549, 10.9746, 0.2012> <-0.7481, 10.9787, 0.2071> <-0.7357, 10.9950, 0.2084>
		<-0.7493, 10.9376, 0.1868> <-0.7372, 10.9504, 0.1913> <-0.7294, 10.9537, 0.1963> <-0.7170, 10.9700, 0.1975>
		<-0.7255, 10.9026, 0.1789> <-0.7121, 10.9145, 0.1822> <-0.7033, 10.9187, 0.1866> <-0.6909, 10.9350, 0.1878>
		<-0.7081, 10.8811, 0.1638> <-0.6947, 10.8929, 0.1671> <-0.6858, 10.8955, 0.1710> <-0.6734, 10.9118, 0.1723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7357, 10.9950, 0.2084> <-0.7230, 11.0116, 0.2096> <-0.7204, 11.0199, 0.2047> <-0.7108, 11.0356, 0.2023>
		<-0.7170, 10.9700, 0.1975> <-0.7043, 10.9866, 0.1988> <-0.7022, 10.9963, 0.1948> <-0.6926, 11.0120, 0.1925>
		<-0.6909, 10.9350, 0.1878> <-0.6774, 10.9526, 0.1892> <-0.6756, 10.9623, 0.1845> <-0.6666, 10.9798, 0.1834>
		<-0.6734, 10.9118, 0.1723> <-0.6600, 10.9294, 0.1736> <-0.6592, 10.9395, 0.1706> <-0.6502, 10.9569, 0.1695>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6906, 10.8673, 0.1302> <-0.6958, 10.8715, 0.1403> <-0.7014, 10.8728, 0.1580> <-0.7081, 10.8811, 0.1638>
		<-0.6707, 10.8668, 0.1271> <-0.6759, 10.8710, 0.1372> <-0.6880, 10.8847, 0.1613> <-0.6947, 10.8929, 0.1671>
		<-0.6547, 10.8497, 0.1205> <-0.6650, 10.8634, 0.1355> <-0.6737, 10.8794, 0.1603> <-0.6858, 10.8955, 0.1710>
		<-0.6389, 10.8661, 0.1222> <-0.6493, 10.8798, 0.1372> <-0.6613, 10.8957, 0.1615> <-0.6734, 10.9118, 0.1723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6389, 10.8661, 0.1222> <-0.6493, 10.8798, 0.1372> <-0.6613, 10.8957, 0.1615> <-0.6734, 10.9118, 0.1723>
		<-0.6199, 10.8858, 0.1242> <-0.6302, 10.8995, 0.1393> <-0.6479, 10.9133, 0.1628> <-0.6600, 10.9294, 0.1736>
		<-0.6352, 10.9036, 0.1310> <-0.6404, 10.9125, 0.1409> <-0.6517, 10.9291, 0.1643> <-0.6592, 10.9395, 0.1706>
		<-0.6329, 10.9272, 0.1365> <-0.6381, 10.9361, 0.1464> <-0.6427, 10.9465, 0.1632> <-0.6502, 10.9569, 0.1695>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8969, 10.8350, 0.1908> <-0.8817, 10.8532, 0.1956> <-0.8730, 10.8596, 0.2025> <-0.8577, 10.8821, 0.2032>
		<-0.8736, 10.8023, 0.1806> <-0.8584, 10.8205, 0.1854> <-0.8481, 10.8255, 0.1912> <-0.8327, 10.8480, 0.1920>
		<-0.8413, 10.7574, 0.1723> <-0.8241, 10.7738, 0.1758> <-0.8134, 10.7787, 0.1820> <-0.7981, 10.8011, 0.1828>
		<-0.8192, 10.7261, 0.1567> <-0.8020, 10.7424, 0.1602> <-0.7898, 10.7461, 0.1650> <-0.7745, 10.7685, 0.1657>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8577, 10.8821, 0.2032> <-0.8417, 10.9054, 0.2040> <-0.8384, 10.9166, 0.1977> <-0.8264, 10.9382, 0.1943>
		<-0.8327, 10.8480, 0.1920> <-0.8168, 10.8714, 0.1927> <-0.8145, 10.8848, 0.1875> <-0.8025, 10.9065, 0.1840>
		<-0.7981, 10.8011, 0.1828> <-0.7809, 10.8263, 0.1836> <-0.7800, 10.8383, 0.1778> <-0.7692, 10.8629, 0.1757>
		<-0.7745, 10.7685, 0.1657> <-0.7574, 10.7936, 0.1665> <-0.7574, 10.8077, 0.1623> <-0.7467, 10.8323, 0.1602>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7961, 10.6923, 0.1198> <-0.8030, 10.7024, 0.1309> <-0.8104, 10.7136, 0.1505> <-0.8192, 10.7261, 0.1567>
		<-0.7710, 10.6978, 0.1166> <-0.7780, 10.7079, 0.1276> <-0.7931, 10.7299, 0.1539> <-0.8020, 10.7424, 0.1602>
		<-0.7475, 10.6823, 0.1105> <-0.7605, 10.7009, 0.1268> <-0.7748, 10.7252, 0.1541> <-0.7898, 10.7461, 0.1650>
		<-0.7312, 10.7065, 0.1114> <-0.7442, 10.7251, 0.1277> <-0.7595, 10.7476, 0.1548> <-0.7745, 10.7685, 0.1657>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7312, 10.7065, 0.1114> <-0.7442, 10.7251, 0.1277> <-0.7595, 10.7476, 0.1548> <-0.7745, 10.7685, 0.1657>
		<-0.7083, 10.7403, 0.1127> <-0.7213, 10.7589, 0.1290> <-0.7423, 10.7728, 0.1556> <-0.7574, 10.7936, 0.1665>
		<-0.7267, 10.7633, 0.1191> <-0.7335, 10.7733, 0.1300> <-0.7485, 10.7955, 0.1562> <-0.7574, 10.8077, 0.1623>
		<-0.7239, 10.7990, 0.1239> <-0.7307, 10.8090, 0.1348> <-0.7377, 10.8202, 0.1541> <-0.7467, 10.8323, 0.1602>
	}
	texture {nokti}
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1498, 15.5381, 7.4459> <-2.4901, 15.7711, 7.5652> <-3.0094, 16.0059, 7.6752> <-3.4051, 16.1490, 7.7605>
		<-2.0671, 15.2155, 7.7727> <-2.4073, 15.4485, 7.8920> <-2.9497, 15.8608, 7.8886> <-3.3454, 16.0040, 7.9739>
		<-1.9513, 14.7075, 8.1212> <-2.2180, 15.1699, 8.1592> <-2.7502, 15.4706, 8.2303> <-3.1777, 15.7920, 8.2114>
		<-1.8663, 14.3515, 8.4106> <-2.1330, 14.8139, 8.4486> <-2.6688, 15.3221, 8.4339> <-3.0962, 15.6435, 8.4150>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1498, 15.5381, 7.4459> <-2.2141, 15.7887, 7.1920> <-2.3019, 16.0598, 6.7951> <-2.3527, 16.2479, 6.4894>
		<-2.4901, 15.7711, 7.5652> <-2.5544, 16.0217, 7.3113> <-2.6324, 16.2572, 6.9006> <-2.6832, 16.4453, 6.5950>
		<-3.0094, 16.0059, 7.6752> <-3.0865, 16.1933, 7.3995> <-3.1377, 16.4685, 7.0162> <-3.1759, 16.6264, 6.7151>
		<-3.4051, 16.1490, 7.7605> <-3.4822, 16.3364, 7.4848> <-3.5105, 16.5850, 7.0986> <-3.5487, 16.7429, 6.7974>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1498, 15.5381, 7.4459> <-2.0671, 15.2155, 7.7727> <-1.9513, 14.7075, 8.1212> <-1.8663, 14.3515, 8.4106>
		<-2.0190, 15.4485, 7.4000> <-1.9362, 15.1259, 7.7268> <-1.8639, 14.5559, 8.1087> <-1.7789, 14.1999, 8.3981>
		<-1.9182, 15.2565, 7.2914> <-1.9305, 14.9015, 7.6433> <-1.8966, 14.2910, 8.0686> <-1.9432, 13.9024, 8.3797>
		<-1.8849, 15.1080, 7.2274> <-1.8971, 14.7530, 7.5792> <-1.9938, 14.2013, 7.9533> <-2.0405, 13.8128, 8.2645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1498, 15.5381, 7.4459> <-2.0190, 15.4485, 7.4000> <-1.9182, 15.2565, 7.2914> <-1.8849, 15.1080, 7.2274>
		<-2.2141, 15.7887, 7.1920> <-2.0832, 15.6991, 7.1461> <-1.9097, 15.5049, 7.0452> <-1.8763, 15.3564, 6.9811>
		<-2.3019, 16.0598, 6.7951> <-2.1482, 15.9680, 6.7460> <-2.0135, 15.7800, 6.6568> <-1.9406, 15.6219, 6.5923>
		<-2.3527, 16.2479, 6.4894> <-2.1990, 16.1562, 6.4403> <-2.0448, 15.9594, 6.3581> <-1.9719, 15.8014, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5282, 13.5128, 8.4786> <-2.4447, 13.6319, 8.3013> <-2.3720, 13.7933, 8.0474> <-2.3076, 13.9446, 7.8874>
		<-2.4590, 13.5508, 8.5095> <-2.3755, 13.6700, 8.3321> <-2.2747, 13.8472, 8.1390> <-2.2102, 13.9985, 7.9790>
		<-2.3685, 13.3996, 8.5075> <-2.2659, 13.4852, 8.3923> <-2.1982, 13.6006, 8.2464> <-2.1203, 13.7391, 8.1698>
		<-2.3000, 13.3510, 8.5198> <-2.1974, 13.4367, 8.4047> <-2.1183, 13.6742, 8.3411> <-2.0405, 13.8128, 8.2645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5282, 13.5128, 8.4786> <-2.6721, 13.4336, 8.4144> <-2.7076, 13.1637, 8.3253> <-2.8386, 13.0548, 8.2796>
		<-2.4447, 13.6319, 8.3013> <-2.5887, 13.5527, 8.2370> <-2.6301, 13.2408, 8.1262> <-2.7611, 13.1319, 8.0805>
		<-2.3720, 13.7933, 8.0474> <-2.5071, 13.7185, 7.9203> <-2.6090, 13.4404, 7.8924> <-2.7490, 13.3152, 7.8238>
		<-2.3076, 13.9446, 7.8874> <-2.4427, 13.8698, 7.7603> <-2.5510, 13.5777, 7.7210> <-2.6910, 13.4525, 7.6525>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5282, 13.5128, 8.4786> <-2.4590, 13.5508, 8.5095> <-2.3685, 13.3996, 8.5075> <-2.3000, 13.3510, 8.5198>
		<-2.6139, 13.3904, 8.6609> <-2.5447, 13.4285, 8.6917> <-2.4828, 13.3042, 8.6358> <-2.4143, 13.2556, 8.6481>
		<-2.7887, 13.2064, 8.8696> <-2.7392, 13.2396, 8.8605> <-2.6136, 13.2712, 8.9037> <-2.6227, 13.2639, 8.8446>
		<-2.8693, 13.1426, 9.0816> <-2.8197, 13.1758, 9.0726> <-2.7035, 13.2591, 9.0781> <-2.7126, 13.2518, 9.0189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5282, 13.5128, 8.4786> <-2.6139, 13.3904, 8.6609> <-2.7887, 13.2064, 8.8696> <-2.8693, 13.1426, 9.0816>
		<-2.6721, 13.4336, 8.4144> <-2.7578, 13.3112, 8.5967> <-2.9050, 13.1287, 8.8909> <-2.9855, 13.0649, 9.1029>
		<-2.7076, 13.1637, 8.3253> <-2.8054, 13.0663, 8.5767> <-3.0610, 12.9848, 8.8424> <-3.1399, 12.9558, 9.1166>
		<-2.8386, 13.0548, 8.2796> <-2.9365, 12.9574, 8.5310> <-3.1830, 12.9133, 8.8454> <-3.2620, 12.8843, 9.1196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8693, 13.1426, 9.0816> <-2.9376, 13.0885, 9.2617> <-2.9698, 13.1236, 9.5378> <-3.0052, 13.1349, 9.7344>
		<-2.9855, 13.0649, 9.1029> <-3.0539, 13.0107, 9.2830> <-3.0457, 13.0562, 9.5756> <-3.0810, 13.0674, 9.7722>
		<-3.1399, 12.9558, 9.1166> <-3.1947, 12.9357, 9.3069> <-3.1719, 12.9129, 9.5781> <-3.1693, 12.9315, 9.7762>
		<-3.2620, 12.8843, 9.1196> <-3.3167, 12.8642, 9.3099> <-3.2739, 12.8771, 9.5848> <-3.2713, 12.8958, 9.7829>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8693, 13.1426, 9.0816> <-2.8197, 13.1758, 9.0726> <-2.7035, 13.2591, 9.0781> <-2.7126, 13.2518, 9.0189>
		<-2.9376, 13.0885, 9.2617> <-2.8881, 13.1216, 9.2526> <-2.7810, 13.2488, 9.2285> <-2.7901, 13.2415, 9.1694>
		<-2.9698, 13.1236, 9.5378> <-2.9121, 13.1749, 9.5092> <-2.8146, 13.2780, 9.4814> <-2.8166, 13.2543, 9.4027>
		<-3.0052, 13.1349, 9.7344> <-2.9475, 13.1861, 9.7058> <-2.8387, 13.3024, 9.6475> <-2.8406, 13.2787, 9.5687>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0052, 13.1349, 9.7344> <-3.0168, 13.1386, 9.7994> <-3.0215, 13.1581, 9.8897> <-3.0248, 13.1920, 9.9464>
		<-3.0810, 13.0674, 9.7722> <-3.0927, 13.0711, 9.8371> <-3.0890, 13.0921, 9.9093> <-3.0923, 13.1259, 9.9660>
		<-3.1693, 12.9315, 9.7762> <-3.1685, 12.9372, 9.8361> <-3.2236, 13.0004, 9.8596> <-3.2222, 13.0338, 9.9096>
		<-3.2713, 12.8958, 9.7829> <-3.2706, 12.9015, 9.8428> <-3.2523, 12.9311, 9.9202> <-3.2509, 12.9645, 9.9702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0052, 13.1349, 9.7344> <-2.9475, 13.1861, 9.7058> <-2.8387, 13.3024, 9.6475> <-2.8406, 13.2787, 9.5687>
		<-3.0168, 13.1386, 9.7994> <-2.9592, 13.1898, 9.7707> <-2.8512, 13.3151, 9.7343> <-2.8531, 13.2914, 9.6555>
		<-3.0215, 13.1581, 9.8897> <-2.9623, 13.2160, 9.8724> <-2.8750, 13.3581, 9.8577> <-2.8657, 13.3302, 9.7784>
		<-3.0248, 13.1920, 9.9464> <-2.9656, 13.2498, 9.9291> <-2.8419, 13.4013, 9.9276> <-2.8326, 13.3734, 9.8483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0444, 13.5350, 10.4048> <-3.1146, 13.5166, 10.4559> <-3.1930, 13.4672, 10.5332> <-3.2482, 13.4405, 10.5973>
		<-3.0575, 13.3826, 10.3265> <-3.1277, 13.3641, 10.3775> <-3.1616, 13.2708, 10.4058> <-3.2168, 13.2441, 10.4699>
		<-3.0334, 13.2800, 10.0938> <-3.1010, 13.2139, 10.1135> <-3.2166, 13.1651, 10.1058> <-3.2453, 13.0958, 10.1665>
		<-3.0248, 13.1920, 9.9464> <-3.0923, 13.1259, 9.9660> <-3.2222, 13.0338, 9.9096> <-3.2509, 12.9645, 9.9702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0444, 13.5350, 10.4048> <-3.0575, 13.3826, 10.3265> <-3.0334, 13.2800, 10.0938> <-3.0248, 13.1920, 9.9464>
		<-2.9134, 13.5695, 10.3097> <-2.9265, 13.4171, 10.2313> <-2.9742, 13.3378, 10.0765> <-2.9656, 13.2498, 9.9291>
		<-2.6210, 13.6826, 10.2601> <-2.7048, 13.5902, 10.2191> <-2.7929, 13.4654, 10.0312> <-2.8419, 13.4013, 9.9276>
		<-2.5827, 13.6156, 10.1137> <-2.6665, 13.5232, 10.0727> <-2.7836, 13.4374, 9.9519> <-2.8326, 13.3734, 9.8483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0444, 13.5350, 10.4048> <-3.0322, 13.6769, 10.4778> <-2.9760, 13.9253, 10.4755> <-2.9501, 14.0597, 10.3927>
		<-3.1146, 13.5166, 10.4559> <-3.1024, 13.6584, 10.5288> <-3.1088, 13.9522, 10.5580> <-3.0829, 14.0866, 10.4752>
		<-3.1930, 13.4672, 10.5332> <-3.2159, 13.6107, 10.6263> <-3.2278, 13.8679, 10.6701> <-3.2653, 14.0154, 10.5886>
		<-3.2482, 13.4405, 10.5973> <-3.2711, 13.5840, 10.6904> <-3.3773, 13.8424, 10.7166> <-3.4147, 13.9899, 10.6351>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0444, 13.5350, 10.4048> <-2.9134, 13.5695, 10.3097> <-2.6210, 13.6826, 10.2601> <-2.5827, 13.6156, 10.1137>
		<-3.0322, 13.6769, 10.4778> <-2.9012, 13.7113, 10.3826> <-2.5757, 13.7324, 10.2823> <-2.5374, 13.6655, 10.1358>
		<-2.9760, 13.9253, 10.4755> <-2.8080, 13.8914, 10.3710> <-2.5456, 13.8658, 10.2386> <-2.4789, 13.7541, 10.0858>
		<-2.9501, 14.0597, 10.3927> <-2.7821, 14.0258, 10.2882> <-2.5170, 13.9066, 10.1882> <-2.4502, 13.7949, 10.0354>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9501, 14.0597, 10.3927> <-2.8993, 14.3230, 10.2306> <-2.8105, 14.5697, 9.8819> <-2.8058, 14.7723, 9.6429>
		<-3.0829, 14.0866, 10.4752> <-3.0321, 14.3498, 10.3131> <-3.0262, 14.6537, 9.9560> <-3.0214, 14.8563, 9.7170>
		<-3.2653, 14.0154, 10.5886> <-3.3373, 14.2991, 10.4317> <-3.3003, 14.5939, 10.0537> <-3.3529, 14.8082, 9.8055>
		<-3.4147, 13.9899, 10.6351> <-3.4868, 14.2737, 10.4783> <-3.5323, 14.5521, 10.1128> <-3.5848, 14.7664, 9.8645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9501, 14.0597, 10.3927> <-2.7821, 14.0258, 10.2882> <-2.5170, 13.9066, 10.1882> <-2.4502, 13.7949, 10.0354>
		<-2.8993, 14.3230, 10.2306> <-2.7313, 14.2890, 10.1261> <-2.4161, 14.0503, 10.0109> <-2.3493, 13.9386, 9.8581>
		<-2.8105, 14.5697, 9.8819> <-2.5728, 14.4772, 9.8002> <-2.3731, 14.3150, 9.7200> <-2.2735, 14.1123, 9.5759>
		<-2.8058, 14.7723, 9.6429> <-2.5680, 14.6798, 9.5613> <-2.2627, 14.4156, 9.5202> <-2.1630, 14.2130, 9.3761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8058, 14.7723, 9.6429> <-2.8019, 14.9364, 9.4495> <-2.8737, 15.1238, 9.1710> <-2.9218, 15.2679, 8.9678>
		<-3.0214, 14.8563, 9.7170> <-3.0176, 15.0203, 9.5236> <-3.0994, 15.2251, 9.2068> <-3.1474, 15.3692, 9.0037>
		<-3.3529, 14.8082, 9.8055> <-3.3997, 14.9991, 9.5844> <-3.4503, 15.1778, 9.2967> <-3.4959, 15.3473, 9.0587>
		<-3.5848, 14.7664, 9.8645> <-3.6317, 14.9573, 9.6435> <-3.6993, 15.1666, 9.3140> <-3.7449, 15.3362, 9.0760>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8058, 14.7723, 9.6429> <-2.5680, 14.6798, 9.5613> <-2.2627, 14.4156, 9.5202> <-2.1630, 14.2130, 9.3761>
		<-2.8019, 14.9364, 9.4495> <-2.5642, 14.8438, 9.3678> <-2.1591, 14.5100, 9.3328> <-2.0595, 14.3073, 9.1888>
		<-2.8737, 15.1238, 9.1710> <-2.4794, 14.9469, 9.1083> <-2.0079, 14.7508, 9.1637> <-1.8123, 14.4064, 8.9797>
		<-2.9218, 15.2679, 8.9678> <-2.5275, 15.0910, 8.9052> <-1.9398, 14.7826, 8.9421> <-1.7442, 14.4382, 8.7582>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9218, 15.2679, 8.9678> <-2.9610, 15.3857, 8.8019> <-3.0325, 15.5272, 8.5743> <-3.0962, 15.6435, 8.4150>
		<-3.1474, 15.3692, 9.0037> <-3.1867, 15.4869, 8.8377> <-3.2291, 15.6750, 8.5656> <-3.2928, 15.7913, 8.4063>
		<-3.4959, 15.3473, 9.0587> <-3.5390, 15.5076, 8.8338> <-3.5946, 15.6830, 8.5648> <-3.6361, 15.8408, 8.3379>
		<-3.7449, 15.3362, 9.0760> <-3.7880, 15.4964, 8.8511> <-3.8389, 15.7079, 8.5485> <-3.8804, 15.8657, 8.3216>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9218, 15.2679, 8.9678> <-2.5275, 15.0910, 8.9052> <-1.9398, 14.7826, 8.9421> <-1.7442, 14.4382, 8.7582>
		<-2.9610, 15.3857, 8.8019> <-2.5667, 15.2087, 8.7393> <-1.9068, 14.7980, 8.8346> <-1.7111, 14.4536, 8.6507>
		<-3.0325, 15.5272, 8.5743> <-2.6050, 15.2059, 8.5931> <-2.0963, 14.8399, 8.5529> <-1.8297, 14.3775, 8.5149>
		<-3.0962, 15.6435, 8.4150> <-2.6688, 15.3221, 8.4339> <-2.1330, 14.8139, 8.4486> <-1.8663, 14.3515, 8.4106>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0962, 15.6435, 8.4150> <-3.1777, 15.7920, 8.2114> <-3.3454, 16.0040, 7.9739> <-3.4051, 16.1490, 7.7605>
		<-3.2928, 15.7913, 8.4063> <-3.3743, 15.9398, 8.2028> <-3.5039, 16.0614, 8.0081> <-3.5636, 16.2064, 7.7947>
		<-3.6361, 15.8408, 8.3379> <-3.6625, 15.9413, 8.1936> <-3.7756, 16.1086, 7.9720> <-3.7999, 16.2044, 7.8241>
		<-3.8804, 15.8657, 8.3216> <-3.9068, 15.9662, 8.1772> <-3.9469, 16.1015, 7.9865> <-3.9712, 16.1972, 7.8386>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4051, 16.1490, 7.7605> <-3.4822, 16.3364, 7.4848> <-3.5105, 16.5850, 7.0986> <-3.5487, 16.7429, 6.7974>
		<-3.5636, 16.2064, 7.7947> <-3.6407, 16.3938, 7.5190> <-3.6721, 16.6356, 7.1343> <-3.7103, 16.7935, 6.8331>
		<-3.7999, 16.2044, 7.8241> <-3.8466, 16.3889, 7.5392> <-3.9060, 16.6472, 7.1655> <-3.9446, 16.8066, 6.8646>
		<-3.9712, 16.1972, 7.8386> <-4.0179, 16.3817, 7.5537> <-4.0783, 16.6401, 7.1800> <-4.1169, 16.7995, 6.8792>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8787, 13.9376, 6.6767> <-2.7575, 14.1361, 6.4523> <-2.4735, 14.3567, 6.1903> <-2.3510, 14.5180, 5.9385>
		<-2.7333, 13.9887, 6.7634> <-2.6121, 14.1872, 6.5391> <-2.4097, 14.4021, 6.2029> <-2.2873, 14.5634, 5.9512>
		<-2.5142, 13.9929, 6.9057> <-2.4242, 14.1911, 6.6333> <-2.2419, 14.4397, 6.2680> <-2.1751, 14.6005, 5.9658>
		<-2.3939, 14.1078, 6.9659> <-2.3039, 14.3060, 6.6935> <-2.2054, 14.5085, 6.2828> <-2.1386, 14.6692, 5.9806>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8787, 13.9376, 6.6767> <-2.7333, 13.9887, 6.7634> <-2.5142, 13.9929, 6.9057> <-2.3939, 14.1078, 6.9659>
		<-3.0068, 13.7279, 6.9138> <-2.8614, 13.7789, 7.0005> <-2.5912, 13.8233, 7.1388> <-2.4709, 13.9381, 7.1989>
		<-3.0794, 13.3724, 7.2054> <-2.9343, 13.4574, 7.2622> <-2.7391, 13.5218, 7.3666> <-2.6148, 13.6329, 7.4274>
		<-3.1746, 13.1694, 7.4629> <-3.0295, 13.2543, 7.5198> <-2.8153, 13.3414, 7.5916> <-2.6910, 13.4525, 7.6525>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1746, 13.1694, 7.4629> <-3.0295, 13.2543, 7.5198> <-2.8153, 13.3414, 7.5916> <-2.6910, 13.4525, 7.6525>
		<-3.2455, 13.0180, 7.6550> <-3.1005, 13.1029, 7.7119> <-2.8733, 13.2040, 7.7630> <-2.7490, 13.3152, 7.8238>
		<-3.3678, 12.8302, 7.9261> <-3.1909, 12.9172, 7.9606> <-2.9099, 13.0083, 8.0286> <-2.7611, 13.1319, 8.0805>
		<-3.4285, 12.7647, 8.1646> <-3.2515, 12.8517, 8.1991> <-2.9873, 12.9312, 8.2277> <-2.8386, 13.0548, 8.2796>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4285, 12.7647, 8.1646> <-3.2515, 12.8517, 8.1991> <-2.9873, 12.9312, 8.2277> <-2.8386, 13.0548, 8.2796>
		<-3.4963, 12.6914, 8.4314> <-3.3193, 12.7785, 8.4659> <-3.0852, 12.8339, 8.4791> <-2.9365, 12.9574, 8.5310>
		<-3.5503, 12.6954, 8.8182> <-3.4517, 12.7447, 8.8243> <-3.2782, 12.8575, 8.8477> <-3.1830, 12.9133, 8.8454>
		<-3.5905, 12.7200, 9.0991> <-3.4919, 12.7693, 9.1052> <-3.3572, 12.8285, 9.1219> <-3.2620, 12.8843, 9.1196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5905, 12.7200, 9.0991> <-3.4919, 12.7693, 9.1052> <-3.3572, 12.8285, 9.1219> <-3.2620, 12.8843, 9.1196>
		<-3.6204, 12.7383, 9.3081> <-3.5219, 12.7876, 9.3143> <-3.4119, 12.8084, 9.3122> <-3.3167, 12.8642, 9.3099>
		<-3.6387, 12.8501, 9.5738> <-3.6629, 12.8754, 9.4628> <-3.3836, 12.8387, 9.5920> <-3.2739, 12.8771, 9.5848>
		<-3.6593, 12.9059, 9.7773> <-3.6835, 12.9312, 9.6662> <-3.3810, 12.8574, 9.7901> <-3.2713, 12.8958, 9.7829>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6910, 13.4525, 7.6525> <-2.6148, 13.6329, 7.4274> <-2.4709, 13.9381, 7.1989> <-2.3939, 14.1078, 6.9659>
		<-2.5510, 13.5777, 7.7210> <-2.4748, 13.7581, 7.4960> <-2.3045, 14.0970, 7.2820> <-2.2275, 14.2666, 7.0490>
		<-2.4427, 13.8698, 7.7603> <-2.3426, 14.1045, 7.5121> <-2.1503, 14.3663, 7.3465> <-2.0905, 14.5811, 7.0690>
		<-2.3076, 13.9446, 7.8874> <-2.2075, 14.1793, 7.6392> <-2.0422, 14.5785, 7.4020> <-1.9825, 14.7934, 7.1245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2713, 12.8958, 9.7829> <-3.2706, 12.9015, 9.8428> <-3.2523, 12.9311, 9.9202> <-3.2509, 12.9645, 9.9702>
		<-3.3810, 12.8574, 9.7901> <-3.3803, 12.8631, 9.8500> <-3.2736, 12.8798, 9.9650> <-3.2721, 12.9132, 10.0150>
		<-3.6835, 12.9312, 9.6662> <-3.5255, 12.9390, 9.7851> <-3.2215, 12.8429, 9.9430> <-3.1564, 12.9335, 10.1065>
		<-3.6593, 12.9059, 9.7773> <-3.5012, 12.9137, 9.8962> <-3.1975, 12.8414, 10.0101> <-3.1324, 12.9320, 10.1736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2482, 13.4405, 10.5973> <-3.2689, 13.4305, 10.6214> <-3.2969, 13.4187, 10.6621> <-3.2941, 13.4142, 10.6950>
		<-3.2168, 13.2441, 10.4699> <-3.2376, 13.2341, 10.4940> <-3.1488, 13.2833, 10.5755> <-3.1460, 13.2789, 10.6084>
		<-3.2453, 13.0958, 10.1665> <-3.2666, 13.0445, 10.2113> <-3.0846, 13.0335, 10.2870> <-3.0606, 13.0320, 10.3541>
		<-3.2509, 12.9645, 9.9702> <-3.2721, 12.9132, 10.0150> <-3.1564, 12.9335, 10.1065> <-3.1324, 12.9320, 10.1736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2482, 13.4405, 10.5973> <-3.2711, 13.5840, 10.6904> <-3.3773, 13.8424, 10.7166> <-3.4147, 13.9899, 10.6351>
		<-3.2689, 13.4305, 10.6214> <-3.2919, 13.5740, 10.7145> <-3.5901, 13.8062, 10.7829> <-3.6275, 13.9537, 10.7014>
		<-3.2969, 13.4187, 10.6621> <-3.4922, 13.5972, 10.7762> <-3.6702, 13.7781, 10.7540> <-3.9251, 13.9107, 10.7749>
		<-3.2941, 13.4142, 10.6950> <-3.4895, 13.5927, 10.8091> <-3.8890, 13.7237, 10.7436> <-4.1440, 13.8564, 10.7645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5848, 14.7664, 9.8645> <-3.8246, 14.7233, 9.9256> <-4.1142, 14.5544, 10.0570> <-4.3570, 14.4931, 10.0378>
		<-3.5323, 14.5521, 10.1128> <-3.7721, 14.5089, 10.1738> <-4.0699, 14.3718, 10.2867> <-4.3127, 14.3105, 10.2676>
		<-3.4868, 14.2737, 10.4783> <-3.6996, 14.2374, 10.5445> <-3.9890, 14.1018, 10.5569> <-4.2079, 14.0474, 10.5465>
		<-3.4147, 13.9899, 10.6351> <-3.6275, 13.9537, 10.7014> <-3.9251, 13.9107, 10.7749> <-4.1440, 13.8564, 10.7645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5848, 14.7664, 9.8645> <-3.6317, 14.9573, 9.6435> <-3.6993, 15.1666, 9.3140> <-3.7449, 15.3362, 9.0760>
		<-3.8246, 14.7233, 9.9256> <-3.8715, 14.9141, 9.7045> <-3.9200, 15.1568, 9.3293> <-3.9655, 15.3263, 9.0913>
		<-4.1142, 14.5544, 10.0570> <-4.1679, 14.7756, 9.7786> <-4.2231, 15.0283, 9.3790> <-4.2540, 15.2441, 9.0931>
		<-4.3570, 14.4931, 10.0378> <-4.4107, 14.7143, 9.7594> <-4.4391, 14.9829, 9.3614> <-4.4699, 15.1987, 9.0754>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7449, 15.3362, 9.0760> <-3.7880, 15.4964, 8.8511> <-3.8389, 15.7079, 8.5485> <-3.8804, 15.8657, 8.3216>
		<-3.9655, 15.3263, 9.0913> <-4.0086, 15.4866, 8.8664> <-4.0373, 15.7281, 8.5352> <-4.0788, 15.8860, 8.3083>
		<-4.2540, 15.2441, 9.0931> <-4.2787, 15.4176, 8.8631> <-4.3064, 15.6747, 8.5351> <-4.3504, 15.8452, 8.3057>
		<-4.4699, 15.1987, 9.0754> <-4.4947, 15.3723, 8.8455> <-4.4983, 15.6203, 8.5477> <-4.5424, 15.7908, 8.3183>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8804, 15.8657, 8.3216> <-3.9068, 15.9662, 8.1772> <-3.9469, 16.1015, 7.9865> <-3.9712, 16.1972, 7.8386>
		<-4.0788, 15.8860, 8.3083> <-4.1052, 15.9864, 8.1640> <-4.1673, 16.0923, 8.0051> <-4.1916, 16.1880, 7.8572>
		<-4.3504, 15.8452, 8.3057> <-4.3762, 15.9451, 8.1714> <-4.4519, 16.0578, 8.0098> <-4.4861, 16.1469, 7.8699>
		<-4.5424, 15.7908, 8.3183> <-4.5681, 15.8907, 8.1840> <-4.6671, 16.0057, 8.0098> <-4.7013, 16.0949, 7.8699>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9712, 16.1972, 7.8386> <-4.0179, 16.3817, 7.5537> <-4.0783, 16.6401, 7.1800> <-4.1169, 16.7995, 6.8792>
		<-4.1916, 16.1880, 7.8572> <-4.2383, 16.3725, 7.5723> <-4.3107, 16.6305, 7.1997> <-4.3493, 16.7899, 6.8989>
		<-4.4861, 16.1469, 7.8699> <-4.5553, 16.3273, 7.5867> <-4.6143, 16.5846, 7.2115> <-4.6594, 16.7425, 6.9105>
		<-4.7013, 16.0949, 7.8699> <-4.7705, 16.2753, 7.5867> <-4.8412, 16.5297, 7.2115> <-4.8862, 16.6876, 6.9105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2051, 17.1643, 6.0139> <-4.4375, 17.1547, 6.0336> <-4.7437, 17.0860, 6.0358> <-4.9745, 17.0524, 6.0452>
		<-4.1787, 17.0548, 6.2735> <-4.4110, 17.0452, 6.2932> <-4.5473, 17.0630, 6.2383> <-4.7781, 17.0295, 6.2477>
		<-4.1487, 16.9312, 6.6308> <-4.3811, 16.9216, 6.6504> <-4.6965, 16.8729, 6.6621> <-4.9234, 16.8180, 6.6621>
		<-4.1169, 16.7995, 6.8792> <-4.3493, 16.7899, 6.8989> <-4.6594, 16.7425, 6.9105> <-4.8862, 16.6876, 6.9105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2051, 17.1643, 6.0139> <-4.1787, 17.0548, 6.2735> <-4.1487, 16.9312, 6.6308> <-4.1169, 16.7995, 6.8792>
		<-4.0328, 17.1714, 5.9994> <-4.0064, 17.0620, 6.2590> <-3.9765, 16.9383, 6.6162> <-3.9446, 16.8066, 6.8646>
		<-3.7997, 17.1563, 5.9652> <-3.7732, 17.0469, 6.2248> <-3.7419, 16.9240, 6.5841> <-3.7103, 16.7935, 6.8331>
		<-3.6369, 17.1077, 5.9321> <-3.6105, 16.9982, 6.1917> <-3.5803, 16.8735, 6.5484> <-3.5487, 16.7429, 6.7974>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6369, 17.1077, 5.9321> <-3.6105, 16.9982, 6.1917> <-3.5803, 16.8735, 6.5484> <-3.5487, 16.7429, 6.7974>
		<-3.2679, 16.9974, 5.8572> <-3.2415, 16.8880, 6.1168> <-3.2075, 16.7569, 6.4660> <-3.1759, 16.6264, 6.7151>
		<-2.7733, 16.8343, 5.7552> <-2.7449, 16.7169, 6.0049> <-2.7221, 16.5892, 6.3611> <-2.6832, 16.4453, 6.5950>
		<-2.4473, 16.6392, 5.6570> <-2.4190, 16.5218, 5.9068> <-2.3916, 16.3919, 6.2555> <-2.3527, 16.2479, 6.4894>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4473, 16.6392, 5.6570> <-2.4190, 16.5218, 5.9068> <-2.3916, 16.3919, 6.2555> <-2.3527, 16.2479, 6.4894>
		<-2.2894, 16.5447, 5.6095> <-2.2610, 16.4273, 5.8592> <-2.2379, 16.3001, 6.2064> <-2.1990, 16.1562, 6.4403>
		<-2.1487, 16.3280, 5.5302> <-2.1192, 16.2176, 5.7801> <-2.0694, 16.1004, 6.1234> <-2.0448, 15.9594, 6.3581>
		<-2.0701, 16.1696, 5.4605> <-2.0406, 16.0591, 5.7104> <-1.9965, 15.9423, 6.0590> <-1.9719, 15.8014, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9742, 15.6856, 5.2373> <-1.9864, 15.8399, 5.2868> <-2.0029, 16.0342, 5.4009> <-2.0701, 16.1696, 5.4605>
		<-1.9594, 15.5759, 5.4995> <-1.9716, 15.7302, 5.5489> <-1.9735, 15.9238, 5.6508> <-2.0406, 16.0591, 5.7104>
		<-1.9238, 15.4416, 5.8540> <-1.9020, 15.5896, 5.8949> <-1.9356, 15.8103, 6.0052> <-1.9965, 15.9423, 6.0590>
		<-1.9249, 15.3200, 6.1112> <-1.9031, 15.4680, 6.1522> <-1.9110, 15.6693, 6.2398> <-1.9719, 15.8014, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9742, 15.6856, 5.2373> <-1.9594, 15.5759, 5.4995> <-1.9238, 15.4416, 5.8540> <-1.9249, 15.3200, 6.1112>
		<-1.9606, 15.5131, 5.1820> <-1.9458, 15.4034, 5.4442> <-1.9532, 15.2420, 5.7988> <-1.9543, 15.1203, 6.0561>
		<-1.9548, 15.2672, 5.1551> <-2.0009, 15.1402, 5.4147> <-1.9862, 14.9856, 5.7662> <-2.0422, 14.8507, 6.0197>
		<-1.9850, 15.0925, 5.1153> <-2.0311, 14.9655, 5.3749> <-2.0826, 14.8042, 5.7271> <-2.1386, 14.6692, 5.9806>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9850, 15.0925, 5.1153> <-2.0311, 14.9655, 5.3749> <-2.0826, 14.8042, 5.7271> <-2.1386, 14.6692, 5.9806>
		<-1.9937, 15.0417, 5.1038> <-2.0398, 14.9148, 5.3634> <-2.1191, 14.7354, 5.7123> <-2.1751, 14.6005, 5.9658>
		<-2.0646, 15.0033, 5.0859> <-2.1403, 14.8692, 5.3455> <-2.1729, 14.7141, 5.7160> <-2.2873, 14.5634, 5.9512>
		<-2.0988, 14.9651, 5.0733> <-2.1744, 14.8310, 5.3328> <-2.2366, 14.6687, 5.7034> <-2.3510, 14.5180, 5.9385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9249, 15.3200, 6.1112> <-1.9031, 15.4680, 6.1522> <-1.9110, 15.6693, 6.2398> <-1.9719, 15.8014, 6.2936>
		<-1.9262, 15.1734, 6.4214> <-1.9045, 15.3213, 6.4623> <-1.8797, 15.4898, 6.5385> <-1.9406, 15.6219, 6.5923>
		<-1.9249, 15.0004, 6.8572> <-1.8791, 15.0903, 6.8807> <-1.8554, 15.2634, 6.9410> <-1.8763, 15.3564, 6.9811>
		<-1.9825, 14.7934, 7.1245> <-1.9367, 14.8833, 7.1480> <-1.8640, 15.0149, 7.1872> <-1.8849, 15.1080, 7.2274>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9249, 15.3200, 6.1112> <-1.9262, 15.1734, 6.4214> <-1.9249, 15.0004, 6.8572> <-1.9825, 14.7934, 7.1245>
		<-1.9543, 15.1203, 6.0561> <-1.9556, 14.9737, 6.3662> <-2.0329, 14.7882, 6.8017> <-2.0905, 14.5811, 7.0690>
		<-2.0422, 14.8507, 6.0197> <-2.1090, 14.6899, 6.3218> <-2.1375, 14.4648, 6.7766> <-2.2275, 14.2666, 7.0490>
		<-2.1386, 14.6692, 5.9806> <-2.2054, 14.5085, 6.2828> <-2.3039, 14.3060, 6.6935> <-2.3939, 14.1078, 6.9659>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5827, 13.6156, 10.1137> <-2.6665, 13.5232, 10.0727> <-2.7836, 13.4374, 9.9519> <-2.8326, 13.3734, 9.8483>
		<-2.4560, 13.3942, 9.6291> <-2.5398, 13.3018, 9.5881> <-2.7323, 13.2839, 9.5166> <-2.7813, 13.2198, 9.4130>
		<-2.5689, 12.9312, 9.0326> <-2.6596, 12.9296, 9.0274> <-2.7931, 12.8490, 8.9498> <-2.8676, 12.8476, 8.8981>
		<-2.5578, 12.6847, 8.5437> <-2.6484, 12.6831, 8.5386> <-2.7761, 12.6721, 8.5207> <-2.8507, 12.6707, 8.4690>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5827, 13.6156, 10.1137> <-2.4560, 13.3942, 9.6291> <-2.5689, 12.9312, 9.0326> <-2.5578, 12.6847, 8.5437>
		<-2.5374, 13.6655, 10.1358> <-2.4107, 13.4441, 9.6512> <-2.4397, 12.9336, 9.0399> <-2.4286, 12.6870, 8.5511>
		<-2.4789, 13.7541, 10.0858> <-2.2878, 13.4345, 9.6485> <-2.3259, 13.0230, 9.0301> <-2.2424, 12.6899, 8.5697>
		<-2.4502, 13.7949, 10.0354> <-2.2592, 13.4753, 9.5981> <-2.2112, 13.0168, 8.9705> <-2.1277, 12.6837, 8.5101>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8406, 13.2787, 9.5687> <-2.8166, 13.2543, 9.4027> <-2.7901, 13.2415, 9.1694> <-2.7126, 13.2518, 9.0189>
		<-2.8511, 13.1488, 9.1372> <-2.8271, 13.1245, 8.9711> <-2.8526, 13.1915, 8.7646> <-2.7751, 13.2019, 8.6142>
		<-3.0171, 12.8509, 8.6219> <-3.0638, 12.9131, 8.4693> <-3.0696, 13.1422, 8.2065> <-3.0102, 13.2045, 8.0584>
		<-3.0423, 12.6755, 8.2075> <-3.0890, 12.7377, 8.0548> <-3.1385, 12.9126, 7.8706> <-3.0790, 12.9749, 7.7225>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8406, 13.2787, 9.5687> <-2.8511, 13.1488, 9.1372> <-3.0171, 12.8509, 8.6219> <-3.0423, 12.6755, 8.2075>
		<-2.8531, 13.2914, 9.6555> <-2.8636, 13.1615, 9.2240> <-2.9906, 12.8156, 8.7086> <-3.0158, 12.6401, 8.2941>
		<-2.8657, 13.3302, 9.7784> <-2.8144, 13.1766, 9.3431> <-2.9475, 12.8461, 8.8426> <-2.9306, 12.6692, 8.4135>
		<-2.8326, 13.3734, 9.8483> <-2.7813, 13.2198, 9.4130> <-2.8676, 12.8476, 8.8981> <-2.8507, 12.6707, 8.4690>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7126, 13.2518, 9.0189> <-2.6227, 13.2639, 8.8446> <-2.4143, 13.2556, 8.6481> <-2.3000, 13.3510, 8.5198>
		<-2.7751, 13.2019, 8.6142> <-2.6852, 13.2139, 8.4398> <-2.5248, 13.1706, 8.2748> <-2.4105, 13.2660, 8.1465>
		<-3.0102, 13.2045, 8.0584> <-2.9462, 13.2715, 7.8991> <-2.7411, 13.3469, 7.6203> <-2.5754, 13.3508, 7.5400>
		<-3.0790, 12.9749, 7.7225> <-3.0151, 13.0419, 7.5633> <-2.8339, 13.0637, 7.3559> <-2.6682, 13.0676, 7.2755>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3000, 13.3510, 8.5198> <-2.1974, 13.4367, 8.4047> <-2.1183, 13.6742, 8.3411> <-2.0405, 13.8128, 8.2645>
		<-2.4105, 13.2660, 8.1465> <-2.3079, 13.3516, 8.0314> <-2.1386, 13.4297, 8.0373> <-2.0607, 13.5682, 7.9607>
		<-2.5754, 13.3508, 7.5400> <-2.4229, 13.3544, 7.4661> <-2.2253, 13.3663, 7.4284> <-2.0586, 13.3371, 7.4385>
		<-2.6682, 13.0676, 7.2755> <-2.5157, 13.0711, 7.2016> <-2.2747, 13.0269, 7.2417> <-2.1080, 12.9977, 7.2518>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7442, 14.4382, 8.7582> <-1.8123, 14.4064, 8.9797> <-2.0595, 14.3073, 9.1888> <-2.1630, 14.2130, 9.3761>
		<-1.4725, 13.9598, 8.5027> <-1.5405, 13.9280, 8.7242> <-1.8309, 13.8427, 8.8584> <-1.9345, 13.7483, 9.0457>
		<-1.5180, 13.3008, 7.9353> <-1.5163, 13.2465, 8.0971> <-1.7304, 13.1014, 8.4058> <-1.8290, 13.0872, 8.5443>
		<-1.5049, 12.7736, 7.6356> <-1.5032, 12.7193, 7.7974> <-1.6591, 12.6557, 7.9892> <-1.7577, 12.6414, 8.1277>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7442, 14.4382, 8.7582> <-1.4725, 13.9598, 8.5027> <-1.5180, 13.3008, 7.9353> <-1.5049, 12.7736, 7.6356>
		<-1.7111, 14.4536, 8.6507> <-1.4394, 13.9752, 8.3952> <-1.5193, 13.3413, 7.8147> <-1.5062, 12.8142, 7.5149>
		<-1.8297, 14.3775, 8.5149> <-1.7996, 13.9449, 8.1907> <-1.6248, 13.3587, 7.6279> <-1.6636, 12.8713, 7.3952>
		<-1.8663, 14.3515, 8.4106> <-1.8362, 13.9189, 8.0864> <-1.7273, 13.3968, 7.5627> <-1.7661, 12.9094, 7.3300>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1630, 14.2130, 9.3761> <-2.2735, 14.1123, 9.5759> <-2.3493, 13.9386, 9.8581> <-2.4502, 13.7949, 10.0354>
		<-1.9345, 13.7483, 9.0457> <-2.0449, 13.6477, 9.2455> <-2.1583, 13.6189, 9.4208> <-2.2592, 13.4753, 9.5981>
		<-1.8290, 13.0872, 8.5443> <-1.9216, 13.0738, 8.6743> <-2.0693, 13.0091, 8.8967> <-2.2112, 13.0168, 8.9705>
		<-1.7577, 12.6414, 8.1277> <-1.8503, 12.6281, 8.2577> <-1.9858, 12.6760, 8.4363> <-2.1277, 12.6837, 8.5101>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8849, 15.1080, 7.2274> <-1.8971, 14.7530, 7.5792> <-1.9938, 14.2013, 7.9533> <-2.0405, 13.8128, 8.2645>
		<-1.8640, 15.0149, 7.1872> <-1.8762, 14.6599, 7.5390> <-2.0737, 14.1277, 7.8586> <-2.1203, 13.7391, 8.1698>
		<-1.9367, 14.8833, 7.1480> <-1.9965, 14.6684, 7.4255> <-2.1102, 14.2333, 7.7308> <-2.2102, 13.9985, 7.9790>
		<-1.9825, 14.7934, 7.1245> <-2.0422, 14.5785, 7.4020> <-2.2075, 14.1793, 7.6392> <-2.3076, 13.9446, 7.8874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8663, 14.3515, 8.4106> <-1.8362, 13.9189, 8.0864> <-1.7273, 13.3968, 7.5627> <-1.7661, 12.9094, 7.3300>
		<-1.7789, 14.1999, 8.3981> <-1.7488, 13.7673, 8.0739> <-1.8146, 13.4292, 7.5071> <-1.8535, 12.9418, 7.2744>
		<-1.9432, 13.9024, 8.3797> <-1.9635, 13.6579, 8.0759> <-1.9519, 13.3184, 7.4449> <-2.0013, 12.9790, 7.2582>
		<-2.0405, 13.8128, 8.2645> <-2.0607, 13.5682, 7.9607> <-2.0586, 13.3371, 7.4385> <-2.1080, 12.9977, 7.2518>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6593, 12.9059, 9.7773> <-3.5012, 12.9137, 9.8962> <-3.1975, 12.8414, 10.0101> <-3.1324, 12.9320, 10.1736>
		<-3.6152, 12.8598, 9.9794> <-3.4571, 12.8676, 10.0983> <-3.1249, 12.8370, 10.2129> <-3.0599, 12.9276, 10.3764>
		<-3.2597, 12.8554, 10.0917> <-3.1895, 12.9033, 10.2701> <-2.9476, 12.8812, 10.4711> <-2.9499, 12.9665, 10.6494>
		<-3.1655, 12.7852, 10.2681> <-3.0953, 12.8331, 10.4465> <-2.9291, 12.8597, 10.6846> <-2.9315, 12.9450, 10.8629>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2941, 13.4142, 10.6950> <-3.2762, 13.3851, 10.9105> <-3.2083, 13.3639, 11.1946> <-3.1805, 13.3307, 11.4085>
		<-3.1460, 13.2789, 10.6084> <-3.1280, 13.2497, 10.8239> <-3.0427, 13.2562, 11.1127> <-3.0149, 13.2229, 11.3265>
		<-3.0606, 13.0320, 10.3541> <-2.9880, 13.0276, 10.5569> <-2.9525, 13.0588, 10.8423> <-2.9340, 13.0373, 11.0559>
		<-3.1324, 12.9320, 10.1736> <-3.0599, 12.9276, 10.3764> <-2.9499, 12.9665, 10.6494> <-2.9315, 12.9450, 10.8629>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2941, 13.4142, 10.6950> <-3.4895, 13.5927, 10.8091> <-3.8890, 13.7237, 10.7436> <-4.1440, 13.8564, 10.7645>
		<-3.2762, 13.3851, 10.9105> <-3.4715, 13.5636, 11.0245> <-3.8909, 13.7148, 10.8027> <-4.1459, 13.8474, 10.8236>
		<-3.2083, 13.3639, 11.1946> <-3.4575, 13.5261, 11.3180> <-3.8584, 13.8526, 11.2604> <-4.1708, 13.7750, 11.2604>
		<-3.1805, 13.3307, 11.4085> <-3.4297, 13.4929, 11.5318> <-3.8542, 13.8263, 11.4743> <-4.1666, 13.7487, 11.4743>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1655, 12.7852, 10.2681> <-3.0953, 12.8331, 10.4465> <-2.9291, 12.8597, 10.6846> <-2.9315, 12.9450, 10.8629>
		<-3.0199, 12.6768, 10.5405> <-2.9497, 12.7247, 10.7189> <-2.9085, 12.8355, 10.9234> <-2.9108, 12.9208, 11.1017>
		<-2.9058, 12.4648, 10.9223> <-2.9410, 12.6003, 11.0499> <-2.9576, 12.7237, 11.2746> <-2.9886, 12.8477, 11.4145>
		<-2.8878, 12.3314, 11.2207> <-2.9230, 12.4670, 11.3483> <-2.9742, 12.6593, 11.5062> <-3.0052, 12.7833, 11.6461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1805, 13.3307, 11.4085> <-3.4297, 13.4929, 11.5318> <-3.8542, 13.8263, 11.4743> <-4.1666, 13.7487, 11.4743>
		<-3.1503, 13.2946, 11.6412> <-3.3995, 13.4568, 11.7645> <-3.8493, 13.7961, 11.7205> <-4.1618, 13.7185, 11.7205>
		<-3.0797, 13.2499, 11.9550> <-3.3204, 13.4421, 12.0960> <-3.8176, 13.8254, 12.0638> <-4.1477, 13.7496, 12.0638>
		<-3.1007, 13.1833, 12.1819> <-3.3414, 13.3754, 12.3229> <-3.7838, 13.7441, 12.2958> <-4.1140, 13.6684, 12.2958>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1805, 13.3307, 11.4085> <-3.1503, 13.2946, 11.6412> <-3.0797, 13.2499, 11.9550> <-3.1007, 13.1833, 12.1819>
		<-3.0149, 13.2229, 11.3265> <-2.9846, 13.1868, 11.5592> <-2.9358, 13.1350, 11.8706> <-2.9568, 13.0683, 12.0975>
		<-2.9340, 13.0373, 11.0559> <-2.9134, 13.0131, 11.2947> <-3.0217, 12.9803, 11.5641> <-3.0383, 12.9159, 11.7957>
		<-2.9315, 12.9450, 10.8629> <-2.9108, 12.9208, 11.1017> <-2.9886, 12.8477, 11.4145> <-3.0052, 12.7833, 11.6461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8878, 12.3314, 11.2207> <-2.9230, 12.4670, 11.3483> <-2.9742, 12.6593, 11.5062> <-3.0052, 12.7833, 11.6461>
		<-2.8764, 12.2474, 11.4087> <-2.9117, 12.3830, 11.5363> <-2.9886, 12.6034, 11.7071> <-3.0196, 12.7274, 11.8470>
		<-2.9462, 12.1746, 11.6983> <-2.9352, 12.3128, 11.8377> <-2.9035, 12.5300, 12.0328> <-2.9397, 12.6720, 12.1638>
		<-3.0710, 12.0847, 11.8357> <-3.0600, 12.2229, 11.9751> <-2.9983, 12.4033, 12.1694> <-3.0345, 12.5453, 12.3004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1007, 13.1833, 12.1819> <-3.3414, 13.3754, 12.3229> <-3.7838, 13.7441, 12.2958> <-4.1140, 13.6684, 12.2958>
		<-3.1154, 13.1369, 12.3397> <-3.3561, 13.3290, 12.4807> <-3.7558, 13.6767, 12.4883> <-4.0860, 13.6009, 12.4883>
		<-3.1919, 13.0406, 12.5437> <-3.3564, 13.1685, 12.6381> <-3.7923, 13.4788, 12.7449> <-4.0177, 13.4418, 12.7317>
		<-3.2954, 12.9662, 12.6486> <-3.4599, 13.0941, 12.7431> <-3.7430, 13.3086, 12.8498> <-3.9684, 13.2716, 12.8366>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1007, 13.1833, 12.1819> <-3.1154, 13.1369, 12.3397> <-3.1919, 13.0406, 12.5437> <-3.2954, 12.9662, 12.6486>
		<-2.9568, 13.0683, 12.0975> <-2.9714, 13.0219, 12.2553> <-3.0613, 12.9390, 12.4687> <-3.1648, 12.8646, 12.5737>
		<-3.0383, 12.9159, 11.7957> <-3.0527, 12.8600, 11.9966> <-2.9731, 12.8033, 12.2848> <-3.0679, 12.6765, 12.4214>
		<-3.0052, 12.7833, 11.6461> <-3.0196, 12.7274, 11.8470> <-2.9397, 12.6720, 12.1638> <-3.0345, 12.5453, 12.3004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0710, 12.0847, 11.8357> <-3.0600, 12.2229, 11.9751> <-2.9983, 12.4033, 12.1694> <-3.0345, 12.5453, 12.3004>
		<-3.1854, 12.0024, 11.9617> <-3.1745, 12.1405, 12.1011> <-3.1108, 12.2529, 12.3314> <-3.1469, 12.3949, 12.4624>
		<-3.4260, 11.8560, 12.0114> <-3.4242, 11.9075, 12.1592> <-3.3341, 11.9263, 12.4001> <-3.3607, 12.0324, 12.5121>
		<-3.6098, 11.8116, 12.0157> <-3.6080, 11.8630, 12.1635> <-3.5771, 11.8769, 12.3965> <-3.6037, 11.9830, 12.5085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2954, 12.9662, 12.6486> <-3.4599, 13.0941, 12.7431> <-3.7430, 13.3086, 12.8498> <-3.9684, 13.2716, 12.8366>
		<-3.2954, 12.9662, 12.6486> <-3.5848, 13.0043, 12.8698> <-3.6979, 13.1524, 12.9461> <-3.9233, 13.1154, 12.9328>
		<-3.2954, 12.9662, 12.6486> <-3.5848, 13.0043, 12.8698> <-3.6771, 12.8726, 12.9714> <-3.8734, 12.8403, 12.9599>
		<-3.2954, 12.9662, 12.6486> <-3.4203, 12.8764, 12.7753> <-3.6271, 12.6960, 12.9265> <-3.8234, 12.6637, 12.9149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2954, 12.9662, 12.6486> <-3.4203, 12.8764, 12.7753> <-3.6271, 12.6960, 12.9265> <-3.8234, 12.6637, 12.9149>
		<-3.1648, 12.8646, 12.5737> <-3.2897, 12.7748, 12.7003> <-3.5618, 12.4653, 12.8677> <-3.7581, 12.4331, 12.8562>
		<-3.0679, 12.6765, 12.4214> <-3.1803, 12.5261, 12.5834> <-3.4026, 12.1997, 12.6886> <-3.6456, 12.1503, 12.6850>
		<-3.0345, 12.5453, 12.3004> <-3.1469, 12.3949, 12.4624> <-3.3607, 12.0324, 12.5121> <-3.6037, 11.9830, 12.5085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6098, 11.8116, 12.0157> <-3.6080, 11.8630, 12.1635> <-3.5771, 11.8769, 12.3965> <-3.6037, 11.9830, 12.5085>
		<-3.8008, 11.7653, 12.0201> <-3.7990, 11.8168, 12.1680> <-3.8345, 11.8246, 12.3927> <-3.8611, 11.9307, 12.5047>
		<-4.1177, 11.7652, 12.0070> <-4.1634, 11.9055, 12.1321> <-4.1736, 12.0378, 12.3307> <-4.2087, 12.1910, 12.4435>
		<-4.2471, 11.8002, 11.8631> <-4.2928, 11.9405, 11.9882> <-4.3644, 12.1147, 12.1673> <-4.3995, 12.2679, 12.2801>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6393, 14.4521, 7.4459> <-6.6625, 14.4036, 7.4288> <-6.6290, 14.3310, 7.3593> <-6.5819, 14.3109, 7.3355>
		<-6.5257, 13.9366, 7.7882> <-6.5490, 13.8880, 7.7711> <-6.5006, 13.8552, 7.7506> <-6.4535, 13.8351, 7.7268>
		<-6.3865, 13.1510, 8.2938> <-6.3878, 13.0948, 8.2885> <-6.3510, 12.9845, 8.2246> <-6.3186, 13.0206, 8.1956>
		<-6.1671, 12.5648, 8.2295> <-6.1685, 12.5085, 8.2241> <-6.0516, 12.4319, 8.1932> <-6.0192, 12.4680, 8.1642>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6393, 14.4521, 7.4459> <-6.7048, 14.7496, 7.2484> <-6.7168, 14.9918, 6.7951> <-6.7443, 15.1856, 6.4894>
		<-6.6625, 14.4036, 7.4288> <-6.7280, 14.7010, 7.2313> <-6.7712, 14.8624, 6.7447> <-6.7987, 15.0562, 6.4391>
		<-6.6290, 14.3310, 7.3593> <-6.6981, 14.5871, 7.1487> <-6.6670, 14.7313, 6.6624> <-6.7018, 14.8614, 6.3517>
		<-6.5819, 14.3109, 7.3355> <-6.6510, 14.5669, 7.1249> <-6.5980, 14.6124, 6.6044> <-6.6328, 14.7426, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6393, 14.4521, 7.4459> <-6.5257, 13.9366, 7.7882> <-6.3865, 13.1510, 8.2938> <-6.1671, 12.5648, 8.2295>
		<-6.4810, 14.7830, 7.5621> <-6.3675, 14.2674, 7.9044> <-6.3684, 13.9055, 8.3655> <-6.1491, 13.3193, 8.3012>
		<-6.2408, 15.2294, 7.6771> <-6.2167, 15.1253, 7.8886> <-6.1739, 14.4783, 8.1696> <-6.1441, 14.3434, 8.3622>
		<-6.0034, 15.5205, 7.7605> <-5.9793, 15.4163, 7.9720> <-5.9866, 15.2111, 8.2194> <-5.9569, 15.0763, 8.4120>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6393, 14.4521, 7.4459> <-6.4810, 14.7830, 7.5621> <-6.2408, 15.2294, 7.6771> <-6.0034, 15.5205, 7.7605>
		<-6.7048, 14.7496, 7.2484> <-6.5465, 15.0804, 7.3647> <-6.2742, 15.3738, 7.3841> <-6.0368, 15.6648, 7.4675>
		<-6.7168, 14.9918, 6.7951> <-6.6114, 15.2427, 6.8927> <-6.2939, 15.5936, 6.9894> <-6.1093, 15.8059, 7.0562>
		<-6.7443, 15.1856, 6.4894> <-6.6388, 15.4365, 6.5871> <-6.3316, 15.6858, 6.6765> <-6.1471, 15.8981, 6.7433>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8858, 12.8032, 8.0064> <-5.0359, 12.8975, 7.8172> <-5.4148, 13.0475, 7.7976> <-5.5727, 13.2269, 7.6973>
		<-4.8062, 12.8202, 8.1020> <-4.9562, 12.9145, 7.9127> <-5.2385, 13.1507, 7.7309> <-5.3964, 13.3301, 7.6306>
		<-4.7498, 12.7924, 8.2983> <-4.8131, 12.8724, 8.1015> <-4.9915, 13.0437, 7.9430> <-5.0711, 13.1598, 7.7718>
		<-4.6314, 12.8025, 8.3388> <-4.6947, 12.8825, 8.1420> <-4.7820, 13.0297, 7.8975> <-4.8616, 13.1459, 7.7262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8858, 12.8032, 8.0064> <-4.9405, 12.7915, 7.9409> <-5.0525, 12.7381, 7.8882> <-5.0724, 12.7084, 7.8099>
		<-5.0359, 12.8975, 7.8172> <-5.0905, 12.8858, 7.7516> <-5.3525, 12.7376, 7.8033> <-5.3724, 12.7080, 7.7250>
		<-5.4148, 13.0475, 7.7976> <-5.6600, 12.9038, 7.8904> <-5.5638, 12.7311, 7.9044> <-5.7352, 12.5401, 8.0579>
		<-5.5727, 13.2269, 7.6973> <-5.8180, 13.0833, 7.7901> <-5.8478, 12.6589, 8.0107> <-6.0192, 12.4680, 8.1642>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8858, 12.8032, 8.0064> <-4.7269, 12.7033, 8.2069> <-4.6663, 12.6939, 8.6051> <-4.6406, 12.6411, 8.8733>
		<-4.9405, 12.7915, 7.9409> <-4.7816, 12.6917, 8.1414> <-4.6936, 12.6488, 8.5135> <-4.6679, 12.5960, 8.7818>
		<-5.0525, 12.7381, 7.8882> <-4.7820, 12.7384, 7.9648> <-4.6079, 12.5207, 8.3997> <-4.5515, 12.4804, 8.6722>
		<-5.0724, 12.7084, 7.8099> <-4.8020, 12.7088, 7.8864> <-4.6375, 12.5104, 8.2988> <-4.5811, 12.4701, 8.5712>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8858, 12.8032, 8.0064> <-4.8062, 12.8202, 8.1020> <-4.7498, 12.7924, 8.2983> <-4.6314, 12.8025, 8.3388>
		<-4.7269, 12.7033, 8.2069> <-4.6473, 12.7203, 8.3025> <-4.6949, 12.7230, 8.4690> <-4.5764, 12.7331, 8.5095>
		<-4.6663, 12.6939, 8.6051> <-4.6521, 12.7173, 8.6526> <-4.5444, 12.6843, 8.7423> <-4.4915, 12.6928, 8.7541>
		<-4.6406, 12.6411, 8.8733> <-4.6264, 12.6645, 8.9209> <-4.5239, 12.6435, 8.9290> <-4.4709, 12.6521, 8.9409>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6406, 12.6411, 8.8733> <-4.6258, 12.6107, 9.0281> <-4.7173, 12.5285, 9.2237> <-4.7544, 12.5337, 9.3776>
		<-4.6679, 12.5960, 8.7818> <-4.6531, 12.5656, 8.9365> <-4.7614, 12.5201, 9.1806> <-4.7985, 12.5253, 9.3345>
		<-4.5515, 12.4804, 8.6722> <-4.5130, 12.4529, 8.8582> <-4.6769, 12.5000, 9.0624> <-4.7661, 12.5184, 9.2313>
		<-4.5811, 12.4701, 8.5712> <-4.5425, 12.4426, 8.7573> <-4.7005, 12.4880, 9.0060> <-4.7897, 12.5065, 9.1750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6406, 12.6411, 8.8733> <-4.6264, 12.6645, 8.9209> <-4.5239, 12.6435, 8.9290> <-4.4709, 12.6521, 8.9409>
		<-4.6258, 12.6107, 9.0281> <-4.6116, 12.6341, 9.0756> <-4.5072, 12.6105, 9.0800> <-4.4543, 12.6191, 9.0918>
		<-4.7173, 12.5285, 9.2237> <-4.6627, 12.5389, 9.2771> <-4.5505, 12.5559, 9.2668> <-4.4801, 12.5648, 9.2966>
		<-4.7544, 12.5337, 9.3776> <-4.6998, 12.5441, 9.4310> <-4.5797, 12.5512, 9.4194> <-4.5092, 12.5601, 9.4492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7544, 12.5337, 9.3776> <-4.8050, 12.5409, 9.5876> <-4.8435, 12.5919, 9.8832> <-4.9268, 12.6815, 10.0614>
		<-4.7985, 12.5253, 9.3345> <-4.8491, 12.5324, 9.5445> <-4.9554, 12.5904, 9.8419> <-5.0388, 12.6800, 10.0201>
		<-4.7661, 12.5184, 9.2313> <-4.8817, 12.5423, 9.4502> <-5.0750, 12.5953, 9.7703> <-5.2261, 12.6441, 9.9617>
		<-4.7897, 12.5065, 9.1750> <-4.9052, 12.5304, 9.3938> <-5.1059, 12.5610, 9.6603> <-5.2570, 12.6098, 9.8517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7544, 12.5337, 9.3776> <-4.6998, 12.5441, 9.4310> <-4.5797, 12.5512, 9.4194> <-4.5092, 12.5601, 9.4492>
		<-4.8050, 12.5409, 9.5876> <-4.7504, 12.5513, 9.6410> <-4.6157, 12.5454, 9.6081> <-4.5452, 12.5543, 9.6379>
		<-4.8435, 12.5919, 9.8832> <-4.7731, 12.5929, 9.9091> <-4.6982, 12.5492, 9.8834> <-4.6244, 12.5441, 9.8957>
		<-4.9268, 12.6815, 10.0614> <-4.8564, 12.6825, 10.0873> <-4.7589, 12.6227, 10.0503> <-4.6850, 12.6176, 10.0626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2000, 13.0127, 10.3300> <-5.3093, 12.9604, 10.2535> <-5.4953, 12.8055, 10.2308> <-5.5239, 12.7435, 10.1049>
		<-5.1237, 12.8943, 10.2732> <-5.2329, 12.8420, 10.1967> <-5.4142, 12.7248, 10.2047> <-5.4427, 12.6628, 10.0787>
		<-4.9854, 12.7445, 10.1866> <-5.0974, 12.7430, 10.1453> <-5.2974, 12.6671, 10.0520> <-5.3284, 12.6328, 9.9421>
		<-4.9268, 12.6815, 10.0614> <-5.0388, 12.6800, 10.0201> <-5.2261, 12.6441, 9.9617> <-5.2570, 12.6098, 9.8517>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2000, 13.0127, 10.3300> <-5.1237, 12.8943, 10.2732> <-4.9854, 12.7445, 10.1866> <-4.9268, 12.6815, 10.0614>
		<-5.1172, 13.0524, 10.3880> <-5.0408, 12.9339, 10.3312> <-4.9150, 12.7455, 10.2125> <-4.8564, 12.6825, 10.0873>
		<-4.9973, 13.0303, 10.4818> <-4.9433, 12.8568, 10.3938> <-4.8226, 12.6999, 10.2256> <-4.7589, 12.6227, 10.0503>
		<-4.9050, 13.0398, 10.5384> <-4.8510, 12.8662, 10.4504> <-4.7487, 12.6948, 10.2379> <-4.6850, 12.6176, 10.0626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2000, 13.0127, 10.3300> <-5.2651, 13.1137, 10.3784> <-5.3442, 13.2901, 10.4663> <-5.3869, 13.3949, 10.4034>
		<-5.3093, 12.9604, 10.2535> <-5.3744, 13.0614, 10.3019> <-5.4792, 13.2089, 10.3734> <-5.5219, 13.3137, 10.3105>
		<-5.4953, 12.8055, 10.2308> <-5.5920, 12.9016, 10.2620> <-5.6902, 13.1463, 10.2660> <-5.7440, 13.2288, 10.1668>
		<-5.5239, 12.7435, 10.1049> <-5.6205, 12.8396, 10.1361> <-5.7222, 13.0434, 10.1183> <-5.7760, 13.1259, 10.0191>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2000, 13.0127, 10.3300> <-5.1172, 13.0524, 10.3880> <-4.9973, 13.0303, 10.4818> <-4.9050, 13.0398, 10.5384>
		<-5.2651, 13.1137, 10.3784> <-5.1823, 13.1533, 10.4364> <-5.0427, 13.1762, 10.5558> <-4.9503, 13.1856, 10.6124>
		<-5.3442, 13.2901, 10.4663> <-5.2395, 13.3531, 10.5383> <-5.0856, 13.4089, 10.6095> <-4.9573, 13.4565, 10.6468>
		<-5.3869, 13.3949, 10.4034> <-5.2822, 13.4579, 10.4755> <-5.1184, 13.5511, 10.5229> <-4.9900, 13.5988, 10.5601>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3869, 13.3949, 10.4034> <-5.5096, 13.6963, 10.2227> <-5.6300, 14.0240, 9.8522> <-5.7097, 14.2645, 9.5796>
		<-5.5219, 13.3137, 10.3105> <-5.6446, 13.6151, 10.1298> <-5.8044, 13.8558, 9.7281> <-5.8841, 14.0963, 9.4555>
		<-5.7440, 13.2288, 10.1668> <-5.8610, 13.4081, 9.9513> <-5.9311, 13.7739, 9.5983> <-6.0180, 13.7585, 9.3077>
		<-5.7760, 13.1259, 10.0191> <-5.8930, 13.3052, 9.8036> <-5.9611, 13.5622, 9.4299> <-6.0480, 13.5468, 9.1392>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3869, 13.3949, 10.4034> <-5.2822, 13.4579, 10.4755> <-5.1184, 13.5511, 10.5229> <-4.9900, 13.5988, 10.5601>
		<-5.5096, 13.6963, 10.2227> <-5.4049, 13.7593, 10.2948> <-5.1844, 13.8378, 10.3482> <-5.0561, 13.8854, 10.3855>
		<-5.6300, 14.0240, 9.8522> <-5.5275, 14.1228, 9.9251> <-5.2997, 14.1106, 9.9406> <-5.1501, 14.1359, 9.9913>
		<-5.7097, 14.2645, 9.5796> <-5.6072, 14.3633, 9.6525> <-5.3580, 14.3313, 9.6857> <-5.2083, 14.3565, 9.7363>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7097, 14.2645, 9.5796> <-5.7635, 14.4269, 9.3954> <-5.7855, 14.5869, 9.0953> <-5.8285, 14.7282, 8.8920>
		<-5.8841, 14.0963, 9.4555> <-5.9379, 14.2587, 9.2714> <-6.0114, 14.1064, 8.9446> <-6.0545, 14.2478, 8.7413>
		<-6.0180, 13.7585, 9.3077> <-6.1026, 13.7435, 9.0248> <-6.2226, 13.7269, 8.8091> <-6.2488, 13.5109, 8.6089>
		<-6.0480, 13.5468, 9.1392> <-6.1326, 13.5318, 8.8563> <-6.2552, 13.2523, 8.5293> <-6.2814, 13.0362, 8.3291>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7097, 14.2645, 9.5796> <-5.6072, 14.3633, 9.6525> <-5.3580, 14.3313, 9.6857> <-5.2083, 14.3565, 9.7363>
		<-5.7635, 14.4269, 9.3954> <-5.6609, 14.5257, 9.4683> <-5.4106, 14.5305, 9.4555> <-5.2609, 14.5557, 9.5062>
		<-5.7855, 14.5869, 9.0953> <-5.7187, 14.7288, 9.1398> <-5.4707, 14.7509, 9.1611> <-5.3179, 14.8038, 9.1817>
		<-5.8285, 14.7282, 8.8920> <-5.7618, 14.8701, 8.9365> <-5.5120, 14.9441, 8.9237> <-5.3592, 14.9971, 8.9443>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.8285, 14.7282, 8.8920> <-5.8597, 14.8306, 8.7448> <-5.9340, 14.9727, 8.5599> <-5.9569, 15.0763, 8.4120>
		<-6.0545, 14.2478, 8.7413> <-6.0856, 14.3501, 8.5941> <-6.1213, 14.2398, 8.5101> <-6.1441, 14.3434, 8.3622>
		<-6.2488, 13.5109, 8.6089> <-6.2620, 13.4023, 8.5084> <-6.1834, 13.4607, 8.3311> <-6.1491, 13.3193, 8.3012>
		<-6.2814, 13.0362, 8.3291> <-6.2946, 12.9277, 8.2286> <-6.2014, 12.7062, 8.2594> <-6.1671, 12.5648, 8.2295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.8285, 14.7282, 8.8920> <-5.7618, 14.8701, 8.9365> <-5.5120, 14.9441, 8.9237> <-5.3592, 14.9971, 8.9443>
		<-5.8597, 14.8306, 8.7448> <-5.7929, 14.9725, 8.7893> <-5.5392, 15.0714, 8.7673> <-5.3864, 15.1243, 8.7879>
		<-5.9340, 14.9727, 8.5599> <-5.8876, 15.1544, 8.5723> <-5.5801, 15.2194, 8.5968> <-5.4126, 15.3039, 8.5857>
		<-5.9569, 15.0763, 8.4120> <-5.9105, 15.2580, 8.4244> <-5.6039, 15.3402, 8.4349> <-5.4364, 15.4248, 8.4238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.9569, 15.0763, 8.4120> <-5.9105, 15.2580, 8.4244> <-5.6039, 15.3402, 8.4349> <-5.4364, 15.4248, 8.4238>
		<-5.9866, 15.2111, 8.2194> <-5.9402, 15.3928, 8.2318> <-5.6289, 15.4671, 8.2648> <-5.4615, 15.5517, 8.2537>
		<-5.9793, 15.4163, 7.9720> <-5.8731, 15.5465, 8.0093> <-5.6522, 15.6377, 8.0035> <-5.4952, 15.7069, 8.0166>
		<-6.0034, 15.5205, 7.7605> <-5.8972, 15.6507, 7.7979> <-5.6788, 15.7529, 7.8254> <-5.5219, 15.8221, 7.8386>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.0034, 15.5205, 7.7605> <-5.8972, 15.6507, 7.7979> <-5.6788, 15.7529, 7.8254> <-5.5219, 15.8221, 7.8386>
		<-6.0368, 15.6648, 7.4675> <-5.9306, 15.7950, 7.5048> <-5.7216, 15.9376, 7.5400> <-5.5646, 16.0068, 7.5532>
		<-6.1093, 15.8059, 7.0562> <-5.9705, 15.9656, 7.1065> <-5.8121, 16.1503, 7.1557> <-5.6290, 16.2650, 7.1800>
		<-6.1471, 15.8981, 6.7433> <-6.0083, 16.0578, 6.7936> <-5.8507, 16.3097, 6.8549> <-5.6676, 16.4244, 6.8792>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5245, 13.8333, 6.6010> <-4.8650, 14.0054, 6.3239> <-5.4697, 13.9931, 6.0294> <-5.7750, 14.1132, 5.6906>
		<-4.7750, 13.8428, 6.6523> <-5.1156, 14.0150, 6.3752> <-5.5018, 14.0153, 6.0815> <-5.8071, 14.1354, 5.7427>
		<-5.1259, 13.8060, 6.6859> <-5.2677, 13.9508, 6.4271> <-5.6876, 14.0573, 6.0998> <-5.8345, 14.1646, 5.8260>
		<-5.3596, 13.8650, 6.7719> <-5.5014, 14.0098, 6.5131> <-5.7351, 14.0799, 6.1381> <-5.8820, 14.1872, 5.8643>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5245, 13.8333, 6.6010> <-4.7750, 13.8428, 6.6523> <-5.1259, 13.8060, 6.6859> <-5.3596, 13.8650, 6.7719>
		<-4.2528, 13.6960, 6.8220> <-4.5034, 13.7055, 6.8733> <-4.9583, 13.6350, 6.9917> <-5.1920, 13.6940, 7.0777>
		<-3.9307, 13.2656, 6.9995> <-4.2533, 13.2770, 7.1246> <-4.6634, 13.3268, 7.3528> <-5.0010, 13.3493, 7.4262>
		<-3.7863, 13.1079, 7.3089> <-4.1089, 13.1193, 7.4341> <-4.5240, 13.1234, 7.6528> <-4.8616, 13.1459, 7.7262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.7863, 13.1079, 7.3089> <-4.1089, 13.1193, 7.4341> <-4.5240, 13.1234, 7.6528> <-4.8616, 13.1459, 7.7262>
		<-3.6555, 12.9651, 7.5890> <-3.9781, 12.9765, 7.7142> <-4.4444, 13.0072, 7.8241> <-4.7820, 13.0297, 7.8975>
		<-3.6965, 12.9643, 8.0854> <-3.9833, 12.9333, 8.0610> <-4.4216, 12.9057, 8.2353> <-4.6947, 12.8825, 8.1420>
		<-3.6753, 12.9060, 8.4202> <-3.9621, 12.8749, 8.3958> <-4.3583, 12.8257, 8.4321> <-4.6314, 12.8025, 8.3388>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6753, 12.9060, 8.4202> <-3.9621, 12.8749, 8.3958> <-4.3583, 12.8257, 8.4321> <-4.6314, 12.8025, 8.3388>
		<-3.6627, 12.8711, 8.6201> <-3.9495, 12.8401, 8.5957> <-4.3034, 12.7563, 8.6029> <-4.5764, 12.7331, 8.5095>
		<-3.6820, 12.8294, 8.8885> <-3.9211, 12.7857, 8.8440> <-4.2532, 12.7314, 8.8073> <-4.4915, 12.6928, 8.7541>
		<-3.6737, 12.7976, 9.0892> <-3.9129, 12.7539, 9.0447> <-4.2327, 12.6906, 8.9940> <-4.4709, 12.6521, 8.9409>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6737, 12.7976, 9.0892> <-3.9129, 12.7539, 9.0447> <-4.2327, 12.6906, 8.9940> <-4.4709, 12.6521, 8.9409>
		<-3.6642, 12.7609, 9.3205> <-3.9033, 12.7172, 9.2760> <-4.2161, 12.6577, 9.1450> <-4.4543, 12.6191, 9.0918>
		<-3.6333, 12.7137, 9.6282> <-3.7331, 12.8330, 9.3752> <-4.2084, 12.5992, 9.4116> <-4.4801, 12.5648, 9.2966>
		<-3.6161, 12.6778, 9.8592> <-3.7158, 12.7970, 9.6063> <-4.2376, 12.5945, 9.5641> <-4.5092, 12.5601, 9.4492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3570, 14.4931, 10.0378> <-4.4107, 14.7143, 9.7594> <-4.4391, 14.9829, 9.3614> <-4.4699, 15.1987, 9.0754>
		<-4.6219, 14.4262, 10.0169> <-4.6756, 14.6474, 9.7385> <-4.7087, 14.9262, 9.3394> <-4.7395, 15.1421, 9.0534>
		<-4.9521, 14.3999, 9.8232> <-5.0047, 14.5991, 9.5930> <-5.0589, 14.8935, 9.2167> <-5.1001, 15.0868, 8.9793>
		<-5.2083, 14.3565, 9.7363> <-5.2609, 14.5557, 9.5062> <-5.3179, 14.8038, 9.1817> <-5.3592, 14.9971, 8.9443>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3570, 14.4931, 10.0378> <-4.6219, 14.4262, 10.0169> <-4.9521, 14.3999, 9.8232> <-5.2083, 14.3565, 9.7363>
		<-4.3127, 14.3105, 10.2676> <-4.5776, 14.2436, 10.2466> <-4.8938, 14.1793, 10.0781> <-5.1501, 14.1359, 9.9913>
		<-4.2079, 14.0474, 10.5465> <-4.4719, 13.9819, 10.5339> <-4.8098, 13.9769, 10.4571> <-5.0561, 13.8854, 10.3855>
		<-4.1440, 13.8564, 10.7645> <-4.4080, 13.7908, 10.7519> <-4.7437, 13.6902, 10.6317> <-4.9900, 13.5988, 10.5601>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4699, 15.1987, 9.0754> <-4.4947, 15.3723, 8.8455> <-4.4983, 15.6203, 8.5477> <-4.5424, 15.7908, 8.3183>
		<-4.7395, 15.1421, 9.0534> <-4.7643, 15.3156, 8.8235> <-4.7783, 15.5410, 8.5661> <-4.8223, 15.7115, 8.3367>
		<-5.1001, 15.0868, 8.9793> <-5.1273, 15.2140, 8.8229> <-5.1528, 15.4352, 8.5685> <-5.1766, 15.5560, 8.4066>
		<-5.3592, 14.9971, 8.9443> <-5.3864, 15.1243, 8.7879> <-5.4126, 15.3039, 8.5857> <-5.4364, 15.4248, 8.4238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7013, 16.0949, 7.8699> <-4.9536, 16.0338, 7.8699> <-5.2851, 15.9266, 7.8585> <-5.5219, 15.8221, 7.8386>
		<-4.6671, 16.0057, 8.0098> <-4.9194, 15.9447, 8.0098> <-5.2584, 15.8114, 8.0365> <-5.4952, 15.7069, 8.0166>
		<-4.5681, 15.8907, 8.1840> <-4.8481, 15.8114, 8.2024> <-5.2017, 15.6830, 8.2365> <-5.4615, 15.5517, 8.2537>
		<-4.5424, 15.7908, 8.3183> <-4.8223, 15.7115, 8.3367> <-5.1766, 15.5560, 8.4066> <-5.4364, 15.4248, 8.4238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7013, 16.0949, 7.8699> <-4.7705, 16.2753, 7.5867> <-4.8412, 16.5297, 7.2115> <-4.8862, 16.6876, 6.9105>
		<-4.9536, 16.0338, 7.8699> <-5.0228, 16.2142, 7.5867> <-5.0818, 16.4715, 7.2115> <-5.1268, 16.6294, 6.9105>
		<-5.2851, 15.9266, 7.8585> <-5.3278, 16.1113, 7.5731> <-5.4205, 16.3955, 7.2077> <-5.4591, 16.5550, 6.9069>
		<-5.5219, 15.8221, 7.8386> <-5.5646, 16.0068, 7.5532> <-5.6290, 16.2650, 7.1800> <-5.6676, 16.4244, 6.8792>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8616, 13.1459, 7.7262> <-5.0711, 13.1598, 7.7718> <-5.3964, 13.3301, 7.6306> <-5.5727, 13.2269, 7.6973>
		<-5.0010, 13.3493, 7.4262> <-5.2106, 13.3633, 7.4718> <-5.6292, 13.5946, 7.4829> <-5.8055, 13.4914, 7.5496>
		<-5.1920, 13.6940, 7.0777> <-5.4605, 13.7618, 7.1764> <-5.7762, 13.9478, 7.3812> <-6.0296, 14.0403, 7.4981>
		<-5.3596, 13.8650, 6.7719> <-5.6281, 13.9328, 6.8706> <-5.9013, 14.1524, 7.0839> <-6.1548, 14.2448, 7.2007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5092, 12.5601, 9.4492> <-4.2376, 12.5945, 9.5641> <-3.7158, 12.7970, 9.6063> <-3.6161, 12.6778, 9.8592>
		<-4.5452, 12.5543, 9.6379> <-4.2736, 12.5887, 9.7528> <-3.9068, 12.7841, 9.7006> <-3.8070, 12.6649, 9.9536>
		<-4.6244, 12.5441, 9.8957> <-4.4925, 12.5349, 9.9176> <-4.1134, 12.5839, 9.9094> <-4.0969, 12.5724, 10.0418>
		<-4.6850, 12.6176, 10.0626> <-4.5531, 12.6084, 10.0845> <-4.2692, 12.6463, 10.0411> <-4.2527, 12.6347, 10.1736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9050, 13.0398, 10.5384> <-4.8510, 12.8662, 10.4504> <-4.7487, 12.6948, 10.2379> <-4.6850, 12.6176, 10.0626>
		<-4.8182, 13.0486, 10.5916> <-4.7643, 12.8751, 10.5036> <-4.6169, 12.6857, 10.2599> <-4.5531, 12.6084, 10.0845>
		<-4.6080, 13.0884, 10.5940> <-4.6263, 12.8820, 10.4941> <-4.4372, 12.7135, 10.1832> <-4.2692, 12.6463, 10.0411>
		<-4.6045, 13.0734, 10.6950> <-4.6228, 12.8670, 10.5951> <-4.4207, 12.7020, 10.3157> <-4.2527, 12.6347, 10.1736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9050, 13.0398, 10.5384> <-4.8182, 13.0486, 10.5916> <-4.6080, 13.0884, 10.5940> <-4.6045, 13.0734, 10.6950>
		<-4.9503, 13.1856, 10.6124> <-4.8636, 13.1945, 10.6656> <-4.5861, 13.3337, 10.7126> <-4.5826, 13.3186, 10.8136>
		<-4.9573, 13.4565, 10.6468> <-4.7110, 13.5479, 10.7184> <-4.5461, 13.5559, 10.7311> <-4.2821, 13.6215, 10.7436>
		<-4.9900, 13.5988, 10.5601> <-4.7437, 13.6902, 10.6317> <-4.4080, 13.7908, 10.7519> <-4.1440, 13.8564, 10.7645>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9745, 17.0524, 6.0452> <-5.1462, 17.0724, 5.8681> <-5.5609, 16.9384, 6.0460> <-5.7558, 16.7892, 6.0139>
		<-4.7781, 17.0295, 6.2477> <-4.9499, 17.0495, 6.0706> <-5.5345, 16.8289, 6.3056> <-5.7293, 16.6797, 6.2735>
		<-4.9234, 16.8180, 6.6621> <-5.1640, 16.7598, 6.6621> <-5.4909, 16.6866, 6.6584> <-5.6994, 16.5561, 6.6308>
		<-4.8862, 16.6876, 6.9105> <-5.1268, 16.6294, 6.9105> <-5.4591, 16.5550, 6.9069> <-5.6676, 16.4244, 6.8792>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.7558, 16.7892, 6.0139> <-5.9609, 16.6322, 5.9801> <-6.0687, 16.2791, 5.8945> <-6.2353, 16.0871, 5.8375>
		<-5.7293, 16.6797, 6.2735> <-5.9344, 16.5227, 6.2397> <-6.0422, 16.2224, 6.1662> <-6.2088, 16.0304, 6.1093>
		<-5.6994, 16.5561, 6.6308> <-5.8826, 16.4414, 6.6065> <-6.0403, 16.1361, 6.5279> <-6.1791, 15.9764, 6.4776>
		<-5.6676, 16.4244, 6.8792> <-5.8507, 16.3097, 6.8549> <-6.0083, 16.0578, 6.7936> <-6.1471, 15.8981, 6.7433>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2353, 16.0871, 5.8375> <-6.3842, 15.9156, 5.7866> <-6.6918, 15.7790, 5.7303> <-6.7999, 15.5863, 5.6570>
		<-6.2088, 16.0304, 6.1093> <-6.3577, 15.8589, 6.0584> <-6.6751, 15.6588, 5.9801> <-6.7832, 15.4661, 5.9068>
		<-6.1791, 15.9764, 6.4776> <-6.3636, 15.7641, 6.4108> <-6.6598, 15.5847, 6.3533> <-6.7653, 15.3339, 6.2556>
		<-6.1471, 15.8981, 6.7433> <-6.3316, 15.6858, 6.6765> <-6.6388, 15.4365, 6.5871> <-6.7443, 15.1856, 6.4894>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7999, 15.5863, 5.6570> <-6.8736, 15.4552, 5.6072> <-6.8473, 15.2309, 5.5227> <-6.7918, 15.0961, 5.4605>
		<-6.7832, 15.4661, 5.9068> <-6.8569, 15.3350, 5.8569> <-6.7996, 15.1248, 5.7727> <-6.7441, 14.9901, 5.7104>
		<-6.7653, 15.3339, 6.2556> <-6.8197, 15.2045, 6.2053> <-6.7301, 14.9673, 6.0987> <-6.6611, 14.8485, 6.0407>
		<-6.7443, 15.1856, 6.4894> <-6.7987, 15.0562, 6.4391> <-6.7018, 14.8614, 6.3517> <-6.6328, 14.7426, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4257, 14.6775, 5.2373> <-6.3743, 14.5767, 5.4893> <-6.2913, 14.4003, 5.8099> <-6.2544, 14.3414, 6.0772>
		<-6.3765, 14.6243, 5.2021> <-6.3251, 14.5235, 5.4540> <-6.1914, 14.3264, 5.7527> <-6.1545, 14.2675, 6.0201>
		<-6.3201, 14.5624, 5.1306> <-6.2050, 14.4604, 5.3650> <-6.1070, 14.3262, 5.7113> <-5.9818, 14.2347, 5.9448>
		<-6.2655, 14.5269, 5.0830> <-6.1504, 14.4250, 5.3174> <-6.0072, 14.2787, 5.6308> <-5.8820, 14.1872, 5.8643>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4257, 14.6775, 5.2373> <-6.5354, 14.7962, 5.3160> <-6.7289, 14.9432, 5.3899> <-6.7918, 15.0961, 5.4605>
		<-6.3743, 14.5767, 5.4893> <-6.4840, 14.6953, 5.5680> <-6.6812, 14.8372, 5.6398> <-6.7441, 14.9901, 5.7104>
		<-6.2913, 14.4003, 5.8099> <-6.4211, 14.4963, 5.8841> <-6.5790, 14.7069, 5.9715> <-6.6611, 14.8485, 6.0407>
		<-6.2544, 14.3414, 6.0772> <-6.3842, 14.4374, 6.1514> <-6.5506, 14.6010, 6.2245> <-6.6328, 14.7426, 6.2936>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2655, 14.5269, 5.0830> <-6.1504, 14.4250, 5.3174> <-6.0072, 14.2787, 5.6308> <-5.8820, 14.1872, 5.8643>
		<-6.2061, 14.4883, 5.0312> <-6.0910, 14.3863, 5.2656> <-5.9597, 14.2561, 5.5925> <-5.8345, 14.1646, 5.8260>
		<-6.1142, 14.4611, 4.9614> <-6.0319, 14.3652, 5.1958> <-5.9795, 14.2032, 5.5515> <-5.8071, 14.1354, 5.7427>
		<-6.0494, 14.4329, 4.9093> <-5.9671, 14.3370, 5.1437> <-5.9475, 14.1810, 5.4994> <-5.7750, 14.1132, 5.6906>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2544, 14.3414, 6.0772> <-6.1545, 14.2675, 6.0201> <-5.9818, 14.2347, 5.9448> <-5.8820, 14.1872, 5.8643>
		<-6.2090, 14.2689, 6.4059> <-6.1091, 14.1950, 6.3488> <-5.8349, 14.1274, 6.2186> <-5.7351, 14.0799, 6.1381>
		<-6.2660, 14.4267, 6.9363> <-6.0125, 14.3343, 6.8195> <-5.7699, 14.0775, 6.6119> <-5.5014, 14.0098, 6.5131>
		<-6.1548, 14.2448, 7.2007> <-5.9013, 14.1524, 7.0839> <-5.6281, 13.9328, 6.8706> <-5.3596, 13.8650, 6.7719>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2544, 14.3414, 6.0772> <-6.3842, 14.4374, 6.1514> <-6.5506, 14.6010, 6.2245> <-6.6328, 14.7426, 6.2936>
		<-6.2090, 14.2689, 6.4059> <-6.3389, 14.3650, 6.4801> <-6.5159, 14.4708, 6.5352> <-6.5980, 14.6124, 6.6044>
		<-6.2660, 14.4267, 6.9363> <-6.3831, 14.4694, 6.9903> <-6.5378, 14.5185, 7.0676> <-6.6510, 14.5669, 7.1249>
		<-6.1548, 14.2448, 7.2007> <-6.2718, 14.2875, 7.2547> <-6.4687, 14.2624, 7.2782> <-6.5819, 14.3109, 7.3355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5239, 12.7435, 10.1049> <-5.6490, 12.4721, 9.5534> <-5.7138, 12.2879, 8.7059> <-5.6885, 11.9528, 8.1763>
		<-5.4427, 12.6628, 10.0787> <-5.5678, 12.3914, 9.5272> <-5.6476, 12.3351, 8.7193> <-5.6224, 12.0001, 8.1896>
		<-5.3284, 12.6328, 9.9421> <-5.4650, 12.4816, 9.4570> <-5.5663, 12.2879, 8.6666> <-5.5189, 12.0470, 8.2013>
		<-5.2570, 12.6098, 9.8517> <-5.3937, 12.4586, 9.3667> <-5.5024, 12.3377, 8.6518> <-5.4550, 12.0969, 8.1864>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5239, 12.7435, 10.1049> <-5.6205, 12.8396, 10.1361> <-5.7222, 13.0434, 10.1183> <-5.7760, 13.1259, 10.0191>
		<-5.6490, 12.4721, 9.5534> <-5.7456, 12.5682, 9.5846> <-5.8450, 12.6478, 9.5508> <-5.8988, 12.7303, 9.4516>
		<-5.7138, 12.2879, 8.7059> <-5.7782, 12.2418, 8.6929> <-5.8749, 12.2807, 8.6789> <-5.9196, 12.2661, 8.6139>
		<-5.6885, 11.9528, 8.1763> <-5.7529, 11.9067, 8.1632> <-5.8408, 11.8036, 8.1643> <-5.8856, 11.7890, 8.0992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7897, 12.5065, 9.1750> <-4.9291, 12.4359, 8.8418> <-5.2753, 12.4447, 8.4026> <-5.2952, 12.2600, 8.0849>
		<-4.7005, 12.4880, 9.0060> <-4.8399, 12.4175, 8.6728> <-5.1755, 12.5334, 8.3099> <-5.1954, 12.3487, 7.9922>
		<-4.5425, 12.4426, 8.7573> <-4.6199, 12.4155, 8.4932> <-5.0085, 12.6228, 8.1131> <-5.0198, 12.4683, 7.8841>
		<-4.5811, 12.4701, 8.5712> <-4.6585, 12.4430, 8.3072> <-4.9618, 12.6794, 7.9681> <-4.9731, 12.5250, 7.7391>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7897, 12.5065, 9.1750> <-4.9052, 12.5304, 9.3938> <-5.1059, 12.5610, 9.6603> <-5.2570, 12.6098, 9.8517>
		<-4.9291, 12.4359, 8.8418> <-5.0446, 12.4598, 9.0607> <-5.2426, 12.4098, 9.1753> <-5.3937, 12.4586, 9.3667>
		<-5.2753, 12.4447, 8.4026> <-5.3214, 12.4038, 8.4453> <-5.4443, 12.3831, 8.6383> <-5.5024, 12.3377, 8.6518>
		<-5.2952, 12.2600, 8.0849> <-5.3413, 12.2191, 8.1276> <-5.3969, 12.1423, 8.1729> <-5.4550, 12.0969, 8.1864>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5811, 12.4701, 8.5712> <-4.6585, 12.4430, 8.3072> <-4.9618, 12.6794, 7.9681> <-4.9731, 12.5250, 7.7391>
		<-4.6375, 12.5104, 8.2988> <-4.7149, 12.4833, 8.0348> <-4.9265, 12.7221, 7.8588> <-4.9379, 12.5676, 7.6298>
		<-4.8020, 12.7088, 7.8864> <-4.8364, 12.6575, 7.7510> <-5.0200, 12.6859, 7.4803> <-4.9624, 12.5632, 7.4189>
		<-5.0724, 12.7084, 7.8099> <-5.1068, 12.6571, 7.6745> <-5.1128, 12.6736, 7.4012> <-5.0552, 12.5509, 7.3399>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0724, 12.7084, 7.8099> <-5.1068, 12.6571, 7.6745> <-5.1128, 12.6736, 7.4012> <-5.0552, 12.5509, 7.3399>
		<-5.3724, 12.7080, 7.7250> <-5.4068, 12.6567, 7.5896> <-5.2350, 12.6574, 7.2970> <-5.1775, 12.5347, 7.2357>
		<-5.7352, 12.5401, 8.0579> <-5.5872, 12.2670, 8.0424> <-5.6104, 12.6752, 7.4298> <-5.4215, 12.5001, 7.2555>
		<-6.0192, 12.4680, 8.1642> <-5.8712, 12.1949, 8.1486> <-5.7601, 12.6207, 7.4038> <-5.5712, 12.4456, 7.2295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2814, 13.0362, 8.3291> <-6.3071, 12.6624, 8.1088> <-6.1734, 12.4005, 7.4967> <-6.0130, 12.0427, 7.3090>
		<-6.2552, 13.2523, 8.5293> <-6.2809, 12.8784, 8.3089> <-6.2151, 12.3214, 7.5760> <-6.0547, 11.9636, 7.3883>
		<-6.1326, 13.5318, 8.8563> <-6.2078, 13.0014, 8.4343> <-6.1752, 12.4439, 7.8857> <-6.0723, 11.8695, 7.5329>
		<-6.0480, 13.5468, 9.1392> <-6.1232, 13.0164, 8.7172> <-6.1570, 12.4078, 7.9982> <-6.0541, 11.8334, 7.6454>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2814, 13.0362, 8.3291> <-6.2946, 12.9277, 8.2286> <-6.2014, 12.7062, 8.2594> <-6.1671, 12.5648, 8.2295>
		<-6.3071, 12.6624, 8.1088> <-6.3203, 12.5538, 8.0082> <-6.0844, 12.3936, 8.2251> <-6.0501, 12.2522, 8.1952>
		<-6.1734, 12.4005, 7.4967> <-6.1405, 12.4629, 7.4342> <-6.0783, 12.4191, 7.4020> <-6.0093, 12.4820, 7.3896>
		<-6.0130, 12.0427, 7.3090> <-5.9801, 12.1051, 7.2464> <-5.8922, 12.2083, 7.2190> <-5.8232, 12.2712, 7.2065>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.0480, 13.5468, 9.1392> <-6.1232, 13.0164, 8.7172> <-6.1570, 12.4078, 7.9982> <-6.0541, 11.8334, 7.6454>
		<-5.9611, 13.5622, 9.4299> <-6.0362, 13.0318, 9.0079> <-6.1349, 12.3638, 8.1354> <-6.0320, 11.7893, 7.7827>
		<-5.8930, 13.3052, 9.8036> <-6.0158, 12.9096, 9.2360> <-6.0010, 12.2395, 8.4958> <-5.9669, 11.7624, 7.9811>
		<-5.7760, 13.1259, 10.0191> <-5.8988, 12.7303, 9.4516> <-5.9196, 12.2661, 8.6139> <-5.8856, 11.7890, 8.0992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5819, 14.3109, 7.3355> <-6.4535, 13.8351, 7.7268> <-6.3186, 13.0206, 8.1956> <-6.0192, 12.4680, 8.1642>
		<-6.4687, 14.2624, 7.2782> <-6.3403, 13.7866, 7.6695> <-6.1472, 13.2115, 8.0421> <-5.8478, 12.6589, 8.0107>
		<-6.2718, 14.2875, 7.2547> <-6.1467, 14.0830, 7.5521> <-6.0507, 13.3477, 7.6423> <-5.8180, 13.0833, 7.7901>
		<-6.1548, 14.2448, 7.2007> <-6.0296, 14.0403, 7.4981> <-5.8055, 13.4914, 7.5496> <-5.5727, 13.2269, 7.6973>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.1671, 12.5648, 8.2295> <-6.1685, 12.5085, 8.2241> <-6.0516, 12.4319, 8.1932> <-6.0192, 12.4680, 8.1642>
		<-6.0501, 12.2522, 8.1952> <-6.0515, 12.1959, 8.1898> <-5.9036, 12.1588, 8.1777> <-5.8712, 12.1949, 8.1486>
		<-6.0093, 12.4820, 7.3896> <-5.9418, 12.5436, 7.3774> <-5.8456, 12.5896, 7.3890> <-5.7601, 12.6207, 7.4038>
		<-5.8232, 12.2712, 7.2065> <-5.7556, 12.3328, 7.1944> <-5.6567, 12.4145, 7.2147> <-5.5712, 12.4456, 7.2295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6161, 12.6778, 9.8592> <-3.5323, 12.5777, 10.0717> <-4.1132, 12.3093, 9.9898> <-4.2155, 12.2091, 10.1940>
		<-3.8070, 12.6649, 9.9536> <-3.7233, 12.5648, 10.1660> <-4.2232, 12.4103, 10.1980> <-4.3255, 12.3101, 10.4022>
		<-4.0969, 12.5724, 10.0418> <-4.0676, 12.5519, 10.2767> <-4.4190, 12.4681, 10.4592> <-4.4731, 12.4298, 10.6872>
		<-4.2527, 12.6347, 10.1736> <-4.2234, 12.6143, 10.4084> <-4.5280, 12.5840, 10.6600> <-4.5821, 12.5457, 10.8881>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6045, 13.0734, 10.6950> <-4.6228, 12.8670, 10.5951> <-4.4207, 12.7020, 10.3157> <-4.2527, 12.6347, 10.1736>
		<-4.5964, 13.0389, 10.9264> <-4.6148, 12.8325, 10.8265> <-4.3914, 12.6815, 10.5505> <-4.2234, 12.6143, 10.4084>
		<-4.8582, 12.9503, 11.1785> <-4.9204, 12.7701, 11.0907> <-4.6173, 12.6790, 10.8244> <-4.5280, 12.5840, 10.6600>
		<-4.8748, 12.9101, 11.4085> <-4.9370, 12.7299, 11.3207> <-4.6714, 12.6406, 11.0525> <-4.5821, 12.5457, 10.8881>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6045, 13.0734, 10.6950> <-4.5964, 13.0389, 10.9264> <-4.8582, 12.9503, 11.1785> <-4.8748, 12.9101, 11.4085>
		<-4.5826, 13.3186, 10.8136> <-4.5746, 13.2842, 11.0450> <-4.7604, 13.2335, 11.3165> <-4.7770, 13.1933, 11.5465>
		<-4.2821, 13.6215, 10.7436> <-4.2840, 13.6125, 10.8027> <-4.4910, 13.6955, 11.2604> <-4.4868, 13.6692, 11.4743>
		<-4.1440, 13.8564, 10.7645> <-4.1459, 13.8474, 10.8236> <-4.1708, 13.7750, 11.2604> <-4.1666, 13.7487, 11.4743>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2155, 12.2091, 10.1940> <-4.3472, 12.0801, 10.4569> <-4.3016, 12.0767, 10.9278> <-4.3075, 12.0003, 11.2396>
		<-4.3255, 12.3101, 10.4022> <-4.4571, 12.1811, 10.6651> <-4.3903, 12.1924, 11.0516> <-4.3962, 12.1160, 11.3634>
		<-4.4731, 12.4298, 10.6872> <-4.5264, 12.3919, 10.9123> <-4.5739, 12.3126, 11.2867> <-4.5440, 12.2671, 11.5147>
		<-4.5821, 12.5457, 10.8881> <-4.6354, 12.5078, 11.1131> <-4.6330, 12.4314, 11.4244> <-4.6031, 12.3860, 11.6524>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8748, 12.9101, 11.4085> <-4.9370, 12.7299, 11.3207> <-4.6714, 12.6406, 11.0525> <-4.5821, 12.5457, 10.8881>
		<-4.8918, 12.8691, 11.6432> <-4.9540, 12.6889, 11.5554> <-4.7247, 12.6028, 11.2776> <-4.6354, 12.5078, 11.1131>
		<-4.7897, 12.8398, 11.9575> <-4.8564, 12.6648, 11.8697> <-4.6969, 12.5599, 11.5733> <-4.6330, 12.4314, 11.4244>
		<-4.7121, 12.8135, 12.1819> <-4.7788, 12.6386, 12.0941> <-4.6670, 12.5144, 11.8012> <-4.6031, 12.3860, 11.6524>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8748, 12.9101, 11.4085> <-4.8918, 12.8691, 11.6432> <-4.7897, 12.8398, 11.9575> <-4.7121, 12.8135, 12.1819>
		<-4.7770, 13.1933, 11.5465> <-4.7940, 13.1523, 11.7812> <-4.6881, 13.1061, 12.0911> <-4.6105, 13.0799, 12.3155>
		<-4.4868, 13.6692, 11.4743> <-4.4819, 13.6390, 11.7205> <-4.4546, 13.6792, 12.0638> <-4.4208, 13.5979, 12.2958>
		<-4.1666, 13.7487, 11.4743> <-4.1618, 13.7185, 11.7205> <-4.1477, 13.7496, 12.0638> <-4.1140, 13.6684, 12.2958>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3075, 12.0003, 11.2396> <-4.3112, 11.9534, 11.4312> <-4.3769, 11.8353, 11.7187> <-4.2471, 11.8002, 11.8631>
		<-4.3962, 12.1160, 11.3634> <-4.3998, 12.0691, 11.5550> <-4.4226, 11.9756, 11.8438> <-4.2928, 11.9405, 11.9882>
		<-4.5440, 12.2671, 11.5147> <-4.5183, 12.2281, 11.7103> <-4.5104, 12.1736, 12.0422> <-4.3644, 12.1147, 12.1673>
		<-4.6031, 12.3860, 11.6524> <-4.5774, 12.3469, 11.8480> <-4.5455, 12.3268, 12.1550> <-4.3995, 12.2679, 12.2801>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7121, 12.8135, 12.1819> <-4.7788, 12.6386, 12.0941> <-4.6670, 12.5144, 11.8012> <-4.6031, 12.3860, 11.6524>
		<-4.6666, 12.7981, 12.3136> <-4.7333, 12.6232, 12.2258> <-4.6414, 12.4754, 11.9969> <-4.5774, 12.3469, 11.8480>
		<-4.5773, 12.7912, 12.4910> <-4.6397, 12.6459, 12.4105> <-4.5777, 12.4673, 12.2585> <-4.5455, 12.3268, 12.1550>
		<-4.4701, 12.7731, 12.5795> <-4.5325, 12.6278, 12.4989> <-4.4317, 12.4084, 12.3836> <-4.3995, 12.2679, 12.2801>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7121, 12.8135, 12.1819> <-4.6666, 12.7981, 12.3136> <-4.5773, 12.7912, 12.4910> <-4.4701, 12.7731, 12.5795>
		<-4.6105, 13.0799, 12.3155> <-4.5650, 13.0645, 12.4472> <-4.4979, 12.9760, 12.5935> <-4.3907, 12.9579, 12.6819>
		<-4.4208, 13.5979, 12.2958> <-4.3928, 13.5305, 12.4883> <-4.2400, 13.4052, 12.7186> <-4.1908, 13.2350, 12.8235>
		<-4.1140, 13.6684, 12.2958> <-4.0860, 13.6009, 12.4883> <-4.0177, 13.4418, 12.7317> <-3.9684, 13.2716, 12.8366>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4701, 12.7731, 12.5795> <-4.5325, 12.6278, 12.4989> <-4.4317, 12.4084, 12.3836> <-4.3995, 12.2679, 12.2801>
		<-4.3010, 12.7446, 12.7189> <-4.3634, 12.5994, 12.6384> <-4.2409, 12.3315, 12.5470> <-4.2087, 12.1910, 12.4435>
		<-4.0411, 12.6280, 12.9021> <-3.9758, 12.3973, 12.8434> <-3.9030, 12.0980, 12.6812> <-3.8611, 11.9307, 12.5047>
		<-3.8234, 12.6637, 12.9149> <-3.7581, 12.4331, 12.8562> <-3.6456, 12.1503, 12.6850> <-3.6037, 11.9830, 12.5085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4701, 12.7731, 12.5795> <-4.3010, 12.7446, 12.7189> <-4.0411, 12.6280, 12.9021> <-3.8234, 12.6637, 12.9149>
		<-4.4701, 12.7731, 12.5795> <-4.2216, 12.9294, 12.8214> <-4.0911, 12.8045, 12.9471> <-3.8734, 12.8403, 12.9599>
		<-4.4701, 12.7731, 12.5795> <-4.2216, 12.9294, 12.8214> <-4.1456, 13.0789, 12.9197> <-3.9233, 13.1154, 12.9328>
		<-4.4701, 12.7731, 12.5795> <-4.3907, 12.9579, 12.6819> <-4.1908, 13.2350, 12.8235> <-3.9684, 13.2716, 12.8366>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5578, 12.6847, 8.5437> <-2.5562, 12.6489, 8.4726> <-2.5359, 12.7277, 8.3490> <-2.5408, 12.6903, 8.2789>
		<-2.4286, 12.6870, 8.5511> <-2.4270, 12.6512, 8.4800> <-2.4261, 12.7208, 8.4074> <-2.4310, 12.6834, 8.3373>
		<-2.2424, 12.6899, 8.5697> <-2.2351, 12.6608, 8.5296> <-2.2220, 12.6440, 8.4822> <-2.2453, 12.6187, 8.4459>
		<-2.1277, 12.6837, 8.5101> <-2.1204, 12.6546, 8.4699> <-2.1252, 12.6171, 8.4086> <-2.1486, 12.5918, 8.3723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5578, 12.6847, 8.5437> <-2.6484, 12.6831, 8.5386> <-2.7761, 12.6721, 8.5207> <-2.8507, 12.6707, 8.4690>
		<-2.5562, 12.6489, 8.4726> <-2.6468, 12.6472, 8.4675> <-2.7713, 12.6225, 8.4004> <-2.8459, 12.6211, 8.3487>
		<-2.5359, 12.7277, 8.3490> <-2.6221, 12.7331, 8.3031> <-2.7061, 12.6998, 8.2400> <-2.7679, 12.6757, 8.1680>
		<-2.5408, 12.6903, 8.2789> <-2.6270, 12.6958, 8.2329> <-2.6996, 12.6544, 8.1181> <-2.7614, 12.6304, 8.0461>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8507, 12.6707, 8.4690> <-2.9306, 12.6692, 8.4135> <-3.0158, 12.6401, 8.2941> <-3.0423, 12.6755, 8.2075>
		<-2.8459, 12.6211, 8.3487> <-2.9258, 12.6196, 8.2932> <-3.0232, 12.5889, 8.1732> <-3.0497, 12.6243, 8.0865>
		<-2.7679, 12.6757, 8.1680> <-2.8287, 12.6521, 8.0971> <-2.9202, 12.7057, 7.9309> <-2.9541, 12.6511, 7.8591>
		<-2.7614, 12.6304, 8.0461> <-2.8222, 12.6067, 7.9752> <-2.9141, 12.5864, 7.8757> <-2.9480, 12.5318, 7.8040>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0423, 12.6755, 8.2075> <-3.0890, 12.7377, 8.0548> <-3.1385, 12.9126, 7.8706> <-3.0790, 12.9749, 7.7225>
		<-3.0497, 12.6243, 8.0865> <-3.0964, 12.6865, 7.9338> <-3.1791, 12.7773, 7.6726> <-3.1196, 12.8396, 7.5245>
		<-2.9541, 12.6511, 7.8591> <-3.0034, 12.5717, 7.7548> <-3.0651, 12.5393, 7.5574> <-3.0317, 12.4441, 7.4602>
		<-2.9480, 12.5318, 7.8040> <-2.9973, 12.4524, 7.6996> <-3.0608, 12.2971, 7.5803> <-3.0274, 12.2019, 7.4830>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0790, 12.9749, 7.7225> <-3.0151, 13.0419, 7.5633> <-2.8339, 13.0637, 7.3559> <-2.6682, 13.0676, 7.2755>
		<-3.1196, 12.8396, 7.5245> <-3.0556, 12.9066, 7.3652> <-2.9107, 12.8294, 7.1371> <-2.7449, 12.8332, 7.0568>
		<-3.0317, 12.4441, 7.4602> <-3.0004, 12.3550, 7.3692> <-2.8294, 12.3474, 7.2074> <-2.7196, 12.2928, 7.1610>
		<-3.0274, 12.2019, 7.4830> <-2.9961, 12.1128, 7.3920> <-2.8615, 12.0273, 7.2794> <-2.7517, 11.9728, 7.2330>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.6682, 13.0676, 7.2755> <-2.5157, 13.0711, 7.2016> <-2.2747, 13.0269, 7.2417> <-2.1080, 12.9977, 7.2518>
		<-2.7449, 12.8332, 7.0568> <-2.5925, 12.8368, 6.9828> <-2.3189, 12.7227, 7.0744> <-2.1522, 12.6935, 7.0845>
		<-2.7196, 12.2928, 7.1610> <-2.6077, 12.2373, 7.1138> <-2.3802, 12.2093, 7.1446> <-2.2478, 12.1920, 7.1444>
		<-2.7517, 11.9728, 7.2330> <-2.6398, 11.9172, 7.1858> <-2.4579, 11.8707, 7.1869> <-2.3255, 11.8534, 7.1867>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1080, 12.9977, 7.2518> <-2.0013, 12.9790, 7.2582> <-1.8535, 12.9418, 7.2744> <-1.7661, 12.9094, 7.3300>
		<-2.1522, 12.6935, 7.0845> <-2.0456, 12.6748, 7.0909> <-1.8765, 12.6521, 7.1361> <-1.7892, 12.6197, 7.1917>
		<-2.2478, 12.1920, 7.1444> <-2.1680, 12.1816, 7.1443> <-2.0567, 12.1787, 7.1916> <-1.9803, 12.1934, 7.2121>
		<-2.3255, 11.8534, 7.1867> <-2.2457, 11.8430, 7.1866> <-2.1393, 11.8683, 7.2116> <-2.0629, 11.8830, 7.2321>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7661, 12.9094, 7.3300> <-1.6636, 12.8713, 7.3952> <-1.5062, 12.8142, 7.5149> <-1.5049, 12.7736, 7.6356>
		<-1.7892, 12.6197, 7.1917> <-1.6867, 12.5816, 7.2569> <-1.5006, 12.5895, 7.3872> <-1.4993, 12.5489, 7.5078>
		<-1.9803, 12.1934, 7.2121> <-1.8631, 12.2160, 7.2435> <-1.6373, 12.1329, 7.3123> <-1.6123, 12.2236, 7.3922>
		<-2.0629, 11.8830, 7.2321> <-1.9457, 11.9055, 7.2635> <-1.7081, 11.8865, 7.2791> <-1.6832, 11.9771, 7.3590>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5049, 12.7736, 7.6356> <-1.5032, 12.7193, 7.7974> <-1.6591, 12.6557, 7.9892> <-1.7577, 12.6414, 8.1277>
		<-1.4993, 12.5489, 7.5078> <-1.4976, 12.4946, 7.6696> <-1.6455, 12.5706, 7.9097> <-1.7441, 12.5563, 8.0482>
		<-1.6123, 12.2236, 7.3922> <-1.5691, 12.3806, 7.5306> <-1.7902, 12.4964, 7.6864> <-1.8683, 12.5995, 7.8565>
		<-1.6832, 11.9771, 7.3590> <-1.6400, 12.1342, 7.4973> <-1.8124, 12.4065, 7.6142> <-1.8905, 12.5097, 7.7843>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.7577, 12.6414, 8.1277> <-1.8503, 12.6281, 8.2577> <-1.9858, 12.6760, 8.4363> <-2.1277, 12.6837, 8.5101>
		<-1.7441, 12.5563, 8.0482> <-1.8367, 12.5429, 8.1781> <-1.9785, 12.6470, 8.3962> <-2.1204, 12.6546, 8.4699>
		<-1.8683, 12.5995, 7.8565> <-1.9393, 12.6933, 8.0110> <-1.9743, 12.5752, 8.2938> <-2.1252, 12.6171, 8.4086>
		<-1.8905, 12.5097, 7.7843> <-1.9615, 12.6035, 7.9389> <-1.9976, 12.5499, 8.2575> <-2.1486, 12.5918, 8.3723>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5408, 12.6903, 8.2789> <-2.5432, 12.6714, 8.2433> <-2.5536, 12.5675, 8.2889> <-2.5731, 12.5679, 8.3242>
		<-2.4310, 12.6834, 8.3373> <-2.4335, 12.6645, 8.3017> <-2.4589, 12.5586, 8.2946> <-2.4785, 12.5590, 8.3299>
		<-2.2453, 12.6187, 8.4459> <-2.2642, 12.5982, 8.4166> <-2.2973, 12.5827, 8.3335> <-2.3213, 12.5844, 8.3659>
		<-2.1486, 12.5918, 8.3723> <-2.1674, 12.5713, 8.3430> <-2.2330, 12.5416, 8.2766> <-2.2570, 12.5433, 8.3090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5408, 12.6903, 8.2789> <-2.6270, 12.6958, 8.2329> <-2.6996, 12.6544, 8.1181> <-2.7614, 12.6304, 8.0461>
		<-2.5432, 12.6714, 8.2433> <-2.6295, 12.6768, 8.1974> <-2.6960, 12.6290, 8.0499> <-2.7578, 12.6050, 7.9779>
		<-2.5536, 12.5675, 8.2889> <-2.6351, 12.5751, 8.2840> <-2.7530, 12.6369, 8.2470> <-2.8122, 12.5970, 8.2065>
		<-2.5731, 12.5679, 8.3242> <-2.6547, 12.5755, 8.3193> <-2.7812, 12.6380, 8.3142> <-2.8403, 12.5981, 8.2738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7614, 12.6304, 8.0461> <-2.8222, 12.6067, 7.9752> <-2.9141, 12.5864, 7.8757> <-2.9480, 12.5318, 7.8040>
		<-2.7578, 12.6050, 7.9779> <-2.8186, 12.5813, 7.9070> <-2.9092, 12.4914, 7.8318> <-2.9431, 12.4367, 7.7600>
		<-2.8122, 12.5970, 8.2065> <-2.9111, 12.5302, 8.1388> <-2.9532, 12.3768, 7.9907> <-2.9886, 12.2659, 7.9181>
		<-2.8403, 12.5981, 8.2738> <-2.9392, 12.5313, 8.2061> <-2.9858, 12.3761, 8.0904> <-3.0212, 12.2652, 8.0177>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9480, 12.5318, 7.8040> <-2.9973, 12.4524, 7.6996> <-3.0608, 12.2971, 7.5803> <-3.0274, 12.2019, 7.4830>
		<-2.9431, 12.4367, 7.7600> <-2.9924, 12.3573, 7.6556> <-3.0584, 12.1630, 7.5929> <-3.0250, 12.0678, 7.4957>
		<-2.9886, 12.2659, 7.9181> <-3.0201, 12.1672, 7.8534> <-3.0539, 12.0071, 7.7473> <-3.0264, 11.9014, 7.6926>
		<-3.0212, 12.2652, 8.0177> <-3.0527, 12.1665, 7.9531> <-3.0875, 12.0156, 7.8775> <-3.0600, 11.9100, 7.8229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0274, 12.2019, 7.4830> <-2.9961, 12.1128, 7.3920> <-2.8615, 12.0273, 7.2794> <-2.7517, 11.9728, 7.2330>
		<-3.0250, 12.0678, 7.4957> <-2.9937, 11.9787, 7.4047> <-2.8794, 11.8488, 7.3195> <-2.7695, 11.7943, 7.2731>
		<-3.0264, 11.9014, 7.6926> <-2.9923, 11.7702, 7.6248> <-2.8749, 11.5910, 7.5160> <-2.7714, 11.5017, 7.4503>
		<-3.0600, 11.9100, 7.8229> <-3.0259, 11.7788, 7.7550> <-2.9278, 11.5978, 7.6919> <-2.8244, 11.5085, 7.6262>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7517, 11.9728, 7.2330> <-2.6398, 11.9172, 7.1858> <-2.4579, 11.8707, 7.1869> <-2.3255, 11.8534, 7.1867>
		<-2.7695, 11.7943, 7.2731> <-2.6577, 11.7387, 7.2259> <-2.4939, 11.7134, 7.2065> <-2.3616, 11.6962, 7.2063>
		<-2.7714, 11.5017, 7.4503> <-2.6884, 11.4300, 7.3976> <-2.5330, 11.4115, 7.3334> <-2.4174, 11.3955, 7.2984>
		<-2.8244, 11.5085, 7.6262> <-2.7413, 11.4368, 7.5734> <-2.5892, 11.4202, 7.4856> <-2.4737, 11.4042, 7.4506>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3255, 11.8534, 7.1867> <-2.2457, 11.8430, 7.1866> <-2.1393, 11.8683, 7.2116> <-2.0629, 11.8830, 7.2321>
		<-2.3616, 11.6962, 7.2063> <-2.2818, 11.6858, 7.2062> <-2.1789, 11.7193, 7.2212> <-2.1025, 11.7340, 7.2417>
		<-2.4174, 11.3955, 7.2984> <-2.3287, 11.3832, 7.2716> <-2.1916, 11.3754, 7.2791> <-2.1044, 11.4088, 7.2836>
		<-2.4737, 11.4042, 7.4506> <-2.3849, 11.3919, 7.4238> <-2.2504, 11.3833, 7.4217> <-2.1632, 11.4167, 7.4263>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0629, 11.8830, 7.2321> <-1.9457, 11.9055, 7.2635> <-1.7081, 11.8865, 7.2791> <-1.6832, 11.9771, 7.3590>
		<-2.1025, 11.7340, 7.2417> <-1.9854, 11.7566, 7.2731> <-1.7391, 11.7787, 7.2645> <-1.7141, 11.8693, 7.3444>
		<-2.1044, 11.4088, 7.2836> <-1.9885, 11.4533, 7.2897> <-1.8172, 11.5370, 7.3403> <-1.7747, 11.6452, 7.3843>
		<-2.1632, 11.4167, 7.4263> <-2.0473, 11.4612, 7.4323> <-1.8697, 11.5438, 7.4403> <-1.8272, 11.6520, 7.4842>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6832, 11.9771, 7.3590> <-1.6400, 12.1342, 7.4973> <-1.8124, 12.4065, 7.6142> <-1.8905, 12.5097, 7.7843>
		<-1.7141, 11.8693, 7.3444> <-1.6709, 12.0264, 7.4828> <-1.8344, 12.3172, 7.5425> <-1.9125, 12.4204, 7.7126>
		<-1.7747, 11.6452, 7.3843> <-1.7203, 11.7840, 7.4406> <-1.7739, 12.0218, 7.5113> <-1.8271, 12.1321, 7.6133>
		<-1.8272, 11.6520, 7.4842> <-1.7728, 11.7908, 7.5405> <-1.8314, 12.0169, 7.6127> <-1.8846, 12.1271, 7.7147>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8905, 12.5097, 7.7843> <-1.9615, 12.6035, 7.9389> <-1.9976, 12.5499, 8.2575> <-2.1486, 12.5918, 8.3723>
		<-1.9125, 12.4204, 7.7126> <-1.9835, 12.5141, 7.8671> <-2.0165, 12.5294, 8.2282> <-2.1674, 12.5713, 8.3430>
		<-1.8271, 12.1321, 7.6133> <-1.9087, 12.3014, 7.7699> <-2.0678, 12.4359, 8.1303> <-2.2330, 12.5416, 8.2766>
		<-1.8846, 12.1271, 7.7147> <-1.9662, 12.2964, 7.8713> <-2.0918, 12.4375, 8.1627> <-2.2570, 12.5433, 8.3090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5731, 12.5679, 8.3242> <-2.7647, 12.5715, 8.6702> <-3.0147, 12.6387, 9.1327> <-3.2028, 12.7031, 9.4746>
		<-2.4785, 12.5590, 8.3299> <-2.6700, 12.5626, 8.6759> <-2.9621, 12.6389, 9.1594> <-3.1502, 12.7033, 9.5013>
		<-2.3213, 12.5844, 8.3659> <-2.5878, 12.6030, 8.7249> <-2.8467, 12.6377, 9.1619> <-3.0725, 12.6935, 9.5442>
		<-2.2570, 12.5433, 8.3090> <-2.5235, 12.5618, 8.6680> <-2.8144, 12.5980, 9.1913> <-3.0402, 12.6538, 9.5736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5731, 12.5679, 8.3242> <-2.6547, 12.5755, 8.3193> <-2.7812, 12.6380, 8.3142> <-2.8403, 12.5981, 8.2738>
		<-2.7647, 12.5715, 8.6702> <-2.8463, 12.5792, 8.6653> <-2.9261, 12.6435, 8.6610> <-2.9852, 12.6036, 8.6205>
		<-3.0147, 12.6387, 9.1327> <-3.0554, 12.6385, 9.1119> <-3.1430, 12.6380, 9.0941> <-3.1797, 12.6129, 9.0836>
		<-3.2028, 12.7031, 9.4746> <-3.2435, 12.7028, 9.4538> <-3.3000, 12.6774, 9.4333> <-3.3367, 12.6523, 9.4228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8403, 12.5981, 8.2738> <-2.9392, 12.5313, 8.2061> <-2.9858, 12.3761, 8.0904> <-3.0212, 12.2652, 8.0177>
		<-2.9852, 12.6036, 8.6205> <-3.0841, 12.5368, 8.5529> <-3.1233, 12.3731, 8.5106> <-3.1587, 12.2622, 8.4379>
		<-3.1797, 12.6129, 9.0836> <-3.2252, 12.5818, 9.0706> <-3.2897, 12.4788, 8.9914> <-3.3188, 12.4302, 8.9925>
		<-3.3367, 12.6523, 9.4228> <-3.3822, 12.6211, 9.4098> <-3.4404, 12.5690, 9.3972> <-3.4695, 12.5205, 9.3982>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0212, 12.2652, 8.0177> <-3.0527, 12.1665, 7.9531> <-3.0875, 12.0156, 7.8775> <-3.0600, 11.9100, 7.8229>
		<-3.1587, 12.2622, 8.4379> <-3.1902, 12.1635, 8.3733> <-3.2166, 12.0485, 8.3779> <-3.1891, 11.9428, 8.3233>
		<-3.3188, 12.4302, 8.9925> <-3.3500, 12.3781, 8.9936> <-3.3711, 12.2583, 8.9349> <-3.3688, 12.2009, 8.9549>
		<-3.4695, 12.5205, 9.3982> <-3.5007, 12.4683, 9.3994> <-3.5320, 12.3871, 9.4100> <-3.5297, 12.3298, 9.4299>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0600, 11.9100, 7.8229> <-3.0259, 11.7788, 7.7550> <-2.9278, 11.5978, 7.6919> <-2.8244, 11.5085, 7.6262>
		<-3.1891, 11.9428, 8.3233> <-3.1550, 11.8117, 8.2554> <-3.1097, 11.6211, 8.2961> <-3.0062, 11.5319, 8.2304>
		<-3.3688, 12.2009, 8.9549> <-3.3654, 12.1142, 8.9850> <-3.2992, 11.9678, 8.9342> <-3.2479, 11.9070, 8.9803>
		<-3.5297, 12.3298, 9.4299> <-3.5263, 12.2430, 9.4601> <-3.5025, 12.1233, 9.5114> <-3.4512, 12.0626, 9.5575>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8244, 11.5085, 7.6262> <-2.7413, 11.4368, 7.5734> <-2.5892, 11.4202, 7.4856> <-2.4737, 11.4042, 7.4506>
		<-3.0062, 11.5319, 8.2304> <-2.9231, 11.4602, 8.1777> <-2.8420, 11.4593, 8.1701> <-2.7265, 11.4433, 8.1352>
		<-3.2479, 11.9070, 8.9803> <-3.2063, 11.8578, 9.0177> <-3.0760, 11.8396, 8.9759> <-3.0110, 11.8321, 9.0115>
		<-3.4512, 12.0626, 9.5575> <-3.4096, 12.0133, 9.5948> <-3.3126, 12.0034, 9.6476> <-3.2476, 11.9959, 9.6832>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4737, 11.4042, 7.4506> <-2.3849, 11.3919, 7.4238> <-2.2504, 11.3833, 7.4217> <-2.1632, 11.4167, 7.4263>
		<-2.7265, 11.4433, 8.1352> <-2.6378, 11.4309, 8.1083> <-2.5449, 11.4228, 8.1356> <-2.4577, 11.4562, 8.1401>
		<-3.0110, 11.8321, 9.0115> <-2.9685, 11.8272, 9.0348> <-2.8658, 11.8320, 9.0332> <-2.8242, 11.8530, 9.0475>
		<-3.2476, 11.9959, 9.6832> <-3.2051, 11.9909, 9.7065> <-3.1431, 12.0012, 9.7348> <-3.1015, 12.0222, 9.7492>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1632, 11.4167, 7.4263> <-2.0473, 11.4612, 7.4323> <-1.8697, 11.5438, 7.4403> <-1.8272, 11.6520, 7.4842>
		<-2.4577, 11.4562, 8.1401> <-2.3418, 11.5006, 8.1461> <-2.2330, 11.5910, 8.1317> <-2.1906, 11.6992, 8.1756>
		<-2.8242, 11.8530, 9.0475> <-2.7753, 11.8777, 9.0644> <-2.6492, 11.9468, 9.0947> <-2.6313, 12.0006, 9.0863>
		<-3.1015, 12.0222, 9.7492> <-3.0526, 12.0469, 9.7660> <-2.9751, 12.0888, 9.7919> <-2.9572, 12.1426, 9.7834>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8272, 11.6520, 7.4842> <-1.7728, 11.7908, 7.5405> <-1.8314, 12.0169, 7.6127> <-1.8846, 12.1271, 7.7147>
		<-2.1906, 11.6992, 8.1756> <-2.1362, 11.8380, 8.2320> <-2.1672, 11.9881, 8.2044> <-2.2203, 12.0983, 8.3064>
		<-2.6313, 12.0006, 9.0863> <-2.6040, 12.0826, 9.0733> <-2.6442, 12.2402, 9.1228> <-2.6571, 12.3201, 9.0900>
		<-2.9572, 12.1426, 9.7834> <-2.9299, 12.2245, 9.7705> <-2.9571, 12.3371, 9.7198> <-2.9700, 12.4171, 9.6870>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8846, 12.1271, 7.7147> <-1.9662, 12.2964, 7.8713> <-2.0918, 12.4375, 8.1627> <-2.2570, 12.5433, 8.3090>
		<-2.2203, 12.0983, 8.3064> <-2.3020, 12.2676, 8.4631> <-2.3583, 12.4561, 8.5217> <-2.5235, 12.5618, 8.6680>
		<-2.6571, 12.3201, 9.0900> <-2.6692, 12.3947, 9.0594> <-2.7698, 12.5433, 9.2320> <-2.8144, 12.5980, 9.1913>
		<-2.9700, 12.4171, 9.6870> <-2.9821, 12.4916, 9.6564> <-2.9957, 12.5990, 9.6143> <-3.0402, 12.6538, 9.5736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2028, 12.7031, 9.4746> <-3.2207, 12.7092, 9.5072> <-3.2591, 12.7999, 9.5808> <-3.2451, 12.7979, 9.5458>
		<-3.1502, 12.7033, 9.5013> <-3.1682, 12.7095, 9.5340> <-3.1979, 12.8002, 9.6119> <-3.1839, 12.7982, 9.5769>
		<-3.0725, 12.6935, 9.5442> <-3.0913, 12.6981, 9.5760> <-3.1106, 12.7891, 9.6598> <-3.0934, 12.7867, 9.6268>
		<-3.0402, 12.6538, 9.5736> <-3.0591, 12.6585, 9.6054> <-3.0731, 12.7429, 9.6941> <-3.0558, 12.7406, 9.6611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2028, 12.7031, 9.4746> <-3.2435, 12.7028, 9.4538> <-3.3000, 12.6774, 9.4333> <-3.3367, 12.6523, 9.4228>
		<-3.2207, 12.7092, 9.5072> <-3.2615, 12.7090, 9.4865> <-3.3157, 12.6813, 9.4671> <-3.3523, 12.6562, 9.4566>
		<-3.2591, 12.7999, 9.5808> <-3.3065, 12.7996, 9.5567> <-3.3692, 12.7710, 9.5334> <-3.4120, 12.7418, 9.5212>
		<-3.2451, 12.7979, 9.5458> <-3.2925, 12.7977, 9.5216> <-3.3584, 12.7680, 9.4977> <-3.4011, 12.7388, 9.4855>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3367, 12.6523, 9.4228> <-3.3822, 12.6211, 9.4098> <-3.4404, 12.5690, 9.3972> <-3.4695, 12.5205, 9.3982>
		<-3.3523, 12.6562, 9.4566> <-3.3978, 12.6251, 9.4436> <-3.4530, 12.5765, 9.4310> <-3.4820, 12.5280, 9.4320>
		<-3.4120, 12.7418, 9.5212> <-3.4649, 12.7055, 9.5060> <-3.5295, 12.6472, 9.4912> <-3.5633, 12.5906, 9.4925>
		<-3.4011, 12.7388, 9.4855> <-3.4541, 12.7025, 9.4703> <-3.5219, 12.6418, 9.4556> <-3.5558, 12.5852, 9.4568>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4695, 12.5205, 9.3982> <-3.5007, 12.4683, 9.3994> <-3.5320, 12.3871, 9.4100> <-3.5297, 12.3298, 9.4299>
		<-3.4820, 12.5280, 9.4320> <-3.5132, 12.4759, 9.4332> <-3.5432, 12.3961, 9.4430> <-3.5409, 12.3387, 9.4630>
		<-3.5633, 12.5906, 9.4925> <-3.5996, 12.5299, 9.4938> <-3.6348, 12.4383, 9.5050> <-3.6321, 12.3715, 9.5283>
		<-3.5558, 12.5852, 9.4568> <-3.5921, 12.5245, 9.4582> <-3.6286, 12.4299, 9.4705> <-3.6259, 12.3631, 9.4937>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5297, 12.3298, 9.4299> <-3.5263, 12.2430, 9.4601> <-3.5025, 12.1233, 9.5114> <-3.4512, 12.0626, 9.5575>
		<-3.5409, 12.3387, 9.4630> <-3.5375, 12.2520, 9.4932> <-3.5140, 12.1321, 9.5441> <-3.4627, 12.0714, 9.5902>
		<-3.6321, 12.3715, 9.5283> <-3.6281, 12.2705, 9.5634> <-3.6027, 12.1346, 9.6213> <-3.5429, 12.0639, 9.6750>
		<-3.6259, 12.3631, 9.4937> <-3.6219, 12.2621, 9.5289> <-3.5942, 12.1227, 9.5887> <-3.5344, 12.0519, 9.6423>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4512, 12.0626, 9.5575> <-3.4096, 12.0133, 9.5948> <-3.3126, 12.0034, 9.6476> <-3.2476, 11.9959, 9.6832>
		<-3.4627, 12.0714, 9.5902> <-3.4211, 12.0222, 9.6276> <-3.3241, 12.0113, 9.6803> <-3.2591, 12.0038, 9.7160>
		<-3.5429, 12.0639, 9.6750> <-3.4945, 12.0065, 9.7185> <-3.3862, 11.9949, 9.7782> <-3.3104, 11.9861, 9.8197>
		<-3.5344, 12.0519, 9.6423> <-3.4860, 11.9945, 9.6859> <-3.3730, 11.9829, 9.7473> <-3.2973, 11.9742, 9.7888>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2476, 11.9959, 9.6832> <-3.2051, 11.9909, 9.7065> <-3.1431, 12.0012, 9.7348> <-3.1015, 12.0222, 9.7492>
		<-3.2591, 12.0038, 9.7160> <-3.2166, 11.9989, 9.7393> <-3.1560, 12.0091, 9.7676> <-3.1145, 12.0301, 9.7820>
		<-3.3104, 11.9861, 9.8197> <-3.2609, 11.9804, 9.8468> <-3.1918, 11.9914, 9.8793> <-3.1434, 12.0159, 9.8960>
		<-3.2973, 11.9742, 9.7888> <-3.2478, 11.9685, 9.8160> <-3.1756, 11.9804, 9.8489> <-3.1271, 12.0048, 9.8656>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1015, 12.0222, 9.7492> <-3.0526, 12.0469, 9.7660> <-2.9751, 12.0888, 9.7919> <-2.9572, 12.1426, 9.7834>
		<-3.1145, 12.0301, 9.7820> <-3.0656, 12.0548, 9.7988> <-2.9904, 12.0954, 9.8245> <-2.9725, 12.1492, 9.8160>
		<-3.1434, 12.0159, 9.8960> <-3.0865, 12.0447, 9.9156> <-2.9990, 12.0914, 9.9453> <-2.9781, 12.1540, 9.9355>
		<-3.1271, 12.0048, 9.8656> <-3.0702, 12.0336, 9.8853> <-2.9800, 12.0824, 9.9153> <-2.9591, 12.1451, 9.9055>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9572, 12.1426, 9.7834> <-2.9299, 12.2245, 9.7705> <-2.9571, 12.3371, 9.7198> <-2.9700, 12.4171, 9.6870>
		<-2.9725, 12.1492, 9.8160> <-2.9452, 12.2312, 9.8031> <-2.9731, 12.3421, 9.7504> <-2.9861, 12.4220, 9.7176>
		<-2.9781, 12.1540, 9.9355> <-2.9463, 12.2495, 9.9204> <-2.9766, 12.3768, 9.8610> <-2.9917, 12.4699, 9.8229>
		<-2.9591, 12.1451, 9.9055> <-2.9273, 12.2406, 9.8904> <-2.9589, 12.3717, 9.8314> <-2.9740, 12.4648, 9.7932>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9700, 12.4171, 9.6870> <-2.9821, 12.4916, 9.6564> <-2.9957, 12.5990, 9.6143> <-3.0402, 12.6538, 9.5736>
		<-2.9861, 12.4220, 9.7176> <-2.9982, 12.4966, 9.6870> <-3.0145, 12.6037, 9.6461> <-3.0591, 12.6585, 9.6054>
		<-2.9917, 12.4699, 9.8229> <-3.0058, 12.5568, 9.7872> <-3.0211, 12.6791, 9.7415> <-3.0731, 12.7429, 9.6941>
		<-2.9740, 12.4648, 9.7932> <-2.9881, 12.5517, 9.7575> <-3.0039, 12.6768, 9.7085> <-3.0558, 12.7406, 9.6611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2451, 12.7979, 9.5458> <-3.1353, 12.7826, 9.2710> <-2.9730, 12.7417, 8.9076> <-2.8703, 12.6568, 8.6429>
		<-3.1839, 12.7982, 9.5769> <-3.0740, 12.7830, 9.3021> <-2.8891, 12.7438, 8.9315> <-2.7865, 12.6590, 8.6668>
		<-3.0934, 12.7867, 9.6268> <-2.9490, 12.7674, 9.3513> <-2.7679, 12.7347, 8.9862> <-2.6606, 12.6517, 8.7055>
		<-3.0558, 12.7406, 9.6611> <-2.9115, 12.7212, 9.3855> <-2.7097, 12.6782, 9.0183> <-2.6024, 12.5951, 8.7376>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2451, 12.7979, 9.5458> <-3.2925, 12.7977, 9.5216> <-3.3584, 12.7680, 9.4977> <-3.4011, 12.7388, 9.4855>
		<-3.1353, 12.7826, 9.2710> <-3.1827, 12.7824, 9.2468> <-3.2756, 12.7450, 9.2250> <-3.3184, 12.7158, 9.2128>
		<-2.9730, 12.7417, 8.9076> <-3.0402, 12.7400, 8.8884> <-3.1274, 12.7018, 8.8618> <-3.1868, 12.6659, 8.8541>
		<-2.8703, 12.6568, 8.6429> <-2.9375, 12.6551, 8.6237> <-3.0275, 12.6188, 8.6072> <-3.0869, 12.5829, 8.5994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.4011, 12.7388, 9.4855> <-3.4541, 12.7025, 9.4703> <-3.5219, 12.6418, 9.4556> <-3.5558, 12.5852, 9.4568>
		<-3.3184, 12.7158, 9.2128> <-3.3713, 12.6795, 9.1976> <-3.4649, 12.6013, 9.1867> <-3.4988, 12.5447, 9.1879>
		<-3.1868, 12.6659, 8.8541> <-3.2584, 12.6226, 8.8448> <-3.3492, 12.5464, 8.8300> <-3.3960, 12.4767, 8.8349>
		<-3.0869, 12.5829, 8.5994> <-3.1584, 12.5395, 8.5901> <-3.2509, 12.4679, 8.5822> <-3.2977, 12.3982, 8.5872>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5558, 12.5852, 9.4568> <-3.5921, 12.5245, 9.4582> <-3.6286, 12.4299, 9.4705> <-3.6259, 12.3631, 9.4937>
		<-3.4988, 12.5447, 9.1879> <-3.5351, 12.4840, 9.1892> <-3.5813, 12.3654, 9.2053> <-3.5786, 12.2986, 9.2285>
		<-3.3960, 12.4767, 8.8349> <-3.4429, 12.4068, 8.8399> <-3.4929, 12.2880, 8.8563> <-3.4862, 12.2073, 8.8798>
		<-3.2977, 12.3982, 8.5872> <-3.3446, 12.3284, 8.5922> <-3.3938, 12.2163, 8.6077> <-3.3872, 12.1356, 8.6312>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.6259, 12.3631, 9.4937> <-3.6219, 12.2621, 9.5289> <-3.5942, 12.1227, 9.5887> <-3.5344, 12.0519, 9.6423>
		<-3.5786, 12.2986, 9.2285> <-3.5746, 12.1976, 9.2637> <-3.5259, 12.0262, 9.3258> <-3.4661, 11.9554, 9.3795>
		<-3.4862, 12.2073, 8.8798> <-3.4765, 12.0888, 8.9143> <-3.4336, 11.9135, 8.9856> <-3.3496, 11.8348, 9.0312>
		<-3.3872, 12.1356, 8.6312> <-3.3774, 12.0171, 8.6657> <-3.3302, 11.8519, 8.7237> <-3.2462, 11.7732, 8.7692>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.5344, 12.0519, 9.6423> <-3.4860, 11.9945, 9.6859> <-3.3730, 11.9829, 9.7473> <-3.2973, 11.9742, 9.7888>
		<-3.4661, 11.9554, 9.3795> <-3.4176, 11.8981, 9.4230> <-3.2603, 11.8804, 9.4821> <-3.1846, 11.8716, 9.5237>
		<-3.3496, 11.8348, 9.0312> <-3.2749, 11.7649, 9.0716> <-3.1235, 11.7552, 9.1371> <-3.0188, 11.7473, 9.1698>
		<-3.2462, 11.7732, 8.7692> <-3.1715, 11.7033, 8.8097> <-3.0150, 11.6969, 8.8572> <-2.9103, 11.6890, 8.8899>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2973, 11.9742, 9.7888> <-3.2478, 11.9685, 9.8160> <-3.1756, 11.9804, 9.8489> <-3.1271, 12.0048, 9.8656>
		<-3.1846, 11.8716, 9.5237> <-3.1351, 11.8659, 9.5508> <-3.0327, 11.8830, 9.5821> <-2.9843, 11.9075, 9.5988>
		<-3.0188, 11.7473, 9.1698> <-2.9480, 11.7420, 9.1919> <-2.8516, 11.7587, 9.2286> <-2.7846, 11.7889, 9.2401>
		<-2.9103, 11.6890, 8.8899> <-2.8394, 11.6837, 8.9120> <-2.7398, 11.6998, 8.9368> <-2.6727, 11.7300, 8.9483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1271, 12.0048, 9.8656> <-3.0702, 12.0336, 9.8853> <-2.9800, 12.0824, 9.9153> <-2.9591, 12.1451, 9.9055>
		<-2.9843, 11.9075, 9.5988> <-2.9273, 11.9362, 9.6184> <-2.8094, 12.0019, 9.6459> <-2.7886, 12.0645, 9.6360>
		<-2.7846, 11.7889, 9.2401> <-2.7071, 11.8237, 9.2534> <-2.5859, 11.8827, 9.2850> <-2.5571, 11.9627, 9.2720>
		<-2.6727, 11.7300, 8.9483> <-2.5953, 11.7648, 8.9616> <-2.4715, 11.8195, 8.9832> <-2.4426, 11.8994, 8.9703>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9591, 12.1451, 9.9055> <-2.9273, 12.2406, 9.8904> <-2.9589, 12.3717, 9.8314> <-2.9740, 12.4648, 9.7932>
		<-2.7886, 12.0645, 9.6360> <-2.7568, 12.1600, 9.6210> <-2.7955, 12.3243, 9.5576> <-2.8106, 12.4174, 9.5194>
		<-2.5571, 11.9627, 9.2720> <-2.5176, 12.0720, 9.2543> <-2.5629, 12.2390, 9.1899> <-2.5879, 12.3479, 9.1535>
		<-2.4426, 11.8994, 8.9703> <-2.4032, 12.0088, 8.9526> <-2.4515, 12.1651, 8.8967> <-2.4765, 12.2740, 8.8602>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.9740, 12.4648, 9.7932> <-2.9881, 12.5517, 9.7575> <-3.0039, 12.6768, 9.7085> <-3.0558, 12.7406, 9.6611>
		<-2.8106, 12.4174, 9.5194> <-2.8247, 12.5043, 9.4838> <-2.8595, 12.6574, 9.4329> <-2.9115, 12.7212, 9.3855>
		<-2.5879, 12.3479, 9.1535> <-2.6113, 12.4497, 9.1195> <-2.6365, 12.6070, 9.0587> <-2.7097, 12.6782, 9.0183>
		<-2.4765, 12.2740, 8.8602> <-2.4999, 12.3758, 8.8262> <-2.5292, 12.5240, 8.7781> <-2.6024, 12.5951, 8.7376>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8650, 12.4838, 8.5656> <-2.8020, 12.4854, 8.5836> <-2.7076, 12.4799, 8.6126> <-2.6640, 12.4375, 8.6367>
		<-2.8666, 12.5357, 8.5888> <-2.8037, 12.5373, 8.6068> <-2.6892, 12.5272, 8.6429> <-2.6455, 12.4848, 8.6670>
		<-2.8506, 12.6406, 8.5921> <-2.7668, 12.6427, 8.6160> <-2.6402, 12.6359, 8.6523> <-2.5821, 12.5794, 8.6844>
		<-2.8703, 12.6568, 8.6429> <-2.7865, 12.6590, 8.6668> <-2.6606, 12.6517, 8.7055> <-2.6024, 12.5951, 8.7376>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8650, 12.4838, 8.5656> <-2.8666, 12.5357, 8.5888> <-2.8506, 12.6406, 8.5921> <-2.8703, 12.6568, 8.6429>
		<-2.9153, 12.4825, 8.5513> <-2.9170, 12.5344, 8.5744> <-2.9178, 12.6388, 8.5729> <-2.9375, 12.6551, 8.6237>
		<-2.9828, 12.4553, 8.5388> <-3.0007, 12.5016, 8.5588> <-3.0088, 12.6033, 8.5595> <-3.0275, 12.6188, 8.6072>
		<-3.0274, 12.4283, 8.5330> <-3.0452, 12.4747, 8.5529> <-3.0682, 12.5673, 8.5517> <-3.0869, 12.5829, 8.5994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0274, 12.4283, 8.5330> <-3.0452, 12.4747, 8.5529> <-3.0682, 12.5673, 8.5517> <-3.0869, 12.5829, 8.5994>
		<-3.0810, 12.3958, 8.5260> <-3.0989, 12.4422, 8.5459> <-3.1397, 12.5240, 8.5424> <-3.1584, 12.5395, 8.5901>
		<-3.1503, 12.3421, 8.5201> <-3.1840, 12.3746, 8.5391> <-3.2330, 12.4537, 8.5372> <-3.2509, 12.4679, 8.5822>
		<-3.1854, 12.2898, 8.5239> <-3.2191, 12.3223, 8.5429> <-3.2798, 12.3839, 8.5421> <-3.2977, 12.3982, 8.5872>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1854, 12.2898, 8.5239> <-3.2191, 12.3223, 8.5429> <-3.2798, 12.3839, 8.5421> <-3.2977, 12.3982, 8.5872>
		<-3.2206, 12.2374, 8.5276> <-3.2543, 12.2699, 8.5466> <-3.3267, 12.3141, 8.5471> <-3.3446, 12.3284, 8.5922>
		<-3.2575, 12.1533, 8.5393> <-3.2979, 12.1662, 8.5616> <-3.3767, 12.2039, 8.5648> <-3.3938, 12.2163, 8.6077>
		<-3.2526, 12.0928, 8.5569> <-3.2929, 12.1057, 8.5792> <-3.3700, 12.1232, 8.5883> <-3.3872, 12.1356, 8.6312>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2526, 12.0928, 8.5569> <-3.2929, 12.1057, 8.5792> <-3.3700, 12.1232, 8.5883> <-3.3872, 12.1356, 8.6312>
		<-3.2452, 12.0040, 8.5828> <-3.2856, 12.0168, 8.6051> <-3.3603, 12.0047, 8.6228> <-3.3774, 12.0171, 8.6657>
		<-3.2098, 11.8801, 8.6262> <-3.2396, 11.8657, 8.6589> <-3.3135, 11.8420, 8.6815> <-3.3302, 11.8519, 8.7237>
		<-3.1468, 11.8211, 8.6604> <-3.1766, 11.8067, 8.6931> <-3.2295, 11.7633, 8.7270> <-3.2462, 11.7732, 8.7692>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1468, 11.8211, 8.6604> <-3.1766, 11.8067, 8.6931> <-3.2295, 11.7633, 8.7270> <-3.2462, 11.7732, 8.7692>
		<-3.0908, 11.7686, 8.6908> <-3.1206, 11.7543, 8.7234> <-3.1548, 11.6934, 8.7675> <-3.1715, 11.7033, 8.8097>
		<-2.9735, 11.7638, 8.7264> <-2.9781, 11.7432, 8.7681> <-2.9984, 11.6880, 8.8144> <-3.0150, 11.6969, 8.8572>
		<-2.8949, 11.7579, 8.7509> <-2.8995, 11.7372, 8.7926> <-2.8937, 11.6801, 8.8471> <-2.9103, 11.6890, 8.8899>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8949, 11.7579, 8.7509> <-2.8995, 11.7372, 8.7926> <-2.8937, 11.6801, 8.8471> <-2.9103, 11.6890, 8.8899>
		<-2.8418, 11.7539, 8.7675> <-2.8464, 11.7332, 8.8092> <-2.8228, 11.6748, 8.8692> <-2.8394, 11.6837, 8.9120>
		<-2.7670, 11.7660, 8.7861> <-2.7538, 11.7484, 8.8322> <-2.7218, 11.6904, 8.8899> <-2.7398, 11.6998, 8.9368>
		<-2.7168, 11.7886, 8.7947> <-2.7036, 11.7710, 8.8408> <-2.6548, 11.7205, 8.9015> <-2.6727, 11.7300, 8.9483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.7168, 11.7886, 8.7947> <-2.7036, 11.7710, 8.8408> <-2.6548, 11.7205, 8.9015> <-2.6727, 11.7300, 8.9483>
		<-2.6587, 11.8148, 8.8047> <-2.6455, 11.7972, 8.8508> <-2.5773, 11.7554, 8.9148> <-2.5953, 11.7648, 8.9616>
		<-2.5658, 11.8557, 8.8209> <-2.5353, 11.8509, 8.8686> <-2.4517, 11.8085, 8.9311> <-2.4715, 11.8195, 8.9832>
		<-2.5442, 11.9157, 8.8112> <-2.5137, 11.9108, 8.8589> <-2.4229, 11.8885, 8.9181> <-2.4426, 11.8994, 8.9703>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5442, 11.9157, 8.8112> <-2.5137, 11.9108, 8.8589> <-2.4229, 11.8885, 8.9181> <-2.4426, 11.8994, 8.9703>
		<-2.5146, 11.9977, 8.7979> <-2.4841, 11.9928, 8.8456> <-2.3834, 11.9978, 8.9004> <-2.4032, 12.0088, 8.9526>
		<-2.5508, 12.1150, 8.7560> <-2.5229, 12.1382, 8.7955> <-2.4329, 12.1528, 8.8479> <-2.4515, 12.1651, 8.8967>
		<-2.5696, 12.1967, 8.7287> <-2.5416, 12.2199, 8.7681> <-2.4580, 12.2617, 8.8114> <-2.4765, 12.2740, 8.8602>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.5696, 12.1967, 8.7287> <-2.5416, 12.2199, 8.7681> <-2.4580, 12.2617, 8.8114> <-2.4765, 12.2740, 8.8602>
		<-2.5871, 12.2730, 8.7031> <-2.5592, 12.2962, 8.7426> <-2.4813, 12.3635, 8.7774> <-2.4999, 12.3758, 8.8262>
		<-2.6091, 12.3841, 8.6670> <-2.5906, 12.4314, 8.6973> <-2.5088, 12.5082, 8.7248> <-2.5292, 12.5240, 8.7781>
		<-2.6640, 12.4375, 8.6367> <-2.6455, 12.4848, 8.6670> <-2.5821, 12.5794, 8.6844> <-2.6024, 12.5951, 8.7376>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6885, 11.9528, 8.1763> <-5.7529, 11.9067, 8.1632> <-5.8408, 11.8036, 8.1643> <-5.8856, 11.7890, 8.0992>
		<-5.6821, 11.8679, 8.0420> <-5.7465, 11.8218, 8.0290> <-5.8330, 11.6945, 8.0465> <-5.8778, 11.6799, 7.9815>
		<-5.5301, 11.6162, 8.1306> <-5.6040, 11.5701, 8.1340> <-5.7250, 11.4812, 8.1277> <-5.7525, 11.4319, 8.0612>
		<-5.4297, 11.4929, 8.1281> <-5.5036, 11.4468, 8.1315> <-5.6191, 11.3604, 8.1280> <-5.6466, 11.3111, 8.0615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6885, 11.9528, 8.1763> <-5.6821, 11.8679, 8.0420> <-5.5301, 11.6162, 8.1306> <-5.4297, 11.4929, 8.1281>
		<-5.6224, 12.0001, 8.1896> <-5.6160, 11.9151, 8.0554> <-5.4258, 11.6812, 8.1257> <-5.3255, 11.5579, 8.1233>
		<-5.5189, 12.0470, 8.2013> <-5.5028, 11.9655, 8.0438> <-5.2765, 11.7716, 8.0999> <-5.1737, 11.6266, 8.0888>
		<-5.4550, 12.0969, 8.1864> <-5.4390, 12.0154, 8.0289> <-5.1747, 11.8145, 8.0460> <-5.0719, 11.6695, 8.0349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4550, 12.0969, 8.1864> <-5.4390, 12.0154, 8.0289> <-5.1747, 11.8145, 8.0460> <-5.0719, 11.6695, 8.0349>
		<-5.3969, 12.1423, 8.1729> <-5.3808, 12.0608, 8.0154> <-5.1031, 11.8447, 8.0082> <-5.0003, 11.6996, 7.9971>
		<-5.3413, 12.2191, 8.1276> <-5.3530, 12.1101, 7.9401> <-5.0528, 11.8916, 7.9199> <-4.9304, 11.7135, 7.8978>
		<-5.2952, 12.2600, 8.0849> <-5.3070, 12.1510, 7.8973> <-4.9961, 11.9053, 7.8562> <-4.8737, 11.7271, 7.8341>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2952, 12.2600, 8.0849> <-5.3070, 12.1510, 7.8973> <-4.9961, 11.9053, 7.8562> <-4.8737, 11.7271, 7.8341>
		<-5.1954, 12.3487, 7.9922> <-5.2071, 12.2397, 7.8046> <-4.9207, 11.9234, 7.7716> <-4.7983, 11.7453, 7.7494>
		<-5.0198, 12.4683, 7.8841> <-5.0303, 12.3264, 7.6736> <-4.7972, 12.0097, 7.6490> <-4.6852, 11.7817, 7.6428>
		<-4.9731, 12.5250, 7.7391> <-4.9836, 12.3830, 7.5286> <-4.7442, 12.0033, 7.5475> <-4.6322, 11.7753, 7.5412>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9731, 12.5250, 7.7391> <-4.9836, 12.3830, 7.5286> <-4.7442, 12.0033, 7.5475> <-4.6322, 11.7753, 7.5412>
		<-4.9379, 12.5676, 7.6298> <-4.9484, 12.4257, 7.4193> <-4.7089, 11.9991, 7.4798> <-4.5969, 11.7711, 7.4736>
		<-4.9624, 12.5632, 7.4189> <-4.8495, 12.3224, 7.2986> <-4.6961, 11.9940, 7.3351> <-4.5596, 11.7367, 7.3541>
		<-5.0552, 12.5509, 7.3399> <-4.9422, 12.3101, 7.2195> <-4.7328, 11.9510, 7.2837> <-4.5963, 11.6937, 7.3027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0552, 12.5509, 7.3399> <-4.9422, 12.3101, 7.2195> <-4.7328, 11.9510, 7.2837> <-4.5963, 11.6937, 7.3027>
		<-5.1775, 12.5347, 7.2357> <-5.0645, 12.2939, 7.1154> <-4.7953, 11.8777, 7.1960> <-4.6588, 11.6204, 7.2150>
		<-5.4215, 12.5001, 7.2555> <-5.2028, 12.2973, 7.0536> <-5.0283, 11.8097, 7.1572> <-4.8141, 11.5208, 7.1758>
		<-5.5712, 12.4456, 7.2295> <-5.3524, 12.2428, 7.0277> <-5.1290, 11.7329, 7.1263> <-4.9147, 11.4440, 7.1449>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5712, 12.4456, 7.2295> <-5.3524, 12.2428, 7.0277> <-5.1290, 11.7329, 7.1263> <-4.9147, 11.4440, 7.1449>
		<-5.6567, 12.4145, 7.2147> <-5.4379, 12.2117, 7.0128> <-5.1749, 11.6979, 7.1121> <-4.9606, 11.4090, 7.1308>
		<-5.7556, 12.3328, 7.1944> <-5.5551, 12.1058, 6.9972> <-5.2600, 11.6315, 7.1150> <-5.0262, 11.3568, 7.1376>
		<-5.8232, 12.2712, 7.2065> <-5.6227, 12.0442, 7.0094> <-5.3089, 11.6029, 7.1330> <-5.0751, 11.3282, 7.1556>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.8232, 12.2712, 7.2065> <-5.6227, 12.0442, 7.0094> <-5.3089, 11.6029, 7.1330> <-5.0751, 11.3282, 7.1556>
		<-5.8922, 12.2083, 7.2190> <-5.6917, 11.9812, 7.0218> <-5.4178, 11.5393, 7.1730> <-5.1840, 11.2645, 7.1956>
		<-5.9801, 12.1051, 7.2464> <-5.8614, 11.8403, 7.1075> <-5.5490, 11.4136, 7.2211> <-5.3384, 11.1716, 7.2466>
		<-6.0130, 12.0427, 7.3090> <-5.8943, 11.7779, 7.1700> <-5.6426, 11.3834, 7.3096> <-5.4321, 11.1414, 7.3350>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.0130, 12.0427, 7.3090> <-5.8943, 11.7779, 7.1700> <-5.6426, 11.3834, 7.3096> <-5.4321, 11.1414, 7.3350>
		<-6.0547, 11.9636, 7.3883> <-5.9360, 11.6988, 7.2493> <-5.7240, 11.3572, 7.3864> <-5.5135, 11.1152, 7.4118>
		<-6.0723, 11.8695, 7.5329> <-6.0357, 11.6653, 7.4075> <-5.7512, 11.3059, 7.5474> <-5.5874, 11.1278, 7.5616>
		<-6.0541, 11.8334, 7.6454> <-6.0175, 11.6292, 7.5200> <-5.7829, 11.3310, 7.6550> <-5.6192, 11.1529, 7.6691>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.0541, 11.8334, 7.6454> <-6.0175, 11.6292, 7.5200> <-5.7829, 11.3310, 7.6550> <-5.6192, 11.1529, 7.6691>
		<-6.0320, 11.7893, 7.7827> <-5.9954, 11.5851, 7.6573> <-5.8181, 11.3588, 7.7740> <-5.6543, 11.1807, 7.7881>
		<-5.9669, 11.7624, 7.9811> <-5.9592, 11.6533, 7.8634> <-5.7925, 11.3601, 7.9642> <-5.6866, 11.2392, 7.9645>
		<-5.8856, 11.7890, 8.0992> <-5.8778, 11.6799, 7.9815> <-5.7525, 11.4319, 8.0612> <-5.6466, 11.3111, 8.0615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4297, 11.4929, 8.1281> <-5.5036, 11.4468, 8.1315> <-5.6191, 11.3604, 8.1280> <-5.6466, 11.3111, 8.0615>
		<-5.1281, 11.1227, 8.1207> <-5.2021, 11.0765, 8.1241> <-5.2906, 10.9856, 8.1292> <-5.3180, 10.9363, 8.0626>
		<-4.6571, 10.6870, 8.1130> <-4.6912, 10.6411, 8.1213> <-4.7906, 10.5513, 8.1140> <-4.7964, 10.5156, 8.0688>
		<-4.3564, 10.3172, 8.1436> <-4.3905, 10.2712, 8.1519> <-4.4479, 10.1911, 8.1493> <-4.4537, 10.1555, 8.1041>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4297, 11.4929, 8.1281> <-5.1281, 11.1227, 8.1207> <-4.6571, 10.6870, 8.1130> <-4.3564, 10.3172, 8.1436>
		<-5.3255, 11.5579, 8.1233> <-5.0239, 11.1877, 8.1159> <-4.6288, 10.7252, 8.1061> <-4.3281, 10.3554, 8.1367>
		<-5.1737, 11.6266, 8.0888> <-4.9150, 11.2616, 8.0608> <-4.5221, 10.7759, 8.0488> <-4.2924, 10.3931, 8.0885>
		<-5.0719, 11.6695, 8.0349> <-4.8132, 11.3045, 8.0069> <-4.4920, 10.7967, 8.0177> <-4.2622, 10.4138, 8.0574>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0719, 11.6695, 8.0349> <-4.8132, 11.3045, 8.0069> <-4.4920, 10.7967, 8.0177> <-4.2622, 10.4138, 8.0574>
		<-5.0003, 11.6996, 7.9971> <-4.7416, 11.3346, 7.9691> <-4.4405, 10.8322, 7.9647> <-4.2108, 10.4493, 8.0044>
		<-4.9304, 11.7135, 7.8978> <-4.6845, 11.3554, 7.8533> <-4.3574, 10.8495, 7.8698> <-4.1332, 10.4799, 7.9311>
		<-4.8737, 11.7271, 7.8341> <-4.6277, 11.3691, 7.7896> <-4.3121, 10.8721, 7.8053> <-4.0878, 10.5024, 7.8666>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8737, 11.7271, 7.8341> <-4.6277, 11.3691, 7.7896> <-4.3121, 10.8721, 7.8053> <-4.0878, 10.5024, 7.8666>
		<-4.7983, 11.7453, 7.7494> <-4.5523, 11.3872, 7.7050> <-4.2779, 10.8890, 7.7567> <-4.0537, 10.5194, 7.8180>
		<-4.6852, 11.7817, 7.6428> <-4.5013, 11.4071, 7.6326> <-4.2347, 10.9031, 7.7076> <-4.0204, 10.5467, 7.7433>
		<-4.6322, 11.7753, 7.5412> <-4.4483, 11.4007, 7.5310> <-4.2147, 10.9004, 7.6492> <-4.0004, 10.5440, 7.6849>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6322, 11.7753, 7.5412> <-4.4483, 11.4007, 7.5310> <-4.2147, 10.9004, 7.6492> <-4.0004, 10.5440, 7.6849>
		<-4.5969, 11.7711, 7.4736> <-4.4130, 11.3965, 7.4634> <-4.1948, 10.8977, 7.5911> <-3.9805, 10.5413, 7.6267>
		<-4.5596, 11.7367, 7.3541> <-4.3662, 11.3720, 7.3811> <-4.1749, 10.8692, 7.5090> <-3.9584, 10.5184, 7.5444>
		<-4.5963, 11.6937, 7.3027> <-4.4029, 11.3290, 7.3297> <-4.1762, 10.8360, 7.4573> <-3.9597, 10.4852, 7.4927>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5963, 11.6937, 7.3027> <-4.4029, 11.3290, 7.3297> <-4.1762, 10.8360, 7.4573> <-3.9597, 10.4852, 7.4927>
		<-4.6588, 11.6204, 7.2150> <-4.4654, 11.2557, 7.2420> <-4.1775, 10.8035, 7.4068> <-3.9610, 10.4528, 7.4422>
		<-4.8141, 11.5208, 7.1758> <-4.5560, 11.1729, 7.1983> <-4.2682, 10.7138, 7.3538> <-3.9837, 10.3882, 7.3887>
		<-4.9147, 11.4440, 7.1449> <-4.6566, 11.0961, 7.1674> <-4.2932, 10.6644, 7.3306> <-4.0087, 10.3388, 7.3655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9147, 11.4440, 7.1449> <-4.6566, 11.0961, 7.1674> <-4.2932, 10.6644, 7.3306> <-4.0087, 10.3388, 7.3655>
		<-4.9606, 11.4090, 7.1308> <-4.7025, 11.0610, 7.1533> <-4.3098, 10.6315, 7.3152> <-4.0253, 10.3059, 7.3501>
		<-5.0262, 11.3568, 7.1376> <-4.7368, 11.0168, 7.1655> <-4.3633, 10.5885, 7.3249> <-4.0623, 10.2593, 7.3597>
		<-5.0751, 11.3282, 7.1556> <-4.7857, 10.9881, 7.1835> <-4.3887, 10.5612, 7.3393> <-4.0877, 10.2320, 7.3741>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0751, 11.3282, 7.1556> <-4.7857, 10.9881, 7.1835> <-4.3887, 10.5612, 7.3393> <-4.0877, 10.2320, 7.3741>
		<-5.1840, 11.2645, 7.1956> <-4.8946, 10.9245, 7.2235> <-4.4462, 10.4995, 7.3720> <-4.1452, 10.1703, 7.4068>
		<-5.3384, 11.1716, 7.2466> <-5.0245, 10.8107, 7.2846> <-4.5629, 10.4220, 7.4165> <-4.2275, 10.0806, 7.4513>
		<-5.4321, 11.1414, 7.3350> <-5.1182, 10.7805, 7.3730> <-4.6141, 10.3902, 7.4839> <-4.2787, 10.0488, 7.5187>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4321, 11.1414, 7.3350> <-5.1182, 10.7805, 7.3730> <-4.6141, 10.3902, 7.4839> <-4.2787, 10.0488, 7.5187>
		<-5.5135, 11.1152, 7.4118> <-5.1996, 10.7543, 7.4498> <-4.6645, 10.3589, 7.5502> <-4.3291, 10.0176, 7.5850>
		<-5.5874, 11.1278, 7.5616> <-5.2518, 10.7629, 7.5905> <-4.7255, 10.3738, 7.6690> <-4.3771, 10.0216, 7.7040>
		<-5.6192, 11.1529, 7.6691> <-5.2836, 10.7880, 7.6981> <-4.7506, 10.3891, 7.7529> <-4.4022, 10.0369, 7.7879>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.6192, 11.1529, 7.6691> <-5.2836, 10.7880, 7.6981> <-4.7506, 10.3891, 7.7529> <-4.4022, 10.0369, 7.7879>
		<-5.6543, 11.1807, 7.7881> <-5.3187, 10.8158, 7.8171> <-4.7795, 10.4067, 7.8497> <-4.4311, 10.0546, 7.8847>
		<-5.6866, 11.2392, 7.9645> <-5.3581, 10.8644, 7.9656> <-4.8067, 10.4525, 7.9887> <-4.4640, 10.0924, 8.0240>
		<-5.6466, 11.3111, 8.0615> <-5.3180, 10.9363, 8.0626> <-4.7964, 10.5156, 8.0688> <-4.4537, 10.1555, 8.1041>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3564, 10.3172, 8.1436> <-4.3905, 10.2712, 8.1519> <-4.4479, 10.1911, 8.1493> <-4.4537, 10.1555, 8.1041>
		<-4.3294, 10.2840, 8.1464> <-4.3635, 10.2380, 8.1547> <-4.4201, 10.1619, 8.1522> <-4.4259, 10.1263, 8.1070>
		<-4.3582, 10.1799, 8.2309> <-4.3861, 10.1339, 8.2328> <-4.4143, 10.0536, 8.2270> <-4.4136, 10.0227, 8.1830>
		<-4.3876, 10.2109, 8.2342> <-4.4155, 10.1650, 8.2361> <-4.4455, 10.0792, 8.2293> <-4.4448, 10.0483, 8.1853>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3564, 10.3172, 8.1436> <-4.3294, 10.2840, 8.1464> <-4.3582, 10.1799, 8.2309> <-4.3876, 10.2109, 8.2342>
		<-4.3281, 10.3554, 8.1367> <-4.3011, 10.3222, 8.1394> <-4.3300, 10.2261, 8.2290> <-4.3595, 10.2572, 8.2323>
		<-4.2924, 10.3931, 8.0885> <-4.2707, 10.3570, 8.0923> <-4.2844, 10.2729, 8.1941> <-4.3103, 10.3061, 8.1974>
		<-4.2622, 10.4138, 8.0574> <-4.2406, 10.3778, 8.0612> <-4.2449, 10.3011, 8.1700> <-4.2709, 10.3343, 8.1733>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2622, 10.4138, 8.0574> <-4.2406, 10.3778, 8.0612> <-4.2449, 10.3011, 8.1700> <-4.2709, 10.3343, 8.1733>
		<-4.2108, 10.4493, 8.0044> <-4.1891, 10.4132, 8.0081> <-4.1921, 10.3389, 8.1378> <-4.2181, 10.3721, 8.1411>
		<-4.1332, 10.4799, 7.9311> <-4.1027, 10.4297, 7.9394> <-4.0966, 10.3556, 8.1026> <-4.1274, 10.4062, 8.1047>
		<-4.0878, 10.5024, 7.8666> <-4.0574, 10.4522, 7.8749> <-4.0545, 10.3768, 8.0475> <-4.0853, 10.4274, 8.0495>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0878, 10.5024, 7.8666> <-4.0574, 10.4522, 7.8749> <-4.0545, 10.3768, 8.0475> <-4.0853, 10.4274, 8.0495>
		<-4.0537, 10.5194, 7.8180> <-4.0232, 10.4692, 7.8263> <-3.9769, 10.4159, 7.9459> <-4.0077, 10.4665, 7.9480>
		<-4.0204, 10.5467, 7.7433> <-4.0020, 10.5160, 7.7463> <-3.9181, 10.4918, 7.7948> <-3.9335, 10.5238, 7.7895>
		<-4.0004, 10.5440, 7.6849> <-3.9820, 10.5133, 7.6879> <-3.8678, 10.4976, 7.6711> <-3.8832, 10.5296, 7.6658>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0004, 10.5440, 7.6849> <-3.9820, 10.5133, 7.6879> <-3.8678, 10.4976, 7.6711> <-3.8832, 10.5296, 7.6658>
		<-3.9805, 10.5413, 7.6267> <-3.9621, 10.5107, 7.6298> <-3.8392, 10.5010, 7.6005> <-3.8546, 10.5329, 7.5953>
		<-3.9584, 10.5184, 7.5444> <-3.9356, 10.4815, 7.5482> <-3.8125, 10.4601, 7.5027> <-3.8312, 10.4980, 7.4918>
		<-3.9597, 10.4852, 7.4927> <-3.9369, 10.4482, 7.4964> <-3.8142, 10.4189, 7.4385> <-3.8328, 10.4568, 7.4277>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9597, 10.4852, 7.4927> <-3.9369, 10.4482, 7.4964> <-3.8142, 10.4189, 7.4385> <-3.8328, 10.4568, 7.4277>
		<-3.9610, 10.4528, 7.4422> <-3.9382, 10.4158, 7.4460> <-3.8158, 10.3787, 7.3760> <-3.8344, 10.4166, 7.3652>
		<-3.9837, 10.3882, 7.3887> <-3.9517, 10.3517, 7.3926> <-3.8373, 10.2979, 7.3142> <-3.8625, 10.3367, 7.2988>
		<-4.0087, 10.3388, 7.3655> <-3.9767, 10.3023, 7.3695> <-3.8682, 10.2367, 7.2855> <-3.8934, 10.2754, 7.2701>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0087, 10.3388, 7.3655> <-3.9767, 10.3023, 7.3695> <-3.8682, 10.2367, 7.2855> <-3.8934, 10.2754, 7.2701>
		<-4.0253, 10.3059, 7.3501> <-3.9933, 10.2694, 7.3541> <-3.8888, 10.1959, 7.2664> <-3.9140, 10.2347, 7.2511>
		<-4.0623, 10.2593, 7.3597> <-4.0298, 10.2238, 7.3635> <-3.9307, 10.1414, 7.2778> <-3.9599, 10.1769, 7.2629>
		<-4.0877, 10.2320, 7.3741> <-4.0552, 10.1965, 7.3779> <-3.9621, 10.1076, 7.2956> <-3.9914, 10.1431, 7.2808>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0877, 10.2320, 7.3741> <-4.0552, 10.1965, 7.3779> <-3.9621, 10.1076, 7.2956> <-3.9914, 10.1431, 7.2808>
		<-4.1452, 10.1703, 7.4068> <-4.1127, 10.1347, 7.4105> <-4.0334, 10.0311, 7.3360> <-4.0626, 10.0666, 7.3212>
		<-4.2275, 10.0806, 7.4513> <-4.1952, 10.0478, 7.4546> <-4.1296, 9.9272, 7.3865> <-4.1646, 9.9555, 7.3764>
		<-4.2787, 10.0488, 7.5187> <-4.2465, 10.0160, 7.5221> <-4.1931, 9.8878, 7.4701> <-4.2281, 9.9161, 7.4600>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2787, 10.0488, 7.5187> <-4.2465, 10.0160, 7.5221> <-4.1931, 9.8878, 7.4701> <-4.2281, 9.9161, 7.4600>
		<-4.3291, 10.0176, 7.5850> <-4.2969, 9.9848, 7.5884> <-4.2555, 9.8491, 7.5522> <-4.2905, 9.8774, 7.5421>
		<-4.3771, 10.0216, 7.7040> <-4.3482, 9.9924, 7.7069> <-4.3169, 9.8581, 7.6930> <-4.3500, 9.8824, 7.6895>
		<-4.4022, 10.0369, 7.7879> <-4.3733, 10.0077, 7.7908> <-4.3480, 9.8771, 7.7970> <-4.3810, 9.9014, 7.7935>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4022, 10.0369, 7.7879> <-4.3733, 10.0077, 7.7908> <-4.3480, 9.8771, 7.7970> <-4.3810, 9.9014, 7.7935>
		<-4.4311, 10.0546, 7.8847> <-4.4022, 10.0253, 7.8876> <-4.3838, 9.8989, 7.9168> <-4.4168, 9.9232, 7.9133>
		<-4.4640, 10.0924, 8.0240> <-4.4362, 10.0632, 8.0269> <-4.4121, 9.9497, 8.0791> <-4.4433, 9.9753, 8.0814>
		<-4.4537, 10.1555, 8.1041> <-4.4259, 10.1263, 8.1070> <-4.4136, 10.0227, 8.1830> <-4.4448, 10.0483, 8.1853>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3876, 10.2109, 8.2342> <-4.4155, 10.1650, 8.2361> <-4.4455, 10.0792, 8.2293> <-4.4448, 10.0483, 8.1853>
		<-4.5899, 10.4246, 8.2568> <-4.6178, 10.3787, 8.2587> <-4.6851, 10.2753, 8.2469> <-4.6844, 10.2444, 8.2029>
		<-4.8401, 10.7437, 8.2843> <-4.9074, 10.6803, 8.2896> <-5.0036, 10.5649, 8.2943> <-5.0251, 10.5086, 8.2239>
		<-4.9912, 10.9875, 8.2146> <-5.0585, 10.9241, 8.2200> <-5.1718, 10.8171, 8.2289> <-5.1932, 10.7608, 8.1585>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3876, 10.2109, 8.2342> <-4.5899, 10.4246, 8.2568> <-4.8401, 10.7437, 8.2843> <-4.9912, 10.9875, 8.2146>
		<-4.3595, 10.2572, 8.2323> <-4.5618, 10.4708, 8.2549> <-4.7882, 10.7926, 8.2801> <-4.9393, 11.0364, 8.2105>
		<-4.3103, 10.3061, 8.1974> <-4.4860, 10.5313, 8.2200> <-4.7099, 10.8554, 8.2323> <-4.8645, 11.0871, 8.1653>
		<-4.2709, 10.3343, 8.1733> <-4.4466, 10.5595, 8.1959> <-4.6581, 10.8878, 8.1951> <-4.8128, 11.1195, 8.1281>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2709, 10.3343, 8.1733> <-4.4466, 10.5595, 8.1959> <-4.6581, 10.8878, 8.1951> <-4.8128, 11.1195, 8.1281>
		<-4.2181, 10.3721, 8.1411> <-4.3938, 10.5973, 8.1636> <-4.5762, 10.9390, 8.1362> <-4.7309, 11.1707, 8.0692>
		<-4.1274, 10.4062, 8.1047> <-4.2784, 10.6542, 8.1149> <-4.4638, 11.0030, 8.0538> <-4.6200, 11.2378, 7.9839>
		<-4.0853, 10.4274, 8.0495> <-4.2363, 10.6754, 8.0598> <-4.3946, 11.0280, 7.9679> <-4.5508, 11.2628, 7.8981>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0853, 10.4274, 8.0495> <-4.2363, 10.6754, 8.0598> <-4.3946, 11.0280, 7.9679> <-4.5508, 11.2628, 7.8981>
		<-4.0077, 10.4665, 7.9480> <-4.1587, 10.7145, 7.9582> <-4.3234, 11.0538, 7.8796> <-4.4795, 11.2886, 7.8097>
		<-3.9335, 10.5238, 7.7895> <-4.0490, 10.7636, 7.7500> <-4.2184, 11.0983, 7.6886> <-4.3998, 11.2963, 7.6703>
		<-3.8832, 10.5296, 7.6658> <-3.9988, 10.7694, 7.6263> <-4.1757, 11.0863, 7.5811> <-4.3571, 11.2843, 7.5628>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8832, 10.5296, 7.6658> <-3.9988, 10.7694, 7.6263> <-4.1757, 11.0863, 7.5811> <-4.3571, 11.2843, 7.5628>
		<-3.8546, 10.5329, 7.5953> <-3.9701, 10.7727, 7.5557> <-4.1436, 11.0772, 7.5003> <-4.3250, 11.2752, 7.4820>
		<-3.8312, 10.4980, 7.4918> <-3.9453, 10.7297, 7.4255> <-4.1203, 11.0430, 7.3626> <-4.2976, 11.2423, 7.3621>
		<-3.8328, 10.4568, 7.4277> <-3.9470, 10.6885, 7.3614> <-4.1319, 10.9954, 7.2903> <-4.3091, 11.1947, 7.2897>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8328, 10.4568, 7.4277> <-3.9470, 10.6885, 7.3614> <-4.1319, 10.9954, 7.2903> <-4.3091, 11.1947, 7.2897>
		<-3.8344, 10.4166, 7.3652> <-3.9486, 10.6484, 7.2989> <-4.1438, 10.9461, 7.2154> <-4.3211, 11.1454, 7.2148>
		<-3.8625, 10.3367, 7.2988> <-4.0029, 10.5525, 7.2132> <-4.2016, 10.8464, 7.1300> <-4.3775, 11.0527, 7.1405>
		<-3.8934, 10.2754, 7.2701> <-4.0338, 10.4913, 7.1846> <-4.2536, 10.7795, 7.0985> <-4.4295, 10.9858, 7.1090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.8934, 10.2754, 7.2701> <-4.0338, 10.4913, 7.1846> <-4.2536, 10.7795, 7.0985> <-4.4295, 10.9858, 7.1090>
		<-3.9140, 10.2347, 7.2511> <-4.0544, 10.4505, 7.1655> <-4.2909, 10.7315, 7.0758> <-4.4668, 10.9378, 7.0863>
		<-3.9599, 10.1769, 7.2629> <-4.1285, 10.3815, 7.1775> <-4.3620, 10.6596, 7.0866> <-4.5379, 10.8751, 7.1006>
		<-3.9914, 10.1431, 7.2808> <-4.1599, 10.3477, 7.1953> <-4.4107, 10.6220, 7.1072> <-4.5866, 10.8376, 7.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.9914, 10.1431, 7.2808> <-4.1599, 10.3477, 7.1953> <-4.4107, 10.6220, 7.1072> <-4.5866, 10.8376, 7.1212>
		<-4.0626, 10.0666, 7.3212> <-4.2312, 10.2712, 7.2357> <-4.5193, 10.5383, 7.1531> <-4.6952, 10.7538, 7.1671>
		<-4.1646, 9.9555, 7.3764> <-4.3901, 10.1383, 7.3114> <-4.6759, 10.3903, 7.2271> <-4.8496, 10.6319, 7.2266>
		<-4.2281, 9.9161, 7.4600> <-4.4536, 10.0989, 7.3949> <-4.7710, 10.3470, 7.3272> <-4.9446, 10.5886, 7.3267>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2281, 9.9161, 7.4600> <-4.4536, 10.0989, 7.3949> <-4.7710, 10.3470, 7.3272> <-4.9446, 10.5886, 7.3267>
		<-4.2905, 9.8774, 7.5421> <-4.5160, 10.0602, 7.4770> <-4.8561, 10.3082, 7.4168> <-5.0298, 10.5498, 7.4163>
		<-4.3500, 9.8824, 7.6895> <-4.5974, 10.0643, 7.6633> <-4.9373, 10.3033, 7.6167> <-5.1088, 10.5578, 7.5874>
		<-4.3810, 9.9014, 7.7935> <-4.6285, 10.0832, 7.7673> <-4.9737, 10.3286, 7.7385> <-5.1452, 10.5830, 7.7092>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3810, 9.9014, 7.7935> <-4.6285, 10.0832, 7.7673> <-4.9737, 10.3286, 7.7385> <-5.1452, 10.5830, 7.7092>
		<-4.4168, 9.9232, 7.9133> <-4.6643, 10.1051, 7.8871> <-5.0146, 10.3569, 7.8754> <-5.1861, 10.6114, 7.8461>
		<-4.4433, 9.9753, 8.0814> <-4.6829, 10.1714, 8.0990> <-5.0588, 10.4200, 8.1132> <-5.2269, 10.6723, 8.0479>
		<-4.4448, 10.0483, 8.1853> <-4.6844, 10.2444, 8.2029> <-5.0251, 10.5086, 8.2239> <-5.1932, 10.7608, 8.1585>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9403, 11.1027, 7.9795> <-4.9556, 11.0682, 8.0500> <-5.0322, 11.0536, 8.1957> <-4.9912, 10.9875, 8.2146>
		<-4.9798, 11.0655, 7.9827> <-4.9951, 11.0309, 8.0532> <-5.0994, 10.9902, 8.2011> <-5.0585, 10.9241, 8.2200>
		<-5.0463, 11.0027, 7.9879> <-5.0866, 10.9401, 8.0515> <-5.2249, 10.8968, 8.2083> <-5.1718, 10.8171, 8.2289>
		<-5.0589, 10.9697, 7.9465> <-5.0992, 10.9070, 8.0101> <-5.2463, 10.8405, 8.1379> <-5.1932, 10.7608, 8.1585>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9403, 11.1027, 7.9795> <-4.9098, 11.1315, 7.9770> <-4.8663, 11.1601, 7.9489> <-4.8355, 11.1803, 7.9287>
		<-4.9556, 11.0682, 8.0500> <-4.9251, 11.0969, 8.0476> <-4.8594, 11.1418, 8.0087> <-4.8287, 11.1620, 7.9885>
		<-5.0322, 11.0536, 8.1957> <-4.9802, 11.1025, 8.1916> <-4.8985, 11.1380, 8.1505> <-4.8468, 11.1703, 8.1134>
		<-4.9912, 10.9875, 8.2146> <-4.9393, 11.0364, 8.2105> <-4.8645, 11.0871, 8.1653> <-4.8128, 11.1195, 8.1281>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.8355, 11.1803, 7.9287> <-4.7810, 11.2160, 7.8928> <-4.7033, 11.2718, 7.8501> <-4.6578, 11.2883, 7.7936>
		<-4.8287, 11.1620, 7.9885> <-4.7742, 11.1978, 7.9526> <-4.6712, 11.2642, 7.8814> <-4.6257, 11.2806, 7.8249>
		<-4.8468, 11.1703, 8.1134> <-4.7649, 11.2215, 8.0545> <-4.6444, 11.2746, 7.9730> <-4.5752, 11.2996, 7.8871>
		<-4.8128, 11.1195, 8.1281> <-4.7309, 11.1707, 8.0692> <-4.6200, 11.2378, 7.9839> <-4.5508, 11.2628, 7.8981>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6578, 11.2883, 7.7936> <-4.6180, 11.3027, 7.7442> <-4.5892, 11.2851, 7.6576> <-4.5679, 11.2770, 7.5967>
		<-4.6257, 11.2806, 7.8249> <-4.5859, 11.2950, 7.7756> <-4.5260, 11.2873, 7.6474> <-4.5046, 11.2792, 7.5865>
		<-4.5752, 11.2996, 7.8871> <-4.5040, 11.3254, 7.7988> <-4.4430, 11.3435, 7.6660> <-4.4003, 11.3314, 7.5584>
		<-4.5508, 11.2628, 7.8981> <-4.4795, 11.2886, 7.8097> <-4.3998, 11.2963, 7.6703> <-4.3571, 11.2843, 7.5628>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5679, 11.2770, 7.5967> <-4.5502, 11.2703, 7.5462> <-4.5230, 11.2667, 7.4716> <-4.5288, 11.2394, 7.4255>
		<-4.5046, 11.2792, 7.5865> <-4.4870, 11.2725, 7.5360> <-4.4570, 11.2532, 7.4308> <-4.4629, 11.2260, 7.3847>
		<-4.4003, 11.3314, 7.5584> <-4.3682, 11.3224, 7.4776> <-4.3498, 11.3010, 7.3619> <-4.3614, 11.2534, 7.2895>
		<-4.3571, 11.2843, 7.5628> <-4.3250, 11.2752, 7.4820> <-4.2976, 11.2423, 7.3621> <-4.3091, 11.1947, 7.2897>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5288, 11.2394, 7.4255> <-4.5350, 11.2108, 7.3772> <-4.5711, 11.1515, 7.3293> <-4.6041, 11.1089, 7.3125>
		<-4.4629, 11.2260, 7.3847> <-4.4691, 11.1974, 7.3364> <-4.5187, 11.1146, 7.2682> <-4.5517, 11.0720, 7.2515>
		<-4.3614, 11.2534, 7.2895> <-4.3733, 11.2042, 7.2147> <-4.4349, 11.1200, 7.1440> <-4.4869, 11.0531, 7.1124>
		<-4.3091, 11.1947, 7.2897> <-4.3211, 11.1454, 7.2148> <-4.3775, 11.0527, 7.1405> <-4.4295, 10.9858, 7.1090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.6041, 11.1089, 7.3125> <-4.6284, 11.0775, 7.3002> <-4.6719, 11.0386, 7.3228> <-4.7027, 11.0147, 7.3373>
		<-4.5517, 11.0720, 7.2515> <-4.5760, 11.0406, 7.2391> <-4.6371, 10.9855, 7.2580> <-4.6679, 10.9616, 7.2725>
		<-4.4869, 11.0531, 7.1124> <-4.5242, 11.0051, 7.0897> <-4.5952, 10.9454, 7.1051> <-4.6439, 10.9078, 7.1257>
		<-4.4295, 10.9858, 7.1090> <-4.4668, 10.9378, 7.0863> <-4.5379, 10.8751, 7.1006> <-4.5866, 10.8376, 7.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.7027, 11.0147, 7.3373> <-4.7655, 10.9658, 7.3669> <-4.8571, 10.8939, 7.3993> <-4.9130, 10.8685, 7.4580>
		<-4.6679, 10.9616, 7.2725> <-4.7307, 10.9127, 7.3021> <-4.8666, 10.8099, 7.3599> <-4.9225, 10.7845, 7.4186>
		<-4.6439, 10.9078, 7.1257> <-4.7525, 10.8240, 7.1716> <-4.9040, 10.7076, 7.2265> <-4.9991, 10.6643, 7.3265>
		<-4.5866, 10.8376, 7.1212> <-4.6952, 10.7538, 7.1671> <-4.8496, 10.6319, 7.2266> <-4.9446, 10.5886, 7.3267>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.9130, 10.8685, 7.4580> <-4.9630, 10.8457, 7.5107> <-5.0094, 10.8504, 7.6111> <-5.0307, 10.8652, 7.6827>
		<-4.9225, 10.7845, 7.4186> <-4.9725, 10.7617, 7.4713> <-5.0437, 10.7657, 7.6191> <-5.0651, 10.7805, 7.6906>
		<-4.9991, 10.6643, 7.3265> <-5.0842, 10.6255, 7.4162> <-5.1599, 10.6335, 7.5787> <-5.1962, 10.6587, 7.7005>
		<-4.9446, 10.5886, 7.3267> <-5.0298, 10.5498, 7.4163> <-5.1088, 10.5578, 7.5874> <-5.1452, 10.5830, 7.7092>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0307, 10.8652, 7.6827> <-5.0548, 10.8819, 7.7631> <-5.0787, 10.9176, 7.8816> <-5.0589, 10.9697, 7.9465>
		<-5.0651, 10.7805, 7.6906> <-5.0891, 10.7972, 7.7710> <-5.1190, 10.8550, 7.9452> <-5.0992, 10.9070, 8.0101>
		<-5.1962, 10.6587, 7.7005> <-5.2372, 10.6871, 7.8374> <-5.2800, 10.7520, 8.0272> <-5.2463, 10.8405, 8.1379>
		<-5.1452, 10.5830, 7.7092> <-5.1861, 10.6114, 7.8461> <-5.2269, 10.6723, 8.0479> <-5.1932, 10.7608, 8.1585>
	}
texture {jakna}
}
