/* ------------------------ CHEST.INC -----------------------*/

#ifndef(LidOpen)
	#declare LidOpen=0
#end

#declare LockTexture =
texture {
	pigment { rgb<0.95,0.96,1> }
	finish {
		metallic
		ambient 0.2
		diffuse 0.675
		brilliance 8
		reflection 0.17
		phong 0.75
		phong_size 80
	}
}

#declare BoxTexture =
texture {
	pigment {
	    wood
	    turbulence 0.075
	    scale <0.45, 0.1, 0.45>
	    color_map {
     	   [0.0, 0.1 color rgb <0.57, 0.41, 0.3>
          	        color rgb <0.57, 0.41, 0.3>]
	        [0.3, 0.6 color rgb <0.57, 0.41, 0.3>
     	             color rgb <0.67, 0.52, 0.41>]
	        [0.6, 1.0 color rgb <0.47, 0.42, 0.41>
     			color rgb <0.67, 0.62, 0.41>]
	   	}
		rotate <0,-90,0>
		}//end pigment

	finish { phong .5 phong_size 30 diffuse .55 }

	scale .25
}

#declare GreenFelt =
texture{
  pigment {color rgb <.173,.392,.184>*.9}
  normal{
    bumps 0.15
    scale 0.05
  }
  finish {crand 0.07}
}

#declare BoxShape =
union {
	superellipsoid { //main body of box...
    	<.05, .05>

	    scale <3,1.25, 2>
    	translate <0,1.25,0>
    }
	difference { //the lock assembly...
		box { //exterior of lock,
			<- 0.33,1.37,-2.2>,<0.33,2.2,-1.9>
		}
		box { //hollow it out...
			<-0.325,1.365,-2.05>,<0.325,2.15,-1.85>
		}
		cylinder { //cut the circle of the keyhole...
			<0,1.8,-2.25>,<0,1.8,-1.89>,.075
		}
		box { //cut the lower part of keyhole...
			<-.04,1.5,-2.25>,<.04,1.8,-1.89>
		}
		texture { LockTexture }
	}
	box { //the clasp of the lock...
		<-.05,2.0001,-2.201>, <.05,2.05,-1.899>
		texture { LockTexture }
	}

}

#declare Chest =
union { //the complete chest assembly...

	union { //the body of the box...

		difference {
			object { BoxShape } //the box itself...
			box { <-3.5,-.5,-2.5>, <3.5,2,2.5> inverse} //clip off the top...
			box { <-2.75,.25,-1.75>, <2.75,3,1.75>
			texture {GreenFelt}
		} //hollow the interior...

	    texture { BoxTexture }
		}

		box { //...plus the left hinge box...
			<-2.5,1.75,1.9>, <-1.5,2,2.1>
			texture { LockTexture }
		}

		box { //...plus the right hinge box...
			<1.5,1.75,1.9>, <2.5,2,2.1>
			texture { LockTexture }
		}

		cylinder { //left hinge cylinder...
			<-2.5,2,2.05>, <-1.5,2,2.05>,.1
			texture { LockTexture
				normal {
					gradient x
					slope_map {
					[ 0 <1,0> ]
					[ .32 <0,0> ]
					[ .33 <0,0> ]
					[ .33 <1,0> ]
					[ .65 <0,0> ]
					[ .66 <0,0> ]
					[ .66 <1,0> ]
					[ 1 <1,0> ]
					}
				}
			}
		}

		cylinder { //right hinge cylinder...
			<1.5,2,2.05>, <2.5,2,2.05>,.1
			texture { LockTexture
				normal {
					gradient x
					slope_map {
					[ 0 <1,0> ]
					[ .32 <0,0> ]
					[ .33 <0,0> ]
					[ .33 <1,0> ]
					[ .65 <0,0> ]
					[ .66 <0,0> ]
					[ .66 <1,0> ]
					[ 1 <1,0> ]
					}
				}
			}
		}

		difference { //the hook of the lock...
			cylinder {	<.1315,1.9,-2>,<.1315,1.9,-2.1>,.1}
			cylinder { <.032,1.95,-2.1001>,<.032,1.95,-1.999>, .1  }
			scale <1,1.025,1>
			texture { LockTexture }
		}
	}//end box body union.

	union  { //the complete lid assembly

		difference { //the lid itself...
			object { BoxShape }
			box { <-3.75, 2, -2.5>, <3.75, 3, 2.5> inverse }
			box { <-2.75, 1.9, -1.75>, <2.75, 2.25,1.75>
				texture { GreenFelt }
			}

		    texture { BoxTexture  }

		}

		box { //...plus the left hinge...
			<-2.5,2.001,1.9>, <-1.5,2.2,2.1>
			texture { LockTexture }
		}

		box { //...plus the right hinge
			<1.5,2.001,1.9>, <2.5,2.2,2.1>
			texture { LockTexture }
		}

		translate <0, -2, -2>
		rotate<LidOpen,0,0>
		translate <0, 2.01,2>

	} //end the lid assembly

	scale 1.05
} //end the complete Chest union.
