#include "colors.inc"
#include "textures.inc"

#declare SC_F=5

#declare camera_location = <0,10,-20>
#declare camera_look_at  = <0,SC_F*1.2, 0>
#declare effect_location = <0,SC_F*1.05,0>
#declare effect_always_on_top=off
#declare effect_rotate=z*180
#declare effect_scale=2
#declare effect_type="Rainbow2"
#include "Lens.inc"

camera {
   location camera_location
   look_at camera_look_at
}

#declare FogDist = 100


fog {
   fog_type 2
   distance FogDist
   color <0,0.5, 0.7>
   turbulence 3
   turb_depth 1.5
   fog_offset SC_F*0.8
   fog_alt    SC_F*0.6
}

fog {
   fog_type 2
   distance FogDist
   color <0,0.2, 0.5>
   turbulence 3
   turb_depth 1.5
   fog_offset SC_F*1.5
   fog_alt    SC_F*0.8
}

#declare TextGout=texture { 
   pigment { Yellow }
   finish {
      reflection 0.6
      diffuse 0.1
      ior 1.33 
      phong 1.0 }
}
      

/*
#declare TextGout=texture {
   pigment { rgbt <0.0,0.9,1,0.2> }
   finish {
      refraction 0.5
      reflection 0.9
      diffuse 0.1
      ior 1.33 
      phong 1.0 }
}
*/

#declare TextCreus=texture {
   TextGout
}

/*
#declare TextCreus=texture {
   pigment { rgbt <0.8,0.9,1,0.2> }
   finish {
      refraction 0.5
      reflection 0.9
      diffuse 0.1
      ior 1.5
      phong 1.0 }
}
*/

#declare TextMer=texture {
  pigment { rgb <0.3,0.2,0.5> }
   finish {
      refraction 0.0
      reflection 0.9
      diffuse 0.5
      ior 1.33 
      phong 1.0 }
}



sky_sphere {
   pigment {
      gradient <1,1,0>
      color_map {
	 [0   color rgb <0,0,0> ]
	 [0.4 color rgb <0,0,0> ]
	 [0.5 color rgb <0,0,1> ]
	 [0.6 color rgb <0,0.8,1> ]
	 [0.7 color rgb <1,1,1> ]
	 [0.8 color rgb <0,0.8,1> ]
	 [0.9 color rgb <0,0,1> ]
	 [1   color rgb <0,0,0> ]
      }
      turbulence <0.5,1,0.1>
      scale 2
   }
}


light_source { <130,220, -180> color White atmosphere on }
light_source { <130,220, 180> color White atmosphere on  }


isosurface {
   box < -100, -1, -100>, <100, 1, 100>
   function { "BumpBox", <0.075, 0.02>, library "fonc.so" }
   eval
   max_gradient 1.0
   translate y*-0.5
   scale SC_F
   texture { TextMer
      normal { ripples 0.1 scale 10 }
   }
}

intersection {
   isosurface {
      box <-1.21,0.001,-1.21>, <1.21,1,1.21>
      function { "Parabole", <1>, library "fonc.so" }
      max_gradient 2.90
      eval
      
   }
   
   sphere { <0,0.5, 0>, 1.3 }
   
   texture { TextCreus }
   
   rotate y*20
   
   scale SC_F	
}




/* 1 */

isosurface {
   function { "BumpSph", <0.7,0.07,0.05>, library "fonc.so" }
   
   max_gradient 2.0
   eval
   texture { TextGout }
     
   scale SC_F/2
   translate <-5.0, SC_F*2.3, -1>
   
}



/* 2 */
isosurface {  
   function { "BumpSph", <0.8, 0.05,0.05>, library "fonc.so" }
   max_gradient 10
   eval
   texture { TextGout }
   scale <1,0.5, 0.66>*SC_F/2
   rotate y*30
   rotate z*30
   rotate x*30
   translate <-4.5, SC_F*1.5, 3>  
}

/* 3 */

isosurface {
   function { "BumpSph", <0.75, 0.035, 0.05>, library "fonc.so" }
   max_gradient 4
   eval
   rotate z*30
   rotate x*20
   texture { TextGout }
   scale SC_F/2
   translate <0,SC_F*2.0,0>
}

/* 4 */

isosurface {
   function { "BumpSph", <0.5, 0.1, 0.5>, library "fonc.so" }
   
   max_gradient 40
   eval
   texture { TextGout }
   
   scale <0.75,1,0.25>
   scale SC_F/2	
   
   rotate z*25
   rotate -x*30
   rotate -y*30
   
   translate <1.5, SC_F*1.2, -4>
   
}

/* 5 */

isosurface {
   function { "BumpSph", <0.75, 0.06,0.15>, library "fonc.so" }
   max_gradient 25
   eval
   texture { TextGout }
      
   rotate x*115
   rotate -z*10
   scale <0.5,0.5,0.5>
   scale SC_F/2	
   translate <3.5, SC_F*2.7, -1>
   
}

/* 6 */ 

isosurface {
   function { "BumpSph", <0.7,0.5,0.005>, library "fonc.so" }
   
   max_gradient 1.5
   eval
   texture { TextGout }
     
   scale SC_F/2
   translate <5.0, SC_F*1.75, -1>
   
}



