#define DLL
#include "isofunc.h"

#define MakeSphCoord(R,T,P) \
	R=sqrt(x*x + y*y + z*z); \
	T=atan(x/z); \
	P=acos(y/R);

FUNC BumpBox(FUNCTION * Func, VECTOR XYZ) {
  /* P0 : Frequence			*/
  /* P1 : Profondeur			*/
  
  /* Renvoi une demi boite (de -1 a 0) */
  /* dont la surface 0 est de traviole */
  
  DBL Pert;
  
  Pert = (sin(x/P0/M_PI) + sin(z/P0/M_PI))/2 * P1;

  /* printf("%lf, %lf -> %lf\n",x, z, Pert); */

  return Pert + y;
}

FUNC BumpSph(FUNCTION * Func, VECTOR XYZ) {
  /* P0 : Diametre de la sphere					*/
  /* P1 : "Frequence" de la perturabation				*/
  /* P2 : Profodeur de la perturbation				*/

  DBL Rho;	/* Distance du point XYZ au centre */
  DBL Pert;	/* Difference de perturbation      */
  DBL Theta;	/* Angle Theta			*/
  DBL Phi;	/* Angle Phi				*/
  DBL AngDist;  /* Distance Angulaire		*/

  MakeSphCoord(Rho, Theta, Phi);

  Pert = (cos(Theta/P1/M_PI) + cos(Phi/P1/M_PI))/2 * P2;

  return (Rho + Pert - P0);
}

FUNC Goutte(FUNCTION * Func, VECTOR XYZ) {
  /* P0 : Diametre de base de la "goute"                   */
  /* P1 : Perturbation                                     */
  /* P2 : Frenquence de Perturbation                       */

  DBL r;
  DBL r2;
  DBL a;
  DBL b;
  DBL EPSILON=0.01;

  r = sqrt( x*x + z*z + y*y );

  if ( y > 0 ) a =  acos(x/r);
  else         a = -acos(x/r);
  if ( z > 0 ) b =  acos(y/r);
  else         b = -acos(y/r);
  
  r2 = P0 + cos(a*P2)*cos(b*P3)*P1;
  return r - r2;

}

FUNC Parabole(FUNCTION * Func, VECTOR XYZ) {

  DBL r;
  DBL r2;

  r=sqrt( x*x + z*z );

  return (y+1)/2 - r*r;
}
