// Persistence of Vision Ray Tracer Scene Description File
// File: fly_book.pov
// Vers: 3.02 Watcom Win32
// Desc: Grimoire Flying Away
// Date: August 17, 1997
// Auth: Sonya Roberts
// Note: 

object {
	union {
		union {								// Book cover
			difference {						// Spine
				cylinder {<0,0,-1>,<0,0,1>,.25}
				cylinder {<0,0,-1.1>,<0,0,1.1>,.225}
				box {<-.2,-.3,-1.11>,<.2,-.1,1.11>}
			}
			difference {
				union {						// Gilt Rings Along Spine
					torus {
						.25,.05
						rotate x*90
						translate <0,0,-.75>
					}
					torus {
						.25,.05
						rotate x*90
						translate <0,0,-.5>
					}
					torus {
						.25,.05
						rotate x*90
						translate <0,0,.75>
					}
					torus {
						.25,.05
						rotate x*90
						translate <0,0,.5>
					}
					texture {T_Copper_4C}
				}
				box {<-.2,-.3,-1.11>,<.2,-.1,1.11>}
			}
			box {<-1.5,-.025,-1>,<0,.025,1>	translate <-.25,0,0>	rotate z*30}
			box {<1.5,-.025,-1>,<0,.025,1>	translate <.25,0,0>	rotate z*-30}
			box {							// Text on Cover
				<0,0,0>,<1,1,-.01>
				texture {
					material_map {
						gif "fly_book.gif"
						texture {pigment {color Clear}}
						texture {T_Gold_4C}
					}
				}
				translate <0,-.5,0>
				rotate x*90
				scale <1.5,1,2>
				translate <.25,.025,0>
				rotate z*-30
			}
			texture {pigment {color Scarlet}}
			scale <1,.75,1>
		}
		union {								// Pages
			#declare X1=-.18
			#while (X1<=.18)
				union {
					box {<-.005,-1.3,-.9>,<.005,0,.9>	pigment {color White}	finish {ambient .2}}
					box {<-.005,-1.31,-.91>,<.005,0,-.9>	texture {T_Brass_4C}}
					box {<-.005,-1.31,.91>,<.005,0,.9>	texture {T_Brass_4C}}
					box {<-.005,-1.31,-.9>,<-.005,-1.3,.9>	texture {T_Brass_4C}}
					rotate z*(300*X1)
					translate <X1,-.1,0>
				}
				#declare X1=X1+.02
			#end
		}
	}
	rotate z*-17
	rotate x*12
	rotate y*40
	translate <-2,7,-6>
}
