// Persistence of Vision Ray Tracer Scene Description File
// File: furnish.pov
// Vers: 3.01 Watcom Win32
// Desc: Furnishings for Library
// Date: August 14, 1997
// Auth: Sonya Roberts
// Note:

#declare FR=seed(57)

#if (I_Desk)
	#declare Leg=
	object {
		#declare bflc=<-.05,0,-.05>
		#declare bbrc=<.05,0,.05>
		#declare tflc=<-.1,.75,-.1>
		#declare tbrc=<.1,.75,.1>
		union {
			#include "pyr_cube.inc"
			box {<-.1,.75,-.1>,<.1,3,.1>}
		}
	}

	object {
		union {
			union {
				object {Leg	translate <-1.25,0,-2.75>}
				object {Leg	translate <1.25,0,-2.75>}
				object {Leg	translate <-1.25,0,2.75>}
				object {Leg	translate <1.25,0,2.75>}
				texture {T_Wood30	rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>}
			}
			box {<-1.5,3,-3>,<1.5,3.25,3>		texture {T_Wood30	rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>}}
			box {<-1.25,1,-2.75>,<1.25,3,2.75>	texture {T_Wood30	rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>}}
		}
		translate <-6.75,0,-3.25>
	}
#end

#if (I_DontFeed)
	object {
		union {
			box {							// Sign
				<0,0,0>,<1,1,-.0075>
				pigment {
					image_map {
						gif "dontfeed.gif"
					}
				}
				finish {
					ambient .3
				}
				scale <2.25,1.6875,1>
			}
			box {							// Scotch Tape
				<-.05,-.325,-.01>,<.05,.35,0>
				rotate z*-40
				translate <.1,1.5,0>
				texture {T_Yellow_Glass}
			}
			box {
				<-.05,-.425,-.01>,<.05,.3,0>
				rotate z*30
				translate <2.175,1.55,0>
				texture {T_Yellow_Glass}
			}
		}
		translate <-4.5,4.25,10>
	}
#end

#if (I_Enter)
	#declare QArc=
	object {
		union {
			intersection {
				torus {.5,.05}
				box {<-.7,-.1,0>,<0,.1,.7>}
				translate <.55,0,0>
				rotate x*-90
			}
			intersection {
				torus {.25,.05}
				box {<-.35,-.1,0>,<0,.1,.35>}
				translate <.3,0,0>
				rotate x*-90
			}
			intersection {
				torus {.25,.05}
				box {<-.35,-.1,0>,<0,.1,.35>}
				translate <.3,0,0>
				rotate x*90
			}
			intersection {
				torus {.125,.05}
				box {<.2,-.1,0>,<0,.1,.2>}
				translate <.3,0,.125>
				rotate x*90
			}
		}
	}

	object {
		union {
			union {								// Base and Pole
				difference {
					sphere {<0,-1,0>,1.25}
					box {<-2,0,-2>,<2,-2.26,2>	pigment {color PaleGreen} finish {crand .2}}
				}
				cylinder {<0,0,0>,<0,3,0>,.075}
				texture {T_Brass_3A}
			}
			union {								// Area for Sign
				difference {
					box {<-.85,3,-.1>,<.85,4.5,.1>}
					box {<-.75,3.1,-.11>,<.75,4.4,0>}
				}
				union {							// Decoration Around Pole
					sphere {<-.175,2.9,0>,.1}
					sphere {<.175,2.9,0>,.1}
					texture {T_Gold_4C}
				}
				object {QArc			translate <.075,2.45,0>}
				object {QArc	rotate y*180	translate <-.075,2.45,0>}
				union {
					sphere {<-.175,4.6,0>,.1}			// Decoration on Top
					sphere {<0,0,0>,.075	scale <1,2,1>	translate <0,4.65,0>}
					sphere {<.175,4.6,0>,.1}
					texture {T_Gold_4C}
				}
				texture {T_Brass_5B}
			}
			box {
				<0,0,0>,<1,1,-.025>					// Sign
				pigment {
					image_map {
						gif "enter.gif"
					}
				}
				finish {ambient .3}
				scale <1.5,1.3,1>
				translate <-.75,3.1,0>
			}
		}
		rotate y*-10
		rotate x*30
		rotate z*-10
		translate <5.5,1,-3>
	}
#end

#if (I_BookShelves)
	union {
		#declare X1=-19.25
		#declare Odd=True
		#while (X1<10)
			#debug str(X1,0,1)
			#debug " - "
			union {
				#declare Z1=12
				#while (Z1<=42)
					#debug str(Z1,0,0)
					#debug " "
					union {
						union {						// Sides
							box {<-2,0,-.75>,<-1.9,8,.75>}
							box {<2,0,-.75>,<1.9,8,.75>}
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
						}
						box {						// Top
							<-1.9,7.9,-.75>,<1.9,8,.75>
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
						}
						box {						// Base
							<-1.9,0,-.7>,<1.9,.45,.75>
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
						}
						box {						// Back
							<-1.9,.45,.7>,<1.9,7.9,.75>
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
						}
						union {						// Shelves
							#declare RowLength=3.5
							#declare RowHeight=1.25
							#declare RowDepth=1
							#declare StackStyle=0
							#declare Y1=1
							#while (Y1<=5)
								union {
									box {
										<-1.9,.45+((Y1-1)*1.5),-.745>,<1.9,.5+((Y1-1)*1.5),.75>
										texture {
											T_Wood7
											scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
											rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
										}
									}
									#if (Detailed)
										object {
											#declare NumBooks=10+int(rand(FR)*10)
											#declare ExactLength=int(rand(FR)*1.9999)
											#if (rand(FR)<.1)
												#declare VariColours=False
											     #else
											     	#declare VariColours=True
											#end
											#if (VariColours)
												#declare VariHeight=.1
												#declare VariDepth=.1
											     #else
												#declare VarHeight=0
												#declare VariDepth=0
											#end
											#include "books.inc"
											translate <-1.9,.45+((Y1-1)*1.5),-.35>
										}
									     #else
									     	sphere {
											<-1.9,.45+((Y1-1)*1.5),-.25>,.01
											pigment {color Clear}
										}
									#end
								}
								#declare Y1=Y1+1
							#end
						}
						#if (Odd)
							rotate y*-(88+(rand(FR)*4))
						     #else
							rotate y*(88+(rand(FR)*4))
						#end
						translate <X1,0,Z1>
					}
					#declare Z1=Z1+4
				#end
			}
			#if (Odd)
				#declare X1=X1+6.8
				#declare Odd=False
			     #else
				#declare X1=X1+1.5
				#declare Odd=True
			#end
			#debug "\n"
		#end
	}

	#if (Detailed)
		union {
			#declare X1=-19.25
			#declare Odd=True
			#while (X1<20)
				#debug str(X1,0,1)
				#debug " - "
				union {
					#declare Z1=58
					#while (Z1<=92)
						#debug str(Z1,0,0)
						#debug " "
						box {
							<-2,0,-.75>,<2,8,.75>
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
							#if (Odd)
								rotate y*-(88+(rand(FR)*4))
							     #else
								rotate y*(88+(rand(FR)*4))
							#end
							translate <X1,0,Z1>
						}
						#declare Z1=Z1+4
					#end
				}
				#if (Odd)
					#declare X1=X1+6.8
					#declare Odd=False
				     #else
					#declare X1=X1+1.5
					#declare Odd=True
				#end
				#debug "\n"
			#end
		}

		union {
			#declare X1=-19.25
			#declare Odd=True
			#while (X1<=20)
				#debug str(X1,0,1)
				#debug " - "
				union {
					#declare Z1=108
					#while (Z1<=142)
						#debug str(Z1,0,0)
						#debug " "
						box {
							<-2,0,-.75>,<2,8,.75>
							texture {
								T_Wood7
								scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
								rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
							}
							#if (Odd)
								rotate y*-(88+(rand(FR)*4))
							     #else
								rotate y*(88+(rand(FR)*4))
							#end
							translate <X1,0,Z1>
						}
						#declare Z1=Z1+4
					#end
				}
				#if (Odd)
					#declare X1=X1+6.8
					#declare Odd=False
				     #else
					#declare X1=X1+1.5
					#declare Odd=True
				#end
				#debug "\n"
			#end
		}

		union {
			#declare X1=-16
			#declare Odd=True
			#while (X1<16)
				#debug str(X1,0,1)
				#debug ",  "
				box {
					<-2,0,-.75>,<2,8,.75>
					texture {
						T_Wood7
						scale <.25+(rand(FR)*2),.25+(rand(FR)*2),.25+(rand(FR)*2)>
						rotate <rand(FR)*360,rand(FR)*360,rand(FR)*360>
					}
					translate <X1,0,149.25>
				}
				#declare X1=X1+4
			#end
			#debug "\n"
		}
	#end
#end

#if (I_ExLibris)
	#declare Post=
	object {
		union {
			cone {<0,.65,0>,.025,<0,.1,-.125>,.075}
			cone {<0,-.65,0>,.025,<0,-.1,-.125>,.075}
			difference {
				union {
					sphere {<0,.025,0>,.075}
					sphere {<0,-.05,0>,.05}
				}
				union {
					sphere {<0,.025,0>,.073}
					sphere {<0,-.05,0>,.048}
					texture {T_Chrome_2D}
				}
				sphere {<0,0,0>,.0225	scale <1,1.25,2>	translate <-.025,.025,-.05>}
				sphere {<0,0,0>,.0225	scale <1,1.25,2>	translate <.025,.025,-.05>}
				sphere {<0,0,0>,.0225	scale <2,.75,2>		translate <0,-.025,-.03>}
				scale <1.25,1.25,1.25>
				translate <0,0,-.125>
				texture {T_Silver_4C}
			}
		}
	}

	#declare HourGlass=
	object {
		union {
			difference {
				blob {
					threshold .65
					cylinder {<0,.35,0>,<0,.45,0>,.6,.5}
					sphere {<0,.25,0>,.5,.9}
					sphere {<0,0,0>,.4,-.75}
					sphere {<0,-.25,0>,.5,.9}
					cylinder {<0,-.35,0>,<0,-.45,0>,.6,.5}
				}
				blob {
					threshold .65
					cylinder {<0,.35,0>,<0,.45,0>,.6,.5}
					sphere {<0,.25,0>,.5,.9}
					sphere {<0,0,0>,.4,-.75}
					sphere {<0,-.25,0>,.5,.9}
					cylinder {<0,-.35,0>,<0,-.45,0>,.6,.5}
					scale <.9,1,.9>
				}
			}
			intersection {
				blob {
					threshold .65
					cylinder {<0,.35,0>,<0,.45,0>,.6,.5}
					sphere {<0,.25,0>,.5,.9}
					sphere {<0,0,0>,.4,-.75}
					sphere {<0,-.25,0>,.5,.9}
					cylinder {<0,-.35,0>,<0,-.45,0>,.6,.5}
					scale <.899,1,.899>
				}
				union {
					cone {<0,-.65,0>,.4,<0,-.3,0>,.015}
					cylinder {<0,-.3,0>,<0,0,0>,.015}
					cone {<0,0,0>,.2,<0,.25,0>,.05}
				}
				pigment {color MediumGoldenrod*1.25}
				finish {
					ambient .25
					crand .3
				}
			}
		}
		scale <1.25,1,1.25>
		texture {T_Glass3}
	}

	object 	{
		union {
			intersection {
				cylinder {<0,0,-.5>,<0,0,0>,1.5}
				sphere {<0,0,4>,4.25}
				texture {
					material_map {
						gif "exlibris.gif"
						texture {CreamMarble	scale <.1,.1,.1>}
						texture {T_Brass_3B}
					}
					translate <-.5,-.5,0>
					scale <2.875,2.875,1>
				}
			}
			union {
				torus {1.5,.05	rotate x*90}
				torus {1,.05	rotate x*90	translate <0,0,-.125>}
				texture {T_Gold_4C}
			}
			union {
				cylinder {<0,.6,0>,<0,.7,0>,.4}
				cylinder {<0,-.6,0>,<0,-.7,0>,.4}
				object {Post	translate <0,0,-.35>	rotate y*45}
				object {Post	translate <0,0,-.35>	rotate y*-45}
				object {HourGlass}
				texture {T_Chrome_2B}
				translate <0,0,-.25>
			}
		}
		scale <2,2,2>
		translate <-9.5,7.5,0>
	}
#end
