// Persistence of Vision Ray Tracer Scene Description File
// File: library.pov
// Vers: 3.01 Watcom Win32
// Desc: Library - Walls and
// Date: August 13, 1997
// Auth: Sonya Roberts
// Note:

#declare WindowShape=
object {
	intersection {
		union {
			box {<-1.6,-.1,-1.1>,<2.5,4,1.1>}
			cylinder {<.5,4,-1>,<.5,4,1>,2}
		}
		union {
			box {<1.6,-.1,-1.1>,<-2.5,4,1.1>}
			cylinder {<-.5,4,-1>,<-.5,4,1>,2}
		}
		box {<-1.5,0,-1>,<1.5,6,1>}
	}
}

#declare WindowGlass=
object {
	box{<0,0,-.02>,<1,1,.02>}
	texture {
		pigment {
			image_map {
				gif "window.gif"
				filter 0,1
				filter 1,0
			}
		}
	}
	translate <-.5,0,0>
	scale <3,6,1>
}

#declare Walls=
object {
	union {
		difference {
			union {
				difference {
					box {<-21,-1,-15.5>,<51,20,151>}	// Overall Shape
					box {<-15,-.1,-15>,<50,12.1,0>}		// Hallway
					box {<-20.1,-.1,1>,<20,14.1,150.1>}	// Library
				}
				difference {
					box {<-15,-.1,-15>,<50,4,0>}		// Wainscoting
					box {<-14.9,.5,-14.9>,<49.9,4.1,-.1>}
					box {<-14.85,-.11,-14.85>,<49.85,.51,-.15>}
					sphere {<-14.9,4,-.1>,.075}
					sphere {<-14.9,4,-14.9>,.075}
					sphere {<49.9,4,-.1>,.075}
					sphere {<49.9,4,-14.9>,.075}
					cylinder {<-14.9,4,-.1>,<-14.9,4,-14.9>,.075}
					cylinder {<-14.9,4,-.1>,<49.9,4,-.1>,.075}
					cylinder {<49.9,4,-14.9>,<49.9,4,-.1>,.075}
					cylinder {<49.9,4,-14.9>,<-14.9,4,-14.9>,.075}
					union {
						#declare X1=-14
						#while (X1<=49)
							difference {
								box {<X1-.25,.75,-.11>,<X1+.25,3.75,-.075>}
								box {<X1-.15,.85,-.12>,<X1+.15,3.65,-.074>}
							}
							#declare X1=X1+1
						#end
					}
					union {
						#declare X1=-14
						#while (X1<=49)
							difference {
								box {<X1-.25,.75,-49.925>,<X1+.25,3.75,-49.89>}
								box {<X1-.15,.85,-49.926>,<X1+.15,3.65,-49.88>}
							}
							#declare X1=X1+1
						#end
					}
					union {
						#declare Z1=-14
						#while (Z1<=-1)
							difference {
								box {<-19.925,.75,Z1-.25>,<-19.89,3.75,Z1+.25>}
								box {<-19.926,.85,Z1-.15>,<-19.88,3.65,Z1+.15>}
							}
							#declare Z1=Z1+1
						#end
					}
					texture {DarkStone}
				}
			}
			box {<-5,-1.1,-.5>,<5,7,1.1>}				// Archway
			cylinder {<0,0,-.5>,<0,0,1.1>,5	scale <1,.5,1>	translate <0,7,0>}
			cylinder {<0,0,-.5>,<0,0,.5>,.2	scale <1,2,1>	translate <-5,0,0>}	// Mousehole for Ants
			object {WindowShape	translate <-10,2,-15.5>}
			object {WindowShape	translate <-5,2,-15.5>}
			object {WindowShape	translate <-0,2,-15.5>}
			object {WindowShape	translate <5,2,-15.5>}
			object {WindowShape	translate <10,2,-15.5>}
			object {WindowShape	translate <15,2,-15.5>}
		}
		box {								// Ceiling in Library
			<-20,14,1>,<20,14.1,150>
			pigment {color Gray50}
			finish {Mirror}
		}
		box {								// Side Wall in Library
			<-20.1,0,1>,<-20,17,150>
			pigment {color Gray50}
			finish {Mirror}
		}
		box {								// End Wall in Library
			<-20.1,0,100>,<20,17.1,150.1>
			pigment {color Black}
		}
		box {<-20,12,-16>,<20,12.1,0>	texture {T_Stone5	finish {ambient .4}}}	// Ceiling in Hallway
		object {WindowGlass	translate <-10,2,-15.25>}		// Windows
		object {WindowGlass	translate <-5,2,-15.25>}
		object {WindowGlass	translate <-0,2,-15.25>}
		object {WindowGlass	translate <5,2,-15.25>}
		object {WindowGlass	translate <10,2,-15.25>}
		object {WindowGlass	translate <15,2,-15.25>}
	}
	texture {
		brick
		texture {
			pigment {color Wheat}
			normal {
				brick
				brick_size <2,1,2>
				mortar .1
			}
			finish {
				ambient .3
			}
		}
		texture {TanMarble finish {reflection 0}	scale <.5,.5,.5>}
		brick_size <2,1,2>
		mortar .1
	}
}


#declare CapStone=
object {
	difference {
		union {
			box {<-1.5,-1.25,-.5>,<1.5,1.25,0>}
			height_field {
				gif "unseen.gif"
				translate <-.5,0,-.5>
				rotate x*-90
				scale <3,2.5,.1>*.9
				translate <0,0,-.5>
			}
		}
		difference {
			box {<-1.4,-1.15,-.55>,<1.4,1.15,-.25>}
			box {<-1.35,-1.1,-.56>,<1.35,1.1,0>}
		}
	}
	texture {T_Brass_3A}
}

#declare Ornament1=
object {
	union {
		sphere {<-2,.25,0>,.5		scale <1,1,.5>	texture {BlueAgate	scale <.25,.25,.25>}}
		torus {.55,.05	rotate x*-90	translate <-2,.25,0>}
		union {
			#declare Z1=-30
			#while (Z1<=30)
				cylinder {
					<-.55,0,0>,<-(3-(abs(Z1)/15)),0,0>,.05
					rotate z*Z1
				}
				#declare Z1=Z1+10
			#end
			rotate z*25
			translate <-2,.25,0>
		}
		sphere {<2,.25,0>,.5		scale <1,1,.5>	texture {BlueAgate	scale <.25,.25,.25>}}
		torus {.55,.05	rotate x*-90	translate <2,.25,0>}
		union {
			#declare Z1=-30
			#while (Z1<=30)
				cylinder {
					<.55,0,0>,<3-(abs(Z1)/15),0,0>,.05
					rotate z*Z1
				}
				#declare Z1=Z1+10
			#end
			rotate z*-25
			translate <2,.25,0>
		}
	}
	texture {T_Gold_4C}
	translate <0,10,0>
}

#declare AGroove=
object {
	union {
		sphere {<0,1.75,0>,.1}
		cylinder {<0,1.75,0>,<0,5.75,0>,.1}
		sphere {<0,5.75,0>,.1}
	}
	scale <1,1,.75>
}

#declare Circ=
object {
	union {
		sphere {<0,0,0>,.15}
		torus {.35, .1}
	}
	rotate x*90
	scale <1,1,.5>
}

#declare Arch=
object {
	union {
		difference {
			union {
				box {<-5.4,-1,-.2>,<5.4,7,1.2>}
				cylinder {<0,0,-.2>,<0,0,1.2>,5.4	scale <1,.5,1>	translate <0,7,0>}
			}
			union {
				box {<-4.6,-1.1,-.21>,<4.6,7,1.21>}
				cylinder {<0,0,-.21>,<0,0,1.21>,4.6	scale <1,.5,1>	translate <0,7,0>}
			}
			cylinder {<0,0,-.3>,<0,0,-0.01>,.2	scale <1,2,1>	translate <-5,0,0>	pigment {color Black}}
			object {AGroove translate <-5.25,0,-.2>}
			object {AGroove translate <-5,0,-.2>}
			object {AGroove translate <-4.75,0,-.2>}
			object {AGroove translate <5.25,0,-.2>}
			object {AGroove translate <5,0,-.2>}
			object {AGroove translate <4.75,0,-.2>}
		}
		difference {
			box {<-5.5,0,-.25>,<-4.5,1.5,1.25>}
			box {<-5.4,.5,-.26>,<-.46,1.4,-.2>}
			box {<-4.55,.5,-.24>,<-4.4,1.4,1.15>}
			cylinder {<0,0,-.3>,<0,0,-0.01>,.2	scale <1,2,1>	translate <-5,0,0>}
		}
		difference {
			box {<5.5,0,-.25>,<4.5,1.5,1.25>}
			box {<5.4,.5,-.26>,<.46,1.4,-.2>}
			box {<4.55,.5,-.24>,<4.4,1.4,1.15>}
		}
		union {
			box {<-5.5,6,-.25>,<-4.5,7,1.25>}
			object {Circ	translate <-5,6.5,-.25>}
			object {Circ	rotate y*90	translate <-4.5,6.5,.5>}
			object {Circ	translate <-5,6.5,1.25>}
		}
		union {
			box {<5.5,6,-.25>,<4.5,7,1.25>}
			object {Circ	translate <5,6.5,-.25>}
			object {Circ	rotate y*90	translate <4.5,6.5,.5>}
			object {Circ	translate <5,6.5,1.25>}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.1,1,1.1>
			translate <-5,1.5,.5>
			texture {T_Gold_4C}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.05,1,1.05>
			translate <5,1.5,.5>
			texture {T_Gold_4C}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.1,1,1.1>
			translate <-5,6,.5>
			texture {T_Gold_4C}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.05,1,1.05>
			translate <5,6,.5>
			texture {T_Gold_4C}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.1,1,1.1>
			translate <-5,7,.5>
			texture {T_Gold_4C}
		}
		superellipsoid {
			<.3,.3>
			scale <.5,.05,.75>
			scale <1.05,1,1.05>
			translate <5,7,.5>
			texture {T_Gold_4C}
		}
		object {CapStone	translate <0,10,0>}
		object {Ornament1}
	}
	texture {MalachitePolished	scale <.5,.5,.5>}
}

#declare Floor=
object {
	union {
		difference {
			box {<-20,-.1,-30>,<20,0,2>}			// Main Floor
			box {<-19,-.11,-14>,<49,.1,-1>}			// Minus Everything Except Edge
			texture {T_Stone21	finish {reflection .25}}
		}
		difference {
			union {						// Edging Strips
				difference {
					box {<-19,-.1,-14>,<49,0,-1>}
					box {<-17,-.11,-12>,<47,.1,-3>}
				}
				box {<-20,-.1,2>,<20,0,2.25>}
				box {<-20,-.1,3.75>,<20,0,4>}
			}
			difference {					// Minus Smaller Strips
				box {<-18.75,-.11,-13.75>,<48.75,.1,-1.25>}
				box {<-17.25,-.12,-11.75>,<47.25,.11,-2.75>}
			}
			texture {T_Gold_4C}
		}
		union {
			difference {					// Smaller Strips
				box {<-18.75,-.1,-13.75>,<48.75,0,-1.25>}
				box {<-17.25,-.12,-11.75>,<47.25,.11,-2.75>}
			}
			box {<-20,-.1,2.25>,<20,0,3.75>}
			texture {
				checker
				texture {T_Stone15	finish {reflection .25}}
				texture {T_Stone10	finish {reflection .25}}
				scale <.25,.25,.25>
			}
		}
		union {							// Center Portions
			box {<-17,-.1,-12>,<47,0,-3>}
			box {<-20,-.1,4>,<20,0,150>}
			texture {
				checker
				texture {T_Stone23	finish {reflection .25}}
				texture {T_Stone24	finish {reflection .25}}
			}
		}
	}
}

#declare Column=
object {
     union {
     	difference {
		cylinder {<0,0,0>,<0,10.75,0>,.5}
		#declare Grooves=1
		#while (Grooves<=15)
			union {
				sphere {<0,.2,0>,.075}
				cylinder {<0,.2,0>,<0,10.55,0>,.075}
				sphere {<0,10.55,0>,.075}
				translate <0,0,.5>
				rotate y*((360/15)*Grooves)
			}
			#declare Grooves=Grooves+1
		#end
		translate <0,.25,0>
	}
	union {
		cylinder {<0,0,0>,<0,.125,0>,.7}
		cylinder {<0,0,0>,<0,.25,0>,.6}
		union {
			torus {.7,.08}
			torus {.6,.08	translate <0,.125,0>}
			texture {T_Gold_4C}
		}
	}
	union {
		intersection {
			sphere {<0,.5,0>,.7}
			box {<-.6,0,-.6>,<.6,.5,.6>}
		}
		box {<-.6,.5,-.6>,<.6,1,.6>}
		torus {.55,.05	texture {T_Gold_4C}}
		translate <0,11,0>
	}
     }
     scale <1.5,1,1.5>
}

#declare Pilaster=
object {
	union {
		difference {
			box {<-1,0,-.3>,<1,2,0>}
			box {<-.8,.25,-.31>,<.8,1.8,-.25>}
		}
		difference {
			box {<-.8,1,-.2>,<.8,12,0>}
			#declare X1=-.6
			#while (X1<=.6)
				sphere {<X1,1.25,-.25>,.1}
				cylinder {<X1,1.25,-.25>,<X1,12.1,-.25>,.1}
				#declare X1=X1+.3
			#end
		}
		union {
			cylinder {<-.85,2.025,0>,<-.85,2.025,-.25>,.05}
			cylinder {<.85,2.025,0>,<.85,2.025,-.25>,.05}
			cylinder {<.85,2.025,-.25>,<-.85,2.025,-.25>,.05}
			sphere {<.85,2.025,-.25>,.05}
			sphere {<-.85,2.025,-.25>,.05}
			texture {T_Gold_4C}
		}
	}
}

object {Walls}
object {Arch}
object {Floor}
object {Column	translate <-13.75,0,-1.25>     texture {MalachitePolished	scale <.5,.5,.5>}}
object {Column	translate <-13.75,0,-13.75>     texture {MalachitePolished	scale <.5,.5,.5>}}
