// Persistence of Vision Ray Tracer Scene Description File
// File: rincewnd.pov
// Vers: 3.02 Watcom Win32
// Desc: Rincewind the Wizard
// Date: August 18, 1997
// Auth: Sonya Roberts
// Note: Modifed starting from cohen.pov

#declare RWEye=
object {
	union {
		sphere {<0,0,0>,.075	scale <1.25,1,.95>	texture {T_Glass3}}
		difference {
			union {
				difference {
					sphere {<0,0,0>,.074}
					sphere {<0,0,0>,.0739}
					pigment {color White}
					finish {ambient .3}
				}
				difference {
					sphere {<0,0,0>,.07391}
					sphere {<0,0,0>,.071}
					pigment {color PaleGreen}
				}
				sphere {<0,0,0>,.0711	pigment {color Black}}
				scale <1.25,1,.95>
			}
			sphere {<0,0,0>,.0725	scale <1,1,.75>	translate <0,0,-.075>}
		}
	}
	rotate x*5
}

#if (Detailed)
	#declare RWHair=
	object {
		#declare HR=seed(5)
		#declare X1=1
		union {
			#while (X1<=230)
				#debug str(X1,0,1)
				#debug " - "
				#declare Y1=1
				union {
					#while (Y1<=26)
						#debug str(Y1,0,0)
						#debug " "
						#declare HPercent=.05+((abs(115-X1)/57.5)/(1+(Y1*.05)))
						#if (rand(HR)<=HPercent)
							union {
								#declare HStart=<0,0,0>
								#declare HSegment=1
								#while (HSegment<=5)
									#declare HFx=HStart.x-(rand(HR)*(.2/HSegment))
									#declare HFy=HStart.y-(rand(HR)*(.07*HSegment))
									#declare HFz=HStart.z+(-.05+(rand(HR)*.1))
									cylinder {
										HStart,<HFx,HFy,HFz>,.015
										pigment {color rgb <.65+((.05/5)*HSegment),.49+((.15/5)*HSegment),.24+((.21/5)*HSegment)>}
									}
									#declare HStart=<HFx,HFy,HFz>
									#declare HSegment=HSegment+1
								#end
								translate <-.4,-.5+(Y1*.032),0>
								rotate y*(-25+X1)
							}
						#end
						#declare Y1=Y1+1.5
					#end
				}
				#declare X1=X1+5
				#debug "\n"
			#end
		}
	}

	#declare RWEyebrow=
	object {
		#declare HR=seed(6)
		#declare X1=0
		union {
			#while (X1<=.2)
				#debug str(X1,0,1)
				#debug " - "
				#declare Z1=0
				union {
					#while (Z1<=.1)
						#debug str(Z1,0,2)
						#debug " "
						union {
							#declare HStart=<0,0,0>
							#declare HSegment=1
							#while (HSegment<=3)
								#declare HFx=HStart.x+(.01+(rand(HR)*(X1/3)))
								#declare HFy=HStart.y-(rand(HR)*.025)
								#declare HFz=HStart.z+(-.01+(rand(HR)*.02))
								cylinder {
									HStart,<HFx,HFy,HFz>,.0075
									pigment {color rgb <.65+((.05/3)*HSegment),.49+((.15/3)*HSegment),.24+((.21/3)*HSegment)>}
								}
								#declare HStart=<HFx,HFy,HFz>
								#declare HSegment=HSegment+1
							#end
							translate <X1,0,Z1>
						}
						#declare Z1=Z1+.05
					#end
				}
				#declare X1=X1+.05
				#debug "\n"
			#end
		}
	}
#end

#declare RWHandR=
object {
	blob {
		threshold .65
		sphere {<-.23,-.32,0>,.43,1	scale <1.95,1.05,.8>}	// Palm
		sphere {<.12,-.41,0>,.43,1	scale <1.95,1.075,.8>}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<-.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>}	// Middle of hand
		sphere {<.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>}
		sphere {<-.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>}	// Heel of hand
		sphere {<.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>}
		cylinder {<-.65,-.28,0>,<-.7,.28,-.075>,.26,1}		// Pinky Finger
		sphere {<-.7,.28,-.075>,.26,-.75}
		cylinder {<-.7,.28,-.075>,<-.75,.68,-.3>,.26,1}
		sphere {<-.75,.68,-.3>,.2,1}
		cylinder {<-.3,-.28,0>,<-.325,.44,-.075>,.26,1}		// Ring Finger
		sphere {<-.325,.44,-.075>,.26,-.75}
		cylinder {<-.325,.44,-.075>,<-.35,.9,-.325>,.26,1}
		sphere {<-.35,.9,-.325>,.2,1}
		cylinder {<.05,-.28,0>,<.05,.49,-.075>,.26,1}		// Middle Finger
		sphere {<.05,.49,-.075>,.26,-.75}
		cylinder {<.05,.49,-.075>,<.05,.95,-.35>,.26,1}
		sphere {<.05,.95,-.35>,.2,1}
		cylinder {<.4,-.4,0>,<.425,.512,-.075>,.26,1}		// Index Finger
		sphere {<.425,.512,-.075>,.26,-.75}
		cylinder {<.425,.512,-.075>,<.45, .85,-.375>,.26,1}
		sphere {<.45, .85,-.375>,.2,1}
		cylinder {<.41,-.95,0>,<.85,-.68,-.05>,.25,1}		// Thumb
		sphere {<.85,-.68,-.05>,.26,-.75}
		cylinder {<.85,-.68,-.05>,<1,-.3,-.2>,.25,1}
		sphere {<1,-.3,-.2>,.2,1}
	}
	pigment {color NewTan}
	scale <.5,.5,.5>
}

#declare RWHandL=
object {
	blob {
		threshold .65
		sphere {<.23,-.32,0>,.43,1	scale <1.95,1.05,.8>}	// Palm
		sphere {<-.12,-.41,0>,.43,1	scale <1.95,1.075,.8>}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>}	// Middle of hand
		sphere {<-.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>}
		sphere {<.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>}	// Heel of hand
		sphere {<-.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>}
		cylinder {<.65,-.28,0>,<.75,.28,-.075>,.26,1}		// Pinky Finger
		sphere {<.75,.28,-.075>,.26,-.75}
		cylinder {<.7,.28,-.075>,<.8,.28,-.5>,.26,1}
		sphere {<.8,.28,-.5>,.2,1}
		cylinder {<.3,-.28,0>,<.35,.44,-.075>,.26,1}		// Ring Finger
		sphere {<.35,.44,-.075>,.26,-.75}
		cylinder {<.35,.44,-.075>,<.45,.44,-.7>,.26,1}
		sphere {<.45,.46,-.7>,.2,1}
		cylinder {<0,-.28,0>,<0,.49,-.075>,.26,1}		// Middle Finger
		sphere {<0,.49,-.075>,.26,-.75}
		cylinder {<0,.49,-.075>,<.05,.53,-.8>,.26,1}
		sphere {<.05,.53,-.8>,.2,1}
		cylinder {<-.4,-.4,0>,<-.425,.512,-.075>,.26,1}		// Index Finger
		sphere {<-.425,.512,-.075>,.26,-.75}
		cylinder {<-.425,.512,-.075>,<-.45,.572,-.7>,.26,1}
		sphere {<-.45,.572,-.7>,.2,1}
		cylinder {<-.41,-.95,0>,<-.85,-.68,-.05>,.25,1}		// Thumb
		sphere {<-.85,-.68,-.05>,.26,-.75}
		cylinder {<-.85,-.68,-.05>,<-1,-.3,-.2>,.25,1}
		sphere {<-1,-.3,-.2>,.175,1}
	}
	pigment {color NewTan}
	scale <.4,.4,.4>
}

#declare Hat=
object {
	union {
		cylinder {<0,0,0>,<0,.025,0>,1}
		cylinder {<0,.025,0>,<0,.1,0>,.5	texture {T_Gold_4A}}
		cone {
			<0,.1,0>,.5,<0,1.5,0>,.15
			texture {
				material_map {
					gif "wizzard.gif"
					map_type 2
					texture {pigment{color Red}}
					texture {T_Silver_4C}
				}
				scale <1,1.4,1>
				translate <0,.1,0>
				rotate y*-90
			}
		}
		sphere {<0,1.5,0>,.15}
		cone {<0,1.5,0>,.15,<.05,2,.25>,.05}
		sphere {<.05,2,.25>,.05}
		pigment {color Red}
	}
}

#declare RWRightBoot=
object {
	difference {
		blob {
			threshold .75
			sphere {<0,1,0>,1,.35	scale <1,1,1.25>}
			cylinder {<0,0,0>,<0,1,0>,1,1}
			cylinder {<0,.1,0>,<-.05,.1,-.5>,.6,1	scale <1,.75,1>}
			cylinder {<-.05,.1,-.5>,<0,.1,-1>,.55,1	scale <1,.5,1>}
			sphere {<0,.1,-1>,.4,.75}
			sturm
		}
		box {<-1,-.5,-2>,<1,0,1>}
		pigment {color DarkBrown}
	}
}

#declare RWLeftBoot=
object {
	difference {
		blob {
			threshold .75
			sphere {<0,1,0>,1,.35	scale <1,1,1.25>}
			cylinder {<0,0,0>,<0,1,0>,1,1}
			cylinder {<0,.1,0>,<.05,.1,-.5>,.6,1	scale <1,.75,1>}
			cylinder {<.05,.1,-.5>,<0,.1,-1>,.55,1	scale <1,.5,1>}
			sphere {<0,.1,-1>,.4,.75}
		}
		box {<-1,-.5,-2>,<1,0,1>}
	pigment {color DarkBrown}
	}
}

#declare Robe=
object {
	blob {
		cylinder {<-1,-.75,.25>,<1,-.75,.25>,.75,1}				// Collarbone
		sphere {<-1,-.75,.25>,.85,1}						// Shoulders
		sphere {<1,-.75,.25>,.85,1}
		cylinder {<1,-.75,.25>,<1.75,-1.75,-1>,.65,1}				// Left Upper Arm
		cylinder {<1.2,-.75,.25>,<1.75,-1.75,-1>,.75,1}
		sphere {<1.75,-1.75,-1>,.75,.75}
		cylinder {<-1,-.75,.25>,<-1.75,-1.75,1>,.65,1}				// Right Upper Arm
		cylinder {<-1.2,-.75,.25>,<-1.75,-1.75,1>,.75,1}
		sphere {<-1.75,-1.75,1>,.75,.75}
		cylinder {<0,0,0>,<0,0,.3>,1,1	scale <.85,1.25,.35>	rotate x*18	translate <-.45,-1.45,-.25>}	// Chest
		cylinder {<0,0,0>,<0,0,.3>,1,1	scale <.85,1.25,.35>	rotate x*18	translate <.45,-1.45,-.25>}
		cylinder {<0,0,0>,<0,0,.25>,1.25,1	scale <.9,1,.35>	translate <0,-2.5,-.25>}			// Belly
		cylinder {<0,0,0>,<0,0,.5>,1.75,1	scale <1.5,1.25,.75>	translate <0,-1.5,.25>}		// Upper Back
		cylinder {<0,0,0>,<0,0,.35>,1.5,1	scale <.75,1,.5>	translate <0,-2.5,.25>}		// Lower Back
		sphere {<.45,-3,.45>,1.25,1}						// Left Hip
		cylinder {<.3,-3,0>,<1,-4.5,1>,1,1}					// Left Thigh
		cylinder {<1,-3,0>,<1,-4.5,1>,1,1}					// Left Thigh
		sphere {<-.45,-3,.45>,1.25,1}						// Right Hip
		cylinder {<-.3,-3,0>,<-1,-4.5,-1>,1,1}					// Right Thigh
		cylinder {<-1,-3,0>,<-1,-4.5,-1>,1,1}					// Right Thigh
		sphere {<0,0,0>,2,1	scale <1.25,1,.45>	rotate y*-45	translate <0,-4.25,0>}			// Skirt of Robe
		cylinder {<0,-.1,0>,<0,.1,0>,2,1	scale <1.5,1,.5>	rotate y*-45	translate <0,-4.75,0>}	// Flare at bottom
		sturm
		pigment {color Red}
	}
}
object {
	union {
		blob {
			threshold .65
			sphere {<0,0,0>,.85,1	scale <1.2,1.75,1>	translate <0,.4,0>}	// Head
			sphere {<0,.65,.25>,.85,1}						// Back of Skull
			sphere {<-.2,.275,-.3>,.325,.5}						// Cheeks
			sphere {<.2,.275,-.3>,.325,.5}
			sphere {<0,.125,-.35>,.35,.5}						// Chin
			sphere {<0,-.025,-.5>,.35,.5}
			cylinder {<0,-.05,0>,<0,.05,0>,.325,1	scale <.5,.1,1>	rotate x*20	translate <0,.05,-.375>	pigment {color Scarlet}}	// Lips
			cylinder {<0,-.05,0>,<0,.05,0>,.325,1	scale <.5,.1,1>	rotate x*-15	translate <0,.05,-.375>	pigment {color Scarlet}}
			sphere {<0,0,0>,.25,-1	scale <.65,.5,2.5>	translate <0,.05,-.5> pigment {color Scarlet}}		// Mouth
			cylinder {<0,.55,-.4>,<0,.3,-.55>,.1,1}					// Nose
			sphere {<0,0,0>,.1,1	scale <2,1,1>	translate <0,.3,-.55>}
			sphere {<0,0,0>,.16,-1	scale <1.75,1.25,.5>	rotate y*5	translate <-.16,.575,-.4>}	// Eye Sockets
			sphere {<0,0,0>,.16,-1	scale <1.75,1.25,.5>	rotate y*-5	translate <.16,.575,-.4>}
			sphere {<-.175,.575,-.35>,.075,-1}					// Holes for Eyeballs
			sphere {<.175,.575,-.35>,.075,-1}
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,1.5,.8>	rotate <10,-8,12>	translate <-.575,.5,.05>}	// Ears
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,1.5,.8>	rotate <10,8,-12>	translate <.575,.5,.05>}
			cylinder {<-1,-.75,.25>,<1,-.75,.25>,.5,1}				// Collarbone
			sphere {<-1,-.75,.25>,.6,1}						// Shoulders
			sphere {<1,-.75,.25>,.6,1}
			cylinder {<1.75,-1.75,-1>,<2,-.5,-1.25>,.4,1}				// Left Lower Arm
			sphere {<1.9,-1.5,-1.15>,.75,.5}
			cylinder {<-1.75,-1.75,1>,<-2,-2,-.5>,.4,1}				// Right Lower Arm
			sphere {<-1.9,-1.85,.25>,.75,.5}
			cylinder {<0,0,0>,<0,0,.3>,.75,1	scale <.85,1.25,.35>	rotate x*18	translate <-.45,-1.45,-.25>}	// Chest
			cylinder {<0,0,0>,<0,0,.3>,.75,1	scale <.85,1.25,.35>	rotate x*18	translate <.45,-1.45,-.25>}
			cylinder {<0,0,0>,<0,0,.5>,1.5,1	scale <1.5,1.25,.75>	translate <0,-1.5,.25>}		// Upper Back
			sphere {<.45,-3,.45>,1.25,1}						// Left Hip
			cylinder {<.3,-3,0>,<1,-4.5,1>,.55,1}					// Left Thigh
			cylinder {<.5,-3.25,.4>,<1,-4.5,1>,.35,1}
			cylinder {<.8,-3,.25>,<1,-4.5,1>,.45,1}
			cylinder {<1,-4.5,1>,<1,-4.5,2.5>,.5,1}					// Left Lower Leg
			cylinder {<1,-4.25,1.25>,<1,-4.5,2.5>,.5,1}
			sphere {<0,0,0>,.75,.5	scale <.5,.5,1>	translate <1,-4.25,1.5>}	// Left Calf
			sphere {<-.45,-3,.45>,1.25,1}						// Right Hip
			cylinder {<-.3,-3,0>,<-1,-4.5,-1>,.55,1}				// Right Thigh
			cylinder {<-.5,-3.25,.4>,<-1,-4.5,-1>,.35,1}
			cylinder {<-.8,-3,.25>,<-1,-4.5,-1>,.45,1}
			cylinder {<-1,-4.5,-1>,<-1,-6,-1>.5,1}					// Right Lower Leg
			cylinder {<-1,-4.75,-1.25>,<-1,-6,-1>.5,1}
			sphere {<0,0,0>,.75,.5	scale <.5,1,.5>	translate <-1,-5,-1.25>}	// Right Calf
			sturm
			pigment {color Flesh}
		}
		object {RWEye	translate <-.175,.575,-.35>}
		object {RWEye	translate <.175,.575,-.35>}
		object {RWHandL		rotate y*60	rotate x*-20	translate <1.95,-.1,-1.475>}
		object {RWHandR		rotate y*-105	rotate x*-90	rotate y*15	translate <-2.15,-1.95,-.95>}
		object {Hat		rotate x*25	translate <0,.6,0>}
		object {RWLeftBoot	rotate x*80	translate <1,-4.6,2.75>}
		object {RWRightBoot			translate <-1,-6.25,-1.1>}
		object {Robe}
		#if (Detailed)
			object {RWHair translate <0,.65,0>}
			object {RWEyebrow		rotate z*-10		translate <.075,.75,-.45>}
			object {RWEyebrow		rotate z*(180+10)	translate <-.075,.75,-.45>}
		#end
	}
	translate <0,6.5,0>
	scale <.85,.85,.85>
	translate <1,0,8.5>
}
