//#include "dragonscale.inc"

#declare ClawDownAngle = 70
#declare FrontClawDownAngle = 40
#declare LeftFrontLegZA = +20
#declare RightFrontLegZA = -50
#declare LeftLegPos = <-1.2,1.6,-0.6>

#declare BlotchColour = color rgb<0.537255,0.456863,0.119608>*0.7
#declare ScaleColour = color rgb<0.6,-0.5,-0.5> // Negatives deny G/B

#declare WetAndSlimy = finish { Shiny }
#declare Blotches =
    texture {
	pigment {
	    bozo
	    turbulence 1
	    color_map {
	     [ 0.0 color Clear ]
	     [ 0.5 color Clear ]
	     [ 0.7 color BlotchColour ]
	     [ 1.0 color BlotchColour ]
	    }
	    scale 0.5
	    quick_colour Red
	}
    }

#declare DragonColour =
    pigment {
	bozo
	turbulence 1
	color_map {
	 [ 0.0 color ScaleColour ]
	 [ 0.5 color ScaleColour ]
	 [ 0.7 color BlotchColour ]
	 [ 1.0 color BlotchColour ]
	}
	scale 0.5
	quick_colour Red
    }

#declare ScaleNormals =
    normal {
        bump_map {
            ppm "scales.ppm"
            map_type Cylinder_Map
            bump_size -8
            interpolate Bi
        }
        turbulence 0.08

        scale <1,0.1,1>
    }

#declare ScaleTexture = 
    texture {
        //pigment { radial frequency 2 }
        pigment { DragonColour }
        normal { ScaleNormals }
	finish { F_MetalB }
    }

#declare ScaleTextureNinv = 
        normal {
            bump_map {
                ppm "scales.ppm"
                map_type Cylinder_Map
                bump_size 8 // XXX ho hum
                interpolate Bi
            }
            turbulence 0.08

            scale <1,0.1,1>
        }

#declare ScaleTextureinv = 
    texture {
        pigment { DragonColour }
        normal { ScaleTextureNinv }
	finish { F_MetalC }
    }

#declare ScaleNormals2 =
    normal {
        bump_map {
            ppm "scales2.ppm"
            map_type Cylinder_Map
            bump_size -8
            interpolate Bi
        }
        turbulence 0.08

        scale <1,0.1,1>
    }


#declare DragonColour2 = // With yellow bits
    pigment {
        image_map {
            gif "scales2c.gif"
            map_type Cylinder_Map
            interpolate Bi
        }
        quick_colour SeaGreen
        turbulence 0.08

        scale <1,0.1,1>
    }

#declare ScaleTexture2 =
    texture {
        pigment { DragonColour/*2*/ }
        normal { ScaleNormals2 }
	finish { F_MetalC }
    }
/*
    texture {
	Blotches
        normal { ScaleNormals2 }
	finish { F_MetalC }
    }
*/

#declare ScaleTexture2Ninv =
        normal {
            bump_map {
                ppm "scales2.ppm"
                map_type Cylinder_Map
                bump_size 8
                interpolate Bi
            }
            turbulence 0.08

            scale <1,0.1,1>
        }

#declare ScaleTexture2inv =
    texture {
        // FOR SOME REASON, SOME OF THESE ARE INSIDE OUT!
        // SOME need negative bump_size

        pigment {
            image_map {
                gif "scales2c.gif"
                map_type Cylinder_Map
                interpolate Bi
            }
            turbulence 0.08
            quick_colour SeaGreen

            scale <1,0.1,1>
        }

	normal { ScaleTexture2Ninv }
	finish { F_MetalC }
    }
    texture {
	Blotches
	translate x*3 // Find a good but
	normal { ScaleTexture2Ninv }
	finish { F_MetalC }
    }

#declare NeckAndTailTexture =
    texture {
        ScaleTexture2//inv

        rotate z*90 // turn mapping cylinder on its side
        scale <-1,1,1>
    }

#declare WingTexture =
    texture {
        ScaleTextureinv

        rotate z*90 // turn mapping cylinder on its side
        //scale <-1,1,1>
    }

#declare DragonSpike =
    intersection {
        sphere { <0,0,0>,1 scale <1,1,0.1> }
        plane { <1,1,0>,0.5 }
        plane { <-1,1,0>,0.5 }
        texture {
            pigment {
                marble
                turbulence 0.2
                colour_map {
                    [0.0, 0.5 colour Brown colour DarkBrown ]
                    [0.5, 0.7 colour Brown colour Black ]
                    [0.7, 1.0 colour Brown colour DarkBrown ]
                }
                quick_colour Brown
            }
        }
        scale 0.2
        bounded_by { sphere { <0,0,0>,1.01 scale <1,1,0.1> } }
    }

#declare DragonTalon =
    difference {
        sphere { <0,0,0>,1 scale <1,1,0.2> }
        sphere { <-0.2,-0.2,0>,1 }
        box { <-0.2,-1.01,-0.21>,<1.01,1.01,0.21> }

        pigment {
            red 0.8 green 0.85 blue 0.7
            quick_colour red 0.8 green 0.85 blue 0.7
        }
        finish { WetAndSlimy }
        translate y*-0.9
        scale 0.5
    }

#declare DragonClaw =
    union {
        object { DragonTalon }
        sphere {
            <0,0,0>,0.13
            scale <1,0.8,0.7>
            translate <-0.05,-0.03,0>
        }
        sphere {
            <0,0,0>,0.16
            scale <1,0.8,0.7>
            translate <0.01,-0.03,0>
        }
        texture {
            ScaleTexture2
            scale 0.4
            rotate z*90
            rotate y*180
            translate <0.01,-0.03,0>
        }
    }

#declare ClawSet =
    union {
        object {DragonClaw rotate y*7-z*10 translate <-.11,0.09,+0.13>}
        object {DragonClaw scale 1.2 rotate y*00-z*10 translate <-0.18,0.09,0>}
        object {DragonClaw rotate y*-7-z*10 translate <-.11,0.09,-0.13>}
    }

// Simple blue eye
#declare BlueEye =
  sphere {
    <0,0,0>, 1
    texture {
      pigment {
    gradient z
    colour_map {
      [0.95 colour White]
      [0.951 colour Blue]
      [0.99 colour Blue]
      [0.991 colour Black]
    }
    scale 4
    translate z*3
      }
    }
    scale 0.15
  }

#declare CatEye =
  sphere {
    <0,0,0>, 1
    texture {
      material_map {
    gif "cateye.gif"
    texture {
        pigment {
            radial
            frequency 10
            turbulence 1
            colour_map {
                [0.0, 0.9 colour White colour White ]
                [0.9, 1.0 colour White colour Red ]
            }
            rotate x*90 // radiate from Z axis, not Y.
            translate <0.5,0.5,0> // image map is 0,0 to 1,1
        }
        finish { WetAndSlimy }
    }
    texture {
        pigment {
            radial
            frequency 18
            turbulence 0.07 // No eye is perfect
            colour_map {
                [0.0, 0.5 colour Yellow colour Orange]
                [0.5, 1.0 colour Orange colour Yellow]
            }
            rotate x*90
            translate <0.5,0.5,0> // image map is 0,0 to 1,1
        }
        finish { WetAndSlimy }
    }
    texture {
        pigment { colour Clear }
        finish { WetAndSlimy }
    }
      }
      translate <-0.5,-0.5,0>
      scale 2.5
    }
    scale 0.15
  }

#declare DragonEye =
    object {
        CatEye
        scale 0.5
        rotate x*25+y*10 // Point them forward & upward
    }

#declare DragonTooth =
    union {
        difference {
            sphere { <0,0,0>,1 scale <1,1,0.2> }
            sphere { <-0.2,-0.2,0>,1 }
            box { <-0.2,-1,-0.21>,<1.01,1.01,0.21> }

            pigment {
                red 1.0 green 1.0 blue 0.9
                quick_colour red 1.0 green 1.0 blue 0.9
            }
            finish { WetAndSlimy }
            translate <0.2,-0.9,0>
            scale 0.5
            rotate z*-110
            rotate y*180
            translate y*-0.008
        }
        // Gum
        sphere {
            <0,0,0>,0.07
            pigment {
                red 0.7 green 0.5 blue 0.6
                quick_colour red 0.7 green 0.5 blue 0.6
            }
        }
    }

#declare DragonLowerRightGum =
    union {
        object { DragonTooth
            scale 0.17 rotate y*50 translate <-0.21,0,0.12> }
        object { DragonTooth
            scale 0.19 rotate y*40 translate <-0.24,0,0.11> }
        object { DragonTooth
            scale 0.20 rotate y*30 translate <-0.27,0,0.094> }
        object { DragonTooth
            scale 0.22 rotate y*20 translate <-0.295,0,0.082> }
        object { DragonTooth
            scale 0.19 rotate y*18 translate <-0.316,0,0.07> }
        object { DragonTooth
            scale 0.33 rotate y*12 translate <-0.33,0,0.05> }
        object { DragonTooth
            scale 0.16 rotate y*8 translate <-0.34,0,0.029> }
        object { DragonTooth
            scale 0.17 rotate y*0 translate <-0.346,0,0.010> }
    }

#declare DragonUpperRightGum =
    union {
        object { DragonLowerRightGum }
        rotate x*180
        scale 1.08
    }

#declare DragonCheek =
    intersection {
        torus { 0.4,0.3 }
	box { <0,-1,-0.1> <1,1,0.16> }
        translate <-0.16,0.1,-0.05>
        scale <5,0.3,7>
        scale 0.11
        rotate x*76
        rotate z*20
    }

#declare DragonRightHorn =
    object {
	#include "horn.inc"
	scale 0.11   // up to 0.15 looks good
	rotate z*140
	//rotate y*50
	translate <0,0,-0.22>
    }

#declare DragonHead =
    union {
        //box {<-0.5,-0.1,-0.1>, <0,0.1,0.1>}

        //sphere { <0,0,0>,0.17 }

        // Upper jaw
        difference {
            blob {
                threshold 0.5

                // Bulk
                sphere { <0,0,0>, 0.31, 0.78 }
                sphere { <-0.22,0,0.00>, 0.25, 0.23 }
                sphere { <-0.22,0,-0.00>, 0.25, 0.23 }
                sphere { <-0.24,-0.35,0>, 0.35, 0.53 }
                // Palate
                sphere { <-0.15,-0.3,0>, 0.35, -0.93 }

                // Nostrils
                sphere { <-0.37,0.03,-0.04>, 0.06, 0.7 }
                sphere { <-0.37,0.03,+0.04>, 0.06, 0.7 }
                sphere { <-0.37,0.03,-0.04>, 0.03, -1.9 texture { pigment { colour Red } } }
                sphere { <-0.37,0.03,+0.04>, 0.03, -1.9 texture { pigment { colour Red } } }
                sphere { <-0.41,0.03,-0.04>, 0.03, -1.4 texture { pigment { colour Red } } }
                sphere { <-0.41,0.03,+0.04>, 0.03, -1.4 texture { pigment { colour Red } } }
                sphere { <-0.36,0.03,-0.04>, 0.03, -2.5 texture { pigment { colour Red } } }
                sphere { <-0.36,0.03,+0.04>, 0.03, -2.5 texture { pigment { colour Red } } }

                // Eye socket
		sphere { <0,0,0> 0.06, -0.8 scale <1.6,1,1> translate <-0.18,0.09,+0.10> texture { pigment { colour Red*2 } } }
		sphere { <0,0,0> 0.06, -0.8 scale <1.6,1,1> translate <-0.18,0.09,-0.10> texture { pigment { colour Red*2 } } }

                // Brow ridges
                sphere { <-0.1,0.15,-0.09>, 0.06, 0.55 }
                sphere { <-0.1,0.15,+0.09>, 0.06, 0.55 }
                sphere { <-0.14,0.14,-0.09>, 0.06, 0.53 }
                sphere { <-0.14,0.14,+0.09>, 0.06, 0.53 }
                sphere { <-0.06,0.14,-0.09>, 0.045, 0.51 }
                sphere { <-0.06,0.14,+0.09>, 0.045, 0.51 }
                sphere { <-0.17,0.10,-0.11>, 0.04, 0.53 }
                sphere { <-0.17,0.10,+0.11>, 0.04, 0.53 }
                sphere { <-0.03,0.10,-0.11>, 0.04, 0.53 }
                sphere { <-0.03,0.10,+0.11>, 0.04, 0.53 }

                // Top bumps
                sphere { <0,0.14,0>, 0.04, 0.53 }
                sphere { <-0.075,0.15,0>, 0.05, 0.53 }
                sphere { <-0.15,0.15,0>, 0.04, 0.53 }
                sphere { <-0.225,0.14,0>, 0.035, 0.53 }
                //sphere { <-0.3,0.13,0>, 0.03, 0.53 }

		// Horn mounts
                sphere { <+0.01,0.18,+0.11>, 0.13, 0.53 }
                sphere { <+0.01,0.18,-0.11>, 0.13, 0.53 }
                sphere {
		    <0,0,0> 0.09, -0.6
		    scale <2,2.4,1>
		    translate <+0.01,0.35,0>
		}

		// Neck join
                sphere { <-0.4,0,0>, 0.4, 0.4 }
                sphere { <-0.2,-0.6,0>, 0.6, -3 }

                //sturm
            }
            sphere { <-0.1,-0.6,0>,0.25 }
            scale <1.5,1,1.5>
        }

	// Horns
	union {
	    object { DragonRightHorn }
	    object { DragonRightHorn scale <1,1,-1> }
	    texture { 
		pigment { rgb <1,1,0.8> }
		normal {
		    wrinkles 0.4
		    slope_map {
		     [0 0]
		     [0.5 0]
		     [1.0 1]
		    }
		    scale 0.01
		}
		finish { WetAndSlimy }
	    }
	    translate <+0.01,0.17,0>
	}

        union {
            object { DragonUpperRightGum }
            object { DragonUpperRightGum scale <1,1,-1> }
            translate <-0.18,-0.055,0>
        }

        // Eyes
/*
        object {
	    DragonEye
	    translate <-0.15,0.06,-0.14>
	}
        object {
	    DragonEye scale<1,1,-1>
	    translate <-0.15,0.06,0.14>
	}
*/
        object {
	    DragonEye
	    rotate y*50
	    translate <-0.18,0.07,-0.14>
	}
        object {
	    DragonEye scale<1,1,-1>
	    rotate y*-50
	    translate <-0.18,0.07,0.14>
	}


        // Lower jaw

#declare JawOpenAngle=20   // 0..40 - cheek scaling fails beyond 40
        union {
            difference {
                blob {
                    threshold 0.5
                    component 0.7,0.5,<0,0,0>
                    component -0.5,0.4,<0,0.3,0>
                }
		sphere {
		    <0,0.01,0>,0.16
		    texture {
			pigment {
			    marble
			    turbulence 2
			    color_map {
			     [ 0 colour rgb<0.6,0,0.1> ]
			     [ 0.7 colour rgb<1,0,0.1> ]
			     [ 1 colour rgb<0.4,0,0> ]
			    }
			}
			finish { WetAndSlimy }
			scale 0.03
		    }
		    scale <1.1,1,1>
		}
                scale <2.0,0.5,0.7>
            }

	    // Cheeks
	    difference {
		union {
		    object { DragonCheek
			translate <-0.14,-0.02,-0.120>
		    }
		    object { DragonCheek
			scale <1,1,-1>
			translate <-0.14,-0.02,0.120>
		    }
		    rotate z*-27
		    scale <1,sin(radians(JawOpenAngle))*1.8+0.2,1>
		}
		box { <-0.3,0.1,-0.2> <0.2,0.2,0.2> rotate -z*JawOpenAngle }
	    }

	    union {
		object { DragonLowerRightGum }
		object { DragonLowerRightGum scale <1,1,-1> }
		scale <1.0,0.9,0.8>
	    }
            rotate z*JawOpenAngle
            translate <-0.16,-0.08,0>
        }

        // Throat
        sphere {
            <0.01,-0.06,0>,0.1
        }
        texture {
            ScaleTextureinv
            rotate z*90 // turn mapping cylinder on its side
        }
    }


#declare DragonWing =
    union {
        object {
            DragonTalon
            rotate y*-45
            translate <0.10,3.0,-1.5>
        }
	difference {
	    bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3

		<0.0,3.0,-1.6>,
		    <0.05,3.0,-1.6>,
		    <0.10,3.0,-1.6>,
		    <0.15,3.0,-1.6>,
		<-0.3,2.67,-1.2>,
		    <-0.033,2.6,-1.4>,
		    <0.24,2.4,-1.42>,
		    <0.96,2.35,-1.44>,
		<-0.6,2.33,-0.8>,
		    <-0.067,2.1,-1.03>,
		    <0.48,1.8,-1.16>,
		    <1.20,1.47,-1.35>,
		<-0.9,2.0,-0.4>,
		    <-0.1,1.56,-0.68>,
		    <0.7,1.13,-0.94>,
		    <1.5,0.7,-1.2>
	    }
	    union {
		#declare FROM = <-0.9,2.0,-0.4>
		#declare TO = <1.5,0.7,-1.2>
		#declare DIFF = TO-FROM

		#declare EL_RADIUS = 0.16

		#declare EL_FROM=FROM+DIFF*0.07
		#declare EL_TO=FROM+DIFF*0.333
		#include "ellipsoid.inc"

		#declare EL_FROM=FROM+DIFF*0.333
		#declare EL_TO=FROM+DIFF*0.666
		#include "ellipsoid.inc"

		#declare EL_FROM=FROM+DIFF*0.666
		#declare EL_TO=FROM+DIFF*0.99
		#include "ellipsoid.inc"

		pigment { colour White }
	    }

	    texture {
		// Semitransparent wing
		pigment { colour rgbt <0.7,0.3,0.9,0.6> }
		normal {
		    wrinkles 1
		    scale <0.03,0.1,0.03>
		}
		finish {
		    //specular 1
		    roughness 0.0001

		    //ambient 0
		    //diffuse 0.6
		    //reflection 0.13
		}
	    }
	}

        #include "wing.inc"

        texture{WingTexture}

	// Move shoulder to origin
        translate -<-0.9,2.0,-0.4>

	rotate y*35
	rotate z*35
	rotate x*15
	scale 1
        translate <-0.9,2.0,-0.4>
    }

#declare LeftFrontLegTexture =
    texture {
        ScaleTexture // Vertical scaley cylinder

	translate <0.5,0,0>
	scale <1,2,1>/3
	rotate z*-45 
	rotate z*LeftFrontLegZA
	translate LeftLegPos*<1,1,1>
    }

#declare RightFrontLegTexture =
    texture {
        ScaleTexture

	translate <0.5,0,0>
	scale <1,2,1>/3
	rotate z*-45 
	translate LeftLegPos*<1,1,1>
    }

#declare LeftBackLegTexture =
    texture {
        ScaleTexture

        // NB: same translations above & below
        scale <0.7,1.00,0.55>
        rotate z*15
        rotate y*25
        translate <+0.92,0.5,-0.9>
    }

#declare RightBackLegTexture =
    texture {
        ScaleTexture

        scale <1,1,-1>
        // NB: same translations twice above
        scale <0.7,1.00,0.55>
        rotate z*15
        rotate y*25
        translate <+0.92,0.5,+0.9> // but PLUS
    }

#declare BodyTexture =
    texture {
        ScaleTexture2

        rotate z*90 // turn mapping cylinder on its side
        scale <1.4,1,1> // Stretch them a little longer along body
        // NB: same translations above
        translate <0,1.42,0>
    }


#declare DragonBody = 
    blob {
        threshold 0.5

        // Feet, ankles, and legs

	// LEFT HIND
	// Soul subtractor
        sphere { <+1,-1.1,-1>, 1.3, -0.9 texture { LeftBackLegTexture } }
        sphere { <+1,-0.8,-1>, 0.7, -0.7 texture { LeftBackLegTexture } }
	// Heel
        sphere { <+1.4,0.5,-0.8>, 0.6, 0.45 texture { LeftBackLegTexture } }
	// Ankle
        sphere {
	    <0,0,0>, 0.18, 0.6
	    scale <1,1,1.8>
	    translate <+1.3,0.65,-0.8>
	    texture { LeftBackLegTexture }
	}
	// Calf/hip
        sphere {
	    <0,0,0>, 0.6, 0.7
	    scale <1,1.6,0.4>
	    rotate x*35
	    rotate y*-30
	    translate <+0.8,1.4,-0.6>
	    texture {  LeftBackLegTexture }
	}
	// Shin
	cylinder {
	    <+1.1,0.9,-0.8>
	    <+1.25,0.6,-0.8>, 0.4, 0.25
	    texture {  LeftBackLegTexture }
	}
	// Tendon
	cylinder {
	    <-0.4,0.9,0>
	    <0,0,0>, 0.06, 0.5
	    scale <1,1,0.8>
	    rotate x*30
	    translate <+1.4,0.7,-0.8>
	    texture {  LeftBackLegTexture }
	}
	// Foot
        sphere {
	    <0,0,0>, 0.7, 0.7
	    scale <1,0.9,1>
	    translate <1,0,-1>
	    texture {  LeftBackLegTexture }
	}

	// RIGHT HIND
	// Soul subtractor
        sphere { <+1,-1.1,+1>, 1.3, -0.9 texture { RightBackLegTexture } }
        sphere { <+1,-0.8,+1>, 0.7, -0.7 texture { RightBackLegTexture } }
	// Heel
        sphere { <+1.4,0.5,+0.8>, 0.6, 0.45 texture { RightBackLegTexture } }
	// Ankle
        sphere {
	    <0,0,0>, 0.18, 0.6
	    scale <1,1,1.8>
	    translate <+1.3,0.65,+0.8>
	    texture { RightBackLegTexture }
	}
	// Calf/hip
        sphere {
	    <0,0,0>, 0.6, 0.7
	    scale <1,1.6,0.4>
	    rotate x*-35
	    rotate y*+30
	    translate <+0.8,1.4,+0.6>
	    texture {  RightBackLegTexture }
	}
	// Shin
	cylinder {
	    <+1.1,0.9,+0.8>
	    <+1.25,0.6,+0.8>, 0.4, 0.25
	    texture {  RightBackLegTexture }
	}
	// Tendon
	cylinder {
	    <-0.4,0.9,0>
	    <0,0,0>, 0.06, 0.5
	    scale <1,1,0.8>
	    rotate x*-30
	    translate <+1.4,0.7,+0.8>
	    texture {  RightBackLegTexture }
	}
	// Foot
        sphere {
	    <0,0,0>, 0.7, 0.7
	    scale <1,0.9,1>
	    translate <1,0,+1>
	    texture {  RightBackLegTexture }
	}


	// LEFT FRONT
	cylinder {
	    <0,0.0,0.2>,
	    <-0.10,-0.60,-0.16>, 0.3,0.48
	    rotate z*LeftFrontLegZA
	    translate LeftLegPos
	    texture { LeftFrontLegTexture }
	}
	cylinder {
	    <-0.12,-0.6,-0.16>,
	    <-0.45,-0.65,0>, 0.15,0.75
	    rotate z*LeftFrontLegZA
	    translate LeftLegPos
	    texture { LeftFrontLegTexture }
	}
        sphere { <0,0,0>, 0.34, 0.6
	    scale <1.4,0.5,1.0>
	    rotate z*30
	    translate <-0.61,-0.66,0>
	    rotate z*LeftFrontLegZA
	    translate LeftLegPos
	    texture { LeftFrontLegTexture }
	}

	// RIGHT FRONT
	cylinder {
	    <0,0.0,0.2>,
	    <-0.10,-0.60,-0.16>, 0.3,0.48
	    rotate z*RightFrontLegZA
	    translate LeftLegPos*<1,1,-1>
	    texture { RightFrontLegTexture }
	}
	cylinder {
	    <-0.12,-0.6,-0.16>,
	    <-0.45,-0.65,0>, 0.15,0.75
	    rotate z*RightFrontLegZA
	    translate LeftLegPos*<1,1,-1>
	    texture { RightFrontLegTexture }
	}
        sphere { <0,0,0>, 0.34, 0.6
	    scale <1.4,0.5,1.0>
	    rotate z*30
	    translate <-0.61,-0.66,0>
	    rotate z*RightFrontLegZA
	    translate LeftLegPos*<1,1,-1>
	    texture { RightFrontLegTexture }
	}

        // Abdomen
        sphere { <.7,1.35,0>, 1.37, 0.9 texture { BodyTexture } }
        sphere { <0,1.4,0>, 0.97, 0.9 texture { BodyTexture } }

        // Chest
        sphere { <-0.8,1.6,0>, 1.3, 1 texture { BodyTexture } }

        texture { BodyTexture } // Shouldn't need this, but pov complains
    }

#declare DragonSpikes =
    union {
        // Neck spikes
        object { DragonSpike
            scale 0.60 rotate z*-8 rotate y*-43 translate <-2.67,2.80,-0.86> }
        object { DragonSpike
            scale 0.65 rotate z*-8 rotate y*-38 translate <-2.45,2.78,-0.66> }
        object { DragonSpike
            scale 0.70 rotate z*-8 rotate y*-33 translate <-2.25,2.74,-0.49> }
        object { DragonSpike
            scale 0.75 rotate z*-9 rotate y*-30 translate <-2.03,2.66,-0.35> }

#ifdef (SADDLE)
	union {
	    object { SADDLE }
	    cone {
		<0.1,0,0>,1.4
		<-0.1,0,0>,1.35
		texture { SADDLE_STRAP_TEXTURE }
		scale <1,0.92,0.90>
		translate <0,-1.13,0>
	    }
	    scale 0.3
	    rotate z*-15 rotate y*-24 translate <-1.60,2.44,-0.27>
	}
#else
        object { DragonSpike
            scale 0.80 rotate z*-10 rotate y*-22 translate <-1.8,2.62,-0.22> }
        object { DragonSpike
            scale 0.85 rotate z*-8 rotate y*-12 translate <-1.5,2.55,-0.12> }
#end

        object { DragonSpike
            scale 0.90 rotate z*-9 rotate y*-7 translate <-1.2,2.48,-0.06> }
        object { DragonSpike
            scale 0.95 rotate z*-8 rotate y*-3 translate <-0.9,2.40,-0.02> }
        object { DragonSpike rotate z*-5 translate <-0.6,2.33,0> }
        object { DragonSpike translate <-0.3,2.27,0> }

        object { DragonSpike translate <0,2.25,0> } // Center spike

        // Tail spikes
        object { DragonSpike translate <0.3,2.21,0> }
        object { DragonSpike translate <0.6,2.19,0> }
        object { DragonSpike rotate z*-15 translate <0.95,2.15,0> }
        object { DragonSpike rotate y*5+z*-30 translate <1.2,2.02,-0.04> }
        object { DragonSpike // First on tail
            scale 0.95 rotate z*-25 rotate y*10 translate <1.5,1.86,-0.113> }
        object { DragonSpike
            scale 0.94 rotate z*-25 rotate y*14 translate <1.8,1.71,-0.18> }
        object { DragonSpike
            scale 0.93 rotate z*-28 rotate y*15.5 translate <2.1,1.58,-0.22> }
        object { DragonSpike
            scale 0.92 rotate z*-30 rotate y*18.5 translate <2.37,1.39,-0.27> }
        object { DragonSpike
            scale 0.91 rotate z*-30 rotate y*23.5 translate <2.59,1.24,-0.35> }
        object { DragonSpike
            scale 0.89 rotate z*-35 rotate y*37 translate <2.77,1.10,-0.49> }
        object { DragonSpike
            scale 0.87 rotate y+10+z*-40 rotate y*30 translate <2.88,0.99,-0.61> }
        object { DragonSpike
            scale 0.85 rotate y+15+z*-35 rotate y*33 translate <2.98,0.88,-0.79> }
        object { DragonSpike
            scale 0.83 rotate y+19+z*-34 rotate y*40 translate <3.05,0.75,-0.99> }
        object { DragonSpike
            scale 0.80 rotate y+20+z*-28 rotate y*74 translate <3.04,0.66,-1.27> }
        object { DragonSpike
            scale 0.77 rotate y+18+z*-20 rotate y*83 translate <2.94,0.55,-1.54> }
        object { DragonSpike
            scale 0.63 rotate y+15+z*-14 rotate y*100 translate <2.78,0.50,-1.85> }
        object { DragonSpike
            scale 0.49 rotate y+10+z*-7 rotate y*115 translate <2.61,0.48,-2.15> }
    }

#declare Dragon =
    union {
#ifndef (ONLY_HEAD)
#ifndef (ONLY_BODY)
        object {
            ClawSet
            rotate z*ClawDownAngle
            translate <1.73,-0.8,+0.4>
	    translate <-0.8,0.8,+0.6>
        }
        object {
            ClawSet
            rotate z*ClawDownAngle
            translate <1.73,-0.8,-0.4>
	    translate <-0.8,0.8,-0.6>
        }

        object {
            ClawSet
            rotate z*FrontClawDownAngle
            scale 0.6
	    translate <-0.55,-0.66,0>
	    rotate z*RightFrontLegZA
	    translate LeftLegPos*<1,1,-1>
        }
        object {
            ClawSet
            rotate z*FrontClawDownAngle
            scale 0.6
	    translate <-0.55,-0.66,0>
	    rotate z*LeftFrontLegZA
	    translate LeftLegPos
        }
#end
#end

#ifndef (ONLY_BODY)
        object {
            DragonHead
            scale <1.7,1.7,1.0> // Dragon heads are narrower than I thought.
            rotate z*00 // 35 // Look down (20=ahead)
            rotate y*-55 // -55=AlignedWithNeck
            translate <-3.1, 2.7, -1.3> // Onto neck
        }
#end

#ifndef (ONLY_HEAD)
        object {DragonSpikes}

        object {
            #include "neck.inc"
            texture { ScaleTexture } // for spheres
        }

#ifndef (ONLY_BODY)
        object {
            #include "tail.inc"
            texture { ScaleTexture } // for spheres
        }

        object {DragonWing}
        object {DragonWing scale <1,1,-1> }
#end
	object {DragonBody}
#end
    }

