/*-----------------------------------------------
  Blood Creature


  1 unit = 1 cm
-----------------------------------------------*/

//-----------------------------------------------
#ifdef (SCENE_FILE)     // This file is included into another scene
  #declare BLOD_CREATURE_INCLUDED = 1
#else                   // This is the main scene file
  #declare SCENE_FILE = 1
  #declare HQ = 1
#end

//-----------------------------------------------
#include "colors.inc"

//-----------------------------------------------
#ifndef (BLOD_CREATURE_INCLUDED)
  #declare FrontLocation = <0, 80, -180>
  #declare FrontLookAt = <-20, 63, 0>

  #declare MeterLocation = <30, 55, -75>
  #declare MeterLookAt = <30, 50, -45>

  #declare TestLocation = <5, 20, -90>
  #declare TestLookAt = <0, 20, 0>

  camera {
    location TestLocation
    look_at TestLookAt
  }

  light_source {
    <-500, 1000, 0>
    White
  }
  light_source {
    <100, 1000, -1500>
    White
  }

  background { Black }
//  background { Yellow}
#end       // (INCLUDE_FILE)

//-----------------------------------------------
#declare TBlood = texture {
  pigment {
    color <0.5, 0.2, 0>
  }
  finish {
    ambient 0.3
    phong 1
    reflection 0.1
  }
  normal {
    bumps 0.1
    scale <0.5, 0.5, 0.5>
  }
}
texture {
  pigment {
    wood
    turbulence 0.3
    color_map {
      [0.0    color rgbft <0.5, 0.2, 0.0, 0, 1>]
      [0.97   color rgbft <0.5, 0.2, 0.0, 0, 1>]
      [0.98   color rgbft <0.1, 0.0, 0.3, 0, 0>]
      [1.0    color rgbft <0.1, 0.0, 0.3, 0, 0>]
    }
    translate 100*x
    rotate 90*x
    scale 7
  }
}

#declare TGlowing = texture {
  pigment {
    color rgbf <1, 1, 0, 3>
  }
  finish {
    phong 1
    refraction 1
    ior 1.5
  }
}
#declare TToothWhite = texture {
  pigment { White }
  finish {
    ambient 0.5
    phong 1
  }
}
//-----------------------------------------------
#declare Tooth = intersection {
  torus {
    5, 1
  }
  torus {
    5, 1
    translate 2.1*x
  }
  box {
    <-7, -2, 0>
    <0, 2, 7>
  }
  scale <2, 1, 1>
  texture { TToothWhite }
  rotate 90*x
  rotate -90*y
}

//-----------------------------------------------
#declare BloodCreature = union {
  blob {
    threshold 1
    sphere {
      <0, 0, 0>, 10, 1.3
    }
    sphere {
      <4, 3, 3>, 10, 1.3
    }
    sphere {
      <0, -6, 1>, 10, 1.3
    }
    sphere {
      <-4, 5, -1>, 10, 1
    }
    sphere {
      <4, 5, -1>, 10, 1
    }

    // Eye holes
    sphere {
      <-4, 2, -4>, 3, -1
    }
    sphere {
      <4, 2, -4>, 3, -1.5
    }

    texture { TBlood }
  }
  // Eyes
  union {
    sphere {
      <-4, 2, -2>, 2
    }
    sphere {
      <4, 2, -2>, 2
    }
    texture { TGlowing }
  }
  // Teeth
  object {
    Tooth
    rotate 5*y
    translate <-2, -0.5, -3>
  }
  object {
    Tooth
    rotate -5*y
    translate <2, -0.5, -3>
  }
}
//-----------------------------------------------
#declare BloodBlobs = union {
  blob {
    threshold 1

#declare R5 = seed(12)
#declare i = 0
#while (i < 18)
    sphere {
      <rand(R5)*25-12.5, rand(R5)*25-12.5, rand(R5)*6-3>, rand(R5)*5+5, rand(R5)*1 + 1
    }
#declare i = i + 1
#end

    texture { TBlood }
  }
  // Glowing smoke
  sphere {
    <0, 0, 0>, 1
    pigment { Clear }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.6
      color_map {
        [0.0   color rgbt <1, 1, 0, 1>]
        [1.0   color rgbt <0.5, 0.2, 0, -1>]
      }
      samples 6
      scale 0.5
    }
    hollow
    scale 30
  }
}
//-----------------------------------------------
#ifndef (BLOD_CREATURE_INCLUDED)
object {
  BloodCreature
//  rotate -65*y
}
/*
object {
  BloodBlobs
//  rotate -65*y
}*/

#end
//-----------------------------------------------
