/*-----------------------------------------------
  "Dungeon"

  1 unit = 1 cm

-----------------------------------------------*/

//-----------------------------------------------

// This is the main scene file
#declare SCENE_FILE = 1
#declare HQ = 1
#declare CEILING = 1
//-----------------------------------------------
#include "colors.inc"
#include "shapes.inc"

#include "strange_engine.pov"
#include "blood_creature.pov"

//-----------------------------------------------
#declare RoomCenter = <400, 155, 400>

#declare FrontLocation = <0, 30, -180>
#declare FrontLookAt = <-20, 13, 0>

#declare TestLocation = <630, 170, 320>
#declare TestLookAt = <450, 35, 600>

camera {
  location TestLocation
  look_at TestLookAt
}


/*light_source {
  <50, 150, 50>
  White
}
light_source {
  <750, 150, 50>
  White
}
light_source {
  <50, 150, 750>
  White
}
*/
//background { White }
background { Black }

//-----------------------------------------------
#declare TOldWood = texture {
  pigment {
    wood
    turbulence 0.1
    color_map
    {
      [0.00 color rgb<0.2, 0.3, 0.2>]
      [0.50 color rgb<0.0, 0.1, 0.0>]
      [1.00 color rgb<0.2, 0.3, 0.2>]
    }
    rotate 90*y
    scale <20, 2, 2>
    translate -100*y
  }
  finish {
    phong 1
  }
}

#declare TWater = texture {
  pigment {
    color <0, 0, 0.6>
  }
  finish {
    phong 1
    reflection 0.4
  }
  normal {
    waves
    turbulence 0.1
    scale <25, 25, 25>
  }
}
#declare TStone = texture {
  pigment {
    granite
    turbulence 0.3
    color_map
    {
      [0.00 color <0.1, 0.1, 0.1>]
      [1.00 color <0.7, 0.7, 0.7>]
    }
    scale 5
  }
  finish {
    phong 1
    ambient 0.2
    diffuse 0.3
  }
}
//-----------------------------------------------
#declare Table = union {
  difference {
    box {
      <-75, 0, -50>
      <75, 6, 50>
    }
#ifdef (HQ)
#declare R1=seed(1)
#declare i = 0
#while (i < 40)
    cone {
      <-80, 6, 0>, 4
      <-65, 6, 0>, 0
      scale <1, 1, 0.2>
      rotate (rand(R1)*30-15)*x
      translate <rand(R1)*5, rand(R1)*2, rand(R1)*100-50>
    }
    cone {
      <80, 6, 0>, 4
      <65, 6, 0>, 0
      scale <1, 1, 0.2>
      rotate (rand(R1)*30-15)*x
      translate <-rand(R1)*5, rand(R1)*2, rand(R1)*100-50>
    }
#declare i = i + 1
#end
#end
    texture { TOldWood }
    translate 80*y
  }
  union {
    box {
      <-3, 0, -3>
      <3, 80, 3>
      translate <-65, 0, -40>
    }
    box {
      <0, 0, 0>
      <6, 80, 6>
      translate <-65, 0, 40>
    }
    box {
      <0, 0, 0>
      <6, 80, 6>
      translate <65, 0, -40>
    }
    box {
      <0, 0, 0>
      <6, 80, 6>
      translate <65, 0, 40>
    }
    texture {
      TOldWood
      rotate 90*z
    }
  }
}
//-----------------------------------------------
#declare Torch = union {
  cone {
    <0, 0, 0>, 2
    <0, 40, 0>, 3
    texture {
      TOldWood
      rotate 90*z
    }
    rotate -25*x
  }
  union {
#declare R6 = seed(6)
#declare i = 0
#while (i<10)
    torus {
      2.5, 1
      rotate (rand(R6)*4-2)*y
      translate <rand(R6)/2-0.25, rand(R6)*7+35, rand(R6)/2-0.25>
      rotate -25*x
    }
#declare i = i + 1
#end
    pigment { color <0.2, 0.2, 0.2> }
  }

  // Torch-holder
  union {
    cylinder {
      <0, 0, 0>
      <0, 2, 0>, 3
      translate 20*y
      rotate -25*x
    }
    cylinder {
      <2.5, 19, -9>
      <10, 12, 2>, 0.5
    }
    cylinder {
      <-2.5, 19, -9>
      <-10, 12, 2>, 0.5
    }
    box {
      <11, 10, 1.5>
      <9, 14, 2>
    }
    box {
      <-11, 10, 1.5>
      <-9, 14, 2>
    }
    pigment { color <0.7, 0.7, 0.7> }
    finish {
      ambient 0.3
      diffuse 0.7
      brilliance 5.0
      specular 0.8    roughness 0.1
      reflection 0.15
    }
  }
  sphere {
    <0, 0, 0>, 1
    pigment { Clear }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.3
      color_map {
        [0.0   color rgbt <1, 0.5, 0, 1>]
        [1.0   color rgbt <1, 1, 0, -2>]
      }
      samples 6
      scale 0.5
      translate -1*y
    }
    hollow
    translate 1*y
    scale <15, 60, 15>
    translate <0, 30, -16>
  }
  light_source {
    <0, 43, 0>
    color <1, 1, 0.8>
    fade_distance 50
    fade_power 2

#ifdef (HQ)
    area_light <5, 0, 0>, <0, 0, 5>, 2, 2
    adaptive 1
    jitter
    rotate -25*x
#end
  }

  translate -2*z
}

//-----------------------------------------------
// <0, 0, 0> - <800, 0, 800>
//
#declare Floor = union {
  box {
    <0, -5, 0>
    <800, -20, 800>
    texture { TWater }
  }
  union {
#declare R2 = seed (2)
#declare ix = 0
#while (ix < 20)
  #declare iz = 0
  #while (iz < 20)
    superellipsoid {
      <0.25, 0.25>
      scale 20
      translate <40*ix+20+3*rand(R2), -20+2*rand(R2), 40*iz+20+3*rand(R2)>
    }
  #declare iz = iz + 1
  #end
#declare ix = ix + 1
#end
    texture { TStone }
  }
}
//-----------------------------------------------
#declare Wall = union {
  box {
    <-20, -10, -2>
    <820, 240, -38>
    pigment { color <0.15, 0.15, 0.15> }
  }
  union {
#declare R3 = seed (3)
#declare ix = -1
#while (ix < 11)
  #declare iy = 0
  #while (iy < 3)
    box {
      <-39, -19, -20>
      <39, 19, 20>
      translate <80*ix + 40 + rand(R3), 20+80*iy + rand(R3), -20.5 + rand(R3)>
    }
    box {
      <-39, -19, -20>
      <39, 19, 20>
      translate <80*ix + rand(R3), 20+80*iy+40 + rand(R3), -20.5 + rand(R3)>
    }
  #declare iy = iy + 1
  #end
#declare ix = ix + 1
#end
    texture { TStone }
  }
}
//-----------------------------------------------
#declare Ceiling = union {

#declare R4 = seed (4)
#declare ix = -1
#while (ix < 9)
  #declare iz = 0
  #while (iz < 3)
  box {
    <0, 0, 0>
    <100, 20, 300>
    translate <-50 + 100*ix, 240 - 10 + rand(R4), -30 + 300*iz>
  }
  #declare iz = iz + 1
  #end
#declare ix = ix + 1
#end
  texture { TStone }
}
//-----------------------------------------------
#declare Pole  = union {
  box {
    <-10, -10, -10>
    <10, 220, 10>
    texture {
      TOldWood
      rotate 90*z
    }
  }
  box {
    <0, -8, -8>
    <16, 100, 8>
    texture {
      TOldWood
      rotate 90*z
    }
    rotate 35*z
    translate <-8, 140, 0>
  }
  box {
    <-16, -8, -8>
    <0, 100, 8>
    texture {
      TOldWood
      rotate 90*z
    }
    rotate -35*z
    translate <8, 140, 0>
  }
  object {
    Torch
    translate <0, 140, -9>
  }
  object {
    Torch
    translate <0, 140, -9>
    rotate 180*y
  }
}
//-----------------------------------------------
#declare SupportingPoles  = union {
  box {
    <0, -10, -10>
    <800, 10, 10>
    translate 230*y
    texture { TOldWood }
  }
  object {
    Pole
    translate 13*20*x
  }
  object {
    Pole
    translate 27*20*x
  }
}

//-----------------------------------------------
object {
  Floor
}
object {
  Wall
  rotate 180*y
  translate <800, -10, 800>
}
object {
  Wall
  rotate -90*y
  translate <800, -10, 0>
}
object {
  Wall
  rotate 90*y
  translate <0, -10, 800>
}
object {
  Wall
  translate <0, -10, 0>
}
#ifdef (CEILING)
object {
  Ceiling
}
#end
object {
  SupportingPoles
  translate 13*20*z
}
object {
  SupportingPoles
  translate 27*20*z
}
union {
  object {
    Table
  }
  object {
    BloodCreature
    rotate -35*y
    translate <-45, 100, 20>
  }
  object {
    BloodCreature
    rotate -1*y
    translate <15, 100, 0>
  }
  rotate 10*y
  translate <610, 0, 420>
}

object {
  StrangeEngine
  rotate -10*y
  translate <410, 0, 620>
}

//-----------------------------------------------
