#include "colors.inc"
#include "finish.inc"
#include "metals.inc"

#declare ft=12

#declare mag_color = color rgb<.1,.1,.3>

#declare mag_light = union
    {
    cylinder // main grooved cylinder
        {
        0, z*12 .75
        texture
            {
            pigment{ color mag_color }
            normal { spiral1 10 }
            finish{ Shiny ambient 0.3 }
            scale .15
            }
        }
    sphere // top round part where the light is
        {
        0 1.5
        hollow
        scale <1,1,2>
        clipped_by { plane {z,0} }
        translate z*14
        }
    sphere // mirrored surface around the bulb
        {
        0 1.499
        hollow
        scale <1,1,2>
        clipped_by { plane {z,0} }
        translate z*14
        texture { T_Chrome_5E }
        }
    light_source
        {
        z*12.1 color 2
        spotlight
        point_at z*50*ft
        radius 5
        falloff 10
        tightness 20
        fade_distance 1*ft
        fade_power 1
        }
    texture
        {
        pigment{ color mag_color }
        finish{ Glossy ambient 0.3 }
        }
    }
