#include "colors.inc"
#include "woods.inc"

#declare ft = 12

// torch
#declare torch = union
    {
    // wood shaft - 3 Ft tall
    cone
        {
        0, 1, z*3*ft, 2.5
        texture { T_Wood14 }
        no_shadow
        }
    // cloth wrapped around the top
    torus
        {
        2 1.4
        no_shadow
        scale <.85,1,.85>
        rotate x*90
        translate z*(2*ft+12)
        texture { pigment{color rgb 0.7} finish {diffuse 0 ambient 0.3} }
        }
    torus
        {
        2 1.4
        no_shadow
        scale <.85,1,.85>
        rotate x*90+y*5
        translate z*(2*ft+10.5)
        texture { pigment{color rgb 0.6} finish {diffuse 0 ambient 0.2} }
        }
    // Flame - top area
    sphere
        {
        0, 1
        hollow
        no_shadow
        texture
            {
            pigment{ color Clear }
            halo
                {
                emitting
                spherical_mapping
                linear
                turbulence 2
                frequency 2
                color_map
                    {
                    [ 0  color rgbt <1, 0.3, 0.3, 1> ]
                    [ 0.1  color rgbt <1, 0.6, 0.2, -1> ]
                    [ 0.4  color rgbt <1, 0.6, 0.2, -1> ]
                    [ 1 color rgbft <1,.6,0,1,0> ]
                    }
                samples 10
                scale 0.4
                }
            }
        scale <6,6,10>
        translate z*3.5*ft
        }
    // Flame - main area
    sphere
        {
        0, 1
        hollow
        no_shadow
        texture
            {
            pigment{ color Clear }
            halo
                {
                emitting
                spherical_mapping
                linear
                turbulence 1.2
                frequency 2
                color_map
                    {
                    [ 0  color rgbt <1, 0.3, 0.3, 1> ]
                    [ 0.1  color rgbt <1, 0.6, 0.2, -.3> ]
                    [ 0.6  color rgbt <1, 0.6, 0.2, -.4> ]
                    [ 1 color rgbft <1,.6,0,1,0> ]
                    }
                samples 10
                scale .5
                }
            }
        scale 10
        translate z*3.3*ft
        }

    // torch light sources (7 of them)
    // center one
    light_source
        {
        z*3.5*ft
        color Yellow*0.75+Red/2
        fade_distance 2*ft
        fade_power 2
        }
    // 6 lights around the outside
#ifndef (R1)
    #declare R1 = seed(0)
#end
#declare torch_lights = 0
#while (torch_lights < 6)
    light_source
        {
        <3+rand(R1),0,3*ft>
        color (Yellow+Red/2)*0.5
        fade_distance 2*ft
        fade_power 2
        rotate z*torch_lights*(360/6)
        }
#declare torch_lights = torch_lights +1
#end
    scale 0.8
    }
