
// Persistence of Vision Ray Tracer Scene Description File
// File: fapure.pov
// Vers: 7.0
// Date: 08/04/97
// Auth: Franck Angella




#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"


camera
{
    location <-6.0 , 2.0 , -8.0>
    look_at <0.0 , 2.0 , 0.0>
}

light_source
{
    <0.0, 2.0, 0.0> //<4.0, 4.0, -8.0>
    color <1.5, 1.0, 1.0>
    fade_distance 4.0
    fade_power 2.0
    atmosphere off
    area_light
    <0.05, 0.0, 0.0> <0.0, 0.0, 0.05>
    2, 2
    adaptive 0
    jitter
    looks_like
    {
        sphere
        {
            <0.0, 0.0, 0.0>
            1.0
            pigment { rgbt <1.0, 1.0, 1.0, 1.0> }
            hollow
            halo
            {
                attenuating
                spherical_mapping
                cubic
                color_map
                {
                      [ 0.0 color rgbt <1.0, 1.0, 1.0, 1.0> ]
                      [ 1.0 color rgbt <2000.0, 2000.0, 2000.0, 0.5> ]
                }
                samples 10
            }
            scale 0.4
        }
    }
}

light_source
{
    <-10.0, 20.0, -2.0>
    color <1.2, 0.9, 0.9>
}

atmosphere
{
    type 1
    samples 100
    distance 100
    scattering 0.15
    aa_level 4
    aa_threshold 0.01
    jitter 0.5
}

/******************************************************/

#declare CoteDalle = 1.0
#declare RapportDalle = 0.25
#declare EpaisseurDalle = 0.01

#declare LargeurPiece = 20.0*CoteDalle
#declare ProfondeurPiece = 20.0*CoteDalle
#declare HauteurPiece = 5.0
#declare EpaisseurPlafond = 0.1
#declare EpaisseurMur = 0.1

#declare RayonColonne = 0.5
#declare HauteurSocle = 0.4
#declare RayonSocle = 0.8
#declare HauteurMoulure = 0.5
#declare RayonMoulure = 0.6
#declare RainureBas = 2.0*HauteurSocle
#declare RainureHaut = HauteurPiece-2.0*HauteurMoulure
#declare ProfondeurRainure = 0.05
#declare NbRainures = 10.0
#declare PeriodeColonne = 4.0

#declare RayonPlateforme = 3.5
#declare MarchePlateforme = 0.05
#declare LargeurMarchePlateforme = 0.2

#declare CotePiedPupitre = 0.07
#declare LongueurPiedPupitre = 2.5
#declare AnglePiedsAvantPupitre = 40.0
#declare EcartPiedsAvantPupitre = CotePiedPupitre
#declare InclinaisonPupitre = 20.0
#declare LargeurPlanchePupitre = 1.5
#declare HauteurPlanchePupitre = 0.8
#declare PositionPlanchePupitre = 2.7
#declare EpaisseurPlanchePupitre = 0.05
#declare LargeurRebordPlanchePupitre = 0.15

/******************************************************/

#declare RebordPupitre = box
{
    <-LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre, 0.0>
    <LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre-EpaisseurPlanchePupitre, -LargeurRebordPlanchePupitre>
}

#declare PlanchePupitre = difference
{
    box
    {
        <-LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre, 0.0>
        <LargeurPlanchePupitre/2.0, 0.0, -EpaisseurPlanchePupitre>
    }
    cylinder
    {
        <-LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre/2.0, 0.001>
        <-LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre/2.0, -EpaisseurPlanchePupitre-0.001>
        HauteurPlanchePupitre/2.0
    }
    cylinder
    {
        <LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre/2.0, 0.001>
        <LargeurPlanchePupitre/2.0, -HauteurPlanchePupitre/2.0, -EpaisseurPlanchePupitre-0.001>
        HauteurPlanchePupitre/2.0
    }
    cylinder
    {
        <0.0, -HauteurPlanchePupitre/2.0, 0.001>
        <0.0, -HauteurPlanchePupitre/2.0, -EpaisseurPlanchePupitre-0.001>
        (LargeurPlanchePupitre-HauteurPlanchePupitre)/6.0
    }
    cylinder
    {
        <0.0, -0.75*HauteurPlanchePupitre, 0.001>
        <0.0, -0.75*HauteurPlanchePupitre, -EpaisseurPlanchePupitre-0.001>
        (LargeurPlanchePupitre-HauteurPlanchePupitre)/6.0
    }
    cylinder
    {
        <0.0, -0.25*HauteurPlanchePupitre, 0.001>
        <0.0, -0.25*HauteurPlanchePupitre, -EpaisseurPlanchePupitre-0.001>
        (LargeurPlanchePupitre-HauteurPlanchePupitre)/6.0
    }
}

#declare PiedPupitre = box
{
    <-CotePiedPupitre/2.0, -LongueurPiedPupitre, -CotePiedPupitre/2.0>
    <CotePiedPupitre/2.0, 0.0, CotePiedPupitre/2.0>
}

#declare Pupitre = union
{
    union
    {
        object { PiedPupitre rotate -(AnglePiedsAvantPupitre/2.0)*z translate -(EcartPiedsAvantPupitre/2.0)*x }
        object { PiedPupitre rotate (AnglePiedsAvantPupitre/2.0)*z translate (EcartPiedsAvantPupitre/2.0)*x }
        object { PiedPupitre translate (LongueurPiedPupitre/3.0)*y }
        object { PlanchePupitre translate (LongueurPiedPupitre-PositionPlanchePupitre)*y }
        object { RebordPupitre translate (LongueurPiedPupitre-PositionPlanchePupitre)*y }
        translate (LongueurPiedPupitre*cos((pi)*AnglePiedsAvantPupitre/(180.0*2.0)))*y
        rotate InclinaisonPupitre*x
    }
    object
    {
        PiedPupitre
        rotate -InclinaisonPupitre*x
        translate (LongueurPiedPupitre*cos((pi)*InclinaisonPupitre/180.0))*y
        translate (LongueurPiedPupitre*sin((pi)*InclinaisonPupitre/180.0))*z
    }
    //pigment { Red }
    texture { pigment { P_WoodGrain2A color_map { M_Wood1A }} scale 5}
    texture { pigment { P_WoodGrain2B color_map { M_Wood1B }} scale 5}
    //translate 2.0*MarchePlateforme*y
    translate (-LongueurPiedPupitre*sin((pi)*InclinaisonPupitre/180.0))*z
    translate <-3.0, 0.0, 5.0>
}

#declare Plateforme = union
{
    cylinder
    {
        <0.0, -0.001, 0.0>
        <0.0, MarchePlateforme, 0.0>
        RayonPlateforme
    }
    cylinder
    {
        <0.0, MarchePlateforme-0.001, 0.0>
        <0.0, 2.0*MarchePlateforme, 0.0>
        RayonPlateforme-LargeurMarchePlateforme
    }
    //pigment { Red }
    texture { T_Stone15 }
}

#declare Dalle1 = union
{
    box
    {
        <0.0, -EpaisseurDalle, 0.0>
        <RapportDalle*CoteDalle, 0.0, RapportDalle*CoteDalle>
    }
    box
    {
        <RapportDalle*CoteDalle, -EpaisseurDalle, RapportDalle*CoteDalle>
        <CoteDalle, 0.0, CoteDalle>
    }
}

#declare Dalle2 = union
{
    box
    {
        <RapportDalle*CoteDalle, -EpaisseurDalle, 0.0>
        <CoteDalle, 0.0, RapportDalle*CoteDalle>
    }
    box
    {
        <0.0, -EpaisseurDalle, RapportDalle*CoteDalle>
        <RapportDalle*CoteDalle, 0.0, CoteDalle>
    }
}

#declare Sol = union
{
    #declare Nbx = LargeurPiece/CoteDalle
    #declare Nbz = ProfondeurPiece/CoteDalle
    #declare Countx = 1.0
    #while (Countx <= Nbx)
           #declare Countz = 1.0
           #while (Countz <= Nbz)
                  object
                  {
                        Dalle1 translate <(Countx-1.0)*CoteDalle, 0.0, (Countz-1.0)*CoteDalle>
                        //pigment { Red }
                        texture { T_Stone15 finish { reflection 0.5 } }
                  }
                  object
                  {
                        Dalle2 translate <(Countx-1.0)*CoteDalle, 0.0, (Countz-1.0)*CoteDalle>
                        //pigment { Yellow }
                        texture { T_Stone6 finish { reflection 0.5 } }
                  }
                  #declare Countz = Countz+1.0
           #end
           #declare Countx = Countx+1.0
    #end
    translate <-LargeurPiece/2.0, 0.0, -ProfondeurPiece/2.0>
}

#declare Mur1 = box
{
    <-EpaisseurMur/2.0, -EpaisseurDalle, -ProfondeurPiece/2.0>
    <EpaisseurMur/2.0, HauteurPiece, ProfondeurPiece/2.0>
}

#declare Mur2 = box
{
    <-LargeurPiece/2.0, -EpaisseurDalle, -EpaisseurMur/2.0>
    <LargeurPiece/2.0, HauteurPiece, EpaisseurMur/2.0>
}

#declare Murs = union
{
    object { Mur1 translate LargeurPiece/2.0*x }
    object { Mur1 translate -LargeurPiece/2.0*x }
    object { Mur2 translate ProfondeurPiece/2.0*z }
    object { Mur2 translate -ProfondeurPiece/2.0*z }
    //pigment { White }
    texture { pigment { rgb <0.7, 0.6, 0.6> } normal { agate agate_turb 0.5 } }
}

#declare Plafond = union
{
    difference
    {
        box
        {
            <1.0-0.75*LargeurPiece/2.0, HauteurPiece+0.001, 1.0-0.75*ProfondeurPiece/2.0>
            <-1.0+0.75*LargeurPiece/2.0, HauteurPiece-0.1, -1.0+0.75*ProfondeurPiece/2.0>
        }
        cylinder
        {
            <0.0, HauteurPiece+0.002, 0.0>
            <0.0, HauteurPiece-0.1-0.001, 0.0>
            4.5
        }
         texture { T_Stone24 }
    }
    union
    {
        torus
        {
            4.0, 0.1
            translate HauteurPiece*y
        }
        torus
        {
            3.5, 0.05
            translate HauteurPiece*y
        }
        torus
        {
            1.5, 0.05
            translate HauteurPiece*y
        }
        cylinder
        {
            <-0.75*LargeurPiece/2.0, HauteurPiece, -0.75*ProfondeurPiece/2.0>
            <0.75*LargeurPiece/2.0, HauteurPiece, -0.75*ProfondeurPiece/2.0>
            0.1
        }
        cylinder
        {
            <-0.75*LargeurPiece/2.0, HauteurPiece, 0.75*ProfondeurPiece/2.0>
            <0.75*LargeurPiece/2.0, HauteurPiece, 0.75*ProfondeurPiece/2.0>
            0.1
        }
        cylinder
        {
            <-0.75*LargeurPiece/2.0, HauteurPiece, -0.75*ProfondeurPiece/2.0>
            <-0.75*LargeurPiece/2.0, HauteurPiece, 0.75*ProfondeurPiece/2.0>
            0.1
        }
        cylinder
        {
            <0.75*LargeurPiece/2.0, HauteurPiece, -0.75*ProfondeurPiece/2.0>
            <0.75*LargeurPiece/2.0, HauteurPiece, 0.75*ProfondeurPiece/2.0>
            0.1
        }
        texture { T_Stone24 }
    }
    difference
    {
    box
    {
        <-1.0-LargeurPiece/2.0, HauteurPiece-0.001, -1.0-LargeurPiece/2.0>
        <1.0+LargeurPiece/2.0, HauteurPiece+EpaisseurPlafond, 1.0+LargeurPiece/2.0>
    }
    cylinder
    {
        <0.0, HauteurPiece-1.0, 0.0>
        <0.0, HauteurPiece+EpaisseurPlafond+1.0, 0.0>
        1.0
    }
    difference
    {
        cylinder
        {
            <0.0, HauteurPiece-1.0, 0.0>
            <0.0, HauteurPiece+EpaisseurPlafond+1.0, 0.0>
            3.0
        }
        cylinder
        {
            <0.0, HauteurPiece-2.0, 0.0>
            <0.0, HauteurPiece+EpaisseurPlafond+2.0, 0.0>
            2.0
        }
        box
        {
            <-4.0, HauteurPiece-2.0, -0.5>
            <4.0, HauteurPiece+EpaisseurPlafond+2.0, 0.5>
        }
        box
        {
            <-0.5, HauteurPiece-2.0, -4.0>
            <0.5, HauteurPiece+EpaisseurPlafond+2.0, 4.0>
        }
    }
    pigment { rgb <1.1, 1.0, 1.0> }
    }
}

#declare Creuseur = union
{
    cylinder
    {
        <0.0, RainureBas, 0.0>
        <0.0, RainureHaut, 0.0>
        ProfondeurRainure
    }
    sphere
    {
        <0.0, RainureBas, 0.0>
        ProfondeurRainure
    }
    sphere
    {
        <0.0, RainureHaut, 0.0>
        ProfondeurRainure
    }
    translate RayonColonne*x
}

#declare Colonne = union
{
    difference
    {
        cylinder
        {
            <0.0, 0.0-0.001, 0.0>
            <0.0, HauteurPiece+0.001, 0.0>
            RayonColonne
        }
        #declare Angle = 360.0/NbRainures
        #declare Count = 1.0
        #while (Count <= NbRainures)
               object { Creuseur rotate (Count*Angle)*y }
               #declare Count = Count+1.0
        #end
    }
    box
    {
        <-RayonSocle, 0.0-0.001, -RayonSocle>
        <RayonSocle, HauteurSocle, RayonSocle>
    }
    torus
    {
        RayonColonne+(RayonSocle-RayonColonne)/2.0,
        (RayonSocle-RayonColonne)/2.0
        translate (HauteurSocle+(RayonSocle-RayonColonne)/2.0)*y
    }
    box
    {
        <-RayonMoulure , HauteurPiece+0.001, -RayonMoulure>
        <RayonMoulure , HauteurPiece+0.001-HauteurMoulure/2.0, RayonMoulure>
    }
    box
    {
        <-RayonColonne, HauteurPiece+0.001-HauteurMoulure/2.0, -RayonColonne>
        <RayonColonne, HauteurPiece+0.001-HauteurMoulure, RayonColonne>
    }
}

#declare Colonnes = union
{
    #declare Pos = PeriodeColonne-LargeurPiece/2.0
    #while (Pos < LargeurPiece/2.0)
           object { Colonne translate <Pos, 0.0, ProfondeurPiece/2.0-EpaisseurMur/2.0-RayonSocle> }
           object { Colonne translate <Pos, 0.0, -ProfondeurPiece/2.0+EpaisseurMur/2.0+RayonSocle> }
           #declare Pos = Pos+PeriodeColonne
    #end
    #declare Pos = PeriodeColonne-ProfondeurPiece/2.0
    #while (Pos < ProfondeurPiece/2.0)
           object { Colonne translate <LargeurPiece/2.0-EpaisseurMur/2.0-RayonSocle, 0.0, Pos> }
           object { Colonne translate <-LargeurPiece/2.0+EpaisseurMur/2.0+RayonSocle, 0.0, Pos> }
           #declare Pos = Pos+PeriodeColonne
    #end
    //pigment { Blue }
    texture { T_Stone24 }
}

/******************************************************/

#declare RayonMegaSphere = 1.3
#declare HauteurMegaSphere = 2.0

/******************************************************/

#declare MegaHalo = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
    hollow
    halo
    {
        attenuating
        spherical_mapping
        linear
        color_map
        {
            [ 0.0 color rgbt <1.0, 0.0, 0.0, 1.0> ]
            [ 1.0 color rgbt <1.0, 0.0, 0.0, 0.0> ]
        }
        samples 10
    }
    scale RayonMegaSphere*2.0
    translate HauteurMegaSphere*y
}

#declare MegaSphere = sphere
{
    <0.0, 0.0, 0.0>
    1.0
    texture
    {
        pigment
        {
            agate
            color_map
            {
                [0.1 color rgb <2.0, 0.0, 0.5> ]
                [0.15 color rgb <1.0, 0.0, 0.0> ]
                [0.4 color rgbt <1.0, 1.0, 1.0, 1.0> ]
            }
         }
         scale 1.5
    }
    halo
    {
       glowing
       linear
       spherical_mapping
       turbulence 0.5
       colour_map
       {
           [ 0.0 color rgbf <1.0, 0.0, 1.0, 0.4> ]
           [ 0.5 color rgbf <1.0, 0.0, 0.0, 1.0> ]
           [ 0.8 color rgbt <1.0, 1.0, 1.0, 1.0> ]
       }
       samples 10
       aa_level 5
       aa_threshold 0.1
       jitter 0.8
    }
    hollow
    scale RayonMegaSphere
    translate HauteurMegaSphere*y
}

/******************************************************/

#declare px0 = 0.0
#declare py0 = HauteurMegaSphere
#declare pz0 = 0.0
#declare px1 = 3.0
#declare py1 = 2.0
#declare pz1 = -1.0
#declare px2 = 3.0
#declare py2 = 2.1
#declare pz2 = -5.0
#declare px3 = 8.0
#declare py3 = 2.5
#declare pz3 = -8.0
#declare NbElements = 2000.0
#declare DeltaT = 0.01
#declare RmaxD = 0.5
#declare RmaxF = 1.0
#declare RayonElement = 0.4

/******************************************************/

#declare Glace = blob
{
    threshold 0.3

    #declare S0 = seed(0)
    #declare S1 = seed(1)
    #declare S2 = seed(2)
    #declare Count = 1.0
    #while (Count <= NbElements)
           #declare T = DeltaT+(3.0-DeltaT)*rand(S0)
           #declare R = RmaxD+T*(RmaxF-RmaxD)/3.0
           #declare Theta = 360.0*rand(S2)
           #declare Facteur0 = ((T-1)*(T-2)*(T-3))/((0-1)*(0-2)*(0-3))
           #declare Facteur1 = ((T)*(T-2)*(T-3))/((1)*(1-2)*(1-3))
           #declare Facteur2 = ((T)*(T-1)*(T-3))/((1)*(2-1)*(2-3))
           #declare Facteur3 = ((T)*(T-1)*(T-2))/((1)*(3-1)*(3-2))
           #declare Xpos = Facteur0*px0+Facteur1*px1+Facteur2*px2+Facteur3*px3
           #declare Ypos = Facteur0*py0+Facteur1*py1+Facteur2*py2+Facteur3*py3
           #declare Zpos = Facteur0*pz0+Facteur1*pz1+Facteur2*pz2+Facteur3*pz3
           #declare T = T-DeltaT
           #declare Facteur0 = ((T-1)*(T-2)*(T-3))/((0-1)*(0-2)*(0-3))
           #declare Facteur1 = ((T)*(T-2)*(T-3))/((1)*(1-2)*(1-3))
           #declare Facteur2 = ((T)*(T-1)*(T-3))/((1)*(2-1)*(2-3))
           #declare Facteur3 = ((T)*(T-1)*(T-2))/((1)*(3-1)*(3-2))
           #declare Xpos2 = Facteur0*px0+Facteur1*px1+Facteur2*px2+Facteur3*px3
           #declare Ypos2 = Facteur0*py0+Facteur1*py1+Facteur2*py2+Facteur3*py3
           #declare Zpos2 = Facteur0*pz0+Facteur1*pz1+Facteur2*pz2+Facteur3*pz3
           #declare dX = (Xpos2-Xpos)/DeltaT
           #declare dY = (Ypos2-Ypos)/DeltaT
           #declare dZ = (Zpos2-Zpos)/DeltaT
           #declare AlphaY = (180.0/pi)*atan2(dZ, dX)-90.0
           #declare AlphaX = (180.0/pi)*atan2(dY, dZ)
           sphere
           {
                <0.0, 0.0, 0.0>, RayonElement, 1.0
                translate R*x
                rotate Theta*z
                rotate AlphaY*y
                rotate AlphaX*x
                translate <Xpos, Ypos, Zpos>
           }
           #declare Count = Count+1.0
    #end
    sturm
}

#declare FaisceauGlace = difference
{
    object { Glace }
    sphere { <0.0, HauteurMegaSphere, 0.0> RayonMegaSphere }
    //pigment { Green }
    texture { T_Glass3 }
}

#declare Main = blob
{
    threshold 0.8
    //1
    cylinder { <-2.0, 0.0, 0.0>, <-6.0, 1.0, 3.0>, 3.0, 1.0 }
    cylinder { <-6.0, 1.0, 3.0>, <-6.0, 1.0, 5.5>, 1.0, 1.0 }
    //2
    cylinder { <-1.5, 0.0, 0.0>, <-3.0, 0.8, 7.0>, 2.5, 1.0 }
    cylinder { <-3.0, 0.8, 7.0>, <-3.0, -1.0, 9.0>, 0.5, 1.0 }
    //3
    cylinder { <0.0, 0.0, 0.0>, <-0.2, 0.8, 7.2>, 2.0, 1.0 }
    cylinder { <-0.2, 0.8, 7.2>, <-0.2, -1.0, 9.0>, 0.5, 1.0 }
    //4
    cylinder { <1.0, 0.0, 0.0>, <2.0, 0.7, 6.5>, 1.5, 1.0 }
    cylinder { <2.0, 0.7, 6.5>, <2.0, -0.2, 8.0>, 0.5, 1.0 }
    //5
    cylinder { <2.0, 0.0, 0.0>, <3.5, 0.5, 4.0>, 1.7, 1.0 }
    sturm
    scale <1.0, 1.0, 1.5>
    scale 0.01
    rotate 5.0*y
    rotate 5.0*z
    texture
    {
        pigment
        {
            agate
            color_map
            {
                [0.1 color rgb <0.0, 0.5, 0.25> ]
                [0.15 color rgb <0.25, 0.5, 0.0> ]
                [0.8 color rgb <0.5, 0.5, 0.0> ]
            }
         }
         normal { bumps 0.5 }
         finish { reflection 0.3 }
         scale 0.01
    }
    scale <1.0, 1.1, 1.0>
    translate <-6.0*0.98, 1.9, -8.0*0.983>
}

/******************************************************/

#declare Feu = union
{
    cone
    {
        <0.0, 0.0, 0.0>, 0.5
        <0.0, 1.0, 0.0>, 0.2
        hollow
        texture
        {
            pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
        }
        halo
        {
            emitting
            linear
            cylindrical_mapping
            turbulence 1.2
            color_map
            {
                    [ 0.0 color rgbt <1.0, 0, 0, 1.0> ]
                    [ 0.2 color rgbt <1.0, 0, 0, -1.0> ]
                    [ 0.7 color rgbt <1.0, 1.0, 0, -1.0> ]
                    [ 1.0 color rgbt <1.0, 1.0, 1.0, -1.0> ]
            }
            frequency 3.0
            samples 20
            scale 0.5
        }
    }
    cone
    {
        <0.0, 0.0, 0.0>, 0.9
        <0.0, 1.0, 0.0>, 0.4
        hollow
        texture
        {
            pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
        }
        halo
        {
               glowing
               linear
               cylindrical_mapping
               turbulence 1.2
               colour_map
               {
                   [ 0.0 color rgbt <1.0, 1.0, 1.0, 1.0> ]
                   [ 0.8 color rgbt <1.0, 1.0, 1.0, -0.2> ]
               }
               frequency 2.0
               samples 20
               aa_level 5
               aa_threshold 0.1
               jitter 0.8
         }
    }
    scale <1.0, 6.0, 1.0>
    rotate -90.0*z
    translate -6.0*x //-6.5*x
    translate HauteurMegaSphere*y
}

#declare Feu2 = union
{
    cone
    {
        <0.0, 0.0, 0.0>, 0.2
        <0.0, 1.0, 0.0>, 0.4
        hollow
        texture
        {
            pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
        }
        halo
        {
            emitting
            linear
            cylindrical_mapping
            turbulence 1.2
            color_map
            {
                    [ 0.0 color rgbt <1.0, 0, 0, 1.0> ]
                    [ 0.2 color rgbt <1.0, 0, 0, -1.0> ]
                    [ 0.7 color rgbt <1.0, 1.0, 0, -1.0> ]
                    [ 1.0 color rgbt <1.0, 1.0, 1.0, -1.0> ]
            }
            frequency 3.0
            samples 20
            scale 0.5
        }
    }
    cone
    {
        <0.0, 0.0, 0.0>, 0.25
        <0.0, 1.0, 0.0>, 0.45
        hollow
        texture
        {
            pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
        }
        halo
        {
               glowing
               linear
               cylindrical_mapping
               turbulence 1.2
               colour_map
               {
                   [ 0.0 color rgbt <1.0, 1.0, 1.0, 1.0> ]
                   [ 0.8 color rgbt <1.0, 1.0, 1.0, -0.2> ]
               }
               frequency 2.0
               samples 20
               aa_level 5
               aa_threshold 0.1
               jitter 0.8
         }
    }
    scale <1.0, 8.0, 1.0>
    rotate 90.0*x
    translate 1.0*z
    rotate -5.0*y
    translate <-6.0*0.98, 1.2, -8.0*0.983>
    translate 0.7*x
}

/******************************************************/

#declare NbFragments = 500.0
#declare DistanceMoy = 4.0
#declare Rayon = 0.02
#declare Count = 1.0
#declare S4 = seed(4)
#declare S5 = seed(5)
#declare S6 = seed(6)

/******************************************************/

#declare Tornade = union
{
    #while (Count <= NbFragments)
           #declare AngleY = 360.0*rand(S4)
           #declare AngleZ = -30.0+60.0*rand(S5)
           #declare Distance = DistanceMoy+0.5*rand(S6)
           cone
           {
                <0.0, 0.0, 0.0>, Rayon
                <0.0, 0.0, -6.0*Rayon>, 0.0
                translate Distance*x
                rotate AngleY*y
                rotate AngleZ*z
                translate HauteurMegaSphere*y
                no_shadow
           }
           #declare Count = Count+1.0
    #end
    pigment { White }
}



/******************************************************/

object { Sol }
object { Murs }
object { Plafond }
object { Colonnes }
object { Plateforme }
object { Pupitre }
object { FaisceauGlace }
object { MegaSphere }
object { MegaHalo }
object { Main }
object { Feu }
object { Feu2 }
//object { Tornade }

/******************************************************/
