// Persistence of Vision Raytracer
// Billo Gatini

#ifndef (MAIN_POV)
#include "common.inc"
#end
#include "sPatch\tete1.pov"
//#include "sPatch\pant1.pov"
/******************************************************************************
   A faire:
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Billo_TCost1=texture{
   pigment {
      Clear
      }
   normal {
      crackle
      bump_size 10
      scale .5
      }
   finish {
      phong 100000
      phong_size 100  //densit de paillettes
      }
   }
#declare Billo_TCost2=texture{
   pigment {
      marble
      turbulence 0.5
      octaves 2
      scale 12//20
      color_map {
         [0.0 Pink]
         [0.1 Pink]
         [0.1 Black]
         [0.2 Black]
         [0.2 Green]
         [0.3 Green]
         [0.3 Black]
         [0.4 Black]
         [0.4 Yellow]
         [0.5 Yellow]
         [0.5 Black]
         [0.6 Black]
         [0.6 LightBlue]
         [0.7 LightBlue]
         [0.7 Black]
         [0.8 Black]
         [0.8 Gray80]
         [0.9 Gray80]
         [0.9 Black]
         [1.0 Black]
         }
      }
   finish {
      diffuse 0.3
      ambient 0.1
      }
   }

#declare Billo_TCost=
   texture{Billo_TCost2}
   texture{Billo_TCost1}

#declare Billo_TYeux=texture{
   pigment {
      gradient x color_map{
         [0.00 color White]
         [0.50 color White]
         [0.80 color MediumWood ]
         [0.95 color Brown]
         [0.95 color Black]
         [1.00 color Black]
         }
      }
   }

#declare Billo_TTurban=texture{
   pigment{
      spiral1 3
      color_map {
         [0.00 color Yellow]
         [0.50 color Red]
         [1.00 color Yellow]
         }
      turbulence 0.1
      scale <5, 5, 5> translate 0*y
      }
   }

#declare Billo_TBordure=texture{
      pigment {rgb <1, .8, .3>}
      finish {
         phong 100
         phong_size 100
         ambient 0.1
         diffuse 0.8
         metallic
         }
   }

/******************************************************************************

        objets

******************************************************************************/

#declare Billo_Veste=object{
   union{
      intersection{
         difference {
            sphere {0, 1 scale <25, 80, 10> }
            intersection{
               box {<  0, 0, -50> <50, 50, 50> rotate 12*z}//15
               box {<-50, 0, -50> < 0, 50, 50> rotate -12*z}
               }
            translate 125*y
            }
         box {<-30, 90, -10> <30, 160, 10>}
         }
      difference{
         cone {159*y, 2, 165*y, 1 scale <8, 1, 6>}
         cylinder {159*y, 175*y, 1 scale <6, 1, 6>}
         plane {-y, 0 rotate 40*x translate 163*y}
         }
      }
   texture{Billo_TCost}
   }

#declare Billo_Chemise=object{
   union{
      intersection{
         sphere {0, 1 scale <25, 80, 9.9> translate 125*y}
         box {<-20, 100, -9> <20, 160, 9.9>}
         }
      difference{
         cylinder {159*y, 164*y, 1 scale <6, 1, 6>}
         box {<-5, -5, 0>, <5, 5, 20> rotate 45*z translate 168*y}
         }
      }
   texture{
      pigment {White}
      normal {bumps 0.3}
      }
   }

#declare Billo_PBoutons=object{
   union{
      sphere {0, .32 translate <0, 125+80*sin(radians(20)), 10*cos(radians(20))>}
      sphere {0, .32 translate <0, 125+80*sin(radians(18)), 10*cos(radians(18))>}
      sphere {0, .32 translate <0, 125+80*sin(radians(16)), 10*cos(radians(16))>}
      sphere {0, .32 translate <0, 125+80*sin(radians(14)), 10*cos(radians(14))>}
      sphere {0, .32 translate <0, 125+80*sin(radians(12)), 10*cos(radians(12))>}
      sphere {0, .32 translate <0, 125+80*sin(radians(10)), 10*cos(radians(10))>}
      sphere {0, .32 translate <0, 125+80*sin(radians( 8)), 10*cos(radians( 8))>}
      sphere {0, .32 translate <0, 125+80*sin(radians( 6)), 10*cos(radians( 6))>}
      sphere {0, .32 translate <0, 125+80*sin(radians( 4)), 10*cos(radians( 4))>}
      sphere {0, .32 translate <0, 125+80*sin(radians( 2)), 10*cos(radians( 2))>}
      sphere {0, .32 translate <0, 125+80*sin(radians( 0)), 10*cos(radians( 0))>}
      }
   texture{
      pigment {Gray90}
      normal {bumps 0.1}
      finish {
         irid {
            .25
            thickness 1
            turbulence 1
            }
         }
      }
   scale 1.03
   }

#declare Billo_Noeud=object{
   intersection{
      union{
         sphere {0, 1 scale <1.5, 1, .5>}
         cylinder {-z/4, z/4, 1 scale <5, 2, 1> translate 5*x}
         cylinder {-z/4, z/4, 1 scale <5, 2, 1> translate -5*x}
         }
      box {<-6, -3, -3> <6, 3, 3>}
      }
   texture{
      pigment {
         spiral1 2
         turbulence .1
         color_map {
            [0 color White]
            [1 color Red]
            }
         rotate 90*x
         scale 3
         }
      normal {bumps 0.1}
      }
   }

#declare Billo_GBoutons=object{
   union{
      sphere {0, 1 scale <1.5, 1.5, .5> translate <0, 110, 10>}
      sphere {0, 1 scale <1.5, 1.5, .5> translate <0, 102, 10>}
      sphere {0, 1 scale <1.5, 1.5, .5> translate <0,  94, 10>}
      }
   texture{
      pigment {rgb <1, .7, .2>}
      finish {
         phong 100
         phong_size 100
         ambient 0.1
         diffuse 0.8
         metallic
         }
      }
   translate (5+1)*y
   }

#declare Billo_Bordure=object{
   union{
      intersection {
         union{
            box {<-19, -.25, 0> <-8, .25, 50> translate -15*y}
            box {<8, -.25, 0> <19, .25, 50> translate -15*y}
            box {<-0.25, 0, -50> < 0.25, 37, 50> rotate 25*z}
            box {<-0.25, -8, -50> < 0.25, 37, 50> rotate -25*z}
            box {<-0.25-8*sin(radians(25)), -35, -50> < 0.25-8*sin(radians(25)), -8*cos(radians(25)), 50>}
            }
         sphere {0, 1 scale <25, 80, 10>*1.01 }
         }
      }
   texture{Billo_TBordure}
   }

#declare Billo_ColD=object{
   intersection{
      sphere {0, 1 scale <25, 80, 10> }
      box {<-50, 0, -50> <0, 50, 50> rotate 12*z}
      box {<0, 0, -50> < 50, 37, 50> rotate 25*z}
      plane {y, 35}
      translate <0, 125, .005>
      }
   texture{Billo_TCost translate 718367}
   finish {
      diffuse 0.25
      ambient 0.1
      }
   }

#declare Billo_ColG=object{
   intersection{
      sphere {0, 1 scale <25, 80, 10> }
      box {<0, 0, -50> <50, 50, 50> rotate -12*z}
      box {<-50, 0, -50> <0, 37, 50> rotate -25*z}
      plane {y, 35}
      translate <0, 125, .005>
      }
   texture{Billo_TCost translate 5416}
   finish {
      diffuse 0.4
      ambient 0.1
      }
   }

#declare Billo_Tronc=union{
   object {Billo_Veste}
   object {Billo_Chemise}
   object {Billo_PBoutons}
   object {Billo_GBoutons}
   object {Billo_ColD}
   object {Billo_ColG}
   object {Billo_Bordure translate 125*y}
   object {Billo_Noeud translate <0, 160, 9>}
   }

//**************************************************************************** TETE

#declare Billo_Tete1_=object{
   union{
      intersection {
         object{Hyperboloid_Y }
         box {<-50, -2, -50> <50, 1, 50>}
         scale 4//<.5, 1, .5>
         translate -10*y
         }
      sphere {0, 1 scale <8, 10, 8>*1.2 }
      cone {0, 0, -y, 1 scale <2, 6, 3> translate 8*z rotate -15*x}
      }
   texture{pigment {Tan}}
   }

#declare Billo_Tete1=object{
   object{STete1 scale <-8, 8, -6> translate <0, 0/*-2*/, 0>}
   texture{pigment {Tan}}
   }

#declare Billo_Turban=object{
   intersection{
      julia_fractal {
         <-0.083,0.0,-0.83,-0.025>
         quaternion
         cube
         max_iteration 12
         precision 15
         slice <1,0,-1,1>,0
         scale 18
         rotate 90*z rotate -55*x
         }
      box {<-20, -8, -20>, <20, 9, 20>}
      bounded_by {box {<-20, -8, -20>, <20, 9, 20>}}
      }
   scale <1.5, 1.8, 1.5>
   texture {Billo_TTurban rotate 30*x}
   }

#declare Billo_Barbe=object{
   intersection{
      julia_fractal {
         <-0.083,0.0,-0.83,-0.025>
         quaternion
         sqr
         max_iteration 12
         precision 15
         slice <1,0,-1,1>,0
         scale 5
         rotate 90*z rotate -90*x
         }
      plane {y, 9}
      }
   scale <.98, 1.0, 1>
   texture {pigment{Gray40}}
   }

#declare Billo_Oeil=object {
   sphere {0, 1}
   texture {Billo_TYeux}
   scale <2, 2, 2> rotate -90*y rotate 10*x
   }

#declare Billo_Sourcil=object {
   difference{
      cone {y, 0, -y, 1 scale <3, 1, .5>}
      sphere {0, 1 scale <.8, 2, .8>  scale <3, 1, .5> translate -2*y}
      }
   texture {
      pigment{Gray40}
      normal {crackle scale .2 turbulence 1 bump_size 5}
      }
   //rotate -90*y
   rotate 0*x
   }

#declare Billo_Pierre=object{
   union{
      object {Icosahedron}
      object {Icosahedron scale <1, -1, 1>}
      }
   texture {
      pigment {rgbt <.2, .7, .3, .7>}
      finish {
         ambient 0.1
         diffuse 1//0.4
         refraction 1
         ior 1.6
         caustics 1.0
         phong 1
         phong_size 30
         }
      }
   scale <3, 4, 2>
   //no_shadow
   }

#declare Billo_Tete=union{
   object {Billo_Tete1 translate 0*y}            //Peau
   object {Billo_Turban rotate 25*x translate <0, 11, -5>}
   object {Billo_Pierre translate <0, 12, 10>}
   object {Billo_Barbe scale <1, 1.5, 1> translate <0, -4, 8>}
   object {Billo_Oeil translate <3.5, 0.5, 9>}
   object {Billo_Oeil rotate -5*y translate <-3.5, 0.5, 9>}
   object {Billo_Sourcil rotate -5*y translate <-4, 4.0, 8.5>}
   object {Billo_Sourcil rotate -5*y translate <4, 4.0, 8.5>}
   }

//******************************************************************************* BRAS
#declare Billo_ChemG=object{//Manche gauche
   union{
      union {
         cylinder {0, 32*x, 1 open scale <1, 4, 4> hollow translate 3*y}
         rotate 50*y
         translate 30*x
         }
      }
   texture{
      pigment {White}
      normal {bumps 0.3}
      finish {
         ambient 0.1
         diffuse 0.7
         phong 3
         phong_size 5
         }
      }
   rotate -120*y rotate 20*x
   }

#declare Billo_ChemD=object{//Manche droite
   union{
      union {
         cylinder {0, 32*x, 1 open scale <1, 4, 4> hollow translate 3*y}
         rotate -30*y
         translate 30*x
         }
      }
   texture{
      pigment {White}
      normal {bumps 0.3}
      finish {
         ambient 0.1
         diffuse 0.7
         phong 3
         phong_size 5
         }
      }
   rotate -70*y rotate 10*x
   }

#declare Billo_MancheD=object{//Manche droite
   union{
      cylinder {0, 30*x, 1 scale <1, 8, 5>}
      union {
         sphere {0, 1 scale <5, 8, 5>}
         cylinder {0, 30*x, 1 open scale <1, 8, 5> hollow}
         rotate 50*y
         translate 30*x
         }
      }
   texture{Billo_TCost translate 8971}
   rotate -120*y rotate 20*x
   }

#declare Billo_MancheG=object{//Manche gauche
   union{
      cylinder {0, 30*x, 1 scale <1, 8, 5>}
      union {
         sphere {0, 1 scale <5, 8, 5>}
         cylinder {0, 30*x, 1 open scale <1, 8, 5> hollow}
         rotate -30*y
         translate 30*x
         }
      }
   texture{Billo_TCost translate 8971}
   rotate -70*y rotate 10*x
   }

#declare Billo_MainG=object{// main gauche
blob {
   threshold 0.5
   component 1.000000, 1.508230, <-0.413502, 0.025316, 0.000000>
   component 1.000000, 1.599720, <0.430380, -0.008439, 0.000000>
   component 1.000000, 1.457520, <-0.548523, -1.189870, 0.000000>
   component 1.000000, 1.434800, <0.700422, -1.206750, 0.000000>
   component 1.000000, 0.983246, <1.493670, -0.548523, 0.000000>
   component 1.000000, 0.747382, <1.729960, 0.109705, 0.000000>
   component 1.000000, 0.683805, <1.797470, 0.683544, 0.000000>
   component 1.000000, 0.676372, <1.822780, 1.215190, 0.000000>
   component 1.000000, 0.714533, <0.759494, 0.911392, 0.000000>
   component 1.000000, 0.676372, <0.742616, 1.502110, 0.000000>
   component 1.000000, 0.749914, <0.741693, 2.159151, 0.000000>
   component 1.000000, 0.708316, <0.741693, 2.785469, 0.000000>
   component 1.000000, 0.718941, <0.741693, 3.411788, 0.000000>
   component 1.000000, 0.679169, <-0.210970, 1.088610, 0.000000>
   component 1.000000, 0.714533, <-0.247231, 1.730617, 0.000000>
   component 1.000000, 0.629936, <-0.313159, 2.356936, 0.000000>
   component 1.000000, 0.698434, <-0.346123, 3.016218, 0.000000>
   component 1.000000, 0.715417, <-0.379088, 3.642537, 0.000000>
   component 1.000000, 0.640875, <-1.021100, 1.021100, 0.000000>
   component 1.000000, 0.621859, <-1.203191, 1.598761, 0.000000>
   component 1.000000, 0.670744, <-1.368012, 2.192115, 0.000000>
   component 1.000000, 0.620842, <-1.598761, 2.818434, 0.000000>
   component 1.000000, 1.210770, <-1.434600, -0.151899, 0.000000>
   component 1.000000, 1.241680, <-1.333330, -1.265820, 0.000000>
   component 1.000000, 0.670743, <-1.862474, 0.741693, 0.000000>
   component 1.000000, 0.674501, <-2.126187, 1.335047, 0.000000>
   component 1.000000, 0.785310, <1.805910, 1.907170, 0.000000>
   component 1.000000, 0.555298, <-2.455828, 1.862474, 0.000000>
   component -0.691503, 2.521970, <-0.510944, -0.181303, -1.829509>
   }
   pigment {White}
   scale 2.5
   rotate -120*y
   translate <34, 3, 0> rotate -30*y translate 30*x rotate -70*y rotate 10*x
   }

#declare Billo_MainD=object{ // main droite
blob {
   threshold 0.6
   component 1.000000, 1.508230, <-0.413502, 0.025316, 0.000000>
   component 1.000000, 1.599720, <0.430380, -0.008439, 0.000000>
   component 1.000000, 1.457520, <-0.548523, -1.189870, 0.000000>
   component 1.000000, 1.434800, <0.700422, -1.206750, 0.000000>
   component 1.000000, 0.983246, <1.170227, -0.510944, -0.477980>
   component 1.000000, 0.747382, <1.279008, 0.145042, -0.939478>
   component 1.000000, 0.683805, <1.532832, 0.576872, -1.302083>
   component 1.000000, 0.676372, <1.753692, 0.962553, -1.664689>
   component 1.000000, 0.714533, <0.759494, 0.911392, 0.000000>
   component 1.000000, 0.676372, <0.751582, 1.384494, 0.000000>
   component 1.000000, 0.749914, <0.672468, 1.938291, -0.515065>
   component 1.000000, 0.708316, <0.646097, 1.674578, -1.256758>
   component 1.000000, 0.718941, <0.593354, 1.542722, -0.968321>
   component 1.000000, 0.679169, <-0.210970, 1.088610, 0.000000>
   component 1.000000, 0.714533, <-0.312236, 1.746840, 0.000000>
   component 1.000000, 0.629936, <-0.408755, 1.832806, -0.638680>
   component 1.000000, 0.698434, <-0.382384, 1.621835, -0.885911>
   component 1.000000, 0.715417, <-0.276899, 1.279008, -1.256758>
   component 1.000000, 0.640875, <-0.962553, 0.857068, -0.020603>
   component 1.000000, 0.621859, <-1.462783, 1.462783, -0.309039>
   component 1.000000, 0.670744, <-1.331751, 1.437236, -0.803501>
   component 1.000000, 0.620842, <-1.173523, 1.041667, -1.215552>
   component 1.000000, 1.210770, <-1.434600, -0.151899, 0.000000>
   component 1.000000, 1.241680, <-1.333330, -1.265820, 0.000000>
   component 1.000000, 0.670743, <-2.042190, 0.638680, -0.556270>
   component 1.000000, 0.674501, <-1.998451, 0.515065, -1.256758>
   component 1.000000, 0.785310, <1.938291, 1.331751, -2.159151>
   component 1.000000, 0.555298, <-1.885548, 0.250527, -1.339168>
   }
   scale <-1, 1, 1>
   pigment {White}
   scale 2.5
   rotate -90*y
   translate <34, 3, 0> rotate 50*y translate 30*x rotate -120*y rotate 20*x
   }

#declare Billo_Baguette=object {
   cylinder {-5*x, 20*x, 1}
   pigment {checker color Black color White scale <50, 20, 20> translate <-35, 10, 10>}
   finish {
      ambient 0.1
      diffuse 0.7
      phong 3
      phong_size 7.5//5
      }
   rotate 90*y
   rotate 20*x
   translate <36, 4, 0> rotate 50*y translate 30*x rotate -120*y rotate 20*x
   }

#declare Billo_As_Coeur=object {
   box {0, 1}
   texture{
      pigment{
         image_map {
            png "As_Coeur.png"
            map_type 0 //plan
            once
            interpolate 2
            }
         }
      }
   translate -.5
   rotate 90*z
   rotate 45*x
   rotate 45*y
   scale <5, 7, .01>*1.2
   translate <30, 4, 0> rotate 50*y translate 30*x rotate -120*y rotate 20*x
   }

#declare Billo_As_Trefle=object {
   box {0, 1}
   texture{
      pigment{
         image_map {
            png "As_Trefl.png"
            map_type 0 //plan
            once
            interpolate 2
            }
         }
      }
   translate -.5
   rotate 90*z
   rotate 65*x
   rotate 45*y
   scale <5, 7, .01>*1.2
   translate <34, 4, 0.1> rotate 50*y translate 30*x rotate -120*y rotate 20*x
   }

#declare Billo_Poignet=object{
   cylinder {29.5*x, 30*x, 1 open scale <1, 8, 5>*1.001 hollow}
   texture{Billo_TBordure}
   }

#declare Billo_Boule=object{
   sphere {0, 2}
   texture{
      pigment {Red}
      finish {Shiny}
      }
   }

#declare Billo_BrasD=union{
   object {Billo_MancheD}
   //object {Billo_ChemD translate <0, -2, 0>}
   object {Billo_Poignet rotate 50*y translate 30*x rotate -120*y rotate 20*x}
   object {Billo_MainD}
   object {Billo_Baguette}
   object {Billo_As_Coeur translate <-1, -10, 2>}
   object {Billo_As_Trefle translate <0, -4, 2>}
   }

#declare Billo_BrasG=union{
   object {Billo_MancheG}
   object {Billo_Poignet rotate -30*y translate 30*x rotate -70*y rotate 10*x}
   object {Billo_Boule translate <28, -3, -2> rotate -30*y translate 30*x rotate -70*y rotate 10*x}
   object {Billo_Boule translate <25, -4, 2> rotate -30*y translate 30*x rotate -70*y rotate 10*x}
   //object {Billo_ChemG translate < 0, -2, 0>}
   object {Billo_MainG}
   }

//******************************************************************************* JAMBES

#declare Billo_Cost2_=object{
   union{
      cylinder {0, 100*y, 10}
      cylinder {0, 100*y, 1 scale <2, 1, 3> translate 8*x rotate 0*y}
      cylinder {0, 100*y, 1 scale <1, 1, 4> translate 8*x rotate 20*y}
      cylinder {0, 100*y, 1 scale <3, 1, 3> translate 8*x rotate 50*y}
      cylinder {0, 100*y, 1 scale <3, 1, 4> translate 8*x rotate 60*y}
      cylinder {0, 100*y, 1 scale <2, 1, 2> translate 8*x rotate 90*y}
      cylinder {0, 100*y, 1 scale <1, 1, 3> translate 8*x rotate 120*y}
      cylinder {0, 100*y, 1 scale <2, 1, 3> translate 8*x rotate 140*y}
      cylinder {0, 100*y, 1 scale <2, 1, 4> translate 8*x rotate 170*y}
      cylinder {0, 100*y, 1 scale <3, 1, 3> translate 8*x rotate 210*y}
      cylinder {0, 100*y, 1 scale <1, 1, 2> translate 8*x rotate 230*y}
      cylinder {0, 100*y, 1 scale <2, 1, 3> translate 8*x rotate 250*y}
      cylinder {0, 100*y, 1 scale <1, 1, 3> translate 8*x rotate 280*y}
      cylinder {0, 100*y, 1 scale <2, 1, 3> translate 8*x rotate 300*y}
      cylinder {0, 100*y, 1 scale <2, 1, 1> translate 8*x rotate 330*y}
      cylinder {0, 100*y, 1 scale <1, 1, 3> translate 8*x rotate 310*y}
      }
   texture{
      pigment{Magenta}
      normal {bumps 0.3 scale 10}
      }
   bounded_by {box{<-11, -1, -11> <11, 101, 11>}}
   scale <.8, 1, .8>
   }

#declare Billo_Cost2=object{
   union{
      cylinder {0, 100*y, 8}
      }
   texture{
      pigment{Magenta}
      normal {bumps 0.3 scale 10}
      }
   bounded_by {box{<-11, -1, -11> <11, 101, 11>}}
   scale <.8, 1, .8>
   }
/*
#declare Billo_Pant=object{
   SPant1
   scale <30, 20, 30>
   texture{
      pigment{Magenta}
      normal {bumps 0.3 scale 10}
      finish {phong 0.5 phong_size 1}
      }
   }
*/
#declare Billo_Jambes=union{
   object {Billo_Cost2 scale <1.2, 1, 1> rotate -10*z translate -12*x}            //Jambe droite
   object {Billo_Cost2 scale <1.2, 1, 1> rotate -10*z translate 12*x}//Jambe gauche
   //object {Billo_Pant translate <15, 63, -5>}
   translate <-15, -5, 0>
   }

//******************************************************************************* TOTAL

#declare Billo=union{
   object {Billo_Tronc translate <0, -10, 5>}
   object {Billo_Tete translate 165*y}
   object {Billo_BrasG translate < 20, 144, 0>}
   object {Billo_BrasD translate <-20, 144, 0>}
   object {Billo_Jambes translate <0, 0, 5>}
   }

/******************************************************************************

        Rendu "autoporteur"

******************************************************************************/

#ifndef (MAIN_POV)
#declare Cam_Scale=350
camera {
   orthographic
   location -130 * z
   up        y*Cam_Scale
   right     -4/3 * x*Cam_Scale
   direction z // Vue globale
   rotate 180 * y
}
object{ light_source{<-200, 370, 295> color White*.8}}
object{ light_source{<200, 370, 295> color White*.6}}
//object {box {<-1000, -1000, -1> <1000, 0, 1>} pigment {Red} finish {ambient 1}}
//object {box {<-1000, -1000, -1000> <1000, 1000, -999>} pigment {checker color Red color White} finish {ambient 1}}
object {Billo scale 1 rotate 0*x rotate -60*y rotate 0*x translate -30*y}
#end
