// Persistence of Vision Raytracer
// Theme "magic" 07-08/97
// Sizes in cm
// Proportions pour cadrage classique 800x600

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"

#include "decor.inc"
#include "lapin.inc"
#include "billo.inc"

#render "Includes ok.\n"

#declare WideLight = 1

#declare Vue_1= camera {
   ultra_wide_angle
   location  <20, 55, 30>
   up        y*.5
   right     -4/3 * x*.5
   look_at   <10, 60, 0>
   angle 220 //Attention: angle  la base et non sur la diagonale!
}

#declare Vue_1_= camera {
   fisheye
   location  <20, 55, 30>
   up        y*.5
   right     -4/3 * x*.5
   look_at   <10, 60, 0>
   angle 220 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=union{
   object {
      light_source {
         <-200, 500, 1000>
         color White*.8
         spotlight
         point_at <0, 0, 0>
         radius 15
         falloff 30
         }
      }
   object {
      light_source {
         <200, 500, 1000>
         color White*.6
         spotlight
         point_at <0, 0, 0>
         radius 15
         falloff 30
         }
      }
   }

#declare Lampes_E=union{
   object {
      light_source {
         <-200, 500, 1000>
         color rgb <.9, .4, .4>
         //color rgb <1, 0, 0>
         spotlight
         point_at <-100, 0, -120>//<0, 0, 0>
         radius 15
         falloff 30
         atmosphere off
         atmospheric_attenuation off
         }
      }
   object {
      light_source {
         <200, 500, 1000>
         //<400, 500, 1000>
         color rgb <.4, .9, .9>
         //color rgb <0, 1, 1>
         spotlight
         point_at <-100, 0, -120>//<0, 0, 0>
         radius 15
         falloff 30
         atmosphere off
         atmospheric_attenuation off
         }
      }
   object {//Spcial lapin 1
      light_source {
         <15, 500, 300>
         color White*.2
         spotlight
         point_at <15, 120, 15>
         radius 1.5
         falloff 1.5*1.1//1.1
         atmosphere on
         atmospheric_attenuation off
         }
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/

#declare Scene1=union{
   object {Decor}
   object {Lapin rotate -0*y translate <15, 50, 15>}
   //object {Billo scale <.7, .8, .7> rotate 40*y translate <-100, -10, -120>} //Eloign
   object {Billo scale <.7, .8, .7>/.7 rotate 40*y translate <-100, -55, -120>} //Proche
   }

camera {Vue_1}
object {Scene1 scale 1 rotate 0*y translate -50*z}

#ifdef (WideLight)
   object {Lampes_E}

atmosphere
{
  type 1            // Isotropic scattering
  samples 4         // Number of samples in first distance interval
  distance 20       // Atmosphere density, similar to fog
  scattering .9     // Reflectivity of atmosphere, determines brightness
  aa_level 2        // Level of binary subdivision in case of aa
  aa_threshold 0.1  // Threshold for aa to push in
  jitter 0.2        // Amount of sample jittering
  color rgbft <1, 1, 1, 0, 1>
}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
