/*
Candle.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)

pre-declares:

CandleH		Candle height
CandleR		Candle radius
*/

#declare Candle = union {
	intersection {
		cylinder { 0,y*CandleH,CandleR }
		sphere { y*(CandleH+CandleR),CandleR*1.5 translate x*-(CandleR*0.2) inverse }
		texture {
			pigment { color White }
			finish { phong 0.2 }
		}
	}
	cylinder {
		0,y*CandleH,.5
		pigment { color Black }
	}
	sphere {
		0,1
		hollow
		pigment { color Clear }

		halo {
			emitting
			spherical_mapping
			cubic
			color_map {
				[ 0.00 color rgbt <1.00, 0.80, 0.00, 1.00> ]
				[ 0.50 color rgbt <1.00, 0.80, 0.00, 1.00> ]
				[ 0.60 color rgbt <1.00, 0.90, 0.10, 0.30> ]
				[ 0.70 color rgbt <1.00, 1.00, 1.00, 0.00> ]
				[ 1.00 color rgbt <1.00, 1.00, 1.00, 0.00> ]
			}
			turbulence < .10,.35,.10 >
			samples 10
		}
		scale < 10,20,10 >
		translate y*(CandleH + 5)
	}
	light_source {
		< 0,CandleH+7,0>
		color rgb < 1.00,0.80,0.60>
		fade_distance 600
		fade_power 2
	}
}
