/*
Eye.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#ifndef(EyeRand)
#declare EyeRand = seed(0)
#end

#declare P_EyeW = pigment {
	crackle
	color_map {
		[ 0.000 rgb < 1.00, 0.00, 0.00 > ]
		[ 0.002 rgb < 1.00, 0.00, 0.00 > ]
		[ 0.006 rgb < 1.00, 1.00, 1.00 > ]
	}
	turbulence .5
	translate x*rand(EyeRand)*500
}

#declare P_Eye = pigment {
	wood ramp_wave
	pigment_map {
		[ 0.00 rgb < 0.00, 0.00, 0.00 > ]
		[ 0.10 rgb < 0.00, 0.00, 0.00 > ]
		[ 0.10 EyeColour ]
		[ 0.20 EyeColour ]
		[ 0.20 P_EyeW ]
	}
}

#declare Eye = sphere {
	0,.5
	texture {
		pigment {
			gradient z
			pigment_map {
				[ 0.0 P_Eye ]
				[ 0.5 P_Eye ]
				[ 0.5 P_EyeW ]
			}
			translate z*-.5
		}
		finish {
			reflection 0.3
			phong 0.9
			phong_size 100
		}
	}
	scale 2
}
