#declare SpiralP = pigment {
   spiral1 9
   color_map {
      [0  rgb <2,1,0> transmit .7]
      [.5 rgb <2,2,2> transmit .85]
      [1  rgb 1 transmit 1]
   }
   triangle_wave
   scale .2
   turbulence .3
   lambda 4
   octaves 3
}

#declare SparkPart = disc {
   0, z, 1
   finish {ambient 2 reflection 0}
   pigment {
      onion
      color_map {
         [ 0 rgbt <1,1,1,0.3> ]
         [ 1 rgbt 1 ]
      }
      scallop_wave
      scale 2
   }
   scale <.015, .75, 1>
}

#declare SparkCent = disc {
   0, z, 1
   finish {ambient 2 reflection 0}
   pigment {
      onion
      color_map {
         [ 0 rgbt <1,1,1,0.3> ]
         [ 1 rgbt 1 ]
      }
      scallop_wave
      scale 2
   }
   scale <.225, .225, 1>
}

#declare Spark = union {
   object { SparkCent                translate <0,0,-.02> }
   object { SparkPart rotate z * 90  translate <0,0,-.01> }
   object { SparkPart scale <1,1.4,1> }
   object { SparkPart scale <.6,.6,1> rotate z * 30  translate <0,0, .001> }
   object { SparkPart scale <.6,.6,1> rotate z * 60  translate <0,0, .002> }
   object { SparkPart scale <.6,.6,1> rotate z * 120 translate <0,0, .003> }
   object { SparkPart scale <.6,.6,1> rotate z * 150 translate <0,0, .004> }
   scale .5
   no_shadow
}

#declare R = seed (228)
#declare Loop = 0
#while (Loop < 50)
   #declare YPos = rand(R)*3
      #if (YPos > 2)
      #declare MidY = abs((YPos-3)/2)*2
      #declare XPos = ((rand(R)*MidY)-(MidY/2))
      #declare ZPos = (((rand(R)*YPos/2)-((YPos/2)/2)))-4.7
   #else
      #declare XPos = ((rand(R)*YPos)-(YPos/2))
      #declare ZPos = (((rand(R)*YPos)-(YPos/2)))-4.7
   #end
   object { Spark translate <XPos, YPos+.5, ZPos> }
   #declare Loop = Loop + 1
#end

disc {
   0, z, 3
   pigment {
      onion
      pigment_map {
         [0   rgbt 1  ]
         [.15 SpiralP ]
         [.4  SpiralP ]
         [1   rgbt 1  ]
      }
      scallop_wave
      scale 6
   }
   finish { ambient 2 }
   scale .5
   translate <0,2,-4.7>
   no_shadow
}
