// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un generador de velas (llama basada en las de P.Engels (engelspj@aol.com))
//--
// This file contains:
//  A candle generator (flame based in P.Engels (engelspj@aol.com) ones)

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  CandleLight : boolean, turns on/off the light source
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#ifndef (CandleSeed)
    #declare CandleSeed = 15000
    #declare CRand = seed (CandleSeed)
#end

#declare Height = 5 + (rand (CRand) * 15)
//#debug concat (str (Height, 1, 1), "\n")
#declare MaxDrops = 1 + (rand (CRand) * 19)
#declare MaxPools = (rand (CRand) * 5) - 1

#declare Candle =
    union {
        #if (CandleLight = on)
            light_source {
                <0, Height + 2, 0> rgb <.15, .15, 0>
                fade_power 2
                fade_distance 50
            }
        #end
        cylinder {
            <0, Height - 1, 0>, <0, Height + 1, 0>, .1
            texture {
                pigment { Black }
            }
        }
        cylinder { // Molten Wax
            <0, Height - 1, 0>, <0, Height, 0>, 1.9
            texture {
                pigment { rgbt <.96, .96, 0, .5> }
                finish {
                    specular .4
                    roughness .001
                    reflection .2
                    refraction on
                    ior 1.5
                }
                normal { bumps .1 }
            }
        }
        union { // Solid Wax
            difference {
                cylinder { <0, 0, 0>, <0, Height, 0>, 2 }
                sphere {
                    <0, 0, 0>, 1.8
                    scale <1, .5, 1>
                    translate <0, Height, 0>
                }
            }
            torus {
                1.9, .1
                scale <1, 2, 1>
                translate <0, Height, 0>
            }
            blob {
                threshold .1
                #while (MaxDrops > 0)
                    #declare DropPos = Height * rand (CRand)
                    #declare DropRotate = 360 * y * rand (CRand)
                  //#debug concat(str (MaxDrops,1,1),"\n")
                    sphere {
                        <0, Height+.5, 0>, .3, strength -.5
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    sphere { // End
                        0, .3, strength 1
                        scale <1, 2, 1>
                        rotate 15*z
                        translate <0, DropPos, 0>
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    sphere { // End (tip)
                        0, .3, strength 1
                        scale <1, 1.5, 1>
                        rotate 20*z
                        translate <0, DropPos-.25, 0>
                        scale <.5, 1, 1> translate 2.1*x
                        rotate DropRotate
                    }
                    cylinder {
                        <0, DropPos, 0>, <0, Height, 0>, .25, strength 1
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    #declare MidDrops = (rand (CRand) * 3) - 1
                    #while (MidDrops > 0) // #1
                        #declare MidDropPos = DropPos + (rand (CRand) * (Height - DropPos)) - .5
                        sphere {
                            0, .3, strength 1
                            scale <1, 2, 1>
                            rotate 15*z
                            translate <0, MidDropPos, 0>
                            scale <.5, 1, 1> translate 2*x
                            rotate DropRotate
                        }
                        #declare MidDrops = MidDrops - 1
                    #end // MidDrops #1
                    #declare MaxDrops = MaxDrops - 1
                #end // MaxDrops

                #while (MaxPools > 0)
                    sphere {
                        <0, Height+.5, 0>, .3, strength -.5
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    cylinder {
                        <0, 0, 0>, <0, Height, 0>, .25, strength 1
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    sphere {
                        0, .3, strength 1
                        scale <1, 2, 1>
                        rotate 30*z
                        translate <0, 1, 0>
                        scale <.5, 1, 1> translate 2*x
                        rotate DropRotate
                    }
                    #declare PoolTrans = rand (CRand)
                    sphere { // Ground 1
                        0, 1, strength 1
                        scale <rand (CRand) + 1, .2, rand (CRand) + 1> * 2
                        translate PoolTrans * x
                        rotate DropRotate
                    }
                    sphere { // Ground 2
                        0, 1, strength 1
                        scale <rand (CRand) + 1, .3, rand (CRand) + 1>
                        translate <PoolTrans + 1.4, .3, 0>
                        rotate DropRotate
                    }
                    sphere { // Ground 3
                        0, 1, strength 1
                        scale <rand (CRand) + 1, .3, rand (CRand) + 1> * .6
                        translate <PoolTrans + 1.75, .5, 0>
                        rotate DropRotate
                    }
                    #declare MidDrops = (rand (CRand) * 3) - 1
                    #while (MidDrops > 0) // #2
                        #declare MidDropPos = (rand (CRand) * Height) - .5
                        sphere {
                            0, .3, strength 1
                            scale <1, 2, 1>
                            rotate 15*z
                            translate <0, MidDropPos, 0>
                            scale <.5, 1, 1> translate 2*x
                            rotate DropRotate
                        }
                        #declare MidDrops = MidDrops - 1
                    #end // MidDrops #2
                    #declare MaxPools = MaxPools - 1
                #end // MaxPools
            }
            texture {
                pigment { rgb <.96, .96, .84> }
                finish {
                    phong .7
                    phong_size 10
                    diffuse .8
                    reflection .05
                }
                normal { granite .05 }
            }
        }
        quartic { // Piriform from ShapesQ
            < 4,   0,   0,   -4,  0,   0,   0,   0,   0,  0,
              0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
              0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
              0,   0,   1,    0,  0>
            sturm hollow no_shadow
            texture {
                pigment { Clear }
                finish  { ambient 1 diffuse 0 }
                halo {
                    linear
                    max_value 1.0
                    cylindrical_mapping
                    emitting
                    turbulence 0.1
                    colour_map {
                        [0.00 color rgbt <0.3,0.3,0.0,0.2>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.60 color rgbt <0.2,0.2,0.0,0.7>]
                        [0.75 color rgbt <1.0,0.8,0.0,0.3>]
                        [0.90 color rgbt <1.0,0.8,0.6,0.5>]
                        [0.95 color rgbt <1.0,1.0,0.0,-0.1>]
                        [1.00 color rgbt <1.0,0.8,0.5,-2.0>]
                    }
                    samples 20
                    rotate 89*z
                }
                halo {
                    linear
                    max_value 1.0
                    spherical_mapping
                    emitting
                    turbulence 0.1
                    colour_map {
                        [0.00 color rgbt <0.3,0.3,0.0,0.2>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.60 color rgbt <0.2,0.2,0.0,0.7>]
                        [0.75 color rgbt <1.0,0.8,0.0,0.3>]
                        [0.90 color rgbt <1.0,0.8,0.6,0.5>]
                        [0.95 color rgbt <1.0,1.0,0.0,-0.1>]
                        [1.00 color rgbt <1.0,0.8,0.5,-2.0>]
                    }
                    samples 20
                    translate .5 * x
                }
            }
            bounded_by {
                box { <0, -1, -1>, 1 }
            }
            rotate <.1, .2, -91>
            scale <1, 2.75, 1>*1.2
            translate <0, Height + 3.8, 0>
        }
        quartic { // Piriform from ShapesQ
            < 4,   0,   0,   -4,  0,   0,   0,   0,   0,  0,
              0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
              0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
              0,   0,   1,    0,  0>
            sturm hollow no_shadow
            texture {
                pigment { Clear }
                finish  { ambient 1 diffuse 0 }
                halo {
                    linear
                    max_value 1.0
                    cylindrical_mapping
                    emitting
                    turbulence 0.1
                    colour_map {
                        [0.00 color rgbt <0.3,0.3,0.0,0.2>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.60 color rgbt <0.2,0.2,0.0,0.7>]
                        [0.75 color rgbt <1.0,0.8,0.0,0.3>]
                        [0.90 color rgbt <1.0,0.8,0.6,0.5>]
                        [0.95 color rgbt <1.0,1.0,0.0,-0.1>]
                        [1.00 color rgbt <1.0,0.8,0.5,-2.0>]
                    }
                    samples 20
                    rotate 89*z
                }
                halo {
                    linear
                    max_value 1.0
                    spherical_mapping
                    emitting
                    turbulence 0.1
                    colour_map {
                        [0.00 color rgbt <0.3,0.3,0.0,0.2>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.20 color rgbt <0.3,0.3,0.0,0.8>]
                        [0.60 color rgbt <0.2,0.2,0.0,0.7>]
                        [0.75 color rgbt <1.0,0.8,0.0,0.3>]
                        [0.90 color rgbt <1.0,0.8,0.6,0.5>]
                        [0.95 color rgbt <1.0,1.0,0.0,-0.1>]
                        [1.00 color rgbt <1.0,0.8,0.5,-2.0>]
                    }
                    samples 20
                    scale 1.5
                    translate .75 * x
                }
            }
            bounded_by {
                box { <0, -1, -1>, 1 }
            }
            rotate <-.1, .2, -92>
            scale <1, 3, 1>*1.5
            translate <0, Height + 4.7, 0>
        }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
