// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Texturas para paredes, suelos, techos... de una ciudad
//   (fantastico-) medieval.
//--
// This file contains:
//  Textures for walls, grounds, roofs... of a (fantastic-) medieval city.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  T_BottomLayer  : Layer to "put" under T_GRMossPatchesX, etc...
//                    (to overcome a layering problem)
//  M_WallsPaint   : color_map for the paint
//  T_WallsPlaster : texture for the walls' plaster (between paint and bricks)
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.

// Please include "bricktex.inc" before, and set its Swap_Colors.


#ifndef (T_BottomLayer)
    #declare T_BottomLayer =
        texture { pigment { Gray90 } }
    #warning "'T_BottomLayer' not set, please declare it\n"
#end
#ifndef (M_WallsPaint)
    #declare M_WallsPaint =
        color_map {
            [ .1 Goldenrod ]
            [ .9 MediumGoldenrod ]
        }
    #warning "'M_WallsPaint' not set, please declare it\n"
#end
#ifndef (T_WallsPlaster)
    #declare T_WallsPlaster =
        texture { pigment { Gray50 } }
    #warning "'T_WallsPlaster' not set, please declare it\n"
#end


#declare T_GRMoss1 =
    texture {
        pigment { rgb <0, .5, 0> }
        normal {
            bumps 3
            scale .01
            turbulence .1
        }
    }

#declare T_GRMoss2 =
    texture {
        pigment { rgb <.15, .55, .15> }
        normal {
            bumps 3
            scale .01
            turbulence .1
        }
    }

#declare T_GRMoss3 =
    texture {
        pigment { rgb <.25, .35, 0> }
        normal {
            bumps 2
            scale .01
            turbulence .1
        }
    }

#declare T_GRMossPatches1 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss1 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_BottomLayer scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
    }

#declare T_GRMossPatches2 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss2 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_BottomLayer scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
        translate 100*y
    }

#declare T_GRMossPatches3 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss3 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_BottomLayer scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
        translate -100*y
    }

#declare T_GRPaint =
    texture {
        pigment {
            wrinkles
            color_map { M_WallsPaint }
            scale .5
        }
        normal { bumps .25 }
    }

#declare T_GRCrackedPaint =
    texture { T_GRPaint }
    texture {
        pigment {
            crackle
            color_map {
                [ .1 rgbf <.1, .1, .1, .5> ]
                [ .1 Clear ]
            }
            turbulence .1
        }
        scale .1
    }

#declare T_GRChippedPaint =
    texture {
        bozo
        texture_map {
            [ .5 T_GRPaint ]
            [ .65 T_GRCrackedPaint ]
            [ .7 T_WallsPlaster ]
            [ .7 T_BottomLayer ]
        }
    }

#declare T_GRWalls1 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss1 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_GRChippedPaint scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
    }

#declare T_GRWalls2 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss2 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_GRChippedPaint scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
        translate 100*y
    }

#declare T_GRWalls3 =
    texture {
        bozo
        texture_map {
            [ .025 T_GRMoss3 ]
            [ .075 pigment { Gray10 } ]
            [ .1   T_GRChippedPaint scale <1, 2, 1> ]
        }
        scale <1, .5, 1>
        translate -100*y
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
