// Trace this scene at 320*240 or more for the height field
// in the center of the scene, HF GRAY 16 is turned on in
// the global settings so you don't have to turn it on.

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 on
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <0.000, -0.001, 12.375>
  direction <0.0,     0.0,  2.5899>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******
light_source {   // Spotlight SpotL001
  <0.000, 0.000, 10.000>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.000, 0.000, 9.000>
    falloff   12.0  // outer radius (in deg)
      radius    1.0  // inner radius
  atmosphere off
}


// ********  TEXTURES  *******
//
#declare Texture01 = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.800, 0.800, 0.800> ]
       [ 1.000  color rgb<1.000, 1.000, 1.000> ]
     }
     turbulence 1.200
     scale     <0.2500, 0.2500, 0.2500>
   }
   finish {
     diffuse 0.500
     ambient 0.050
     specular 0.400
     roughness 0.0100
   }

}

plane { // Plane001
  z,0
  texture {
    Texture01
  }
}


