// Persistence of Vision Ray Tracer Scene Description
// File: Magic.pov
// Vers: 3.02a.f1 / MacOS
// Desc: A crystal ball using all of POV Ray 3.0's magic
// Date: 
// Auth: Joost Egelie


/* PROLOGUE: SCENE INITIALISATION */
/* ------------------------------ */

//Required Settings
global_settings{
	assumed_gamma 1.8
	ambient_light color rgb<0.5,1,0.5>
}
#include "colors.inc"
#include "textures.inc"

//Some Coordinates
#declare BallCoord = <0,0.92,0>
#declare CandleCoord = <0.2,0.822,-0.2>
#declare CardsCoord = CandleCoord+<0,-0.062,0>
#declare BookCoord = <-0.2,0.76,-0.1>
#declare BookTrans = transform{
	rotate<0,165,0>
	translate BookCoord
}

//Parser Quality Options
#declare Hi  = 3
#declare Med = 2
#declare Lo  = 1
#declare On  = 4
#declare Off = 0

/*	Please Note: Do not use the built-in keywords
	"on" and "off", the different values could
	lead to unpredictable errors. Use "On" and "Off"
	for these Quality Settings.
*/

//Parser Quality Settings
#declare Sample = 25	// Setting for all atmos/halo samples
#declare EntireQual  = On		// On - Off
#if(EntireQual = On)
	#render"\nGoing for the real thing!"
	#declare BallQuality = Hi	// You'd rather not change these
	#declare BookQuality = Hi	// settings; use those below and
	#declare RenderAtmos = On	// put the EntireQual switch Off
	#declare TableTex    = Hi	// instead...
	#declare WallTex     = Hi	// The switches below can be set
	#declare CandleBlow  = On	// to your favourite flavours.
#else
	#render"\nJust an exercise."
	#declare BallQuality = Lo	// Hi - Med - Lo
	#declare BookQuality = Lo	// Hi - Med - Lo
	#declare RenderAtmos = Off	// On - Off
	#declare TableTex    = Lo	// Hi - Lo
	#declare WallTex     = Lo	// Hi - Lo
	#declare CandleBlow  = Off	// On - Off
#end

//Camera Viewpoints
#declare MainScn = 1
#declare BookCloseUp = 2
#declare CandleCloseUp = 3
#declare CardsCloseUp = 4

//Gentlemen, Pick Your Camera
#declare UseCam = MainScn


/* CHAPTER ONE: THE ARTIST TAKES PLACE */
/* ----------------------------------- */

//By Setting Up His Camera
#switch(UseCam)
	#case(MainScn)
		#render "\nUsing MainScene Camera."
		camera{
			location <0.25, 1.15, 0.85>
			direction 3*z
			up y
			right 16/9*x
			look_at BallCoord
		}
		#break
	#case(BookCloseUp)
		#render "\nUsing Book Close Up Camera."
		camera{
			location <-0.5, 1.15, 0.85>
			direction 7*z
			up y
			right 16/9*x
			look_at BookCoord
		}
		#break
	#case(CandleCloseUp)
		#render "\nUsing Candle Close Up Camera."
		camera{
			location <0.5, 1.0, 0.85>
			direction 6*z
			up y
			right 16/9*x
			look_at CandleCoord
		}
		#break
	#case(CardsCloseUp)
		#render "\nUsing Tarot Cards Close Up Camera."
		camera{
			location <0.5, 1.0, 0.85>
			direction 6*z
			up y
			right 16/9*x
			look_at CardsCoord
		}
		#break
	#else
		#warning "\nUser didn't properly specify UseCam. Rendering MainScene."
		camera{
			location <0.25, 1.15, 0.85>
			direction 3*z
			up y
			right 16/9*x
			look_at BallCoord
		}
#end


/* CHAPTER TWO: CREATING AN ENVIRONMENT */
/* ------------------------------------ */

//The Surrounding Air
#if(RenderAtmos = On)
	#render"\nDust is in the air (everywhere I look around)"
	atmosphere{
		type 3
		samples Sample
		distance 40
		scattering 8
		aa_level 4
		aa_threshold 0.3
		jitter 0.1
	}
#else
	#render"\nClean air all around."
#end

//The Room
#declare WallPaper = texture{
	#switch(WallTex)
		#case(Hi)
			pigment{
				image_map{
					gif "je_magic1.gif"
					map_type 0
					interpolate 4
				}
				turbulence 0.001
			}
			finish{Dull ambient 0.2}
			normal{crackle 1 turbulence 1 scale<0.1,0.5,0.1>}
			scale 0.3333
			#break
		#case(Med)
			pigment{color Blue}
			finish{Dull ambient 0.2}
			normal{crackle 1 turbulence 1 scale<0.1,0.5,0.1>}
			scale 0.5
			#break
		#else
			pigment{color Blue}
	#end
}

difference{
	box{<-1.0851,-0.001,1.35>,<1.0851,2.3001,1.5>}
	box{<-0.665,0.94,1.349>,<0.835,2.17,1.501>}
	hollow
	texture{WallPaper}
}

box{<-0.665,0.94,1.5>,<0.835,2.17,1.504>
	texture{
		pigment{color rgbf<0.95,0.975,1,0.995>}
		finish{
			reflection 0.15
			refraction 1
			ior 1.53
			specular 1
			roughness 0.0005
			ambient 0.1
		}
	}
}

difference{
	box{<-0.665,0.94,1.48>,<0.835,2.17,1.5>}
	box{<-0.565,1.06,1.479>,<0.03,2.07,1.501>}
	box{<0.14,1.06,1.479>,<0.735,2.07,1.501>}
	texture{pigment{Dark_Wood}}
}

box{<-0.665,0.92,1.3>,<0.835,0.94,1.5>
	texture{
		pigment{
			bozo
			turbulence 0.3
			scale 3
			color_map{
				[0.1  color rgb<1,0.95,0.95>]
				[0.5  color rgb<1,1,1>]
				[0.55 color rgb<1,0.9,0.9>]
				[0.99 color rgb<1,0.95,0.9>]
				[1.0  color rgb<0.5,0.4,0.3>]
			}
		}
	}
}

plane{z,0 rotate<0,90,0> translate<-1.085,0,0>
	clipped_by{box{<-1.0851,-0.001,-1.5001>,<1.0851,2.3001,1.3501>}}
	texture{WallPaper rotate<0,-90,0>}
}
plane{z,0 rotate<0,-90,0> translate<1.085,0,0>
	clipped_by{box{<-1.0851,-0.001,-1.5001>,<1.0851,2.3001,1.3501>}}
	texture{WallPaper rotate<0,90,0>}
}
plane{z,0 translate<0,0,-1.5>
	clipped_by{box{<-1.0851,-0.001,-1.5001>,<1.0851,2.3001,1.3501>}}
	texture{WallPaper rotate<0,180,0>}
}

plane{y,2.30
	clipped_by{box{<-1.0851,-0.001,-1.5001>,<1.0851,2.3001,1.3501>}}
	texture{
		pigment{color White}
		finish{Dull ambient 0.2}
	}
	hollow
}

plane{y,0
	clipped_by{box{<-1.0851,-0.001,-1.5001>,<1.0851,2.3001,1.3501>}}
	texture{
		pigment{
			bozo
			turbulence 0.3
			scale 10
			color_map{
				[0.1  color rgb<0.95,1,0.975>]
				[0.5  color rgb<1,1,1>]
				[0.55 color rgb<1,0.95,0.9>]
				[1.0  color rgb<0.95,0.9,0.85>]
			}
		}
		finish{reflection 0.15 phong 1 phong_size 100 ambient 0.2}
	}
}

//The Table
union{
	cone{<0,0.75,0>,0.39,<0,0.7599,0>,0.375}
	cylinder{<0,0.74,0>,<0,0.7499,0>,0.4}
	#if(TableTex = Hi)
		texture{
			pigment{
				wood
				color_map{
					[0.0 color rgb<0.330,0.110,0.100>]
					[0.5 color rgb<0.300,0.050,0.040>]
					[0.6 color rgb<0.300,0.000,0.000>]
					[1.0 color rgb<0.340,0.110,0.100>]
				}
				turbulence 0.2
				scale<0.03,3,0.03> rotate<0,0,45> rotate<0,27,0>
			}
			finish{
				ambient 0.2
				specular 1
				roughness 0.037
				brilliance 0.5
				reflection 0.13
			}
		}
	#else
		texture{pigment{color rgb<0.330,0.110,0.100>}}
	#end
}


/* CHAPTER THREE: PLACEMENT OF THE ARTIFACTS */
/* ----------------------------------------- */

//The Crystal Ball
#declare CrystalBall = object{
	sphere{BallCoord,0.075 hollow
		texture{
			Glass3
			finish{ambient 0.4 caustics 2}
		}
	}
}
#declare CrystalVision = object{
	text{
		ttf "OXFORD.TTF", "POV-Ray 4.0", 0.25, -0.05*x
		// Please take note, that I could not include this font in order not
		// to violate its copyrights. 
		texture{pigment{color Red}}
		translate<-2.2,-0.25,0>
		rotate<0,180,0>
		scale 0.0275
		translate BallCoord
	}
}
#declare CrystalMagic = object{
	light_source{0*x
		color rgb<0,0,1>
		looks_like{
			sphere{0*x,1
				texture{
					pigment{color rgbt<1,1,1,1>}
					halo{
						emitting
						spherical_mapping
						linear
						color_map{
							[0.0  color rgbt<0,0,0,1.0>]
							[0.33 color rgbt<0,0,1,0.9>]
							[1.0  color rgbt<0,1,1,0.8>]
						}
						samples Sample
						turbulence 0.75
						scale 0.75
					}
				}
				hollow
			}
			scale 0.0749
		}
		fade_distance 0.076
		fade_power 2
		atmospheric_attenuation on
		translate BallCoord
	}
}

difference{
	cone{<0,0.76,0>,0.075,<0,0.86,0>,0.05}
	sphere{BallCoord,0.07501}
	#if(BallQuality = Lo)
		texture{pigment{color rgb<0.25,0.25,0.5>}}
	#else
		texture{
			pigment{Blue_Agate scale 0.05}
			finish{Phong_Shiny}
			normal{
				wrinkles 0.4
				scale 0.2
			}
		}
	#end
}

#switch(BallQuality)
	#case(Med)
		#render "\nRendering Crystal Ball as Glass sphere with text."
		object{CrystalBall}
		object{CrystalVision}
		#break
	#case(Hi)
		#render "\nRendering Crystal Ball as Glass sphere with text, Halo and Lightsource."
		object{CrystalBall}
		object{CrystalVision}
		object{CrystalMagic}
		#break
	#case(Lo)
		#render "\nRendering Crystal Ball as a transparent sphere."
		sphere{BallCoord,0.075 hollow texture{pigment{color rgbt<0,1,1,0.85>}}}
		#break
	#else
		#warning "\nUser didn't specify BallQuality."
#end

//The Book
#declare BookLeather = texture{
	pigment{
		marble
		color_map{
			[0.0 color rgb<0.5,0.1,0.05>]
			[1.0 color rgb<0.1,0.0,0.00>]
		}
		turbulence 0.75
		scale<0.005,0.1,0.005>
	}
	finish{
		specular 0.33
		roughness 0.01
	}
	normal{
		marble
		slope_map{
			[0.0 <1.0,-1.0>]
			[1.0 <0.0, 1.0>]
		}
		turbulence 0.75
		scale<0.005,0.1,0.005>
	}
}
#declare Dust = texture{
	pigment{
		bozo
		color_map{
			[0.00 color rgbt<1,1,1,1.00>]
			[0.25 color rgbt<1,1,1,1.00>]
			[0.50 color rgbt<1,1,1,0.75>]
			[0.75 color rgbt<1,1,1,1.00>]
			[1.00 color rgbt<1,1,1,1.00>]
		}
		turbulence 1
		scale 0.2
	}
	finish{Dull}
}	
#declare BookCover1 =
	texture{BookLeather}
	texture{Dust}
#declare BookCover2 =
	texture{Bronze_Metal}
	texture{Dust}
union{
	intersection{
		cylinder{<0.06,0.015,-0.1251>,<0.06,0.015,0.1251>,0.04}
		box{<0.06,0.003,-0.125>,<0.12,0.037,0.125>}
	}
	difference{
		box{<-0.12,0.003,-0.125>,<0.06,0.037,0.125>}
		cylinder{<-0.12,0.015,-0.1251>,<-0.12,0.015,0.1251>,0.04}
	}
	#switch(BookQuality)
		#range(Med,Hi)
			texture{
				pigment{
					wood
					color_map{
						[0.0 color rgb<1.0,1.0,0.5>]
						[0.4 color rgb<1.0,1.0,0.5>]
						[0.5 color rgb<0.7,0.2,0.1>]
						[0.6 color rgb<1.0,1.0,0.5>]
						[1.0 color rgb<1.0,1.0,0.5>]
					}
					rotate<90,0,0>
					turbulence 0.1
					scale <1,0.0001,1>
				}
			}
			#break
		#else
			texture{pigment{color rgb<1.0,1.0,0.5>}}
	#end
	transform BookTrans
}

difference{
	box{<-0.092,-0.0015,-0.127>,<0.092,0.0015,0.127>}
	cylinder{<0.089,0,-0.128>,<0.089,0,0.128>,0.003
		scale<1,0.5,1>
		translate<0,0.0015,0>
	}
	#switch(BookQuality)
		#case(Hi)
			#render "\nUsing Full Texture on Book."
			texture{
				material_map{
					gif "je_magic2.gif"
					map_type 0
					interpolate 4
					once
					texture{BookCover1}
					texture{BookCover2}
				}
				translate<-0.5,-0.5,0>
				rotate<90,180,0>
				scale<0.184,0.33,0.254>

			}
			#break
		#case(Med)
			#render "\nRendering Book without Cover and Dust."
			texture{BookLeather
				translate<-0.5,-0.5,0>
				rotate<90,180,0>
				scale<0.184,0.33,0.254>
			}
			#break
		#case(Lo)
			#render "\nThe Book will be rendered in plain colors."
			texture{pigment{color rgb<0.7,0,0>}}
			#break
		#else
			#render "\nUser did not specify legal BookQuality. Rendering Lo."
			texture{pigment{color rgb<0.7,0,0>}}
	#end
	translate <(cos(asin(0.022/0.04))*0.04)-0.03,0.0385,0>
	transform BookTrans
}
difference{
	box{<-0.092,-0.0015,-0.127>,<0.092,0.0015,0.127>}
	cylinder{<0.089,0,-0.128>,<0.089,0,0.128>,0.003
		scale<1,0.5,1>
		translate<0,-0.0015,0>
	}
	#switch(BookQuality)
		#case(Hi)
			texture{BookLeather}
			texture{Dust}
			#break
		#case(Med)
			texture{BookLeather}
			#break
		#else
			texture{pigment{color rgb<0.7,0,0>}}
	#end			
	translate <(cos(asin(0.012/0.04))*0.04)-0.03,0.0015,0>
	transform BookTrans
}
intersection{
	difference{
		cylinder{<0.06,0.015,-0.1251>,<0.06,0.015,0.1251>,0.044}
		cylinder{<0.06,0.015,-0.1251>,<0.06,0.015,0.1251>,0.041}
	}
	box{<0.06,0.003,-0.125>,<0.12,0.037,0.125>}
	#switch(BookQuality)
		#case(Hi)
			texture{BookLeather}
			texture{Dust}
			#break
		#case(Med)
			texture{BookLeather}
			#break
		#else
			texture{pigment{color rgb<0.7,0,0>}}
	#end			
	transform BookTrans
}	

//The Candle
#declare CandleTex = texture{
	pigment{color rgb<1,1,0.9>}
	finish{
		diffuse 0.5
		phong 1
		phong_size 25
		brilliance 0.1
		reflection 0.2
	}
	normal{
		crackle 0.1
		turbulence 1
		scale 0.01
	}
}

difference{
	cylinder{<0,0,0>,<0,0.1,0>,0.0105}
	merge{
		sphere{<0,0,0>,0.01
			scale <1,0.25,1>
			translate<0,0.1,0>
		}
		cylinder{<0,0.1,0>,<0,0.12,0>,0.01}
	}
	texture{CandleTex}
	translate CandleCoord
}

difference{
	blob{
		threshold 0.0005
		sphere{<0.01,0.0950,0>,0.0014,0.1}
		sphere{<0.01,0.0960,0>,0.0010,0.1}
		sphere{<0.01,0.1010,0>,0.0020,0.1}
		sphere{<0.01,0.1030,0>,0.0014,0.3}
		sphere{<0.01,0.1050,0>,0.0020,0.1}
		sphere{<0.01,0.1068,0>,0.0014,0.1}
		sphere{<0.01,0.1090,0>,0.0010,0.1}
	}
	merge{
		sphere{<0,0,0>,0.01
			scale <1,0.25,1>
			translate<0,0.1,0>
		}
		cylinder{<0,0.1,0>,<0,0.12,0>,0.01}
	}
	texture{CandleTex}
	translate CandleCoord
}
blob{
	threshold 0.0005
	sphere{<0.01,0.0950,0>,0.0014,0.1}
	sphere{<0.01,0.0960,0>,0.0010,0.1}
	sphere{<0.01,0.1010,0>,0.0020,0.1}
	sphere{<0.01,0.1030,0>,0.0014,0.3}
	sphere{<0.01,0.1050,0>,0.0020,0.1}
	sphere{<0.01,0.1068,0>,0.0014,0.1}
	sphere{<0.01,0.1090,0>,0.0010,0.1}
	texture{CandleTex}
	translate<0,-0.102,0>
	rotate<0,-117,0>
	scale <1,1.34,1>
	translate<0,0.08,0>
	translate CandleCoord
}

union{
	intersection{
		torus{0.0025, 0.00075 rotate<-90,0,0>}
		box{<0,0,-0.001>,<0.003,0.003,0.001>}
		translate<-0.0025,0.1,0>
		rotate<0,-20,0>
	}
	cylinder{<0,0.098,0>,<0,0.1,0>,0.00075}
	texture{
		pigment{color rgb<0.01,0,0>}
	}
	translate CandleCoord
}
#if(CandleBlow = On)
	#render"\nCandle's just blown out."
	light_source{
    	<0,0,0>
		color rgb<1,0,0>
		looks_like{
			cylinder{<-0.00075,0,0>,<0.00075,0,0>,0.00075
				texture{
					pigment{color rgbt<1,0,0,0.2>}
				}
			}
		}
		fade_distance 0.005
		fade_power 2
		translate<-0.00074,0.0025,0>
		translate<-0.0025,0.1,0>
		rotate<0,-20,0>
		translate CandleCoord
	}
	cone{<0,-1,0>,0.1,<0,1,0>,1
		texture{
		pigment{color rgbt<1,1,1,1>}
			halo{
				dust
				dust_type 1
				cubic
				cylindrical_mapping
				turbulence <0.4,1,0.4>
				octaves 5
				lambda 10
				omega 0.99
				colour_map{
					[ 0.0 color rgbt <0, 0, 0, 1.0> ]
					[ 0.9 color rgbt <0, 0, 0, 1.0> ]
					[ 1.0 color rgbt <1, 1, 1, 0.0> ]
				}
				scale 0.95
				samples Sample
				aa_level 4
				aa_threshold 0.25
				jitter 0.1
			}  
		}
		hollow
		scale <0.03,0.1,0.03>
		translate<0,0.2,0>
		translate CandleCoord
	}
#else
	#render"\nCandle's blown out long time ago."
#end
union{
	lathe{
		quadratic_spline
		18,
		<0.0000,0.0712>,<0.0125,0.0712>,<0.0110,0.0700>,<0.0110,0.0600>,<0.0200,0.0600>,
		<0.0200,0.0550>,<0.0100,0.0500>,<0.0050,0.0450>,<0.0050,0.0400>,<0.0100,0.0350>,
		<0.0050,0.0300>,<0.0050,0.0250>,<0.0100,0.0200>,<0.0100,0.0150>,<0.0050,0.0100>,
		<0.0300,0.0050>,<0.0300,0.0000>,<0.0000,0.0000>
	}
	difference{
		cylinder{<0.03,0.03,-0.001>,<0.03,0.03,0.001>,0.011}
		cylinder{<0.03,0.03,-0.0011>,<0.03,0.03,0.0011>,0.009}
	}
	prism{
		linear_sweep
		quadratic_spline
		-0.001,0.001,10,
		<0.000,0.015>,<0.010,0.015>,<0.017,0.015>,<0.020,0.018>,<0.021,0.030>,
		<0.019,0.030>,<0.019,0.020>,<0.015,0.017>,<0.010,0.017>,<0.010,0.015>
		rotate<-90,0,0>
	}
	prism{
		linear_sweep
		quadratic_spline
		-0.001,0.001,8,
		<0.020,0.039>,<0.030,0.039>,<0.035,0.039>,<0.038,0.040>,<0.037,0.042>,
		<0.035,0.041>,<0.030,0.041>,<0.030,0.039>
		rotate<-90,0,0>
	}
	texture{Bronze_Metal}
	texture{Dust scale 0.5}
	rotate<0,-10,0>
	translate<0,-0.062,0>
	translate CandleCoord
}
blob{
	threshold 0.0005
	sphere{<0.01,0.0950,0>,0.0014,0.1}
	sphere{<0.01,0.0960,0>,0.0010,0.1}
	sphere{<0.01,0.1010,0>,0.0020,0.1}
	sphere{<0.01,0.1030,0>,0.0014,0.3}
	sphere{<0.01,0.1050,0>,0.0020,0.1}
	sphere{<0.01,0.1068,0>,0.0014,0.1}
	sphere{<0.01,0.1090,0>,0.0010,0.1}
	texture{CandleTex}
	translate<0,-0.102,0>
	rotate<0,0,15>
	rotate<0,-117,0>
	scale <1.5,1.5,1.5>
	translate<0,0.005,0>
	translate CandleCoord
}

//The Tarot Cards
superellipsoid{<0.1,0.1>
	texture{
		pigment{
			image_map{
				gif "je_magic3.gif"
				map_type 0
				interpolate 4
				once
			}
			translate<-0.5,-0.5,-0.5>
			scale 2
			rotate<90,90,0>
		}
	}
	scale<0.06,0.0001,0.04>
	translate<-0.07,0,0>
	rotate<0,20,0>
	translate CardsCoord
}
superellipsoid{<0.1,0.1>
	texture{
		pigment{
			image_map{
				gif "je_magic4.gif"
				map_type 0
				interpolate 4
				once
			}
			translate<-0.5,-0.5,-0.5>
			scale 2
			rotate<90,90,0>
		}
	}
	scale<0.06,0.0001,0.04>
	translate<-0.06,0.0001,0>
	rotate<0,50,0>
	translate CardsCoord
}
superellipsoid{<0.1,0.1>
	texture{
		pigment{
			image_map{
				gif "je_magic5.gif"
				map_type 0
				interpolate 4
				once
			}
			translate<-0.5,-0.5,-0.5>
			scale 2
			rotate<90,90,0>
		}
	}
	scale<0.06,0.0001,0.04>
	translate<-0.05,0.0002,0>
	rotate<0,80,0>
	translate CardsCoord
}


/* CHAPTER FOUR: VISUALISATION BY LIGHT_SOURCE */
/* ------------------------------------------- */

//The Lamp
cone{<0,2,0>,0.225,<0,2.08,0>,0 open
	texture{pigment{color White} finish{Shiny ambient 0.2}}
}
cone{<0,2.0001,0>,0.225,<0,2.0801,0>,0 open
	texture{pigment{color rgb<0,0,0>} finish{Shiny ambient 0.2}}
}
light_source{0*x
	color rgb<1,1,0.75>
	looks_like{
		sphere{0*x,0.045
			texture{
				pigment{color rgb<1,1,1>}
				finish{Luminous}
			}
		}
	}		
	translate <0,1.95,0>
	spotlight
	point_at BallCoord
	radius 12
	tightness 50
	falloff 16
	atmosphere off
}

//The Moon (With No Visual Appearance)
light_source{<10,42,75>
	color rgb<0.45,0.45,0.5>
	atmosphere off
}

//Additional Light_source For Natural Ambients
//(To Make Bumps Look Right In Shadows)
light_source{<1,2.2,1>
	color rgb<0.1,0.1,0.12>
	atmosphere off
}


/* EPILOGUE: THE AFTERCARE */
/* ----------------------- */

//Make Things Neat
#render "\n"
