camera {
  location <0,-10,-19>
  direction <0,0,0.8>
  up <0,1,0>
  right <1.333,0,0>
  look_at <0,-8,0>
}

// dust in the tower but not outside...
atmosphere { type 1 distance 500000 samples 18 scattering 0.02 color rgbt<1,1,1,0.8> }

// lighting from above...
light_source { <0,29.8,0> color rgb<0.4,0.4,0.4> atmosphere off }
light_source { <0,50,0> color rgb<0.2,0.2,0.2> shadowless atmosphere off }
// outside light which makes the interior dust visible
light_source { <-2000,1050,2000> color rgb<1,0.9,0.7> }

// a brick to make the tower
#declare Block =
superellipsoid { <0.2, 0.2>
  scale <1.5,1,1>
}

// textures for the blocks
#declare DryBlockTexture =
texture {
  pigment { rgb<0.64,0.6,0.6> }
  normal {
    average normal_map {
      [bumps 0.4 scale 0.02]
      [dents 2 scale 0.3]
      [agate 0.8]
    }
  }
}

#declare WetBlockTexture =
texture {
  pigment { rgb<0.4,0.38,0.38> }
  normal {
    average normal_map {
      [bumps 0.4 scale 0.02]
      [dents 2 scale 0.3]
      [agate 0.8]
    }
  }
  finish { reflection 0.05 phong 0.4 phong_size 80 }
}

#declare BlockTexture =
texture {
  gradient y texture_map {
    [0 WetBlockTexture scale 1/60]
    [0.18 WetBlockTexture scale 1/60]
    [0.2 DryBlockTexture scale 1/60]
  }
  turbulence 0.2
  lambda 5 omega 0.2 octaves 3
  scale 60 translate -22*y
}

// shape of window to "subtract" from tower walls
#declare Window =
union {
  cylinder { <0,0,-2>, <0,0,2>, 4 scale <1,1.2,1> }
  box { <-4,-6,-2>, <4,0,2> }
  translate -6*y
}

#declare Sill =
union {
  object { Block rotate 90*y translate -3*x }
  object { Block rotate 90*y translate -x }
  object { Block rotate 90*y translate x }
  object { Block rotate 90*y translate 3*x }
  translate -12*y
  scale <1,1,1.2>
}

// the tower including windows, window-sills, and stairs
union {
  difference { 
    union {
      #declare Theta = 0
      #while (Theta < 360)
        #declare Y = -21
        #while (Y < 31.5)
          #switch (Y)
            #range (12,25)
            #range (-11,2)
              #switch (Theta)
                #range (0,32)
                #range (82,122)
                #range (172,212)
                #range (262,302)
                #range (352,360)
                  object { Block translate <0,Y,20> rotate (Theta + 4.5*mod(Y/2.1,2))*y }
                #break
              #end
            #break
          #end
          #declare Y = Y + 2.1
        #end
        #declare Theta = Theta + 9
      #end
      difference {
        cylinder { <0,-25,0>, <0,30,0>, 20.8 }
        cylinder { <0,-26,0>, <0,31,0>, 19.6 }
      }
    }
    object { Window translate <0,24,20> rotate 12*y }
    object { Window translate <0,24,-20> rotate 12*y }
    object { Window translate <0,1,20> rotate 102*y }
    object { Window translate <0,1,-20> rotate 102*y }
  }
  #declare Theta = 0
  #while (Theta < 360)
    #declare Y = -21
    #while (Y < 31.5)
      #switch (Y)
        #range (25,32)
        #range (2,12)
        #range (-22,-11)
          object { Block translate <0,Y,20> rotate (Theta + 4.5*mod(Y/2.1,2))*y }
        #break
        #else
          #switch (Theta)
            #range (32,82)
            #range (122,172)
            #range (212,262)
            #range (302,352)
              object { Block translate <0,Y,20> rotate (Theta + 4.5*mod(Y/2.1,2))*y }
            #break
          #end
      #end
      #declare Y = Y + 2.1
    #end
    #declare Theta = Theta + 9
  #end
  object { Sill translate <0,24,20> rotate 12*y }
  object { Sill translate <0,24,-20> rotate 12*y }
  object { Sill translate <0,1,20> rotate 102*y }
  object { Sill translate <0,1,-20> rotate 102*y }
  #declare Theta = -18
  #declare Y = -21
  #while (Y < 30) 
    union {
      object { Block translate -17.5*x translate z }
      object { Block translate -14.5*x translate z }
      object { Block translate -11.5*x translate z }
      object { Block translate -17.5*x translate -z }
      object { Block translate -14.5*x translate -z }
      object { Block translate -11.5*x translate -z }
      translate Y*y rotate Theta*y
    }
    #declare Y = Y + 2
    #declare Theta = Theta + 11
  #end
  texture { BlockTexture }
}

// wooden boards for tower ceiling
intersection {
  union {
    #declare Count = -20
    #while (Count < 20)
      box { <Count,29.8,-20>, <Count+3.8,30,20> }
      #declare Count = Count + 4
    #end
  }
  cylinder { <0,0,0>, <0,31.5,0>, 20 }
  pigment {
    wood color_map {
      [0 color rgb<0.45,0.3,0.15>]
      [1 color rgb<0.3,0.2,0.1>]
    }
    turbulence 0.03
    rotate <1,2,3>
    translate <10,10,10>
    scale 0.2
  }
  normal {
    wood 0.4 turbulence 0.03 rotate <1,2,3>
    translate <10,10,10> scale 0.2
  }
  finish { phong 0.15 }
}

// ground at the bottom of the tower (as well as outside)
plane { <0,1,0>, -21
  pigment { rgb<0,0.1,0> }
  normal { bumps 0.6 scale 0.2 }
}

// water column
cylinder { <0,-12,0>, <0,-25,0>, 20
  pigment { rgbt<0,0,0.06,0.7> }
  normal { ripples 0.5 frequency 96 scale 200 }
  finish { phong 1 refraction 1 ior 1.333 reflection 0.25 ambient 0 diffuse 0.75 }
}

// sky outside
sphere { <0,0,0>, 5000
  texture {
    pigment { rgb<0.1,0.5,0.6> }
    finish { ambient 1 diffuse 0 }
  }
  texture {
    pigment {
      bozo color_map {
        [0 color rgbt<0.8,0.8,0.8,1>]
        [0.5 color rgbt<0.8,0.8,0.8,1>]
        [0.8 color rgbt<1,1,1,0>]
      }
      turbulence 2
      scale <600,200,600>
    }
    finish { ambient 1 diffuse 0 }
  }
  hollow
}

// cheat so that sky shows through instead of atmosphere color...
cylinder {
  <0,-26,0>, <0,32,0>, 24
  pigment { rgbt<1,1,1,1> }
  inverse
}

// objects for "broom men"
#declare Arms =
union {
  sphere { <0,0,0>, 0.3 scale <1.2,1,1> translate <3.5,5.35,0> }
  sphere { <0,0,0>, 0.3 scale <1.2,1,1> translate <-3.5,5.35,0> }
  cylinder { <3.5,5.35,0>, <2.7,7,0>, 0.17 }
  cylinder { <-3.5,5,0>, <-2.7,7,0>, 0.17 }
  sphere { <2.7,7,0>, 0.18 }
  sphere { <-2.7,7,0>, 0.18 }
  cylinder { <2.7,7,0>, <0,7.2,0>, 0.17 }
  cylinder { <-2.7,7,0>, <0,7.2,0>, 0.17 }
}

#declare BucketHandle =
difference {
  cylinder { <0,0,-0.14>, <0,0,0.14>, 1.36 }
  cylinder { <0,0,-1>, <0,0,1>, 1.34 }
  plane { <0,1,0>, 0 }
}

#declare BucketHandles =
union {
  object { BucketHandle translate <3.5,4,0> }
  object { BucketHandle translate <-3.5,4,0> }
  pigment { rgb<0.6,0.6,0.6> }
  normal { bumps 0.5 scale 0.015 }
  finish { phong 1 metallic reflection 0.1 brilliance 20 }
}

#declare Handle =
union {
  cylinder { <0,0,0>, <0,1.5,0>, 0.19
    pigment { rgb<0.8,0.92,0.96> }
    finish { reflection 0.2 phong 1 metallic brilliance 5 }
  }
  union {
    cylinder { <0,0,0>, <0,11,0>, 0.18 }
    sphere { <0,11,0>, 0.18 }
    object { Arms }
    pigment {
      wood color_map {
        [0 color rgb<0.8,0.6,0.4>]
        [1 color rgb<0.7,0.5,0.3>]
      }
      turbulence 0.05 scale 0.2 rotate <60,72,0> translate <20,10,0>
    }
  }
  object { BucketHandles }
}

#declare Broom =
union {
  union {
    intersection {
      union {
        torus { 1.2, 0.2 rotate -90*x }
        cylinder { <0,0,-0.2>, <0,0,0.2>, 1.2 }
      }
      box { <-2,0,-1>, <2,2,1> }
      scale <1,0.75,1>
    }
    #declare Count = 0
    #while (Count <= 240)
      union {
        cylinder { <-1.2-Count/2000,-Count/100,0>, <1.2+Count/2000,-Count/100,0>, 0.2 }
        sphere { <-1.2-Count/2000,-Count/100,0>, 0.2 }
        sphere { <1.2+Count/2000,-Count/100,0>, 0.2 }
        rotate -y*Count*Count/1920
      }
      #declare Count = Count + 1
    #end
    texture {
      pigment { rgb<0.92,0.75,0.4> }
      normal {
        marble 0.32
        rotate 90*x scale 0.1
      }
    }
    texture {
      pigment {
        marble rotate 90*x rotate 90*z color_map {
          [0 color rgbt<0.4,0.1,0.1,0>]
          [0.04 color rgbt<0.4,0.1,0.1,0>]
          [0.04 color rgbt<1,1,1,1>]
          [0.2 color rgbt<1,1,1,1>]
          [0.2 color rgbt<0.4,0.1,0.1,0>]
          [0.24 color rgbt<0.4,0.1,0.1,0>]
          [0.24 color rgbt<1,1,1,1>]
          [0.4 color rgbt<1,1,1,1>]
          [0.4 color rgbt<0.4,0.1,0.1,0>]
          [0.44 color rgbt<0.4,0.1,0.1,0>]
          [0.44 color rgbt<1,1,1,1>]
          [0.6 color rgbt<1,1,1,1>]
          [0.6 color rgbt<0.4,0.1,0.1,0>]
          [0.64 color rgbt<0.4,0.1,0.1,0>]
          [0.64 color rgbt<1,1,1,1>]
        }
        scale 2.6
        translate -0.8*y
      }
      normal {
        marble 0.5 rotate 90*x rotate 90*z slope_map {
          [0 <1,1>]
          [0.02 <1,1>]
          [0.04 <1,0>]
          [0.2 <1,0>]
          [0.2 <1,1>]
          [0.22 <1,1>]
          [0.24 <1,0>]
          [0.4 <1,0>]
          [0.4 <1,1>]
          [0.42 <1,1>]
          [0.44 <1,0>]
          [0.6 <1,0>]
          [0.6 <1,1>]
          [0.62 <1,1>]
          [0.64 <1,0>]
        }
        scale 2.6
        translate -0.8*y
      }
    }
  }
  object { Handle }
}

#declare Bucket =
union {
  union {
    cylinder { <0,-0.1,0>, <0,0.1,0>, 0.6 }
    cone { <0,-0.1,0>, 0.6, <0,1.1,0>, 0.8 open hollow }
    #declare Count = 0
    #while (Count < 360)
      box { <-0.0785398163397,-0.1,0>, <0.0785398163397,1.1655250606,0.1>
        rotate 9.46232220803*x translate 0.6*z rotate Count*y
      }
      #declare Count = Count + 15
    #end
    pigment {
      wood color_map {
        [0 color rgb<0.7,0.5,0.3>]
        [1 color rgb<0.6,0.4,0.2>]
      }
      turbulence 0.05 scale 0.05 rotate <60,72,0> translate <20,10,0>
    }
  }
  union {
    sphere { <0.9,0.995,0>, 0.07 }
    sphere { <-0.9,0.995,0>, 0.07 }
    difference {
      cylinder { <0,0.96,0>, <0,1.03,0>, 0.9 }
      cylinder { <0,0.8,0>, <0,1.1,0>, 0.84 }
    }
    pigment { rgb<0.6,0.6,0.6> }
    normal { bumps 0.5 scale 0.01 }
    finish { phong 1 metallic reflection 0.1 brilliance 20 }
  }
  translate -0.995*y
  scale <1.5,1.8,1.5>
}

#declare WaterShape =
cone { <0,-0.1,0>, 0.6, <0,1.1,0>, 0.8 translate -0.995*y scale <1.5,1.8,1.5> }

#declare R = seed(69)

// "broom men" carrying pails of water down the stairs
#declare Y = -21
#declare Theta = -18
#while (Y < 30)
  union {
    object { Broom }
    union {
      object { Bucket }
      intersection {
        plane { <0,1,0>, -rand(R)*0.1 rotate (rand(R)*20 - 10)*x }
        object { WaterShape }
        pigment { rgbt<0,0,0.1,0.99> }
        normal { ripples 0.25 scale 10 frequency 45 }
        finish { phong 0.6 refraction 1 ior 1.333 reflection 0.1 }
      }
      rotate (rand(R)*60 - 30)*x translate <3.5,4,0>
    }
    union {
      object { Bucket }
      intersection {
        plane { <0,1,0>, -rand(R)*0.1 rotate (rand(R)*20 - 10)*x }
        object { WaterShape }
        pigment { rgbt<0,0,0.1,0.99> }
        normal { ripples 0.25 scale 10 frequency 45 }
        finish { phong 0.6 refraction 1 ior 1.333 reflection 0.1 }
      }
      rotate (rand(R)*60 - 30)*x translate <-3.5,4,0>
    }
    #if (rand(R) > 0.5)
      scale <-1,1,1>
    #end
    scale 0.7 translate <(-13 - rand(R)*2),2.813,-1.5>
    translate Y*y rotate Theta*y
  }
  #declare Step = floor(rand(R)*1.5) + 2
  #declare Y = Y + Step*2
  #declare Theta = Theta + Step*11
#end
