#include "mytextures.inc"
#include "leaves.inc"

camera {
 location <0,5,-120>
 look_at <0,35,0>
}

light_source { <100,25,-100> color rgb<1,1,1> }
light_source { <-100,25,-100> color rgb<1,1,1> }


sky_sphere {
 pigment {
  gradient y
  color_map {
   [ 0.5  color rgb<165/256,195/256,243/256> ]
   [ 1.0  color rgb<78/256,135/256,256/256> ]
  }
  scale 2
  translate -1
 }
}


global_settings { assumed_gamma 1.5 }


#declare Tmtree = 0005
#include "tmtrees.inc"
#include "treespec.inc"
#declare Memory2 =  Memory
#include "treespec2.inc"
difference {
 object { Tree }
 sphere { <30,0,0>,55
  texture {
   pigment { color rgb<1,1,1> }
  }
 }
}
#declare BarkTexture = texture { Texture0003 }
#declare Leaf = object { Leaf0005
 pigment { color rgb<0,1,0> }
}
#declare TwigsLeavesVisible = 1
#declare Memory = Memory2
#include "treespec2.inc"
intersection {
 object { Tree }
 sphere { <30,0,0>,55
  texture {
   pigment { color rgb<1,1,1> }
  }
 }
}

#declare TwigsLeavesVisible = 0
#declare BarkTexture = texture { Texture0007 }
#include "treemaker.inc"
object { Tree
 translate <-90,0,-25>
}

#declare TwigsVisible = 0
#include "treemaker.inc"
object { Tree
 translate <70,0,100>
}

#include "treemaker.inc"
object { Tree
 translate <-60,0,120>
}

#include "treemaker.inc"
object { Tree
 translate <50,0,150>
}

difference {
 height_field {
  png "lsmap.png"
  scale <300,3,300>
  translate <-150,0,-150>
  rotate <0,180,0>
  texture { Texture0008 }
 }
 sphere { <30,0,0>, 55 }
}

intersection {
 height_field {
  png "lsmap.png"
  scale <300,3,300>
  translate <-150,0,-150>
  rotate <0,180,0>
  texture { Texture0004 }
 }
 sphere { <30,0,0>, 55 }
}


sphere { <-800,-2000,2000>,2040
 texture {
  pigment {
   crackle
   turbulence 0.4
   color_map {
    [ 0.0 color rgb<0,0,0> ]
    [ 0.1 color rgb<141/256,100/256,7/256> ]
    [ 0.7 color rgb<235/256,196/256,21/256> ]
    [ 1 color rgb<235/256,196/256,21/256> ]
   }
  }
  normal { bumps 0.4 scale 0.005 }
  finish {
   ambient 0.2
  }
  scale <2,2,2>
 }
}


sphere { <-200,-3000,3000>,3040
 texture {
  pigment {
   crackle
   turbulence 0.4
   color_map {
    [ 0.0 color rgb<0,0,0> ]
    [ 0.1 color rgb<141/256,100/256,7/256> ]
    [ 0.7 color rgb<235/256,196/256,21/256> ]
    [ 1 color rgb<235/256,196/256,21/256> ]
   }
  }
  normal { bumps 0.4 scale 0.005 }
  finish {
   ambient 0.2
  }
  scale <2,2,2>
 }
}


sphere { <500,-2500,2500>,2540
 texture {
  pigment {
   crackle
   turbulence 0.4
   color_map {
    [ 0.0 color rgb<0,0,0> ]
    [ 0.1 color rgb<141/256,100/256,7/256> ]
    [ 0.7 color rgb<235/256,196/256,21/256> ]
    [ 1 color rgb<235/256,196/256,21/256> ]
   }
  }
  normal { bumps 0.4 scale 0.005 }
  finish {
   ambient 0.2
  }
  scale <2,2,2>
 }
}


#declare Stonea = difference {
 box { <2,2,2>,<-2,-2,-2> }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
 }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
  rotate <0,60,0>
 }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
  rotate <0,120,0>
 }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
  rotate <0,180,0>
 }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
  rotate <0,240,0>
 }
 plane { <-cos(45*pi/180),-sin(45*pi/180),0>,0
  translate <1,0,0>
  rotate <0,300,0>
 }
 plane { <0,1,0>,0 }
}

#declare Stone = union {
 intersection {
  object { Stonea }
  plane { <0,1,0>,0.35 }
 }
 object { Stonea
  matrix <1,0,0,
          0,-2,0,
          0,0,1,
          0,0,0>
 }
 texture {
  pigment { color rgbf<0,0,1,0.5> }
  finish {
   diffuse 0.8
   ambient 0.8
   brilliance 2
  }
 }
}

#declare Sceptre = union {
 object { Stone }
 cylinder { <0,0,0>,<0,-10,0>,0.4
  texture {
   pigment { color rgb<1,1,1> }
  }
 }
}

object { Sceptre
 rotate <-90,0,0>
 rotate <0,140,0>
 translate <30,1.7,-10>
}
