// THIS INCLUDE FILE CONTAINS TREE TYPES FOR THE TreeMaker.inc INCLUDE FILE
// AUTHOR : XAVIER LECLERCQ
// E-MAIL : xavierleclercq@iname.com
// WWW : http://www.geocities.com/SiliconValley/Park/2485/index.html
// THIS FILE DESCRIBES TREE TYPES
// VERSION 1.02
//
// FILES NEEDED :
// mytextures.inc
// leaves.inc
//
// COPYRIGHT INFO :
// YOU ARE ALLOWED TO USE AND DISTRIBUTE THIS FILE FREELY AS LONG AS IT IS FOR A
// NON-COMMERCIAL USE.
//
//////////////////////////////////////////////////////////////////////////////////





// Tmtree0001
// THIS SET OF DECLARATIONS RESTORES THE DEFAULT VALUES
//
/////////////////////////////////////////////////////////

#if (Tmtree = 0001)
 #declare BarkTexture = texture {
  pigment { color rgb<152/256,115/256,6/256> }
 }
 #declare LeafTexture = texture {
  pigment { color rgb<0,1,0> }
 }
 #declare Leaf = mesh {
  triangle { <-0.2,0,0>,<0,0,0.6>,<0.2,0,0> }
  triangle { <-0.2,0,0>,<0,0.6,0>,<0.2,0,0> }
  triangle { <0,-0.2,0>,<0.6,0,0>,<0.2,0,0> }
  texture { LeafTexture }
 }
 #declare TrunkLength = 17
 #declare TrunkBase = 2
 #declare TrunkMaxZ = 0
 #declare TrunkMinZ = TrunkMaxZ
 #declare TrunkMaxNarrowing = 0.8
 #declare TrunkMinNarrowing = TrunkMaxNarrowing
 #declare TrunkMaxBending = 0
 #declare TrunkMinBending = TrunkMaxBending
 #declare TrunkPrecision = 10
 #declare TrunkTextureOwn = 1
 #declare SeedTrunkRotation = seed(10)
 #declare SeedTrunkNarrowing = seed(147)
 #declare SeedTrunkBending = seed(50)
 #declare LimbsVisible = 1
 #declare LimbsMaxLength = 10
 #declare LimbsMinLength = LimbsMaxLength
 #declare LimbsMaxBase = 1.5
 #declare LimbsMinBase = LimbsMaxBase
 #declare LimbsMaxNarrowing = 0.5
 #declare LimbsMinNarrowing = LimbsMaxNarrowing
 #declare LimbsMaxN = 4
 #declare LimbsMinN = LimbsMaxN
 #declare LimbsMaxHeight = 1
 #declare LimbsMinHeight = LimbsMaxHeight
 #declare LimbsMaxZ = 15
 #declare LimbsMinZ = LimbsMaxZ
 #declare LimbsMaxY = 360
 #declare LimbsMinY = 0
 #declare LimbsMaxBending = -45
 #declare LimbsMinBending = LimbsMaxBending
 #declare LimbsPrecision = 10
 #declare LimbsAntiRotation = 1
 #declare LimbsTextureOwn = 1
 #declare LimbsOnTop = 1
 #declare SeedLimbsLength = seed(40)
 #declare SeedLimbsBase = seed(5)
 #declare SeedLimbsNarrowing = seed(10)
 #declare SeedLimbsHeight = seed(7)
 #declare SeedLimbsN = seed(12)
 #declare SeedLimbsZ = seed(65)
 #declare SeedLimbsY = seed(10)
 #declare SeedLimbsBending = seed(52)
 #declare BoughsVisible = 1
 #declare BoughsMaxLength = 6
 #declare BoughsMinLength = BoughsMaxLength
 #declare BoughsMaxBase = 0.7
 #declare BoughsMinBase = BoughsMaxBase
 #declare BoughsMaxNarrowing = 0.4
 #declare BoughsMinNarrowing = BoughsMaxNarrowing
 #declare BoughsMaxN = 4
 #declare BoughsMinN = BoughsMaxN
 #declare BoughsMaxHeight = 1
 #declare BoughsMinHeight = BoughsMaxHeight
 #declare BoughsMaxZ = 20
 #declare BoughsMinZ = BoughsMaxZ
 #declare BoughsMaxY = 360
 #declare BoughsMinY = 0
 #declare BoughsMaxBending = -20
 #declare BoughsMinBending = BoughsMaxBending
 #declare BoughsPrecision = 10
 #declare BoughsAntiRotation = 0
 #declare BoughsTextureOwn = 0
 #declare BoughsOnTop = 0
 #declare SeedBoughsLength = seed(56)
 #declare SeedBoughsBase = seed(21)
 #declare SeedBoughsNarrowing = seed(26)
 #declare SeedBoughsHeight = seed(23)
 #declare SeedBoughsN = seed(28)
 #declare SeedBoughsZ = seed(49)
 #declare SeedBoughsY = seed(29)
 #declare SeedBoughsBending = seed(36)
 #declare BranchesVisible = 1
 #declare BranchesMaxLength = 4
 #declare BranchesMinLength = BranchesMaxLength
 #declare BranchesMaxBase = 0.3
 #declare BranchesMinBase = BranchesMaxBase
 #declare BranchesMaxNarrowing = 0.4
 #declare BranchesMinNarrowing = BranchesMaxNarrowing
 #declare BranchesMaxN = 4
 #declare BranchesMinN = BranchesMaxN
 #declare BranchesMaxHeight = 1
 #declare BranchesMinHeight = BranchesMaxHeight
 #declare BranchesMaxZ = 30
 #declare BranchesMinZ = BranchesMaxZ
 #declare BranchesMaxY = 360
 #declare BranchesMinY = 0
 #declare BranchesMaxBending = -20
 #declare BranchesMinBending = BranchesMaxBending
 #declare BranchesPrecision = 10
 #declare BranchesAntiRotation = 0
 #declare BranchesTextureOwn = 0
 #declare BranchesOnTop = 0
 #declare SeedBranchesLength = seed(41)
 #declare SeedBranchesBase = seed(1)
 #declare SeedBranchesNarrowing = seed(6)
 #declare SeedBranchesHeight = seed(32)
 #declare SeedBranchesN = seed(68)
 #declare SeedBranchesZ = seed(9)
 #declare SeedBranchesY = seed(3)
 #declare SeedBranchesBending = seed(86)
 #declare TwigsVisible = 1
 #declare TwigsMaxLength = 2
 #declare TwigsMinLength = TwigsMaxLength
 #declare TwigsMaxBase = 0.1
 #declare TwigsMinBase = TwigsMaxBase
 #declare TwigsMaxNarrowing = 0.2
 #declare TwigsMinNarrowing = TwigsMaxNarrowing
 #declare TwigsMaxN = 4
 #declare TwigsMinN = TwigsMaxN
 #declare TwigsMaxHeight = 1
 #declare TwigsMinHeight = TwigsMaxHeight
 #declare TwigsMaxZ = 30
 #declare TwigsMinZ = TwigsMaxZ
 #declare TwigsMaxY = 360
 #declare TwigsMinY = 0
 #declare TwigsMaxBending = -20
 #declare TwigsMinBending = TwigsMaxBending
 #declare TwigsPrecision = 10
 #declare TwigsAntiRotation = 0
 #declare TwigsTextureOwn = 0
 #declare TwigsOnTop = 0
 #declare TwigsLeavesVisible = 1
 #declare SeedTwigsLength = seed(41)
 #declare SeedTwigsBase = seed(1)
 #declare SeedTwigsNarrowing = seed(6)
 #declare SeedTwigsHeight = seed(32)
 #declare SeedTwigsN = seed(68)
 #declare SeedTwigsZ = seed(9)
 #declare SeedTwigsY = seed(3)
 #declare SeedTwigsBending = seed(86)
#end

// END OF Tree0001 DECLARATIONS
/////////////////////////////////
/////////////////////////////////





// Tmtree0002
//
///////////////

#if (Tmtree = 0002)
 #include "mytextures.inc"
 #include "leaves.inc"
 #declare BarkTexture = texture { Texture0003 }
 #declare LeafTexture = texture {
  pigment { color rgb<0,1,0> }
  finish {
   diffuse 1
  }
 }
 #declare Leaf = object { Leaf0001
  texture { LeafTexture }
 }
 #declare TrunkLength = 17
 #declare TrunkBase = 4
 #declare TrunkMaxZ = 0
 #declare TrunkMinZ = TrunkMaxZ
 #declare TrunkMaxNarrowing = 0.8
 #declare TrunkMinNarrowing = TrunkMaxNarrowing
 #declare TrunkMaxBending = 0
 #declare TrunkMinBending = TrunkMaxBending
 #declare TrunkPrecision = 10
 #declare TrunkTextureOwn = 1
 #declare SeedTrunkRotation = seed(10)
 #declare SeedTrunkNarrowing = seed(147)
 #declare SeedTrunkBending = seed(50)
 #declare LimbsVisible = 1
 #declare LimbsMaxLength = 10
 #declare LimbsMinLength = 5
 #declare LimbsMaxBase = 2
 #declare LimbsMinBase = 1.5
 #declare LimbsMaxNarrowing = 0.9
 #declare LimbsMinNarrowing = 0.7
 #declare LimbsMaxN = 5
 #declare LimbsMinN = LimbsMaxN
 #declare LimbsMaxHeight = 1
 #declare LimbsMinHeight = 0.7
 #declare LimbsMaxZ = 40
 #declare LimbsMinZ = 20
 #declare LimbsMaxY = 360
 #declare LimbsMinY = 0
 #declare LimbsMaxBending = -10
 #declare LimbsMinBending = -20
 #declare LimbsPrecision = 10
 #declare LimbsAntiRotation = 1
 #declare LimbsTextureOwn = 1
 #declare LimbsOnTop = 1
 #declare SeedLimbsLength = seed(40)
 #declare SeedLimbsBase = seed(5)
 #declare SeedLimbsNarrowing = seed(10)
 #declare SeedLimbsHeight = seed(7)
 #declare SeedLimbsN = seed(12)
 #declare SeedLimbsZ = seed(65)
 #declare SeedLimbsY = seed(10)
 #declare SeedLimbsBending = seed(52)
 #declare BoughsVisible = 1
 #declare BoughsMaxLength = 15
 #declare BoughsMinLength = 10
 #declare BoughsMaxBase = 1.2
 #declare BoughsMinBase = 1
 #declare BoughsMaxNarrowing = 0.7
 #declare BoughsMinNarrowing = BoughsMaxNarrowing
 #declare BoughsMaxN = 6
 #declare BoughsMinN = 3
 #declare BoughsMaxHeight = 1
 #declare BoughsMinHeight = BoughsMaxHeight
 #declare BoughsMaxZ = 30
 #declare BoughsMinZ = 15
 #declare BoughsMaxY = 360
 #declare BoughsMinY = 0
 #declare BoughsMaxBending = -10
 #declare BoughsMinBending = -20
 #declare BoughsPrecision = 10
 #declare BoughsAntiRotation = 0
 #declare BoughsTextureOwn = 0
 #declare BoughsOnTop = 1
 #declare SeedBoughsLength = seed(56)
 #declare SeedBoughsBase = seed(21)
 #declare SeedBoughsNarrowing = seed(26)
 #declare SeedBoughsHeight = seed(23)
 #declare SeedBoughsN = seed(28)
 #declare SeedBoughsZ = seed(49)
 #declare SeedBoughsY = seed(29)
 #declare SeedBoughsBending = seed(36)
 #declare BranchesVisible = 1
 #declare BranchesMaxLength = 10
 #declare BranchesMinLength = 5
 #declare BranchesMaxBase = 0.5
 #declare BranchesMinBase = 0.2
 #declare BranchesMaxNarrowing = 0.6
 #declare BranchesMinNarrowing = BranchesMaxNarrowing
 #declare BranchesMaxN = 10
 #declare BranchesMinN = 6
 #declare BranchesMaxHeight = 1
 #declare BranchesMinHeight = 0.1
 #declare BranchesMaxZ = 45
 #declare BranchesMinZ = 10
 #declare BranchesMaxY = 360
 #declare BranchesMinY = 0
 #declare BranchesMaxBending = -10
 #declare BranchesMinBending = -20
 #declare BranchesPrecision = 10
 #declare BranchesAntiRotation = 0
 #declare BranchesTextureOwn = 0
 #declare BranchesOnTop = 1
 #declare SeedBranchesLength = seed(41)
 #declare SeedBranchesBase = seed(1)
 #declare SeedBranchesNarrowing = seed(6)
 #declare SeedBranchesHeight = seed(32)
 #declare SeedBranchesN = seed(68)
 #declare SeedBranchesZ = seed(9)
 #declare SeedBranchesY = seed(3)
 #declare SeedBranchesBending = seed(86)
 #declare TwigsVisible = 1
 #declare TwigsMaxLength = 3
 #declare TwigsMinLength = 0.5
 #declare TwigsMaxBase = 0.1
 #declare TwigsMinBase = 0.05
 #declare TwigsMaxNarrowing = 0.6
 #declare TwigsMinNarrowing = TwigsMaxNarrowing
 #declare TwigsMaxN = 12
 #declare TwigsMinN = 7
 #declare TwigsMaxHeight = 1
 #declare TwigsMinHeight = 0.1
 #declare TwigsMaxZ = 45
 #declare TwigsMinZ = 10
 #declare TwigsMaxY = 360
 #declare TwigsMinY = 0
 #declare TwigsMaxBending = 0
 #declare TwigsMinBending = TwigsMaxBending
 #declare TwigsPrecision = 10
 #declare TwigsAntiRotation = 0
 #declare TwigsTextureOwn = 0
 #declare TwigsOnTop = 1
 #declare TwigsLeavesVisible = 1
 #declare SeedTwigsLength = seed(41)
 #declare SeedTwigsBase = seed(1)
 #declare SeedTwigsNarrowing = seed(6)
 #declare SeedTwigsHeight = seed(32)
 #declare SeedTwigsN = seed(68)
 #declare SeedTwigsZ = seed(9)
 #declare SeedTwigsY = seed(3)
 #declare SeedTwigsBending = seed(86)
#end

// END OF Tree0002 DECLARATIONS
/////////////////////////////////
/////////////////////////////////





// Tmtree0003
//
///////////////

#if (Tmtree = 0003)
 #include "mytextures.inc"
 #declare BarkTexture = texture { Texture0003 }
 #declare LeafTexture = texture {
  pigment { color rgb<0,1,0> }
  finish {
   diffuse 0.5
   ambient 0.3
  }
 }
 #declare OneLeaf = mesh {
  triangle { <-0.3,0,0>,<0,0,1>,<0.3,0,0> }
  triangle { <-0.3,0,0>,<0,1,0>,<0.3,0,0> }
  triangle { <0,-0.3,0>,<1,0,0>,<0.3,0,0> }
  texture { LeafTexture }
  scale <2,2,2>
 }
 #declare Leaf = union {
  object { OneLeaf }
  object { OneLeaf
   translate <0.1,-1.2,0>
  }
  object { OneLeaf
   rotate <180,0,0>
   translate <-0.1,-2.4,0>
  }
 }
 #declare TrunkLength = 15
 #declare TrunkBase = 4
 #declare TrunkMaxZ= 5
 #declare TrunkMinZ = TrunkMaxZ
 #declare TrunkMaxNarrowing = 0.9
 #declare TrunkMinNarrowing = TrunkMaxNarrowing
 #declare TrunkMaxBending = 5
 #declare TrunkMinBending = TrunkMaxBending
 #declare TrunkPrecision = 40
 #declare TrunkTextureOwn = 1
 #declare SeedTrunkRotation = seed(10)
 #declare SeedTrunkNarrowing = seed(147)
 #declare SeedTrunkBending = seed(50)
 #declare LimbsVisible = 1
 #declare LimbsMaxLength = 55
 #declare LimbsMinLength = 35
 #declare LimbsMaxBase = 3
 #declare LimbsMinBase = 2.5
 #declare LimbsMaxNarrowing = 0.2
 #declare LimbsMinNarrowing = LimbsMaxNarrowing
 #declare LimbsMaxN = 4
 #declare LimbsMinN = LimbsMaxN
 #declare LimbsMaxHeight = 1
 #declare LimbsMinHeight = 0.7
 #declare LimbsMaxZ = 45
 #declare LimbsMinZ = 25
 #declare LimbsMaxY = 360
 #declare LimbsMinY = 0
 #declare LimbsMaxBending = -60
 #declare LimbsMinBending = -50
 #declare LimbsPrecision = 25
 #declare LimbsAntiRotation = 1
 #declare LimbsTextureOwn = 1
 #declare LimbsOnTop = 1
 #declare SeedLimbsLength = seed(40)
 #declare SeedLimbsBase = seed(5)
 #declare SeedLimbsNarrowing = seed(10)
 #declare SeedLimbsHeight= seed(7)
 #declare SeedLimbsN = seed(12)
 #declare SeedLimbsZ = seed(65)
 #declare SeedLimbsY = seed(10)
 #declare SeedLimbsBending = seed(52)
 #declare BoughsVisible = 1
 #declare BoughsMaxLength = 20
 #declare BoughsMinLength = 7
 #declare BoughsMaxBase = 1.5
 #declare BoughsMinBase = 1
 #declare BoughsMaxNarrowing = 0.2
 #declare BoughsMinNarrowing = BoughsMaxNarrowing
 #declare BoughsMaxN = 20
 #declare BoughsMinN = 10
 #declare BoughsMaxHeight = 1
 #declare BoughsMinHeight = 0.1
 #declare BoughsMaxZ = 20
 #declare BoughsMinZ = 0
 #declare BoughsMaxY = 360
 #declare BoughsMinY = 0
 #declare BoughsMaxBending = -10
 #declare BoughsMinBending = -20
 #declare BoughsPrecision = 10
 #declare BoughsAntiRotation = 0
 #declare BoughsTextureOwn = 0
 #declare BoughsOnTop = 1
 #declare SeedBoughsLength = seed(56)
 #declare SeedBoughsBase = seed(21)
 #declare SeedBoughsNarrowing = seed(26)
 #declare SeedBoughsHeight = seed(1)
 #declare SeedBoughsN = seed(28)
 #declare SeedBoughsZ = seed(49)
 #declare SeedBoughsY = seed(29)
 #declare SeedBoughsBending = seed(36)
 #declare BranchesVisible = 1
 #declare BranchesMaxLength = 8
 #declare BranchesMinLength = 5
 #declare BranchesMaxBase = 0.4
 #declare BranchesMinBase = 0.2
 #declare BranchesMaxNarrowing = 0.5
 #declare BranchesMinNarrowing = BranchesMaxNarrowing
 #declare BranchesMaxN = 6
 #declare BranchesMinN = 4
 #declare BranchesMaxHeight = 1
 #declare BranchesMinHeight = 0.1
 #declare BranchesMaxZ = 30
 #declare BranchesMinZ = 10
 #declare BranchesMaxY = 360
 #declare BranchesMinY = 0
 #declare BranchesMaxBending = -10
 #declare BranchesMinBending = -20
 #declare BranchesPrecision = 10
 #declare BranchesAntiRotation = 0
 #declare BranchesTextureOwn = 0
 #declare BranchesOnTop = 1
 #declare SeedBranchesLength = seed(41)
 #declare SeedBranchesBase = seed(1)
 #declare SeedBranchesNarrowing = seed(6)
 #declare SeedBranchesHeight = seed(32)
 #declare SeedBranchesN = seed(68)
 #declare SeedBranchesZ = seed(9)
 #declare SeedBranchesY = seed(3)
 #declare SeedBranchesBending = seed(86)
 #declare TwigsVisible = 1
 #declare TwigsMaxLength = 3
 #declare TwigsMinLength = 0.5
 #declare TwigsMaxBase = 0.08
 #declare TwigsMinBase = 0.06
 #declare TwigsMaxNarrowing = 0.8
 #declare TwigsMinNarrowing = TwigsMaxNarrowing
 #declare TwigsMaxN = 2
 #declare TwigsMinN = 2
 #declare TwigsMaxHeight = 1
 #declare TwigsMinHeight = 0.1
 #declare TwigsMaxZ = 90
 #declare TwigsMinZ = 90
 #declare TwigsMaxY = 360
 #declare TwigsminY = 0
 #declare TwigsMaxBending = -20
 #declare TwigsMinBending = TwigsMaxBending
 #declare TwigsPrecision = 10
 #declare TwigsAntiRotation = 0
 #declare TwigsTextureOwn = 0
 #declare TwigsOnTop = 1
 #declare TwigsLeavesVisible = 1
 #declare SeedTwigsLength = seed(41)
 #declare SeedTwigsBase = seed(1)
 #declare SeedTwigsNarrowing = seed(6)
 #declare SeedTwigsHeight = seed(32)
 #declare SeedTwigsN = seed(68)
 #declare SeedTwigsZ = seed(9)
 #declare SeedTwigsY = seed(3)
 #declare SeedTwigsBending = seed(86)
#end

// END OF Tmtree0003 DECLARATIONS
///////////////////////////////////
///////////////////////////////////





// Tmtree0004
//
///////////////

#if (Tmtree = 0004)
 #include "mytextures.inc"
 #include "leaves.inc"
 #declare BarkTexture = texture { Texture0003 }
 #declare LeafTexture = texture {
  pigment { color rgb<0,1,0> }
  finish {
   diffuse 0.5
   ambient 0.3
  }
 }
 #declare Leaf = object { Leaf0003
  texture { LeafTexture }
 }
 #declare TrunkLength = 15
 #declare TrunkBase = 4
 #declare TrunkMaxZ= 5
 #declare TrunkMinZ = TrunkMaxZ
 #declare TrunkMaxNarrowing = 0.9
 #declare TrunkMinNarrowing = TrunkMaxNarrowing
 #declare TrunkMaxBending = 5
 #declare TrunkMinBending = TrunkMaxBending
 #declare TrunkPrecision = 40
 #declare TrunkTextureOwn = 1
 #declare SeedTrunkRotation = seed(10)
 #declare SeedTrunkNarrowing = seed(147)
 #declare SeedTrunkBending = seed(50)
 #declare LimbsVisible = 1
 #declare LimbsMaxLength = 55
 #declare LimbsMinLength = 35
 #declare LimbsMaxBase = 3
 #declare LimbsMinBase = 2.5
 #declare LimbsMaxNarrowing = 0.2
 #declare LimbsMinNarrowing = LimbsMaxNarrowing
 #declare LimbsMaxN = 4
 #declare LimbsMinN = LimbsMaxN
 #declare LimbsMaxHeight = 1
 #declare LimbsMinHeight = 0.7
 #declare LimbsMaxZ = 45
 #declare LimbsMinZ = 25
 #declare LimbsMaxY = 360
 #declare LimbsMinY = 0
 #declare LimbsMaxBending = -60
 #declare LimbsMinBending = -50
 #declare LimbsPrecision = 25
 #declare LimbsAntiRotation = 1
 #declare LimbsTextureOwn = 1
 #declare LimbsOnTop = 1
 #declare SeedLimbsLength = seed(40)
 #declare SeedLimbsBase = seed(5)
 #declare SeedLimbsNarrowing = seed(10)
 #declare SeedLimbsHeight= seed(7)
 #declare SeedLimbsN = seed(12)
 #declare SeedLimbsZ = seed(65)
 #declare SeedLimbsY = seed(10)
 #declare SeedLimbsBending = seed(52)
 #declare BoughsVisible = 1
 #declare BoughsMaxLength = 20
 #declare BoughsMinLength = 7
 #declare BoughsMaxBase = 1.5
 #declare BoughsMinBase = 1
 #declare BoughsMaxNarrowing = 0.2
 #declare BoughsMinNarrowing = BoughsMaxNarrowing
 #declare BoughsMaxN = 20
 #declare BoughsMinN = 10
 #declare BoughsMaxHeight = 1
 #declare BoughsMinHeight = 0.1
 #declare BoughsMaxZ = 20
 #declare BoughsMinZ = 0
 #declare BoughsMaxY = 360
 #declare BoughsMinY = 0
 #declare BoughsMaxBending = -10
 #declare BoughsMinBending = -20
 #declare BoughsPrecision = 10
 #declare BoughsAntiRotation = 0
 #declare BoughsTextureOwn = 0
 #declare BoughsOnTop = 1
 #declare SeedBoughsLength = seed(56)
 #declare SeedBoughsBase = seed(21)
 #declare SeedBoughsNarrowing = seed(26)
 #declare SeedBoughsHeight = seed(1)
 #declare SeedBoughsN = seed(28)
 #declare SeedBoughsZ = seed(49)
 #declare SeedBoughsY = seed(29)
 #declare SeedBoughsBending = seed(36)
 #declare BranchesVisible = 1
 #declare BranchesMaxLength = 8
 #declare BranchesMinLength = 5
 #declare BranchesMaxBase = 0.4
 #declare BranchesMinBase = 0.2
 #declare BranchesMaxNarrowing = 0.5
 #declare BranchesMinNarrowing = BranchesMaxNarrowing
 #declare BranchesMaxN = 6
 #declare BranchesMinN = 4
 #declare BranchesMaxHeight = 1
 #declare BranchesMinHeight = 0.1
 #declare BranchesMaxZ = 30
 #declare BranchesMinZ = 10
 #declare BranchesMaxY = 360
 #declare BranchesMinY = 0
 #declare BranchesMaxBending = -10
 #declare BranchesMinBending = -20
 #declare BranchesPrecision = 10
 #declare BranchesAntiRotation = 0
 #declare BranchesTextureOwn = 0
 #declare BranchesOnTop = 1
 #declare SeedBranchesLength = seed(41)
 #declare SeedBranchesBase = seed(1)
 #declare SeedBranchesNarrowing = seed(6)
 #declare SeedBranchesHeight = seed(32)
 #declare SeedBranchesN = seed(68)
 #declare SeedBranchesZ = seed(9)
 #declare SeedBranchesY = seed(3)
 #declare SeedBranchesBending = seed(86)
 #declare TwigsVisible = 1
 #declare TwigsMaxLength = 3
 #declare TwigsMinLength = 0.5
 #declare TwigsMaxBase = 0.08
 #declare TwigsMinBase = 0.06
 #declare TwigsMaxNarrowing = 0.8
 #declare TwigsMinNarrowing = TwigsMaxNarrowing
 #declare TwigsMaxN = 2
 #declare TwigsMinN = 2
 #declare TwigsMaxHeight = 1
 #declare TwigsMinHeight = 0.1
 #declare TwigsMaxZ = 90
 #declare TwigsMinZ = 90
 #declare TwigsMaxY = 360
 #declare TwigsminY = 0
 #declare TwigsMaxBending = -20
 #declare TwigsMinBending = TwigsMaxBending
 #declare TwigsPrecision = 10
 #declare TwigsAntiRotation = 0
 #declare TwigsTextureOwn = 0
 #declare TwigsOnTop = 1
 #declare TwigsLeavesVisible = 1
 #declare SeedTwigsLength = seed(41)
 #declare SeedTwigsBase = seed(1)
 #declare SeedTwigsNarrowing = seed(6)
 #declare SeedTwigsHeight = seed(32)
 #declare SeedTwigsN = seed(68)
 #declare SeedTwigsZ = seed(9)
 #declare SeedTwigsY = seed(3)
 #declare SeedTwigsBending = seed(86)
#end

// END OF Tmtree0004 DECLARATIONS
///////////////////////////////////
///////////////////////////////////





// Tmtree0005
//
///////////////

#if (Tmtree = 0005)
 #include "mytextures.inc"
 #declare BarkTexture = texture { Texture0007 }
 #declare LeafTexture = texture {
  pigment { color rgb<0,1,0> }
 }
 #declare Leaf = mesh {
  triangle { <-0.2,0,0>,<0,0,0.6>,<0.2,0,0> }
  triangle { <-0.2,0,0>,<0,0.6,0>,<0.2,0,0> }
  triangle { <0,-0.2,0>,<0.6,0,0>,<0.2,0,0> }
  texture { LeafTexture }
 }
 #declare TrunkLength = 15
 #declare TrunkBase = 4
 #declare TrunkMaxZ= 5
 #declare TrunkMinZ = TrunkMaxZ
 #declare TrunkMaxNarrowing = 0.9
 #declare TrunkMinNarrowing = TrunkMaxNarrowing
 #declare TrunkMaxBending = 5
 #declare TrunkMinBending = TrunkMaxBending
 #declare TrunkPrecision = 40
 #declare TrunkTextureOwn = 1
 #declare SeedTrunkRotation = seed(10)
 #declare SeedTrunkNarrowing = seed(147)
 #declare SeedTrunkBending = seed(50)
 #declare LimbsVisible = 1
 #declare LimbsMaxLength = 55
 #declare LimbsMinLength = 35
 #declare LimbsMaxBase = 3
 #declare LimbsMinBase = 2.5
 #declare LimbsMaxNarrowing = 0.3
 #declare LimbsMinNarrowing = LimbsMaxNarrowing
 #declare LimbsMaxN = 4
 #declare LimbsMinN = LimbsMaxN
 #declare LimbsMaxHeight = 1
 #declare LimbsMinHeight = 0.7
 #declare LimbsMaxZ = 45
 #declare LimbsMinZ = 25
 #declare LimbsMaxY = 360
 #declare LimbsMinY = 0
 #declare LimbsMaxBending = -60
 #declare LimbsMinBending = -50
 #declare LimbsPrecision = 25
 #declare LimbsAntiRotation = 1
 #declare LimbsTextureOwn = 1
 #declare LimbsOnTop = 0
 #declare SeedLimbsLength = seed(40)
 #declare SeedLimbsBase = seed(5)
 #declare SeedLimbsNarrowing = seed(10)
 #declare SeedLimbsHeight= seed(7)
 #declare SeedLimbsN = seed(12)
 #declare SeedLimbsZ = seed(65)
 #declare SeedLimbsY = seed(10)
 #declare SeedLimbsBending = seed(52)
 #declare BoughsVisible = 1
 #declare BoughsMaxLength = 20
 #declare BoughsMinLength = 7
 #declare BoughsMaxBase = 1
 #declare BoughsMinBase = 0.8
 #declare BoughsMaxNarrowing = 0.4
 #declare BoughsMinNarrowing = BoughsMaxNarrowing
 #declare BoughsMaxN = 20
 #declare BoughsMinN = 10
 #declare BoughsMaxHeight = 1
 #declare BoughsMinHeight = 0.1
 #declare BoughsMaxZ = 20
 #declare BoughsMinZ = 0
 #declare BoughsMaxY = 360
 #declare BoughsMinY = 0
 #declare BoughsMaxBending = -10
 #declare BoughsMinBending = -20
 #declare BoughsPrecision = 10
 #declare BoughsAntiRotation = 0
 #declare BoughsTextureOwn = 1
 #declare BoughsOnTop = 0
 #declare SeedBoughsLength = seed(56)
 #declare SeedBoughsBase = seed(21)
 #declare SeedBoughsNarrowing = seed(26)
 #declare SeedBoughsHeight = seed(1)
 #declare SeedBoughsN = seed(28)
 #declare SeedBoughsZ = seed(49)
 #declare SeedBoughsY = seed(29)
 #declare SeedBoughsBending = seed(36)
 #declare BranchesVisible = 1
 #declare BranchesMaxLength = 8
 #declare BranchesMinLength = 5
 #declare BranchesMaxBase = 0.3
 #declare BranchesMinBase = 0.2
 #declare BranchesMaxNarrowing = 0.5
 #declare BranchesMinNarrowing = BranchesMaxNarrowing
 #declare BranchesMaxN = 6
 #declare BranchesMinN = 4
 #declare BranchesMaxHeight = 1
 #declare BranchesMinHeight = 0.1
 #declare BranchesMaxZ = 30
 #declare BranchesMinZ = 10
 #declare BranchesMaxY = 360
 #declare BranchesMinY = 0
 #declare BranchesMaxBending = -10
 #declare BranchesMinBending = -20
 #declare BranchesPrecision = 10
 #declare BranchesAntiRotation = 0
 #declare BranchesTextureOwn = 0
 #declare BranchesOnTop = 0
 #declare SeedBranchesLength = seed(41)
 #declare SeedBranchesBase = seed(1)
 #declare SeedBranchesNarrowing = seed(6)
 #declare SeedBranchesHeight = seed(32)
 #declare SeedBranchesN = seed(68)
 #declare SeedBranchesZ = seed(9)
 #declare SeedBranchesY = seed(3)
 #declare SeedBranchesBending = seed(86)
 #declare TwigsVisible = 1
 #declare TwigsMaxLength = 3
 #declare TwigsMinLength = 0.5
 #declare TwigsMaxBase = 0.08
 #declare TwigsMinBase = 0.06
 #declare TwigsMaxNarrowing = 0.8
 #declare TwigsMinNarrowing = TwigsMaxNarrowing
 #declare TwigsMaxN = 2
 #declare TwigsMinN = 2
 #declare TwigsMaxHeight = 1
 #declare TwigsMinHeight = 0.1
 #declare TwigsMaxZ = 70
 #declare TwigsMinZ = 10
 #declare TwigsMaxY = 360
 #declare TwigsminY = 0
 #declare TwigsMaxBending = -20
 #declare TwigsMinBending = TwigsMaxBending
 #declare TwigsPrecision = 10
 #declare TwigsAntiRotation = 0
 #declare TwigsTextureOwn = 0
 #declare TwigsOnTop = 0
 #declare TwigsLeavesVisible = 0
 #declare SeedTwigsLength = seed(41)
 #declare SeedTwigsBase = seed(1)
 #declare SeedTwigsNarrowing = seed(6)
 #declare SeedTwigsHeight = seed(32)
 #declare SeedTwigsN = seed(68)
 #declare SeedTwigsZ = seed(9)
 #declare SeedTwigsY = seed(3)
 #declare SeedTwigsBending = seed(86)
#end

// END OF Tmtree0005 DECLARATIONS
///////////////////////////////////
///////////////////////////////////
