

#declare SidePanel = box {
        <0,0,-.01>, <1,1,.01> pigment {White}
        pigment {
#if (Simple = 1)
            White
#else
            image_map {
                gif "MSSide.gif"
                filter all .93
                }
            scale <1,1,1>
#end
            }
        scale <.5,1,1>
        rotate <0,90,0>
        }

#declare SideFlap = box {<0,0,0>, <1*Inch/32,2*Inch,.5> pigment {White} finish {Dull}}
#declare BackFlap = union {
         box {<0,0,0>, <1,.5,1*Inch/32> pigment {White} finish {Dull}}
         box {<0,0,0>, <1,1*Inch/32,-1*Inch> pigment {White} finish {Dull} translate <0,.5,0>}
         }

#declare H_Mirror = box {<0,0,0>, <3*Inch,6*Inch,1*Inch/8> texture {Polished_Chrome}}

#declare Hex_Chars = text { ttf "timrom.ttf" "F23H" 0.15, 0
      pigment {Red}
      finish { Shiny ambient 1 }
      scale .20
      }

#declare Booleans = text { ttf "timrom.ttf" "100101011" 0.15, 0
      pigment {Yellow}
      finish { Shiny ambient 1.5 }
      scale .20
      }

#declare GUI = text { ttf "timrom.ttf" "GUI" 0.15, 0
      pigment {Green}
      finish { Shiny ambient 1.5 }
      scale .20
      }

#declare TCPIP = text { ttf "timrom.ttf" "TCP/IP" 0.15, 0
      pigment {Blue}
      finish { Shiny ambient 1.5 }
      scale .20
      }

#declare Boolean_1 = text { ttf "timrom.ttf" "1" 0.15, 0
      texture {T_Gold_1E}
      finish { ambient .3 }
      scale .10
      }

#declare Boolean_0 = text { ttf "timrom.ttf" "0" 0.15, 0
      texture {T_Gold_1E}
      finish { ambient .3 }
      scale .10
      }

// Arcs of bits....
#if (Bits_On = 1)
#declare BitCount = 128
#declare Count = 0
#declare Radius = 2
#declare Start_Angle = 10
#declare End_Angle = 5
#declare Jitter_Delta = .05
#declare Cosine_Multiplier = 3.5
#declare Y_Translation = .55
#declare Z_Translation = 1.9

#declare BitStream = union {
#while (Count < BitCount)
    #declare Angle = rand(R1) * (180 - Start_Angle - End_Angle) + Start_Angle
    #declare Jitter_Amount = Jitter_Delta + Jitter_Delta * cos(Angle)*Cosine_Multiplier
    #if (rand(R1) < 0.5)
        #declare Obj = Boolean_1
    #else
        #declare Obj = Boolean_0
    #end
    object {Obj
        rotate <360*rand(R1),360*rand(R1),360*rand(R1)>
        translate <rand(R1)*Jitter_Amount-.5*Jitter_Amount,
                   rand(R1)*Jitter_Amount-.5*Jitter_Amount/2,
                   Radius+rand(R1)*Jitter_Amount-.5*Jitter_Amount/2>
        rotate <-Angle,0,0>
        translate <0,0,Z_Translation>
        }
    #declare Count = Count + 1
#end
    translate <0,Y_Translation,0>
    }

object {BitStream}

object {BitStream rotate <0,72,0>}
object {BitStream rotate <0,-72,0>}
object {BitStream rotate <0,144,0>}
object {BitStream rotate <0,-144,0>}
#end // bits on

#declare MagicSoft = union {
   light_source {
      <.5,.5,.25>
      White * .5 + Yellow * .25
      fade_distance 2
      fade_power 2
      atmospheric_attenuation on
      }
    difference {
        box { <0,0,.01>, <1,1,.5> pigment {White} finish {ambient 1}}
        box { <1*Inch/32,1*Inch/32,.01+1*Inch/32>, <1-Inch/32,1+Inch/32,.5-Inch/32> pigment {White} finish {ambient 1}}
        }
    object {SideFlap rotate <0,0,20> translate <0,1,0>}
    object {SideFlap rotate <0,0,-50> translate <1,1,0>}
    object {BackFlap rotate <25,0,0> translate <0,1,.5>}
    object {SidePanel translate <0,0,.5>}

    object {H_Mirror rotate <5,60,-20> translate <.6,.7,.27>} // in box
    object {H_Mirror rotate <0,0,80> rotate <-40,0,0> rotate <0,10,0> translate <0,1.2,.1>} // middle (TCP/IP)
    object {H_Mirror rotate <0,0,110> rotate <-40,0,0> rotate <0,-10,0> translate <.9,1.5,0>} // GUI
    object {Hex_Chars rotate <-2,10,80> translate <.2,.9,.3>}
#if (Smoke_On = 1)
    object {Smoke rotate <0,0,0> translate <.5,.75,.25>}
#end
    box { <0,0,0>, <1,1,.01> // front cover
        pigment {
#if (Simple = 1)
            White
#else
            image_map {
                gif "MSCover.gif"
                filter all .93
                }
            scale <1,1,1>
#end
            }
        }
    scale <.8,1,1>
    }
