 #include "colors.inc"

  global_settings {
    assumed_gamma 2.2
    hf_gray_16
  }


// The hf_gray_16 keyword causes the output to be in a special 16 bit grayscale that
// is perfect for generating height fields. The normal 8 bit output will lead to less smooth surfaces.

// Now we create a camera positioned so that it points directly down the z-axis at the origin.


  camera {
    location <0, 0, -10>
    look_at 0
  }


// We then create a plane positioned like a wall at z=0. This plane will completely fill the screen.
// It will be colored with white and gray wrinkles.

#declare T_Stone_Floor = texture {
    crackle
    texture_map {
        [0 pigment {Gray10} finish { roughness 2 diffuse .2}]
        [0.005 pigment {Gray50} finish { roughness 2 diffuse .2}]
//        [0.4 pigment {Gray} finish { roughness 2 }]
        [0.05 pigment {Gray70} finish { diffuse .2}]
        [1.0 pigment {White} finish { roughness 2 diffuse .2}]
        }
     scale 2
     }

plane { z, 10
      texture {T_Stone_Floor}
      }


// Finally, create a light source.


light_source { <0, 20, -100> color White }
