
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"



// We add a camera that is two units above the origin and ten units back ...


  camera{
    location <0, 0, 0>
    look_at <0,0,1>
    translate <0,5,-15>
//    angle 30
  }


// ... and a light source.


  light_source{ <1000,1000,-1000> White }


#declare T_Stone_Wall = texture {
    crackle
    texture_map {
        [0 pigment {Black} finish { roughness 2 diffuse .2}]
        [0.05 pigment {Gray50*1.2} finish { roughness 2 diffuse .2}]
//        [0.4 pigment {Gray} finish { roughness 2 }]
//        [0.9 pigment {Gray50} finish { diffuse .2}]
        [1.0 pigment {White*1.2} finish { roughness 2 diffuse .2}]
        }
     scale 2
     }
#declare Wall = union {
         height_field {
             tga "stonefloor.tga"
             smooth
             texture {T_Grnt1 scale .25} // or T_Grnt1 or 9?
             translate <-.5, -.26, -.5>
             scale <20, .5, 20>
             }
         box {<-10,-1,-10>, <10,-.05,10> pigment {White}}
         rotate <-90,0,0>
         }

#declare bend_object = Wall
#declare bend_angle = 180
#declare object_axis1 = -x
#declare object_axis2 = x
//#include "include/bend.inc"
object {Wall}
plane {y,0 pigment {Blue}}
