
// Persistence of Vision Ray Tracer Scene Description File
// File: magic.pov
// Vers: 3
// Desc: IRTC Entry - wizardess conjuring something up in a forest glade
// Date: 08/24/97
// Auth: morgan Fraser
//  +SC0.27 +EC0.5 +SR0.25 +ER0.75 // woman settings

#version 3

#include "colors.inc"
#include "Finish.inc"
#include "woods.inc"

//#declare QuickLighting=0
//#declare QuickTrees=0
//#declare SmallForest=1
#declare UseHalos=0
//#declare QuickColour=0
//#declare QuickRock=0

global_settings
{
  assumed_gamma 1.0
  ambient_light .05
  max_trace_level 100
}

// ----------------------------------------
camera
{
  location  <0.0, 5.7, -25.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 2.0,  0.0>
  rotate<0,25,0>
}

sky_sphere
{
  pigment
  {
    granite
    turbulence 4
    color_map{
       [0.0 color blue 0.6/70]
       [0.7 color rgb<.1,.1,.9>/70]
       [1.0 color rgb 1/10] }
  }
}

//light_source
//{
//  0*x // light's position (translated below)
//  color red 1.0  green 1.0  blue 1.0  // light's color
//  translate <-30, 30, -30>
//}

#debug " Making ground\n"
// ----------------------------------------
plane { y, 0
      #ifdef (QuickColour)
            pigment {color rgb <0.7,0.5,0.3>}
      #else
           texture{
                   pigment{
                           granite
                           turbulence 1.5
                           color_map{
                                     [0.0 color rgb <.3,.03,.04>]
                                     [0.5 color rgb <.1,.05,.01>]
                                     [1.0 color rgb <.12,.01,.02>]
                           }
                   }
                   scale .3
                   finish{
                     specular .03
                     roughness .05
                   }
                   normal{
                          crackle
                          turbulence 2
                          bump_size 6
                          scale 2
                   }
           }
           texture{
                   pigment{
                           bozo
                           turbulence 5
                           color_map{
                                     [0.0 color rgbft<.05,.1,.05,0,0>]
                                     [0.1 color rgbft<.05,.2,.05,0,0>]
                                     [0.15 color rgbft<.15,.1,.05,0,0>]
                                     [0.2 color rgbft<.02,.05,.05,0,1>]
                                     [1.0 color rgbft<.02,.02,.05,0,1>]
                           }
                           scale .4
                   }
           }
      #end
      }

/*#declare RndGrass=seed(3425)

#declare Grass=union{
   #declare Row=-20.0
   #while (Row<20.0)
     #declare Col=-20
     #while (Col<20)
       #declare XPos=Col+rand(RndGrass)*0.1
       #declare YPos=Row+rand(RndGrass)*0.1
       cylinder{
         <XPos,0,YPos>,<XPos,rand(RndGrass)*.3+0.002,YPos>.01
       }
       #declare Col=Col+.25
     #end
     #declare Row=Row+.25
     #debug "Row"
   #end
   texture{pigment{color Green}}
}
*/

#debug " Making Rocks\n"

#declare T_Rock=texture{
   #ifdef (QuickColour)
       pigment{
           color rgb<.5,.2,.15>
       }
   #else
        pigment{
           granite
           turbulence 0.7
           color_map{
              [0.0 color rgb<.6,.6,.6>]
              [0.3 color rgb<.02,.03,.06>]
              [0.5 color rgb<.3,.1,.05>]
              [0.65 color rgb<.1,.15,.2>]
              [1.0 color rgb<.1,.03,.08>]
           }
           //scale 3
        }
        finish{
           specular .2
           roughness .01
           //reflection .1
        }
        normal{
           granite
           turbulence 4
           bump_size .3
           scale 3
        }
   #end
}

#declare R1=seed(0)
#declare Rock1=union{
  #ifdef (QuickRock)
  sphere{<0,0,0>,2}
  #else
    blob{
         threshold 1
         #declare Count=0
         #while (Count<200)
                sphere{<1+2.1*rand(R1),rand(R1),0>,.5+rand(R1)*1.2,1 rotate<0,rand(R1)*360,0>}
                #declare Radius=rand(R1)*0.7
                sphere{<3+3*rand(R1),rand(R1)*Radius,0>,Radius,1 rotate<0,rand(R1)*360,0>}
                #declare Count=Count+1
         #end
    }
  #end
    texture{
            T_Rock
    }
}
#declare Rock2=union{
  #ifdef (QuickRock)
  sphere{<0,0,0>,2}
  #else
    blob{
         threshold 1
         #declare Count=0
         #while (Count<200)
                sphere{<2+1.1*rand(R1),rand(R1),0>,rand(R1)*1.7,1 rotate<0,rand(R1)*360,0>}
                #declare Radius=rand(R1)*0.7
                sphere{<3+3*rand(R1),rand(R1)*Radius,0>,Radius,1 rotate<0,rand(R1)*360,0>}
                #declare Count=Count+1
         #end
    }
  #end
    texture{
            T_Rock
    }
}

#debug " Making Trees\n"
#declare Tree1=union{
    cylinder{<0,0,0>,<0,13,0>,.5
            texture{pigment{color rgb<.5,.25,.1>}}}
    sphere{<0,15,0>,4 texture{pigment{color rgb<.2,.5,.05>}}}
}

#declare Tree3=union{
    cylinder{<0,0,0>,<0,13,0>,.5
            texture{pigment{color rgb<1.0,.15,.1>}}}
    sphere{<0,15,0>,4 texture{pigment{color rgb<.2,.5,1.05>}}}
}

#declare RockCircle=union{
object{Rock1
       translate<11.3,0,0>
       rotate<0,45,0>}
object{Rock2
       translate<12,0,0>
       rotate<0,-45,0>}
object{Rock1
       translate<13,0,0>
       rotate<0,90,0>}
object{Rock2
       translate<15,0,0>
       rotate<0,-90,0>}
object{Rock1
       translate<14,0,0>
       rotate<0,135,0>}
object{Rock2
       translate<11,0,0>
       rotate<0,-135,0>}
}

//#declare Tree2=object {
   #declare Tip=1
   #declare BarkTexture=2
   #declare LeafShape=2
   //#declare BaseLen=1.5
   #declare BaseLen=.8 //.45
   #declare LengthInc=1.5
   #declare IncSplits=1.2
   #declare MaxSplits=3
   #declare MinSplits=2
   #declare TipPercent=1
//   #declare SD1=seed(213)
//   #include "trees.inc"
//}

#debug " Making Forest\n"

#declare R1=seed(201)
#declare R2=seed(542)
//#declare Forest=union{
   #declare CountX=0
   #ifdef (SmallForest)
     #declare NumTrees=5
   #else
     #declare NumTrees=15
   #end
   #while (CountX<NumTrees) // 30 is right number
      #declare CountX=CountX+1
      object{
          #ifdef (QuickTrees)
              Tree3
              scale<1,.7+.5*rand(R1),1>
          #else
            #declare SD1=seed(rand(R1)*1000)
            #declare BaseLen=.5+.7*rand(R2)
            #include "trees.inc"
          #end
          translate<0,0,25+120*rand(R1)>
          rotate<0,-20+rand(R1)*90,0>
        }
   #end

   // additional trees
   #declare CountX=0
   #declare LengthInc=3.0
   #declare IncSplits=1.2
   #declare MaxSplits=2
   #declare MinSplits=2
   #ifdef (SmallForest)
     #declare NumTrees=5
   #else
     #declare NumTrees=40
   #end
   #while (CountX<NumTrees) // 30 is right number
      #declare CountX=CountX+1
      object{
          #ifdef (QuickTrees)
              Tree1
              scale<1,1.2+.7*rand(R1),1>
          #else
            #declare SD1=seed(rand(R1)*1000)
            #declare BaseLen=.5+.7*rand(R2)
            #include "trees.inc"
          #end
          translate<0,0,30+120*rand(R1)>
          rotate<0,-20+rand(R1)*90,0>
        }
   #end

   #declare R1=seed(421)
   // rear side  trees
   #declare CountX=0
   #declare LengthInc=3.0
   #declare IncSplits=1.2
   #declare MaxSplits=2
   #declare MinSplits=2
   #while (CountX<10) // 30 is right number
      #declare CountX=CountX+1
      object{
          //#ifdef (QuickTrees)
              Tree3
              scale<1,1.2+.7*rand(R1),1>
          /*#else
            #declare SD1=seed(rand(R1)*1000)
            #declare BaseLen=.5+.7*rand(R2)
            #include "trees.inc"
          #end*/
          translate<0,0,25+10*rand(R1)>
          rotate<0,71+rand(R1)*135,0>
        }
   #end

//}

#debug " Making Torches\n"

#declare T_Bone=texture{
   #ifdef (QuickColour)
      pigment{color White}
   #else
      pigment{
        color rgb<.95,.9,.85>
      }
      finish{
        specular .2
        roughness .002
        reflection .05
      }

   #end
}

#declare T_TorchWood=texture{
  #ifdef (QuickColour)
    pigment{color Brown}
  #else
    pigment{
       wood
       color_map{
        [0.0 color rgb<.8,.2,.1>]
        [0.8 color rgb<.5,.17,.12>]
        [1.0 color rgb<.07,.01,.05>]
       }
       turbulence 0.3
       scale .5
       rotate<90,0,0>
    }
    finish{
       specular .5
       roughness .02
    }
    normal{
      granite
      turbulence .5
      bump_size 5
      scale .1
    }
  #end
}
#declare Torch=union{
   // bone spiral
   blob{
      threshold 1
      #declare Count=0
      #while (Count<4)
        sphere{<.15,Count,0>,.05,1 rotate<0,Count*2*360,0>}
        #declare Count=Count+0.01
      #end
      texture{T_Bone}
   }
   //wood for torch
   union{
      cylinder{<0,0,0>,<0,4,0>,.05}
      cylinder{<.05,2,0>,<0.045,3.6,0>,.05}
      cylinder{<-.05,.3,0>,<-0.04,3.8,0>,.05}
      cylinder{<0,.5,0.05>,<0,3.96,0.03>,.05}
      cylinder{<0,1,-0.05>,<0,3.5,-0.055>,.05}
      texture{T_TorchWood}
   }
   // flame
   #ifdef (UseHalos)
   union{
   intersection{
     merge{
        sphere{<0,0,0>,1.1 scale<1,2,1> translate<0,2,0>}
        cylinder{<0,1,0>,<0,9,0>,1.05}
     }
     sphere{<0,0,0>,1 scale <1,8,1>}
     texture{pigment{color rgbft<1,1,1,0,1>}}
     hollow
     halo{
        glowing
        spherical_mapping
        linear
        turbulence .8
        colour_map{
            [0.0 rgbft <1,1,1,0,1>]
            [0.02 rgbft <.7,.3,.05,.2,.8>]
            [0.12 rgbft <.7,.3,.05,.7,.1>]
            [0.3 rgbft <.8,.8,.1,.2,.1>]
            [0.6 rgbft <.5,.1,.1,.4,.15>]
            [1.0 rgbft <.9,.4,.1,.5,.1>]
         }
        scale <3,8,3>

     }
     scale .1
     translate<0,4,0>
   }
   intersection{
     merge{
        sphere{<0,0,0>,1.1 scale<1,2,1> translate<0,2,0>}
        cylinder{<0,1,0>,<0,9,0>,1.05}
     }
     sphere{<0,0,0>,1 scale <1,8,1>}
     scale<1.5,1,1.5>
     texture{pigment{color rgbft<1,1,1,0,1>}}
     hollow
     halo{
        glowing
        spherical_mapping
        linear
        turbulence .8
        //octaves 5
        lambda 4
        //phase .6
        colour_map{
            [0.0 rgbft <1,1,1,0,1>]
            [0.02 rgbft <.7,.3,.05,.2,.8>]
            [0.12 rgbft <.7,.3,.05,.6,.3>]
            [0.3 rgbft <.8,.8,.1,.3,.25>]
            [0.6 rgbft <.5,.1,.1,.4,.35>]
            [1.0 rgbft <.9,.4,.1,.5,.3>]
         }
        scale <2,6,2>

     }
     scale .25
     translate<0,4,0>
   }
   intersection{
     merge{
        sphere{<0,0,0>,1.1 scale<1,2,1> translate<0,2,0>}
        cylinder{<0,1,0>,<0,9,0>,1.05}
     }
     sphere{<0,0,0>,1 scale <1,8,1>}
     scale<2.5,2,2.5>
     texture{pigment{color rgbft<1,1,1,0,1>}}
     hollow
     halo{
        glowing
        spherical_mapping
        linear
        turbulence .3
        lambda 1.4
        colour_map{
            [0.0 rgbft <1,1,1,0,1>]
            [0.25 rgbft <1,1,1,0,1>]
            [0.3 rgbft <.7,.3,.05,.05,.95>]
            [0.4 rgbft <.7,.3,.05,.2,.7>]
            [0.5 rgbft <.8,.8,.1,.1,.85>]
            [0.6 rgbft <.5,.1,.1,.15,.75>]
            [1.0 rgbft <.9,.4,.1,.25,.7>]
         }
        translate<0,.5,0>
        scale <2,6,2>

     }
     scale .5
     translate<0,3.8,0>
   }
     translate<0,-4,0>
     scale .7
     translate<0,4,0>
   }
   #end

   #ifndef (QuickLighting)
     light_source{
        <0,4.5,0>
        color Orange/4
        fade_distance 5
        fade_power .6
     }
   #end
}

#debug " Making magic rods\n"

#declare MagicRod1=union{
   cylinder{<0,0,0>,<0,1.5,0>,.1
     texture{
       pigment{
         spiral1 2
         scale .3
         turbulence .2
         color_map{
           [0.0 color rgb<.01,.01,.01>/2]
           [0.1 color rgb<.14,.13,.15>/2]
           [0.3 color rgb<.41,.12,.12>/2]
           [1.0 color rgb<.61,.12,.12>/2]
         }
       }
       finish{
         specular .01
         roughness .2
       }
       normal{
         bozo
         scale .05
         bump_size .5
       }
     }
   }
   union{
   //sphere{<0,1.5,0>,.09
     union{
       box{<-.5,-.5,-.5>,<.5,.5,.5>}
       box{<-.5,-.5,-.5>,<.5,.5,.5> rotate<0,45,45>}
       scale <.15,.5,.15>
       //scale 3
       translate<0,1.5,0>
     }
     texture{
       pigment{color rgbft<.8,.83,.99,.4,.3>}
     normal{
        dents
        scale .033
        bump_size 1
     }
     finish{
        refraction 1
        ior 1.6
        reflection .3
        ambient .8
     }
     }
   }
}

#debug " Making magic circle\n"

#declare MagicCircle=union{
   object{MagicRod1 scale .5 translate<4,0,0> rotate<0,0,0>}
   object{MagicRod1 scale .5 translate<4,0,0> rotate<0,90,0>}
   object{MagicRod1 scale .5 translate<4,0,0> rotate<0,180,0>}
   object{MagicRod1 scale .5 translate<4,0,0> rotate<0,270,0>}
   object{MagicRod1 scale .25 translate<4,0,0> rotate<0,45,0>}
   object{MagicRod1 scale .25 translate<4,0,0> rotate<0,135,0>}
   object{MagicRod1 scale .25 translate<4,0,0> rotate<0,225,0>}
   object{MagicRod1 scale .25 translate<4,0,0> rotate<0,315,0>}
   #declare Count=0
   #declare RCnt=seed(623)
   #while (Count<360)
     #declare Count=Count+8+rand(RCnt)*4
     object{MagicRod1
        scale (.25+rand(RCnt)*.25)
        rotate<-15+rand(RCnt)*30,-30+rand(RCnt)*60,-15+rand(RCnt)*30>
        translate<7.5,0,0>
        rotate<0,Count,0>
     }
   #end
   union{
   #declare Count=0
   #while (Count<1000)
       sphere{<-8+rand(R1)*.4,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*360,0>}
       #declare Count=Count+1
   #end
   #ifdef (QuickColour)
       texture{pigment{ color White}}
   #else
       texture{
           pigment{ color rgb<1,1,1>}
           finish {
             ambient .3
             diffuse .1
             specular 1
             roughness .001
           }
       }
   #end
   }
   union{
       #declare Count=0
       #while (Count<300)
           sphere{<-4+rand(R1)*.5,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*360,0>}
           #declare Count=Count+1
       #end
       texture{pigment{ color rgb<.6,.2,.1>}}
   }
   union{
       #declare Count=0
       #while (Count<150)
           sphere{<-2.0+rand(R1)*.3,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*360,0>}
           #declare Count=Count+1
       #end
       texture{pigment{ color rgb<.8,.7,.1>}}
   }
   union{
       #declare Count=0
       #while (Count<300)
           sphere{<-2-rand(R1)*12,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*1,0>}
           sphere{<-2-rand(R1)*12,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*1,0> rotate<0,85,0>}
           sphere{<-2-rand(R1)*12,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*1,0> rotate<0,174,0>}
           sphere{<-2-rand(R1)*12,0,0>,rand(R1)*0.1 rotate<0,rand(R1)*1,0> rotate<0,277,0>}
           #declare Count=Count+1
       #end
       texture{pigment{ color rgb<.45,.5,.1>}}
   }

   #ifndef (UseHalos)
     sphere{<0,0,0>,10/10
       texture{
         pigment{
           color rgbft<.8,.8,1,.1,.3>
         }
       }
      }

   #else
     sphere{<0,0,0>,10
       texture{
         pigment{
           color rgbft<1,1,1,.05,.95>
         }
       }
       hollow
            halo{
              dust
              spherical_mapping
              linear
              turbulence <.2,.3,.1>
              colour_map{
                 [0.0 rgbft <1,1,1,0,1>]
                 [0.4 rgbft <1,1,1,0,1>]
                 [0.5 rgbft <.5,.3,.1,.3,.7>]
                 [0.6 rgbft <3,.5,.2,.2,.8>]
                 [0.8 rgbft <.3,.6,.2,.4,.6>]
                 [1.0 rgbft <.8,.4,.7,.2,-.2>]
              }
              scale <15,1,15>
              translate<0,0,0>
            }
            halo{
              emitting
              spherical_mapping
              linear
              turbulence .7
              colour_map{
                 [0.0 rgbft <1,1,1,0,1>]
                 [0.4 rgbft <1,1,1,0,1>]
                 [0.5 rgbft <.5,.3,.1,.3,.7>]
                 [0.6 rgbft <3,.5,.2,.2,.8>]
                 [0.8 rgbft <.3,.6,.2,.4,.6>]
                 [1.0 rgbft <.8,.4,.7,.2,-.2>]
              }
              scale <4,8,4>
              translate<0,1,0>
            }
      }
     /*sphere{<0,0,0>,10 scale <1.4,.2,1.4>
       texture{
         pigment{
           color rgbft<1,1,1,.05,.95>
         }
       }
       hollow
            halo{
              dust
              spherical_mapping
              linear
              turbulence <.2,.3,.1>
              colour_map{
                 [0.0 rgbft <1,1,1,0,1>]
                 [0.4 rgbft <1,1,1,0,1>]
                 [0.5 rgbft <.5,.3,.1,.3,.7>]
                 [0.6 rgbft <3,.5,.2,.2,.8>]
                 [0.8 rgbft <.3,.6,.2,.4,.6>]
                 [1.0 rgbft <.8,.4,.7,.2,-.2>]
              }
              scale <15,1,15>
              translate<0,0,0>
            }
      }*/
   #end
}

#debug " adding lights\n"

#ifdef (QuickLighting)
   light_source{
        <0,8,0>
        color rgb<1,1,1>
   }
   // moonlight
   /*light_source{
        <10000,5000,-8000>
        color rgb<.85,.87,1>/2
   }*/

#else
   light_source{
        <0,3,0>
        color rgb<1,1,1>*3
        fade_distance 1
        fade_power 3.5
        }
   // moonlight
   light_source{
        <10000,5000,-8000>
        color rgb<.85,.87,1>/2
   }
#end


#debug " Making forest rocks\n"
#declare RFR=seed(3420)
// random forest rocks
#declare ForestRocks=union{
  #declare Count=0
  #while (Count<20)
     object{Rock2
         scale <.3+rand(RFR)*2,.3+rand(RFR)*1.5,.3+rand(RFR)*2>
         translate<27+rand(RFR)*150,0,0>
         rotate<0,rand(RFR)*360,0>}
     object{Rock1
         scale <.3+rand(RFR)*2,.3+rand(RFR)*1.5,.3+rand(RFR)*2>
         translate<27+rand(RFR)*150,0,0>
         rotate<0,rand(RFR)*360,0>}
     #declare Count=Count+1
  #end

  // perimeter rocks
  #declare Count=0
  #while (Count<100)
     object{Rock1
         scale <.3+rand(RFR)*10,.4+rand(RFR)*15,.3+rand(RFR)*20>
         translate<300+rand(RFR)*150,0,0>
         rotate<0,Count/100*360,0>}
     #declare Count=Count+1
  #end
}

#declare Torches=union{
  object {Torch rotate<6,0,2.5> translate<-8,0,0> rotate<0,0,0>}
  object {Torch rotate<1,0,1.5> translate<-8.5,0,0> rotate<0,85,0>}
  object {Torch rotate<3,0,.8> translate<-7.5,0,0> rotate<0,174,0>}
  object {Torch rotate<2.4,0,6.5> translate<-9.0,0,0> rotate<0,277,0>}
}

#debug " Making Tent\n"

#declare Tent_Stake=union{
    //cylinder{<0,0,0>,<0,.5,0>,.05}
    box{<-.05,0,-.05>,<.05,.5,.05>}
    scale 1.5
    #ifdef (QuickColour)
      texture{pigment{Brown}}
    #else
      texture{
        pigment{
          wood
          turbulence .5
          color_map{
            [0.0 rgb <.7,.2,.15>]
            [0.5 rgb <.1,.02,.015>]
            [1.0 rgb <.3,.4,.3>]
          }
          scale .3
        }
      }
    #end
 }

 #declare Tent_Stake=object{MagicRod1}

#declare Tent_Pole=object{MagicRod1 scale <1,2.5,1>}

#declare Tent=union{
  #declare Tent_Width=7
  #declare Tent_Length=8
  #declare Tent_Height=3
  #declare Tent_Corner1=<Tent_Width/2,0,Tent_Length/2>
  #declare Tent_Corner2=<-Tent_Width/2,0,Tent_Length/2>
  #declare Tent_Corner3=<Tent_Width/2,0,-Tent_Length/2>
  #declare Tent_Corner4=<-Tent_Width/2,0,-Tent_Length/2>
  #declare Tent_TopCorner1=<0,Tent_Height,Tent_Length/2>
  #declare Tent_TopCorner2=<0,Tent_Height,-Tent_Length/2>
  // basic shape
  triangle{
    Tent_Corner1,Tent_Corner3,Tent_TopCorner1
  }
  triangle{
    Tent_TopCorner2,Tent_Corner3,Tent_TopCorner1
  }
  triangle{
    Tent_Corner2,Tent_Corner4,Tent_TopCorner1
  }
  triangle{
    Tent_TopCorner2,Tent_Corner4,Tent_TopCorner1
  }
  //doors
  #declare TentSeed=seed(142)
  union{
  triangle{
    Tent_Corner1,
    Tent_TopCorner1,
    <Tent_Width*.1*rand(TentSeed),Tent_Height*.1*rand(TentSeed),Tent_Length*(.5-.01*rand(TentSeed))>
  }
  triangle{
    Tent_Corner2,
    Tent_TopCorner1,
    <-Tent_Width*.1*rand(TentSeed),Tent_Height*.1*rand(TentSeed),Tent_Length*(.5-.01*rand(TentSeed))>
  }
  triangle{
    Tent_Corner3,
    Tent_TopCorner1,
    <Tent_Width*.1*rand(TentSeed),Tent_Height*.1*rand(TentSeed),-Tent_Length*(.5-.01*rand(TentSeed))>
  }
  triangle{
    Tent_Corner4,
    Tent_TopCorner1,
    <-Tent_Width*.1*rand(TentSeed),Tent_Height*.1*rand(TentSeed),-Tent_Length*(.5-.01*rand(TentSeed))>
  }
    //texture{pigment{color rgb<1,0,0>}}
  }
  //stakes
  object{Tent_Stake rotate<25,0,0> translate Tent_Corner1}
  object{Tent_Stake rotate<-15,0,0> translate Tent_Corner2}
  object{Tent_Stake rotate<22,0,0> translate Tent_Corner3}
  object{Tent_Stake rotate<-17,0,0> translate Tent_Corner4}
  object{Tent_Stake rotate<-18,0,0> translate <-Tent_Width/2,0,0>}
  object{Tent_Stake rotate<21,0,0> translate <Tent_Width/2,0,0>}

  object{Tent_Pole translate<0,0,Tent_Length/2-.2>}
  object{Tent_Pole translate<0,0,-Tent_Length/2+.2>}

  #ifdef (QuickColour)
    texture{pigment{color Brown}}
  #else
  texture{
    pigment{
      marble
      turbulence 1.4
      color_map{
        [0.0 color rgbf<.4,.3,.35,.3>]
        [0.4 color rgbf<.4,.3,.35,.3>]
        [0.45 color rgbf<.1,.35,.15,.1>]
        [0.5 color rgbf<.5,.35,.25,.3>]
        [1.0 color rgbf<.5,.35,.25,.3>]
      }
      scale .3
    }
    normal{
      brick
      brick_size <.4,.2,.5>
      mortar .05
      turbulence .4
      bump_size .5
    }
  }
  #end

}

#debug " Making books\n"

#declare Book=union{
  box{<-.2,.02,.02>,<.2,.098,.58>
    texture{
      pigment{White}
    }
  }
  union{
    box{<-.22,.0979,0>,<.22,.1,.6>}
    box{<-.22,0,0>,<.22,.021,.6>}
    texture{
      pigment{Blue}
    }
  }
}

#declare BookStackSeed=seed(753)
#declare BookStackColourSeed=seed(50)
#declare BookStack1=union{
  #declare Count=0
  #while (Count<2)
    #declare BookSize=rand(BookStackSeed)*.2+0.07
    #declare BookColour=rgb<rand(BookStackColourSeed)/2,rand(BookStackColourSeed)/2,rand(BookStackColourSeed)/2>
    #include "book.inc"
    object{Book
           translate<0,0,-0.3>
           rotate<0,rand(BookStackSeed)*360,0>
           scale <1+rand(BookStackSeed)*1,BookSize/0.1,1+rand(BookStackSeed)*1>
           translate<0,Count,0>}
    #declare Count=Count+BookSize
  #end
}
#declare BookStack3=union{
  #declare Count=0
  #while (Count<1.5)
    #declare BookSize=rand(BookStackSeed)*.2+0.07
    #declare BookColour=rgb<rand(BookStackColourSeed)/2,rand(BookStackColourSeed)/2,rand(BookStackColourSeed)/2>
    #include "book.inc"
    object{Book
           translate<0,0,-0.3>
           rotate<0,rand(BookStackSeed)*360,0>
           scale <1+rand(BookStackSeed)*2,BookSize/0.1,.7+rand(BookStackSeed)*2>
           translate<0,Count,0>}
    #declare Count=Count+BookSize
  #end
}

#debug " Making Kegs\n"

#declare T_KegWood=texture{
  #ifdef (QuickColour)
    pigment{color Brown}
  #else
  pigment{
    wood
    frequency 6
    turbulence .08
    color_map{
      [0.0 color rgb<.65,.4,.3>/2]
      [0.3 color rgb<.8,.65,.37>/3]
      [0.85 color rgb<.8,.15,.1>/2.6]
      [1.0 color rgb<.65,.4,.3>/2]
    }
    rotate<90,0,90>
  }
  scale .9
  normal{
    bozo
    turbulence .6
    bump_size 1
    scale .1
  }
  #end
}

#declare T_KegWood2=texture{
  #ifdef (QuickColour)
    pigment{color Brown}
  #else
  pigment{
    radial
    frequency 45
    turbulence .3
    color_map{
      [0.0 color rgb<.65,.4,.3>/4]
      [0.3 color rgb<.8,.65,.37>/2]
      [0.85 color rgb<.8,.2,.1>/2]
      [1.0 color rgb<.65,.4,.3>/4]
    }
  }
  normal{
    dents
    turbulence .1
    bump_size 1
    scale .1
  }
  #end
}

#declare T_KegStraps=texture{
  #ifdef (QuickColour)
    pigment{color Black}
  #else
  pigment{
    color rgb<.04,.01,.1>
  }
  finish{
    specular .2
    roughness .001
    reflection .2
  }
  #end
}

#declare Keg=union{
  cylinder{<0,.01,0>,<0,2.4,0>,1
    texture{
      radial
      frequency 10
      texture_map{
        [0.0 T_KegWood]
        [0.23 T_KegWood]
        [0.24 T_KegStraps]
        [0.35 T_KegStraps]
        [0.36 T_KegWood2 rotate<0,12,0>]
        [0.77 T_KegWood2 rotate<0,12,0>]
        [0.78 pigment{Black}]
        [0.88 pigment{Black}]
        [0.89 T_KegWood]
        [1.0 T_KegWood]
      }
    }
  }

  cylinder{<0,0,0>,<0,.2,0>,1.05}
  difference{
    cylinder{<0,2.3,0>,<0,2.5,0>,1.05}
    cylinder{<0,2.29,0>,<0,2.51,0>,0.9}
  }
  texture{T_KegWood}
}

#debug " Making Cups\n"

#declare T_Cup=texture{
  #ifdef (QuickColour)
    pigment{color Red}
  #else
    pigment{
      granite
      turbulence 0.5
      color_map{
        [0.0 color rgb<.1,.15,.2>]
        [1.0 color rgb<.04,.01,.15>]
      }
    }
  finish{
    diffuse .1
    specular 1
    roughness .09
    reflection .4
    metallic
  }
  #end
}

#declare Cup=union{
  cylinder{<0,0,0>,<0,.05,0>,.25}
  difference{
   cylinder{<0,.04,0>,<0,.4,0>,.22}
   cylinder{<0,.03,0>,<0,.41,0>,.20}
  }
  intersection{
    torus{.15,.04 scale <1,1,.5>
       rotate<90,0,0>
       translate<.25,.25,0>
       rotate<0,-90,0>
    }
  }
  texture{
      T_Cup
  }
}
//object{Torch translate<12,0,0> rotate<0,140,0>}

#debug " Do Forest\n"
//object {Forest}

#debug " Do RockCircle\n"
object{RockCircle}

#debug " Do ForestRocks\n"
object{ForestRocks}


#debug " Do Torches\n"
object{Torches}

#debug " Do MagicCircle\n"
object{MagicCircle}

#debug " Do Temt\n"
object{Tent rotate<0,95,0> translate<-27,0,0> rotate<0,150,0>}

// stack of books
object{BookStack1 translate<-20,0,0> rotate<0,140,0>}
object{BookStack3 translate<-24,0,0> rotate<0,140,0>}

object{Keg scale .5 translate<-24,0,0> rotate<0,160,0>}
object{Keg
   translate<0,-1.2,0>
   rotate<0,0,-90>
   translate<0,1.05,0>
   scale .5
   translate<-24,0,0>
   rotate<0,162,0>}

object{Cup scale 1 translate<-22,0,0> rotate<0,160,0>}
object{Cup
       rotate<-90,0,0>
       rotate<0,-105,0>
       translate<0,.25,0>
       scale .7 translate<-21.5,0,1> rotate<0,160,0>}



#include "Morgan_woman.inc"
//#include "Morgan~1.inc"
object{Person translate <0,.5,0>
         rotate<0,-90,0>
         scale 5.4 //*1.5
         translate<6,0,0>
         rotate<0,140+0,0>
       }


