
#declare GrassTile = height_field
{
    gif "grass.gif"
    texture { pigment { GrassGreen } }
    scale <2,0.05,2>
    translate <-1, -0.61, -1>
}

#declare GrassPlane = union
{
    object { GrassTile translate <0,0,0> }
    object { GrassTile translate <-2,0,0> }
    object { GrassTile translate <2,0,0> }
    object { GrassTile translate <0,0,2> }
    object { GrassTile translate <-2,0,2> }
    object { GrassTile translate <2,0,2> }
    object { GrassTile translate <-2,0,4> }
    object { GrassTile translate <2,0,4> }
    object { GrassTile translate <-4,0,4> }
    object { GrassTile translate <4,0,4> }
    object { GrassTile translate <-2,0,6> }
    object { GrassTile translate <2,0,6> }
    object { GrassTile translate <-4,0,6> }
    object { GrassTile translate <4,0,6> }
    object { GrassTile translate <-6,0,6> }
    object { GrassTile translate <6,0,6> }
    object { GrassTile translate <-2,0,8> }
    object { GrassTile translate <2,0,8> }
    object { GrassTile translate <-4,0,8> }
    object { GrassTile translate <4,0,8> }
    object { GrassTile translate <-6,0,8> }
    object { GrassTile translate <6,0,8> }
}

#declare RiverCutout = height_field
{
    gif "River2.gif"
    water_level 0.001
    smooth
    texture { Landslice_T }
    translate <-0.5,-0.5,-0.5>
    scale <6,0.5,5>
    rotate x*180
    rotate y*-5
    translate<-1.3,-0.6,1.9>
}

#declare River = intersection
{
    plane { y, -0.7 texture { Water } hollow }
    object { RiverCutout }
}


#declare Grass = difference
{
    object { GrassPlane }
    object { RiverCutout }
}

#declare MySky = plane { z, 30 texture { MySky_T } hollow }

#declare Rock = mesh
{
    #include "Rock.inc"
    texture
    {
        MyStone_T
    }
}

#declare Rocks = union
{
    object
    {
        Rock
        rotate z*-100
        rotate y*-15
        scale <0.15,0.1,0.11>
        translate <-1.1,-0.57,1.5>
    }
    object
    {
        Rock
        rotate z*-100
        rotate y*-15
        scale <0.15,0.1,0.11>
        scale 0.75
        rotate y*180
        translate <-1.75,-0.57,2.3>
    }
    object
    {
        Rock
        rotate z*-100
        rotate y*-15
        scale <0.15,0.1,0.11>
        scale 0.9
        rotate y*-175
        translate <-2.4,-0.56,2.4>
    }
    object
    {
        Rock
        rotate z*-100
        rotate y*-15
        scale <0.15,0.1,0.11>
        scale 1.1
        rotate y*135
        translate <-1.6,-0.55,1.4>
    }
}


#declare Reed = union
{
    union
    {
        cone
        {
            <0,-0.5,0>, 0.015, <0,0.16,0>, 0.010
        }
        cone
        {
            <0,-0.3,0>, 0.013 <0.35,0.1,0>, 0.001
            scale <0.5,1,1>
        }
        cone
        {
            <0,-0.45,0>, 0.013 <-0.3,0.05,0>, 0.001
            scale <0.5,1,1>
        }
        texture { ReedStalk_T }
    }
    union
    {
        sphere
        {
            <0,0.1,0>, 0.035
        }
        cylinder
        {
            <0,0.1,0>, <0,0.3,0>, 0.035
        }
        sphere
        {
            <0,0.3,0>, 0.035
        }
        texture { ReedCylinder_T }
    }
    cone
    {
        <0,0.32,0>, 0.015, <0,0.5,0>, 0.002
        texture { ReedCone_T }
    }
    scale 0.75
}


#declare Reeds = union
{
    object { Reed scale <0.7,0.7,0.7> rotate <0,0,0> translate <1,-0.46,0.5> }
    object { Reed scale <0.6,0.7,0.6> rotate <1,65,2> translate <1.1,-0.49,0.4> }
    object { Reed scale <0.65,0.6,0.65> rotate <1,123,-3> translate <1.12,-0.48,0.3> }
    object { Reed scale <0.67,0.66,0.63> rotate <-2,43,1> translate <0.95,-0.5,0.52> }
    object { Reed scale <0.73,0.7,0.73> rotate <-5,167,3> translate <1.25,-0.53,0.45> }
    object { Reed scale <0.64,0.643,0.64> rotate <3,263,4> translate <1.2,-0.45,0.9> }
    object { Reed scale <0.68,0.7,0.67> rotate <2,143,-2> translate <1,-0.46,1.05> }
    object { Reed scale <0.64,0.65,0.67> rotate <3,80,-1> translate <1.35,-0.46,0.71> }
    object { Reed scale <0.61,0.65,0.63> rotate <-2,32,-1> translate <1.1,-0.48,0.85> }
    object { Reed scale <0.57,0.6,0.59> rotate <-1,54,1> translate <0.7,-0.5,1.1> }
}

#declare ReedGrass = cone
{
    <0, -0.5, 0>, 0.015, <0, 0.5, 0>, 0.003
    texture { ReedStalk_T }
}

#declare ReedHighGrassPart = union
{
    object { ReedGrass scale <0.7,0.7,0.7> scale 0.75 rotate <0,0,0> translate <1,-0.46,0.5> translate x*-0.12 }
    object { ReedGrass scale <0.6,0.7,0.6> scale 0.75 rotate <1,65,2> translate <1.1,-0.49,0.4> translate x*-0.12 }
    object { ReedGrass scale <0.65,0.6,0.65> scale 0.75 rotate <1,123,-3> translate <0.925,-0.48,0.6> translate x*-0.12 }
    object { ReedGrass scale <0.67,0.66,0.63> scale 0.75 rotate <-2,43,1> translate <0.95,-0.5,0.52> translate x*-0.12 }
    object { ReedGrass scale <0.73,0.7,0.73> scale 0.75 rotate <-5,167,3> translate <1.25,-0.53,0.45> translate x*-0.12 }
    object { ReedGrass scale <0.64,0.643,0.64> scale 0.75 rotate <3,263,4> translate <1.2,-0.45,0.9> translate x*-0.12 }
    object { ReedGrass scale <0.68,0.7,0.67> scale 0.75 rotate <2,143,-2> translate <1,-0.46,1.05> translate x*-0.12 }
    object { ReedGrass scale <0.64,0.65,0.67> scale 0.75 rotate <3,80,-1> translate <1.35,-0.47,0.71> translate x*-0.12 }
    object { ReedGrass scale <0.61,0.65,0.63> scale 0.75 rotate <-2,32,-1> translate <1.1,-0.48,0.85> translate x*-0.12 }
    object { ReedGrass scale <0.57,0.6,0.59> scale 0.75 rotate <-1,54,1> translate <0.7,-0.5,1.1> translate x*-0.12 }
}

#declare ReedHighGrass = union
{
    object { ReedHighGrassPart translate <-0.05,-0.05,-0.05> }
    object { ReedHighGrassPart translate <-0.1,0,-0.75> rotate y*180 translate <1.9,-0.1,0.25> }
}

#declare Mountains = height_field
{
    gif "temple.ghf"
//    water_level 0.25
    rotate <0,0,-3>
//    scale <30, 20, 2>
    texture
    {
        pigment
        {
            image_map { gif "temple.ghf" }
            rotate <90,0,-3>
        }
//        scale <30, 20, 2>
        finish { reflection 0.1 diffuse 0.7 ambient 0.2}
    }
    translate <-0.5,-0.5,-0.5>
    scale <40,8,11>
    translate <0,0,25>
//    translate <3, 0.5, 13> //-1.1
    smooth
}
