//
// Ein komisches, astronomisches Gert
//
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "stones.inc"

#declare TestTexturenFinish = finish { diffuse 0 ambient 1 }


///////////////////////////////////////////////////////
// T_LampenGlas
//
// Ein gelbes Glas fr leuchtene Laternen etc. Durch
// den bertriebenen Filterwert strahlt es stark
///////////////////////////////////////////////////////
#declare T_LampenGlas = texture
{
    finish { F_Glass4 }
    normal { agate 0.01 }
    pigment { color rgbf <0.858824, 0.858824, 0.439216, 3> }
}


///////////////////////////////////////////////////////
// T_LeuchtGlasRot
//
// Ein rotes Glas als leuchtender Glasstein
///////////////////////////////////////////////////////
#declare T_LeuchtGlasRot= texture
{
    finish { F_Glass4 }
    pigment { color rgbf <0.556863, 0.137255, 0.137255, 3> }
}



///////////////////////////////////////////////////////
// T_GlasSchwarz
//
// Tiefscharzess, undurchsichtiges Glas
///////////////////////////////////////////////////////
#declare T_GlasSchwarz = texture
{
    pigment { color rgbf <0.0, 0.0, 0.0, 0.0> }
    finish { F_Glass3 }
}


///////////////////////////////////////////////////////
// T_GlasGeriffelt
//
// Durchsichtiges, farbloses Glas mit leichter Rauhheit
///////////////////////////////////////////////////////
#declare T_GlasGeriffelt = texture
{
    pigment { color rgbf <1.0, 1.0, 1.0, 1.0> }
    finish { F_Glass3 }
    normal { agate 0.01 }
}

///////////////////////////////////////////////////////
// T_GlasStarkGeriffelt
//
// Durchsichtiges, farbloses Glas mit leichter Rauhheit
///////////////////////////////////////////////////////
#declare T_GlasStarkGeriffelt = texture
{
    pigment { color rgbf <1.0, 1.0, 1.0, 1.0> }
    finish { F_Glass3 }
    normal { agate 0.1 }
}


///////////////////////////////////////////////////////
// T_LampenFassung
//
// Bronzefarbenes Material fr Lampenfassungen
///////////////////////////////////////////////////////
#declare T_LampenFassung  = texture { T_Brass_1A }


#declare Dicke = 0.5
//////////////////////////////////////////////////////////////////////
// Das komische, astronomische Megert
// Mae      : 1x1x1
// Nullpunkt : x und z mittig, y unten
#declare KomischesGeraet = union
{
   difference
   {
      cylinder { <3,11,0>, <3,11,Dicke>, 15.5 }
      cylinder { <3,17,-1>, <3,17,Dicke+1>, 10 }
      cylinder { <0,0,-1>, <0,0,Dicke+1>, 7.5 }
      cylinder { <-7.5,6.5,-1>, <-7.5,6.5,Dicke+1>, 1.3 }
      cylinder { <-12.5,17,-1>, <-12.5,17,Dicke+1>, 2.4 }
      cylinder { <-5,12,-1>, <-5,12,Dicke+1>, 1 }
      box { <2,-10,-1>, <30,30,Dicke+1> }
   }
   difference
   {
      cylinder { <-12.5,17,0>, <-12.5,17,Dicke>, 2.5 }
      cylinder { <-13,17.2,-1>, <-13,17.2,Dicke+1>, 2.4 }
   }
   difference
   {
      cylinder { <-5,12,0>, <-5,12,Dicke>, 2 }
      cylinder { <-5,12,-1>, <-5,12,Dicke+1>, 1 }
   }
   difference
   {
      cylinder { <-5,12,-0.1>, <-5,12,Dicke+0.1>, 3.5 }
      cylinder { <-5,12,-1>, <-5,12,Dicke+1>, 3 }
   }
   difference
   {
      cylinder { <0,0,-0.1>, <0,0,Dicke+0.1>, 7.4 }
      cylinder { <0,0,-1>, <0,0,Dicke+1>, 6 }
      #declare Winkel=0
      #while( Winkel<360 )
         cylinder { <7.3,0,-0.1>, <5,0,-0.1>, 0.1 rotate <0,0,Winkel> }
         #declare Winkel= Winkel+15
      #end
   }
   difference
   {
      cylinder { <0,0,0.1>, <0,0,Dicke-0.1>, 5.9 }
      cylinder { <0,0,-1>, <0,0,Dicke+1>, 4 }
   }

   cylinder { <-6,6.5,Dicke/2>, <-9,6.5,Dicke/2>, Dicke*0.3 }
   cylinder { <-7.5,5,Dicke/2>, <-7.5,8,Dicke/2>, Dicke*0.3 }

   #declare Winkel=0
   #while( Winkel<360 )
      cone { <4.1,0,Dicke/2>, Dicke*0.5, <3,0,Dicke/2>, 0 rotate <0,0,Winkel> }
      #declare Winkel= Winkel+30
   #end

   scale 0.8
}


// Hhe: 1
#declare Rueckenstreifen = intersection
{
   difference
   {
      cylinder { <0,0,0>, <0,1,0>, 8 }
      cylinder { <0,-1,0>, <0,2,0>, 7.8 }
   }
   box { <-3,0,-8>, <3,1,-7> }
}

#declare Buchdeckel = union
{
   box { <-0.2,0,-7>, <0.2,30,7> }
}


#declare Buch = union
{
   // der Buchruecken
   union
   {
      object { Rueckenstreifen scale <1,30,1>  }
      object { Buchdeckel translate <3,0,0> }
      object { Buchdeckel translate <-3,0,0> }
      texture { T_Stone6 finish {diffuse 0 }  scale 5}
   }
   box { <-2.8,1,-6.8>, <2.8,29,6> pigment { color White } }

   union
   {
      object { Rueckenstreifen scale <1,1,1> translate <0,26,-0.1> }
      object { Rueckenstreifen scale <1,1,1> translate <0,24,-0.1> }
      object { Rueckenstreifen scale <1,1,1> translate <0,5,-0.1> }
      object { Rueckenstreifen scale <1,1,1> translate <0,7,-0.1> }
      texture { T_Copper_5A }
   }
}


