
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: DRESS
// Date: v1 26.08.1997
// Auth: NB

#declare SIDE = 1 // 1=left, -1=right, don't even try other values
#declare ZCENT = 3.05*SIDE

#declare HR_02 = .67
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11
#declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 10.7

//#declare ZCENT = 3.05

#declare ZARM01 = -.82
#declare YARM01 = 11
#declare XARM01 = 0
#declare AAX_01 = 2
#declare AAZ_01 = 5
#declare AB_01 = 6.5
#declare AB_02 = 5.8
#declare AAZ_02 = 20
#declare AAY_02 = 15

// #declare LJZ_01 = -30
// #declare LJZ_02 = 40
// #declare LJZ_03 = 20

difference{

blob{ threshold HD_02
//leg
   cylinder{<0,0,0><0,LB_01*-1,0>,1.4,HS_02
      rotate x*(LAX_01*SIDE)*-1
      rotate y*0*SIDE
      rotate z*LAZ_01
   rotate z*DJZ_01}

   sphere{0,1,HS_02
      scale <2/HR_02,5.2/HR_02,2.0/HR_02>*1.05
      rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
      translate <-0.4,LB_01/-2.3,0.8*SIDE>
   rotate z*DJZ_01}

   sphere{0,1,HS_02
      scale <1.2/HR_02,4.5/HR_02,1.2/HR_02>*1.05
      rotate <0*SIDE,0*SIDE,-5>
      translate <0,LB_01/-2,1.3*SIDE>
   rotate z*DJZ_01}

//*
   sphere{0,1,HS_02
      scale <1.6/HR_02,3/HR_02,2.2/HR_02>*1.05
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*DJZ_01/1.2}

   sphere{0,1,HS_02
      scale <.9/HR_02,1/HR_02,1/HR_02>*1.05
      translate y*-1.5
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*DJZ_01/1.2}
//*

cylinder{<0,0,0><0,LB_01*1.2,0>,1,HS_02
     translate z*ZCENT
     rotate z*-5}

sphere{0,1,HS_02
     scale <1.2/HR_02,2.4/HR_02,1.5/HR_02>*1.05
     translate <-.5,.5,ZCENT>
     rotate z*15}
sphere{0,1,HS_02
     scale <1.4/HR_02,1.8/HR_02,1.4/HR_02>
     translate <-.8,.1,ZCENT>
     rotate z*15}
//
//
sphere{0,1,HS_02
     scale <2/HR_02,4.5/HR_02,2/HR_02>*1.05
     translate <-.8,-5,ZCENT>
     rotate z*0}
//
sphere{0,1,HS_02
     scale <2.2/HR_02,2.5/HR_02,3/HR_02>*1.05
     translate <-.28,1.4,ZCENT>
     rotate z*15}

cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.2/HR_02,1,2.2/HR_02>*1.05
     translate <-.7,2,ZCENT>
     rotate z*-5}

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.3/HR_02,3.2/HR_02,2.3/HR_02>*1.05
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT/1.6>}

sphere{0,1,-.3
     scale <.5/HR_02,.8/HR_02,2/HR_02>*1.05
     rotate <0*SIDE,0*SIDE,0>
     translate <-3.5,4,ZCENT>}

sphere{0,1,HS_02
     scale <1.7/HR_02,1.0/HR_02,1.3/HR_02>*1.05
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.6,ZCENT/3>}

sphere{0,1,HS_02
     scale <1.0/HR_02,1.0/HR_02,1.2/HR_02>*1.05
     translate x*-.5
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.5,ZCENT/3>}
/*
sphere{0,1,HS_02
     scale <.3/HR_02,.3/HR_02,.3/HR_02>*1.05
     translate x*-1.6
     rotate <-10*SIDE,-15*SIDE,-5>
     translate <-2.5,8.5,ZCENT/3>}
*/

sphere{0,1,HS_02
     scale <.95/HR_02,2.9/HR_02,2.5/HR_02>*1.05
     rotate <0*SIDE,0*SIDE,-20>
     translate <-1,10.2,ZCENT>}

cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.4/HR_02,1.5/HR_02,.6/HR_02>*1.05
     rotate x*-25*SIDE
     rotate y*25*SIDE
     translate <1.5,9.5,.85*SIDE>}

// ARM: internal part

   sphere{0,1,HS_02
          scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>*1.05
          rotate x*-10*SIDE
          translate <XARM01,YARM01,ZARM01*SIDE>}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,4.5/HR_02,2.2/HR_02>
     rotate x*-8
     translate <0,12,(ZCENT-7)>}



#declare SIDE=SIDE*-1
//leg
   cylinder{<0,0,0><0,LB_01*-1,0>,1.4,HS_02
      rotate x*(LAX_01*SIDE)*-1
      rotate y*0*SIDE
      rotate z*LAZ_01
   rotate z*DJZ_11
   translate z*ZCENT*2}

   sphere{0,1,HS_02
      scale <2/HR_02,5.2/HR_02,2.0/HR_02>*1.05
      rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
      translate <-0.4,LB_01/-2.3,0.8*SIDE>
   rotate z*DJZ_11
   translate z*ZCENT*2}

   sphere{0,1,HS_02
      scale <1.2/HR_02,4.5/HR_02,1.2/HR_02>*1.05
      rotate <0*SIDE,0*SIDE,-5>
      translate <0,LB_01/-2,1.3*SIDE>
   rotate z*DJZ_11
   translate z*ZCENT*2}



   cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.2/HR_02,1,2.2/HR_02>*1.05
     translate <-.7,2,ZCENT*-1>
     rotate z*-5
   translate z*ZCENT*2}

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.3/HR_02,3.2/HR_02,2.3/HR_02>*1.05
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT*-1/1.6>
   translate z*ZCENT*2}

sphere{0,1,-.3
     scale <.5/HR_02,.8/HR_02,2/HR_02>*1.05
     rotate <0*SIDE,0*SIDE,0>
     translate <-3.5,4,ZCENT*-1>
 translate z*ZCENT*2}

sphere{0,1,HS_02
     scale <1.7/HR_02,1.0/HR_02,1.3/HR_02>*1.05
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.6,ZCENT*-1/3>
  translate z*ZCENT*2}

sphere{0,1,HS_02
     scale <1.0/HR_02,1.0/HR_02,1.2/HR_02>*1.05
     translate x*-.5
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.5,ZCENT*-1/3>
  translate z*ZCENT*2}
/*
sphere{0,1,HS_02
     scale <.3/HR_02,.3/HR_02,.3/HR_02>*1.05
     translate x*-1.6
     rotate <-10*SIDE,-15*SIDE,-5>
     translate <-2.5,8.5,ZCENT/3>}
*/
cylinder{<0,0,-1><0,0,1>1.8,HS_02*.7 translate <-3,8.2,ZCENT>}
//*
   sphere{0,1,HS_02
      scale <1.6/HR_02,3/HR_02,2.2/HR_02>*1.05
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*DJZ_11/1.2
   translate z*ZCENT*2}

   sphere{0,1,HS_02
      scale <.9/HR_02,1/HR_02,1/HR_02>*1.05
      translate y*-1.5
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*DJZ_11/1.2
   translate z*ZCENT*2}
//*
   sphere{0,1,HS_02
          scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>*1.05
          rotate x*-10*SIDE
          translate <XARM01,YARM01,ZARM01*SIDE>
          translate z*ZCENT*2}

cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.4/HR_02,1.5/HR_02,.6/HR_02>*1.05
     rotate x*-25*SIDE
     rotate y*25*SIDE
     translate <1.5,9.5,.85*SIDE>
     translate z*ZCENT*2}


sphere{0,1,-6
   scale <10,1,10>
   translate y*-5}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,3.3/HR_02,2.2/HR_02>
     translate <0,14,ZCENT>}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,4.5/HR_02,2.2/HR_02>
     rotate x*8
     translate <0,12,(ZCENT+7)>}

sturm

translate y*10
translate z*ZCENT*-1
}
box{<-10,.6,-10><10,-10,10>
translate y*(10-5)}
texture{DD_TEX}
}


