
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: MALE HEAD
// Date: 26.08.1997
// Auth: N.B.

// eye ball texture
#declare EY_TEX =
texture{
   finish{
   diffuse .9
   specular .9
   roughness .001
   ambient <1,.97,.97>*.7
   reflection .3
   }
   pigment{color rgb <1,.97,.97>}
}

#declare HR_01 = .65
#declare HS_01 = 3
#declare HD_01 = HS_01*pow((1-pow(HR_01,2)),2)

#declare HEAD01=
blob{ threshold HD_01

//part 01 - cranium
   cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <1.5/HR_01,1.2/HR_01,.85/HR_01> translate y*.45}
   cylinder{<.9,0,0><-.9,0,0>,1,HS_01 scale <.7/HR_01,1.3/HR_01,.8/HR_01> translate y*.3}
   sphere{0,1,HS_01 scale <1.2/HR_01,1.1/HR_01,1.1/HR_01> translate <.8,-.3,0>}

//part 02 - temple
   cylinder{<0,0,.5><0,0,-.5>,1,HS_01  scale <.55/HR_01,.75/HR_01,.7/HR_01>
      rotate z*30 translate <-.75,-.3,0>}

//part 03 - cheek
   cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <.75/HR_01,.5/HR_01,.68/HR_01>
      translate <-.9,-.95,0>}
   cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <.5/HR_01,.5/HR_01,.67/HR_01>
      translate <-.5,-1.5,0>}
   sphere{0,1,HS_01 scale <.4/HR_01,.5/HR_01,.65/HR_01> translate <-1.2,-1.6,0>}

//part 04 - lips
   sphere{0,1,HS_01*.9
      scale <.3/HR_01,.15/HR_01,.37/HR_01> //z:.4
      rotate z*-10
      translate <-1.6,-1.55,0>}
   sphere{0,1,HS_01*.9
      scale <.3/HR_01,.15/HR_01,.32/HR_01> //z:.35
      rotate z*5
      translate <-1.55,-1.82,0>}
   sphere{0,1,-5
      scale <2/HR_01,.15/HR_01,.35/HR_01>
      //rotate z*5
      translate <-2,(1.55+1.82)/-2,0>
      texture{SK_TEX pigment{ color rgb <1,.8,.6>*.3}}
      }

//part05 - chin
   cylinder{<1,0,0><0,0,0>,1,HS_01 scale <.5/HR_01,.45/HR_01,.5/HR_01>
      rotate y*25 rotate z*15 translate <-1.15,-2.05,-.15>
      //texture{SK_TEX pigment{ color rgb <1,.8,.6>*.8}}
      }
   cylinder{<1,0,0><0,0,0>,1,HS_01 scale <.5/HR_01,.45/HR_01,.5/HR_01>
      rotate y*-25 rotate z*15 translate <-1.15,-2.05,.15>
      //texture{SK_TEX pigment{ color rgb <1,.8,.6>*.8}}
      }

//part06 - lower jaw
   cylinder{<0,0,0><0,1,0>,1,HS_01 scale <.9/HR_01,.5/HR_01,.8/HR_01>
      rotate <-7,0,-10> translate<-.6,-1.6,-.35>}
   cylinder{<0,0,0><0,1,0>,1,HS_01 scale <.9/HR_01,.5/HR_01,.8/HR_01>
      rotate <7,0,-10> translate<-.6,-1.6,.35>}

//part071 - nose bridge
   cylinder{<0,0,0><0,1,0>,1,HS_01 scale <.46/HR_01,.3/HR_01,.2/HR_01>
      rotate z*-36 translate<-1.8,-1.00,0>}

//part072 - nostrils
   sphere{0,1,HS_01 scale <.25/HR_01,.13/HR_01,.1/HR_01>
      rotate <0,27,-15> translate<-1.82,-1,-.27>}
   sphere{0,1,HS_01 scale <.25/HR_01,.13/HR_01,.1/HR_01>
      rotate <0,-27,-15> translate<-1.82,-1,.27>}

//part073 - nose tip
   sphere{0,1,HS_01 scale <.25/HR_01,.15/HR_01,.25/HR_01>
      rotate <0,0,2> translate<-1.95,-.95,0>}

//part074 - upper lip
   sphere{0,1,HS_01 scale <.2/HR_01,.25/HR_01,.3/HR_01>
      rotate z*-20 translate<-1.60,-1.2,0>}

//part08 - eye sockets
   sphere{0,1,-2 scale <.4/HR_01,.25/HR_01,.45/HR_01>
      rotate <0,-18,0> translate<-1.5,-.3,-.81>
      texture{SK_TEX pigment{ color rgb <1,.8,.6>*.7}}
      }
   sphere{0,1,-2 scale <.4/HR_01,.25/HR_01,.45/HR_01>
      rotate <0,18,0> translate<-1.5,-.3,.81>
      texture{SK_TEX pigment{ color rgb <1,.8,.6>*.7}}
      }

//part09 - neck
   cylinder{<0,0,0><0,-2.2,0>,1,HS_01
      scale <1/HR_01,1,.9/HR_01>
      rotate z*7
      translate <.3,-1.5,0>}
sturm
}

//left eye:
#declare L_EYE=
union{
   // eye lids
   difference{
      blob{
         sphere{0,1,HS_01
            scale <.4/HR_01,.38/HR_01,.35/HR_01>*.85
               //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.95}
               }
         sphere{0,1,HS_01
            scale <.7/HR_01,.2/HR_01,.36/HR_01>*.85
            translate z*-.04
               //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.9}
               }
      }
      sphere{0,1
         scale <4,.14,.4>*.85
         rotate z*4
         rotate x*-1
         rotate y*5
         translate z*-.04
            //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.9}
            }
   }
   // eye ball
   sphere{0,1
      scale <.4,.39,.4>*.845
         texture {EY_TEX}}
   // iris
   sphere{0,1
      scale .19
      translate x*-.2
      rotate <0,5,0>
         texture {EY_TEX} pigment{ color rgb <.2,.18,.1>}}
   // pupil
   sphere{0,1
      scale .1
      translate x*-.3
      rotate <0,5,0>
         texture {EY_TEX} pigment{ color rgb <0,0,.0>}}

      rotate <2,-15,0>
      translate<-1.25,-.33,-.58>
}
// right eye:
#declare R_EYE=
union{
   // eye lids
   difference{
      blob{
         sphere{0,1,HS_01
            scale <.4/HR_01,.38/HR_01,.35/HR_01>*.85
               //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.95}
               }
         sphere{0,1,HS_01
            scale <.7/HR_01,.2/HR_01,.36/HR_01>*.85
            translate z*.04
               //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.9}
               }
      }
      sphere{0,1
         scale <4,.14,.4>*.85
         rotate z*4
         rotate x*1
         rotate y*-5
         translate z*.04
            //texture {SK_TEX} pigment{color rgb <1,.8,.6>*.9}
            }
   }
   // eye ball
   sphere{0,1
      scale <.4,.39,.4>*.845
         texture {EY_TEX}}
   // iris
   sphere{0,1
      scale .19
      translate x*-.2
      rotate <0,-5,0>
         texture {EY_TEX} pigment{ color rgb <.2,.18,.1>}}
   // pupil
   sphere{0,1
      scale .1
      translate x*-.3
      rotate <0,-5,0>
         texture {EY_TEX} pigment{ color rgb <0,0,0>}}

      rotate <-2,15,0>
      translate<-1.25,-.33,.58>

}

//hair texture:

#declare HAIR_TEX01 =
texture{
   finish{
   brilliance .8
   diffuse .9
   phong 0.2
   phong_size 20
   ambient <0.3,0.2,.1>*2
   //crand .5
   }
   normal{wrinkles 1 scale<.1,5,.1>}
   pigment { bozo
       turbulence 1.9
          //octaves 3
          //lambda 10
          //omega 4
          color_map {
          [0.0, 0.5  color rgbf <.6*1.2,0.55*1.2,.5*1.2,.3>
                      color rgbf <.6,0.55,.5,.4>*1.2]
          [0.5, 1.0  color rgbf <.6,0.55,.5,.4>*1.2
                      color rgbf <.6*1.2,0.55*1.2,.5*1.2,.3>]}
   //rotate x*90
   scale <1,2,1>
   }
}

#declare HR_01 = .6
#declare HS_01 = 3
#declare HD_01 = HS_01*pow((1-pow(HR_01,2)),2)

// hair:
#declare HAIR01=
difference{
   blob{ threshold HD_01

      cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <1.5/HR_01,1.2/HR_01,.85/HR_01> translate y*.45}
      cylinder{<-.5,0,0><0,0,0>,1,HS_01*.8 scale <1.1/HR_01,1/HR_01,.6/HR_01> translate <-.3,.45,0>}

      cylinder{<.9,0,0><-.9,0,0>,1,HS_01 scale <.7/HR_01,1.3/HR_01,.8/HR_01> translate y*.3}
      sphere{0,1,HS_01 scale <1.2/HR_01,1.1/HR_01,1.1/HR_01> translate <.8,-.3,0>}
      cylinder{<-5,0,0><0,0,0>,1,-2 scale <1,.5/HR_01,.9/HR_01> rotate z*0 translate y*.4}
      cylinder{<-5,0,0><0,0,0>,1,-2 scale <1,.8/HR_01,.8/HR_01>}

      cylinder{<0,0,1><0,0,-1>,1,-1.5 scale <.4/HR_01,.5/HR_01,1/HR_01>
         // rotate x*-10
         translate<.3,-.54,0>}
         scale <1,1.1,1>
   }
   #declare HR_01 = .65
   #declare HS_01 = 3
   #declare HD_01 = HS_01*pow((1-pow(HR_01,2)),2)

   // head (cranium, temple, cheek) is subtracted
   blob{ threshold HD_01
      //head:
      //part 01
      cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <1.5/HR_01,1.2/HR_01,.85/HR_01> translate y*.45}
      cylinder{<.9,0,0><-.9,0,0>,1,HS_01 scale <.7/HR_01,1.3/HR_01,.8/HR_01> translate y*.3}
      sphere{0,1,HS_01 scale <1.2/HR_01,1.1/HR_01,1.1/HR_01> translate <.8,-.3,0>}
      //part 02
      cylinder{<0,0,.5><0,0,-.5>,1,HS_01  scale <.55/HR_01,.75/HR_01,.7/HR_01>
         rotate z*30 translate <-.75,-.3,0>}
      //part 03
      cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <.75/HR_01,.5/HR_01,.68/HR_01>
         translate <-.9,-.95,0>}
      cylinder{<0,0,.5><0,0,-.5>,1,HS_01 scale <.5/HR_01,.5/HR_01,.67/HR_01>
         translate <-.5,-1.5,0>}
      sphere{0,1,HS_01 scale <.4/HR_01,.5/HR_01,.65/HR_01> translate <-1.2,-1.6,0>}
   scale 1.001
   }

texture {HAIR_TEX01}
}

//head= all the above together + ears

#declare HEAD02m=
union{
   object{HEAD01}

   object{L_EYE}
   object{R_EYE}

   sphere{0,1 scale <.4,.4,.42>*.85
   rotate <0,-15,0> translate<-1.2,-.33,-.6>}
   sphere{0,1 scale <.4,.4,.42>*.85
   rotate <0,15,0> translate<-1.2,-.33,.6>}
//ears:
   blob{ threshold HD_01
//left:
   sphere{0,1,HS_01
      scale <.2/HR_01,.65/HR_01,.4/HR_01>
      rotate <-14,-60,-5>
      translate<0.2,-.54,-1.5>}
   sphere{0,1,-4
      scale <.5/HR_01,.62/HR_01,.35/HR_01>*.6
      rotate <-14,-60,-8>
      translate<0.1,-.45,-1.7>}
//right:
   sphere{0,1,HS_01
      scale <.2/HR_01,.65/HR_01,.4/HR_01>
      rotate <14,60,-5>
      translate<0.2,-.54,1.5>}
   sphere{0,1,-4
      scale <.5/HR_01,.62/HR_01,.35/HR_01>*.6
      rotate <14,60,-8>
      translate<0.1,-.45,1.7>}

   cylinder{<0,0,1><0,0,-1>,1,HS_01
      scale <.2/HR_01,.25/HR_01,.65/HR_01>
      translate<0,-.54,0>}
   scale<.95,.95,1>}
object{HAIR01}
texture {SK_TEX}
}

//object{HEAD02m}
