
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: Chest of drawers, (c) N.B. 1993
//       The real object was designed and manufactured by the author in 1993 for an exibition
// Date: 09.08.1997
// Auth: N.B.

#include "metals.inc"

#declare TEXb=
texture{
   finish { ambient <.65,.6,.65>*.3 diffuse 0.8 phong .5 phong_size 100
   reflection .1}
   pigment{
     wood
     turbulence 0.12
     octaves 3
     color_map{[0.0 color rgbt <.3,.2,.1,.45>][1.0 color rgbt<.65,.6,.65,1>*.7]}
     rotate <0,90,87>
     scale <20,15,20>*1.5
     translate z*400
   }
}

#declare TEXa=
texture{
   finish { ambient <.5,.4,.3>*.2 diffuse 0.8 phong .5 phong_size 100
   reflection .05}
//   normal {wrinkles .5 scale <10,20,10>}
   pigment{color rgb <.5,.4,.3>}
}

#declare TEX00=
  texture{TEXa}
  texture{TEXb}

#declare TEX1b=
 texture{
   finish { ambient <1,.78,.6>*.2 diffuse 0.8 phong .5 phong_size 100
   reflection .05}
   pigment{
     wood
     turbulence 0.25
     octaves 3
     color_map{[0.0 color rgbt <1,.78,.6,.3>][1.0 color rgbt<1,.96,.90,.7>]}
     rotate <0,83,105>
     scale <25,15,10>
     translate z*100
   }
 }
#declare TEX1a=
 texture{
   finish { ambient <1,.9,.7>*.3 diffuse 0.8 phong .5 phong_size 100
   reflection .07}
   normal{ bumps 0.1 scale 5}
   pigment{
     wood
     turbulence 0.15
     octaves 3
     color_map{[0.0 color rgb <1,.9,.7>*.8][1.0 color rgb<1,.9,.8>]}
     rotate <0,93,105>
     scale <5,10,5>
     translate z*100
   }
 }
 #declare TEX1=
  texture{TEX1a}
  texture{TEX1b}

#declare TEX2=
texture{
   finish { ambient <1,.9,.8>*.2 diffuse 0.8 phong .6 phong_size 50
   reflection .05}
   normal {wrinkles .1 scale <10,20,10>}
   pigment{color rgb <1,.9,.8>}
}

/*
background {color rgb <.9,.95,1>}

camera{
// location <0,-100,-100>
location <-50,40,-60>*80
// location <0,0,-150>
   angle 15
   look_at <0,500,0>
}

light_source{ <-500,500,-500>*10
   color rgb <1,1,1>
}
*/

#declare lLEV01=262
#declare lPAK01=18+19
#declare lPAK02=15.5
#declare lPAK03=15
#declare lKOR01=141
#declare lKAN01=52/2
#declare lPYo01=461
#declare lSYV01=291-lPAK01

#declare lPAK0k=5
#declare lPAK0p=5
#declare lKOR0k=20
#declare lKOR1k=40

#declare lVED01=33/2
#declare lVED02=lVED01+10
#declare lVED03=15/2

//#declare lNRO01=4 //4=5; number of drawers, 5 in real life
#declare lVaL01=2
//#declare lAUK01=-1 //open a drawer; all closed=-1

#declare kPAK01=19
#declare kPAK02=12
#declare kPAK03=18
#declare kLEV01=lLEV01+lVaL01*2+kPAK03*2
#declare kKOR01=lKOR01*(lNRO01+1)+lVaL01*(lNRO01+2)+kPAK03*2
#declare kKAN01=62/2
#declare kPYo01=563
#declare kSYV01=320

#declare pRAD01= 40
#declare pRAD11= 10
#declare pRAD02= 5
#declare pRAD03= 2
#declare pRAD04= 12
#declare pPAK01= 10
#declare pPAK02= 2
#declare pPAK03= 12


#declare LAT01=
union{
difference{
  intersection{
     cylinder{<0,lKOR01/-1.9,0><0,lKOR01/1.9,0>lPYo01 translate z*lPYo01}
     box{<lLEV01/-2,lKOR01/-2,0><lLEV01/2,lKOR01/2,lPAK01>}
     }
  cylinder{<0,lKOR01/-1.8,0><0,lKOR01/1.8,0>lKAN01 translate z*(lPAK01-lPAK02-lKAN01)}
//texture{TEX1}
}

difference{
   box{<lLEV01/-2,lKOR01/-2,lPAK01><lLEV01/2,lKOR01/2,lSYV01>}
      box{<lLEV01/-2-lPAK0k,lKOR01/-2+lKOR1k,lPAK01>
          <lLEV01/-2+lPAK0k,lKOR01/-2+lKOR1k+lKOR0k,lSYV01*1.1>}
      box{<lLEV01/2-lPAK0k,lKOR01/-2+lKOR1k,lPAK01>
          <lLEV01/2+lPAK03+lPAK0k,lKOR01/-2+lKOR1k+lKOR0k,lSYV01*1.1>}

   box{<lLEV01/-2+lPAK03,lKOR01/-2+lPAK0p,lPAK01><lLEV01/2-lPAK03,lKOR01/1.9,lSYV01-lPAK03>}
texture{TEX2}
}

union{
   sphere{0,lVED01}
   cylinder{<0,0,0><0,0,lVED02>lVED03}
texture{T_Chrome_5E}
}
}

#declare LAT02=
union{
#while(lNRO01>=0)
   #if (lNRO01=lAUK01)
      object{LAT01 translate y*(lKOR01+lVaL01)*lNRO01 translate z*lSYV01/-2}
   #else
      object{LAT01 translate y*(lKOR01+lVaL01)*lNRO01}
   #end
   #declare lNRO01=lNRO01-1
#end
texture{TEX1}
}

#declare LAT03=
difference{
  intersection{
     cylinder{<0,kKOR01/-1.9,0><0,kKOR01/1.9,0>kPYo01 translate z*kPYo01}
     box{<kLEV01/-2,kKOR01/-2,0><kLEV01/2,kKOR01/2,kSYV01>}
     }
  cylinder{<0,kKOR01/-1.8,0><0,kKOR01/1.8,0>kKAN01 translate z*kPAK02*-1}
  box{<kLEV01/-2+kPAK03,kKOR01/-2+kPAK03,kPAK03*-1><kLEV01/2-kPAK03,kKOR01/2-kPAK03,kSYV01-kPAK03>}
  translate z*(kPAK03)
  translate y*(kKOR01)/2
texture{TEX00}
}
#declare LAT04=
union{
   object{LAT02 translate y*(kPAK03+lVaL01+lKOR01/2)}
   object{LAT03}
}

#declare LAT00=
union{
object{LAT04 translate y*(pRAD01+pRAD03/2+pRAD01*1.2+pPAK03)}

#declare pBRK01= 0
#include "latt02.inc"
object{PYo01 rotate y*5 translate <kLEV01/2*-.7,pRAD01,kSYV01/2+kSYV01/2*.7>}
object{PYo01 rotate y*3 translate <kLEV01/2*.7,pRAD01,kSYV01/2+kSYV01/2*.7>}
#declare pBRK01= 1
#include "latt02.inc"
object{PYo01 rotate y*30 translate <kLEV01/2*-.7,pRAD01,kSYV01/2+kSYV01/2*-.6>}
object{PYo01 rotate y*35 translate <kLEV01/2*.7,pRAD01,kSYV01/2+kSYV01/2*-.6>}
}

