
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: 2 objects: 1.computer + monitor, 2.mouse + wire + mouse pad
// Date: 7.08.1997
// Auth: N.B.


/*
background {color rgb <.9,.95,1>}

light_source{<90,140,-110>*2.1
   color rgb <1,1,1>
   spotlight
   point_at <50,90,-90>
   radius 30
   falloff 60
   tightness 3
}

camera{
//location <60,70,-120>
//location <150,0,0>
location <0,11,-150>
   angle 45
   look_at <0,11,0>
   //look_at <65,45,0>
}

#declare TEX =
texture{
   finish{
      diffuse .9
      ambient .2
      reflection .05
      phong .7
      phong_size 100
   }
   normal {bumps .05 }
   pigment{color rgb <.9,.95,1>}
}


#declare PC_TEX01 =
texture{
   finish{
      ambient <1,0.97,.92>*.3
      diffuse .7
      phong .8
      phong_size 20
   }
   pigment{color rgb <1,1,1>}
}

#declare LED_TEX01 =
texture{
   pigment{color rgb <1.7,2,.1>}
}

#declare LED_TEX02 =
texture{
   pigment{color rgb <.8,.8,.8>}
}

#declare LED_TEX03 =
texture{
   pigment{color rgb <2,1.7,.1>}
}
*/

#declare SCR_TEX01=
texture{
   finish{
      specular 1
      roughness 0.001
      ambient 0.5
      diffuse 0.9
      reflection 0.5
   }
   pigment{color rgb <.8,.9,1>*2.5}
}

//computer

#declare POMP01=
union{
   difference{
      intersection{
         cylinder{<0,20,0><0,-20,0>44*1.5 scale <1,1,1/1.5> rotate x*5}
         box{<-42/2,0,0><42/2,11,-47>}
      }
      box{<-42/2*1.1,-1,-42><42/2*1.1,2,-47>}
      box{<20,-1,-10><0,2,10> rotate y*30 translate <21,0,-40>}
      box{<-20,-1,-10><0,2,10> rotate y*-30 translate <-21,0,-40>}
      #declare NNNN=5
      #while (NNNN >= 0)
         box{<0,0,0><20,.4,-10> rotate y*20 translate <-19.5,0.8*NNNN,-40>
         translate y*3}
      #declare NNNN=NNNN-1
      #end

      box{<-10.5/2,10,0><10.5/2,7,2> translate <-2,0,-45>}
      box{<-3.6/2,9.6,0><3.6/2,7.4,2.5> translate <-2,0,-45>}
      box{<-9.5/2,10-.8,0><9.5/2,7+1.4,2.51> translate <-2,0,-45>}

      box{<0,.6,0><6.5,-.6,1> rotate y*12 translate <-20,9.5,-42>}
   }
   box{<0,0,1.5><1.1,.5,3> translate <.3,7.6,-45>}
   box{<0,0,1.9><-.8,.2,2> translate <-4.5,7.6,-45> texture{LED_TEX02}}

   cylinder{<0,0,0><3,0,0>.5 scale <1,1,.5> rotate y*12 translate <-19.9,9.5,-41>}
   box{<0,.1,-.3><.8,-.1,1> rotate y*12 translate <-15,9.5,-42>}
   box{<0,.1,.1><.8,-.1,1> rotate y*12 translate <-16.5,9.2,-42>
      texture{LED_TEX01}}
   box{<0,.1,.1><.8,-.1,1> rotate y*12 translate <-16.5,9.8,-42>
      texture{LED_TEX01}}
   box{<-1.5,3.5,2><1.5,5.5,.1> translate <-2,0,-44>}
   difference{
      box{<0,0,0><-15.5,9,5>}
      box{<-.2,8.8-4.5,.5><-(15.5-.2),8.8,-1>}
      cylinder {<0,0,1><0,0,-1>.3 translate <-13.5,4.8,0>}
   translate <20,1,-44>}
   cylinder{<-2.5/2,0,0><-1*(13+2.5/2),0,0>1 scale <1,1,.5> translate <20,7.5,-43.4>}
   cylinder{<0,0,0><-2,0,0>.3 scale <1,1,.6> translate <18.5,5.8,-43.5>}
   cylinder{<0,0,0><-2,0,0>.3 scale <1,1,.6> translate <16,5.8,-43.5>}
   cylinder{<0,-.2,0><0,.2,0>1 translate <8.2,5.8,-43>}
   box{<0,.1,-.1><.8,-.1,1> translate <9.7,5.8,-43.5> texture{LED_TEX03}}
texture{PC_TEX01}
// rotate y*-45
}

//monitor

#declare R01=37
#declare R02=40
#declare A021=14
#declare C01=60
#declare H01=20

#declare ALF01=asin((A021+R01)/(R02+R01))
#declare A01=R01*sin(ALF01)

#declare MON01=
difference{
   union{
      cylinder{<0,H01*-1,0><0,H01,0>R01}
      box{<0,H01*-1,A01*-1><C01*-1,H01,A01>}
   }
   union{
      cylinder{<0,H01*-1.1,0><0,H01*1.1,0>R02 translate x*(R01+R02)*-1}
      box{<0,H01*-1.1,R02*-1><C01*-1,H01*1.1,R02> rotate y*(degrees(ALF01)) translate x*(R01+R02)*-1}
      rotate y*(degrees(ALF01))*-1
   }
   union{
      cylinder{<0,H01*-1.1,0><0,H01*1.1,0>R02 translate x*(R01+R02)*-1}
      box{<0,H01*-1.1,R02*-1><C01*-1,H01*1.1,R02> rotate y*(degrees(ALF01))*-1 translate x*(R01+R02)*-1}
      rotate y*(degrees(ALF01))
   }
scale <1,1,.5>
}

#declare R01=37
#declare R02=40
#declare A021=20
//#declare C01=40
#declare H01=20
#declare MON_RA01 = .65
#declare MON_ST01 = 3
#declare MON_DN01 = MON_ST01*pow((1-pow(MON_RA01,2)),2)
#declare SECT01 = 8
#declare ANGL01 = 360/SECT01
#declare ANGL00 = 0

#declare MON02=
difference{
   blob{ threshold MON_DN01
      sphere{0,1,MON_ST01 scale R01/MON_RA01}
      cylinder{<0,0,0><C01*-1,0,0>1,MON_ST01  scale <1/MON_RA01,A021/MON_RA01,A021/MON_RA01>}
      }
      #declare MMMM=12
      #declare LLLL=(MMMM+1)*-1
      #declare HD01=.5
      #while (MMMM>LLLL)
         box{<C01*-2,HD01/-2,A021*-2><C01*-.3,HD01/2,A021*2> rotate z*MMMM*-3 translate y*MMMM*.5}
      #declare MMMM=MMMM-1
      #end
scale <1,1,.5>
rotate x*-90
}

#declare MON03=
difference{
   box{<0,R01*-1.1,R01*-1.1><R01*2,R01*1.1,R01*1.1>}
   cylinder{<0,R01*-1.2,0><0,R01*1.2,0>R01*1.1 scale <.3,1,1>}
}

#declare MON04=
difference{
   box{<0,R01*-1.1,R01*-1.1><R01*2,R01*-.7,R01*1.1>}
   cylinder{<0,R01*-1.2,0><0,R01*-.5,0>R01*1.1 scale <.3,1,1> translate <-4,0,0>}
   cylinder{<0,R01*-1.2,0><0,R01*-.5,0>12 scale <.48,1,1> rotate y*-5 translate <2,0,30>}
   cylinder{<0,R01*-1.2,0><0,R01*-.5,0>12 scale <.48,1,1> rotate y*5 translate <2,0,-30>}
   scale <.5,.5,.5>
}


#declare MON05=
union{
difference{
   intersection{
      object{MON01}
      object{MON02}
   }
   object{MON03 translate x*-5}
   object{MON03 rotate y*180 translate x*-30}
   object{MON04 translate x*2.7}
   union{
       box{<-10,21/-2,28/-2><10,21/2,28/2> scale<1,.99999999,1> translate <0,3,0>}
       difference{
          box{<0,21/-2,(28/2+5)*-1><10,21/2,28/2+5>}
          cylinder{<0,-21/2,0><0,21/2,0>5 scale <.4,1.1,1> translate z*(28/2+5)*-1}
          cylinder{<0,-21/2,0><0,21/2,0>5 scale <.4,1.1,1> translate z*(28/2+5)}
       translate <5,3,0>}
       }
   cylinder{<0,0,0><-20,0,0>.6 translate <2,12,-18.6>}
   cylinder{<0,0,0><-20,0,0>.6 translate <2,-12,-18.6>}
   cylinder{<0,0,0><-20,0,0>.6 translate <2,12,18.6>}
   cylinder{<0,0,0><-20,0,0>.6 translate <2,-12,18.6>}
   }
   box{<0,9,18><-40,-9,-18>}
   box{<0,0,17><-38,-16,-17>}
   difference{
      union{
      #declare KKKK=9
         #while (KKKK>=0)
            cylinder{<0,0,0><10,0,0>.25 translate z*KKKK*1.5 translate <0,-15,-9>}
         #declare KKKK=KKKK-1
         #end
      }
      object{MON04 translate x*3.2}
   }
   cylinder{<0,0,0><6.8,0,0>.6 translate z*KKKK*1.5 translate <0,-13.3,8>}
   cylinder{<0,0,0><6.8,0,0>.6 translate z*KKKK*1.5 translate <0,-13.3,10>}
   cylinder{<0,-.6,0><0,.6,0>1 scale<.2,1,1> rotate y*-5 translate <6.8,-11.5,12>}
   box{<-2,0,-.35><.1,.2,.35> rotate y*-5 translate <6.8,-11.5-.6,10> texture{LED_TEX01}}
   texture{PC_TEX01}

}
#declare MON06=
intersection{
   cylinder{<0,R01*-1.3,0><0,R01*1.3,0>R01*1.2 scale <.3,1,1> translate <-7.5,0,0>}
   box{<-10,21/-2,28/-2><10,21/2,28/2> translate y*3}
texture{SCR_TEX01
         pigment{
            image_map {
               gif "screen.gif"
               once
            }
            rotate y*-90 translate <0,-.5,-.5> scale <1,60,80>*.33 translate <0,3,0>
         }
      }
}

#declare MON00=
union{
   union{
      object{MON05}
      object{MON06}
   rotate z*5 rotate y*15 translate <10,25,0>}
   cylinder{<0,0,0><0,1,0>12.5}
   cone{<0,1,0>12.5<0,2,0>6}
   cylinder{<0,0,0><0,4,0>6}
   sphere{0,10 translate y*12}
   texture{PC_TEX01}
}

// computer + monitor

#declare POMP00=
union{
   object{MON00 rotate y*90 translate <0,11,-20>}
   object{POMP01}
}

// object{POMP00}

#declare MOUSE_PAD_TEX =
texture{
   finish{
      diffuse .3
      ambient <0.7,0.82,.99>*.3
      phong .5
      phong_size 10
   }
   normal {bumps .05 scale 50}
   pigment{color rgb <0.7,0.82,.99>*.9}
}

#declare T_Length = 50
#declare Height = 10
#declare Thickness = .3
#declare R_Height = (Height-2*Thickness)
#declare NoWaves = 2
#declare NoSegments = 100
#declare SAngle = pi/2.5
#declare B0 = (T_Length/(NoWaves*NoSegments))
#declare Angle = ((2*pi)/NoSegments)
#declare X1 = 0
#declare Y0 = (R_Height*sin(SAngle))
#declare Y1 = 0
#declare Z1 = 0
#declare WCOUNT = NoSegments*NoWaves
#declare WAM001 = .99
#declare W_RAND = seed(3453)

//wire
#declare WIRE01=
blob{threshold 0.6
     #while (WCOUNT>=1)
     #declare X2 = (X1 + B0)
     #declare SAngle = (SAngle + Angle)
     #declare R_Height = R_Height*WAM001
     #declare Y2 = (R_Height*sin(SAngle))-Y0
     //#declare Z2 = rand(W_RAND)/10
     #declare Z2 = 0
     cylinder {<X1,Y1,Z1>,<X2,Y2,Z2>,Thickness,4}
     sphere {<X2,Y2,Z2>,Thickness,-4}
     #declare X1 = X2
     #declare Y1 = Y2
     #declare Z1 = Z2
     #declare WCOUNT=WCOUNT-1
     #end
}

//mouse

#declare MOUSE01=
union{
   difference{
      intersection{
         sphere{0,1 scale <3,5,7>}
         sphere{0,1 scale <5,5,7.5> rotate x*3 translate y*-1.8}
         cylinder{<0,-5,0><0,6,0>10 translate z*-6 rotate x*-5}
      }
      // box{<-5,-5,4><5,5,8> rotate x*-5}
      box{<-5,-10,-8><5,0,8> rotate x*-5}
      box{<-5,0,-.05><5,3,.005> translate <0,1.5,.5>}
      box{<-5,0,-.05><5,3,.005> rotate x*90 translate <0,1.5,.5>}
      box{<-.05,0,0><.05,3,5> translate <0,1.5,.5>}
      sphere{0,1 scale <1,.5,4> rotate x*15 rotate z*5 translate <-1.5,2.5,4>}
   rotate x*5
   }
object{WIRE01  rotate x*90 rotate y*-90 translate <0,.5,4>}
texture{PC_TEX01}
}

//mouse pad

#declare MOUSE02=
difference{
   superellipsoid{<.2,.2> scale <11,11,13>}
   box{<-15,0,-15><15,-15,15>}
   box{<-15,.5,-15><15,15,15>}
texture{MOUSE_PAD_TEX}
}

//mouse + wire + mouse pad

#declare MOUSE00=
union{
   object{MOUSE01 rotate y*12 translate y*.5}
   object{MOUSE02 rotate y*-6 }
}

//object{MOUSE00}
