
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: Computer Desk (c) N.B. 1997
// Date: 26.08.1997
// Auth: N.B.


#declare PAP_TEX =
texture{
   finish{
      diffuse .9
      ambient .3
      phong .6
      phong_size 10
   }
   normal {bumps .5 scale 2}
   pigment{color rgb <1,1,1>}
}

#declare TAB_INS =
    texture {
       finish{
          ambient <1,.9,.8>*.2
          phong .9
          phong_size 80}
       pigment{ color rgb <1,1/1.3,1/1.7>}
       }

#declare MBEECHA =
color_map {
    [0.00 color rgb <1,1/1.45,1/2.7>]
    [0.4 color rgb <1,1/1.3,1/1.7> ]
    [0.6 color rgb <1,1/1.3,1/1.7> ]
    [1.00 color rgb <1,1/1.45,1/2.7>]
}
#declare MBEECHB =
color_map {
    [0.00 0.50 color rgbt <.9,.9/2,.9/4,.6>*.95
               color rgbt <1,1/1.3,1/1.7,.7> ]
    [0.50 1.00 color Clear color Clear]
}

#declare P_BEECH_GRAINA =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.075
    omega 0.45
    lambda 2.3
    color_map { MBEECHA }
    rotate x*4
}
#declare P_BEECH_GRAINB =
pigment {
    bozo
    color_map { MBEECHB }
    scale <0.005, 0.005, 0.9>*.7
}

#declare TBEECH =
    texture {
       finish{
          diffuse .7
          ambient <1,.8,.6>*.2
          phong .5
          phong_size 100
          reflection .05}
       pigment{ P_BEECH_GRAINA color_map { MBEECHA }}}
    texture {
       finish{
          diffuse .7
          ambient <1,.85,.7>*.2
          phong .5
          phong_size 100
          reflection .05}
       // normal{bozo 0.5 scale <0.013, 0.013, 0.75>}
       pigment{ P_BEECH_GRAINB color_map { MBEECHB }}}

#declare T_HI01=90
#declare T_HI02=20
#declare T_WI01=17
#declare T_TH01=1.6
#declare T_WI02=T_WI01-T_TH01

#declare T_HI03=((T_HI02-T_TH01-.2)*2-.4)/3
#declare T_WI03=T_WI01-T_TH01-.2

#declare MTAB01=
prism {
  linear_sweep
  cubic_spline
   0,0.02,6,
   <.5,1>,<0,0>,<.15,-1.5>,<1,-.15>,<0,0>,<1,-.5>
   texture{TBEECH scale .9 rotate x*15}
   scale 100
   translate y*T_HI01
}

#declare MTAB02=
union{
   cylinder{<0,0,0><0,T_HI01,0>2 translate <10,0,-10>}
   cylinder{<0,0,0><0,1,0>3 translate <10,0,-10>}

   cylinder{<0,0,0><0,T_HI01,0>2 translate <82,0,-12>}
   cylinder{<0,0,0><0,1,0>3 translate <82,0,-12>}

   cylinder{<0,T_HI01/2+T_HI02,0><0,T_HI01,0>4 translate <20,0,-110>}
   cylinder{<0,T_HI01/2+T_HI02,0><0,T_HI01/2+T_HI02+1,0>5 translate <20,0,-110>}
   cylinder{<0,0,0><0,T_HI02,0>4 translate <20,0,-110>}
   cylinder{<0,0,0><0,1,0>20 translate <20,0,-110>}
   cone{<0,1,0>20<0,3,0>0 translate <20,0,-110>}
texture{T_Chrome_4D}
}

#declare MTAB03=
union{
   cylinder{<0,T_HI01,0><7,T_HI01-15,0>1 translate <70,0,-80>}
   cylinder{<0,T_HI01,0><7,T_HI01-15,0>1 translate <70,0,-60>}
   sphere{<7,T_HI01-15,0>1 translate <70,0,-80>}
   sphere{<7,T_HI01-15,0>1 translate <70,0,-60>}
   cylinder{<7,T_HI01-15,0><25,T_HI01-15,0>1 translate <70,0,-80>}
   cylinder{<7,T_HI01-15,0><25,T_HI01-15,0>1 translate <70,0,-60>}
   cylinder{<25,T_HI01-15,-25><25,T_HI01-15,25>1.5 translate <70,0,-70>}
texture{T_Chrome_4D}}

#declare MBOX01=
difference{
   box{<-1*T_WI01,T_HI02,T_WI01><T_WI01,T_HI02*-1,-1*T_WI01>}
   box{<-1*T_WI02,20-T_TH01,T_WI02><20,-20+T_TH01,-1*T_WI02> texture {TAB_INS}}
   translate <20,T_HI01/2,-110>
texture{TBEECH scale .9 rotate <25,15,0> scale <100,150,100>}}

#declare MBOX12=
union{
   difference{
      box{<-1*T_WI03,T_HI03/2,T_WI03><T_WI01,T_HI03/-2,-1*T_WI03>}
      box{<-1*T_WI03+T_TH01,T_HI03/2,T_WI03-T_TH01><T_WI01-T_TH01,T_HI03/-2,-1*T_WI03+T_TH01>
         translate y*.5 texture {TAB_INS}}
      }
   cylinder{<T_WI01,0,0><T_WI01+3,0,0>.5 texture{T_Chrome_4D}}
   cylinder{<T_WI01,0,0><T_WI01+.5,0,0>1 texture{T_Chrome_4D}}
   translate <20,T_HI01/2,-110>}

#declare MBOX02=
union{
   object {MBOX12}
   object {MBOX12 translate <5,T_HI03+.2,0>}
   object {MBOX12 translate <8,(T_HI03+.2)*-1,0>}
   box{<21/-2*.71,(T_HI03/-2+2.5),29.7/-2*.71><21/2*.71,T_HI03/-2,29.7/2*.71>
      translate y*.5
      translate <20,T_HI01/2,-110>
      translate <8,(T_HI03+.2)*-1,0>
      texture{PAP_TEX}
   }
texture{TBEECH scale .9  rotate x*15 rotate z*-90 rotate x*5 scale 100}}

#declare M_TABLE=
union{
   object {MBOX01}
   object {MBOX02}
   object {MTAB01}
   object {MTAB02}
   object {MTAB03}
}

//box{<-1000,0,1000><1000,-10,-1000> texture{TEX}}
//object{M_TABLE}
