
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: Pants
// Date: 26.08.1997
// Auth: N.B.

// #declare SIDE = 1 // 1=left, -1=right, don't even try other values

#declare SH_TEX =
texture{
   finish{
      diffuse .8
      brilliance 0.4
      ambient .3
      phong 0.01
      phong_size 2
   }
   normal{bumps .3 scale <.5,.5,1>}
   pigment{color rgbt <1,1,1>}
   //pigment{color rgbt <.3,.4,1>}
   //pigment{color rgbt <.1,.1,.15>}
}

#declare HR_02 = .6
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11.2
// #declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 11

//#declare ZCENT = 3.05

#declare ZARM01 = -1.4
#declare YARM01 = 11.05
#declare XARM01 = 0
// #declare AAX_01 = 2
// #declare AAZ_01 = 5
#declare AB_01 = 7
#declare AB_02 = 6
// #declare AAZ_02 = 20
// #declare AAY_02 = 15

// #declare LJZ_01 = -30
// #declare LJZ_02 = 40
// #declare LJZ_03 = 20


#declare SHORT01=
difference{
blob{ threshold HD_02
//leg
   cylinder{<0,0,0><0,LB_01*-1,0>,1,HS_02
      scale <1.3/HR_02,1,1.2/HR_02>
      rotate x*(LAX_01*SIDE)*-1
      rotate y*0*SIDE
      rotate z*LAZ_01
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   cylinder{<0,0,0><0,LB_02*-1,0>,1.1,HS_02
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.1/HR_02,1.7/HR_02,1.1/HR_02>*1.05
      rotate <5*SIDE,0*SIDE,15>
   rotate z*LJZ_02
      translate x*-.5
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.7*1.2/HR_02,5.2/HR_02,1.7*1.2/HR_02>
      rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
      translate <-0.4,LB_01/-2.3,.9*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.7/HR_02,4.5/HR_02,1.7/HR_02>*1.05
      rotate <0*SIDE,0*SIDE,-5>
      translate <0,LB_01/-2,1.3*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}



//*
   sphere{0,1,HS_02
      scale <1.5/HR_02,2.0/HR_02,1.9/HR_02>*1.05*1.05
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,0,1.3*SIDE>
   rotate z*LJZ_01/2
   }

   sphere{0,1,HS_02
      scale <.9/HR_02,1.1/HR_02,1/HR_02>*1.05
      translate y*-1
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,0,1.3*SIDE>
   rotate z*LJZ_01/1.4
   }
//*

cylinder{<0,0,0><0,LB_01,0>,1,HS_02
     translate z*ZCENT
     rotate z*-5
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.3/HR_02,2.6/HR_02,1.5/HR_02>*.95*1.05
     translate <-.5,.6,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.8/HR_02,1.4/HR_02>*.95*1.05
     translate <-.8,.1,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}
//
sphere{0,1,HS_02
     scale <2.4/HR_02,2.5/HR_02,3/HR_02>*1.05
     translate <-.28,1.4,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.2/HR_02,2/HR_02>*1.05
     translate <-1.2,-2.0,ZCENT>
     rotate z*-10}


cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.3/HR_02,1,2.65/HR_02>*1.05
     translate <-.7,2,ZCENT>
     rotate z*-5
     rotate z*BOW_ANG}

sturm
translate y*10
translate z*ZCENT*-1
}
box{<-10,30,5*SIDE><10,-10,0.0000001*SIDE>}
box{<-10,0,-10><10,-20,10>
   rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
   translate <-0.4,LB_01/-1.5,0.8*SIDE>
   rotate z*LJZ_01
   translate y*10}
box{<-10,0,-10><10,15,10> rotate z*BOW_ANG translate y*2+10}
texture{SH_TEX}
}

