#include "colors.inc"
#include "golds.inc"
#include "nrthpole.inc" //A couple of textures
#include "curtain.inc"
#include "icicles.inc"
#include "antlers.inc"

global_settings{assumed_gamma 2.2}
camera { location  <-3.0 , 2.0 ,-28.0> look_at <0,0,0>}

light_source{ 0 color rgb <.95,.95,1> *.5 translate <-35, 400, -200> }
light_source{ 0 color <.918,.918,.6>*.65 translate <-12, 4, 14> rotate y*55 translate <-20, -5, -12> }
light_source{ 0 color rgb <10,0,0> spotlight translate <5, 0, 7> point_at <5, -5, 7> radius 10 tightness 20 falloff 90}
light_source{ 0 color rgb <1,0,0> spotlight translate <5, 0, 7> point_at <11, 1, -5> radius 10 tightness 20 falloff 90}

sky_sphere {pigment { gradient y
                      pigment_map {[0.35 color rgbf<0.184314,0.184314,0.309804, 0.5>] [0.50 Clear]}}}

#declare background1 = height_field
{tga "mount2.tga" smooth texture {snow_tex} scale <570, 135, 105> translate <-130, -30, 140>}

#declare foreground = height_field
{tga "terrain1.tga" smooth texture {snow_tex} scale <170, 10, 150> rotate y*270 translate <80, -9, -100> }

#declare atmos = sphere{0, 140 texture {pigment {color rgbt <.5, .5, 1, 0.9>}} finish {ambient 1.0} no_shadow hollow}

#declare pole = union {
   cylinder {0, <0, 10, 0>, .5 rotate y*-20 translate <11, -7, -5>
             texture {pigment { gradient x+y
                                color_map { [0.00, 0.25 color Red*2   color Red*2]
                                            [0.25, 0.75 color White*4 color White*4]
                                            [0.75, 1.00 color Red *2  color Red*2]}}
             scale 2.5 translate y*10}
   }
   sphere {0, 1.05 texture {T_Gold_4B} translate <11, 3, -5>}
   torus {.75, .15 texture {T_Gold_4B} translate <11, 2.1, -5>}
}

#declare shudder = difference{
   box {<1.1, 5, 15>, <1.35, 10, 12>}
   box {<1.25, 5.5, 14.5>, <2, 9.5, 12.5>}
   texture {pigment {color Green*.5}}
}

#declare S1 = seed(345) //setup seed value for shingles
#declare wall = union {
   #declare w_width = 26
   #declare c_rows = 0
   #while (c_rows < 15)
       #declare c_width = 0
       #while (c_width < w_width)
         #declare scale_factor = rand(S1)*3 + 3
         #if (c_width + scale_factor > w_width) #declare scale_factor = w_width - c_width #end
         object{#include "shingle.inc" rotate x*5 translate <c_width+0.1, c_rows-0.3, -1.2>}
         #declare c_width = c_width + scale_factor +0.1
      #end
      #declare c_rows = c_rows + 2
   #end
   box {0, <26, 15, -1> texture {pigment {Black}}}
}

#declare workshed = union {
   difference {
      object {wall rotate y*-90}
      box {<-0.5, 5, 15>, <1.5, 10, 20>}
      bounded_by{box{-0.5, <2, 16, 27>}}
   }
   box {<0, 0, 25>, <-21, 15, 26>}
   box {0, <-21, 15, 1>}
   box {<-20, 0, 0>, <-21, 15, 26>}
   box {<0, 15, 0>, <-21, 14.5, 26>}
   intersection {
      union { box {<1, 0, -.5>, <-10, 4, 27>} cylinder {<1, 2, -.5>, <1, 2, 27>, 2} }
      height_field {tga "terrain1.tga" smooth scale<-50, 4, 70> translate <10, 0, -30>}
      rotate -25*z translate <-0.25, 16.25, 1>
      texture {pigment {color White*1.5} finish {reflection 0.15 crand 0.05 ambient 0.38}}
   }
   box {<1.5, 0.25, -.5>, <-10, 1, 27> rotate -25*z translate y*15 pigment {color Black}}
   box {<.5, 5, 15>, <0.75, 10, 20> texture {WindowGlass scale <5, 10, 1> rotate y*90 translate -5.1*y}}
   object {curtain pigment {color rgbf <1, 0, 0, 0.55>} normal{bumps 0.15 scale 0.05} finish {crand 0.07}
           scale <3, 10, 3> rotate y*90 translate <-2, -8, 17>}
   object {shudder}
   object {shudder translate z*7.5}
   object {icicles scale 0.75 rotate y*-90 translate <1.25, 15, 24>}
   texture {pigment {color rgb <.9, .9, .8>} finish {ambient .25}}
   rotate y*55 translate <-20, -5, -12>
}

#declare nose = difference {
   sphere { 0, 1 pigment { color rgbt <1, 1, 1, 1> }
   halo{ emitting spherical_mapping linear
         colour_map
         { [ 0 color rgbt <1, 0, 0, 1> ]
           [ 1 color rgbt <1, 0, 0, 0.5> ]}
         samples 10
   }
   hollow scale 5 translate <-2, 5, 27> rotate y*55 translate <-20, -5, -12>
   }
   box{<-6, -6, 0>, <6, 6, -6>}
}

#declare n_lights =
   sphere { 0, 1 pigment { color rgbt <1, 1, 1, 1> }
            halo{ emitting spherical_mapping linear turbulence .5
                  colour_map { [ 0 color rgbt <0, 1, 0, 1> ]
                               [ 1 color rgbt <.85, 1, .15, 0.5> ]}
                  samples 10
                  scale 0.75}
   hollow scale <205, 115, 15> translate <0, 20, 227>
   }

object {foreground}
object {background1}
object {atmos}
object {n_lights}
object {pole}
object {workshed}
object {nose}
object {antlers scale 1.5 translate <-2, 9, 28.5> rotate <0, 55, -5> translate <-20, -5, -12>}
#declare flares = 1
#declare stars = 1

//Add some finishing touches to the sky. Flags are found with the object declarations.
//The code is found at the bottom because its pretty fixed and this helps keep it
//out of the way.
#if (stars)
   #declare spaceType=3
   #declare multicolor=0
   #include "starfield.inc"
#end

#if (flares)
   #declare camera_location = <-3, 2, -28>
   #declare camera_look_at = 0
   #declare effect_location = <240, 160, 500>
   #declare effect_scale = 0.35
   #declare effect_type = "Star2" #include "LENS.INC"
   #declare effect_type = "Star"
   #declare options_only = true #include "Lens.inc"
   #declare effect_always_on_top = false
   #declare effect_location = <130, 70, 500> #declare effect_scale = 0.1 #include "LnsEfcts.inc"
   #declare effect_location = <350, 180, 500> #declare effect_scale = 0.15 #include "LnsEfcts.inc"
#end
