#declare R1 = seed(1701)		    //Any number
#declare R2 = seed(2000)        //Any number
#declare C1 = seed(1001)
#declare C2 = seed(543)
#declare C3 = seed(782)
#declare R3 = seed(123)
#ifndef (MaxDist) #declare MaxDist = 90000 #end
#ifndef (MinDist) #declare MinDist = 90000 #end
#ifndef (starnum) #declare starnum = 2000 #end
#ifndef (spaceType) #declare spaceType=3 #end
#ifndef (multicolor) #declare multicolor=1 #end

#declare Count=0
#while (Count < starnum)

  #switch (spaceType)
    #case (1) // Full scope: Stars everywhere (requires more stars)
        #declare theta = radians(rand(R1)*360)
        #declare phi = radians(rand(R2)*180)
    #break
    #case (2) // Half scope: Stars only in the upper half.
        #declare theta = radians(rand(R1)*360)
        #declare phi = radians(rand(R2)*90)
    #break
    #case (3) // Front Half scope: Stars in the front half of space
              // (requires less stars; typically only for stills)
        #declare theta = radians(rand(R1)*180)
        #declare phi = radians(rand(R2)*180)
    #break
    #case (4) // Quarter scope: Stars only in one quarter of space
              // (requires least stars; typically only for stills)
        #declare theta = radians(rand(R1)*180)
        #declare phi = radians(rand(R2)*90)
    #break
  #end
  #declare Dist = MinDist + rand(R3)*(MaxDist-MinDist)
  #declare Tmpz= sin(phi)*sin(theta)*Dist
  #declare Tmpx= sin(phi)*cos(theta)*Dist
  #declare Tmpy= cos(phi)*Dist
  //#warning concat(str(radians(phi),0,0)," : ", str(cos(radians(phi)), 0,0), "\n")
  #declare Bcol = rand(C1)
  #if (Bcol < 0.5) #declare Bcol = Bcol +0.5 #end
  #declare Rcol = rand(C2)
  #if (Rcol < 0.5) #declare Rcol = Rcol +0.5 #end
  #declare Gcol = rand(C3)
  #if (Gcol < 0.5) #declare Gcol = Gcol +0.5 #end

  disc
  //sphere
  {
    <0, 0, 0>,
    z, //disc only
    0.2 + 0.15*(Rcol)
	scale 550 // Scale to what ever you want
    translate <Tmpx, Tmpy, Tmpz>
    #if (multicolor)
	pigment { onion color_map{[0
		#declare Decide = rand(R3)
		#if (Decide < 0.25) color rgb <Rcol, Gcol, Bcol>*1.75
		#else color rgb <1.75,1.75,1.75>*(1-(1-Decide))
		#end
        ] [1 rgb 0]} scallop_wave
    }
    #else
    pigment { onion color_map{[0 rgb 1] [1 rgb 0]} scallop_wave }
    #end
    finish{ambient 1.0 diffuse 0.0}
  }

  #declare Count=Count+1
#end

// End
