//Android model file - 7/8/96 - PConophy

//Android is:
// 152 units tall
// 56 units wide
// 18 units deep
// stands on the xz plane, centered on the origin


#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "textures.inc"

//*******************************************************************************
//*	Left Arm
//*******************************************************************************

////////////////////////////////////////////
#declare LFingers =
merge {

	/////////////////////////////////////////////
	// Name: LFingerJoint
	cylinder { < 0, 0, -4 >, < 0, 0, 4 >, 0.5 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LFingerTips
	box { < -0.5, -5, -4 >, < 0.5, 0, 4 > }
	/////////////////////////////////////////////

	rotate <
		0,	//no change
		0,	//no change
		0	//-(0 - 90), close fingers
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LKnuckles =
merge {

	/////////////////////////////////////////////
	// Name: LKnuckleJoint
	cylinder { < 0, 0, -4 >, < 0, 0, 4 >, 1 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LTopFingers
	box { < -0.5, -5, -4 >, < 0.5, 0, 4 > }
	/////////////////////////////////////////////

	object {
		LFingers
		translate <
			0,
			-5,	//length of LTopFingers
			0
		>
	}

	rotate <
		0,	//no change
		0,	//no change
		-90	//-(0 - 90), close knuckles
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LHand =
merge {

	/////////////////////////////////////////////
	// Name: LWrist
	sphere { < 0, 0, 0 >, 3 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LPalm
	box { < -1, -8, -4 >, < 1, 0, 4 > }
	/////////////////////////////////////////////

	object {
		LKnuckles
		translate <
			0,
			-8,	//length of LPalm
			0
		>
	}

	rotate <
		0,	//15 - (-20), bend forward/back
		0,	//no change
		45	//45 - (-90), bend sideways
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LForeArm =
merge {

	/////////////////////////////////////////////
	// Name: LElbow
	sphere { < 0, 0, 0 >, 4 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LFArm
	cylinder { < 0, -24, 0 >, < 0, 0, 0 >, 3 }
	/////////////////////////////////////////////

	object {
		LHand
		translate <
			0,
			-24,	//length of LFArm
			0
		>
	}

	rotate 135*y	//-90 - 90, rotate
	rotate -90*x	//0 - 160, bend forward

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LUpperArm =
merge {

	/////////////////////////////////////////////
	// Name: LShoulder
	sphere { < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LUpArm
	cylinder { < 0, -24, 0 >, < 0, 0, 0 >, 4 }
	/////////////////////////////////////////////

	object {
		LForeArm
		translate <
			0,
			-24,	//length of LFArm
			0
		>
	}

	rotate -80*y	//-90 - 90, rotate
	rotate 50*x	//-90 - 180, lift forward
	rotate 0*z	//-45 - 135, lift outward

}
////////////////////////////////////////////


//*******************************************************************************
//*	Right Arm
//*******************************************************************************

////////////////////////////////////////////
#declare RFingers =
merge {

	/////////////////////////////////////////////
	// Name: RFingerJoint
	cylinder { < 0, 0, -4 >, < 0, 0, 4 >, 0.5 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RFingerTips
	box { < -0.5, -5, -4 >, < 0.5, 0, 4 > }
	/////////////////////////////////////////////

	rotate <
		0,	//no change
		0,	//no change
		45	//0 - 90, close fingers
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RKnuckles =
merge {

	/////////////////////////////////////////////
	// Name: RKnuckleJoint
	cylinder { < 0, 0, -4 >, < 0, 0, 4 >, 1 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RTopFingers
	box { < -0.5, -5, -4 >, < 0.5, 0, 4 > }
	/////////////////////////////////////////////

	object {
		RFingers
		translate <
			0,
			-5,	//length of RTopFingers
			0
		>
	}

	rotate <
		0,	//no change
		0,	//no change
		90	//0 - 90, close knuckles
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RHand =
merge {

	/////////////////////////////////////////////
	// Name: RWrist
	sphere { < 0, 0, 0 >, 3 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RPalm
	box { < -1, -8, -4 >, < 1, 0, 4 > }
	/////////////////////////////////////////////

	object {
		RKnuckles
		translate <
			0,
			-8,	//length of RPalm
			0
		>
	}
	rotate <
		0,	//15 - (-20), bend forward/back
		0,	//no change
		-45	//-45 - 90, bend sideways
	>

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RForeArm =
merge {

	/////////////////////////////////////////////
	// Name: RElbow
	sphere { < 0, 0, 0 >, 4 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RFArm
	cylinder { < 0, -24, 0 >, < 0, 0, 0 >, 3 }
	/////////////////////////////////////////////

	object {
		RHand
		translate <
			0,
			-24,	//length of RFArm
			0
		>
	}

	rotate 0*y	//90 - (-90), rotate
	rotate 135*x	//0 - 160, bend forward

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RUpperArm =
merge {

	/////////////////////////////////////////////
	// Name: RShoulder
	sphere { < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RUpArm
	cylinder { < 0, -24, 0 >, < 0, 0, 0 >, 4 }
	/////////////////////////////////////////////

	object {
		RForeArm
		translate <
			0,
			-24,	//length of RFArm
			0
		>
	}

	rotate 0*y	//-90 - 90, rotate
	rotate 15*x	//-90 - 180, lift forward
	rotate 0*z	//-45 - 135, lift outward

}
////////////////////////////////////////////


//*******************************************************************************
//*	Left Leg
//*******************************************************************************

////////////////////////////////////////////
#declare LFoot =
merge {

	/////////////////////////////////////////////
	// Name: LSole
	box { < -5, -10, -20 >, < 5, -6, 0 > }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LHeel
    cone { < 0, -10, 0 >, 5, < 0, 3, 0 >, 0 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LAnkle
    sphere { < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	rotate 0*y	//-20 - 45, rotate
	rotate -80*x	//-80 - 20, tilt forward/back
	rotate 0*z	//0 - 45, roll outward

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LCalf =
merge {

	/////////////////////////////////////////////
	// Name: LKnee
	sphere { < 0, 0, 0 >, 7 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LLowLeg
	cylinder { < 0, -29, 0 >, < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	object {
		LFoot
		translate <
			0,
			-29,	//length of LLowLeg
			0
		>
	}

	rotate 0*y	//no change
	rotate -90*x	//-90 - 0, bend back
	rotate 0*z	//no change

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare LLeg =
merge {

	/////////////////////////////////////////////
	// Name: LHip
	sphere { < 0, 0, 0 >, 9 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: LThigh
	cylinder { < 0, -32, 0 >, < 0, 0, 0 >, 7 }
	/////////////////////////////////////////////

	object {
		LCalf
		translate <
			0,
			-32,	//length of LThigh
			0
		>
	}

	rotate 0*y	//-90 - 45, rotate
	rotate 45*x	//-45 - 135, bend back/forward
	rotate 0*z	//-45 - 90, lift outward

}
////////////////////////////////////////////


//*******************************************************************************
//*	Right Leg
//*******************************************************************************

////////////////////////////////////////////
#declare RFoot =
merge {

	/////////////////////////////////////////////
	// Name: RSole
	box { < -5, -10, -20 >, < 5, -6, 0 > }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RHeel
    cone { < 0, -10, 0 >, 5, < 0, 3, 0 >, 0 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RAnkle
    sphere { < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	rotate 0*y	//20 - (-45), rotate
	rotate 40*x	//-80 - 20, tilt forward/back
	rotate 0*z	//0 - (-45), roll outward

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RCalf =
merge {

	/////////////////////////////////////////////
	// Name: RKnee
	sphere { < 0, 0, 0 >, 7 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RLowLeg
	cylinder { < 0, -29, 0 >, < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	object {
		RFoot
		translate <
			0,
			-29,	//length of LLowLeg
			0
		>
	}

	rotate 0*y	//no change
	rotate -110*x	//-90 - 0, bend back
	rotate 0*z	//no change

}
////////////////////////////////////////////

////////////////////////////////////////////
#declare RLeg =
merge {

	/////////////////////////////////////////////
	// Name: RHip
	sphere { < 0, 0, 0 >, 9 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: RThigh
	cylinder { < 0, -32, 0 >, < 0, 0, 0 >, 7 }
	/////////////////////////////////////////////

	object {
		RCalf
		translate <
			0,
			-32,	//length of LThigh
			0
		>
	}

	rotate 0*y	//-90 - 45, rotate
	rotate 100*x	//-45 - 135, bend back/forward
	rotate 0*z	//-45 - 90, lift outward

}
////////////////////////////////////////////


//*******************************************************************************
//*	Head
//*******************************************************************************

////////////////////////////////////////////
#declare Head =
merge {

	/////////////////////////////////////////////
	// Name: Base
	sphere { < 0, 0, 0 >, 5 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: Face
	cylinder { < 0, 0, 0 >, < 0, 14, 0 >, 8 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: Pate
	sphere { < 0, 14, 0 >, 8 }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: Skull
	box { < -7, 0, 0 >, < 7, 14, 8 > }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: Cap
	cylinder { < 0, 14, 0 >, < 0, 14, 8 >, 8 }
	/////////////////////////////////////////////

	rotate 0*y	//-90 - 90, turn head
	rotate -30*x	//-50 - 50, tilt forward/back
	rotate 0*z	//-40 - 40, tilt sideways

}
////////////////////////////////////////////


//*******************************************************************************
//*	UpperBody
//*******************************************************************************

////////////////////////////////////////////
#declare UpperBody =
merge {

	/////////////////////////////////////////////
	// Name: Middle
	box { < -16, 0, -7.5 >, < 16, 40, 7.5 > }
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	// Name: Neck
	cylinder { < 0, 40, 0 >, < 0, 50, 0 >, 5 }
	/////////////////////////////////////////////

	object {
		Head
		translate <
			0,
			50,	//top of neck
			0
		>
	}

	/////////////////////////////////////////////
	// Name: Shoulders
	cylinder { < -23, 40, 0 >, < 23, 40, 0 >, 5 }
	/////////////////////////////////////////////

	object {
		RUpperArm
		translate <
			-23,	//Width of shoulders
			40,	//Height of shoulders
			0
		>
	}

	object {
		LUpperArm
		translate <
			23,	//Width of shoulders
			40,	//Height of shoulders
			0
		>
	}

	rotate 0*y	//-90 - 90, turn at waist
	rotate -20*x	//-150 - 50, tilt forward/back
	rotate 0*z	//-40 - 40, tilt sideways

}
////////////////////////////////////////////


//*******************************************************************************
//*	Hips
//*******************************************************************************

////////////////////////////////////////////
#declare Hips =
merge {

	/////////////////////////////////////////////
	// Name: Hips
	cylinder { < -10, 0, 0 >, < 10, 0, 0 >, 9 }
	/////////////////////////////////////////////

	object {
		RLeg
		translate <
			-10,	//width of Hips
			0,
			0
		>
	}

	object {
		LLeg
		translate <
			10,	//width of Hips
			0,
			0
		>
	}
}
////////////////////////////////////////////


//*******************************************************************************
//*	Torso
//*******************************************************************************

////////////////////////////////////////////
#declare Torso =
merge {

	object {
		Hips
		translate <
			0,
			0,
			0
		>
	}

	object {
		UpperBody
		translate <
			0,
			0,
			0
		>
	}
    rotate <-30, 0, 0>
}
////////////////////////////////////////////


//*******************************************************************************
//*	Android
//*******************************************************************************

////////////////////////////////////////////
#declare Android =
object {
	Torso
	translate <
		0,
		45,
		0
	>
}
////////////////////////////////////////////

#declare Golem =
object {
	Android
    translate <0, -1, 0>
    scale 0.15
}
