// Sample file:  A good starting point for images.

#declare CRad = 20   //circle radius
#declare PRad = 1    //pillar radius
#declare PHght = 10  //pillar height
#declare AHght = 5   //arch height
#declare WHght = 10  //wall height
#declare ArchL = 0.5 * ( sqrt( 2*( CRad*CRad ) ) )

#declare MinSide = PRad * 0.38268
#declare MaxSide = PRad * 0.9238795

//////////////////////////
//////////////////////////
#declare HexTex =
texture {
    hexagon
        texture {
            pigment { Black }
            finish {
                metallic
                ambient 0.2
                diffuse 0.7
                brilliance 6
                reflection 0.25
                phong 0.75
                phong_size 80
            }
        },
        texture {
            pigment { White }
            finish {
                metallic
                ambient 0.2
                diffuse 0.7
                brilliance 6
                reflection 0.25
                phong 0.75
                phong_size 80
            }
        },
        texture {
            pigment { Gray50 }
            finish {
                metallic
                ambient 0.2
                diffuse 0.7
                brilliance 6
                reflection 0.25
                phong 0.75
                phong_size 80
            }
        }
}

#declare QuiltTex =
texture {
    pigment {
        color rgb <0.1, 0.1, 0.1>
    }
    normal {
        quilted 0.4
        control0 1 control1 1
        scale 0.3
    }
    finish {
        ambient 0.4
        diffuse 0.7
        brilliance 6
        reflection 0.15
    }
}

#declare WallTex =
texture {
    pigment { Black }
}
texture {
    pigment {
        granite
        turbulence 0.0
        color_map {
            [0.0, 0.2 color White filter 0.4 color White filter 0.8]
            [0.2, 0.3 color White filter 0.8 color Clear]
            [0.3, 1.0 color Clear color Clear]
        }
    }
    finish {
        ambient 0.4
        diffuse 0.7
        brilliance 6
        reflection 0.05
        crand 0.02
    }
}
/////////////////////////////////////
/////////////////////////////////////

//////////////////////////////////////////////////////////////////////
#declare Ceiling =
difference {
    sphere {
        <0, 0, 0>
        1
        scale <3.01 * CRad, 1.01 * PHght, 3.01 * CRad>
        translate <0, PHght, 0>
    }
    sphere {
        <0, 0, 0>
        1
        scale <3 * CRad, PHght, 3 * CRad>
        translate <0, PHght, 0>
    }
    box {
        <-3.5 * CRad, PHght, -3.5 * CRad>
        <3.5 * CRad, -1, 3.5 * CRad>
    }
}

////////////////////////////////////////////////////////////////////////
#declare BackWall =
difference {
    cylinder {
        <0, -0.1, 0>
        <0, PHght, 0>
        3.01 * CRad
        open
    }
    cylinder {
        <0, -0.1, 0>
        <0, PHght, 0>
        3 * CRad
        open
    }
}

///////////////////////////////////////////////////////////////////////
#declare Floor =
box {
    <-3 * CRad, 0, -3 * CRad>
    <3 * CRad, -2, 3 * CRad>
}

////////////////////////////////////////////////////////////////////////
#declare BaseRoom =
union {
    object {
        Ceiling
        texture {
            QuiltTex
            scale 4
        }
    }
    object {
        BackWall
        texture {
            WallTex
            scale 5
        }
    }
    object {
        Floor
        texture {
            HexTex
            scale 5.0
        }
    }
}

////////////////////////////////////////////////////////////////////////
#declare HexPillar =
union {
    box {
        <-MinSide, 0, -MaxSide>
        <MinSide, PHght, MaxSide>
    }
    box {
        <-MinSide, 0, -MaxSide>
        <MinSide, PHght, MaxSide>
        rotate<0, 45, 0>
    }
    box {
        <-MinSide, 0, -MaxSide>
        <MinSide, PHght, MaxSide>
        rotate<0, 90, 0>
    }
    box {
        <-MinSide, 0, -MaxSide>
        <MinSide, PHght, MaxSide>
        rotate<0, 135, 0>
    }
}

////////////////////////////////////////////////////////////////////////////
#declare HalfArches =
union {
    box {
        <-ArchL, PHght+WHght - 1, -PRad * 2>
        <ArchL, PHght+WHght + 1, PRad * 2>
    }
    difference {
        box {
            <-ArchL, PHght, -PRad>
            <ArchL, PHght+WHght, PRad>
        }

        cylinder {
            <0, 0, -PRad -10>
            <0, 0, PRad + 10>
            1
            scale <ArchL - PRad, AHght, 1>
            translate <ArchL, PHght, 0>
        }

        cylinder {
            <0, 0, -PRad -10>
            <0, 0, PRad + 10>
            1
            scale <ArchL - PRad, AHght, 1>
            translate <-ArchL, PHght, 0>
        }
    }
}

//////////////////////////////////////////////////////////////////////////////
#declare Pillar =
merge {
    union {
        object {
            HexPillar
        }
        object {
            HexPillar
            scale <1.4, 0.05, 1.4>
        }
        object {
            HexPillar
            scale <1.2, 0.07, 1.2>
        }
        object {
            HexPillar
            scale <1.4, 0.05, 1.4>
            translate<0, PHght-(PHght*0.05), 0>
        }
        object {
            HexPillar
            scale <1.2, 0.07, 1.2>
            translate<0, PHght-(PHght*0.07), 0>
        }
    }
    object {
        HalfArches
    }
}

////////////////////////////////////////////////////////////////////////////
#declare Room =
union {
    object {
        BaseRoom
    }
#declare Count = 1
#while (Count < 9)
    object {
        Pillar

        texture {
            T_Stone15
            scale 10
            translate <0.3 * Count, 0.3 * Count, 0.3 * Count>
        }

        translate <0, 0, CRad>
        rotate <0, 45 * (Count - 1), 0>
    }
#declare Count = Count + 1
#end
}

