// Persistence of Vision Ray Tracer Scene Description File
// File: practice.pov
// Vers: 3
// Desc: IRTC July-August 1997 submission - A magician practicing his craft
// Date: 8/29/1997
// Auth: Jared Saxton
//

#version 3

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "glass.inc"
#include "woods.inc"
#include "finish.inc"
#include "metals.inc"
//#include "box.inc"

global_settings{assumed_gamma 1.0}

//**** Controls ***
#declare pots=1
#declare shelf=1
#declare walls=1
#declare cage=1
#declare being_obj=1
#declare area_lights=1
#declare stars=1
#declare flash=1
#declare books=1
#declare chess=1

//*** Camera ******
camera{location  <-3, 5, -15> direction 1.5*z right 4/3*x
// look_at<1.5,1,0.0>
 look_at<2,2.65,0.0>
}

//*** Lights *******
#if(area_lights=1)
 light_source
  {0*x color rgb<1.0,1.0,0.8> area_light <8, 0, 0> <0, 0, 8>
  4,4 adaptive 0 jitter
  translate <20, 20, -20>
 }
 light_source
  {0*x color rgb<0.2,0.0,0.2> area_light <8, 0, 0> <0, 0, 8>
  4,4 adaptive 0 jitter
  translate <20, -2, -20>
 }
#else
 light_source
  {0*x color rgb<1.0,1.0,0.8> translate <20, 20, -20>
 }
 light_source
  {0*x color rgb<0.2,0.0,0.2> translate <20, -2, -20>
 }
#end

//*** Texture declarations ***
#declare mortar_tex=pigment{Gray75}
#declare Wall_Tex=texture{T_Stone29 finish{Phong_Shiny}}
#declare shelf_tex=texture{T_Wood7 finish{diffuse 0.75 crand 0.01975}}
#declare knot_tex=texture{pigment{onion color_map{[0.0 0.25 color Clear color Clear][0.25 1.0 color DarkBrown color DarkBrown]} turbulence 0.3} finish{diffuse 0.75 crand 0.01975} scale 0.05}
#declare T_EyeWhite=texture{pigment {onion turbulence 1.15 color_map
   {[0.000, 0.4 color White color White] [0.4, 0.465 color Red color Red] [0.465, 1.1 color White color White]}
   rotate y*90} scale 2 finish {phong 1.0}
}

#declare skin=texture{pigment{marble color_map
         {
           [  0.0  0.5 color Pink color Pink]
           [  0.5  0.6 color Pink color red 1.0 green 0.5 blue 0.5]
           [  0.6 0.7  color red 1.0 green 0.5 blue 0.5 color Pink]
           [  0.7 1.0  color Pink color Pink]
         } turbulence 0.8 scale 3}}

#declare floor_tex=texture{
 pigment{granite turbulence 0.6
  color_map
  {[0.000, 0.212 color rgbf<0.25,0.25,0.25,0> color rgbf<0.2,0.2,0.25,0>]
   [0.212, 0.4 color rgbf<0.2,0.2,0.25,0> color rgbf <0.2,0.25,0.25,0>]
   [0.4, 1.0 color rgbf<0.2,0.25,0.25,0> color rgbf <0.25,0.25,0.25,0>]
  }
 }
}

#declare flash_tex_1=texture{
 pigment
 {marble  turbulence 1.15
  color_map
   {[0.00, 0.45 color rgbt<1,1,1,1> color rgbt<1,1,1,1>]
    [0.45, 0.5 color rgbt<1,1,1,1> color White]
    [0.5, 0.55 color White color rgbt<1,1,1,1>]
    [0.55, 1.05 color rgbt<1,1,1,1> color rgbt<1,1,1,1>]
   }
  scale 20
 }
 finish {ambient 0.8}
}

#declare flash_tex_2=texture{
 pigment
 {marble  turbulence 1.15
  color_map
   {[0.00, 0.35 color rgbt<1,1,1,1> color rgbt<1,1,1,1>]
    [0.35, 0.465 color rgbt<1,1,1,1> color rgbf<1,0,0,0.5>]
    [0.465, 0.5 color rgbf<1,0,0,0.5> color rgbf<1,1,0,0.8>]
    [0.5, 0.65 color rgbf<1,1,0,0.8> color rgbf<1,1,0,0.8>]
    [0.65, 1.0 color rgbf<1,1,0,0.8> color rgbf<1,0,0,0.5>]
    [0.515, 0.55 color rgbf<1,1,0,0.8> color rgbt<1,1,1,1>]
    [0.55, 1.05 color rgbt<1,1,1,1> color rgbt<1,1,1,1>]
   }
//  scale 20
    scale 50
 }
 finish {ambient 0.8}
}

#declare Starfield=texture{
 pigment {
 granite
 color_map {
  [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
  [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
  [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
  [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
  [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
  [ 0.85  0.91 color Gray95 color White  ] // White Stars
  [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
 }
 scale .015
 }
 finish { ambient 100}
}

//*** Objects and other declarations **********
#declare book=object{
 union{
  difference{
   box{<-1,1.5,0>,<10,-1.5,5>}
   text{ttf "c:\windows\fonts\times.ttf","Novelty Magic Spells",0.15,0 pigment{Yellow} translate<0,0.15,-0.145>}
   text{ttf "c:\windows\fonts\times.ttf","Vol. I",0.15,0 pigment{Yellow} scale<0.85,0.85,1> translate<3.25,-0.85,-0.145>}
   box{<-20,1.25,0.25>,<20,-1.25,20>}
  }
  box{<-0.75,1.45,0.25>,<9.75,-1.45,4.75> pigment{White}}
 }
}

#declare eye=object{
 union{
  union{
   difference{
    sphere{<0,0,0>,1 pigment {
      gradient x
      color_map {
       [0.0 0.85 color White color White]
       [0.85 0.875 color Black color Blue]
       [0.875 0.975 color Blue color Thistle]
       [0.975 0.985 color Thistle color Black]
       [0.985 1.1 color Black color Black]
      }
     }
     finish{phong 1.0}
    }
    box{<0.725,100,100>,<-100,-100,-100>}
   }
   difference{
    sphere{<0,0,0>,1 texture{T_EyeWhite}}
    box{<0.725,100,100>,<100,-100,-100>}
   }
   rotate y*0 //for eyeball rotation
  }
  difference{	//upper lid
   blob{threshold 0.6 sphere{<0,0,0>,2.25,1.0} sphere{<0,1.0,0>,1.5,1.0}}
   box{<10,-0.5,10>,<-10,-10,-10>}
   rotate z*60
  }
  difference{	//lower lid
   blob{threshold 0.6 sphere{<0,0,0>,2.25,1.0} sphere{<0,-1.0,0>,1.5,1.0}}
   box{<10,10,10>,<-10,0.5,-10>}
   rotate z*-40
  }
 }
}

#declare head_right=object{
 union{
  blob{
   threshold 0.6

   sphere { <1, 1, 6>, 8.0, 1.0}
   sphere { <0.75, 0.5, 1.5>, 4.0, 1.0}

   cylinder{<0.125,0.5,0>,<0.125,0,-1>, 0.5, 1.0}
   cylinder{<0.125,0,-1>,<0.125,-1,-1.5>, 0.5, 1.0}
   cylinder{<0.125,-1,-1.5>,<0.15,-2,-2>, 0.75, 1.0}
   cylinder{<0.15,-2,-2>,<1,-1.75,1>, 0.75, 1.0}

   sphere{<0.5,1.8,0>,1.15,1.0}

   sphere{<2.25,0,0.5>,3,1.0}
   sphere{<1.5,0,0>,2.0,-1.0}

   sphere{<2.5,-2,0>,1.5,1.0}
   sphere{<0.75,-2.5,0.5>,2,1.0}

   sphere{<1,-3,3>,3.0,1.0}

   sphere{<0.5,-3,0>,2.0,0.75}

   sphere{<2.25,-3,0.15>,3.0,0.75}

   sphere{<1.25,-4,0.15>,1.0,0.75}
  }
 }
}

#declare head_left=object{
 union{
  blob{
   threshold 0.6
   sphere { <-1, 1, 6>, 8.0, 1.0}
   sphere { <-0.75, 0.5, 1.5>, 4.0, 1.0}

   cylinder{<-0.125,0.5,0>,<-0.125,0,-1>, 0.5, 1.0}
   cylinder{<-0.125,0,-1>,<-0.125,-1,-1.5>, 0.5, 1.0}
   cylinder{<-0.125,-1,-1.5>,<-0.15,-2,-2>, 0.75, 1.0}
   cylinder{<-0.15,-2,-2>,<-1,-1.75,1>, 0.75, 1.0}

   sphere{<-0.5,1.8,0>,1.15,1.0}

   sphere{<-2.25,0,0.5>,3,1.0}
   sphere{<-1.5,0,0>,2.0,-1.0}

   sphere{<-2.5,-2,0>,1.5,1.0}
   sphere{<-0.75,-2.5,0.5>,2,1.0}

   sphere{<-1,-3,3>,3.0,1.0}

   sphere{<-0.5,-3,0>,2.0,0.75}

   sphere{<-2.25,-3,0.15>,3.0,0.75}

   sphere{<-1.25,-4,0.15>,1.0,0.75}
  }
 }
}

#declare right_jaw=object{
 union{
  blob{
   threshold 0.6
   sphere{<0.25,-4.5,0.35>,1.75,1.0}
   sphere{<0.5,-4.5,3.0>,3.0,1.0}

   sphere{<2,-14,2.5>,4.0,1.0}
   sphere{<5.5,-12.5,3.25>,2.0,1.0}

   sphere{<2,-12,5>,8.0,1.0}
   sphere{<1.85,-16,7>,7.0,1.0}
   sphere{<1.5,-18,4>,5.0,1.0}

   sphere{<3.5,-21.5,5>,2.5,1.0}
   sphere{<3.3,-22,3>,2.0,1.0}

//***
   sphere{<2.25,-26,6.25>,6.0,1.0}
   sphere{<2.25,-28,6.25>,6.0,1.0}
   sphere{<3.85,-24,5>,2.5,1.0}

   sphere{<2.0,-30,7>,5.5,1.0}
   sphere{<2.0,-31,8>,5.5,1.0}
   sphere{<2.0,-32,8>,5.5,1.0}

   sphere{<3.85,-24,5>,2.5,1.0}
   sphere{<3.0,-25.5,3>,2.0,1.0}
   cylinder{<3.85,-24,5>,<3.0,-25.5,3>,2.0,1.0}
   sphere{<0.5,-25,2>,3.5,1.0}
   sphere{<3.0,-30,5>,5.0,1.0}
   sphere{<3.0,-32,5>,5.0,1.0}

//***MORE
   sphere{<5.0,-35,5>,6.0,1.0}
   sphere{<5.0,-40,5>,4.0,1.0}
   cylinder{<6.0,-30,5>,<5,-45,5>,4.0,1.0}

//***
   sphere{<1.0,-20,3.0>,5.0,1.0}
   sphere{<1.0,-22,3.0>,5.0,1.0}
   sphere{<1.0,-24,3.0>,5.0,1.0}


   cylinder{<0,-10,6>,<7,-11,5>,3,1.0} //shoulder

   cylinder{<7,-11,5>,<13,-10,3>,3,1.0} //arm?

   cylinder{<0.25,-3,5>,<0.25,-6,3>,1.5,1.0}
   cylinder{<0.25,-6,3>,<0.25,-8,3.5>,1.5,1.0}
   cylinder{<0.25,-8,3.5>,<0.25,-10,5>,1.5,1.0}
   cylinder{<0.25,-10,5>,<0.25,-11,7>,1.5,1.0}
   cylinder{<0.25,-11,7>,<0.25,-12,8>,1.5,1.0}
   cylinder{<0.25,-12,8>,<0.25,-14,8.5>,1.5,1.0}
   cylinder{<0.25,-14,8.5>,<0.25,-15,8.5>,1.5,1.0}
   cylinder{<0.25,-15,8.5>,<0.25,-16,8.5>,1.5,1.0}
   cylinder{<0.25,-16,8.5>,<0.25,-17,8.0>,1.5,1.0}
   cylinder{<0.25,-17,8.0>,<0.25,-19,7.0>,1.5,1.0}
   cylinder{<0.25,-19,7.0>,<0.25,-22,5.25>,1.5,1.0}
   cylinder{<0.25,-22,5.25>,<0.25,-24,5>,1.5,1.0}
   cylinder{<0.25,-24,5>,<0.25,-26,5.25>,1.5,1.0}
   cylinder{<0.25,-26,5.25>,<0.25,-28,6.5>,1.5,1.0}

   cylinder{<0.25,-3,6>,<0.25,-6,4>,1.5,1.0}
   cylinder{<0.25,-6,4>,<0.25,-8,4.5>,1.5,1.0}
   cylinder{<0.25,-8,4.5>,<0.25,-10,6>,1.5,1.0}
   cylinder{<0.25,-10,6>,<0.25,-11,8>,1.5,1.0}
   cylinder{<0.25,-11,8>,<0.25,-12,9>,1.5,1.0}
   cylinder{<0.25,-12,9>,<0.25,-14,9.5>,1.5,1.0}
   cylinder{<0.25,-14,9.5>,<0.25,-15,9.5>,1.5,1.0}
   cylinder{<0.25,-15,9.5>,<0.25,-16,9.5>,1.5,1.0}
   cylinder{<0.25,-16,9.5>,<0.25,-17,9.0>,1.5,1.0}
   cylinder{<0.25,-17,9.0>,<0.25,-19,8.0>,1.5,1.0}
   cylinder{<0.25,-19,8.0>,<0.25,-22,6.25>,1.5,1.0}
   cylinder{<0.25,-22,6.25>,<0.25,-24,6>,1.5,1.0}
   cylinder{<0.25,-24,6>,<0.25,-26,6.25>,1.5,1.0}
   cylinder{<0.25,-26,6.25>,<0.25,-28,7.5>,1.5,1.0}

   cylinder{<-1,-4.0,-0.5>,<1,-4.0,-0.5>,0.45,1.0} //lip
  }
 }
}

#declare left_jaw=object{
 union{
  blob{
   threshold 0.6
   sphere{<-0.25,-4.5,0.35>,1.75,1.0}
   sphere{<-0.5,-4.5,3.0>,3.0,1.0}

   sphere{<-2,-12,3>,4.0,1.0}
   sphere{<-5.5,-10.5,3.25>,2.0,1.0}

   sphere{<-2,-12,5>,8.0,1.0}
   sphere{<-1.85,-16,7>,7.0,1.0}
   sphere{<-1.5,-18,4>,5.0,1.0}

   sphere{<-3.5,-21.5,5>,2.5,1.0}
   sphere{<-3.3,-22,3>,2.0,1.0}

//***
   sphere{<-2.25,-26,6.25>,6.0,1.0}
   sphere{<-2.25,-28,6.25>,6.0,1.0}
   sphere{<-3.85,-24,5>,2.5,1.0}

   sphere{<-2.0,-30,7>,5.5,1.0}
   sphere{<-2.0,-31,8>,5.5,1.0}
   sphere{<-2.0,-32,8>,5.5,1.0}

   sphere{<-3.0,-25.5,3>,2.0,1.0}
   cylinder{<-3.85,-24,5>,<-3.0,-25.5,3>,2.0,1.0}
   sphere{<-0.5,-25,2>,3.5,1.0}
   sphere{<-3.0,-30,5>,5.0,1.0}
   sphere{<-3.0,-32,5>,5.0,1.0}

//***MORE
   sphere{<-5.0,-35,5>,6.0,1.0}
   sphere{<-5.0,-40,5>,4.0,1.0}
   cylinder{<-6.0,-30,5>,<-5,-45,5>,4.0,1.0}

//***

   sphere{<-1.0,-20,3.0>,5.0,1.0}
   sphere{<-1.0,-22,3.0>,5.0,1.0}
   sphere{<-1.0,-24,3.0>,5.0,1.0}

//   cylinder{<0,-10,6>,<-7,-13,5>,3,1.0} //shoulder
   cylinder{<0,-10,6>,<-7,-9,5>,3,1.0} //shoulder

//   cylinder{<-7,-13,5>,<-13,-10,3>,3,1.0} //arm?
   cylinder{<-7,-9,5>,<-13,-6,3>,3,1.0} //arm?

   cylinder{<-0.25,-3,5>,<-0.25,-6,3>,1.5,1.0}
   cylinder{<-0.25,-6,3>,<-0.25,-8,3.5>,1.5,1.0}
   cylinder{<-0.25,-8,3.5>,<-0.25,-10,5>,1.5,1.0}
   cylinder{<-0.25,-10,5>,<-0.25,-11,7>,1.5,1.0}
   cylinder{<-0.25,-11,7>,<-0.25,-12,8>,1.5,1.0}
   cylinder{<-0.25,-12,8>,<-0.25,-14,8.5>,1.5,1.0}
   cylinder{<-0.25,-14,8.5>,<-0.25,-15,8.5>,1.5,1.0}
   cylinder{<-0.25,-15,8.5>,<-0.25,-16,8.5>,1.5,1.0}
   cylinder{<-0.25,-16,8.5>,<-0.25,-17,8.0>,1.5,1.0}
   cylinder{<-0.25,-17,8.0>,<-0.25,-19,7.0>,1.5,1.0}
   cylinder{<-0.25,-19,7.0>,<-0.25,-22,5.25>,1.5,1.0}
   cylinder{<-0.25,-22,5.25>,<-0.25,-24,5>,1.5,1.0}
   cylinder{<-0.25,-24,5>,<-0.25,-26,5.25>,1.5,1.0}
   cylinder{<-0.25,-26,5.25>,<-0.25,-28,6.5>,1.5,1.0}

   cylinder{<-0.25,-3,6>,<-0.25,-6,4>,1.5,1.0}
   cylinder{<-0.25,-6,4>,<-0.25,-8,4.5>,1.5,1.0}
   cylinder{<-0.25,-8,4.5>,<-0.25,-10,6>,1.5,1.0}
   cylinder{<-0.25,-10,6>,<-0.25,-11,8>,1.5,1.0}
   cylinder{<-0.25,-11,8>,<-0.25,-12,9>,1.5,1.0}
   cylinder{<-0.25,-12,9>,<-0.25,-14,9.5>,1.5,1.0}
   cylinder{<-0.25,-14,9.5>,<-0.25,-15,9.5>,1.5,1.0}
   cylinder{<-0.25,-15,9.5>,<-0.25,-16,9.5>,1.5,1.0}
   cylinder{<-0.25,-16,9.5>,<-0.25,-17,9.0>,1.5,1.0}
   cylinder{<-0.25,-17,9.0>,<-0.25,-19,8.0>,1.5,1.0}
   cylinder{<-0.25,-19,8.0>,<-0.25,-22,6.25>,1.5,1.0}
   cylinder{<-0.25,-22,6.25>,<-0.25,-24,6>,1.5,1.0}
   cylinder{<-0.25,-24,6>,<-0.25,-26,6.25>,1.5,1.0}
   cylinder{<-0.25,-26,6.25>,<-0.25,-28,7.5>,1.5,1.0}


   cylinder{<-1,-4.0,-0.5>,<1,-4.0,-0.5>,0.45,1.0} //lip
  }
 }
}

#declare full_head=object{
 union{
  object{eye rotate y*90 translate x*1.5}
  object{eye rotate y*90 translate x*-1.5}
  object{right_jaw}
  object{left_jaw}
  object{head_right}
  object{head_left}
 }
}

#declare hand_1=object{
 union{
  blob {
   threshold 0.600000
   component 1.000000, 0.317058, <-0.357251, -0.129278, 0.000000>
   component 1.000000, 0.458498, <-1.086957, 0.053232, 0.000000>
   component 1.000000, 0.302118, <-1.573427, 0.509506, 0.000000>
   component 1.000000, 0.302118, <-1.147765, 1.163498, 0.000000>
   component 1.000000, 0.302118, <-0.843721, 1.239544, 0.000000>
   component 1.000000, 0.302118, <-0.524476, 1.117871, 0.000000>
   component 1.000000, 0.302118, <-0.235634, 0.859316, 0.000000>
   component 1.000000, 0.286425, <-0.250836, 0.235741, 0.000000>
   component 1.000000, 0.286425, <-0.205230, 0.403042, 0.000000>
   component 1.000000, 0.286425, <-0.205230, 0.570342, 0.000000>
   component 1.000000, 0.286425, <-0.326847, 0.098859, 0.000000>
   component 1.000000, 0.224245, <-1.375798, 0.281369, 0.000000>
   component 1.000000, 0.224245, <-1.299787, 0.205323, 0.000000>
   component 1.000000, 0.233210, <-1.467011, 0.372624, 0.000000>
   component 1.000000, 0.205067, <-1.740651, 0.904943, 0.000000>
   component 1.000000, 0.181176, <-1.907875, 1.315589, 0.000000>
   component 1.000000, 0.181176, <-1.634235, 0.676806, 0.000000>
   component 1.000000, 0.181176, <-1.679842, 0.783270, 0.000000>
   component 1.000000, 0.181176, <-1.801459, 1.133080, 0.000000>
   component 1.000000, 0.181176, <-1.771055, 1.041825, 0.000000>
   component 1.000000, 0.181176, <-1.847066, 1.254753, 0.000000>
   component 1.000000, 0.205067, <-0.205230, 1.269962, 0.000000>
   component 1.000000, 0.205067, <-0.494071, 1.558935, 0.000000>
   component 1.000000, 0.205067, <-0.813317, 1.756654, 0.000000>
   component 1.000000, 0.205067, <-1.178170, 1.695817, 0.000000>
   component 1.000000, 0.192210, <-0.197628, 1.551331, 0.000000>
   component 1.000000, 0.192210, <-0.486470, 1.946768, 0.000000>
   component 1.000000, 0.192210, <-0.805716, 2.159696, 0.000000>
   component 1.000000, 0.192210, <-1.170569, 1.460076, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 1.520913, 0.000000>
   component 1.000000, 0.181176, <-0.501672, 1.384030, 0.000000>
   component 1.000000, 0.181176, <-0.212831, 1.095057, 0.000000>
   component 1.000000, 0.163344, <-0.805716, 2.539924, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 1.961977, 0.000000>
   component 1.000000, 0.160175, <-0.486470, 1.764259, 0.000000>
   component 1.000000, 0.160128, <-0.212831, 1.429658, 0.000000>
   component 1.000000, 0.160175, <-1.200973, 2.463878, 0.000000>
   component 1.000000, 0.132080, <-0.471268, 2.372624, 0.000000>
   component 1.000000, 0.160128, <-0.167224, 1.855513, 0.000000>
   component 1.000000, 0.132027, <-0.805716, 2.357414, 0.000000>
   component 1.000000, 0.132027, <-0.486470, 2.174905, 0.000000>
   component 1.000000, 0.132027, <-0.182426, 1.703422, 0.000000>
   component 1.000000, 0.132027, <-0.805716, 2.433460, 0.000000>
   component 1.000000, 0.132027, <-0.805716, 2.266160, 0.000000>
   component 1.000000, 0.132027, <-0.486470, 2.250951, 0.000000>
   component 1.000000, 0.132027, <-0.486470, 2.068441, 0.000000>
   component 1.000000, 0.192210, <-1.170569, 1.581749, 0.000000>
   component 1.000000, 0.192210, <-1.170569, 1.338403, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 1.657795, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 1.414449, 0.000000>
   component 1.000000, 0.181176, <-0.501672, 1.292776, 0.000000>
   component 1.000000, 0.181176, <-0.501672, 1.460076, 0.000000>
   component 1.000000, 0.202524, <-1.200973, 2.083650, 0.000000>
   component 1.000000, 0.181176, <-1.185771, 1.885932, 0.000000>
   component 1.000000, 0.181176, <-1.185771, 1.977186, 0.000000>
   component 1.000000, 0.181176, <-1.185771, 1.809886, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 2.053232, 0.000000>
   component 1.000000, 0.181176, <-0.820918, 1.840304, 0.000000>
   component 1.000000, 0.132027, <-1.200973, 2.296578, 0.000000>
   component 1.000000, 0.132027, <-1.200973, 2.372624, 0.000000>
   component 1.000000, 0.132027, <-1.200973, 2.205323, 0.000000>
   component 1.000000, 0.192210, <-1.003344, 1.247148, 0.000000>
   component 1.000000, 0.192210, <-0.668896, 1.231939, 0.000000>
   component 1.000000, 0.192210, <-0.349650, 1.019011, 0.000000>
   component 1.000000, 0.192210, <-1.170569, 0.973384, 0.000000>
   component 1.000000, 0.192210, <-1.155366, 0.760456, 0.000000>
   component 1.000000, 0.192210, <-1.383399, 0.653992, 0.000000>
   component 1.000000, 0.192210, <-1.307388, 0.760456, 0.000000>
   component 1.000000, 0.192210, <-1.276984, 0.882129, 0.000000>
   component 1.000000, 0.192210, <-1.231377, 1.019011, 0.000000>
   component 1.000000, 0.132027, <-0.182426, 1.779468, 0.000000>
   component 1.000000, 0.132027, <-0.182426, 1.627376, 0.000000>
   component 1.000000, 0.132027, <-0.228033, 1.003802, 0.000000>
   component 1.000000, 0.132027, <-0.212831, 1.171103, 0.000000>
   component 1.000000, 0.160175, <-0.486470, 1.840304, 0.000000>
   component 1.000000, 0.160175, <-0.486470, 1.673004, 0.000000>
   component 1.000000, 0.192210, <-0.988142, 1.095057, 0.000000>
   component 1.000000, 0.192210, <-0.729705, 1.079848, 0.000000>
   component 1.000000, 0.192210, <-0.456066, 0.927757, 0.000000>
   component 1.000000, 0.192210, <-1.398601, 0.532319, 0.000000>
   component 1.000000, 0.192210, <-1.048951, 0.912548, 0.000000>
   component 1.000000, 0.192210, <-0.866525, 0.988593, 0.000000>
   component 1.000000, 0.192210, <-0.638492, 0.942966, 0.000000>
   component 1.000000, 0.286425, <-1.307388, 0.425856, 0.000000>
   component 1.000000, 0.224245, <-1.185771, 0.319392, 0.000000>
   component 1.000000, 0.192210, <-1.216175, 0.608365, 0.000000>
   component 1.000000, 0.192210, <-1.140164, 0.486692, 0.000000>
   component 1.000000, 0.192210, <-1.048951, 0.349810, 0.000000>
   component 1.000000, 0.132027, <-0.319246, 0.714829, 0.000000>
   component 1.000000, 0.132027, <-0.349650, 0.623574, 0.000000>
   component 1.000000, 0.132027, <-0.364853, 0.517110, 0.000000>
   component 1.000000, 0.132027, <-0.364853, 0.410646, 0.000000>
   component 1.000000, 0.132027, <-0.395257, 0.304183, 0.000000>
   component 1.000000, 0.132027, <-0.440863, 0.243346, 0.000000>
   component 1.000000, 0.192210, <-1.109760, 0.623574, 0.000000>
   component 1.000000, 0.192210, <-1.018547, 0.517110, 0.000000>
   component 1.000000, 0.192210, <-0.957738, 0.334601, 0.000000>
   component 1.000000, 0.192210, <-0.912131, 0.197719, 0.000000>
   component 1.000000, 0.132027, <-0.410459, 0.790875, 0.000000>
   component 1.000000, 0.132027, <-0.547279, 0.821293, 0.000000>
   component 1.000000, 0.132027, <-0.760109, 0.897338, 0.000000>
   component 1.000000, 0.132027, <-0.912131, 0.836502, 0.000000>
   component 1.000000, 0.132027, <-1.018547, 0.730038, 0.000000>
   component 1.000000, 0.132027, <-0.927334, 0.653992, 0.000000>
   component 1.000000, 0.132027, <-0.836120, 0.745247, 0.000000>
   component 1.000000, 0.132027, <-0.699301, 0.775665, 0.000000>
   component 1.000000, 0.132027, <-0.577683, 0.669202, 0.000000>
   component 1.000000, 0.132027, <-0.729705, 0.623574, 0.000000>
   component 1.000000, 0.132027, <-0.851323, 0.532319, 0.000000>
   component 1.000000, 0.132027, <-0.714503, 0.456274, 0.000000>
   component 1.000000, 0.132027, <-0.592885, 0.532319, 0.000000>
   component 1.000000, 0.132027, <-0.456066, 0.699620, 0.000000>
   component 1.000000, 0.132027, <-0.486470, 0.577947, 0.000000>
   component 1.000000, 0.132027, <-0.486470, 0.456274, 0.000000>
   component 1.000000, 0.132027, <-0.820918, 0.395437, 0.000000>
   component 1.000000, 0.132027, <-0.592885, 0.365019, 0.000000>
   component 1.000000, 0.132027, <-0.501672, 0.319392, 0.000000>
   component 1.000000, 0.132027, <-0.699301, 0.304183, 0.000000>
   component 1.000000, 0.132027, <-0.805716, 0.273764, 0.000000>
   component 1.000000, 0.132027, <-0.592885, 0.228137, 0.000000>
   component 1.000000, 0.132027, <-0.516874, 0.152091, 0.000000>
   component 1.000000, 0.132027, <-0.516874, 0.045627, 0.000000>
   component 1.000000, 0.132027, <-0.684099, 0.167300, 0.000000>
   component 1.000000, 0.132027, <-0.820918, 0.091255, 0.000000>
   component 1.000000, 0.132027, <-0.653694, 0.060837, 0.000000>
   component 1.000000, 0.224245, <-0.805716, -0.030418, 0.000000>
   component 1.000000, 0.224245, <-0.608088, -0.076046, 0.000000>
   component 1.000000, 0.224245, <-0.197628, 0.730038, 0.000000>
   component 1.000000, 0.132027, <-0.167224, 1.019011, 0.000000>
   component 1.000000, 0.132027, <-0.167224, 0.942966, 0.000000>
   component 1.000000, 0.132027, <-0.836120, 0.623574, 0.000000>
   component 1.000000, 0.132027, <-1.398601, 0.714829, 0.000000>
   component 1.000000, 0.132027, <-1.474612, 0.669201, 0.000000>
   component 1.000000, 0.132027, <-1.550623, 0.669201, 0.000000>
   component 1.000000, 0.132027, <-1.200973, 2.159695, 0.000000>

   component 1.000000, 0.488815, <0.9, -3.75, 3.0>
   component 1.000000, 0.293155, <-0.7, -0.14, 0.0>
   component 1.000000, 0.293155, <-0.5, -0.14, 0.0>
   component 1.000000, 0.293155, <-0.9, -0.14, 0.0>

   cylinder{<0.9, -3.75, 2.800>, <-0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.7, -3.75, 2.800>, <-0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.5, -3.75, 2.800>, <-0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.3, -3.75, 2.800>, <-0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<0.9, -3.625, 3.000>, <-0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.6, -3.625, 3.000>, <-0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.3, -3.625, 3.000>, <-0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<0.9, -3.5, 3.000>, <-0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.6, -3.5, 3.000>, <-0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<0.3, -3.5, 3.000>, <-0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<0.6, -3.45, 3.000>, <-0.7, -0.14, 0.0>, 0.35, 1.0}
   sphere{<0.6, -3.4, 3.000>,0.5,1.0}
  }
//  cone{<-0.7,0.6,0>,0.125,<-0.7,0.6,-100>,3 pigment{color rgbt<1, 1, 1, 1>}
//   halo{emitting cylindrical_mapping linear turbulence 1.5
//   color_map {
//    [ 0.0 color rgbt <1, 0, 0,  1> ]
//    [ 0.5 color rgbt <1, 1, 0, 0.75> ]
//    [ 1.0 color rgbt <1, 0, 0,  1> ]
//   }
//   frequency 2 samples 20 scale<50,50,75> translate<0,0,50>}
//   hollow
//  }

 }
}

#declare hand_2=object{
 union{
  blob {
   threshold 0.600000
   component 1.000000, 0.317058, <0.357251, -0.129278, 0.000000>
   component 1.000000, 0.458498, <1.086957, 0.053232, 0.000000>
   component 1.000000, 0.302118, <1.573427, 0.509506, 0.000000>
   component 1.000000, 0.302118, <1.147765, 1.163498, 0.000000>
   component 1.000000, 0.302118, <0.843721, 1.239544, 0.000000>
   component 1.000000, 0.302118, <0.524476, 1.117871, 0.000000>
   component 1.000000, 0.302118, <0.235634, 0.859316, 0.000000>
   component 1.000000, 0.286425, <0.250836, 0.235741, 0.000000>
   component 1.000000, 0.286425, <0.205230, 0.403042, 0.000000>
   component 1.000000, 0.286425, <0.205230, 0.570342, 0.000000>
   component 1.000000, 0.286425, <0.326847, 0.098859, 0.000000>
   component 1.000000, 0.224245, <1.375798, 0.281369, 0.000000>
   component 1.000000, 0.224245, <1.299787, 0.205323, 0.000000>
   component 1.000000, 0.233210, <1.467011, 0.372624, 0.000000>
   component 1.000000, 0.205067, <1.740651, 0.904943, 0.000000>
   component 1.000000, 0.181176, <1.907875, 1.315589, 0.000000>
   component 1.000000, 0.181176, <1.634235, 0.676806, 0.000000>
   component 1.000000, 0.181176, <1.679842, 0.783270, 0.000000>
   component 1.000000, 0.181176, <1.801459, 1.133080, 0.000000>
   component 1.000000, 0.181176, <1.771055, 1.041825, 0.000000>
   component 1.000000, 0.181176, <1.847066, 1.254753, 0.000000>
   component 1.000000, 0.205067, <0.205230, 1.269962, 0.000000>
   component 1.000000, 0.205067, <0.494071, 1.558935, 0.000000>
   component 1.000000, 0.205067, <0.813317, 1.756654, 0.000000>
   component 1.000000, 0.205067, <1.178170, 1.695817, 0.000000>
   component 1.000000, 0.192210, <0.197628, 1.551331, 0.000000>
   component 1.000000, 0.192210, <0.486470, 1.946768, 0.000000>
   component 1.000000, 0.192210, <0.805716, 2.159696, 0.000000>
   component 1.000000, 0.192210, <1.170569, 1.460076, 0.000000>
   component 1.000000, 0.181176, <0.820918, 1.520913, 0.000000>
   component 1.000000, 0.181176, <0.501672, 1.384030, 0.000000>
   component 1.000000, 0.181176, <0.212831, 1.095057, 0.000000>
   component 1.000000, 0.163344, <0.805716, 2.539924, 0.000000>
   component 1.000000, 0.181176, <0.820918, 1.961977, 0.000000>
   component 1.000000, 0.160175, <0.486470, 1.764259, 0.000000>
   component 1.000000, 0.160128, <0.212831, 1.429658, 0.000000>
   component 1.000000, 0.160175, <1.200973, 2.463878, 0.000000>
   component 1.000000, 0.132080, <0.471268, 2.372624, 0.000000>
   component 1.000000, 0.160128, <0.167224, 1.855513, 0.000000>
   component 1.000000, 0.132027, <0.805716, 2.357414, 0.000000>
   component 1.000000, 0.132027, <0.486470, 2.174905, 0.000000>
   component 1.000000, 0.132027, <0.182426, 1.703422, 0.000000>
   component 1.000000, 0.132027, <0.805716, 2.433460, 0.000000>
   component 1.000000, 0.132027, <0.805716, 2.266160, 0.000000>
   component 1.000000, 0.132027, <0.486470, 2.250951, 0.000000>
   component 1.000000, 0.132027, <0.486470, 2.068441, 0.000000>
   component 1.000000, 0.192210, <1.170569, 1.581749, 0.000000>
   component 1.000000, 0.192210, <1.170569, 1.338403, 0.000000>
   component 1.000000, 0.181176, <0.820918, 1.657795, 0.000000>
   component 1.000000, 0.181176, <0.820918, 1.414449, 0.000000>
   component 1.000000, 0.181176, <0.501672, 1.292776, 0.000000>
   component 1.000000, 0.181176, <0.501672, 1.460076, 0.000000>
   component 1.000000, 0.202524, <1.200973, 2.083650, 0.000000>
   component 1.000000, 0.181176, <1.185771, 1.885932, 0.000000>
   component 1.000000, 0.181176, <1.185771, 1.977186, 0.000000>
   component 1.000000, 0.181176, <1.185771, 1.809886, 0.000000>
   component 1.000000, 0.181176, <0.820918, 2.053232, 0.000000>
   component 1.000000, 0.181176, <0.820918, 1.840304, 0.000000>
   component 1.000000, 0.132027, <1.200973, 2.296578, 0.000000>
   component 1.000000, 0.132027, <1.200973, 2.372624, 0.000000>
   component 1.000000, 0.132027, <1.200973, 2.205323, 0.000000>
   component 1.000000, 0.192210, <1.003344, 1.247148, 0.000000>
   component 1.000000, 0.192210, <0.668896, 1.231939, 0.000000>
   component 1.000000, 0.192210, <0.349650, 1.019011, 0.000000>
   component 1.000000, 0.192210, <1.170569, 0.973384, 0.000000>
   component 1.000000, 0.192210, <1.155366, 0.760456, 0.000000>
   component 1.000000, 0.192210, <1.383399, 0.653992, 0.000000>
   component 1.000000, 0.192210, <1.307388, 0.760456, 0.000000>
   component 1.000000, 0.192210, <1.276984, 0.882129, 0.000000>
   component 1.000000, 0.192210, <1.231377, 1.019011, 0.000000>
   component 1.000000, 0.132027, <0.182426, 1.779468, 0.000000>
   component 1.000000, 0.132027, <0.182426, 1.627376, 0.000000>
   component 1.000000, 0.132027, <0.228033, 1.003802, 0.000000>
   component 1.000000, 0.132027, <0.212831, 1.171103, 0.000000>
   component 1.000000, 0.160175, <0.486470, 1.840304, 0.000000>
   component 1.000000, 0.160175, <0.486470, 1.673004, 0.000000>
   component 1.000000, 0.192210, <0.988142, 1.095057, 0.000000>
   component 1.000000, 0.192210, <0.729705, 1.079848, 0.000000>
   component 1.000000, 0.192210, <0.456066, 0.927757, 0.000000>
   component 1.000000, 0.192210, <1.398601, 0.532319, 0.000000>
   component 1.000000, 0.192210, <1.048951, 0.912548, 0.000000>
   component 1.000000, 0.192210, <0.866525, 0.988593, 0.000000>
   component 1.000000, 0.192210, <0.638492, 0.942966, 0.000000>
   component 1.000000, 0.286425, <1.307388, 0.425856, 0.000000>
   component 1.000000, 0.224245, <1.185771, 0.319392, 0.000000>
   component 1.000000, 0.192210, <1.216175, 0.608365, 0.000000>
   component 1.000000, 0.192210, <1.140164, 0.486692, 0.000000>
   component 1.000000, 0.192210, <1.048951, 0.349810, 0.000000>
   component 1.000000, 0.132027, <0.319246, 0.714829, 0.000000>
   component 1.000000, 0.132027, <0.349650, 0.623574, 0.000000>
   component 1.000000, 0.132027, <0.364853, 0.517110, 0.000000>
   component 1.000000, 0.132027, <0.364853, 0.410646, 0.000000>
   component 1.000000, 0.132027, <0.395257, 0.304183, 0.000000>
   component 1.000000, 0.132027, <0.440863, 0.243346, 0.000000>
   component 1.000000, 0.192210, <1.109760, 0.623574, 0.000000>
   component 1.000000, 0.192210, <1.018547, 0.517110, 0.000000>
   component 1.000000, 0.192210, <0.957738, 0.334601, 0.000000>
   component 1.000000, 0.192210, <0.912131, 0.197719, 0.000000>
   component 1.000000, 0.132027, <0.410459, 0.790875, 0.000000>
   component 1.000000, 0.132027, <0.547279, 0.821293, 0.000000>
   component 1.000000, 0.132027, <0.760109, 0.897338, 0.000000>
   component 1.000000, 0.132027, <0.912131, 0.836502, 0.000000>
   component 1.000000, 0.132027, <1.018547, 0.730038, 0.000000>
   component 1.000000, 0.132027, <0.927334, 0.653992, 0.000000>
   component 1.000000, 0.132027, <0.836120, 0.745247, 0.000000>
   component 1.000000, 0.132027, <0.699301, 0.775665, 0.000000>
   component 1.000000, 0.132027, <0.577683, 0.669202, 0.000000>
   component 1.000000, 0.132027, <0.729705, 0.623574, 0.000000>
   component 1.000000, 0.132027, <0.851323, 0.532319, 0.000000>
   component 1.000000, 0.132027, <0.714503, 0.456274, 0.000000>
   component 1.000000, 0.132027, <0.592885, 0.532319, 0.000000>
   component 1.000000, 0.132027, <0.456066, 0.699620, 0.000000>
   component 1.000000, 0.132027, <0.486470, 0.577947, 0.000000>
   component 1.000000, 0.132027, <0.486470, 0.456274, 0.000000>
   component 1.000000, 0.132027, <0.820918, 0.395437, 0.000000>
   component 1.000000, 0.132027, <0.592885, 0.365019, 0.000000>
   component 1.000000, 0.132027, <0.501672, 0.319392, 0.000000>
   component 1.000000, 0.132027, <0.699301, 0.304183, 0.000000>
   component 1.000000, 0.132027, <0.805716, 0.273764, 0.000000>
   component 1.000000, 0.132027, <0.592885, 0.228137, 0.000000>
   component 1.000000, 0.132027, <0.516874, 0.152091, 0.000000>
   component 1.000000, 0.132027, <0.516874, 0.045627, 0.000000>
   component 1.000000, 0.132027, <0.684099, 0.167300, 0.000000>
   component 1.000000, 0.132027, <0.820918, 0.091255, 0.000000>
   component 1.000000, 0.132027, <0.653694, 0.060837, 0.000000>
   component 1.000000, 0.224245, <0.805716, -0.030418, 0.000000>
   component 1.000000, 0.224245, <0.608088, -0.076046, 0.000000>
   component 1.000000, 0.224245, <0.197628, 0.730038, 0.000000>
   component 1.000000, 0.132027, <0.167224, 1.019011, 0.000000>
   component 1.000000, 0.132027, <0.167224, 0.942966, 0.000000>
   component 1.000000, 0.132027, <0.836120, 0.623574, 0.000000>
   component 1.000000, 0.132027, <1.398601, 0.714829, 0.000000>
   component 1.000000, 0.132027, <1.474612, 0.669201, 0.000000>
   component 1.000000, 0.132027, <1.550623, 0.669201, 0.000000>
   component 1.000000, 0.132027, <1.200973, 2.159695, 0.000000>

   component 1.000000, 0.488815, <-0.9, -3.75, 3.0>
   component 1.000000, 0.293155, <0.7, -0.14, 0.0>
   component 1.000000, 0.293155, <0.5, -0.14, 0.0>
   component 1.000000, 0.293155, <0.9, -0.14, 0.0>

   cylinder{<-0.9, -3.75, 2.800>, <0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.7, -3.75, 2.800>, <0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.5, -3.75, 2.800>, <0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.3, -3.75, 2.800>, <0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<-0.9, -3.625, 3.000>, <0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.6, -3.625, 3.000>, <0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.3, -3.625, 3.000>, <0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<-0.9, -3.5, 3.000>, <0.5, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.6, -3.5, 3.000>, <0.7, -0.14, 0.0>, 0.35, 1.0}
   cylinder{<-0.3, -3.5, 3.000>, <0.9, -0.14, 0.0>, 0.35, 1.0}

   cylinder{<-0.6, -3.45, 3.000>, <0.7, -0.14, 0.0>, 0.35, 1.0}
   sphere{<-0.6, -3.4, 3.000>,0.5,1.0}
  }
//  cone{<0.7,0.6,0>,0.125,<0.7,0.6,-100>,3 pigment{color rgbt<1, 1, 1, 1>}
//   halo{emitting cylindrical_mapping linear turbulence 1.5
//   color_map {
//    [ 0.0 color rgbt <1, 0, 0,  1> ]
//    [ 0.5 color rgbt <1, 1, 0, 0.75> ]
//    [ 1.0 color rgbt <1, 0, 0,  1> ]
//   }
//   frequency 2 samples 20 scale<50,50,75> translate<0,0,50>}
//   hollow
//  }

 }
}

#declare being=object{
 union{
  object{full_head texture{skin}}
  object{hand_1 texture{skin} scale 2.8 translate<11.5,0,-5>}
  object{hand_2 texture{skin} scale 2.8 translate<-11.5,4.5,-5.5>}
 }
}

#declare bird_1=object{
union{
 blob{
  threshold 0.6
  sphere{<0,0,0>,18,1.0}
  sphere{<-7,7,0>,8,1.0}
  sphere{<8,2,0>,3,1.0}
  sphere{<10,3,0>,2,1.0}
  pigment{Orange} finish{phong 1.0}
 }
 union{
  sphere{<-10,7,-3>,1.5}
  sphere{<-10,7,3>,1.5}
  pigment{Black} finish{phong 1.0}
 }
 cone{<-7,7,0>,2,<-22,2,0>,0 pigment{Yellow}}
 cone{<-7,7,0>,2,<-15,-2,0>,0 pigment{Red}}
 cone{<-7,7,0>,2,<-15,-4,0>,0 pigment{Yellow}}
 cylinder{<0,-15,-17>,<0,-15,17>,0.7 pigment{NewTan}}
 torus{0.95,0.5 rotate x*90 translate<0,-15,-15> texture{Aluminum}}
 torus{0.95,0.5 rotate x*90 translate<0,-15,15> texture{Aluminum}}

 union{
  torus{2,0.5 rotate z*90 translate y*17}
  torus{2,0.5 rotate x*140 rotate z*90 translate y*20}
  torus{2,0.5 rotate x*190 rotate z*90 translate y*23}
  torus{2,0.5 rotate x*240 rotate z*90 translate y*26}
  torus{2,0.5 rotate x*290 rotate z*90 translate y*29}
  torus{2,0.5 rotate x*340 rotate z*90 translate y*32}
  torus{2,0.5 rotate x*390 rotate z*90 translate y*35}
  torus{2,0.5 rotate x*440 rotate z*90 translate y*38}
  torus{2,0.5 rotate x*490 rotate z*90 translate y*41}
  texture{Aluminum}
 }

 difference{
  torus{15,0.5}
  box{<0,100,100>,<-100,-100,-100>}
  rotate z*90
  texture{Aluminum}
 }
 cylinder{<0,0,-15>,<0,-15,-15>,0.5 texture{Aluminum}}
 cylinder{<0,0,15>,<0,-15,15>,0.5 texture{Aluminum}}
 union{
  cylinder{<8,-10,4>,<0,-15,4>,0.65}
  cylinder{<8,-10,-4>,<0,-15,-4>,0.65}

  cylinder{<8,-10,4>,<0,-5,4>,0.65}
  cylinder{<8,-10,-4>,<0,-5,-4>,0.65}

  sphere{<0,-15,-4>,1.35}
  sphere{<0,-15,4>,1.35}
  pigment{Red}
 }
// rotate y*-25
 }
}

#declare cage_1=object{
 union{
   object{bird_1 scale 1.25 rotate y*-18}
  union{
   #declare cage_curve=5.0
   cylinder{<-40,-58,-20>,<-40,-35,-20>,cage_curve}
   cylinder{<-40,-58,20>,<-40,-35,20>,cage_curve}
   cylinder{<40,-58,-20>,<40,-35,-20>,cage_curve}
   cylinder{<40,-58,20>,<40,-35,20>,cage_curve}
   box{<-40,-58,-20>,<40,-35,-20-cage_curve>}
   box{<-40,-58,20>,<40,-35,20+cage_curve>}
   box{<-40,-58,-20>,<-40-cage_curve,-35,20>}
   box{<40,-58,-20>,<40+cage_curve,-35,20>}

   union{
    #declare pole_rad=0.5
    #declare pole_trans=40
    cylinder{<39,-55,-19>,<39,40,-19>,pole_rad}
    #while(pole_trans>-40)
     #declare pole_trans=pole_trans-5
     cylinder{<pole_trans,-55,-19>,<pole_trans,40,-19>,pole_rad}
    #end
    cylinder{<-39,-55,-19>,<-39,40,-19>,pole_rad}

    #declare pole_trans=40
    cylinder{<39,-55,19>,<39,40,19>,pole_rad}
    #while(pole_trans>-40)
     #declare pole_trans=pole_trans-5
     cylinder{<pole_trans,-55,19>,<pole_trans,40,19>,pole_rad}
    #end
    cylinder{<-39,-55,19>,<-39,40,19>,pole_rad}

    #declare pole_trans=20
    #while(pole_trans>-20)
     #declare pole_trans=pole_trans-5
     cylinder{<-39,-55,pole_trans>,<-39,40,pole_trans>,pole_rad}
    #end

    #declare pole_trans=20
    #while(pole_trans>-20)
     #declare pole_trans=pole_trans-5
     cylinder{<39,-55,pole_trans>,<39,40,pole_trans>,pole_rad}
    #end
    texture{Aluminum}
   }

   cylinder{<-40,30,-20>,<-40,50,-20>,cage_curve}
   cylinder{<-40,30,20>,<-40,50,20>,cage_curve}
   cylinder{<40,30,-20>,<40,50,-20>,cage_curve}
   cylinder{<40,30,20>,<40,50,20>,cage_curve}
   box{<-40,30,-20>,<40,50,-20-cage_curve>}
   box{<-40,30,20>,<40,50,20+cage_curve>}
   box{<-40,30,-20>,<-40-cage_curve,50,20>}
   box{<40,30,-20>,<40+cage_curve,50,20>}

   texture{Aluminum normal{dents 0.6 scale 5}}
  }
  rotate y*0
 }
}

#declare support=object{
 union{
  box{<0,0,-0.75>,<-0.125,-1,-0.25> rotate z*45 translate<1.9,0,0> texture{shelf_tex rotate z*200}}
 }
}

#declare pot1=object{
 union{
  sor{5,<0.0, 0.0> <0.3,0.0> <0.5,0.5> <0.4,0.8> <0.0, 0.0> open sturm}
  torus{0.4, 0.025 translate y*0.8}
 }
}
#declare R1=seed(131)

#declare shelf_obj=object{
 union{
  union{//***horiz shelf boards
   box{<-2.495,0,-0.75>,<2.495,-0.125,1>}
   box{<-2.495,0,-0.75>,<2.495,-0.125,1> translate y*2}
   box{<-2.495,0,-0.75>,<2.495,-0.125,1> translate y*4}
   texture{shelf_tex rotate y*90}
  }//***end of horiz shelf boards
  union{//***vert shelf boards
   box{<-2.5,-2,-0.75>,<-2.625,4.25,1>}
   box{<2.5,-2,-0.75>,<2.625,4.25,1>}
   texture{shelf_tex rotate x*90}
  }//***end of vert shelf boards
  difference{	//***knots
   union{
    cylinder{<100,3,0>,<-100,3,0>,0.125 rotate z*-10}
    cylinder{<100,1.5,0.25>,<-100,1.5,0.25>,0.1}
    cylinder{<100,1,-0.25>,<-100,1,-0.25>,0.12 rotate z*-5}
   }
   box{<2.499,-20,-0.75>,<-100,20,1>}
   box{<100,-20,-0.75>,<2.626,20,1>}
   texture{knot_tex}
  }				//***end of knots
  object{support translate<0,0,0.1>}
  object{support translate<0,2,0.15>}
  object{support translate<0,4,0.075>}
  object{support translate<0,0,0.9>}
  object{support translate<0,2,0.875>}
  object{support translate<0,4,0.95>}
  union{
   object{support translate<0,0,0.05>}
   object{support translate<0,2,0.1>}
   object{support translate<0,4,0.15>}
   object{support translate<0,0,0.925>}
   object{support translate<0,2,0.95>}
   object{support translate<0,4,0.875>}
   rotate y*180
  }
 }
}

#declare rook=object{
 union{
  cylinder{<0,0,0>,<0,2,0>,2.5}
  torus{2.5,0.125 translate<0,0.125,0>}
  torus{2.5,0.125 translate<0,1.875,0>}
  cone{<0,2,0>,2.5,<0,3,0>,1.5}
  cylinder{<0,3,0>,<0,8,0>,1.5}
  cone{<0,8,0>,1.5,<0,9,0>,2}
  difference{
   cylinder{<0,9,0>,<0,11,0>,2}
   cylinder{<0,9,0>,<0,15,0>,1.75}
   #declare y_rot=0
   #while(y_rot<360)
    box{<-10,10,0.5>,<0,15,-0.5> rotate y*y_rot}
    #declare y_rot=y_rot+60
   #end
  }
  #declare y_rot=0
  #while(y_rot<360)
   sphere{<-2.5,1,0>,0.25 rotate y*y_rot texture{Ruby_Glass}}
   #declare y_rot=y_rot+40
  #end
 }
}

#declare pawn=object{
 union{
  cylinder{<0,0,0>,<0,2,0>,2}
  torus{2,0.125 translate<0,0.125,0>}
  torus{2,0.125 translate<0,1.875,0>}
  cone{<0,2,0>,2,<0,3,0>,1.5}
  cone{<0,3,0>,1.5,<0,7,0>,1}
  sphere{<0,7,0>,1}
  sphere{<0,8.25,0>,0.5}
  #declare y_rot=0
  #while(y_rot<360)
   sphere{<-2,1,0>,0.25 rotate y*y_rot texture{Ruby_Glass}}
   #declare y_rot=y_rot+40
  #end
 }
}

//*** Main scene ****
#if(pots=1)
 union{
 #declare pot_trans=-4
 #while(pot_trans<=4)
  object{pot1 translate<pot_trans+((rand(R1)*0.5)-0.25),0,(rand(R1)*1)-0.5> scale <0.5,(rand(R1)*0.5)+0.5,0.5> pigment{color red 0.556863+((rand(R1)*0.1)-0.05) green 0.137255+((rand(R1)*0.1)-0.05) blue 0.137255+((rand(R1)*0.1)-0.05)} finish{ ambient 0.125 diffuse 0.75 crand 0.01975}}
  #declare pot_trans=pot_trans+1.25
 #end
 }
 union{
 #declare pot_trans=-4
 #while(pot_trans<=4)
  object{pot1 translate<pot_trans+((rand(R1)*0.5)-0.25),0,(rand(R1)*1)-0.5> scale <0.5,(rand(R1)*0.5)+0.5,0.5> pigment{color red 0.556863+((rand(R1)*0.1)-0.05) green 0.137255+((rand(R1)*0.1)-0.05) blue 0.137255+((rand(R1)*0.1)-0.05)} finish{ ambient 0.225 diffuse 0.75 crand 0.01975}}
  #declare pot_trans=pot_trans+1.25
 #end
 translate y*2
 }
 union{
 #declare pot_trans=-4
 #while(pot_trans<=4)
  object{pot1 translate<pot_trans+((rand(R1)*0.5)-0.25),0,(rand(R1)*1)-0.5> scale <0.5,(rand(R1)*0.5)+0.5,0.5> pigment{color red 0.556863+((rand(R1)*0.1)-0.05) green 0.137255+((rand(R1)*0.1)-0.05) blue 0.137255+((rand(R1)*0.1)-0.05)} finish{ ambient 0.225 diffuse 0.75 crand 0.01975}}
  #declare pot_trans=pot_trans+1.25
 #end
 translate y*4
 }
#end

#if(shelf=1)
 object{shelf_obj translate<-5.7,0,-0.25>}
 object{shelf_obj translate<0,0,-0.25>}
 object{shelf_obj translate<6,0,-0.25>}
#end

#if(walls=1)
 difference{
  box{<-100,-100,3>,<100,100,1.1>}
  cylinder{<8,6,-100>,<8,6,100>,2}
  box{<6,6,-100>,<10,4,100>}

  texture{Wall_Tex}
 }
 difference{
  torus{2,0.5 rotate x*90 translate<8,6,1.6>}
  box{<-100,-100,-100>,<100,6,100>}
  texture{Wall_Tex}
 }
 difference{
  torus{2,0.5 rotate x*90 translate<8,6,2.5>}
  box{<-100,-100,-100>,<100,6,100>}
  texture{Wall_Tex}
 }

 difference{
  box{<-100,6,2.5>,<100,100,1.6>} //***
  cylinder{<8,6,-100>,<8,6,100>,1.5}
  texture{Wall_Tex}
 }

 union{
  box{<9.5,100,2.5>,<100,-100,1.6>}
  box{<6.5,100,2.5>,<-100,-100,1.6>}
  texture{Wall_Tex}
 }

 union{
  cylinder{<6,6,1.6>,<6,4,1.6>,0.5}
  cylinder{<10,6,1.6>,<10,4,1.6>,0.5}
  cylinder{<6,4,1.6>,<10,4,1.6>,0.5}
  cylinder{<6,6,2.5>,<6,4,2.5>,0.5}
  cylinder{<10,6,2.5>,<10,4,2.5>,0.5}
  cylinder{<6,4,2.5>,<10,4,2.5>,0.5}
  texture{Wall_Tex}
 }

 box{<-100,-100,-40>,<100,100,-100> texture{Wall_Tex}}
 box{<-40,-100,-100>,<-100,100,100> texture{Wall_Tex}}
 box{<40,-100,-100>,<100,100,2> texture{Wall_Tex}}
 box{<-100,20,-100>,<100,100,3> texture{Wall_Tex}} //*** ceiling
 box{<-100,-100,-100>,<100,-2,100> texture{floor_tex}}
 cylinder{<-100,-2,1.1>,<100,-2,1.1>,0.25 texture{Wall_Tex}}
#end

#if(cage=1)
 object{cage_1 scale 0.025 rotate y*0 translate<5.2,5.4,0>}
#end


 union{
  #if(being_obj=1)
  object{being scale 0.08}
  #end
  #if(flash=1)
  merge{
   sphere{<0,0.6,0>,0.9}
   cone{<0,0.6,1>,0.5,<0,0.6,2>,0}
   scale z*2 translate z*-4 hollow no_shadow 	texture{flash_tex_1 scale 0.25 translate z*-10}
   												texture{flash_tex_1 scale 0.25 translate z*-5}
   												//texture{flash_tex_2}
  }
   sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      glowing
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <1, 1, 0, 0.25> ]
        [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale<1,1,2>
	translate<0,0.6,-4.5>
  }

  light_source
   {0*x color rgb<1.0,1.0,0.3> area_light <3,0,0> <0,0,3>
   4,4 adaptive 0 jitter
   translate<0,0.6,-4>
  }
  #end
  rotate y*-40
  translate<-2,2.5,-4.5>
 }
//box{<-2,-2,-2>,<2,0,2> rotate y*16 translate<-2,0.5,-7> texture{T_Chrome_1A}}

#if(stars=1)
 box{<-10000,-10000,100>,<10000,10000,101> texture{Starfield scale 75}}
#end

object{pot1 translate<7.5,-2,-0.5> pigment{color red 0.556863+((rand(R1)*0.1)-0.05) green 0.137255+((rand(R1)*0.1)-0.05) blue 0.137255+((rand(R1)*0.1)-0.05)} finish{ ambient 0.125 diffuse 0.75 crand 0.01975}}

//object{wooden_box scale<0.1,0.05,0.05> rotate y*150 translate<-4.25,2,0>}

#if(chess=1)
 object{rook scale 0.05 translate<-4,0,-0.65> texture{T_Stone23 finish{Phong_Shiny}}}
 object{pawn scale 0.05 translate<-4.35,0,-0.25> texture{T_Stone23 finish{Phong_Shiny}}}
 object{pawn scale 0.05 translate<-1.875,4,-0.75> texture{T_Stone23 finish{Phong_Shiny}}}
#end


#if(books=1)
 object{book scale 0.11 rotate z*80 translate<2.05,2.165,-0.75> pigment{SteelBlue}}
 object{book scale 0.11 rotate y*13 translate<4,2.2,-0.75> pigment{Blue}}
 object{book scale 0.11 rotate z*-23 translate<5,2.575,-0.75> pigment{DarkGreen}}
#end

 #declare pot_trans=5.5
 #while(pot_trans<=11)
  object{pot1 translate<pot_trans+((rand(R1)*0.5)-0.25),0,(rand(R1)*1)-0.5> scale <0.75,(rand(R1)*0.5)+0.5,0.5> texture{pigment{Black}} texture{T_Crack4 finish{Phong_Shiny}}}
  #declare pot_trans=pot_trans+1.25
 #end

object{pot1 translate<-5.75,2.6,-0.25> scale <0.75,(rand(R1)*0.5)+0.5,0.5> texture{pigment{Black}} texture{T_Crack4 finish{Phong_Shiny}}}
