// Circol.inc
// by Alan Grover
// (c) 1997

#declare CircularColumns = union {
	#declare AngleStep = ( 360/NumberOfColumns )
	#ifdef ( InnerRadius )
	#declare Unit = ( 1/3 * ( 2 * pi * InnerRadius )/( NumberOfColumns ) )
		#declare OuterRadius = InnerRadius + 1.5 * Unit
	#else
		#declare InnerRadius = OuterRadius/( 1 + ( 1.5 * 2/3 * pi )/NumberOfColumns )
		#declare Unit = ( 1/3 * ( 2 * pi * InnerRadius )/( NumberOfColumns ) )
	#end
	difference {
		
		cylinder {
			< 0, Top, 0 >,
			< 0, Top - ( 2/5 * ( Top - Bottom ) ), 0 >,
			OuterRadius
			texture { TopTexture }
		}
		cylinder {
			< 0, Top + ( .001 * ( Top - Bottom ) ), 0 >,
			< 0, Top - ( 2.001/5 * ( Top - Bottom ) ), 0 >,
			InnerRadius
			texture { TopTexture }
		}	
		torus {
			InnerRadius, ( .25 * Unit )
			scale < 1, ( .3 * ( Top - Bottom )/( .25 * Unit ) ), 1 >
			translate < 0, Top - ( 2/5 * ( Top - Bottom ) ), 0 > 
			texture { OuterArchTexture }
		}
		torus {
			OuterRadius, ( .25 * Unit )
			scale < 1, ( .3 * ( Top - Bottom )/( .25 * Unit ) ), 1 >
			translate < 0, Top - ( 2/5 * ( Top - Bottom ) ), 0 > 
			texture { OuterArchTexture }
		}
		#declare Count = 0
		#while ( Count < NumberOfColumns )
			cylinder {
				< 0, 0, ( InnerRadius - ( OuterRadius - InnerRadius ) ) >,
				< 0, 0, ( OuterRadius + ( OuterRadius - InnerRadius ) ) >,
				1
				scale < 1, ( .3 * ( Top - Bottom ) ), 1 >
				scale < Unit, 1, 1 >
				translate < 0, Top - ( 2/5 * ( Top - Bottom ) ), 0 >
				rotate < 0, AngleStep * Count, 0 >
				texture { InnerArchTexture }
			}
		#declare Count = Count + 1
		#end		   
	}
	#declare Count = 0
/*	#while ( Count < NumberOfColumns )
		light_source {
			< 0, 0, 0 >	
			color Orange
			spotlight
			point_at < 0, -1, 0>
			radius 30
			falloff	45
			//fade_distance ( Top - Bottom )/2
			//fade_power 1
			rotate < -30, 0, 0 >
			translate < 0, Top - ( 1/5 * ( Top - Bottom ) ), OuterRadius + ( OuterRadius - InnerRadius )/4 >
			rotate < 0, AngleStep * Count, 0 >
		} 
	#declare Count = Count + 1
	#end   */
	#declare Count = -0.5
	#while ( Count < NumberOfColumns )
		cylinder {
			< 0, Top - ( 2/5 * ( Top - Bottom ) ), ( InnerRadius + ( OuterRadius - InnerRadius )/2 ) >,
			< 0, Bottom, ( InnerRadius + ( OuterRadius - InnerRadius )/2 ) >,
			( .4 * Unit )
			rotate < 0, AngleStep * Count, 0 >
			texture { ColumnTexture }
		}
		torus {
			( .4 * Unit ), ( .09 * Unit )
			translate < 0, Top - ( 2/5 * ( Top - Bottom ) ), ( InnerRadius + ( OuterRadius - InnerRadius )/2 ) >
			rotate < 0, AngleStep * Count, 0 >
			texture { CapitalTexture }
		}
		torus {
			( .4 * Unit ), ( .2 * Unit )
			translate < 0, Bottom, ( InnerRadius + ( OuterRadius - InnerRadius )/2 ) >
			rotate < 0, AngleStep * Count, 0 >
			texture { CapitalTexture }
		}
		torus {
			( .4 * Unit ), ( .07 * Unit )
			translate < 0, Bottom + ( .2 * Unit ), ( InnerRadius + ( OuterRadius - InnerRadius )/2 ) >
			rotate < 0, AngleStep * Count, 0 >
			texture { CapitalTexture }
		}
		cylinder {
			< OuterRadius, Top - .2 * Unit, 0 >,
			< 10e10 * OuterRadius, Top - .2 * Unit, 0 >,
			.2 * Unit
			rotate < 0, AngleStep * Count, 0 >
		}
	#declare Count = Count + 1
	#end
		
}
