
static define glowing
surface {
   ambient 0.8
   diffuse 0.3
   specular 0.3
   microfacet Gaussian 9
   }

static define glowing_red texture { glowing { color <1, 0.12, 0.12> } }
static define glowing_green texture { glowing { color <0.2, 1, 0.2> } }
static define glowing_yellow texture { glowing { color <1, 0.9, 0.2> } }

define silver
texture { reflective { color grey } }

define computer
object {
     object { 
      box <-8, 0, 0>, <8, 33, 3> }
   - object { // cutout for power switch
      box <3, 19.5, -1>, <6.5, 23, 1> }
   + object { // front grille
      box <-4, 0.5, -0.5>, <-3, 13.5, 0> }
   + object {
      box <-2.25, 0.5, -0.5>, <-1.75, 13.5, 0> }
   + object {
      box <-1.25, 0.5, -0.5>, <-0.75, 13.5, 0> }
   + object {
      box <-0.25, 0.5, -0.5>, <0.25, 13.5, 0> }
   + object {
      box <0.75, 0.5, -0.5>, <1.25, 13.5, 0> }
   + object {
      box <1.75, 0.5, -0.5>, <2.25, 13.5, 0> }
   + object {
      box <4, 0.5, -0.5>, <3, 13.5, 0> }
   + object {
      box <-7, 11.5, -0.5>, <-4.5, 15, 0> }
   + object {
      box <7, 11.5, -0.5>, <4.5, 15, 0> }
   + object {
        object {
         box <-7, 14.5, -0.5>, <7, 33, 0> }
         - object {
            box <-6.7, 15, -1>, <6.7, 18.5, -0.4>
            texture { shiny { color <0.3, 0.6, 0.2> } }
            }
         - object {
            box <-6.5, 15.3, -1>, <-4, 18, -0.3>
            matte_yellow }
         - object { // lights
            sphere <-3, 18, -0.4>, 0.2 }
         - object {
            sphere <0, 18, -0.4>, 0.2 }
         - object {
            sphere <3, 18, -0.4>, 0.2 }
         - object { // buttons
            sphere <0, 16, -0.4>, 0.7 }
         - object {
            sphere <3, 16, -0.4>, 0.7 }
         - object { // kbd lock
            sphere <4.7, 16.5, -0.3>, 0.6 }
         - object { // power switch
            box <3, 19.5, -1>, <6.5, 23, 1> }
         - object {
            box <-6.7, 21, -1>, <2.5, 23.5, 2> }
         - object {
            box <-6.7, 23.5, -1>, <6.7, 28, 2> }
      + object {
         box <-3.5, 15.2, -0.39>, <-1, 18.5, 0> glowing_green }
      + object {
         box <-1, 17.5, -0.39>, <1, 18.5, 0> glowing_yellow }
      + object {
         box <1, 17.5, -0.39>, <4, 18.5, 0> glowing_red }
      + object { // buttons
         sphere <0, 16, -1.7>, 0.7
         scale <1, 1, 0.2>
         }
      + object {
         sphere <3, 16, -1.7>, 0.7
         scale <1, 1, 0.2>
         }
      + object { // kbd lock
         cylinder <4.7, 16.5, -0.5>, <4.7, 16.5, 0>, 0.5
         silver
         }
      + object {
         disc <4.7, 16.5, -0.5>, <0, 0, 1>, 0.5
         silver
         }
      + object { // power switch
         box <3.5, 20, 0.5>, <6, 22.5, 1>
         texture { shiny { color grey } } }
      + object {
         box <-1, -1, -0.5>, <1, 1, 0.5>
         rotate <20, 0, 0>
         translate <4.75, 21.25, 0.5>
         texture { shiny { color grey } } }
      + object { // disc drive
           object {
            box <-4.5, -1.5, 0>, <4.55, 1, 1> }
         - object {
              object {
               box <-4.2, 0, -0.1>, <4.2, 0.5, 1> }
            + object {
               box <-1.5, -1, -1>, <1.5, 0.8, 0.2>
               rotate <35, 0, 0> }
            + object {
               box <-2.5, -1, -0.1>, <-2, -0.8, 0.5> }
            }
         + object {
            box <2.5, -1.2, -0.5>, <3.5, -0.7, 1> }
         translate <-2.1, 22.5, -0.5>
         }
      + object { // CD-ROM
           object {
            box <-6.65, 23.53, -0.5>, <6.67, 27.97, 1> }
         - object {
              object {
               box <-6, 26, -1>, <6, 27.5, -0.2> }
            + object {
               sphere <-5, 24.5, -0.5>, 0.3 }
            +  object {
               box <-3.5, 24.5, -1>, <-1.5, 25, 1> }
            }
         + object {
            box <-5.8, 26.2, -0.5>, <5.8, 27.3, -0.2> }
         + object {
            cylinder <-5, 24.5, -0.5>, <-5, 24.5, 0>, 0.25
            shiny_black }
         + object {
            disc <-5, 24.5, -0.3>, <0, 0, 1>, 0.2 
            shiny_black }
         + object {
            cylinder <-2.5, 24.5, 0.9>, <-2.5, 25, 0.9>, 1.5 
            matte_grey }
         + object {
            box <3.5, 24.5, -0.7>, <5.5, 25, 1> 
            matte_grey }
         }
      }
   + object {
      box <-8, 0, 3.05>, <8, 33, 40> }
   }

define m_button
object {
     object {
      sphere <0, 0, -0.8>, 0.3
      scale <1, 1, 0.25>
      }
   + object {
      cylinder <0, 0, -0.25>, <0, 0, 1>, 0.3 }
   }

define monitor
object {
     object {
      box <0, 2.5, 0>, <36, 32, 9> }
   - object {
      box <4, 6, -1>, <32, 29, 2> }
   + object {
      polygon 4, <0, 0, 0>, <1, 0, 0>, <1, 1, 0>, <0, 1, 0>
      texture {
         special surface {
            color planar_imagemap(image("screen.gif"), <u, 0, v>)
            ambient 0.5
            diffuse 0.2
            }
         }
      scale <28, 23, 1>
      translate <4, 6, 1>
      }
   + (object {
      box <4, 0, 0>, <32, 5, 35> }
   - object {
      box <26, 1, -1>, <26.3, 2, 1> })
   + object {
      box <26, 1, 0.05>, <26.3, 2, 1>
      glowing_green
      }
   + object {
      polygon 4, <2, 3, 9>, <34, 3, 9>, <31, 5, 45>, <5, 5, 45> }
   + object {
      polygon 4, <2, 30, 9>, <34, 30, 9>, <31, 26, 45>, <5, 26, 45> }
   + object {
      polygon 4, <2, 30, 9>, <2, 3, 9>, <5, 5, 45>, <5, 26, 45> }
   + object {
      polygon 4, <34, 30, 9>, <34, 3, 9>, <31, 5, 45>, <31, 26, 45> }
   + object {
      polygon 4, <5, 26, 45>, <31, 26, 45>, <31, 5, 45>, <5, 5, 45> }
   + object {
      parabola <18, 10, 25>, <18, 10, 8>, 18
      scale <1, 3, 1>
      }
   * object {
      box <0, -10, -5>, <36, 0, 20>
      rotate <5, 0, 0>
      translate <0, 32, 9>
      }
   + m_button { translate <9, 1, 0> }
   + m_button { translate <10.5, 1, 0> }
   + m_button { translate <12, 1, 0> }
   + m_button { translate <13.5, 1, 0> }
   + m_button { translate <20, 1, 0> }
   + m_button { translate <21.5, 1, 0> }
   + m_button { translate <23, 1, 0> }
   + m_button { translate <24.5, 1, 0> }
   }

define key
object {
     object {
      superq 0.8, 0.25
      rotate <90, 0, 0>
      }
   * object {
      box <-1, 0.4, -1>, <1, 0.8, 1> }
   scale <1, 2.4, 1>
   }

define keyboard
object {
     object {
      box <0.5, 0, 0.5>, <48, 2, 16> }
   + object {
      box <0, 0.5, 0>, <48.5, 2.2, 16.5>
      rotate <-10, 0, 0> }
   // First row of keys
   + key { translate <2, 1.4, 2.5> matte_grey } //Ctrl
   + key { translate <2.9, 1.4, 2.5> matte_grey }
   + key { translate <7, 1.4, 2.5> matte_grey } //Alt
   + key { translate <7.9, 1.4, 2.5> matte_grey }
   + key { translate <9.9, 1.4, 2.5> } //Space
   + key { translate <11, 1.4, 2.5> }
   + key { translate <12, 1.4, 2.5> }
   + key { translate <13, 1.4, 2.5> }
   + key { translate <14, 1.4, 2.5> }
   + key { translate <15, 1.4, 2.5> }
   + key { translate <16, 1.4, 2.5> }
   + key { translate <17, 1.4, 2.5> }
   + key { translate <18, 1.4, 2.5> }
   + key { translate <19, 1.4, 2.5> }
   + key { translate <20, 1.4, 2.5> }
   + key { translate <21, 1.4, 2.5> }
   + key { translate <23, 1.4, 2.5> matte_grey } //Alt Gr
   + key { translate <23.9, 1.4, 2.5> matte_grey }
   + key { translate <28.1, 1.4, 2.5> matte_grey } //Ctrl
   + key { translate <30, 1.4, 2.5> matte_grey }
   + key { translate <33, 1.4, 2.5> matte_grey } //Left
   + key { translate <35, 1.4, 2.5> matte_grey } //Down
   + key { translate <37, 1.4, 2.5> matte_grey } //Right
   + key { translate <40, 1.4, 2.5> } //0
   + key { translate <41, 1.4, 2.5> }
   + key { translate <42, 1.4, 2.5> }
   + key { translate <44, 1.4, 2.5> } //.
   + key { translate <46, 1.2, 2.5> rotate <-5, 0, 0> matte_grey } //Enter
   + key { translate <46, 1.2, 3.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <46, 1.2, 4.5> rotate <-5, 0, 0> matte_grey }
   // Second row of keys
   + key { translate <2, 1.8, 4.5> matte_grey } //Shift
   + key { translate <2.5, 1.8, 4.5> matte_grey }
   + key { translate <4.5, 1.8, 4.5> } //<
   + key { translate <6.5, 1.8, 4.5> } //Z
   + key { translate <8.5, 1.8, 4.5> } //X
   + key { translate <10.5, 1.8, 4.5> } //C
   + key { translate <12.5, 1.8, 4.5> } //V
   + key { translate <14.5, 1.8, 4.5> } //B
   + key { translate <16.5, 1.8, 4.5> } //N
   + key { translate <18.5, 1.8, 4.5> } //M
   + key { translate <20.5, 1.8, 4.5> } //,
   + key { translate <22.5, 1.8, 4.5> } //.
   + key { translate <24.5, 1.8, 4.5> } //-
   + key { translate <26.5, 1.8, 4.5> matte_grey } //Shift
   + key { translate <27.5, 1.8, 4.5> matte_grey} 
   + key { translate <28, 1.8, 4.5> matte_grey }
   + key { translate <30, 1.8, 4.5> matte_grey } //turbo
   + key { translate <35, 1.8, 4.5> matte_grey } //Up
   + key { translate <40, 1.8, 4.5> } //1
   + key { translate <42, 1.8, 4.5> } //2
   + key { translate <44, 1.8, 4.5> } //3
   // Third row of keys
   + key { translate <2, 2.2, 6.5> matte_grey } //Caps Lock
   + key { translate <3, 2.2, 6.5> matte_grey }
   + key { translate <3.5, 2.2, 6.5> matte_grey }
   + key { translate <5.5, 2.2, 6.5> } //A
   + key { translate <7.5, 2.2, 6.5> } //S
   + key { translate <9.5, 2.2, 6.5> } //D
   + key { translate <11.5, 2.2, 6.5> } //F
   + key { translate <13.5, 2.2, 6.5> } //G
   + key { translate <15.5, 2.2, 6.5> } //H
   + key { translate <17.5, 2.2, 6.5> } //J
   + key { translate <19.5, 2.2, 6.5> } //K
   + key { translate <21.5, 2.2, 6.5> } //L
   + key { translate <23.5, 2.2, 6.5> } //
   + key { translate <25.5, 2.2, 6.5> } //
   + key { translate <27.5, 1.7, 6.5> rotate <-5, 0, 0> matte_grey} //Enter
   + key { translate <28.5, 1.7, 6.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <29.5, 1.7, 6.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <30, 1.7, 6.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <29, 1.7, 7.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <30, 1.7, 7.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <29, 1.7, 8.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <30, 1.7, 8.5> rotate <-5, 0, 0> matte_grey }
   + key { translate <40, 2.2, 6.5> } //4
   + key { translate <42, 2.2, 6.5> } //5
   + key { translate <44, 2.2, 6.5> } //6
   + key { translate <46, 1.4, 6.5> rotate <-7, 0, 0> matte_grey } //+
   + key { translate <46, 1.4, 7.5> rotate <-7, 0, 0> matte_grey }
   + key { translate <46, 1.4, 8.5> rotate <-7, 0, 0> matte_grey }
   // Fourth row of keys
   + key { translate <2, 2.6, 8.5> matte_grey } //Tab
   + key { translate <2.9, 2.6, 8.5> matte_grey }
   + key { translate <4.9, 2.6, 8.5> } //Q
   + key { translate <6.9, 2.6, 8.5> } //W
   + key { translate <8.9, 2.6, 8.5> } //E
   + key { translate <10.9, 2.6, 8.5> } //R
   + key { translate <12.9, 2.6, 8.5> } //T
   + key { translate <14.9, 2.6, 8.5> } //Y
   + key { translate <16.9, 2.6, 8.5> } //U
   + key { translate <18.9, 2.6, 8.5> } //I
   + key { translate <20.9, 2.6, 8.5> } //O
   + key { translate <22.9, 2.6, 8.5> } //P
   + key { translate <24.9, 2.6, 8.5> } //
   + key { translate <26.9, 2.6, 8.5> } //~
   + key { translate <33, 2.6, 8.5> matte_grey } //Delete
   + key { translate <35, 2.6, 8.5> matte_grey } //End
   + key { translate <37, 2.6, 8.5> matte_grey } //PgDown
   + key { translate <40, 2.6, 8.5> } //7
   + key { translate <42, 2.6, 8.5> } //8
   + key { translate <44, 2.6, 8.5> } //9
   // Fifth row of keys
   + key { translate <2, 3, 10.5> } //|
   + key { translate <4, 3, 10.5> } //1
   + key { translate <6, 3, 10.5> } //2
   + key { translate <8, 3, 10.5> } //3
   + key { translate <10, 3, 10.5> } //4
   + key { translate <12, 3, 10.5> } //5
   + key { translate <14, 3, 10.5> } //6
   + key { translate <16, 3, 10.5> } //7
   + key { translate <18, 3, 10.5> } //8
   + key { translate <20, 3, 10.5> } //9
   + key { translate <22, 3, 10.5> } //0
   + key { translate <24, 3, 10.5> } //+
   + key { translate <26, 3, 10.5> } //\
   + key { translate <28, 3, 10.5> } //'
   + key { translate <30, 3, 10.5> matte_grey } //BackSpace
   + key { translate <33, 3, 10.5> matte_grey } //Insert
   + key { translate <35, 3, 10.5> matte_grey } //Home
   + key { translate <37, 3, 10.5> matte_grey } //PgUp
   + key { translate <40, 3, 10.5> matte_grey } //NumLock
   + key { translate <42, 3, 10.5> matte_grey } ///
   + key { translate <44, 3, 10.5> matte_grey } //*
   + key { translate <46, 3, 10.5> matte_grey } //-
  // Top row of keys
   + key { translate <2, 3.5, 13.5> matte_grey } //Esc
   + key { translate <6, 3.5, 13.5> } //F1
   + key { translate <8, 3.5, 13.5> } //F2
   + key { translate <10, 3.5, 13.5> } //F3
   + key { translate <12, 3.5, 13.5> } //F4
   + key { translate <15, 3.5, 13.5> matte_grey } //F5
   + key { translate <17, 3.5, 13.5> matte_grey } //F6
   + key { translate <19, 3.5, 13.5> matte_grey } //F7
   + key { translate <21, 3.5, 13.5> matte_grey } //F8
   + key { translate <24, 3.5, 13.5> } //F9
   + key { translate <26, 3.5, 13.5> } //F10
   + key { translate <28, 3.5, 13.5> } //F11
   + key { translate <30, 3.5, 13.5> } //F12
   + key { translate <33, 3.5, 13.5> matte_grey } //PrintScreen
   + key { translate <35, 3.5, 13.5> matte_grey } //ScrollLock
   + key { translate <37, 3.5, 13.5> matte_grey } //Pause
   }
