// Persistence of Vision Ray Tracer Scene Description File
// File: objects.inc
// Vers: 3.0
// Desc: Misc objects
// Date: 31-08-97
// Auth: Samuel Ward

// A single column for the temple
#declare column = cylinder {
   <0,0,0>, y, 1
   scale <9.3, 50, 9.3>
   texture {
      marble1
      finish {
         crand 0.01
         ambient 0.2
         diffuse 0.8
      }
      scale <16, 4, 4>
   }
   texture {
      marble2
      scale <10, 6, 5>
      rotate -30*z
      finish { diffuse 1.0 }
   }
   texture {
      marble4
      finish {
         phong 0.6
         phong_size 45
      }
      scale <8, 15, 5>
      rotate <0, 0, 50>
   }
   rotate 10*y
}

// The entry arch
#declare Arch = union {
        difference {
          torus { 7,1
//                  pigment {color Blue}
                  rotate x*90
                  translate z*60
          }
          box { <-20,-10,30>,<20,0,70>
//                  pigment {color Blue}
          }
        }
cylinder {<0,-15,0>,<0,0,0>,1
//        pigment {color Blue}
        translate x*-7
        translate z*60
}
cylinder {<0,-15,0>,<0,0,0>,1
//        pigment {color Blue}
        translate x*7
        translate z*60
}
texture {T_Grnt18}
}

// The right hand door
#declare door = difference {
    union {
        cylinder { <0,-.5,0>,<0,.5,0>,7
            rotate x*90
        }
        box { <-7,0,.5>,<7,-20,-.5>
        }
    }
    box { <-8,20,2>,<0,-21,-2>
    }
//  pigment {color Magenta}
texture {T_Wood4 rotate x*90 finish {ambient .50} }
}

// The combined/opened doors
#declare Door = union {
    object {door translate x*-7 rotate y*35 translate x*7}
    object {door rotate y*180 translate x*7 rotate y*-35 translate x*-7}
    box { <-7,-20,-1>,<7,-9.5,1>
//        pigment {color Yellow}
    texture {T_Grnt21 scale 4}
    }
}

// The 'garden' wall
#declare Wall = difference {
box { <-400,-20,60>,<400,-5,61>
}
box { <-7,-21,59>,<7,-4,62>
}
//pigment {color Red}
texture {T_Grnt14}
translate x*20
}
