// Persistence of Vision Ray Tracer Scene Description File
// File: Temple.inc
// Vers: 3.0
// Desc: The Temple
// Date: 31-08-97
// Auth: Samuel Ward

#declare Temple = union {
// The main platform
box{ <0,0,0>,<15,5,35>
    //pigment {color Red}
    texture {My_Stone1}
    translate <-7.5,-14,0>
}// end box

// The Columns and Shrubs
#declare yup = -9
#declare const = 1.5
#declare one_on = 0
#declare num = 6
#declare My_Seed = seed(145)
#while (one_on < (num))
object {column scale 0.1
        rotate y*(rand(My_Seed)*360)
        scale <1,2,1>
        translate <6,yup,(const+(one_on*6))>}
#debug concat("On tree ",str(one_on,0,0),"A\n")
object {Shrub_Tree rotate (((rand(My_Seed)*360)+180)*y) scale 0.3
        translate <10.5,-10,(const+(one_on*6))>}
object {column scale 0.1
        rotate y*(rand(My_Seed)*360)
        scale <1,2,1>
        translate <-6,yup,(const+(one_on*6))>}
#debug concat("On tree ",str(one_on,0,0),"B\n")
object {Shrub_Tree rotate (((rand(My_Seed)*360)+180)*y) scale 0.3
        translate <-10.5,-10,(const+(one_on*6))>}
#declare one_on = one_on + 1
#end
scale 1.5
}
#declare roofA = object {
    prism {
        linear_sweep
        linear_spline
        -1, //sweep from
        36,// to
        4,// no of points
        <-8,0>,<8,0>,<0,-6>,<-8,0>
    //pigment {color Red}
    }
}
#declare roofB = object {
        prism {
        linear_sweep
        cubic_spline
        -6,
        0,
        18,
        <3,-5>,<3,5>,<-5,0>,<3,-5>,<3,5>,<-5,0>
        <2,-4>,<2,4>,<-4,0>,<2,-4>,<2,4>,<-4,0>
        <1,-3>,<1,3>,<-3,0>,<1,-3>,<1,3>,<-3,0>
        }
}

#declare roofC = object {roofA scale .75}

#declare marb = 
    texture {
       marble1
       finish {
          crand 0.01
          ambient 0.2
          diffuse 0.8
       }
       scale <16, 4, 4>
      }
      texture {
         marble2
         scale <10, 6, 5>
         rotate -30*z
         finish { diffuse 1.0 }
      }
      texture {
         marble4
         finish {
            phong 0.6
            phong_size 45
         }
         scale <8, 15, 5>
         rotate <0, 0, 50>
      }

//The Roof
#declare Roof = union {
    difference {
        object {roofA rotate x*90 scale 1.5 }
        object {roofC rotate x*90 scale 1.5 translate <0,0.95,-40>}
    texture { marb }
    }
    object {roofB rotate z*-90 rotate y*90 scale 0.55 translate <0,3.5,-1> texture {T_Grnt3}}
  translate <0,6.5,-10> // x was 0
}
