#declare Base =
union
{
	difference
	{
		cone
		{
			0,10,y*7.5,7.5
		}
		sphere
		{
			y*15,12.5
		}
		pigment { Black_Marble }
	}
	difference
	{
		union
		{
			cone
			{
				0,10.5,y*7.5,8.5
			}
			sphere
			{
				y*15,12.7
			}
			union
			{
				#declare Rib_Count = 0
				#while (Rib_Count < 4 )
					torus
					{
						12.7,.7
						rotate z*90
						rotate (22.5+(45*Rib_Count))*y
						translate y*16
					}
					#declare Rib_Count = Rib_Count+1
				#end
			}
		}
		union
		{
			sphere
			{
				y*15,12.25
			}
			box
			{
				<-13,16,-13>,<13,30,13>
			}
			union
			{
				#declare Cut_Count = 0
				#while (Cut_Count < 8)
					cylinder
					{
						<0,25,-80>,<0,25,0>,17
						scale <.25,.75,.25>
						rotate 45*Cut_Count*y
					}
					cylinder
					{
						<0,0,-20>,<0,0,-11>,5
						scale <.7,1,.7>
						rotate (22.5+45*Cut_Count)*y
					}
					#declare Cut_Count = Cut_Count + 1
				#end
			}
		}
	}
	texture {Tarnished_Brass}
}

#declare Crystal_Ball =
union
{
	object { Base }
	sphere
	{
		y*15,12.5
		pigment
		{
			White
			transmit .85
		}
		finish
		{
			specular .9 roughness 0.005 reflection .0625
		}
	}
}
