// Persistence of Vision Ray Tracer Scene Description File
// File: boogeymn.pov
// Vers: 3
// Desc: For the Internet Ray Tracing Competition
// Date: 12/29/97
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "boy.inc"
#include "boogey3.inc"
#include "popcan.inc"
#include "parquet.inc"


#declare useAreaLight= true

global_settings
{
  assumed_gamma 2.2
  max_trace_level 5     //default is five
}
// ----------------------------------------

camera{
  location  <15, 36, -25> //15, 36, -25
    direction 1.1*z
  right     4/3*x
  look_at   <18, 32, 108>
}


#declare oakMult= 2
#declare DMFLightOak2 =
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0, 0.1 color rgb <0.42, 0.26, 0.15>*oakMult
                  color rgb <0.42, 0.26, 0.15>*oakMult]
        [0.1, 0.9 color rgb <0.42, 0.26, 0.15>*oakMult
                  color rgb <0.52, 0.37, 0.26>*oakMult]
        [0.9, 1.0 color rgb <0.52, 0.37, 0.26>*oakMult
                  color rgb <0.52, 0.37, 0.26>*oakMult]
    }
}

#declare oakMult3= 1.75
#declare DMFLightOak3 =
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0, 0.1 color rgb <0.42, 0.26, 0.15>*oakMult3
                  color rgb <0.42, 0.26, 0.15>*oakMult3]
        [0.1, 0.9 color rgb <0.42, 0.26, 0.15>*oakMult3
                  color rgb <0.52, 0.37, 0.26>*oakMult3]
        [0.9, 1.0 color rgb <0.52, 0.37, 0.26>*oakMult3
                  color rgb <0.52, 0.37, 0.26>*oakMult3]
    }
}

#declare aRedWoodMult=1.2
#declare aRedWood = pigment {
  wood
  turbulence 0.05
  scale <0.2, 0.2, 1>
  color_map {
    [0.0, 0.8  color rgb <0.666, 0.312, 0.2>*aRedWoodMult
               color rgb <0.666, 0.312, 0.2>*aRedWoodMult]
    [0.8, 1.01 color rgb <0.4, 0.133, 0.066>*aRedWoodMult
               color rgb <0.2, 0.065, 0.033>*aRedWoodMult]
  }
}

#declare RedWood2Mult = 1.4
#declare RedWood2 = pigment {
  wood
  turbulence 0.05
  scale <0.2, 0.2, 1>
  color_map {
    [0.0, 0.8  color rgb <0.666, 0.312, 0.2>*RedWood2Mult
               color rgb <0.666, 0.312, 0.2>*RedWood2Mult]
    [0.8, 1.01 color rgb <0.4, 0.133, 0.066>*RedWood2Mult
               color rgb <0.2, 0.065, 0.033>*RedWood2Mult]
  }
}


#declare vertWood1 =
    pigment{aRedWood rotate<89,0,0> scale .5}

#declare lightVertWood =
    pigment{RedWood2 rotate<89,0,0> scale .5}

#declare horizWood1 =
    pigment{aRedWood rotate<0,89,0> scale .5}


#declare New_Brass2 =
texture {
    pigment { color rgb <0.70, 0.56, 0.37>*1.1 }
    finish {
        ambient 0.35
        diffuse 1.0
        brilliance 15
        phong 0.41
        phong_size 5
    }
}


#declare trimOne=
box{<0,0,0>,<1,84,1.5> pigment{vertWood1}}

#declare trimTwo=
box{<0,79,5>,<1,84,53.5> pigment{horizWood1}}

#declare trimThree=
box{<-4,0,53.5>,<0,79,53.25> pigment{vertWood1 scale<.1,1,1>}}

#declare trim4=
box{<-4,78.75,5>,<0,79,53.5> pigment{horizWood1}}

#declare latchPlate=
merge{
  difference{
    box{<-.5,-1.125,0>,<.875,1.125,.0625>}
    box{<-.375,.5,-1>,<.375,-.5,1>}
    cylinder{<0,.8125,-1>,<0,.8125,1>,0.09375}
    cylinder{<0,-.8125,-1>,<0,-.8125,1>,0.09375}
  }
  object{
    cylinder{<-2.5,0,0>,<-2.5,0,.0625>,3.55755}
    clipped_by{plane{x,.875 inverse}}
  }
  texture{New_Brass2}
}



//===================<< start wall Plug >>==================
#declare plugHole=
  difference{
    cylinder{<0,0,.5>,<0,0,-.5>,.65625  }
    object{plane {y,.5625 inverse } }
    object{plane {y,-.5625 } }
    scale <1.05,1.05,1.5>
  }


#declare onePlug=
difference{
  cylinder{<0,0,0>,<0,0,-.3125>,.65625  }
  object{plane {y,.5625 inverse } }
  object{plane {y,-.5625 } }
  cylinder{<0,-.37375,.5>,<0,-.34375,-.5>,.09375}
  box{<-.09375,-.37375,.5>,<.09375,-.46875,-.5>}
  box{<-.2,-.0625,.5>,<-.29,.3125,-.5>}
  box{<.2,-.0625,.5>,<.29,.25,-.5>}
  texture{pigment{rgb<1,1,.9>*1.5 }finish{ Shiny}}
}


#declare wallPlug=
union{
  difference{
    difference{
      superellipsoid{ <.1,.25> scale <1.375,2.25,.25>}
      object{ plane {z,0 inverse}}
    }
    object{ plugHole translate<0,.75,0> }
    object{ plugHole translate<0,-.75,0>}
    texture{pigment{rgb<1,1,.9>*1.5 }finish{ Shiny}}
  }
  object{ onePlug translate<0,.75,.0>}
  object{ onePlug translate<0,-.75,0>}
}
//===================<< end wall Plug >>==================

//===================<< begin light switch >>==================

#declare lightSwitch=
union{
  difference{
    difference{
      superellipsoid{ <.1,.25> scale <1.375,2.25,.25>}
      object{ plane {z,0 inverse}}
    }
    box{<-.1875,-.4375,-2>,<.1875,.4375,2>}
  }
  difference{
    box{<-.1875,-.4375,-.1875>,<.1875,.4375,0>}
    box{<-.1875,-.4375,-.1>,<.1875,.4375,-2> scale <.6,.85,1>}
  }
  box{<-.1,-.125,-1.00>,<.1,.125,0> rotate<-30,0,0> translate<0,0,.25> }
  texture{pigment{rgb<1,1,.9>*1.5}finish{ Shiny}}
}

//===================<< end light switch >>==================


#declare doorTrack=
merge{
  box{<-1.5,78.75,5>,<-2.5,78.6875,53.5>}
  box{<-1.5,78.75,5>,<-1.4375,78.5,53.5>}
  box{<-2.5,78.75,5>,<-2.5625,78.5,53.5>}
  texture{pigment{White} finish{Shiny}}
}

#declare leftWall=
union{
  box{<0,0,53.75>,<.75,2,108> pigment{horizWood1} }
  object{doorTrack}
  object{trimOne translate<0,0,3.5>}
  object{trimOne translate<0,0,53.5>}
  object{trimTwo}
  object{trimThree}
  object{trim4}
  difference{
    box{<0,0,0>,<-4,84,108>}
    box{<-10,-1,5>,<10,79,53.5>}
    pigment{White}
  }
}

#declare leftSideWall=
box{<0,0,0>,<-120,84,4> pigment{White}}


#declare rearWall=
union{
  box{<-40,0,-76>,<53,84,-72> pigment{White}}
  box{<-36,0,-72>,<-40,84,-36> pigment{White}}
}

#declare rightWall=
union{
  box{<48,0,60>,<47.25,84,61.5> pigment{vertWood1} }
  box{<48,0,29>,<47.25,84,27.5> pigment{vertWood1} }
  box{<48,0,60>,<53,79,59.75> pigment{lightVertWood scale<.5,1,.5> } }
  box{<49,0,59.75>,<51.5,79,59.5> pigment{vertWood1} }
  box{<47.25,0,61.5>,<48,2,108> pigment{horizWood1} }
  union{
    box{<0,.25,0>,<-30.25,78.75,-1> pigment{DMFLightOak3 rotate<89,0,0> scale<.5,2,.5> }}
    union{
      cylinder{<-27.75,36,-1>,<-27.75,36,-1.125>, 1.25}
      cylinder{<-27.75,36,-1>,<-27.75,36,-1.25>, 1.125}
      cylinder{<-27.75,36,-1>,<-27.75,36,-1.625>, .4375}
      cylinder{<-27.75,36,-1>,<-27.75,36,-2>, .375}
      cone { <-27.75,36,-2>, .75, <-27.75,36,-3.25>, 1}
      texture{
        New_Brass2
      }
    }
    rotate<0,105.5,0>
    translate<53,0,29.25>
  }
  difference{
    box{<48,0,-80>,<53,84,108>}
    box{<40,-10,60>,<55,79,29>}
    pigment{White}
  }
}

#declare backWall=
union{
  box{<46.5,0,108>,<48,60,107.25> pigment{vertWood1} }
  box{<21.5,0,108>,<23.5,60,107.25> pigment{vertWood1} }
  box{<23.5,29,108>,<46.5,33,107.3125> pigment{horizWood1} }

  box{<0,0,108>,<21.5,2,107.25> pigment{horizWood1} }

  box{<23.5,29,108>,<46.5,28.75,112> pigment{DarkBrown } }
  box{<23.5,0,108>,<23.75,28.75,112> pigment{DarkBrown } }
  box{<46.5,0,108>,<46.25,28.75,112> pigment{DarkBrown } }

  union{
    box{<-22.25-.0625,.25,0>,<-.0625,28.625,.75>
      pigment{DMFLightOak2 rotate<89,0,0> rotate<0,40,0>}
    }
    merge{
      cylinder{<-21.25,13,0>,<-21.25,13,-.5>,.25 }
      sphere{<-21.25,13,-1>,.75 }
      texture{pigment{White} finish{Shiny}}
    }
    rotate<0,-40,0>
    translate<46.1875,0,108>
  }

  difference{
    box{<0,0,108>,<100,53,112>}
    box{<46.5,0,100>,<23.5,29,120>}
    pigment{White}
  }
}

#declare backAngleWall=
box{<-4,0,0>,<100,50,4> pigment{White*.75}}

#declare ceiling=
box{<-200,84,-200>,<200,88,200> pigment{White}}

#declare louver=
box{<1,0,0.125>,<11,0,1.125>
  pigment{DMFLightOak2 rotate<0,88.5,0> scale<1,.3,1> }
  rotate<-55,0,0>
}

#declare closetDoor=
union{
  box{<0,1,0>,<1.5,77.75,1> pigment{DMFLightOak3 rotate<89,0,0> scale<.5,2,.5> }}
  box{<10.25,1,0>,<11.75,77.75,1> pigment{DMFLightOak3 rotate<89,0,0> scale<.5,2,.5> }}
  box{<1.5,74.75,0>,<10.25,77.75,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}
  box{<1.5,1,0>,<10.25,4,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}
  box{<1.5,34,0>,<10.25,36,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}
  #declare yy=74.0
  #while (yy > 35)
    object{louver translate<0,yy,0>}
    #declare yy = yy - 1.125
  #end

  #declare yy=33.65
  #while (yy > 3)
    object{louver translate<0,yy,0>}
    #declare yy = yy - 1.125
  #end
}

#declare closetDoor2=
union{
  merge{
    cylinder{<5.875,35,0>,<5.875,35,-.5>,.25 }
    sphere{<5.875,35,-1>,.75 }
    texture{pigment{White*1.25} finish{Shiny}}
  }

  union{
    box{<0,1,0>,<1.5,77.75,1> pigment{DMFLightOak3 rotate<89,0,0> scale<.5,2,.5> }}
    box{<10.25,1,0>,<11.75,77.75,1> pigment{DMFLightOak3 rotate<89,0,0> scale<.5,2,.5> }}
    box{<1.5,74.75,0>,<10.25,77.75,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}
    box{<1.5,1,0>,<10.25,4,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}
    box{<1.5,34,0>,<10.25,36,1> pigment{DMFLightOak3 rotate<0,90,0> scale<1,.5,1> }}

    #declare yy=74.0
    #while (yy > 35)
      object{louver translate<0,yy,0>}
      #declare yy = yy - 1.125
    #end

    #declare yy=33.65
    #while (yy > 3)
      object{louver translate<0,yy,0>}
      #declare yy = yy - 1.125
    #end
  }
}


#declare coverFinish=
texture {
  pigment {color rgbf <1, 1, .95,.8>}
  finish {ambient .8 diffuse .8 specular 1 roughness 0.001}
}


#declare cover=
difference{
  cone {<0,0,0>, .3125, <0,2.5,0>, 0.875 }
  cylinder{<1.1875,-2,0>, <1.1875,5,0>, 0.75}
}


#declare niteLight=
union{
  difference{
   object{cover}
    object{cover scale <.95,.985,.95>}
    plane{x,-.125}
    texture{coverFinish}
    no_shadow
  }
  merge{
    cone {<0,0,0>, .3125, <0,-.75,0>, .1437 }
    box{<0,-0.125,.25>,<-.5,-.75,-.25>}
    texture {pigment{Black} finish{Shiny}}
  }

  box{<-1.00,-.4,-.125>,<0,-.6,-.09375> texture{Soft_Silver}}
  box{<-1.00,-.4,.125>,<0,-.6,.09375> texture{Soft_Silver}}

  light_source {
    <-.25, 2, 0>
    color rgb <1.000, 1.000, 0.7>*.185

    #if (useAreaLight = true)
      area_light
      <1, 0, 0> <0, 0, 1.5>
      4, 4
      adaptive 1
      jitter
    #end
  }

  light_source{
    <8, 3, 0>                    // light's position (translated below)  2
    color rgb <1,1,.7>*.75       // light's colo
    spotlight               // this kind of light source
    point_at <-1, 2, 0>      // direction of spotlight
    radius 60            // hotspot (inner, in degrees)
    tightness 1         // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 90               // intensity falloff radius (outer, in degrees)
  }
}

#declare niteLight2=
union{
  difference{
   object{cover}
    object{cover scale <.95,.985,.95>}
    plane{x,-.125}
    texture{coverFinish}
    no_shadow
  }
  merge{
    cone {<0,0,0>, .3125, <0,-.75,0>, .1437 }
    box{<0,-0.125,.25>,<-.5,-.75,-.25>}
    texture {pigment{Black} finish{Shiny}}
  }

  box{<-1.00,-.4,-.125>,<0,-.6,-.09375> texture{Soft_Silver}}
  box{<-1.00,-.4,.125>,<0,-.6,.09375> texture{Soft_Silver}}

  light_source {
    <-.25, 2, 0>
    color rgb <1.000, 1.000, 0.7>*.24
    #if (useAreaLight = true)
      area_light
      <1, 0, 0> <0, 0, 1.5>
      4, 4
      adaptive 1
      jitter
    #end
  }

  light_source{
    <2, 3, 0>                    // light's position (translated below)
    color rgb <1,1,.7>*.75       // light's colo
    spotlight               // this kind of light source
    point_at <-1, 2, 0>      // direction of spotlight
    radius 60            // hotspot (inner, in degrees)
    tightness 1         // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 90               // intensity falloff radius (outer, in degrees)
  }
}


#declare stick=
box{<-.375,0,-7>,<.375,0.25,7>
  pigment{Brown*1.75}
}

//================<<< assemble the scene >>>======================

object{niteLight rotate<0,180,0> translate<47.0,19.25,-5>}
object{niteLight rotate<0,0,0> translate<1,19.25,70>}
object{niteLight2 rotate<0,0,0> translate<53.875,19.25,75>}
object{niteLight2 rotate<0,-90,0> translate<-0,19.5,-71>}


object{latchPlate translate<52.125,36,59.75>}
rearWall
leftSideWall
leftWall
rightWall
backWall
object{backAngleWall rotate<-30,0,0> translate<0,53,108>}
ceiling

object{wallPlug rotate<0,90,0> translate<48,18,70>}
object{wallPlug rotate<0,-90,0> translate<0,18,70>}

object{lightSwitch rotate<0,90,0> translate<48,45,70>}

object{closetDoor rotate<0,-90,0>translate<-1.5,0,5.0>}
object{closetDoor2 rotate<0,-90,0>translate<-1.375,0,17.0>}
object{closetDoor2 rotate<0,-90,0>translate<-1.5,0,29.25>}
object{closetDoor rotate<0,-90,0>translate<-1.375,0,41.25>}

object{youngBoy scale 81  rotate<0,65,0>translate<56,21.62,63.5>}
object{boogeyMan scale 78 rotate<0,0,0>translate<30,21.84,103.5>}
object{CanOfPop rotate<0,-45,0> rotate<-5,0,0> translate<0,24,25>}

// ===========< start of string for the can of pop>============
object
{
    #declare NumRots = 10
    #declare Height = 6.75
    #declare Rad = 0.1
    #declare NumCords = 3
    #declare CordRatio = 0.3
    #declare NumSegs = 70
    #declare OffsetFact = -0.5
    #declare ObjType = 1
    #declare Texture = texture { pigment{White*1.5}}
    #include "stwist.inc"
    rotate<0,0,-2.25>
    translate<0,29.375,24.75>
}

object
{
    #declare NumRots = 10
    #declare Height = 6.875
    #declare Rad = 0.10
    #declare NumCords = 3
    #declare CordRatio = 0.3
    #declare NumSegs = 70
    #declare OffsetFact = -0.5
    #declare ObjType = 1
    #declare Texture = texture { pigment{White*1.5}}
    #include "stwist.inc"
    rotate<0,0,5>
    translate<0,29.375,24.6875>
}

object
{
    #declare NumRots = 1
    #declare Height = .8125
    #declare Rad = 0.10
    #declare NumCords = 3
    #declare CordRatio = 0.3
    #declare NumSegs = 70
    #declare OffsetFact = -0.5
    #declare ObjType = 1
    #declare Texture = texture { pigment{White*1.5}}
    #include "stwist.inc"
    rotate<0,0,90>
    translate<.25,36.125,24.6875>
}
// ===========< end of string for the can of pop>============

object{stick translate<-.25,35.75,28>}


// ===========< start of floor tiles>============
#declare yy = seed(300)
#declare zz=102
#while (zz > 48)
  #declare xx=6
  #while (xx < 84)
    #declare yyRotate= rand(yy)
    #switch (yyRotate)
      #range (0,.25)
        #declare yRotate=0
      #break  //Third case ends
      #range (.25999,.50)
        #declare yRotate= 90
      #break
      #range (.50999,.75)
        #declare yRotate= 180
      #break
      #range (.75999,1.0)
        #declare yRotate= 270
      #break
      #else
        #declare yRotate= 0
    #end
    object{parquetSquare rotate<0,yRotate,0> translate<xx,0,zz>}
    #declare xx=xx+12
  #end
  #declare zz=zz-12
#end
// ===========< end of floor tiles>============


//output_to_file=on +b1024 +QR +A0.1
// +SRnn  +SCnn  EC & ER
