#include "colors.inc"
#include "woods.inc"

// define the flooring area
#declare x_start = -30
#declare x_finish = 40
#declare y_start = -30
#declare y_finish = 40

// the floor texture
#declare old_wood = texture {
  T_Wood5
  finish { reflection 0.5  ambient 0 }
  normal { dents 0.3 scale <0.005, 0.1, 0.1>}
  rotate x*90
  scale 4 // to compensate for scale up of model and flooring
}

// seeds for floor board texture randomizer
#declare randomizer = seed(0)

// define the board size
#declare board_width = 2
#declare board_length = 8
#declare board_thickness = 0.5
#declare gap_thickness = 0.02

// parameter for random board rotations
#declare perfect = 0
#declare good = 1
#declare fair = 2
#declare rougth = 3
#declare chaotic = 5
#declare smoothness = good // rougth, fair or good

// create the basic boards
#declare vert_board = box
  {
   <-(board_width/2)+(gap_thickness/2), -(board_length/2)+(gap_thickness/2), -(board_thickness)>,
   < (board_width/2)-(gap_thickness/2),  (board_length/2)-(gap_thickness/2), 0 >
  }

#declare hor_board = object
  {
   vert_board
   rotate z*90
  }

// define the variable for the flooring loop
#declare x_current = x_start
#declare y_current = y_start
#declare x_offset = 0
#declare y_offset = 0

#declare flooring = union {
// put the vertical boards
union {
#while (x_current < x_finish)
  #while (y_current < y_finish)
    object { vert_board
      texture { old_wood
        translate <50*rand(randomizer),40*rand(randomizer),20*rand(randomizer)>
        rotate <0,0,5*rand(randomizer)>}
      // testing random rotations
      rotate <smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer))>
      translate < x_current, y_current, 0>
    }
    #declare y_current = y_current + (2*board_length)
  #end
  #declare y_offset = y_offset + (board_length/4)
  #if (y_offset >= 2*board_length)
    #declare y_offset = y_offset - (2*board_length)
  #end
  #declare y_current = y_start + y_offset
  #declare x_current = x_current + board_width
#end
}

// redefine variables for second loops
#declare x_current = x_start
#declare y_current = y_start
#declare x_offset = 0
#declare y_offset = 0

// put the horizontal boards
union {
#while (x_current < x_finish)
  #while (y_current < y_finish)
    object { hor_board
      texture { old_wood
        translate <50*rand(randomizer),40*rand(randomizer),20*rand(randomizer)>
        rotate <0,0,5*rand(randomizer)>
        rotate z*90
      }
      // testing very slight random tilts
      rotate <smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer))>

      translate < x_current, y_current, 0>
    }
    #declare y_current = y_current + (2*board_length)
  #end
  #declare y_offset = y_offset + (board_length/4)
  #if (y_offset >= 2*board_length)
    #declare y_offset = y_offset - (2*board_length)
  #end
  #declare y_current = y_start + y_offset
  #declare x_current = x_current + board_width
#end
translate <(board_length/2)-(board_width/2),-(board_length/2)-(board_width/2),0>
}
}
